$!-----------------------------------------------------------------------------
$! BUILD_QDLOGSTATS.COM
$!
$! P1 == LINK or BUILD or empty (builds)
$!
$! Determines environment by looking for hints in the build procedure device
$! so help things along by setting default to the environment concealed root.
$! Suggested locations:  HT_ROOT:[SRC.MISC]
$!                       WWW_ROOT:[SCRIPT_CODE.WASD]
$!                       APACHE_ROOT:[WASD]
$!
$! 17-MAY-2003  MGD  regular expression support
$! 07-JUL-2001  MGD  (in)directly support multiple environments
$! 23-DEC-2000  MGD  link /NOTRACE so it may be INSTALLed
$! 15-NOV-2000  MGD  initial development
$!-----------------------------------------------------------------------------
$!
$ ON CONTROLY THEN EXIT 44
$!
$ WRITE SYS$OUTPUT ""
$ WRITE SYS$OUTPUT "Building ""QDLOGSTATS""" +-
                   " for ""''F$GETSYI("ARCH_NAME")'"" architecture"
$!
$ ARCH_NAME = F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE")
$ IF ARCH_NAME .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$ PROC_DEV = F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DEVICE")
$ PROC_DIR = F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DIRECTORY")
$ DEV_DIR = PROC_DEV + PROC_DIR
$!
$ IF F$SEARCH("''DEV_DIR'CGILIB.C") .NES. ""
$ THEN
$    CGILIB_INCLUDE = DEV_DIR
$    CGLIB_OLB = DEV_DIR - "]" + ".OBJ_''ARCH_NAME']CGILIB.OLB"
$ ELSE
$    CGILIB_INCLUDE = "HT_ROOT:[SRC.MISC]"
$    CGILIB_OLB = "HT_ROOT:[SRC.MISC.OBJ_''ARCH_NAME']CGILIB.OLB"
$ ENDIF
$ IF F$SEARCH("''DEV_DIR'REGEX.C") .NES. ""
$ THEN
$    REGEX_INCLUDE = DEV_DIR
$    REGEX_OBJ = DEV_DIR - "]" + ".OBJ_''ARCH_NAME']REGEX.OBJ"
$ ELSE
$    REGEX_INCLUDE = "HT_ROOT:[SRC.HTTPD]"
$    REGEX_OBJ = "HT_ROOT:[SRC.HTTPD.OBJ_''ARCH_NAME']REGEX.OBJ"
$ ENDIF
$ DEFINES = " /DEFINE=(_VMS_V6_SOURCE=1,__VMS_VER=60000000," +-
                       "__CRTL_VER=60000000,CGILIB_OBJECT_MODULE)"
$ WARNINGS= " /WARNING=(DISABLE=(PREOPTW))"
$ INCLUDES = " /INCLUDE=(''CGILIB_INCLUDE',''REGEX_INCLUDE')"
$ CC_OPTIONS = "/DECC /OPTIMIZE /STAND=RELAXED_ANSI /PREFIX=ALL" +-
               INCLUDES + DEFINES + WARNINGS
$!
$ IF F$SEARCH("OBJ_''ARCH_NAME'.DIR") .EQS. "" -
     THEN CREATE /DIR [.OBJ_'ARCH_NAME']
$ OBJECT_DIR = "[.OBJ_''ARCH_NAME']"
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$    SET NOON
$    SET VERIFY
$    CC 'CC_OPTIONS' /OBJECT='OBJECT_DIR' QDLOGSTATS
$!   'F$VERIFY(0)
$    SET ON
$ ENDIF
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "LINK"
$ THEN
$    IF PROC_DEV .EQS. "APACHE_ROOT:" THEN EXE_DIR = "CGI-BIN:[000000]"
$    IF PROC_DEV .EQS. "WWW_ROOT:" THEN EXE_DIR = "WWW_ROOT:[BIN]"
$    IF PROC_DEV .EQS. "HT_ROOT:" THEN EXE_DIR = "HT_EXE:"
$    SET NOON
$    SET VERIFY
$    LINK /NOTRACE /EXECUTABLE='EXE_DIR'QDLOGSTATS.EXE -
     'OBJECT_DIR'QDLOGSTATS,'REGEX_OBJ','CGILIB_OLB'/LIBRARY
$!   'F$VERIFY(0)
$    SET ON
$ ENDIF
$ PURGE /NOLOG 'OBJECT_DIR'
$!
$!-----------------------------------------------------------------------------
