$!-----------------------------------------------------------------------------
$! INSTALL.COM
$! 
$! Installs or updates the yahMAIL package.
$! Copies files to the required locations.
$! 
$! 15-OCT-2002  MGD  allow for pre/post WASD 8.1
$! 16-JAN-2001  MGD  APACHE_ROOT becomes APACHE$COMMON (CSWS V1.0-1)
$! 06-APR-2000  MGD  VMS Apache
$! 04-APR-2000  MGD  non-WASD executable now in top-level directory
$! 15-JAN-2000  MGD  make a single package work for all three environments
$!-----------------------------------------------------------------------------
$ procedure = f$environment("procedure")
$ set default 'f$parse(procedure,,,"device")''f$parse(procedure,,,"directory")'
$ say = "write sys$output"
$ if p1 .eqs. "INSTALL" .or. p1 .eqs. "UPDATE"
$ THEN        
$    if p2 .eqs. "WASD" then goto wasd
$    if p2 .eqs. "OSU" then goto osu
$    if p2 .eqs. "APACHE" then goto apache
$    if p2 .eqs. "CGI" then goto cgi
$ endif
$ say "usage: @INSTALL INSTALL|UPDATE WASD|OSU|APACHE|CGI"
$ exit
$!-----------------------------------------------------------------------------
$ wasd:
$ if f$search("ht_root:[000000]cgi-bin.dir") .nes. ""
$ then
$!   (post WASD 8.1, default security will be applied)
$    copy yahmail.com cgi_bin:
$    copy ht_exe:yahmail.exe cgi_exe:
$    copy yahmail_startup.com ht_root:[startup]
$ else
$!   (pre WASD 8.1)
$    copy /prot=w:re yahmail.com ht_root:[script]
$ endif
$ if p1 .eqs. "INSTALL"
$ then
$    copy /prot=w yahmail.conf ht_root:[local]
$    if f$search("ht_root:[000000]startup.dir") .eqs. ""
$    then
$!      (pre WASD 8.1)
$       copy /prot=w yahmail_startup.com ht_root:[local]
$    endif
$ endif
$ if f$search("ht_root:[doc.yahmail]*.*") .nes. ""
$ then
$    delete = "delete"
$    delete ht_root:[doc.yahmail]*.*;*
$    create /prot=w:re ht_root:[doc.yahmail]index.html
<HTML>
<HEAD>
<META HTTP-EQUIV="refresh" CONTENT="2; url=/ht_root/src/yahmail/doc/">
<TITLE>yahMAIL Documentation Relocated</TITLE>
</HEAD>
<BODY>
<FONT SIZE=+1><B>yahMAIL</B></FONT> documentation may now be found at
<A HREF="/ht_root/src/yahmail/doc/">/ht_root/src/yahmail/doc/</A>
<BODY>
</HTML>
$    endif
$ exit
$!-----------------------------------------------------------------------------
$ osu:
$ arch_name = f$edit(f$getsyi("arch_name"),"upcase")
$ if arch_name .eqs. "ALPHA" then arch_name = "AXP"
$ copy /prot=w:re yahmail_'arch_name'.exe www_root:[bin]
$ copy /prot=w:re yahmail.com www_root:[bin]
$ if p1 .eqs. "INSTALL"
$ then
$    copy /prot=w yahmail.conf www_root:[system]
$    copy /prot=w yahmail_startup.com www_root:[system]
$ else
$    say "When updating to v1.3 please check and manually update YAHMAIL.CONF"
$ endif
$ exit
$!-----------------------------------------------------------------------------
$ apache:
$ arch_name = f$edit(f$getsyi("arch_name"),"upcase")
$ if arch_name .eqs. "ALPHA" then arch_name = "AXP"
$ copy /prot=w:re yahmail_'arch_name'.exe apache$common:[cgi-bin]
$ copy /prot=w:re yahmail.com apache$common:[cgi-bin]
$ if p1 .eqs. "INSTALL"
$ then
$    copy /prot=w yahmail.conf apache$common:[conf]
$    copy /prot=w yahmail_startup.com apache$common:[000000]
$ endif
$ exit
$!-----------------------------------------------------------------------------
$ cgi:
$ if p3 .eqs. "" .or. p4 .eqs. "" 
$ then
$    say "usage: @INSTALL INSTALL|UPDATE CGI [cgi-bin-dir] [config-dir]"
$    exit
$ endif
$ arch_name = f$edit(f$getsyi("arch_name"),"upcase")
$ if arch_name .eqs. "ALPHA" then arch_name = "AXP"
$ copy /prot=w:re yahmail_'arch_name'.exe 'p3'
$ if p1 .eqs. "INSTALL"
$ then
$    copy /prot=w yahmail.conf 'p4'
$    copy /prot=w yahmail_startup.com 'p4'
$ else
$    say "When updating to v1.3 please check and manually update YAHMAIL.CONF"
$ endif
$ exit
$!-----------------------------------------------------------------------------
