O /*****************************************************************************/  /*)                                 lang_de.c   K This module provides static strings used by YAHMAIL.C for all text.  LANG.H O provides the external references when compiling YAHMAIL.C so that the LANG_xx.C K modules may be built independently then a desired, language-specific module O linked in to produce the final executable.  These LANG_xx.C are named using the H ISO language abbreviations (e.g. English "en", French "fr", German "de", Russian "ru", etc., etc.)      INSTRUCTIONS ------------O To create a new language-specific module use the LANG_EN.C file as a template.  H Copy it to a new file named LANG_xx.C (where the "xx" represents the ISO language abbreviation).   K Then just go through the new file translating the English into the language ? equivalent.  All, or only selected strings need to be modified.   2 Some general guidelines when making modifications:  I   *  Keep the translated string as close as possible to the length of the N original English string.  Do not embellish messages with more explanation thanH in the original.  Significant differences in length may disrupt the page layout.   J   *  Each of the 'lang_Btn...' strings must be unique, even if in only oneF character.  The script uses these values to determine which button wasO activated.  If two are the same they obviously cannot be differentiated.  It is H quite acceptable to merely add a leading or trailing space to one of two6 buttons where the word used for them must be the same.  M   *  Follow the case and punctuation of the original as closely as possible.  K Strings are used for various purposes and in specific places in the page or N report.  Changing case or punctuation unduly may affect the overall meaning or impression of the text.   K   *  These strings may be used in/as printf() parameters.  Avoid the use of M character sequences that may be interpreted as format control.  Always escape * such sequences (e.g. "%" as "&#37;", etc.)  F   *  The strings will be appearing in HTML marked-up pages.  The usualG considerations involving the use of HTML-sensitive characters should be K followed.  Always escape such characters as "<" ("&lt;"), ">" ("&gt;"), "&" E ("&amp;") and """ ("&quot;").  HTML entities may be used to represent O characters not directly available (e.g. "&#233;").  Additional, string-specific H markup, while not forbidden in many cases, is discouraged.  For messagesL containing HTML markup in the original do not change the markup, only change	 the text.   J   *  Complete the 'lang_LanguageAuthor' string with the appropriate e-mailK contact details so that the just may be punished and the guilty go free :^) N This will immortalize the effort as well as make subsequent contact possible. D In a similar vein please complete the version history details below.     BUILDING THE NEW MODULE  ----------------------- M The new module may be checked for errors, etc., using a command-line compile:      $ CC /NOOBJECT LANG_xx  G When satisfied the module is ready for inclusion in the script edit the L BUILD_YAHMAIL.COM and [.MUNPACK]BUILD_YAHMAIL.COM procedures and add the newO module to the compile and link sections in the same way as the LANG_EN has been H (which may be left in place).  Execute the procedure to build the scriptB specifying the new module as the language component.  For example:      $ @BUILD_YAHMAIL MIME BUILD EN     MULTIPLE CONCURRENT LANGUAGES  ----------------------------- O Multiple-language sites may be relatively easily supported.  In addition to the G primary language accessed via /cgi-bin/yahmail/~ other languages may be O concurrently supported by renaming the executable to reflect the language.  For I example English could be YAHMAIL_EN.EXE, German YAHMAIL_DE.EXE and French N YAHMAIL_FR.EXE.  This would allow those with a preference for German to accessK it via /cgi-bin/yahmail_de/~.  If such an approach is undertaken it is also O necessary to copy (and possibly modify) the wrapper procedure and configuration E files appropriately.  For example YAHMAIL_EN.COM and YAHMAIL_EN.CONF.      SHARING THE HARD WORK  --------------------- F After all that effort there may be others who would profit from such aO language specific module.  ZIP it up (layout may be disrupted by mailing agents N otherwise) and send as an attachment to the author of yahMAIL for inclusion in the next release.   O When changes to yahMAIL require additional or modified messages the author will L attempt to contact the module's translator with the few changes required forM the new release.  Failing this any new message will be included as English in O the language specific module and built that way, waiting for some generous soul $ to make the changes and return them.     VERSION HISTORY  --------------- F 30-JAN-2004  MGD  v1.8.0, add lang_BtnListMailFiles, lang_BtnViewSpam,>                               lang_BtnHideSpam, lang_HideSpam,-                               lang_BtnLogout, C                               lang_BtnNotSpam, lang_BtnUndoNotSpam, 8                               lang_BtnPersonalSetupEdit,8                               lang_BtnPersonalSetupLoad,8                               lang_BtnPersonalSetupSave,C                               lang_BrowseFile, lang_DirectActionUI, 6                               lang_NotSpamListUpdated,5                               lang_PersonalSetupEdit, 5                               lang_PersonalSetupFile, 4                               lang_PersonalSetupSave8                               lang_PersonalSetupUpdated,-                               lang_ProDefault B 08-FEB-2003  MGD  v1.6.4, add lang_BrowseReplyTo, lang_MsgReplyTo 8 15-JUN-2002  MGD  v1.6.3, add lang_NoCc, lang_NoSubject,K                               lang_BrowseEncoding88, lang_BrowseEncoding8Q, J                               lang_BrowseEncodingIQ, lang_BrowseEncodingI8C 25-MAR-2002  MGD  v1.6.0, add lang_Bottom, lang_Top, lang_ListName, ?                               lang_ProDisabled, lang_ProEnabled @ 03-NOV-2000  MGD  v1.4.0, add lang_BtnReload, lang_WrapLongLines2 14-JUN-2000  MGD  v1.3.1, add lang_ErrSendSubjBody8 09-APR-2000  MGD  v1.3.0, add lang_ResponseErrorMessage,:                               lang_ResponseSuccessMessage,>                           remove lang_ResponseReportedByServer4 19-FEB-2000  MGD  v1.3.0B2, add lang_AttachmentsMax,:                                 lang_BrowseCreateTextArea,>                                 lang_BrowseCreateTextAreaRows,7                                 lang_BtnGoBackToFolder, 9                                 lang_ErrPreEditedNotText, 6                                 lang_PreEditedMessage,1                                 lang_SoAndSoWrote + 27-JAN-2000  MGD  v1.2.0, add lang_ChkAllId G 22-DEC-1999  MGD  v1.1.0, add lang_BtnEmptyWasteBasket, lang_BtnToSent, ?                               lang_BtnToMail, lang_BtnToNewMail 4                               lang_BtnToWasteBasket,:                               lang_BrowseCreateSendButton,7                               lang_BrowseFolderButtons, ;                               lang_BrowseMailFolderButtons, 4                               lang_BrowsePickFields,:                               lang_BrowseUserFolderButtons; 26-SEP-1999  MGD  v1.0.B4, add lang_AutoWrap, lang_NewMail, =                            lang_Messages..., lang_Profile..., / 29-AUG-1999  MGD  v1.0.B3, add lang_Response... . 19-AUG-1999  MGD  v1.0.B2, initial development */  O /*****************************************************************************/    char  !    lang_Language [] =       "de", &    lang_LanguageName [] =   "Deutsch",A    lang_LanguageAuthor [] = "Frank.Weichert@Ruwel-Pfullingen.de", )    lang_Charset [] =        "ISO-8859-1",          /***********/    /* message */    /***********/     #    lang_MsgCc [] =      "Kopie an",      lang_MsgDate [] =    "Datum",    lang_MsgFrom [] =    "Von",$    lang_MsgMessage [] = "Nachricht",)    lang_MsgReplyTo [] = "Rckantwort an", !    lang_MsgStatus [] =  "Status", "    lang_MsgSubj [] =    "Betreff",    lang_MsgTo [] =      "An",          /*****************/    /* folder browse */    /*****************/  3    lang_BrowseAllItems [] =           "Alle Mails", O    lang_BrowseCreateSendButton [] =   "Button &quot;Neue Mail erstellen&quot;", 5    lang_BrowseCreateTextArea [] =     "Text-Fenster", /    lang_BrowseCreateTextAreaRows [] = "Zeilen", <    lang_BrowseEncoding [] =           "Kodierung Kopf/Text",2    lang_BrowseEncoding88 [] =         "8bit/8bit",4    lang_BrowseEncoding8Q [] =         "8bit/Quoted",3    lang_BrowseEncodingIQ [] =         "ISO/Quoted", 1    lang_BrowseEncodingI8 [] =         "ISO/8bit", /    lang_BrowseFile [] =               "Archiv", /    lang_BrowseFolder [] =             "Ordner", p    lang_BrowseFolderButtons [] =      "Buttons &quot;ffnen&quot; &quot;Verschieben&quot; &quot;Kopieren&quot;",4    lang_BrowseFolderName [] =         "Ordner Name",-    lang_BrowseItem [] =               "Mail", 6    lang_BrowseNewMailCheck [] =       "Aktualisieren",.    lang_BrowseNewMailDisabled [] =    "(aus)",0    lang_BrowseNewMailMinutes [] =     "Minuten",.    lang_BrowsePick [] =               "Suche",@    lang_BrowsePickFields [] =         "&quot;Such&quot; Felder",0    lang_BrowseRelated [] =            "Related",;    lang_BrowseReplyTo [] =            "Rckantwortadresse", E    lang_BrowseMailFolderButtons [] =  "Standard Mail-Ordner Buttons", C    lang_BrowseUserFolderButtons [] =  "Eigene Mail-Ordner Buttons", @    lang_BrowseWindow [] =             "Anzahl Mails im Fenster",      /***********/    /* buttons */    /***********/     3    lang_BtnAccess [] =            "Ansehen/ndern", *    lang_BtnBinary [] =            "Binr",<    lang_BtnChangeProfile [] =     "Mail-Einstellung ndern",,    lang_BtnClear [] =             "Lschen",.    lang_BtnClose [] =             "Schlieen",-    lang_BtnCopy [] =              "Kopieren", 8    lang_BtnCreateSend [] =        "Neue Mail erstellen",?    lang_BtnCreateUserProfile [] = "Benutzer-Profile erstellen", =    lang_BtnDeleteUserProfile [] = "Benutzer-Profile lschen", .    lang_BtnDelete [] =            "Lschen !",+    lang_BtnEmptyWasteBasket [] =  "Leeren", -    lang_BtnForeign [] =           "/FOREIGN", 1    lang_BtnForward [] =           "Weiterleiten", +    lang_BtnGoBack [] =            "zurck", 6    lang_BtnGoBackToFolder [] =    "zurck zum Ordner",2    lang_BtnAddressLists [] =      "Adress-Listen",+    lang_BtnLogout [] =            "logout", 1    lang_BtnMailFiles [] =         "Mail Archive", 0    lang_BtnMove [] =              "Verschieben",/    lang_BtnToMail [] =            "Alte Mails", /    lang_BtnToNewMail [] =         "Neue Mails", -    lang_BtnToSent [] =            "Absenden", 5    lang_BtnHideSpam [] =          "SPAM-Anzeige aus", .    lang_BtnNotSpam [] =           "kein SPAM",2    lang_BtnUndoNotSpam [] =       "SPAM-Verdacht",4    lang_BtnPersonalSetupEdit [] = "Setup editieren",0    lang_BtnPersonalSetupLoad [] = "Setup laden",4    lang_BtnPersonalSetupSave [] = "Setup speichern",5    lang_BtnViewSpam [] =          "SPAM-Anzeige ein", *    lang_BtnToWasteBasket [] =     "Trash",1    lang_BtnNext [] =              "nchste Mail", 3    lang_BtnPrevious [] =          "vorherige Mail", +    lang_BtnOpen [] =              "ffnen", 2    lang_BtnRefresh [] =           "Aktualisieren",-    lang_BtnReload [] =            "Anzeigen", 0    lang_BtnRemove [] =            "Entfernen !",.    lang_BtnReply [] =             "Antworten",1    lang_BtnReset [] =             "zurcksetzen", .    lang_BtnSend [] =              "Versenden",4    lang_BtnSetupHide [] =         "Setup schlieen",3    lang_BtnSetupShow [] =         "Setup anzeigen", .    lang_BtnSet [] =               "Speichern",)    lang_BtnText [] =              "Text", 2    lang_BtnUpdate [] =            "Aktualisieren",         /*******************/    /* checkbox labels */    /*******************/     '    lang_ChkAllId [] = "Alle markieren", (    lang_ChkInclude [] = "Ursprungstext",#    lang_ChkQuote [] =   "zitieren", 1    lang_ChkSaveAsFile [] = "Als Datei speichern",     lang_ChkMessage [] = "Mail",          /****************/     /* user profile */     /****************/      3    lang_ProUserProfile [] =     "Benutzer Profile", 9    lang_ProUserProfileList [] = "Benutzer Profile Liste", 6    lang_ProAutoPurge [] =       "automatisch Lschen",1    lang_ProCcPrompt [] =        "Kopie an: Feld", 9    lang_ProCopyFwd [] =         "Kopie bei Weiterleiten", 6    lang_ProCopyReply [] =       "Kopie bei Antworten",3    lang_ProCopySend [] =        "Kopie bei Senden", +    lang_ProDefault [] =         "standard", &    lang_ProDisabled [] =        "aus",.    lang_ProEditor [] =          "Text-Editor",&    lang_ProEnabled [] =         "ein",/    lang_ProForwarding [] =      "Weiterleiten", 4    lang_ProPersonalName [] =    "persnlicher Name",0    lang_ProPrintQueue [] =      "Drucker-Queue",3    lang_ProPrintForm [] =       "Drucker-Formular", 1    lang_ProSignatureFile [] =   "Signatur Datei", ,    lang_ProNewMessages [] =     "Neue Mail",9    lang_ProfileUser [] =        "Benutzer-Einstellungen", F    lang_ProfileCreated [] =     "Benutzer-Einstellungen gespeichert.",C    lang_ProfileDeleted [] =     "Benutzer-Einstellungen gelscht.", G    lang_ProfileUpdated [] =     "Benutzer-Einstellungen aktualisiert.", ?    lang_SigFileUpdated [] =     "Signatur-Datei aktualisiert.",       /****************/     /* address list */     /****************/   1    lang_ListAddressPlural [] =   "Adress-Listen", 0    lang_ListAddressSingular [] = "Adress-Liste",9    lang_ListName [] =            "Name der Adress-Liste", :    lang_ListRemoved [] =         "Adress-Liste gelscht.",>    lang_ListUpdated [] =         "Adress-Liste aktualisiert.",      /*********/    /* error */    /*********/     9    lang_ErrBinStdout [] = "binr ffnen &lt;stdout&gt;.",       lang_ErrCgiPlusMunpack [] =5 "MIME-enabled yahMAIL ist nicht CGIplus compatibel!",   7    lang_ErrConfigRestriction [] = "nicht konfiguiert.",   #    lang_ErrCurrentMessageCount [] =  "Anzahl der Mails gendert. \  <P>Bitte Ordner neu ffnen.",   M    lang_ErrFoldersIdentical [] =    "Quell- und Zielordner sind identisch !", F    lang_ErrGenerateFolderList [] =  "Ordner-bersicht wird erstellt.",@    lang_ErrGenerateMessageList [] = "Mail-Liste wird erstellt.",<    lang_ErrGenerateUserList [] =    "generating user list.",E    lang_ErrGetUserInfo [] =         "Benutzer-Infos werden gelesen.", >    lang_ErrInternalLimit [] =       "Internal limit reached!",C    lang_ErrListNotFound [] =        "Adress-Liste nicht gefunden.", D    lang_ErrListNotSpecified [] =    "Adress-Liste nicht angegeben.",B    lang_ErrMailIllegalPersonal [] = "Falscher persnlicher Name.",;    lang_ErrMailMessageNotFound [] = "Mail nicht gefunden.", ?    lang_ErrMailNoSuchUser [] =      "Benutzer nicht vorhanden", =    lang_ErrMailNoSuchFolder [] =    "Ordner nicht vorhanden", 9    lang_ErrMailOpening [] =         "Fehler beim ffnen", 9    lang_ErrMessageDelete [] =       "gelschte Mail(s).", L    lang_ErrMessageForeign [] =      "unbekanntes Attachment wird geffnet.",:    lang_ErrMessageMove [] =         "verschobene Mail(s)",=    lang_ErrMessageNotSelected [] =  "Kein Mail(s) markiert!", 2    lang_ErrMessageRead [] =         "Mail lesen.",       lang_ErrPreEditedNotText [] =I "Problem ... Der Browser hat festgestellt, dass die vorgefertigte Mail\n\ S nicht im &quot;Text&quot;-Format vorliegt.  Diese Mail kann nicht geladen werden.",   @    lang_ErrOpenMail [] =            "MAIL-Datei wird geffnet.",E    lang_ErrSanityCheck [] =         "Internal sanity check failure!", 6    lang_ErrSendInvalidUser [] =     "Falsche Adresse",;    lang_ErrSendMailAddressOvf [] =  "Mailadresse zu lang!", A    lang_ErrSendNetworkLink [] =     "Sendefehler (Netzwerk) fr", :    lang_ErrSendNoSuchUser [] =      "User nicht gefunden",5    lang_ErrSendParsing [] =         "Parsing-Fehler", N    lang_ErrSendRecipient [] =       "Adresse im Feld (An:) ist erforderlich.",    lang_ErrSendSubjBody [] =# "Betreff und/oder Mail-Text fehlt \ ? Falls das nicht OK ist, dann bitte abbrechen und korrigieren.", @    lang_ErrSendTransport [] =       "Fehler beim Speichern von",G    lang_ErrSetUserAutoPurge [] =    "Einstellung automatisch lschen.", C    lang_ErrSetUserCcPrompt [] =     "Einstellung Kopie an Prompt.", J    lang_ErrSetUserCopyForward [] =  "Einstellung Kopie bei Weiterleiten.",G    lang_ErrSetUserCopyReply [] =    "Einstellung Kopie bei Antworten.", D    lang_ErrSetUserCopySend [] =     "Einstellung Kopie bei Senden.",?    lang_ErrSetUserEditor [] =       "Einstellung Text-Editor.", D    lang_ErrSetUserForm [] =         "Einstellung Drucker-Formular.",>    lang_ErrSetUserForwarding [] =   "Einstellung Forwarding.",>    lang_ErrSetUserNewMessages [] =  "Einstellung Neue Mails.",E    lang_ErrSetUserPersonalName [] = "Einstellung persnlicher Name.", A    lang_ErrSetUserQueue [] =        "Einstellung Drucker-Queue.", B    lang_ErrSetUserSigFile [] =      "Einstellung Signatur-Datei.",@    lang_ErrSigFileNoName [] =       "Signatur-Dateiname fehlt.",L    lang_ErrSigFileOpen [] =         "Fehler beim ffnen der Signatur-Datei",H    lang_ErrUserCreate [] =          "Benutzereintrag wird gespeichert.",H    lang_ErrUserCreateForward [] =   "Weiterleiten: Mail-Adresse fehlt!",E    lang_ErrUserDelete [] =          "Benutzereintrag wird gelscht.", 6    lang_ErrUserNoName [] =          "Username fehlt.",      /*********/    /* other */    /*********/  "    lang_AsAtDateTime [] = "Stand",<    lang_AttachmentsMax [] = "Maximale Anzahl Attachment(s)",,    lang_AttachmentPlural [] = "Attachments",-    lang_AttachmentSingular [] = "Attachment", %    lang_AutoWrap [] = "Auto-Umbruch",   (    lang_CcSelf [] =    "Kopie: an mich",    lang_CreateNew [] = "neu", 4    lang_PreEditedMessage [] = "vorgefertigte Mails",  !    lang_CurrentlyUnavailable [] = L "<FONT SIZE=+1><B><U>yahMAIL ist momentan nicht verfgbar!</U></B></FONT>\n\- <P>Bitte versuchen Sie es spter nochmal.\n",   I    lang_DirectActionUI [] = "Aktionen ohne Erfolgsbesttigung ausfhren", $    lang_Entries [] = "Mail-Eintrag",      lang_Header [] = "Kopf",   *    lang_MessageSent [] = "Mail gesendet.",/    lang_MessagesCopied [] = "Mail(s) kopiert.", 1    lang_MessagesDeleted [] = "Mail(s) gelscht.", -    lang_MessagesInNewMailPlural [] = "Mails", .    lang_MessagesInNewMailSingular [] = "Mail",$    lang_MessagesInNewMail [] = "in",1    lang_MessagesMoved [] = "Mail(s) verschoben.",       lang_NewMailBiff [] =: "<FONT SIZE=+2 COLOR=\"#0000cc\">&nbsp;&nbsp;&nbsp;&nbsp;\  <BLINK><B>Neue Mail</B></BLINK>\ &nbsp;&nbsp;</FONT>", 4    lang_NewMailBiffTitle [] = " N e u e   M a i l ",  .    lang_NoCc [] =               "keine Kopie",/    lang_NoSubject [] =          "kein Betreff", -    lang_NoMessages [] =         "keine Mail", ;    lang_NoMessagesSelected [] = "keine Mail(s) selektiert",   ?    lang_HideSpam [] = "SPAM-Filer aktivieren (fr Neue Mails)", >    lang_PersonalSetupFile [] =    "Persnliche Einstellungen",K    lang_PersonalSetupSave [] =    "Persnliche Einstellungen gespeichert.", @    lang_PersonalSetupUpdated [] = "Konfiguration aktualisiert.",C    lang_NotSpamListUpdated [] =   "Nicht SPAM-Liste aktualisiert.",       lang_Bottom [] = "unten",    lang_None [] = "aus",    lang_Top [] = "oben",  %    lang_PostMaster [] = "POSTMASTER",     lang_PostMasterWarning [] =  * "<CENTER><FONT SIZE=+1 COLOR=\"#ff0000\">\( <B>POSTMASTER</B></FONT></CENTER><P>\n",  3    lang_ResetCaution [] = "alle Eingaben lschen.",   8    lang_ResponseErrorMessage [] = "erkannt von yahMAIL",)    lang_ResponseErrorTitle [] = "Fehler", :    lang_ResponseSuccessMessage [] = "erkannt von yahMAIL",0    lang_ResponseSuccessTitle [] = "erfolgreich",      lang_SizeBytes [] = "Bytes", !    lang_SizeRecords [] = "Stze", $    lang_SoAndSoWrote [] = "schrieb",  0    lang_WasteBasketPurged [] = "Trash geleert.",6    lang_WasteBasketEmpty [] = "Keine Mails im Trash!",=    lang_WrapLongLines [] = "Zeilenumbruch bei langen Zeilen",    #ifdef YAHMAIL_MUNPACK  
    /********/ 
    /* MIME */ 
    /********/   1    lang_MimeAlternative [] = "MIME_alternative_", F    lang_MimeAttachmentNotFound [] = "MIME Attachment nicht gefunden!",   #endif /* YAHMAIL_MUNPACK */      lang_TheEnd [] = "";   O /*****************************************************************************/   