/*****************************************************************************/
/*
                                lang_en.c

This module provides static strings used by YAHMAIL.C for all text.  LANG.H
provides the external references when compiling YAHMAIL.C so that the LANG_xx.C
modules may be built independently then a desired, language-specific module
linked in to produce the final executable.  These LANG_xx.C are named using the
ISO language abbreviations (e.g. English "en", French "fr", German "de",
Russian "ru", etc., etc.)


INSTRUCTIONS
------------
To create a new language-specific module use the LANG_EN.C file as a template. 
Copy it to a new file named LANG_xx.C (where the "xx" represents the ISO
language abbreviation).

Then just go through the new file translating the English into the language
equivalent.  All, or only selected strings need to be modified.

Some general guidelines when making modifications:

  *  Keep the translated string as close as possible to the length of the
original English string.  Do not embellish messages with more explanation than
in the original.  Significant differences in length may disrupt the page
layout.

  *  Each of the 'lang_Btn...' strings must be unique, even if in only one
character.  The script uses these values to determine which button was
activated.  If two are the same they obviously cannot be differentiated.  It is
quite acceptable to merely add a leading or trailing space to one of two
buttons where the word used for them must be the same.

  *  Follow the case and punctuation of the original as closely as possible. 
Strings are used for various purposes and in specific places in the page or
report.  Changing case or punctuation unduly may affect the overall meaning or
impression of the text.

  *  These strings may be used in/as printf() parameters.  Avoid the use of
character sequences that may be interpreted as format control.  Always escape
such sequences (e.g. "%" as "&#37;", etc.)

  *  The strings will be appearing in HTML marked-up pages.  The usual
considerations involving the use of HTML-sensitive characters should be
followed.  Always escape such characters as "<" ("&lt;"), ">" ("&gt;"), "&"
("&amp;") and """ ("&quot;").  HTML entities may be used to represent
characters not directly available (e.g. "&#233;").  Additional, string-specific
markup, while not forbidden in many cases, is discouraged.  For messages
containing HTML markup in the original do not change the markup, only change
the text.

  *  Complete the 'lang_LanguageAuthor' string with the appropriate e-mail
contact details so that the just may be punished and the guilty go free :^)
This will immortalize the effort as well as make subsequent contact possible. 
In a similar vein please complete the version history details below.


BUILDING THE NEW MODULE
-----------------------
The new module may be checked for errors, etc., using a command-line compile:

  $ CC /NOOBJECT LANG_xx

When satisfied the module is ready for inclusion in the script edit the
BUILD_YAHMAIL.COM and [.MUNPACK]BUILD_YAHMAIL.COM procedures and add the new
module to the compile and link sections in the same way as the LANG_EN has been
(which may be left in place).  Execute the procedure to build the script
specifying the new module as the language component.  For example:

  $ @BUILD_YAHMAIL MIME BUILD EN


MULTIPLE CONCURRENT LANGUAGES
-----------------------------
Multiple-language sites may be relatively easily supported.  In addition to the
primary language accessed via /cgi-bin/yahmail/~ other languages may be
concurrently supported by renaming the executable to reflect the language.  For
example English could be YAHMAIL_EN.EXE, German YAHMAIL_DE.EXE and French
YAHMAIL_FR.EXE.  This would allow those with a preference for German to access
it via /cgi-bin/yahmail_de/~.  If such an approach is undertaken it is also
necessary to copy (and possibly modify) the wrapper procedure and configuration
files appropriately.  For example YAHMAIL_EN.COM and YAHMAIL_EN.CONF.


SHARING THE HARD WORK
---------------------
After all that effort there may be others who would profit from such a
language specific module.  ZIP it up (layout may be disrupted by mailing agents
otherwise) and send as an attachment to the author of yahMAIL for inclusion in
the next release.

When changes to yahMAIL require additional or modified messages the author will
attempt to contact the module's translator with the few changes required for
the new release.  Failing this any new message will be included as English in
the language specific module and built that way, waiting for some generous soul
to make the changes and return them.


VERSION HISTORY
---------------
30-JAN-2004  MGD  v1.8.0, add lang_BtnListMailFiles, lang_BtnViewSpam,
                              lang_BtnHideSpam, lang_HideSpam,
                              lang_BtnLogout,
                              lang_BtnNotSpam, lang_BtnUndoNotSpam,
                              lang_BtnPersonalSetupEdit,
                              lang_BtnPersonalSetupLoad,
                              lang_BtnPersonalSetupSave,
                              lang_BrowseFile, lang_DirectActionUI,
                              lang_NotSpamListUpdated,
                              lang_PersonalSetupEdit,
                              lang_PersonalSetupFile,
                              lang_PersonalSetupSave
                              lang_PersonalSetupUpdated,
                              lang_ProDefault
08-FEB-2003  MGD  v1.6.4, add lang_BrowseReplyTo, lang_MsgReplyTo 
15-JUN-2002  MGD  v1.6.3, add lang_NoCc, lang_NoSubject,
                              lang_BrowseEncoding,
                              lang_BrowseEncoding88, lang_BrowseEncoding8Q,
                              lang_BrowseEncodingIQ, lang_BrowseEncodingI8
25-MAR-2002  MGD  v1.6.0, add lang_Bottom, lang_Top, lang_ListName,
                              lang_ProDisabled, lang_ProEnabled
03-NOV-2000  MGD  v1.4.0, add lang_BtnReload, lang_WrapLongLines
14-JUN-2000  MGD  v1.3.1, add lang_ErrSendSubjBody
09-APR-2000  MGD  v1.3.0, add lang_ResponseErrorMessage,
                              lang_ResponseSuccessMessage,
                          remove lang_ResponseReportedByServer
19-FEB-2000  MGD  v1.3.0B2, add lang_AttachmentsMax,
                                lang_BrowseCreateTextArea,
                                lang_BrowseCreateTextAreaRows,
                                lang_BtnGoBackToFolder,
                                lang_ErrPreEditedNotText,
                                lang_PreEditedMessage,
                                lang_SoAndSoWrote
27-JAN-2000  MGD  v1.2.0, add lang_ChkAllId
22-DEC-1999  MGD  v1.1.0, add lang_BtnEmptyWasteBasket, lang_BtnToSent,
                              lang_BtnToMail, lang_BtnToNewMail
                              lang_BtnToWasteBasket,
                              lang_BrowseCreateSendButton,
                              lang_BrowseFolderButtons,
                              lang_BrowseMailFolderButtons,
                              lang_BrowsePickFields,
                              lang_BrowseUserFolderButtons
26-SEP-1999  MGD  v1.0.B4, add lang_AutoWrap, lang_NewMail,
                           lang_Messages..., lang_Profile...,
29-AUG-1999  MGD  v1.0.B3, add lang_Response...
19-AUG-1999  MGD  v1.0.B2, initial development
*/

/*****************************************************************************/

char

   lang_Language [] =       "en",
   lang_LanguageName [] =   "English",
   lang_LanguageAuthor [] = "Mark.Daniel@wasd.vsm.com.au",
   lang_Charset [] =        "ISO-8859-1",
   
   /***********/
   /* message */
   /***********/
   
   lang_MsgCc [] =      "Cc",
   lang_MsgDate [] =    "Date",
   lang_MsgFrom [] =    "From",
   lang_MsgMessage [] = "Message",
   lang_MsgReplyTo [] = "Reply-To",
   lang_MsgStatus [] =  "Status",
   lang_MsgSubj [] =    "Subject",
   lang_MsgTo [] =      "To",
   
   /*****************/
   /* folder browse */
   /*****************/

   lang_BrowseAllItems [] =           "all items",
   lang_BrowseCreateSendButton [] =   "CREATE-SEND button",
   lang_BrowseCreateTextArea [] =     "message edit window",
   lang_BrowseCreateTextAreaRows [] = "rows",
   lang_BrowseEncoding [] =           "encoding header/text",
   lang_BrowseEncoding88 [] =         "8bit/8bit",
   lang_BrowseEncoding8Q [] =         "8bit/Quoted",
   lang_BrowseEncodingIQ [] =         "ISO/Quoted",
   lang_BrowseEncodingI8 [] =         "ISO/8bit",
   lang_BrowseFile [] =               "File",
   lang_BrowseFolder [] =             "Folder",
   lang_BrowseFolderButtons [] =      "folder OPEN / MOVE / COPY",
   lang_BrowseFolderName [] =         "folder name",
   lang_BrowseItem [] =               "item",
   lang_BrowseNewMailCheck [] =       "check NEWMAIL",
   lang_BrowseNewMailDisabled [] =    "(disabled)",
   lang_BrowseNewMailMinutes [] =     "minutes",
   lang_BrowsePick [] =               "pick",
   lang_BrowsePickFields [] =         "&quot;pick&quot; fields",
   lang_BrowseRelated [] =            "Related",
   lang_BrowseReplyTo [] =            "reply-to",
   lang_BrowseMailFolderButtons [] =  "&quot;mail&quot; folder buttons",
   lang_BrowseUserFolderButtons [] =  "&quot;user&quot; folder buttons",
   lang_BrowseWindow [] =             "window",

   /***********/
   /* buttons */
   /***********/
   
   lang_BtnAccess [] =            "ACCESS",
   lang_BtnBinary [] =            "BINARY",
   lang_BtnChangeProfile [] =     "CHANGE profile",
   lang_BtnClear [] =             "CLEAR",
   lang_BtnClose [] =             "close",
   lang_BtnCopy [] =              "COPY",
   lang_BtnCreateSend [] =        "CREATE-SEND new",
   lang_BtnCreateUserProfile [] = "CREATE-USER-PROFILE",
   lang_BtnDeleteUserProfile [] = "DELETE-USER-PROFILE",
   lang_BtnDelete [] =            "DELETE !",
   lang_BtnEmptyWasteBasket [] =  "EMPTY",
   lang_BtnForeign [] =           "/FOREIGN",
   lang_BtnForward [] =           "FORWARD",
   lang_BtnGoBack [] =            "go BACK",
   lang_BtnGoBackToFolder [] =    "go BACK to folder",
   lang_BtnAddressLists [] =      "ADDRESS lists",
   lang_BtnLogout [] =            "logout",
   lang_BtnMailFiles [] =         "Mail Files",
   lang_BtnMove [] =              "MOVE",
   lang_BtnToMail [] =            "MAIL",
   lang_BtnToNewMail [] =         "NEWMAIL",
   lang_BtnToSent [] =            "SENT",
   lang_BtnHideSpam [] =          "hide SPAM",
   lang_BtnNotSpam [] =           "not SPAM",
   lang_BtnUndoNotSpam [] =       "is SPAM",
   lang_BtnPersonalSetupEdit [] = "EDIT setup",
   lang_BtnPersonalSetupLoad [] = "LOAD setup",
   lang_BtnPersonalSetupSave [] =  "SAVE setup",
   lang_BtnViewSpam [] =          "view SPAM",
   lang_BtnToWasteBasket [] =     "WASTEBASKET",
   lang_BtnNext [] =              "NEXT",
   lang_BtnPrevious [] =          "PREVIOUS",
   lang_BtnOpen [] =              "OPEN",
   lang_BtnRefresh [] =           "refresh",
   lang_BtnReload [] =            "RELOAD",
   lang_BtnRemove [] =            "REMOVE !",
   lang_BtnReply [] =             "REPLY",
   lang_BtnReset [] =             "reset",
   lang_BtnSend [] =              "SEND",
   lang_BtnSetupHide [] =         "HIDE setup",
   lang_BtnSetupShow [] =         "SHOW setup",
   lang_BtnSet [] =               "SET",
   lang_BtnText [] =              "TEXT",
   lang_BtnUpdate [] =            "UPDATE",
   
   /*******************/
   /* checkbox labels */
   /*******************/
   
   lang_ChkAllId [] = "check all",
   lang_ChkInclude [] = "include",
   lang_ChkQuote [] =   "quote",
   lang_ChkSaveAsFile [] = "save as file",
   lang_ChkMessage [] = "message",
   
   /****************/
   /* user profile */
   /****************/
   
   lang_ProUserProfile [] =     "VMS Mail User Profile",
   lang_ProUserProfileList [] = "User Profile List",
   lang_ProAutoPurge [] =       "Auto Purge",
   lang_ProCcPrompt [] =        "CC Prompt",
   lang_ProCopyFwd [] =         "Copy Fwd",
   lang_ProCopyReply [] =       "Copy Reply",
   lang_ProCopySend [] =        "Copy Send",
   lang_ProDefault [] =         "default",
   lang_ProDisabled [] =        "disabled",
   lang_ProEditor [] =          "Editor",
   lang_ProEnabled [] =         "enabled",
   lang_ProForwarding [] =      "Forwarding",
   lang_ProPersonalName [] =    "Personal Name",
   lang_ProPrintQueue [] =      "Print Queue",
   lang_ProPrintForm [] =       "Print Form",
   lang_ProSignatureFile [] =   "Signature File",
   lang_ProNewMessages [] =     "New Messages",
   lang_ProfileUser [] =        "PROFILE",
   lang_ProfileCreated [] =     "User profile created.",
   lang_ProfileDeleted [] =     "User profile deleted.",
   lang_ProfileUpdated [] =     "User profile updated.",
   lang_SigFileUpdated [] =     "Signature file updated.",

   /****************/
   /* address list */
   /****************/

   lang_ListAddressPlural [] =   "Address Lists",
   lang_ListAddressSingular [] = "Address List",
   lang_ListName [] =            "list name",
   lang_ListRemoved [] =         "Address list removed.",
   lang_ListUpdated [] =         "Address list updated.",

   /*********/
   /* error */
   /*********/
   
   lang_ErrBinStdout [] = "opening binary &lt;stdout&gt;.",

   lang_ErrCgiPlusMunpack [] =
"MIME-enabled yahMAIL is not CGIplus compliant!",

   lang_ErrConfigRestriction [] = "Configuration restriction.",

   lang_ErrCurrentMessageCount [] =
"Folder message count disparity. \
<P>This indicates folder contents have changed and should be reOPENed.",

   lang_ErrFoldersIdentical [] =    "Source and destination folders the same!",
   lang_ErrGenerateFolderList [] =  "generating folder list.",
   lang_ErrGenerateMessageList [] = "generating message list.",
   lang_ErrGenerateUserList [] =    "generating user list.",
   lang_ErrGetUserInfo [] =         "getting user information.",
   lang_ErrInternalLimit [] =       "Internal limit reached!",
   lang_ErrListNotFound [] =        "Address list not found.",
   lang_ErrListNotSpecified [] =    "Address list not specified.",
   lang_ErrMailIllegalPersonal [] = "Illegal personal name.",
   lang_ErrMailMessageNotFound [] = "Message not found.",
   lang_ErrMailNoSuchUser [] =      "No such user",
   lang_ErrMailNoSuchFolder [] =    "No such folder",
   lang_ErrMailOpening [] =         "Error opening",
   lang_ErrMessageDelete [] =       "deleting message(s).",
   lang_ErrMessageForeign [] =      "opening foreign attachment.",
   lang_ErrMessageMove [] =         "moving message(s)",
   lang_ErrMessageNotSelected [] =  "No message(s) selected!",
   lang_ErrMessageRead [] =         "reading message.",

   lang_ErrPreEditedNotText [] =
"PROBLEM ... the browser is not identifying the pre-edited\n\
message content-type as &quot;text&quot;.  It has not been included!",

   lang_ErrOpenMail [] =            "opening mail file.",
   lang_ErrSanityCheck [] =         "Internal sanity check failure!",
   lang_ErrSendInvalidUser [] =     "Invalid user specification",
   lang_ErrSendMailAddressOvf [] =  "Mail address too big!",
   lang_ErrSendNetworkLink [] =     "Error creating network link for",
   lang_ErrSendNoSuchUser [] =      "No such user",
   lang_ErrSendParsing [] =         "Error parsing",
   lang_ErrSendRecipient [] =       "A recipient name (To:) is required.",
   lang_ErrSendSubjBody [] =
"Message has no subject and/or no body! \
If this is not OK then cancel and correct.",
   lang_ErrSendTransport [] =       "Error activating transport for",
   lang_ErrSetUserAutoPurge [] =    "setting auto purge.",
   lang_ErrSetUserCcPrompt [] =     "setting CC prompt.",
   lang_ErrSetUserCopyForward [] =  "setting copy forward.",
   lang_ErrSetUserCopyReply [] =    "setting copy reply.",
   lang_ErrSetUserCopySend [] =     "setting copy send.",
   lang_ErrSetUserEditor [] =       "setting editor.",
   lang_ErrSetUserForm [] =         "setting print queue form.",
   lang_ErrSetUserForwarding [] =   "setting forwarding.",
   lang_ErrSetUserNewMessages [] =  "setting new messages.",
   lang_ErrSetUserPersonalName [] = "setting personal name.",
   lang_ErrSetUserQueue [] =        "setting print queue.",
   lang_ErrSetUserSigFile [] =      "setting signature file.",
   lang_ErrSigFileNoName [] =       "Signature file name not set.",
   lang_ErrSigFileOpen [] =         "Signature file open error",
   lang_ErrUserCreate [] =          "creating user entry.",
   lang_ErrUserCreateForward [] =   "Must supply a forwarding address!",
   lang_ErrUserDelete [] =          "deleting user entry.",
   lang_ErrUserNoName [] =          "User name not supplied.",

   /*********/
   /* other */
   /*********/

   lang_AsAtDateTime [] =       "as at",
   lang_AttachmentsMax [] =     "attachment(s) max.",
   lang_AttachmentPlural [] =   "Attachments",
   lang_AttachmentSingular [] = "Attachment",
   lang_AutoWrap [] =           "auto-wrap",

   lang_CcSelf [] =           "cc: self",
   lang_CreateNew [] =        "new",
   lang_PreEditedMessage [] = "pre-edited message",

   lang_CurrentlyUnavailable [] =
"<FONT SIZE=+1><B><U>yahMAIL is currently unavailable!</U></B></FONT>\n\
<P>Apologies for any inconvenience. Please try again later.\n",

   lang_DirectActionUI [] = "direct action UI",
   lang_Entries [] = "entries",

   lang_Header [] = "header",

   lang_MessageSent [] = "Message sent.",
   lang_MessagesCopied [] = "Message(s) copied.",
   lang_MessagesDeleted [] = "Message(s) deleted.",
   lang_MessagesInNewMailPlural [] = "messages",
   lang_MessagesInNewMailSingular [] = "message",
   lang_MessagesInNewMail [] = "in",
   lang_MessagesMoved [] = "Message(s) moved.",

   lang_NewMailBiff [] =
"<FONT SIZE=+2 COLOR=\"#0000cc\">&nbsp;&nbsp;&nbsp;&nbsp;\
<BLINK><B>NEWMAIL</B></BLINK>\
&nbsp;&nbsp;</FONT>",
   lang_NewMailBiffTitle [] = " N E W M A I L ",

   lang_NoCc [] =               "none",
   lang_NoSubject [] =          "no subject",
   lang_NoMessages [] =         "no messages",
   lang_NoMessagesSelected [] = "no messages selected",

   lang_HideSpam [] =             "hide SPAM (in NEWMAIL)",
   lang_PersonalSetupFile [] =    "Personal Setup",
   lang_PersonalSetupSave [] =     "Personal Setup saved.",
   lang_PersonalSetupUpdated [] = "Config updated.",
   lang_NotSpamListUpdated [] =   "Not SPAM list updated.",

   lang_Bottom [] = "bottom",
   lang_None [] = "none",
   lang_Top [] = "top",

   lang_PostMaster [] = "POSTMASTER",
   lang_PostMasterWarning [] = 
"<CENTER><FONT SIZE=+1 COLOR=\"#ff0000\">\
<B>POSTMASTER</B></FONT></CENTER><P>\n",

   lang_ResetCaution [] = "caution, erases all changes!",

   lang_ResponseErrorMessage [] = "Reported by yahMAIL",
   lang_ResponseErrorTitle [] = "ERROR",
   lang_ResponseSuccessMessage [] = "Reported by yahMAIL",
   lang_ResponseSuccessTitle [] = "SUCCESS",

   lang_SizeBytes [] = "bytes",
   lang_SizeRecords [] = "records",
   lang_SoAndSoWrote [] = "wrote",

   lang_WasteBasketPurged [] = "Wastebasket emptied.",
   lang_WasteBasketEmpty [] = "Wastebasket was empty!",
   lang_WrapLongLines [] = "wrap long lines",

#ifdef YAHMAIL_MUNPACK

   /********/
   /* MIME */
   /********/

   lang_MimeAlternative [] = "MIME_alternative_",
   lang_MimeAttachmentNotFound [] = "MIME attachment not found!",

#endif /* YAHMAIL_MUNPACK */

   lang_TheEnd [] = "";

/*****************************************************************************/

