/*****************************************************************************/
/*
                                lang_es.c

This module provides static strings used by YAHMAIL.C for all text.  LANG.H
provides the external references when compiling YAHMAIL.C so that the LANG_xx.C
modules may be built independently then a desired, language-specific module
linked in to produce the final executable.  These LANG_xx.C are named using the
ISO language abbreviations (e.g. English "en", French "fr", German "de",
Russian "ru", etc., etc.)


INSTRUCTIONS
------------
To create a new language-specific module use the LANG_EN.C file as a template. 
Copy it to a new file named LANG_xx.C (where the "xx" represents the ISO
language abbreviation).

Then just go through the new file translating the English into the language
equivalent.  All, or only selected strings need to be modified.

Some general guidelines when making modifications:

  *  Keep the translated string as close as possible to the length of the
original English string.  Do not embelish messages with more explanation than
in the original.  Significant differences in length may disrupt the page
layout.

  *  Follow the case and punctuation of the original as closely as possible. 
Strings are used for various purposes and in specific places in the page or
report.  Changing case or punctuation unduly may affect the overall meaning or
impression of the text.

  *  These strings may be used in/as printf() parameters.  Avoid the use of
character sequences that may be interpreted as format control.  Always escape
such sequences (e.g. "%" as "\%").

  *  The strings will be appearing in HTML marked-up pages.  The usual
considerations involving the use of HTML-sensitive characters should be
followed.  Always escape such characters as "<" ("&lt;"), ">" ("&gt;"), "&"
("&amp;") and """ ("&quot;").  HTML entities may be used to represent
characters not directly available (e.g. "&#233;").  Additional, string-specific
markup, while not forbidden in many cases, is discouraged.  For messages
containing HTML markup in the original do not change the markup, only change
the text.

  *  Complete the 'lang_LanguageAuthor' string with the appropriate e-mail
contact details so that the just may be punished and the guilty go free :^)
This will immortalize the effort as well as make subsequent contact possible. 
In a similar vein please complete the version history details below.


BUILDING THE NEW MODULE
-----------------------
The new module may be checked for errors, etc., using a command-line compile:

  $ CC /NOOBJECT LANG_xx

When satisfied the module is ready for inclusion in the script edit the
BUILD_YAHMAIL.COM and [.MUNPACK]BUILD_YAHMAIL.COM procedures and add the new
module to the compile and link sections in the same way as the LANG_EN has been
(which may be left in place).  Execute the procedure to build the script
specifying the new module as the language component.  For example:

  $ @BUILD_YAHMAIL MIME BUILD EN


SHARING THE HARD WORK
---------------------
After all that effort there may be others who would profit from such a
language specific module.  ZIP it up (layout may be disrupted by mailing agent
otherwise) and send as an attachment to the author of yahMAIL for inclusion in
the next release.

When changes to yahMAIL require additional or modified messages the author will
attempt to contact the module's translator with the few changes required for
the new release.  Failing this any new message will be included as English in
the language specific module and built that way, waiting for some generous soul
to make the changes and return them.


VERSION HISTORY
---------------
30-JAN-2004  MGD  v1.8.0, add lang_BtnListMailFiles, lang_BtnViewSpam,
                              lang_BtnHideSpam, lang_HideSpam,
                              lang_BtnLogout,
                              lang_BtnNotSpam, lang_BtnUndoNotSpam,
                              lang_BtnPersonalSetupEdit,
                              lang_BtnPersonalSetupLoad,
                              lang_BtnPersonalSetupSave,
                              lang_BrowseFile, lang_DirectActionUI,
                              lang_NotSpamListUpdated,
                              lang_PersonalSetupEdit,
                              lang_PersonalSetupFile,
                              lang_PersonalSetupSave
                              lang_PersonalSetupUpdated,
                              lang_ProDefault
30-MAR-2003  VGG  (Victoriano Giralt) Spanish version made available
08-FEB-2003  MGD  v1.6.4, add lang_BrowseReplyTo, lang_MsgReplyTo 
15-JUN-2002  MGD  v1.6.3, add lang_NoCc, lang_NoSubject,
                              lang_BrowseEncoding,
                              lang_BrowseEncoding88, lang_BrowseEncoding8Q,
                              lang_BrowseEncodingIQ, lang_BrowseEncodingI8
25-MAR-2002  MGD  v1.6.0, add lang_Bottom, lang_Top, lang_ListName,
                              lang_ProDisabled, lang_ProEnabled
03-NOV-2000  MGD  v1.4.0, add lang_BtnReload, lang_WrapLongLines
14-JUN-2000  MGD  v1.3.1, add lang_ErrSendSubjBody
09-APR-2000  MGD  v1.3.0, add lang_ResponseErrorMessage,
                              lang_ResponseSuccessMessage,
                          remove lang_ResponseReportedByServer
19-FEB-2000  MGD  v1.3.0B2, add lang_AttachmentsMax,
                                lang_BrowseCreateTextArea,
                                lang_BrowseCreateTextAreaRows,
                                lang_BtnGoBackToFolder,
                                lang_ErrPreEditedNotText,
                                lang_PreEditedMessage,
                                lang_SoAndSoWrote
27-JAN-2000  MGD  v1.2.0, add lang_ChkAllId
22-DEC-1999  MGD  v1.1.0, add lang_BtnEmptyWasteBasket, lang_BtnToSent,
                              lang_BtnToMail, lang_BtnToNewMail
                              lang_BtnToWasteBasket,
                              lang_BrowseCreateSendButton,
                              lang_BrowseFolderButtons,
                              lang_BrowseMailFolderButtons,
                              lang_BrowsePickFields,
                              lang_BrowseUserFolderButtons
26-SEP-1999  MGD  v1.0.B4, add lang_AutoWrap, lang_NewMail,
                           lang_Messages..., lang_Profile...,
29-AUG-1999  MGD  v1.0.B3, add lang_Response...
19-AUG-1999  MGD  v1.0.0B2, initial development
*/

/*****************************************************************************/

char

   lang_Language [] =       "es",
   lang_LanguageName [] =   "Espaol",
   lang_LanguageAuthor [] = "victoriano@uma.es,acampos@uma.es,danielcr@uma.es",
   lang_Charset [] =        "ISO-8859-1",
   
   /***********/
   /* message */
   /***********/
   
   lang_MsgCc [] =      "Cc",
   lang_MsgDate [] =    "Fecha",
   lang_MsgFrom [] =    "De",
   lang_MsgMessage [] = "Mensaje",
   lang_MsgReplyTo [] = "Responder a",
   lang_MsgStatus [] =  "Estatus",
   lang_MsgSubj [] =    "Tema",
   lang_MsgTo [] =      "Para",
   
   /*****************/
   /* folder browse */
   /*****************/

   lang_BrowseAllItems [] =          "Todos los elementos",
   lang_BrowseCreateSendButton [] =  "bot&oacute;n CREAR-ENVIAR",
   lang_BrowseCreateTextArea [] =     "ventana de edici&oacute;n de mensaje",
   lang_BrowseCreateTextAreaRows [] = "filas",
   lang_BrowseEncoding [] =           "codificaci&oacute;n cabecera/texto",
   lang_BrowseEncoding88 [] =         "8bit/8bit",
   lang_BrowseEncoding8Q [] =         "8bit/Quoted",
   lang_BrowseEncodingIQ [] =         "ISO/Quoted",
   lang_BrowseEncodingI8 [] =         "ISO/8bit",
   lang_BrowseFile [] =               "File",
   lang_BrowseFolder [] =            "Carpeta",
   lang_BrowseFolderButtons [] =     "ABRIR / MOVER / COPIAR carpeta",
   lang_BrowseFolderName [] =        "Nombre carpeta",
   lang_BrowseItem [] =              "art&iacute;culo",
   lang_BrowseNewMailCheck [] =      "comprobar NEWMAIL",
   lang_BrowseNewMailDisabled [] =   "(Desactivado)",
   lang_BrowseNewMailMinutes [] =    "minutos",
   lang_BrowsePick [] =              "escoja",
   lang_BrowsePickFields [] =        "&quot;pick&quot; fields",
   lang_BrowseRelated [] =           "Relacionado",
   lang_BrowseReplyTo [] =           "respuesta a",
   lang_BrowseMailFolderButtons [] = "&quot;mail&quot; folder buttons",
   lang_BrowseUserFolderButtons [] = "&quot;user&quot; folder buttons",
   lang_BrowseWindow [] =            "ventana",

   /***********/
   /* buttons */
   /***********/
   
   lang_BtnAccess [] =            "Aacceso",
   lang_BtnBinary [] =            "Binario",
   lang_BtnChangeProfile [] =     "Cambiar perfil",
   lang_BtnClear [] =             "Limpiar",
   lang_BtnClose [] =             "Cerrar",
   lang_BtnCopy [] =              "Copiar marcados",
   lang_BtnCreateSend [] =        "Crear-enviar nuevo correo",
   lang_BtnCreateUserProfile [] = "Crear prefil de usuario",
   lang_BtnDeleteUserProfile [] = "Borrar perfil de usuario",
   lang_BtnDelete [] =            "Borrar marcados",
   lang_BtnEmptyWasteBasket [] =  "Vaciar papelera",
   lang_BtnForeign [] =           "/FOREIGN",
   lang_BtnForward [] =           "Reenviar",
   lang_BtnGoBack [] =            "Atras",
   lang_BtnGoBackToFolder [] =    "volver a la carpeta",
   lang_BtnAddressLists [] =      "Lista de direcciones",
   lang_BtnLogout [] =            "logout",
   lang_BtnMailFiles [] =         "Mail Files",
   lang_BtnMove [] =              "Mover marcados",
   lang_BtnToMail [] =            "Ver correo viejo",
   lang_BtnToNewMail [] =         "Ver correo nuevo",
   lang_BtnToSent [] =            "Ver correo enviado",
   lang_BtnHideSpam [] =          "hide SPAM",
   lang_BtnNotSpam [] =           "not SPAM",
   lang_BtnUndoNotSpam [] =       "is SPAM",
   lang_BtnPersonalSetupEdit [] = "EDIT setup",
   lang_BtnPersonalSetupLoad [] = "LOAD setup",
   lang_BtnPersonalSetupSave [] =  "SAVE setup",
   lang_BtnViewSpam [] =          "view SPAM",
   lang_BtnToWasteBasket [] =     "Ver papelera",
   lang_BtnNext [] =              "Siguiente",
   lang_BtnPrevious [] =          "Anterior",
   lang_BtnOpen [] =              "Abrir",
   lang_BtnRefresh [] =           "Refrescar",
   lang_BtnReload [] =            "Recargar",
   lang_BtnRemove [] =            "Eliminar",
   lang_BtnReply [] =             "Responder",
   lang_BtnReset [] =             "Reiniciar",
   lang_BtnSend [] =              "Enviar",
   lang_BtnSetupHide [] =         "Esconder configuracion",
   lang_BtnSetupShow [] =         "Mostrar configuracion",
   lang_BtnSet [] =               "Cambiar",
   lang_BtnText [] =              "Texto",
   lang_BtnUpdate [] =            "Actualizar",
   
   /*******************/
   /* checkbox labels */
   /*******************/
   
   lang_ChkAllId [] = "marcar todos",
   lang_ChkInclude [] = "incluir",
   lang_ChkQuote [] =   "marcar",
   lang_ChkSaveAsFile [] = "guardar como fichero",
   lang_ChkMessage [] = "mensaje",
   
   /****************/
   /* user profile */
   /****************/
   
   lang_ProUserProfile [] =     "Perfil de Usuario",
   lang_ProUserProfileList [] = "Listar perfil de usuario",
   lang_ProAutoPurge [] =       "Auto Purge",
   lang_ProCcPrompt [] =        "CC Indicador",
   lang_ProCopyFwd [] =         "Copia Reenvio",
   lang_ProCopyReply [] =       "Copia Respuesta",
   lang_ProCopySend [] =        "Copia Envio",
   lang_ProDefault [] =         "default",
   lang_ProDisabled [] =        "desactivado",
   lang_ProEditor [] =          "Editor",
   lang_ProEnabled [] =         "activo",
   lang_ProForwarding [] =      "Reenviando",
   lang_ProPersonalName [] =    "Nombre Personal",
   lang_ProPrintQueue [] =      "Imprimir Cola",
   lang_ProPrintForm [] =       "Imprimir Form",
   lang_ProSignatureFile [] =   "Fichero de firma",
   lang_ProNewMessages [] =     "Nuevos Mensajes",
   lang_ProfileUser [] =        "Perfil",
   lang_ProfileCreated [] =     "Perfil de usuario creado.",
   lang_ProfileDeleted [] =     "Perfil de usuario borrado.",
   lang_ProfileUpdated [] =     "Perfil de usuario actualizado.",
   lang_SigFileUpdated [] =     "Fichero de firma actualizado.",

   /****************/
   /* address list */
   /****************/

   lang_ListAddressPlural [] =   "Listas de direcciones",
   lang_ListAddressSingular [] = "Lista de direcciones",
   lang_ListName [] =            "nombre de la lista",
   lang_ListRemoved [] =         "Lista de direcciones eliminada.",
   lang_ListUpdated [] =         "Lista de direcciones actualizada.",

   /*********/
   /* error */
   /*********/
   
   lang_ErrBinStdout [] = "abriendo &lt;stdout&gt; en binario.",

   lang_ErrCgiPlusMunpack [] = "MIME-enabled yahMAIL is not CGIplus compliant!",

   lang_ErrConfigRestriction [] = "Configuraci&oacute;n restringida.",

   lang_ErrCurrentMessageCount [] =
"Disparidad en el n&uacute:mero de mensajes de la carpeta. \
<P>Indica que el contenido de la carpeta ha cambiado y deber&iacute;a ser recargada.",

   lang_ErrFoldersIdentical [] =    "Carpetas fuente y destino iguales!",
   lang_ErrGenerateFolderList [] =  "generando lista carpetas.",
   lang_ErrGenerateMessageList [] = "generating lista mensaje.",
   lang_ErrGenerateUserList [] =    "generating lista usuario.",
   lang_ErrGetUserInfo [] =         "obteniendo informaci&oacute;n de usuario.",
   lang_ErrInternalLimit [] =       "L&iacute;mite interno alcanzado!",
   lang_ErrListNotFound [] =        "Lista direcciones no encontrada.",
   lang_ErrListNotSpecified [] =    "Lista direcciones no especificada.",
   lang_ErrMailIllegalPersonal [] = "Nombre personal ilegal.",
   lang_ErrMailMessageNotFound [] = "Mensaje no encontrado.",
   lang_ErrMailNoSuchUser [] =      "No existe ese usuario",
   lang_ErrMailNoSuchFolder [] =    "No existe esa carpeta",
   lang_ErrMailOpening [] =         "Error abriendo",
   lang_ErrMessageDelete [] =       "borrando mensaje(s).",
   lang_ErrMessageForeign [] =      "abriendo anejo.",
   lang_ErrMessageMove [] =         "moviendo mesnaje(s)",
   lang_ErrMessageNotSelected [] =  "No hay mesaje(s) seleccionado(s)!",
   lang_ErrMessageRead [] =         "leyendo mensaje.",

   lang_ErrPreEditedNotText [] =
"PROBLEMA ... el navegador no est&aacute; identificando el content-type\n\
del mensaje preeditado como &quot;texto&quot;. &iexcl;No se ha incluido!",

   lang_ErrOpenMail [] =            "abriendo fichero de correo.",
   lang_ErrSanityCheck [] =         "Fallo en el control de coherencia interno!",
   lang_ErrSendInvalidUser [] =     "Especificaci&oacute;n de usuario inv&aacute;lida",
   lang_ErrSendMailAddressOvf [] =  "Direcci&oacuten de correo demasiado grande!",
   lang_ErrSendNetworkLink [] =     "Error creando una conexi&oacute;n de red para",
   lang_ErrSendNoSuchUser [] =      "Usuario inexistente",
   lang_ErrSendParsing [] =         "Error interpreteando",
   lang_ErrSendRecipient [] =       "Hace falta un destinatario (To:).",
   lang_ErrSendSubjBody [] =
"&iexcl;El mensaje no tiene asunto ni/o contenido! \
Si esto no es correcto, cancele y corrija.",
   lang_ErrSendTransport [] =       "Error activando un transporte para",
   lang_ErrSetUserAutoPurge [] =    "cambiando auto purge.",
   lang_ErrSetUserCcPrompt [] =     "cambiando indicador CC.",
   lang_ErrSetUserCopyForward [] =  "cambiando copia reenv&iacute;o.",
   lang_ErrSetUserCopyReply [] =    "cambiando copia respuesta.",
   lang_ErrSetUserCopySend [] =     "cambiando copia env&iacute;o.",
   lang_ErrSetUserEditor [] =       "cambiando editor.",
   lang_ErrSetUserForm [] =         "cambiando imprimir lista form.",
   lang_ErrSetUserForwarding [] =   "cambiando reenvio.",
   lang_ErrSetUserNewMessages [] =  "cambiando nuevos mensajes.",
   lang_ErrSetUserPersonalName [] = "cambiando nombre personal.",
   lang_ErrSetUserQueue [] =        "cambiando imprimir cola.",
   lang_ErrSetUserSigFile [] =      "cambiando fichero de firma.",
   lang_ErrSigFileNoName [] =       "El fichero de firma no est configurado.",
   lang_ErrSigFileOpen [] =         "Error abriendo fichero firma",
   lang_ErrUserCreate [] =          "creando entrada de usuario.",
   lang_ErrUserCreateForward [] =   "Debe dar direcci&oacute; de reenv&iacute;io!",
   lang_ErrUserDelete [] =          "borando entrada usuario.",
   lang_ErrUserNoName [] =          "Nombre usuario no suministrado.",

   /*********/
   /* other */
   /*********/

   lang_AsAtDateTime [] =       "as at",
   lang_AttachmentsMax [] =     "anejo(s) como m&aacute;ximo.",
   lang_AttachmentPlural [] =   "Anejos",
   lang_AttachmentSingular [] = "Anejo",
   lang_AutoWrap [] =           "m&aacute;rgenes autom&aacute;ticos",

   lang_CcSelf [] =    "cc: a mi",
   lang_CreateNew [] = "nuevo",
   lang_PreEditedMessage [] = "mensaje pre-editado",

   lang_CurrentlyUnavailable [] =
"<FONT SIZE=+1><B><U>yahMAIL no est&aacute; disponible en este momento!</U></B></FONT>\n\
<P>Disculpe las molestias. Por favor int%eacute;ntelo de nuevo m&aacute;s tarde\n",

   lang_DirectActionUI [] = "direct action UI",
   lang_Entries [] = "entradas",

   lang_Header [] = "cabecera",

   lang_MessageSent [] = "Mensaje enviado.",
   lang_MessagesCopied [] = "Mensaje(s) copiado(s).",
   lang_MessagesDeleted [] = "Mensaje(s) borrado(s).",
   lang_MessagesInNewMailPlural [] = "mensajes",
   lang_MessagesInNewMailSingular [] = "mensaje",
   lang_MessagesInNewMail [] = "en",
   lang_MessagesMoved [] = "Mensaje(s) movido(s).",

   lang_NewMailBiff [] =
"<FONT SIZE=+2 COLOR=\"#0000cc\">&nbsp;&nbsp;&nbsp;&nbsp;\
<BLINK><B>NEWMAIL</B></BLINK>\
&nbsp;&nbsp;</FONT>",
   lang_NewMailBiffTitle [] = " N E W M A I L ",

   lang_NoCc [] =               "ninguno",
   lang_NoSubject [] =          "sin asunto",
   lang_NoMessages [] =         "no hay mensajes",
   lang_NoMessagesSelected [] = "no hay un mensaje seleccionado",

   lang_HideSpam [] = "hide SPAM (in NEWMAIL)",
   lang_PersonalSetupFile [] =    "Personal Setup",
   lang_PersonalSetupSave [] =     "Personal Setup saved.",
   lang_PersonalSetupUpdated [] = "Config updated.",
   lang_NotSpamListUpdated [] =   "Not SPAM list updated.",

   lang_Bottom [] = "final",
   lang_None [] = "ninguno",
   lang_Top [] = "principio",

   lang_PostMaster [] = "POSTMASTER",
   lang_PostMasterWarning [] = 
"<CENTER><FONT SIZE=+1 COLOR=\"#ff0000\">\
<B>POSTMASTER</B></FONT></CENTER><P>\n",

   lang_ResetCaution [] = "atenci&oacute;n, elimina los cambios!",

   lang_ResponseErrorMessage [] = "Respuesta del servidor.",
   lang_ResponseErrorTitle [] = "ERROR",
   lang_ResponseSuccessMessage [] = "Respuesta del servidor.",
   lang_ResponseSuccessTitle [] = "&Eacute;XITO",

   lang_SizeBytes [] = "bytes",
   lang_SizeRecords [] = "registros",
   lang_SoAndSoWrote [] = "escribi",

   lang_WasteBasketPurged [] = "Papelera (wastebasket) vac&iacute;a.",
   lang_WasteBasketEmpty [] = "La papelera (wastebasket) estaba vac&iacute;a!",
   lang_WrapLongLines [] = "partir l&iacute;neas largas",

#ifdef YAHMAIL_MUNPACK

   /********/
   /* MIME */
   /********/

   lang_MimeAttachmentNotFound [] = "&iexcl;No se ha encontrado el anejo MIME!",
   lang_MimeAlternative [] = "MIME_alternative_",

#endif /* YAHMAIL_MUNPACK */

   lang_TheEnd [] = "";

/*****************************************************************************/

