/*****************************************************************************/
/*
                                lang_ru.c

This module provides static strings used by YAHMAIL.C for all text.  LANG.H
provides the external references when compiling YAHMAIL.C so that the LANG_xx.C
modules may be built independently then a desired, language-specific module
linked in to produce the final executable.  These LANG_xx.C are named using the
ISO language abbreviations (e.g. English "en", French "fr", German "de",
Russian "ru", etc., etc.)


INSTRUCTIONS
------------
To create a new language-specific module use the LANG_EN.C file as a template. 
Copy it to a new file named LANG_xx.C (where the "xx" represents the ISO
language abbreviation).

Then just go through the new file translating the English into the language
equivalent.  All, or only selected strings need to be modified.

Some general guidelines when making modifications:

  *  Keep the translated string as close as possible to the length of the
original English string.  Do not embellish messages with more explanation than
in the original.  Significant differences in length may disrupt the page
layout.

  *  Each of the 'lang_Btn...' strings must be unique, even if in only one
character.  The script uses these values to determine which button was
activated.  If two are the same they obviously cannot be differentiated.  It is
quite acceptable to merely add a leading or trailing space to one of two
buttons where the word used for them must be the same.

  *  Follow the case and punctuation of the original as closely as possible. 
Strings are used for various purposes and in specific places in the page or
report.  Changing case or punctuation unduly may affect the overall meaning or
impression of the text.

  *  These strings may be used in/as printf() parameters.  Avoid the use of
character sequences that may be interpreted as format control.  Always escape
such sequences (e.g. "%" as "&#37;", etc.)

  *  The strings will be appearing in HTML marked-up pages.  The usual
considerations involving the use of HTML-sensitive characters should be
followed.  Always escape such characters as "<" ("&lt;"), ">" ("&gt;"), "&"
("&amp;") and """ ("&quot;").  HTML entities may be used to represent
characters not directly available (e.g. "&#233;").  Additional, string-specific
markup, while not forbidden in many cases, is discouraged.  For messages
containing HTML markup in the original do not change the markup, only change
the text.

  *  Complete the 'lang_LanguageAuthor' string with the appropriate e-mail
contact details so that the just may be punished and the guilty go free :^)
This will immortalize the effort as well as make subsequent contact possible. 
In a similar vein please complete the version history details below.


BUILDING THE NEW MODULE
-----------------------
The new module may be checked for errors, etc., using a command-line compile:

  $ CC /NOOBJECT LANG_xx

When satisfied the module is ready for inclusion in the script edit the
BUILD_YAHMAIL.COM and [.MUNPACK]BUILD_YAHMAIL.COM procedures and add the new
module to the compile and link sections in the same way as the LANG_EN has been
(which may be left in place).  Execute the procedure to build the script
specifying the new module as the language component.  For example:

  $ @BUILD_YAHMAIL MIME BUILD EN


MULTIPLE CONCURRENT LANGUAGES
-----------------------------
Multiple-language sites may be relatively easily supported.  In addition to the
primary language accessed via /cgi-bin/yahmail/~ other languages may be
concurrently supported by renaming the executable to reflect the language.  For
example English could be YAHMAIL_EN.EXE, German YAHMAIL_DE.EXE and French
YAHMAIL_FR.EXE.  This would allow those with a preference for German to access
it via /cgi-bin/yahmail_de/~.  If such an approach is undertaken it is also
necessary to copy (and possibly modify) the wrapper procedure and configuration
files appropriately.  For example YAHMAIL_EN.COM and YAHMAIL_EN.CONF.


SHARING THE HARD WORK
---------------------
After all that effort there may be others who would profit from such a
language specific module.  ZIP it up (layout may be disrupted by mailing agents
otherwise) and send as an attachment to the author of yahMAIL for inclusion in
the next release.

When changes to yahMAIL require additional or modified messages the author will
attempt to contact the module's translator with the few changes required for
the new release.  Failing this any new message will be included as English in
the language specific module and built that way, waiting for some generous soul
to make the changes and return them.


VERSION HISTORY
---------------
30-JAN-2004  MGD  v1.8.0, add lang_BtnListMailFiles, lang_BtnViewSpam,
                              lang_BtnHideSpam, lang_HideSpam,
                              lang_BtnLogout,
                              lang_BtnNotSpam, lang_BtnUndoNotSpam,
                              lang_BtnPersonalSetupEdit,
                              lang_BtnPersonalSetupLoad,
                              lang_BtnPersonalSetupSave,
                              lang_BrowseFile, lang_DirectActionUI,
                              lang_NotSpamListUpdated,
                              lang_PersonalSetupEdit,
                              lang_PersonalSetupFile,
                              lang_PersonalSetupSave
                              lang_PersonalSetupUpdated,
                              lang_ProDefault
08-FEB-2003  MGD  v1.6.4, add lang_BrowseReplyTo, lang_MsgReplyTo 
08-AUG-2002  RRL	  Russian, ISO8859-5 module
15-JUN-2002  MGD  v1.6.3, add lang_NoCc, lang_NoSubject,
                              lang_BrowseEncoding,
                              lang_BrowseEncoding88, lang_BrowseEncoding8Q,
                              lang_BrowseEncodingIQ, lang_BrowseEncodingI8
25-MAR-2002  MGD  v1.6.0, add lang_Bottom, lang_Top, lang_ListName,
                              lang_ProDisabled, lang_ProEnabled
03-NOV-2000  MGD  v1.4.0, add lang_BtnReload, lang_WrapLongLines
14-JUN-2000  MGD  v1.3.1, add lang_ErrSendSubjBody
09-APR-2000  MGD  v1.3.0, add lang_ResponseErrorMessage,
                              lang_ResponseSuccessMessage,
                          remove lang_ResponseReportedByServer
19-FEB-2000  MGD  v1.3.0B2, add lang_AttachmentsMax,
                                lang_BrowseCreateTextArea,
                                lang_BrowseCreateTextAreaRows,
                                lang_BtnGoBackToFolder,
                                lang_ErrPreEditedNotText,
                                lang_PreEditedMessage,
                                lang_SoAndSoWrote
27-JAN-2000  MGD  v1.2.0, add lang_ChkAllId
22-DEC-1999  MGD  v1.1.0, add lang_BtnEmptyWasteBasket, lang_BtnToSent,
                              lang_BtnToMail, lang_BtnToNewMail
                              lang_BtnToWasteBasket,
                              lang_BrowseCreateSendButton,
                              lang_BrowseFolderButtons,
                              lang_BrowseMailFolderButtons,
                              lang_BrowsePickFields,
                              lang_BrowseUserFolderButtons
26-SEP-1999  MGD  v1.0.B4, add lang_AutoWrap, lang_NewMail,
                           lang_Messages..., lang_Profile...,
29-AUG-1999  MGD  v1.0.B3, add lang_Response...
19-AUG-1999  MGD  v1.0.B2, initial development
*/

/*****************************************************************************/

char

   lang_Language [] =       "ru",
   lang_LanguageName [] =   "Russian",
   lang_LanguageAuthor [] = "laishev@smtp.deltatel.ru",
   lang_Charset [] =        "ISO-8859-5",
   
   /***********/
   /* message */
   /***********/
   
   lang_MsgCc [] =      "",
   lang_MsgDate [] =    "",
   lang_MsgFrom [] =    "",
   lang_MsgMessage [] = "",
   lang_MsgReplyTo [] = "",
   lang_MsgStatus [] =  "",
   lang_MsgSubj [] =    "",
   lang_MsgTo [] =      "",
   
   /*****************/
   /* folder browse */
   /*****************/

   lang_BrowseAllItems [] =           " ",
   lang_BrowseCreateSendButton [] =   " ",
   lang_BrowseCreateTextArea [] =     "  ",
   lang_BrowseCreateTextAreaRows [] = "",
   lang_BrowseEncoding [] =           " /",
   lang_BrowseEncoding88 [] =         "8bit/8bit",
   lang_BrowseEncoding8Q [] =         "8bit/Quoted",
   lang_BrowseEncodingIQ [] =         "ISO/Quoted",
   lang_BrowseEncodingI8 [] =         "ISO/8bit",
   lang_BrowseFile [] =               "File",
   lang_BrowseFolder [] =             "",
   lang_BrowseFolderButtons [] =      " º / ¸ / ",
   lang_BrowseFolderName [] =         " ",
   lang_BrowseItem [] =               "",
   lang_BrowseNewMailCheck [] =       " NEWMAIL",
   lang_BrowseNewMailDisabled [] =    "()",
   lang_BrowseNewMailMinutes [] =     "",
   lang_BrowsePick [] =               "pick",
   lang_BrowsePickFields [] =         "&quot;pick&quot; fields",
   lang_BrowseRelated [] =            "Related",
   lang_BrowseReplyTo [] =            "",
   lang_BrowseMailFolderButtons [] =  "&quot;mail&quot; folder buttons",
   lang_BrowseUserFolderButtons [] =  "&quot;user&quot; folder buttons",
   lang_BrowseWindow [] =             "",

   /***********/
   /* buttons */
   /***********/
   
   lang_BtnAccess [] =            "º",
   lang_BtnBinary [] =            "ǽ˹",
   lang_BtnChangeProfile [] =     " ",
   lang_BtnClear [] =             "Ǹ¸",
   lang_BtnClose [] =             "",
   lang_BtnCopy [] =              "",
   lang_BtnCreateSend [] =        " ",
   lang_BtnCreateUserProfile [] = "    ",
   lang_BtnDeleteUserProfile [] = "  ",
   lang_BtnDelete [] =            "ô !",
   lang_BtnEmptyWasteBasket [] =  "Ǹ¸",
   lang_BtnForeign [] =           "/FOREIGN",
   lang_BtnForward [] =           "",
   lang_BtnGoBack [] =            "",
   lang_BtnGoBackToFolder [] =    "  ",
   lang_BtnAddressLists [] =      "",
   lang_BtnLogout [] =            "logout",
   lang_BtnMailFiles [] =         " ",
   lang_BtnMove [] =              "¸",
   lang_BtnToMail [] =            "°",
   lang_BtnToNewMail [] =         " °",
   lang_BtnToSent [] =            "¿˵",
   lang_BtnHideSpam [] =          "  SPAM",
   lang_BtnNotSpam [] =           "not SPAM",
   lang_BtnUndoNotSpam [] =       "is SPAM",
   lang_BtnPersonalSetupEdit [] = "EDIT setup",
   lang_BtnPersonalSetupLoad [] = "LOAD setup",
   lang_BtnPersonalSetupSave [] =  "SAVE setup",
   lang_BtnViewSpam [] =          " SPAM",
   lang_BtnToWasteBasket [] =     "ô˵",
   lang_BtnNext [] =              "ɸ",
   lang_BtnPrevious [] =          "˴ɸ",
   lang_BtnOpen [] =              "º",
   lang_BtnRefresh [] =           "",
   lang_BtnReload [] =            "",
   lang_BtnRemove [] =            "ô !",
   lang_BtnReply [] =             "²¸",
   lang_BtnReset [] =             "",
   lang_BtnSend [] =              "¿",
   lang_BtnSetupHide [] =         " ",
   lang_BtnSetupShow [] =         "¾ ",
   lang_BtnSet [] =               "°",
   lang_BtnText [] =              "µ¾˹",
   lang_BtnUpdate [] =            "",
   
   /*******************/
   /* checkbox labels */
   /*******************/
   
   lang_ChkAllId [] = " ",
   lang_ChkInclude [] = "",
   lang_ChkQuote [] =   "",
   lang_ChkSaveAsFile [] = "  ",
   lang_ChkMessage [] = "",
   
   /****************/
   /* user profile */
   /****************/
   
   lang_ProUserProfile [] =     " ",
   lang_ProUserProfileList [] = "  ",
   lang_ProAutoPurge [] =       " ",
   lang_ProCcPrompt [] =        " ",
   lang_ProCopyFwd [] =         " ",
   lang_ProCopyReply [] =       "¿  ",
   lang_ProCopySend [] =        "¿ ",
   lang_ProDefault [] =         "default",
   lang_ProDisabled [] =        "",
   lang_ProEditor [] =          "",
   lang_ProEnabled [] =         "",
   lang_ProForwarding [] =      "",
   lang_ProPersonalName [] =    "ĸ",
   lang_ProPrintQueue [] =      " ",
   lang_ProPrintForm [] =       " ",
   lang_ProSignatureFile [] =   "",
   lang_ProNewMessages [] =     " ",
   lang_ProfileUser [] =        "°",
   lang_ProfileCreated [] =     "  .",
   lang_ProfileDeleted [] =     "  .",
   lang_ProfileUpdated [] =     "  .",
   lang_SigFileUpdated [] =     " .",

   /****************/
   /* address list */
   /****************/

   lang_ListAddressPlural [] =   " ",
   lang_ListAddressSingular [] = " ",
   lang_ListName [] =            " ",
   lang_ListRemoved [] =         "  .",
   lang_ListUpdated [] =         "  .",

   /*********/
   /* error */
   /*********/
   
   lang_ErrBinStdout [] = "  &lt;stdout&gt;.",

   lang_ErrCgiPlusMunpack [] =
"MIME-enabled yahMAIL is not CGIplus compliant!",

   lang_ErrConfigRestriction [] = " .",

   lang_ErrCurrentMessageCount [] =
"      - . \
<P>  ,     .",

   lang_ErrFoldersIdentical [] =    "    !",
   lang_ErrGenerateFolderList [] =  "  .",
   lang_ErrGenerateMessageList [] = "  .",
   lang_ErrGenerateUserList [] =    "  .",
   lang_ErrGetUserInfo [] =         "  .",
   lang_ErrInternalLimit [] =       " !",
   lang_ErrListNotFound [] =        "   .",
   lang_ErrListNotSpecified [] =    "   .",
   lang_ErrMailIllegalPersonal [] = " ĸ.",
   lang_ErrMailMessageNotFound [] = "  .",
   lang_ErrMailNoSuchUser [] =      "  ",
   lang_ErrMailNoSuchFolder [] =    "  ",
   lang_ErrMailOpening [] =         " ",
   lang_ErrMessageDelete [] =       "() .",
   lang_ErrMessageForeign [] =      "  .",
   lang_ErrMessageMove [] =         " ()",
   lang_ErrMessageNotSelected [] =  "()  !",
   lang_ErrMessageRead [] =         " .",

   lang_ErrPreEditedNotText [] =
"ȸ ...       \n\
  &quot;text&quot;.    !",

   lang_ErrOpenMail [] =            "  .",
   lang_ErrSanityCheck [] =         "  !",
   lang_ErrSendInvalidUser [] =     "   ",
   lang_ErrSendMailAddressOvf [] =  "  !",
   lang_ErrSendNetworkLink [] =     "    ",
   lang_ErrSendNoSuchUser [] =      "  ",
   lang_ErrSendParsing [] =         " ",
   lang_ErrSendRecipient [] =       " ()   .",
   lang_ErrSendSubjBody [] =
"    /  ! \
    .",
   lang_ErrSendTransport [] =       "   ",
   lang_ErrSetUserAutoPurge [] =    "  .",
   lang_ErrSetUserCcPrompt [] =     "   .",
   lang_ErrSetUserCopyForward [] =  " .",
   lang_ErrSetUserCopyReply [] =    "  .",
   lang_ErrSetUserCopySend [] =     "   .",
   lang_ErrSetUserEditor [] =       " .",
   lang_ErrSetUserForm [] =         "  .",
   lang_ErrSetUserForwarding [] =   " .",
   lang_ErrSetUserNewMessages [] =  "  .",
   lang_ErrSetUserPersonalName [] = " ĸ.",
   lang_ErrSetUserQueue [] =        "  .",
   lang_ErrSetUserSigFile [] =      " .",
   lang_ErrSigFileNoName [] =       "    .",
   lang_ErrSigFileOpen [] =         "      ",
   lang_ErrUserCreate [] =          "  .",
   lang_ErrUserCreateForward [] =   "     !",
   lang_ErrUserDelete [] =          "  .",
   lang_ErrUserNoName [] =          "   .",

   /*********/
   /* other */
   /*********/

   lang_AsAtDateTime [] =       "",
   lang_AttachmentsMax [] =     " -() .",
   lang_AttachmentPlural [] =   "-() -()",
   lang_AttachmentSingular [] = " ",
   lang_AutoWrap [] =           " ",

   lang_CcSelf [] =           ": ",
   lang_CreateNew [] =        "",
   lang_PreEditedMessage [] = " ",

   lang_CurrentlyUnavailable [] =
"<FONT SIZE=+1><B><U>yahMAIL is currently unavailable!</U></B></FONT>\n\
<P>Apologies for any inconvenience. Please try again later.\n",

   lang_DirectActionUI [] = "direct action UI",
   lang_Entries [] = " ",

   lang_Header [] = "",

   lang_MessageSent [] = " .",
   lang_MessagesCopied [] = "-() .",
   lang_MessagesDeleted [] = "-() .",
   lang_MessagesInNewMailPlural [] = "",
   lang_MessagesInNewMailSingular [] = "",
   lang_MessagesInNewMail [] = "",
   lang_MessagesMoved [] = "-() .",

   lang_NewMailBiff [] =
"<FONT SIZE=+2 COLOR=\"#0000cc\">&nbsp;&nbsp;&nbsp;&nbsp;\
<BLINK><B>NEWMAIL</B></BLINK>\
&nbsp;&nbsp;</FONT>",
   lang_NewMailBiffTitle [] = "             ",

   lang_NoCc [] =               "",
   lang_NoSubject [] =          " ",
   lang_NoMessages [] =         " ",
   lang_NoMessagesSelected [] = "  ",

   lang_HideSpam [] = " SPAM (  µ)",
   lang_PersonalSetupFile [] =    "Personal Setup",
   lang_PersonalSetupSave [] =     "Personal Setup saved.",
   lang_PersonalSetupUpdated [] = "Config updated.",
   lang_NotSpamListUpdated [] =   "Not SPAM list updated.",

   lang_Bottom [] = "",
   lang_None [] = "",
   lang_Top [] = "",

   lang_PostMaster [] = "POSTMASTER",
   lang_PostMasterWarning [] = 
"<CENTER><FONT SIZE=+1 COLOR=\"#ff0000\">\
<B>POSTMASTER</B></FONT></CENTER><P>\n",

   lang_ResetCaution [] = ",   !",

   lang_ResponseErrorMessage [] = "Reported by yahMAIL",
   lang_ResponseErrorTitle [] = "ERROR",
   lang_ResponseSuccessMessage [] = "Reported by yahMAIL",
   lang_ResponseSuccessTitle [] = "SUCCESS",

   lang_SizeBytes [] = "",
   lang_SizeRecords [] = "",
   lang_SoAndSoWrote [] = "",

   lang_WasteBasketPurged [] = "  .",
   lang_WasteBasketEmpty [] = "   !",
   lang_WrapLongLines [] = "  ",

#ifdef YAHMAIL_MUNPACK

   /********/
   /* MIME */
   /********/

   lang_MimeAlternative [] = "MIME_alternative_",
   lang_MimeAttachmentNotFound [] = "MIME attachment not found!",

#endif /* YAHMAIL_MUNPACK */

   lang_TheEnd [] = "";

/*****************************************************************************/

