/* (C) Copyright 1993,1994 by Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of Carnegie
 * Mellon University not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  Carnegie Mellon University makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#include <stdio.h>
#include "version.h"
#include "part.h"

extern int optind;
extern char *optarg;

extern int overwrite_files;
extern int didchat;
int quiet;

#ifdef YAHMAIL_MUNPACK

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#define MGD_MODS 1

#define PUTC_CHUNK 2048
#define VSPRINTF_MAX 512
#define VSPRINTF_CHUNK PUTC_CHUNK

int  MunpackAttachmentCount,
     MunpackDescTextLength,
     MunpackDescTextSize,
     MunpackDoProcess,
     MunpackDoQuoteDesc,
     MunpackPartsTextLength,
     MunpackPartsTextSize;

char  *MunpackDescTextPtr,
      *MunpackMimeContentTypePtr,
      *MunpackNamePtr,
      *MunpackPartsTextPtr,
      *MunpackTextPtr;

char  MunpackCharset [256];
int  MunpackSizeofCharset = sizeof(MunpackCharset);

extern int  Debug;
extern int  VmsMailHeaderLength;
extern char  lang_ChkSaveAsFile [];
extern char  *VmsMailTextPtr;

int Munpack_sprintf (char*, char*, ...);

/*
Make one pass though the message body getting message (descriptive) text into a
buffer (note any associated 'charset'), counting the number of "attachments"
(parts that would generate individual files), and a text buffer containing the
parts buttons.  The respective buffers are later output using
MunpackYahmailText() and MunpackYahmailParts().  The 'QuoteDesc' parameter is
used when getting the message text for inclusion in a reply/forward.
*/

MunpackYahmailProcess (int QuoteDesc)

{
   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "MunpackYahmailProcess()\n");

   MunpackTextPtr = VmsMailTextPtr + VmsMailHeaderLength;
   MunpackDoProcess = 1;
   MunpackAttachmentCount = 0;
   MunpackCharset[0] = '\0';
   MunpackDoQuoteDesc = QuoteDesc;

   if (MunpackDescTextPtr != NULL) free (MunpackDescTextPtr);
   MunpackDescTextPtr = NULL;
   MunpackDescTextLength = MunpackDescTextSize = 0;

   if (MunpackPartsTextPtr != NULL) free (MunpackPartsTextPtr);
   MunpackPartsTextPtr = NULL;
   MunpackPartsTextLength = MunpackPartsTextSize = 0;

   handleMessage(part_init(NULL), "text/plain", 0, 0);

   if (Debug)
      fprintf (stdout, "MunpackAttachmentCount: %d MunpackCharset |%s|\n",
                        MunpackAttachmentCount, MunpackCharset);
}

/*
From the message BODY extract the attachment with the file name 'NamePtr',
returning it as an HTTP response.
*/

MunpackYahmailFile
(
char *NamePtr,
char *MimeContentTypePtr
)
{
   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "MunpackYahmailFile() |%s|\n", NamePtr);

   MunpackNamePtr = NamePtr;
   MunpackTextPtr = VmsMailTextPtr + VmsMailHeaderLength;
   MunpackDoProcess = MunpackDoQuoteDesc = 0;

   MunpackMimeContentTypePtr = MimeContentTypePtr;

   handleMessage(part_init(NULL), "text/plain", 0, 0);

   if (didchat) return;

   CgiLibResponseError (__FILE__, __LINE__, 0, "MIME attachment not found!");
}

/*
Output after HTML-escaping and URL-anchoring the in-line message text.
*/

MunpackYahmailText
(
FILE *file_ptr,
int AnchorUrls,
int WrapLongLines
)
{
   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "MunpackYahmailText() %d\n", AnchorUrls);

   if (MunpackDescTextPtr != NULL &&
       file_ptr != NULL)
   {
      MunpackDescTextPtr[MunpackDescTextLength] = '\0';
      if (WrapLongLines)
         ViewMsgWrapLongLines (MunpackDescTextPtr, WrapLongLines);
      cptr = (char*)CgiLibAnchorHtmlEscape (MunpackDescTextPtr, -1, NULL, -1,
                                            AnchorUrls);
      fputs (cptr, file_ptr);
      free (cptr);
   }
}

/*
Output the parts button text buffer.
*/

MunpackYahmailParts (FILE *file_ptr)

{
   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "MunpackYahmailParts()\n");

   if (MunpackPartsTextPtr != NULL &&
       file_ptr != NULL)
   {
      MunpackPartsTextPtr[MunpackPartsTextLength] = '\0';
      if (MunpackDescTextPtr == NULL &&
          MunpackPartsTextPtr[0] == '\n')
         fputs (MunpackPartsTextPtr+1, file_ptr);
      else
         fputs (MunpackPartsTextPtr, file_ptr);
      fprintf (stdout,
"\n&nbsp;&nbsp;\
<INPUT TYPE=checkbox NAME=mct%d VALUE=\"application/octet-stream\">&nbsp;\
<I>%s</I>", MunpackAttachmentCount, lang_ChkSaveAsFile);
   }
}

/*
Read the specified number of bytes from the body of the VMS mail message as if
from a file using fread() itself.
*/

int Munpack_fread
(
char *ptr,
int size_of_item,
int number_of_items
)
{
   register int  ccnt;
   register char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

/**
   if (Debug)
      fprintf (stdout, "Munpack_fread() %d %d\n",
               size_of_item, number_of_items);
**/

   if (MunpackTextPtr == NULL)
   {
      /** if (Debug) fprintf (stdout, "Munpack_fread() EOF (empty)\n"); **/
      return (0);
   }
   if (!*(cptr = MunpackTextPtr))
   {
      /** if (Debug) fprintf (stdout, "Munpack_fread() EOF\n"); **/
      return (0);
   }

   sptr = ptr;
   ccnt = size_of_item * number_of_items;
   while (*cptr && ccnt--) *sptr++ = *cptr++;
   ccnt = (cptr - MunpackTextPtr) / size_of_item;
   MunpackTextPtr = cptr;
   /** if (Debug) fprintf (stdout, "Munpack_fread() ccnt: %d\n", ccnt); **/
   return (ccnt);
}

/*
Point back at the start of the message text.
*/

int Munpack_rewind ()

{
   /*********/
   /* begin */
   /*********/

   /** if (Debug) fprintf (stdout, "Munpack_rewind()\n"); **/

   MunpackTextPtr = VmsMailTextPtr + VmsMailHeaderLength;
   return (0);
}

/*
Used to buffer (instead of output) characters when outputing in-line text. 
This is done so that the text can be HTML-escaped and URL-anchored prior to
inclusion on the message display page.
*/

int Munpack_putc
(
int character,
FILE *file_ptr
)
{
   /*********/
   /* begin */
   /*********/

   /** if (Debug) fprintf (stdout, "Munpack_putc()\n"); **/

   if (!MunpackDoProcess) return (putc (character, file_ptr));

   if (MunpackDescTextLength >= MunpackDescTextSize)
   {
       MunpackDescTextSize += PUTC_CHUNK;
       /* the plus one allows for the potential quote character! */
       MunpackDescTextPtr = realloc (MunpackDescTextPtr, MunpackDescTextSize+1);
   }

   if (MunpackDoQuoteDesc)
   {
      if (!MunpackDescTextLength ||
          *(MunpackDescTextPtr+MunpackDescTextLength-1) == '\n')
         *(MunpackDescTextPtr+MunpackDescTextLength++) = '>';
   }
   *(MunpackDescTextPtr+MunpackDescTextLength++) = character;

   return (character);
}

/*
Used to buffer (instead of output) characters when outputing in-line text. 
This is done so that the text can be HTML-escaped and URL-anchored prior to
inclusion on the message display page.
*/

int Munpack_fputs
(
char *str,
FILE *file_ptr
)
{
   /*********/
   /* begin */
   /*********/

   /** if (Debug) fprintf (stdout, "Munpack_fputs()\n"); **/

   if (!MunpackDoProcess) return (fputs (str, file_ptr));

   while (*str)
   {
      if (MunpackDescTextLength >= MunpackDescTextSize)
      {
          MunpackDescTextSize += PUTC_CHUNK;
          /* the plus one allows for the potential quote character! */
          MunpackDescTextPtr = realloc (MunpackDescTextPtr,
                                        MunpackDescTextSize+1);
      }

      if (MunpackDoQuoteDesc)
      {
         if (!MunpackDescTextLength ||
             *(MunpackDescTextPtr+MunpackDescTextLength-1) == '\n')
            *(MunpackDescTextPtr+MunpackDescTextLength++) = '>';
      }
      *(MunpackDescTextPtr+MunpackDescTextLength++) = *str++;
   }

   return (0);
}

/*
An sprintf() that prints into the message text or parts text buffer.  Maximum
allowed single print is VSPRINTF_MAX characters.
*/

int Munpack_sprintf
(
char *str,
char *format,
...
)
{
   int  argcnt,
        cnt;
   va_list  argptr;

   /*********/
   /* begin */
   /*********/

   va_count (argcnt);

   if (Debug) fprintf (stdout, "Munpack_sprintf() %d |%s|\n", argcnt, format);

   if (str == (char*)&MunpackDescTextPtr)
   {
      if (MunpackDescTextLength + VSPRINTF_MAX >= MunpackDescTextSize)
      {
          MunpackDescTextSize += VSPRINTF_CHUNK;
          MunpackDescTextPtr = realloc (MunpackDescTextPtr,
                                        MunpackDescTextSize+1);
      }

      va_start (argptr, format);
      cnt = vsprintf (MunpackDescTextPtr+MunpackDescTextLength,
                      format, argptr);
      va_end (argptr);
      if (cnt >= VSPRINTF_MAX) exit (676);
      MunpackDescTextLength += cnt;
      return (cnt);
   }
   else
   {
      if (MunpackPartsTextLength + VSPRINTF_MAX >= MunpackPartsTextSize)
      {
          MunpackPartsTextSize += VSPRINTF_CHUNK;
          MunpackPartsTextPtr = realloc (MunpackPartsTextPtr,
                                         MunpackPartsTextSize);
      }

      va_start (argptr, format);
      cnt = vsprintf (MunpackPartsTextPtr+MunpackPartsTextLength,
                      format, argptr);
      va_end (argptr);
      if (cnt >= VSPRINTF_MAX) exit (676);
      MunpackPartsTextLength += cnt;
      return (cnt);
   }
}

#else /* YAHMAIL_MUNPACK */

int Debug = 0;
char  *SourceFileNamePtr;

main(argc, argv)
int argc;
char **argv;
{
    int opt;
    FILE *file;
    int extractText = 0;
    
    while ((opt = getopt(argc, argv, "qftC:")) != EOF) {
	switch (opt) {
	case 'f':
	    overwrite_files = 1;
	    break;

	case 'q':
	    quiet = 1;
	    break;

	case 't':
	    extractText = 1;
	    break;

	case 'C':
	    if (chdir(optarg)) {
		perror(optarg);
		exit(1);
	    }
	    break;

	default:
	    usage();
	}
    }

    if (optind == argc) {
	fprintf(stderr, "munpack: reading from standard input\n");
	didchat = 0;
	handleMessage(part_init(stdin), "text/plain", 0, extractText);
	if (!didchat) {
	    fprintf(stdout,
		    "Did not find anything to unpack from standard input\n");
	}
	exit(0);
    }

    while (argv[optind]) {
#ifdef MGD_MODS
	file = fopen(SourceFileNamePtr = argv[optind], "r");
#else /* MGD_MODS */
	file = fopen(argv[optind], "r");
#endif /* MGD_MODS */
	if (!file) {
	    perror(argv[optind]);
	}
	else {
	    didchat = 0;
	    handleMessage(part_init(file), "text/plain", 0, extractText);
	    fclose(file);
	    if (!didchat) {
		fprintf(stdout, 
			"Did not find anything to unpack from %s\n",
			argv[optind]);
	    }
	}
	optind++;
    }
    exit(0);
}

#endif /* YAHMAIL_MUNPACK */

usage() {
    fprintf(stderr, "munpack version %s\n", MPACK_VERSION);
    fprintf(stderr, "usage: munpack [-f] [-q] [-C directory] [files...]\n");
    exit(1);
}

warn(s)
char *s;
{
#ifdef YAHMAIL_MUNPACK

    char  *cptr;
    char  sBuffer [256];

    if (MunpackDoProcess)
    {
       CgiLibHtmlEscape (s, -1, sBuffer, sizeof(sBuffer));
       if (cptr = strchr (sBuffer, '\n')) *cptr = '\0';

       Munpack_sprintf ((char*)&MunpackPartsTextPtr,
"\n<FONT COLOR=\"#ff0000\">[[<B>MIME PROCESSING ERROR:</B> %s]]</FONT>\n",
                        sBuffer);
    }
    else
    {
       strcpy (sBuffer, s);
       if (cptr = strchr (sBuffer, '\n')) *cptr = '\0';

       fprintf (stdout, "\n[[MIME PROCESSING ERROR: %s]]\n", sBuffer);
    }

#else /* YAHMAIL_MUNPACK */

    fprintf(stderr, "munpack: warning: %s\n", s);

#endif /* YAHMAIL_MUNPACK */
}

chat(s)
char *s;
{
    didchat = 1;

#ifdef YAHMAIL_MUNPACK
#else /* YAHMAIL_MUNPACK */

    if (!quiet) fprintf(stdout, "%s\n", s);

#endif /* YAHMAIL_MUNPACK */
}
