/*****************************************************************************/
/*
                                   SPAM.c

        +-----------------------------------------------------------+
        | A pox on the houses of all SPAMers.  Make that two poxes. |
        +-----------------------------------------------------------+

Well, when the daily receipt of SPAM grew from one or two items to one or two
dozen (and in the subsequent nine months to four or five dozen - a pox on the
houses of all SPAMers), I finally spat the dummy and will provide some crude
SPAM filtering (for myself if no one else).

The first attempt at this was to implement a filter for SPAM - of course that
turned out to be an application in itself!!  So, to provide some filtering for
SPAM this second attempt has changed to to 'filter-out' recognised messages
from the noise of mostly incoming SPAM.  As a default everything is considered
SPAM until the user indicates a particular sender address (or other indicator)
is *not* SPAM.  Registering an address as 'known' can be done by a simple
button-click.

The SPAM file is a simple plain-text file that can be edited at the
command-line or with a <TEXTAREA></TEXTAREA> page provided by yahMAIL.  This
allows the senders to be removed or otherwise modified as well as for the
introduction of 'other rules' to indicate (or not) SPAM.  These 'other rules'
are not really needed for opt-out SPAM filtering but can be used to improve the
filtering-out of recognised mail.  For instance my recognised mail file
(in part) contains

  # 22-JAN-2004 22:32:01
  -default
  +subj:^.*[^@]wasd.*
  +subj:*yahmail*
  +from:info-wasd@vsm.com.au
  +from:mark.daniel@vsm.com.au

where the "+from:"s identifiy recognised email addresses, along with the first
"+subj:" which recognises a message with a subject line containing the keyword
"wasd" in it that is not part of something like "mark.daniel@wasd.vsm.com.au
how would you like a bigger <whatever>?" (perhaps "income"? :^)  The second
"+subj:" recognises  emails containing a subject line including the string
"yahmail".  So carefully constructed additional rules can be used to improve
the recognition of particular themes in mail.


RULES
-----
-default          by default identify all messages as SPAM (the default)
+default          by default allow all messages
-from:<pattern>   this sender address is SPAM
+from:<pattern>   this sender address is not SPAM
-to:<pattern>     this destination address is SPAM
+to:<pattern>     this destination address is not SPAM
-subj:<pattern>   this subject is SPAM
+subj:<pattern>   this subject is not SPAM

The <pattern> can be a simple wildcard string, where '*' indicates a greedy
match any zero or more characters and '%' match any one character.  Simple
wildcard patterns are internally converted into corresponding regular
expressions.  If the <pattern> begins with a '^' character it is considered a
native regular  expression and so all 'regex' syntax may be used,

The rules "+from:" and "+subj:" are probably the only ones that generally need 
to considered and used.  The others are provided for future or other
experimentation.

Rules are loaded once from the file(s) then used to compare to all mail
messages in the one yahMAIL activation.  They are based on regular expressions.
They are interpreted from first-to-last in a specific rule order.

  1) +from:  allowed senders
  2) -from:  blocked senders
  3) +to:    allowed destinations
  4) -to:    blocked destinations
  5) +subj:  allowed subjects
  6) -subj:  blocked subjects
  7) +|-default

As soon as a match occurs it is allowed (not SPAM) or blocked (is SPAM).  When
all the above rules have been scanned in the specified order and none have
matched the default action occurs.


RULE FILES
----------
The yahMAIL global configuration file is located by the system-wide logical
name YAHMAIL$CONFIG and may contain SPAM filter rules within a [SPAM]
configuration directive.  A user-specific rule file is named YAHMAIL.CONF and
must be located with the user's MAIL.MAI file (this is where yahMAIL
automatically places it).


REGEX EVALUATION
----------------
Uses the GNU RX1.5 regular expression package.
Evaluation is done using case-insensitive, EGREP-compatible matching.


COPYRIGHT
---------
Copyright (C) 1999-2004 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
22-JAN-2004  MGD  second attempt (opt-out filtering)
                  A pox on the houses of all SPAMers.  This has become my new
                  mantra.  Repetition will improve it's potency.  Join me now
                  ... a pox on the houses of all SPAMers, a pox on the houses
                  of all SPAMers, a pox on the houses of all SPAMers ...
08-APR-2003  MGD  first attempt (SPAM filtering)
*/

/*****************************************************************************/

#ifndef __VAX
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* VMS header files */
#include <rmsdef.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "regex.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

#define REGEX_DEBUG 0
#if REGEX_DEBUG
#define RegexDebug Debug
#else
#define RegexDebug 0
#endif

int  SpamRegexCflags = REG_EXTENDED | REG_ICASE,
     SpamRegexEflags = 0;

extern int  PrivateTextLength;
extern char  *ConfigSpamPtr,
             *PrivateTextPtr;

/*****************************************************************************/
/*
Apply the tests described above.
Return true is it looks like SPAM, false if it doesn't.
Expects 'Reason' to be NULL or point to at least 256 bytes of storage.

Because these SPAMing bastards (well I would certainly disown any child of mine
discovered SPAMing) attempt to disguise their keywords with lookalikes (e.g.
"pen1s") or interpose other characters between them (e.g. "p_e_n-i-s") when a
"-subj:" (subject line) disallow is processed the filter attempts to
automatically allow for this by interposing likely characters between all other
characters in the filter string supplied.

A pox on the houses of all SPAMers.
*/

boolean LooksLikeSPAM
(
char *To,
char *From,
char *Sender,
char *Subject,
char *Reason
)
{
   static boolean  SpamDefaultBlock;
   static char  *SpamGlobalPtr,
                *SpamUserPtr;
   static int  SpamLength,
               SpamLineCount,
               SpamRegexCount,
               SpamUserLength;
   static char  **SpamLinePtr;
   static regex_t  *SpamRegex;

   boolean  BlockedSubject,
            DelimitFilter,
            FromFilter,
            NativeRegex;
   int  cnt, retval, status;
   regmatch_t  pmatch[1];
   char  *bptr, *cptr, *sptr, *zptr;
   char  Buffer [4096],
         FileName [256];

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "LooksLikeSPAM() |%s|%s|%s|%s|\n",
               To, From, Sender, Subject);

   if (!SpamGlobalPtr)
   {
      /********************/
      /* get spam filters */
      /********************/

      /* of course we only need to load and compile these once per yahMAIL */
      SpamDefaultBlock = true;

      if (ConfigSpamPtr)
         SpamGlobalPtr = ConfigSpamPtr;
      else
         SpamGlobalPtr = "";

      if (PrivateTextPtr)
      {
         /* reuse the already read-in private setup file */
         SpamUserPtr = calloc (1, PrivateTextLength+1);
         SpamUserLength = PrivateTextLength;
         memcpy (SpamUserPtr, PrivateTextPtr, PrivateTextLength+1);
      }
      else
      {
         sprintf (FileName, "%s%s%s",
                  VmsMailUserFullDirectory,
                  PERSONAL_CONFIG_FILE_NAME, PERSONAL_CONFIG_FILE_TYPE);
         status = ReadFileIntoMemory (FileName,
                                      &SpamUserPtr, &SpamUserLength);
         if (VMSnok (status)) SpamUserPtr = "";
      }

      /* count the lines, first the global yahmail, then the user */
      SpamLineCount = 0;
      cptr = SpamGlobalPtr;
      while (*cptr)
      {
         for (sptr = cptr; *sptr && *sptr != '\n'; sptr++);
         while (cptr < sptr && isspace(*cptr)) cptr++;
         if (*cptr == '+' || *cptr == '-') SpamLineCount++;
         if (*sptr) sptr++;
         cptr = sptr;
      }
      if (Debug) fprintf (stdout, "SpamLineCount: %d\n", SpamLineCount);
      cptr = SpamUserPtr;
      while (*cptr)
      {
         for (sptr = cptr; *sptr && *sptr != '\n'; sptr++);
         while (cptr < sptr && isspace(*cptr)) cptr++;
         if (*cptr == '+' || *cptr == '-') SpamLineCount++;
         if (*sptr) sptr++;
         cptr = sptr;
      }
      if (Debug) fprintf (stdout, "SpamLineCount: %d\n", SpamLineCount);

      SpamRegex = calloc (sizeof(regex_t), SpamLineCount);
      if (!SpamRegex) exit (vaxc$errno);

      SpamLinePtr = calloc (sizeof(char*), SpamLineCount);
      if (!SpamLinePtr) exit (vaxc$errno);

      /*******************************/
      /* compile regular expressions */
      /*******************************/

      SpamRegexCount = 0;
      for (cnt = 0; cnt < 2; cnt++)
      {
         if (!cnt)
            cptr = SpamGlobalPtr;
         else
            cptr = SpamUserPtr;

         while (*cptr)
         {
            for (sptr = cptr; *sptr && *sptr != '\n'; sptr++);
            if (*sptr == '\n') *sptr++ = '\0';
            while (cptr < sptr && isspace(*cptr)) cptr++;
            if (*cptr != '+' && *cptr != '-')
            {
               cptr = sptr;
               continue;
            }         
            if (Debug) fprintf (stdout, "|%s|\n", cptr);

            if ((*(unsigned long*)cptr == '+def' ||
                 *(unsigned long*)cptr == '-def') &&
                !memcmp (cptr+1, "default", 7))
            {
               if (*cptr == '+')
                  SpamDefaultBlock = false;
               else
                  SpamDefaultBlock = true;
               cptr = sptr;
               continue;
            }

            if (*(unsigned long*)cptr == '-fro' ||
                *(unsigned long*)cptr == '+fro')
               FromFilter = true;
            else
               FromFilter = false;

            if (*(unsigned long*)cptr == '-sub')
               BlockedSubject = true;
            else
               BlockedSubject = false;

            SpamLinePtr[SpamRegexCount] = cptr;
            while (*cptr && *cptr != ':') cptr++;
            if (*cptr) cptr++;

            if (*cptr == '^')
               NativeRegex = true;
            else
               NativeRegex = false;

            if (FromFilter)
            {
               /* if not obviously address ensure it's white-space delimited */
               while (*cptr && *cptr != '@' && *(unsigned short*)cptr != '::')
                  cptr++;
               if (*cptr)
                  DelimitFilter = false;
               else
                  DelimitFilter = true;
            }
            else
               DelimitFilter = false;

            /* note the last character just parsed */
            bptr = sptr;

            zptr = (sptr = Buffer) + sizeof(Buffer);
            if (DelimitFilter)
               for (cptr = "^[ 	]*"; *cptr && sptr < zptr; *sptr++ = *cptr++);
            cptr = SpamLinePtr[SpamRegexCount];
            cptr += 6;

            if (BlockedSubject && NativeRegex)
            {
               /*****************************/
               /* expand regular expression */
               /*****************************/

               cptr++;  /* past the leading '^' */
               while (*cptr)
               {
                  /* quick and dirty bounds check */
                  if (sptr + 128 > zptr) exit (SS$_BUGCHECK);
                  switch (*cptr)
                  {
                     case 'a' :
                        strcpy (sptr,
"(a|\xc0|\xc1|\xc2|\xc3|\xc4|\xc5|\xe0|\xe1|\xe2|\xe3)");
                        sptr += 23;
                        break;
                     case 'e' :
                        strcpy (sptr,
"(e|\xc8|\xc9|\xca|\xcb|\xe8|\xe9|\xea|\xeb)");
                        sptr += 19;
                        break;
                     case 'i' :
                        strcpy (sptr,
"(i|\xcc|\xcd|\xce|\xcf|\xec|\xed|\xee|\xef)");
                        sptr += 19;
                        break;
                     case 'o' :
                        strcpy (sptr,
"(o|\xd2|\xd3|\xd4|\xd5|\xd6|\xf2|\xf3|\xf4|\xf5|\xf6)");
                        sptr += 23;
                        break;
                     case 'u' :
                        strcpy (sptr,
"(u|\xd9|\xda|\xdb|\xdc|\xdd|\xfa|\xfb|\xfc)");
                        sptr += 19;
                        break;
                     case 'y' :
                        strcpy (sptr,
"(y|\xdd|\xfd|\xff)");
                        sptr += 9;
                        break;
                     default :
                        *sptr++ = *cptr;
                  }
                  if (isalpha(cptr[0]) && isalpha(cptr[1]))
                  {
                     strcpy (sptr, "[^a-z]{0,3}");
                     sptr += 11;
                  }
                  cptr++;
               }
            }
            else
            if (NativeRegex)
            {
               /*****************************/
               /* native regular expression */
               /*****************************/

               cptr++;  /* past the leading '^' */
               while (*cptr)
               {
                  if (sptr < zptr) *sptr++ = *cptr;
                  cptr++;
               }
            }
            else
            {
               /***********************/
               /* wildcard expression */
               /***********************/

               while (*cptr)
               {
                  /* convert into a regular expression equivalent */
                  switch (*cptr)
                  {
                     case '*' :
                        /* match any number of characters */
                        if (sptr < zptr) *sptr++ = '.';
                        if (sptr < zptr) *sptr++ = '*';
                        break;
                     case '%' :
                        /* match any one character */
                        if (sptr < zptr) *sptr++ = '.';
                        break;
                     case '\\' :
                        /* escape the next character */
                        if (sptr < zptr) *sptr++ = '\\';
                        cptr++;
                        if (*cptr && sptr < zptr) *sptr++ = *zptr++;
                        break;
                     case '.' :
                     case '+' :
                     case '?' :
                     case '{' :
                     case '}' :
                     case '|' :
                     case '[' :
                     case ']' :
                     case '(' :
                     case ')' :
                     case '^' :
                     case '$' :
                        if (sptr < zptr) *sptr++ = '\\';
                        if (sptr < zptr) *sptr++ = *cptr;
                        break;
                     default :
                        if (sptr < zptr) *sptr++ = *cptr;
                  }
                  cptr++;
               }
            }

            if (DelimitFilter)
               for (cptr = "[ 	]*$"; *cptr && sptr < zptr; *sptr++ = *cptr++);
            *sptr = '\0';
            if (Debug) fprintf (stdout, "Buffer |%s|\n", Buffer);

            retval = regcomp (&SpamRegex[SpamRegexCount], Buffer,
                              SpamRegexCflags);
            if (RegexDebug)
               fprintf (stdout, "regcomp() %d |%s|\n", retval, Buffer);

            if (retval) SpamLinePtr[SpamRegexCount][0] = '?';

            SpamRegexCount++;
            cptr = sptr = bptr;
         }
      }
   }
   if (Debug) fprintf (stdout, "SpamRegexCount: %d\n", SpamRegexCount);

   if (!SpamRegexCount)
   {
      /* no regular expressions (i.e. no filters), default action */
      if (SpamDefaultBlock)
      {
         if (Reason) strcpy (Reason, "-default");
         return (true);
      }
      else
      {
         if (Reason) strcpy (Reason, "+default");
         return (false);
      }
   }

   /********************/
   /* allowed "from:"s */
   /********************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "SpamLinePtr[%d] |%s|\n", cnt, cptr);
      if (*(unsigned long*)cptr != '+fro') continue;

      retval = regexec (&SpamRegex[cnt], From, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "ALLOWED \"%s\" \"%s\"\n", cptr+6, From);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgFrom, cptr+6);
      return (false);
   }

   /********************/
   /* blocked "from:"s */
   /********************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "-from |%s|\n", cptr);
      if (*(unsigned long*)cptr != '-fro') continue;

      retval = regexec (&SpamRegex[cnt], From, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "BLOCKED \"%s\" \"%s\"\n", cptr+6, From);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgFrom, cptr+6);
      return (true);
   }

   /******************/
   /* allowed "to:"s */
   /******************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "+from |%s|\n", cptr);
      if (*(unsigned long*)cptr != '+to:') continue;

      retval = regexec (&SpamRegex[cnt], To, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "ALLOWED \"%s\" \"%s\"\n", cptr+4, To);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgTo, cptr+4);
      return (false);
   }

   /******************/
   /* blocked "to:"s */
   /******************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "-to |%s|\n", cptr);
      if (*(unsigned long*)cptr != '-to:') continue;

      retval = regexec (&SpamRegex[cnt], To, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "BLOCKED \"%s\" \"%s\"\n", cptr+4, To);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgTo, cptr+4);
      return (true);
   }

   /********************/
   /* allowed "subj:"s */
   /********************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "+subj |%s|\n", cptr);
      if (*(unsigned long*)cptr != '+sub') continue;

      retval = regexec (&SpamRegex[cnt], Subject, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "MATCHED \"%s\" \"%s\"\n", cptr+6, Subject);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgSubj, cptr+6);
      return (false);
   }

   /********************/
   /* blocked "subj:"s */
   /********************/

   for (cnt = 0; cnt < SpamRegexCount; cnt++)
   {
      cptr = SpamLinePtr[cnt];
      if (Debug) fprintf (stdout, "-subj |%s|\n", cptr);
      if (*(unsigned long*)cptr != '-sub') continue;

      retval = regexec (&SpamRegex[cnt], Subject, 1, pmatch, SpamRegexEflags);
      if (retval) continue;

      if (Debug) fprintf (stdout, "BLOCKED \"%s\" \"%s\"\n", cptr+6, Subject);
      if (Reason) sprintf (Reason, "%s: %s", lang_MsgSubj, cptr+6);
      return (true);
   }

   /******************/
   /* default action */
   /******************/

   if (SpamDefaultBlock)
   {
      if (Reason) strcpy (Reason, "-default");
      return (true);
   }
   else
   {
      if (Reason) strcpy (Reason, "+default");
      return (false);
   }
}

/*****************************************************************************/
/*
Add a "+from:<address>" to the SPAM list file (if it doesn't already exists in
the current one).  A pox on the houses of all SPAMers.
*/

SpamListAddFrom ()
       
{
   int  cnt, idx, status,
        SpamListCount,
        PostBufferCount;
   char  Line [256],
         NewLine [256],
         FileName [256];
   char  *cptr, *sptr,
         SpamUserPtr;
   FILE  *FilePtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SpamListAddFrom()\n");

   sprintf (FileName, "%s%s%s",
            VmsMailUserFullDirectory,
            PERSONAL_CONFIG_FILE_NAME, PERSONAL_CONFIG_FILE_TYPE);

   /* couldn't get append to work, use read-update plus 'while{fgets()}' */
   FilePtr = fopen (FileName, "r+", "shr=nil");
   if (!FilePtr)
   {
      PersonalSetupFileCreate ();
      FilePtr = fopen (FileName, "r+", "shr=nil");
   }
   if (!FilePtr)
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            FileName, lang_BtnGoBack);
      return;
   }

   /* if already in the list then just prevent it from being added again */
   strcpy (NewLine, "+from:");
   while (fgets (Line, sizeof(Line), FilePtr))
   {
      for (cptr = Line; *cptr && isspace(*cptr); cptr++);
      if (!*cptr || *cptr == '#') continue;
      for (cnt = 0; cnt < MailMessageIdCount; cnt++)
      {
         if (!(cptr = MailMessageIdSpamList[cnt])) continue;
         if (Debug) fprintf (stdout, "|%s|\n", cptr);
         /* ensure it's not in there more than once */
         for (idx = 0; idx < MailMessageIdCount; idx++)
         {
            if (idx == cnt) continue;
            if (!MailMessageIdSpamList[idx]) continue;
            if (strsame (MailMessageIdSpamList[idx],
                         MailMessageIdSpamList[cnt],
                         -1))
               MailMessageIdSpamList[idx] = NULL;
         }
         SpamGetAddress (NewLine+6, cptr, sizeof(NewLine)-6);
         strcat (NewLine, "\n");
         if (strsame (Line, NewLine, -1)) MailMessageIdSpamList[cnt] = NULL;
      }
   }

   SpamListCount = 0;
   for (cnt = 0; cnt < MailMessageIdCount; cnt++)
   {
      if (!(cptr = MailMessageIdSpamList[cnt])) continue;
      if (Debug) fprintf (stdout, "|%s|\n", cptr);
      SpamListCount++;

      SpamGetAddress (NewLine+6, cptr, sizeof(NewLine)-7);
      strcat (NewLine, "\n");
      if (fputs (NewLine, FilePtr) == EOF)
      {
         status = vaxc$errno;
         CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            FileName, lang_BtnGoBack);
         fclose (FilePtr);
         return;
      }
   }

   fclose (FilePtr);

   if (SpamListCount)
   {
      if (ConfigDirectActionUI)
         returnFromAction(-1);
      else
         CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            lang_NotSpamListUpdated, lang_BtnGoBack);
   }
   else
   {
      CgiLibResponseError (FI_LI, 0,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_NoMessagesSelected, lang_BtnGoBack);

   }
}

/*****************************************************************************/
/*
Remove a "+from:<address>" to the SPAM list file (if it actually exists in the
current one).  A pox on the houses of all SPAMers.
*/

SpamListRemoveFrom ()
       
{
   boolean  HitFrom;
   int  cnt, status,
        SpamListCount,
        PostBufferCount;
   char  Line [256],
         NewLine [256],
         FileName [256],
         TempFileName [256];
   char  *cptr, *sptr,
         SpamUserPtr;
   FILE  *FilePtr,
         *NewFilePtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SpamListRemoveFrom()\n");

   sprintf (FileName, "%s%s%s",
            VmsMailUserFullDirectory,
            PERSONAL_CONFIG_FILE_NAME, PERSONAL_CONFIG_FILE_TYPE);

   sprintf (TempFileName, "%s%s%s",
            VmsMailUserFullDirectory,
            PERSONAL_CONFIG_FILE_NAME, PERSONAL_CONFIG_FILE_TEMP);

   FilePtr = fopen (FileName, "r+", "shr=nil");
   if (!FilePtr)
   {
      PersonalSetupFileCreate ();
      FilePtr = fopen (FileName, "r+", "shr=nil");
   }
   if (!FilePtr)
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            FileName, lang_BtnGoBack);
      return;
   }

   /* if already in the list then just prevent it from being added again */
   HitFrom = false;
   strcpy (NewLine, "+from:");
   while (fgets (Line, sizeof(Line), FilePtr))
   {
      for (cptr = Line; *cptr && isspace(*cptr); cptr++);
      if (!*cptr || *cptr == '#') continue;
      SpamListCount = 0;
      for (cnt = 0; cnt < MailMessageIdCount; cnt++)
      {
         if (!(cptr = MailMessageIdSpamList[cnt])) continue;
         if (Debug)
            fprintf (stdout, "MailMessageIdSpamList[%d] |%s|\n", cnt, cptr);
         SpamListCount++;
         SpamGetAddress (NewLine+6, cptr, sizeof(NewLine)-7);
         strcat (NewLine, "\n");
         if (Debug) fprintf (stdout, "|%s|%s|\n", Line, NewLine);
         if (strsame (Line, NewLine, -1))
         {
            HitFrom = true;
            break;
         }
      }
      if (HitFrom) break;
   }

   if (!SpamListCount)
   {
      CgiLibResponseError (FI_LI, 0,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_NoMessagesSelected, lang_BtnGoBack);
      fclose (FilePtr);
      return;
   }

   if (HitFrom)
   {
      NewFilePtr = fopen (TempFileName, "w", "shr=nil");
      if (!NewFilePtr)
      {
         status = vaxc$errno;
         CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            FileName, lang_BtnGoBack);
         if (Debug) fprintf (stdout, "fopen() %%X%08.08X\n", status);
         fclose (FilePtr);
         return;
      }
      rewind (FilePtr);
      while (fgets (Line, sizeof(Line), FilePtr))
      {
         for (cptr = Line; *cptr && isspace(*cptr); cptr++);
         if (!*cptr || *cptr == '#') continue;
         for (cnt = 0; cnt < MailMessageIdCount; cnt++)
         {
            if (!(cptr = MailMessageIdSpamList[cnt])) continue;
            if (Debug)
               fprintf (stdout, "MailMessageIdSpamList[%d] |%s|\n", cnt, cptr);
            SpamGetAddress (NewLine+6, cptr, sizeof(NewLine)-7);
            strcat (NewLine, "\n");
            if (Debug) fprintf (stdout, "|%s|%s|\n", Line, NewLine);
            if (strsame (Line, NewLine, -1)) Line[0] = '\0';
         }
         if (!Line[0]) continue;
         if (fputs (Line, NewFilePtr) == EOF)
         {
            status = vaxc$errno;
            CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
               FileName, lang_BtnGoBack);

            fclose (FilePtr);
            fclose (NewFilePtr);
            remove (TempFileName);

            return;
         }
      }
   }

   fclose (FilePtr);
   fclose (NewFilePtr);

   rename (TempFileName, FileName);

   /* purge the versions back to a maximum of 3 */
   strcat (FileName, ";-3");
   while (!remove (FileName));

   if (ConfigDirectActionUI)
      returnFromAction(-1);
   else
      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_NotSpamListUpdated, lang_BtnGoBack);
}

/*****************************************************************************/
/*
Isolates a <username@host.name> or <node::username> address from the supplied
string.  If neither is found returns the entire string.  A pox on the houses of
all SPAMers.
*/

SpamGetAddress
(
char *str1,
char *str2,
int SizeOfStr1
)
{
   char  *cptr, *sptr, *zptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SpamGetAddress() |%s|\n", str2);

   /* look for RFC822 address */
   cptr = str2;
   while (*cptr)
   {
      while (*cptr && *cptr != '@') cptr++;
      if (!*cptr) break;
      sptr = cptr;
      while (cptr > str2 && *cptr != '<' && !isspace(*cptr)) cptr--;
      while (*sptr && !isspace(*sptr))
      {
         if (*sptr == '.')
         {
            zptr = (sptr = str1) + SizeOfStr1 - 1;
            while (*cptr && *cptr != '>' && !isspace(*cptr) && sptr < zptr)
               *sptr++ = *cptr++;
            *sptr = '\0';
            if (Debug) fprintf (stdout, "|%s|\n", str1);
            return;
         }
         sptr++;
      }                         
      cptr++;
   }
   /* look for a DECnet address */
   cptr = str2;
   while (*cptr)
   {
      while (*cptr && *(unsigned short*)cptr != '::') cptr++;
      if (!*cptr) break;
      sptr = cptr;
      while (cptr > str2 && !isspace(*cptr)) cptr--;
      zptr = (sptr = str1) + SizeOfStr1 - 1;
      while (*cptr && !isspace(*cptr) && sptr < zptr) *sptr++ = *cptr++;
      *sptr = '\0';
      if (Debug) fprintf (stdout, "|%s|\n", str1);
      return;
   }
   /* neither, buffer the entire string */
   cptr = str2;
   zptr = (sptr = str1) + SizeOfStr1 - 1;
   while (*cptr && sptr < zptr) *sptr++ = *cptr++;
   *sptr = '\0';
   if (Debug) fprintf (stdout, "|%s|\n", str1);
}

/*****************************************************************************/

