/*****************************************************************************/
/*
                                 yahMAIL.c

Yet Another Hyper-MAIL :^)  With acknowlegements for seminal ideas, other
VMS incarnations, etc., etc., including Jonathan Boswell (jsb@early.com). 

WASD yahMAIL is for interfacing with OpenVMS MAIL files.  It is NOT ONLY for
providing access to public/archived mail messages.  It can provide on-line,
authenticated, Web access to VMS users' private mail (with much of the
functionality available with DECwindows mail).  It can provide "postmaster"
(superuser) access to a VMS systems mail system, including mail profiles.  It
can also make public areas/archives of mail messages available for
non-athenticated access via the Web.

YAHMAIL makes some limited use of JavaScript and client-side cookies.  The
JavaScript ensures there is only ever one folder browse page in the history
list as well as keeping some state information allowing some semi-intelligent
reloading of browse pages as necessary (i.e. after deleting, move or sending
message(s)).  The pages will work OK on a non-JavaScript-enabled browser but
these features will not work and the user must keep track of when to reload
folder pages, etc.

It is possible to localize the language used in this script.  See LANG_EN.C and
any other language-specific files that may be in the source directory.

Frank.Weichert at Ruwel-Pfullingen.de has provided invaluable assistance in
refining the multi-language functionality provided all the _de input.


ISSUES
------
There have been a number of issues with the Mail system from 5.5-2 through to
the present (that I know of).  First, please ensure you have the latest MAIL
and C RTL patches installed if behaviour problems exist.


READING MIME ATTACHMENTS
------------------------
yahMAIL can use a savagely hacked MUNPACK component from the MPACK 1.5 package
(ftp://ftp.andrew.cmu.edu/pub/mpack/), Copyright (C) Carnegie Mellon University
and used within license conditions.

  Copyright 1993,1994 by Carnegie Mellon University
  Permission to use, copy, modify, distribute, and sell this software
  and its documentation for any purpose is hereby granted without
  fee, provided that the above copyright notice appear in all copies
  and that both that copyright notice and this permission notice
  appear in supporting documentation

This supports the reading of RFC822 (Internet mail)/MIME-encoded message
components (attachments). 


SENDING MIME ATTACHMENTS
------------------------
For systems that have PMDF available MIME attachments may be included with
messages to be sent without any workarounds or kludges.  A system with PMDF is
detected from logical name contents and the PMDF processing is enabled.

For some other mail agents sending MIME attachments is also possible ... just! 
VMS Mail is not (currently) MIME, or even RFC822 aware.  For this purpose it
relies on additional Mail transports such as TCP/IP Services (UCX), MX,
Multinet SMTP Mail, etc.  This makes the inclusion of MIME-compliant
attachments impossible as such messages need to include RFC82 header fields
describing the message as such, which callable mail is unaware of and cannot
pass.

HOWEVER ... a clever but obviously kludgy workaround was reported in the
vmsnet.mail.mx news group by <simon.maufe@virgin.net> on Sat, 12 Feb 2000
(thanks to the contributors).  This seems to work well enough for UCX 4.2,5.0A
and MadGoat MX (4.2).  It involves appending two correctly carriage-controlled
RFC822/MIME header fields to the VMS Mail subject line, which induces the
initial and subsequent Internet/SMTP mailing agents and ultimately the
MIME-compliant mail reader into processing it as MIME.  These fields are
obvious in the "Subj:" field of VMS command-line and DECwindows Mail, but
otherwise causes no great inconvenience.  yahMAIL detects and eliminates them
when displaying subject lines and once transported by SMTP the information just
becomes part of RFC822 header processing and so never appears to subsequent
readers.

yahMAIL attempts to identify the mailing agent on a particular host.  For
Compaq UCX/TCPIP(5.n) and MadGoat MX it switches the kludge on.  If it proves
problematic at a particular site or with particular agents, or is undesirable
for any other reason, it may be disabled by use of the /NOMIMEKLUDGE qualifier. 
Conversely, if the site is not recognised as supporting it, but the sysadmin
wishes to switch it on experimentally or permanently then the /MIMEKLUDGE
qualifier will unconditionally enable it.  Please advise the author of any
other environments in which this kludge is demonstrated to work, so that code
may be altered to automatically enable it for those environments.


PATHS TO MAIL AND ARCHIVES
--------------------------
The request path is not necesarily fixed and can have various components
present or not, and dependent on whether it's a request for private Mail or
public archives.  A tilde should be the first character of a private request
and cause the server to authenticate the request.  The query string can vary
considerably but always contains some of those elements described below in the
"CGI Variables" section.

  /~/                          open NEWMAIL folder
  /~/folder/                   open folder
  /~/file/folder/              open folder found in file
  /~/999                       get item from NEWMAIL folder
  /~/folder/999                get item from folder
  /~/file/folder/999           get item from folder found in file
  
  /name/                       public mail file
  /name/999                    get item from NEWMAIL in public file
  /name/folder/                open folder found in public file
  /name/folder/999             get item from folder in public file


GLOBAL CONFIG FILE
------------------
The configuration file (amongst other functions) maps authenicated user names
to VMS usernames and archive paths to archive Mail files. It can be protected
against world access.  SYSPRV is used when opening it. Several free-form text
sections indicated by square-bracket delimited keywords.  The left-most square
bracket must be on the left-most margin of the line.  Do not place any other
than a section keyword left square bracket on this margin (indent it at least
one space if necessary).  The section keywords are as follows:

  [anchor]           integer, zero disables conversion of URLs into anchors
  [body]             a localized HTML <BODY...> tag
  [charset]          default character set (overrides any RFC822 header)
  [createfooter]     free form, HTML for the bottom of the create-send page
  [direct]           direct action user interface ('enabled', 'disabled')
  [encoding]         default for non-specified FORM_ENC (e.g. "88", "IQ")
  [folderfooter]     free form, HTML for the bottom of the folder browse page
  [folderheader]     free form, HTML for the top of the folder browse page
  [list]             names of "global" address lists with file specifications
  [listfooter]       free form, HTML for the bottom of the address list pages
  [vmsmailfooter]    free form, HTML for the bottom of the profile page
  [localtosmtp]      force VMS username to be sent via SMTP (e.g. "@host.name")
  [newmail]          attention seeking message for new mail check
  [postmaster]       a localized warning message when postmaster access active
  [private]          mappings for access to the VMS mail system (authenticated)
  [public]           mappings for archive access requests (non-authenticated)
  [publicfooter]     for a public page (archive) overrides [header]
  [publicheader]     for a public page (archive) overrides [footer]
  [readfooter]       free form, HTML for the bottom of the read message page
  [replyuseRFC822]   use RFC822 "Reply-To:" then "From:" header when replying
                     'enabled' uses the yahMAIL-determined quoting,
                     'quote' delimits using \', 'parentheses' using (..)
  [smtp]             transport for smtp mail (for pre-VMS6.2 Mail)
  [SPAM]             '+' and '-' directives acceptable to the filter in SPAM.C
  [window]           number of items in browse window (an integer)
  [!yahmail!]        a non-default public config message string (see below)
  [#]                comment directive

Sections may be present in any order, EXCEPT the [public] and [private]
sections MUST be the last two.  The text for each section is considered to span
from the right square bracket of the section keyword to the left square bracket
of the next section keyword.  Leading and trailing white-space is trimmed.

The "[private]" section.  Each single line in this section comprises an entry
in the following format:

  authenticated-name\realm\equivalent-VMS-username

The authenticated name is the string in WWW_REMOTE_USER.  The realm is the
string in the WASD WWW_AUTH_REALM.  The eqivalent VMS user name is the VMS user
that YAHMAIL allows mail access to.

Any of these three elements may be asterisks.  If the authenticated name is an
asterisk, any name will be mapped. If the realm is an asterisk, names from
any (and all) realms will be mapped.  If the equivalent VMS username is an
asterisk then the authenticated name is mapped as the VMS user account.

The "[public]" section.  Each line in this section comprises an entry in the
following format:

  public-name\VMS-file-path\optional-folder-name

The first element of the path is the first '/' delimited string of the path
(following the script portion).  The VMS file path is a full file specification
to the mail file (e.g. USER_DISK:[USERS.EXAMPLE]MAIL.MAI).  The optional folder
name allows only a single folder to be accesses (otherwise it's the entire mail
file).

Example YAHMAIL configuration file.

  [#] this is an example yahMAIL configuration file
  [body]
  <BODY BGCOLOR="#ffffff" TEXT="#000000" LINK="#ff0000" VLINK="#990000">
  [header]
  <FONT COLOR="#ff0000">
  Unauthorized access via <B>yahMAIL</B> is prohibited
  by Federal and State law.
  </FONT>
  [footer]
  <A HREF="/yahmail/-/help.html" TARGET=_parent>yahMAIL help</A>
  [#] this is a pre-VMS6.2 system, provide default Internet mail transport
  [smtp] MX%
  [list]
  all_users WORLD:[LISTS]ALL_USERS.DIS
  postmaster WORLD:[LISTS]POSTMASTER.DIS
  [private]
  daniel\VMS\postmaster
  *\VMS\*
  [public]
  info-WASD\WEB:[INFO-WASD]MAIL.MAI\


CAUTION!!
---------
CARE SHOULD BE EXERCISED WITH THE CONFIGURATION FILE.  Misconfiguration could
conceivably leave the mail system open to inappropriate access.  For instance,
mapping an authenticated name to the wrong VMS username.  The code has been
designed to minimise the risk of catastrophic errors, for instance mapping all
authenticated users as POSTMASTERS.  Also, unless a username is explicitly
mapped in some way it will be rejected.  But, DO NOT MAP all authenticated
users to VMS usernames unless the source of the authentication is the SYSUAF,
or unless the realm usernames always correspond the appropriate VMS username. 
That is, DO NOT DO SOMETHING LIKE:

  *\not-from-SYSUAF\*

For the same reasons do not map all realms with a wildcard unless you have only
the one authentication realm, from the SYSUAF, or all realm names are
authenticated from the SYSUAF, or all usernames in the realm correspond to the
appropriate VMS usernames.  That is, DO NOT DO:

  *\*\*


PRIVATE CONFIG FILE
-------------------
This per-user configuration file, stored in the same location as MAIL.MAI and
named YAHMAIL.CONF, contains configuration directives allowing some
(semi-)permanent customization of the user's yahMAIL interface.  It is not
intended to be hand-edited (but can be), being accessable via the SET CONFIG
button.

  [FolderButtons]       top or bottom
  [MailFolderButtons]   top or bottom
  [UserFolderButtons]   none, top or bottom
  [CreateSendButton]    top or bottom
  [PickFields]          none, top or bottom
  [BrowseWindow] 10     integer
  [LongLineWrap] 0      integer 
  [CheckNEWMAIL] 30     integer 
  [TextAreaRows] 24     integer 
  [BodyEncoding] 88     keyword
  [ReplyTo]             string (e.g. "mark.daniel@wasd.vsm.com.au")
  [DirectAction]        enabled or disabled
  [HideSPAM]            enabled or disabled

Following this can be '+' and '-' SPAM filtering directives.
See SPAM.C module.

This file is read when no "action" button has been used (e.g.
"/cgi-bin/yahmail/~") and is intended to be loaded the once at the start of a 
yahMAIL session.  Use of an "action" button results in the private setup
directives being taken from the path passed to the CGI.  The LOAD CONFIG button
causes the in-config-file directives to be reloaded.


PUBLIC CONFIG MESSAGE
---------------------
When requesting from a public area, if the folder contains a message with the
subject string "!yahMAIL!" (case sensitive), or another specified using the
[!yahmail!] configuration directive, it's contents are used to generate custom
titles, etc., on the public folder browse page.  Section keywords:

  [body]             a localized HTML <BODY...> tag
  [title]            title of the folder
  [header]           free form, HTML marked-up text for the top of the page
  [footer]           free form, HTML marked-up text for the bottom of the page

These keywords must be positioned on the left-most edge of the page (the '['
character should not occur here otherwise). In-between these keywords is
free-form text, which can contain HTML markup tags.  Each section of text, up
until the next '[' delimited keyword or end-of-message, is used for the purpose
specified by the preceding keyword.  Note that [header] and [footer] here
overrides any [header], [footer], [publicheader] or [publicfooter] in the
configuration file.  This is an example:

  # not going to customize the <BODY...> tag for this public area!
  [title]
  Example Archive
  [header]
  This is an <U>example archive</U>!
  Note that HTML <I>markup</I> can be used.
  This is just a descriptive paragraph.
  [footer]
  For more information see the
  <A HREF="/yahmail/-/help.html">yahMAIL Help</A>.


CGI VARIABLES
-------------
AUTH_REALM          authentication realm name
PATH_INFO           request path information
REMOTE_USER         authenticated user name
REQUEST_METHOD      GET or POST
REQUEST_SCHEME      "http:" or "https:"
SCRIPT_NAME         name of script component in path information
SERVER_NAME         host name of server
SERVER_PORT         request port
SERVER_SOFTWARE     software ID string for server

FORM_ACT            form action string (usually from a submit button)
FORM_ANC            allows the user to override the 'MakeAnchors' setting
FORM_ANCHOR         same as FORM_ANC (for user convenience)
FORM_ATC            attachment count (max number of)
FORM_ATTn           URL-encoded, uploaded file(s) (from <INPUT TYPE=file>)
FORM_BWC            private browse window configuration, message create button
FORM_BWF            private browse window configuration, folder select/action
FORM_BWM            private browse window configuration, standard move buttons
FORM_BWP            private browse window configuration, pick fields
FORM_BWU            private browse window configuration, user move buttons
FORM_CMC            current message count (at time folder was listed)
FORM_CNM            refresh (check) NEWMAIL page every so many minutes
FORM_NEWMAIL        same as FORM_CNM (for user convenience)
FORM_DSP            display SPAM (if 1) do not display SPAM (if 0)
FORM_DUI            direct action user interface
FORM_ENC            send mail encoding ("88", "I8", "8Q", "IQ")
FORM_FIL            search for mail files
FORM_FSE            folder selected from a <SELECT></SELECT>
FORM_FTE            folder name entered in text ENTRY box
FORM_HEA            when displaying mail include VMS header
FORM_IDn            field names 1..n form each message ID checkbox checked
FORM_INC            include the message text with a create reply or forward
FORM_LLW            private setup equivalent (long line wrap) of WLL
FORM_LSE            address list name from a <SELECT></SELECT>
FORM_LTE            address list name entered in text ENTRY box
FORM_MAI            mail file (from selection list)
FORM_MCTn           specified MIME content type for attachment
FORM_MUNn           when MUNPACKing MIME content provides the part (file) name
FORM_NMS            new message seconds (used during NEWMAIL checking)
FORM_NNN            simple number based on time, to make folder request unique
FORM_PAG            browse folder page number (1 == most recent, nnn == least)
FORM_PCC            pick CC (select on substring of "CC:")
FORM_PEM            create-send pre-edited message text (upload)
FORM_PFR            pick from (select on substring of "From:")
FORM_PSU            pick subject (select on substring of "Subj:")
FORM_PTO            pick to (select on substring of "To:")
FORM_QUO            when reply/forward message quote ('>') body
FORM_RFC            when displaying mail include the RFC822 header
FORM_RTO            reply-to (attempts to provide "Reply-To: header field)
FORM_SBD            sending mail, message body
FORM_SCC            sending mail, message CC
FORM_SCS            sending mail, CC to self
FORM_SFR            sending mail, postmaster (only) may specify who it's from!
FORM_SPS            show private browse page setup selectors and buttons
FORM_SPM            filter SPAM from NEWMAIL folder
FORM_SSU            sending mail, message subject
FORM_STO            sending mail, message to
FORM_TAR            create-send <TEXTAREA> provides integer rows
FORM_TAW            create-send <TEXTAREA> to automatically wrap at integer
FORM_TXT            text from <TEXTAREA> when editing list or sig file
FORM_UAP            setting user profile, auto-purge
FORM_UCP            setting user profile, CC prompt
FORM_UCF            setting user profile, copy forward
FORM_UCR            setting user profile, copy reply
FORM_UCS            setting user profile, copy send
FORM_UED            setting user profile, editor
FORM_UFW            setting user profile, forwarding
FORM_UNM            setting user profile, new messages
FORM_UPN            setting user profile, personal name
FORM_USF            setting user profile, signature file
FORM_UPQ            setting user profile, print queue
FORM_UPF            setting user profile, print queue form
FORM_WHA            differentiates multiple buttons with the same action
FORM_WIN            browse window (number of messages on one page)
FORM_WINDOW         same as FORM_WIN (for user convenience)
FORM_WLL            when reading a message wrap at the first space after this
FORM_WRA            mail composition edit wraps at integer (also see _TAW)
FORM_WRAP           same as FORM_WRA (for user convenience)


PRIVILEGES REQUIRED
-------------------
SYSPRV              to access and send mail on behalf of others
READALL             (optional) to access mail protected against SYSTEM

if installed as follows:

  $ INSTALL ADD HT_EXE:YAHMAIL /OPEN /HEADER /SHARED /PRIV=SYSPRV

or

  $ INSTALL ADD HT_EXE:YAHMAIL /OPEN /HEADER /SHARED /PRIV=(SYSPRV,READALL)

then should have an ACL attached to prevent unexpected access:

  $ SET SECURITY HT_EXE:YAHMAIL.EXE -
  /ACL=((IDENT=HTTP$SERVER,ACCESS=READ+EXEC),(IDENT=*,ACCESS=NONE))


QUALIFIERS
----------
/CHARSET=           "Content-Type: text/html; charset=..."
/CONFIG=            yahMAIL configuration file (overrides YAHMAIL$CONFIG)
/DBUG               turns on all "if (Debug)" statements
/ENCODING=          default for non-specified FORM_ENC (e.g. "88", "IQ")
/[NO]MIMEKLUDGE     enables/disables the send message MIME attachment kludge
/NOPMDF             disable the PMDF message send (only if compiled for)
/POSTMASTER         PostMaster functionality can be used with this script


LOGICAL NAMES
-------------
YAHMAIL$CONFIG   file containing configuration directives
YAHMAIL$CHECK    turns on access checking messages in ProcessConfig()
YAHMAIL$DIRECT   turns on the direct transition user interface in which
                 if there is only one place to go after an action is requested,
                 you go there without stopping for a successful status message.
YAHMAIL$DISABLE  disables yahMAIL, provides an HTML message to that effect
YAHMAIL$DBUG     turns on all "if (Debug)" statements
YAHMAIL$PARAM    equivalent to (overrides) the command line
                 parameters/qualifiers (define as a system-wide logical)
                 may also be assigned as a local/global symbol


BUILD DETAILS
-------------
See BUILD_YAHMAIL.COM procedure.


COPYRIGHT
---------
Copyright (C) 1999-2004 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY (update 'SOFTWAREVN' as well)
---------------
16-FEB-2004  MGD  v1.8.b7,
                  minor conditional mods to support IA64,
                  private (per-user) configuration file,
                  optional (via setup) SPAM filtering in NEWMAIL,
                  optional [SPAM] directive in global config file,
                  optional (on-demand) mail file listing,
                  setup is displayed for "/cgi-bin/yahmail/~",
                  add private setup for direct action user interface,
                  create-send/reply/forward now pops-up in it's own window,
                  yahMAIL "logout" button (for WASD environments),
                  os_newtypedfile() provides text field for content-type,
                  modification to [.MUNPACK]DECODE.C to support MIME filenames
                    specified over multiple lines,
                  redirect to place attachment file name into path to provide
                    default file name with browser [save-as] dialog
                  bugfix; small number for CSWS (Apache) idiosyncracies
                  bugfix; reply-to in [reply] and [forward]
23-MAR-2003  DM   v1.8.b1, (munroe@csworks.com)
                  I don't like the user interface that requires the user to
                  manually return from things like deleting messages, etc.
                  A new logical name, YAHMAIL$DIRECT, alternatively the
                  [direct] configuration directive, or the private setup
                  turns the interface on.
                  If set and a request for some action has only one place to
                  return to, the UI will go there directly without stopping
                  for user confirmation on success.  Error reporting paths
                  have remained untouched.
20-MAR-2003  MGD  v1.7.1, remove the tilde character from cookie assignments
                  (Mozilla 1.0-1.3 at least cannot handle /~ in cookies)
03-MAR-2003  MGD  v1.7.0, reply-to (for MultiNet, MX, PMDF, TCPIP, TCPWARE)
                          [replyuseRFC822] new configuration directive (uses
                          RFC822 "Reply-To:" then "From:" as reply destination)
11-SEP-2002  MGD  v1.6.4, bugfix; CGILIB response 'charset=' processing
15-JUN-2002  MGD  v1.6.3, configurable ISO header and quoted-printable body
02-MAY-2002  MGD  v1.6.2, quoted-printable encoding
22-APR-2002  MGD  v1.6.1, CGILIB changes to support CSWS 1.2
13-APR-2002  MGD  v1.6.0, allow for an un-wrapped OSU yahMAIL,
                  provide RFC1522 encoded-words in message header,
                  provide quoted-printable decoding where appropriate,
                  bugfix; refinements for (correct) multi-language support
16-FEB-2002  MGD  v1.5.3, StripTransport() from addresses,
                  bugfixes; small bunch (thanks to Carl Karcher of WISC)
10-FEB-2002  MGD  v1.5.2, MAIL$MESSAGE_GET() item MAIL$_MESSAGE_RECORD from
                  a documented 255 characters to an empirical 2048 for later
                  versions of VMS (though exactly which is a bit of a mystery)
23-JAN-2002  MGD  V1.5.1, bugfix; SendMailMessage() inserted mail transport
18-JAN-2001  MGD  v1.5.0, use CGILIB suitable for CSWS V1.0-1 (Apache),
                  [localtosmtp] VMS username delivered via SMTP agent,
                  MSIE 5.n when <-back to a POSTed page requires refresh -
                  change "CREATE-SEND" from POST to GET using setMethodGET(),
                  private setup 'LongLineWrap' to set 'WrapLongLines',
                  bugfix; 'WrapLongLines' in PRIVATE.C
03-OCT-2000  MGD  v1.4.0, use CGILIB object module,
                  RELAXED_ANSI compilation
17-AUG-2000  MGD  v1.3.2, bugfix; PmdfWriteHeader() in SENDMSG.C
14-JUN-2000  MGD  v1.3.1, JavaScript alert() and confirm() for missing
                  requirements when creating and sending message
03-MAY-2000  MGD  v1.3.0, final release,
                  include Apache (1.3.9 BETA) support in CGILIB,
                  allow for non-WASTEBASKET wastebasket name
09-APR-2000  MGD  v1.3.B3, change report error/success reporting
02-APR-2000  MGD  v1.3.B2, reorganize code,
                  add PMDF support for MIME attachments,
                  add MIME upload VMS callable mail kludge,
                  bugfix; DELETE! button deletes message
                  (and consequently also purges wastebasket)
27-JAN-2000  MGD  v1.2.0, added "check/uncheck all" checkbox,
                  bugfix; private setup not propagated in
                  BuildPrivateQueryString()
                  (hmmm, source code's becoming a bit of a monster)
22-DEC-1999  MGD  v1.1.0, private browse setup,
                  standard Mail and "user" folder buttons,
                  copy-to-self from profile now sets checkbox
22-NOV-1999  MGD  v1.0.2, bugfix; revise signature file from 6.2 to 7.0
07-NOV-1999  MGD  v1.0.1, bugfix; MakeAnchors only if isdigit()
31-OCT-1999  MGD  v1.0.0, final non-BETA release
26-SEP-1999  MGD  v1.0.B4, NEWMAIL "biff" (and bugfix),
                  optional auto-wrap on mail-create <TEXTAREA>s,
                  additions to LANG_EN.C
16-SEP-1999  MGD  v1.0.B3, add lang_Response...,
                  [PublicHeader] and [PublicFooter] configuration,
                  replace 302 redirect for MIME with
                  "Content-Disposition: filename="
21-AUG-1999  MGD  v1.0.B2, separate language module,
                  signature file update
22-JUN-1999  MGD  v1.0.B1, initial development
*/

/*****************************************************************************/

#define SOFTWAREVN "1.8.0"
#define SOFTWARENM "YAHMAIL"
#ifdef __ALPHA
#  define SOFTWAREID SOFTWARENM " AXP-" SOFTWAREVN
#endif
#ifdef __ia64
#  define SOFTWAREID SOFTWARENM " IA64-" SOFTWAREVN
#endif
#ifdef __VAX
#  define SOFTWAREID SOFTWARENM " VAX-" SOFTWAREVN
#endif

#ifdef YAHMAIL_MUNPACK
#   define SOFTWAREID_MIME " (MIME)"
#else
#   define SOFTWAREID_MIME ""
#endif

#ifndef __VAX
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* VMS related header files */
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

/* application specific */
#include "yahmail.h"
#include "regex.h"

#define FI_LI __FILE__, __LINE__

/**************************/
/* general global storage */
/**************************/

char  Utility [] = "YAHMAIL";

boolean  CliMimeNoSubjectKludge,
         CliMimeSubjectKludge,
         CliNoPMDF,
         CliPostMasterEnabled,
	 ConfigDirectActionUI,
         ConfigPrivate,
         ConfigPublic,
         ConfigPublicBrowseFolders,
         ConfigReplyParenRfc822,
         ConfigReplyQuoteRfc822,
         ConfigReplyUseRfc822,
         Debug,
         DoAddrListEdit,
         DoAddrListRemove,
         DoAddrListSelect,
         DoAddrListUpdate,
         DoDisplaySpam,
         DoFolderBrowse,
         DoMessageCopy,
         DoMessageCreate,
         DoMessageDelete,
         DoMessageEmptyWasteBasket,
         DoMessageForward,
         DoMessageMove,
         DoMessageRead,
         DoMessageReadMunpack,
         DoMessageReadOctetStream,
         DoMessageReadPlainText,
         DoMessageReply,
         DoMessageSend,
         DoNotDisplaySpam,
         DoSpamNotFrom,
         DoSpamUndoNotFrom,
         DoSigFileAccess,
         DoSigFileUpdate,
         DoPersonalSetupEdit,
         DoPersonalSetupSave,
         DoPersonalSetupUpdate,
         DoUserCreate,
         DoUserDelete,
         DoUserList,
         DoUserProfile,
         DoUserSet,
         IsCgiPlus,
         MailProtocolIsPMDF,
         MimeAttachmentSubjectKludge,
         MimeQuotedPrintable,
         OsuEnvironment,
         PostMasterAuthenticated,
         PersonalSetupLoad,
         PersonalSetupHide,
         PersonalSetupShow,
         StdCgiEnvironment;

int  AttachmentMunNumber,
     BrowsePage,
     BrowseWindow,
     CgiPlusUsageCount,
     CheckNewMailMinutes,
     ListMailFiles,
     CurrentMessageCount,
     HideSpam,
     LongLineWrap,
     LooksLikeSpamCount,
     MakeAnchors,
     MessageIncrement,
     PublicConfigSubjCount,
     PublicConfigSubjLength,
     VmsVersion,
     WrapAt,
     WrapLongLines;

char  TildeChar;

char  *AttachmentFileNamePtr,
      *CliConfigFilePtr = DEFAULT_CONFIG_FILE_NAME,
      *CgiAuthRealmPtr,
      *CgiEnvironmentPtr,
      *CgiFormActionPtr,
      *CgiFormBwcPtr,
      *CgiFormBwfPtr,
      *CgiFormBwmPtr,
      *CgiFormBwpPtr,
      *CgiFormBwuPtr,
      *CgiFormDuiPtr,
      *CgiFormEncPtr,
      *CgiFormFileNamePtr,
      *CgiFormFolderNamePtr,
      *CgiFormIncludePtr,
      *CgiFormMunpackContentTypePtr,
      *CgiFormMunpackPtr,
      *CgiFormNnnPtr,
      *CgiFormPreEditedMessagePtr,
      *CgiFormQuotePtr,
      *CgiFormRefreshPtr,
      *CgiFormSpamPtr,
      *CgiFormTarPtr,
      *CgiFormRtoPtr,
      *CgiHttpCookiePtr,
      *CgiHttpHostPtr,
      *CgiHttpUserAgentPtr,
      *CgiRemoteUserPtr,
      *CgiRequestSchemePtr,
      *CgiServerNamePtr,
      *CgiServerPortPtr,
      *CgiServerSoftwarePtr,
      *CgiPathInfoPtr,
      *CgiQueryStringPtr,
      *CgiRemoteUserPtr,
      *CgiRequestMethodPtr,
      *CgiScriptNamePtr,
      *CgiTypePtr,
      *CliCharsetPtr = lang_Charset,
      *CliEncodingPtr,
      *ConfigAddrListPtr,
      *ConfigBodyTagPtr,
      *ConfigCharsetPtr,
      *ConfigCreateFooterPtr,
      *ConfigEncodingPtr,
      *ConfigFolderFooterPtr,
      *ConfigFolderHeaderPtr,
      *ConfigAddrListFooterPtr,
      *ConfigVMSmailFooterPtr, 
      *ConfigLocalToSmtpPtr,
      *ConfigNewMailPtr,
      *ConfigPublicFooterPtr,
      *ConfigPublicHeaderPtr,
      *ConfigReadFooterPtr,
      *ConfigSmtpTransportPtr,
      *PostMasterWarningPtr,
      *PublicConfigSubjPtr,
      *PublicHeaderPtr,
      *PublicFooterPtr,
      *PublicTitlePtr;

char  ActionPathInfo [256],
      ActionQueryString [512],
      SchemeHostPort [256],
      SoftwareID [64];

char  PathPart [5][128];

/*******************************************/
/* global storage, information to VMS mail */
/*******************************************/

unsigned long  CopyFolderNameLength,
               MailFileContext,
               MailFileContext,
               MailFileMessagesDeleted,
               MailFileNameLength,
               MailFolderNameLength,
               MailSubstringCcLength,
               MailSubstringFromLength,
               MailSubstringSubjLength,
               MailSubstringToLength,
               MailUserNameLength,
               UserContext;

/* size of array for keeping message IDs supplied as checkbox selections */
#define MAX_MESSAGE_ID 64
int  MailMessageIdCount;
unsigned long  MailMessageId [MAX_MESSAGE_ID+1];
char *MailMessageIdSpamList [MAX_MESSAGE_ID+1];

char  CopyFolderName [256],
      HtmlEscapedMailFolderName [256],
      MailFileName [256],
      MailFolderName [256],
      MailSubstringCc [256],
      MailSubstringFrom [256],
      MailSubstringSubj [256],
      MailSubstringTo [256],
      MailUserName [256],
      PublicFileName [256],
      PublicFolderName [256],
      PublicUserName [256];

int  SizeOfHtmlEscapedMailFolderName = sizeof(HtmlEscapedMailFolderName),
     SizeOfMailFileName = sizeof(MailFileName),
     SizeOfMailFolderName = sizeof(MailFolderName),
     SizeOfMailUserName = sizeof(MailUserName),
     SizeOfPublicUserName = sizeof(PublicUserName);

/*********************************************/
/* global storage, information from VMS mail */
/*********************************************/

int  VmsMailHeaderLength,
     VmsMailRfc822HeaderLength,
     VmsMailRfc822MimeVersion;

unsigned long  VmsMailCcLength,
               VmsMailDateLength,
               VmsMailExtIdLength,
               VmsMailFromLength,
               VmsMailFolderLength,
               VmsMailMessageFlags,
               VmsMailMessageId,
               VmsMailMessageSize,
               VmsMailMessageSelectedCount,
               VmsMailRfc822FromLength,
               VmsMailRfc822ReplyToLength,
               VmsMailSenderLength,
               VmsMailSigFileTextLength,
               VmsMailSubjectLength,
               VmsMailTextLength,
               VmsMailTextSize,
               VmsMailToLength,
               VmsMailUserEditorLength,
               VmsMailUserFormLength,
               VmsMailUserForwardingLength,
               VmsMailUserFullDirectoryLength,
               VmsMailUserNewMessages,
               VmsMailUserPersonalNameLength,
               VmsMailUserQueueLength,
               VmsMailUserSigFileLength,
               VmsMailUserAutoPurge,
               VmsMailUserCcPrompt,
               VmsMailUserCopyForward,
               VmsMailUserCopyReply,
               VmsMailUserCopySend,
               VmsMailWasteBasketNameLength;

unsigned long  VmsMailBinaryDate [2];

char  *VmsMailTextPtr,
      *VmsMailSigFileTextPtr;

char  VmsMailTo [256],
      VmsMailCc [256],
      VmsMailDate [256],
      VmsMailExtId [256],
      VmsMailFrom [256],
      VmsMailFolder [256],
      VmsMailRfc822From [256],
      VmsMailRfc822MimeCharset [256],
      VmsMailRfc822MimeContTransEnc [256],
      VmsMailRfc822MimeContentType [256],
      VmsMailRfc822ReplyTo [256],
      VmsMailSender [256],
      VmsMailSubject [256],
      VmsMailUserEditor [256],
      VmsMailUserForm [256],
      VmsMailUserFullDirectory [256],
      VmsMailUserForwarding [256],
      VmsMailUserPersonalName [256],
      VmsMailUserQueue [256],
      VmsMailUserSigFile [256],
      VmsMailWasteBasketName [256];

int   SizeOfVmsMailRfc822From = sizeof(VmsMailRfc822From),
      SizeOfVmsMailRfc822ReplyTo = sizeof(VmsMailRfc822ReplyTo);

int  FolderListCount;
struct FolderListStruct  *FolderListHeadPtr,
                         *FolderListTailPtr;

int  MessageListCount;
struct MessageListStruct  *MessageListHeadPtr,
                          *MessageListTailPtr;

int  UserListCount;
struct UserListStruct  *UserListHeadPtr,
                       *UserListTailPtr;

struct VmsItemStruct  NullItem = {0,0,0,0};

/* declared in SendMsg() */
extern boolean  CompilationIncludesPMDF;

/*****************************************************************************/
/*
*/

main (int argc, char* argv[])
       
{
   int  status;

   /*********/
   /* begin */
   /*********/

   sprintf (SoftwareID, "%s%s%s (%s)",
            SOFTWAREID, SOFTWAREID_MIME,
            CompilationIncludesPMDF ? " (PMDF)" : "",
            CgiLibEnvironmentVersion());

   if (getenv ("YAHMAIL$DBUG") != NULL) Debug = true;
   CgiLibEnvironmentSetDebug (Debug);
   if (Debug) fprintf (stdout, "Content-Type: text/plain\n\n");

   /* set if action request go directly to their result on success */
   ConfigDirectActionUI = (getenv("YAHMAIL$DIRECT") != NULL);

   CgiLibEnvironmentInit (argc, argv, false);

   GetParameters (argc, argv);

   CgiLibResponseSetSoftwareID (SoftwareID);
   CgiLibResponseSetErrorTitle (lang_ResponseErrorTitle);
   CgiLibResponseSetErrorMessage (lang_ResponseErrorMessage);
   CgiLibResponseSetSuccessTitle (lang_ResponseSuccessTitle);
   CgiLibResponseSetSuccessMessage (lang_ResponseSuccessMessage);

   VmsVersion = GetVmsVersion ();

   IsCgiPlus = CgiLibEnvironmentIsCgiPlus ();

#ifdef YAHMAIL_MUNPACK
   if (IsCgiPlus)
   {
      /*
         I suspect the current MUNPACK used for decoding MIME messages
         wouldn't be designed for reuse and therefore shouldn't be!
      */
      CgiLibResponseError (FI_LI, 0, lang_ErrCgiPlusMunpack);
      exit (SS$_NORMAL);
   }
#endif /* YAHMAIL_MUNPACK */

   if (IsCgiPlus)
   {
      for (;;)
      {
         /* block waiting for the next request */
         CgiLibVar ("");
         ProcessRequest ();
         CgiLibCgiPlusEOF ();
      }
   }
   else
      ProcessRequest ();
}

/*****************************************************************************/
/*
Get "command-line" parameters, whether from the command-line or from a
configuration symbol or logical containing the equivalent.
*/

GetParameters
(
int argc,
char *argv[]
)
{
   static char  CommandLine [256];
   static unsigned long  Flags = 0;

   int  status,
        SkipParameters;
   unsigned short  Length;
   char  ch;
   char  *aptr, *cptr, *clptr, *sptr;
   $DESCRIPTOR (CommandLineDsc, CommandLine);

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetParameters()\n");

   if ((clptr = getenv ("YAHMAIL$PARAM")) == NULL)
   {
      /* get the entire command line following the verb */
      if (VMSnok (status =
          lib$get_foreign (&CommandLineDsc, 0, &Length, &Flags)))
         exit (status);
      (clptr = CommandLine)[Length] = '\0';
   }

   /* if OSU environment then skip P1, P2, P3 */
   if (getenv ("WWWEXEC_RUNDOWN_STRING") != NULL)
      SkipParameters = 3;
   else
      SkipParameters = 0;

   aptr = NULL;
   ch = *clptr;
   for (;;)
   {
      if (aptr != NULL && *aptr == '/') *aptr = '\0';
      if (!ch) break;

      *clptr = ch;
      if (Debug) fprintf (stdout, "clptr |%s|\n", clptr);
      while (*clptr && isspace(*clptr)) *clptr++ = '\0';
      aptr = clptr;
      if (*clptr == '/') clptr++;
      while (*clptr && !isspace (*clptr) && *clptr != '/')
      {
         if (*clptr != '\"')
         {
            clptr++;
            continue;
         }
         cptr = clptr;
         clptr++;
         while (*clptr)
         {
            if (*clptr == '\"')
               if (*(clptr+1) == '\"')
                  clptr++;
               else
                  break;
            *cptr++ = *clptr++;
         }
         *cptr = '\0';
         if (*clptr) clptr++;
      }
      ch = *clptr;
      if (*clptr) *clptr = '\0';
      if (Debug) fprintf (stdout, "aptr |%s|\n", aptr);
      if (!*aptr) continue;

      if (SkipParameters)
      {
         SkipParameters--;
         continue;
      }

      /***********/
      /* process */
      /***********/

      if (strsame (aptr, "/CONFIG=", 4))
      {
         for (cptr = aptr; *cptr && *cptr != '='; cptr++);
         if (!*cptr) continue;
         CliConfigFilePtr = cptr+1;
         continue;
      }

      if (strsame (aptr, "/CHARSET=", 4))
      {
         for (cptr = aptr; *cptr && *cptr != '='; cptr++);
         if (!*cptr) continue;
         CliCharsetPtr = cptr+1;
         continue;
      }

      if (strsame (aptr, "/DBUG", -1))
      {
         Debug = true;
         continue;
      }

      if (strsame (aptr, "/ENCODING=", 4))
      {
         for (cptr = aptr; *cptr && *cptr != '='; cptr++);
         if (!*cptr) continue;
         CliEncodingPtr = cptr+1;
         continue;
      }

      if (strsame (aptr, "/MIMEKLUDGE", 6))
      {
         CliMimeSubjectKludge = true;
         CliMimeNoSubjectKludge = false;
         continue;
      }
      if (strsame (aptr, "/NOMIMEKLUDGE", 8))
      {
         CliMimeSubjectKludge = false;
         CliMimeNoSubjectKludge = true;
         continue;
      }

      if (CompilationIncludesPMDF && strsame (aptr, "/NOPMDF", 7))
      {
         CliNoPMDF = true;
         continue;
      }

      if (strsame (aptr, "/POSTMASTER", 5))
      {
#if YAHMAIL_POSTMASTER
         CliPostMasterEnabled = true;
         continue;
#else
         fprintf (stdout, "%%%s-E-BUILD, build does not support POSTMASTER\n",
                  Utility);
         exit (STS$K_ERROR | STS$M_INHIB_MSG);
#endif
      }

      if (*aptr == '/')
      {
         fprintf (stdout, "%%%s-E-IVQUAL, unrecognized qualifier\n \\%s\\\n",
                  Utility, aptr+1);
         exit (STS$K_ERROR | STS$M_INHIB_MSG);
      }

      fprintf (stdout, "%%%s-E-MAXPARM, too many parameters\n \\%s\\\n",
               Utility, aptr);
      exit (STS$K_ERROR | STS$M_INHIB_MSG);
   }
}

/*****************************************************************************/
/*
*/

ProcessRequest ()
       
{
   int  idx,
        status,
        PostBufferCount;
   char  *cptr, *sptr, *zptr,
         *PostBufferPtr;
   char  Scratch [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessRequest()\n");

   CgiEnvironmentPtr = CgiLibEnvironmentName ();

   DoAddrListEdit = DoAddrListRemove = DoAddrListSelect =
      DoAddrListUpdate = DoMessageEmptyWasteBasket = DoFolderBrowse =
      DoMessageDelete = DoMessageMove = DoMessageSend = DoMessageRead =
      DoMessageReadOctetStream = DoMessageReadPlainText =
      DoMessageForward = DoMessageReply = DoMessageCopy = DoMessageCreate =
      DoSigFileAccess = DoSigFileUpdate =
      DoPersonalSetupEdit = DoPersonalSetupSave = DoPersonalSetupUpdate =
      DoSpamNotFrom = DoSpamUndoNotFrom =
      DoUserCreate = DoUserList =
      DoUserProfile = DoUserSet =
      DoDisplaySpam = DoNotDisplaySpam =
      PersonalSetupLoad =  PersonalSetupHide = PersonalSetupShow = false;

   BrowsePage = CheckNewMailMinutes = MessageIncrement =
      VmsMailSigFileTextLength = 0;

   if (VmsMailTextPtr != NULL) free (VmsMailTextPtr);
   if (VmsMailSigFileTextPtr != NULL) free (VmsMailSigFileTextPtr);
   VmsMailTextPtr = VmsMailSigFileTextPtr = NULL;

   CurrentMessageCount = -1;

   cptr = CgiPathInfoPtr = CgiLibVar ("WWW_PATH_INFO");

   /* parse the first (up to) five slash-delimited sections of the path */
   for (idx = 0; idx < 5; idx++)
   {
      if (*cptr) cptr++;
      zptr = (sptr = PathPart[idx]) + sizeof(PathPart[idx]);
      while (*cptr && *cptr != '/' && sptr < zptr) *sptr++ = *cptr++;
      if (sptr >= zptr) exit (SS$_RESULTOVF);
      *sptr = '\0';
   }
   if (Debug)
      fprintf (stdout, "PathPart |%s|%s|%s|%s|%s|\n",
          PathPart[0], PathPart[1], PathPart[2], PathPart[3], PathPart[4]);

   /* accomodate local mapping requirements for the tilde character */
   if (PathPart[0][0] && !isalnum(PathPart[0][0]))
      TildeChar = PathPart[0][0];
   else
      TildeChar = '~';

   if (PathPart[0][1] == TildeChar)
   {
      /*
         break current authentication
         (allows new username/password to be supplied)
      */
      CgiLibResponseHeader (401, "text/html",
                            "Basic realm=\"yahMAIL cancel\"");
      fputs ("Current authentication cancelled!\n", stdout);
      return;
   }

   CgiRemoteUserPtr = CgiLibVar("WWW_REMOTE_USER");
   CgiAuthRealmPtr = CgiLibVar("WWW_AUTH_REALM");

   GlobalConfigFileLoad ();

   /* obviously these must be set after the configuration has been processed */
   CgiLibResponseSetBody (ConfigBodyTagPtr);
   CgiLibResponseSetCharset (ConfigCharsetPtr);

   if (!(ConfigPrivate || ConfigPublic))
   {
      /***********************/
      /* access is forbidden */
      /***********************/

      CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
      return;
   }

   /*********************/
   /* access is allowed */
   /*********************/

   if (ConfigCharsetPtr == NULL) ConfigCharsetPtr = CliCharsetPtr;

   CgiHttpUserAgentPtr = CgiLibVar ("WWW_HTTP_USER_AGENT");
   CgiScriptNamePtr = CgiLibVar ("WWW_SCRIPT_NAME");
   CgiRequestMethodPtr = CgiLibVar ("WWW_REQUEST_METHOD");

   /********************/
   /* path information */
   /********************/

   /*
       Legitimate path information elements:
       /~/                           (open NEWMAIL folder)
       /~/folder/                    (open folder)
       /~/file/folder/               (open folder found in file)
       /~/999                        (get item from NEWMAIL folder)
       /~/999/file.name              (redirected to have filename in path)
       /~/folder/999                 (get item from folder)
       /~/folder/999/file.name       (redirected to have filename in path)
       /~/file/folder/999            (get item from folder found in file)
       /~/file/folder/999/file.name  (redirected to have filename in path)
       /name/                        (public mail file)
       /name/999                     (get item from NEWMAIL in public file)
       /name/999/file.name           (redirected to have filename in path)
       /name/folder/                 (open folder found in public file)
       /name/folder/999              (get item from folder in public file)
       /name/folder/999/file.name    (redirected to have filename in path)
   */

   if (PathPart[0][0])
   {
      if (ConfigPrivate)
      {
         if (PathPart[0][0] != TildeChar)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
            return;
         }
         /* only the postmaster can specify who they want to be! */
         if (!PostMasterAuthenticated &&
             PathPart[0][1] &&
             !strsame (MailUserName, PathPart[0]+1, -1))
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
            return;
         }
         if (PostMasterAuthenticated && PathPart[0][1])
         {
            sptr = MailUserName;
            for (cptr = PathPart[0]+1; *cptr; *sptr++ = toupper(*cptr++));
            *sptr = '\0';
         }
         if (PathPart[0][1])
            PersonalSetupHide = true;
         else
            PersonalSetupShow = true;
      }
      else
      if (PathPart[0][0] == TildeChar)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
         return;
      }
   }

   AttachmentFileNamePtr = "";
   if (isinteger(PathPart[1]))
   {
      /* message ID follows username/archive (implies it's from NEWMAIL) */
      MailMessageId[0] = atoi(PathPart[1]);
      AttachmentFileNamePtr = PathPart[2];
   }
   else
   if (PathPart[1][0] && (!PathPart[2][0] || isinteger(PathPart[2])))
   {
      /* folder name follows username/archive */
      strzcpy (MailFolderName, PathPart[1], sizeof(MailFolderName));
      /* if a message ID follows the folder name */
      if (isinteger(PathPart[2])) MailMessageId[0] = atoi(PathPart[2]);
      AttachmentFileNamePtr = PathPart[3];
   }
   else
   if (PathPart[1][0] && PathPart[2][0] && !isinteger(PathPart[2]))
   {
      strzcpy (MailFileName, PathPart[1], sizeof(MailFileName));
      strzcpy (MailFolderName, PathPart[2], sizeof(MailFolderName));
      if (isinteger(PathPart[3])) MailMessageId[0] = atoi(PathPart[3]);
      AttachmentFileNamePtr = PathPart[4];
   }

   if (!strcmp (CgiRequestMethodPtr, "POST"))
   {
      /***************/
      /* POST method */
      /***************/

      /* read and create the CGI variable equivalents of the body fields */
      CgiLibReadRequestBody (&PostBufferPtr, &PostBufferCount);
      if (PostBufferPtr == NULL ||
          PostBufferCount == 0)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
         return;
      }
      CgiLibFormRequestBody (PostBufferPtr, PostBufferCount);
      free (PostBufferPtr);
      if (Debug)
         while ((cptr = CgiLibVarNull ("*")) != NULL)
            fprintf (stdout, "|%s|\n", cptr);
   }
   else
   {
      /**************/
      /* GET method */
      /**************/

      /* if not GET method */
      if (strcmp (CgiRequestMethodPtr, "GET"))
      {
         CgiLibResponseHeader (501, "text/html");
         return;
      }
   }

   /****************/
   /* query string */
   /****************/

   /* need this here in case it's a [next] or [previous] */
   cptr = CgiLibVar ("WWW_FORM_CMC");
   if (isdigit(*cptr)) CurrentMessageCount = atoi(cptr);
   if (Debug) fprintf (stdout, "CMC: %d\n", CurrentMessageCount);
   CgiFormActionPtr = CgiLibVar ("WWW_KEY_1");
   if (!CgiFormActionPtr[0])
      CgiFormActionPtr = CgiLibVar ("WWW_FORM_ACT");
   CgiLibHtmlDeEntify (CgiFormActionPtr);

   CgiFormNnnPtr = CgiLibVar ("WWW_FORM_NNN");

   cptr = CgiLibVar ("WWW_FORM_WINDOW");
   if (!cptr[0]) cptr = CgiLibVar ("WWW_FORM_WIN");
   if (isdigit(*cptr))
   {
      BrowseWindow = atoi(cptr);
      if (BrowseWindow <= 0 || BrowseWindow > 999)
         BrowseWindow = DEFAULT_BROWSE_WINDOW;
   }

   cptr = CgiLibVar ("WWW_FORM_PAG");
   if (isdigit(*cptr)) BrowsePage = atoi(cptr);
   if (!BrowsePage) BrowsePage = 1;

   cptr = CgiLibVar ("WWW_FORM_NEWMAIL");
   if (!cptr[0]) cptr = CgiLibVar ("WWW_FORM_CNM");
   if (isdigit(*cptr)) CheckNewMailMinutes = atoi(cptr);

   cptr = CgiLibVar ("WWW_FORM_ANCHOR");
   if (!cptr[0]) cptr = CgiLibVar ("WWW_FORM_ANC");
   if (isdigit(*cptr)) MakeAnchors = atoi(cptr);

   cptr = CgiLibVar ("WWW_FORM_WRAP");
   if (!cptr[0]) cptr = CgiLibVar ("WWW_FORM_WRA");
   if (!cptr[0])
      WrapAt = 72;
   else
      WrapAt = atoi(cptr);
   /* let's keep it within the bounds of reason! */
   if (WrapAt && (WrapAt < 48 || WrapAt > 255)) WrapAt = 72;

   /* LLW is the private setup of message read WLL */
   LongLineWrap = 0;
   cptr = CgiLibVar("WWW_FORM_LLW");
   if (cptr[0]) LongLineWrap = atoi(cptr);
   /* let's keep it within the bounds of reason! */
   if (LongLineWrap && (LongLineWrap < 48 || LongLineWrap > 255))
      LongLineWrap = 72;

   /* when reading a message automatically wrap long lines */
   WrapLongLines = 0;
   cptr = CgiLibVar("WWW_FORM_WLL");
   if (cptr[0]) WrapLongLines = atoi(cptr);
   /* let's keep it within the bounds of reason! */
   if (WrapLongLines && (WrapLongLines < 48 || WrapLongLines > 255))
   {
      if (LongLineWrap)
         WrapLongLines = LongLineWrap;
      else
         WrapLongLines = 72;
   }
   if (LongLineWrap && !WrapLongLines) WrapLongLines = LongLineWrap;

   cptr = CgiLibVar ("WWW_FORM_PCC");
   MailSubstringCcLength =
      strzcpy (MailSubstringCc, cptr, sizeof(MailSubstringCc));

   cptr = CgiLibVar ("WWW_FORM_PFR");
   MailSubstringFromLength =
      strzcpy (MailSubstringFrom, cptr, sizeof(MailSubstringFrom));

   cptr = CgiLibVar ("WWW_FORM_PSU");
   MailSubstringSubjLength =
      strzcpy (MailSubstringSubj, cptr, sizeof(MailSubstringSubj));

   cptr = CgiLibVar ("WWW_FORM_PTO");
   MailSubstringToLength =
      strzcpy (MailSubstringTo, cptr, sizeof(MailSubstringTo));

#if YAHMAIL_PRIVATE
   if (ConfigPrivate)
   {
      EnableAccess (1);
      status = MailGetUserInfo ();
      EnableAccess (0);
      if (Debug) fprintf (stdout, "MailGetUserInfo() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrGetUserInfo);
         return;
      }

      if (strsame (CgiFormActionPtr, lang_BtnPersonalSetupLoad, -1))
         PersonalSetupLoad = true;
      else
         PersonalSetupLoad = false;

      EnableAccess (1);
      if (PersonalSetupLoad)
      {
         /* a button was pressed saying reload private config */
         PersonalSetupFileLoad ();
      }
      else
      {
         /* if there is no path information in the request */
         if (PathPart[0][1])
            PersonalSetupFromCgi ();
         else
         {
            status = PersonalSetupFileLoad ();
            if (VMSnok (status))
            {
               PersonalSetupShow = true;
               PersonalSetupHide = false;
            }
         }
      }
      EnableAccess (0);
   }
#endif

#ifdef YAHMAIL_MUNPACK

   for (AttachmentMunNumber = 1;
        AttachmentMunNumber <= YAHMAIL_MUN_MAX;
        AttachmentMunNumber++)
   {
      sprintf (Scratch, "WWW_FORM_MUN%d", AttachmentMunNumber);
      CgiFormMunpackPtr = CgiLibVar (Scratch);
      if (CgiFormMunpackPtr[0]) break;
   }
   if (CgiFormMunpackPtr[0])
   {
      /* unpack a MIME attachment */
      DoMessageRead = DoMessageReadMunpack = true;
   }
   else

#endif /* YAHMAIL_MUNPACK */

   if (CgiFormActionPtr[0])
   {
      /*****************/
      /* action button */
      /*****************/

      CgiFormFileNamePtr = CgiLibVar ("WWW_FORM_MAI");
      if (*CgiFormFileNamePtr)
      {
         strzcpy (MailFileName, CgiFormFileNamePtr, sizeof(MailFileName));
         if (Debug) fprintf (stdout, "WWW_FORM_MAI |%s|\n", MailFileName);
      }

      /* first check the text entry field, then if none the selection box */
      CgiFormFolderNamePtr = CgiLibVar ("WWW_FORM_FTE");
      if (!CgiFormFolderNamePtr[0])
         CgiFormFolderNamePtr = CgiLibVar ("WWW_FORM_FSE");
      CgiLibHtmlDeEntify (CgiFormFolderNamePtr);

      if (strsame (CgiFormActionPtr, lang_BtnOpen, -1) ||
          strsame (CgiFormActionPtr, lang_BtnMailFiles, -1) ||
          strsame (CgiFormActionPtr, lang_BtnPersonalSetupLoad, -1) ||
          strsame (CgiFormActionPtr, lang_BtnSetupShow, -1) ||
          strsame (CgiFormActionPtr, lang_BtnSetupHide, -1))
      {
         DoFolderBrowse = true;
         /* only authenticated request are allowed to specify the folder */
         if (ConfigPrivate)
         {
            if (!CgiFormFolderNamePtr[0])
            {
               CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
               return;
            }
            strzcpy (MailFolderName,
                     CgiFormFolderNamePtr,
                     sizeof(MailFolderName));
         }
         if (HideSpam && !strcmp (MailFolderName, "NEWMAIL"))
            DoNotDisplaySpam = true;
         if (strsame (CgiFormActionPtr, lang_BtnMailFiles, -1))
            ListMailFiles = true;
         if (strsame (CgiFormActionPtr, lang_BtnPersonalSetupLoad, -1))
            PersonalSetupLoad = true;
         if (strsame (CgiFormActionPtr, lang_BtnSetupShow, -1))
            PersonalSetupShow = true;
         if (strsame (CgiFormActionPtr, lang_BtnSetupHide, -1))
            PersonalSetupHide = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnToNewMail, -1) ||
          strsame (CgiFormActionPtr, "NEWMAIL", -1))
      {
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
         {
            DoMessageMove = true;
            strcpy (CopyFolderName, "NEWMAIL");
         }
         else
         {
            DoFolderBrowse = true;
            strcpy (MailFolderName, "NEWMAIL");
         }
         if (HideSpam) DoNotDisplaySpam = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnHideSpam, -1))
      {
         strcpy (MailFolderName, "NEWMAIL");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
            DoMessageMove = true;
         else
            DoFolderBrowse = true;
         if (HideSpam) DoNotDisplaySpam = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnViewSpam, -1) ||
          /* this second test allows for "(view SPAM)" */
          strsame (CgiFormActionPtr+1,
                   lang_BtnViewSpam,
                   strlen(lang_BtnViewSpam)))
      {
         strcpy (MailFolderName, "NEWMAIL");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
            DoMessageMove = true;
         else
            DoFolderBrowse = true;
         if (HideSpam) DoDisplaySpam = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnUndoNotSpam, -1))
      {
         strcpy (MailFolderName, "NEWMAIL");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
            DoSpamUndoNotFrom = true;
         else
            DoFolderBrowse = true;
         if (HideSpam) DoNotDisplaySpam = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnNotSpam, -1))
      {
         strcpy (MailFolderName, "NEWMAIL");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
            DoSpamNotFrom = true;
         else
            DoFolderBrowse = true;
         if (HideSpam) DoDisplaySpam = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnToMail, -1))
      {
         strcpy (MailFolderName, "MAIL");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
         {
            DoMessageMove = true;
            strcpy (CopyFolderName, "MAIL");
         }
         else
         {
            DoFolderBrowse = true;
            strcpy (MailFolderName, "MAIL");
         }
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnToSent, -1))
      {
         strcpy (MailFolderName, "SENT");
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
         {
            DoMessageMove = true;
            strcpy (CopyFolderName, "SENT");
         }
         else
         {
            DoFolderBrowse = true;
            strcpy (MailFolderName, "SENT");
         }
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnToWasteBasket, -1))
      {
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
         {
            strzcpy (CopyFolderName,
                     lang_BtnToWasteBasket,
                     sizeof(CopyFolderName));
            DoMessageMove = true;
         }
         else
         {
            strzcpy (MailFolderName,
                     lang_BtnToWasteBasket,
                     sizeof(MailFolderName));
            DoFolderBrowse = true;
         }
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnEmptyWasteBasket, -1))
         DoMessageEmptyWasteBasket = true;
      else
      if (CgiFormActionPtr[0] == '\"')
      {
         ProcessRequestIdNumbers ();
         if (MailMessageIdCount)
         {
            zptr = (sptr = CopyFolderName) + sizeof(CopyFolderName)-1;
            for (cptr = CgiFormActionPtr+1;
                 *cptr && *cptr != '\"' && sptr < zptr;
                 *sptr++ = *cptr++);
            *sptr = '\0';
            DoMessageMove = true;
         }
         else
         {
            zptr = (sptr = MailFolderName) + sizeof(MailFolderName)-1;
            for (cptr = CgiFormActionPtr+1;
                 *cptr && *cptr != '\"' && sptr < zptr;
                 *sptr++ = *cptr++);
            *sptr = '\0';
            DoFolderBrowse = true;
         }
      }
      else
      if ((DoMessageCopy = strsame (CgiFormActionPtr, lang_BtnCopy, -1)) ||
          (DoMessageMove = strsame (CgiFormActionPtr, lang_BtnMove, -1)))
      {
         ProcessRequestIdNumbers ();
         if (!MailMessageIdCount)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrMessageNotSelected);
            return;
         }
         if (!CgiFormFolderNamePtr[0])
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
            return;
         }
         strzcpy (CopyFolderName,
                  CgiFormFolderNamePtr,
                  sizeof(CopyFolderName));
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnDelete, -1))
      {
         ProcessRequestIdNumbers ();
         if (!MailMessageIdCount)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrMessageNotSelected);
            return;
         }
         DoMessageDelete = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnNext, -1))
      {
         if (MailMessageId[0] >= CurrentMessageCount)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
            return;
         }
         MailMessageId[0] += MessageIncrement = 1;
         DoMessageRead = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnPrevious, -1))
      {
         if (MailMessageId[0] <= 1)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
            return;
         }
         MailMessageId[0] += MessageIncrement = -1;
         DoMessageRead = true;
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnReload, -1))
         DoMessageRead = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnText, -1))
         DoMessageRead = DoMessageReadPlainText = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnBinary, -1) ||
          strsame (CgiFormActionPtr, lang_BtnForeign, -1))
         DoMessageRead = DoMessageReadOctetStream = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnCreateSend, -1))
         DoMessageCreate = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnReply, -1))
         DoMessageReply = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnForward, -1))
         DoMessageForward = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnSend, -1))
         DoMessageSend = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnSet, -1))
         DoUserSet = true;
      else
      if (strsame (CgiFormActionPtr, lang_ProfileUser, -1))
         DoUserProfile = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnChangeProfile, -1))
         DoUserProfile = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnDeleteUserProfile, -1))
         DoUserDelete = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnCreateUserProfile, -1))
         DoUserCreate = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnAddressLists, -1))
         DoAddrListSelect = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnAccess, -1))
      {
         cptr = CgiLibVar ("WWW_FORM_WHA");
         if (!strcmp (cptr, "lis"))
            DoAddrListEdit = true;
         else
         if (!strcmp (cptr, "sig"))
            DoSigFileAccess = true;
         else
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
            return;
         }
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnUpdate, -1))
      {
         cptr = CgiLibVar ("WWW_FORM_WHA");
         if (!strcmp (cptr, "lis"))
            DoAddrListUpdate = true;
         else
         if (!strcmp (cptr, "sig"))
            DoSigFileUpdate = true;
         else
         if (!strcmp (cptr, "pcu"))
            DoPersonalSetupUpdate = true;
         else
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
            return;
         }
      }
      else
      if (strsame (CgiFormActionPtr, lang_BtnRemove, -1))
         DoAddrListRemove = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnPersonalSetupEdit, -1))
         DoPersonalSetupEdit = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnPersonalSetupSave, -1))
         DoPersonalSetupSave = true;
      else
      if (strsame (CgiFormActionPtr, lang_BtnLogout, -1))
      {
         if (CgiLibEnvironmentIsWasd())
         {
            CgiLibResponseHeader (302, NULL, "%s%s?httpd=logout",
                                  CgiScriptNamePtr, CgiPathInfoPtr);
            return;
         }
         CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
         return;
      }
      else
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
         return;
      }
   }
   else
   {
      if (Debug) fprintf (stdout, "MailMessageId[0]: %d\n", MailMessageId[0]);
      if (MailMessageId[0])
         DoMessageRead = true;
      else
         DoFolderBrowse = true;

#if YAHMAIL_PRIVATE
      if (ConfigPrivate)
      {
         if (!MailFileName[0]) strcpy (MailFileName, "MAIL");
         if (!MailFolderName[0]) strcpy (MailFolderName, "NEWMAIL");

         if (HideSpam)
         {
            cptr = CgiLibVar ("WWW_FORM_DSP");
            if (*cptr == '0') DoNotDisplaySpam = true;
            if (*cptr == '1') DoDisplaySpam = true;
         }
      }
#endif
   }

   MailFileNameLength = strlen(MailFileName);
   MailFolderNameLength = strlen(MailFolderName);
   CopyFolderNameLength = strlen(CopyFolderName);

   /*********/
   /* do it */
   /*********/

   EnableAccess (1);

#if YAHMAIL_PRIVATE
   if (ConfigPrivate)
      ProcessPrivateRequest ();
   else
#endif
      ProcessPublicRequest ();

   EnableAccess (0);
}

/*****************************************************************************/
/*
For selected requests scan through possible ID numbers to see whether they
exist as form fields. Possible numbers are 1 .. size of browse window.  Each
form element would contain a message ID.
*/

ProcessRequestIdNumbers ()
       
{
   boolean  DebugBuffer;
   int  IdNumber;
   char  *cptr, *sptr;
   char  Scratch [64];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessRequestIdNumbers()\n");

   /* check for message ID numbers in the query string as form fields */
   if (DebugBuffer = Debug) Debug = false;
   MailMessageIdCount = 0;
   for (IdNumber = 1; IdNumber <= BrowseWindow; IdNumber++)
   {
      sprintf (Scratch, "WWW_FORM_ID%d", IdNumber);
      if ((cptr = CgiLibVarNull (Scratch)) != NULL)
      {
         if (MailMessageIdCount > MAX_MESSAGE_ID)
         {
            CgiLibResponseError (FI_LI, 0, lang_ErrInternalLimit);
            return;
         }
         MailMessageId[MailMessageIdCount] = atoi(cptr);
         while (*cptr && *cptr != ':') cptr++;
         if (*cptr)
         {
            cptr++;
            sptr = calloc (strlen(cptr)+1, 1);
            if (!sptr) exit (vaxc$errno);
            strcpy (sptr, cptr);
            MailMessageIdSpamList[MailMessageIdCount] = sptr;
         }
         else
            MailMessageIdSpamList[MailMessageIdCount] = NULL;
         MailMessageIdCount++;
         if (DebugBuffer)
            fprintf (stdout, "id: %d=%d\n", MailMessageIdCount, IdNumber);
      }
   }
   /* if checkboxes selected then zero any number supplied with the path */
   if (MailMessageIdCount) MailMessageId[MailMessageIdCount] = 0;
   Debug = DebugBuffer;
   if (Debug) fprintf (stdout, "MailMessageIdCount: %d\n", MailMessageIdCount);
}

/****************************************************************************/
/*
Return true is the string is all digits, false if not.
*/ 

boolean isinteger (char *sptr)

{
   while (*sptr && isdigit(*sptr)) sptr++;
   if (!*sptr) return (true);
   return (false);
}

/*****************************************************************************/
/*
*/

void returnFromAction(int number)
{
    if (number == 0)
    {
        number = -1 ;
    } ;

    CgiLibResponseHeader (200, "text/html",
"\n\
<html>\n\
<head>\n\
</head>\n\
<body>\n\
<script language=javascript>\n\
<!--\n\
history.go(%d) ;\n\
//-->\n\
</script>\n\
</body>\n\
</html>\n", number) ;
}

/*****************************************************************************/
