$!-----------------------------------------------------------------------------
$! YAHMAIL_STARTUP.COM
$!
$! For WASD P1 can supply the server username ("HTTP$SERVER" by default)
$! For APACHE P1 can supply the server username ("APACHE" by default)
$! For OSU P1 can supply the server username ("HTTP_SERVER" by default)
$! The server, "WASD", "APACHE", "OSU", or "OTHER", may be specified using P2
$!
$! Usage examples:
$!
$! $ @YAHMAIL_STARTUP
$! $ @YAHMAIL_STARTUP "" OSU
$! $ @YAHMAIL_STARTUP WEB_SERVER OSU
$!
$! 16-FEB-2004  MGD  check_server_opt (thanks Martin Zinser)
$! 08-FEB-2003  MGD  WASD yahMAIL image moved to cgi_exe:yahmail.exe
$! 20-DEC-2002  MGD  WASD 8.1 package (security settings implicit in package)
$! 26-APR-2002  MGD  allow P2 to explicitly specify the server family
$! 16-JAN-2001  MGD  APACHE_ROOT becomes APACHE$COMMON (CSWS V1.0-1)
$! 06-APR-2000  MGD  VMS Apache
$! 15-JAN-2000  MGD  make a single package work for all three environments
$! 07-JUL-1999  MGD  initial
$!-----------------------------------------------------------------------------
$!
$ privs = "/priv=(sysprv)"
$ arch_name = f$edit(f$getsyi("arch_name"),"upcase")
$ if arch_name .eqs. "ALPHA" then arch_name = "AXP"
$!
$ WASD81 = 0
$!
$ gosub check_server_opt
$!
$ if p2 .eqs. "WASD"
$ then
$!   (WASD environment)
$    yahmail_com = "CGI-BIN:[000000]YAHMAIL.COM"
$    if f$search(yahmail_com) .eqs. ""
$       then yahmail_exe = "CGI-BIN:[000000]YAHMAIL.EXE"
$       else yahmail_exe = "CGI_EXE:YAHMAIL.EXE"
$    endif
$    yahmail_config = "HT_ROOT:[LOCAL]YAHMAIL.CONF"
$    httpd_username = "HTTP$SERVER"
$    if p1 .nes. "" then httpd_username = p1
$    if f$search("HT_EXE:SECHAN.EXE") .nes. "" then WASD81 = 1
$ endif
$!
$ if p2 .eqs. "APACHE"
$ then
$!   (VMS Apache environment)
$    yahmail_exe = "APACHE$COMMON:[CGI-BIN]YAHMAIL_''arch_name'.EXE"
$    yahmail_com = "APACHE$COMMON:[CGI-BIN]YAHMAIL.COM"
$    yahmail_config = "APACHE$COMMON:[CONF]YAHMAIL.CONF"
$    httpd_username = "APACHE$WWW"
$    if p1 .nes. "" then httpd_username = p1
$ endif
$!
$ if p2 .eqs. "OSU"
$ then
$!   (OSU environment)
$    yahmail_exe = "WWW_ROOT:[BIN]YAHMAIL_''arch_name'.EXE"
$    yahmail_com = "WWW_ROOT:[BIN]YAHMAIL.COM"
$    yahmail_config = "WWW_ROOT:[SYSTEM]YAHMAIL.CONF"
$    httpd_username = "HTTP_SERVER"
$    if p1 .nes. "" then httpd_username = p1
$ endif
$!
$ if p2 .eqs. "OTHER"
$ then
$!   (vanilla CGI server environment)
$    yahmail_exe = "LOCATION:YAHMAIL_''arch_name'.EXE"
$    yahmail_com = "LOCATION:YAHMAIL.COM"
$    yahmail_config = "LOCATION:YAHMAIL.CONF"
$    httpd_username = "USERNAME?"
$ endif
$!
$!(define a logical locating configuration file)
$ define /nolog /system /exec yahmail$config 'yahmail_config'
$!
$ if .not. WASD81
$ then
$!  (remove all world access from the configuration file)
$   set security 'yahmail_config' /protection=w -
        /acl=((ident='httpd_username',access=read),(ident=*,access=none))
$!  (allow only the server account to execute the support procedure & image)
$   set security 'yahmail_com' /protection=w -
        /acl=((ident='httpd_username',access=read+execute), -
              (ident=*,access=none))
$   set security 'yahmail_exe' /protection=w -
        /acl=((ident='httpd_username',access=read+execute), -
              (ident=*,access=none))
$ endif
$!
$!(install with required privileges)
$ install = "install"
$ if f$search(yahmail_exe) .nes. ""
$ then
$    if f$file(yahmail_exe,"known")
$       then install replace 'yahmail_exe' /open /header /share 'privs'
$       else install add 'yahmail_exe' /open /header /share 'privs'
$    endif
$ else
$    write sys$output "%YAHMAIL-E-STARTUP, the expected image ''yahmail_exe' was not found"
$ endif
$ exit
$!-----------------------------------------------------------------------------
$ CHECK_SERVER_OPT:
$!
$ if p2 .eqs. ""
$ then
$    procedure = f$environment("procedure")
$    prolength = f$length(procedure)
$    if f$locate("HT_ROOT",procedure) .lt. prolength then p2 = "WASD"
$    if f$locate("APACHE$COMMON",procedure) .lt. prolength then p2 = "APACHE"
$    if f$locate("WWW_ROOT",procedure) .lt. prolength then p2 = "OSU"
$    if p2 .eqs. "" then p2 =  "OTHER"
$ endif
$ 
$ if (p2 .eqs. "WASD") .or. (p2 .eqs. "APACHE") - 
     .or. (p2 .eqs. "OSU") .or (p2 .eqs. "OTHER") 
$ then
$    write sys$output - 
           "%YAHMAIL-I-STARTUP, Installing yahMAIL for server type ''p2'"
$ else
$    write sys$output - 
           "%YAHMAIL-F-STARTUP, Unknown server type ''p2' - aborting"
$    exit 2	   
$ endif      
$ return
$!-----------------------------------------------------------------------------
