## VMS::FindFile - Implements some simple hooks to give VMS perl
## a function similar to DCL's f$search().
##
## Version 0.9 written 04-DEC-2000 by Forrest Cahoon
##                                       (forrest@wiredaemons.com)
##

package VMS::FindFile;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter AutoLoader DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(

);
$VERSION = '0.9';

bootstrap VMS::FindFile $VERSION;

# Preloaded methods go here.
use VMS::FindFile;

sub new {
   my $class = $_[0];
   my $objref = {_filespec  => $_[1]};
   ($objref->{"_resultant"},$objref->{"_context"}) =
     VMS::FindFile::_find_file($objref->{"_filespec"}, 0);
   bless $objref, $class;
   return $objref;
}

sub search {
   my ($self) = @_;
   my $fname = $self->{"_resultant"};
   if ($fname) {
      ($self->{"_resultant"}, $self->{"_context"}) =
	VMS::FindFile::_find_file($self->{"_filespec"}, $self->{"_context"});
   }
   return $fname;
}

sub DESTROY {
   my ($self) = @_;
   if ($self->{"_context"}) {
      VMS::FindFile::_find_file_end($self->{"_context"});
   }
}

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

VMS::FindFile - Perl extension to return all the file names matching a
VMS wildcard file specification.

=head1 SYNOPSIS

  use VMS::FindFile;

  my $ff=VMS::FindFile->new($wildcard_spec);

  while (my $filename = $ff->search()) {
     # ... do whatever with $filename ...
  }

=head1 DESCRIPTION

VMS::FindFile is a simple hook into the VMS system service calls
LIB$FIND_FILE() and LIB$FIND_FILE_END(), like the DCL f$search()
function.

While it is VMS-specific, it should be a lot faster than the system-
independent File::Find.

=head1 AUTHOR

Forrest Cahoon (forrest@wiredaemons.com)

=head1 SEE ALSO

perl(1).

=cut
