$!+  BATCH_INFO.COM  v1.1-3
$!
$!   AUTHOR:  Alan E. Feldman
$!
$!   PURPOSE: To get the PID of a batch job and use it in 
$!            a SHOW PROCESS command and show other useful info.
$!
$!   Parameters:   P1    - Entry number. Qualifiers for the SHOW PROCESS 
$!			   command may be optionally appended. 
$!                 P2... - Qualifiers for SHOW PROC/ID=pid (optional)
$!
$!   Example:   $ BAT*CH_INFO :== @disk:[dir]BATCH_INFO.COM
$!
$!              $ BAT 234/ACC/QUOT
$!        or
$!		$ BAT 234 /ACC /QUOT
$!
$!!  Define status codes:
$
$    BATCH_INFO__STATUS = %X18008000
$    BATCH_INFO__SUCCESS = BATCH_INFO__STATUS + %X0001
$    BATCH_INFO__CONTROL_Y = BATCH_INFO__STATUS + %X000C
$
$!!  Establish handlers:
$
$    STATUS = BATCH_INFO__SUCCESS
$    ON CONTROL_Y THEN GOTO _CONTROL_Y
$    ON WARNING THEN GOTO _ERROR 
$
$    WSO := WRITE SYS$OUTPUT
$
$    P1ORIG = P1
$    P1 = F$ELEMENT(0,"/",P1)
$    P1END = P1ORIG - P1
$
$    SHOW ENTRY/FULL 'P1'
$    BATCH_PID = F$GETQUI("DISPLAY_ENTRY","JOB_PID",P1)
$    IF (BATCH_PID .EQS. "")
$    THEN
$        WSO " "
$        WSO "No PID; job not running."
$        GOTO _EXIT
$    ENDIF
$    WSO " "
$    WSO "Process creation time: ",-
         F$CVTIME(F$GETJPI(BATCH_PID,"LOGINTIM"))
$    WSO "Current image: ''F$GETJPI(BATCH_PID,"IMAGNAME")'"
$    SHOW PROCESS -
         /ID='BATCH_PID' 'P1END' 'P2' 'P3' 'P4' 'P5' 'P6' 'P7' 'P8'
$    WSO " "
$    SHOW SYSTEM/BATCH/OUTPUT=SYS$SCRATCH:AEFBAT.AEFTMP
$    SEARCH /NOHIGHLIGHT      SYS$SCRATCH:AEFBAT.AEFTMP -
         'BATCH_PID',"on node","Process Name"/EXACT
$    GOTO _EXIT
$
$_CONTROL_Y:
$    STATUS = BATCH_INFO__CONTROL_Y
$    GOTO _EXIT
$
$_ERROR:
$    STATUS = $STATUS
$    GOTO _EXIT
$
$_EXIT:
$    SET NOON
$    IF (F$SEARCH("SYS$SCRATCH:AEFBAT.AEFTMP").NES."") THEN -
        DELETE/NOLOG SYS$SCRATCH:AEFBAT.AEFTMP;*
$    WSO " "
$    EXIT STATUS .OR. %X10000000
