$IF 0
-----------------------------------------------------------------------------
 BIOS Interrupt & Port I/O Routines     Created with PowerBASIC for DOS 3.50
 Copyright (C) 2002 by Bla Valek       E-mail: bvalek2@freemail.hu
 Version date: 10-20-2002
-----------------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------
 SetVideo          -  Set video mode
 SetCursor         -  Set cursor type
 PutCursor         -  Set cursor position
 GetCursor         -  Read cursor position
 GetPen            -  Read light pen
 ActivePage        -  Select active display page
 ScrollUp          -  Scroll active page up
 ScrollDown        -  Scroll active page down
 GetAtCursor       -  Read character and attribute at cursor
 PutAtCursorC      -  Write character and attribute at cursor
 PutAtCursor       -  Write character at current cursor
 SetColorPal       -  Set Color Palette
 PutPixel          -  Write graphics pixel at coordinate
 GetPixel          -  Read graphics pixel at coordinate
 PutChar           -  Write text in teletype mode
 GetVideo          -  Get current video state
 SetDAC            -  Set DAC color register
 PutStr            -  Write String
-----------------------------------------------------------------------------
 PutLine           -  Draw line
 Box               -  Draw box
 FillBox           -  Draw filled box
 Ellipse           -  Draw ellipse
 FillEllipse       -  Draw filled ellipse
 Teletype          -  Write string
 XYStr             -  Write string at coordinate using fonts
 XYStrBack         -  Write string with background color
-----------------------------------------------------------------------------
 SetPalette        -  Set 256 color palette
 Reboot            -  Reboot PC in DOS or close command line in Windows
 WaitFrame         -  Wait for video enabled signal
-----------------------------------------------------------------------------
 Equipment         -  Equipment determination
 Memory            -  Memory size determination
-----------------------------------------------------------------------------
 ResetDisk         -  Reset Disk System
 GetDisk           -  Get Disk Status
 ReadSector        -  Read Disk Sectors
 WriteSector       -  Write Disk Sectors
 VerifySector      -  Verify Disk Sectors
-----------------------------------------------------------------------------
 WaitKey           -  Wait for keystroke and read
 GetKey            -  Get keystroke status
 GetShift          -  Get shift status
-----------------------------------------------------------------------------
 LPrintChar        -  Print character
 InitPrinter       -  Initialize printer port
 PrinterStatus     -  Read printer port status
-----------------------------------------------------------------------------
 Bootstrap         -  Bootstrap loader
-----------------------------------------------------------------------------
 ReadClock         -  Read system clock counter
 SetClock          -  Set system clock counter
-----------------------------------------------------------------------------
$ENDIF

$CPU      8086
$LIB      ALL     OFF
$DEBUG    MAP     OFF
$DEBUG    PBDEBUG OFF
$DEBUG    PATH    OFF
$DEBUG    UNIT    OFF
$ERROR    ALL     OFF
$OPTIMIZE SIZE
$COMPILE  UNIT

DEFINT A-Z

%AX = 1
%BX = 2
%CX = 3
%DX = 4
%SI = 5
%DI = 6
%BP = 7
%DS = 8
%ES = 9
%FLAGS = 0

DIM VideoMode AS BYTE
SHARED VideoMode

SUB SetVideo (BYVAL Mode AS BYTE) PUBLIC
  REG %AX, Mode
  CALL INTERRUPT &H10
  VideoMode = Mode
END SUB

SUB SetCursor (BYVAL Bottom AS BYTE, BYVAL Top AS BYTE) PUBLIC

  REG %AX, &H01 * &H100
  REG %CX, Top * &H100 + Bottom
  CALL INTERRUPT &H10

END SUB

SUB PutCursor (BYVAL Page AS BYTE, BYVAL Column AS BYTE, BYVAL Row AS BYTE) _
              PUBLIC

  REG %AX, &H02 * &H100
  REG %BX, Page * &H100
  REG %DX, Row * &H100 + Column
  CALL INTERRUPT &H10

END SUB

SUB GetCursor (BYVAL Page AS BYTE, Bottom AS INTEGER, Top AS INTEGER, _
              Column AS INTEGER, Row AS INTEGER) PUBLIC

  REG %AX, &H03 * &H100
  REG %BX, Page * &H100
  CALL INTERRUPT &H10
  Bottom = REG(%CX) MOD &H100
  Top    = REG(%CX)  \  &H100
  Column = REG(%DX) MOD &H100
  Row    = REG(%DX)  \  &H100

END SUB

SUB GetPen (Trigger AS INTEGER, PixelCol AS INTEGER, PixelRow AS INTEGER, _
           Column AS INTEGER, Row AS INTEGER) PUBLIC

DIM Cols AS INTEGER
DIM Mode AS INTEGER
DIM Page AS INTEGER

  GetVideo Cols, Mode, Page

  REG %AX, &H04 * &H100
  CALL INTERRUPT &H10
  Trigger  = REG(%AX) \ &H100
  PixelCol = REG(%BX)
  SELECT CASE Mode
    CASE 4, 5, 6: PixelRow = REG(%CX) \ &H100
    CASE ELSE:    PixelRow = REG(%CX)
  END SELECT
  Column = REG(%DX) MOD &H100
  Row    = REG(%DX)  \  &H100

END SUB

SUB ActivePage (BYVAL Page AS BYTE) PUBLIC

  REG %AX, &H05 * &H100 + Page
  CALL INTERRUPT &H10

END SUB

SUB ScrollUp (BYVAL Lines AS BYTE, BYVAL Attr AS BYTE, BYVAL UpLeftCol AS _
             BYTE, BYVAL UpLeftRow AS BYTE, BYVAL DownRightCol AS BYTE, _
             BYVAL DownRightRow AS BYTE) PUBLIC

  REG %AX, &H06 * &H100 + Lines
  REG %BX, Attr * &H100
  REG %CX, UpLeftRow * &H100 + UpLeftCol
  REG %DX, DownRightRow * &H100 + DownRightCol
  CALL INTERRUPT &H10

END SUB

SUB ScrollDown (BYVAL Lines AS BYTE, BYVAL Attr AS BYTE, BYVAL UpLeftCol AS _
               BYTE, BYVAL UpLeftRow AS BYTE, BYVAL DownRightCol AS BYTE, _
               BYVAL DownRightRow AS BYTE) PUBLIC

  REG %AX, &H07 * &H100 + Lines
  REG %BX, Attr * &H100
  REG %CX, UpLeftRow * &H100 + UpLeftCol
  REG %DX, DownRightRow * &H100 + DownRightCol
  CALL INTERRUPT &H10

END SUB

SUB GetAtCursor (BYVAL Page AS BYTE, Char AS INTEGER, Attr AS INTEGER) PUBLIC

  REG %AX, &H08 * &H100
  REG %BX, Page * &H100
  CALL INTERRUPT &H10
  Char = REG(%AX) MOD &H100
  Attr = REG(%AX)  \  &H100

END SUB

SUB PutAtCursorC (BYVAL Code AS BYTE, BYVAL Page_Back13h AS BYTE, BYVAL _
                 Attr AS BYTE, BYVAL Count AS INTEGER) PUBLIC

  REG %AX, &H09 * &H100 + Code
  REG %BX, Page_Back13h * &H100 + Attr
  REG %CX, Count
  CALL INTERRUPT &H10

END SUB

SUB PutAtCursor (BYVAL Code AS BYTE, BYVAL Page_Back13h AS BYTE, BYVAL Attr _
                AS BYTE, BYVAL Count AS INTEGER) PUBLIC

  REG %AX, &H0A * &H100 + Code
  REG %BX, Page_Back13h * &H100 + Attr
  REG %CX, Count
  CALL INTERRUPT &H10

END SUB

SUB SetColorPal (BYVAL Switch AS BYTE, BYVAL Clr_Pal AS BYTE) PUBLIC

  REG %AX, &H0B * &H100
  REG %BX, Switch * &H100 + Clr_Pal
  CALL INTERRUPT &H10

END SUB

SUB PutPixel (BYVAL Clr AS BYTE, BYVAL Page AS BYTE, BYVAL Column AS _
             INTEGER, BYVAL Row AS INTEGER) PUBLIC

SELECT CASE VideoMode
  CASE &H13
    DIM DefSeg AS INTEGER
    DefSeg = pbvDefSeg
    DEF SEG = &HA000
    POKE Row * 320 + Column, Clr
    DEF SEG = DefSeg
  CASE ELSE
    REG %AX, &H0C * &H100 + Clr
    REG %BX, Page * &H100
    REG %CX, Column
    REG %DX, Row
    CALL INTERRUPT &H10
END SELECT

END SUB

FUNCTION GetPixel (BYVAL Page AS BYTE, BYVAL Column AS INTEGER, BYVAL Row _
                  AS INTEGER) PUBLIC AS INTEGER

SELECT CASE VideoMode
  CASE &H13
    DIM DefSeg AS INTEGER
    DefSeg = pbvDefSeg
    DEF SEG = &HA000
    FUNCTION = PEEK(Row * 320 + Column)
    DEF SEG = DefSeg
  CASE ELSE
    REG %AX, &H0D * &H100
    REG %BX, Page * &H100
    REG %CX, Column
    REG %DX, Row
    CALL INTERRUPT &H10
    FUNCTION = REG(%AX) MOD &H100
END SELECT

END FUNCTION

SUB PutChar (BYVAL Code AS BYTE, BYVAL Page AS BYTE, BYVAL Clr AS BYTE) _
            PUBLIC

  REG %AX, &H0E * &H100 + Code
  REG %BX, Page * &H100 + Clr
  CALL INTERRUPT &H10

END SUB

SUB GetVideo (Column AS INTEGER, Mode AS INTEGER, Page AS INTEGER) PUBLIC

  REG %AX, &H0F * &H100
  CALL INTERRUPT &H10
  Column = REG(%AX)  \  &H100
  Mode =   REG(%AX) mod &H100
  Page =   REG(%BX)  \  &H100

END SUB

SUB SetDAC (BYVAL Register AS INTEGER, BYVAL Green AS BYTE, BYVAL Blue AS _
           BYTE, BYVAL Red AS BYTE) PUBLIC

  REG %AX, &H1010
  REG %BX, Register
  REG %CX, Green * &H100 + Blue
  REG %AX, Red * &H100
  CALL INTERRUPT &H10

END SUB

SUB PutStr (BYVAL Column AS BYTE, BYVAL Row AS BYTE, BYVAL Text AS STRING, _
           BYVAL Mode AS BYTE, BYVAL Attr AS BYTE, BYVAL Page AS BYTE) _
           PUBLIC

  REG %AX, &H13 * &H100 + Mode
  REG %BX, Page * &H100 + Attr
  REG %CX, LEN(Text)
  REG %DX, Row * &H100 + Column
  REG %ES, STRSEG(Text)
  REG %BP, STRPTR(Text)
  CALL INTERRUPT &H10

END SUB

FUNCTION Equipment () PUBLIC AS INTEGER

  CALL INTERRUPT &H11
  FUNCTION = REG(%AX)

END FUNCTION

FUNCTION Memory () PUBLIC AS INTEGER

  CALL INTERRUPT &H12
  FUNCTION = REG(%AX)

END FUNCTION

'----------------------------------------------------------------------------

SUB SetPalette (BYVAL Slot AS INTEGER, BYVAL Red AS INTEGER, BYVAL Green AS _
               INTEGER, BYVAL Blue AS INTEGER) PUBLIC

  OUT &H3C8, Slot
  OUT &H3C9, Red
  OUT &H3C9, Green
  OUT &H3C9, Blue

END SUB

SUB Reboot () PUBLIC

  OUT &H64, &HFE

END SUB

SUB WaitFrame (BYVAL Frames AS LONG) PUBLIC
DIM c AS LONG

FOR c = 1 TO Frames
  WAIT &H3DA, &H08
NEXT c

END SUB

'----------------------------------------------------------------------------

SUB PutLine (BYVAL x1 AS INTEGER, BYVAL y1 AS INTEGER, BYVAL x2 AS INTEGER, _
            BYVAL y2 AS INTEGER, BYVAL Clr AS BYTE, BYVAL Page AS BYTE) _
            PUBLIC
DIM a AS SINGLE
DIM b AS INTEGER
DIM mn AS INTEGER
DIM mx AS INTEGER
DIM c AS INTEGER

IF ABS(x1 - x2) >= ABS(y1 - y2) THEN
  mn = MIN%(x1, x2)
  mx = MAX%(x1, x2)
  a = (y2 - y1) / (x2 - x1)
  b = y1 - (((y2 - y1) / (x2 - x1)) * x1)
  FOR c = mn TO mx
    PutPixel Clr, Page, c, a * c + b
  NEXT c
ELSE
  mn = MIN%(y1, y2)
  mx = MAX%(y1, y2)
  a = (x2 - x1) / (y2 - y1)
  b = x1 - (((x2 - x1) / (y2 - y1)) * y1)
  FOR c = mn TO mx
    PutPixel Clr, Page, a * c + b, c
  NEXT c
END IF

END SUB

SUB Box (BYVAL x1 AS INTEGER, BYVAL y1 AS INTEGER, BYVAL x2 AS INTEGER, _
        BYVAL y2 AS INTEGER, BYVAL Clr AS BYTE, BYVAL Page AS BYTE) PUBLIC
DIM c AS INTEGER

FOR c = MIN(x1, x2) TO MAX(x1, x2)
  PutPixel Clr, Page, c, y1
  PutPixel Clr, Page, c, y2
NEXT c
FOR c = MIN(y1, y2) TO MAX(y1, y2)
  PutPixel Clr, Page, x1, c
  PutPixel Clr, Page, x2, c
NEXT c

END SUB

SUB FillBox (BYVAL x1 AS INTEGER, BYVAL y1 AS INTEGER, BYVAL x2 AS INTEGER, _
            BYVAL y2 AS INTEGER, BYVAL Clr AS BYTE, BYVAL Page AS BYTE) _
            PUBLIC
DIM c AS INTEGER
DIM d AS INTEGER

FOR c = MIN(x1, x2) TO MAX(x1, x2)
  FOR d = MIN(y1, y2) TO MAX(y1, y2)
    PutPixel Clr, Page, c, d
  NEXT d
NEXT c

END SUB

SUB Ellipse (BYVAL x AS INTEGER, BYVAL y AS INTEGER, BYVAL a AS SINGLE, _
            BYVAL b AS SINGLE, BYVAL s AS SINGLE, BYVAL f AS SINGLE, BYVAL _
            Clr AS BYTE, BYVAL Page AS BYTE) PUBLIC
DIM c AS SINGLE

FOR c = MIN(s, f) TO MAX(s, f) STEP 1 / MAX(a, b)
  PutPixel Clr, Page, a * COS(c) + x, b * SIN(c) + y
NEXT c

END SUB

SUB FillEllipse (BYVAL x AS INTEGER, BYVAL y AS INTEGER, BYVAL a AS SINGLE, _
                BYVAL b AS SINGLE, BYVAL Clr AS BYTE, BYVAL Page AS BYTE) _
                PUBLIC
DIM c AS SINGLE

FOR c = -3.141593 / 2 TO 3.141593 / 2 STEP 1 / MAX%(a, b)
  PutLine a * COS(c + 3.141593) + x, b * SIN(c) + y, a * COS(c) + x, b * SIN(c) + y, Clr, Page
NEXT c

END SUB

SUB Teletype (BYVAL Text AS STRING, BYVAL Clr AS BYTE, BYVAL Page AS BYTE) _
             PUBLIC
DIM c AS INTEGER

IF LEN(Text) > 0 THEN
  FOR c = 1 TO LEN(Text)
    PutChar ASC(MID$(Text, c, 1)), Page, Clr
  NEXT c
END IF

END SUB

SUB XYStr (BYVAL x AS INTEGER, BYVAL y AS INTEGER, BYVAL Text AS STRING, _
          BYVAL Clr AS BYTE, BYVAL Page AS BYTE, BYVAL FontFile AS STRING) _
          PUBLIC
DIM a AS INTEGER
DIM b AS INTEGER
DIM c AS INTEGER
DIM h AS INTEGER
DIM f AS STRING
DIM ch AS BYTE

IF (Text <> "") AND (FontFile <> "") THEN
  IF DIR$(FontFile) = UCASE$(FontFile) THEN
    OPEN FontFile FOR BINARY AS #1
      h = LOF(1) \ 256
      f = SPACE$(h)
      FOR c = 1 TO LEN(Text)
        GET #1, ASC(MID$(Text, c, 1)) * h, f
        FOR b = 0 TO h - 1
          ch = ASC(MID$(f, b + 1, 1))
          FOR a = 0 TO 7
            IF BIT(ch, a) <> 0 THEN PutPixel Clr, Page, x + 7 - a + ((c - 1) * 8), y + b
          NEXT a
        NEXT b
      NEXT c
    CLOSE #1
  END IF
END IF

END SUB

SUB XYStrBack (BYVAL x AS INTEGER, BYVAL y AS INTEGER, BYVAL Text AS _
              STRING, BYVAL Clr AS BYTE, BYVAL back AS BYTE, BYVAL Page AS _
              BYTE, BYVAL FontFile AS STRING) PUBLIC
DIM a AS INTEGER
DIM b AS INTEGER
DIM c AS INTEGER
DIM h AS INTEGER
DIM f AS STRING
DIM ch AS BYTE

IF (Text <> "") AND (FontFile <> "") THEN
  IF DIR$(FontFile) = UCASE$(FontFile) THEN
    OPEN FontFile FOR BINARY AS #1
      h = LOF(1) \ 256
      f = SPACE$(h)
      FOR c = 1 TO LEN(Text)
        GET #1, ASC(MID$(Text, c, 1)) * h, f
        FOR b = 0 TO h - 1
          ch = ASC(MID$(f, b + 1, 1))
          FOR a = 0 TO 7
            IF BIT(ch, a) = 0 THEN
              PutPixel Back, Page, x + 7 - a + ((c - 1) * 8), y + b
            ELSE
              PutPixel Clr, Page, x + 7 - a + ((c - 1) * 8), y + b
            END IF
          NEXT a
        NEXT b
      NEXT c
    CLOSE #1
  END IF
END IF

END SUB

'----------------------------------------------------------------------------

FUNCTION ResetDisk (BYVAL Drive AS BYTE) PUBLIC AS INTEGER

  REG %AX, &H00
  REG %DX, Drive
  CALL INTERRUPT &H13
  FUNCTION = REG(%AX) \ &H100

END FUNCTION

FUNCTION GetDisk () PUBLIC AS INTEGER

  REG %AX, &H100
  CALL INTERRUPT &H13
  FUNCTION = REG(%AX) \ &H100

END FUNCTION

SUB ReadSector (BYVAL Number AS BYTE, BYVAL Track AS INTEGER, BYVAL Sector _
               AS BYTE, BYVAL Head AS BYTE, BYVAL Drive AS BYTE, BYVAL _
               BufferSeg AS INTEGER, BYVAL BufferOfs AS INTEGER, Status AS _
               INTEGER, Result AS INTEGER) PUBLIC

  REG %AX, &H02 * &H100 + Number
  REG %CX, (Track \ &H100) * &H100 + (Track MOD &H100) * &B100000 + Sector
  REG %DX, Head * &H100 + Drive
  REG %ES, BufferSeg
  REG %BX, BufferOfs
  CALL INTERRUPT &H13
  Status = REG(%AX)  \  &H100
  Result = REG(%AX) MOD &H100

END SUB

SUB WriteSector (BYVAL Number AS BYTE, BYVAL Track AS INTEGER, BYVAL Sector _
                AS BYTE, BYVAL Head AS BYTE, BYVAL Drive AS BYTE, BYVAL _
                BufferSeg AS INTEGER, BYVAL BufferOfs AS INTEGER, Status AS _
                INTEGER, Result AS INTEGER) PUBLIC

  REG %AX, &H03 * &H100 + Number
  REG %CX, (Track \ &H100) * &H100 + (Track MOD &H100) * &B100000 + Sector
  REG %DX, Head * &H100 + Drive
  REG %ES, BufferSeg
  REG %BX, BufferOfs
  CALL INTERRUPT &H13
  Status = REG(%AX)  \  &H100
  Result = REG(%AX) MOD &H100

END SUB

SUB VerifySector (BYVAL Number AS BYTE, BYVAL Track AS INTEGER, BYVAL _
                 Sector AS BYTE, BYVAL Head AS BYTE, BYVAL Drive AS BYTE, _
                 BYVAL BufferSeg AS INTEGER, BYVAL BufferOfs AS INTEGER, _
                 Status AS INTEGER, Result AS INTEGER) PUBLIC

  REG %AX, &H04 * &H100 + Number
  REG %CX, (Track \ &H100) * &H100 + (Track MOD &H100) * &B100000 + Sector
  REG %DX, Head * &H100 + Drive
  REG %ES, BufferSeg
  REG %BX, BufferOfs
  CALL INTERRUPT &H13
  Status = REG(%AX)  \  &H100
  Result = REG(%AX) MOD &H100

END SUB

'----------------------------------------------------------------------------

SUB WaitKey (ScanCode AS INTEGER, AsciiCode AS INTEGER) PUBLIC

  REG %AX, &H0
  CALL INTERRUPT &H16
  ScanCode  = REG(%AX)  \  &H100
  AsciiCode = REG(%AX) MOD &H100

END SUB

SUB GetKey (Pressed AS INTEGER, ScanCode AS INTEGER, AsciiCode AS INTEGER) _
           PUBLIC
DIM flag AS INTEGER

  REG %AX, &H100
  CALL INTERRUPT &H16
  ScanCode  = REG(%AX)  \  &H100
  AsciiCode = REG(%AX) MOD &H100
  flag      = REG(%FLAGS)
  Pressed   = BIT(flag, 6)

END SUB

FUNCTION GetShift () PUBLIC AS INTEGER

  REG %AX, &H200
  CALL INTERRUPT &H16

END FUNCTION

'----------------------------------------------------------------------------

FUNCTION LPrintChar (BYVAL CharCode AS BYTE, BYVAL LPort AS INTEGER) PUBLIC _
                    AS INTEGER

  REG %AX, CharCode
  REG %DX, LPort
  CALL INTERRUPT &H17
  FUNCTION = REG(%AX) \ &H100

END FUNCTION

FUNCTION InitPrinter (BYVAL LPort AS INTEGER) PUBLIC AS INTEGER

  REG %AX, &H100
  REG %DX, LPort
  CALL INTERRUPT &H17
  FUNCTION = REG(%AX) \ &H100

END FUNCTION

FUNCTION PrinterStatus (BYVAL LPort AS INTEGER) PUBLIC AS INTEGER

  REG %AX, &H200
  REG %DX, LPort
  CALL INTERRUPT &H17
  FUNCTION = REG(%AX) \ &H100

END FUNCTION

'----------------------------------------------------------------------------

SUB Bootstrap (BYVAL Drive AS BYTE) PUBLIC

  REG %DX, Drive
  CALL INTERRUPT &H19

END SUB

'----------------------------------------------------------------------------

FUNCTION ReadClock () PUBLIC AS LONG

  REG %AX, 0
  CALL INTERRUPT &H1A
  FUNCTION = REG(%CX) * &HFFFF + REG(%DX)

END FUNCTION

SUB SetClock (BYVAL ClockTick AS LONG) PUBLIC

  REG %AX, &H100
  REG %CX, ClockTick  \  &HFFFF
  REG %DX, ClockTick MOD &HFFFF
  CALL INTERRUPT &H1A

END SUB
