$! CDRECORD.COM
$!
$!* Copyright 2003 Compaq Information Technologies Group, L.P.
$!
$! Jan 15, 2004
$! Remove loading of LD cld commands. The cld will be in DCLTABLES.
$!
$! July 29, 2003
$! The "help overview" command is being updated to reflect the new
$! verify option.  A comment is added to the validate_log_device
$! routine to clarify possible user response when the Logical Device
$! unit is already in use.
$!
$! December 5, 2002
$! This is V7.3-1 patch 2 version of CDRECORD.COM.
$! It has been modified to allow specification of the "burnproof"
$! capability of the cdrecord executable.  In addition, a "verify"
$! option has been added.  It is being released to the HP OpenVMS website
$! relating to the VMS Open Sources CD.
$! 
$!
$! July 11, 2002
$! This is a special "patched" version of CDRECORD.COM.
$! It has been modified to deal with problems identified in the
$! V7.3-1 Release Notes. It is being shipped on the VMS OpenSources
$! CD along with OpenVMS V7.3-1. It will subsequently be released
$! with the OpenVMS V7.3-1R (remedial) version.
$!
$! Procedures to write, and to prepare for writing, cd-r media.
$! 
$! To use this procedure you require the following privileges:
$! diag, phy_io, sysprv.  altpri is required to modify execution
$! priority.
$!
$! To invoke this procedure:
$! @sys$manager:cdrecord arg1, arg2, ...
$! 
$! For debugging, define symbol cdrecord_verify to 1 in order
$! to 'set verify'.
$!
$! If you omit arguments, you will be prompted.
$! First parameter values:  [ help | inquire | setup | reuse | write | verify ]
$! 
$! The additional parameter values are dependent upon the first parameter:
$!
$! help [ overview | inquire | setup | reuse | write | verify ]
$!
$! inquire [ cdrw device name ] 
$!
$! setup [container filename] [logical disk device name]
$!	[logical disk volume label]
$!	[number of 512-byte blocks to be written]
$!
$! reuse [container filename] [logical disk device name]
$!	[logical disk volume label]
$!
$! write [container filename] [logical disk device name]
$!	[cdrw device name] [cdrw laser disable = 1]
$!	[override cdrw recording speed (1-99; 0=>no override)]
$!	[set process base priority (1-63; 0=>no change)]
$!	[reset priority after write (y|n)]
$!
$! verify [container filename] [logical disk device name]
$!	[logical disk volume label] [cd device name]
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Define symbol cdrecord_verify to 1 in order to 'set verify'.
$!
$ if "''cdrecord_verify'" .nes. "1" then $ cdrecord_verify = 0
$ verify_state = f$verify('cdrecord_verify)
$!
$ wo := write sys$output
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Scan for the command name 
$ p1 = f$edit(p1,"LOWERCASE")
$ if p1 .eqs. f$extract(0,f$length(p1),"help") then $ goto help_cmd
$ if p1 .eqs. f$extract(0,f$length(p1),"inquire") then $ goto inquire_cmd
$ if p1 .eqs. f$extract(0,f$length(p1),"setup") then $ goto setup_cmd
$ if p1 .eqs. f$extract(0,f$length(p1),"reuse") then $ goto reuse_cmd
$ if p1 .eqs. f$extract(0,f$length(p1),"write") then $ goto write_cmd
$ if p1 .eqs. f$extract(0,f$length(p1),"verify") then $ goto verify_cmd
$ wo "Command not recognized [ ''p1' ] "
$! Since command not recognized, do the "help overview" command.
$ p1 = "help"
$ p2 = "overview"
$ goto help_cmd
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process the inquire command
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$inquire_cmd:
$ cdrw_dev_value=""
$ get_device_name:
$ if p2 .nes. "" then $ goto got_device_name
$ inquire p2 "Specify the cdrw device name [dqa0:]"
$ if p2 .eqs. "" then $ p2 = "dqa0:"
$ goto get_device_name
$got_device_name:
$ p2 = p2 - ":" + ":"   ! Add colon if missing
$ cdrw_device = p2 
$ gosub validate_cdrw_device
$ if cdrw_dev_value .eqs. ""
$ then
$     p2 = ""
$     goto get_device_name
$ endif
$!
$ allocate 'cdrw_alloc_value
$! Define foreign command
$ cdrecord := "$sys$system:cdrecord.exe"
$! Now ready to execute
$ cdrecord -inq -prcap -dev='cdrw_dev_value  
$ dealloc 'cdrw_alloc_value
$ verify_state=f$verify('verify_state) ! revert to previous 'set verify' state
$ exit
$!
$!
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$validate_cdrw_device:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! This is a gosub subroutine,
$! which validates the cdrw device name, and which
$! derives the -dev value from the cdrw device name.
$!
$! Arguments
$!
$! cdrw_device		Input/Output
$!				VMS cdrw device (e.g. DQA0:)
$!				This string is uppercased.
$!
$! cdrw_dev_value	Output	String to be used as -dev=x,y,z value
$!				in invocation of the cdrecord.exe image.
$!				For example: 8,0,0  represents DQA0:
$!				On error, returns null string.
$!
$! cdrw_alloc_value             String to be used for device allocation
$! 				and deallocation  
$! Validation to be performed:
$! First two chars must be DQ
$! Third char must be alphabetic [A-Z]
$! Fourth char must be 0 or 1
$! String must be five chars long including colon
$!
$! Default to error return
$  cdrw_dev_value = ""
$  cdrw_alloc_value = ""
$!
$! only allow DQ devices
$ cdrw_device = f$edit( cdrw_device, "UPCASE")
$!
$! First validate as existing, local, DQ device
$ cdrw_dev_exists = f$getdvi(cdrw_device, "exists")
$ if cdrw_dev_exists .eqs. "FALSE" 
$ then 
$     wo "Device ''cdrw_device' does not exist"
$     return
$ endif
$!
$ cdrw_dev_remote = f$getdvi(cdrw_device, "remote_device")
$ if cdrw_dev_remote .eqs. "TRUE"
$ then
$     wo "Device ''cdrw_device' is not local to this node"
$     return  
$ endif
$!
$ cdrw_devnam = f$getdvi(cdrw_device, "alldevnam")
$ cdrw_alloc_value = cdrw_devnam 
$!cdrw_alloc_value is to be used by alloc and dealloc
$!
$! remove leading chars through 1st or 2nd $, if present
$ cdrw_temp = f$element(2,"$",cdrw_devnam)
$ if cdrw_temp .nes. "$"
$ then
$     cdrw_device = cdrw_temp  
$ else
$     cdrw_temp = f$element(1,"$",cdrw_devnam)
$     if cdrw_temp .nes. "$"
$     then
$         cdrw_device = cdrw_temp
$     else  
$!        no $'s found
$         cdrw_device = cdrw_devnam
$     endif
$ endif
$!
$! remove leading underscore, if present
$ cdrw_temp = f$extract(0,1,cdrw_device)
$ if cdrw_temp .eqs. "_" 
$ then 
$     cdrw_temp = f$extract(1,f$length(cdrw_device)-1,cdrw_device)
$ endif
$!
$ if f$extract(0,2,cdrw_device) .nes. "DQ" then $ return 
$!
$! check for alphabetic controller char
$ alphabet := "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
$ alpha_offset = f$locate(f$extract(2,1,cdrw_device),alphabet)
$! if character not found, exit
$ if alpha_offset .eq. f$length(alphabet) then $ return
$!
$! check that fourth char is 0 or 1
$ cdrw_dev_unit=f$extract(3,1,cdrw_device)
$ if cdrw_dev_unit .nes. "0" .and. cdrw_dev_unit .nes. "1" then $ return
$!
$! check that length is 5
$ if f$length(cdrw_device) .ne. 5 then $ return
$!
$! now set the value for cdrw_dev_value needed by cdrecord executable
$ cdrw_dev_value = f$string(8+alpha_offset)+",0,"+cdrw_dev_unit
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$validate_cd_device:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! This is a gosub subroutine,
$! which validates the cd device name.  The cd device name
$! should be a device which can read a cd.
$!
$! Arguments
$!
$! cd_device		Input/Output
$!				VMS cdrw device (e.g. DQA0:)
$!				This string is uppercased.
$!
$! cd_dev_value		Output	String to be used to represent device
$!				which holds cdrom media.
$!				On error, returns null string.
$!
$! cd_alloc_value             String to be used for device allocation
$! 				and deallocation  
$! Validation to be performed:
$!
$ cd_dev_value = ""
$ cd_alloc_value = ""
$ cd_device = f$edit( cd_device, "UPCASE")
$!
$ cd_dev_exists = f$getdvi(cd_device, "exists")
$ if cd_dev_exists .eqs. "FALSE"
$ then
$     wo "Device ''cd_device' is not local to this node"
$     return  
$ endif
$!
$ cd_dev_remote = f$getdvi(cd_device, "remote_device")
$ if cd_dev_remote .eqs. "TRUE"
$ then
$     wo "Device ''cd_device' is not local to this node"
$     return  
$ endif
$!
$ cd_devnam = f$getdvi(cd_device, "alldevnam")
$ cd_alloc_value = cd_devnam 
$!cd_alloc_value is to be used by alloc and dealloc
$!
$! remove leading chars through 1st or 2nd $, if present
$ cd_temp = f$element(2,"$",cd_devnam)
$ if cd_temp .nes. "$"
$ then
$     cd_device = cd_temp  
$ else
$     cd_temp = f$element(1,"$",cd_devnam)
$     if cd_temp .nes. "$"
$     then
$         cd_device = cd_temp
$     else  
$!        no $'s found
$         cd_device = cd_devnam
$     endif
$ endif
$!
$! remove leading underscore, if present
$ cd_temp = f$extract(0,1,cd_device)
$ if cd_temp .eqs. "_" 
$ then 
$     cd_temp = f$extract(1,f$length(cd_device)-1,cd_device)
$ endif
$!
$ cd_dev_value = cd_temp
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ setup_cmd:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Procedure to create a container file.
$! 
$! p2 = filename of the container file (to be created)
$! p3 = logical disk device name to be used (lda1: to lda9999:)
$! p4 = logical disk volume label
$! p5 = number of 512-byte blocks to be allocated to the container file
$!
$! Load and start the LD Driver if necessary.
$ if ( .not. f$getdvi("lda0","exists") )
$ then 
$    @sys$startup:ld$startup
$ endif 
$! Get the container filename if missing
$get_filename:
$ if p2 .nes. "" then $ goto got_filename
$ temp = f$environment("default")
$ wo "The current default disk and directory is: "+temp
$ inquire p2 "Specify container files-11 filename to create"
$ goto get_filename
$got_filename:
$ temp=f$parse(p2)
$ if temp .eqs. "" 
$ then
$     wo "Invalid filename: "+p2
$     p2 = ""
$     goto get_filename
$ endif
$get_logical_device:
$ if p3 .nes. "" then $ goto got_logical_device
$ inquire p3 "Specify Logical Device [lda1:]"
$ if p3 .eqs. "" then $ p3 = "lda1:"
$ goto get_logical_device
$got_logical_device:
$ p3 = p3 - ":" + ":"
$ log_device = p3
$ gosub validate_log_device
$ if log_device .eqs. "" 
$ then
$     p3 = "" 
$     goto get_logical_device
$ endif
$get_volume_label:
$ if p4 .nes. "" then $ goto got_volume_label
$ inquire p4 "Specify CD Volume Label" 
$ if p4 .nes. "" then $ goto got_volume_label
$ goto get_volume_label
$got_volume_label:
$get_block_count:
$ if p5 .nes. "" then $ goto got_block_count
$ Write sys$output "Block Count: # of 512-byte blocks to allocate"
$ write sys$output "Must be multiple of 4"
$ inquire p5 "Specify # of 512-byte blocks [1250000 == 640MB]
$ if p5 .eqs. "" then $ p5 = 1250000
$! Now round up to multiple of 4
$ p5 = ( ( p5 + 3 ) / 4) * 4
$ goto get_block_count
$!
$got_block_count:
$ gosub release_ld  
$ ld create /size='p5 /contig 'p2 
$ ld connect 'p2 'log_device
$ init 'log_device 'p4
$ mount 'log_device 'p4
$ wo := "write sys$output"
$ wo ""
$ wo "The container file has been mounted as Logical Device ''p3'"
$ wo "Now you may write to ''p3', using VMS commands
$ wo "or applications to add files and directories to the device."
$ wo "When you are ready to write the cd, insert blank CD-R media into"
$ wo "the drive.  Then execute the @sys$manager:cdrecord write procedure."
$! time to exit
$ verify_state=f$verify('verify_state) ! revert to previous 'set verify' state
$ exit 1
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ reuse_cmd:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Procedure to reuse a container file.
$! The file will be initialized as empty.
$! 
$! p2 = filename of the existing container file (to be reused)
$! p3 = logical disk device name to be used (lda1: to lda9999:)
$! p4 = logical disk volume label
$!
$! Load and start the LD Driver if necessary.
$ if ( .not. f$getdvi("lda0","exists") )
$ then 
$    @sys$startup:ld$startup
$ endif 
$! Get the container filename if missing
$r_get_filename:
$ if p2 .nes. "" then $ goto r_got_filename
$ inquire p2 "Specify container files-11 filename to reuse"
$r_got_filename:
$ gosub r_validate_file
$ if p2 .nes. "" then $ goto r_get_logical_device
$ goto r_get_filename
$r_get_logical_device:
$ if p3 .nes. "" then $ goto r_got_logical_device
$ inquire p3 "Specify Logical Device [lda1:]"
$ if p3 .eqs. "" then $ p3 = "lda1:"
$ goto r_get_logical_device
$r_got_logical_device:
$ p3 = p3 - ":" + ":"
$ log_device = p3
$r_get_volume_label:
$ if p4 .nes. "" then $ goto r_got_volume_label
$ inquire p4 "Specify CD Volume Label" 
$ if p4 .nes. "" then $ goto r_got_volume_label
$ goto r_get_volume_label
$r_got_volume_label:
$! release existing logical device, if in use
$ gosub release_ld
$!    
$ ld connect 'p2 'log_device
$ init 'log_device 'p4
$ mount 'log_device 'p4
$ wo := "write sys$output"
$ wo ""
$ wo "The container file has been mounted as Logical Device ''p3'"
$ wo "Now you may write to ''p3', using VMS commands"
$ wo "or applications to add files and directories to the device."
$ wo "When you are ready to write the cd, insert blank CD-R media into"
$ wo "the drive.  Then execute the @sys$manager:cdrecord write procedure."
$! time to exit
$ verify_state=f$verify('verify_state) ! revert to previous 'set verify' state
$ exit 1
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ r_validate_file:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Gosub procedure to validate the specification of a previously used
$! container file
$! The filename is specified in p2.
$ temp=f$parse(p2)
$ if temp .eqs. "" 
$ then 
$     wo "Invalid filename: "+p2
$     p2 = ""
$     return
$ endif
$ if f$search(p2) .eqs. ""
$ then
$     wo "Filename not found: "+p2
$     p2 = ""
$     return
$ endif
$ return
$!!!!!!!
$ release_ld:
$ if f$getdvi("''log_device'", "EXISTS")
$ then 
$    if f$getdvi("''log_device'", "MOUNTCNT") .nes. "0"
$    then 
$       dismount 'log_device
$    endif 
$    ld disconnect 'log_device
$ endif
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ write_cmd:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Procedure to write a cd.
$!
$! This is the procedure to write a cd, given that the operator has
$! previously "staged" the data to be written, using 
$! either the @cdrecord setup or @cdrecord reuse procedures,
$! and then has written the Logical Device device LDAn: with the data to
$! be copied to the CD-R media. 
$!
$! p2 = filename of the container file 
$! p3 = logical disk device name being used (lda1: to lda9999:)
$! p4 = the cdrw device name (dqa0:)
$! p5 = disable cdrw laser (1=disable or 0=enable )
$! p6 = override recording speed (1-99; 0=>no override)
$!      The maximum recording speed is dependent upon the media speed rating,
$!      the drive rating, and the system load.  
$! p7 = set process base priority (1-63; 0=>no change)
$! p8 = reset priority after write? (y|n)
$!
$ cdrw_dev_value=""
$! Load and start the LD Driver if necessary.
$ if ( .not. f$getdvi("lda0","exists") )
$ then 
$    @sys$startup:ld$startup
$ endif 
$! Get container filename
$ w_get_filename:
$ if p2 .nes. "" then $ goto w_got_filename 
$ inquire p2 "Specify the prepared files-11 filename"
$w_got_filename:
$ gosub r_validate_file
$ if p2 .nes. "" then $ goto w_get_logical_device
$ goto w_get_filename
$w_get_logical_device:
$ if p3 .nes. "" then $ goto w_got_logical_device
$ inquire p3 "Specify Logical Device [lda1:]"
$ if p3 .eqs. "" then $ p3 = "lda1:"
$ goto w_get_logical_device
$w_got_logical_device:
$ p3 = p3 - ":" + ":"
$ log_device = p3
$! 
$ w_get_device_name:
$ if p4 .nes. "" then $ goto w_got_device_name
$ inquire p4 "Specify the cdrw device name [dqa0:]"
$ if p4 .eqs. "" then $ p4 = "dqa0:"
$ goto w_get_device_name
$ w_got_device_name:
$ p4 = p4 - ":" + ":"   ! Add colon if missing
$ cdrw_device = p4 
$ gosub validate_cdrw_device
$ if cdrw_dev_value .eqs. ""
$ then
$     p4 = ""
$     goto w_get_device_name
$ endif
$! Now get disable laser option
$ w_get_disable_laser:
$ if p5 .nes. "" then $ goto w_got_disable_laser
$ inquire p5 "Disable laser [1=disable, 0=enable]"
$ if p5 .eqs. "1" .or. p5 .eqs. "0" then $ goto w_got_disable_laser
$ p5 = ""
$ goto w_get_disable_laser
$ w_got_disable_laser:
$ dummy := ""
$ if p5 .eqs. "1" then $ dummy := "-dummy"
$!
$! Now get the speed option
$ w_get_speed:
$ if p6 .nes. "" then $ goto w_got_speed
$ inquire p6 "Override speed [1-99], else 0 => no override"
$ w_got_speed:
$ speed = f$integer(p6)
$ if (speed .lt. 0 .or. speed .ge. 100)
$ then
$     p6 = ""
$     goto w_get_speed
$ endif 
$ if speed .eq. 0 
$ then 
$     speed_option := ""
$ else
$     speed_option := "-speed=''speed'"
$ endif
! Now get the process base priority
$ w_get_priority:
$ cur_priority = f$getjpi("","PRI")
$ if p7 .nes. "" then $ goto w_got_priority
$ cur_priority = f$getjpi("","PRI")
$ wo "Current process priority is ''cur_priority'"
$ inquire p7 "New process priority [1-63], else 0 => no change"
$ w_got_priority:
$ priority = f$integer(p7)
$ if priority .lt. 0 .or. priority .gt. 63 
$ then
$     p7 = ""
$     goto w_get_priority
$ endif
$ if priority .ne. 0
$ then
$    set process/priority='priority   
$ endif
$!
$!
$! dismount and ld disconnect 'log_device
$ gosub release_ld
$!
$ set file/end_of_file/nomove/nobackup 'p2
$ allocate 'cdrw_alloc_value
$! Define foreign command
$ cdrecord := "$sys$system:cdrecord.exe"
$! Now execute the write cdr program
$ cdrecord -dev='cdrw_dev_value -driveropts=burnproof 'dummy 'speed_option 'p2 
$ dealloc 'cdrw_alloc_value
$ if priority .ne. 0 
$ then
$    if p8 .nes. "" then $ goto w_got_reset
$ w_get_reset: 
$    inquire p8  "Reset process priority to ''cur_priority'? [y|n]"
$    if p8 .nes. "Y" .and. p8 .nes. "N" then $ goto w_get_reset 
$ w_got_reset:
$    if p8 .eq. "Y" then $ set process /priority='cur_priority
$ endif
$ verify_state=f$verify('verify_state) ! revert to previous 'set verify' state
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ verify_cmd:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Procedure to verify that the system can read the data from a newly written
$! cd, and that the data matches the data copied.
$! 
$! p2 = filename of the container file (copied)
$! p3 = logical disk device name to be used (lda1: to lda9999:)
$! p4 = logical disk volume label
$! p5 = vms cd device name
$!
$! Load and start the LD Driver if necessary.
$ if ( .not. f$getdvi("lda0","exists") )
$ then 
$    @sys$startup:ld$startup
$ endif 
$! Get the container filename if missing
$get_filename2:
$ if p2 .nes. "" then $ goto got_filename2
$ temp = f$environment("default")
$ wo "The current default disk and directory is: "+temp
$ inquire p2 "Specify container files-11 filename to verify"
$ goto get_filename2
$got_filename2:
$ temp=f$parse(p2)
$ if temp .eqs. "" 
$ then
$     wo "Invalid filename: "+p2
$     p2 = ""
$     goto get_filename2
$ endif
$get_logical_device2:
$ if p3 .nes. "" then $ goto got_logical_device2
$ inquire p3 "Specify Logical Device [lda1:]"
$ if p3 .eqs. "" then $ p3 = "lda1:"
$ goto get_logical_device2
$got_logical_device2:
$ p3 = p3 - ":" + ":"
$ log_device = p3
$ gosub validate_log_device
$ if log_device .eqs. "" 
$ then 
$     p3 = ""
$     goto get_logical_device2
$ endif
$get_volume_label2:
$ if p4 .nes. "" then $ goto got_volume_label2
$ inquire p4 "Specify CD Volume Label" 
$ if p4 .nes. "" then $ goto got_volume_label2
$ goto get_volume_label2
$got_volume_label2:
$get_cd_device:
$ if p5 .nes. "" then $ goto got_cd_device
$ inquire p5 "Specify cd device [dqa0:]"
$ if p5 .eqs. "" then $ p5 = "dqa0:"
$got_cd_device:
$ p5 = p5 - ":" + ":"
$ cd_device = p5
$ gosub validate_cd_device
$ if cd_dev_value .eqs. "" .or. cd_alloc_value .eqs. ""
$ then
$     p5 = ""
$     goto get_cd_device
$ endif
$ gosub release_ld ! dismount and disconnect log_device
$ ld connect 'p2 'log_device
$ allocate 'cd_alloc_value
$ mount /write_lock 'log_device 'p4
$ mount /write_lock 'p5 'p4
$ backup/image/compare 'log_device 'p5
$ backup_stat = $status
$ backup_stat_msg = f$message(backup_stat)
$ wo "Status of verification = "+backup_stat_msg
$ gosub release_ld ! dismount and disconnect log_device
$ dismount 'p5
$ dealloc 'cd_alloc_value
$ exit 
$!!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ r_validate_file:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Gosub procedure to validate the specification of a previously used
$! container file
$! The filename is specified in p2.
$! On error, p2 is returned as the null string.
$ temp=f$parse(p2)
$ if temp .eqs. "" 
$ then 
$     wo "Invalid filename: "+p2
$     p2 = ""
$     return
$ endif
$ if f$search(p2) .eqs. ""
$ then
$     wo "Filename not found: "+p2
$     p2 = ""
$     return
$ endif
$ return
$!!!!!!!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ validate_log_device:
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! gosub procedure to validate an available logical device specification
$! The specified device is specified in log_device.
$!
$! Validate that the device specification is valid.
$!    First 3 letters must be LDA; followed by unit number 1 to 9999.
$! Validate that the device is not in use.
$!
$ temp=f$edit(log_device,"UPCASE")
$ temp= temp - ":" 
$ if f$extract(0,3,temp      ) .nes. "LDA"
$ then
$     wo "Logical Device must start with LDA"
$     log_device=""
$     return
$ endif
$ ld_unit = f$extract(3,f$length(temp)-3,temp)
$ if ld_unit .lt. 1 .or. ld_unit .gt. 9999 
$ then
$     wo "Logical Device unit number must be in range [1-9999]."
$     log_device=""
$     return
$ endif
$ if f$getdvi(temp,"exists") 
$ then
$     wo "Logical Device is already in use: ''temp'"
$     wo " "
$     wo "    To resolve, try a different Logical Device unit,"
$     wo "    or exit and issue $ ld disconnect ''temp'"
$     wo " "
$     log_device=""
$     return
$ endif
$ return
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process the help command
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_cmd:
$! Scan for first argument for the help command
$ p2 = f$edit(p2,"LOWERCASE")
$ if p2 .eqs. f$extract(0,f$length(p2),"overview") then goto help_overview_cmd
$ if p2 .eqs. f$extract(0,f$length(p2),"inquire") then goto help_inquire_cmd
$ if p2 .eqs. f$extract(0,f$length(p2),"setup") then goto help_setup_cmd
$ if p2 .eqs. f$extract(0,f$length(p2),"reuse") then goto help_reuse_cmd
$ if p2 .eqs. f$extract(0,f$length(p2),"write") then goto help_write_cmd
$ if p2 .eqs. f$extract(0,f$length(p2),"verify") then goto help_verify_cmd
$! 
$!
$ help_overview_cmd: 
$! START OF HELP OVERVIEW
$ type/page=save sys$input
   CDRECORD.COM
   
   Procedures to write, and to prepare for writing, cd-r media.
   
   Privileges required to write cd's: diag, phy_io, sysprv.
   Privilege required to alter execution priority: altpri.

   To invoke this procedure:
   @sys$manager:cdrecord arg1, arg2, ...
   
   If you omit arguments, you will be prompted.
   First parameter values:  [ help | inquire | setup | reuse | write | verify ]
   
   The additional parameter values are dependent upon the first parameter:
  
   help [ overview | inquire | setup | reuse | write | verify ]
  
   inquire [ cdrw device name ] 
  
  
   setup [container filename] [logical disk device name]
  	[logical disk volume label]
  	[number of 512-byte blocks to be written]
  
   reuse [container filename] [logical disk device name]
  	[logical disk volume label]
  
   write [container filename] [logical disk device name]
  	[cdrw device name] [cdrw laser disable = 1]
  	[override cdrw recording speed (1-99,0)]
	[new process base priority (1-63,0)]
  	[reset priority after write (y|n)]

   verify [container filename] [logical disk device name]
	[logical disk volume label] [cdrw device name]

  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  CD Burning Directions
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  The cd "burning" procedure requires three steps:

  1.  The user invokes the setup command.  This procedure defines a 
  contiguous "container file" , which has a size greater than the total
  amount of data to be written to the cd.  The procedure also defines
  a "Logical Disk" device, and "connects" it to the container file.
  For purposes of an example, the container file might be named 
  DKA0:[CDRW]lda1.dsk, and the Logical Disk device might be lda1:.
  VMS now treats the lda1: device as a virtual device, which can be
  processed by any VMS command just as if it were a real physical device.
  All information that would be written to a real device volume is now written
  to the region of disk memory allocated to lda1.dsk, the "container file".

  2.  The user now issues writes to the Logical Disk device, with any
  standard VMS command (DCL commands: Copy, Backup, Create/dir etc., or
  with a VMS application issuing writes to the Logical Disk Device.

  3.  The user then invokes the write command, which writes the
  contents of the container file onto the blank CD-R media mounted in the
  CD ReWritable device.  It is sometimes worth doing a "test" run first,
  with the cdrw laser disabled, to insure that no problems occur.

  4.  Once the data has been written to the CD-R, the user may invoke the 
  verify command.  This will read the data in the Logical Disk device, and
  compare it to the data just written to the CD-R media.
   
$ exit 1
$! END of HELP OVERVIEW 
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process help inquire
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_inquire_cmd:
$type/page=save sys$input
 INQUIRE [cdrw device name]

 where	cdrw device name  is the VMS device name (DQA0:, for example)

The inquire command provides information about the physical
characteristics of the cdrw device, as reported by the device.  If the
device you selected is not a cd-recordable device (such as a disk, or
cdrom reader), the output will indicate this.  Note that the characteristics
listed are not necessarily supported by VMS.

Other output shown includes the approximate read and write speed
provided by the device; note, however, that the media itself may
require a slower speed.  A 1x device speed is defined as a transfer rate
of 150 kB/second.  This is approximately the speed required to
play an audio cd.


$ exit 1
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process help setup
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_setup_cmd:
$type/page=save sys$input

 SETUP [container filename] [logical disk device name]
       [logical disk volume label]
       [number of 512-byte blocks to be written]

 where 
       container filename	files-ll filename used to hold all
                                data to be written to the cd

       logical disk device     	unused ld device name (LDA1: to LDA9999:)
           name           
	
       logical disk volume	Any valid VMS volume name string
           label

	number of 512-byte	Specifies size of the container file.
            blocks to be        Rounded up to a multiple of 4.
            written

 Description:
       
    This procedure creates a container file and connects it to a
 Logical Device.  Upon completion, the user may write to the
 Logical Device, adding files and directories.


$ exit 1
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process help reuse
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_reuse_cmd:
$type/page=save sys$input

 REUSE [container filename] [logical disk device name]
       [logical disk volume label]

 where
       container filename	existing files-ll filename used to hold all
                                data to be written to the cd

       logical disk device     	unused ld device name (LDA1: to LDA9999:)
           name           
	
       logical disk volume	Any valid VMS volume name string
           label
	
 Description:
    
    This procedure allows you to reuse an existing container file.  ALL
 DATA IN THE CONTAINER FILE IS LOST!!!.  The purpose of this procedure
 is to allow the user to reuse the contiguous space occupied by a 
 container file, whose data is no longer needed.

$ exit 1

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process help write
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_write_cmd:
$type/page=save sys$input

 WRITE  [container filename] [logical disk device name]
	[cdrw device name] [cdrw laser disable = 1]
	[override cdrw recording speed (1-99,0)]
        [modify process base priority (1-63; 0=>no change)]
        [reset priority after write? (y|n)]

 where
       container filename	files-ll filename used to hold all
                                data to be written to the cd

       logical disk device     	ld device name (LDA1: to LDA9999:)
           name           

       cdrw device name		valid VMS cdrw device (DQA0:)

       cdrw laser disable	1=> disable the laser=> TEST
				0=> enable the laser => WRITE CD
        
       override cdrw		0 => do not override
           recording speed      1-99=> override speed selected
                                       by the program 

       modify process priority? 0=> do not modify
				1-63=> modify process priority

       reset priority after	y => yes, reset priority
           write        	n => no.

 Description:

    This procedure writes the content of the container file to the cd-r
 media.  If the cdrw laser is disabled, this procedure tests the writing
 of the media.  

 During the operation of this procedure, the container file is
 disconnected from the  Logical Device.  The Cd-Writing device
 is allocated, so that it may not be used by another process during
 the write operation.  The priority of the current process is
 modified, if requested.  The actual writing process is executed. The
 process priority is restored to its previous value, if requested.  Finally,
 the Cd-Writing device is deallocated.

 This command may be repeated to burn another identical cd-r media.
    
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Process help verify
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ help_verify_cmd:
$type/page=save sys$input

 VERIFY  [container filename] [logical disk device name]
	 [logical disk volume label] [cd device name]

 where 
       container filename	files-ll filename used to hold all
                                data that was written to the cd

       logical disk device     	ld device name (LDA1: to LDA9999:)
           name                   (can be same device that was used)
	
       logical disk volume	VMS volume name string that was used
           label

       cd device name		cd drive that contains cd-r media to be
				verified

 Description:

    This procedure compares the Logical Device data to written
    CD-R media.  Its purpose is to verify that no errors occurred.
    The steps executed by this procedure are:  
    1.  Reconnect the container file to a Logical Device
    2.  Allocate the CD device.
    3.  Mount the Logical Device and the CD device.
    4.  Run the VMS command: backup/image/compare.
    5.  Deallocate the CD device.
    6.  Disconnect the container file from the Logical Device.
    7.  Dismount the CD Device and the Logical Device.

$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ exit 1
