$! CDRECORD_RUN.COM  
$! This is the procedure to write a cd, given that the operator has
$! previously "staged" the data to be written, using CDRECORD_SETUP.COM. 
$!
$! p1 = filename of the container file created
$! p2 = logical disk device name being used (lda1: to lda9999:)
$! p3 = logical disk volume label
$! p4 = number of 512-byte blocks to be written to the cd
$! p5 = the cdrw device name (dqa0:)
$! p6 = disable cdrw laser (1 or 0)
$! p7 = recording speed (1x, 2x, ...)
$!      The maximum recording speed is dependent upon the media speed rating,
$!      the drive rating, and the system load.  
$!
$ dismount 'p2
$ ld disconnect 'p2
$ set file/end_of_file/nomove/nobackup 'p1
$ allocate 'p5
$! Derive the -dev value from the cdrw device name
$ if "''p5'" .eqs. "DQA0" then cdrw_dev_value := "8,0,0"
$ if "''p5'" .eqs. "DQA1" then cdrw_dev_value := "8,0,1"
$ if "''p5'" .eqs. "DQB0" then cdrw_dev_value := "9,0,0"
$ if "''p5'" .eqs. "DQB1" then cdrw_dev_value := "9,0,1"
$ if "''p5'" .eqs. "DQC0" then cdrw_dev_value := "10,0,0"
$ if "''p5'" .eqs. "DQC1" then cdrw_dev_value := "10,0,1"
$ if "''p5'" .eqs. "DQD0" then cdrw_dev_value := "11,0,0"
$ if "''p5'" .eqs. "DQD1" then cdrw_dev_value := "11,0,1"
$ show sym cdrw_dev_value
$!
$ dummy := ""
$ if 'p6 .eq. 1 then dummy := "-dummy" 
$ show sym dummy
$! 
$ speed := ""
$ if "''p7'" .nes. "" then speed := "-speed=''p7'"
$ show sym speed
$ cdrecord -dev='cdrw_dev_value 'dummy 'speed  'p1 
$ dealloc 'p5
$ exit
