$ VRFY = 'F$VERIFY( 0 )'
$!
$!	RM_RET_ENT.COM -
$!			21-Oct-1997 by David J. Dachtera
$!
$!	Procedure to delete entries retained on queues. No distinction
$!	is made between "Retained on error" and "Retained on completion".
$!
$!	Parameters:
$!	P1 =	The Queue Name - defaults to SYS$PRINT. Value may be
$!		any valid queue name or a comma-separated list of 
$!		queue names. Wildcards are supported.
$!	P2 =	The Queue Type - defaults to "PRINT" (PRINTER,TERMINAL)
$!	P3 =	The delta time for comparison - defaults to "-1-"
$!		(the current date/time minus 24 hours).
$!
$!	Usage Hints:
$!
$!	To delete all retained entries on all print queues, specify P1
$!	as "*", P2 as "" and P3 as "-0".
$!	To delete all retained entries on all batch queues, specify P1
$!	as "*", P2 as "BATCH" and P3 as "-0".
$!	To delete all retained entries on all server queues, specify P1
$!	as "*", P2 as "SERVER" and P3 as "-0".
$!	To delete all retained entries on all queues, specify P1 as "*", 
$!	P2 as "BATCH,SYMBIONT" and P3 as "-0".
$!
$! Modified 22-Oct-1997 by David J. Dachtera:
$!	If the user has OPER privilege, we should be able to delete 
$!	ALL_JOBS that are retained.
$!
$!------------------------------------------------------------------------------
$ ON WARNING THEN GOTO ERR_EXIT
$ SAY := WRITE SYS$OUTPUT
$! IF P1 .EQS. "" THEN P1 := SYS$PRINT
$ IF P1 .EQS. "" THEN GOTO SHOW_USAGE
$ IF P2 .EQS. "" THEN P2 := PRINTER,TERMINAL
$ IF P3 .EQS. "" THEN P3 := "-1-"
$ DEBUG = 0
$! DEBUG = 1
$ CMPD8 = F$CVTIME( P3,, )
$ JBTYP := RETAINED_JOBS
$ IF F$PRIV( "OPER" ) THEN JBTYP := 'JBTYP',ALL_JOBS
$ FJBTYP := FREEZE_CONTEXT,'JBTYP'
$ CNTR = 1
$ LIST_1 :=
$ PNTR = 0
$P1_LOOP:
$ ELEM = F$ELEM( PNTR, ",", P1 )
$ PNTR = PNTR + 1
$ IF ELEM .EQS. "" THEN GOTO P1_LOOP
$ IF ELEM .EQS. "," THEN GOTO EXIT_P1_LOOP
$Q_LOOP:
$ ELEM_LEN = F$LENGTH( ELEM )
$ IF (F$LOCATE( "*", ELEM ) .EQ. ELEM_LEN) -
.AND.(F$LOCATE( "%", ELEM ) .EQ. ELEM_LEN)
$ THEN
$ QNAME = F$GETQUI( "DISPLAY_QUEUE", "QUEUE_NAME", ELEM, "''P2',WILDCARD" )
$ ELSE
$ QNAME = F$GETQUI( "DISPLAY_QUEUE", "QUEUE_NAME", ELEM, "''P2'" )
$ ENDIF
$ IF QNAME .EQS. "" THEN GOTO EXIT_Q_LOOP
$J_LOOP:
$ RET_VAL = F$GETQUI("DISPLAY_JOB","ENTRY_NUMBER",,JBTYP)
$ IF RET_VAL .EQS. "" THEN GOTO EXIT_J_LOOP
$ SUBD8 = F$GETQUI("DISPLAY_JOB","SUBMISSION_TIME",,FJBTYP)
$ IF	F$CVTIME( SUBD8,, ) .LTS. CMPD8
$ THEN
$	GOSUB SAVE_ENTRY
$	SAY F$FAO( " Queue: !AS, Entry !AS, submitted !AS", -
		QNAME, "''RET_VAL'", SUBD8 )
$ ENDIF
$ GOTO J_LOOP
$!
$EXIT_J_LOOP:
$ GOTO Q_LOOP
$!
$EXIT_Q_LOOP:
$ GOTO P1_LOOP
$!
$EXIT_P1_LOOP:
$ IF	LIST_1 .NES. ""
$ THEN
$	SAY ""
$	SAY " Deleting entries..."
$ ENDIF
$ PNTR = 0
$P_LOOP:
$ PNTR = PNTR + 1
$ SYM = LIST_'PNTR'
$ IF	SYM .NES. ""
$ THEN
$	IF	DEBUG
$	THEN
$		SAY F$FAO( "$ DELETE/NOLOG/ENTRY=(!AS)", SYM )
$	ELSE
$		DELETE/NOLOG/ENTRY=('SYM')
$	ENDIF
$ ENDIF
$ IF PNTR .LT. CNTR THEN GOTO P_LOOP
$ SAY ""
$ SAY " Done."
$!
$ERR_EXIT:
$! IF DEBUG THEN SHOW SYMBOL/ALL
$ EXIT ($STATUS .OR. %X10000000) + (0 * F$VERIFY( VRFY ))
$!
$SHOW_USAGE:
$ SAY " Usage: @[ddcu:[<dir>]]RM_RET_ENT queue_name[ queue_type[ delta_time]]"
$ EXIT
$!
$SAVE_ENTRY:
$ IF	LIST_1 .EQS. ""
$ THEN
$	SAY ""
$	SAY " The following entries will be DELETEd:"
$ ENDIF
$ IF	F$LENGTH( LIST_'CNTR' ) .GE. 200
$ THEN
$	CNTR = CNTR + 1
$	LIST_'CNTR' :=
$ ENDIF
$ SYM_NAME := LIST_'CNTR'
$ IF LIST_'CNTR' .NES. "" THEN -
$ LIST_'CNTR' = LIST_'CNTR' + ","
$ LIST_'CNTR' = LIST_'CNTR' + "''RET_VAL'"
$ RETURN
