$! Procedure to find out what is executed for a certain command.
$!  P1  is the command verb to be examined.
$
$! The following possibilities are checked in the given order:
$! 1 DCL symbols
$! 2 DCL command definitions
$! 3 DCL$PATH search
$
$! F.Z. 16-Aug-1995: Creation
$! F.Z.  9-Nov-1995: Checked for legal characters to prevent confusion.
$
$! Get required parameter
$
$ CHECK P1:
$ if P1 .eqs. ""
$ then
$  if f$mode() .eqs. "INTERACTIVE"
$  then
$   INQUIRE P1 "Command verb"
$   goto CHECK P1
$  else
$   exit %X00038048  ! INSFPRM
$  endif
$ endif
$
$! Check that only legal characters are used.
$
$ STRIP = f$edit(P1, "UPCASE")
$ STRIP LEGAL:
$ STRIP_OLD = STRIP
$ STRIP = STRIP -
  - "0" - "1" - "2" - "3" - "4" - "5" - "6" - "7" - "8" - "9"
$ STRIP = STRIP -
  - "A" - "B" - "C" - "D" - "E" - "F" - "G" - "H" - "I" - "J"
$ STRIP = STRIP -
  - "K" - "L" - "M" - "N" - "O" - "P" - "Q" - "R" - "S" - "T"
$ STRIP = STRIP -
  - "U" - "V" - "W" - "X" - "Y" - "Z" - "$" - " "
$ if STRIP_OLD .nes. STRIP then goto STRIP_LEGAL
$ if STRIP .nes. ""
$ then
$  write sys$output "Illegal characters: " + STRIP
$  exit %XFCC  ! Invalid argument
$ endif
$
$! Test DCL symbols
$
$ if f$type('P1') .nes. ""
$ then
$  write sys$output P1 + " is a DCL foreign command:"
$  show symbol 'P1'
$  exit 1
$ endif
$
$! Test DCL verbs
$
$! DCLEXTRACT := $KVI$SYSTEM:DCLEXTRACT        ! Also known as VERB
$ SCRATCH FILE = "WHICH " + f$getjpi("","PID")
$ SCRATCH FILE = f$parse("SYS$SCRATCH:;0", SCRATCH FILE)
$ VERB = f$extract (0, 4, P1)  ! DCL uses 4 characters at max.
$ VERB /output='SCRATCH FILE' 'VERB'*
$ define/user sys$output  NLA0:
$ define/user sys$error  NLA0:
$ SEARCH /nooutput 'SCRATCH FILE' "define verb", 'VERB' /match=AND
$ if f$integer($STATUS) .eq. 1
$ then
$  write sys$output P1 + " is a DCL verb:"
$  search 'SCRATCH FILE' "define verb", 'VERB' /match=AND /nohigh
$  delete /nolog 'f$parse(";*", SCRATCH FILE)'
$  exit 1
$ else
$  delete /nolog 'f$parse(";*", SCRATCH FILE)'
$ endif
$
$! Test DCL$PATH
$
$! The following is not completely correct. P1 should be used as a 
filename and
$! the string "DCL$PATH:.*" should be added as a default name. In DCL 
this does
$! not work, because f$parse uses only the first translation of a 
search-list
$! logical-name.
$! We try to come close, by using a different approach if no logical 
name
$! exists, but we cannot be completely correct.
$
$ if f$trnlnm (P1) .nes. ""
$ then
$
$! A logical name exists.
$! If it includes a device or directory there is again a different case.
$
$  P1 X = f$parse (P1, "X:[X].*", , , "SYNTAX ONLY")
$  P1 Y = f$parse (P1, "Y:[Y].*", , , "SYNTAX ONLY")
$  if P1 X .eqs. P1 Y
$  then
$
$! The logical name includes device and directory.
$
$   PATH SEARCH = f$parse (P1, ".*")
$  else if (P1 X - "X:[X]") .eqs. (P1 Y - "Y:[Y]")
$   then
$
$! The logical name does not specify device and directory
$
$    PATH SEARCH = "DCL$PATH:" + P1 X - "X:[X]"
$   else
$
$! The logical name specifies either device or directory, this case we 
cannot
$! handle in DCL.
$
$    write sys$output P1 + " may be in DCL$PATH:"
$    directorys/nohead/notrail 'P1'
$    exit 1
$   endif
$  endif
$ else
$  PATH SEARCH = "DCL$PATH:" + P1 + ".*"
$ endif
$
$ !show symbol PATH SEARCH
$ PATH SEARCH:
$ PATH FILE = f$search (PATH SEARCH)
$ if PATH FILE .nes. ""
$ then
$  if (f$parse (PATH FILE, , , "TYPE") .nes. ".COM") .and. -
   (f$parse (PATH FILE, , , "TYPE") .nes. ".EXE")
$  then
$   goto PATH SEARCH
$  endif
$  write sys$output P1 + " is found in DCL$PATH:"
$  write sys$output PATH FILE
$  exit 1
$ endif
$
$ write sys$output P1 + " cannot be found."
$ exit %X38090     ! Unrecognized cmd
