	function dix_con_is_filler(control,nbit,offset,typ,data)
	implicit none
c
c Return true if data is all filler
c
	integer*4 control
	integer*4 nbit			!:i: #bits
	integer*4 offset		!:i: offset in data
	integer*4 typ			!:i: datatype
	byte data(*)			!:i: the data
	logical*4 dix_con_is_filler	!:f: return true if filler
c#
	include 'dix_def.inc'
c
	character*(max_str_len) line                                             
	integer*4 nkar,nb_f
c
	logical*4 dix_con_intasc
	record /des_rec/ des_rec	!:i: description
c##
	des_rec.ent_type = typ
	des_rec.size = nbit
	des_rec.fld_len = 0
	des_rec.fld_adr = %loc(nkar)	!take anything
c
	des_rec.bit_offset = offset
	des_rec.translate = translate_nor
c
c
c Let con_int_intasc solve the problem (but in hex mode)
c
	dix_con_is_filler = .not. dix_con_intasc(nbit/8,des_rec,data,line,
     1                         nkar,.false.,nb_f,.false.,control)
	return
	end
c
	subroutine dix_con_type_intasc(nk,data,type,value,nkar)
	implicit none
	include 'dix_def.inc'
c
c A simplified interface to dix_con_intasc
c
	integer*4 nk
	byte data(*)
	integer*4 type
	character*(*) value
	integer*4 nkar
c
	record /des_rec/ des_rec
	integer*4 k
c
c
	des_rec.ent_type = type
	des_rec.fld_len = 0
	des_rec.fld_adr = 0
	des_rec.bit_offset = 0
	des_rec.size = 8*nk
	des_rec.translate = translate_nor
	call dix_con_intasc(nk,des_rec,data,value,nkar,.false.,k,.false.,0)
	return                     
	end

	function dix_con_intasc(max_size,des_rec,data,value,nkar,hex,
     1                          max_len,include_binary,control)
	implicit none
c
c Convert data from binary to ascii in all modes
c
	include 'dix_def.inc'
	integer*4 max_size		!:i: size of remaining data
	record /des_rec/ des_rec	!:i: description
	byte data(*)			!:i: the data
	character*(*) value		!:o: the text
	integer*4 nkar			!:o: the size
	logical*4 hex			!:i: hex translation wanted
	integer*4 max_len		!:o: max length needed for ascii
	logical*4 include_binary	!:i: Include unprintables in text
	record /control/ control
	logical*4 dix_con_intasc	!:f: if true than nonempty
c#
	integer*4 nk,typ,fldnam(2),temp(2),nk2,offs,limit
	logical stat
c
c The conversion routines per type
c
	logical*4 dix_con_int_intasc,dix_con_real_intasc
	logical*4 dix_con_realg_intasc
	logical*4 dix_con_log_intasc,dix_con_dat_intasc
	logical*4 dix_con_uic_intasc,dix_con_bits_intasc
	logical*4 dix_con_chr_intasc,dix_con_str_intasc
	logical*4 dix_con_uint_intasc,dix_con_lstr_intasc
	logical*4 dix_con_zstr_intasc,dix_con_hstr_intasc
	logical*4 dix_con_hex_intasc,dix_con_prot_intasc
	logical*4 dix_con_oct_intasc
	logical*4 dix_con_revint_intasc,dix_con_fid_intasc
	logical*4 dix_con_wstr_intasc,dix_con_bin_intasc
	logical*4 dix_con_diskmap_intasc
	logical*4 dix_con_identifier_intasc
	logical*4 dix_con_acl_intasc,dix_inter_execute
c
	typ = des_rec.ent_type
	nk = min((des_rec.size+7)/8,max_size)
	fldnam(1) = des_rec.fld_len
	fldnam(2) = des_rec.fld_adr
	value = ' '
c
	offs = des_rec.bit_offset/8+1
c
	nk2 = 1
	if(des_rec.size .gt.  8) nk2 = 2
	if(des_rec.size .gt. 16) nk2 = 3
	if(des_rec.size .gt. 24) nk2 = 4
	if(des_rec.size .gt. 32) nk2 = 8
	if(nk2 .gt. max_size) nk2 = max_size
	if(hex .or. des_rec.translate .ne. translate_nor) then
c
c Explicit hex asked, or the description line contains /hex or something like that
c
	  if(hex .or. des_rec.translate .eq. translate_hex) then
	    stat   = dix_con_hex_intasc(des_rec.bit_offset,
     1                  des_rec.size,data,value,nkar,typ,max_len)
	  elseif(des_rec.translate .eq. translate_bin) then
	    stat   = dix_con_bin_intasc(des_rec.bit_offset,
     1                  des_rec.size,data,value,nkar,max_len)
	  elseif(des_rec.translate .eq. translate_oct) then
	    stat   = dix_con_oct_intasc(des_rec.bit_offset,
     1                  des_rec.size,data,value,nkar,max_len)
	  endif
	else
c
c Normal conversion
c
	  if    (typ .eq. enttyp_int) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,nk2)
	    stat = dix_con_int_intasc(nk2,temp,value,nkar,fldnam,control)
	    max_len = 60
	  elseif(typ .eq. enttyp_uint) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,nk2)
	    stat = dix_con_uint_intasc(nk2,temp,value,nkar,fldnam,control)
	    max_len = 60
	  elseif(typ .eq. enttyp_bits .or. typ .eq. enttyp_rbits) then
	    stat = dix_con_bits_intasc(des_rec.size,
     1                     des_rec.bit_offset,data,value,nkar,fldnam,
     1                     typ .eq. enttyp_rbits)
	    max_len = len(value)
	  elseif(typ .eq. enttyp_log .or. typ .eq. enttyp_rlog) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,nk2)
	    stat = dix_con_log_intasc(nk2,temp,value,nkar,fldnam,
     1                     typ .eq. enttyp_rlog)
	    max_len = 60
	  elseif(typ .eq. enttyp_real) then
	    stat = dix_con_real_intasc  (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_realg) then
	    stat = dix_con_realg_intasc (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_dat .or. typ .eq. enttyp_cpu) then
	    stat = dix_con_dat_intasc   (nk,data(offs),value,nkar,
     1                                            typ.eq. enttyp_dat)
	    max_len = 60
	  elseif(typ .eq. enttyp_uic) then
	    stat = dix_con_uic_intasc   (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_identifier) then
	    stat = dix_con_identifier_intasc(nk,data(offs),
     1                    value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_prot) then
	    stat = dix_con_prot_intasc   (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_fid) then
	    stat = dix_con_fid_intasc   (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_revint) then
	    stat = dix_con_revint_intasc (nk,data(offs),value,nkar)
	    max_len = 60
	  elseif(typ .eq. enttyp_chr) then
	    stat = dix_con_chr_intasc   (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	  elseif(typ .eq. enttyp_string) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_str_intasc   (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	    des_rec.act_size = (nk-des_rec.nb_reserved)*8
	  elseif(typ .eq. enttyp_wstring) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_wstr_intasc  (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	    des_rec.act_size = (nk-des_rec.nb_reserved)*8
	  elseif(typ .eq. enttyp_lstring) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_lstr_intasc  (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	    des_rec.act_size = (nk-des_rec.nb_reserved)*8
	  elseif(typ .eq. enttyp_zstring) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_zstr_intasc  (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	    des_rec.act_size = (nk-des_rec.nb_reserved)*8
	  elseif(typ .eq. enttyp_hstring) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_hstr_intasc  (nk,data(offs),value,nkar,
     1                        include_binary)
	    max_len = des_rec.size/8 - des_rec.nb_reserved
	    if(des_rec.variable) max_len = len(value)
	    des_rec.act_size = (nk-des_rec.nb_reserved)*8
	  elseif(typ .eq. enttyp_diskmap) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_diskmap_intasc(nk,data(offs),value,nkar,
     1                        include_binary)
	    des_rec.act_size = (nk)*8
	    max_len = 60
	  elseif(typ .eq. enttyp_acl) then
	    limit = nk*8	
	    call dix_des_get_real_size(typ,limit,data(offs),0,control)
	    nk = limit/8
	    stat = dix_con_acl_intasc(nk,data(offs),value,nkar,
     1                        include_binary)
	    des_rec.act_size = (nk)*8
	    max_len = 60
	  elseif(typ .eq. enttyp_user) then
	    stat = dix_inter_execute(control,'BINASC',des_rec.lun_translate,
     1          des_rec.size,fldnam,nk,data(offs),
     1          nkar,%ref(value),nk2)
	  endif
	endif
c
c Return found size
c
	max_len = min(max_len,len(value))
	dix_con_intasc = stat
	return
	end                                     

	function dix_con_int_intasc(nk,data,value,nkar,fldnam,control)
	implicit none
c
	include 'dix_def.inc'
c
c conversio routine for signed integers
c
	integer*4 nk		!:i: length of data
	byte data(*)		!:i: the data
	character*(*) value	!:o: the text
	integer*4 nkar		!:o: text length
	character*(*) fldnam	!:i: List of fields
	record /control/ control
	logical*4 dix_con_int_intasc	!:f: true if no skip else false
c#
c local vars
c
	integer*4 nk1
	integer*4 int8(2)
	logical*4 ok
c
	character*(max_int_asc_length) temp
	logical*4 dix_util_get_field
	integer*4 dix_util_get_len
c
	int8(1) = 0
	int8(2) = 0
	temp = ' '
	call dix_util_copy(nk,data,int8)
	dix_con_int_intasc = (int8(1) .ne. 0) .or. (int8(2) .ne. 0)
	if(nk .le. 4) then
c
c Check if field is present
c
	  ok = .false.
	  if(fldnam .ne. ' ') then
	    ok = dix_util_get_field(int8(1),fldnam,temp,nkar)
	  end if
	  if(.not. ok) then
	    call ots$cvt_l_ti(int8(1),temp(1:12),%val(1),%val(nk))
	    nkar = 12
	    call dix_util_left_just(temp,nkar)
	  end if
	else
	  if(control.platform .eq. platform_vax) then
	    call ots$cvt_l_ti(int8(1),temp(1:12),%val(1),%val(4))
	    nkar = 12
	    call dix_util_left_just(temp,nkar)
	    nkar = nkar+1
	    temp(nkar:nkar) = ','
	    nk1 = nkar
	    call ots$cvt_l_ti(int8(2),temp(nkar+1:nkar+12),%val(1),%val(4))
	    nkar= 12
	    call dix_util_left_just(temp(nkar+1:nkar+12),nkar)
	    nkar = nk1+nkar
	  else
	    temp = ' '
	    call ots$cvt_l_ti(int8,temp,%val(1),%val(8))
	    nkar = dix_util_get_len(temp)
	  endif
	end if
	value = temp
	return
	end

	function dix_con_uint_intasc(nk,data,value,nkar,fldnam,control)
	implicit none
c
	include 'dix_def.inc'
c
c conversio routine for unsigned integers
c
	integer*4 nk		!:i: length of data
	byte data(*)		!:i: the data
	character*(*) value	!:o: the text
	integer*4 nkar		!:o: text length
	character*(*) fldnam	!:i: field names
	record /control/ control
	logical*4 dix_con_uint_intasc	!:f: true if no skip else false
c#
c local vars
c
	integer*4 nk1
	integer*4 int8(2)
	logical*4 ok
c
	character*(max_int_asc_length) temp
	logical*4 dix_util_get_field
	integer*4 dix_util_get_len
c
	int8(1) = 0
	int8(2) = 0
	temp = ' '
	call dix_util_copy(nk,data,int8)
	dix_con_uint_intasc = (int8(1) .ne. 0) .or. (int8(2) .ne. 0)
	if(nk .le. 4) then
	  ok = .false.
	  if(fldnam .ne. ' ') then
	    ok = dix_util_get_field(int8(1),fldnam,temp,nkar)
	  end if
	  if(.not. ok) then
	    call ots$cvt_l_tu(int8(1),temp(1:12),%val(1),%val(nk))
	    nkar = 12
	    call dix_util_left_just(temp,nkar)
	  end if
	else
	  if(control.platform .eq. platform_vax) then
	    call ots$cvt_l_tu(int8(1),temp(1:12),%val(1),%val(4))
	    nkar = 12
	    call dix_util_left_just(temp,nkar)
	    nkar = nkar+1
	    temp(nkar:nkar) = ','
	    nk1 = nkar
	    call ots$cvt_l_tu(int8(2),temp(nkar+1:nkar+12),%val(1),%val(4))
	    nkar= 12
	    call dix_util_left_just(temp(nkar+1:nkar+12),nkar)
	    nkar = nk1+nkar
	  else
	    temp = ' '
	    call ots$cvt_l_tu(int8,temp,%val(1),%val(8))
	    nkar = dix_util_get_len(temp)
	  endif
	end if
	value = temp
	return
	end

	function dix_con_log_intasc(nk,data,value,nkar,fldnam,reverse)
	implicit none
c
c convert logicals
c
	include 'dix_def.inc'
c
	integer*4 nk		!:i: length of data
	byte data(*)		!:i: the data
	character*(*) value	!:O: the dix_conerted text
	integer*4 nkar		!:o: length of text
	character*(*) fldnam	!:i: fieldnames
	logical*4 reverse	!:i: value reversed?
	logical*4 dix_con_log_intasc	!:f: true if not compressed
c#
	nkar = nk		!prevent unused message
	nkar = %loc(fldnam)	!prevent unused
c
	if(data(1) .xor. reverse) then
	  value = true_name
	  nkar = len(true_name)
	else
	  value = false_name
	  nkar =  len(false_name)
	end if
	dix_con_log_intasc = data(1)
	return
	end
c

	function dix_con_dat_intasc(nk,data,value,nkar,is_dat)
	implicit none
c
c convert vms date (4 or 8 bytes long) or cputime *4
c Date format can be *8 (normal vms date)
c                 or *4 (vmsdate/60000000 = #minutes sinc 1857)
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:O: the text
	integer*4 nkar		!:o: the text length
	logical is_dat		!:i: date or cpu time
	logical*4 dix_con_dat_intasc	!:F: true if not copmpressed
c#
	integer*4 vmsdat(2)
c
	vmsdat(1) = 0
	vmsdat(2) = 0
	if(is_dat) then
	  if(nk .le. 4) then
	    call lib$emul(data,600000000,0,vmsdat)
	  else
	    call dix_util_copy(nk,data,vmsdat)
	  endif
	else
	  call lib$emul(data,-10*1000*10,0,vmsdat)	!delta time
	endif
c
	dix_con_dat_intasc = (vmsdat(1) .ne. 0) .or. (vmsdat(2) .ne. 0)
c
        if(vmsdat(1) .eq. -1 .and. vmsdat(2) .eq. -1) then
          value = 'Pre-expired'
          nkar = 11
        else
	  nkar = 0			!asctim delivers only integer*2
          if(is_dat) then
	    call sys$ASCtim(nkar,value,vmsdat,)
	  else
	    if(vmsdat(1) .eq. 0 .and. vmsdat(2) .eq. 0) then
	      value = '(none)'
	      nkar = 6
	    else
	      call sys$ASCtim(nkar,value,vmsdat,)
	    endif
	  endif
	  call dix_util_left_just(value,nkar)
	end if
	return
	end
c

	function dix_con_uic_intasc(nk,data,value,nkar)
	implicit none
c
	include 'dix_def.inc'
c
c convert UIC
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: lenngth of text
	logical*4 dix_con_uic_intasc	!:f: True if not compressed
c#
	integer*4 uic,nk1
c
	character*(max_uic_asc_length) tline
c
	uic = 0
	call dix_util_copy(nk,data,uic)
	dix_con_uic_intasc = uic .ne. 0
c
	nkar = 0			!idtoasc delivers only integer*2
	call sys$fao('!%I',nkar,value,%val(uic))
	nk1 = 0
	call sys$fao('!%U',nk1, tline,%val(uic))
	if(value(1:nkar) .ne. tline(1:nk1)) then
	  value(nkar+1:) = ' = '//tline(1:nk1)
	  nkar = nkar +3 + nk1
	endif
	call dix_util_left_just(value,nkar)
	return
	end
	function dix_con_identifier_intasc(nk,data,value,nkar)
	implicit none
c
c convert UIC
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: lenngth of text
	logical*4 dix_con_identifier_intasc	!:f: True if not compressed
c#
	integer*4 sys$idtoasc
c
	integer*4 id
c
	call dix_util_copy(nk,data,id)
	dix_con_identifier_intasc = id .ne. 0
c
	nkar = 0			!idtoasc delivers only integer*2
	call sys$idtoasc(%val(id),nkar,value,,,)
	call dix_util_left_just(value,nkar)
	return
	end

	function dix_con_revint_intasc(nk,data,value,nkar)
	implicit none
c
c convert integer with words reversed (only *4)
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: lenngth of text
	logical*4 dix_con_revint_intasc	!:f: True if not compressed
c#
	logical*4 dix_con_int_intasc
c
	byte temp(4)
c
	temp(1) = data(3)
	temp(2) = data(4)
	temp(3) = data(1)
	temp(4) = data(2)
	dix_con_revint_intasc = dix_con_int_intasc(nk,temp,value,nkar,' ')
	return
	end
	function dix_con_fid_intasc(nk,data,value,nkar)
	implicit none
c
	include 'dix_def.inc'
c
c Convert file id to ascii (*6)
c
	integer*4 nk      		!:i: #bytes
	integer*2 data(3)		!:i: thedata
	character*(*) value		!:o: the text
	integer*4 nkar			!:o: length of value
	logical*4 dix_con_fid_intasc	!:f: True if not compressed
c#
	integer*4 fnr,fseq,vol,tmp
	character*(max_fid_asc_length) temp
c
	vol = nk		!to prevent warnings
c
	fnr = zext(data(1))	!not in once integer*2 truncate
	tmp = iand(data(3),'FF00'X)
        tmp = ishft(tmp,8)
	fnr = fnr .or. tmp
	fseq = zext(data(2))
	vol = iand(data(3),'FF'X)
c
	nkar  = 0
	call sys$fao('(!UL,!UL,!UL)',nkar,temp,
     1              %val(fnr),%val(fseq),%val(vol))
	dix_con_fid_intasc = (fnr .ne. 0) .or. (fseq .ne. 0).or.(vol .ne. 0)
	nkar = min(nkar,len(value))
	value = temp(1:nkar)
	return
	end
	function dix_con_prot_intasc(nk,data,value,nkar)
	implicit none
c
	include 'dix_def.inc'
c
c convert file protection mask
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: lenngth of text
	logical*4 dix_con_prot_intasc	!:f: True if not compressed
c#
	integer*2 prot,k,l
	integer*4 prot_len
	parameter (prot_len=4)
	character*(prot_len) mask,types
	character*(max_prot_asc_length) temp
c
	prot = 0
	call dix_util_copy(nk,data,prot)
	dix_con_prot_intasc = prot .ne. 0
c
	mask  = 'RWED'
	types = 'SOGW'
	nkar = 0
	do k=0,3
	  temp(nkar+1:nkar+1) = types(k+1:k+1)
	  temp(nkar+2:nkar+2) = ':'
	  nkar = nkar + 2
	  do l=0,3
	    if(.not. btest(prot,k*4+l)) then
	      nkar = nkar + 1
	      temp(nkar:nkar) = mask(l+1:l+1)
	    end if
	  end do
	  if(k .ne. 3) then
	    temp(nkar+1:nkar+2) = ', '
	    nkar = nkar + 2
	  end if
	end do
	nkar = min(nkar,len(value))
	value = temp
	return
	end

	function dix_con_bits_intasc(nbit,offset,data,value,nkar,
     1                     fldnam,reverse)
	implicit none
c
	include 'dix_def.inc'
c
c Convert bit string
c
	integer*4 nbit		!:i: #bits length
	integer*4 offset	!:i: Offset in databuffer
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	character*(*) fldnam	!:i: list of field names
	logical*4 reverse	!:i: bits reversed??
	logical*4 dix_con_bits_intasc	!:F: true if not comppessed
c#
	integer*4 k,nk1
	byte temp,all_set,all_clr
c
	character*(max_short_line_length) tempasc
c
	logical*4 dix_util_get_field
c
	all_set = .true.
	all_clr = .true.

	do k=0,nbit-1
	  call dix_util_copy_bits(1,offset+k,data,temp,1)
	  if(reverse) temp = .not. temp
	  if(     temp) all_clr = .false.
	  if(.not.temp) all_set = .false.
	end do
	dix_con_bits_intasc = .not. all_clr
	if(.not. all_set) goto 1
	value = '%ALL'
	nkar = 4
	goto 90
c
1	nkar = 0
	do k=0,nbit-1
	  call dix_util_copy_bits(1,offset+k,data,temp,1)
	  if(reverse) temp = .not. temp
	  if(temp) then
	    if(.not. dix_util_get_field(k,fldnam,value(nkar+1:),nk1)) then
c
c Now fill in fieldname in number format
c
	      call sys$fao('BIT!UL',nk1,tempasc,%val(k))
	      if(nk1+nkar .le. len(value)) then
	        value(nkar+1:) = tempasc
	      else
	        nk1 = 0
	      endif
c	      call sys$fao('BIT!UL',nk1,value(nkar+1:),%val(k))
	    end if
	    if(nkar .lt. len(value)) then
	      nkar = nkar + nk1 + 1
	      value(nkar:nkar) = ','
	    endif
	  end if
	end do	    
	if(nkar .gt. 0) then
	  value(nkar:nkar) = ' '
	  nkar  = nkar-1
	end if
90	return
	end
c

	function dix_con_real_intasc(nk,data,value,nkar)
	implicit none
c
c real conversion
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 dix_con_real_intasc	!:F: true if not compressed
c#
c
	real*4 real4
	real*8 real8
	real*16 real16
	byte hulp(16)
c
	equivalence (real4,real8),(real4,real16),(real4,hulp)
c
	logical*4 overflow
        common /dix_con_common/ overflow
	external dix_con_overflow
	volatile overflow
c
	real16 = 0
	call dix_util_copy(nk,data,hulp)
c
	overflow = .false.
	call lib$establish(dix_con_overflow)
	if(nk .le. 4) then
	  dix_con_real_intasc = real4 .ne. 0.0
	  if(overflow) goto 60
	  write(value,1010,err=60) real4
1010	  format(G20.5e5)
	  nkar = 20
	elseif(nk .le. 8) then
	  dix_con_real_intasc = real8 .ne. 0.0
	  if(overflow) goto 60
	  write(value,1010,err=60) real8
	  nkar = 20
	elseif(nk .le. 16) then
	  dix_con_real_intasc = real16 .ne. 0.0
	  if(overflow) goto 60
	  write(value,1010,err=60) real16
	  nkar = 20
	end if
	goto 70
60	value = 'Overflow'
	nkar = 8
70	call dix_util_left_just(value,nkar)
	return
	end
	options /g_floating
	function dix_con_realg_intasc(nk,data,value,nkar)
	implicit none
c
c real conversion (g_format)
c
	integer*4 nk		!:i: data length
	byte data(*)		!:i: the data
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 dix_con_realg_intasc	!:F: true if not compressed
c#
	real*8 real8
	byte hulp(8)
c
	equivalence (real8,hulp)
c
	logical*4 overflow
        common /dix_con_common/ overflow
	external dix_con_overflow
c
	real8 = 0
	call dix_util_copy(nk,data,hulp)
c
	overflow = .false.
	call lib$establish(dix_con_overflow)
c
	dix_con_realg_intasc = real8 .ne. 0.0
	if(overflow) goto 50
c
	write(value,1010,err=50) real8
1010	format(G20.5e5)
	nkar = 20
	goto 70
50	value= 'Overflow'
	nkar = 8
70	call dix_util_left_just(value,nkar)
	return
	end

	function dix_con_chr_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c character conversion
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_chr_intasc	!:f: true if not compressed
c#
	integer*4 k
	character dix_util_kar_conv
c
	nkar = min(nk,len(value))
c
	call dix_util_copy(nkar,data,%ref(value))
	dix_con_chr_intasc = .false.
	do k=1,nkar
	  if(.not. include_binary) then
	    value(k:k) = dix_util_kar_conv(value(k:k))
	  end if
	  if(value(k:k) .ne. ' ' .and. value(k:k) .ne. char(0)) 
     1            dix_con_chr_intasc = .true.
	end do
90	return
	end

	function dix_con_str_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for counted ascii strings
C the first byte contains the length
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_str_intasc	!:f: true if not compressed
c#
	logical*4 dix_con_chr_intasc
	dix_con_str_intasc = dix_con_chr_intasc(nk-1,data(2),value,nkar,
     1                               include_binary)
	return
	end

	function dix_con_wstr_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for counted ascii strings
C the first word contains the length
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_wstr_intasc	!:f: true if not compressed
c#
	logical*4 dix_con_chr_intasc
c
	dix_con_wstr_intasc = dix_con_chr_intasc(nk-2,data(3),value,nkar,
     1                               include_binary)
	return
	end
	function dix_con_lstr_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for counted ascii strings
C the first longword contains the length
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_lstr_intasc	!:f: true if not compressed
c#
	logical*4 dix_con_chr_intasc
c
	dix_con_lstr_intasc = dix_con_chr_intasc(nk-4,data(5),value,nkar,
     1                               include_binary)
	return
	end

	function dix_con_hstr_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for strings terminated by char with high bit set
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_hstr_intasc	!:f: true if not compressed
c#
	logical*4 dix_con_chr_intasc
c
	dix_con_hstr_intasc = dix_con_chr_intasc(nk,data,value,nkar,
     1                               include_binary)
	value(nk:nk) = char(iand(ichar(value(nk:nk)),'7F'X))
	return
	end

	function dix_con_zstr_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for zero-terminated ascii strings
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_zstr_intasc	!:f: true if not compressed
c#
	logical*4 dix_con_chr_intasc
c
	dix_con_zstr_intasc = dix_con_chr_intasc(nk-1,data,value,nkar,
     1                               include_binary)
	return
	end
	function dix_con_acl_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for acl fields
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_acl_intasc  !:f: true if not compressed
c#
	integer descr(2),istat
c
	integer sys$format_acl
c
	istat = include_binary	!skip warnings
	descr(1) = nk
	descr(2) = %loc(data)
	istat = sys$format_acl(descr,nkar,value,,,,,)
	dix_con_acl_intasc = .true.
90	return
	end
	function dix_con_diskmap_intasc(nk,data,value,nkar,include_binary)
	implicit none
c
c charcter conversion for diskmap (ods-2 disk allocation)
c
	integer*4 nk		!:I: data length
	byte data(*)		!:i: data 
	character*(*) value	!:o: the converted text
	integer*4 nkar		!:o: length of text
	logical*4 include_binary!:i: include unprintables in text
	logical*4 dix_con_diskmap_intasc  !:f: true if not compressed
c#
	integer k,blnr,count,bltyp
	integer*2 dataword(4)
c
	call lib$movc3(8,data,dataword)
c
	k = include_binary		!skip warnings
	dix_con_diskmap_intasc = .false.
	bltyp = zext(data(2))
	bltyp = ishft(bltyp,-6)	!take bit 15,14 = bit 7,6 of nbyte 2
	do k=1,nk
	  if(data(k) .ne. 0) goto 10
	enddo
	nkar = 0
	goto 90
10	dix_con_diskmap_intasc = .true.
	if(bltyp .eq. 0) then
c
c Type 0, placement type
c
	  write(value,1000) (data(k),k=1,min(10,nk))
1000	  format('P:',10z3)
	  nkar = 2 + nk*3
	  goto 90
	elseif(bltyp .eq. 1) then
c
c Type 1: 8 bits count and 22 bits blocknr
c    bit 111111
c        5432109876543210
c word1  tpNNNNNNCCCCCCCC  
c word2  NNNNNNNNNNNNNNNN
c
	  count = iand(dataword(1),'ff'x)
	  blnr  = iand(dataword(1),'3f00'x)
	  blnr  = ior(ishft(blnr ,8),zext(dataword(2)))
	elseif(bltyp .eq. 2) then
c
c Type 2: 14 bits count and 32 bits blocknr
c    bit 111111
c        5432109876543210
c word1  tpCCCCCCCCCCCCCC  
c word2  NNNNNNNNNNNNNNNN
c word3  NNNNNNNNNNNNNNNN
c
	  count = iand(dataword(1),'3fff'x)
	  call lib$movc3(4,dataword(2),blnr)
c	  blnr  = zext(dataword(3))
c	  blnr  = ior(ishft(blnr ,16),zext(dataword(2)))
	elseif(bltyp .eq. 3) then
c
c Type 3: 30 bits count and 32 bits blocknr
c word1  tpCCCCCCCCCCCCCC  MS
c word2  CCCCCCCCCCCCCCCC  LS
c word3  NNNNNNNNNNNNNNNN  LS
c word4  NNNNNNNNNNNNNNNN  MS
c
c	  call lib$movc3(4,dataword(1),count)
c	  count = iand(count,'3fffffff'x)
	  count = iand(dataword(1),'3fff'x)
	  count = ior(ishft(count,16),zext(dataword(2)))
	  call lib$movc3(4,dataword(3),blnr)
c	  blnr  = zext(dataword(2))
c	  blnr  = ior(ishft(blnr ,16),zext(dataword(3)))
	endif
c
c count is one low, a count of 0 means 1 block
c
	call sys$fao('T:!UL !UL-!UL (!UL)',nkar,value,
     1         %val(bltyp),%val(blnr),%val(blnr+count),%val(count+1))
c
90	return
	end

	function dix_con_hex_intasc(offset,size,data,value,nkar,typ,max_len)
	implicit none
c
c convert to hex bytes
C if string than separated by spaces and ascending index
C else descending index
c
	integer*4 offset	!:i: offset in bits from buffer data
	integer*4 size          !:i: size in bits of data
	integer*4 typ		!:i: the data type
	byte data(*)		!:i: the data
	character*(*) value	!:o: the text
	integer*4 nkar		!:o: length of text
	integer*4 max_len	!:o: max length allowed
	logical*4 dix_con_hex_intasc	!:F: True if not compres skip else false
c#
c local vars
c
	include 'dix_def.inc'
c
	logical*4 dix_con_typ_is_text
c
	integer*4 k,nk_txt,nk,offs,nbtod
	logical*4 ascii
	integer*4 lib$extzv
c
	ascii = dix_con_typ_is_text(typ)
	nk_txt = len(value)
	nk = size/8
c
	nkar = 0
	dix_con_hex_intasc = .false.
	if(ascii) then
c
c ascii case, convert ascending with spaces
c cannot be fielded
c
	  offs = offset/8
	  nk   = size/8
	  do k=1,nk
	    if(nkar+3 .le. nk_txt) then
	      write(value(nkar+1:nkar+3),1000) data(k+offs)
1000	      format(z2.2,' ')
	    end if
	    if(data(k) .ne. 0 .and. data(k).ne. ' ') dix_con_hex_intasc =.true.
	    nkar = nkar + 3
	  end do
	  max_len = nk*3
	else
c
c binary case, convert descending no spaces
c
	  if(mod(offset,8) .ne. 0 .or. mod(size,8) .ne. 0) then
	    nbtod = size
	    offs = offset
	    do while(nbtod .gt. 0)
	      k = lib$extzv(offset,min(8,nbtod),data)
	      if(nkar+2 .le. nk_txt) then
	        write(value(nkar+1:nkar+2),1100) k
	      end if
	      if(k .ne. 0) dix_con_hex_intasc = .true.
	      nkar = nkar + 2
	      nbtod = nbtod-8
	      offs = offs + 8
	    end do
	  else
	    offs = offset/8
	    nk   = size/8
	    do k=nk,1,-1
	      if(nkar+2 .le. nk_txt) then
	        write(value(nkar+1:nkar+2),1100) data(k+offs)
1100	        format(z2.2)
	      end if
	      if(data(k) .ne. 0) dix_con_hex_intasc = .true.
	      nkar = nkar + 2
	    end do
	    max_len = nk*2
	  end if
	end if
	call dix_util_left_just(value,nkar)
	return
	end	  
	function dix_con_oct_intasc(offset,size,data,value,nkar,max_len)
	implicit none
c
c convert to oct bytes
C if string than separated by spaces and ascending index
C else descending index
c
	integer*4 offset	!:i: offset in bits from buffer data
	integer*4 size          !:i: size in bits of data
	byte data(*)		!:i: the data
	character*(*) value	!:o: the text
	integer*4 nkar		!:o: length of text
	integer*4 max_len	!:o: max length allowed
	logical*4 dix_con_oct_intasc	!:F: True if not compres skip else false
c#
c local vars
c
	include 'dix_def.inc'
c
	integer*4 k,offs,nbtod,pos
	integer*4 lib$extzv
c
	nkar = min(max_len,(size+2)/3)
	dix_con_oct_intasc = .false.
c
	nbtod = size
	offs = offset
	pos = nkar
	do while(nbtod .gt. 0)
	  k = lib$extzv(offs,min(3,nbtod),data)
	  if(nkar .gt. 0) value(pos:pos) = char(ichar('0')+k)
	  if(k .ne. 0) dix_con_oct_intasc = .true.
	  pos   = pos   - 1
	  nbtod = nbtod - 3
	  offs  = offs  + 3
	end do
	call dix_util_left_just(value,nkar)
	return
	end	  

	function dix_con_bin_intasc(offset,size,data,value,nkar,max_len)
	implicit none
c
c convert to binary
c
	integer*4 offset	!:i: offset in bits from buffer data
	integer*4 size          !:i: size in bits of data
	byte data(*)		!:i: the data
	character*(*) value	!:o: the text
	integer*4 nkar		!:o: length of text
	integer*4 max_len	!:o: max length allowed
	logical*4 dix_con_bin_intasc	!:F: True if not compres skip else false
c#
c local vars
c
	include 'dix_def.inc'
c
	integer*4 k,l,offs
	integer*4 lib$extzv
c
	value = ' '
	dix_con_bin_intasc = .false.
c
	nkar = size
	offs = offset
	do l=1,size
	  k = lib$extzv(offs,1,data)
	  if(nkar .le. max_len) then
	    value(nkar:nkar) = char(ichar('0')+k)
	  endif
	  if(k .ne. 0) dix_con_bin_intasc = .true.
	  offs = offs + 1
	  nkar = nkar - 1
	end do
	nkar = min(size,max_len)
	return
	end	  
c
	function dix_con_ascint(value,data,des_rec,hex,nb_f,control)
	implicit none
c
c Convert data from ascii to binary
c
	include 'dix_def.inc'
	character*(*) value		!:i: the text
	byte data(*)			!:o: the data to receive
	record /des_rec/ des_rec
	logical*4 hex			!:i: hex mode??
	integer*4 nb_f			!:o: length of data found
	record /control/ control	!:i: control structure
	logical*4 dix_con_ascint	!:f: f is conversion error
c#
c The conversion routines
c
	logical*4 dix_con_int_ascint,dix_con_real_ascint
	logical*4 dix_con_realg_ascint,dix_con_identifier_ascint
	logical*4 dix_con_log_ascint,dix_con_dat_ascint
	logical*4 dix_con_uic_ascint,dix_con_bits_ascint
	logical*4 dix_con_chr_ascint,dix_con_str_ascint
	logical*4 dix_con_wstr_ascint,dix_con_lstr_ascint
	logical*4 dix_con_uint_ascint,dix_con_hex_ascint
	logical*4 dix_con_hstr_ascint,dix_con_zstr_ascint
	logical*4 dix_con_prot_ascint,dix_con_revint_ascint
	logical*4 dix_con_fid_ascint,dix_con_bin_ascint
	logical*4 dix_con_oct_ascint,dix_con_acl_ascint
	logical*4 dix_con_diskmap_ascint
	logical*4 dix_inter_execute
c
	external dix_msg_converr
c
	integer*4 fldnam(2),temp(2),offs
	integer*4 size,typ,k,case
	logical try_hex,stat
c
	fldnam(1) = des_rec.fld_len	!create description for text
	fldnam(2) = des_rec.fld_adr
c
	nb_f = des_rec.size		!intitial setting
c
	offs = des_rec.bit_offset/8
	size = (des_rec.size+7)/8
	if(des_rec.variable) size = 0
	typ  = des_rec.ent_type
	case = des_rec.case
c
	try_hex = hex .or. (des_rec.translate .ne. translate_nor)
	if(typ .eq. enttyp_int .or. typ .eq. enttyp_uint) then
c
c Hex wanted, but if string start with %, let normal int/uint translate
c
	  if(value(1:1) .eq. '%') try_hex = .false.
	endif
c
	if(try_hex) then
c
c Translate non standard (hex,oct,bin)
c
	  if(hex .or. des_rec.translate .eq. translate_hex) then
	    stat = dix_con_hex_ascint(value,data,
     1            des_rec.bit_offset,des_rec.size,typ,control)
	  elseif(des_rec.translate .eq. translate_bin) then
	    stat = dix_con_bin_ascint(value,data,
     1            des_rec.bit_offset,des_rec.size,control)
	  elseif(des_rec.translate .eq. translate_oct) then
	    stat = dix_con_oct_ascint(value,data,
     1            des_rec.bit_offset,des_rec.size,control)
	  endif	  
	else
c
c Normal conversions
c
	  if    ( typ .eq. enttyp_int) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,8)
	    stat = dix_con_int_ascint(value,temp, des_rec.size,
     1                                         fldnam,des_rec.min_val,
     1                                         des_rec.max_val,control)
	    if(stat) then
	      call dix_util_insert_bits(temp,des_rec.bit_offset,
     1                des_rec.size,data)
	    end if
	  elseif( typ .eq. enttyp_uint) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,8)
	    stat = dix_con_uint_ascint  (value,temp, des_rec.size,
     1                             fldnam,des_rec.min_val,
     1                             des_rec.max_val,control)
	    if(stat) then
	      call dix_util_insert_bits(temp,des_rec.bit_offset,
     1                des_rec.size,data)
	    end if
	  elseif( typ .eq. enttyp_log .or. typ .eq. enttyp_rlog) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,8)
	    stat = dix_con_log_ascint   (value,temp, des_rec.size,
     1                      typ .eq. enttyp_rlog,control)
	    if(stat) then
	      call dix_util_insert_bits(temp,des_rec.bit_offset,
     1                des_rec.size,data)
	    end if
	  elseif( typ .eq. enttyp_bits .or. typ .eq. enttyp_rbits) then
	    call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,data,
     1                temp,8)
	    stat = dix_con_bits_ascint  (value,temp, des_rec.size,
     1                            fldnam,typ .eq. enttyp_rbits,control)
	    if(stat) then
	      call dix_util_insert_bits(temp,des_rec.bit_offset,
     1                des_rec.size,data)
	    end if
	  elseif( typ .eq. enttyp_real) then
	    stat = dix_con_real_ascint  (value,data(offs+1),size,
     1                            control)
	  elseif( typ .eq. enttyp_realg) then
	    stat = dix_con_realg_ascint (value,data(offs+1), size,
     1                            control)
	  elseif( typ .eq. enttyp_dat .or. typ .eq. enttyp_cpu) then
	    stat = dix_con_dat_ascint   (value,data(offs+1), size,
     1                            typ .eq. enttyp_dat,control)
	  elseif( typ .eq. enttyp_uic) then
	    stat = dix_con_uic_ascint   (value,data(offs+1), size,
     1                            control,.true.)
	  elseif( typ .eq. enttyp_identifier) then
	    stat = dix_con_identifier_ascint(value,data(offs+1),
     1                            size,control,.true.)
	  elseif( typ .eq. enttyp_prot) then
	    stat = dix_con_prot_ascint   (value,data(offs+1), size,
     1                            control)
	  elseif( typ .eq. enttyp_fid) then
	    stat = dix_con_fid_ascint   (value,data(offs+1), size,
     1                            control)
	  elseif( typ .eq. enttyp_revint) then
	    stat = dix_con_revint_ascint (value,data(offs+1), size,
     1                   des_rec.min_val,des_rec.max_val,control)
	  elseif( typ .eq. enttyp_chr) then
	    stat = dix_con_chr_ascint   (value,data(offs+1), size,
     1                            control,case)
	  elseif( typ .eq. enttyp_string) then
	    stat = dix_con_str_ascint (value,data(offs+1),size,nb_f,
     1                            control,case)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_wstring) then
	    stat = dix_con_wstr_ascint(value,data(offs+1),size,nb_f,
     1                            control,case)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_lstring) then
	    stat = dix_con_lstr_ascint(value,data(offs+1),size,nb_f,
     1                            control,case)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_hstring) then
	    stat = dix_con_hstr_ascint(value,data(offs+1),size,nb_f,
     1                            control,case)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_zstring) then
	    stat = dix_con_zstr_ascint(value,data(offs+1),size,nb_f,
     1                            control,case)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_diskmap) then
	    stat = dix_con_diskmap_ascint(value,data(offs+1),
     1                            size,nb_f,control)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_acl) then
	    stat = dix_con_acl_ascint(value,data(offs+1),
     1                            size,nb_f,control)
	    nb_f = nb_f*8
	  elseif(typ .eq. enttyp_user) then
	    stat = dix_inter_execute(control,'ASCBIN',des_rec.lun_translate,
     1          0,fldnam,len(value),%ref(value),
     1          k,data(offs+1),nb_f)
	  endif
	end if
	if(stat) then
	  dix_con_ascint = 1
	else
	  dix_con_ascint = %loc(dix_msg_converr)
	endif
	return
	end

	function dix_con_int_ascint(line,data,size,fldnam,min_val,
     1                              max_val,control)
	implicit none
c
c Convert signed integer
c
	character*(*) line			!:i: the line to convert
	byte data(*)				!:o: the data
	integer*4 size				!:i: data size in bits
	character*(*) fldnam			!:i: list of fieldnames
	integer*4 min_val			!:i: min val 
	integer*4 max_val			!:i: max val
	integer*4 control
	integer*4 dix_con_int_ascint		!:f: true if all ok
c#
	logical*4 dix_con_int_ascint_1
c	integer*4 k
c
	external dix_msg_converr
	external dix_msg_invint
c
	dix_con_int_ascint = %loc(dix_msg_converr)
	if(dix_con_int_ascint_1(line,data,size,fldnam,min_val,
     1         max_val,control,.true.)) then
	  dix_con_int_ascint = 1
	else
	  call dix_message(control,dix_msg_invint,line)
	end if
90	return
	end

	function dix_con_int_ascint_1(line,data,size,fldnam,min_val,
     1            max_val,control,signed)
	implicit none
c
	include 'dix_def.inc'
c
c The actual conversion for signed integer
c
	character*(*) line			!:i: the line to convert
	byte data(*)				!:o: the data
	integer*4 size				!:i: data size in bits
	character*(*) fldnam			!:i: list of fieldnames
	integer*4 min_val			!:i: allowed min_val
	integer*4 max_val			!:i: allowed max val
	record /control/ control
	logical signed				!:i: signed/unsigned
	logical*4 dix_con_int_ascint_1		!:f: true if all ok
c#
	integer*4 hulp(2),nkar,k,l,istat
	logical*4 dix_con_i4
	integer*4 lib$convert_date_string
	logical*4 dix_util_find_field
	logical*4 dix_smg_select_field
	character*(max_line_length) tline
c
	external dix_msg_intoutran
	integer*4 ots$cvt_tu_l
	integer*4 ots$cvt_ti_l
c
	do nkar=len(line),1,-1
	  if(line(nkar:nkar) .ne. ' ' .and. line(nkar:nkar) .ne. char(0))goto 4
	end do
	nkar = 0
c
4	if(size .le. 4*8 .and. fldnam .ne. ' ') then
	  if(line(1:1) .eq. '?') then
	    if(dix_smg_select_field(control,data,size*8,.false.,
     1                  fldnam,.false.,.true.))goto 75
	    goto 80
	  end if
	  call str$upcase(tline,line(1:nkar))
	  if(dix_util_find_field(tline(1:nkar),fldnam,hulp)) goto 70
	end if
c
	if    (size .lt. 4*8) then
	  if(signed) then
	    istat = ots$cvt_ti_l(line(1:nkar),hulp,%val(size/8))
	  else
	    istat = ots$cvt_tu_l(line(1:nkar),hulp,%val(size/8))
	  endif
	  if(.not. istat) goto 80
	elseif(size .eq. 4*8) then
	  if(.not. dix_con_i4(line,nkar,hulp,.false.,
     1                        control,signed)) goto 80
	else
c
c >32 bits, if alpha use ots, else do it youself
c
	  if(control.platform .eq. platform_vax) then
	    k = index(line,'.')
	    if(k .ne. 0) then
c
c is build of 2 integer*4's try conversion for each of them
c
	      if(.not. dix_con_i4(line,k-1,hulp(2),.false.,
     1                       control,.false.)) goto 60
	      if(.not. dix_con_i4(line(k+1:),nkar-k,hulp(1),.false.,
     1                       control,signed)) goto 60
	    else
	      if(nkar .lt. 10) then
	        read(line(1:nkar),2010,err=60) hulp(1)
2010	        format(i12)
	        hulp(2) = 0
	        if(hulp(1) .lt. 0) hulp(2) = -1
	      else
	        read(line(1 :   9),2010,err=60) k
	        read(line(10:nkar),2010,err=60) l
	        call lib$emul(1000000000,k,l,hulp)
	      end if
	    endif
	  else
c
c  Alpha/ipf
c	    
	     if(signed) then
	        istat = ots$cvt_ti_l(line(1:nkar),hulp,%val(8))
	     else
	        istat = ots$cvt_tu_l(line(1:nkar),hulp,%val(8))
	     endif
	     if(istat) goto 70
	  end if
c
c Try date conversion (in upper case)
c
60	  call str$upcase(tline,line(1:nkar))
	  k = lib$convert_date_string(tline(1:nkar),hulp,,123)
	  if(.not. l) goto 80
	end if
70	if(max_val .gt. min_val) then
	  if(hulp(1) .lt. min_val .or. hulp(1) .gt. max_val) then
	    call dix_message(control,dix_msg_intoutran,
     1	          line,%val(min_val),%val(max_val))
	    goto 80
	  endif
	endif
	call dix_util_copy((size+7)/8,hulp,data)
75	dix_con_int_ascint_1 = .true.
	goto 90
80	dix_con_int_ascint_1 = .false.
90	return
	end

	function dix_con_uint_ascint(line,data,size,fldnam,min_val,
     1                    max_val,control)
	implicit none
c
c Convert unsigned integers
c
	character*(*) line                      !:i: the text
	byte data(*)                            !:o: the data
	integer*4 size   			!:i: size in bits
	character*(*) fldnam			!:i: list of fieldnames
	integer*4 min_val
	integer*4 max_val
	integer*4 control
	logical*4 dix_con_uint_ascint
c#
	logical*4 dix_con_int_ascint_1
	integer*4 nkar
	external dix_msg_invsign
	external dix_msg_invuint
	external dix_msg_converr
c
	dix_con_uint_ascint = %loc(dix_msg_converr)
	do nkar=len(line),1,-1
	  if(line(nkar:nkar) .ne. ' ') goto 4
	end do
	nkar = 0
4	if(index(line(1:nkar),'-') .ne. 0 .or. 
     1     index(line(1:nkar),'+') .ne. 0) goto 85
c
	if(.not. dix_con_int_ascint_1(line,data,size,fldnam,min_val,
     1            max_val,control,.false.)) goto 87
	dix_con_uint_ascint = 1
	goto 90
c
85	call dix_message(control,dix_msg_invsign,line)
	goto 90
c
87	call dix_message(control,dix_msg_invuint,line)
	goto 90
c
90	return
	end

	function dix_con_real_ascint(line,data,size,control)
	implicit none
c
c Convert real
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size	
	integer*4 control
	logical*4 dix_con_real_ascint	!:f: the result
c
	integer*4 istat
	real*16 hulp
c#
	integer*4 ots$cvt_t_f,ots$cvt_t_d,ots$cvt_t_h
	external dix_msg_invreal
c
	if(size .le. 4) then
	  istat = ots$cvt_t_f(line,hulp,,,1)
	elseif(size .le. 8) then
	  istat = ots$cvt_t_d(line,hulp,,,1)
	else
	  istat = ots$cvt_t_h(line,hulp,,,1)
	end if
	if(istat) then
	  call dix_util_copy(size,hulp,data)
	  dix_con_real_ascint = .true.
	else
	  call dix_message(control,dix_msg_invreal,line)
	  dix_con_real_ascint = .false.
	end if
c
	return
	end

	options /g_floating
	function dix_con_realg_ascint(line,data,size,control)
	implicit none
c
c Convert real (g_floating)
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size
	integer*4 control
	logical*4 dix_con_realg_ascint	!:f: conversion result
c#
	real*8 hulp
	integer*4 istat 
	integer*4 ots$cvt_t_g
	external dix_msg_invrealg
c
	istat = ots$cvt_t_g(line,hulp,,,1)
	if(istat) then
	  call dix_util_copy(size,hulp,data)
	  dix_con_realg_ascint = .true.
	else
	  call dix_message(control,dix_msg_invrealg,line)
	  dix_con_realg_ascint = .false.
	end if
	return
	end

	function dix_con_log_ascint(line,data,size,reverse,control)
	implicit none
c
c Convert logical 
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the length
	logical*4 reverse		!:i: reverse the value
	integer*4 control
	logical*4 dix_con_log_ascint    !:f: the conversion result
c#
	logical*4 logf
	external dix_msg_invlog
c
	if(    line(1:1) .eq. 'F' .or.
     1         line(1:1) .eq. 'f' .or.
     1         line(1:1) .eq. '0') then
	  logf = .false.
	elseif(line(1:1) .eq. 'T' .or.
     1         line(1:1) .eq. 't' .or.
     1         line(1:1) .eq. '1') then
	  logf = .true.
	else
	  call dix_message(control,dix_msg_invlog,line)
	  dix_con_log_ascint = .false.
	  goto 90
	end if
	if(reverse) logf = .not. logf
	call dix_util_copy((size+7)/8,logf,data)
	dix_con_log_ascint = .true.
90	return
	end

	function dix_con_dat_ascint(line,data,size,is_dat,control)
	implicit none
c
	include 'dix_def.inc'
c
c Convert date from asc to int (either date or cputime fields)
c Date format can be *8 (normal vms date)
c                 or *4 (vmsdate/60000000 = #minutes sinc 1857)
c
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the length (4 or 8)
	logical*4 is_dat		!:i: date/cputime flag
	integer*4 control
	logical*4 dix_con_dat_ascint	!:f: conversion result
c#
	integer*4 vmstim(2),istat,temp,k
	integer*2 defs(7)
	character*(max_short_line_length) lineu
c
	integer*4 lib$convert_date_string
	integer*4 sys$bintim
	external dix_msg_invdate
	external dix_msg_invcputim
c
c allow default for all fields ; except  day
c
	if(.not. is_dat) then
c
c cputime format
c
	  do k=1,7
	    defs(k) = 0
	  end do
c
	  istat = sys$bintim(line,vmstim)
	  if(istat) then
	    call lib$ediv(-10*1000*10,vmstim,temp,k)
	    if(temp .lt. 0) then
	      istat = 0
	    else
	      vmstim(1) = temp
	    endif
	  else
            call str$upcase(lineu,line)
	    if(lineu(1:6) .eq. '(NONE)') then
	      vmstim(1) = 0
	      istat = 1
	    endif
	  endif
	  if(.not. istat) then
 	    call dix_message(control,dix_msg_invcputim,line)
	  endif
	else
	  if(lib$convert_date_string(line,vmstim,,127)) then
	    if(size .eq. 4) then
	      call lib$ediv(600000000,vmstim,temp,k)
	      vmstim(1) = temp
	    endif
	    istat = 1
	  else
            call str$upcase(lineu,line)
            if(lineu(1:11) .eq. 'PRE-EXPIRED') then
              vmstim(1) = -1
              vmstim(2) = -1
	      istat = 1
	    endif
	  end if
	  if(.not. istat) then
 	    call dix_message(control,dix_msg_invdate,line)
	  endif
	endif
	if(istat) then
	  call dix_util_copy(size,vmstim,data)
	endif
        dix_con_dat_ascint = istat
c
90	return
	end

	function dix_con_uic_ascint(line,data,size,control,signal)
	implicit none
c
c Convert UIC
c
	character*(*) line 		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size
	integer*4 control
	logical signal			!:i: signal error ?
	logical*4 dix_con_uic_ascint	!:f: conversion result
c#
	integer*4 sys$asctoid
c
	structure /uic/
	  integer*2 mem
	  integer*2 grp
	end structure
	record /uic/ uic,uic1
	integer*4 ipos1,ipos2,ipos3
c
	external dix_msg_invuic
c
	ipos1 = size		!prevent unused message (size is always 4)
c
	dix_con_uic_ascint = .false.
	ipos3 = index(line,']')
	if(ipos3 .eq. 0) goto 80
	ipos1 = index(line(1:ipos3),'[')
	if(line(1:ipos1-1) .ne. ' ') goto 80
c
	if(ipos1 .gt. 0) then
	  ipos2 = index(line(1:ipos3),',')
	  if(ipos2 .eq. 0) then
c
c Format [userasc]
c
	    if(ipos3 .gt. ipos1) then
	      if(sys$asctoid(line(ipos1+1:ipos3-1),uic,)) then
	        dix_con_uic_ascint = uic.grp .gt. 0	!not general identifier
	      endif
	    endif
	  else
c
c Format either
c  [group,member]
c  both group and mmeber can be text (identifier) or numeric (octal)
c
	    if(ipos2 .gt. ipos1 .and. ipos3 .gt. ipos2) then
	      read(line(ipos1+1:ipos2-1),2000,err=10) uic.grp
	      goto 20
c
c Not numeric, so must be identifier
c
10	      if(.not. sys$asctoid(line(ipos1+1:ipos2-1),uic,)) goto 80
	      if(uic.mem .ne. 'FFFF'x) goto 80		!must be -1
c
c uic.grp in filled now
c
20	      read(line(ipos2+1:ipos3-1),2000,err=30) uic1.mem
2000	      format(bn,o6)
	      goto 40
30	      if(.not. sys$asctoid(line(ipos2+1:ipos3-1),uic1,)) goto 80
	      if(uic.grp .ne. uic1.grp) goto 80
40	      uic.mem = uic1.mem
	      dix_con_uic_ascint = .true.
	    end if
	  end if
	end if
c	    
80	if(dix_con_uic_ascint) then
	  call dix_util_copy(4,uic,data)
	else
	  if(signal) call dix_message(control,dix_msg_invuic,line)
	end if
	return
	end
	function dix_con_identifier_ascint(line,data,size,control,signal)
	implicit none
c
c Convert UIC
c
	character*(*) line 		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size
	integer*4 control
	logical signal			!:i: signal error ?
	logical*4 dix_con_identifier_ascint	!:f: conversion result
c#
	integer*4 ipos,id
c
	external dix_msg_invid
	logical dix_con_uic_ascint
	integer*4 sys$asctoid
	integer*4 dix_util_get_len
c
	ipos = size		!prevent unused message (size is always 4)
c
	dix_con_identifier_ascint = .false.
	ipos = dix_util_get_len(line)
	if(sys$asctoid(line(1:ipos),id,)) then
 	  dix_con_identifier_ascint = .true.
	else
	  if(dix_con_uic_ascint(line,id,size,control,.false.)) then
 	    dix_con_identifier_ascint = .true.
	  endif
	endif	    
	if(dix_con_identifier_ascint) then
	  call dix_util_copy(4,id,data)
	else
	  if(signal) call dix_message(control,dix_msg_invid,line)
	end if
	return
	end

	function dix_con_revint_ascint(line,data,size,
     1               min_val,max_val,control)
	implicit none
c
c Convert revint (int*4 wtih low/high word swapped)
c	
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size
	integer*4 min_val		!:i: min allowed balue
	integer*4 max_val		!:i: max allowed value
	integer*4 control
	logical*4 dix_con_revint_ascint	!:f: the conversion result
c#
	byte temp(4)
	logical*4 dix_con_int_ascint
c
	dix_con_revint_ascint = .false.
	if(dix_con_int_ascint(line,temp,size*8,' ',
     1               min_val,max_val,control)) then
	  dix_con_revint_ascint = .true.
	  data(1) = temp(3)
	  data(2) = temp(4)
	  data(3) = temp(1)
	  data(4) = temp(2)
	end if	  
	return
	end
	function dix_con_fid_ascint(line,data,size,control)
	implicit none
c
	include 'dix_def.inc'
c
c Convert fileid 
c
	character*(*) line		!:i: the text
	integer*2 data(3)		!:o: the binary data
	integer*4 size			!:i: the size (must be 6)
	integer*4 control
	logical*4 dix_con_fid_ascint	!:f: the conversion result
c#
	integer*4 fnr,fseq,vol,ipos
	integer*2 tdata(3)

	structure /v2v4/
	  union
	    map
	      integer*2 v2(2)
	    end map
	    map
	      integer*4 v4
	    end map
	  end union
	end structure
	record /v2v4/ val
c
	character*(max_fid_asc_length) temp
	external dix_msg_invfield
c
	dix_con_fid_ascint = .false.
	ipos = index(line,'(')
	if(ipos .eq. 0) goto 90
c
	temp = line(ipos+1:)
c
	ipos = index(temp,',')
	if(ipos .eq. 0) goto 90
c
	read(temp(1:ipos-1),1000,err=90) fnr
1000	format(bn,i12)
	temp = temp(ipos+1:)
	if(fnr .lt. 0 .or. fnr .gt. 'ffffff'x) goto 90
c
	ipos = index(temp,',')
	if(ipos .eq. 0) goto 90
c
	read(temp(1:ipos-1),1000,err=90) fseq
	temp = temp(ipos+1:)
	if(fseq .lt. 0 .or. fseq .gt. 'ffff'x) goto 90
c
c Not direct assignment because signed/unsigned
c
	val.v4 = fseq
	tdata(2) = val.v2(1)
c
	ipos = index(temp,')')
	if(ipos .eq. 0) goto 90
c
	read(temp(1:ipos-1),1000,err=90) vol
	temp = temp(ipos+1:)
c
	if(vol .lt. 0 .or. vol .gt. 255) goto 90
	tdata(3) = vol
c
	if(temp .ne. ' ') goto 90
c
c Not direct assignment because signed/unsigned
c
	val.v4 = fnr
	tdata(1) = val.v2(1)
c
	val.v4 = iand(ishft(fnr,-8),'FF00'X)
	tdata(3) = tdata(3) .or. val.v2(1)
c
	dix_con_fid_ascint = .true.
c
	data(1) = tdata(1)
	data(2) = tdata(2)
	data(3) = tdata(3)
	size = 6
	goto 99
c
90	call dix_message(control,dix_msg_invfield,line)	
99	return
	end

	function dix_con_prot_ascint(line,data,size,control)
	implicit none
c
c Convert protection 
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size (should be 2)
	integer*4 control
	logical*4 dix_con_prot_ascint	!:f: function result
c#
	logical*4 dix_con_prot_ascint_1
c
	integer*4 prot,ibpos,iepos,k,offs,flag
c
	dix_con_prot_ascint = .false.
c
	prot = 'FFFF'X			!default all off
	ibpos = 1
	flag = control		!to prevent warnings
	flag = 0
c
	do while(ibpos .le. len(line))
	  iepos = index(line(ibpos:) ,',')
	  if(iepos .eq. 0) then
	    iepos = len(line)
	  else
	   iepos = ibpos + iepos-2
	  end if
	  if(.not.  dix_con_prot_ascint_1(line(ibpos:iepos),k,
     1                offs,control)) goto 90
	  if(btest(flag,offs)) goto 90
	  flag = ibset(flag,offs)		!signal already used
	  call lib$insv(k,offs,4,prot)
	  ibpos = iepos + 2
	end do
	dix_con_prot_ascint = .true.
	call dix_util_copy(size,prot,data)
c
90	return
	end
	function dix_con_prot_ascint_1(line,val,offs,control)
	implicit none
c
c Convert a piece of the prot string
c
	character*(*) line		!:i: the text
	integer*4 val			!:o: the binary data
	integer*4 offs			!:i: the offset
	integer*4 control
	logical*4 dix_con_prot_ascint_1 !:f: conversion result
c#
	character type
	integer*4 k,ipos,l
	external dix_msg_typdoubl
	external dix_msg_typunkn
	external dix_msg_protdoubl
	external dix_msg_invprot
c
	dix_con_prot_ascint_1 = .false.

c
	ipos = index(line,':')
	if(ipos .eq. 0) ipos = len(line)+1
c
	type = ' '
	do k=1,ipos-1
	  if(line(k:k) .ne. ' ') then
	    if(type .ne. ' ') goto 80
	    type = line(k:k)
	  end if
	end do
c
	offs = -1
	if(type .eq. 'S' .or. type .eq. 's')offs = 0
	if(type .eq. 'O' .or. type .eq. 'o')offs = 4
	if(type .eq. 'G' .or. type .eq. 'g')offs = 8
	if(type .eq. 'W' .or. type .eq. 'w')offs = 12
	if(offs .lt. 0) goto 82
c
	ipos = index(line,':')
	val  = 15				!default disabled
	if(ipos .eq. 0) goto 20
	do k=ipos+1,len(line)
	  if(line(k:k) .eq. ' ') goto 20
	  l = -1
	  if(line(k:k) .eq. 'R' .or. line(k:k) .eq. 'r') l = 0
	  if(line(k:k) .eq. 'W' .or. line(k:k) .eq. 'w') l = 1
	  if(line(k:k) .eq. 'E' .or. line(k:k) .eq. 'e') l = 2
	  if(line(k:k) .eq. 'D' .or. line(k:k) .eq. 'd') l = 3
	  if(l .lt. 0) goto 84
c
	  if(.not. btest(val,l)) goto 86		!if reset, then error (double)
	  val = ibclr(val,l)
	end do
c
20	dix_con_prot_ascint_1 = .true.
	goto 90
80	call dix_message(control,dix_msg_typdoubl,type)
	goto 90
82	call dix_message(control,dix_msg_typunkn,type)
	goto 90
84	call dix_message(control,dix_msg_invprot,line(k:k))
	goto 90
86	call dix_message(control,dix_msg_protdoubl,line(k:k))
90	return
	end

	function dix_con_bits_ascint(line,data,size,fldnam,reverse,control)
	implicit none
c
	include 'dix_def.inc'
c
c Convert bits 
c
	character*(*) line		!:i: the text data
	byte data(*)                    !:o: the result 
	integer*4 size                  !:i: #bits in result
	character*(*) fldnam            !:i: fieldnames
	integer*4 control
	logical*4 reverse		!:i: reverse values?
	logical*4 dix_con_bits_ascint	!:f: conversion result
c#
	logical*4 dix_util_get_field
	integer*4 str$case_blind_compare
	logical*4 dix_smg_select_field
	external dix_msg_invbits
c
	integer*4 ibpos,iepos,hulp(2),nkar,offset,nk_f,nb,nk
	logical*4 neg
	character*(max_symbol_name_length) field
	character*(max_short_line_length) tline
c
	ibpos = 1
	nkar = len(line)
	hulp(1) = 0
	hulp(2) = 0
	neg = .false.
c
	nb = (size+7)/8
c
	if(line(1:1) .eq. '?') then
	  if(dix_smg_select_field(control,data,size,.true.,
     1              fldnam,reverse,.true.)) goto 75
	  goto 85
	endif
	if(line(1:1) .eq. '+') then
	  call dix_util_copy(nb,data,hulp)
	  ibpos = 2
	elseif(line(1:1) .eq. '-') then
	  call dix_util_copy(nb,data,hulp)
	  ibpos = 2
	  neg = .true.
	else
	  ibpos = 1
	end if
c
10	iepos = index(line(ibpos:),',')
	if(iepos .eq. 0) then
	  iepos = nkar
	else
	  iepos = iepos+ibpos-2
	endif
c
	if(iepos .ge. ibpos) then
	  call str$upcase(tline,line(ibpos:iepos))
	  nk = iepos-ibpos+1
	  call dix_util_left_just(tline,nk)
c
c First see if name to be found
c
	  if(tline .eq. '%ALL') then
	    hulp(1) = 'ffffffff'X
	    hulp(2) = 'ffffffff'X
	    goto 18
	  end if
	  do offset=0,size-1
c
c Try to extract fieldname
c
	    if(dix_util_get_field(offset,fldnam,field,nk_f)) then
c
c Got the field name, no compare
c
	      nk_f = min(nk_f,nk)
	      if(str$case_blind_compare(field(1:nk_f),
     1             tline(1:nk_f)) .eq. 0) goto 16
	    end if
	  end do
c
c Could not find field, so must be integer
c
	  read(tline(1:nk),2000,err=14) offset
2000	  format(bn,i2)
	  goto 16
14	  if(nk .gt. 3 .and. tline(1:3) .eq. 'BIT') then
	    read(tline(4:nk),2000,err=80) offset
	  else
	    goto 80
	  end if
16	  if(offset .lt. 0 .or. offset .ge. size) goto 80
	  if(neg) then
	    call clear_bit(offset,hulp)
	  else
	    call set_bit(offset,hulp)
	  end if
	endif
18	ibpos = iepos+2
	if(ibpos .le. nkar) goto 10
c
	if(reverse) then
	  hulp(1) = .not. hulp(1)
	  hulp(2) = .not. hulp(2)
	end if
	call dix_util_copy(nb,hulp,data)
75	dix_con_bits_ascint = .true.
	goto 90
80	call dix_message(control,dix_msg_invbits,tline(1:nk))
85	dix_con_bits_ascint = .false.
c
90	return
	end

	function dix_con_chr_ascint(line,data,size,control,case)
	implicit none
	include 'dix_def.inc'
c
c Convert chars
c
	character*(*) line
	byte data(*)
	integer*4 size
	integer*4 control               !
	integer*4 case			!:i: case parameter
	logical*4 dix_con_chr_ascint
c#
	integer*4 k
	character dix_util_upcase_kar
	character dix_util_locase_kar
c
	k = control 	!to prevent warnings
	call lib$movc5(len(line),%ref(line),ichar(' '),size,data)
	if(case .eq. case_lower) then
	  do k=1,len(line)
	    data(k) = ichar(dix_util_locase_kar(line(k:k)))
	  end do
	elseif(case .eq. case_upper) then
	  do k=1,len(line)
	    data(k) = ichar(dix_util_upcase_kar(line(k:k)))
	  end do
	endif
c
	dix_con_chr_ascint = .true.
c
	return
	end

	function dix_con_str_ascint(line,data,size,nb_f,control,case)
	implicit none
c
c Convert string type
c size if either 0, (length of line determines size)
c  or <>0, we have a fixed size
c the result will be in nb_f
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: size
	integer*4 nb_f			!:o: actual size
	integer*4 control
	integer*4 case			!:i: case parameter
	logical*4 dix_con_str_ascint	!:f: conversion result
c#
	logical*4 dix_con_chr_ascint
c
c Save size in byte
c
	if(size .eq. 0) then
	  nb_f = min(len(line)+1,256)
	  size = nb_f
	else
	  nb_f = size
	  size = min(size,len(line)+1)
	end if
	call dix_util_copy(1,size-1,data)
	dix_con_str_ascint = dix_con_chr_ascint(line,data(2),nb_f-1,
     1                         control,case)
	return
	end

	function dix_con_wstr_ascint(line,data,size,nb_f,control,case)
	implicit none
c
c Convert wstring (word counted string)
c size if either 0, (length of line determines size)
c  or <>0, we have a fixed size
c the result will be in nb_f
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: th  binary data
	integer*4 size			!:i: the size
	integer*4 nb_f			!:o: actual length
	integer*4 control
	integer*4 case			!:i: case parameter
	logical*4 dix_con_wstr_ascint	!:f: conversion result
c#
	logical*4 dix_con_chr_ascint
c
	if(size .eq. 0) then
	  nb_f = len(line)+2
	  size = nb_f
	else
	  nb_f = size
	  size = min(size,len(line)+2)
	end if
	call dix_util_copy(2,size-2,data)
	dix_con_wstr_ascint = dix_con_chr_ascint(line,data(3),nb_f-2,
     1                  control,case)
c
	return
	end
	function dix_con_lstr_ascint(line,data,size,nb_f,control,case)
	implicit none
c
c Convert lstring (longword counted string)
c size if either 0, (length of line determines size)
c  or <>0, we have a fixed size
c the result will be in nb_f
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the  binary data
	integer*4 size			!:i: the size (or 0)
	integer*4 nb_f			!:o: actual length
	integer*4 case			!:i: case parameter
	integer*4 control
	logical*4 dix_con_lstr_ascint	!:f: conversion result
c#
	logical*4 dix_con_chr_ascint
c
	if(size .eq. 0) then
	  nb_f = len(line)+4
	  size = nb_f
	else
	  nb_f = size
	  size = min(size,len(line)+4)
	end if
	call dix_util_copy(4,size-4,data)
	dix_con_lstr_ascint = dix_con_chr_ascint(line,data(5),nb_f-4,
     1                       control,case)
c
	return
	end

	function dix_con_hstr_ascint(line,data,size,nb_f,control,case)
	implicit none
c
c Conver hstring (string terminated with byte that has high bit set)
c size if either 0, (length of line determines size)
c  or <>0, we have a fixed size
c the result will be in nb_f
c
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: binary data
	integer*4 size			!:i: length
	integer*4 nb_f			!:o: actual length
	integer*4 control
	integer*4 case			!:i: case parameter
	logical*4 dix_con_hstr_ascint	!:f: conversion result
c#
	logical*4 dix_con_chr_ascint
c
c Terminate string with hex 80
c
	if(size .eq. 0) then
	  nb_f = len(line)
	  size = nb_f
	else
	  nb_f = size
	  size = min(size,len(line))
	end if
c
	dix_con_hstr_ascint = dix_con_chr_ascint(line,data,nb_f,
     1                 control,case)
	data(size) = data(size) .or. '80'X
90	return
	end
	function dix_con_zstr_ascint(line,data,size,nb_f,control,case)
	implicit none
c
c Convert zstring (string with terminating 0)
c
c size if either 0, (length of line determines size)
c  or <>0, we have a fixed size
c the result will be in nb_f
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: the binary data
	integer*4 size			!:i: the size
	integer*4 nb_f			!:o: the actual length
	integer*4 control
	integer*4 case		        !:i: case paraemter
	logical*4 dix_con_zstr_ascint	!:f: conversion result
c#
	integer*4 k
c
	logical*4 dix_con_chr_ascint
c
c Terminate string with hex 00
c
	if(size .eq. 0) then
c
c Variable length
c
	  nb_f   = len(line)+1
	  size   = nb_f
	else
c
c Fixed length
c
	  nb_f   = size
	  size   = min(size,len(line)+1)
	end if
c
	dix_con_zstr_ascint = dix_con_chr_ascint(line,data,nb_f,
     1                   control,case)
c
c  Fill the rest with 0
c
	do k=size,nb_f
	  data(k) = 0
	end do
90	return
	end
	function dix_con_acl_ascint(line,data,size,nb_f,control)
	implicit none
c
c COnvert acl 
c
	character*(*) line		!:i: the text	
	byte data(*)			!:o: binary data
	integer*4 size			!:i: size (unused)
	integer*4 nb_f			!:o: actual length
	integer*4 control
	logical*4 dix_con_acl_ascint	!:f: conversion result
c#
	integer descr(2)
	integer sys$parse_acl
	external dix_msg_invacl
c
	descr(1) = 0
	descr(2) = %loc(data)
c
	nb_f = size		!to prevent compiler warnings
	dix_con_acl_ascint = sys$parse_acl(line,descr,,,)
	if(.not. dix_con_acl_ascint) 
     1       call dix_message(control,dix_msg_invacl,line)
	nb_f = descr(1)
	return
	end
	function dix_con_diskmap_ascint(line,data,size,nb_f,control)
	implicit none
c
c Convert diskmap entry
c
	character*(*) line		!:i: the text
	byte data(*)			!:o: binary data
	integer*4 size			!:i: the size
	integer*4 nb_f			!:o: actual length
	integer*4 control
	logical*4 dix_con_diskmap_ascint!:f: conversion result
c#
	integer k,n,count,begblk,endblk,bltyp,ipos,kpos
	external dix_msg_invdmap
c
	dix_con_diskmap_ascint = .false.
c
	nb_f = size		!to prevent compiler warning
	if(line(1:2) .eq. 'P:') then
c
c Type 0, placement type
c Syntax PL: xx xx xx
c
	  n = 3
	  nb_f = 0
	  do while(n+2 .lt. len(line))
	    nb_f = nb_f + 1
	    read(line(n+1:n+2),2020,err=90) data(nb_f)
2020	    format(z2)
	    n = n + 3
	  enddo
	  goto 80
	elseif(line(1:2) .eq. 'T:') then
	  read(line(3:3),2000,err=90) bltyp
2000	  format(i12)
	  k = 5
	  if(bltyp .lt. 1.or. bltyp .gt. 3) goto 90
	else 
	  k = 1
	  bltyp = 0
	endif
	ipos = index(line,'-')
	kpos = index(line,'(')
	if(kpos .eq. 0) kpos = len(line) + 1
	if(ipos .eq. 0) goto 90
	read(line(k     :ipos-1),2000,err=90) begblk
	read(line(ipos+1:kpos-1),2000,err=90) endblk
	count = endblk-begblk		!0 mens one block
	if(bltyp .eq. 0) then
c
c Automatic nb_f, let DIX decide on format
c
	  if(count .le. 255 .and. begblk .le. '3fffff'X) then
	    bltyp = 1
	  else
	    if(count .le. '3fff'x) then
	      bltyp = 2
	    elseif(count .le. '3fffffff'x) then
	      bltyp = 3
	    endif
	  endif
	endif
c
c Now check on bltyp
c
	if(bltyp .eq. 1) then
c
c Type 1: 8 bits count and 22 bits blocknr
c    bit 111111
c        5432109876543210
c word1  tpNNNNNNCCCCCCCC  
c word2  NNNNNNNNNNNNNNNN
c
	  if(count .gt. 255) goto 90
	  if(begblk .gt. '3fffff'x) goto 90
	  k = ishft(begblk,-16)
	  k = ishft(k,8)
	  k = '4000'x .or. k .or. count
	  call lib$movc3(2,k,data(1))
	  k = iand(begblk,'ffff'x)	    
	  call lib$movc3(2,k,data(3))
	  nb_f = 4
	elseif(bltyp .eq. 2) then
c
c Type 2: 14 bits count and 32 bits blocknr
c    bit 111111
c        5432109876543210
c word1  tpCCCCCCCCCCCCCC  
c word2  NNNNNNNNNNNNNNNN
c word3  NNNNNNNNNNNNNNNN
c
	  if(count .gt. '3fff'x) goto 90
	  k = '8000'x .or. iand(count,'3fff'x)
	  call lib$movc3(2,k,data(1))
c              
	  call lib$movc3(4,begblk,data(3))
	  nb_f = 6
	elseif(bltyp .eq. 3) then
c
c Type 3: 30 bits count and 32 bits blocknr
c word1  tpCCCCCCCCCCCCCC  
c word2  CCCCCCCCCCCCCCCC
c word3  NNNNNNNNNNNNNNNN
c word4  NNNNNNNNNNNNNNNN
c
	  if(count .gt. '3fffffff'x) goto 90
          k = 'c000'X .or. ishft(count,-16)
          call lib$movc3(2,k,data(1))
          k = iand(begblk,'ffff'x)
          call lib$movc3(2,k,data(3))
	  call lib$movc3(4,begblk,data(5))
	  nb_f = 8
	endif
80	dix_con_diskmap_ascint = .true.
	goto 99
90	call dix_message(control,dix_msg_invdmap,line)
99	return
	end
	function dix_con_i4(data,nkar_data,data_out,hex_first,
     1                      control,signed)
	implicit none
c
	include 'dix_def.inc'
c
c Easy routine for asc to int*4
c It tries to convert in a lot of ways
c
	character*(*) data		!:i: the text data
	integer*4 nkar_data             !:i: #chars                  	
	integer*4 data_out             !:o: the data
	logical*4 hex_first             !:i: try hex first
	integer*4 control
	logical signed
	integer*4 dix_con_i4		!:f: conversion result
c#
	integer*4 lib$convert_date_string
	integer*4 sys$asctoid
	integer*4 dix_con_uic_ascint
	external dix_msg_convi4dt
	external dix_msg_convid
	external dix_msg_convuic
	external dix_msg_convtext
c
	integer*4 ots$cvt_ti_l		!signed
	integer*4 ots$cvt_tu_l          !unsigned
	integer*4 ots$cvt_to_l          !octal
	integer*4 ots$cvt_tz_l          !hex
	integer*4 ots$cvt_tb_l          !binary
c
	integer*4 istat,vmstim(2),k,data4
	character*(max_int_asc_length) tline
c
c if nkar_data=0 then value=0
c
	if(nkar_data .eq. 0) then
	  data4 =0
	  istat = 1
	else
c
c Fist try as integer
c
	  if(hex_first) then
	    istat = ots$cvt_tz_l(data(1:nkar_data),data4)
	  else
	    if(signed) then
	      istat = ots$cvt_ti_l(data(1:nkar_data),data4)
	    else
	      istat = ots$cvt_tu_l(data(1:nkar_data),data4)
	    endif
	  end if
	  if(istat) goto 19
c
	  if(nkar_data .gt. 2) then
	    if(data(1:2) .eq. '%X' .or.
     1         data(1:2) .eq. '%x') then
	      istat = ots$cvt_tz_l(data(3:nkar_data),data4)
	    elseif(data(1:2) .eq. '%O' .or.
     1             data(1:2) .eq. '%o') then
	      istat = ots$cvt_to_l(data(3:nkar_data),data4)
	    elseif(data(1:2) .eq. '%B' .or.
     1             data(1:2) .eq. '%b') then
	      istat = ots$cvt_tb_l(data(3:nkar_data),data4)
	    elseif(data(1:2) .eq. '%D' .or.
     1             data(1:2) .eq. '%d') then
	      if(signed) then
	        istat = ots$cvt_ti_l(data(3:nkar_data),data4)
	      else
	        istat = ots$cvt_tu_l(data(3:nkar_data),data4)
	      endif
	    else
	      istat = 0
	    end if
	    if(istat) goto 19
	  end if
c
c try format 'dddd'B
c
11	  if(data(1:1) .eq. '''') then
	    do k=2,nkar_data-1
	      if(data(k:k) .eq. '''') then
	        if(data(k+1:k+1) .eq. 'X' .or. data(k+1:k+1) .eq. 'x') then
	          istat = ots$cvt_tz_l(data(2:k-1),data4)
	        elseif(data(k+1:k+1) .eq. 'O' .or. data(k+1:k+1) .eq. 'o') then
	          istat = ots$cvt_to_l(data(2:k-1),data4)
	        elseif(data(k+1:k+1) .eq. 'D' .or. data(k+1:k+1) .eq. 'd') then
	          if(signed) then
	            istat = ots$cvt_ti_l(data(2:k-1),data4)
	          else
	            istat = ots$cvt_tu_l(data(2:k-1),data4)
	          endif
	        elseif(data(k+1:k+1) .eq. 'B' .or. data(k+1:k+1) .eq. 'b') then
	          istat = ots$cvt_tb_l(data(2:k-1),data4)
	        else
	          istat = 0
	        endif
	        if(istat) goto 19
	        goto 111
	      endif
	    end do
	  endif
	  
c
c integer conversion did not success, so try date format
c
111	  call str$upcase(tline,data(1:nkar_data))
	  istat = lib$convert_date_string(tline(1:nkar_data),vmstim,,123)
	  if(.not. istat) goto 12
	  call lib$ediv(600000000,vmstim,data4,istat)
	  call dix_message(control,dix_msg_convi4dt,
     1         data(1:nkar_data),%val(data4),%val(data4))
	  goto 19
c
c did not succeed for data, so try identifier format
c
12	  istat = sys$asctoid(data(1:nkar_data),data4,)
	  if(.not. istat) goto 14
	  call dix_message(control,dix_msg_convid,
     1         data(1:nkar_data),%val(data4),%val(data4))
	  goto 19
c
c did not succeed, try as uic
c
14	  if(.not. dix_con_uic_ascint(data(1:nkar_data),
     1            data4,4*8,control,.false.)) goto 18
	  call dix_message(control,dix_msg_convuic,
     1         data(1:nkar_data),%val(data4),%val(data4))
	  goto 19
c
c Try as ascii
c
18	  if(data(1:1) .eq. '''' .or. data(1:1) .eq. '"') then
	    call dix_util_copy(4,%ref(data(2:2)),data4)
	    call dix_message(control,dix_msg_convtext,
     1         data(1:nkar_data),%val(data4),%val(data4))
	    goto 19
	  end if
c
c No more options, failed
c
	  istat = 0
	  goto 99
	end if
c
c  ok
c
19	data_out = data4
c
99	dix_con_i4 = istat
	return
	end

	function dix_con_hex_ascint(value,data,offset,size,typ,control)
	implicit none
c
c convert to hex bytes
C if string than separated by spaces and ascending index
C else descending index
c
	character*(*) value	!:i: the text
	byte data(*)		!:o: the data
	integer*4 size		!:i: length of data in bits
	integer*4 offset	!:i: offset in bits
	integer*4 typ		!:i: the data type
	integer*4 control
	logical*4 dix_con_hex_ascint	!:F: Fale in conv error
c#
c local vars
c
	include 'dix_def.inc'
c
	logical*4 dix_con_typ_is_text
	external dix_msg_invhexv
c
	integer*4 k,ipos,offs,nbtod,nk_str
	logical*4 ascii,odd_length
	byte tmp
c
	ascii = dix_con_typ_is_text(typ)
c
c In 2 phases, first to check for legality.
c
	nk_str = index(value,' ')-1
	if(nk_str .lt. 0) nk_str =  len(value)
c
	odd_length = 2*(nk_str/2) .ne. nk_str
c
c
	ipos = 1
	if(odd_length) ipos = 0
c
c Check if value HEX data
c The length should be even, but we include the possibility
c of odd length
c
c
	do while(ipos .le. nk_str)
	  if(value(ipos:ipos) .eq. ' ') then
	    ipos = ipos + 1
	  else
	    if(ipos .eq. 0) then
	      read(value(ipos+1:ipos+1),2001,err=80) tmp
2001	      format(z1)
	      ipos = ipos + 1
	    else
	      read(value(ipos:ipos+1),2000,err=80) tmp
2000	      format(z2)
	      ipos = ipos + 2
	    endif
	  endif
	end do
c
c 2nd for real data
c
	if(ascii) then
c
c ascii case, convert ascending 
c Cannot be fielded
c
	  ipos = 1
	  if(odd_length) ipos = 0
	  offs = offset/8
	  do k=1,size/8
10	    if(ipos .le. nk_str) then
	      if(value(ipos:ipos) .eq. ' ') then
	        ipos = ipos + 1
	        goto 10
	      end if
	      if(ipos .eq. 0) then
	        read(value(ipos+1:ipos+1),2001,err=80) tmp
	        ipos = ipos + 1
	      else
	        read(value(ipos:ipos+1),2000,err=80) tmp
	        ipos = ipos + 2
	      endif
	    else
	      tmp = ' '
	    end if
	    data(offs+k-1) = tmp
	  end do
	else
c
c binary case, convert descending 
c start converting from the end of the string
c
	  ipos = nk_str
	  nbtod = size
	  offs = offset
	  do while(nbtod .gt. 0)
50	    if(ipos .gt. 1) then
	      read(value(ipos-1:ipos),2000,err=80) tmp
	      ipos = ipos - 2
	    elseif(ipos .eq. 1) then
	      read(value(ipos-1:ipos),2000,err=80) tmp
	      ipos = ipos - 1
	    else
	      tmp = 0
	    end if
	    call dix_util_insert_bits(tmp,offs,min(nbtod,8),data)
	    nbtod = nbtod - 8
	    offs  = offs  + 8
	  end do
	end if
c
	dix_con_hex_ascint = .true.
	goto 90
80	dix_con_hex_ascint = .false.
	call dix_message(control,dix_msg_invhexv,value)
90	return
	end	  
	function dix_con_bin_ascint(value,data,offset,size,control)
	implicit none
c
c convert binary data
c
	character*(*) value	!:i: the text
	byte data(*)		!:o: the data
	integer*4 offset	!:i: offset in buffer in bits
	integer*4 size		!:i: length of data
	integer*4 control
	logical*4 dix_con_bin_ascint	!:F: Fale in conv error
c#
c local vars
c
	include 'dix_def.inc'
c
	integer*4 k,l,ipos,offs,nk
c
	external dix_msg_toobig
	external dix_msg_invbinv
c
	do k=1,len(value)
	  if(value(k:k) .eq. ' ') goto 10
	  if(value(k:k) .ne. '0' .and. value(k:k) .ne. '1') goto 80
	end do
c
10	nk = k-1
	if(nk .gt. size) goto 70
	offs = offset+size-1
c
	do k=1,size
	  l = 0
	  ipos = k-size+nk
	  if(ipos .gt. 0) then
	    if(value(ipos:ipos) .eq. '1') l = 1
	  endif
	  call lib$insv(l,offs,1,data)
	  offs = offs - 1
	end do	
	dix_con_bin_ascint = .true.
	goto 90
c
70	nk = min(nk,50)
	call dix_message(control,dix_msg_toobig,value(1:nk),%val(size))
c
80	dix_con_bin_ascint = .false.
	call dix_message(control,dix_msg_invbinv,value)
90	return
	end	  
	function dix_con_oct_ascint(value,data,offset,size,control)
	implicit none
c
c convert octal text
c
	character*(*) value	!:i: the text
	byte data(*)		!:o: the data
	integer*4 offset	!:i: offset in buffer in bits
	integer*4 size		!:i: length of data
	integer*4 control
	logical*4 dix_con_oct_ascint	!:F: Fale in conv error
c#
c local vars
c
	include 'dix_def.inc'
c
	integer*4 k,l,ipos,offs,nk,nb,nb_to_do
c
	external dix_msg_toobig
	external dix_msg_invoctv
c
	nb = 0
c
	do k=1,len(value)
	  if(value(k:k) .eq. ' ') goto 10
	  if(value(k:k) .lt. '0' .or. value(k:k) .gt. '7') goto 80
	  if(nb .eq. 0) then
	    if(value(k:k) .gt. '0') nb = 1
	    if(value(k:k) .gt. '1') nb = 2
	    if(value(k:k) .gt. '3') nb = 3
	  else
	    nb = nb + 3
	  endif
	end do
c
10	ipos = k-1
	if(nb .gt. size) goto 70
	offs = offset
c
	nb_to_do = size
	do while (nb_to_do .gt. 0)
	  l = 0
	  if(ipos .gt. 0) l = ichar(value(ipos:ipos)) - ichar('0')
	  ipos = ipos - 1
	  call lib$insv(l,offs,min(3,nb_to_do),data)
	  offs = offs + 3
	  nb_to_do = nb_to_do - 3
	end do	
	dix_con_oct_ascint = .true.
	goto 90
c
70	nk = min(ipos,50)
	call dix_message(control,dix_msg_toobig,value(1:nk),%val(size))
c
80	dix_con_oct_ascint = .false.
	call dix_message(control,dix_msg_invoctv,value)
90	return
	end	  

	function dix_con_typ_is_text(typ)
	implicit none
c
c Return true if datatype is "text"
c
	integer*4 typ			!:i: the datatype
	logical*4 dix_con_typ_is_text	!:f: function result
c#
	include 'dix_def.inc'
c
	dix_con_typ_is_text = 
     1          typ .eq. enttyp_chr .or.
     1          typ .eq. enttyp_string .or.
     1          typ .eq. enttyp_wstring .or.
     1          typ .eq. enttyp_lstring .or.
     1          typ .eq. enttyp_hstring .or.
     1          typ .eq. enttyp_zstring
	return
	end
	function dix_con_kar_to_hex(kar,nr)
	implicit none
c
c Convert a char to hex
c
	character*(*) kar		!:i: text char (should be 0-9 or a-f)	
	integer*4 nr			!:o: the binary data
	logical*4 dix_con_kar_to_hex 	!:f: conversion result
c#
	dix_con_kar_to_hex = .false.
	read(kar,'(z1)',err=90) nr
	dix_con_kar_to_hex = .true.
90	return
	end
        function dix_con_overflow(sigargs) !,mechargs)
        implicit none
c
c OVerflow hadler for real conversions
c
        integer*4 sigargs(*)
c       integer*4 mechargs(*)
        integer*4 dix_con_overflow
c#
        include '($ssdef)'
        include '($mthdef)'
c
	logical*4 overflow
        common /dix_con_common/ overflow
c
        integer*4 signal
c
        signal = sigargs(2)
c
        if(signal .eq. ss$_hparith) then
          overflow = .true.
          dix_con_overflow = ss$_continue
        else
          dix_con_overflow = ss$_resignal
        end if
        return
        end
	function dix_con_value_intasc(control,value,line,nkar,hex)
	implicit none
c
c Convert a value from binary to ascii
c 
	include 'dix_def.inc'
	record /value/ value		!:i: the value
	record /control/ control
	character*(*) line		!:o: the text
	integer*4 nkar			!:o: length of line
	logical hex
	logical dix_con_value_intasc	!:f: conversion result
c#
	record /des_rec/ des_rec
	integer*4 max_len
c
	integer*4 dix_con_intasc
c
	if(value.type .eq. symb_typ_int) then
	  des_rec.ent_type   = enttyp_int
	  des_rec.size       = 8*sizeof(value.ival)
	  des_rec.bit_offset = 8*(%loc(value.ival) - %loc(value))
	elseif(value.type .eq. symb_typ_real) then
	  des_rec.ent_type   = enttyp_real
	  des_rec.size       = 8*sizeof(value.rval)
	  des_rec.bit_offset = 8*(%loc(value.rval) - %loc(value))
	elseif(value.type .eq. symb_typ_log) then
	  des_rec.ent_type   = enttyp_log
	  des_rec.size       = 8*sizeof(value.ival)
	  des_rec.bit_offset = 8*(%loc(value.ival) - %loc(value))
	elseif(value.type .eq. symb_typ_date) then
	  des_rec.ent_type   = enttyp_dat
	  des_rec.size       = 8*sizeof(value.date)
	  des_rec.bit_offset = 8*(%loc(value.date) - %loc(value))
	endif
	des_rec.fld_len    = 0
	if(value.type .eq. symb_typ_char) then
	  des_rec.ent_type   = enttyp_chr
	  des_rec.size       = 8*zext(value.strdes.dsc$w_maxstrlen)
	  des_rec.bit_offset = 0
	  dix_con_value_intasc = dix_con_intasc(des_rec.size,des_rec,
     1                  %val(value.strdes.dsc$a_pointer),
     1                  line,nkar,hex,max_len,.false.,control)
	else
	  dix_con_value_intasc = dix_con_intasc(des_rec.size,des_rec,
     1                  value,line,nkar,hex,max_len,.false.,control)
	endif
	return
	end
	subroutine dix_con_vfc(data,line,nkar)
	implicit none
c
c Convert a two byte vfc entry (DCL) to ascii
c
	byte data(2)		!:i: the vfc data
	character*(*) line	!:o: the text version
	integer*4 nkar		!:o: the length of line
c
	integer*4 nk1
c
	nkar = 0
        call dix_conv_vfc1(data(1),'Pre ',line,nk1)
	nkar = nkar + nk1
	line(nkar+1:nkar+3) = ' ; '
	nkar = nkar + 3
        call dix_conv_vfc1(data(2),'Post',line(nkar+1:),nk1)
	nkar = nkar + nk1
	return
	end
	subroutine dix_conv_vfc1(data,intro,line,nkar)
	implicit none
c
	include 'dix_def.inc'
c
	byte data
	character*(*) intro
	character*(*) line
	integer nkar

	character*(max_short_line_length) extra
	integer flag,count,nk1
c
	integer*4  max_co_name_length
	parameter (max_co_name_length=3)
c
	character*(*) c0_names
	parameter (c0_names=
     1     'NUL,SHO,STX,ETX,EOT,ENQ,ACK,BEL,'//
     1     'BS ,HT ,LF ,VT ,FF ,CR ,SO ,SI ,'//
     1     'DLE,DC1,DC2,DC3,DC4,NAK,SYN,ETB,'//
     1     'CAN,EM ,SUB,ESC,FS ,GS ,RS ,US ' )
c
	character*(max_co_name_length) name
c
	integer*4  max_hh_length
	parameter (max_hh_length=2)
	character*(max_hh_length) temp
c
	flag = zext(data)
	write(temp,'(z2.2)') data
c
	if(data .eq. 0) then
	  extra = 'None'
	  nk1   = 4
	else
	  if(.not. btest(flag,7)) then
	    count = iand(zext(flag),127)
	    call sys$fao('!UL New_line!%S',nk1,extra,%val(count))
	  else
	    extra = 'Reserved'
	    nk1   = 8	    
	    if(iand(flag,14*16) .eq. 8*16) then
	      count = iand(zext(flag),31)
	      call str$element(name,count,',',c0_names)
	      call sys$fao('Byte !2XL = !AS',nk1,extra,%val(count),name) 
	    elseif(iand(flag,240) .eq. 12*16) then
	      count = iand(zext(flag),15)
	      call sys$fao('VFU channel',nk1,extra,%val(count)) 
	    endif
	  endif
	endif
	line = intro//':('//temp//'):'//extra
	nkar = len(intro) + 2 + len(temp) + 2 + nk1
	return
	end	
