    	subroutine dix_des_remove(control,des_info)
	implicit none
	include 'dix_def.inc'
c
	record /control/ control
	record /des_info/ des_info	!:io: descriptor entry
	external dix_msg_debug
C#
c
c We should close open luns for user defined types
c
	if(control.debug) then
	  call dix_message(control,dix_msg_debug,'Removing des_info '//
     1            des_info.fnam(1:des_info.nk_fnam))
	endif
	if(des_info.n_lin .gt. 0) then
	  call dix_des_close_user_luns(des_info.n_lin,%val(des_info.lin_adr))
	endif
c
	if(des_info.zone_file.zone .ne. 0) then
	  call delete_vm(des_info.zone_file)
	end if
c
	call dix_des_init_des(des_info)
	return
	end
	subroutine dix_des_close_user_luns(n_des,des)
	implicit none
c
	include 'dix_def.inc'
	integer*4 n_des			!:i: ndescriptor
	record /des_rec_fil/ des(*)	!:i: des records
c#
	integer*4 k
c
	do k=1,n_des
	  if(des(k).lun_translate .ne. 0) then
	    call memtab_close(des(k).lun_translate)
	  endif
	end do
	return
	end

	subroutine dix_des_init_des(des_info)
	implicit none
c
c init des record
c
	include 'dix_def.inc'
c
	record /des_info/ des_info	!:o: des record
c#
	des_info.fnam    = ' '
	des_info.nk_fnam = 0
	des_info.nl_des  = 0
c
	des_info.n_lin   = 0
	des_info.nb_lin  = 0
	des_info.lin_adr = 0
c
	des_info.n_par   = 0
	des_info.nb_par  = 0
	des_info.par_adr = 0
c
	des_info.fixed   = .true.
	des_info.has_fields = .false.
c
	des_info.usage_count = 0
	des_info.lun_memtab  = 0
c
	des_info.zone_file.zone = 0
c
	return
	end
	function dix_des_get_all(control,file,fnam,signal)
	implicit none
c
c Try to get a description file/module
c First try a file with extension .des in the same directory as the file
c Then try to open the file in the current diectory
c then try to find in dex_des.tlb
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file		!:io: current file to hook into
	character*(*) fnam		!:i: explicit filename for description
	logical signal			!:i: signal errors ?
	logical*4 dix_des_get_all	!:f: get all matching descriptions
c#
	include '($jpidef)'
c
	logical dix_util_file_parse
	integer*4 dix_lbr_add_des
	logical dix_des_get_des_file
c
	integer*4 lun,bpos,epos,nk_Wfnam,old_cur_file
	character*(max_line_length) wfnam,save_file,save_file1
	integer*4 dix_util_get_len_fu
c
c make sure 'file' is the current
c
	old_cur_file = control.cur_file
	control.cur_file = %loc(file)
c
c First kill old data
c
	dix_des_get_all = .false.
	call lib$get_lun(lun)
c
c Try to open .des file in same directory as datafile
c
	wfnam    = fnam
	nk_wfnam = dix_util_get_len_fu(fnam)
c
	call dix_util_file_parse(wfnam,'T',bpos,epos)
	if(bpos .eq. 0) then
	  wfnam(nk_wfnam+1:) = '.DES'
	  nk_wfnam = nk_wfnam + 4
	endif
	call dix_util_file_parse(file.fnam,'N',bpos,epos)
	open(lun,
     1           file=wfnam(1:nk_wfnam),
     1           defaultfile=file.fnam(1:epos),
     1           status='old',
     1           err=30,shared,readonly)
	inquire(lun,name=save_file)
	if(save_file .eq. file.fnam) then
	  close(lun)
	else
c
c Got a file, copy to memtab, close lun and process lines
c
	  if(dix_des_get_des_file(control,lun,
     1            file,signal)) dix_des_get_all = .true.
	endif
c
c Try to open in current directory, take the
c filename part from the source file
c
30	open(lun,
     1           file=wfnam(1:nk_wfnam),
     1           defaultfile=file.fnam(bpos:epos),
     1           status='old',
     1           err=40,shared,readonly)
	inquire(lun,name=save_file1)
c
c If we already have the file
c
	if(save_file1 .eq. file.fnam .or. save_file1 .eq. save_file) then
	  close(lun)
	else
c
	  if(dix_des_get_des_file(control,lun,
     1                file,signal)) dix_des_get_all = .true.
	endif
c
c See if module can be lookup up in DIX_DES.TLB
c first by the name of the file
c
40	if(control.nk_syslib .ne. 0 .or. control.nk_userlib .ne. 0) then
	  wfnam = fnam
	  if(wfnam .eq. ' ') wfnam = file.fnam
	  if(dix_lbr_add_des(control,file,wfnam,signal))
     1              dix_des_get_all = .true.
	endif
	call lib$free_lun(lun)
c
c If no descriptor yes, make the top the current (if it is there)
c
	if(file.cur_des .eq. 0) file.cur_des = file.top_des
c
c Restore the old current file
c
	control.cur_file = old_cur_file
	return
	end

	function dix_des_get_des_file(control,lun,file,signal)
	implicit none
c
c Read descriptor from file
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	integer*4 lun			!:i: lun on which file is open
	record /file_info/ file		!:i: file info record
	logical signal			!:i: signal errors?
	logical dix_des_get_des_file	!:f: result
c#
	integer*4 nlines,err_row,nk_fnam,ptr,istat
	character*(max_line_length) fnam
	logical master_link
c
	integer*4 dix_util_get_len_fu
	integer*4 dix_des_read_it
	logical dix_des_find_des
	external dix_msg_alrload
	external dix_msg_desadd
	logical dix_des_find_des_file
c
	record /des_info/ des
	pointer (p_des,des)
c
	dix_des_get_des_file = .false.
c
	inquire(lun,name=fnam)
	nk_fnam = dix_util_get_len_fu(fnam)
c
c See if module already in file list
c
	if(dix_des_find_des_file(file,
     1              fnam(1:nk_fnam),des_in_file)) then
	  call dix_message(control,dix_msg_alrload,fnam(1:nk_fnam))
	else
c
c No, see if already open
c
	  if(dix_des_find_des(control,fnam(1:nk_fnam),des_in_file,ptr)) then
	    p_des = ptr
	    istat = 1
	    master_link = .false.
	  else
c
c Copy the file to a memtab structure
c
c
c Allocate a new description, and init it
c
	    call get_vm(sizeof(des),p_des,control.zone_descr)
            call dix_des_init_des(des)
	    call memtab_open_lun(lun,des.lun_memtab,nlines)
	    des.fnam    = fnam
	    des.nk_fnam = nk_fnam
	    des.in_library = des_in_file
c
c Try to process the file
c
	    istat = dix_des_read_it(control,des.lun_memtab,des,err_row)
	    call memtab_close(des.lun_memtab)
	    master_link = .true.
	  endif
	  if(istat) then
c
c Success , link it it in the file list
c
	    if(signal) call dix_message(control,dix_msg_desadd,fnam(1:nk_fnam))
	    call dix_des_link_in(control,file,des,master_link,.true.)
	    dix_des_get_des_file = .true.
	  else
c
c Failure, delete the des_structure
c
	    call free_vm(sizeof(des),p_des,control.zone_descr)
	  endif
c
c And close all things
c
	endif
	close(lun)
	return
	end
	subroutine dix_des_link_in(control,file,des,master_link,file_link)
	implicit none
c
c Link description in to two lists
c a. the list of all opened descriptions (via control.top_descr)
c b. the list of all descriptions for this file (file.top_des)
c
	include 'dix_def.inc'
	record /control/ control	!:i: control record
	record /file_info/ file		!:i: file record to link des into
	record /des_info/ des		!:i: des record to be linked
	logical master_link		!:i: link into master chain?
	logical file_link		!:i: link into file chain?
c#
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
c Get a link record for the total list
c
	if(master_link) then
	  call dix_util_link_in(des.link,control.top_descr)
	endif
c
c Get a link record for the file link, 
c
	if(file_link) then
	  call get_vm(sizeof(des_expanded),p_des_expanded,control.zone_links)
c
	  call dix_des_make_handle(des,file.top_des,des_expanded)
c
	  call dix_util_link_in(des_expanded.link,file.top_des)
c
c Make unique handle name
c
	  des_expanded.p_des_info= %loc(des)
	  des_expanded.n_des     = 0
	  des_expanded.nb_des    = 0
	  des_expanded.des_adr   = 0
	  des_expanded.zone_rec.zone = 0
	  des.usage_count = des.usage_count + 1
	endif
c
	return
	end
	subroutine dix_des_link_out(control,file,des_expanded)
	implicit none
c
c Link description out of two lists
c a. the list of all opened descriptions (via control.top_descr)
c b. the list of all descriptions for this file (file.top_des)
c
	include 'dix_def.inc'
	record /control/ control	!:i: control record
	record /des_expanded/ des_expanded !:i: linked list structure
	record /file_info/ file		!:io: file structure to remove it from
c#
	record /des_info/ des_info
	pointer (p_des_info,des_info)
	external dix_msg_debug
c
c Free from the file link
c
	call dix_util_link_out(des_expanded.link,file.top_des)
	p_des_info = des_expanded.p_des_info
c
	if(control.debug) call dix_message(control,dix_msg_debug,
     1       'remove des_exp '//des_expanded.handle)
c
	des_info.usage_count = des_info.usage_count - 1
	if(des_info.usage_count .eq. 0) then
c
c All refs to this description are lost, now 
c linkout of total list, and remove
c
	  p_des_info = control.top_descr
	  do while(p_des_info .ne. des_expanded.p_des_info) 
	    p_des_info = des_info.link.forw
	  end do
c
c Yes is it the same
c
	  call dix_util_link_out(des_info.link,control.top_descr)
	  call dix_des_remove(control,des_info)
	  call free_vm(sizeof(des_info),%loc(des_info),control.zone_descr)
	endif
c 
c And remove the linked_list block
c
	call dix_des_clean_expanded(des_expanded)
	call free_vm(sizeof(des_expanded),%loc(des_expanded),
     1               control.zone_links)
	return
	end
	function dix_des_reget(control,des)
	implicit none
c
c Reread a a description file/module
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /des_info/ des		!:io: description record
	integer*4 dix_des_reget		!:f: functoin result
c#
	integer*4 lun_memtab,istat,nlines,err_row
c
	integer*4 dix_lbr_get_module
	integer*4 dix_des_read_it
	integer*4 memtab_open
c
	if(des.in_library .ne. des_in_file) then
	  istat = dix_lbr_get_module(control,des.fnam,lun_memtab,
     1                             nlines,des.in_library)
	else
	  istat = memtab_open(des.fnam,lun_memtab,nlines)
	endif
	if(istat) then
	  istat = dix_des_read_it(control,lun_memtab,des,err_row)
	endif
	call memtab_close(lun_memtab)
	dix_des_reget = istat
	return
	end
	function dix_des_read_it(control,p_memtab,des,err_linenr)
	implicit none
c
c Process the .DES file
c
	include 'dix_def.inc'
c
	record /control/ control
	integer*4 p_memtab	!:i: the lun on which the .DES file is open
	record /des_info/ des	!:io:Des info 
	integer*4 err_linenr	!:o: of error,this contains the linenr
	logical*4 dix_des_read_it !:F: funciton result
c#
	record /des_rec_fil/ des_rec_fil
c
	logical*4 dix_des_process_lines
	external dix_msg_syntax
	external dix_msg_debug
c
	record /file_info/ file
	pointer (p_file,file)
	record /des_expanded/ des_expanded
c
	integer*4 istat,p_usertypes,old_ll
c
c Make sure this des is the current of the current file
c so the eval_expre in the process lines gets the correct paramters
c
	if(control.debug) call dix_message(control,dix_msg_debug,
     1    'Loading descr for '//des.fnam(1:des.nk_fnam))
	des_expanded.link.forw  = 0
	des_expanded.link.backw = 0
	des_expanded.p_des_info = %loc(des)
	des_expanded.n_des      = 0
c
	p_file = control.cur_file
	old_ll = file.cur_des
	file.cur_des = %loc(des_expanded)
c
	call memtab_get_nlines(p_memtab,des.nl_des)
c
c we know how many lines needed, allocate a piece of memory
c and the amount of memory needed for the names
c
	call memtab_rewind(p_memtab)	!rewind the file
c
	call init_vm(des.zone_file,0,
     1           'FIL_'//des.fnam(1:des.nk_fnam),.false.)

	call memtab_init(p_usertypes,'USER_TYPES')
	call dix_des_get_usertypes(control,p_memtab,p_usertypes)
c
	call memtab_rewind(p_memtab)	!rewind the file
c
	des.nb_lin = des.nl_des*sizeof(des_rec_fil)
	if(des.nb_lin .gt. 0) then
	  call get_vm(des.nb_lin,des.lin_adr,des.zone_file)
	else
	  des.lin_adr = 0
	end if
c
c Phase 2 ; now fill in all data
c
	istat = dix_des_process_lines(control,
     1                p_memtab,%val(des.lin_adr),
     1                des.n_lin,des.fixed,des.has_fields,
     1                des.n_par,des.nb_par,des.par_adr,
     1                des.zone_file,err_linenr,
     1                p_usertypes)
	call memtab_close(p_usertypes)
	if(.not. istat) then
	  call dix_message(control,dix_msg_syntax,des.fnam(1:des.nk_fnam))
	endif
c
c restore old current des in the file
c
	file.cur_des = old_ll
c
	dix_des_read_it = istat
	return
	end
	subroutine dix_des_get_usertypes(control,p_memtab,p_usertypes)
	implicit none
c
c search the descriptor file for userdefined type
c they begin with type name
c and end with    endtype
c
	include 'dix_def.inc'
	record /control/ control!:i: control structure
	integer*4 p_memtab	!:i: the liun for the descriptor
	integer*4 p_usertypes	!:i: the lun for the usertypes
c#
	character*(max_line_length) line
	character*(max_label_length) label
	integer*4 nk,p_line
	logical in_type
c
	logical memtab_read
	logical dix_des_is_type
c
	external dix_msg_openusrt
c
	in_type = .false.
	label = ' '
	do while(memtab_read(p_memtab,nk,line))
	  if(.not. in_type) then
	    if(dix_des_is_type(line(1:nk),.true.,label)) then
	      in_type = .true.
	    endif
	  endif
	  if(in_type) then
	    call memtab_add_record(p_usertypes,line(1:nk))
	    if(label .ne. ' ') then
	      call memtab_get_line_ptr(p_usertypes,p_line)
	      call memtab_add_label(p_usertypes,p_line,label,0)
	      label = ' '
	    endif
	  endif
	  if(in_type) then
	    if(dix_des_is_type(line(1:nk),.false.,label)) then
	      in_type = .false.
	    endif
	  endif
	end do	
	if(in_type) call dix_message(control,dix_msg_openusrt)
	return
	end
	function dix_des_is_type(line,start,label)
	implicit none
c
c Check to see if line is a #TYPE or #ENDTYPE statement
c
	include 'dix_def.inc'
c
	character*(*) line	!:i: line to be checked
	logical start		!:i: check for type  or endtype
	character*(*) label	!:o: label found on start
	logical dix_des_is_type	!:f: true if (end)type statement found
c#
	integer*4 ipos,nkar
c
	character*(max_line_length) wline
c
	dix_des_is_type = .false.
c
	wline = line
	nkar  = len(line)
	call dix_util_decent_line(nkar,wline(:nkar))
	ipos = index(wline(1:nkar),'!')
	if(ipos .ne. 0) nkar = ipos-1	
c
	if(nkar .gt. 0) then
c
c Find the verb
c
	  ipos = index(wline(1:nkar),' ')
	  if(ipos .eq. 0) ipos = nkar+1
	  if(start) then
c
c Check if verb = #TYPE
c
	    dix_des_is_type = wline(1:ipos-1) .eq. '#TYPE'
	    label = wline(ipos+1:nkar)
	  else
c
c Check if type = #ENDTYPE
c
	    if(wline(1:ipos-1) .eq. 'END')  then
	      wline = wline(1:3)//wline(5:nkar)
	      nkar = nkar - 1
	      ipos = index(wline(1:nkar),' ')
	      if(ipos .eq. 0) ipos = nkar+1
	    endif
	    dix_des_is_type = wline(1:ipos-1) .eq. '#ENDTYPE'
	  endif
	endif
	return
	end
	function dix_des_process_lines(control,p_memtab,des_recs,nrecs,
     1                  fixed,has_fields,
     1                  n_par,nb_par,par_adr,zone_id,err_linenr,
     1                  p_usertypes)
	implicit none
c  
c REad all description line, and process them in some data structures
c  1. des_recs, the parsed field-description lines
c  2. par_adr , the parameter statements from the .des record
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	integer*4 p_memtab		!:i: lun for description file
	record /des_rec_fil/ des_recs(*)!:o: the descriptions
	integer*4 nrecs			!:O: #lines without comments etc.
	logical*4 fixed			!:o: set false if v(l)string found
	logical*4 has_fields 		!:o: set true if Bit fields present
	integer*4 n_par			!:o: #paramter statements found
	integer*4 nb_par                !:o: #bytes allocated for param-recs
	integer*4 par_adr               !:o: address of param_recs 
	record /vm_zone/ zone_id	!:i: vm zone id
	integer*4 err_linenr		!:o: if problem, this contains the linenr
	integer*4 p_usertypes		!:i: the lun for the usertypes
	logical*4 dix_des_process_lines !:f: the function result
c#
c local vars
c
	character*(max_label_length) username
	character*(max_err_arg_length) errline
	character*(max_line_length) range_data
	character*(max_line_length) TYP,ntyp,line1
	character*(max_command_length) line,oline
	character*(size_dim_name) size_asc
c
	integer*4 size,nkar,k,ipos,nk,jpos,min_val,max_val,nk1
	integer*4 ent_type,kk,nkar1,first_var,nbr,istat,p_link_rec
	integer*4 nb_reserved,default_size,nke,nk_nam,lun_user
	logical*4 field_mode,got_dimension,skip
	logical*1 is_variable,trans_override,in_range,no_display,user,case
c
	record /param/ param_rec
c
c
	logical*4 dix_des_conv_idx
	integer*4 dix_util_find_char_bracket
	integer*4 dix_util_get_len_fu
	logical*4 dix_eval_check
	logical*4 dix_eval_express_des
	integer*4 dix_util_get_len
	integer*4 dix_des_get_range
	integer dix_util_check_name
	integer*4 memtab_read
	logical dix_util_remove_comment
	integer*4 dix_des_get_qualifier
	logical dix_inter_read_command_usertype
	logical*4 dix_des_is_type
c
	external dix_msg_dimerr
	external dix_msg_doubldef
	external dix_msg_endufoll
	external dix_msg_errdepen
	external dix_msg_errinline
	external dix_msg_general
	external dix_msg_invqual
	external dix_msg_invrange
	external dix_msg_mapfoll
	external dix_msg_maxstrdep
	external dix_msg_maxunidep
	external dix_msg_nestbitf
	external dix_msg_nestrange
	external dix_msg_nobitf
	external dix_msg_nomap
	external dix_msg_norangs
	external dix_msg_norange
	external dix_msg_nostruct
	external dix_msg_nounion
	external dix_msg_openbitf
	external dix_msg_openmap
	external dix_msg_openquote
	external dix_msg_openrange
	external dix_msg_openstruc
	external dix_msg_openunion
	external dix_msg_parerr
	external dix_msg_randign
	external dix_msg_sizerr
	external dix_msg_toomdim
	external dix_msg_typbitf
	external dix_msg_unkendc
	external dix_msg_unkline
	external dix_msg_ranstru
	external dix_msg_evalerr
	external dix_msg_userstd
c
	integer*4 deep_structure,deep_map,deep_union 
	integer*4 range_deep_structure,range_deep_map,range_deep_union
	integer*4 fieldname_status
	record /repeat/ rep
	record /dimension/ dim
	integer*4 nkar_o
c
c start of coding
c
	errline = ' '
	dix_des_process_lines = .false.
	deep_structure = 0
	deep_map       = 0
	deep_union     = 0
	range_deep_structure = 0
	range_deep_union     = 0
	range_deep_map       = 0
	fixed          = .true.
	first_var      = 9999999		!set max
	field_mode     = .false.
	err_linenr     = 0
c
c Init the values for location 
c these are witout a value, but thius value will be filled
c when expanding
c
	call dix_symbol_add_int(control,'%BIT_LOCATION',0,line1)	!for now 0
	call dix_symbol_add_int(control,'%LOCATION',0,line1)		!for now 0
c
c read lines
c
	nrecs = 0
	skip = .false.
10	nkar = 0
11	istat = memtab_read(p_memtab,nkar1,line1)
	if(.not. istat) goto 90
	err_linenr = err_linenr + 1
c
c skip comment and trailing blanks
c
	if(.not. dix_util_remove_comment(nkar1,line1)) then
	  call dix_message(control,dix_msg_openquote)
	  errline = line1
	  nkar_o = 0	  
	  goto 80
	endif
c
c See if continuation line
c
	line(nkar+1:) = line1(1:nkar1)
	nkar = nkar + nkar1
	if(nkar .gt. 0) then
	  if(line(nkar:nkar) .eq. '-') then
	    nkar = nkar-1
	    goto 11
	  end  if
c
	  if(line(1:1) .eq. 'C' .or. line(1:1) .eq. 'c') goto 10	!if firts char is C, then exit
c
c Now remove double blanks etc, and all cahrs to upcase(out of quotes)
c 
	  call dix_util_decent_line(nkar,line)
	endif
	if(nkar .eq. 0) goto 10
c
c Skip the userdefined types
c
	if(skip) then
	  if(dix_des_is_type(line(1:nkar),.false.,username)) then
	    skip = .false.
	  endif
	  goto 10
	else
	  if(dix_des_is_type(line(1:nkar),.true.,username)) then
	    skip = .true.
	    goto 10
	  endif
	endif

c
c save line in case of error
c
	oline = line
	nkar_o = nkar
	call str$upcase(line,line)
	if(line(1:1) .eq. '*') goto 10
c
c We cannot uiser DCL parsing, since the syntax is too cryptic
c  f.e. character*(20) jan(20) etc., etc.
c
	range_data = ' '	!no range yet
	no_display = .false.	!Not nodisplay mode
	user       = .false.	!not user defined
	case       = case_no_case !dono translate to upper/lower case
	trans_override = translate_nor
	p_link_rec = 0
c
c See if qualifiers specified
c
12	ipos = index(line(1:nkar),'/')
	if(ipos .ne. 0) then
c
c Check for override translate /HEXADECIMAL,/BINARY,/OCTAL,/RANGE=MIN:MAX/UPPERCASE/LOWERCASE
c and the file linke qualifiers /file=/key=/match=/compute=/REC
c and the user type /user
c
	  istat = dix_des_get_qualifier(control,line,nkar,ipos,p_link_rec,
     1            zone_id,trans_override,no_display,range_data,
     1            user,case)
	  if(istat) goto 12
	  errline = ' '
	  call dix_message(control,%val(istat))
	  goto 80
	endif
c
c And decent the line again
c
	call dix_util_decent_line(nkar,line)
c
c now we have format
c type*size var(d1,d2,d3)
c
	line(nkar+1:) = ' '
c
c take first item is separated from the next by a space
c
	ipos = index(line,' ')
	typ  = line(1:ipos-1)
	line = line(ipos+1:)
c
	nkar = ipos-1
c
c take some special cases 
c 1. end structure = endstructure 
c 2. end map       = endmap
c 3. end union     = endunion
c 4. byte          = integer*1
c
	if(typ .eq. 'END') then
	  if(line .eq. 'STRUCTURE') then
	    typ = 'ENDSTRUCTURE'
	  elseif(line .eq. 'MAP') then
	    typ = 'ENDMAP'
	  elseif(line .eq. 'UNION') then
	    typ = 'ENDUNION'
	  elseif(line .eq. 'BITFIELD') then
	    typ = 'ENDBITFIELD'
	  elseif(line .eq. 'RANGE') then
	    typ = 'ENDRANGE'
	  else
c
c unsupported case
c 
	    call dix_message(control,dix_msg_unkendc,typ)
	    goto 80
	  endif
	  ipos = index(line,' ')
	  line = line(ipos+1:)
	end if
c
	if(typ .eq. 'PARAMETER') then
c
c Parameter can have 2 formats
c  parameter a=1
c  parameter (a=1,b=1)
c  In the second case : get rid of the ()
c
	  if(line(1:1) .eq. '(') then
	    jpos = dix_util_find_char_bracket(line,')',.false.)
	    if(jpos .eq. 0) then
	      call dix_message(control,dix_msg_parerr)
	      goto 80
	    endif
	    line = line(2:jpos-1)
	  endif
c
c Split line in parts, get the , as separator
c
1411	  jpos = dix_util_find_char_bracket(line,',',.false.)
	  if(jpos .eq. 0) jpos = len(line)+1
c
c Split element in two parts
c  1. name
c  2. expression
c
	  ipos = index(line(1:jpos),'=')
	  if(ipos .eq. 0) then
	    call dix_message(control,dix_msg_parerr)
	    goto 80
	  endif
	  istat = dix_util_check_name(line(1:ipos-1))
	  if(.not. istat) then
	    call dix_message(control,%val(istat),line(1:ipos-1))
	  else
	    param_rec.name = line(1:ipos-1)
c
c Try to evaluate the expression
c
	    ntyp = line(ipos+1:jpos-1)
	    nk = jpos-ipos-1	  
	    param_rec.hex = translate_nor
	    if(index(ntyp,'''B') .ne. 0) param_rec.hex = translate_bin
	    if(index(ntyp,'''O') .ne. 0) param_rec.hex = translate_oct
	    if(index(ntyp,'''X') .ne. 0) param_rec.hex = translate_hex
	    call dix_util_collapse(ntyp,nk,.false.)
	    istat = dix_eval_express_des(control,ntyp(1:nk),
     1          param_rec.value,errline,.false.)
	    if(.not. istat) then
	      nk1 = dix_util_get_len_fu(errline)
	      call dix_message(control,%val(istat),errline(1:nk1))
	      call dix_message(control,dix_msg_parerr)
	      goto 80
	    endif
c
c Append the parameter record to the list,
c
	    call dix_util_insert_element(sizeof(param_rec),param_rec,
     1          n_par,nb_par,par_adr,20,zone_id)
c
c See if still more on the line
c
	  endif
	  if(jpos .le. len(line)) then
	    line = line(jpos+1:)
	    goto 1411
	  endif
	  goto 10
	end if
c
c Compatibility
c
c	
	is_variable = .false.
	fieldname_status = fieldnames_none
c
	if(typ .eq. 'BYTE'    ) typ = 'INTEGER*1'
	if(typ .eq. 'UBYTE'   ) typ = 'UINTEGER*1'
c
c take off the *size 
c
	size_asc = ' '
	ipos = index(typ,'*')
	if(ipos .eq. 0) then
	  size = 0		!default size
	else
c
c compute the size, forget then () in case of *(Nn)
c
	  if(typ(ipos+1:ipos+1) .eq. '(') then
	    kk = dix_util_find_char_bracket(typ(ipos+1:),')',.false.)
	    if (kk .eq. 0) goto 69
	    kk = kk + ipos
	    size_asc = typ(ipos+2:kk-1)
	    istat = dix_eval_check(control,size_asc,errline)
	    if(.not. istat) goto 66
            typ(ipos+1:ipos+1) = ' '	!clear (
	    typ(kk:kk)         = ' '    !clear )
	  end if	    
c
c read the size, in error give error message
c
	  read(typ(ipos+1:),2034,err=34) size
2034	  format(bn,i6)
	  size_asc = ' '	!clear if valid read
	  goto 35
34	  if(size_asc .eq. ' ') goto 69
35	  typ(ipos:) = ' '
	end if
	if (.not. field_mode) size = size*8
c
c Set repeat low and high all on 1 (dimension statement)
c
	do kk=1,max_dimension
	  rep.dim(kk).low  = 1
	  rep.dim(kk).high = 1
	  rep.dim(kk).low_name = ' '
	  rep.dim(kk).high_name = ' '
	end do
	got_dimension = .false.
c
c see if dimension specified.
c but not for MAP statement
c
	if(typ .eq. 'MAP') goto 45
	ipos = index(line,'(')
	if(ipos .ne. 0) then
c
c yes so read all the intermediate dimensions (upto max_dimension=3)
c 
	  got_dimension = .true.
	  kk = 1			!dimension index 1..3
	  ntyp  = line(ipos:)		!the dimension in ntyp
	  jpos = dix_util_find_char_bracket(ntyp,')',.false.)
	  if(jpos .eq. 0) goto 69
	  ntyp(jpos:) = ' '		!remove trailing bracket
	  ntyp(1:1) = ' '		!remove leading (
	  line(ipos:) = line(ipos+jpos:) 	!clear out dimension part
	  call dix_util_collapse(ntyp,jpos,.false.)
c
c Now ntyp contains the dimension without the surrounding brackets
c
	  do while(ntyp .ne. ' ')
	    ipos = dix_util_find_char_bracket(ntyp,',',.false.)
	    if(ipos .eq. 0) ipos = dix_util_find_char_bracket(ntyp,' ',
     1                              .false.) !if not found look for )
	    if(ipos .eq. 0) goto 69
c
c read the size, if error, then exit
c dimension can be nn or ll:hh
c
	    dim.low_name  = ' '
	    dim.high_name = ' '
	    dim.low       = 1
	    dim.high      = 1
	    jpos = dix_util_find_char_bracket(ntyp(1:ipos),':',.false.)
	    if(jpos .ne. 0) then
	      if(.not. dix_des_conv_idx(ntyp(1:jpos-1),dim.low)) then
	        istat = dix_eval_check(control,ntyp(1:jpos-1),errline)
	        if(.not. istat) goto 66
	        dim.low_name = ntyp(1:jpos-1)
	      endif
	      ntyp = ntyp(jpos+1:)
	      ipos = ipos - jpos
	    end if
	    if(ntyp(1:ipos-1) .eq. '*') then
	      dim.high = '7fffffff'x	!take max value
	    else
	      if(.not. dix_des_conv_idx(ntyp(1:ipos-1),dim.high)) then
	        istat = dix_eval_check(control,ntyp(1:ipos-1),errline)
	        if(.not. istat) goto 66
	        dim.high_name = ntyp(1:ipos-1)
	      endif
	   endif
c
c we have a new dimension; may have no more than 3
c
	    if(kk .gt. max_dimension) then
	      call dix_message(control,dix_msg_toomdim)
	      goto 80
	    end if
	    rep.dim(kk) = dim
	    kk = kk + 1
c
c skip this dimension, and try next
c
	    ntyp = ntyp(ipos+1:)
	  end do	  
	end if
	nkar = len(line)
	call dix_util_collapse(line,nkar,.false.)
c
c take the cases, check for the sizes
c
c
45	nb_reserved = 0
	default_size = 32
	if(field_mode) default_size = 8
c
	if(range_data .ne. ' ') then
	  nbr = size
	  if(nbr .eq. 0) nbr = default_size
	  errline = 'error in range'
	  if(.not. dix_des_get_range(control,range_data,
     1            min_val,max_val,nbr)) then
	    call dix_message(control,dix_msg_invrange)
	    goto 80
	  endif
	else
	  min_val = 0
	  max_val = 0
	endif
c
	username = ' '		!assume not user defined type
c
	if(typ .eq. 'INTEGER') then
	  if(size .eq. 0) size = default_size
	  if(size .lt. 1 .or. size .gt. 64) goto 70
	  ent_type = enttyp_int
	  range_data = ' '
	  fieldname_status = fieldnames_single
	elseif(typ .eq. 'UINTEGER') then
	  if(size .eq. 0) size = default_size
	  if(size .lt. 1 .or. size .gt. 64) goto 70
	  ent_type = enttyp_uint
	  range_data = ' '
	  fieldname_status = fieldnames_single
	elseif(typ .eq. 'BITS') then
	  if(size .eq. 0) size = default_size
	  if(field_mode) then
	    if(size .lt. 1 .or. size .gt. 32) goto 70
	  else
	    if(size .lt. 1 .or. size .gt. 64) goto 70
	  end if
	  ent_type = enttyp_bits
	  fieldname_status = fieldnames_multi
	elseif(typ .eq. 'RBITS') then
	  if(size .eq. 0) size = default_size
	  if(field_mode) then
	    if(size .lt. 1 .or. size .gt. 32) goto 70
	  else
	    if(size .lt. 1 .or. size .gt. 64) goto 70
	  end if
	  ent_type = enttyp_rbits
	  fieldname_status = fieldnames_multirev
	elseif(typ .eq. 'LOGICAL') then
	  if(size .eq. 0) size = default_size
	  if(size .lt. 1 .or. size .gt. 32) goto 70
	  ent_type = enttyp_log
	elseif(typ .eq. 'RLOGICAL') then
	  if(size .eq. 0) size = default_size
	  if(size .lt. 1 .or. size .gt. 32) goto 70
	  ent_type = enttyp_rlog
	elseif(typ .eq. 'DATE') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 64
	  if(size .ne. 32 .and. size .ne. 64) goto 70
	  ent_type = enttyp_dat
	elseif(typ .eq. 'CPUTIME') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 32
	  if(size .ne. 32) goto 70
	  ent_type = enttyp_cpu
	elseif(typ .eq. 'UIC') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 32
	  if(size .ne. 32) goto 70
	  ent_type = enttyp_uic
	elseif(typ .eq. 'IDENTIFIER') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 32
	  if(size .ne. 32) goto 70
	  ent_type = enttyp_identifier
	elseif(typ .eq. 'PROTECTION') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 16
	  if(size .ne. 16) goto 70
	  ent_type = enttyp_prot
	elseif(typ .eq. 'FILEID') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 48
	  if(size .ne. 48) goto 70
	  ent_type = enttyp_fid
	elseif(typ .eq. 'RINTEGER') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 32
	  if(size .ne. 32) goto 70
	  ent_type = enttyp_revint
	elseif(typ .eq. 'REAL') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 32
	  if(size .ne. 32 .and. size .ne. 64) goto 70
	  ent_type = enttyp_real
	elseif(typ .eq. 'REALG') then
	  if(field_mode) goto 68
	  if(size .eq. 0) size = 64
	  if(size .ne. 64) goto 70
	  ent_type = enttyp_realg
	elseif(typ .eq. 'POSITION') then
	  ent_type = enttyp_position
	  size = 0
	  is_variable = .true.
	elseif(typ .eq. 'ACL') then
	  ent_type = enttyp_acl
	  size = 0
	  is_variable = .true.
	elseif(typ .eq. 'RANGE') then
	  if(.not. got_dimension) then
	    call dix_message(control,dix_msg_norangs)
	    goto 80
	  endif
	  if(in_range) then
	    call dix_message(control,dix_msg_nestrange)
	    goto 80
	  end if
	  range_deep_structure = deep_structure
	  range_deep_union     = deep_union
	  range_deep_map       = deep_map
	  in_range = .true.
	  ent_type = enttyp_range
	  size     = 0
	  is_variable = .false.
	elseif(typ .eq. 'ENDRANGE') then
	  if(.not. in_range) then
	    call dix_message(control,dix_msg_norange)
	    goto 80
	  end if
	  if(deep_structure .ne. range_deep_structure .or.
     1       deep_union     .ne. range_deep_union .or.
     1       deep_map       .ne. range_deep_map) then
	    goto 65
	  endif
c
	  in_range = .false.
	  ent_type = enttyp_endrange
	  size     = 0
	  is_variable = .false.
	elseif(typ .eq. 'DISKMAP') then
	  if(field_mode) goto 68
	  ent_type = enttyp_diskmap
	  size = 0
	  is_variable = .true.
	elseif(typ .eq. 'CHARACTER') then
	  if(field_mode) goto 68
	  ent_type = enttyp_chr
	elseif(typ .eq. 'STRING') then
	  if(field_mode) goto 68
	  nb_reserved = 1
	  ent_type = enttyp_string
	  if(size .lt. 0 .or. size .gt. 8*255) goto 70
	  if(size .gt. 0) then
	    size = size + 8		!one more for byte count
	  else
	    is_variable = .true.
	  end if
	elseif(typ .eq. 'WSTRING') then
	  if(field_mode) goto 68
	  nb_reserved = 2
	  ent_type = enttyp_wstring
	  if(size .lt. 0 .or. size .gt. 8*65535) goto 70
	  if(size .gt. 0) then
	    size = size + 2*8		!two more for byte count
	  else
	    is_variable = .true.
	  end if
	elseif(typ .eq. 'LSTRING') then
	  if(field_mode) goto 68
	  nb_reserved = 4
	  ent_type = enttyp_lstring
	  if(size .lt. 0 .or. size .gt. 8*65535) goto 70
	  if(size .gt. 0) then
	    size = size + 4*8		!four more for byte count
	  else
	    is_variable = .true.
	  end if
	elseif(typ .eq. 'HSTRING') then	!terminated by 8bitchar
	  if(field_mode) goto 68
	  nb_reserved = 0
	  ent_type = enttyp_hstring
	  if(size .lt. 0 .or. size .gt. 8*255) goto 70
	  if(size .gt. 0) then
	  else
	    is_variable = .true.
	  end if
	elseif(typ .eq. 'ZSTRING') then	!terminated by 0
	  if(field_mode) goto 68
	  nb_reserved = 1
	  ent_type = enttyp_zstring
	  if(size .lt. 0 .or. size .gt. 8*255) goto 70
	  if(size .gt. 0) then
	    size = size + 1*8		!one more for terminator
	  else
	    is_variable = .true.
	  end if
	elseif(typ .eq. 'PAD' .or. typ .eq. 'ALIGN') then
c	  if(field_mode) goto 68
	  is_variable = .true.
	  ent_type = enttyp_pad
	  if(size .eq. 0) then
	    if(field_mode) then
	      size = 8
	    else
	      size = 16
	    endif
	  endif
	  if(size .lt. 1 .or. size .gt. 64) goto 70
	elseif(typ .eq. 'STRUCTURE') then
	  if(field_mode) goto 68
	  if(deep_structure .eq. max_depth) then
	    call dix_message(control,dix_msg_maxstrdep)
	    goto 80
	  end if
c
c One more structure, remember lin number in input file
c

	  deep_structure = deep_structure + 1
c
c Remember current prefix length (for truncating on endstructure)
c	
	  ent_type = enttyp_structure
	elseif(typ .eq. 'ENDSTRUCTURE') then
c
c endstructure, if repeat count exceeded than all ok
c if not exceeded skip back file to correct line
c 
	  if(deep_structure .eq. range_deep_structure) goto 65
	  if(field_mode) goto 68
	  if(deep_structure .eq. 0) then
	    call dix_message(control,dix_msg_nostruct)
	    goto 80
	  end if
	  deep_structure = deep_structure-1
	  ent_type = enttyp_endstructure
c
c could not find structure, so error
c
	elseif (typ .eq. 'MAP') then
	  if(field_mode) goto 68
	  if(deep_map .ne. deep_union-1) then
	    call dix_message(control,dix_msg_nounion)
	    goto 80
	  end if
	  if(des_recs(nrecs).ent_type .ne. enttyp_union .and.
     1       des_recs(nrecs).ent_type .ne. enttyp_endmap) then
	    call dix_message(control,dix_msg_mapfoll)
	    goto 80
	  endif
	  deep_map = deep_map + 1
	  ent_type = enttyp_map
	  nk = len(line)
	  call dix_util_collapse(line,nk,.false.)
c
	  if(line .ne. ' ') then
c
c Syntax = 1 MAP fieldname              = intvalue (can have any value)
c Separate fieldname from value
c
	    ipos = index(line,'=')
	    if(ipos .eq. 0) then
	      if(line .eq. '*') then
	        ipos = 2
	      else
	        call dix_message(control,dix_msg_errdepen)
	        goto 80
	      endif
	    else
	      istat = dix_eval_check(control,line(1:ipos-1),errline)
	      if(.not. istat) goto 66
	    endif
	    rep.dim(1).low_name  = line(1:ipos-1)
	    rep.dim(1).high_name = line(ipos+1:nk)
	    line = ' '
	  end if
	elseif (typ .eq. 'ENDMAP') then
	  if(deep_map .eq. range_deep_map) goto 65
	  if(field_mode) goto 68
c
c look for previous map
c 
	  if(deep_map .ne. deep_union) then
	    call dix_message(control,dix_msg_nomap)
	    goto 80
	  end if
	  deep_map = deep_map-1
	  ent_type = enttyp_endmap
	elseif (typ .eq. 'EXIT') then
c
c EXIT can only happen in structure
c
	  if(field_mode) goto 68
	  if(deep_structure .eq. 0) then
	    call dix_message(control,dix_msg_nostruct)
	    goto 80
	  end if
	  ent_type = enttyp_exit
	elseif (typ .eq. 'UNION') then
	  if(field_mode) goto 68
	  if(deep_union .eq. max_depth_union) then
	    call dix_message(control,dix_msg_maxunidep)
	    goto 80
	  end if
	  deep_union = deep_union + 1
	  ent_type = enttyp_union
	elseif (typ .eq. 'ENDUNION') then
	  if(deep_union .eq. range_deep_union) goto 65
	  if(field_mode) goto 68
c
c look for previous union 
c 
	  if(deep_union .eq. 0) then
	    call dix_message(control,dix_msg_nounion)
	    goto 80
	  end if
	  if(des_recs(nrecs).ent_type .ne. enttyp_union .and.
     1       des_recs(nrecs).ent_type .ne. enttyp_endmap) then
	    call dix_message(control,dix_msg_endufoll)
	    goto 80
	  endif
	  deep_union = deep_union - 1
	  ent_type = enttyp_endunion
	elseif(typ .eq. 'BITFIELD') then
	  has_fields = .true.
	  if(field_mode) then
	    call dix_message(control,dix_msg_nestbitf)
	    goto 80
	  endif
	  ent_type = enttyp_field
	  field_mode = .true.
	elseif(typ .eq. 'ENDBITFIELD') then
	  if(.not. field_mode) then
	    call dix_message(control,dix_msg_nobitf)
	    goto 80
	  endif
	  ent_type = enttyp_endfield
	  field_mode = .false.
	else
c
c unsupported case
c  check it usermode wanted
c 
	  if(user) then
	    nkar1 = dix_util_get_len_fu(typ)
	    istat = dix_inter_read_command_usertype(lun_user,control,
     1               typ(1:nkar1),p_usertypes)
	    if(istat) then
	      if(size .lt. 0 .or. size .gt. 8*65535) goto 70
	      if(size .eq. 0) is_variable = .true.
	      ent_type = enttyp_user
	      username = typ
	      goto 51
	    else
	      goto 80
	    endif
	  endif
	  call dix_message(control,dix_msg_unkline)
	  goto 80
	end if
	lun_user = 0
	if(user) then
c
c If we came here and user is set, 
c   user tried to redefine standard type
c
	  nkar1 = dix_util_get_len_fu(typ)
	  call dix_message(control,dix_msg_userstd,typ(1:nkar1))
	  goto 80
	endif
c
c store the results
c save name () is now deleted
C
51	nk = dix_util_get_len(line)			!and length
	jpos = index(line,'[')				!see if fields specified
c
c See if the name is not double defined
c
	nk_nam = nk
	if(jpos .gt. 0) nk_nam = jpos-1
c
c Check if name is not double defined,
c  do not check for items not displayed
c
	if(line(1:1) .ne. '%' .and. .not. no_display .and. 
     1     line(1:nk_nam) .ne. ' ') then
	  do k=nrecs,1,-1
	    if(des_recs(k).ent_type .eq. enttyp_structure) goto 55
	    if(des_recs(k).name .eq. line(1:nk_nam)) then
	      call dix_message(control,dix_msg_doubldef,line(1:nk_nam))
	      goto 80
	    end if
	  end do
	endif
c
55	if(line(1:1) .ne. '%') then
	  istat = dix_util_check_name(line(1:nk_nam))
	  if(.not. istat) then
	    call dix_message(control,%val(istat),line(1:nk_nam))
	    goto 80
	  endif
	endif
c
	nrecs = nrecs + 1
	des_recs(nrecs).nam_len = nk_nam
	des_recs(nrecs).name    = line(1:nk_nam)
c
c Check on fieldnames separator
c
	des_recs(nrecs).fld_len = 0
	des_recs(nrecs).fld_adr = 0		!description
	if(jpos .ne. 0) then
c
c there was a [, so look for ] (if not found take eol)
c
	  ipos = index(line,']')		!compute new length
	  if(ipos .eq. 0) goto 80
c
c Allocate some room, and copy descriprot
c
	  line = line(jpos+1:ipos-1)
	  nk = ipos-jpos-1
	  if(line .ne. ' ') then
c
c remove all blanks
c
	    ipos = index(line,' ')
	    do while(ipos .lt. nk)
	      line = line(1:ipos-1)//line(ipos+1:nk)
	      nk = nk - 1
	      ipos = index(line,' ')
	    end do
	    call get_vm(nk,des_recs(nrecs).fld_adr,zone_id)
	    call dix_util_copy(nk,%ref(line),%val(des_recs(nrecs).fld_adr))
	    des_recs(nrecs).fld_len = nk
	  end if
	end if
	des_recs(nrecs).ent_type    = ent_type 
	des_recs(nrecs).size        = size
	des_recs(nrecs).size_asc    = size_asc
	des_recs(nrecs).variable    = is_variable
	des_recs(nrecs).nb_reserved = nb_reserved
	des_recs(nrecs).is_field    = field_mode
	des_recs(nrecs).translate   = trans_override
	des_recs(nrecs).min_val     = min_val
	des_recs(nrecs).no_display  = no_display
	des_recs(nrecs).max_val     = max_val
	des_recs(nrecs).fieldname_status = fieldname_status
	des_recs(nrecs).p_link_rec  = p_link_rec
	des_recs(nrecs).lun_translate= lun_user
	des_recs(nrecs).username    = username
	des_recs(nrecs).case      = case
   	if(is_variable) fixed = .false.
	do k=1,max_dimension
	  des_recs(nrecs).rep.dim(k) = rep.dim(k)
	end do
	if(range_data .ne. ' ') then
	  call dix_message(control,dix_msg_randign)
	endif
	goto 10
65 	call dix_message(control,dix_msg_ranstru)
	goto 80
66	nk1 = dix_util_get_len_fu(errline)
	call dix_message(control,%val(istat),errline(1:nk1))
 	call dix_message(control,dix_msg_evalerr)
	goto 80
68	call dix_message(control,dix_msg_typbitf,typ)
	goto 80
c
c Error in dimension
c
69	call dix_message(control,dix_msg_dimerr)
	goto 80
c
c Error in repeat count
c
70	call dix_message(control,dix_msg_sizerr,%val(size))
	goto 80
c
c format error in line
c
80	nke = dix_util_get_len_fu(errline)
	if(nke .gt. 0) call dix_message(control,dix_msg_general,
     1                  errline(1:nke))
	if(nkar_o .gt. 0) then
	  call dix_message(control,dix_msg_errinline,oline(1:nkar_o))
	endif
	goto 92
c
c Could not open record file
c
c Normal exit; check for open structures
c
90	dix_des_process_lines = .true.
	if(deep_structure .ne. 0) then
	  call dix_message(control,dix_msg_openstruc)
	  goto 92
	end if
	if(deep_union .ne. 0) then
	  call dix_message(control,dix_msg_openunion)
	  goto 92
	end if
	if(deep_map .ne. 0) then
	  call dix_message(control,dix_msg_openmap)
	  goto 92
	end if
	if(field_mode) then
	  call dix_message(control,dix_msg_openbitf)
	  goto 92
	end if
	if(in_range) then
	  call dix_message(control,dix_msg_openrange)
	  goto 92
	end if
	goto 95
c
c exit in case of error, nent=0
c
92	nrecs = 0
	dix_des_process_lines = .false.
c
c normal exit
c
95	return
	end	  
	function dix_des_conv_idx(ntyp,value)
	implicit none
c
c convert a text to a number
c
	include 'dix_def.inc'
	character*(*) ntyp		!:i: the text
	integer*4 value			!:o: the number
	logical*4 dix_des_conv_idx	!:f: function result
c#
c
	dix_des_conv_idx = .false.
	read(ntyp,'(bn,i10)',err=90) value
	dix_des_conv_idx = .true.
90	return
	end 
c
	function dix_des_expand(control,des_expanded,file,iquiet)
	implicit none
	include 'dix_def.inc'
c
c (re-)expand a description
c
	record /control/ control	!:i: control structure
	record /des_expanded/ des_expanded !:io: expanded des
	record /file_info/ file		!:i: the file data
	logical*4 iquiet		!:i: (opt) do no signal errors
	logical*4 dix_des_expand	!:f: function result
c#
	character*(max_filename_length) line
c
	integer*4 max_data,nk,max_size
c
	logical*4 dix_des_expand_1
	external dix_msg_dessmall
	external dix_msg_debug
c
	record /des_info/ des_info
	pointer (p_des_info,des_info)
c
	logical quiet
c
c Return prev memory
c
	if(control.debug) call dix_message(control,dix_msg_debug,
     1       'expanding desc '//des_expanded.handle)
	if(iargcount() .gt. 3) then
	  quiet = iquiet
	else
	  quiet = .false.
	endif
	p_des_info = des_expanded.p_des_info
	call dix_des_clean_expanded(des_expanded)
c
	call init_vm(des_expanded.zone_rec,0,
     1         'EXP_'//des_expanded.handle(1:des_expanded.nk_handle),
     1         .false.)
c
	dix_des_expand = dix_des_expand_1(control,
     1                   des_info.n_lin,%val(des_info.lin_adr),
     1                   file,
     1                   des_expanded.nb_des,des_expanded.des_adr,
     1                   des_expanded.n_des,
     1                   des_expanded.nfield_notcompressed,
     1                   max_size,max_data,
     1                   des_expanded.zone_rec,quiet)
	des_expanded.max_name_size = max_size
c
	if(file.data.nb_data .gt. max_data) then
	  if(.not. quiet) then
	    call dix_des_display(control,des_info,line,nk,.true.)
	    call dix_message(control,dix_msg_dessmall,line(1:nk))
	  endif
	end if
	call dix_symbol_delete(control,'%BIT_LOCATION',.false.,.true.,.true.)
	call dix_symbol_delete(control,'%LOCATION',.false.,.true.,.true.)
	return
	end

	function dix_des_expand_1(control,n_des,des_rec_fils,
     1         file,
     1         nb_all_des,des_adr,n_desw,n_desnc,
     1         max_size,max_data,vm_zone,quiet)
	implicit none
c
c DO the real expand from a desiirptor 
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:i: the file/record data
	integer*4 n_des			!:i: #descriptors
	record /des_rec_fil/ des_rec_fils(*)	!:o: the descriptions
	integer*4 nb_all_des		!#bytes allocated for descriptions
	integer*4 des_adr		!address of descripror segment
	integer*4 n_desw                !#descriptions really used
	integer*4 n_desnc		!#fields not compressed
	integer*4 max_size		!:o: ths max size of the name
	integer*4 max_data		!:o: max byteoffset seen
	record /vm_zone/ vm_zone	!:i: the vm_zone to allocate mem from
	logical quiet			!:i: do not signal error
	logical*4 dix_des_expand_1	!:f: function result
c#
c local vars
c
	logical*4 dix_con_is_filler
c	integer*4 dix_util_insert_element_v
cc
	record /des_rec/ des_rec
	record /des_rec/ des_rec_w
c
	record /des_rec_fil/ des_rec_fil
	pointer (p_des_rec_fil,des_rec_fil)
c
	integer*4 size,nk,kk,bit_offset,nb_asc,k
	integer*4 resval
	logical*4 is_zero
c
	structure /save_struct/
	  integer*4 nk_p
	  integer*4 nk_r
	  integer*4 file_line
	  record /repeat/ rep
	end structure
c
	structure /save_union/
	  integer*4 beg_offset		!bit_offset for begin of union
	  integer*4 end_offset  	!bit_offset for end_union
	  integer*4 idx_last_map	!i_Des for last map statement in union
	  integer*4 idx_match_all	!i_des for map statement with dependency=*
	  integer*4 idx_end_union	!i_des for end_union
	  logical*2 used		!flag is any of the map's in the union is used
	  logical*2 override		!override checks 
	end structure
c
	record /save_struct/ save_struct(max_depth)
	record /save_union / save_union(max_depth)
c
	integer*4 deep_structure,deep_map,save_deep_map,deep_union 
c
	logical*4 fill
	character*(max_err_arg_length) errline
	character*(max_line_length) prefix_line,nam,wnam
	integer*4 nkar_prefix,i_des,ent_type,low_lim,hig_lim,id_wnam,ipos
	integer nke,max_pos,range_save_bit_offset,istat,line_nr
	integer*4 fldnam(2)
	logical*4 var_field,cnv_err,in_range,is_symbol
c
	record /value/ eval_val
c	record /symbol/ std_vals(2)
c
	integer*4 str$element
c
	logical*4 dix_util_get_len_fu
	logical*4 dix_des_set_next
	integer*4 dix_eval_express_des
	logical*4 dix_eval_expression
	integer*4 dix_util_get_len
	logical dix_util_find_field
c
	external dix_msg_mapnfnd
	external dix_msg_general
	external dix_msg_mapnotint

c
c start of coding
c
	call dix_eval_init_value(eval_val)
	dix_des_expand_1 = .false.
	errline        = ' '
	nb_asc         = 0
	deep_structure = 0
	deep_map       = 0
	deep_union     = 0
	bit_offset     = 0
	max_size       = 0
	max_data       = 0
	in_range       = .false.
	line_nr        = 0
	n_desnc        = 0
c
c read lines
c
	prefix_line = ' '
	nkar_prefix = 0
	i_des       = 0
	n_desw      = 0
c
c Cannot use DO loop, i_des will change (structures)
c
10	i_des = i_des + 1
11	var_field = .false.
	call dix_symbol_add_int(control,'%BIT_LOCATION',bit_offset,errline)
	call dix_symbol_add_int(control,'%LOCATION',bit_offset/8,errline) 
c
c See if we have processed all des entries
c
	if(i_des .gt. n_des) goto 90
c
c no, so process the next one
c
	  des_rec_fils(i_des).tbit_offset = bit_offset
c
C Check on var data
c Handle var dimension (only for character*(field)
c
	  if(des_rec_fils(i_des).size_asc .ne. ' ') then	
	    istat = dix_eval_express_des(control,
     1              des_rec_fils(i_des).size_asc,
     1              resval,errline,.true.)
	    if(istat) then
	      des_rec_fils(i_des).size = resval*8
	    else
	      if(.not. quiet) then
	        nke = dix_util_get_len_fu(errline)
                call dix_message(control,%val(istat),errline(1:nke))
	      endif
	      goto 99
	    endif
	  endif
c
c Handle exit
c 
	  if(des_rec_fils(i_des).ent_type .eq. enttyp_exit) then
c
c Find the next endstructure
c
	    if(deep_structure .eq. 0) goto 10	!should not happen
	    do kk=i_des+1,n_des
	      if(des_rec_fils(i_des).ent_type.eq.enttyp_endstructure)then
c
c Set the repeart to exit, and set pointer to end_structure
c
	        do k=1,max_dimension
	          save_struct(deep_structure).rep.dim(k).idx = 
     1             save_struct(deep_structure).rep.dim(k).high
	        end do
	        i_des = kk
	        goto 12
	      end if
	    end do
c
c Not found, should not happen
c
	    goto 10
	  end if
c
c handle dimension types
c
12	  if(des_rec_fils(i_des).ent_type .eq. enttyp_map) goto 141
	  do kk=1,max_dimension
	    if(des_rec_fils(i_des).rep.dim(kk).low_name(1:1) .ne. '*') then
	      if(des_rec_fils(i_des).rep.dim(kk).low_name .ne. ' ') then
	        istat = dix_eval_express_des(control,
     1              des_rec_fils(i_des).rep.dim(kk).low_name,
     1              resval,errline,.true.)
	        if(istat) then
	          des_rec_fils(i_des).rep.dim(kk).low = resval
	        else
	          if(.not. quiet) then
	            nke = dix_util_get_len_fu(errline)
	            call dix_message(control,%val(istat),errline(1:nke))
	          endif
	          goto 99
	        endif
	      end if
	      if(des_rec_fils(i_des).rep.dim(kk).high_name .ne. ' ') then
	        istat = dix_eval_express_des(control,
     1              des_rec_fils(i_des).rep.dim(kk).high_name,
     1              resval,errline,.true.)
	        if(istat) then
	          des_rec_fils(i_des).rep.dim(kk).high = resval
	        else
	          if(.not. quiet) then
	            nke = dix_util_get_len_fu(errline)
	            call dix_message(control,%val(istat),errline(1:nke))
	          endif
	          goto 99
	        endif
	      end if
	    end if
	    des_rec_fils(i_des).rep.dim(kk).idx = 
     1            des_rec_fils(i_des).rep.dim(kk).low
	  end do
C
c
141	  ent_type = des_rec_fils(i_des).ent_type
	  size = des_rec_fils(i_des).size
	  var_field = des_rec_fils(i_des).variable
c
c Select some special cases
c
c
	  if(ent_type .eq. enttyp_structure) then
c
c Structure, 
c 1. build new prefix (include new structure name)
c 2. Remember the i_des for the structure
c 3. since a structure can have a repeat count,
c    remember the repeat count
c
c
	    deep_structure = deep_structure + 1
c
c Remember current prefix length (for truncating on endstructure)
c	
	    save_struct(deep_structure).nk_p      = nkar_prefix
	    save_struct(deep_structure).file_line = i_des
	    save_struct(deep_structure).rep       = des_rec_fils(i_des).rep
c
	    prefix_line(nkar_prefix+1:) = des_rec_fils(i_des).name
	    nkar_prefix = nkar_prefix + des_rec_fils(i_des).nam_len
c
c Remember nkar_prefix (for rebuilding dimension on endstructure)
c
	    save_struct(deep_structure).nk_r = nkar_prefix
	    call dix_des_insert_indices(prefix_line,
     1        save_struct(deep_structure).rep,nkar_prefix)
	    nkar_prefix = nkar_prefix + 1
	    prefix_line(nkar_prefix:nkar_prefix) = '.'
	    goto 10
	  elseif(ent_type .eq. enttyp_endstructure) then
c
c endstructure, if repeat count exceeded than all ok
c if not exceeded skip back file to correct line
c 
	    if(dix_des_set_next(save_struct(deep_structure).rep)) then
c
c More repeating of structure, so trunctate prefix to point just before
c repeat counts, and rebuild repeat count
c and then set i_Des to the line of the corresponding structure
c  since label 10 will increase i_des before executing, the first
c  description to be executed will be the first line after the
c  corresponding structure
c
	      nkar_prefix = save_struct(deep_structure).nk_r
	      call dix_des_insert_indices(prefix_line,
     1             save_struct(deep_structure).rep,nkar_prefix)
	      nkar_prefix = nkar_prefix + 1
	      prefix_line(nkar_prefix:nkar_prefix) = '.'
	      i_des = save_struct(deep_structure).file_line
	    else
c
c Repeat count exhausted, so truncate prefix length to previous length
c
	      nkar_prefix = save_struct(deep_structure).nk_p 
	      deep_structure = deep_structure-1
	    end if
	    prefix_line(nkar_prefix+1:) = ' '	   
	    goto 10
c
	  elseif (ent_type .eq. enttyp_map) then
c
c Map statement
c 1. Set bit_offset back to the one it was during the UNION statement
c 2. Remember the i_des of this MAP (so we will see the last MAP again)
c 3. check for override, if so execute without questions
c 4. check for dependend part. 
c    4.1 if not, execute map
c    4.2 if there is a dependend part
c        4.2.1 if depandant part=*, remember in IDX_MATCH_ALL, and skip
c              until corresponding ENDMAP
c        compute dependend value, and compare to range given
c        4.2.1 if match, execute
c        4.2.2 if no match, skip until corresponding ENDMAP
c
	    bit_offset = save_union(deep_union).beg_offset
	    save_union(deep_union).idx_last_map = i_des
	    deep_map = deep_map + 1
c
c If override is set, do not check the dependend field
c
	    if(save_union(deep_union).override) goto 544
c
c See if dependend map, if so the name field contains the dependend string
c  format 
c   MAP name=value[,value...]
c  where value=begin_value[:end_value]
c
	    wnam = des_rec_fils(i_des).rep.dim(1).low_name  
	    if(wnam(1:1) .ne. ' ') then
c
c there is a dependend field
c
	      if(wnam(1:1) .eq. '*') then
c
c It is a match if no other map matches, so remember this index
c
	        save_union(deep_union).idx_match_all = i_des
	      else
c
c It is a normal dependend field, try to locate
c
c
	        nk = dix_util_get_len(wnam)
c
c First try to locate the fieldname itself
c
	        fldnam(1) = 0
	        fldnam(2) = 0
	        do k=n_desw,1,-1
	          call dix_des_get_des_1(%val(des_adr),k,des_rec_w,nam)
	          if(nam .eq. wnam) then
	            fldnam(1) = des_rec_w.fld_len
	            fldnam(2) = des_rec_w.fld_adr
	            goto 431
	          else
	            p_des_rec_fil = des_rec_w.link_back
	            if(wnam .eq. des_rec_fil.name) then
	              fldnam(1) = des_rec_w.fld_len
	              fldnam(2) = des_rec_w.fld_adr
	              goto 431
	            endif
	          endif
	        end do
c
431	        istat= dix_eval_expression(control,wnam(1:nk),eval_val,
     1             .false.,errline,.true.,is_symbol)
	        if(istat) then
	          if(eval_val.type .ne. symb_typ_int) then
	            if(.not. quiet) then
	              call dix_message(control,dix_msg_mapnotint,wnam(1:nk))
	            endif
	            goto 99
	          endif
c
c Got the value of the dependend field
c Check the range(s) to check
c
	          des_rec.bit_offset = 0
	          des_rec.size = min(32,des_rec.size)
	          id_wnam = 0
	          do while(str$element(wnam,id_wnam,',',
     1               des_rec_fils(i_des).rep.dim(1).high_name))
c
c Now we have a range in WNAM (format begin_value[:end_value] 
c
	            nk = dix_util_get_len(wnam)
	            id_wnam = id_wnam + 1
c            
c Format entry[,entry[,entry]
c where entry = begin[:end]
c
	            cnv_err = .true.
	            ipos = index(wnam,':')
	            if(ipos .eq. 0) then
c
c Only one value, so begin_value=end_value
c
c
	              cnv_err = .not. dix_eval_express_des(control,
     1                 wnam(1:nk),low_lim,errline,.true.)
	              if(cnv_err .and. fldnam(1) .gt. 0) cnv_err = .not.
     1                  dix_util_find_field(wnam(1:nk),fldnam,low_lim)
	              if(.not. cnv_err) then
	                hig_lim = low_lim
	                cnv_err = .false.
	              endif
	            else
c
c We have format begin_value:end_value
c
	              cnv_err = .not. dix_eval_express_des(control,
     1                 wnam(1:ipos-1),low_lim,errline,.true.)
	              if(cnv_err .and. fldnam(1) .gt. 0) cnv_err = .not.
     1                  dix_util_find_field(wnam(1:ipos-1),fldnam,
     1                                      low_lim)
c
	              if(.not. cnv_err) then
	                cnv_err = .not. dix_eval_express_des(control,
     1                    wnam(ipos+1:nk),hig_lim,errline,.true.)
	                if(cnv_err .and. fldnam(1) .gt. 0) cnv_err = .not.
     1                    dix_util_find_field(wnam(ipos+1:nk),fldnam,
     1                                        hig_lim)
	              endif
	            endif
	            if(cnv_err) then
c
c Check if depenandant value is in range
c
	              if(.not. quiet) then
	                nke = dix_util_get_len_fu(errline)
                        call dix_message(control,dix_msg_general,
     1                      errline(1:nke))
	              endif
	              goto 99
	            else
	              if(eval_val.ival .ge. low_lim .and. 
     1                   eval_val.ival .le. hig_lim) goto 544
	            endif
	          enddo
	        else
c
c Could not find dependend field
c
	          if(.not. quiet) then
	            nke = dix_util_get_len_fu(errline)
                    call dix_message(control,%val(istat),errline(1:nke))
	            call dix_message(control,dix_msg_mapnfnd,wnam(1:nk))
	          endif
	          goto 99
	        endif
	      endif
c
c No match, Skip until next corresponding endmap description
c
	      save_deep_map = deep_map
	      do while(des_rec_fils(i_des+1).ent_type .ne. enttyp_endmap
     1                   .or. deep_map .ne. save_deep_map)
	        i_des = i_des + 1
	        if(des_rec_fils(i_des).ent_type .eq. enttyp_map) 
     1                  deep_map = deep_map + 1
	        if(des_rec_fils(i_des).ent_type .eq. enttyp_endmap) 
     1                  deep_map = deep_map - 1
	      end do
	      goto 10		!not used yet
	    end if
c
c We have a match, or no dependend field , or override
c
544	    save_union(deep_union).used = .true.
	    goto 10					!all done
c
	  elseif (ent_type .eq. enttyp_endmap) then
c
c End map, remember biggest bit_offset
c
	    deep_map = deep_map-1
c
c If override, we were executing a previous map, so skip to end union now
c
	    if(save_union(deep_union).override) 
     1          i_des = save_union(deep_union).idx_end_union-1
c
c Else remember the biggest bit_offset of all MAP's
c
	    save_union(deep_union).end_offset = 
     1          max(save_union(deep_union).end_offset,bit_offset)
	    goto 10					!all done
	  elseif (ent_type .eq. enttyp_union) then
c
c New union
c  Rememer a lot of things
c
	    deep_union = deep_union + 1
	    save_union(deep_union).beg_offset    = bit_offset
	    save_union(deep_union).end_offset    = bit_offset
	    save_union(deep_union).idx_last_map  = 0
	    save_union(deep_union).idx_match_all = 0
	    save_union(deep_union).idx_end_union = 0
	    save_union(deep_union).used          = .false.
	    save_union(deep_union).override      = .false.
	    goto 10					!all done
	  elseif (ent_type .eq. enttyp_endunion) then
c 
c End union, see if any of the MAP's matched,
c If not, try to skip back to the match_all map (MAP *)
c  if that is not found, take the last map in the union
c
	    if(.not. save_union(deep_union).used) then
c
c No map of this union has been used
c  1. remember IDX of end_union
c  2. Set override
c  3. skip back to a valid MAP
c
	      save_union(deep_union).idx_end_union = i_des
	      i_des = save_union(deep_union).idx_match_all
	      if(i_des .eq. 0) i_des = save_union(deep_union).idx_last_map !rewind a bit
	      i_des = i_des - 1			!so we find the MAP again
	      save_union(deep_union).override = .true.
	    else
c
c Some map has beep used, now set the bit_offset to the max of all MAP's found
c
	      bit_offset = save_union(deep_union).end_offset
	      deep_union = deep_union-1
	    end if
	    goto 10					!all done
	  elseif(ent_type .eq. enttyp_field) then
	    goto 10
	  elseif(ent_type .eq. enttyp_endfield) then
	    if(mod(bit_offset,8) .ne. 0) then
	      bit_offset = bit_offset + 8-mod(bit_offset,8)
	    end if
	    goto 10
	  elseif(ent_type .eq. enttyp_position) then
	    bit_offset = des_rec_fils(i_des).rep.dim(1).high*8
	    goto 10
	  elseif(ent_type .eq. enttyp_range) then
	    range_save_bit_offset = bit_offset
	    bit_offset = des_rec_fils(i_des).rep.dim(1).low*8
	    max_pos    = min(file.data.nb_data,
     1                des_rec_fils(i_des).rep.dim(1).high)
	    in_range   = .true.
	    goto 10
	  elseif(ent_type .eq. enttyp_endrange) then
	    in_range = .false.
	    bit_offset = range_save_bit_offset
	    goto 10
	  end if
c
c Normal case, just normal type
c
75	  if(in_range) then
	    if(bit_offset .ge. max_pos*8) goto 76
	  else
	    if(bit_offset .ge. file.data.nb_data*8) goto 76
	  endif
c
c For var data, use type to determine real size
c
	  if(ent_type .eq. enttyp_pad) then
 	    size = mod(size-mod(bit_offset,size),size)
	  else
	    if(var_field) then
	      size = file.data.nb_data*8-bit_offset
	      call dix_des_get_real_size(ent_type,size,
     1              file.data.data_rec(bit_offset/8+1),
     1              des_rec_fils(i_des).lun_translate,control)
	    end if
	  end if
c
	  nam = prefix_line(1:nkar_prefix)//des_rec_fils(i_des).name !compute name
	  nk = nkar_prefix + des_rec_fils(i_des).nam_len	!and length
	  fill = index(nam(1:nk),'%') .ne. 0 .or. ent_type .eq. enttyp_pad .or.
     1            des_rec_fils(i_des).no_display
c
	  is_zero = dix_con_is_filler(control,size,bit_offset,ent_type,
     1                 file.data.data_rec)
c
	  call dix_des_insert_indices(nam,des_rec_fils(i_des).rep,nk) !Add repeat counts
c
c
	  if(.not. fill) then
	    if(des_rec_fils(i_des).p_link_rec .ne. 0) then
	      if(nk+1 .gt. max_size) max_size = nk+1
	    else
	      if(nk   .gt. max_size) max_size = nk
	    endif
c
	    call get_vm(nk,des_rec.nam_adr,vm_zone)
	    call dix_util_copy(nk,%ref(nam),%val(des_rec.nam_adr))
	    des_rec.nam_len     = nk
c
	    des_rec.fld_len     = des_rec_fils(i_des).fld_len
	    des_rec.fld_adr     = des_rec_fils(i_des).fld_adr
	    des_rec.ent_type    = ent_type 
	    des_rec.size        = size
	    des_rec.link_back   = %loc(des_rec_fils(i_des))
	    des_rec.bit_offset  = bit_offset
	    des_rec.variable    = des_rec_fils(i_des).variable
	    des_rec.translate   = des_rec_fils(i_des).translate
	    des_rec.nb_reserved = des_rec_fils(i_des).nb_reserved
	    des_rec.is_field    = des_rec_fils(i_des).is_field
	    des_rec.dependency  = .false.
	    des_rec.readonly    = .false.
	    des_rec.min_val     = des_rec_fils(i_des).min_val
	    des_rec.max_val     = des_rec_fils(i_des).max_val
	    des_rec.p_link_rec  = des_rec_fils(i_des).p_link_rec
	    des_rec.fieldname_status = des_rec_fils(i_Des).fieldname_status
	    des_rec.lun_translate = des_rec_fils(i_des).lun_translate
	    des_rec.case         = des_rec_fils(i_des).case
	    des_rec.compressed   = is_zero
	    if(.not. is_zero) n_desnc = n_desnc + 1
	    line_nr = line_nr + 1
c
c  Now add description to list of descriptions
c           
	    call dix_util_insert_element(sizeof(des_rec),des_rec,n_desw,
     1             nb_all_des,des_adr,50,vm_zone)
	  end if
c
	  bit_offset                  = bit_offset + size
	  if(bit_offset/8 .gt. max_data) max_data = bit_offset/8
c
c CHeck for repeat count
c
	  if(dix_des_set_next(des_rec_fils(i_des).rep)) then
	    goto 75
	  end if
	  goto 10
c
c Finished
c
76	  if(in_range .or. deep_map .gt. 0) goto 10
c
c normal exit
c
90	dix_des_expand_1 = .true.
99	call dix_eval_free_value(eval_val)
	return
	end	  
c
	function dix_des_find_par(control,name,resval)
	implicit none
c
c Try to find a parameter in a des_rec
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) name		!:i: name of param
	integer*4 resval		!:o: result value
	integer*4 dix_des_find_par	!:f: function result
c
c
	record /file_info/ file
	pointer (p_file,file)
c
	record /des_expanded/ des_expanded
	pointer (p_des_Expanded,des_expanded)
c
	record /des_info/ des
	pointer (p_des,des)
c
	record /param/ pars(*)
	pointer (p_pars,pars)
c
	integer*4 k
c
	dix_des_find_par = .false.
	resval = 0
c
	p_file = control.cur_file
	if(p_file .eq. 0) goto 90
c
	p_des_expanded = file.cur_des
	if(p_des_expanded .eq. 0) goto 90
c
	p_des = des_expanded.p_des_info
	if(p_des .eq. 0) goto 90
c
	p_pars = des.par_adr
c
	do k=1,des.n_par
	  if(pars(k).name .eq. name) goto 20
	end do
	goto 90
c
20	resval = pars(k).value
	dix_des_find_par = .true.
c
90	return
	end
c
	function dix_des_find_field(control,name,des_rec,set_dep,ptr)
	implicit none
c
c Try to find a field name from the list of expanded des
c A fully qualifier field name is
c filetag\descriptiontag\name
c both tags default to the current (file or description)
c if only one \ is found, it is interpreted as
c  filetag\filename  with the current description is used
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) name		!:i: the name to find
	record /des_rec/ des_rec	!:o: the resulting des_rec
	logical set_dep			!:i: if found, do we set dependency flag?
	logical field_mode		!:o: in fieldmode?
	integer*4 ptr			!:o: pointer to file where found
	logical*4 dix_des_find_field	!:f: result of search
c#
	character*(name_length) namdes
	integer*4 k,pos_field,ptr_file,ptr_des
c
	record /des_rec_fil/ des_rec_fil
	pointer (p_des_rec_fil,des_rec_fil)
c
	record /file_info/ file
	pointer (p_file,file)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_rec/ des_recs(*)
	pointer (p_des_recs,des_recs)
c
	logical dix_des_find_file_des
c
	dix_des_find_field = .false.
c
c Set pointers right
c
	if(dix_des_find_file_des(control,name,ptr_file,ptr_des,pos_field)) then
	  p_file         = ptr_file
	  p_des_expanded = ptr_des
	  p_des_recs     = des_expanded.des_adr
c
	  field_mode = .false.
	  do k=1,des_expanded.n_des
c
c Get the (expanded) name of the field
c the also contains structure info
c e.g. str1.str2.field(d1,d2)
c We need the field part
c
	    namdes = ' '
 	    call dix_util_copy(des_recs(k).nam_len,
     1           %val(des_recs(k).nam_adr),%ref(namdes))
	    if(namdes .eq. name(pos_field:)) goto 80
	  end do
c
c Did not find the name, now try backlink to the original 
c  field specification (the one in the description file)
c
	  do k=des_expanded.n_des,1,-1
	    p_des_rec_fil = des_recs(k).link_back
	    namdes = des_rec_fil.name(1:des_rec_fil.nam_len)
	    if(name(pos_field:) .eq. namdes) goto 80
	  end do
c
c Could not find it, now check for special values
c
	  if(name(pos_field:) .eq. '$RECORDSIZE') then
	    des_rec.ent_type = enttyp_int
	    des_rec.bit_offset = 8*(%loc(file.data.nb_data) -
     1                              %loc(file.data.data_rec))
	    des_rec.size = 8*sizeof(file.data.nb_data)
	    goto 85
	  endif
	  goto 90
c
c Found the field, return des_rec, 
c  if set_dep is true, makr this field as having a dependency
c
80	  des_rec   = des_recs(k)
	  if(set_dep) des_recs(k).dependency = .true.
85	  dix_des_find_field = .true.
	  ptr = p_file
	endif
c
90	return
	end
	function dix_des_find_file_des(control,name,ptr_file,ptr_des,pos_field)
	implicit none
c
c Try to find a field name from the list of expanded des
c A fully qualifier field name is
c filetag\descriptiontag\name
c both tags default to the current (file or description)
c if only one \ is found, it is interpreted as
c  filetag\filename  with the current description is used
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) name		!:i: the name to find
	integer*4 ptr_file		!:o: pointer to file where found
	integer*4 ptr_des		!:o: pointer to description found
	integer*4 pos_field		!:o: position in name of start of fieldname
	logical*4 dix_des_find_file_des	!:f: result of search
c#
	integer*4 k,pos_descr
c
	record /file_info/ file
	pointer (p_file,file)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	dix_des_find_file_des = .false.
c
c Set pointers right
c
	pos_field = index(name,'\')
	if(pos_field .ne. 0) then
	   pos_descr = index(name(pos_field+1:),'\')
	   if(pos_descr .ne. 0) then
	     k = pos_descr + pos_field
	     pos_descr = pos_field
	     pos_field = k
	  else
	    pos_descr = pos_field
	  endif
c
c Name had a file tag, now search all files for the tag
c
	  if(pos_descr .eq. 1) then
	     p_file = control.cur_file
	  else
	    p_file = control.top_file
	    do while(p_file .ne. 0)
	       if(file.handle .eq. name(1:pos_descr-1)) goto 10
	       p_file = file.link.forw
	     end do
	  endif
	else
	  p_file = control.cur_file
	  pos_descr = 0
	endif
c
c We have found the file (either by default ot explicit)
c Now try to find the description
c
10	ptr_file = p_file
	if(p_file .eq. 0) goto 90
c
	if(pos_descr .lt. pos_field+1) then
	  p_des_expanded = file.cur_des
	else
c
c Find a match for the description
c
	  p_des_expanded = file.top_des
	  do while(p_des_expanded .ne. 0)
	    if(des_expanded.handle .eq. name(pos_field+1:pos_descr-1)) goto 20
	  end do
	endif
20	pos_field = pos_field + 1
	if(p_des_expanded .eq. 0) goto 90
c
	ptr_des = p_des_expanded
	dix_des_find_file_des = .true.
c
90	return
	end
c
	subroutine dix_des_get_fieldname(control,idx,mask,name,nkar)
	implicit none
c
c Return fieldnames 
c  return the idx'th occurrence of the fieldname that matches "mask"
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	integer*4 idx			!:i: the idx'th match
	character*(*) mask		!:i: mask
	character*(*) name		!:o: the name found
	integer*4 nkar			!:o: name length
c#
	record /file_info/ file
	pointer (p_file,file)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_rec/ des_recs(*)
	pointer (p_des_recs,des_recs)
c
	integer*4 k,count
	character*(name_length) namdes
c
	logical str$match_wild
c
c Search backward
c
	p_file = control.cur_file
	if(p_file .eq. 0) goto 10
c
	p_des_expanded = file.cur_des
	if(p_des_expanded .eq. 0) goto 10
c
	p_des_recs = des_expanded.des_adr
c
	count = 0
	do k=1,des_expanded.n_des
	  namdes = ' '
	  nkar = des_recs(k).nam_len
 	  call dix_util_copy(nkar,%val(des_recs(k).nam_adr),%ref(namdes))
	  if(str$match_wild(namdes(1:nkar),mask)) then
	    count = count + 1
	    if(count .eq. idx) goto 20
	  end if	     
	end do
10	nkar = 0
	namdes = ' '
20	name = namdes
	return
	end
c
	subroutine dix_des_get_real_size(ent_type,size,data,lun,control)
	implicit none
	include 'dix_def.inc'
c
	integer*4 ent_type	!:i: entry type
	integer*4 size		!:io: input max size, output computed size
	byte data(*)		!:i: the data
	integer*4 lun		!:i: lun for user type
	record /control/ control
c#
	integer*4 limit,bltyp,k
c
	logical dix_inter_execute
c
	limit = size
	if    (ent_type .eq. enttyp_string) then
	  size = 0
	  call dix_util_copy(1,data(1),size)
 	  size = size+1
	  size = size*8
	elseif(ent_type .eq. enttyp_wstring) then
	  size = 0
	  call dix_util_copy(2,data(1),size)
	  size = size+2
	  size = size*8
	elseif(ent_type .eq. enttyp_lstring) then
	  call dix_util_copy(4,data(1),size)
	  size = size+4
	  size = size*8
	elseif(ent_type .eq. enttyp_zstring ) then
	  do size=1,limit
	    if(data(size) .eq. 0) goto 311
	  end do
	  size = limit
311	  continue
	  size = size*8
	elseif(ent_type .eq. enttyp_hstring) then
	  do size=1,limit
	    if(data(size) .lt. 0) goto 312
	  end do
	  size = limit
312	  continue
	  size = size*8
	elseif(ent_type .eq. enttyp_diskmap) then
	  bltyp = 0
	  call lib$movc3(2,data,bltyp)
	  bltyp = ishft(bltyp,-14)
	  if(bltyp .eq. 0) then
	    size = 2
	  elseif(bltyp .eq. 1) then
	    size = 4
	  elseif(bltyp .eq. 2) then
	    size = 6
	  elseif(bltyp .eq. 3) then
	    size = 8
	  endif
	  size = size*8
	elseif(ent_type .eq. enttyp_acl) then
	  size = 0
	  call dix_util_copy(1,data(1),size)
	  size = size*8
	elseif(ent_type .eq. enttyp_user) then
	  call dix_inter_execute(control,'SIZE',lun,
     1            0,' ',data(1),size,
     1            k,size,size)
	end if
	if(size .gt. limit) size = limit
	return
	end
	function dix_des_set_next(rep)
	implicit none
c
c Set the next iteration from tables
c
	include 'dix_def.inc'
	record /repeat/ rep		!:io: repeat structure
	logical*4 dix_des_set_next	!:F: function result
c
	integer*4 kk
c
	kk = 1
	dix_des_set_next = .true.
10	if(rep.dim(kk).idx .lt. rep.dim(kk).high) then
	  rep.dim(kk).idx = rep.dim(kk).idx+1
	else
	  rep.dim(kk).idx = rep.dim(kk).low
	  if(kk .lt. max_dimension) then
	    kk = kk + 1
	    goto 10
	  end if
	  dix_des_set_next = .false.
	end if
	return
	end

	subroutine dix_des_insert_indices(text,rep,nk)
	implicit none
c
c Insert the dimension (if present) to the name
c
	character*(*) text
	include 'dix_def.inc'
	record /repeat/ rep		!:i: repeat
	integer*4 nk			!:o: printed length
c#
	integer*4 k,nk1
c
c	nk = 0
	do k=1,max_dimension
	  if(rep.dim(k).high .gt. rep.dim(k).low) goto 10
	end do
	goto 90
10	text(nk+1:nk+1) = '('
	nk = nk+1
 	do k=1,max_dimension
	  if(rep.dim(k).high .gt. rep.dim(k).low) then
	    call dix_con_type_intasc(4,rep.dim(k).idx,enttyp_int,
     1               text(nk+1:),nk1)
	    nk = nk+nk1+1
	    text(nk:nk) = ','
	  end if
	end do
	text(nk:nk) = ')'
90	return
	end

	function dix_des_get_des(des_expanded,i_des,des_rec,name)
	implicit none
c
c Get a (expanded)des_rec from the descriptor record
c
	include 'dix_def.inc'
	record /des_expanded/ des_expanded !:i: des exp structure
	integer*4 i_des			!:i: the des wanted
	record /des_rec/ des_rec	!:o: the wanted des_rec
	character*(*) name		!:o: the name
	logical*4 dix_des_get_des	!:f: the function result
c#
	if(i_des .ge. 1 .and. i_des .le. des_expanded.n_des) then
	  dix_des_get_des = .true.
	  call dix_des_get_des_1(%val(des_expanded.des_adr),i_des,
     1                   des_rec,name)
	else
	  dix_des_get_des = .false.
	  name = ' '
	end if
	return
	end

	subroutine dix_des_get_des_1(des_recs,i_des,des_rec,name)
	implicit none
c
c Get the descriptor entry from the list
c fill in the  name too
c
	include 'dix_def.inc'
c
	record /des_rec/ des_recs(*)	!:i: the list of (expanded) des_recs
	integer*4 i_des			!:i: the wanted one
	record /des_rec/ des_rec	!:o: the selected des_rec
	character*(*) name		!:o: and its name
c#
	integer*4 nk
c
	des_rec = des_recs(i_des)
	name = ' '
	nk = min(des_rec.nam_len,len(name))
	call dix_util_copy(nk,%val(des_rec.nam_adr),%ref(name))
	return
	end

	subroutine dix_des_set_des(des_expanded,i_des,des_rec)
	include 'dix_def.inc'
c
c Ovewrite a specific (expanded) des_rec
c
	record /des_expanded/ des_expanded !:i: descriprot structure
	integer*4 i_des			!:i: the  index to be overwritten
	record /des_rec/ des_rec	!:i: the new value
c#
	if(i_des .ge. 1 .and. i_des .le. des_expanded.n_des) then
	  call dix_des_set_des_1(%val(des_expanded.des_adr),i_des,des_rec)
	end if
	return
	end

	subroutine dix_des_set_des_1(des_recs,i_des,des_rec)
	include 'dix_def.inc'
c
c Overwrite a specific (expanded) des_rec
c
	record /des_rec/ des_recs(*)	!:io: list of des_recs
	integer*4 i_des			!:i: the des_rec to be overwritten
	record /des_rec/ des_rec	!i: the new value
c#
	des_recs(i_des) = des_rec
	return
	end
	function dix_des_get_range(control,range,min_val,max_val,nb)
	implicit none
c
c Get range values
c
	integer*4 control
	character*(*) range	!:i: the text
	integer*4 min_val	!:o: min value
	integer*4 max_val       !:o: max value
	integer*4 nb            !:i: size of data (in bits)
	logical*4 dix_des_get_range	!:f: result
c#
	integer*4 ipos
	integer dix_con_int_ascint
c
	dix_des_get_range = .false.
c
	ipos = index(range,':')
	if(ipos .eq. 0) goto 90
c
	if(.not.dix_con_int_ascint(range(1:ipos-1),min_val,nb,' ',
     1           0,0,control))goto 90
	if(.not.dix_con_int_ascint(range(ipos+1: ),max_val,nb,' ',
     1           0,0,control))goto 90
	if(min_val .ge. max_val) goto 90
	dix_des_get_range = .true.
90	return
	end
	function dix_des_match_qual(typ,match_str,endpos,min_len)
	implicit none
c
	character*(*) typ		!:i: the text to be matched
	character*(*) match_str		!:i: the text to match against
	integer*4 endpos		!:o: max length
	integer*4 min_len		!:i: min length needed to match
	logical dix_des_match_qual	!:f: function result
c#
	integer str$find_first_in_set
c
	endpos = str$find_first_in_set(typ,'/= ')
c
	dix_des_match_qual = endpos-1 .ge. min_len .and.
     1      typ(1:endpos-1) .eq. match_str(1:endpos-1)
	return
	end	
	subroutine dix_des_display(control,des,fnam,nk,short)
	implicit none
c
c make a display for the desciptor name
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /des_info/ des		!:i: des file structure
	character*(*) fnam		!:o: name
	logical short			!:i: short format?
	integer*4 nk			!:o: length of fnam
c#
        if(des.in_library .eq. des_in_userlib) then
	  if(short) then
            fnam = 'USERLIB('//des.fnam(1:des.nk_fnam)//')'
            nk   = 8 + des.nk_fnam + 1
	  else
            fnam = control.userlib_name(1:control.nk_userlib)//
     1            '('//des.fnam(1:des.nk_fnam)//')'
            nk = control.nk_userlib + 1 + des.nk_fnam + 1
	  endif
        elseif(des.in_library .eq. des_in_syslib) then
	  if(short) then
            fnam = 'SYSLIB('//des.fnam(1:des.nk_fnam)//')'
            nk   = 7 + des.nk_fnam + 1
	  else
            fnam = control.syslib_name(1:control.nk_syslib)//
     1            '('//des.fnam(1:des.nk_fnam)//')'
            nk = control.nk_syslib + 1 + des.nk_fnam + 1
	  endif
        else
          fnam = des.fnam
          nk = des.nk_fnam
        endif
	return
	end
	function dix_des_find_des(control,name,in_library,ptr)
	implicit none
c
c Find a descriptor  from the list of loaded descriptors
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) name		!:i: name to find
	logical in_library		!:o: in sys/user-library/file
	integer*4 ptr			!:o: the memtab lun
	logical dix_des_find_des	!:f: function result
c#
	integer*4 istat
	logical dix_des_find_mod_glo
c
	external dix_msg_debug
c
	istat = dix_des_find_mod_glo(control.top_descr,
     1             name,in_library,ptr)
	if(istat) then
	  if(control.debug) call dix_message(control,dix_msg_debug,
     1          'Descr found for '//name)
	endif
	dix_des_find_des = istat
	return
	end
	function dix_des_find_des_file(file,name,in_library)
	implicit none
	include 'dix_def.inc'
c
c Find the description from the des's linked to a file
c
	record /file_info/ file		!:i: the file structure
	character*(*) name		!:i: the name to find
	logical in_library		!:o: where found
	integer*4 ptr			!:o: memtab lun
	logical dix_des_find_des_file	!:f: function result
c#
	logical dix_des_find_mod
c
	dix_des_find_des_file = dix_des_find_mod(file.top_des,
     1                name,in_library,ptr)
c
	return
	end
	function dix_des_find_mod_glo(top,name,in_library,ptr)
	implicit none
	include 'dix_def.inc'
c
c Find module in global chained list
c
	integer*4 top		!:i: top link
	character*(*) name	!:i: name
	logical in_library	!:o: where found
	integer*4 ptr		!:o: memtab_lun
	logical dix_des_find_mod_glo!:f: function result
c#
c
	record /des_info/ des_info
	pointer (p_des_info, des_info)
c
	dix_des_find_mod_glo = .false.
	p_des_info = top
	do while(p_des_info .ne. 0)
	  if(des_info.in_library .eq. in_library) then
	    if(name .eq. des_info.fnam) then
	      ptr = p_des_info
	      dix_des_find_mod_glo = .true.
	      goto 90
	    endif
	  endif
	  p_des_info = des_info.link.forw
	end do
90	return
	end
	function dix_des_find_mod(top,name,in_library,ptr)
	implicit none
	include 'dix_def.inc'
c
c Find module in file chained list
c
	integer*4 top		!:i: top link
	character*(*) name	!:i: name
	logical in_library	!:o: where found
	integer*4 ptr		!:o: memtab_lun
	logical dix_des_find_mod!:f: function result
c#
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_info/ des_info
	pointer (p_des_info,des_info)
c
	dix_des_find_mod = .false.
	p_des_expanded = top
	do while(p_des_expanded .ne. 0)
	  p_des_info = des_expanded.p_des_info
	  if(des_info.in_library .eq. in_library) then
	    if(name .eq. des_info.fnam) then
	      ptr = p_des_info
	      dix_des_find_mod = .true.
	      goto 90
	    endif
	  endif
	  p_des_Expanded = des_Expanded.link.forw
	end do
90	return
	end
	function dix_des_get_qualifier(control,line,nkar,ipos,
     1             p_link,zone_id,
     1             trans_override,no_display,range_data,user,case)
	implicit none
c
c Parse the file[/key=number]/[compute=string] part
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line              !:io: the line
	integer*4 nkar                  !:IO: length of the line
	integer*4 ipos			!the / pos
	integer*4 p_link		!:io: the pointer to the link record
	record /vm_zone/ zone_id	!:i: the zone if to get the data from	
	logical*1 trans_override	!:io: override radix
	logical*1 no_display		!:io: the nodisplay flag 
	character*(*) range_data	!:o: range data
	logical*1 user			!:o: user defined?
	byte case			!:o: upper/lower case found
c#
	logical dix_des_get_qualifier
c
	record /link_rec/ link_rec
	pointer (p_link_rec,link_rec)
c
	integer*4 istat,k,endpos,keynr,nk_res,l   !,bpos,epos,nk_d
	character*(max_line_length) res_line      !,thisdir
c
	integer str$find_first_in_set
	external dix_msg_synterr
	external dix_msg_invqual
	external dix_msg_openquote
	logical dix_des_match_qual
	integer*4 dix_des_get_p_link
c
	res_line   = line(ipos+1:nkar)
	nk_res     = nkar - ipos
	p_link_rec = p_link
	istat = 1
	if(    dix_des_match_qual(res_line,'HEXADECIMAL',endpos,1)) then
	  trans_override = translate_hex
	elseif(dix_des_match_qual(res_line,'OCTAL',endpos,1)) then
	  trans_override = translate_oct
	elseif(dix_des_match_qual(res_line,'BINARY',endpos,1)) then
	  trans_override = translate_bin
	elseif(dix_des_match_qual(res_line,'NODISPLAY',endpos,1)) then
	  no_display = .true.
	elseif(dix_des_match_qual(res_line,'USER',endpos,2)) then
	  user = .true.
	elseif(dix_des_match_qual(res_line,'UPPERCASE',endpos,2)) then
	  case = case_upper
	elseif(dix_des_match_qual(res_line,'LOWERCASE',endpos,1)) then
	  case = case_lower
	elseif(dix_des_match_qual(res_line,'RANGE',endpos,2)) then
	  k = endpos+1
	  endpos = str$find_first_in_set(res_line,'/ ')
	  range_data = res_line(k:endpos-1)
	elseif(dix_des_match_qual(res_line,'MATCH',endpos,1)) then
	  if(res_line(endpos:endpos) .ne. '=') goto 80
	  k = str$find_first_in_set(res_line(endpos+1:),'/ ')
	  l = -5
	  if(res_line(endpos+1:endpos+2) .eq. 'EQ') l = 0
	  if(res_line(endpos+1:endpos+2) .eq. 'GE') l = 1
	  if(res_line(endpos+1:endpos+2) .eq. 'GT') l = 2
	  if(res_line(endpos+1:endpos+2) .eq. 'LE') l = -1
	  if(res_line(endpos+1:endpos+2) .eq. 'LT') l = -2
	  if(l .eq. -5) goto 80
	  istat = dix_des_get_p_link(p_link_rec,zone_id)
	  if(.not. istat) goto 90
	  link_rec.match      = l
	  endpos = endpos + k
	elseif(dix_des_match_qual(res_line,'FILE',endpos,1)) then
c
c The /FILE= has two syntaxes
c   a. /file=filename      result will be quoted name
c   b. /file="expression"  Result will be string as entered
c 
	  if(res_line(endpos:endpos) .ne. '=') goto 80
	  if(res_line(endpos+1:endpos+1) .ne. '"') then
c
c Format 1.
c
	    k = str$find_first_in_set(res_line(endpos+1:),'/ ')
	    k = endpos + k
	    istat = dix_des_get_p_link(p_link_rec,zone_id)
	    if(.not. istat) goto 90
	    link_rec.link_file = '"'//res_line(endpos+1:k-1)//'"'
	    link_rec.nk_link_file = k-1 - endpos + 2
	    endpos = k
	  else
c
c Format 2. Now copy all until closing quote
c
	    istat = dix_des_get_p_link(p_link_rec,zone_id)
	    if(.not. istat) goto 90
	    endpos = endpos+2
	    do while (endpos .le. nk_res)
	      if(res_line(endpos:endpos) .eq. '"') then
	        endpos = endpos + 1
	        if(endpos .ge. nk_res) goto 8
	        if(res_line(endpos:endpos) .ne. '"') goto 8
	      endif
	      link_rec.nk_link_file = link_rec.nk_link_file + 1
	      l = link_rec.nk_link_file
	      link_rec.link_file(l:l) = res_line(endpos:endpos)
	      endpos =  endpos + 1
	    end do
	    istat = %loc(dix_msg_openquote)
	    goto 81		!no trailing "
8	    endpos = endpos
	  endif
c
c Now check for relative file spec
c
c	  call dix_util_file_parse(link_rec.link_file,'D',bpos,epos)
c	  if(bpos .ne. 0) then
c	    k = index(link_rec.link_file(bpos:epos),'][')
c	    if(k .ne. 0) then
c	      k = k + bpos - 1
c	      link_rec.link_file = link_rec.link_file(1:k-1)//
c     1                             link_rec.link_file(k+2:)
c	      link_rec.nk_link_file = link_rec.nk_link_file - 2
c	      epos = epos - 2
c	    endif
c	    k = index(link_rec.link_file(bpos:epos),'[.')
c	    if(k .eq. 1) then
c
c Relative file spec, now add default directory
c
c	      call sys$setddir(,nk_d,thisdir)
c	      link_rec.link_file = 
c     1           link_rec.link_file(1:bpos-1)//
c     1             thisdir(1:nk_d-1)//
c     1             link_rec.link_file(bpos+1:)
c	      link_rec.nk_link_file = link_rec.nk_link_file + nk_d - 2
c	    endif
c	  endif
	elseif(dix_des_match_qual(res_line,'KEY',endpos,1)) then
	  keynr = 0
	  if(res_line(endpos:endpos) .eq. '=') then
	    k = str$find_first_in_set(res_line(endpos+1:),'/= ')
	    k = k + endpos
	    read(res_line(endpos+1:k-1),2000,err=80) keynr
2000	    format(bn,i10)
	    if(keynr .lt. 0 .or. keynr .gt. 255) goto 80
	    endpos = k
	  endif
	  istat = dix_des_get_p_link(p_link_rec,zone_id)
	  if(.not. istat) goto 90
	  link_rec.key_nr = keynr
	elseif(dix_des_match_qual(res_line,'RECORD',endpos,2)) then
	  istat = dix_des_get_p_link(p_link_rec,zone_id)
	  if(.not. istat) goto 90
	  link_rec.key_nr = -1
	elseif(dix_des_match_qual(res_line,'IF',endpos,1)) then
c
c conditional if
c
	  if(res_line(endpos:endpos) .ne. '=') goto 80
	  endpos = endpos + 1
	  if(res_line(endpos:endpos) .ne. '"') goto 80
c        
c Find closing ", but skip  ""
c
	  istat = dix_des_get_p_link(p_link_rec,zone_id)
	  if(.not. istat) goto 90
	  endpos = endpos+1
	  do while (endpos .le. nk_res)
	    if(res_line(endpos:endpos) .eq. '"') then
	      endpos = endpos + 1
	      if(endpos .ge. nk_res) goto 12
	      if(res_line(endpos:endpos) .ne. '"') goto 12
	    endif
	    link_rec.nk_if = link_rec.nk_if + 1
	    l = link_rec.nk_if
	    link_rec.if_line(l:l) = res_line(endpos:endpos)
	    endpos =  endpos + 1
	  end do
	  istat = %loc(dix_msg_openquote)
	  goto 81		!no trailing "
12	  endpos = endpos
	elseif(dix_des_match_qual(res_line,'COMPUTE',endpos,1)) then
	  if(res_line(endpos:endpos) .ne. '=') goto 80
	  endpos = endpos + 1
	  if(res_line(endpos:endpos) .ne. '"') goto 80
c        
c Find closing ", but skip  ""
c
	  istat = dix_des_get_p_link(p_link_rec,zone_id)
	  if(.not. istat) goto 90
	  endpos = endpos+1
	  do while (endpos .le. nk_res)
	    if(res_line(endpos:endpos) .eq. '"') then
	      endpos = endpos + 1
	      if(endpos .ge. nk_res) goto 14
	      if(res_line(endpos:endpos) .ne. '"') goto 14
	    endif
	    link_rec.nk_compute = link_rec.nk_compute + 1
	    l = link_rec.nk_compute
	    link_rec.comp_line(l:l) = res_line(endpos:endpos)
	    endpos =  endpos + 1
	  end do
	  istat = %loc(dix_msg_openquote)
	  goto 81		!no trailing "
14	  endpos = endpos
	else
	  endpos = str$find_first_in_set(res_line,'/ ')
	  call dix_message(control,dix_msg_invqual,res_line(1:endpos-1))
	  goto 80
	endif
c
c BLank out the string processed
c
	line(ipos:ipos+endpos-1) = ' '
	istat = 1
	goto 90
c
80	istat = %loc(dix_msg_synterr)
81	if(p_link_rec .ne. 0) then
	  call free_vm(sizeof(link_rec),p_link_rec,zone_id)
	  p_link_rec = 0
	endif
90	p_link = p_link_rec
	dix_des_get_qualifier = istat
	return
	end
	subroutine dix_des_check_des(control)
	implicit none
c
c Remove descriptions no longer linked to any file
c
	include 'dix_def.inc'
	record /control/ control		!:io: control structrue
c#
	integer*4 next_pointer,istat,err_row,old_cur_file
	integer*4 dix_des_read_it
c
	record /file_info/ file
	pointer (p_file,file)
c
	record /des_info/ des
	pointer (p_des,des)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	old_cur_file = control.cur_file
	p_file = control.top_file
        do while(p_file .ne. 0) 
	  control.cur_file = p_file
	  p_des_Expanded = file.top_des
	  do while(p_des_expanded .ne. 0) 
	    p_des = des_expanded.p_des_info
	    next_pointer  = des_expanded.link.forw
	    if(des.lun_memtab .ne. 0) then
	      istat = dix_des_read_it(control,des.lun_memtab,des,err_row)
	      call memtab_close(des.lun_memtab)
	      if(.not. istat) then
	        call dix_des_remove(control,des)	!kill data
	        call dix_des_link_out(control,file,des_expanded)
c
c Link out this pointer
c
	      endif 
	    endif
	    p_des_expanded = next_pointer
	  end do
	  p_file = file.link.forw
	end do
	control.cur_file = old_cur_file 
	return
	end
	function dix_des_get_p_link(p_link_rec,zone_id)
	implicit none
c
c Create new link_rec, but only if needed
c
	include 'dix_def.inc'
	record /link_rec/ link_rec		!:i: line_rec pointer
	pointer (p_link_rec,link_rec)		
	record /vm_zone/ zone_id                !:o: zone_id
c#
	integer*4 istat
	logical dix_des_get_p_link
c
       	if(p_link_rec .eq. 0) then
	  call get_vm(sizeof(link_rec),p_link_rec,zone_id)
	  link_rec.nk_link_file = 0
	  link_rec.key_nr       = 0
	  link_rec.nk_compute   = 0
	  link_rec.match        = 0
	  link_rec.nk_if        = 0
	endif
	istat = 1
	dix_des_get_p_link =istat
	return
	end
	subroutine dix_des_make_handle(des_info,top_des,des_expanded)
	implicit none
c
	include 'dix_def.inc'
c
	record /des_info/ des_info
	integer*4 top_des
	record /des_Expanded/ des_expanded
c
	record /des_expanded/ des_exp
	pointer (p_des_exp,des_exp)
c
	integer*4 icnt,nk,k,bpos,epos,nk_exp
	character*(max_short_line_length) temp
c
	integer*4 dix_util_get_len
	logical dix_util_legal_char
c
c
	nk = 0
	if(des_info.in_library .eq. des_in_file) then
c
c From file, take filename part of the description file
c
	  call dix_util_file_parse(des_info.fnam,'N',bpos,epos)
	  do k=bpos,epos
	    if(dix_util_legal_char(des_info.fnam(k:k),k-bpos+1)) then
	      if(nk .eq. len(des_expanded.handle)) goto 5
	      nk = nk + 1
	      des_expanded.handle(nk:nk) = des_info.fnam(k:k)
	    endif
	  end do
	else
c
c From library : take the desciption name and remove all non valid chars
c
	  do k=1,des_info.nk_fnam
	    if(dix_util_legal_char(des_info.fnam(k:k),k)) then
	      if(nk .eq. len(des_expanded.handle)) goto 5
	      nk = nk + 1
	      des_expanded.handle(nk:nk) = des_info.fnam(k:k)
	    endif
	  end do
	endif
5	des_expanded.nk_handle = nk
c
c Now make sure its unique
c
	icnt = 0
	nk_exp = nk
10	p_des_exp = top_des
	do while(p_des_exp .ne. 0)
	  if(des_expanded.handle .eq. des_exp.handle) then
	    icnt = icnt + 1
	    call sys$fao('_!UL',nk,temp,%val(icnt))
	    if(nk_exp+nk .gt. len(des_expanded.handle)) then
	      nk_exp = len(des_expanded.handle) - nk
	    endif
	    des_expanded.handle(nk_exp+1:) = temp(1:nk)
	    des_expanded.nk_handle = nk_exp + nk
	    goto 10
	  endif
	  p_des_exp = des_exp.link.forw
	end do
	des_expanded.handle(des_expanded.nk_handle+1:) = ' '
	des_expanded.nk_handle = dix_util_get_len(des_expanded.handle)
	return
	end
	subroutine dix_des_compress(des_expanded)
	implicit none
c
c Delete all compressed lines from the list of des_recs
c
	include 'dix_def.inc'
	record /des_expanded/ des_expanded
c
	call dix_des_comprs_1(des_expanded.n_des,%val(des_expanded.des_adr))
	return
	end
	subroutine dix_des_comprs_1(n_des,des_recs)
	implicit none
c
c Delete all not compressed data
c
	include 'dix_def.inc'
	integer*4 n_des
	record /des_rec/ des_recs(*)
c
	integer*4 k,n
c
	n = 0
	do k=1,n_des
	  if(.not. des_recs(k).compressed) then
	    n= n + 1
	    des_recs(n) = des_recs(k)
	  end if
	end do
	n_des = n
	return
	end
	subroutine dix_des_expand_all(control,file)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	p_des_expanded = file.top_des
	do while(p_des_expanded .ne. 0) 
	  call dix_des_expand(control,des_expanded,file,.true.)
	  p_des_expanded = des_expanded.link.forw
	end do
	return
	end
	subroutine dix_des_check_expand_all(control,file)
	implicit none
c
c Check if all descriptions are expanded, and if not expand it
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	p_des_expanded = file.top_des
	do while(p_des_expanded .ne. 0) 
	  if(des_expanded.zone_rec.zone .eq. 0) then
	    call dix_des_expand(control,des_expanded,file,.true.)
	  endif
	  p_des_expanded = des_expanded.link.forw
	end do
	return
	end
	subroutine dix_des_clean_expanded(des_expanded)
	implicit none
c
c  Delete all data from des_expanded
c 
	include 'dix_def.inc'
	record /des_expanded/ des_expanded
c
	if(des_expanded.des_adr .ne. 0) then
	  call free_vm(des_expanded.nb_des,des_expanded.des_adr,
     1                 des_expanded.zone_rec)
	end if
	if(des_expanded.zone_rec.zone .ne. 0) then
	  call delete_vm(des_expanded.zone_rec)
	end if
c
	des_expanded.nb_des  = 0
	des_expanded.des_adr = 0
c
	return
	end
