	function dix_dump_file(control,file,iterm,dis)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control	!:io: the control area
	record /file_info/ file		!:io: the file info
c	record /data_info/ data		!:i: the data
	integer*4 iterm			!:o: the terminator (action wanted)
	record /dis_pars/  dis          !:i: the display parameters
	integer*4 dix_dump_file		!:f: function result
c
	character*(max_line_length) line,sstring
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_Expanded)
c
	record /des_info/ des
	pointer(p_des,des)
c
	integer*4 nkar,i_count,istat,k
	logical*4 multi
c
	integer*4 dix_rms_get
	logical dix_main_string_found
	external dix_msg_seanotf
	external rms$_eof
	integer*4 memtab_read
c
	i_count = 0		!!no records yet
	istat = 1
c
c For sequential files, display the recordnumber
c
10	if(control.lun_search .ne. 0) then
	  call memtab_rewind(control.lun_search)
	  do while(memtab_read(control.lun_search,nkar,sstring))
	    if(dix_main_string_found(file.data,sstring(1:nkar),
     1             control.seapos,control.seasiz)) goto 11
	    k = k + 1
	  end do
	  if(control.one_rec) goto 90	!we wanted one rec only
	  goto 80			!try next record
	endif
c
11	if(.not. (file.relative .or. file.indexed)) then
	  if(control.display_recnr) then
	    nkar = 0
	    call dix_util_con_nr(file.rec_nr*8,.false.,line,nkar,
     1                  dis.number_hex)
	    if(dis.number_hex) then
	      line = '%X'//line(1:nkar)
	      nkar = nkar + 2
	    endif
	    call dix_dump_file_write_out(control,
     1             control.symbol(1:control.nk_symb),
     1             'Recordnumber',
     1             '%Recordnumber = ',line(1:nkar))
	  endif
	endif
c
c For all files, display the record size
c
	if(control.display_recsiz) then
	  nkar = 0
	  call dix_util_con_nr(file.data.nb_data*8,.false.,line,nkar,
     1                  dis.number_hex)
	  if(dis.number_hex) then
	    line = '%X'//line(1:nkar)
	    nkar = nkar + 2
	  endif
	  call dix_dump_file_write_out(control,
     1             control.symbol(1:control.nk_symb),
     1             'Recordsize',
     1             '%Recordsize = ',line(1:nkar))
	endif
c
c Check if we have a description
c
	if(control.display_vfc) then
	  if(file.data.nb_vfc .eq. 0 .or. file.data.nb_vfc .eq. 2) then
	    if(file.data.nb_vfc .eq. 0) then
	      nkar = 0
	      call sys$fao('No VFC data present',nkar,line)
	      control.display_vfc = .false. !display message only once
	    else
	      call dix_con_vfc(file.data.vfc_data(1),line,nkar)
	    endif	    
	    call dix_dump_file_write_out(control,
     1             control.symbol(1:control.nk_symb),
     1             'VFC_DATA',
     1             '%VFC_DATA = ',line(1:nkar))
	  else
	    if(control.display_data) 
     1           call dix_dump_print_line(control,0,'%VFC_data')
	    call dix_dump_file_raw(control,file,file.data.nb_vfc,
     1             file.data.vfc_data,dis,
     1             control.symbol(1:control.nk_symb)//'VFC',0)
	  endif
	endif
	if(control.display_data) then
	  if(control.display_vfc) 
     1           call dix_dump_print_line(control,0,'%Record_data')
	  if(file.raw .or. file.top_des .eq. 0) then
c
c No des, so dump raw
c
	    call dix_dump_file_raw(control,file,file.data.nb_data,
     1             file.data.data_rec,dis,
     1             control.symbol(1:control.nk_symb),0)
	  else
c
c Yes, a description, use them all
c
	    p_des_expanded = file.top_des
	    multi = des_expanded.link.forw .ne. 0
	    do while(p_des_expanded .ne. 0)
	      p_des = des_Expanded.p_des_info
c
c Dump with this description,
c
	      call dix_dump_file_des(control,file,dis,des,des_Expanded,multi,
     1           control.symbol(1:control.nk_symb))
c
c And set the pointer to the next
c
	      p_des_expanded = des_expanded.link.forw
	    end do
	  endif
	end if
c
c And return next_rec
c
	i_count = i_count + 1
80	if(control.count .eq. 0 .or. i_count .lt. control.count) then
	  istat = dix_rms_get(control,file)
	  if(istat) goto 10
	  if(control.count .eq. 0 .and. istat .eq. %loc(rms$_eof)) istat = 1
	endif
90	if(i_count .eq. 0 .and. control.lun_search .ne. 0) then
	  istat = %loc(dix_msg_seanotf)
	endif
	iterm = key_exit
	if(.not. istat) call dix_message(control,%val(istat))
	dix_dump_file = istat
	return
	end

	subroutine dix_dump_file_raw(control,file,nb_data,data_rec,
     1              dis,symbname,lun)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
	integer*4 nb_data
	byte data_rec(*)
c	record /data_info/ data
	record /dis_pars/ dis
	character*(*) symbname
	integer lun
c
c Raw dump (DUMP mode)
c
c local vars
c
	integer*4 linenr,kpl,fldsiz,posasc,nlines,nkar,nk_symbasc,lun_save
	character*(max_line_length) line,symbasc
c
	include '($smgdef)'
c
	integer*4 n_bol
	integer*4 begpos_bol(10),endpos_bol(10)
c
c start, compute # values on 1 line
c
	call dix_dump_vars(control,dis,kpl,fldsiz,posasc)
c
	lun_save = control.lun_out
	if(lun .ne. 0) control.lun_out = lun
c
	nlines = (nb_data+kpl-1)/kpl
	do linenr=1,nlines

	  call dix_dump_raw_line(control,(linenr-1)*kpl,kpl,nb_data,
     1             data_rec,dis,posasc,
     1             begpos_bol,endpos_bol,n_bol,line,
     1             nkar,fldsiz,file)

	  call sys$fao('!UL',nk_symbasc,symbasc,%val(linenr))
	  call dix_dump_file_write_out(control,symbname,symbasc(1:nk_symbasc),
     1              ' ',line(1:nkar))
	end do
	control.lun_out = lun_save
	return
	end

	subroutine dix_dump_file_des(control,file,dis,des,des_Expanded,
     1                               multi,symbname)
	implicit none
c
c Dump to file/term with no screen
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
c
	
	record /des_info/ des
	record /des_expanded/ des_expanded
	record /dis_pars/ dis
	logical*4 multi
	character*(*) symbname
c
	character*(max_command_length) regel
	integer*4 nk_nroff,iel,nk_fieldname
	logical*4 match
	integer*4 nkar,nk_rem,k,nk_min,offs,nk_disp,ibpos,iepos,max_len,nkar1
	character*(max_line_length) line,pattern,fieldname
	record /des_rec/ des_rec
c
	integer*4 memtab_read
	logical*4 dix_des_expand
	logical*4 dix_util_get_len
	logical*4 dix_util_match_string_wild
c
	character*(max_nr_asc_length) nroff
c
	if(.not. dix_des_expand(control,des_expanded,file)) then
	  goto 90
	end if
	nk_min = des_expanded.max_name_size
c
c Compute size for number
c
	nk_nroff = 0
	nk_disp = nk_min
	if(dis.number) then
	  call dix_util_con_nr(file.data.nb_data*8,des.has_fields,
     1          nroff,nk_nroff,dis.number_hex)
	  nk_disp = nk_disp + nk_nroff + 1	!one for the |
	end if
c
	if(multi) then
	  call dix_des_display(control,des,regel,nkar,.false.)
	  call dix_dump_file_write_out(control,symbname,
     1             'Description_file',
     1             'Description file:',regel(:nkar))
	end if
c
c
	do k=1,des_expanded.n_des
	 call dix_des_get_des(des_expanded,k,des_rec,line)
	 if(.not. dis.compres .or. .not. des_rec.compressed) then
	  fieldname = line
	  nk_fieldname = dix_util_get_len(line)
	  if(control.lun_select .ne. 0) then
	    call memtab_rewind(control.lun_select)
	    nkar = nk_fieldname
	    iel = 0
	    match = .false.
	    do while(.not. match .and. 
     1          memtab_read(control.lun_select,nkar1,pattern))
	      match = dix_util_match_string_wild(line(1:nkar),
     1                   pattern(1:nkar1),.false.,.false.)
	      iel = iel + 1
	    end do
	  else
	    match = .true.
	  end if
	  offs = des_rec.bit_offset/8
	  if(match .and. (offs .lt. file.data.nb_data)) then
	    call dix_con_intasc(file.data.nb_data-offs,des_rec,
     1           file.data.data_rec,regel,nkar,dis.hex,
     1           max_len,.false.,control)
	    if(dis.number) then
	      call dix_util_con_nr(des_rec.bit_offset,des.has_fields,
     1                 nroff,nk_nroff,dis.number_hex)
	      line = nroff(1:nk_nroff)//'|'//line
	    end if
	    line(nk_disp+1:nk_disp+1) = '|'
	    nk_rem = control.ncols - nk_disp-1-1
	    if(multi) nk_rem = nk_rem - 1
c
c Map, in multiple lines
c
	    ibpos = 1
	    if(nkar .eq. 0) nkar = 1	!make sure to print at least one line
	    do while(ibpos .le. nkar)
	      iepos = min(nkar,ibpos+nk_rem-1)
	      if(multi) then
	        call dix_dump_file_write_out(control,symbname,
     1          fieldname(1:nk_fieldname),
     1	        ' '//line(1:nk_disp+1),regel(ibpos:iepos))
	      else
	        call dix_dump_file_write_out(control,symbname,
     1              fieldname(1:nk_fieldname),
     1	            line(1:nk_disp+1),regel(ibpos:iepos))
	      end if
	      ibpos = iepos + 1
	      line(1:nk_disp) = ' '	!leave | present
	    end do
	  end if
	 endif
60	end do
c
90	return
	end
	subroutine dix_dump_file_write_out(control,symbname,symbfield,
     1            header,data)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) symbname
	character*(*) symbfield
	character*(*) header
	character*(*) data
c
	call dix_dump_print_line(control,0,header//data)
	if(symbname .ne. ' ') call lib$set_symbol(symbname//symbfield,data)
	return
	end
