	options /recursi
	function dix_dump_interactive(control,iterm,dis,from_usertype)
	implicit none
c
c Display/modify data interactively
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: the control structure
	integer*4 iterm			!:o: the teminator (action wanted)
	record /dis_pars/  dis		!:i: the display parameters
	logical from_usertype 		!:i: from usertype?
	integer*4 dix_dump_interactive	!f: function result
c
c Common for control_c
c
        logical seen_signal
        common /ignore_message_common/ seen_signal
c
c Include files
c
	include '($dcdef)'
	include '($stsdef)'
	include '($smgdef)'
c
c Records
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
	record /des_info/ des
	pointer(p_des,des)
	record /struct_level/ struct_level
	pointer (p_struct_level,struct_level)
	record /des_rec/ des_rec
	record /struct_pointers/ ptrs
	record /value/ val,val1
	record /dis_pars/ dis_work
	record /file_level/ save_level
	record /file_info/ file         
	pointer (p_file,file)
	record /file_info/ temp_file    
	pointer (p_temp_file,temp_file)
	record /link_rec/ link_rec	
c
c Local Variables
c
	character*(max_line_length) field_name,fieldname,tline
	character*(max_symbol_name_length) if_state,set_state,context
	character*(max_str_len) ascdat,totline,arguments,ototline
	character*(max_symbol_name_length) symbol,symbol1
	character kar
	integer*4 nk_tot,begval,endval,incval,workval,nk_if,onk_tot
	integer*4 nk,k,ipos,offs,line_ptr,save_lun,nk_arg
	integer*4 istat,l,nl,line_level,nlevel,save_paged
	integer*4 nk_field,nk_t
	integer*4 where,symbtyp
	logical*4 skip,is_call,was_call,trans,do_descr !,changed,
	logical*4 on_command,all,full,is_symbol
	character*(max_verb_length) verb
	logical changed_des,changed_fil,changed_rec
c
	integer*4 gosub_ptrs(2)
	pointer (p_gosub_ptrs,gosub_ptrs)
c
	integer*4 nk_label
	character*(max_label_length) label
	character*(max_short_line_length) modflag,temp
	logical*4 then_mode,auto,do_close
	integer*4 nk_line,key,nk_symb,nk_symb1,descr(2),flag,start_level,lun1
	logical signal,logit,from_read
	character*(max_line_length) line
	character*(max_err_arg_length) err_arg
	character*(max_filename_length) link_fnam
	character*(max_str_len) eval_line
	integer*4 err_status
	logical do_sys,do_usr,do_fil,do_it
	logical jump_from_control
	logical jump_from_call,jump_from_at
	logical jump_from_end_statement
c
c Functions
c
	integer*4 dix_inter_open_level
	integer*4 dix_symbol_add_str
	integer*4 dix_symbol_add
	integer*4 dix_symbol_set_alias
	integer*4 dix_symbol_find
	integer*4 smg$delete_key_def
	integer*4 dix_inter_parse_for
	integer*4 dix_dump_inter_get_symbol
	integer*4 dix_main_follow
	integer*4 dix_main_follow_back
	integer*4 memtab_read
c
	external ignore_message
	external cli$_present,cli$_negated
	logical*4 dcl_parse
	external dix_int_cld
	logical*4 dix_con_i4
	logical*4 cli$present
	external lib$get_input
c
	integer*4 dix_dump_i_open_output
	logical*4 dix_eval_expression
	logical*4 dix_eval_expression1
	logical*4 cli$get_value
	logical dix_rms_check_rfa
	logical dix_des_get_all
	integer dix_rms_rewind
	integer dix_inter_read_line
	logical dix_symbol_delete
	integer*4 dix_rms_delete
	logical dix_dump_set_link
	integer*4 dix_dump_i_exam
	integer*4 dix_dump_i_depo
	integer*4 dix_inter_get_params
	integer*4 dix_inter_set_local
	integer*4 dix_dump_inter_sel_file
	integer*4 smg$define_key
	integer*4 dix_dump_inter_get_file
	integer*4 dix_main_get_rec_int
	integer*4 dix_main_rfa_restore
	integer*4 dix_dump_i_get_keys
	integer*4 dix_dump_i_dir_des
c
	integer*4 dix_des_expand
	logical*4 dix_symbol_check_name
	logical*4 str$match_wild
	integer*4 dix_util_find_char_bracket
	integer*4 dix_edit_des
	integer*4 dix_util_check_name
	integer*4 dix_dump_i_show_des
	integer*4 dix_dump_i_show_des_exp
	integer*4 dix_inter_find_label
	integer*4 dix_inter_create_new_level
	integer*4 dix_main_get_files
	integer*4 dix_rms_get
c
c Messages
c
	external dix_msg_ambig
	external dix_msg_cannotchg
	external dix_msg_chgdrecl
	external dix_msg_closbnotf
	external dix_msg_cmpasnum
	external dix_msg_datasav
	external dix_msg_datarest
	external dix_msg_desadd
	external dix_msg_desnotm
	external dix_msg_desrem
	external dix_msg_enotint
	external dix_msg_entryign
	external dix_msg_errgetl
	external dix_msg_fieldnotf
	external dix_msg_filnotop
	external dix_msg_general
	external dix_msg_ignoterm
	external dix_msg_illcomm
	external dix_msg_illcycle
	external dix_msg_illends
	external dix_msg_illends1
	external dix_msg_illret
	external dix_msg_illkey
	external dix_msg_illleave
	external dix_msg_illoffs
	external dix_msg_invlog
	external dix_msg_labnotf
	external dix_msg_mrknotmrk
	external dix_msg_nocall
	external dix_msg_nodescr
	external dix_msg_nofilopen	  
	external dix_msg_noupdate
	external dix_msg_nomordes
	external dix_msg_norest
	external dix_msg_noseastr
	external dix_msg_notaddes
	external dix_msg_notchar
	external dix_msg_notlog
	external dix_msg_notindex
	external dix_msg_notinmod
	external dix_msg_notonterm
	external dix_msg_opernotf
	external dix_msg_opernotall
	external dix_msg_openbnotf
	external dix_msg_pagemode
	external dix_msg_setedt
	external dix_msg_stricmode
	external dix_msg_symbform
	external dix_msg_usingfil
	external dix_msg_usingdes
	external dix_msg_unexpchar
	external dix_msg_wrargtyp
c
	external cli$_ivverb
	external cli$_parmdel
c
c
c There is a problem with dcl_parse
c if the first statement has a problem, the the get_value('$line') 
c ends in an access violation
c to prevent this we do a dcl_parse here
c
	start_level = control.depth
	call dcl_parse(control,'SHOW PAG',dix_int_cld)
c
c INit local vars, since they have variable string type
c
	call dix_eval_init_value(val)
	call dix_eval_init_value(val1)
	err_status = 1
c
c Now set the file pointer
c Reentry after current file changed
c
1	p_file = control.cur_file
c
c Set the control block for the current command level
c
	p_file_level   = control.cur_level		!point to the correct level
	p_struct_level = file_level.cur_struct		!can be 0
c
c Check for the current file
c
	if(from_usertype) goto 5
	if(%loc(file) .ne. 0) then
c
c We have a file current
c
	  if(file.modify) then
	    modflag = '/MOD'
	  else
	    modflag = '/NOMOD'
	  endif
c
	  nk   = file.nk_fnam
	  line = file.fnam(1:nk)
	  if(%loc(file) .ne. control.old_filep) then
	    call dix_message(control,dix_msg_usingfil,line(1:nk),modflag(1:6))
	    control.old_desp  = 0		!so this will be signalled too
	  end if
	  if(file.cur_des .eq. 0) file.cur_des = file.top_des
	else
c
c We have no file current
c
	  nk = 0
	  if(control.old_filep .ne. 0) then
	    call dix_message(control,dix_msg_nofilopen)
	  endif
	endif
c
	if(control.old_filep .ne. %loc(file)) then
	  call dix_symbol_add_str(control,'$FILE',line(1:nk),err_arg)
	  control.old_filep = %loc(file)
	endif
c
c CHeck for the current description record
c Reentry after descriptor changed
c
5	if(p_file .ne. 0) then
	  p_des_expanded = file.cur_des
	  if(p_des_expanded .eq. 0) p_des_expanded = file.top_des
	  if(p_des_expanded .ne. 0) then
	    p_des = des_expanded.p_des_info
	  else
	    p_des = 0
	  endif
	else
	  p_des_expanded = 0
	  p_des          = 0
	endif
c
	if(from_usertype) goto 9
	if(p_des .ne. 0) then
c
c We have a descriptor present, set the symbol
c
	  call dix_des_display(control,des,line,nk,.false.)
	  if(p_des .ne. control.old_desp) then
	    call dix_message(control,dix_msg_usingdes,line(1:nk))
	  end if
	else
	  nk = 0
	end if 
	if(p_des .ne. control.old_desp) then
	  call dix_symbol_add_str(control,'$DESCRIPTION',line(1:nk),err_arg)
	  control.old_desp = p_des
	endif
c
c Restart for new record, reexpand the description (if des present)
c
8	if(p_des .ne. 0) then
c
c Now we have description, try to expand it
c
	  if(.not. dix_des_expand(control,des_expanded,file)) then
c
c Expand failed, try to use another description
c
	    k = p_Des
	    p_des_expanded = file.top_des
	    do while(p_des_Expanded .ne. 0)
	      if(des_expanded.p_des_info .ne. k) then
c
c We have another (not the same), try to expand
c
	        p_des = des_expanded.p_des_info
	        if(dix_des_expand(control,des_expanded,file)) then
c
c Expand succeeded, tell ther user
c
	          call dix_des_display(control,des,line,nk,.false.)
	          call dix_message(control,dix_msg_usingdes,line(1:nk))
	          control.old_desp = p_des
	          file.cur_des = p_des_Expanded
	          goto 9
	        endif
	      endif
	      p_des_Expanded = des_expanded.link.forw
	    end do
c
c All descriptions failed, now tell the user wea are sorry, but no description
c
	    p_des = 0
	    call dix_message(control,dix_msg_nodescr)
	  end if
	end if
c
c All description things done
c Init some vars
c
9	on_command = .false.
	jump_from_end_statement = .false.
	jump_from_control  = .false.
	jump_from_call     = .false.
	jump_from_at       = .false.
	from_read          = .true.
c
c Main loop fo program
c  return here with err_status (and err_arg) set to 
c  values representing the status of the last command
c  dix_inter_signal will signal warning/error/fatal
c  and when the error level execeeds the current ON-setting
c  return with an exit
c
10	call dix_inter_signal(control,err_status,err_arg,
     1       totline,nk_tot,on_command,
     1       file_level,from_read)
	if(nk_tot .ne. 0) then
c
c err_status was a serious error (looking at the ON level)
c We have an error statement from the on xxxxx  commands
c close all command files until we have a terminal as input
c
	  from_read = .false.
	else
c
c Read next command line
c
	  from_read = .true.
	  err_status = dix_inter_read_line(control,totline,nk_tot,
     1                   ototline,onk_tot,
     1                   .false.,des,err_arg,ptrs,line_level)
	  if(.not. err_status) then
c
c Error during read, if in label search signal error
c else return exit
c
	    if(err_status .ne. 0) goto 10
c
c End of file, just exit
c
	    totline = 'EXIT'
	    nk_tot = 4
	  end if
	  err_status = 1
	  on_command = .false.
	endif
c
c
c Go parse the command line
c if a command does not parse oke
c  see if it is a symbol assignment : symb=expression command
c
c Do not let cli$dcl_parse signal errors, we handle them later
c so establish a return handler. The common seen_signal will
c  be set if this routine is entered
c
25	seen_signal = .false.
	call lib$establish(ignore_message)
	istat = dcl_parse(control,totline(1:nk_tot),dix_int_cld)
	call lib$revert
c
c Clear the /error and /end= label names 
c
	control.error_label = ' '
	control.eof_label   = ' '
c
	changed_des = .false.		!set flags for changes
	changed_fil = .false.
	changed_rec = .false.
c
	if(.not. istat) then
c
c parsing went wrong (error)
c Could be symbol assignment, if so we must have  an = sign, and all
c  chars before must make a valid symbol
c
	  call dix_util_decent_line(nk_tot,totline)
	  ipos = index(totline(1:nk_tot),'=')
	  if(ipos .ne. 0) then
c
c See if the part before the = is all legal chars
c
	    if(dix_symbol_check_name(totline(1:ipos-1),des_expanded,
     1                err_arg)) then
c
c Parse the rest of the line (after the = sign)
c
	      err_status = dix_eval_expression(control,
     1           totline(ipos+1:nk_tot),val,
     1           .false.,err_arg,.false.,is_symbol)
	      if(err_status) then
c
c Parsing of expression is ok
c now assign new symbol
c
	        err_status = dix_symbol_add(control,totline(1:ipos-1),
     1               val,err_arg)
	      endif     !valid expression
	      goto 10
	    endif	!has symbol a valid name
	  endif		!= sign found
c
c Otherwise error, let DCL signal the message  (no lib$establish)
c (at least if dcl_parse signals it)
c
	  if(seen_signal) then
c
c There was an error seen in the ignore_message handler
c dcl_parse will output the full message
c 
	    call dcl_parse(control,totline(1:nk_tot),dix_int_cld)
	  else
c
c Ohter error from dcl_parse, let us handle it
c
	    err_status = istat
	  endif
	  goto 10
	endif
c
c All dcl_parsing oke, now process the verb
c
	call cli$get_value('$VERB',verb)
c
	control.linenr = 0	!no output line(s) yet
	iterm = 0		!not yet return to main routine
c
c if we came from CALL, and verb <> SUBR, this is an invalid call
c
	if(jump_from_call .and. verb .ne. 'SUBR') then
	  err_status = %loc(dix_msg_nocall)
	  jump_from_call = .false.
	  goto 10
	endif
c
c Is the previous command is a AT (@), check if this (the first)
c  line is an ENTRY
c
	if(jump_from_at) then
	  jump_from_at = .false.
	  is_call = verb .eq. 'ENTR'
	  err_status = dix_inter_get_params(control,arguments(1:nk_arg),
     1             err_arg,is_call)
	  if(.not. err_status) goto 10
	  if(is_Call) goto 10
	endif
c
c Now start executing verbs
c
	if(verb .eq. 'AT') then
c
c @ command
c syntax @name/out=file param[,param...]
c
	  nk_tot = 0
	  call cli$get_value('p1',totline,nk_tot)	!name of the routine
	  nk_t   = 0
	  call cli$get_value('output',tline,nk_t)       !output file
	  nk_arg = 0
	  call cli$get_value('p2',arguments,nk_arg)            !parameters
c
c Check if arguments are valid
c
	  ascdat = arguments(1:nk_arg)
          nk = nk_arg
	  do while(nk .gt. 0)
	    err_status = dix_eval_expression1(control,ascdat(1:nk),val,
     1             .false.,err_arg,.false.,kar,ipos,is_symbol)
	    if(.not. err_status) then
	      nk = 0
	    else
	      nk = nk - ipos + 1	  	  
	      ascdat = ascdat(ipos:)
	    endif
	  enddo       
	  if(err_status) then
c
c Args are oke, now open the file
c
	    err_status = dix_inter_open_level(control,totline(1:nk_tot),
     1                     tline(1:nk_t))
	    if(.not. err_status) then
c
c Could not open level, so signal
c
	      err_arg = totline(1:nk_tot)
	    else
c
c Open level is ok, fill in the new file_level control block
c
	      p_file_level           = control.cur_level
	      p_struct_level         = file_level.cur_struct		!is 0
	      file_level.is_call     = .false.
	      file_level.return_line = 0
	      jump_from_at           = .true.	!remember we came from AT
	    endif
	  endif
c
	elseif(verb .eq. 'ENTR') then
c
c Entry command
c syntax
c  entry param[/qual]0,param[/qual]...]
c  is already handeled above
c
	  if(file_level.is_term) goto 73	!not on terminal
	  err_status = %loc(dix_msg_entryign)
c
	elseif(verb .eq. 'DEFI') then
c
c Define
c syntax:
c  define/key keyname string [/qualifiers]		for inter mode
c  define/key screenkey dix_function [/qualifiers]      for screen mode
c
	  if(cli$present('key')) then
	    err_status = smg$define_key(control.keytable_id,totline(1:nk_tot))
	  elseif(cli$present('skey')) then
            call cli$get_value('p1',line)
            call cli$get_value('set_state',set_state)
            call cli$get_value('context',context)
            if(set_state .eq. ' ') then
              call cli$get_value('p2',tline)
            else
              tline = ' '
            endif
            call cli$get_value('if_state',if_state)
            call keydefs_add_key(control,line,if_state,set_state,
     1                tline,control.debug,context)
	  else
	    goto 70
	  endif
c
	elseif(verb .eq. 'REAL' .or. 
     1         verb .eq. 'INTE' .or. 
     1         verb .eq. 'DATE' .or.
     1         verb .eq. 'LOGI' .or. 
     1         verb .eq. 'CHAR') then
c
c Declaration statements
c syntax
c  type : name[=value]
c
	  if(verb .eq. 'REAL') symbtyp = symb_typ_real
	  if(verb .eq. 'INTE') symbtyp = symb_typ_int
	  if(verb .eq. 'DATE') symbtyp = symb_typ_date
	  if(verb .eq. 'LOGI') symbtyp = symb_typ_log
	  if(verb .eq. 'CHAR') symbtyp = symb_typ_char
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  err_status = dix_inter_set_local(control,ascdat,nk,
     1             err_arg,symbtyp)
c
	elseif(verb .eq. 'ALIA') then
c
c Define an alias symbol (not normally used command)
c  syntax : alias=symbol
c
	  err_status = dix_dump_inter_get_symbol('p1',symbol,nk_symb,err_arg)	!alias name
	  if(err_status) then
	    err_status = dix_dump_inter_get_symbol('p2',symbol1,
     1                   nk_symb1,err_Arg) !alias name
	    if(err_status) then
	      err_status = dix_symbol_set_alias(control,symbol(1:nk_symb),
     1                symbol1(1:nk_symb1),err_arg)
	    endif
	  endif
c
	elseif(verb .eq. 'CYCL') then
c
c Cycle command, in a loop : goto the endloop, but stay in the loop
c
	  if(file_level.is_term) goto 73
	  if(file_level.struct_level .eq. 0) then
c
c Not is a loop
c
	    err_status = %loc(dix_msg_illcycle)
	  else
c
c In a loop ,goto the end_label
c
	    call memtab_set_line_ptr(file_level.lun,struct_level.ptrs.end_ptr)
	  endif
c
	elseif(verb .eq. 'LEAV') then
c
c Leave command, leave the current loop
c Syntax : LEAVE
c
	  if(file_level.is_term) goto 73
	  if(file_level.struct_level .eq. 0) then
	    err_status = %loc(dix_msg_illleave)
	  else
	    call memtab_set_line_ptr(file_level.lun,
     1               struct_level.ptrs.end_ptr)
	    jump_from_control = .true.
	  endif
c
	elseif(verb .eq. 'WAIT') then
c
c Wait
c Syntax : WAIT seconds
c Wait seconds (integer or real)
c
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  err_status= dix_eval_expression(control,ascdat(1:nk),val,
     1           .false.,err_arg,.false.,is_symbol)
	  if(err_status) then
	    if(val.type .eq. symb_typ_int) then
	      call lib$wait(1.0*val.ival)
	    elseif(val.type .eq. symb_typ_real) then
	      call lib$wait(1.0*val.rval)
	    else
	      err_status = %loc(dix_msg_wrargtyp)
	      err_arg = 'WAIT'
	    endif
	  endif
c
	elseif(verb .eq. 'SUBR') then
c
c Subroutine
c syntax : LABEL : SUBROUTINE [parameters]
c
	  if(file_level.is_term) goto 73
c
c If we did come from a call, get params and continue
c if not skip unitl the ends(ub)
c
	  if(jump_from_call) then
	    jump_from_call = .false.
	    err_status = dix_inter_get_params(control,arguments(1:nk_arg),
     1             err_arg,.true.)
	    if(.not. err_status) then
	      call dix_inter_close_level(control,.true.)
	      p_file_level = control.cur_level
	      p_struct_level = file_level.cur_struct
	    endif
	  else
c
c Goto the endsubroutine line 
c
	    jump_from_control = .true.
	    call memtab_set_line_ptr(file_level.lun,ptrs.end_ptr)
	  endif
c
	elseif(verb .eq. 'ENDS') then
c
c ENDSUBROUTINE
c syntax : ENDSUBROUTINE
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
	    jump_from_control = .false.
	  else
	    line_ptr = file_level.return_line
	    call dix_inter_close_level(control,.true.)
	    p_file_level = control.cur_level
	    p_struct_level = file_level.cur_struct
	    call memtab_set_line_ptr(file_level.lun,line_ptr)
	  endif
c
	elseif(verb .eq. 'CALL') then
c
c CALL
c Syntax : CALL LABEL
C Call of a subroutine 
c
	  if(file_level.is_term) goto 73
	  call memtab_get_line_ptr(file_level.lun,line_ptr)
	  nk_label = 0
	  call cli$get_value('p1',label,nk_label)
	  nk_arg = 0
	  call cli$get_value('p2',arguments,nk_arg)
c
c Check if the arguments are valid
c
	  ascdat = arguments(1:nk_arg)
          nk = nk_arg
	  do while(nk .gt. 0)
	    err_status = dix_eval_expression1(control,ascdat(1:nk),val,
     1             .false.,err_arg,.false.,kar,ipos,is_symbol)
	    if(.not. err_status) then
	      nk = 0
	    else
	      nk = nk - ipos + 1	  	  
	      ascdat = ascdat(ipos:)
	    endif
	  enddo
c
	  if(err_status) then
	    err_status = dix_inter_find_label(label,
     1                     line_level,err_arg,nlevel,file_level,
     1                     control.debug)
	  endif
	  if(err_status) then
	    err_status = dix_inter_create_new_level(control)
	    if(err_status) then
	      save_level = file_level
	      p_file_level = control.cur_level
	      p_struct_level = file_level.cur_struct
              file_level.verify   = save_level.verify	!set verify
              file_level.lun_out  = save_level.lun_out	!and lun_out
              call dix_inter_set_default_error(file_level)
	      file_level.nk_file       = save_level.nk_file
	      file_level.filename      = save_level.filename
	      file_level.lun           = save_level.lun
	      file_level.is_term       = save_level.is_term
	      file_level.output_opened = .false.  !so do not close
	      file_level.is_call       = .true.     !tis a call not a @
	      file_level.return_line   = line_ptr   !return address
	      jump_from_call = .true.
	    endif       !could not create new level
	  endif		!could not find label
c
	elseif(verb .eq. 'DECL') then
c
c DECLARE
c Syntax : DECLARE[/qualifier] symbol[/qualifier][,symbol[/qualifier...]]
c
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  symbtyp = symb_typ_none
c
c FIrst get global type
c
	  if(cli$present('REAL'     )) symbtyp = symb_typ_real
	  if(cli$present('INTEGER'  )) symbtyp = symb_typ_int
	  if(cli$present('DATE'     )) symbtyp = symb_typ_date
	  if(cli$present('LOGICAL'  )) symbtyp = symb_typ_log
	  if(cli$present('CHARACTER')) symbtyp = symb_typ_char
c
c Now parse each symbol (with its type)
c
	  err_status = dix_inter_set_local(control,ascdat,nk,
     1             err_arg,symbtyp)
c
	elseif(verb .eq. 'NOOP') then
c
c Noop
c syntax : NOOP
c Do nothing
c
	elseif(verb .eq. 'OPEN') then
	  call dix_dump_get_err_lab(control,file_level)
	  if(cli$present('p2')) then
	    temp = 'p2'
	    err_status=dix_dump_inter_get_symbol('p1',symbol,nk_symb,err_arg)
	  else
	    temp = 'p1'
	    err_status=dix_dump_inter_get_symbol('tag',symbol,nk_symb,err_arg)
	  endif
	  if(err_status) then
	    logit = cli$present('log')
	    err_status = dix_main_get_files(control,temp(1:2),
     1                      dis.raw,' ',symbol(1:nk_symb),logit)
c
c If all oke, and we had no file open, and we have files now
c jump to the first
c
	    if(err_status) then
	      if(%loc(file) .eq. 0) then
	        if(control.n_file .gt. 0) then
	          control.cur_file = control.top_file
	          changed_fil = .true.
	        endif
	      endif
	    endif
	  endif
	elseif(verb .eq. 'EXIT') then
c
c Exit 
c syntax : exit [status]
c
	  call util_cli_get_number('p1',1,err_status)
c
c CLose one level, if 
c
	  was_call = file_level.is_call
	  line_ptr = file_level.return_line
c
	  do_close = .true.
	  if(from_usertype) then
	    if(control.depth .eq. start_level) do_close = .false.
	  endif
	  if(do_close) then	    
	    call dix_inter_close_level(control,.true.)
	    p_file_level = control.cur_level
	    if(control.depth .lt. start_level) then
	      iterm = key_exit
	    else
	      p_struct_level = file_level.cur_struct
	      if(was_call) call memtab_set_line_ptr(file_level.lun,line_ptr)
	    endif
	  else
	    iterm = key_exit
	  endif
	elseif(verb .eq. 'WHIL') then
c
c While
c  Syntax : WHILE Log-Expression
c OPening statement of the WHILE/ENDWHILE construct
c
	  if(file_level.is_term) goto 73
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  err_status= dix_eval_expression(control,ascdat(1:nk),val,
     1         .false.,err_arg,.false.,is_symbol)
	  if(err_status) then
c
c expression valid, check for type
c
	    if(val.type .ne. symb_typ_log) err_status = %loc(dix_msg_invlog)
	  endif
	  if(.not. jump_from_end_statement) then
c
c We did not come here from the endwhile, so open new level
c even if the statement evaluates to false, so the endwhile will clean it
c
	    call dix_inter_open_struct(file_level,ptrs)
	    p_struct_level = file_level.cur_struct
	  endif
	  if((.not. val.lval) .or. (.not. err_status)) then
c                
c Now evaluates to false, or some other error : jump to endwhile
c
	    call memtab_set_line_ptr(file_level.lun,struct_level.ptrs.end_ptr)
	    jump_from_control = .true.
	  endif	        !evaluates to true
	  jump_from_end_statement = .false.
c
	elseif(verb .eq. 'ENDW') then
c
c Endwhile
c syntax : ENDWHILE
c Closing statement of the WHILE/ENDWHILE construct
c
c if we came here from the while, close struct and continue
c  else jump bck to while
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
c
c We can from the while (expression not true) or the  LEAVE command
c
	    call dix_inter_close_struct(control,file_level)
	    p_struct_level = file_level.cur_struct
	    jump_from_control = .false.
	  else
c
c We just ran into this one, so jump to the while
c
	    if(file_level.struct_level .eq. 0) goto 76
	    if(struct_level.ptrs.begin_verb .ne. 'WHIL') goto 77
	    call memtab_set_line_ptr(file_level.lun,
     1                 struct_level.ptrs.begin_ptr)
	    jump_from_end_statement = .true.
	    err_status = 1
	  endif
c
	elseif(verb .eq. 'LOOP') then
c
c Loop construct
c  syntax : LOOP
c
	  if(file_level.is_term) goto 73
	  if(jump_from_end_statement) then
	    jump_from_end_statement = .false.
	  else
	    call dix_inter_open_struct(file_level,ptrs)
	    p_struct_level = file_level.cur_struct
	  endif
c
	elseif(verb .eq. 'TEST') then
c
c TESTLOOP
c syntax : TESTLOOP expression
c
c Test statement for the LOOP/TSTLOOP/ENDLOOP construct
c
	  if(file_level.is_term) goto 73
c
c Test the expression
c
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  err_status= dix_eval_expression(control,ascdat(1:nk),val,
     1           .false.,err_arg,.false.,is_symbol)
	  if(err_status) then
	    if(val.type .ne. symb_typ_log) err_status = %loc(dix_msg_notlog)
	    if((.not. err_status) .or. (.not. val.lval)) then
	      call memtab_set_line_ptr(file_level.lun,
     1                      struct_level.ptrs.end_ptr)
	      jump_from_control = .true.
	    endif
	  endif
c
	elseif(verb .eq. 'ENDL') then
c
c ENDLOOP
c Syntax : ENDLOOP
c finishing statement of the LOOP/TESTLOOP/ENDLOOP structure
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
c
c Came from the TESTLOOP or the LEAVE command
c
	    call dix_inter_close_struct(control,file_level)
	    p_struct_level = file_level.cur_struct
	    jump_from_control = .false.
	  else
	    if(file_level.struct_level .eq. 0) goto 76
	    if(struct_level.ptrs.begin_verb .ne. 'LOOP') goto 77
	    call memtab_set_line_ptr(file_level.lun,
     1            struct_level.ptrs.begin_ptr)
	    jump_from_end_statement = .true.
	    err_status = 1
	  endif
c
	elseif(verb .eq. 'FOR') then
c
c For
c syntax : FOR SYMBOL=Initval,Endval[,increment]
c starting statement of the FOR/ENDFOR construct
c
	  if(file_level.is_term) goto 73
	  if(.not. jump_from_end_statement) then
c
c We ran into the FOR, so set up the control
c
	    nk = 0
	    call cli$get_value('p1',ascdat,nk)
c
c The format : for symbol=begin,end[,interval]
c
	    err_status = dix_inter_parse_for(control,ascdat(1:nk),symbol,
     1             nk_symb,err_arg,des_expanded,
     1              begval,incval,endval)

	    if(.not. err_status) goto 10
c
	    call dix_inter_open_struct(file_level,ptrs)
	    p_struct_level = file_level.cur_struct
c
c FIll in the extra data for the FOR command
c
	    struct_level.for_symbol   = symbol
	    struct_level.nk_for_symbol= nk_symb
	    struct_level.for_begval   = begval
	    struct_level.for_increment= incval
	    struct_level.for_endval   = endval
	    workval = begval
c
c Now define a local symbol, to this level
c
	    val.type = symb_typ_int
	    val.ival = begval
	    call dix_symbol_add_level(control,symbol(1:nk_symb),
     1                val,err_arg,.true.,'FOR')
	  else
c
c Now update the symbol
c
	    symbol = struct_level.for_symbol 
	    nk_symb = struct_level.nk_for_symbol
	    call dix_symbol_find(control,symbol(1:nk_symb),val)
	    val.ival = val.ival + struct_level.for_increment
	    call dix_symbol_add_level(control,symbol(1:nk_symb),
     1                val,err_arg,.true.,'FOR')
	    workval = val.ival
	  endif
c
c And check if we have done it all
c
	  if(struct_level.for_increment .gt. 0) then
c
c Ascending
c
	    skip = workval .gt. struct_level.for_endval
	  else
c
c Descending
c
	    skip = workval .lt. struct_level.for_endval
	  endif
	  if(skip) then
c
c If skip set, jump to beyond ENDFOR, and decrease level
c
	    call memtab_set_line_ptr(file_level.lun,struct_level.ptrs.end_ptr)
	    jump_from_control = .true. 
	  endif
	  jump_from_end_statement = .false.
c
	elseif(verb .eq. 'ENDF') then
c
c ENDFOR
c SYntax : ENDFOR
c closing statement of the FOR/ENDFOR construct
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
c
c Came from the FOR or the LEAVE command
c
	    call dix_inter_close_struct(control,file_level)
	    p_struct_level = file_level.cur_struct
	    jump_from_control = .false.
	  else
	    if(file_level.struct_level .eq. 0) goto 76
	    if(struct_level.ptrs.begin_verb .ne. 'FOR') goto 77
	    call memtab_set_line_ptr(file_level.lun,
     1               struct_level.ptrs.begin_ptr)
	    jump_from_end_statement = .true.
	    err_status = 1
	  endif
c
	elseif(verb .eq. 'REPE') then
c
c REPEAT
c syntax : REPEAT
c  opening statement of the REPEAT/UNTIL sturcture
c
	  if(file_level.is_term) goto 73
c
	  if(.not. jump_from_end_statement) then
	    call dix_inter_open_struct(file_level,ptrs)
	    p_struct_level = file_level.cur_struct
	  endif
	  jump_from_end_statement = .false.
c
	elseif(verb .eq. 'UNTI') then
c
c Until
c syntax : UNTIL Leg-expression
c Closing statement of the REPEAT/UNTIL structure
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
c
c Came from the LEAVE statemenet
c
	    call dix_inter_close_struct(control,file_level)
	    p_struct_level = file_level.cur_struct
	    jump_from_control = .false.
	  else
	    if(file_level.struct_level .eq. 0) goto 76
	    if(struct_level.ptrs.begin_verb .ne. 'REPE') goto 77
	    nk = 0
	    call cli$get_value('p1',ascdat,nk)
	    err_status= dix_eval_expression(control,ascdat(1:nk),val,
     1             .false.,err_arg,.false.,is_symbol)
	    if(err_status) then
	      if(val.type .ne. symb_typ_log) then
	        err_status = %loc(dix_msg_invlog)
	        val.lval = .true.
	      endif
	    else
	      val.lval = .true.
	    endif
	    if(.not. val.lval) then
c                
c Now evaluates to false, jump to repeat
c
	      call memtab_set_line_ptr(file_level.lun,
     1               struct_level.ptrs.begin_ptr)
	      jump_from_end_statement = .true.
	    else
	      call dix_inter_close_struct(control,file_level)
	      p_struct_level = file_level.cur_struct
	    endif	        !evaluates to true
	  endif			!jump_from
c
	elseif(verb .eq. 'GOTO') then
c
c GOTO
c Syntax : GOTO label
c Goto the specified label
c
	  if(file_level.is_term) goto 73
	  nk_label = 0
	  call cli$get_value('p1',label,nk_label)
	  err_status = dix_inter_find_label(label,
     1                       line_level,err_arg,nlevel,file_level,
     1                     control.debug)
	  if(err_status) then
c
c We found the label, but is is some levels down, so close all of them
c
	    do k=1,nlevel
	      call dix_inter_close_struct(control,file_level)
	      p_struct_level = file_level.cur_struct
	    enddo
	  endif
c
	elseif(verb .eq. 'GOSU') then
c
c gosub
c syntax : GOSUB label
c goto the label and let RETURN return you to the next statement
c
	  if(file_level.is_term) goto 73
c
	  nk_label = 0
	  call cli$get_value('p1',label,nk_label)
	  call memtab_get_line_ptr(file_level.lun,line_ptr)
	  k = sizeof(line_ptr)
c
c Insert into link
c
	  call dix_util_insert_element(sizeof(line_ptr),line_ptr,
     1       file_level.gosub_level,file_level.nbgosub_alloc,
     1       file_level.p_gosubs,10,file_level.zone_level)
c
	  err_status = dix_inter_find_label(label,
     1                 line_level,err_arg,nlevel,file_level,
     1                     control.debug)
c
	elseif(verb .eq. 'RETU') then
c
c RETURN
c Syntax : RETURN
c Return to the statement just after to GOSUB
c
	  if(file_level.is_term) goto 73
	  if(file_level.gosub_level .gt. 0) then
	    p_gosub_ptrs = file_level.p_gosubs
	    line_ptr = gosub_ptrs(file_level.gosub_level)
	    file_level.gosub_level = file_level.gosub_level - 1
	    call memtab_set_line_ptr(file_level.lun,line_ptr)
	  else
c
c THis is really an error, but DCL lets you enter RETURNS without GOSUBS
c so just ignore this
c
c	    err_status = %loc(dix_msg_illret)
	    err_status = 1
	  endif	       
c
	elseif(verb .eq. 'INQU') then
c
c Inquire
c syntax : INQUIRE statement [prompt_string][/qualifiers
c let the user input a value for a symbol
c  The type of the symbol is defined by the input of the user
c
	  err_status = dix_dump_inter_get_symbol('p1',symbol,nk_symb,err_arg)
	  if(err_status) then
	    nk = 0
	    call cli$get_value('p2',line,nk)
	    if(nk .eq. 0) then
	      line = 'Data'
	      nk = 4
	    endif
	    if(cli$present('punctation')) then
	      line(nk+1:nk+2) = ': '
	      nk = nk + 2
	    endif
c
c Now prompt the user for the input
c
	    write(*,1124) line(1:nk)
1124	    format('$',a)
	    read(*,2010,iostat=err_status) nk,tline
2010	    format(q,a)
	    if(err_status .ne. 0) then
	      call errsns(,err_status)
	    else
	      err_status= dix_eval_expression(control,tline(1:nk),val,
     1             .false.,err_arg,.false.,is_symbol)
	    endif
	    if(err_status) then
	      call dix_symbol_add(control,symbol(1:nk_symb),val,err_arg)
	    endif
	  endif		!valid symbol name
c
	elseif(verb .eq. 'CREA') then
c
c CREATE
c syntax : create what (what = DESCRIPTION or RECORD)
c Create description file or new record in the file
c
	  nk = 0
	  call cli$get_value('p1',line,nk) 
	  if(line(1:1) .eq. 'D') then
c
c We want to create a description
c
	    nk = 0
	    call cli$get_value('p2',line,nk)
	    err_status = dix_util_check_name(line(1:nk))
	    if(err_status) then
	      where = des_in_file
	      if(cli$present('user_library'  )) where = des_in_userlib
	      if(cli$present('system_library')) where = des_in_syslib
	      err_status = dix_edit_des(control,file,des,line(1:nk),
     1                       where,err_arg)
	    endif
	  else
c
c We want to create a new record in the file
c
	    err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	    if(err_status) then
	      p_temp_file = k
	      if(.not. temp_file.modify) goto 75
	      call dix_main_fill_rec(control,temp_file)
	      temp_file.data.newrec = .true.
	      changed_rec = .true.
	    endif
	  endif
c
	elseif(verb .eq. 'EDIT') then
c
c EDIT
c syntax : EDIT
c Edit current description file
c
	  err_status = 1
	  if(%loc(file) .eq. 0) goto 71
	  if(file.cur_des .eq. 0) goto 72
	  err_status = dix_edit_des(control,file,des,' ',0,err_arg)
	  call dix_des_check_expand_all(control,file)
c
	elseif(verb .eq. 'SHOW') then
c
c SHOW
c Syntax : SHOW what
c Show some things
c
	  call cli$get_value('p1',line)
c
	  if(line(1:3) .eq. 'PAG') then
	    temp = 'No'
	    if(control.paged .eq. 1) temp = 'Yes'
	    if(control.paged .eq. 3) temp = 'Screen'
	    call dix_dump_print_line(control,0,
     1            'Page mode set to '//temp(1:6))
	  elseif(line(1:2) .eq. 'SK') then
	    call cli$get_value('output',line)
	    if(line .eq. ' ') line = 'SYS$OUTPUT'
	    call keydefs_dump(control.key_table,line)
	  elseif(line(1:1) .eq. 'K') then
	    call dix_inter_list_keys(control)
	  elseif(line(1:2) .eq. 'ST') then
	    nk = 0
	    if(iand(control.strict_mode,strict_typing) .ne. 0) then
	      call dix_append(nk,line,'TYPING,')
	    else
	      call dix_append(nk,line,'NOTYPING,')
	    endif
 	    if(iand(control.strict_mode,strict_declaration) .ne. 0) then
	      call dix_append(nk,line,'DECLARATIONS,')
 	      if(iand(control.strict_mode,strict_declaration_local).ne.0)then
	        call dix_append(nk,line,'LOCAL,')
	      endif
	    else
	      call dix_append(nk,line,'NODECLARATIONS,')
	    endif
	    call dix_dump_print_line(control,0,
     1                 'Strict mode set to '//line(1:nk-1))
	  elseif(line(1:2) .eq. 'DI') then
	    call dix_inter_show_dis(control,dis)
	  elseif(line(1:2) .eq. 'DE') then
	    err_status = dix_dump_i_open_output(control,save_lun,save_paged,
     1                   err_arg,dis.is_term,file_level)
	    if(err_status) then
	      if(cli$present('expanded')) then
	        if(%loc(des) .eq. 0) goto 72
	        err_status = dix_dump_i_show_des_exp(control,
     1               des_expanded.n_des,%val(des_expanded.des_adr),
     1               des.has_fields)
	      else
	        err_status = dix_dump_i_show_des(control,file,des)	    
	      endif
	    endif
	    call dix_dump_i_close_output(control,save_lun,
     1                 save_paged,file_level,
     1                 'Show Descriptor')
	  elseif(line(1:1) .eq. 'E') then
c
c Show editor
c
	    temp = 'Unknown'
	    if(control.editor .eq. dix_edit_edt     ) temp = 'EDT'
	    if(control.editor .eq. dix_edit_internal) temp = 'Internal'
	    if(control.editor .eq. dix_edit_tpu     ) temp = 'TPU'
	    call dix_dump_print_line(control,0,
     1           'Editor set to '//temp(1:8))
	  elseif(line(1:1) .eq. 'T') then
	    temp = 'LINE_EDITING'
	    if(control.input_flags .ne. 0) temp = 'NO'//temp
	    call dix_dump_print_line(control,0,
     1                'Terminal set to '//temp(1:14))
	  elseif(line(1:1) .eq. 'F') then
c
c Show file
c
	    err_status = dix_dump_i_open_output(control,save_lun,save_paged,
     1                 err_arg,dis.is_term,file_level)
	    if(err_status) then
	      do_descr = cli$present('descriptions')
	      all = cli$present('ALL')
	      full = cli$present('FULL')
	      if(all) then
	        if(control.n_file .eq. 0) goto 71
	      else
	        if(%loc(file) .eq. 0) goto 71
	      endif
	      call dix_dump_inter_dir_files(control,'*',full,do_descr,all)
	    endif
	    call dix_dump_i_close_output(control,save_lun,
     1                     save_paged,file_level,
     1                 'Show File')
	  elseif(line(1:2) .eq. 'SY') then
c
c Show symbols
c
	    if(cli$present('statistics')) then
	      full = cli$present('full')
	      all = cli$present('all')
	      call dix_symbol_statistics(control,full,all)
	    else
	      dis_work.hex = cli$present('hex')
	      nk_line = 0
	      call cli$get_value('p2',line,nk_line)
	      all  = cli$present('ALL')
	      full = cli$present('FULL')
	      call dix_dump_show_symbols(control,
     1            line(1:nk_line),dis_work.hex,all,full)
	    endif
	  elseif(line(1:1) .eq. 'P') then
c
c Show parameters
c
	    if(%loc(des) .eq. 0) goto 72
	    err_status = dix_dump_i_open_output(control,save_lun,save_paged,
     1                  err_arg,dis.is_term,file_level)
	    if(err_status) then
	      dis_work.hex = cli$present('hex')
	      nl = 0
	      nk_line = 0
	      call cli$get_value('p2',line,nk_line)
	      if(nk_line .eq. 0) then
	        line = '*'
	        nk_line = 1
	      endif
	      call dix_dump_print_par(control,des.n_par,
     1            %val(des.par_adr),line(1:nk_line),
     1            dis_work.hex)
	    endif
	    call dix_dump_i_close_output(control,save_lun,
     1               save_paged,file_level,
     1                 'Show Parameters')
	  elseif(line(1:2) .eq. 'VI') then
	    err_status = dix_dump_i_open_output(control,save_lun,save_paged,
     1                   err_arg,dis.is_term,file_level)
	    if(err_status) then
	      if(cli$present('VMS')) then
	        full = cli$present('full')
	        all = cli$present('detail')
	        call vm_info(control,full,all)
	      else
	        call dix_util_show_vm(control)
	      endif
	      call dix_dump_i_close_output(control,save_lun,
     1                  save_paged,file_level,
     1                 'Virtual memory info')
	    endif
	  elseif(line(1:2) .eq. 'VE') then
	    call dix_get_version(line,nk)
	    call dix_dump_print_line(control,0,
     1                'DIX Version '//line(1:nk))
	  elseif(line(1:1) .eq. 'M') then
	    call dix_inter_conv_msg(control.msgmask,line,nk)
	    call dix_dump_print_line(control,0,
     1                'Message set to '//line(1:nk))
	  else
	    goto 70
	  endif
c
	elseif(verb .eq. 'SET') then
c
c Set 
c Syntax : set what towhat
c Set something
c
	  call cli$get_value('p1',line)
	  if(line(1:1) .eq. 'O'  ) then	!set on
	    call dix_inter_set_default_error(file_level)
	  elseif(line(1:3) .eq. 'NOO'  ) then	!set on
	    file_level.nk_on = 0
	    file_level.on_mode = .false.
	  elseif(line(1:2) .eq. 'DI'  ) then
	    call dix_inter_set_display(dis)
	  elseif(line(1:2) .eq. 'DE'  ) then
	    call cli$get_value('p2',line)
	    control.debug = line(1:2) .eq. 'ON'
	  elseif(line(1:1) .eq. 'V'  ) then
	    file_level.verify = .true.
	  elseif(line(1:3) .eq. 'NOV') then
	    file_level.verify = .false.
	  elseif(line(1:1) .eq. 'M') then
	    call set_message(control)
	  elseif(line(1:2) .eq. 'ED') then
	    call cli$get_value('p2',line)
            if(line(1:1) .eq. 'E') then
              control.editor = dix_edit_edt
            elseif(line(1:1) .eq. 'I') then
              control.editor = dix_edit_internal
            elseif(line(1:1) .eq. 'T') then
              control.editor = dix_edit_tpu
            endif
	  elseif(line(1:2) .eq. 'EX') then
	    nk = 0
	    call cli$get_value('p2',line,nk)
	    read(line(1:nk),2040) err_status
2040	    format(i10)
	  elseif(line(1:2) .eq. 'PR') then
	    control.nk_prompt = 0
	    call cli$get_value('P2',control.prompt,control.nk_prompt)
	  elseif(line(1:2) .eq. 'PA') then
	    nk = 0
	    call cli$get_value('p2',line,nk)
	    if(line(1:1) .eq. 'N') control.paged = 0
	    if(line(1:1) .eq. 'Y') control.paged = 1
	    if(line(1:1) .eq. 'S') control.paged = 3
	    temp = 'No'
	    if(control.paged .eq. 1) temp = 'Yes'
	    if(control.paged .eq. 3) temp = 'Screen'
	    call dix_message(control,dix_msg_pagemode,temp)
	  elseif(line(1:2) .eq. 'SC') then
	    if(%loc(file) .eq. 0) goto 71
	    iterm = key_modechange
	  elseif(line(1:2) .eq. 'ST') then
	    call set_strict(control.strict_mode)
	  elseif(line(1:1) .eq. 'T') then
	    istat = cli$present('LINE_editing')
	    if(istat .eq. %loc(cli$_present)) control.input_flags = 0
	    if(istat .eq. %loc(cli$_negated)) control.input_flags =
     1               smg$m_func_keys
	  else
	    goto 70
	  endif
c
	elseif(verb .eq. 'ECHO') then
c
c Echo
c Syntax ECHO[/console] "string"
c Print a string to the output file/terminal
c
	  nk_t   = 0
	  call cli$get_value('p1',line,nk_t)
	  if(line(1:1) .eq. '"' .and. line(nk_t:nk_t) .eq. '"') then
	    line = line(2:nk_t-1)
	    nk_t = nk_t - 2
	  endif
	  k = 0
	  if(cli$present('console')) then
	    k = file_level.lun_out
	    file_level.lun_out = control.lun_console
	  endif
	  call dix_dump_print_line(control,0,'ECHO:'//line(1:nk_t))
	  if(k .ne. 0) file_level.lun_out = k
c
	elseif(verb .eq. 'SPAW') then
c
c SPAWN
c Syntax : SPAWN [command]
c The spawn command, temporary to DCL
c
	  nk = 0
	  call cli$get_value('p1',line,nk)
	  call lib$spawn(line(1:nk))
c
	elseif(verb .eq. 'HELP') then
c
c HELP
c Syntax : HELP [topic [topic...]
c The help command
c
	  nk = 0
	  call cli$get_Value('p1',line,nk)
	  call dix_help('DIX INTERACTIVE '//line(1:nk))	
c
	elseif(verb .eq. 'ON') then
c
c ON
c Syntax : ON CONTROL_C command
c          ON severity command  (severity = warning,error,severe)
c Define action for some events
c
	  if(file_level.is_term) goto 73
	  nk = 0
	  call cli$get_value('P1',line,nk)
	  file_level.on_mode = .true.
	  if(line(1:1) .eq. 'C') then
c
c On control
c
	    file_level.nk_on_c = 0
	    call cli$get_value('P2',
     1           file_level.on_controlc_line,
     1           file_level.nk_on_c)
	  else
c
c On warning,error,severe
c
	    file_level.nk_on = 0
	    call cli$get_value('P2',file_level.on_line,file_level.nk_on)
	    if(line(1:1) .eq. 'W') then
	      file_level.on_level = sts$k_warning
	    elseif(line(1:1) .eq. 'E') then
	      file_level.on_level = sts$k_error
	    elseif(line(1:1) .eq. 'S') then
	      file_level.on_level = sts$k_severe
	    endif
	  endif
c
	elseif(verb .eq. 'EVAL') then
c
c Evaluate 
c Syntax : Evaluate expression
c Evaluatie expression and print the result
c
	  dis_work.hex = cli$present('hex')
	  nk = 0
	  call cli$get_value('p1',ascdat,nk)
	  call dix_util_collapse(ascdat,nk,.true.)
	  des_rec.size = -1
	  nk_tot = 0
42	  err_status= dix_eval_expression1(control,ascdat(1:nk),val,
     1           .false.,err_arg,.false.,kar,l,is_symbol)
	  if(err_status) then
	    call dix_con_value_intasc(control,val,
     1               eval_line(nk_tot+1:),k,dis_work.hex)
	    nk_tot = nk_tot + k
	    if(kar .eq. ',') then	
	      ascdat = ascdat(l:)
	      nk = nk - l + 1
	      goto 42
	    elseif(kar .eq. char(0)) then
	      call dix_dump_print_line(control,0,eval_line(1:nk_tot))
	    else
	      err_status = %loc(dix_msg_unexpchar)
	      err_arg = kar
	    endif
	  endif
c
	elseif(verb .eq. 'IF') then
c 
c IF
c Syntax : IF (log_expr) command One line if
c    or  : IF (log_expr) THEN	 Start statement of IFTHEN/ELSE/ENDIF construct
c find the (expr) part
c
	  nk = 0
	  call cli$get_value('p1',line,nk)
	  if(line(1:1) .eq. '(') then
	    k = dix_util_find_char_bracket(line,')',.true.)
	    if(k .le. 2) then
	      err_status = %loc(dix_msg_closbnotf)
	      goto 10
	    endif
c
	    totline = line(k+1:)		!remember the command
	    nk_tot  = nk - k + 1
c
c Evaluate the expression
c
	    err_status = dix_eval_expression(control,
     1           line(2:k-1),val1,
     1           .false.,err_arg,.false.,is_symbol)
	    if(err_status) then
	      if(val1.type .ne. symb_typ_log) then
	        err_status = %loc(dix_msg_notlog)
	        err_arg = line(1:k)
	      endif
	    endif
	    if(err_status) then
	      istat = val1.lval
	      call dix_util_decent_line(nk_tot,totline)
	      then_mode = totline .eq. 'THEN'
c
	      if(then_mode) then
	        if(file_level.is_term) goto 73
	        call dix_inter_open_struct(file_level,ptrs)
	        p_struct_level = file_level.cur_struct
c
c We have the ifthen variant
c
	        if(.not. istat) then
c
c Take the else branch if there, else take the endif 
c
	          line_ptr = struct_level.ptrs.middle_ptr
	          if(line_ptr .eq. 0) then
c
c No ELSE branch, so continue after the ENDIF, and exit this IF level
c
	            line_ptr = struct_level.ptrs.end_ptr
	          endif
	          jump_from_control = .true.
	          call memtab_set_line_ptr(file_level.lun,line_ptr)
	        endif
c
c IF (EXPR) THEN : expr evaluates to true, so just continue
c
	      else
c
c IF (EXPR) statement
c
	        if(istat) then
c
c EXPR is .true. Make sure all items are parsable
c
	          call dix_inter_massage(totline,nk_tot)
	          goto 25	!valid result, go execute totline
	        endif
	      endif
	    endif
	  else
	    err_status = %loc(dix_msg_openbnotf)
	  endif
c
	elseif(verb .eq. 'ELSE') then
c
c ELSE
c Syntax : ELSE
c ELSE statement of the IFTHEN/ELSE/ENDIF structure
c
	  if(file_level.is_term) goto 73
	  if(jump_from_control) then
	    jump_from_control = .false.	!we came from if
	  else
	    call memtab_set_line_ptr(file_level.lun,struct_level.ptrs.end_ptr)
	    err_status = 1
	  endif
c
	elseif(verb .eq. 'ENDI') then
c
c ENDIF
c syntax :ENDIF
c closing statement of the IFTHE/ELSE/ENDIF statement
c
	  jump_from_control = .false.
	  if(file_level.is_term) goto 73
	  if(file_level.struct_level .eq. 0) goto 76
	  if(struct_level.ptrs.begin_verb .ne. 'IF') goto 77
	  call dix_inter_close_struct(control,file_level)
	  p_struct_level = file_level.cur_struct
c
	elseif(verb .eq. 'DELE') then
c
c DELETE
c Syntax : DELETE /symbol symbolname     delete symbols
c        : DELETE /key    keyname        Delete keys for interactive mode
c        : DELETE /skey   keyname        Delete keys for screen mode
c        : DELETE                        Delete record
c
	  if(cli$present('symbol')) then
	    err_status = dix_dump_inter_get_symbol('p1',line,nk_line,err_arg)
	    if(err_status) then
	      logit = cli$present('log')
	      all   = .not. cli$present('local')
	      err_status = dix_symbol_delete(control,line(1:nk_line),
     1                 logit,.false.,all)
	    endif
	  elseif(cli$present('RECORD')) then
	    if(%loc(file) .eq. 0) goto 71
	    err_status = dix_rms_delete(control,file)
	    if(err_Status) then
	      err_status = dix_rms_get(control,temp_file)
	    endif
	    if(err_status) changed_rec = .true.
	  elseif(cli$present('KEY')) then
	    nk = 0
	    call cli$get_value('p1',line,nk)
	    nk_if = 0
	    call cli$get_value('state',if_state,nk_if)
	    err_status = smg$delete_key_def(control.keytable_id,
     1           line(1:nk),if_state(1:nk_if))
	  elseif(cli$present('SKEY')) then
            if(cli$present('all')) then
              if_state = ' '
              line = ' '
            else
              call cli$get_value('p1',line)
              call cli$get_value('state',if_state)
            endif
            call keydefs_del_key(control,line,if_state,control.debug)
	  else
	    goto 70
	  endif
c
	elseif(verb .eq. 'READ') then
c
c READ
c syntax : READ[/error=label][/end=label][record selection quals]
c  Read a record from the file
c
	  call dix_dump_get_err_lab(control,file_level)
	  call dix_dump_get_eof_lab(control,file_level)
	  trans = cli$present('translate')
	  err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  if(err_status) then
	    p_temp_file = k
	    err_status = dix_dump_i_get_keys(temp_file,control,err_arg,trans)
	  end if	  
	  if(err_status) changed_rec = .true.
	elseif(verb .eq. 'CLOS') then
c
c CLOSE
c Syntax : CLOSE [/ERROR=label] [mask]
c Close the current file
c
	  call dix_dump_get_err_lab(control,file_level)
	  logit = cli$present('log')
	  nk = 0
	  call cli$get_value('p1',line,nk)
	  k = control.cur_file
          call dix_main_close_files(control,line(1:nk),logit)
	  if(k .ne. control.cur_file) changed_fil = .true.
	elseif(verb .eq. 'MARK') then
c
c MARK
c Syntax : MARK [markname]
c mark this record for easy retrieval
c
	  if(%loc(file) .eq. 0) goto 71
	  nk = 0
	  call cli$get_value('p1',tline,nk)
	  call dix_rms_save_rfa_rab(control,tline(1:nk),
     1                %val(file.rabadr),file.rec_nr)
c
	elseif(verb .eq. 'GOMA') then
c
c GOMARK
c syntax : GOMARK [markname]
c  Goto a previously save RECORD marker 
c
	  nk = 0
	  call cli$get_value('p1',tline,nk)
	  if(.not. dix_rms_check_rfa(tline(1:nk))) then
	    err_arg = tline(1:nk)
	    err_status = %loc(dix_msg_mrknotmrk)
	  else
	    err_arg = tline(1:nk)
	    err_status = dix_main_rfa_restore(control,tline(1:nk))
	  endif
	  if(err_status) changed_fil = .true.
c
	elseif(verb .eq. 'EXAM' .or. verb .eq. 'SEAR') then
c
c EXAM or SEAR
c Syntax: EXAMINE [/qualifiers] [fieldmask]  Display fields
c         SEARCH  [/qualifiers] [searchmask] Display field with contents
c
	  err_status = dix_dump_i_exam(control,dis,verb,err_arg,file_level)
c
	elseif(verb .eq. 'DEPO') then
c
c Deposit
c Syntax:  DEPOSIT[/qualifiers] fieldname=value
c          DEPOSIT[/qualifiers] offset=value
c Deposit data in fields or raw byte offsets
c
 	  err_status = dix_dump_i_depo(control,dis,
     1          err_arg,ototline(1:onk_tot),changed_rec)
c
	elseif(verb .eq. 'TRUN') then
c
c TRUNCATE
c Syntax TRUNCATE[/qualifiers] size
c     Or TRUNCATE[/qualifiers[ tag size
c
c Truncate the current record (only IDX and REL files)
c
	  nk_field = 0
	  if(cli$present('p2')) then
c
c 2 parameters specified, tag, recl
c
	    err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	    call cli$get_value('p2',fieldname,nk_field)
	  else
c
c Only one paramter recl
c
	    k = control.cur_file
	    call cli$get_value('p1',fieldname,nk_field)
	  endif
c
	  if(k .eq. 0) goto 71
c
	  p_temp_file = k
c
c Check if allowed
c
	  if(.not. temp_file.modify) goto 75
	  if(.not. ((temp_file.indexed .or. temp_file.relative) .and. .not.
     1                   temp_file.fixed)) then
	    err_status = %loc(dix_msg_cannotchg)
	  else
	    dis_work.number_hex = cli$present('HEX')
	    if(dix_con_i4(fieldname(1:nk_field),nk_field,
     1                   offs,dis_work.number_hex,
     1                   control,.false.)) then
	      offs = max(temp_file.minrecl,offs)
	      if(temp_file.maxrecl .ne. 0) then
	        offs = min(temp_file.maxrecl,offs)
	      endif
	      temp_file.data.nb_data = offs
	      call dix_message(control,dix_msg_chgdrecl,
     1                      %val(temp_file.data.nb_data))
	      changed_rec = .true.
	    else
	      err_arg = fieldname(1:nk_field)
	      err_status = %loc(dix_msg_illoffs)
	    end if
	  endif       !correct file type
c
	elseif(verb .eq. 'REWI') then
c
c REWIND
c Syntax : REWIND [/KEY=keynumber] [tag]
c 
c Rewind a file to the first record [on the specified key]
c the first record is read and is the current record
c
	  err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  if(err_status) then
	    p_temp_file = k
	    if(cli$present('KEY')) then
	      if(temp_file.indexed) then
	        call util_cli_get_number('KEY',0,key)
	        if(key .lt. 0 .or. key .ge. temp_file.nkey) then
	          call cli$get_value('key',err_arg)
	          err_status = %loc(dix_msg_illkey)
	        endif
	      else
	       err_status = %loc(dix_msg_notindex)
	      endif
	    else
	      key = -1
	    endif
	    if(err_status) err_status = dix_rms_rewind(control,temp_file,key)
	    if(err_status) err_status = dix_rms_get(control,temp_file)
	    if(err_status) changed_rec = .true.
	  endif
	elseif(verb .eq. 'UPDA') then
c
c UPDATE
c syntax : UPDATE[/quiet]
c     Or : UPDATE[/quiet] tag
c Update the current data in memory to the file
c
	  if(cli$present('p1')) then
	    err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  else
	    k = control.cur_file
	  endif
	  if(k .eq. 0) goto 71
	  p_temp_file = k
	  if(.not. temp_file.modify) goto 75
c
	  signal = .true.
	  if(cli$present('quiet')) signal = .false.
	  call dix_rms_update(control,temp_file,signal)
	  call dix_util_copy(temp_file.data.nb_data,temp_file.data.data_rec,
     1                         temp_file.data.data_sav)
	  temp_file.data.nb_sav = temp_file.data.nb_data
c
	elseif(verb .eq. 'CUT') then
c
c CUT
c Syntax : CUT  [TAG] [/SYMBOL=symbolname]
c Save the record data to the save area (paste buffer)
c
	  err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  if(err_status) then
	    p_temp_file = k
	    err_status = dix_dump_inter_get_symbol('symbol',symbol,
     1                          nk_symb,err_arg)
	    if(err_status) then
	      if(nk .gt. 0) then
	        descr(1) = temp_file.data.nb_data
	        descr(2) = %loc(temp_file.data.data_rec)
	        err_status = dix_symbol_add_str(control,symbol(1:nk_symb),
     1                          descr,err_arg)
	        if(err_status) then	    
	          call dix_message(control,dix_msg_datasav,
     1             %val(temp_file.data.nb_data),
     1             %DESCR('symbol '//symbol(1:nk_symb)))
	        endif
	      else
	        control.nb_save = temp_file.data.nb_data
	        call dix_util_copy(temp_file.data.nb_data,
     1                        temp_file.data.data_rec,
     1                        control.save_area)
	        call dix_message(control,dix_msg_datasav,
     1           %val(temp_file.data.nb_data),%DESCR('SAVE_AREA'))
	      endif
	    endif
	  endif
c
	elseif(verb .eq. 'PAST') then
c
c PASTE
c Syntax : PASTE  [TAG] [/symbol=expression]
c Replace the record data in memory by data from the save area (past buffer)
c  or from data in a symbol
c
	  err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  if(err_status) then
	    p_temp_file = k
	    if(.not. temp_file.modify) goto 75
	    if(cli$present('SYMBOL')) then
	      nk = 0
	      call cli$get_value('symbol',ascdat,nk)
	      err_status= dix_eval_expression(control,ascdat(1:nk),val,
     1             .false.,err_arg,.false.,is_symbol)
	      if(err_status) then
	        if(val.type .eq. symb_typ_char) then
	          temp_file.data.nb_data = zext(val.strdes.dsc$w_maxstrlen)
	          call dix_util_copy(temp_file.data.nb_data,
     1                 %val(val.strdes.dsc$a_pointer),
     1                      temp_file.data.data_rec)
	          call dix_message(control,dix_msg_datarest,
     1                         %val(temp_file.data.nb_data),
     1                  %descr('Symbol '//ascdat(1:nk)))
	          changed_rec = .true.
	        else
	          err_status = %loc(dix_msg_notchar)
	        endif
	      endif
	    else
	      if(control.nb_save .eq. 0) then
	        err_status = %loc(dix_msg_norest)
	      else
	        temp_file.data.nb_data = control.nb_save 
	        call dix_util_copy(temp_file.data.nb_data,control.save_area,
     1                      temp_file.data.data_rec)
	        call dix_message(control,dix_msg_datarest,
     1                         %val(temp_file.data.nb_data),
     1                         %descr('SAVE_AREA'))
	        changed_rec = .true.
	      endif
	    end if
	  endif
c
	elseif(verb .eq. 'ADD') then
c
c Add
c Syntax : ADD description[,description...]
c Add new descriptions to the current open file
c
	  if(%loc(file) .eq. 0) goto 71
c
c Add another description file to to current file
c
	  nk_line = 0
	  call memtab_init(lun1,'TEMP_DES')
	  do while (cli$get_value('description',line,nk_line))
	    call memtab_add_record(lun1,line(1:nk_line))
	  end do
	  call memtab_rewind(lun1)
	  do while (memtab_read(lun1,nk_line,line))
	    if(.not. dix_des_get_all(control,file,line(1:nk_line),
     1             .true.)) then
	      call dix_message(control,dix_msg_notaddes,line(1:nk_line))
	    endif
	  end do
	  call memtab_close(lun1)
	  call dix_des_check_expand_all(control,file)
	  if(file.top_des .ne. 0 .and. file.cur_des .eq. 0) then
	    file.cur_des = file.top_des
	    file.raw    = .false.
	    dis.hex     = .false.
	    changed_des = .true.
	  endif
c
	elseif(verb .eq. 'BACK') then
c
c BACK
c SYNTAX : BACK [/log][/error=label]
c Follow the backlink from a previous FOLLOW statement
c
	  if(%loc(file) .eq. 0) goto 71
	  logit = cli$present('log')
	  call dix_dump_get_err_lab(control,file_level)
	  err_status = dix_main_follow_back(control,logit)
	  if(err_status) changed_fil = .true.
c
	elseif(verb .eq. 'FOLL') then
c
c FOLLOW
c  Syntax : FOLLOW fieldname[/log]
c Follow the link specified in the fieldname to another record in 
c               (possibly) another file.
c
	  if(%loc(file) .eq. 0) goto 71
	  if(p_des .eq. 0) goto 72
	  logit = cli$present('log')
	  nk_line = 0
	  call cli$get_value('p1',line,nk_line)
	  call dix_dump_get_err_lab(control,file_level)
	  l = 0
	  do k=1,des_expanded.n_des
	    call dix_des_get_des(des_expanded,k,des_rec,field_name)
	    if(line(1:nk_line) .eq. field_name) then
	      l = k
	    end if
	  end do
	  if(l .eq. 0) then
	    err_status = %loc(dix_msg_fieldnotf)
	    err_arg = line
	  else
	    err_status = dix_dump_set_link(control,l,
     1         %val(des_expanded.des_adr),err_arg,file,logit,link_rec,
     1              val,link_fnam)
	    if(err_status) then
	      auto = cli$present('automatic')
	      flag = 0		!assume open a current file
	      if(cli$present('write')) flag =  1      !open /write
	      if(cli$present('read')) flag = -1       !open /nowrite
	      err_status = dix_main_follow(control,dis,auto,flag,
     1                link_rec,val,link_fnam)
	    endif
	  endif
	  if(err_status) changed_fil = .true.
c
	elseif(verb .eq. 'REMO') then
c
c REMOVE
c Syntax : REMOVE descrption[,description]
c Remove descriptions from the current file
c
	  if(%loc(file) .eq. 0) goto 71
	  if(p_des .eq. 0) goto 72
	  nk_line = 0
	  call cli$get_value('p2',line,nk_line)
	  p_des_expanded = file.top_des
	  do_sys = cli$present('system_library')
	  do_usr = cli$present('user_library')
	  do_fil = cli$present('file')
	  do while(p_des_expanded .ne. 0)
	    p_des = des_expanded.p_des_info
	    if(str$match_wild(des.fnam(1:des.nk_fnam),line(1:nk_line))) then
	      do_it = 
     1         ((des.in_Library .eq. des_in_file   ) .and. do_fil) .or. 
     1         ((des.in_Library .eq. des_in_syslib ) .and. do_sys) .or. 
     1         ((des.in_Library .eq. des_in_userlib) .and. do_usr)
	      k = des_expanded.link.forw
	      if(do_it) then
	        call dix_message(control,dix_msg_desrem,
     1                 des.fnam(1:des.nk_fnam))
	        call dix_des_link_out(control,file,des_expanded)
	      end if
	      p_des_expanded = K	!since linkout fremems linked_list and des
	    else
	      p_des_expanded = des_expanded.link.forw
	    end if
	  end do
	  if(file.top_des .eq. 0) then
	    call dix_message(control,dix_msg_nomordes)
	    file.raw = .true.
	    dis.hex = .true.
	  endif
	  file.cur_des = 0	!select new description
	  changed_des = .true.
c
	elseif(verb .eq. 'UNDO') then
c
c UNDO
c Syntax : UNDO 
c     Or : UNDO tag
c undo changes made to record
c
	  err_status = dix_dump_inter_get_file(control,'p1',k,err_arg)
	  if(err_status) then
	    p_temp_file = k
	    if(.not. temp_file.modify) goto 75
c
	    temp_file.data.nb_data = temp_file.data.nb_sav
	    call dix_util_copy(temp_file.data.nb_data,temp_file.data.data_sav,
     1                        temp_file.data.data_rec)
	    call dix_message(control,dix_msg_datarest,
     1         %val(file.data.nb_data),%descr('UNDO_AREA'))
	    changed_rec = .true.
	  endif
c
	elseif(verb .eq. 'NEXT') then
c
c NEXT
c SYNTAX : Next record      goto next record
c          Next file        goto next file
c          Next description goto next description of this file
c
	  call cli$get_Value('p1',line)
	  if(line(1:1) .eq. 'D') then
	    if(%loc(file) .eq. 0) goto 71
	    if(file.top_des .eq. 0) goto 72
	    p_des_expanded = file.cur_des
	    p_des_expanded = des_expanded.link.forw
	    if(p_des_expanded .eq. 0) p_des_expanded = file.top_des
	    file.cur_des = p_des_expanded
	    changed_des = .true.
	  elseif(line(1:1) .eq. 'F') then
	    if(control.n_file .eq. 0) goto 71
	    if(control.cur_file .eq. 0) then
	      control.cur_file = control.top_file
	    else
	      control.cur_file = file.link.forw
	      if(control.cur_file .eq. 0) control.cur_file = control.top_file
	    endif
	    changed_fil = .true.
	  else 
	    call dix_dump_get_err_lab(control,file_level)
	    call dix_dump_get_eof_lab(control,file_level)
	    err_status = dix_dump_inter_get_file(control,'p2',k,err_arg)
	    if(err_status) then
	      p_temp_file = k
	      err_status = dix_rms_get(control,temp_file)
	    endif
	    if(err_status) changed_rec = .true.
	  end if
	elseif(verb .eq. 'PREV') then
c
c PREVIOUS
c SYNTAX : PREVIOUS record      goto next record
c          PREVIOUS file        goto next file
c          PREVIOUS description goto next description of this file
c
	  call cli$get_Value('p1',line)
	  if(line(1:1) .EQ. 'D') then
	    if(%loc(file) .eq. 0) goto 71
	    if(file.top_des .eq. 0) goto 72
	    p_des_expanded = file.cur_des
	    p_des_expanded = des_expanded.link.backw
	    if(p_des_expanded .eq. 0) then
	      p_des_expanded = file.top_des
	      do while(des_expanded.link.forw .ne. 0)
	        p_des_expanded = des_expanded.link.forw
	      end do                                           
	    end if
	    file.cur_des = p_des_expanded
	    changed_des = .true.
	  elseif(line(1:1) .EQ. 'R') then
	    call dix_dump_get_err_lab(control,file_level)
	    err_status = dix_dump_inter_get_file(control,'p2',k,err_arg)
	    if(err_status) then
	      p_temp_file = k
              if(temp_file.block_size .eq. 0 .and.
     1          (temp_file.indexed .or. temp_file.relative)) then
                err_status = %loc(dix_msg_opernotall)
              else
                err_status = dix_main_get_rec_int(control,
     1                      temp_file,temp_file.rec_nr-1)
              end if
	    end if
	    if(err_status) changed_rec = .true.
	  else
	    if(control.n_file .eq. 0) goto 71
	    if(p_file .ne. 0) p_file = file.link.backw
	    if(p_file .eq. 0) then
	      p_file = control.top_file
	      do while(file.link.forw .ne. 0)
	        p_file = file.link.forw
	      end do
	    endif
	    control.cur_file = p_file
	    changed_fil = .true.
	  end if
c
	elseif(verb .eq. 'SELE') then
c
c SELECT
c Syntax : SELECT FILE             Select a file from the list
c          SELECT DESCRIPTION      Select a description from the list
c
	  call cli$get_Value('p1',line)
	  if(line(1:1) .eq. 'F') then
	    nk = 0
	    call cli$get_value('p2',line,nk)
	    if(err_status) then
	      err_status = dix_dump_inter_sel_file(control,line(1:nk),
     1                          err_arg)
	      if(err_status) changed_fil = .true.
	    endif
	  elseif(line(1:1) .eq. 'D') then
	    nk = 0
	    call cli$get_Value('p2',line,nk)
	    if(%loc(file) .eq. 0) goto 71
	    if(file.top_des .eq. 0) goto 72
	    err_status = dix_dump_i_dir_des(control,file,
     1           dis.is_term,line(1:nk),err_arg,changed_des)
c	    if(err_Status) then
c	      if(changed) then
c	        file.cur_des = p_des_expanded
c	        changed_des = .true.
c	      endif
c	    endif
	  endif
c
	elseif(verb .eq. 'FIND') then
c
c FIND
c Syntax FIND searchstring[/rewind]
c Find a record that contains the specified data
c
	  if(%loc(file) .eq. 0) goto 71
	  nk = 0
	  call cli$get_Value('p1',line,nk)
	  if(nk .gt. 0) then	  
	    control.sear = line(1:nk)
	    control.nk_sear = min(nk,len(control.sear))
	  else
	    if(control.nk_sear .eq. 0) then
	      err_status = %loc(dix_msg_noseastr)
	      goto 10
	    end if
	  end if
	  control.rewind = cli$present('REWIND')
	  call dix_main_search_file(control,file,.false.)
	  changed_rec = .true.
	else
	  goto 70
	end if
c
c All verbs done
c check if we need to recompute the description (we changed 
c    some part of the record) or not
c
	if(iterm .eq. 0) then		!Exit terminator
	  if(changed_rec) then
	    call dix_des_expand_all(control,file)
	    goto 8	!changed record, so reeexpand des
	  endif
	  if(changed_des) goto 5	!changed desc, so signal and and expa
	  if(changed_fil) goto 1	!changed file, do all
	  goto 10
	endif
c
	goto 90				!return to caller
c
c Invalid command
c
70	err_arg = totline(1:nk_tot)
	err_status = %loc(dix_msg_illcomm)
	goto 10
c 
c Command that needed a file open
c  and currently no file open gets here
c
71	err_status = %loc(dix_msg_nofilopen)	  
	goto 10
c
c Command that need a descriptor and no one is present
c  goto here
c
72	err_status = %loc(dix_msg_nodescr)
	goto 10
c
c Command that can only be executed in a comand file
c
73	err_arg = verb
	err_status = %loc(dix_msg_notonterm)
	goto 10
c
c We are not in modify mode
c
75	err_status = %loc(dix_msg_notinmod)
	goto 10
c
c Here if we run into a ENDx and no structure open
c  this can only happen with goto/gosub
c
76	err_status = %loc(dix_msg_illends)
	err_arg = verb
	goto 10
c
c Here if we run into an ENDx and the open structure
c  is not the expected one
c  this can only happen with goto/gosub
c
77	err_status = %loc(dix_msg_illends1)
	err_arg = struct_level.ptrs.begin_verb//' '//verb
	goto 10
c
90	istat = 1
	call dix_eval_free_value(val)
	call dix_eval_free_value(val1)
	dix_dump_interactive = istat
	return
	end
	function dix_dump_inter_get_symbol(name,symb,nk_symb,err_arg)
	implicit none
c
c Get a symbol . If present check the syntax
c
	character*(*) name	!:i: the CLI name
	character*(*) symb	!:o: the value
	integer*4 nk_symb	!:o: the length of the symbol
	character*(*) err_arg	!:o: the error argument (symbol name)
	integer*4 dix_dump_inter_get_symbol	!:f: function result
c
	integer*4 istat
	integer*4 dix_util_check_name
c
	istat = 1
	nk_symb = 0
	call cli$get_value(name,symb,nk_symb)
	if(nk_symb .gt. 0) then
	  istat = dix_util_check_name(symb(1:nk_symb))
	  if(.not. istat) err_arg = symb(1:nk_symb)
	else
	  istat = 1
	endif
	dix_dump_inter_get_symbol = istat
	return
	end
	subroutine dix_dump_file_set(flag,flagasc)
	implicit none
c
c Set a flag depending on a positional qualifier
c
	logical*1 flag
	character*(*) flagasc
c
	integer*4 k
	integer*4 cli$present
	external cli$_present,cli$_negated
c
	k = cli$present(flagasc)
	if(k .eq. %loc(cli$_present)) flag = .true.
	if(k .eq. %loc(cli$_negated)) flag = .false.
	return
	end
	function dix_dump_i_dir_des(control,file,is_term,mask,err_arg,changed)
	implicit none
c
c Display a directory of descriptions
c And let the user select one (in interactive mode)
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:i: current file
	logical*4 is_term		!:i: are we on a terminal
	character*(*) mask		!:i: desciptor mask to select
	character*(*) err_arg		!:o: error argument
	logical changed			!:o: true if file.cur_des changed
	integer*4 dix_dump_i_dir_des	!:f: functionresult
c
	record /des_info/ des
	pointer (p_des,des)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	character*(max_line_length) line,tline
	character kar
	integer*4 k,width,nk,i_des,max_width,istat,save_ptr
c
	logical*4 dix_util_get_nr
	integer*4 dix_dump_print_line
	logical str$match_wild
c
	external dix_msg_ambig
	external dix_msg_desnotm
c
	changed = .false.
	istat = 1
c
	if(mask .eq. ' ') then
c
c Compute current index
c
	  save_ptr = 0
	  p_des_expanded = file.top_des	  	  
	  do while(p_des_expanded .ne. 0)
	    p_des = des_expanded.p_des_info
	    if(str$match_wild(des.fnam(1:des.nk_fnam),mask))then
	      if(save_ptr .ne. 0) then
	        istat = %loc(dix_msg_ambig)
	      else
	        save_ptr = p_des_expanded
	      endif
	    endif
	    p_des_expanded = des_expanded.link.forw
	  end do
	  if(istat) then
	    if(save_ptr .ne. 0) then
	      changed = file.cur_des .ne. save_ptr
	      file.cur_des = save_ptr
	    else
	      istat = %loc(dix_msg_desnotm)
	    endif
	  endif
	  if(.not. istat) err_arg = mask
	else
c
c We had no mask, display all and let the user select
c
	  max_width = control.ncols - 13
	  width = 0
c
	  p_des_expanded = file.top_des
	  do while(p_des_expanded .ne. 0) 
	    p_des = des_Expanded.p_des_info
c
c Format the long way
c
	    call dix_des_display(control,des,line,nk,.false.)
	    if(nk .gt. max_width) then
c
c Too long, format the short way
c
	      call dix_des_display(control,des,line,nk,.true.)
	    endif
	    if(nk .gt. width) width = nk
	    p_des_expanded = des_expanded.link.forw
	  end do
c
c Print header
c
	  write(tline,1000) 'Idx','name','#line2'
1000	  format(a,a4,1x,a,1x,a6)
	  if(.not. dix_dump_print_line(control,0,tline(1:width+12))) goto 90
c
	  k = 0
	  i_des = 0
	  p_des_expanded = file.top_des
	  do while(p_des_expanded .ne. 0) 
	    p_des = des_expanded.p_des_info
	    kar = ' '
	    k = k + 1
	    if(p_des_expanded .eq. file.cur_des) then
	      i_des = k
	      kar = '*'
	    endif
	    call dix_des_display(control,des,line,nk,.false.)
	    if(nk .gt. width) then
	      call dix_des_display(control,des,line,nk,.true.)
	    endif
c
	    write(tline,1010) kar,k,line(1:width),des.nl_des
1010	    format(a,i4,':',a,1x,i6)
	    if(.not. dix_dump_print_line(control,0,tline(1:width+13))) goto 90
	    p_des_Expanded = des_expanded.link.forw
	  end do
c
c Check if at at a terminal, if not exit now
c
	  if(is_term) then
	    save_ptr = file.cur_des
c
	    if(dix_util_get_nr(k,i_des)) then
	      p_des_expanded = file.top_des
	      do k=1,i_des-1
	        p_des_expanded = des_expanded.link.forw
	      end do
	      file.cur_des = p_des_expanded
	    endif
	    changed = file.cur_des .ne. save_ptr
	  endif
	endif
90	dix_dump_i_dir_des = istat
	return
	end
	subroutine dix_dump_i_print_des(control,des)
	implicit none
c
c Print out description record from file/library
c
	include 'dix_interactive.inc'
	record /control/ control 	!:io: control structure
	record /des_info/ des		!i: des block
c
	character*(max_line_length) line
	integer*4 lun,nk
	logical*4 dix_dump_print_line
	integer*4 dix_lbr_get_module
        integer*4 memtab_read
c
	include '($lbrdef)'
c
	external dix_msg_libfnop
	external dix_msg_modnotf
	external dix_msg_desnopnd
c
c View original source
c print filename
c
	call dix_des_display(control,des,line,nk,.false.)
	if(.not. dix_dump_print_line(control,0,'Description file :'//
     1         line(1:nk))) goto 90
c
	if(des.in_library .ne. des_in_file) then
c
c From library
c
	  if(dix_lbr_get_module(control,des.fnam(1:des.nk_fnam),
     1            lun,nk,des.in_library)) then
	    do while(memtab_read(lun,nk,line))
	      if(.not. dix_dump_print_line(control,0,line(1:nk))) goto 8
	    end do
8	    call memtab_close(lun)
	  else
	    call dix_message(control,dix_msg_modnotf,des.fnam(1:des.nk_fnam))
	  endif
	else
c
c From file
c
	  call lib$get_lun(lun)
	  open(lun,file=des.fnam(1:des.nk_fnam),
     1         shared,readonly,err=88,status='old')
10	  read(lun,'(q,a)',end=80) nk,line
	  if(dix_dump_print_line(control,0,line(1:nk))) goto 10
80	  close(lun)
	  goto 89
88	  call dix_message(control,dix_msg_desnopnd)
89	  call lib$free_lun(lun)
	endif
c
90	return
	end
	function unsymbol(control,line,nk,des,err_arg)
	implicit none
c
c Unsymbol a line
c  replace all 'xxx' by its expansion
c
	include 'dix_interactive.inc'
c
	record /control/ control	!:io: the control block
	character*(*) line              !:io: the line 
	integer*4 nk                    !:io: length of the line
	record /des_info/ des		!:i: description
	character*(*) err_arg           !:o: error argument
	integer*4 unsymbol		!:f: function result
c
	record /value/ val
c
	integer*4 k,l,bpos,istat,ival
	logical in_quote,is_symbol
	logical dix_eval_expression
	external dix_msg_overflow
c
	character*(max_line_length) tline
	integer*4 nkt
c
	call dix_eval_init_value(val)
c
c
	in_quote = .false.
	k = 1
	do while(k .le. nk)
c
c Go find a ' ' pair
c
	  if(line(k:k) .eq. '"') in_quote = .not. in_quote
	  if(line(k:k) .eq. '''') then
	    bpos = k
	    if(in_quote) then
	      if(k .eq. nk) goto 90
	      k = k + 1
	      if(line(k:k) .ne. '''') goto 20
	    endif
c
c We have a leading quote, now search for trailing one
c
	    l = k + 1
	    do while (l .le. nk)
	      if(line(l:l) .eq. '''') then
c
c Got trailing quote, see if between is symbol
c
	        call str$upcase(tline,line(k+1:l-1))
	        nkt = l-1 - k
	        if(%loc(des) .eq. 0) then
	          istat = dix_eval_expression(control,tline(1:nkt),val,
     1              .false.,err_arg,.false.,is_symbol)
	        else
	          istat = dix_eval_expression(control,tline(:nkt),val,
     1                 .false.,err_arg,.false.,is_symbol)
	        endif
	        if(.not. istat) goto 90	         
c
c Make ascii, and replace in line
c
	        call dix_con_value_intasc(control,val,tline,nkt,.false.)
	        ival = nk + nkt - (l-bpos+1)
	        if(ival .gt. len(line)) then
	          istat = %loc(dix_msg_overflow)
	          err_arg = line(k+1:l-1)
	          goto 90
	        endif
	        line = line(1:bpos-1)//tline(1:nkt)//line(l+1:)
	        nk = nk + nkt - (l-bpos+1)
c
c Goon after substitution
c
	        k = bpos-1 + nkt
	        goto 20
	      endif
	      l = l + 1
	    end do
c
c No trailing quote found, skip
c
	    goto 90	    
	  endif
20	  k = k+ 1
	end do
c	write(*,*) 'Translated '//line(1:nk)
	istat = 1
90	call dix_eval_free_value(val)
	unsymbol = istat
	return
	end
	subroutine unspace(ascdat,nk_data)
	implicit none
c
c Remove all double spaces by one space (Except in " " string)
c
	character*(*) ascdat	!:io: the text string
	integer*4 nk_data	!:io: length of the line
c
	logical in_quote
	integer*4 k,n_out
c
	n_out = 0
	in_quote = .false.
	do k=1,nk_data
	  if(ascdat(k:k) .eq. '"') then
	    in_quote = .not. in_quote
	  else
	    if(.not. in_quote) then
	      if(ascdat(k:k) .eq. ' ') goto 10
	    endif
	  endif
	  n_out = n_out + 1
	  ascdat(n_out:n_out) = ascdat(k:k)
10	end do
	nk_data = n_out
	return
	end
	subroutine dix_dump_show_symbols(control,pattern,hex,all,full)
	implicit none
c
c Show all symbols
c
	include 'dix_interactive.inc'
c
	record /control/ control	!:io: the control structure
	character*(*) pattern		!:i: the string pattern
	logical*4 hex			!:i: display in hex ?
	logical all		!dispay all symbols (specials too)
	logical full			!:i: display all info of symbol
c
	character*(max_str_len) tline
	integer*4 nk,nk_pat,context,level,nkw
	record /value/ value
	logical dix_dump_print_line
c
	logical str$match_wild
	logical dix_symbol_enumerate
c	logical dix_symbol_print_full
c
	integer*4 ptr
c
	call dix_eval_init_value(value)
	nk_pat = len(pattern)
c
c Go through all symbols
c 
	context = 0
	do while(dix_symbol_enumerate(control,value,tline,nk,
     1              context,all,level,ptr,full))
c
	  if(nk_pat .eq. 0 .or. str$match_wild(
     1             tline(1:nk),pattern)) then
c	    
c Pattern matches
c
	    if(full) then
	      call dix_append(nk,tline,'(')
	      call dix_symbol_type(value,tline(nk+1:),nkw,.true.,.false.)
	      nk = nk + nkw
	      call dix_append(nk,tline,',Level=')
	      call dix_symbol_levelasc(level,tline(nk+1:),nkw)
	      nk = nk + nkw
	      call dix_append(nk,tline,')')
	    endif
	    call dix_append(nk,tline,'=')
c
c Ans the value
c
	    if(value.type .eq. symb_typ_char) call dix_append(nk,tline,'"')
	    call dix_con_value_intasc(control,value,tline(nk+1:),nkw,hex)
	    nk = nk + nkw	    
	    if(value.type .eq. symb_typ_char) call dix_append(nk,tline,'"')
	    if(.not. dix_dump_print_line(control,0,tline(1:nk))) goto 90
	  endif
	end do
90	call dix_eval_free_value(value)
	return
	end
	subroutine set_message(control)
	implicit none
c
c Set message flags
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control structure
c
	integer*4 k,istat
c
	logical cli$present
	external cli$_present
	external cli$_negated
c
	k = control.msgmask
	if(cli$present('all'))      k= 15
	if(cli$present('none'))     k= 0
	istat = cli$present('text')    
	if(istat .eq. %loc(cli$_present)) k = k  .or.  1
	if(istat .eq. %loc(cli$_negated)) k = k .and. 14
c
	istat = cli$present('ident')   
	if(istat .eq. %loc(cli$_present)) k = k  .or.  2
	if(istat .eq. %loc(cli$_negated)) k = k .and. 13
c
	istat = cli$present('severity')
	if(istat .eq. %loc(cli$_present)) k = k  .or.  4
	if(istat .eq. %loc(cli$_negated)) k = k .and. 11
c
	istat = cli$present('facility')
	if(istat .eq. %loc(cli$_present)) k = k  .or.  8
	if(istat .eq. %loc(cli$_negated)) k = k .and.  7
c
	control.msgmask = k
	return
	end
c
	subroutine dix_inter_conv_msg(msgmask,line,nk)
	implicit none
c
c Convert message flags to ascii
c
	integer*4 msgmask	!:i: the message flags
	character*(*) line	!:o: the text
	integer*4 nk		!:o: length of line
c
	nk = 0
	if(msgmask .eq. 15 .or. msgmask .eq. 0) then
	  line = '/ALL'
	  nk = 4
	else
	  nk = 0
	  if(btest(msgmask,0)) call dix_append(nk,line,'/TEXT')
	  if(btest(msgmask,0)) call dix_append(nk,line,'/IDENT')
	  if(btest(msgmask,0)) call dix_append(nk,line,'/SEVERITY')
	  if(btest(msgmask,0)) call dix_append(nk,line,'/FACILITY')
	endif
	return
	end
	function dix_inter_read_line(control,totline,nk_tot,
     1               ototline,onk_tot,
     1               quiet,des,err_arg,ptrs,line_level)
	implicit none
c
c Read one complete line
c return 0 for eof
c        lower bit set for all oke
c        lower bit clear for error
c
	include 'dix_interactive.inc'
	record /control/ control        !:i: control structure
	integer*4 nk_tot		!:o: line length
	character*(*) totline		!:o: line read
	integer*4 onk_tot
	character*(*) ototline
	logical quiet			!:i: quiet on endwhile/.. search
	record /des_info/ des
	character*(*) err_arg
	record /struct_pointers/ ptrs	!:o: info for loop constructs
	integer*4 line_level		!:o: the line level
	logical dix_inter_read_line	!:f: errstatus
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	character*(max_line_length) line
	character*(max_short_line_length) prompt,nrasc
	integer*4 nk,nk_pr,istat,pos,nk_nrasc
	logical cont_line
c
c
	integer*4 smg$read_composed_line
	integer*4 memtab_read
	integer*4 memtab_read_level
	logical dix_util_remove_comment
	external dix_msg_openquote
	logical unsymbol
c
	p_file_level = control.cur_level
5	nk_tot = 0
c
	cont_line = .false.
10	if(file_level.is_term) then
c
c Terminal input, let SMG do it (recall buffer enabled)
c
	  nk_pr = control.nk_prompt
	  prompt= control.prompt
	  if(control.depth .eq. 1) then
	    nk_nrasc = 0
	  else
	    call sys$fao('_!UL',nk_nrasc,nrasc,%val(control.depth-1))
	  endif
c
c if we find a #, replace if by the nrasc part
c
	  pos = index(prompt,'#')
	  if(pos .gt. 0) then
	    prompt = prompt(1:pos-1)//nrasc(1:nk_nrasc)//prompt(pos+1:nk_pr)
	    nk_pr = nk_pr + nk_nrasc - 1
	  endif
c
	  if(cont_line) then
	    prompt = '_'//prompt
	    nk_pr  =  nk_pr + 1
	  endif
	  line_level = 0
	  control.control_c_seen  = .false.
	  istat = smg$read_composed_line(file_level.lun,
     1              control.keytable_id,line,
     1              prompt(1:nk_pr),nk,,control.input_flags)
	  if(.not. istat) goto 80		!return eof
	else	!is_term
c
c Read a line from the file, let memtab handle it
c it this case , check for control_c to abort
c
	  if(cont_line) then
	    istat = memtab_read(file_level.lun,nk,line)
	    pos = 0
	  else
	    istat = memtab_read_level(file_level.lun,
     1                    nk,line,line_level,pos,
     1                    sizeof(ptrs),ptrs)
	  endif
	  if(istat) then
c
c Read from memtab oke
c
	    if(.not. quiet) then
c
c Verify mode, print line
c
	      if(file_level.verify) 
     1            call dix_dump_print_line(control,0,line(1:nk))
	    endif
	    if(pos .gt. 0) then
c
c Remove label 
c
	      line = line(pos:)
	      nk = nk - pos + 1
	    endif
	  else
c
c Read from memtab not oke
c
	    goto 80
	  endif		!if istat
	endif		!is_term
c
c Now see if need to append to totline
c
	if(istat) then
c
c Find the first and the last significant (non-blank) char
c
	  if(.not. dix_util_remove_comment(nk,line)) then
	    istat = %loc(dix_msg_openquote)
	    goto 90
	  endif
c
c See if line is a continuation line (- at the end)
c
	  totline(nk_tot+1:) = line(1:nk)
	  nk_tot = nk_tot + nk 
	  if(totline(nk_tot:nk_tot) .eq. '-') then
	    nk_tot = nk_tot - 1
	    cont_line = .true.
	    goto 10
	  endif
c
c
c Now unsymbol the line
c
	  istat = unsymbol(control,totline,nk_tot,des,err_arg)
	  if(quiet) istat = 1		!ignore errors when quiet mode
c
c Make line decent, but keep original 
c  decent_line upcases, and this in not desired for deposit
c
	  onk_tot = nk_tot
	  ototline = totline
	  call dix_util_decent_line(nk_tot,totline)
c
	endif
	call dix_inter_massage(totline,nk_tot)
	if(nk_tot .eq. 0) goto 5
	goto 90
c
c Eof reached
c
80	istat = 0
c
90	dix_inter_read_line = istat
	return
	end
	function dix_inter_get_label(line,label,pos)
	implicit none
c
c See if the first part of the line contains a label
c  if so return the text, set pos to just beyond this label 
c
	character*(*) line	!:i: the line
	character*(*) label	!:o: the label
	integer*4 pos		!:o: pos ion line just beyond the label :
	logical dix_inter_get_label	!:f: true if label found
c
	integer*4 nk,ipos
	character kar
	logical dix_util_legal_char
c
c
	label = ' '
	pos   = 0
c
c Now skip all letters/digits
c
	dix_inter_get_label = .false.
	nk = len(line)
	ipos  = 1
	do while(ipos .le. nk) 
	  kar = line(ipos:ipos)
	  if(dix_util_legal_char(kar,ipos)) then
	    ipos = ipos + 1
	  else
c
c No longer a legal char, now if it is a : then we have a label
c
	    if(kar .eq. ':') then
	      dix_inter_get_label = .true.
c
c Got label, now skip it
c
	      call str$upcase(label,line(1:ipos-1))
	      pos = ipos + 1	!set pointer to just beyond the :
	    endif
	    ipos = nk + 1	!to stop the do loop
	  endif
	end do
	return
	end
c	            
	subroutine dix_inter_signal(control,err_status,err_arg,
     1        line,nk,on_command,file_level,from_read)
	implicit none
c 
c Signal error messages, and handle on_x and /err= and /end=
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control structure
	integer*4 err_status		!:i: error status
	character*(*) err_arg		!:io: err argument
	character*(*) line		!:o: returned line (if on_? found)
	integer*4 nk			!:o: length of line
	record /file_level/ file_level  !:i: current file info
	logical from_read		!:i: did the error come from a read?
	logical on_command
c
	include '($stsdef)'
	include '($rmsdef)'
c
	integer*4 err_sev,nk_arg
c
	integer*4 dix_util_get_len_fu
	external dix_msg_ctrlcseen
c
	if(control.control_c_seen) then
	  call dix_message(control,dix_msg_ctrlcseen)
	  err_status = %loc(dix_msg_ctrlcseen)
	  control.control_c_seen  = .false.
	endif
c
c Define the symbols $STATUS , $SEVERITY
c
	err_sev = iand(err_status,sts$m_severity)
	if(.not. on_command) then
	  call dix_symbol_add_int(control,'$STATUS',err_status,err_arg)
	  call dix_symbol_add_int(control,'$SEVERITY',err_sev,err_arg)
	endif
c
	nk = 0
c
	if(err_status .eq. %loc(dix_msg_ctrlcseen)) then
	  if(.not. file_level.is_term) then
	    line = file_level.on_controlc_line
	    nk   = file_level.nk_on_c
	    if(nk .eq. 0) call sys$fao('EXIT !UL',nk,line,%val(err_status))
	    goto 90
	  endif
	endif
c
	if(.not. err_status) then
c
c Check for error_label or eof_label
c  if present, use it
c
	  if(.not. file_level.is_term) then
	    if(err_status .eq. rms$_eof) then
	      if(control.eof_label .ne. ' ') then
	        line = 'GOTO '//control.eof_label
	        nk = dix_util_get_len_fu(line)
	        on_command = .true.
	       goto 90
	      end if
	    endif	  
	    if(control.error_label .ne. ' ') then
	      line = 'GOTO '//control.error_label
	      nk = dix_util_get_len_fu(line)
	      on_command = .true.
	      goto 90
	    end if
	  endif		!is_term
c
c If from_read is true, the eror is from a real command
c if from_read is false, the error is created here on a higher level
c  so the message must not be repeated here
c Now translate to text and allow the (optional) parameter to
c be included.
c if the sts$m_inhib_msg is set, do not print the message
c
	  if(from_read .and. (err_status .and. sts$m_inhib_msg) .eq. 0) then
	    nk_arg = dix_util_get_len_fu(err_arg)
	    call dix_message(control,%val(err_status),err_arg(1:nk_arg))
          endif
c
c Check on serverity (severe, error or warning)
c
	  if(.not. file_level.is_term) then
c
c Not in terminal mode (we are using a file)
c check if set on is active
c
	    if(file_level.on_mode) then
c
c Yes , now see if err_sev >= on_level
c
	      on_command = .true.
	      if(err_sev .ge. file_level.on_level) then
c
c Yes, now return the line
c
	        line = file_level.on_line
	        nk   = file_level.nk_on
	        file_level.nk_on = 0
	        if(nk .eq. 0 .and. err_sev .gt. sts$k_warning) then
c
c Not found, return exit (if not warning)
c
	          nk = 0
	          call sys$fao('EXIT !UL',nk,line,%val(err_status))
	        endif	!default error action "exit status"
	      endif     !status >= level
	    endif		!on mode active
	  endif		!processing a terminal
	endif		!err_status
c
c Exit, clear all error info
c
90	err_arg             = ' '
	err_status          = 1
	control.error_label = ' '
	control.eof_label   = ' '
	return
	end
	function dix_dump_i_show_des(control,file,des)	    
	implicit none
c
c Show some descriptions
c
	include 'dix_interactive.inc'
	record /control/ control
	record /file_info/ file
	record /des_info/ des
	integer*4 dix_dump_i_show_des
c
c Three options
c  show des        display current description
c  show des/file   show all descriptions of this file
c  show des/loaded show all descriptions loaded (possible in other files)
c  show des/all    show all descriptions in the library
c  On all commands you can have
c   /full          Show the contents 
c   /source        Show the descriptions from the source
c
	integer*4 istat,lun_memtab,nk,lun,where,nk_mask,nk_wh
	character*(max_line_length) line,mask
	logical full,source
	character*(max_line_length) whasc
c
	integer*4 memtab_read
	integer*4 dix_dump_print_line
	integer*4 dix_dump_i_show_des_1
	logical dix_lbr_get_list
	logical dix_lbr_get_module
c
	external dix_msg_nodescr
	external dix_msg_nolibopen
	external dix_msg_modnotf
	external dix_msg_nofilopen
	logical cli$present
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_info/ des_info
	pointer (p_des_info, des_info)
c
	full   = cli$present('full')
	source = cli$present('source')
	if(source) full = .true.
c
	istat = %loc(dix_msg_nofilopen)	  
	if(cli$present('file')) then
c
c Show the descriptions connected to the file
c
	  if(%loc(file) .eq. 0) goto 90
	  if(file.top_des .eq. 0) goto 72
	  p_des_expanded = file.top_des
	  istat = 1
	  do while(istat .and. p_des_expanded .ne. 0)
	    istat = dix_dump_i_show_des_1(control,
     1             %val(des_expanded.p_des_info),full,source)
	    p_des_expanded = des_expanded.link.forw
	  end do
	elseif(cli$present('loaded')) then
c
c Show all loaded descriptions (for all files)
c
	  if(control.top_descr .eq. 0) goto 72
	  p_des_info = control.top_descr
	  istat = 1
	  do while(istat .and. p_des_info .ne. 0)
	    istat = dix_dump_i_show_des_1(control,des_info,full,source)
	    p_des_info = des_info.link.forw
	  end do
	elseif(cli$present('all')) then
c
c Show the defined descriptions for the libraries
c
	  if(control.nk_syslib .eq. 0 .and. control.nk_userlib .eq. 0) then
	    istat = %loc(dix_msg_nolibopen)
	  else
	    call cli$get_value('p2',mask,nk_mask)
	    if(nk_mask .eq. 0) then
	      mask = '*.*'
	      nk_mask = 3
	    endif
	    where = des_in_userlib
	    whasc = 'USER-library = '//
     1          control.userlib_name(1:control.nk_userlib)
	    nk_wh = 15 + control.nk_userlib
10	    if(dix_lbr_get_list(control,lun_memtab,mask(1:nk_mask),
     1                where,.true.)) then
	      istat = dix_dump_print_line(control,0,'Contents of '//
     1               whasc(1:nk_wh))
	      call memtab_rewind(lun_memtab)
	      do while(istat .and. memtab_read(lun_memtab,nk,line))
	        istat = dix_dump_print_line(control,2,line(1:nk))
	        if(full) then
	          if(dix_lbr_get_module(control,line(1:nk),lun,nk,where)) then
	            do while(istat .and. memtab_read(lun,nk,line))
	              istat = dix_dump_print_line(control,0,line(1:nk))
	            end do
	            call memtab_close(lun)
	          else
	            call dix_message(control,dix_msg_modnotf,line(1:nk))
	          endif
	        endif
	      end do
	      call memtab_close(lun_memtab)
	    endif
	    if(where .eq. des_in_userlib) then
	      where = des_in_syslib
	      whasc = 'SYSTEM-library = '//
     1          control.syslib_name(1:control.nk_syslib)
	      nk_wh = 15 + control.nk_syslib
	      goto 10
	    endif
	  endif
	else
c
c View current description
c
	  if(%loc(file) .eq. 0) goto 90
	  if(file.top_des .eq. 0) then
	    istat = %loc(dix_msg_nodescr)
	  else
	    istat = dix_dump_i_show_des_1(control,des,full,source)
	  endif
	endif
	goto 90
72	istat = %loc(dix_msg_nodescr)
90	dix_dump_i_show_des = istat
	return
	end
	function dix_dump_i_show_des_1(control,des,full,source)
	implicit none
c
c Show current desciption
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control structure
	record /des_info/ des		!:i: des info
	logical full			!:i: full display
	logical source			!:i: from the source?
	integer*4 dix_dump_i_show_des_1
c
	character*(max_line_length) line
c
	integer*4 istat,nk
	integer*4 dix_dump_print_line	
c
c Get module name
c
	call dix_des_display(control,des,line,nk,.false.)
	istat = dix_dump_print_line(control,0,'Description : '//line(1:nk))
	if(.not. istat) goto 90
c
	if(full) then
	  if(source) then
c
c View description from source file/module
c
	    call dix_dump_i_print_des(control,des)
	  else
c
c View  description/parameters from internal data
c
	    call dix_dump_print_par(control,des.n_par,
     1          %val(des.par_adr),'*',.false.)
	    call dix_dump_print_line_int(control,
     1              des.n_lin,%val(des.lin_adr))
	  endif
	end if
90	dix_dump_i_show_des_1 = istat
	return
	end
	subroutine dix_dump_i_set_paged(paged,is_term)
	implicit none
c
c Set paged mode
c
	logical paged		!:o: paged mode?
	logical is_term         !:i: are we on a terminal
c
	integer*4 istat
c
	integer cli$present
	external cli$_present
	external cli$_negated
c
	if(is_term) then
	  istat = cli$present('PAGED')
	  if(istat .eq. %loc(cli$_present)) paged = 1
	  if(istat .eq. %loc(cli$_negated)) paged = 0
	  if(cli$present('screen')) paged = 3
	else
	  paged = .false.
	endif
	return
	end
	function dix_dump_i_open_output(control,save_lun,save_paged,err_arg,
     1              is_term,file_level)
	implicit none
c
c Open a temp output file "/output=xxx"
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control structure 	
	integer*4 save_lun		!:o: original lun
	integer*4 save_paged		!:o: save paged mode
	character*(*) err_arg		!:o: error argument
	logical is_term			!:i: are we on terminal
	record /file_level/ file_level	!:io: command file level
	integer*4 dix_dump_i_open_output!:f: function result
c
	integer*4 istat,ios
	character*(max_line_length) line
	external dix_msg_filnotop
c
	istat = 1 
	call cli$get_value('output',line)
c
	save_paged = control.paged
	if(line .eq. ' ') then
c
c Output to teminal, check for /paged flag
c
	  save_lun = 0
	  ios = 0
	  call dix_dump_i_set_paged(control.paged,is_term)
	  if(control.paged .eq. 3) 
     1       call memtab_init(control.smg_window,'DIX_INTER_MEM')
	else
c
c To file
c
	  save_lun = file_level.lun_out
	  control.paged = 0
	  call lib$get_lun(file_level.lun_out)
	  open(file_level.lun_out,file=line,status='new',
     1          carriagecontrol='list',iostat=ios)
c
c Show description(s)
c
	  if(ios .ne. 0) then
	    call lib$free_lun(file_level.lun_out)
	    file_level.lun_out = save_lun
	    save_lun = 0
	    istat = %loc(dix_msg_filnotop)
	    err_arg = line
	  endif
	endif
	dix_dump_i_open_output = istat
	return
	end
	subroutine dix_dump_i_close_output(control,save_lun,save_paged,
     1                      file_level,header)
	implicit none
c
c  Close temporary output file
c  
	include 'dix_interactive.inc'
	record /control/ control        !:io: control structure
	integer*4 save_lun		!:i: saved orig file lun
	integer*4 save_paged		!:io: saved paged mode
	record /file_level/ file_level  !:i: command_file level
	character*(*) header
c
	integer*4 nlines
c
	if(control.paged .eq. 3) then
	  call memtab_get_nlines(control.smg_window,nlines)
	  if(nlines .gt. 0) then
	    call smg$erase_pasteboard(control.paste_id)
	    call dix_smg_view_memtab(control,control.smg_window,
     1            header,22,.false.)
	  endif
	  call memtab_close(control.smg_window)
	  control.smg_window = 0
	elseif(save_lun .ne. 0) then
	  close (file_level.lun_out)
	  call lib$free_lun(file_level.lun_out)
	  file_level.lun_out = save_lun
	  save_lun = 0
	endif
	control.paged = save_paged
	return
	end
c
	function dix_inter_get_params(control,line,
     1             err_arg,is_call)
	implicit none
c
c Evaluate line for arguments for @ and CALL
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: the control sturcture
	character*(*) line		!:i: the input line with the expressions
	character*(*) err_arg		!:o: error argument
	logical is_call			!:i: is this a call or an @
	integer*4 dix_inter_get_params	!:f: the function result
c
	integer*4 nk,pos,istat,narg
	record /value/ val
	character kar
c
	character*(max_symbol_name_length) symbol,name
	integer*4 nk_symb,nk_name,type
	logical is_symbol
c
	external dix_msg_toompar
	external dix_msg_toomuch
	external dix_msg_toomanarg
	external dix_msg_mustbesymb
	external dix_msg_invtype
	external dix_msg_argcount
	external dix_msg_wrtypstr
	external dix_msg_undecl
	integer*4 dix_eval_expression1
	logical cli$get_value
	logical cli$present
	logical dix_util_check_name
	integer*4 dix_symbol_set_alias
c
	call dix_eval_init_value(val)
	nk    = len(line)
	narg  = 0
	istat = 1
	kar   = char(0)
c
	do while(nk .gt. 0)
c
c Now evaluate the part of the line upto the ,
c First see if the expression ia a symbol, if so
c  we might alias the new name to this one
c
c We must decrement level for the evaluation phase, otherwise
c  symbols cannot be found
c	
	  control.depth = control.depth-1
	  istat = dix_eval_expression1(control,line(1:nk),val,
     1             .false.,err_arg,.false.,kar,pos,is_symbol)
	  control.depth = control.depth+1
	  if(.not. istat) goto 90
	  if(is_symbol) then
	    if(kar .eq. char(0)) then
	      nk_symb = pos-1
	    else
	      nk_symb = pos-2
	    endif
	    symbol = line(1:nk_symb)
	  endif
c
c One more argument
c
	  narg = narg + 1
c
	  if(is_call) then
c
c Check if there was an argument name on the subroutine line
c
	    call cli$get_value('p1',name,nk_name)
C
	    if(nk_name .eq. 0) then
c
c There are more expressions defined than there are variables
c Not allowed in strict mode
c
	      if(iand(control.strict_mode,strict_declaration).ne.0) goto 70
	    endif
c
	    type = symb_typ_none
	    if(cli$present('REAL'     )) type = symb_typ_real
	    if(cli$present('INTEGER'  )) type = symb_typ_int
	    if(cli$present('DATE'     )) type = symb_typ_date
	    if(cli$present('LOGICAL'  )) type = symb_typ_log
	    if(cli$present('CHARACTER')) type = symb_typ_char
	    if(iand(control.strict_mode,strict_typing) .ne. 0) then
c
c Strict typing
c
	      if(type .eq. symb_typ_none) goto 71	!no type
	      if(type .ne. val.type) goto 72		!wrong type
	      type = val.type	!take type of expression
	    endif
c
c Must be valid symbolname
c
	    if(cli$present('symbol')) then
c
c We want the local var to be an alias of the original expression
c  this can only be true if the expression consists of a symbol only
c
	      if(.not. is_symbol) goto 73
	    else
c
c We do not want the alias entered
c
	      is_symbol = .false.
	    endif
c
c Check if name is a valid symbol name
c
	    istat = dix_util_check_name(name(1:nk_name))
	    if(.not. istat) goto 80	!invalid symbol name
	  else
c
c For @ the parameters are called p'n'
c
	    nk_name = 0
	  endif
	  if(nk_name .eq. 0) then
c
c No name or illegal name
c
	    if(iand(control.strict_mode,strict_declaration).ne.0) goto 70
	    call sys$fao('P!UL',nk_name,name,%val(narg))
	    type = symb_typ_none
	  endif
c
c Define the (local) symbol
c
	  call dix_symbol_add_level(control,name(1:nk_name),val,err_arg,
     1               type .ne. symb_typ_none,' ')
	  if(is_symbol) then
	    istat = dix_symbol_set_alias(control,symbol(1:nk_symb),
     1                name(1:nk_name),err_arg)
	    if(.not. istat) goto 90
	  endif
c
c Skip the part upto and including the ,
c
	  nk = nk - pos + 1	  	  
	  line = line(pos:)
	end do
c
c Now ther may not be anything left on the line
c
	if(kar .ne. char(0)) then
	  istat = %loc(dix_msg_toomuch)
	  err_arg = kar
	  goto 90
	endif
c
c There are no more expressions.
c Now define the $arguments variable
c
	val.ival = narg
	val.type = symb_typ_int 
	call dix_symbol_add_level(control,'$NRARGS',val,err_arg,.true.,' ')
c
	if(is_call) then
c
c Check if there are more vars than expressions
c
	  do while(cli$get_value('p1',name,nk_name))
	    if(iand(control.strict_mode,strict_declaration) .ne. 0) goto 70
	    if(cli$present('symbol')) then
c
c We want the local var to be an alias of the original expression
c  this can only be true if the expression consists of a symbol only
c  and it must exist
c
	      goto 73
	    endif
	    val.type = symb_typ_none
	    if(cli$present('REAL'     )) val.type = symb_typ_real
	    if(cli$present('INTEGER'  )) val.type = symb_typ_int
	    if(cli$present('DATE'     )) val.type = symb_typ_date
	    if(cli$present('LOGICAL'  )) val.type = symb_typ_log
	    if(cli$present('CHARACTER')) val.type = symb_typ_char
	    if(iand(control.strict_mode,strict_typing) .ne. 0) then
	      if(val.type .eq. symb_typ_none) goto 71
	    endif
	    call dix_symbol_default(val)
	    call dix_symbol_add_level(control,name(1:nk_name),val,err_arg,
     1              val.type .ne. symb_typ_none,' ')
	  end do
	endif
	err_arg = line(1:nk)
	goto 90
70	istat = %loc(dix_msg_argcount)
	goto 80
71	istat = %loc(dix_msg_undecl)
	goto 80
72	istat = %loc(dix_msg_wrtypstr)
	goto 80
73	istat = %loc(dix_msg_mustbesymb)
80	err_arg = name(1:nk_name)
c
90	call dix_eval_free_value(val)
	dix_inter_get_params = istat
	return
	end
	subroutine dix_inter_open_struct(file_level,ptrs)
	implicit none
c
c Open a structure (for/while...etc..)
c
        include 'dix_interactive.inc'
	record /file_level/ file_level		!:io: command file structure
	record /struct_pointers/ ptrs		!:i: the line pointers
c
	record /struct_level/ struct_level
	pointer (p_struct_level,struct_level)
c
c Allocate a new structure
c
	call get_vm(sizeof(struct_level),p_struct_level,
     1                    file_level.zone_level)
c	
c We have a new one, now link in
c
	call dix_inter_insert_link(struct_level,file_level.top_struct,
     1        file_level.cur_struct,file_level.struct_level)
	struct_level.ptrs = ptrs
	return
	end
        subroutine dix_inter_close_struct(control,file_level)
        implicit none
c
c Close an open structure (for/while etc.)
c
        include 'dix_interactive.inc'
        record /control/ control		!:io: control,structure
	record /file_level/ file_level		!:io: commandfile level
c
	record /struct_level/ struct_level
	pointer (p_struct_level,struct_level)
c
c Delete all symbols for this level
c
        call dix_symbol_delete_level(control)
	p_struct_level = file_level.cur_struct
c
c remove it from the chain
c
	call dix_inter_remove_link(file_level.top_struct,
     1    file_level.cur_struct,file_level.struct_level)
c
c Now remove structure 
c	
	call free_vm(sizeof(struct_level),p_struct_level,
     1                 file_level.zone_level)
        return
        end
	function dix_inter_set_local(control,ascdat,nk,
     1             err_arg,def_symbtyp)
	implicit none
c
c Declare a local variable
c
	include 'dix_interactive.inc'
	record /control/ control		!:io: control structure
	character*(*) ascdat			!:i: the command line
	integer*4 nk				!:i: Length
	character*(*) err_arg			!:o: the error argument
	integer*4 def_symbtyp			!:i: default symboltype
	integer*4 dix_inter_set_local		!:f: function result
c
	character*(max_symbol_name_length) symbol
	record /value/ val
	character kar
	integer*4 k,pos,nk_symb,istat,symbtyp,l
	logical is_symbol
c
	integer*4 dix_util_check_name
	integer*4 dix_symbol_exists
	integer*4 dix_eval_expression1
	integer*4 dix_util_check_field
	integer*4 str$find_first_in_set
c
	external dix_msg_toomuch
	external dix_msg_invstype
	external dix_msg_symbdef
	external dix_msg_wrongtype
c
	call dix_eval_init_value(val)
	do while(nk .gt. 0)
c
c The string consists of value[,value...]
c where value is
c either 1.symbol[/type=symboltype]=expression
c  or    2.symbol[/type=symboltype]
c Now find the first occurrence of a /, an = or a ,
c
c
	  k = str$find_first_in_set(ascdat(1:nk),'/=,')
	  if(k .eq. 0) k = nk + 1
	  nk_symb  = k-1
	  symbol   = ascdat(1:nk_symb)
c
c Check if valid symbol name
c
	  istat = dix_util_check_name(symbol(1:nk_symb))
	  if(.not. istat) then
	    err_arg = symbol(1:nk_symb)
	    goto 90
	  endif
c
	  kar      = ascdat(k:k)
	  ascdat   = ascdat(k+1:nk)
	  nk       = nk - k 
c
c Now parse the type (if present)
c
	  symbtyp = def_symbtyp
	  if(kar .eq. '/') then
	    k = str$find_first_in_set(ascdat(1:nk),'=,')
	    if(k .eq. 0) k = nk+1
	    istat = dix_util_check_field(ascdat(1:k-1),
     1        'CHARACTER|INTEGER|REAL|LOGICAL|DATA',l)
	    if(.not. istat) then
	      istat = %loc(dix_msg_invstype)
	      err_arg = ascdat(1:k-1)
	      goto 90
	    endif
            if(ascdat(1:1) .eq. 'C') symbtyp = symb_typ_char
            if(ascdat(1:1) .eq. 'I') symbtyp = symb_typ_int
            if(ascdat(1:1) .eq. 'R') symbtyp = symb_typ_real
            if(ascdat(1:1) .eq. 'L') symbtyp = symb_typ_log
            if(ascdat(1:1) .eq. 'D') symbtyp = symb_typ_date
	    kar = ascdat(k:k)
	    ascdat = ascdat(k+1:nk)
	    nk = nk - k
	  endif
c
c Now check for the expression (the kar must be =)
c
	  if(kar .eq. '=') then
	    istat = dix_eval_expression1(control,ascdat(1:nk),val,
     1             .false.,err_arg,.false.,kar,pos,is_symbol)
	    if(.not. istat) goto 90
            if(kar .ne. char(0) .and. kar .ne. ',') then
              istat = %loc(dix_msg_toomuch)
              err_arg = kar
              goto 90
            endif
c
	    if(symbtyp .ne. symb_typ_none) then 
	      if(val.type .ne. symbtyp) then
	        istat = %loc(dix_msg_wrongtype)
	        err_arg = symbol(1:nk_symb)
	        goto 90
	      endif
	    endif
	    ascdat = ascdat(pos:nk)
	    nk = nk - pos + 1
	  else
	    val.type = symbtyp
	    call dix_symbol_default(val)
	  endif
c
c Now define the new symbol, only if it does not yet exists
c
	  if(.not. dix_symbol_exists(control,symbol(1:nk_symb))) then
	    call dix_symbol_add_level(control,symbol(1:nk_symb),val,err_arg,
     1          symbtyp .ne. symb_typ_none,' ')
	  endif
	end do
c
90	call dix_eval_free_value(val)
 	dix_inter_set_local = istat
	nk = 0
	return
	end	
	subroutine dix_inter_show_dis(control,dis)
	implicit none
	include 'dix_interactive.inc'
c
c Display default display params
c
	record /control/ control
	record /dis_pars/ dis
c
	character*(max_short_line_length) line
	character*(max_tf_asc_length) dix_util_tfas
c
	call dix_dump_print_line(control,0,'Default display mode')
	call dix_dump_print_line(control,0,
     1        '  Hex mode  : '//dix_util_tfas(dis.hex))
	line = 'Byte'
	if(dis.word .eq. 2) line = 'Word'
	if(dis.word .eq. 4) line = 'Longword'
	call dix_dump_print_line(control,0,
     1        '  Word size : '//line(1:8))
	call dix_dump_print_line(control,0,
     1        '  Offset    : '//dix_util_tfas(dis.number))
	call dix_dump_print_line(control,0,
     1        '  Hex Offset: '//dix_util_tfas(dis.number_hex))
	call dix_dump_print_line(control,0,
     1        '  Rawmode   : '//dix_util_tfas(dis.raw))
	call dix_dump_print_line(control,0,
     1        '  Compressed: '//dix_util_tfas(dis.compres))
	call dix_dump_print_line(control,0,
     1        '  Unsigned  : '//dix_util_tfas(dis.unsigned))
	return
	end
	subroutine dix_inter_set_display(dis)
	implicit none
	include 'dix_interactive.inc'
c
c Set default display params
c
	record /dis_pars/ dis
c
	character*(max_short_line_length) line
	integer*4 nk
c
	logical cli$get_value
c
	do while (cli$get_value('p2',line,nk))
          if(line(1:4) .eq. 'HEX') dis.hex     = .true.
          if(line(1:1) .eq. 'D'  ) dis.hex     = .false.
          if(line(1:6) .eq. 'NOHEX ') dis.hex  = .false.
          if(line(1:1) .eq. 'B'  ) dis.word    = 1
          if(line(1:1) .eq. 'W'  ) dis.word    = 2
          if(line(1:1) .eq. 'L'  ) dis.word    = 4
          if(line(1:2) .eq. 'O'  ) dis.number  = .true.
          if(line(1:3) .eq. 'NOO') dis.number  = .false.
          if(line(1:4) .eq. 'HEXO') dis.number_hex = .true.
          if(line(1:6) .eq. 'NOHEXO') dis.number_hex = .false.
          if(line(1:1) .eq. 'R'  ) dis.raw     = .true.
          if(line(1:3) .eq. 'NOR') dis.raw     = .false.
          if(line(1:1) .eq. 'C'  ) dis.compres = .true.
          if(line(1:3) .eq. 'NOC') dis.compres = .false.
          if(line(1:1) .eq. 'U'  ) dis.unsigned= .true.
          if(line(1:3) .eq. 'NOU') dis.unsigned= .false.
	end do
	return
	end
	subroutine dix_inter_massage(totline,nk_tot)
	implicit none
c
c Handle some special cases of input
c
	character*(*) totline
	integer*4 nk_tot
c	
	if(totline(1:1) .eq. '@') then
c
c Make @ command parsable to AT command
c
	  totline = 'AT '//totline(2:nk_tot)
	  nk_tot = nk_tot + 2
	endif
	if(totline(1:3) .eq. 'IF(') then
c
c Make sure there is a space between the IF and the (
c
	  totline = 'IF '//totline(3:nk_tot)
	  nk_tot = nk_tot + 1
	endif
	if(totline(1:4) .eq. 'END ') then
c
c Special END case, 
c  useful for END IF instead of ENDIF, END FOR and END WHILE
c
	  totline = totline(1:3)//totline(5:nk_tot)
	  nk_tot = nk_tot - 1
	endif
	return
	end
	function dix_dump_i_exam(control,dis,verb,err_arg,file_level)
	implicit none
c
c Examine some field value(s)
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	record /dis_pars/ dis           !:i: the display fields
	character*(*) verb		!:i: the verb exam/sear
	logical is_exam			!:i: search/examine flag
	character*(*) err_arg		!:o: error argument
	record /file_level/ file_level	!:i: the command file 
	integer*4 dix_dump_i_exam	!:f: function result
c
	record /file_info/ file	
	pointer (p_file,file)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_info/ des_info
	pointer (p_des_info,des_info)
c
	character*(max_search_length) search,mask
	character*(max_line_length) line
	character*(max_line_length) file_mask,desc_mask
	character dis_typ
	integer*4 nk_search,nk_mask,istat,save_lun,save_paged,nk_l,nk
	integer*4 nk_fm,nk_dm
	logical displ_des,displ_recn,displ_recl,mark,unix,displ_recn1
	logical*4 org_raw,got_file
	record /dis_pars/ dis_work
c
	logical cli$present
	logical cli$get_value
	integer*4 dix_dump_i_open_output
	logical dix_util_match_string_wild
c
	external dix_msg_nofmatch
	external dix_msg_nofilopen
	external dix_msg_nodescr
c
	call cli$get_value('search',search,nk_search)
	unix = cli$present('unix')
c
c Check what the user wants to see
c
	is_exam = verb .eq. 'EXAM'
	dis_typ = 'R'					!record
	if(cli$present('ORIGINAL'  )) dis_typ = 'O'     !org record
	if(cli$present('SAVE_AREA' )) dis_typ = 'S'     !save buffer
	if(cli$present('VFC_BUFFER')) dis_typ = 'V'     !VFC buffer
c
	displ_des   = cli$present('DESCRIPTION')
	displ_recn1 = cli$present('recnumber')
	displ_recl  = cli$present('record_length')
c
c Set (temporary) display modes
c
	dis_work = dis
	call dix_dump_file_set(dis_work.hex,       'HEX')
	if(cli$present('decimal')) dis.hex = .false.
	call dix_dump_file_set(dis_work.number,    'NUMBER')
	call dix_dump_file_set(dis_work.number_hex,'NUMBER.HEX')
	call dix_dump_file_set(dis_work.raw,       'RAW')
	call dix_dump_file_set(dis_work.compres,   'COMPRESS')
	call dix_dump_file_set(dis_work.unsigned,  'unsigned')
	org_raw = dis_work.raw	!save it
c
	if(control.is_term) then
	  mark = cli$present('MARK')
	else
	  mark = .false.
	endif
	if(cli$present('LONG')) dis_work.word = 4
	if(cli$present('WORD')) dis_work.word = 2
	if(cli$present('BYTE')) dis_work.word = 1
c
	nk_mask = 0
	nk_fm   = 0
	nk_dm   = 0
	if(is_exam) then
	  call cli$get_value('p1',mask,nk_mask)
	  if(dis_typ .eq. 'R' .or. dis_typ .eq. 'O') then
	    nk_fm = index(mask(1:nk_mask),'\')
	    if(nk_fm .gt. 0) then
	      file_mask = mask(1:nk_fm-1)
	      mask = mask(nk_fm+1:nk_mask)
	      nk_mask = nk_mask - nk_fm 
	      nk_fm = nk_fm - 1
	      nk_dm = index(mask(1:nk_mask),'\')
	      if(nk_dm .ne. 0) then
	        desc_mask = mask(1:nk_dm-1)
	        mask = mask(nk_dm+1:nk_mask)
	        nk_mask = nk_mask - nk_dm
	        nk_dm = nk_dm - 1
	      endif
	    endif
	  endif
	  line = mask(1:nk_mask)
	  nk_l = nk_mask
	  if(nk_search .gt. 0) then
	    line(nk_l+1:) = '/search='//search(1:nk_search)
	    nk_l = nk_l + 8 + nk_search
	  endif
	else
	  line = search(1:nk_search)
	  nk_l = nk_search
	endif
c
	istat = dix_dump_i_open_output(control,save_lun,save_paged,
     1                err_arg,dis.is_term,file_level)
	istat = 1
c
c set pointer correctly
c
	got_file = .false.
	if(nk_fm .gt. 0) then
	  p_file = control.top_file
	else
	  p_file = control.cur_file
	endif
c
	if(p_file .eq. 0) goto 71
c
5	if(nk_fm .gt. 0) then
	  if(p_file .eq. 0) goto 90
	  nk = file.nk_handle
	  if(.not. dix_util_match_string_wild(file.handle(1:nk),
     1             file_mask(1:nk_fm),.false.,unix)) then
	    p_file = file.link.forw
	    goto 5
	  endif
	  call dix_dump_print_line(control,0,
     1          'File:'//file.fnam(1:file.nk_fnam))
	endif	    
c
	if(nk_dm .gt. 0) then
	   p_des_expanded = file.top_des
	else
	  p_des_expanded = file.cur_des
	  if(p_des_expanded .eq. 0) then
	    p_des_info = 0
	  else
	    p_des_info     = des_expanded.p_des_info
	  endif
 	end if
c
7	if(nk_dm .gt. 0) then
	  if(p_des_expanded .eq. 0) goto 50	!next file
	  if(.not. dix_util_match_string_wild(
     1           des_expanded.handle(1:des_expanded.nk_handle),
     1           desc_mask(1:nk_dm),.false.,unix)) then
	     p_des_expanded = des_expanded.link.forw
	     goto 7
	  endif
	  p_des_info = des_expanded.p_des_info
	  call dix_dump_print_line(control,0,
     1          'Description:'//des_info.fnam(1:des_info.nk_fnam))
	endif
c
	displ_recn = displ_recn1
	if(file.indexed .or. file.relative) displ_recn = .false.
	dis_work.raw = org_raw
	if(file.raw .or. p_des_expanded .eq. 0) dis_work.raw = .true.
c
	if(istat) then
	  if(dis_typ .eq. 'O') then
	    call dix_dump_displ(control,
     1           file.data.data_sav,file.data.nb_sav,des_info,
     1           des_expanded,dis_work,
     1           displ_recl,displ_recn,file.rec_nr,displ_des,
     1           mask(1:nk_mask),search(1:nk_search),'Original record',
     1           .false.,file,unix)
	  elseif(dis_typ .eq. 'S') then
	    call dix_dump_displ(control,
     1           control.nb_save,control.save_area,des_info,
     1           des_expanded,dis_work,
     1           displ_recl,displ_recn,file.rec_nr,displ_des,
     1           mask(1:nk_mask),search(1:nk_search),'Save Area',
     1           .false.,file,unix)
	  elseif(dis_typ .eq. 'V') then
	    call dix_dump_displ(control,
     1           file.data.vfc_data,file.data.nb_vfc,des_info,
     1           des_expanded,dis_work,
     1           displ_recl,displ_recn,file.rec_nr,displ_des,
     1           mask(1:nk_mask),search(1:nk_search),'VFC Buffer',
     1           .false.,file,unix)
	  else
	    call dix_dump_displ(control,
     1           file.data.data_rec,file.data.nb_data,des_info,
     1           des_expanded,dis_work,
     1           displ_recl,displ_recn,file.rec_nr,displ_des,
     1           mask(1:nk_mask),search(1:nk_search),' ',
     1           mark,file,unix)
	  endif
	  if(control.linenr .eq. 0) then
	    istat = %loc(dix_msg_nofmatch)
	    err_arg = line(1:nk_l)
	  endif
	  call dix_dump_i_close_output(control,save_lun,
     1                             save_paged,file_level,
     1                             verb//' ' //line(1:nk_l))
	endif
	istat = 1
c
	if(nk_dm .ne. 0) then
	  p_des_expanded = des_expanded.link.forw
	  goto 7
	endif
c
50	if(nk_fm .gt. 0) then
	  p_file = file.link.forw
	  goto 5
	endif
	goto 90
c
c No file present
c
71	if(got_file) then
	  istat = 1
	else
	  istat = %loc(dix_msg_nofilopen)	  
	endif
	goto 90
c
90	dix_dump_i_exam = istat
	return
	end	
	subroutine dix_dump_displ(control,data,nb_data,des,des_expanded,
     1           dis,displ_recl,
     1           displ_recn,recordnumber,displ_des,
     1           mask,search,dat_typ,mark,file,unix)
	implicit none
c
c Display the contents of the fields
c  from 1: Record buffer   (Current record)
c       2: Paste buffer    (Data from the last CUT)
c       3: Original buffer (before changes to record)
c       4: VFC data        For some files with VFC data
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	byte data(*)			!:i: the data
	integer*4 nb_data		!:i: #bytes in data
	record /des_info/ des		!:i: description
	record /des_expanded/ des_expanded		!:i: description
	record /dis_pars/ dis		!:i: display data
	logical*4 displ_recl		!:i: display recordlength?
	logical*4 displ_recn		!:i: display record number?
	integer*4 recordnumber		!:i: the record number
	logical*4 displ_des		!:i: display descriptions too?
	character*(*) mask		!:i: mask for fieldnames
	character*(*) search            !:i: search for fieldvalues
	character*(*) dat_typ		!:i: the databuffer type
	logical mark			!:i: mark keys 
	logical unix			!:i: unix type of search
	record /file_info/ file		!:i: the file structure
c
	record /des_rec/ des_rec
c
        integer*4 n_bol
        integer*4 begpos_bol(10),endpos_bol(10)
c
	integer*4 nk_off,nk_min_1,k,nk1,offs,istat,nkar,max_len,bpos,nk_fol
	integer*4 kpl,epos,nk,nl,fldsiz,posasc,phase,endpos,pp,nfld_pr
	logical*4 set_bold
	character*(max_line_length) line,field_name
	character*(max_str_len) ascdat
c
	integer*4 dix_con_i4
	integer*4 dix_con_intasc
	logical*4 dix_util_find_string_wild
	logical*4 dix_util_match_string_wild
	logical*4 dix_dump_Print_line
	logical dix_rms_offset_in_key
	logical display_des
c
	external dix_msg_nomaskoff
	external dix_msg_nofldfnd
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	p_file_level = control.cur_level
c
	nl = 0
	nfld_pr = 0
c
c If dat_typ <> ' ' (record data), display which the data we print
c
	if(dat_typ .ne. ' ') then
	  call dix_dump_print_line(control,0,'Data from '//dat_typ)
	endif
c
	if(displ_recn) then
c
c Now display record number
c
	  nkar = 0
	  call dix_util_con_nr(recordnumber*8,.false.,line,nkar,
     1                  dis.number_hex)
	  if(dis.number_hex) then
	    line = '%X'//line(1:nkar)
	    nkar = nkar + 2
	  endif
	  call dix_dump_print_line(control,0,'%Recordnumber = '//line(1:nkar))
	endif
c
	if(displ_recl) then
c
c Now display record number
c
	  nkar = 0
	  call dix_util_con_nr(nb_data*8,.false.,line,nk_off,
     1           dis.number_hex .or. dis.hex)
	  if(dis.number_hex) then
	    line = '%X'//line(1:nkar)
	    nkar = nkar + 2
	  endif
	  call dix_dump_print_line(control,0,'%Recordlength = '//line(1:nkar))
	endif
c
c If recordnumber or recordnumber displayed and no mask, all is done
c
	if(displ_recl .or. displ_recn) then
	  if(len(mask) .eq. 0) goto 90
	endif
c
c Check for VFC data (only raw mode (or special DCL vfc mode))
c
	if(dat_typ(1:3) .eq. 'VFC' .and. nb_data .eq. 2) then
 	  call dix_con_vfc(data,line,nkar)
	  if(.not. dix_dump_print_line(control,0,line(1:nkar))) goto 90
	  goto 90
	endif
c
c Start displaying
c
	if(.not. dis.raw) then
c
c In interpreted mode
c
	  nk_off  = 0
	  if(dis.number) then
c
c Compute the size of the maximum byte offset
c
	    call dix_util_con_nr(nb_data*8,des.has_fields,
     1                     line,nk_off,dis.number_hex)
	  end if
c
c Go through all fields twice,
c the first time to compute the length of the name
c teh second time to print
c
	  nk_min_1 = 0	    
	  do phase=1,2
	   do k=1,des_expanded.n_des
	    call dix_des_get_des(des_expanded,k,des_rec,field_name)
	    if(.not. dis.compres .or. .not. des_rec.compressed) then
	     nk1 = des_rec.nam_len
c
c Check if display wanted on match on fieldname
c
	     if(len(mask) .eq. 0 .or. 
     1            dix_util_match_string_wild(field_name(1:nk1),mask,
     1             .false.,unix))then
c
c We have a field that must be printed
c
	      if(phase .eq. 1) then
c
c Just computing size of name field
c
	        if(des_rec.p_link_rec .ne. 0) nk1 = nk1 + 1
	        nk_min_1 = max(nk1,nk_min_1)
	        goto 31
	      endif
c
c Normal print
c
	      offs = des_rec.bit_offset/8
	      if(offs .lt. nb_data) then
c
c Convert data to text
c
	        istat = dix_con_intasc(nb_data-offs,des_rec,
     1                  data,ascdat,nkar,dis.hex,
     1                  max_len,.false.,control)
	        if(istat .or. .not. dis.compres) then
c
c If /search also , see if match on contents
c
	          if(len(search) .ne. 0) then
	            pp = dix_util_find_string_wild(ascdat(1:nkar),search,
     1                     endpos,.false.,unix)
	            if(pp .eq. 0) goto 31
	          end if
c
c Do display data, possibly in multiple lines
c
	          nk = 0
	          if(dis.number) then
	            call dix_util_con_nr(des_rec.bit_offset,des.has_fields,
     1                       line,nk_off,dis.number_hex)
	            nk = nk_off + 1
	            line(nk:nk) = '|'
	          end if
	          if(des_rec.p_link_rec .ne. 0) 
     1               field_name(nk_min_1:nk_min_1) = '>'
c
c See if we want the keyfields to be marked
c
	          if(file.indexed .and. mark) then
	            set_bold = dix_rms_offset_in_key(file,des_rec.bit_offset/8,
     1                                     des_rec.size/8)
	          else
	            set_bold = .false.
	          endif
	          nk_fol = nk + nk_min_1 + 2
	          if(set_bold) then
	            nk1 = des_rec.nam_len
	            line(nk+1:) = bold_seq//field_name(1:nk_min_1)//norm_seq
	            nk = nk_fol + len(bold_seq) + len(norm_seq)
	          else
	            line(nk+1:) = field_name(1:nk_min_1)
	            nk = nk_fol
	          endif
	          line(nk-1:nk-1) = '|'
	          bpos = 1
	          if(nkar .eq. 0) nkar = 1 		!at least one line
c
c Start printing the whole line
c
	          do while(bpos .le. nkar)
	            epos = min(bpos+control.ncols-nk_fol-2,nkar)
	            line(nk:) = ascdat(bpos:epos)
	            if(.not. dix_dump_print_line(control,0,
     1                     line(1:nk+epos-bpos))) goto 90
c     1                     line(1:control.ncols-1))) goto 90
	            nk = nk_fol
	            line = ' '
                    bpos = epos + 1
	          end do
	          nfld_pr = nfld_pr + 1
c
c If description display wanted, display description for this field
c
	          if(displ_des) then
	            if(.not. display_des(control,0,des_rec,0,4)) goto 90
	          endif
	        end if	!non blank data
	      end if	!offset still in record
	     end if	!Field name matches
	    endif	!compress matches
31	   end do       !Go through all fields
	  end do  	!phase=1,2
	  if(nfld_pr .eq. 0) call dix_message(control,dix_msg_nofldfnd)
	else
c
c Display raw
c
	  if(len(mask) .eq. 0) then
c
c Display raw the whole record
c
	    call dix_dump_file_raw(control,file,nb_data,data,dis,' ',
     1                 file_level.lun_out)
	  else
c
c Display line containing offset
c
	    call dix_dump_vars(control,dis,kpl,fldsiz,posasc)
	    if(dix_con_i4(mask,len(mask),offs,
     1               dis.number_hex,control,.false.)) then
	      call dix_dump_raw_line(control,offs,kpl,nb_data,data,dis,posasc,
     1                 begpos_bol,endpos_bol,n_bol,line,nkar,
     1                 fldsiz,file)   
	      call dix_dump_print_line(control,1,line(1:nkar))
	    else
	      call dix_message(control,dix_msg_nomaskoff,mask)
	    end if
	  end if
	end if
c
90	return
	end
c
	function dix_dump_i_depo(control,dis,err_arg,totline,recompute_des)
	implicit none
c
c Deposit field=value
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	record /dis_pars/ dis		!:i: display parameters
	character*(*) err_arg		!:o: error argument
	character*(*) totline		!:i: value to be deposited
	logical recompute_des		!:o: recompute descriptions?
	integer*4 dix_dump_i_depo	!:f: function result
c
	character*(max_str_len) ascdat
	character*(max_line_length) fieldname,atemp
	integer*4 err_status,nk_data,ipos,nk_field,k,nk_atemp,plus
	integer*4 offs,value,ptr_file,ptr_des
	logical dep_vfc,repaint
	record /des_rec/ des_rec
	record /dis_pars/ dis_work
c
	record /file_info/ file		!:i: file 
	pointer (p_file,file)
c
	logical cli$present
	logical dix_con_typ_is_text
	logical dix_con_i4
	logical dix_con_hex_ascint
	logical dix_con_int_ascint
	logical dix_dump_check_deposit
	logical dix_des_find_field
	logical dix_des_find_file_des
c
	external dix_msg_notinmod
	external dix_msg_depform
	external dix_msg_fieldnotf
	external dix_msg_invbits
	external dix_msg_invusage
	external dix_msg_datalose
	external dix_msg_nomaskoff
	external dix_msg_outofvfc
	external dix_msg_outofrec
	external dix_msg_chgdrecl
	external dix_msg_synterr
	external dix_msg_synterrv
	external dix_msg_rectrunc
	external dix_msg_reclchg
	external dix_msg_invfsynt
c
	err_status = 1
c
c Check for VFC mode
c
c
	dep_vfc = cli$present('VFC_BUFFER')
	if(dep_vfc) then
	  des_rec.ent_type = enttyp_int
	  ascdat = totline
	  nk_data = len(totline)
	  goto 101
	endif
c
c Get the data
c
	call cli$get_value('p1',ascdat,nk_data)
	ipos = index(ascdat(1:nk_data),'=')
	if(ipos .eq. 0) then
	  err_status = %loc(dix_msg_depform)
	  goto 90
	endif
c
c Get the modify qualifiers
c
	dis_work = dis
	call dix_dump_file_set(dis_work.hex,     'HEX')
	call dix_dump_file_set(dis_work.number_hex,     'NUMBER.HEX')
	call dix_dump_file_set(dis_work.number,  'NUMBER')
	call dix_dump_file_set(dis_work.raw,     'RAW')
c
c Now try the data before the =, must be valid field name
c  of an offset
c
	fieldname = ascdat(1:ipos-1)
	nk_field = ipos-1
c
	if(dix_des_find_field(control,fieldname(1:nk_field),
     1                 des_rec,.false.,ptr_file)) then
c
c Got a match for the file
c
	  p_file = ptr_file
	  offs = -1		!signal we have a match for fieldname
	else
c
c Did not find the fieldname
c check if valid offset
c syntax integer[.bit_offset]
c
	  if(dix_des_find_file_des(control,fieldname(1:nk_field),
     1                ptr_file,ptr_des,ipos)) then
	    p_file = ptr_file
	    fieldname = fieldname(ipos:)
	    nk_field = nk_field - ipos + 1
	    ipos = index(fieldname(1:nk_field),'.')
	    if(ipos .eq. 0) then
	      plus = 0
	    else
	      read(fieldname(ipos+1:nk_field),2040,err=78) plus
	      if(plus .lt. 0 .or. plus .gt. 7) goto 78
	      nk_field = ipos-1
	    end if
	    if(.not. dix_con_i4(fieldname(1:nk_field),nk_field,
     1            offs,dis_work.number_hex,control,.false.))goto 78
c
c See if offset falls inside current record
c
	    offs = offs*8 + plus
	    des_rec.ent_type = enttyp_int
	  else
c
c Could not parse \file[\des\] part
c
	    goto 89
	  endif
c
	end if
c
	if(.not. file.modify) goto 75
c
c Get the data from the orig buffer (Since DCL parses to upercase)
c
	ascdat = totline
	nk_data = len(totline)
c
c Remove the = part (if present)
c
101	ipos = index(ascdat(1:nk_data),'=')
	if(ipos .gt. 0) then
	  ascdat  = ascdat(ipos+1:)
	  nk_data = nk_data - ipos
	endif
c
c If no char type, delete all spaces
c
	if(.not. dix_con_typ_is_text(des_rec.ent_type) .and.
     1           des_rec.ent_type .ne. enttyp_cpu) then
	  call unspace(ascdat,nk_data)
	endif
c
	if(dep_vfc) then
	  dis_work.word = 8		!force to 8 bits
	else
	  dis_work.word = 0
	  if(cli$present('LONG')) dis_work.word = 4*8
	  if(cli$present('WORD')) dis_work.word = 2*8
	  if(cli$present('BYTE')) dis_work.word = 1*8
	  call cli$get_value('bits',atemp,nk_atemp)
	  if(nk_atemp .gt. 0) then
	    read(atemp(1:nk_atemp),2040,err=81)  dis_work.word
2040	    format(i10)
	    if(dis_work.word .ge. 1 .and. dis_work.word .le. 32) goto 81
	  endif
	endif
c
	if(offs .lt. 0) then
c
c Description mode
c
	  if(dis_work.word .ne. 0) then
	    err_status = %loc(dix_msg_invusage)
	    goto 90
	  endif
c
	  if(p_file .eq. 0) goto 82
c
c format
c deposit[/quals] fieldname=value
c Try to locate fieldname and see no duplicate possibilities
c
c Copy data to temp record, and try to convert there
c
	  if(.not. dix_dump_check_deposit(control,file,des_rec,
     1               ascdat(1:nk_data),
     1               dis,repaint,.false.)) then
	    err_status = %loc(dix_msg_synterr)
	  end if
	else
c
c Raw mode
c Format deposit[/quals] offset=value
c Offset = byteoffset[.bit_offset]
c value  = data in integer format
c
c Try to convert offset to binary
c
	  if(dis_work.word .eq. 0) then
	    dis_work.word = dis.word*8		!take command line
	    if(dis_work.word .eq. 0) dis_work.word = 8!take def 1 byte
	  endif
c
	  if(dep_vfc) then
	    if(offs+8 .gt. file.data.nb_vfc*8) then
	      err_status = %loc(dix_msg_outofvfc)
	      goto 48
	    endif
	  else
	    if(offs+dis_work.word .gt. file.data.nb_data*8) then
	      if(.not. ((file.indexed .or. file.relative) .and. .not.
     1                   file.fixed)) then
	        err_status = %loc(dix_msg_outofrec)
	        goto 48
	      else
	        if(mod(offs+dis_work.word,8) .ne. 0) then
	          file.data.nb_data = (offs+dis_work.word)/8+1
	        else
	          file.data.nb_data = (offs+dis_work.word)/8
	        endif
	        call dix_message(control,dix_msg_chgdrecl,
     1                     %val(file.data.nb_data))
	        recompute_des = .true.
	      endif
	    endif
	  endif
c
c Now try to convert the data with dis_work.size to be the size in bits
c
	  if(dis_work.hex) then
	    if(2*(nk_data/2) .ne. nk_data) then
	      ascdat = '0'//ascdat(1:nk_data)
	      nk_data = nk_data + 1
	    endif
	    if(.not. dix_con_hex_ascint(ascdat(1:nk_data),value,0,4,
     1            enttyp_int,control)) goto 49
	  else
	    if(.not. dix_con_int_ascint(ascdat(1:nk_data),value,
     1           dis_work.word,' ',0,0,control)) goto 49
	  endif
c
c COnvert successfull, now insert in the main data
c
	  if(dep_vfc) then
	    call dix_util_insert_bits(value,offs,dis_work.word,
     1                           file.data.vfc_data)
	  else
	    call dix_util_insert_bits(value,offs,dis_work.word,
     1                           file.data.data_rec)
	  endif
	end if
	err_status = 1
	goto 90
48	call sys$fao('!UL',k,err_arg,%val(offs/8))
	err_arg(k+1:) = ' '
	goto 90
c
49	err_arg = ascdat(1:nk_data)
	err_status = %loc(dix_msg_synterrv)
	goto 90
c
75	err_status = %loc(dix_msg_notinmod)
	goto 90
c
78	err_arg = fieldname(1:nk_field)
	err_status = %loc(dix_msg_nomaskoff)
	goto 90
c
81	err_arg = atemp(1:nk_atemp)
	err_status = %loc(dix_msg_invbits)
	goto 90
c
82	err_arg = fieldname(1:nk_field)
	err_status = %loc(dix_msg_fieldnotf)
	goto 90
c
89	err_status = %loc(dix_msg_invfsynt)
	err_arg = fieldname(1:nk_field)
	goto 90
c
90	dix_dump_i_depo = err_status
	return
	end
	function dix_dump_i_show_des_exp(control,n_des,des_recs,
     1            has_fields)	   
	implicit none
c
c show dexciption expanded
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control
	integer*4 n_des			!:i: #descriptions
	record /des_rec/ des_recs(*)	!:i: the descriptions
	logical has_fields		!:i: do we have field mode fields
	integer*4 dix_dump_i_show_des_exp !:f: the function result
c
	integer*4 k,nk,nk1,siz,descr(2),wid_off,wid_typ
	character*(max_line_length) line
	logical hex,full,field_mode
c
	record /link_rec/ link_rec
	pointer (p_link_rec,link_rec)
c
	integer*4 dix_dump_print_line
	integer*4 dix_dump_print_line_br
	logical cli$present
c
	character*(max_keytype_length) matchfield
c
	character*(*) matchfields
	parameter (matchfields = 'LT,LE,EQ,GE,GT')
c
	full = cli$present('FULL')
	hex  = cli$present('HEX')
c
c Compute width's for ofset and type field
c
	wid_off = 0
	wid_typ = 0
	field_mode = .false.
c
c Display all descriptions
c first compute size for some fields
c
	do k=1,n_des
	  nk = 0
	  call dix_util_con_nr(des_recs(k).bit_offset,has_fields,
     1          line,nk,hex)
	  if(nk .gt. wid_off) wid_off = nk
	  call dix_util_get_type_name(des_recs(k).ent_type,line,nk)
          siz = des_recs(k).size
          if(.not. des_recs(k).is_field) siz = siz/8
	  call sys$fao('*!UL',nk1,line,%val(siz))
	  nk = nk + nk1
          if(des_recs(k).translate .ne. translate_nor) nk = nk+ 4
	  if(nk .gt.wid_typ) wid_typ = nk
	end do	  
c
c Now really  display
c
	do k=1,n_des
c
c CHeck for change in fieldmode
c
	  if(field_mode) then
	    if(.not. des_recs(k).is_field) then
	      field_mode = .false.
	      if(.not.dix_dump_print_line(control,0,'NOFIELDMODE')) goto 90
	    endif
	  else
	    if(des_recs(k).is_field) then
	      field_mode = .true.
	      if(.not.dix_dump_print_line(control,0,'FIELDMODE')) goto 90
	    endif
	  endif
c
c Convert the offset
c
	  line = ' '
	  call dix_util_con_nr(des_recs(k).bit_offset,has_fields,
     1          line,wid_off,hex)
	  nk = wid_off+1		!8 for width and 1 for space
c
c Append the type
c 
	  call dix_util_get_type_name(des_recs(k).ent_type,line(nk+1:),nk1)
	  nk = nk + nk1
c
c And the size
c
          siz = des_recs(k).size
          if(.not. des_recs(k).is_field) siz = siz/8
	  call sys$fao('*!UL',nk1,line(nk+1:),%val(siz))
	  nk = nk + nk1
c
c Optionally the special convert options
c
          if(des_recs(k).translate .ne. translate_nor) then
	    if(des_recs(k).translate .eq. translate_hex) line(nk+1:) = '/HEX'
	    if(des_recs(k).translate .eq. translate_oct) line(nk+1:) = '/OCT'
	    if(des_recs(k).translate .eq. translate_bin) line(nk+1:) = '/BIN'
            nk = nk + 4
          endif
	  if(des_recs(k).case .ne. case_no_case) then
	    if(des_recs(k).case .eq. case_upper) line(nk+1:) = '/UPP'
	    if(des_recs(k).case .eq. case_lower) line(nk+1:) = '/LOW'
	    nk = nk + 4
	  endif
c
c Check for follow fields
c
	  nk = wid_off + wid_typ + 2
	  if(des_recs(k).p_link_rec .ne. 0) line(nk:nk) = '>'
c
c And the name
c
	  call lib$movc3(des_recs(k).nam_len,%val(des_recs(k).nam_adr),
     1              %ref(line(nk+1:nk+1)))
          nk = nk + des_recs(k).nam_len
c
          if(.not.dix_dump_print_line(control,0,line(1:nk))) goto 90
c
	  if(full) then	  
c
c If full, display for field display (text names for integers)
c
	    nk1 = wid_off + wid_typ + 2
            if(des_recs(k).fld_len .gt. 0) then
              descr(1) = des_recs(k).fld_len
              descr(2) = des_recs(k).fld_adr
	      if(.not.dix_dump_print_line_br(control,nk1,descr)) goto 90
            endif
c
c Min/max values
c
	    if(des_recs(k).min_val .ne. des_recs(k).max_val) then
	      call sys$fao('Minimum !UL, Maximum !UL',nk,line,
     1                %val(des_recs(k).min_val),
     1                %val(des_recs(k).max_val))
	      if(.not.dix_dump_print_line(control,nk1,line(1:nk))) goto 90
	    endif
c
c And follow field
c
	    if(des_recs(k).p_link_rec .ne. 0) then
	      p_link_rec = des_recs(k).p_link_rec
	      if(.not.dix_dump_print_line(control,nk1,'link record')) goto 90
	      if(link_rec.nk_link_file .ne. 0) then
	        if(.not. dix_dump_print_line(control,nk1+2,'File:'//
     1             link_rec.link_file(1:link_rec.nk_link_file))) goto 90
	      endif
	      if(link_rec.key_nr .lt. 0) then
	        call sys$fao('/RECORD',nk,line)
	      else
	        call str$element(matchfield,link_rec.match+2,',',matchfields)
	        call sys$fao('/KEY=!UL/MATCH=!AS',nk,line,
     1               %val(link_rec.key_nr),matchfield)
	      endif
	      if(.not. dix_dump_print_line(control,nk1+2,line(1:nk))) goto 90
	      if(link_rec.nk_if .gt. 0) then
	        if(.not. dix_dump_print_line(control,nk1+2,'If:'//
     1             link_rec.if_line(1:link_rec.nk_if))) goto 90
	      endif
	      if(link_rec.nk_compute .gt. 0) then
	        if(.not. dix_dump_print_line(control,nk1+2,'Compute:'//
     1             link_rec.comp_line(1:link_rec.nk_compute))) goto 90
	      endif
	    endif       !there is a link_record
	  endif		!full display
	end do
90	dix_dump_i_show_des_exp = 1
	return
	end
	subroutine dix_inter_list_keys(control)
	implicit none
c
c List interactive mode keys
c
	include 'dix_interactive.inc'
	include '($smgdef)'
	record /control/ control	!:io: control structure
c
	character*(max_line_length) line
	character*(max_symbol_name_length) keyname,if_state,equiv,set_state
	character*(max_symbol_name_length) key_w,state_w
	integer*4 nk_k,nk_if,nk_eq,nk_se,n,nk,nk_kw,nk_sw,ctx,flags
	integer*4 mem_lun
	logical full
c
	integer*4 dix_util_get_len_fu
	integer*4 smg$list_key_defs
	integer*4 str$match_wild
	logical cli$present
	logical dix_dump_print_line
	integer*4 dix_util_get_len
	external dix_msg_nokeys
	integer memtab_read
c
	if(cli$present('DIRECTORY')) then
c
c Display a directory of states
c
	  call memtab_init(mem_lun,'Directory')
	  ctx = 0
	  if(.not. dix_dump_print_line(control,0,
     1        'Directory of key-states')) goto 15
	  do while(smg$list_key_defs(control.keytable_id,ctx,
     1           keyname,if_state,flags,equiv,set_state))
	    call memtab_rewind(mem_lun)
	    nk_if = dix_util_get_len(if_state)
	    do while(memtab_read(mem_lun,nk,line))
	      if(line(1:nk) .eq. if_state(1:nk_if)) goto 10
	    end do
	    call memtab_add_record(mem_lun,if_state(1:nk_if))
10	  end do
	  call memtab_rewind(mem_lun)
	  do while(memtab_read(mem_lun,nk,line))
	    if(.not. dix_dump_print_line(control,2,line(1:nk))) then
	      goto 15
	    end if
	  end do
15	  call memtab_close(mem_lun)
	  goto 90
	endif
c
c Display the wanted keys
c
	call cli$get_value('p2',key_w,nk_kw)
	if(nk_kw .eq. 0) then
	  key_w = '*'
	  nk_kw = 1
	endif
	call cli$get_value('state',state_w,nk_sw)
	if(nk_sw .eq. 0) then
	  state_w = 'DEFAULT'
	  nk_sw = 7
	endif
	if(.not. dix_dump_print_line(control,0,
     1       state_w(1:nk_sw)//' keypad definitions')) goto 90
	full = cli$present('full')
	ctx = 0
	n = 0
	do while(smg$list_key_defs(control.keytable_id,ctx,
     1           keyname,if_state,flags,equiv,set_state))
	  nk_k =  dix_util_get_len_fu(keyname)
	  nk_if = dix_util_get_len_fu(if_state)
	  nk_eq = dix_util_get_len_fu(equiv)
	  nk_se = dix_util_get_len_fu(set_state)
	  if(str$match_wild(keyname(1:nk_k),key_w(1:nk_kw)) .and.
     1       if_state(1:nk_if) .eq. state_w(1:nk_sw)) then
	    n = n + 1
	    line = keyname(1:nk_k)//' = "'//equiv(1:nk_eq)//'"'
	    nk = nk_k + 4 + nk_eq + 1
	    if(full) then
	      nk =  nk + 2
	      line(nk:nk) = '('
	      if(iand(flags,smg$m_key_noecho) .ne. 0) then
	        call dix_append(nk,line,'NOECHO,')
	      else
	        call dix_append(nk,line,'ECHO,')
	      endif
c
	      if(iand(flags,smg$m_key_terminate) .ne. 0) then
	        call dix_append(nk,line,'TERMINATE,')
	      else
	        call dix_append(nk,line,'NOTERMINATE,')
	      endif
	      if(iand(flags,smg$m_key_lock) .ne. 0) then
	        call dix_append(nk,line,'LOCK,')
	      else
	        call dix_append(nk,line,'NOLOCK,')
	      endif
	      if(iand(flags,smg$m_key_protected) .ne. 0) then
	        call dix_append(nk,line,'PROTECTED')
	      else
	        call dix_append(nk,line,'NOPROTECTED')
	      endif
	      if(nk_se .gt. 0) then
	        call dix_append(nk,line,',STATE='//set_state(1:nk_se)//')')
	      else
	        call dix_append(nk,line,')')
	      endif
	    end if
	    if(.not. dix_dump_print_line(control,2,line(1:nk))) goto 90
	  endif
	end do
	if(n .eq. 0) call dix_message(control,dix_msg_nokeys,
     1             state_w(1:nk_sw))
90	return
	end
	subroutine set_strict(strict)
	implicit none
c
c Set strict mod
c
	include 'dix_interactive.inc'
	integer*4 strict
c
	integer*4 istat
	integer*4 cli$present
	external cli$_present
	external cli$_negated
c
	istat = cli$present('TYPING') 
	if(istat .eq. %loc(cli$_present)) then 
	  strict = strict .or. strict_typing
	endif
	if(istat .eq. %loc(cli$_negated)) then
	  strict = strict .and. .not. strict_typing
	endif
c
	istat = cli$present('DECLARATIONS')
	if(istat .eq. %loc(cli$_present)) then
	  strict = strict .or. strict_declaration
	endif
	if(istat .eq. %loc(cli$_negated)) then
	  strict = strict .and. .not. strict_declaration
	  strict = strict .and. .not. strict_declaration_local
	endif
c
	istat = cli$present('LOCAL')
	if(istat .eq. %loc(cli$_present)) then
	  strict = strict .or. strict_declaration
	  strict = strict .or. strict_declaration_local
	endif
	if(istat .eq. %loc(cli$_negated)) then
	  strict = strict .and. .not. strict_declaration
	  strict = strict .and. .not. strict_declaration_local
	endif                                    
	return
	end
	function dix_inter_read_command_file(control,file,file_level)
	implicit none
c
c Readin a command file to a memory file
c the file is checked on syntax for the
c  control structures, any mismatch results in an message and an error
c
	include 'dix_interactive.inc'	
	record /control/ control	!:io: control structure
	character*(*) file		!:i: filename
	record /file_level/ file_level	!:io: file level structure
	integer*4 dix_inter_read_command_file	!:f: status
c
	integer*4 istat,lun_f,lun_mem,nlin
c
	integer*4 dix_inter_read_command_memtab
	integer*4 dix_util_get_len_fu
c
c Open the file, it should exists, since SMG already opened it
c
	call lib$get_lun(lun_f)
	open(lun_f,file=file,status='old',err=80,defaultfile='.dix')
	inquire(lun_f,name=file_level.filename)
	file_level.nk_file  = dix_util_get_len_fu(file_level.filename)
c
c Copy the file to a memtab
c
	call memtab_open_lun(lun_f,lun_mem,nlin) 
	close(lun_f)
c
c Create new memtab (contains precompiled source)
c
	call memtab_init(file_level.lun,file)
c
c And parse it
c
	istat = dix_inter_read_command_memtab(lun_mem,control,file_level)
	call memtab_close(lun_mem)
	goto 90
c
80	call errsns(,istat)
c
90	call lib$free_lun(lun_f)
	dix_inter_read_command_file = istat
	return
	end
	function dix_inter_read_command_usertype(lun_mem,control,name,
     1             lun_usertypes)
	implicit none
c
c A simple interface for command_memtab
c 
	include 'dix_interactive.inc'	
	record /control/ control	!:i: control structure
	character*(*) name		!:i: the rquested user type
	integer*4 lun_mem		!:o: the lun 
	integer*4 lun_usertypes		!:i: usertype lun
c
	integer*4 dix_inter_read_command_usertype
c
	integer*4 istat,nlin,lun,ptr_line,k,nk
	character*(max_label_length) label
	character*(max_command_length) line
c
	record /file_level/ file_level
c
	integer*4 dix_inter_read_command_memtab
	integer*4 dix_lbr_read_module
	integer*4 memtab_open
	integer*4 memtab_read
	logical memtab_find_label
	logical dix_des_is_type
c
	external dix_msg_usrtnotf
c
c First try to find in the lun_usertype
c
	istat = memtab_find_label(lun_usertypes,name,ptr_line,k)
	if(istat) then
	  call memtab_set_line_ptr(lun_usertypes,ptr_line)
c
c Skip first line, it contains the label 
c
	  call memtab_init(lun,'USERTYPE_'//name)
c
	  call memtab_read(lun_usertypes,nk,line)
	  do while(memtab_read(lun_usertypes,nk,line))
	    if(dix_des_is_type(line(1:nk),.false.,label)) goto 10
	    call memtab_add_record(lun,line(1:nk))
	  end do
	endif
c
10	if(.not. istat) then
c
c Try to open in the current directory
c
	  istat = memtab_open('USERTYPE_'//name,lun,nlin)
	endif
	if(.not. istat) then
c
c Try to read from one of the libraries
c
	  istat = dix_lbr_read_module(control,'USERTYPE_'//name,lun,nlin)
	endif
c
	if(istat) then
	  call memtab_rewind(lun)
	  call memtab_init(file_level.lun,'USERTYPE_'//name)
	  istat = dix_inter_read_command_memtab(lun,control,file_level)
	  lun_mem = file_level.lun              !tell caller
	  call memtab_close(lun)		!delete lun
	else
	  call dix_message(control,dix_msg_usrtnotf,name)
	endif
	dix_inter_read_command_usertype = istat
	return
	end
c
	function dix_inter_read_command_memtab(lun_mem,control,file_level)
	implicit none
c
c Readin a command file to a memory file
c the file is checked on syntax for the
c  control structures, any mismatch results in an message and an error
c
	include 'dix_interactive.inc'	
	integer*4 lun_mem		!:i: lun with the source file
	record /control/ control	!:io: control structure
	record /file_level/ file_level	!:io: file level structure
	integer*4 dix_inter_read_command_memtab	!:f: status
c
	character*(max_str_len) line,tot_line
	character*(max_label_length) label
c
	record /struct_pointers/ ptrs
	record /struct_level/ struct_level
	pointer (p_struct_level,struct_level)
c
	character*(max_verb_length) verb
c
	integer*4 line_ptr
	integer*4 istat
	integer*4 nk,nk_tot,pos,beg_line_nr,xlev,nk1
	logical first
c
        record /level_info/ level
c
	integer*4 dix_inter_get_label
	integer*4 memtab_read
	integer*4 dix_util_get_len_fu
	integer*4 str$find_first_in_set
c
c	external dix_int_cld
c	external ignore_message
c
	external dix_msg_notpart
	external dix_msg_wrongblock
	external dix_msg_openlevel
	external dix_msg_errcmnd
	external dix_msg_multielse
	external dix_msg_contlnotf
	external dix_msg_noopstr
c
c
c
	call  dix_inter_open_struct(file_level,ptrs)
	p_struct_level = file_level.cur_struct
c
c Init
c
	level.level   = 1
	level.line_nr = 0
c
c Start reading 
c
10	nk_tot = 0
	first = .true.
20	istat = memtab_read(lun_mem,nk,line)
	if(.not. istat) goto 50
c
	level.line_nr = level.line_nr + 1
	call memtab_add_record_level(file_level.lun,line(1:nk),level)
c
	if(first) then
	  call memtab_get_line_ptr(file_level.lun,line_ptr)
	  beg_line_nr = level.line_nr
	endif
	first = .false.
	call dix_util_remove_comment(nk,line)
	call dix_util_decent_line(nk,line)
	tot_line(nk_tot+1:nk_tot+nk) = line(1:nk)
	nk_tot = nk_tot + nk
	if(nk_tot .gt. 0) then
	  if(tot_line(nk_tot:nk_tot) .eq. '-') then
	    nk_tot = nk_tot - 1
	    goto 20
	  endif
	endif
c
c Change some special statements
c
	call dix_inter_massage(tot_line,nk_tot)
c
c Now we have a total line tot_line(1:nk_tot)
c  find the (optional) label and the verb
c
	if(dix_inter_get_label(tot_line(1:nk_tot),label,pos)) then
	  if(tot_line(pos:pos) .eq. ' ') pos = pos + 1
	  tot_line = tot_line(pos:nk_tot)
	  nk_tot   = nk_tot - pos + 1
	  call memtab_add_label(file_level.lun,line_ptr,label,pos)
	else
	  label = ' '
	endif	  
c
c Now get verb, this is the part upto the space or /
c
	pos = str$find_first_in_set(tot_line(1:nk_tot),' =(/')
	if(pos .eq. 0) pos = nk_tot+1
	if(pos .gt. 0) pos = pos - 1
	if(pos .gt. 4) pos = 4
	call str$upcase(verb,tot_line(1:pos))
c
c CHeck for end verbs
c
	if(verb .eq. 'ENDF' .or. verb .eq. 'ENDW' .or.
     1     verb .eq. 'UNTI' .or. verb .eq. 'ENDL' .or.
     1     verb .eq. 'ENDI' .or. verb .eq. 'ENDS') then
	  if(level.level .le. 1) goto 66
	  if(verb .eq. 'UNTI') then
	    if(struct_level.ptrs.begin_verb .ne. 'REPE') goto  62
	  else
	    if(verb(4:4) .ne. struct_level.ptrs.begin_verb(1:1)) goto 62
	  endif
	  struct_level.ptrs.end_ptr = line_ptr
	  struct_level.ptrs.end_nr  = beg_line_nr
c
c Now store the extra info for the begin_line
c
	  call memtab_add_pointers(file_level.lun,sizeof(struct_level.ptrs),
     1              struct_level.ptrs,struct_level.ptrs.begin_ptr)
          call dix_inter_close_struct(control,file_level)
	  p_struct_level = file_level.cur_struct
	  level.level = level.level - 1
	endif
c
c Check for middle verbs
c
	xlev = level.level
	if(verb .eq. 'ELSE') then
	  if(level.level .le. 1) goto 60
	  if(struct_level.ptrs.begin_verb .ne. 'IF') goto  60
	  if(struct_level.ptrs.middle_ptr .ne. 0) goto 65
	  struct_level.ptrs.middle_ptr = line_ptr
	  struct_level.ptrs.middle_nr  = beg_line_nr
	  xlev = xlev - 1
	endif
	if(verb .eq. 'TEST') then
	  if(level.level .le. 1) goto 61
	  if(struct_level.ptrs.begin_verb .ne. 'LOOP') goto  61
	  xlev = xlev - 1
	endif
c
	if(control.debug) then
	  nk = min(nk_tot,80-2*xlev-15)
	  if(label .ne. ' ') then
	    nk1 = dix_util_get_len_fu(label)
	    label(nk1+1:nk1+1) = ':'
	    nk1 = nk1 + 1
	  else
	    nk1 = 0
	  endif
	  call sys$fao('!4UL !2UL !#*  !AS',nk,line,
     1         %val(beg_line_nr),
     1         %val(level.level),
     1          %val(2*xlev),
     1           label(1:nk1)//tot_line(1:nk))
	  write(*,1000) line(1:nk)
1000	  format(1x,a)
	endif
c
c Now check for begin verbs
c
	if(verb .eq. 'FOR' .or.
     1     verb .eq. 'WHIL' .or.
     1     verb .eq. 'REPE' .or.
     1     verb .eq. 'LOOP' .or.
     1     verb .eq. 'IF'   .or.
     1     verb .eq. 'SUBR') then
	  if(verb .eq. 'IF') then
c
c The IF statement can have 2 forms
c  IF (expres) THEN
c  IF (expres) statement
c  Only format 1 creates a new level
c
	    if(tot_line(nk_tot-5:nk_tot) .ne. ') THEN' .and.
     1         tot_line(nk_tot-4:nk_tot) .ne. ')THEN') goto 40
	  endif
	  level.level = level.level + 1
	  call  dix_inter_open_struct(file_level,ptrs)
	  p_struct_level = file_level.cur_struct
c
	  struct_level.ptrs.begin_verb = verb
	  struct_level.ptrs.begin_ptr  = line_ptr
	  struct_level.ptrs.begin_nr   = beg_line_nr
	  struct_level.ptrs.middle_ptr = 0
	  struct_level.ptrs.middle_nr  = 0
	  struct_level.ptrs.end_ptr    = 0
	  struct_level.ptrs.end_nr     = 0
	endif
c
c
c If label present, store the label info
c
40	goto 10	
c
c Eof reached, close the file and exit
c
50	if(level.level .gt. 1) goto 63
	if(.not. first) goto 64
	istat = 1
	call memtab_rewind(file_level.lun)
	goto 90
c
60	call dix_message(control,dix_msg_notpart,verb,%val(level.line_nr),
     1                    %descr('IF'))

	goto 70
c
61	call dix_message(control,dix_msg_notpart,verb,%val(level.line_nr),
     1                          %descr('LOOP'))
	goto 70
c
62	call dix_message(control,dix_msg_wrongblock,
     1       verb,%val(level.line_nr),
     1       struct_level.ptrs.begin_verb,
     1       %val(struct_level.ptrs.begin_nr))
	goto 70
c
63	call dix_message(control,dix_msg_openlevel,
     1       struct_level.ptrs.begin_verb,
     1       %val(struct_level.ptrs.begin_nr))
	goto 70
c
64	call dix_message(control,dix_msg_contlnotf)
	goto 70
c
65	call dix_message(control,dix_msg_multielse)
	goto 70
66	call dix_message(control,dix_msg_noopstr,
     1         verb,%val(level.line_nr))
	goto 70
c
70	istat = %loc(dix_msg_errcmnd)
	call memtab_close(file_level.lun)
	goto 90
c
c Delete all temporary struct_levels
c
90	do while(file_level.cur_struct .ne. 0)
	  call dix_inter_close_struct(control,file_level)
	end do
c
	dix_inter_read_command_memtab = istat
	return
	end
	function dix_inter_find_label(label,goto_level,
     1                err_arg,nlevel,file_level,debug)
	implicit none
c
c TGry to find  a label
c
	include 'dix_interactive.inc'
	character*(*) label		!:i: the label to be found
	record /level_info/ goto_level	!:i: the level of the go(to/sub) line
	character*(*) err_arg		!:o: the error argument
	integer*4 nlevel		!:o: #levels down
	record /file_level/ file_level	!:i: command file 
	logical debug
	logical dix_inter_find_label	!:f: function result
c
	integer*4 lun
	integer*4 ptr_line,label_line
	record /level_info/ label_level
c
	record /struct_level/ struct_level
	pointer (p_struct_level,struct_level)
c
	external dix_msg_labnotr
	external dix_msg_labnotf
c
	integer*4 istat, k,blin,elin,nk_l
c
	integer*4 memtab_find_label
	integer*4 dix_util_get_len_fu
c
	lun = file_level.lun
	istat = 0
	nk_l = dix_util_get_len_fu(label)
c
	if(debug) write(*,1001) label(1:nk_l),goto_level.level,
     1                          goto_level.line_nr
1001	format(' search label ',a,' from Goto at level ',i4,' linenr ',i5) 
c
	if(memtab_find_label(lun,label,ptr_line,label_level)) then
c
c Now goto_level  is the level of the goto line
c     label_level is the level of the label line
c see if reachable
c 
c If label is at level 1, is can be reached from anywhere.
c	   
	  if(debug) write(*,1010) label(1:nk_l),label_level.level,
     1                label_level.line_nr
1010	  format(' Label ',a,' found at level ',i4,' linenr ',i5)
	  label_line = label_level.line_nr
c
	  p_struct_level = file_level.top_struct
	  do k=2,label_level.level
	    if(debug) write(*,1020) k,struct_level.ptrs.begin_verb,
     1              struct_level.ptrs.begin_nr,
     1              struct_level.ptrs.middle_nr,
     1              struct_level.ptrs.end_nr
1020	    format(' Level ',i3,' bverb ',a,' b,m,e ',3i5)

	    if(struct_level.ptrs.middle_nr .eq. 0) then
c
c Only begin and end are interesting
c
	      blin = struct_level.ptrs.begin_nr
	      elin = struct_level.ptrs.end_nr
	    else
	      if(goto_level.line_nr .lt. struct_level.ptrs.middle_nr) then
	        blin = struct_level.ptrs.begin_nr
	        elin = struct_level.ptrs.middle_nr
	      else
	        blin = struct_level.ptrs.middle_nr
	        elin = struct_level.ptrs.end_nr
	      endif
	    endif
	    if(debug) write(*,1040) label_line,blin,elin
1040	    format('   Check if ',i5,' is between ',i5, ' and ',i5)
	    if(label_line .lt. blin .or. label_line .gt. elin) goto 60
	    p_struct_level = struct_level.link.forw
	  end do
c
	  call memtab_set_line_ptr(lun,ptr_line)
	  istat = 1
c
c Now compute how many levels we went down
c
	  nlevel = goto_level.level - label_level.level
	  goto 90
60	  istat = %loc(dix_msg_labnotf)
	  err_arg = label
	else
	  istat = %loc(dix_msg_labnotf)
	  err_arg = label
	endif
c
90	dix_inter_find_label = istat
	return
	end
	function dix_inter_parse_for(control,ascdat,symbol,nk_symb,
     1              err_arg,des_expanded,begval,incval,endval)
	implicit none
c
c  Parse the FOR argument
c  for symbol=begin.end[,increment]
c
	include 'dix_interactive.inc'
c
	record /control/ control
	character*(*) ascdat		!:i: the command line
	character*(*) symbol		!:o: the symbol
	integer*4 nk_symb		!:o: lenght of symbol
	character*(*) err_arg		!:o: error argument
	integer*4 des_expanded	  		!:i: description
	integer*4 begval		!:o: begval
	integer*4 incval		!:o: increment val
	integer*4 endval		!:o: end val
	integer*4 dix_inter_parse_for	!:f: the recult
c
	integer*4 ipos,nk
	integer*4 err_status
	character kar
c
	integer*4 dix_symbol_check_name
	integer*4 dix_inter_eval_int
	external dix_msg_illfor
	external dix_msg_infloop
c
	nk = len(ascdat)
c
c FInd the = character
c
	ipos = index(ascdat,'=')
	if(ipos .eq. 0) goto 80
c
c The symbol is the part upto to =, get and check
c
	nk_symb = ipos-1
	symbol = ascdat(1:nk_symb)
	err_status = dix_symbol_check_name(symbol(1:nk_symb),
     1                des_expanded,err_arg)
	if(.not. err_status) goto 90
c
c And the expression the rest
c
	ascdat = ascdat(ipos+1:)
	nk = nk - ipos
c
c Now we have a symbol name
c Parse first part (startpoint)
c	         	      
	err_status = dix_inter_eval_int(control,ascdat,nk,begval,err_arg,kar)
	if(.not. err_status) goto 90	        
	if(kar .ne. ',') goto 80
c
c Now parse second part (endpoint)
c
	err_status = dix_inter_eval_int(control,ascdat,nk,endval,err_arg,kar)
c
	if(.not. err_status) goto 90	        
c
c Now optional get the increment
c
	incval = 1
	if(kar .eq. ',') then
	  err_status = dix_inter_eval_int(control,ascdat,nk,incval,err_arg,kar)
c
	  if(.not. err_status) goto 90	        
	endif
	if(kar .ne. char(0)) goto 80
c
c Now we have all ingredients, begval,endval,incval
c check for sanity
c
	if(endval .lt. begval) then
	  if(incval .ge. 0) goto 81
	else
	  if(incval .le. 0) goto 81
	endif
	err_status = 1
	goto 90
c
80	err_status = %loc(dix_msg_illfor)
	goto 90	
81	err_status = %loc(dix_msg_infloop)
	goto 90
c
90	dix_inter_parse_for = err_status
	return
	end
	function dix_inter_eval_int(control,line,nk,ival,err_arg,kar)
c
c Evaluate string and return an integer
c
	implicit none
c
	include 'dix_interactive.inc'
	record /control/ control
	character*(*) line
	integer*4 nk
	integer*4 ival
	character*(*) err_arg
	character kar
	logical dix_inter_eval_int
c
	integer*4 istat,pos,is_symbol
	integer*4 dix_eval_expression1
	external dix_msg_enotint
	record /value/ val
c
	call dix_eval_init_value(val)
	istat = dix_eval_expression1(control,line(1:nk),val,
     1             .false.,err_arg,.false.,
     1             kar,pos,is_symbol)
	if(istat) then
	  if(val.type .eq. symb_typ_int) then
	    istat = 1
	  else
	    err_arg = line(1:pos-2)
	    istat = %loc(dix_msg_enotint)
	  endif
	  ival = val.ival
	endif
	line = line(pos:)
	nk = nk - pos + 1
	call dix_eval_free_value(val)
	dix_inter_eval_int = istat
	return
	end
c
	function dix_inter_open_level(control,line,output_file)
	implicit none
c
c Open a new commandfile level
c
	include 'dix_interactive.inc'
	include '($smgdef)'	     	
	include '($dcdef)'
	include '($dvidef)'

	record /control/ control	!:io: control structure
	character*(*) line      	!:i: filename
	character*(*) output_file	!:i: output file
	integer*4 dix_inter_open_level	!:f: the function result
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	integer*4 istat,lun_out,k,lun
	logical ver_mode
	external dix_msg_filnotop
	record /smgdef/ keyboard_info
c
	integer*4 smg$create_virtual_keyboard
	integer*4 dix_inter_read_command_file
	integer*4 dix_inter_create_new_level
c	
c Try to open virtual keyboard
c
	istat = smg$create_virtual_keyboard(lun,line,'.DIX')
	if(istat) then
c
c Create new level
c
	  istat = dix_inter_create_new_level(control)
	  if(.not. istat) goto 90
	  p_file_level = control.cur_level
c
	  file_level.lun = lun
	  file_level.filename = line
	  file_level.nk_file  = len(line)
c
c Could open terminal/file, Now get type of input device (file/terminal)
c
	  call smg$get_keyboard_attributes(file_level.lun,
     1            keyboard_info,smg$c_keyboard_info_block)
c
c Set .is_term according to input type (file/terminal)
c
	  file_level.is_term = keyboard_info.smg$b_devclass.ne.dc$_disk
	  if(.not. file_level.is_term) then
c        
c Sys$input is a file
c
	    call smg$delete_virtual_keyboard(file_level.lun)
	    istat = dix_inter_read_command_file(control,line,file_level)
	    if(.not. istat) goto 80
	  endif
c
c Set default error action (on error then exit)
c
	  if(output_file .ne. ' ') then
	    call lib$get_lun(lun_out)
	    file_level.output_opened = .true.
	    open(lun_out,
     1           file=output_file,
     1           status='new',
     1           carriagecontrol='list',err=70)
	  else
	    file_level.output_opened = .false.
	    if(control.depth .eq. 1) then
	      ver_mode = .false.
	      lun_out = control.lun_out
	    else
	      k = p_file_level
	      p_file_level = file_level.link.backw
	      ver_mode = file_level.verify
	      lun_out  = file_level.lun_out
	      p_file_level = k
	    endif
	  endif
          file_level.verify   = ver_mode			!set verify
          file_level.lun_out  = lun_out
          call dix_inter_set_default_error(file_level)
	endif
	goto 90
c
c Open error on output file
c
70	call errsns(,istat)
c	goto 80
c
c Open error on command file parsing
c
80	call dix_inter_close_level(control,.true.)
c
90	dix_inter_open_level = istat
	return
	end
	function dix_inter_create_new_level(control)
	implicit none
c
c Create a new level
c
	include 'dix_interactive.inc'
	record /control/ control
	integer*4 dix_inter_create_new_level
c
	integer*4 istat
	integer*4 nk
	character*(max_nr_asc_length) levelasc
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	call sys$fao('!UL',nk,levelasc,%val(control.depth))
c
	call get_vm(sizeof(file_level),p_file_level,control.zone_cfile)
c
c Now link in
c
	call dix_inter_insert_link(file_level,control.top_level,
     1        control.cur_level,control.depth)
	call init_vm(file_level.zone_level,0,
     1     'FILE_LEVEL_'//levelasc(1:nk),.false.)
c
c Init some counters
c
        file_level.struct_level = 0		!no structs yet
	file_level.cur_struct    = 0
	file_level.top_struct    = 0
c
        file_level.gosub_level  = 0          !no level yet
        file_level.nbgosub_alloc= 0          !no bytes alocated yet
        file_level.p_gosubs     = 0          !pointer to table
c
	file_level.output_opened= .false.	!No output open yet
c
	file_level.on_mode = .false.		!no control_c yet
	istat = 1
	dix_inter_create_new_level = istat
	return
	end

	subroutine dix_inter_close_level(control,close_file)
	implicit none
c
c Close a level (exit/endsubroutine statement)
c
	include 'dix_interactive.inc'
	record /control/ control
	logical close_file		!really close the input file
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	p_file_level = control.cur_level
	if(.not. file_level.is_call) then
c
c Twas an @, so close the input terminal/memfile
c
          if(file_level.is_term) then
            call smg$delete_virtual_keyboard(file_level.lun)
          else
            if(close_file) call memtab_close(file_level.lun)
          endif
        endif
c
c moet alle struc_levels sluiten van dit level
c
	do while(file_level.struct_level .gt. 0)
          call dix_symbol_delete_level(control)
	  call dix_inter_close_struct(control,file_level)
        enddo
c
        call dix_symbol_delete_level(control)
c
        if(file_level.output_opened) then
          close(file_level.lun_out)
          call lib$free_lun(file_level.lun_out)
        endif             
	call dix_inter_remove_link(control.top_level,control.cur_level,
     1            control.depth)
	call delete_vm(file_level.zone_level)
	call free_vm(sizeof(file_level),p_file_level,control.zone_cfile)
c
 	return
	end
        subroutine dix_inter_set_default_error(level)
        implicit none
c
c Set default error action correct : on error exit
c
        include 'dix_interactive.inc'
        include '($stsdef)'
        record /file_level/ level
c
        level.on_mode  = .true.
        level.nk_on    = 0
        level.on_line  = ' '
        level.on_level = sts$k_error
        return
        end
	subroutine dix_inter_get_struct_level(control,level)
	implicit none
c
c Get the current level
c
        include 'dix_interactive.inc'
	record /control/ control
	integer*4 level
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	if(control.cur_level .eq. 0) then
	  level = 0
	else
	  p_file_level = control.cur_level
	  level = file_level.struct_level
	endif
	return
	end
	subroutine dix_inter_get_lun(control,lun)
	implicit none
c
c Get the lun for output printing
c
	include 'dix_interactive.inc'
	record /control/ control		!:i: control structure
	integer*4 lun				!:o: the current output lun
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	p_file_level = control.cur_level
	lun = file_level.lun_out	
	return
	end
	subroutine dix_inter_insert_link(link,top,last,count)
	implicit none
c
c insert a token in a link
c 
	include 'dix_def.inc'
	record /link/ link
	integer*4 top
	integer*4 last
	integer*4 count
c
	record /link/ p_link
	pointer (p_p_link,p_link)
c
	link.backw = last
	link.forw  = 0
	if(last .eq. 0) then
	  top = %loc(link)
	else
	  p_p_link = last
	  p_link.forw = %loc(link)
	endif
	last  = %loc(link)
	count = count + 1
	return
	end
c
	subroutine dix_inter_remove_link(top,last,count)
	implicit none
c
c Remove the last token in a link
c 
	include 'dix_def.inc'
	integer*4 top
	integer*4 last
	integer*4 count
c
	record /link/ link
	pointer (p_link,link)
c
	p_link = last
	p_link = link.backw
	if(p_link .eq. 0) then
	  top  = 0
	else
	  link.forw = 0
	endif
	last = p_link
	count = count - 1
	return
	end
	subroutine dix_inter_get_file_level_info(control,what,nk,line)
	implicit none
c
c Get some info about current file_level
c this routine is made so that other module do not need to know
c the layout of the /file_level/ structure
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	character*(*) what		!:i: item to get info about		
	integer*4 nk			!:o: length or integer value
	character*(*) line		!:o: text ingo
c
	include '($stsdef)'
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	p_file_level = control.cur_level
	if(what(1:2) .eq. 'PR') then
	  nk   = file_level.nk_file
	  line = file_level.filename
	elseif(what(1:2) .eq. 'OA') then
	  if(file_level.on_mode) then
	    nk   = file_level.nk_on
	    line = file_level.on_line
	  else
	    line = 'None'
	    nk = 4
	  endif
	elseif(what(1:2) .eq. 'OS') then 
          if(file_level.on_mode) then
            if(file_level.on_level .eq. sts$k_warning) then
              line = 'WARNING'
            elseif(file_level.on_level .eq. sts$k_error) then
              line = 'WARNING'
            elseif(file_level.on_level .eq. sts$k_severe) then
              line = 'WARNING'
            endif
          else
            line = 'NONE'
          endif
          nk = index(line,' ')-1
	elseif(what(1:2) .eq. 'LU') then 
	  nk = file_level.lun_out	
	elseif(what(1:2) .eq. 'FI') then 
	  nk = .not. file_level.is_term
	endif
	return
	end	 
	subroutine dix_dump_inter_dir_files(control,file_mask,full,
     1           do_descr,all)
	implicit none
c
c LEt the user select a file from the file list
c or display a list of file
c File mask can be
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) file_mask         !:i: file mask
	logical full			!:i: full file display
	logical do_descr		!:i: show descriptions too
	logical all			!:i: all files?
c
	record /file_info/ file
	pointer (p_file,file)
c
	record  /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_info/ des_info
	pointer (p_des_info,des_info)
c
	logical str$match_wild
	logical dix_dump_print_line
c
	integer*4 k,width,nk,nk_h,nk_s,nk_f
	character*(max_short_line_length) ftyp
	character*(max_line_length) line,hline
	character kar
c
	external dix_msg_nofilmat
c
c Either show all files (possibly full)
c or select a file
c First compute the length of various parts
c
	if(all) then
c
c all files wanted
c
	  p_file = control.top_file
	else
c
c Only the current file
c
	   p_file = control.cur_file
	endif
	nk_h = 3 	!max handle size
	nk_s = 4      !max filesize size
	nk_f = 0	!max filename length
	do while(p_file .ne. 0)	
	  if(file.handle .eq. file_mask .or. 
     1         str$match_wild(file.fnam(1:file.nk_fnam),file_mask)) then
c
	    call sys$fao('!UL',k,line,%val(file.filesize))
	    if(k .gt. nk_s) nk_s = k
c
	    nk = file.nk_handle
	    if(nk .gt. nk_h) nk_h = nk
	    if(do_descr) then
	      p_des_expanded = file.top_des
	      do while(p_des_expanded .ne. 0) 
	        nk = des_expanded.nk_handle+ 1
	        if(nk .gt. nk_h) nk_h = nk
	        p_des_info = des_expanded.p_des_info
	        call dix_des_display(control,des_info,line,nk,.true.)
	        if(nk .gt. nk_f) nk_f = nk
	        call sys$fao('!UL',k,line,%val(des_expanded.n_des))
	        if(k .gt. nk_s) nk_s = k
	        p_des_expanded = des_expanded.link.forw
	      enddo
	    end if  
	    call sys$fao('!UL',k,line,%val(file.filesize))
	    if(k .gt. nk_s) nk_s = k
c
c Filename is appended by /MOD
c
	    nk = file.nk_fnam
	    if(file.modify) nk = nk + 4	!/mod
c
	    if(nk .gt. nk_f) nk_f = nk
	    p_file = file.link.forw
	    if(.not. all) p_file = 0
	  end if
	end do
c
c Now print the line
c the format is
c Tcc:hh filexx ss
c T  = current         1 char
c hh = handle       nk_h char
c  8 = filetype        8 chars SEQ/FIX + space
c ss = size of file nk_s char
c
c	width = min(nk_f,control.ncols-2-nk_h-1 - len(ftyp) -1 - nk_s - 1)
	width = min(nk_f,control.ncols-2-nk_h-1 - 7 -1 - nk_s - 1)
	kar = 'C'
	line = 'Filename'
	ftyp = 'Type'
	call sys$fao('!AS !#AS !AS !AS !#AS',nk,hline,
     1         kar,
     1         %val(nk_h),%descr('TAG'),ftyp(1:7),
     1         line(1:width),
     1         %val(nk_s),%descr('Size'))
	if(.not. dix_dump_print_line(control,0,hline(1:nk))) goto 90
c
	if(all) then
	  p_file = control.top_file
	else
	  p_file = control.cur_file
	endif
	do while(p_file .ne. 0) 
	  if(file.handle .eq. file_mask .or. 
     1         str$match_wild(file.fnam(1:file.nk_fnam),file_mask)) then
	    ftyp = 'SEQ'
	    if(file.relative) ftyp = 'REL'
	    if(file.indexed ) ftyp = 'IDX'
	    if(file.fixed   ) ftyp(4:) = '/FIX'
c
	    width = min(nk_f,control.ncols-2-nk_h-1 - len(ftyp) -1 - nk_s -1)
	    width = min(nk_f,control.ncols-2-nk_h-1 - 7 -1 - nk_s -1)
	    if(file.modify) width = width - 4	    
	    call lib$trim_filespec(file.fnam(1:file.nk_fnam),line,width,nk)
	    if(file.modify) then
	      line(nk+1:) = '/MOD'
	      width = width + 4
	    else
	      line(nk+1:) = ' '
	    endif
	    kar = ' '
	    if(p_file .eq. control.cur_file) kar = '*'
	    call sys$fao('!AS !#AS !AS !AS !#UL',nk,hline,
     1         kar,
     1         %val(nk_h),
     1         file.handle//' ',ftyp(1:7),
     1         line(1:width),
     1         %val(nk_s),%val(file.filesize))
	    if(.not. dix_dump_print_line(control,0,hline(1:nk))) goto 90
c
	    if(full) then
              call dix_rms_file_info(control,
     1              file.fnam(1:file.nk_fnam),
     1              %val(file.rabadr),%val(0))
	    endif
c
c check if descriptors too
c
	    if(do_descr) then
	      p_des_expanded = file.top_des
	      do while(p_des_expanded .ne. 0) 
	        kar = ' '
	        if(file.cur_des .eq. p_des_expanded) kar = '*'
	        p_des_info = des_expanded.p_des_info
	        ftyp = 'Descr'
	        call dix_des_display(control,des_info,line,nk,.true.)
	        call sys$fao(' !AS!AS !AS !AS !#UL',nk,hline,
     1             kar,' '//des_expanded.handle(1:nk_h-1),ftyp(1:7),
     1             line(1:width),%val(nk_s),%val(des_expanded.n_des))
	        if(.not. dix_dump_print_line(control,0,hline(1:nk))) goto 90
	        p_des_expanded = des_expanded.link.forw
	      enddo
	    end if  
	    p_file = file.link.forw
	    if(.not. all) p_file = 0
	  endif
	end do
	call sys$fao('* means the current file',nk,hline)
	if(do_descr) then
	  call sys$fao('/descriptions',k,hline(nk+1:))
	  nk = nk + k
	endif
	if(.not. dix_dump_print_line(control,0,hline(1:nk))) goto 90
c
90	return
	end
	function dix_dump_inter_sel_file(control,file_mask,err_arg)
	implicit none
c
c LEt the user select a file from the file list
c the match is the fiorst file that matches
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) file_mask         !:i: file mask
	character*(*) err_arg		!:o: error argument
	integer*4 dix_dump_inter_sel_file	!:f: Function result
c
	record /file_info/ file
	pointer (p_file,file)
c
	logical str$match_wild
c
	integer*4 istat
	external dix_msg_nofilmat
c
c case 4 : general file mask
c
	p_file = control.top_file
	do while(p_file .ne. 0)
	  if(file.handle .eq. file_mask .or. 
     1         str$match_wild(file.fnam(1:file.nk_fnam),file_mask)) then
	    control.cur_file = p_file
	    istat = 1
	    goto 90
	  endif
	  p_file = file.link.forw
	end do
	istat = %loc(dix_msg_nofilmat)
	err_arg = file_mask
90	dix_dump_inter_sel_file = istat
	return
	end
	function dix_dump_inter_get_file(control,field,ptr_file,err_arg)
	implicit none
c
c Select a file by tag (or take current)
c
	include 'dix_def.inc'	
	record /control/ control	!:i: control structure
	character*(*) field		!:i: cli token
	integer*4 ptr_file		!:o: pointer to file structure
	character*(*) err_arg		!:o: errorargument
	integer*4 dix_dump_inter_get_file
c
	record /file_info/ file
	pointer (p_file,file)
c
	integer*4 istat
	character*(max_symbol_name_length) tag
c
	external dix_msg_filnotf

	call cli$get_value(field,tag)
c
        if(tag .ne. ' ') then
c
c Now select the correct file
c
          p_file = control.top_file
          do while(p_file .ne. 0)
            if(file.handle .eq. tag) goto 90
            p_file = file.link.forw
          end do
          p_file = 0          !error
        else
c
c It is the current file
c
          p_file = control.cur_file
        endif
90      ptr_file = p_file
        if(p_file .eq. 0) then
	  istat = %loc(dix_msg_filnotf)
	  err_arg = tag
	else
	  istat = 1
	endif
	dix_dump_inter_get_file = istat
	return
	end
	function dix_dump_i_get_keys(file,control,err_arg,trans)
	implicit none
c
	include 'dix_def.inc'
	record /file_info/ file
	record /control/ control
	character*(*) err_arg
	logical trans
	integer*4 dix_dump_i_get_keys
c
	integer*4 key1,keyopt,istat,nk,ios,nkar_key
	logical*4 string,ascending
	integer*4 length
	character*(max_rms_key_name_length) keynam
	character*(max_line_length) line
c
	logical*4 dix_rms_keyinfo
	logical*4 cli$get_value
	logical*4 cli$present
	integer*4 dix_main_get_record
c
	external dix_msg_illkey
	external dix_msg_aslelt
	external dix_msg_degegt
c
	if(file.indexed) then
c
c For indexed file we need 
c  keynr, options(eq,ge,gt), and key_value
c
	  call cli$get_value('KEY',line,nk)  ! goto 70
          read(line(1:nk),2000,iostat=ios) key1
2000      format(bn,i2)
	  if(ios .ne. 0) key1 = -1
c
	  if(.not. dix_rms_keyinfo(file,key1,string,length,
     1               ascending,keynam)) then
	    istat  = %loc(dix_msg_illkey)
	    err_arg = line(1:nk)	
	    goto 90
	  endif
c
c Valid key, now get value
c
	  file.cur_key = key1
c
c In interactive mode (non SMG, from commandline)
c
	  if(ascending) then
c
c For ascewnding keys, accept only eq,ge or gt
c
	    if(cli$present('le') .or. cli$present('lt')) then
	      istat = %loc(dix_msg_aslelt)
	      goto 90
	    endif
	    keyopt = 1
	    call cli$get_value('eq',line,nkar_key)
	    if(nkar_key .eq. 0) then
	      keyopt = 2
	      call cli$get_value('ge',line,nkar_key)
	    endif
	    if(nkar_key .eq. 0) then
	      keyopt = 3
	      call cli$get_value('gt',line,nkar_key)
	    endif
	  else
c
c Descending key accept only eq,le or lt
c
	    if(cli$present('ge') .or. cli$present('gt')) then
	      istat = %loc(dix_msg_degegt)
	      goto 90
	    endif
	    keyopt = 1
	    call cli$get_value('eq',line,nkar_key)
	    if(nkar_key .eq. 0) then
	      keyopt = 2
	      call cli$get_value('le',line,nkar_key)
	    endif
	    if(nkar_key .eq. 0) then
	      keyopt = 3
	      call cli$get_value('lt',line,nkar_key)
	    endif
	  end if
c
c No keyn value , so just seqential read 
c
	  if(nkar_key .eq. 0) keyopt = 0   !signal seq read
	else
c
c File not keyed, so must be record
c
	  call cli$get_value('RECORD',line,nkar_key)	!try to get record#
	  keyopt = 0			!signal seq read
	endif
	istat = dix_main_get_record(control,file,key1,keyopt,
     1            line(1:nkar_key),trans)
90	dix_dump_i_get_keys = istat
	return
	end
	subroutine dix_dump_get_err_lab(control,file_level)
	implicit none
c
	include 'dix_interactive.inc'
	record /control/ control
	record /file_level/ file_level
c
	call dix_dump_get_erreof(control,file_level,
     1             'ERROR',control.error_label)
	return
	end
	subroutine dix_dump_get_eof_lab(control,file_level)
	implicit none
c
	include 'dix_interactive.inc'
	record /control/ control
	record /file_level/ file_level
c
	call dix_dump_get_erreof(control,file_level,'END',control.eof_label)
	return
	end
	subroutine dix_dump_get_erreof(control,file_level,what,label)
	implicit none
c
c Set the /error, and the /end= option
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control structure
	record /file_level/ file_level	!:i: command file level
	character*(*) what		!:i: what to set
	character*(*) label		!:o: the label field
c
	external dix_msg_ignoterm
c
	call cli$get_value(what,label)
	if(label .ne. ' ') then
	  if(file_level.is_term) then
	    call dix_message(control,dix_msg_ignoterm,what)
	    label = ' '
	  endif
	endif
	return
	end
	subroutine dix_dump_inter_show_vm(control,fi)
	implicit none
c
c Display vm info for command levels
c
	include 'dix_interactive.inc'
	record /control/ control
	logical fi
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
c
	p_file_level = control.top_level
	do while (p_file_level .ne. 0) 
	  call dix_util_show_vm1(control,file_level.zone_level,fi,1)
	  p_file_level = file_level.link.forw
	end do
	return
	end
	function dix_inter_execute(control,what,lun,bitsize,fields,ink,idata,
     1            onk,odata,obitsize)
	implicit none
c
	include 'dix_interactive.inc'
	record /control/ control	!:i: control structure
	character*(*) what
	integer*4 lun			!:i: lun with data
	integer*4 bitsize		!:i: size in bits of data
	character*(*) fields		!:i: field values
	integer*4 ink			!:i: size in bytes of data
	byte idata(*)
	integer*4 onk			!:o: output string length
	byte odata(*)			!:o: output data
	integer*4 obitsize
	integer*4 dix_inter_execute
c
	record /file_level/ file_level
	pointer (p_file_level,file_level)
	record /dis_pars/ dis
	record /value/ val
c
	integer*4 istat,descr(2),iterm
	character*(max_line_length) line
c
	integer*4 dix_inter_create_new_level
	logical dix_symbol_find
	integer*4 dix_dump_interactive
c
	external dix_msg_varwrtype
	external dix_msg_varnotf
c
	istat = dix_inter_create_new_level(control)
	if(istat) then
	  p_file_level   = control.cur_level
          call dix_inter_set_default_error(file_level)
	  call memtab_rewind(lun)
	  file_level.lun           = lun
	  file_level.is_call       = .false.
	  file_level.output_opened = .false.
	  file_level.verify        = .false.
	  if(control.debug) file_level.verify = .true.
	  file_level.nk_file       = 0
	  file_level.filename      = ' '
          file_level.lun_out       = control.lun_out
c
	  call dix_symbol_add_str(control,'ACTION',what,line)
c
	  descr(1) = ink
	  descr(2) = %loc(idata)
c
	  call dix_symbol_add_str(control,'DATA',descr,line)
c
	  call dix_symbol_add_str(control,'FIELDS',fields,line)
c
	  if(bitsize .ne. 0) then
	    call dix_symbol_add_int(control,'BITSIZE',bitsize,line)
	  endif
c
	  istat = dix_dump_interactive(control,iterm,dis,.true.)
	  if(istat) then
c
c Now get the data from the symbols
c for SIZE   : size
c for BINASC :          result
c for ascbin : size and result
c
c
            call dix_eval_init_value(val)
c	   
	    if(what .eq. 'SIZE' .or. what .eq. 'ASCBIN') then
              if(dix_symbol_find(control,'SIZE',val)) then
	        if(val.type .eq. symb_typ_int) then
	          call lib$movc3(ONK,val.ival,obitsize)
	        else
                  call dix_message(control,dix_msg_varwrtype,
     1                             %DESCR('SIZE'))
	        endif
	      else
                call dix_message(control,dix_msg_varnotf,'SIZE')
	      endif
	    endif
	    if(what .eq. 'BINASC' .or. what .eq. 'ASCBIN') then
              if(dix_symbol_find(control,'RESULT',val)) then
                if(val.type .eq. symb_typ_char) then
	          onk = zext(val.strdes.dsc$w_maxstrlen)
	          call lib$movc3(onk,%val(val.strdes.dsc$a_pointer),odata)
	        else
	          call dix_message(control,dix_msg_varwrtype,
     1                                     %DESCR('RESULT'))
	        endif
	      else
	        call dix_message(control,dix_msg_varnotf,%DESCR('RESULT'))
	      endif
            endif	!found required symbol
            call dix_eval_free_value(val)
          endif		!dix_dump_inter is oke
	  call dix_inter_close_level(control,.false.)
	endif
	dix_inter_execute = istat
	return
	end	  
