  	options /extend_source
	function dix_dump_screen(control,iterm,dis)
	implicit none
c
c Dump the data in the record data on the screen
c dependend on file.raw display in either interpreted mode, or in raw mode
c
	include 'dix_def.inc'
c
	record /control/ control	!:io: control area
	integer*4 iterm			!:o: typed key
	record /dis_pars / dis		!:i: display parameters
	integer*4 dix_dump_screen	!:f: function result
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	record /des_info/ des
	pointer (p_des,des)
c
	record /file_info/ file		!:i: file information
	pointer (p_file,file)
c
	record /dyn_help/ help_des
	record /link_rec/ link_rec
	record /value/ value
	character*(max_filename_length) link_fnam
	character*(max_short_line_length) line
	integer*4 nk,new_wid,istat
	logical got_help
	logical changed_des,changed_rec
	logical changed_fil
c
	logical*4 dix_rms_delete
	integer*4 dix_rms_get
	integer*4 dix_main_get_rec_int
	integer*4 dix_dump_s_get_keys
	integer*4 dix_main_follow
	integer*4 dix_main_follow_back
c
c
	external dix_msg_nodescr
	external dix_msg_datarest
	external dix_msg_opernotall
c
	include '($smgdef)'
c
	got_help = .false.
	istat = 1
c
c Take the current file
c
	call dix_eval_init_value(value)
1	p_file = control.cur_file
        call dix_symbol_add_str(control,'$FILE',
     1                      file.fnam(1:file.nk_fnam),line)
	call display_header(control,file)
c
c Now take the current description (if any)
c
5	if(file.cur_des .eq. 0) file.cur_des = file.top_des
	p_des_expanded = file.cur_des
	if(p_des_expanded .ne. 0) then
	  p_des = des_expanded.p_des_info
	else
	  p_des = 0
	endif
c
c Create header display
c
	if(.not. file.raw .and. p_des_expanded .eq. 0) then
c
c Check on impossible things
c
	  call dix_message(control,dix_msg_nodescr)
	  file.raw = .true.
	end if
c
c Build help, remove if we had one
c
	if(got_help) then
	  call dix_smg_unstack_help(control)
	  call help_exit(help_des)
	end if
c
	call get_help_lines(control.key_table,help_des,file.raw)
	call dix_smg_stack_help(control,help_des)
	got_help = .true.
c
c Take requested display
c
	if(file.raw) then
	  line = 'Raw'
	else
	  line = 'Interpreted'
	endif
c
	call smg$put_chars(control.dis_kop,line(1:11),2,64,,
     1                 smg$m_bold .or. smg$m_reverse)
c
20	changed_des = .false.
	changed_fil = .false.
c
	if(file.raw) then
c
c Display in raw mode
c
	  call dix_dump_screen_raw(control,iterm,dis,file)
	else
c
c Dump in description mode
c
	  if(p_des .eq. 0) then
	    nk = 0
            call dix_symbol_add_str(control,'$DESCRIPTION',line(1:nk),line)
	  else
            call dix_symbol_add_str(control,'$DESCRIPTION',
     1                  des.fnam(1:des.nk_fnam),line)
	  endif
	  call dix_dump_screen_des(control,des,des_expanded,iterm,
     1        dis,file,link_rec,value,link_fnam)
	end if
c
c check on command's
c
	if(iterm .eq. key_swap_dis) then		!toggle raw/interp
	  file.raw = .not. file.raw
c
c Now build new help
c
	  changed_des = .true.
	elseif(iterm .eq. key_abort) then		!restore record
	  file.data.nb_data = file.data.nb_sav                    !from original read-in
	  call dix_util_copy(file.data.nb_data,file.data.data_sav,
     1                       file.data.data_rec)
	  call dix_message(control,dix_msg_datarest,%val(file.data.nb_data),
     1          %descr('UNDO_AREA'))
	  changed_rec = .true.
	elseif(iterm .eq. key_restore) then
	  call dix_smg_copy_restore(control,control.nb_save,control.save_area,
     1                      file.data.nb_data,file.data.data_rec)
	elseif(iterm .eq. key_dirdes) then              !display descriptions
	  call dix_smg_sel_dirs(control,file)		!and let user select
	  changed_des = .true.	
	elseif(iterm .eq. key_nextdes) then             !take next description
	  if(p_des .eq. 0) then
	    call dix_message(control,dix_msg_nodescr)
	  else
	    p_des_expanded = des_expanded.link.forw
	    if(p_des_expanded .eq. 0) p_des_expanded = file.top_des
	    file.cur_des = p_des_expanded
	    changed_des = .true.	
	  end if
	elseif(iterm .eq. key_prevdes) then             !take previous descrip
	  if(p_des .eq. 0) then
	    call dix_message(control,dix_msg_nodescr)
	  else
	    p_des_expanded = des_expanded.link.backw
	    if(p_des_Expanded .eq. 0) then
	      p_des_expanded = file.top_des
	      do while(des_expanded.link.forw .ne. 0)
	        p_des_expanded = des_expanded.link.forw
	      end do
	    end if
	    file.cur_des = p_des_expanded
	    changed_des = .true.
	  end if
	elseif(iterm .eq. key_remove) then              !delete record
	  istat = dix_rms_delete(control,file)
	  if(istat) istat = dix_rms_get(control,file)
	  changed_rec = .true.
	elseif(iterm .eq. key_ch_width) then              !delete record
	  if(control.ncols .le. norm_screen_width) then
	    new_wid = max_screen_width
	  else
	    new_wid = norm_screen_width
	  endif
	  call smg$change_pbd_characteristics(control.paste_id,new_wid)
	  control.ncols = new_wid
          call smg$change_virtual_display(control.dis_kop,,new_wid)
	  call display_header(control,file)
	elseif(iterm .eq. key_prev_file) then
          p_file = file.link.backw
          if(p_file .eq. 0) then
            p_file = control.top_file
            do while(file.link.forw .ne. 0)
              p_file = file.link.forw
            end do
          endif
	  control.cur_file = p_file
	  changed_fil = .true.
	elseif(iterm .eq. key_next_file) then
          control.cur_file = file.link.forw
          if(control.cur_file .eq. 0) control.cur_file = control.top_file
	  changed_fil = .true.
	elseif(iterm .eq. key_dir_file) then
	  call dix_smg_sel_files(control)
	  changed_fil = .true.
	elseif(iterm .eq. key_next_rec) then
	  istat = dix_rms_get(control,file)
	  if(.not. istat) call dix_message(control,%val(istat))
	  changed_rec = .true.
	elseif(iterm .eq. key_prev_rec) then
          if(file.block_size .eq. 0 .and.
     1      (file.indexed .or. file.relative)) then
            istat = %loc(dix_msg_opernotall)
          else
            istat = dix_main_get_rec_int(control,file,file.rec_nr-1)
	    changed_rec = .true.
          end if
	  if(.not. istat) call dix_message(control,%val(istat))
	elseif(iterm .eq. key_find_rec .or. iterm .eq. key_find_rec1) then
	  call dix_main_search_file(control,file,iterm .eq. key_find_rec1)
	  changed_rec = .true.
	elseif(iterm .eq. key_ask_key) then
	  istat = dix_dump_s_get_keys(file,control)
	  if(.not. istat) call dix_message(control,%val(istat))
	  changed_rec = .true.
	elseif(iterm .eq. key_put) then
	  call dix_main_fill_rec(control,file)
	  file.data.newrec = .true.
	  changed_rec = .true.
	elseif(iterm .eq. key_follow_link) then
	  istat = dix_main_follow(control,dis,.false.,0,link_rec,
     1               value,link_fnam)
	  if(.not. istat) call dix_message(control,%val(istat))
	  changed_fil = .true.
	elseif(iterm .eq. key_back_link) then
	  istat = dix_main_follow_back(control,.true.)
	  if(.not. istat) call dix_message(control,%val(istat))
	  changed_fil = .true.
	elseif(iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_modechange) then
	  goto 90
	end if
c
	if(changed_fil) goto 1
	if(changed_des) goto 5
	if(changed_rec) then
	  call dix_des_expand_all(control,file)
	endif
	goto 20
c
c Remove the help from this module
c
90	istat = 1
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	call dix_eval_free_value(value)
	dix_dump_screen = istat
	return
	end

	subroutine dix_dump_screen_des(control,des,des_Expanded,iterm,
     1                   dis,file,link_rec,value,link_fnam)
	implicit none
c
c Display the data via the descriptions
c
c
	include 'dix_def.inc'
	record /control/ control	!:io: control structure
	record /des_info/ des		!:i: description file information
	record /des_expanded/ des_expanded !:i: expanded des
	integer*4 iterm			!:o: terminator
	record /dis_pars/  dis		!:i: display parameters
	record /file_info/ file		!:i: file information
	record /link_rec/ link_rec	!:o: the link record for follow_link
	record /value/ value		!:o: the value or the follow_link
	character*(*) link_fnam		!:o: the file name for the follow_link
c
	include '($smgdef)'
c
	logical*4 dix_rms_offset_in_key
c
	record /des_rec/ des_rec
c
	integer*4 k,l,nk,row,scr_pos,nk_min,nrows_view,dis_id,dis_cont
	integer*4 page_size,offs,nk_rem,line_nr,nk_disp,video,nk_min_org
	integer*4 max_len,display_nlines,istat
	integer*4 fldnam_des(2),i_des,n_des
	logical*4 top,repaint
c
	structure /admin/
	  integer*4 row_number
	  integer*4 nlines
	  integer*4 idx_des
	end structure
	integer*4  max_admins,n_admins
	parameter (max_admins=4096)
	record /admin/ admins(max_admins)
c
	character*(max_screen_width) line
	byte temp_data(max_buf)
c
	character*(max_command_length) regel
	character*(max_nr_asc_length) nroff
	integer*4 nkar,nlines,nk_off,nlin
	integer*4 col,ibpos,iepos
c
	logical*4 dix_dump_in_modify
	integer*4 dix_dump_set_link
	logical*4 dix_con_typ_is_text
	logical*4 dix_des_expand
	logical*4 dix_util_kar_in_ran
	logical*4 dix_util_get_len_fu
	logical dix_smg_select_field
	integer*4 dix_rms_update
	logical dix_dump_check_deposit
c
	external dix_msg_swcomp
	external dix_msg_nodata
	external dix_msg_novfc
	external dix_msg_recempty
	external dix_msg_nofields
	external dix_msg_reclchg
	external dix_msg_rectrunc

c
c Fill header display
c
	call dix_des_display(control,des,line,nk,.false.)
	if(nk .gt. control.ncols-20) 
     1       call dix_des_display(control,des,line,nk,.true.)
c
	line(nk+1:) = ' '
        call smg$put_chars(control.dis_kop,
     1           'Des file :'//line,3,1,,
     1            smg$m_bold .or. smg$m_reverse)
c
3	line_nr = 1
	scr_pos = 1
c
5	nk = 0
	call dix_dump_screen_dis_count(file.data.nb_data*8,dis.number_hex,
     1                 control.dis_kop,2,9,.false.,6)
c
	call dix_dump_screen_dis_recnr(control.dis_kop,file.rec_nr,
     1                  dis.number_hex)
c
c Try to expand the descriptions, if error go back to raw mode
c
	if(.not. dix_des_expand(control,des_expanded,file)) then
	  iterm = key_swap_dis
	  goto 90
	end if
c
c If conpressed mode wanted, compress it now
c
c	if(dis.compres) call dix_des_compress(des_expanded)
	if(dis.compres) then
	  n_des = des_expanded.nfield_notcompressed
	else
	  n_des = des_expanded.n_des
	endif	  
c
	nk_min_org = des_expanded.max_name_size
	nk_min = min(control.ncols/2,nk_min_org)
c
c If no lines from expand, check for compress mode, 
c   if on , reset and try again
c
	if(n_des .eq. 0) then
	  if(dis.compres) then
	    call dix_message(control,dix_msg_swcomp)
	    dis.compres = .false.
	    n_des = des_expanded.n_des
	  end if
	endif
	if(n_des .eq. 0) then
	  call dix_message(control,dix_msg_nodata)
	end if
c
	if(dis.compres) then
	  line(1:3) = 'Yes'
	else
	  line(1:3) = 'No'
	end if
c
	call smg$put_chars(control.dis_kop,line(1:3),2,38,,
     1             smg$m_bold .or. smg$m_reverse)
c
c Create display big enough (if not it will be increased later)
c
c	display_nlines = 2*des_expanded.n_des+4
	display_nlines = 2*n_des+4
	call smg$create_virtual_display(display_nlines,control.ncols,dis_id)
c
c Compute the size of the offset field form the max data offset
c nk_min is the length of the longest field name
c
7	if(dis.number) then
	  nk_off = 0
	  call dix_util_con_nr(file.data.nb_data*8,des.has_fields,nroff,nk_off,
     1              dis.number_hex)
	  nk_disp = nk_min + nk_off + 1		!+ nk_off digits and 1 :
	else		
	  nk_disp = nk_min 
	end if
c
	col    = nk_disp+2
	nk_rem = control.ncols - nk_disp-1
	nlines = 0
c
c go display all data
c
	n_admins = 0
	do k=1,des_expanded.n_des
c
c Get description
c
	 call dix_des_get_des(des_expanded,k,des_rec,line)
	 if(.not. dis.compres .or. .not. des_rec.compressed) then
	  offs = des_rec.bit_offset  /8
	  if(offs .lt. file.data.nb_data) then
	    n_admins = n_admins + 1
c
c Convert the data to ascii
c
	    call dix_con_intasc(file.data.nb_data-offs,des_rec,
     1              file.data.data_rec,regel,nkar,dis.hex,
     1              max_len,.false.,control)
	    admins(n_admins).row_number = nlines + 1
	    admins(n_admins).idx_des = k
	    video = 0
c
c If the data overlaps with the current key, mark it reversed
c
	    if(dix_rms_offset_in_key(file,offs,des_rec.size/8))
     1          video = smg$m_reverse
	    l = 1
c
c Compute #lines needed, since nkar could be 0, always user 1 line
c
	    admins(n_admins).nlines = max(1,(nkar+nk_rem-1)/nk_rem)
	    do while(nlines+1+admins(n_admins).nlines .ge. display_nlines)
	      display_nlines = display_nlines + 100
	      call smg$change_virtual_display(dis_id,display_nlines)
	    end do
c
c Convert the byte offset
c
	    if(dis.number) then
	      call dix_util_con_nr(des_rec.bit_offset,
     1                    des.has_fields,nroff,nk_off,dis.number_hex)
	      call smg$put_chars(dis_id,nroff,nlines+1,1)
	      l = nk_off+2
	    end if
c
c Display the field name
c
	    if(nk_min .lt. nk_min_org) then
	      call dix_scr_truncate(line,nk_min,des_rec.p_link_rec.ne. 0)
	    endif
	    if(des_rec.p_link_rec .ne. 0) line(nk_min:nk_min) = '>'	    
	    call smg$put_chars(dis_id,line(1:nk_min),nlines+1,l,,video)
c
c display the ascii data in (possibly) multiple lines 
c
	    ibpos =1
	    do l=1,admins(n_admins).nlines
	      nlines = nlines + 1
	      iepos = min(len(regel),l*nk_rem)
	      call smg$put_chars(dis_id,regel(ibpos:iepos),nlines,col,
     1                             smg$m_erase_to_eol)
	      ibpos = iepos + 1
	    end do
	  end if	!still in data rec
	 endif		!compress
	end do
c
c Draw line, (check for special cases  in nlines)
C  0: do nothing
C  1: draw single character
c
	if(nlines .eq. 0) then
	elseif(nlines .eq. 1) then
	  call                smg$draw_char(dis_id,smg$m_up,1,col-1)
	  if(dis.number) call smg$draw_char(dis_id,smg$m_up,1,nk_off+1)
	else
	  call                smg$draw_line(dis_id,1,col-1   ,nlines,col-1)
	  if(dis.number) call smg$draw_line(dis_id,1,nk_off+1,nlines,nk_off+1)
	end if
c
c Now create viewport, save 3 lines for the header
c
	nrows_view = control.nrows-3
c
	call smg$create_viewport(dis_id,scr_pos,1,nrows_view,control.ncols)
	call smg$paste_virtual_display(dis_id,control.paste_id,4,1)
c
	page_size = nrows_view-2
c
c If continouous description display wanted, create it now
c
	if(dis.show_des) call smg$create_virtual_display(1,1,dis_cont)
c
c Start editting./displaying,
c compute requested row, and make sure its in screen
c
10	if(nlines .gt. 0) then
c
c Get the correct des_rec. It is the line_nr'th one if not comnpressed
c   or the line_nr'th uncompressed one
c
	  i_des = admins(line_nr).idx_des
	  call dix_des_get_des(des_expanded,i_des,des_rec,line)
	  row = admins(line_nr).row_number
	else
	  line_nr = 0
	  row = 1
	end if
c
c Display description if wanted
c
	if(dis.show_des) then
	  top = (row-scr_pos) .gt. (nrows_view/2)
	  call display_des(control,dis_cont,des_rec,top,0)
	end if
c
c Get key
c
	call dix_dump_get_key(control,dis_id,row,col,scr_pos,
     1                        nrows_view-admins(line_nr).nlines,
     1                        iterm,dis,nlines,
     1                        des_rec.bit_offset,
     1                        file,.true.,des.has_fields,
     1                        des_expanded)
	col = nk_disp+2
c
c Go exectute the commands
c
	if(iterm .eq. key_prev) then
	  do while(line_nr .gt. 1 .and. 
     1            admins(line_nr).row_number .gt. row-page_size)
	    line_nr = line_nr -1
	  end do
	elseif(iterm .eq. key_next) then
	  do while(line_nr .lt. n_des .and. 
     1                admins(line_nr).row_number .lt. row+page_size)
	    line_nr = line_nr +1
	  end do
	elseif(iterm .eq. key_top) then
	  line_nr = 1
	elseif(iterm .eq. key_bot) then
	  line_nr = n_des
	elseif(iterm .eq. key_up) then
	  if(line_nr .gt. 1) line_nr = line_nr-1
	elseif(iterm .eq. key_down) then
	  if(line_nr .lt. n_des) line_nr = line_nr+1
	elseif(iterm .eq. key_contdis) then
	  if(dis.show_des) then
	    call smg$delete_virtual_display(dis_cont)
	  else
	    call smg$create_virtual_display(1,1,dis_cont)
	  end if
	  dis.show_des = .not. dis.show_des
	elseif(iterm .eq. key_viewvfc) then
	  if(file.data.nb_vfc .gt. 0) then
	    call dix_smg_show_vfc(control,file.data,dis)
	  else
	    call dix_message(control,dix_msg_novfc)
	  endif
	elseif(iterm .eq. key_save) then
	  call dix_smg_copy_save(control,file.data.nb_data,file.data.data_rec,
     1                           control.nb_save,control.save_area)
	elseif(iterm .eq. key_find) then
c
c Find last description just before row
c
	  l = 0
	  do k=1,n_admins
	    if(admins(k).row_number .ge. row) goto 60
	  end do
	  l = n_des
60	  line_nr = l
	elseif(iterm .eq. key_do) then
c
c Update patches
c
	  istat = dix_rms_update(control,file,.true.)
	  if(.not. istat) call dix_message(control,%val(istat))
	elseif(iterm .eq. key_viewdesc) then           !view expanded des
	  call dix_dump_screen_view_des(control,des)
	elseif(iterm .eq. key_viewdes) then
	  call dix_smg_view_des_file(control,des)
	elseif(iterm .eq. key_back_link) then
	  goto 90
	elseif(iterm .eq. key_follow_link) then
	  k = dix_dump_set_link(control,i_des,
     1          %val(des_expanded.des_adr),
     1          line,file,.true.,
     1          link_rec,value,link_fnam)
	  if(k) then
	    iterm = key_follow_link
	    goto 90
	  else
	    nk = dix_util_get_len_fu(line)
	    call dix_message(control,%val(k),line(1:nk))
	  endif
	elseif(iterm .le. key_chdis) then
	  goto 90
	else
	  if(nlines .eq. 0) then
	    call dix_message(control,dix_msg_recempty)
	    goto 10
	  endif
	  if(dix_util_kar_in_ran(iterm) .or. 
     1       iterm .eq. key_enter .or.
     1       iterm .eq. key_right .or.
     1       iterm .eq. key_getfields .or.
     1       iterm .eq. key_erase) then
c
c Character insert mode
c Get the string
c
	    nk = len(regel)
	    if (.not. dis.hex .and. dix_con_typ_is_text(des_rec.ent_type)) then
	      if(.not. des_rec.variable) then
	        nk = des_rec.size/8 - des_rec.nb_reserved
	      end if
	    end if
c
c If getfields, process it
c 
	    if(iterm .eq. key_getfields) then
	      if(des_rec.fld_len .gt. 0 .and. 
     1          des_rec.fieldname_status .ne. fieldnames_none) then
c
c field entry allowed
c	        
	        fldnam_des(1) = des_rec.fld_len
	        fldnam_des(2) = des_rec.fld_adr
                call dix_util_copy_bits(des_rec.size,des_rec.bit_offset,
     1              file.data.data_rec,temp_data,sizeof(temp_data))
c
	        if(dix_smg_select_field(control,temp_data,des_rec.size,
     1           des_rec.fieldname_status .ne. fieldnames_single,
     1           fldnam_des,
     1           des_rec.fieldname_status.eq.fieldnames_multirev,
     1           file.modify)) then
c
c select field oke, insert the data in the buffer
c
	          if(.not. file.modify) goto 10
	          call dix_util_insert_bits(temp_data,des_rec.bit_offset,
     1                des_rec.size,file.data.data_rec)
c
c Now compute new #lines
c
	          call dix_con_intasc(file.data.nb_data-des_rec.bit_offset/8,
     1              des_rec,file.data.data_rec,regel,nkar,
     1              dis.hex,max_len,.true.,control)
c
	          nlin = max(1,(nkar+nk_rem-1)/nk_rem)
	          k = nlin-admins(line_nr).nlines
	          if(k .lt. 0) then
c
c Delete some display lines
c
	            call smg$delete_line(dis_id,row+1,-k)
	          elseif(k .gt. 0) then
c
c Insert Delete some display lines
c
	            line = ' '
	            do l=1,k
	              line(col+1:) = regel((k-1)*nk_rem+1:k*nk_rem)
	              call smg$insert_line(dis_id,row+admins(line_nr).nlines,
     1                    line,smg$m_down)
	            end do
	            call smg$draw_line(dis_id,row,col-1,row+k,col-1)
	            if(dis.number) call smg$draw_line(dis_id,row,nk_off+1,
     1                row+k,nk_off+1)
	          endif
	        else
	          goto 10
	        endif
	      else
	        call dix_message(control,dix_msg_nofields)
	        goto 10      
	      endif
	    else
	      if(.not. dix_dump_in_modify(control,file.modify)) goto 10
c
c let the user edit the data,  get ascii data in regel
c
	      call dix_con_intasc(file.data.nb_data-des_rec.bit_offset/8,
     1             des_rec,file.data.data_rec,regel,nkar,
     1             dis.hex,max_len,.true.,control)
	      nlin = admins(line_nr).nlines
	      l = 0
	      if(dis.number) l = nk_off +1
	      call dix_smg_get_string_multi(control,dis_id,row,col,
     1                        nlin,control.ncols-col+1,regel(1:max_len),
     1                        0,iterm,nkar,l)
	    endif
c
c If editting changed #lines for convert, adapt all des_recs for line_nr
c
	    if(nlin .ne. admins(line_nr).nlines) then
c
c Display length has changed
c Patch all following descriptions to new index on screen
c
	      l = admins(line_nr).nlines - nlin		!so much changed
	      admins(line_nr).nlines = nlin
c
	      do k=line_nr+1,n_admins
	        admins(k).row_number = admins(k).row_number - l
	      end do
	    end if
c
	    call dix_dump_check_deposit(control,file,des_rec,regel(1:nkar),
     1                   dis,repaint,iterm .eq. key_getfields)
c
	    if(repaint) then
	      iterm = key_repaint
	      goto 90
	    endif
c
	    call dix_con_intasc(file.data.nb_data-des_rec.bit_offset/8,
     1             des_rec,file.data.data_rec,regel,nkar,dis.hex,
     1             max_len,.false.,control)
c
c Map, in multiple lines
c
c
	    ibpos = 1
	    do l=1,admins(line_nr).nlines
	      iepos = min(len(regel),l*nk_rem)
	      call smg$put_chars(dis_id,regel(ibpos:iepos),
     1                   l+admins(line_nr).row_number-1,col,
     1                   smg$m_erase_to_eol)
	      ibpos = iepos+1
	    end do
c
c Conversion success
c
	  else
	    call dix_mes_invkey(control)
	  endif
78	end if
	goto 10
90	call smg$delete_virtual_display(dis_id)
	if(iterm .eq. key_compres) then
	  dis.compres = .not. dis.compres
	  line_nr = 1
	  scr_pos = 1
	end if
	if(iterm .gt. key_chmod) goto 5
	if(dis.show_des) call smg$delete_virtual_display(dis_cont)
	return
	end
c
	subroutine dix_dump_screen_dis_count(value,hex,dis_kop,row,col,fldmod,
     1           width)
	implicit none
c
	include 'dix_def.inc'
c
	integer*4 value
	logical*4 hex
	integer*4 dis_kop
	integer*4 row
	integer*4 col
	logical*4 fldmod
	integer*4 width
c
	character*(max_short_line_length) line
	integer*4 nk
c
	include '($smgdef)'
c
	nk = 0
	call dix_util_con_nr(value,fldmod,line,nk,hex)
	if(hex) then
	  line = '%X'//line
	end if
	call smg$put_chars(dis_kop,line(1:width),row,col,,
     1                  smg$m_reverse.or.smg$m_bold)
	return
	end
	function display_des(control,dis_cont,des_rec,top,indent)
	implicit none
c
c Display the current description
c
	include 'dix_def.inc'
	record /control/ control
	integer*4 dis_cont		!:i: the (smg) display (0 if file)
	record /des_rec/ des_rec	!:i: the description record
	logical*4 top                   !:i: top or bottom of display
	integer*4 indent		!:i: indent wanted
	logical display_des		!:F: result of print_line
c
	integer*4 wid,lent,needed_wid,needed_len,nk,nk1,l,k1,k2,lim,minl
	integer*4 infolen,k,maxl,nlext,row,needed_row,idx_line,nb1,fld_des(2)
	logical*4 first,redis,one_line
	logical draw_file,draw_compute,draw_if
	character*(max_screen_width) line
	character kar
c
	logical dix_dump_print_line
	character*(max_tf_asc_length) dix_util_tfas
	integer*4 dix_util_get_len_fu
c
	record /link_rec/ link_rec
	pointer (p_link_rec,link_rec)
c
	record /des_rec_fil/ des_rec_fil
	pointer (p_des_rec_fil,des_rec_fil)
c
c
	include '($smgdef)'
c
	infolen = 11
	display_des = .false.
c
c For screen mode, we must run 2 times
c  1. compute #lines needed and adjust display if <> computed
c  2. disply the data
c
	lim = 1
	if(dis_cont .ne. 0) lim = 2
c
	needed_wid = 0
	needed_len = 4
	draw_file    = .false.
	draw_compute = .false.
	draw_if      = .false.
c
	do k=1,lim
	  if(k .eq. 2) then
c
c Second around, only for screen display
c get current display length
c
	    call smg$get_display_attr(dis_cont,lent,wid)
	    first = lent .eq. 1
c
	    if(top) then
	      needed_row = 5
	    else
	      needed_row = control.nrows-needed_len-1 !leave lowest line free
	    end if
c
c See if still at the correct place
c
	    call smg$get_pasting_info(dis_cont,control.paste_id,l,row)
	    redis = (row .eq. 5) .xor. (needed_row .eq. 5)
c
c Check if redisplay wanted
c
	    if(redis .or.(wid .ne. needed_wid+infolen).or.
     1                   (lent .ne. needed_len)) then
	      lent = needed_len
	      wid = needed_wid+infolen
	      row = needed_row
	      call smg$change_virtual_display(dis_cont,lent,wid,smg$m_border)
	      if(first) then
	       call smg$paste_virtual_display(dis_cont,control.paste_id,
     1                row,control.ncols-wid+1)
	      else
	        call smg$repaste_virtual_display(dis_cont,control.paste_id,
     1                row,control.ncols-wid+1)
	      end if
	    end if
	    call  smg$erase_display(dis_cont)
	    call smg$label_border(dis_cont,'Description')
	    call smg$put_chars(dis_cont,'Type'      ,1,1)
	    call smg$put_chars(dis_cont,'Variable',  2,1)
	    call smg$put_chars(dis_cont,'Dependency',3,1)
	    minl = 4
	    if(draw_file) then
	      call smg$put_chars(dis_cont,'File',4,1)
	      call smg$put_chars(dis_cont,'Key' ,5,1)
	      minl = 6
	      if(link_rec.key_nr .ge. 0) then
	        call smg$put_chars(dis_cont,'Match',minl,1)
	        minl = minl + 1
	      endif
	      if(draw_if) then
	        call smg$put_chars(dis_cont,'If',minl,1)
	        minl = minl + 1
	      endif
	      if(draw_compute) then
	        call smg$put_chars(dis_cont,'Compute',minl,1)
	        minl = minl + 1
	      endif
	    endif
	    call smg$draw_line(dis_cont,1,infolen,min(minl,lent),infolen)
	  end if
c
	  if(des_rec.ent_type .eq. enttyp_user) then
	    p_des_rec_fil = des_rec.link_back
	    line = des_rec_fil.username
	    nk = dix_util_get_len_fu(line)
	  else
	    call dix_util_get_type_name(des_rec.ent_type,line,nk)
	  endif
	  if(nk .eq. 0) then
	    line = 'Unknown'
	    nk = 7
	  endif
	  nk = nk+1
	  line(nk:nk) = '*'
	  nb1 = des_rec.nb_reserved
c
	  if(des_rec.variable) then
	    line(nk:nk+2) = '(*)'
	    nk = nk + 3
	  else
	    k1 = (des_rec.size-nb1*8)/8 
	    k2 = mod(des_rec.size-nb1*8,8)
	    if(k2 .eq. 0) then
	      call sys$fao('!UL',nk1,line(nk+1:),%val(k1))
	    else
	      call sys$fao('!UL.!UL',nk1,line(nk+1:),%val(k1),%val(k2))
	    endif
	    nk = nk + nk1
	    if(des_rec.translate .ne. translate_nor) then
	      if(des_rec.translate .eq. translate_hex) kar = 'H'
	      if(des_rec.translate .eq. translate_oct) kar = 'O'
	      if(des_rec.translate .eq. translate_bin) kar = 'B'
	      line(nk+1:nk+2) = '/'//kar
	      nk = nk + 2
	    endif
            if(des_rec.case .ne. case_no_case) then
              if(des_rec.case .eq. case_upper) line(nk+1:) = '/UP'
              if(des_rec.case .eq. case_lower) line(nk+1:) = '/LO'
              nk = nk + 3
            endif
	  end if
c
	  if(des_rec.ent_type .eq. enttyp_user) then
	    line(nk+1:) = '/USER'
	    nk = nk + 5
	  endif
c
	  needed_wid = max(needed_wid,nk)
	  idx_line = 1
	  if(k .eq. 2)call smg$put_chars(dis_cont,line(1:nk),
     1               idx_line,infolen+1,smg$m_erase_to_eol)
	  if(dis_cont .eq. 0) then
	   if(.not. dix_dump_print_line(control,indent,
     1                 'Type      :'//line(1:nk))) goto 90
	  endif
	  idx_line = idx_line + 1
c
	  line = dix_util_tfas(des_rec.variable)
	  needed_wid = max(needed_wid,5)
	  if(k .eq. 2) call smg$put_chars(dis_cont,line(1:5),
     1                      idx_line,infolen+1)
	  if(dis_cont .eq. 0) then
	    if(.not. dix_dump_print_line(control,indent,
     1                 'Variable  :'//line(1:5))) goto 90
	  endif
	  idx_line = idx_line + 1
c
	  line = dix_util_tfas(des_rec.dependency)
	  needed_wid = max(needed_wid,5)
	  if(k .eq. 2) call smg$put_chars(dis_cont,line(1:5),
     1                idx_line,infolen+1)
	  if(dis_cont .eq. 0) then
	    if(.not. dix_dump_print_line(control,indent,
     1                 'Dependency:'//line(1:5))) goto 90
	  endif
	  idx_line = idx_line + 1
c
c Check on link record to other file
c
	  if(des_rec.p_link_rec .ne. 0) then
c
	    needed_len = needed_len + 1
	    p_link_rec = des_rec.p_link_rec
	    nk =   link_rec.nk_link_file
	    line = link_rec.link_file
	    needed_wid = max(needed_wid,nk)
	    if(k .eq. 2) call smg$put_chars(dis_cont,line(1:nk),
     1                idx_line,infolen+1)
	    if(dis_cont .eq. 0) then
	      if(.not. dix_dump_print_line(control,indent,
     1                 'Link file :'//line(1:nk))) goto 90
	    endif
	    draw_file = .true.
	    idx_line = idx_line + 1
c
	    if(link_rec.key_nr .lt. 0) then
	      line = 'Record'
	      nk = 6
	    else
	      nk = 0
	      call sys$fao('!UL',nk,line,%val(link_rec.key_nr))
	    endif
	    needed_wid = max(needed_wid,nk)
	    needed_len = needed_len + 1
	    if(k .eq. 2) call smg$put_chars(dis_cont,line(1:nk),
     1                idx_line,infolen+1)
	    if(dis_cont .eq. 0) then
	      if(.not. dix_dump_print_line(control,indent,
     1                 'Link field:'//line(1:nk))) goto 90
	    endif
	    idx_line = idx_line + 1
c
	    if(link_rec.key_nr .ge. 0) then
	      call str$element(line,link_rec.match+2,',','LT,LE,EQ,GE,GT')
	      nk = 2
	      needed_wid = max(needed_wid,nk)
	      needed_len = needed_len + 1
	      if(k .eq. 2) call smg$put_chars(dis_cont,line(1:nk),
     1                idx_line,infolen+1)
	      if(dis_cont .eq. 0) then
	        if(.not. dix_dump_print_line(control,indent,
     1                 'Match     :'//line(1:nk))) goto 90
	      endif
	      idx_line = idx_line + 1
	    endif
c
	    if(link_rec.nk_if .gt. 0) then
	      draw_if = .true.
	      line = link_rec.if_line
	      nk   = link_rec.nk_if
	      needed_wid = max(needed_wid,nk)
	      needed_len = needed_len + 1
	      if(k .eq. 2) call smg$put_chars(dis_cont,line(1:nk),
     1                idx_line,infolen+1)
	      if(dis_cont .eq. 0) then
	        if(.not. dix_dump_print_line(control,indent,
     1                 'If        :'//line(1:nk))) goto 90
	      endif
	      idx_line = idx_line + 1
	    endif
c
	    if(link_rec.nk_compute .gt. 0) then
	      draw_compute = .true.
	      line = link_rec.comp_line
	      nk   = link_rec.nk_compute
	      needed_wid = max(needed_wid,nk)
	      needed_len = needed_len + 1
	      if(k .eq. 2) call smg$put_chars(dis_cont,line(1:nk),
     1                idx_line,infolen+1)
	      if(dis_cont .eq. 0) then
	        if(.not. dix_dump_print_line(control,indent,
     1                 'Computinfo:'//line(1:nk))) goto 90
	      endif
	      idx_line = idx_line + 1
	    endif
	  endif
c
	  if(des_rec.variable .or. nb1 .ne. 0) then
	    needed_len = needed_len + 1
	    if(nb1 .gt. 0) then
	      call sys$fao('!UL',nk,line,%val(des_rec.act_size/8))
	    else
	      call sys$fao('!UL',nk,line,%val(des_rec.size/8))
	    endif
	    needed_wid = max(needed_wid,nk)
	    if(k .eq. 2) then
	      call smg$put_chars(dis_cont,'Cur_size',idx_line,1)
	      call smg$put_chars(dis_cont,line(1:nk),idx_line,infolen+1,
     1                        smg$m_erase_to_eol)
	    end if
	    if(dis_cont .eq. 0) then
	      if(.not. dix_dump_print_line(control,indent,
     1                 'Cur_size  :'//line(1:nk))) goto 90
	    endif
	    idx_line = idx_line + 1
	  end if
c
	  if(des_rec.min_val .ne. des_rec.max_val) then
	    needed_len = needed_len + 1
	    call sys$fao('!UL-!UL',nk,line,%val(des_rec.min_val),
     1                %val(des_rec.max_val))
	    needed_wid = max(needed_wid,nk)
	    if(k .eq. 2) then
	      call smg$put_chars(dis_cont,'Range',idx_line,1)
	      call smg$put_chars(dis_cont,line(1:nk),idx_line,infolen+1,
     1                        smg$m_erase_to_eol)
	    end if
	    if(dis_cont .eq. 0) then
	      if(.not. dix_dump_print_line(control,indent,
     1                 'Range     :'//line(1:nk))) goto 90
	    endif
	    idx_line = idx_line + 1
	  endif
c
	  if(des_rec.fld_len .gt. 0) then
	    nk    = max(needed_wid+infolen,40)	!width in this case
	    maxl  = control.nrows-idx_line-1		!max length in this case
	    if(dis_cont .eq. 0) then
	      if(.not. dix_dump_print_line(control,indent,'Fields    :')) 
     1                  goto 90
	      fld_des(1) = des_rec.fld_len
	      fld_des(2) = des_rec.fld_adr
	      if(.not. dix_dump_print_line(control,indent+4,fld_des)) goto 90
	    endif
	    if(des_rec.fld_len .le. nk-infolen) then
	      one_line = .true.
	      needed_len = needed_len + 1
	      needed_wid = max(needed_wid,des_rec.fld_len)
	    else
	      one_line = .false.
c
c Takes more than one line, compute how many extra
c
	      needed_wid = nk-infolen
	      nlext = min(maxl,(des_rec.fld_len+nk-1)/nk+1)
	      needed_len = needed_len + nlext
	    end if
	    if(k .eq. 2) then
	      fld_des(1) = des_rec.fld_len
	      fld_des(2) = des_rec.fld_adr
	      if(one_line) then
	        call smg$put_chars(dis_cont,'Values',idx_line,1)
	        call smg$put_chars(dis_cont,fld_des,idx_line,infolen+1,
     1                        smg$m_erase_to_eol)
	      else
	        call smg$draw_line(dis_cont,idx_line,1,idx_line,wid)
	        call smg$put_chars(dis_cont,'Values',idx_line,(wid-6)/2)
	        nlext = min(maxl,(des_rec.fld_len+nk-1)/nk+2)
	        do l=1,nlext	        
	          fld_des(1) = min(nk,des_rec.fld_len-(l-1)*nk)
	          call smg$put_chars(dis_cont,fld_des,idx_line+l,1,
     1                        smg$m_erase_to_eol)
	          fld_des(2) = fld_des(2) + nk
	        enddo
	      endif
	    end if
	  end if 
	end do
c
	display_des = .true.
90	return
	end

	subroutine dix_dump_get_key(control,dis_id,row,col,scr_pos,max_pos,
     1                              iterm,dis,nlines,
     1                              offset_in,file,
     1                              des_mode,has_fields,
     1                              des_expanded)
	implicit none
c
c Return a key from the user
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file		!:i: file information
	record /dis_pars/  dis		!:i: display parameters
	integer*4 dis_id		!:i: display id for data
	integer*4 row			!:io: current row
	integer*4 col			!:io: current col
	integer*4 scr_pos		!:io: screen pos (view position in display)
	integer*4 max_pos
	integer*4 iterm			!:o: terminatoir (typed key)
	integer*4 nlines		!:i: #lines in disoplay
	integer*4 offset_in		!:i: current byte offset in data record
	logical*4 des_mode		!:i: des/raw mode
	logical*4 has_fields		!:i: does description contain bitfields
	record /des_expanded/ des_expanded !:i: expanded des
c
	logical*4 modified
	integer*4 k,offset
c
c Check if top line in screen
c
	include '($smgdef)'
c
	logical*4 dix_smg_find_string
	logical*4 dix_dump_in_modify
	logical*4 dix_smg_question
	logical*4 dix_smg_get_int
c
	external dix_msg_notindes
	external dix_msg_notinraw
	external dix_msg_recempty
	external dix_msg_notindex
	external dix_msg_fixfile
	external dix_msg_notfixfile
c
	integer*4 max_smooth_scroll
	parameter (max_smooth_scroll=20)
c
c Start of coding
c
	offset = offset_in
	k = 0
c
	call dix_dump_screen_dis_count(offset_in,dis.number_hex,
     1               control.dis_kop,2,23,has_fields,6)
c
c Make sure position is in the screen
c
	do while(row .lt. scr_pos)
	  if(scr_pos-row .lt. max_smooth_scroll) then
	    k = 1
	  else
	    k = scr_pos-row
	  end if
	  scr_pos = scr_pos-k
	  call smg$scroll_viewport(dis_id,smg$m_down,k)
	end do
c
c Make sure bottom line is in screen, 
c
	do while(row-scr_pos .ge. max_pos)
	  if(row-scr_pos-max_pos .lt. max_smooth_scroll) then
	    k = 1
	  else
	    k = row-scr_pos-max_pos
	  end if
	  scr_pos = scr_pos+k
	  call smg$scroll_viewport(dis_id,smg$m_up,k)
	end do
	goto 10
c
c Some error messages
c
7	call dix_message(control,dix_msg_recempty)
	goto 10
c
c Illegal command for this mode
c
8	if(des_mode) then
	  call dix_message(control,dix_msg_notindes)
	else
	  call dix_message(control,dix_msg_notinraw)
	end if
c
c Set cursor, read key
c
10	call smg$set_cursor_abs(dis_id,row,col)
	call dix_get_key(control,iterm)
c
	if(control.bold_set) then
	  call smg$change_rendition(dis_id,control.row_bold,control.col_bold,
     1                              1,control.nk_sear,0)
	  control.bold_set = .false.
	end if
c
c Split out commands
c
	if(iterm .eq. key_byte) then
	  if(des_mode) goto 8
	elseif(iterm .eq. key_contdis) then
	  if(.not. des_mode) goto 8
	elseif(iterm .eq. key_fileinfo) then
	  call dix_smg_file_info_scr(control,%val(file.rabadr),
     1                   file.fnam(1:file.nk_fnam),des_expanded)
	  goto 10
	elseif(iterm .eq. key_getfields) then
	  if(.not. des_mode) goto 8
	elseif(iterm .eq. key_hexdec) then
	  k = 0
	  if(dis.hex)        k = k + 1
	  if(dis.number_hex) k = k + 2
	  k = mod(k+1,4)
	  dis.hex        = (k .and. 1) .ne. 0
	  dis.number_hex = (k .and. 2) .ne. 0
	elseif(iterm .eq. key_put) then
	  if(.not. dix_dump_in_modify(control,file.modify)) goto 10
	  if(.not. file.indexed) then
	    call dix_message(control,dix_msg_notindex)
	    goto 10
	  end if
	elseif(iterm .eq. key_long) then
	  if(des_mode) goto 8
	elseif(iterm .eq. key_print) then
	  call dix_dump_screen_print(control,dis_id,nlines,file)
	  goto 10
	elseif(iterm .eq. key_remove) then
	  if(.not. dix_dump_in_modify(control,file.modify)) goto 10
	  if(.not. file.indexed) then
	    call dix_message(control,dix_msg_notindex)
	    goto 10
	  end if
	  if(.not. dix_smg_question(control,
     1      'Deleting record; Are you sure',.false.)) goto 10
	elseif(iterm .eq. key_dispall) then
	  if(nlines .eq. 0) goto 7
	  call dix_dump_display_all(control,offset_in,file.data,file,modified)
	  if(modified) then
	    iterm = key_chdis
	  else
	    goto 10
	  end if
	elseif(iterm .eq. key_newreclen) then
	  if(.not. dix_dump_in_modify(control,file.modify)) goto 10
	  if(file.fixed) then
	    call dix_message(control,dix_msg_fixfile)
	  else
	    if(.not. file.indexed) then
	      call dix_message(control,dix_msg_notindex)
	    else
	      k = offset
	      if(dix_smg_get_int(control,'recordlength',k,
     1                     file.minrecl,file.maxrecl)) then
	        file.data.nb_data = k
	      end if
	    end if
	  end if
	elseif(iterm .eq. key_viewdesc) then
	  if(.not. des_mode) goto 8
	elseif(iterm .eq. key_viewdes) then
	  if(.not. des_mode) goto 8
	elseif(iterm .eq. key_word) then
	  if(des_mode) goto 8
	elseif(iterm .eq. key_page) then
	  if(control.forward) then
	    iterm = key_next
	  else
	    iterm = key_prev
	  end if
	elseif(iterm .eq. key_set_forw) then
	  control.forward = .true.
	  goto 10
	elseif(iterm .eq. key_set_backw) then
	  control.forward = .false.
	  goto 10
	elseif(iterm .eq. key_find .or. iterm .eq. key_find1) then
	  if(nlines .eq. 0) goto 7
	  if(iterm .eq. key_find1) control.nk_Sear = 0
	  control.row_bold = row
	  if(dix_smg_find_string(control,dis_id,control.nk_sear,control.sear,
     1               control.row_bold,control.col_bold,
     1               nlines,control.forward)) then
	    control.bold_set = .true.
	    row = control.row_bold
	    col = control.col_bold
	    call smg$change_rendition(dis_id,control.row_bold,
     1             control.col_bold,1,control.nk_sear,smg$m_bold)
	  else
	    goto 10
	  end if
	  iterm = key_find
	elseif(iterm .eq. key_binasc) then
	  if(des_mode) goto 8
	elseif(iterm .eq. key_swap_num) then
	  dis.number = .not. dis.number
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	  goto 10
	elseif(iterm .eq. key_contdis) then
	  if(.not. des_mode) goto 8
	elseif(iterm .eq. key_do) then
	  if(.not. dix_dump_in_modify(control,file.modify)) goto 10
	end if
90	return
	end

	function dix_dump_in_modify(control,mod) 
	implicit none
c
c Check if in /mod mode, if not give message
c
	include 'dix_def.inc'
	record /control/ control
	logical*4 mod 			!:i: modify mode??
	logical*4 dix_dump_in_modify	!:f: true if in modify mode
c
	external dix_msg_notinmod
c
	dix_dump_in_modify = mod
	if(.not. mod) call dix_message(control,dix_msg_notinmod)
	return
	end 		

	subroutine dix_dump_screen_raw(control,iterm,dis,file)
	implicit none
c
c Dump record in raw mode
c
	include 'dix_def.inc'
c
	record /control/ control
	integer*4 iterm			!:o: terminator
	record /dis_pars/ dis		!:i: display parameters
	record /file_info/ file		!:i: file information
c
	include '($smgdef)'
c
	integer*4 dis_id,nrows_view,row,col,scr_pos,k,nlines,page_size
	integer*4 ipos,l,posasc,nkar,offset,indx,incr,kpl,fldsiz
c
	character*(max_screen_width) line
	character kar
c
	record /des_rec/ des_rec
c
	logical*4 ascdis
	logical*4 dix_dump_in_modify
	integer*4 dix_util_hex_kar
	external dix_msg_nodata
	external dix_msg_novfc
	external dix_msg_illhexchar
	external dix_msg_illval
c
	integer*4 val
c
c local vars
c
c	logical*4 dix_con_int_ascint
	logical*4 dix_con_ascint
c
c start, display 16 values on 1 line
c
	call smg$put_chars(control.dis_kop,'  ',2,38,,
     1              smg$m_bold.or.smg$m_reverse)
c
	scr_pos = 1
	row     = 1 
	col     = 1
	indx    = 0
	ascdis  = .false.
c
5	ipos=0
c
	if(dis.hex) then
	  line = 'Hex'
	else
	  if(dis.unsigned) then
	    line = 'Unsigned'
	  else
	    line = 'Signed'
	  endif
	endif
	call smg$put_chars(control.dis_kop,line(1:8),2,68,,
     1                 smg$m_bold .or. smg$m_reverse)
c
	call dix_dump_vars(control,dis,kpl,fldsiz,posasc)
	nlines     = (file.data.nb_data+kpl-1)/kpl 
	nrows_view = control.nrows-3
	call smg$create_virtual_display(nlines+1,control.ncols,dis_id)
c
	nkar = 0
	call dix_dump_screen_dis_count(file.data.nb_data*8,dis.number_hex,
     1                 control.dis_kop,2,9,.false.,6)
C
	call dix_dump_screen_dis_recnr(control.dis_kop,file.rec_nr,
     1           dis.number_hex)
C
c
	do k=1,nlines
	  call dix_dump_screen_raw_line(control,dis_id,k,kpl,file,
     1                    dis,posasc,fldsiz)
	end do
c
c
	if(dis.word .eq. 1) then
	  fldsiz = 5
	elseif(dis.word .eq. 2) then
	  fldsiz = 6
	else
	  fldsiz = 11
	end if
c
	line = ' '
	do k=0,kpl-1
c
c Take the low 4 bits (in 32 byte display two times the same)
c
	  l = iand(k,15)
c
	  if(l .gt. 9) then	 	  
	    kar = char(l+ichar('A')-10)
	  else
	    kar = char(l+ichar('0'))
	  end if
c
c Now kar = 0..9 or A..Z
c and kar1 = space 0 or 1
c now insert kar in ascii mode
c
	  line(posasc+k+1:posasc+k+1) = kar
	  l = -1
	  if(dis.hex) then
	    l = k*2+2 + k/dis.word
	  else
	    if(mod(K,dis.word) .eq. 0) l = (k/dis.word+1)*fldsiz
	  end if
	  if(l .gt. 0) line(l:l) = kar
	end do
	call smg$put_chars(control.dis_kop,line(1:control.ncols),3,1,,
     1              smg$m_bold .or. smg$m_reverse)
c
	page_size  = nrows_view-2
c
	call smg$create_viewport(dis_id,scr_pos,1,nrows_view,control.ncols)
	call smg$paste_virtual_display(dis_id,control.paste_id,4,1)
c
	dis.compres = .false.
	if(file.data.nb_data .eq. 0) then
	  call dix_message(control,dix_msg_nodata)
	end if
c
c index is nibble offset (for hex display
c offset is byte offset (=indx/2)
c
10	indx = max(0,indx)
	indx = min(file.data.nb_data*2-1,indx)
	offset = indx/2
c
c Comput row/col on screen
c 3 modes
c 1. Ascii mode
c 2. Binary/hex
c 2. binary/dec 
c
	row    = offset/kpl+1
	if(ascdis) then
c
c Mode 1 ascii
c
	  incr   = 2
	  col    = posasc + mod(offset,kpl) + 1
	else
	  col = mod(indx,kpl*2)
	  if(dis.hex) then
c
c mode 2 binary/hex
c
	    k    = kpl*2-col-1
	    col  = k+1+k/(dis.word*2)
	    incr = -1
	  else
c
c Mode 3, binary /decimal, now input right_justified
c
	    k = kpl/dis.word-col/(dis.word*2)
	    incr = dis.word*2
	    col = k*fldsiz
	  end if
	end if
c
	call dix_dump_get_key(control,dis_id,row,col,scr_pos,nrows_view,
     1            iterm,dis,nlines,offset*8,file,
     1            .false.,.false.,%val(0))
c
c Set cursor
c
	if(iterm .eq. key_prev) then
	  indx = indx - page_size*kpl*2
	elseif(iterm .eq. key_next) then
	  indx = indx + page_size*kpl*2
	  row = min(row + page_size,nlines)
	elseif(iterm .eq. key_left) then
	  indx = indx-incr
	elseif(iterm .eq. key_right) then
	  indx = indx+incr
	elseif(iterm .eq. key_bot) then
	  indx = file.data.nb_data*2-1
	elseif(iterm .eq. key_compres) then
	  dis.unsigned = .not. dis.unsigned
	  goto 90			!let redisplay
	elseif(iterm .eq. key_top) then
	  indx = 0
	elseif(iterm .eq. key_find) then
c
c Got
c
	  ascdis = col .ge. posasc
	  if(ascdis) then
	    col = col-posasc-1
	    if(col .ge. kpl) col = kpl-1
	    indx = ((row-1)*kpl + col)*2
	  else
	    if(dis.hex) then
c
c Col is 
c
	      col = col - (col-1)/(dis.word*2+1)
	      indx = (row-1)*2*kpl + 2*kpl-col
	    else
	      if(dis.word .eq. 1) then
	        fldsiz = 5
	      elseif(dis.word .eq. 2) then
	        fldsiz = 6
	      else
	        fldsiz = 11
	      end if
	      col = kpl/dis.word - (col-1)/fldsiz - 1
	      indx = (row-1)*2*kpl + col*dis.word*2
	    end if
	  end if
	elseif(iterm .eq. key_up) then
	  indx = indx-kpl*2
	elseif(iterm .eq. key_down) then
	  indx = indx+kpl*2
	elseif(iterm .eq. key_viewvfc) then
	  if(file.data.nb_vfc .gt. 0) then
	    call dix_smg_show_vfc(control,file,dis)
	  else
	    call dix_message(control,dix_msg_novfc)
	  endif
	elseif(iterm .eq. key_binasc) then
	  ascdis = .not. ascdis
	elseif(iterm .eq. key_save) then
	  call dix_smg_copy_save(control,file.data.nb_data,file.data.data_rec,
     1                           control.nb_save,control.save_area)
	elseif(iterm .eq. key_long) then
	  dis.word = 4
	  goto 90			!let redisplay
	elseif(iterm .eq. key_word) then
	  dis.word = 2
	  goto 90			!let redisplay
	elseif(iterm .eq. key_byte) then
	  dis.word = 1
	  goto 90			!let redisplay
	elseif(iterm .eq. key_do) then
	  call dix_rms_update(control,file,.true.)
	elseif(iterm .le. key_chdis) then
	  goto 90
	else
c
c Character insert mode
c
	  if(iterm .lt. 0 .and. iterm .ne. key_enter) then
	    call dix_mes_invkey(control)
	  else
	    if(.not. dix_dump_in_modify(control,file.modify)) goto 10
	    if(ascdis) then
	      call lib$movc3(1,iterm,file.data.data_rec(offset+1))
	    else
	      if(dis.hex) then
	        iterm = dix_util_hex_kar(iterm)
	        if(iterm .lt. 0) then
	          call dix_message(control,dix_msg_illhexchar)
	          goto 10
	        end if
c
c Now update buffer
c
	        val = 0	        
	        call lib$movc3(1,file.data.data_rec(offset+1),val)
	        if(mod(indx,2) .eq. 0) then
c
c Patch low nibble
c
	          val = iand(val,'F0'X)+iterm
	        else
c
c Patch high nibble
c
	          val = iand(val,'0F'X)+(iterm*16)
	        end if
	        call lib$movc3(1,val,file.data.data_rec(offset+1))
	      else
c
c binary dump/decimal, now let user type string
c
	        call dix_smg_get_string(control,dis_id,row,col,fldsiz,line,0,
     1                         iterm,nkar,.true.)
	        des_rec.fld_adr = 0
	        des_rec.fld_len = 0
	        des_rec.size    = dis.word*8
	        des_rec.bit_offset = offset*8
	        des_rec.translate  = translate_nor
	        if(dis.unsigned) then
	          des_rec.ent_type = enttyp_uint
	        else
	          des_rec.ent_type = enttyp_int
	        endif
	        if(dix_con_ascint(line(1:nkar),file.data.data_rec,
     1              des_rec,.false.,k,control)) then
	        else
	          call dix_message(control,dix_msg_illval)
	        end if
	      end if
	    end if
	    call dix_dump_screen_raw_line(control,dis_id,row,kpl,file,dis,
     1                    posasc,fldsiz)
	    indx = indx+incr
	  end if
	endif
	goto 10
90	call smg$delete_virtual_display(dis_id)
	if(iterm .gt. key_chmod) goto 5
	return
	end


	subroutine dix_dump_screen_raw_line(control,dis_id,linenr,kpl,file,dis,
     1                        posasc,fldsiz)
	implicit none
c
c dump data bytes in raw mode on screen
c
	include 'dix_def.inc'
	record /control/ control	!:i: contol block
	integer*4 dis_id		!:i: display id
	integer*4 linenr		!:i: linenr requested
	integer*4 kpl			!:i: #bytes/line
	record /file_info/ file		!:i: file info
	record /dis_pars/ dis		!:i: display parameters
	integer*4 posasc		!:i: ascii position
	integer*4 fldsiz		!:i: field size
c
	integer*4 begpos_bol(50),endpos_bol(50)
	integer*4 n_bol,nkar,k
	character*(max_screen_width) line
c
	include '($smgdef)'
c
c Convert to ascii
c
	call dix_dump_raw_line(control,(linenr-1)*kpl,kpl,file.data.nb_data,
     1                file.data.data_rec,dis,posasc,
     1                begpos_bol,endpos_bol,n_bol,line,nkar,
     1                fldsiz,file)
c
c To screen
c
	call smg$put_chars(dis_id,line(1:nkar),linenr,1)
c
c Highlight key fields
c
	do k=1,n_bol
	  call smg$change_rendition(dis_id,linenr,begpos_bol(k),1,
     1             endpos_bol(k)-begpos_bol(k)+1,smg$m_reverse)
	end do
c
	return
	end

	subroutine dix_dump_display_all(control,offset_in,data,file,modified)
	implicit none
c
c Display data in all formats, and let user modify (if /mod )
c
	include 'dix_def.inc'
	record /control/ control
	record /data_info/ data		!:i: display id
	record /file_info/ file		!;I; file information
	integer*4 offset_in		!:i: start offset
	logical*4 modified		!:o: true if byte modified
c
	record /dyn_help/ help_des
	record /des_rec/ des_rec
c
	integer*4 iterm,dis_id,nkar,offset,k,col,ind,row,gotnr,l,offset_old
	integer*4 max_len,width
	character*(max_screen_width) line
	logical*4 hex
c
	include '($smgdef)'
c
	logical*4 dix_util_kar_in_ran
	logical*4 dix_dump_in_modify
	logical*4 dix_con_ascint
c
	integer*4 n_convs
	parameter (n_convs=19)
	integer*4 con_types(n_convs)
	integer*4 con_sizes(n_convs)
	integer*4  max_names_width
	parameter (max_names_width=11)
	character*(max_names_width) con_names(n_convs)
	logical*1 con_valid(n_convs)
c
	data con_types/enttyp_int   ,enttyp_int   ,enttyp_int   ,
     1                 enttyp_uint  ,enttyp_uint  ,enttyp_uint  ,
     1                 enttyp_real  ,enttyp_real  ,enttyp_real  ,
     1                 enttyp_realg,
     1                 enttyp_log   ,enttyp_uic   ,enttyp_chr   ,
     1                 enttyp_dat   ,enttyp_dat   ,enttyp_prot  ,
     1                 enttyp_revint,enttyp_fid   ,enttyp_bits/
	data con_sizes/            1,            2,            4,
     1                             1,            2,            4,
     1                             4,            8,           16,
     1                             8,
     1                             1,            4,            4,
     1                             4,            8,            2,
     1                             4,            6,            1/
	data con_names/'INTEGER*1  ','INTEGER*2  ','INTEGER*4  ',
     1                 'UINTEGER*1 ','UINTEGER*2 ','UINTEGER*4 ',
     1                 'REAL*4     ','REAL*8     ','REAL*16    ',
     1                 'REALG*8    ',
     1                 'LOGICAL*1  ','UIC        ','CHARACTER*4',
     1                 'DATE*4     ','DATE*8     ','PROTECTION',
     1                 'RINTEGER   ','FILEID     ','BITS      '/
c
	external dix_msg_converr
c
c Create help page
c
	call help_init(help_des,'Dump_all formats',20,0)
c
	call help_topic(help_des,'Moves')
	call help_key(control.key_table,help_des,key_left,
     1              'offset one position left')
	call help_key(control.key_table,help_des,key_right,
     1              'Offset one position right')
	call help_key(control.key_table,help_des,key_up,'previous item')
	call help_key(control.key_table,help_des,key_down,'next item')
	call help_key(control.key_table,help_des,key_swap_dis,
     1              'Toggle hex/decimal input')
	call help_key(control.key_table,help_des,key_swap_num,
     1              'Lets user input new offset')
	call help_key(control.key_table,help_des,key_top,'first line')
	call help_key(control.key_table,help_des,key_bot,'last line')
	call help_topic(help_des,'other keys')
c
	call help_key(control.key_table,help_des,key_exit,
     1                'exit show mode')
	call help_text(help_des,
     1   'Enter or Printable character will enter edit field')
	call dix_smg_stack_help(control,help_des)
c
	offset = offset_in/8
	modified = .false.
c
	col = sizeof(con_names(1))+2
c
c We need to display 16 bytes (space,xx) so the 16*3
c
	width = col+16*3 + 2
	call smg$create_virtual_display(n_convs+2,width,dis_id)
	call smg$paste_virtual_display(dis_id,control.paste_id,2,
     1          control.ncols-width-1)
c
	call smg$put_chars(dis_id,'Raw data',1,1)
	do k=1,n_convs
	  call smg$put_chars(dis_id,con_names(k),k+2,1)	  
	end do
	call smg$draw_line(dis_id,2,col-1,2,width)
	call smg$draw_line(dis_id,1,col-1,n_convs+2,col-1)
c
	ind = 1
10	call sys$fao('All format display at offset !UL',nkar,line,
     1            %val(offset))
	call smg$label_border(dis_id,line(1:nkar))

	line = ' '
	do k=1,16
	  write(line(k*3-2:k*3-1),1010) data.data_rec(offset+k)
1010	  format(z2.2)
	end do
c
	call smg$put_chars(dis_id,line,1,col) !,,smg$m_underline)
c
	gotnr = 0
	do k=1,n_convs
	  l = con_sizes(k)
	  if(l+offset-1 .ge. data.nb_data) then
	    line = '**OUT OF BUFFER**'
	    nkar = 20
	    con_valid(k) = .false.
	  else
	    des_rec.ent_type = con_types(k)
	    des_rec.size     = con_sizes(k)*8
	    des_rec.fld_len  = 0
	    des_rec.fld_adr  = 0	    
	    des_rec.min_val  = 0	    
	    des_rec.max_val  = 0	    
	    des_rec.nb_reserved =0
	    des_rec.variable = .false.
	    call dix_con_intasc(con_sizes(k),des_rec,
     1          data.data_rec(offset+1),line,nkar,hex,
     1                      max_len,.false.,control)
	    if(gotnr .eq. 0) gotnr = k
 	    con_valid(k) = .true.
	  end if
	  call smg$put_chars(dis_id,line(1:nkar),k+2,col,smg$m_erase_to_eol)
	end do
20	if(.not. con_valid(ind)) ind = gotnr
	row = ind+2
c	  
	call smg$set_cursor_abs(dis_id,row,col)
	call dix_get_key(control,iterm)
c
	offset_old = offset
c
	if(iterm .eq. key_top) then
	  ind = 1
	  do while(.not. con_valid(ind))
	    ind = ind+1
	  end do	   
	elseif(iterm .eq. key_up) then
	  k = ind-1	    
	  do while(k .gt. 1 .and. .not. con_valid(k)) 
	    k = k-1
	  end do
	  if(con_valid(k)) ind = k
	elseif(iterm .eq. key_swap_dis) then
	  hex = .not. hex
	  goto 10
	elseif(iterm .eq. key_swap_num) then
	  call dix_smg_get_int(control,'Offset value',offset,
     1                0,data.nb_data-1)
	elseif(iterm .eq. key_bot) then
	  ind = n_convs
	  do while (.not. con_valid(ind))
	    ind = ind-1
	  end do
	elseif(iterm .eq. key_down) then
 	  k = ind+1
	  do while(k .lt. n_convs .and. .not. con_valid(k))
	    k = k+1
	  end do
	  if(con_valid(k)) ind=k
	elseif(iterm .eq. key_left) then
	  offset = max(0,offset-1)
	elseif(iterm .eq. key_right) then
	  offset = min(data.nb_data-1,offset+1)
	elseif(iterm .eq. key_help) then

	  call dix_smg_help(control)
	elseif(iterm .eq. key_exit) then
	  goto 90
	elseif(dix_util_kar_in_ran(iterm) .or.
     1          iterm .eq. key_enter) then
	  if(dix_dump_in_modify(control,file.modify)) then
	    call dix_smg_get_string(control,dis_id,row,col,30,
     1           line,0,iterm,nkar,.false.)
	    des_rec.ent_type = con_types(ind)
	    des_rec.size     = con_sizes(ind)*8
	    des_rec.fld_len  = 0
	    des_rec.fld_adr  = 0	    
	    des_rec.nb_reserved =0
	    des_rec.variable = .false.
	    if(dix_con_ascint(line(1:nkar),data.data_rec(offset+1),
     1                 des_rec,hex,k,control)) then
	      modified = .true.
	    else
	      call dix_message(control,dix_msg_converr)
	    end if
	    goto 10
	  end if
	else
	  call dix_mes_invkey(control)
	end if
	if(offset .ne. offset_old) goto 10
	goto 20
90	call smg$delete_virtual_display(dis_id)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end

	subroutine dix_dump_screen_print(control,dis_id,nlines,file)
	implicit none
c
	include 'dix_def.inc'
c
	record /control/control
	integer*4 dis_id		!:i: the display to be printed
	integer*4 nlines		!:i: this dispay contains # lines
	record /file_info/ file		!:i: file information
c
	integer*4 lun,k,iterm,nkar,ipos,rmssts,rmsstv,ioerr,nk_f
	character*(max_screen_width) line
	character*(max_filename_length) fnam
	character*(max_short_line_length) stat,acce
c
	integer*4 dix_util_get_len_fu
	external dix_msg_filnotop
	external dix_msg_filecrea
	external dix_msg_fileappen
	external dix_msg_forterr
	external dix_msg_fileempty
c
	include '($smgdef)'
c
c Get a filename
c
	call dix_smg_get_str(control,'Filename',fnam,iterm)
	nk_f = dix_util_get_len_fu(line)
	if(iterm .eq. key_enter) then
	  if(nk_f .eq. 0) then
	    call dix_message(control,dix_msg_fileempty)
	    goto 90
	  endif
c
c If terminator = CR, than print
c
	  ipos = index(fnam(1:nk_f),'/')
	  stat = 'NEW'
	  acce = 'SEQUENTIAL'
	  if(ipos .gt. 0) then
	    line = fnam(ipos:nk_f)
	    fnam = fnam(1:ipos-1)
	    nk_f = ipos-1
	    call str$upcase(line,line)
	    if(index(line,'/A') .ne. 0) acce = 'APPEND'
	    stat = 'UNKNOWN'
	  end if	  
	  call lib$get_lun(lun)
	  open(lun,file=fnam(1:nk_f),status=stat,carriagecontrol='list',
     1           access=acce,err=60)
	  write(lun,1034) file.fnam(1:file.nk_fnam)
1034	  format('Dump of record of file :',a)
c
c Print all lines
c
	  do k=1,nlines
	    call smg$read_from_display(dis_id,line,,k)
	    nkar = max(1,dix_util_get_len_fu(line))
	    write(lun,1100) line(1:nkar)
1100	    format(a)
	  end do
	  inquire(lun,name=line)
	  nkar = dix_util_get_len_fu(line)
	  close(lun)
	  if(stat(1:1) .eq. 'N') then
	    call dix_message(control,dix_msg_filecrea,line(1:nkar))
	  else
	    call dix_message(control,dix_msg_fileappen,line(1:nkar))
	  endif
	  goto 70
c
c Error in opening file, tell user
c
60	  call errsns(ioerr,rmssts,rmsstv)
	  call dix_message(control,dix_msg_filnotop,fnam(1:nk_f))
	  call cnv_forterr_message(ioerr,line)
	  nkar = dix_util_get_len_fu(line)
	  if(nkar .gt. 0) call dix_message(control,dix_msg_forterr,
     1                                     line(1:nkar))
	  if(rmssts .ne. 0) call dix_message(control,%val(rmssts))
	  if(rmssts .ne. 0) call dix_message(control,%val(rmsstv))
70	  call lib$free_lun(lun)
	end if
90	return
	end
	subroutine dix_smg_copy_save(control,nb_src,src,nb_dst,dst)
	implicit none
c
c Save current data to save area
c
	integer*4 control
	integer*4 nb_src
	byte src(*)
	integer*4 nb_dst
	byte dst(*)
c
	external dix_msg_datasav
c
	call dix_util_copy(nb_src,src,dst)
	nb_dst = nb_src
	call dix_message(control,dix_msg_datasav,%val(nb_dst),
     1             %descr('PASTE_BUFFER'))
	return
	end
	subroutine dix_smg_copy_restore(control,nb_src,src,nb_dst,dst)
	implicit none
c
c Restore data from save area to current data area
c
	integer*4 control
	integer*4 nb_src
	byte src(*)
	integer*4 nb_dst
	byte dst(*)
c
	external dix_msg_datarest
	external dix_msg_norest
c
	if(nb_src .gt. 0) then
	  call dix_util_copy(nb_src,src,dst)
	  nb_dst = nb_src
	  call dix_message(control,dix_msg_datarest,%val(nb_src),
     1            %descr('UNDO_AREA'))
	else
	  call dix_message(control,dix_msg_norest)
	end if
	return
	end
  	options /extend_source
	subroutine get_help_lines(key_table,help_des,raw_mode)
	implicit none
c
c Since chars can be translated, the help is dynamaically build up
c done once on the first usage of dump_screen
c
	include 'dix_def.inc'
	integer*4 key_table		!:i: the key table
	record /dyn_help/ help_des
	logical raw_mode		!:i: raw mode 
c
	call help_init(help_des,'dump screen',12,40)
c
c And go appending all helplines
c
	call help_topic(help_des,'Moves')
	call help_key(key_table,help_des,key_up,'1 line up')
	call help_key(key_table,help_des,key_down,'1 line down')
	call help_key(key_table,help_des,key_left,'1 pos to left')
	call help_key(key_table,help_des,key_right,'1 pos to right')
	call help_key(key_table,help_des,key_prev,'1 page up')
	call help_key(key_table,help_des,key_next,'1 page down')
	call help_key(key_table,help_des,key_top,'Top of data')
	call help_key(key_table,help_des,key_bot,'Bottom of data')
	call help_key(key_table,help_des,key_find,
     1             'Find string in record')
	call help_key(key_table,help_des,key_find1,
     1             'Ask string and find')
	call help_key(key_table,help_des,key_page,'Next or prev screen')
	call help_key(key_table,help_des,key_set_forw,'Set forward')
	call help_key(key_table,help_des,key_set_backw,'Set backward')
	if(raw_mode) then
	  call help_key(key_table,help_des,key_binasc,'Toggle bin/asc')
	endif
c
	call help_topic(help_des,'Display options')
	if(raw_mode) then
	  call help_key(key_table,help_des,key_byte,'Display byte')
	  call help_key(key_table,help_des,key_word,'Display word')
	  call help_key(key_table,help_des,key_long,'Display longword')
	else
	  call help_key(key_table,help_des,key_getfields,
     1           'Enter fieldedit mode')
	  call help_key(key_table,help_des,key_contdis,'Display description')
	  call help_key(key_table,help_des,key_dispall,'Show all formats')
	endif
	call help_key(key_table,help_des,key_viewvfc,'View/mod VFC data')
	call help_key(key_table,help_des,key_swap_num,'No-display offset')
	if(raw_mode) then
	  call help_key(key_table,help_des,key_compres,'Toggle singed/unsigned')
	else
	  call help_key(key_table,help_des,key_compres,'Compress on/off')
	endif
	call help_key(key_table,help_des,key_hexdec,'Hex/decimal display')
	call help_key(key_table,help_des,key_swap_dis,'Raw/interpret mode')
	call help_key(key_table,help_des,key_print,'Print record')
	call help_key(key_table,help_des,key_ch_width,'Toggle 80/132 cols')
c
	if (.not. raw_mode) then
	  call help_topic(help_des,'Description files')
	  call help_key(key_table,help_des,key_nextdes,'Next des file')
	  call help_key(key_table,help_des,key_prevdes,'Prev des file')
	  call help_key(key_table,help_des,key_viewdes,'View des file')
	  call help_key(key_table,help_des,key_viewdesc,'View internal desrecords')
	  call help_key(key_table,help_des,key_dirdes,'Dir of des files')
	  call help_key(key_table,help_des,key_editdes,'Edit description')
	endif
	call help_topic(help_des,'File/record')
	call help_key(key_table,help_des,key_next_rec,'Read next rec')
	call help_key(key_table,help_des,key_prev_rec,'Read prev rec')
	call help_key(key_table,help_des,key_ask_key,
     1        'Ask for key and read')
	call help_key(key_table,help_des,key_fileinfo,'File info')
	call help_key(key_table,help_des,key_put,'Insert record')
	call help_key(key_table,help_des,key_remove,'Delete current record')
	call help_key(key_table,help_des,key_newreclen,'Change recordlength')
	call help_key(key_table,help_des,key_find_rec,
     1              'Search file for string')
	call help_key(key_table,help_des,key_find_rec1,
     1              'Ask for string and search file')
	call help_key(key_table,help_des,key_next_file,'Next file')
	call help_key(key_table,help_des,key_prev_file,'Prev file')
	call help_key(key_table,help_des,key_dir_file,'Dir files')
	call help_key(key_table,help_des,key_follow_link,'Follow link')
	call help_topic(help_des,'General')
	call help_key(key_table,help_des,key_do,'Save changes')
	call help_key(key_table,help_des,key_abort,'Restore record to original')
	call help_key(key_table,help_des,key_save,'Save data(cut)')
	call help_key(key_table,help_des,key_restore,
     1                'Restore from last save')
	call help_key(key_table,help_des,key_help,'Display help')
	call help_key(key_table,help_des,key_exit,'Exit')
	call help_key(key_table,help_des,key_modechange,
     1               'Change mode to interactive')
	return
	end
	subroutine dix_dump_screen_view_des(control,des)
	implicit none
	include 'dix_def.inc'
	record /control/ control
	record /des_info/ des
c
c We need a scratch file to get all data
c
	call lib$get_lun(control.lun_out)
	open(control.lun_out,type='scratch',carriagecontrol='list')
	call dix_dump_print_par(control,des.n_par,
     1        %val(des.par_adr),'*',.false.)
	call dix_dump_print_line_int(control,des.n_lin,
     1        %val(des.lin_adr))
c
c Now let smg look at it
c
	rewind(control.lun_out)
	call dix_smg_view_file(control,control.lun_out,
     1         'Current expanded description')
	close(control.lun_out)
	call lib$free_lun(control.lun_out)
	control.lun_out = 0
	return
	end	
	subroutine dix_smg_show_vfc(control,file,dis)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
	record /dis_pars/ dis
c
	character*(max_screen_width) line
	integer kpl,nlines,k,nkar,dis_id,posasc,fldsiz,linenr,nl
c
        integer*4 n_bol
        integer*4 begpos_bol(10),endpos_bol(10)
c
	if(file.data.nb_vfc .eq. 2) then
	  nl = 2
	  call smg$create_virtual_display(nl,60,dis_id)
	  call dix_con_vfc(file.data.vfc_data,line,nkar)
	  call smg$put_chars(dis_id,line(1:nkar),1,1)
	else
	  call dix_dump_vars(control,dis,kpl,fldsiz,posasc)
	  nlines = (file.data.nb_vfc+kpl-1)/kpl
	  nl = nlines + 3
	  call smg$create_virtual_display(nl,control.ncols,dis_id)
	  write(line,1000) file.data.nb_vfc
1000	  format('Number of VFC bytes : ',i3)
	  call smg$put_chars(dis_id,line(1:40),1,1)
	  linenr = 2
	  do k=1,nlines
	    call dix_dump_raw_line(control,(k-1)*kpl,kpl,file.data.nb_vfc,
     1           file.data.vfc_data,dis,posasc,
     1           begpos_bol,endpos_bol,n_bol,
     1           line,nkar,fldsiz,file)
	    linenr = linenr + 1
	    call smg$put_chars(dis_id,line(1:nkar),linenr,1)
	  end do	  
	end if	
	call smg$label_border(dis_id,'VFC info')
	call smg$paste_virtual_display(dis_id,control.paste_id,5,1)
	call smg$set_cursor_abs(dis_id,nl,1)
	call dix_get_key(control,k)
	call smg$delete_virtual_display(dis_id)
	return	
	end
	subroutine dix_dump_screen_dis_recnr(dis_kop,recnr,hex)
	implicit none
c
	include 'dix_def.inc'
c
	integer dis_kop
	integer*4 recnr
	logical hex
c
	include '($smgdef)'
	character*(max_nr_asc_length+2) line
	integer nk
c
	nk = 0
	if(recnr .gt. 0) then
	  if(hex) then
	    call sys$fao('%X!XL',nk,line,%val(recnr))
	  else
	    call sys$fao('!UL',nk,line,%val(recnr))
	  endif
	end if
	line(nk+1:) = ' '
	call smg$put_chars(dis_kop,line,2,48,,
     1            smg$m_bold .or. smg$m_reverse)
	return
	end
	subroutine display_header(control,file)
	implicit none
c
	include 'dix_def.inc'
	include '($smgdef)'
c
	record /control/ control
	record /file_info/ file
	integer*4 nk
c
	character*(max_screen_width) line
c
	call lib$trim_filespec(file.fnam,line,control.ncols-20,nk)
	line(nk+1:) = ' '	
        call smg$put_chars(control.dis_kop,'File :'//line,
     1             1,1,,smg$m_bold .or. smg$m_reverse)
        if(file.fixed) then
          line = 'Fix/'
        else
          line = 'Var/'
        end if
        if(file.indexed) then
          line(5:7) = 'Idx'
        elseif(file.relative) then
          line(5:7) = 'Rel'
        else
          line(5:7) = 'Seq'
        end if
        if (file.modify) line(8:11) = '/MOD'
        if (file.block_size .ne. 0) line(12:15) = '/BLK'
        call smg$put_chars(control.dis_kop,line(1:15),1,
     1            control.ncols-14,,smg$m_reverse)
	if(file.fixed) then
          line   = 'Recsize:       Offset:       '//
     1             'Compres:    Recnr:           Mode:'
	elseif(file.block_size) then
          line   = 'Recsize:       Offset:       '//
     1             'Compres:    Blknr:           Mode:'
	else
	  if(file.indexed .or. file.relative) then
            line = 'Recsize:       Offset:       '//
     1             'Compres:                     Mode:'
	  else
            line = 'Recsize:       Offset:       '//
     1             'Compres:    Recnr:           Mode:'
	  endif
	endif
c
        call smg$put_chars(control.dis_kop,line(1:control.ncols),2,1,,
     1                 smg$m_reverse)

	return
	end  
	subroutine dix_scr_truncate(line,nk_min,extra)
	implicit none
	character*(*) line	!:io: the line
	integer*4 nk_min	!:i: the width to clip to
	logical extra		!:i: do we need an extra space for >
c
	integer*4 nk_act 
	integer*4 dix_util_get_len
c
	nk_act = dix_util_get_len(line)
	if(extra) nk_act = nk_act + 1
	if(nk_act .gt. nk_min) line = '.'//line(nk_act-nk_min+2:nk_act)
	return
	end
	function dix_dump_s_get_keys(file,control)
	implicit none
c
	include 'dix_def.inc'
	record /file_info/ file
	record /control/ control
	integer*4 dix_dump_s_get_keys
c
	include '($smgdef)'
	include '($smgmsg)'
c
	character*(*) help_lines_idx
	character*(*) help_lines_dir
c
	parameter (help_lines_idx =
     1    'input for indexed files;'//
     1    'The user can specify the key 0..nkey-1 or a ?;'//
     1    'And a value and a keyoption (EQ,LE,LT,GE,GT);'//
     1    'If the value is empty, the program will rewind on this key')
c
	parameter (help_lines_dir=
     1    'input for sequential files;'//
     1    'The user can specify a record number;'//
     1    'If the file allows direct access, the program will;'//
     1    'read the record, else the program will rewind and;'//
     1    'skip recnr-1 records')
c
	integer*4 dis_ch,dis_id,iterm,key1,keyopt,istat,nk,ios
	logical*4 string,ascending
	integer*4 length
	character*(max_rms_key_name_length) keynam
	character*(max_line_length) line
c
	logical*4 dix_main_get_record
	logical*4 dix_rms_keyinfo
	integer*4 smg$select_from_menu
c
	integer*4 nkar_key,nkar
	external dix_msg_illkey
	external dix_msg_aslelt
	external dix_msg_degegt
	external dix_msg_noval
	external dix_msg_rewind
	external dix_msg_keynotf
	external dix_msg_illrecn
c
	character*(max_keytype_length) choice(3)
c
	call smg$create_virtual_display(5,50,dis_id,smg$m_border)
	call smg$paste_virtual_display(dis_id,control.paste_id,10,10)
	call smg$label_border(dis_id,'Keyinformation')
c
	if(file.indexed) then
c
c For indexed file we need 
c  keynr, options(eq,ge,gt), and key_value
c
c Get key number
c first DIsplay key info
c
10	  call smg$put_chars(dis_id,'Key :',1,1)
	  call dix_rms_keyinfo(file,file.cur_key,
     1                string,length,ascending,keynam)
c
	  call dix_con_type_intasc(4,file.cur_key,enttyp_int,line,nkar)
	  call smg$put_chars(dis_id,line(1:nkar),1,7)
	  call smg$put_chars(dis_id,keynam,1,10)
C
	  call smg$put_chars(dis_id,keynam,1,10)
	  if(ascending) then
	    call smg$put_chars(dis_id,'Ascending',2,8)
	  else
	    call smg$put_chars(dis_id,'Descending',2,8)
	  end if
	  if(string) then
	    call smg$put_chars(dis_id,'String',2,19)
	  else
	    call smg$put_chars(dis_id,'Numeric',2,19)
	  endif
c         
c Get key number
c
	  iterm = 0
	  call dix_smg_stack_help(control,help_lines_idx)
	  call dix_smg_get_string(control,dis_id,1,7,2,line,0,
     1                              iterm,nk,.false.)
	  call dix_smg_unstack_help(control)
	  if(iterm .eq. key_exit) goto 80
	  if(line .eq. '?') then
	    call dix_dump_s_select_key_from_menu(control,file,key1)
	    if(key1 .ge. 0) then
	      call sys$fao('!UL',nk,line,%val(key1))
	      call smg$put_chars(dis_id,line(1:nk),1,7)
	    endif
	  else
	    read(line(1:nk),2000,iostat=ios) key1
2000	    format(bn,i10)
	    if(ios .ne. 0) key1 = -1
	  endif
	  if(key1 .lt. 0 .and. key1 .ge. file.nkey) goto 30
	  if(dix_rms_keyinfo(file,key1,string,length,
     1               ascending,keynam)) goto 40
c
30	  call dix_message(control,dix_msg_illkey,line(1:nk))
	  call dix_rms_keyinfo(file,file.cur_key,string,
     1                    length,ascending,keynam)
	  goto 10
c
c Valid key, now get value
c SMG mode : LEt the user specify eq,ge(le) or gt(lt)
c
40	  call smg$put_chars(dis_id,keynam,1,10)
	  choice(1) = 'EQ'
	  if(ascending) then
	    call smg$put_chars(dis_id,'Ascending',2,8)
	    choice(2) = 'GE'
	    choice(3) = 'GT'
	  else
	    call smg$put_chars(dis_id,'Descending',2,8)
	    choice(2) = 'LE'
	    choice(3) = 'LT'
	  end if
	  if(string) then
	    call smg$put_chars(dis_id,'String',2,19)
	  else
	    call smg$put_chars(dis_id,'Numeric',2,19)
	  endif
c
c Got valid key
c
	  call smg$put_chars(dis_id,'Value :',3,1)
c
c Now get keyvalue
c
	  iterm = 0
	  call dix_smg_stack_help(control,help_lines_idx)
	  call dix_smg_get_string(control,dis_id,3,8,32,line,0,iterm,
     1                 nkar_key,.false.)
	  call dix_smg_unstack_help(control)
	  if(iterm .eq. key_exit) goto 80
	  if(iterm .eq. key_first) goto 10
	  if(nkar_key .eq. 0) then
	    file.cur_key = key1
	    call dix_message(control,dix_msg_rewind)
	    keyopt = 2		!ge option
	    goto 50
	  end if
c
c Create menu or eq,ge,gt (or eq,le,lt)
c
	  call smg$create_virtual_display(1,20,dis_ch)
	  call smg$paste_virtual_display(dis_ch,control.paste_id,13,15)
	  call smg$create_menu(dis_ch,choice,smg$k_horizontal,,,0)
c
c Let the select one 
c
	  istat  = smg$select_from_menu(control.keyboard_id,dis_ch,keyopt,1)
	  call smg$delete_virtual_display(dis_ch)
	  if(istat .eq. smg$_eof) goto 80
	else
c
c Non indexed file, we only accept recordnumber
c
60	  call smg$put_chars(dis_id,'Recordnumber :',1,1)
	  line = ' '
	  call smg$put_chars(dis_id,line(1:10),1,15)
	  iterm = 0
	  call dix_smg_stack_help(control,help_lines_dir)
	  nk = 10
	  call dix_smg_get_string(control,dis_id,1,15,nk,
     1             line(1:nk),0,iterm,nkar_key,.false.)
	  call dix_smg_unstack_help(control)
	endif
50	istat = dix_main_get_record(control,file,key1,keyopt,
     1              line(1:nkar_key),.true.)
	goto 90
80	istat = 1
90	call smg$delete_virtual_display(dis_id)
	dix_dump_s_get_keys = istat
	return
	end
	subroutine dix_dump_s_select_key_from_menu(control,file,key1)
	implicit none
c
c LEt the user select a key via a menu
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
	integer*4 key1
c
	include '($smgdef)'
	integer*4 iterm,sel_id,ipos,k,nkey,minr,maxr,length
	character*(max_line_length) line
	record /dyn_help/ help_des
c
c assume error
c
	character*(max_rms_key_name_length) keynam
	logical*4 ascending,string
c
	call help_init_std(control,help_des,'select key',20,2)
	call help_key(control.key_table,help_des,key_enter,
     1                'select the current key')
	call help_key(control.key_table,help_des,key_exit,
     1                'Exit this screen')
	call dix_smg_stack_help(control,help_des)
c
	call dix_rms_get_reclen(%val(file.rabadr),minr,maxr,nkey)
	call smg$create_virtual_display(nkey,50,sel_id)
	call smg$put_chars(sel_id,'Key  Size String Ascending name',1,1)
	do k=0,nkey-1
	  call dix_rms_keyinfo(file,k,string,length,ascending,keynam)
	  write(line,'(i3,i6)') k,length
	  line(11:16) = '   No'	
	  if(string) line(11:16) = '  Yes'	
	  line(18:26) = '       No'	
	  if(ascending) line(18:26) = '      Yes'	
c
	  line(28:) = keynam
	  call smg$put_chars(sel_id,line,k+2,1)
	end do
	call smg$label_border(sel_id,'Keyselection')
	call smg$paste_virtual_display(sel_id,control.paste_id,
     1                2,control.ncols-51)
	key1 = -1
	ipos = 0
c
10	call smg$set_cursor_abs(sel_id,ipos+2,1)
	call dix_get_key(control,iterm)
	if(iterm .eq. key_up) then
	  if(ipos .gt. 0) ipos = ipos - 1
	elseif(iterm .eq. key_down) then
	  if(ipos .lt. nkey-1) ipos = ipos+1
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	elseif(iterm .eq. key_enter) then
	  key1 = ipos
	  goto 90
	elseif(iterm .eq. key_exit) then
	  key1 = -1
	  goto 90
	endif
	goto 10
90	call smg$delete_virtual_display(sel_id)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end
