 	function dix_eval_check(control,line,err_arg)
	implicit none
c
c Check if expression is ok
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line           	!:i: input line
	character*(*) err_arg		!:o: output parameter
c
	logical*4 dix_eval_check
c
	logical*4 dix_eval_expression
c
	integer*4 dix_util_get_len_fu
c
	integer*4 nk
	record /value/ result
	logical is_symbol
c
	nk = dix_util_get_len_fu(line)
	call dix_eval_init_char(result.strdes)
c
	dix_eval_check = dix_eval_expression(control,line(1:nk),result,
     1                     .true.,err_arg,.false.,is_symbol)

	call dix_eval_free_char(result.strdes)
	return
	end
	function dix_eval_express_des(control,line,result,err_arg,set_dep)
	implicit none
c
c Evaluate expression, and allow only integer results
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line    		!:i: the line to be "eval"ed
	integer*4 result		!:o: result value (integer)
	character*(*) err_arg     	!:o: error parameter
	logical*4 set_dep               !:i: if field is used, do we set dependency flag?
	logical*4 dix_eval_express_des
c
	logical is_symbol
	logical*4 dix_eval_expression
	external dix_msg_enotint
c
	record /value/ result1
c
c Evaluate expression
c
	dix_eval_express_des = dix_eval_expression(control,
     1            line,result1,
     1            .false.,err_arg,set_dep,is_symbol)
	if(dix_eval_express_des) then
c
c Evaluate oke; is the result an integer?
c
	  if(result1.type .eq. symb_typ_int) then
	    result = result1.ival
	  else
	    err_arg = line
	    dix_eval_express_des = %loc(dix_msg_enotint)
	  endif
	endif
	return
	end
c
	function dix_eval_expression(control,line,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_expression
c
	integer*4 ipos,istat
	character kar
c
	integer*4 dix_eval_expression1
	external dix_msg_toomuch
c
	istat = dix_eval_expression1(control,line,result,
     1                syntax,err_arg,set_dep,
     1                kar,ipos,is_symbol)
	if(istat) then
	  if(kar .ne. char(0)) then
	    istat = %loc(dix_msg_toomuch)
	    err_arg = line(ipos-1:)
	  endif	
	endif
	dix_eval_expression = istat
	return
	end
	function dix_eval_expression1(control,line,result,
     1                syntax,err_arg,set_dep,
     1                kar,ipos,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	character kar
	integer*4 ipos	
	logical is_symbol
	integer*4 dix_eval_expression1
c
	integer*4 istat
c
	integer*4 dix_eval_expres
	character dix_eval_getkar
c
	call dix_eval_free_value(result)
	is_symbol = .true.
	err_arg = ' '
	ipos    = 1
	istat   = dix_eval_expres(control,
     1                 line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	if(istat) then
	  kar = dix_eval_getkar(line,ipos,.true.)
	endif
	dix_eval_expression1 = istat
	return
	end
	options /recursive
	function dix_eval_expres(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	integer*4 ipos
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_expres
c
	character kar
	integer*4 istat,oper
	logical isless,isequal
	record /value/ result1
c
	character dix_eval_getkar
	integer dix_eval_andor
	integer dix_eval_setflags
c
	integer*4 oper_lt
	integer*4 oper_le
	integer*4 oper_eq
	integer*4 oper_ge
	integer*4 oper_gt
	integer*4 oper_ne
	integer*4 oper_none
c
	parameter (oper_none = 0,oper_lt = 1,oper_le = 2,
     1             oper_eq   = 3,oper_ge = 4,oper_gt = 5,oper_ne=6)

c
c	write(*,*) 'In expr with pos ',ipos
	call dix_eval_init_char(result1.strdes)
	istat = dix_eval_andor(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	if(istat) then
10	  oper = oper_none
	  kar = dix_eval_getkar(line,ipos,.true.)
	  if(kar .eq. '<') then
	    oper = oper_lt
	    kar = dix_eval_getkar(line,ipos,.true.)
	    if(kar .eq. '=') then
	      oper = oper_le
	    elseif(kar .eq. '>') then
	      oper = oper_ne
	    else
	      ipos = ipos - 1
	    endif
	  elseif(kar .eq. '>') then     
	    oper = oper_gt
	    kar = dix_eval_getkar(line,ipos,.true.)
	    if(kar .eq. '=') then
	      oper = oper_ge
	    else
	      ipos = ipos - 1
	    endif
	  elseif(kar .eq. '=') then
	    oper = oper_eq
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1
	  endif
c
c If we have a valid operator, execute it
c
	  if(oper .ne. oper_none) then
	    is_symbol = .false.
	    istat = dix_eval_andor(control,line,ipos,result1,
     1                syntax,err_arg,set_dep,is_symbol)
            if(istat) then
	      if(.not. syntax) then
	        istat = dix_eval_setflags(result,result1,isless,isequal)
	        if(istat) then
	          if(oper .eq. oper_lt) then
	            result.lval = isless .and. .not. isequal
	          elseif(oper .eq. oper_le) then	   
	            result.lval = isless
	          elseif(oper .eq. oper_eq) then
	            result.lval = isequal
	          elseif(oper .eq. oper_ge) then
	            result.lval = .not. isless
	          elseif(oper .eq. oper_gt) then
	            result.lval = .not. (isless .or. isequal)
	          elseif(oper .eq. oper_ne) then
	            result.lval = .not. isequal
	          endif
	          result.type = symb_typ_log
	        endif
	        goto 10
	      endif     !valie compare
	    endif	!oper <>none
	  endif
	endif
	call dix_eval_free_char(result1.strdes)
	dix_eval_expres = istat
	return
	end
	function dix_eval_setflags(result,result1,isless,isequal)
	implicit none
	include 'dix_def.inc'
	record /value/ result
	record /value/ result1
	logical isless
	logical isequal
	integer dix_eval_setflags
c
	integer*4 istat,diff(2),is
	external dix_msg_invcomp
	integer*4 str$compare
c 
c Assume invalid compares
c
	istat = %loc(dix_msg_invcomp)
	if(result.type .eq. symb_typ_int) then
	  if    (result1.type .eq. symb_typ_int) then
	    isequal = result.ival .eq. result1.ival
	    isless  = result.ival .lt. result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    isequal = result.ival .eq. result1.rval
	    isless  = result.ival .lt. result1.rval
	  else
	    goto 90	
	  endif	
	elseif(result.type .eq. symb_typ_real) then
	  if    (result1.type .eq. symb_typ_int) then
	    isequal = result.rval .eq. result1.ival
	    isless  = result.rval .lt. result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    isequal = result.rval .eq. result1.rval
	    isless  = result.rval .lt. result1.rval
	  else
	    goto 90	
	  endif	
	elseif(result.type .eq. symb_typ_char) then
	  if(result1.type .eq. symb_typ_char) then
	    is = str$compare(result.strdes,result1.strdes)
	    isequal = is .eq. 0
	    isless  = is .lt. 0
	  else
	    goto 90	
	  endif	
	elseif(result.type .eq. symb_typ_date) then
	  if(result1.type .eq. symb_typ_date) then
	    call lib$subx(result.date,result1.date,diff)
	    isequal = diff(1) .eq. 0 .and. diff(2) .eq. 0
	    isless  = diff(2) .lt. 0
	  else
	    goto 90	
	  endif	
	elseif(result.type .eq. symb_typ_log) then
	  goto 90
	endif	
	istat = 1
90	dix_eval_setflags = istat
	return
	end
	options /recursive
	function dix_eval_andor(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	integer*4 ipos
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_andor
c
	character kar
	integer*4 istat
	record /value/ result1
c
	character dix_eval_getkar
	integer dix_eval_addsub
	integer*4 dix_eval_and
	integer*4 dix_eval_or

c
c	write(*,*) 'In expr with pos ',ipos
	call dix_eval_init_char(result1.strdes)
	istat = dix_eval_addsub(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	if(istat) then
10	  kar = dix_eval_getkar(line,ipos,.true.)
	  if(kar .eq. '&' .or. kar .eq. '|') then
	    is_symbol = .false.
	    istat = dix_eval_addsub(control,line,ipos,result1,
     1                syntax,err_arg,set_dep,is_symbol)
            if(istat) then
	      if(.not. syntax) then
	        if(kar .eq. '&') then
	          istat = dix_Eval_and(result,result1)
	        else
	          istat = dix_Eval_or(result,result1)
	        endif
	      endif
	    endif
	    if(istat) goto 10
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1
	  endif
	endif
	call dix_eval_free_char(result1.strdes)
	dix_eval_andor = istat
	return
	end
	options /recursive
	function dix_eval_addsub(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	integer*4 ipos
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_addsub
c
	character kar
	integer*4 istat
	record /value/ result1
	character dix_eval_getkar
	integer*4 dix_eval_add
	integer*4 dix_eval_sub
	integer*4 dix_eval_muldiv
c
c	write(*,*) 'In addsub with pos ',ipos
	call dix_eval_init_char(result1.strdes)
	istat = dix_eval_muldiv(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	if(istat) then
10	  kar = dix_eval_getkar(line,ipos,.true.)
	  if(kar .eq. '+' .or. kar .eq. '-') then
	    is_symbol = .false.
	    istat = dix_eval_muldiv(control,line,ipos,result1,
     1                syntax,err_arg,set_dep,is_symbol)
            if(istat) then
	      if(.not. syntax) then
	        if(kar .eq. '+') then
	          istat = dix_eval_add(result,result1)
	        else
	          istat = dix_eval_sub(result,result1)
	        endif
	      endif
	    endif
	    if(istat) goto 10
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1
	  endif
	endif
	call dix_eval_free_char(result1.strdes)
	dix_eval_addsub = istat
	return
	end
	options	/recursive
	function dix_eval_muldiv(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	integer*4 ipos
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_muldiv
c
	character kar
	integer*4 istat
	record /value/ result1
c
	character dix_eval_getkar
	integer dix_eval_mul
	integer dix_eval_div
	integer*4 dix_eval_element
c
c	write(*,*) 'In muldiv with pos ',ipos
	call dix_eval_init_char(result1.strdes)
	istat = dix_eval_element(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	if(istat) then
10	  kar = dix_eval_getkar(line,ipos,.true.)
	  if(kar .eq. '*' .or. kar .eq. '/') then
	    is_symbol = .false.
	    istat = dix_eval_element(control,line,ipos,result1,
     1                syntax,err_arg,set_dep,is_symbol)
            if(istat) then
	      if(.not. syntax) then
	        if(kar .eq. '*') then
	          istat = dix_eval_mul(result,result1)
	        else
	          istat = dix_eval_div(result,result1)
	        endif
	      endif
	    endif
	    if(istat) goto 10
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1
	  endif
	endif
	call dix_eval_free_char(result1.strdes)
	dix_eval_muldiv = istat
	return
	end
	options /recursive
	function dix_eval_element(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) line
	integer*4 ipos
	record /value/ result
	logical syntax
	character*(*) err_arg
	logical set_dep
	logical is_symbol
	integer*4 dix_eval_element
c
	character dix_eval_getkar
	integer*4 dix_eval_expres
	logical dix_eval_is_tf
	integer dix_des_find_field
	integer*4 dix_symbol_find
	integer*4 dix_eval_func
	integer*4 ots$cvt_t_f
	logical dix_util_legal_char
	logical dix_des_find_par
c
	character kar
	logical got_exponent,got_fraction,try_field,try_symb
	character*(max_str_len) work
	integer*4 nk,narg,istat,xpos,spos
	integer*4 k,nk_name,ptr
	record /des_rec/ des_rec
c
	integer*4 max_arguments
	parameter (max_arguments = 10)
	record /value/ args(max_arguments)
c
	external dix_msg_symbtool
	external dix_msg_invelem
	external dix_msg_invreal
	external dix_msg_invint
	external dix_msg_closbnotf
	external dix_msg_empty
	external dix_msg_unexpchar

c
	do k=1,max_arguments
	  call dix_eval_init_char(args(k).strdes)
	  args(k).type = symb_typ_none	!no value present
	end do
	  
c	write(*,*) 'In element with pos ',ipos
	istat = 1
c	
	kar = dix_eval_getkar(line,ipos,.true.)
	if(kar .eq. char(0)) then
	  istat = %loc(dix_msg_empty)
	elseif(kar .eq. '(') then
	  is_symbol = .false.
	  istat = dix_eval_expres(control,line,ipos,result,
     1                syntax,err_arg,set_dep,is_symbol)
	  if(istat) then
	    kar = dix_eval_getkar(line,ipos,.true.)
	    if(kar .ne. ')') then
	      istat = %loc(dix_msg_closbnotf)
	    endif
	  endif
	elseif(kar .eq. '"') then
	  is_symbol = .false.
	  result.type = symb_typ_char
	  nk = 0
12	  kar = dix_eval_getkar(line,ipos,.false.)
	  if(kar .eq. '"') then
c
c Get next char, if a quote too, goon with one "
c
	    kar = dix_eval_getkar(line,ipos,.false.)
	    if(kar .eq. '"') then
	    elseif(kar .eq. char(0)) then
	      goto 15
	    else
	      ipos = ipos - 1
	      goto 15
	    endif
	  endif
	  if(nk .lt. max_str_len) then
	    nk = nk + 1
	    work(nk:nk) = kar
	    goto 12
	  else
	    istat = %loc(dix_msg_symbtool)
	  endif
15	  call dix_eval_fill_char(result.strdes,work(1:nk))
	elseif((kar .ge. '0' .and. kar .le. '9') .or. 
     1          kar .eq. '+' .or. kar .eq. '-') then
c
c Must be a number
c
	  is_symbol = .false.
	  got_fraction = .false.
	  got_exponent = .false.
	  nk = 0
10	  nk = nk + 1
	  work(nk:nk) = kar
	  kar  = dix_eval_getkar(line,ipos,.false.)
	  if(kar .ge. '0' .and. kar .le. '9') then
	    goto 10
	  elseif(kar .eq. '.') then
	    if(got_fraction .or. got_exponent) then
	      istat = %loc(dix_msg_invreal)
	      goto 90
	    endif
	    got_fraction = .true.
	    goto 10
	  elseif(kar .eq. 'E' .or. kar .eq. 'e') then
	    if(got_exponent) then
	      istat = %loc(dix_msg_invreal)
	      goto 90
	    endif	      
	    got_exponent = .true.
	    if(kar .eq. 'e') kar = 'E'
	    goto 10
	  elseif(kar .eq. '+' .or. kar .eq. '-') then
	    if(work(nk:nk) .eq. 'E') goto 10
	    ipos = ipos - 1
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1	!skipback one char
	  endif
c
	  if(got_exponent .or. got_fraction) then
	    istat = ots$cvt_t_f(work(1:nk),result.rval,,,1)
	    if(.not. istat) err_arg = work(1:nk)
	    result.type = symb_typ_real
	  else
	    read(work(1:nk),2010,iostat=k) result.ival
	    if(k .ne. 0) then
	      istat = %loc(dix_msg_invint)
	      err_arg = work(1:nk)
	    endif
2010	    format(i12)
	    result.type = symb_typ_int
	  endif
	elseif(dix_util_legal_char(kar,1) .or. 
     1              kar .eq. '%' .or. 
     1              kar .eq. '$') then
c
c Symbol
c format can be something like
c  name                                symbol,parameter,radix constant
c  name(dim,dim,dim)	               field with dimensions
c  name("xyz")                         function
c  name(dim,dim).name(dim,dim).name    fieldname
c
	  spos         = ipos-1
	  nk           = 0		!no chars yet
	  nk_name      = 0		!no name yet	
	  try_field    = .true.		!it can still be a fieldname
	  try_symb     = .true.		!it can still be symb/par/radix char
c
20	  nk = nk + 1
	  work(nk:nk) = kar
c
c Must be a symbol
c
	  kar  = dix_eval_getkar(line,ipos,.false.)
	  if(dix_util_legal_char(kar,2)) goto 20
	  if(kar .eq. '.' .or. kar .eq. '\') then
c
c Part of fieldname filetag\name
c
	    is_symbol = .false.
	    try_symb = .false.
	    goto 20
	  endif
c
	  if(kar .eq. ' ') kar = dix_eval_getkar(line,ipos,.true.)
	  narg = 0
	  if(kar .eq. '(') then
	    is_symbol = .false.
	    try_symb = .false.		!no more symbol
c
c We had ( before so it cannot be a function. If try_field is also false
c
	    nk_name = nk	!remember the function name position
c
c See if the text contains a function line f$time() with
c () without any argument
c
	    kar = dix_eval_getkar(line,ipos,.true.)
	    if(kar .eq. ')') then
	      try_field = .false.		!cannot be a field name
	      goto 35
	    else
	      ipos = ipos - 1
	      kar = '('
	    endif  
c
30	    nk = nk + 1
	    work(nk:nk) = kar
	    narg = narg + 1
	    if(narg .gt. max_dimension) try_field = .false.
c
c Check if next char a , or a )  if so we have an empty argument
c
	    kar = dix_eval_getkar(line,ipos,.true.)
	    ipos = ipos - 1
	    if(kar .eq. ',' .or. kar .eq. ')') then
	      try_field = .false.
	      args(narg).type = symb_typ_none
	      goto 32
	    endif

	    xpos = ipos
	    istat = dix_eval_expres(control,line,ipos,args(narg),
     1                syntax,err_arg,set_dep,is_symbol)
	    if(.not. istat) goto 90
	    if(args(narg).type .ne. symb_typ_int) then
c
c Not integer argument, cannot be a fieldname
c
	      try_field = .false.
	    else
c
c Can still be a field name (matrix), so keep ,on filling work
c
	      if(try_field) then
	        call dix_con_type_intasc(4,args(narg).ival,enttyp_int,
     1                      work(nk+1:),xpos)
	        nk = nk + xpos
	      endif
	    endif
c
c Get next char
c
32	    kar = dix_eval_getkar(line,ipos,.true.)
35	    if(kar .eq. ',') then
	      goto 30			!next argument
	    elseif(kar .eq. ')') then
c
c Now we have all thing present for this funcion,
c try if it is one
c
	      call str$upcase(work(1:nk_name),work(1:nk_name))
              istat = dix_eval_func(control,work(1:nk_name),narg,args,
     1                result,err_arg,set_dep)
	      if(istat) goto 90		!valid function  result
c
c Not a valid function. It can still be a fieldname
c  for tables e.g. name(1,2,3).name
c
c Now kar still contains the )
c
	      nk = nk + 1
	      work(nk:nk) = kar
c
c Get the next char, it can be either a . (next part of field)
c or a eol
c  all other chars are illegal
c
	      kar  = dix_eval_getkar(line,ipos,.false.)
	      if(kar .eq. char(0)) then
c
c Not a valid function
c  if try_field or try_symbol both false, exit
c
	        if(.not. (try_symb .or. try_field)) goto 90
	        goto 39
	      endif
	      if(kar .ne. '.') try_field = .false.
	      if(try_field) goto 20	!if field still possible try the next char
	      goto 90			!and return the invfunc
	    else
	      istat = %loc(dix_msg_closbnotf)
	      goto 90
	    endif
	  elseif(kar .eq. char(0)) then
	  else
	    ipos = ipos - 1	!skip back
	  endif
c
c Now we finally have the name in work
c  work(1:nk) can be a fieldname (if try_field is still true)
c  or work(1:nk_name) can be the  name of the function with args(1:narg)
c                      its arguments
c
39	  call str$upcase(work(1:nk),work(1:nk))
c
c Set the type to nothing
c
	  result.type = symb_typ_none
c
c First check for things that do not have arguments
c
	  if(try_symb) then
c
c Check for reserved words (true, false)
c
	    if(dix_eval_is_tf(.true.,work(1:nk))) then
	      is_symbol = .false.
	      result.lval = 1
	      result.type = symb_typ_log
	    elseif(dix_eval_is_tf(.false.,work(1:nk))) then
	      is_symbol = .false.
	      result.lval = 0
	      result.type = symb_typ_log
	    endif
c
c If not yet oke, Try the a %rdddd format
c
	    if(result.type .eq. symb_typ_none) then
	      if(work(1:1) .eq. '%') then
	        call dix_eval_tryradix(work(2:nk),result)
	      endif
	    endif
c
c If not yet oke, try as a symbol
c
	    if(result.type .eq. symb_typ_none) then
	      call dix_symbol_find(control,work(1:nk),result)
	    else
	      is_symbol = .false.
	    endif
c
c If not yet oke, Try as a parameter
c
	    if(result.type .eq. symb_typ_none) then
	      is_symbol = .false.
	      if(dix_des_find_par(control,work(1:nk),result.ival)) then
	        result.type = symb_typ_int
	      endif
	    endif
	  else
	    is_symbol = .false.
	  endif
c
c if result.typ still _none try fields
c
	  if(result.type .eq. symb_typ_none .and. .not. syntax) then
c
c fields can have max_dimension arguments, all of type integer
c check if this is valid
c
	    if(try_field) then
c
c Try to find the field (with or without the dimensions)
c
	      istat = dix_des_find_field(control,work(1:nk),des_rec,
     1                                   set_dep,ptr)
	      if(istat) then
c
c we have a valid prev field, nmow convert from des_rec to symbol
c
	        call dix_eval_cvt(control,des_rec,%val(ptr),result)
	      endif 
	    endif
c
c Still not found, so return invelem
c
	    if(result.type .eq. symb_typ_none) then
	      istat = %loc(dix_msg_invelem)
	      err_arg = line(spos:min(len(line),ipos))
	    endif
	  endif	
	else
	  istat = %loc(dix_msg_unexpchar)
	  err_arg = kar
	endif
90	do k=1,max_arguments
	  call dix_eval_free_char(args(k).strdes)
	end do
	dix_eval_element = istat
	return
	end
	subroutine dix_eval_tryradix(line,result)
	implicit none
c
c Try if the text is a valid radix structure
c if so set result.ival to number and result.type to symb_typ_int
c
	include 'dix_def.inc'
	character*(*) line
	record /value/ result
c
	integer*4 l
c
c Format %Bddddd  where B can be X (hexadecimal), O(Octal) or 
c                                 D( decimal)   or B(inary)
c
	if(line(1:1) .eq. 'X') then
	  read(line(2:),'(z)',err=40) result.ival
	elseif(line(1:1) .eq. 'O') then
	  read(line(2:),'(o)',err=40) result.ival
	elseif(line(1:1) .eq. 'D') then
          read(line(2:),'(i)',err=40) result.ival
        elseif(line(1:1) .eq. 'B') then
	  result.ival = 0
	  if(len(line)-1 .gt. 32) goto 40
	  do l=2,len(line)
	    result.ival = ishft(result.ival,1)
	    if(line(l:l) .eq. '1') then
	      result.ival = result.ival + 1
	    elseif(line(l:l) .eq. '0') then
	    else
	      goto 40	!invalid char
	    endif
	  end do
	else
	  goto 40
	endif
c
c Valid result, so now it is an niteger
c
	result.type = symb_typ_int
40	return
	end

	subroutine dix_eval_cvt(control,des_rec,file,result)
	implicit none
	include 'dix_def.inc'
	record /control/ control
	record /des_rec/ des_rec
	record /file_info/ file
	record /value/ result
c
	integer*4 p_data,offset
	character*(max_str_len) work
	integer*4 nkar,max_len
	real*8 rrval
c
	if(des_rec.ent_type .eq. enttyp_int) then
c
c For some valued ($RECORDSIZE) offset can be begative
c compensate this by decreasing the pointer and increasing the offset
c
	  p_data = %loc(file.data.data_rec)
	  offset = des_rec.bit_offset
	  do while (offset .lt. 0)
	    offset = offset + 8		!offset is in bits
	    p_data = p_data - 1
	  end do
          result.type = symb_typ_int
          result.ival = 0
	  call dix_util_copy_bits(min(32,des_rec.size),
     1              offset,%val(p_data),result.ival,4)
        elseif(des_rec.ent_type .eq. enttyp_uint) then
          result.type = symb_typ_int
          result.ival = 0
          call dix_util_copy_bits(min(32,des_rec.size),
     1          des_rec.bit_offset,file.data.data_rec,result.ival,4)
        elseif(des_rec.ent_type .eq. enttyp_real) then
c
c We can have real*4 or *8. Symbols only have *4, so if *8 do conversion
c
          if(des_rec.size .eq. 64) then
            call dix_util_copy_bits(des_rec.size,
     1          des_rec.bit_offset,file.data.data_rec,rrval,4)
            result.rval = rrval
          else
            call dix_util_copy_bits(des_rec.size,
     1          des_rec.bit_offset,
     1          file.data.data_rec,result.rval,4)
          endif
          result.type = symb_typ_real
        else
c
c All others result in string
c
          result.type = symb_typ_char
          call dix_con_intasc(32768,des_rec,file.data.data_rec,
     1               work,nkar,.false.,max_len,.false.,control)
	  call dix_eval_fill_char(result.strdes,work(1:nkar))
        endif
	return
	end
	subroutine dix_eval_copy_char_fix(string,result,nk)
	implicit none
c
	include 'dix_def.inc'
	record /strdef/ string	!:i: the source
	character*(*) result	!:o: the fixed string
	integer*4 nk		!:o: the lengh
c
	integer*4 istat
	integer*4 str$copy_dx
c
	nk = zext(string.dsc$w_maxstrlen)
	istat = str$copy_dx(result,string)
	if(.not. istat) call lib$signal(%val(istat))
	return
	end
	subroutine dix_eval_copy_char_dyn(string,result)
	implicit none
c
	include 'dix_def.inc'
	character*(*) string 	!:i: the fixed string
	record /strdef/ result	!:i: the dest
c
	integer*4 istat
	integer*4 str$copy_dx
c
	istat = str$copy_dx(result,string)
	if(.not. istat) call lib$signal(%val(istat))
	return
	end
	subroutine dix_eval_upcase(result,string,nk)
	implicit none
c
	include 'dix_def.inc'
	record /strdef/ result
	character*(*) string
	integer*4 nk
c
	integer*4 istat
	integer*4 str$upcase
c
	nk = zext(result.dsc$w_maxstrlen)
	istat = str$upcase(string,result)
	if(.not. istat) call lib$signal(%val(istat))
	return
	end
	subroutine dix_eval_fill_char(result,string)
	implicit none
c
	include 'dix_def.inc'
	record /strdef/ result
	character*(*) string
c
	integer*4 istat
	integer*4 str$copy_dx
c
c	call dix_eval_init_char(result)
	istat = str$copy_dx(result,string)
	if(.not. istat) call lib$signal(%val(istat))
	return
	end	
	subroutine dix_eval_free_value(value)
	implicit none
c
	include 'dix_def.inc'
	record /value/ value
c
	call dix_eval_free_char(value.strdes)
	return
	end
	subroutine dix_eval_free_char(result)
	implicit none
c
	include 'dix_def.inc'
	record /strdef/ result
c
	include '($dscdef)'
c
	integer*4 istat
	integer*4 str$free1_dx
c
	if(result.dsc$a_pointer .ne. 0) then
	  istat = str$free1_dx(result)
	  if(.not. istat) call lib$signal(%val(istat))
	end if
	return
	end
	subroutine dix_eval_init_value(value)
	implicit none
c
	include 'dix_def.inc'
	record /value/ value
c
	call dix_eval_init_char(value.strdes)
	return
	end
	subroutine dix_eval_copy_value(src,dst)
	implicit none
c
	include 'dix_def.inc'
	record /value/ src
	record /value/ dst
c
	record /strdef/ save
c
	if(src.type .eq. symb_typ_char) then
	  call str$copy_dx(dst.strdes,src.strdes)
	  dst.type = symb_typ_char
	else
c
c Copy the rest of the data, but keep the string part
c
	  save = dst.strdes
	  dst = src
	  dst.strdes = save
	end if
	return
	end
	subroutine dix_eval_init_char(result)
c	
	implicit none
	include 'dix_def.inc'
	record /strdef/ result
c
	include '($dscdef)'
c
	result.dsc$w_maxstrlen = 0
        result.dsc$b_dtype     = dsc$k_dtype_z
        result.dsc$b_class     = dsc$k_class_d
        result.dsc$a_pointer   = 0
	return
	end
	function dix_eval_getkar(line,ipos,skip_blanks)
	implicit none
c
	include 'dix_def.inc'

c
	character*(*) line
	integer*4 ipos
	logical skip_blanks
	character dix_eval_getkar
c
	character kar
c
10	if(ipos .gt. len(line)) then
	  kar = char(0)
	else
	  kar = line(ipos:ipos)
	  ipos = ipos + 1
	  if(skip_blanks) then
            if(kar .eq. SPACE .or. kar .eq. TAB) goto 10
	  endif
	endif
	dix_eval_getkar = kar
	return
	end
	function dix_eval_is_tf(true,line)
	implicit none
c
	include 'dix_def.inc'
c
	logical true
	character*(*) line
	logical dix_eval_is_tf
c
	integer*4 str$case_blind_compare	
c
	if(true) then
	  dix_eval_is_tf = str$case_blind_compare(line,true_name).eq. 0
	else
	  dix_eval_is_tf = str$case_blind_compare(line,false_name).eq. 0
	endif
	return
	end
	function dix_eval_add(total,result1)
	implicit none
c
c Result1 must be addded to total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_add
c
	integer*4 istat	
c
	external dix_msg_invmixic
	external dix_msg_invtype
	external dix_msg_aroverfl
	external dix_msg_invmixdate
	external dix_msg_invmixdatd
	external dix_eval_overflow
	logical overflow
	volatile overflow
	common /dix_eval_overflow_common/ overflow
c
	overflow = .false.
	call lib$establish(dix_eval_overflow)
c
	istat = 1
	if(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_int) then
	    total.ival = total.ival + result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = real(total.ival)
	    total.type = symb_typ_real
	    total.rval = total.rval + result1.rval
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_real) then
	  if(result1.type .eq. symb_typ_int) then
	    total.rval = total.rval + real(result1.ival)
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = total.rval + result1.rval
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_char) then
	  if(result1.type .eq. symb_typ_char) then
	    call str$append(total.strdes,result1.strdes)
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_date) then
	  if(result1.type .eq. symb_typ_date) then
	    istat = %loc(dix_msg_invmixdatd)	!assume problem
	    if(total.date(2) .ge. 0) then	!total=absolute
	      if(result1.date(2) .ge. 0) goto 90!two abs times
	      call lib$subx(total.date,result1.date,total.date)
	    else				!total = delta
	      if(result1.date(2) .ge. 0) then
	        call lib$subx(result1.date,total.date,total.date)
	      else                              !both delta
	        call lib$addx(total.date,result1.date,total.date)
	      endif
	    endif	      
	    istat = 1
	  else
	    istat = %loc(dix_msg_invmixdate)
	    goto 90
	  endif
	else
	  istat = %loc(dix_msg_invtype)
	endif
	if(overflow) istat = %loc(dix_msg_aroverfl)
90	dix_eval_add = istat
	return
	end
	function dix_eval_sub(total,result1)
	implicit none
c
c Result1 must be subtracted from total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_sub
c
	record /strdef/ zero_string
c
	integer*4 istat,ipos,nk
c
	external dix_msg_invmixic
	external dix_msg_invtype
	external dix_msg_aroverfl
	external dix_eval_overflow
	external dix_msg_invmixdate
	external dix_msg_invmixdatd
	logical overflow
	volatile overflow
	common /dix_eval_overflow_common/ overflow
c
	integer*4 str$position
c
	overflow = .false.
	call lib$establish(dix_eval_overflow)
	istat = 1
	if(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_int) then
	    total.ival = total.ival - result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = real(total.ival)
	    total.type = symb_typ_real
	    total.rval = total.rval - result1.rval
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_real) then
	  if(result1.type .eq. symb_typ_int) then
	    total.rval = total.rval - real(result1.ival)
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = total.rval - result1.rval
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_char) then
	  if(result1.type .eq. symb_typ_char) then
	    ipos = str$position(total.strdes,result1.strdes)
	    if(ipos .ne. 0) then
c	      call dix_eval_init_char(zero_string)
	      nk = zext(result1.strdes.dsc$w_maxstrlen)
	      call str$replace(total.strdes,total.strdes,ipos,ipos+nk-1,
     1                 zero_string)
	    end if
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_date) then
	  if(result1.type .eq. symb_typ_date) then
	    istat = %loc(dix_msg_invmixdatd)		!assume problems
	    if(total.date(2) .lt. 0) then		!total=delta
	      if(result1.date(2) .lt. 0) then
	        call lib$subx(total.date,result1.date,total.date)	!total=delta
	        if(total.date(2) .ge. 0) goto 90
	      else
	        call lib$addx(result1.date,total.date,total.date)	!total=delta
	      endif
	    else					!total is absolute
	      if(result1.date(2) .lt. 0) then
	        call lib$addx(total.date,result1.date,total.date)       !result=delta
	      else
	        call lib$subx(total.date,result1.date,total.date)	!both abs
	        if(total.date(2) .ge. 0) goto 90
	      endif
	    endif
	    istat = 1
	  else
	    istat = %loc(dix_msg_invmixdate)
	    goto 90
	  endif
	else
	  istat = %loc(dix_msg_invtype)
	endif
	if(overflow) istat = %loc(dix_msg_aroverfl)
90	dix_eval_sub = istat
	return
	end
	function dix_eval_mul(total,result1)
	implicit none
c
c Result1 must be subtracted from total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_mul
c
	integer*4 istat	,nkar,k
c
	external dix_msg_invmixrc
	external dix_msg_invoperc
	external dix_msg_invtype
	external dix_msg_aroverfl
	external dix_eval_overflow
	logical overflow
	volatile overflow
	common /dix_eval_overflow_common/ overflow
c
	character kar
c
	overflow = .false.
	call lib$establish(dix_eval_overflow)
	istat = 1
	if(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_int) then
	    total.ival = total.ival * result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = real(total.ival)
	    total.type = symb_typ_real
	    total.rval = total.rval * result1.rval
	  elseif(result1.type .eq. symb_typ_char) then
	    nkar = 0
	    call str$left(kar,result1.strdes,1)
	    k = total.ival
c	    call dix_eval_init_char(total.strdes)
	    call str$dupl_char(total,k,kar)
	    total.type = symb_typ_char
	  else
	    istat = %loc(dix_msg_invtype)
	  endif
	elseif(total.type .eq. symb_typ_real) then
	  if(result1.type .eq. symb_typ_int) then
	    total.rval = total.rval * real(result1.ival)
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = total.rval * result1.rval
	  elseif(result1.type .eq. symb_typ_char) then
	    istat = %loc(dix_msg_invmixrc)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_char) then
	  if(result1.type .eq. symb_typ_int) then
	    call str$left(kar,total.strdes,1)
	    call str$free1_dx(total.strdes)
	    call str$dupl_char(total.strdes,result1.ival,kar)
	    total.type = symb_typ_char
	  else
	    istat = %loc(dix_msg_invoperc)
	  endif
	  goto 90
	else
	  istat = %loc(dix_msg_invtype)
	endif	
	if(overflow) istat = %loc(dix_msg_aroverfl)
90	dix_eval_mul = istat
	return
	end
	function dix_eval_div(total,result1)
	implicit none
c
c Result1 must be subtracted from total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_div
c
	integer*4 istat,ipos,nk
c
	external dix_msg_invmixic
	external dix_msg_invmixrc
	external dix_msg_invtype
	external dix_msg_invoperc
	external dix_msg_aroverfl
	external dix_eval_overflow
	logical overflow
	volatile overflow
	common /dix_eval_overflow_common/ overflow
c
	record /strdef/ zero_string
c
	integer*4 str$position
c
c
	overflow = .false.
	call lib$establish(dix_eval_overflow)
	istat = 1
	if(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_int) then
	    total.ival = total.ival / result1.ival
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = real(total.ival)
	    total.type = symb_typ_real
	    total.rval = total.rval / result1.rval
	  else
	    istat = %loc(dix_msg_invmixic)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_real) then
	  if(result1.type .eq. symb_typ_int) then
	    total.rval = total.rval / real(result1.ival)
	  elseif(result1.type .eq. symb_typ_real) then
	    total.rval = total.rval / result1.rval
	  else
	    istat = %loc(dix_msg_invmixrc)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_char) then
	  if(result1.type .eq. symb_typ_char) then
	    if(zext(total.strdes.dsc$w_maxstrlen) .gt. 0 .and. 
     1         zext(result1.strdes.dsc$w_maxstrlen) .gt. 0) then
c	      call dix_eval_init_char(zero_string)
45	      ipos = str$position(total.strdes,result1.strdes)
	      if(ipos .ne. 0) then
	        nk = zext(result1.strdes.dsc$w_maxstrlen)
	        call str$replace(total.strdes,total.strdes,ipos,ipos+nk-1,
     1                 zero_string)
	        goto 45
	      end if
	    endif
	  else
	    istat = %loc(dix_msg_invoperc)
	    goto 90
	  endif
	else
	  istat = %loc(dix_msg_invtype)
	endif
	if(overflow) istat = %loc(dix_msg_aroverfl)
90	dix_eval_div = istat
	return
	end
	function dix_eval_and(total,result1)
	implicit none
c
c Result1 must be anded tot total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_and
c
	integer*4 istat
c
	external dix_msg_invmixand
	external dix_msg_invtype
c
	istat = 1
	if(total.type .eq. symb_typ_log) then
	  if(result1.type .eq. symb_typ_log) then
	    total.lval = total.lval .and. result1.lval
	  elseif(result1.type .eq. symb_typ_int) then
	    total.lval = total.lval .and. result1.ival
	  else
	    istat = %loc(dix_msg_invmixand)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_log) then
	    total.lval = total.ival .and. result1.lval
	    total.type = symb_typ_log
	  elseif(result1.type .eq. symb_typ_int) then
	    total.lval = total.ival .and. result1.ival
	    total.type = symb_typ_log
	  else
	    istat = %loc(dix_msg_invmixand)
	    goto 90
	  endif
	else
	  istat = %loc(dix_msg_invtype)
	  goto 90
	endif	      
90	dix_eval_and = istat
	return
	end
	function dix_eval_or(total,result1)
	implicit none
c
c Result1 must be anded tot total
c check for the types
c
	include 'dix_def.inc'
	record /value/ total
	record /value/ result1
	integer*4 dix_eval_or
c
	integer*4 istat
	external dix_msg_invmixor
	external dix_msg_invtype
c
	istat = 1
	if(total.type .eq. symb_typ_log) then
	  if(result1.type .eq. symb_typ_log) then
	    total.lval = total.lval .or. result1.lval
	  elseif(result1.type .eq. symb_typ_int) then
	    total.lval = total.lval .or. result1.ival
	  else
	    istat = %loc(dix_msg_invmixor)
	    goto 90
	  endif
	elseif(total.type .eq. symb_typ_int) then
	  if(result1.type .eq. symb_typ_log) then
	    total.lval = total.ival .or. result1.lval
	    total.type = symb_typ_log
	  elseif(result1.type .eq. symb_typ_int) then
	    total.lval = total.ival .or. result1.ival
	    total.type = symb_typ_log
	  else
	    istat = %loc(dix_msg_invmixor)
	    goto 90
	  endif
	else
	  istat = %loc(dix_msg_invtype)
	  goto 90
	endif	      
90	dix_eval_or = istat
	return
	end

        function dix_eval_overflow(sigargs) !,mechargs)
        implicit none
c
        integer*4 sigargs(*)
c       integer*4 mechargs(*)
        integer*4 dix_eval_overflow
c
        include '($ssdef)'
        include '($mthdef)'
c
	integer*4 overflow
	common /dix_eval_overflow_common/ overflow
c
        integer*4 signal
c
        signal = sigargs(2)
c
        if(signal .eq. ss$_intovf .or.
     1     signal .eq. ss$_intdiv .or.
     1     signal .eq. ss$_fltovf .or.
     1     signal .eq. ss$_fltdiv .or.
     1     signal .eq. ss$_hparith .or.
     1     signal .eq. mth$_floovemat) then
          overflow = .true.
          dix_eval_overflow = ss$_continue
        elseif(
     1     signal .eq. ss$_fltovf_f .or.
     1     signal .eq. ss$_fltdiv_f) then
          overflow = .true.
          dix_eval_overflow = ss$_continue
          call sys$unwind(,)
        else
          dix_eval_overflow = ss$_resignal
        end if
        return
        end
	function dix_eval_func(control,funcnam,narg,args,result,
     1               err_arg,set_dep)
	implicit none
c
c evaluate functions
c  the name is in funcnam, the args in ars(*) 
c this function returns
c  1       : it was a function and is correctly handled
c  invfunc : is was not a recognized function name
c   else   : error when evluating function
c
	include 'dix_def.inc'
	record /control/ control	!:i: control block
	character*(*)funcnam		!:i: function name
	integer*4 narg			!:i: #arguments
	record /value/ args(*)		!:i: arguments
	record /value/ result		!:o: result value
	character*(*) err_arg		!:o: error argument
	logical set_dep			!:i: set dependancy for refs
	logical*4 dix_eval_func		!:f: function result
c
	record /des_rec_fil/ des_rec_fil
	pointer (p_des_rec_fil,des_rec_fil)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	record /des_info/ des_info
	pointer (p_des_info,des_info)
c
	record /file_info/ file_info
	pointer (p_file_info,file_info)
c
	include '($libdtdef)'
c
	integer*4 max_faol_size
	parameter (max_faol_size=100)
c
	integer*4 k,bpos,epos,istat,argval,this_time(2),wl,nk,iel,nk1
	integer*4 nk_mask,ndim,idx,nk_tab,flag,descr(2),pos,siz,pnt,ptr
	integer*4 nk_what,ptr_file,iha
	integer*2 numtim(7)
	character*(max_line_length) action,mask,table,mode,option,what
	character*(max_line_length) argvals
	character*(max_str_len) work,work1
	character kar
	integer*4 nk_work,nk_work1,arglist(max_faol_size)
	record /des_rec/ des_rec
	record /value/ symbval
	logical unix,case
c
	integer*4 dix_util_get_len_fu
	integer*4 str$element
	integer*4 dix_util_checksum
	integer dix_eval_check_arg
	integer dix_symbol_find
	integer dix_des_find_field
	integer*4 dix_util_get_len
	integer*4 dix_eval_trnlnm
	integer*4 dix_eval_getdvi
	integer*4 lib$convert_date_string
	integer*4 vms_vers
	integer*4 sys$faol
c
	integer*4 lib$extzv
	integer*4 lib$extv
	integer*4 str$pos_extr
	integer*4 str$trim
	integer*4 str$left
	integer*4 str$upcase	
c
	external dix_msg_wrargcnt
	external dix_msg_wrargtyp
	external dix_msg_wrargval
	external dix_msg_invfunc
	external dix_msg_nofilopen
	external dix_msg_fldnotf
	external dix_msg_symbnotf
	external dix_msg_filnotf
	logical dix_util_match
	integer*4 dix_util_find_string_wild
	logical dix_util_match_string_wild
c
	call dix_eval_init_char(symbval.strdes)
	istat = 1
	if(dix_util_match(funcnam,'AND')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_int .or.
     1       args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_int
	  result.ival = args(1).ival .and. args(2).ival
	elseif(dix_util_match(funcnam,'OR')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_int .or.
     1       args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_int
	  result.ival = args(1).ival .or. args(2).ival
	elseif(dix_util_match(funcnam,'NOT')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_log) goto 30
	  result.type = symb_typ_log
	  result.lval = .not. args(1).lval
	elseif(dix_util_match(funcnam,'EVEN')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_log
	  result.lval = .not. btest(args(1).ival,0)
	elseif(dix_util_match(funcnam,'ODD')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_log
	  result.lval = btest(args(1).ival,0)
	elseif(dix_util_match(funcnam,'LSHI|FT')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_int .or.
     1       args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_int
	  result.ival = ishft(args(1).ival,args(2).ival)
	elseif(dix_util_match(funcnam,'RSHI|FT')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_int .or.
     1       args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_int
	  result.ival = ishft(args(1).ival,-args(2).ival)
	elseif(dix_util_match(funcnam,'MOD')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_int .or.
     1       args(1).type .ne. symb_typ_int) goto 30
	  result.type = symb_typ_int
	  result.ival = mod(args(1).ival,args(2).ival)
	elseif(dix_util_match(funcnam,'MAX')) then
	  if(args(1).type .eq. symb_typ_char) goto 30
	  result = args(1)
	  do k=2,narg
	    if(args(k).type .eq. symb_typ_char) goto 30
	    if(result.type .eq. symb_typ_real) then
c
c Result is real
c
	      if(args(k).type .eq. symb_typ_int) then
	        if(real(args(k).ival) .gt. result.rval) then
	          result = args(k)	!changes type to real
	        endif
	      else
	        result.rval = max(result.rval,args(k).rval)
	      endif
	    else
c
c Result is int
c
	      if(args(k).type .eq. symb_typ_int) then
	        result.ival = max(result.ival,args(k).ival)
	      else
	        if(args(k).rval .gt. real(result.ival)) then
	          result = args(k) 	!changes type too
	        endif
	      endif
	    endif
	  end do
	elseif(dix_util_match(funcnam,'MIN')) then
	  result = args(1)
	  do k=2,narg
	    if(args(k).type .eq. symb_typ_char) goto 30
	    if(result.type .eq. symb_typ_real) then
c
c Result is real
c
	      if(args(k).type .eq. symb_typ_int) then
	        if(real(args(k).ival) .lt. result.rval) then
	          result = args(k)		!changes type too
	        endif
	      else
	        result.rval = min(result.rval,args(k).rval)
	      endif
	    else
c
c Result is int
c
	      if(args(k).type .eq. symb_typ_int) then
	        result.ival = min(result.ival,args(k).ival)
	      else
	        if(args(k).rval .lt. real(result.ival)) then
	          result = args(k)		!chnges type too
	        endif
	      endif
	    endif
	  end do
	elseif(dix_util_match(funcnam,'REAL')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_char) goto 30
	  if(args(1).type .eq. symb_typ_int) then
	    result.rval = real(args(1).ival)
	    result.type = symb_typ_real
	  else
	    result = args(1)
	  endif	  
	elseif(dix_util_match(funcnam,'STRING')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_int) then
	    nk_work = 0
	    call sys$fao('!UL',nk_work,work,
     1            %val(args(1).ival))
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  elseif(args(1).type .eq. symb_typ_int) then
	    call dix_con_value_intasc(control,args(1),work,
     1               nk_work,.false.)
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  else
	    result = args(1)
	  endif
	elseif(dix_util_match(funcnam,'LOGI|CAL')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_int) then
	    result.ival = args(1).lval
	    result.type = symb_typ_log
	  elseif(args(1).type .eq. symb_typ_log) then
	    result = args(1)
	  else 
	    goto 30
	  endif
	elseif(dix_util_match(funcnam,'INT')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_char) then
	    call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	    if(nk_work .gt. 10) goto 30
	    read(work(1:nk_work),2000,err=30) result.ival
	    result.type = symb_typ_int
	  elseif(args(1).type .eq. symb_typ_real) then
	    result.ival = int(args(1).rval)
	    result.type = symb_typ_int
	  elseif(args(1).type .eq. symb_typ_real) then
	    result = args(1)
	  else
	    goto 30
	  endif	  
	elseif(dix_util_match(funcnam,'NINT')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_char) then
	    call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	    if(nk_work .gt. 10) goto 30
	    read(work(1:nk_work),2000,err=30) result.ival
2000	    format(bn,i10)
	  elseif(args(1).type .eq. symb_typ_int) then
	    result = args(1)
	  elseif(args(1).type .eq. symb_typ_real) then
	    result.ival = nint(args(1).rval)
	    result.type = symb_typ_int
	  else
	    goto 30
	  endif	  
	elseif(dix_util_match(funcnam,'HEX')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .eq. symb_typ_char) then
	    call dix_eval_copy_char_fix(args(1).strdes,work1,nk_work1)
	    nk_work = 0
	    do k=1,nk_work1
	      write(work(nk_work+1:nk_work+3),4000) ichar(work1(k:k))
4000	      format(z2.2,1x)
	      nk_work = nk_work + 3
	    end do
	    if(nk_work .gt. 0) nk_work = nk_work - 1 
	  elseif(args(1).type .eq. symb_typ_int) then
	    write(work(1:8),4001) args(1).ival
4001	    format(z8.8)
	     nk_work = 8
	  elseif(args(1).type .eq. symb_typ_real) then
	    call lib$movc3(4,args(1).ival,k)
	    write(work(1:8),4001) k
	    nk_work = 8
	  elseif(args(1).type .eq. symb_typ_log) then
	    write(work(1:8),4001) args(1).lval
	     nk_work = 8
	  elseif(args(1).type .eq. symb_typ_date) then
	    write(work(1:8),4002) args(1).date
4002	    format(z8.8,' ',z8.8)
	    nk_work = 17
	  endif
	  call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$EXTZ|V') .or.
     1         dix_util_match(funcnam,'F$EXTV|')) then
	  if(narg .ne. 3) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(2).type .ne. symb_typ_int) goto 30
c
	  pos = args(1).ival	  
	  siz = args(2).ival
c
	  if(args(3).type .eq. symb_typ_int) then
	    pnt = %loc(args(3).ival)
	    k = 32
	  elseif(args(3).type .eq. symb_typ_real) then
	    pnt = %loc(args(3).rval)
	    k = 32
	  elseif(args(3).type .eq. symb_typ_log) then
	    pnt = %loc(args(3).lval)
	    k = 32
	  elseif(args(3).type .eq. symb_typ_char) then
	    pnt = args(3).strdes.dsc$a_pointer
	    k = 8*args(3).strdes.dsc$w_maxstrlen
	  elseif(args(3).type .eq. symb_typ_date) then
	    pnt = %loc(args(3).date)
	    k = 64
	  endif
	  if(pos+siz .lt. 0) goto 40	!
	  if(pos+siz .gt. k) goto 40
	  if(siz .gt. 32)    goto 40
	  if(funcnam(6:6) .eq. 'Z' .or. funcnam(6:6) .eq. 'z') then
	    result.ival = lib$extzv(pos,siz,%val(pnt))
	  else
	    result.ival = lib$extv(pos,siz,%val(pnt))
	  endif
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'F$INS|V')) then
	  if(narg .ne. 4) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(2).type .ne. symb_typ_int) goto 30
	  if(args(3).type .ne. symb_typ_int) goto 30
	  pos = args(2).ival
	  siz = args(3).ival
c
	  if(args(4).type .eq. symb_typ_char) then
	  else
	    result = args(4)
	  endif	  
	  if(args(4).type .eq. symb_typ_int) then
	    pnt = %loc(result.ival)
	    k = 32
	  elseif(args(4).type .eq. symb_typ_real) then
	    pnt = %loc(result.rval)
	    k = 32
	  elseif(args(4).type .eq. symb_typ_log) then
	    pnt = %loc(result.lval)
	    k = 32
	  elseif(args(4).type .eq. symb_typ_char) then
	    call dix_eval_copy_char_fix(args(4).strdes,work,nk_work)
	    pnt = %loc(work)
	    k = 8*nk_work
	  elseif(args(4).type .eq. symb_typ_date) then
	    pnt = %loc(result.date)
	    k = 64
	  endif
	  if(pos+siz .lt. 0) goto 40	!
	  if(pos+siz .gt. k) goto 40
	  if(siz .gt. 32)    goto 40
	  call lib$insv(args(1).ival,pos,siz,%val(pnt))
	  if(args(4).type .eq. symb_typ_char) then 
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  endif
c
	elseif(dix_util_match(funcnam,'F$ENV|IRONMENT')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
c
	  call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	  argvals='DEPTH|MESSAGE|ON_SEVERITY|ON_ACTION|'//
     1            'PROCEDURE|INTERACTIVE|PROMPT'
	  istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	  if(.not. istat) goto 50
	  call dix_eval_envi(control,work(1:nk_work),result)
	elseif(dix_util_match(funcnam,'F$RAND|OM')) then
	  if(narg .gt. 1) goto 20
	  if(narg .eq. 0) then
	    args(1).type = symb_typ_real
	    args(1).rval = 1.0
	  endif
	  if(args(1).type .eq. symb_typ_int) then
	    if(args(1).ival .le. 1) goto 40
	    result.ival = int(args(1).ival * ran(control.ran_seed))
	    result.type = symb_typ_int
	  elseif(args(1).type .eq. symb_typ_real) then
	    if(args(1).rval .le. 0.0) goto 40
	    result.rval = args(1).rval * ran(control.ran_seed)
	    result.type = symb_typ_real
	  else
	    goto 30
	  endif 
	elseif(dix_util_match(funcnam,'F$GETD|VI')) then
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  if(args(2).type .ne. symb_typ_char) goto 30
c
	  call dix_eval_copy_char_fix(args(2).strdes,work,nk_work)
	  argvals = 'MAXBLOCK|MAXFILES|EXISTS|BLNRFILE'
	  istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	  if(.not. istat) goto 50
c
	  istat = dix_eval_getdvi(args(1).strdes,work(1:nk_work),result)
	elseif(dix_util_match(funcnam,'F$EDIT')) then
c
c F$edit(string,"what,what")
c
	  if(narg .ne. 2) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  if(args(2).type .ne. symb_typ_char) goto 30
c
	  call dix_eval_copy_value(args(1),result)
	  call dix_eval_copy_char_fix(args(2).strdes,work1,nk_work1)
	  iel = 0
	  do while(str$element(work,iel,',',work1(1:nk_work1)))
	    nk_work = dix_util_get_len(work)
	    argvals = 'COLLAPSE|COMPRESS|TRIM|UPPERCASE|LOWERCASE|UNCOMMENT'
	    istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	    if(.not. istat) goto 50
	    action = work(1:nk_work)
c
	    nk_work = -1
	    if(action(1:3) .eq. 'COL') then
	      call dix_eval_copy_char_fix(result.strdes,work,nk_work)
	      call dix_util_compress_Line(work,nk_work,.true.)
	    elseif(action(1:3) .eq. 'COM') then
	      call dix_eval_copy_char_fix(result.strdes,work,nk_work)
	      call dix_util_compress_line(work,nk_work,.false.)
	    elseif(action(1:1) .eq. 'T') then
	      call str$trim(result.strdes,result.strdes)
	    elseif(action(1:2) .eq. 'UP') then
	      call str$upcase(result.strdes,result.strdes)
	    elseif(action(1:1) .eq. 'L') then
	      call dix_util_case_line(result.strdes,.false.)
	    elseif(action(1:2) .eq. 'UN') then
	      call dix_eval_copy_char_fix(result.strdes,work,nk_work)
	      call dix_util_remove_comment(nk_work,work)
	    endif
	    if(nk_work .ge. 0) then
	      call dix_eval_copy_char_dyn(work(1:nk_work),result.strdes)
	    endif
	    iel = iel + 1
	  enddo                         
	elseif(dix_util_match(funcnam,'F$FAO')) then
	  if(narg .eq. 0 .or. narg .gt. max_faol_size) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  do k=1,max_faol_size
	    arglist(k) = 0
	  enddo
	  do k=2,narg
	    if(args(k).type .eq. symb_typ_int) then
	      arglist(k-1) = args(k).ival
	    elseif(args(k).type .eq. symb_typ_char) then
	      arglist(k-1) = %loc(args(k).strdes)
	    elseif(args(k).type .eq. symb_typ_date) then
	      arglist(k-1) = %loc(args(k).date)
	    else
	      goto 30
	    endif
	  end do
	  nk_work = 0
	  istat = sys$faol(args(1).strdes,nk_work,work,arglist)
	  if(.not. istat) goto 90	  
	  result.type = symb_typ_char
	  call dix_eval_copy_char_dyn(work(1:nk_work),result.strdes)
	elseif(dix_util_match(funcnam,'F$DATE')) then
	  argvals = 'WEEKS|DAYS|HOURS|MINUTES|SECONDS|HUNDREDTH|CPUTICKS'
	  if(args(1).type .eq. symb_typ_char) then
	    if(narg .ne. 1) goto 20
c
	    istat = lib$convert_date_string(args(1).strdes,result.date)
	    call dix_eval_copy_char_fix(args(1).strdes,argvals,nk)
	    if(.not. istat) goto  50
	  elseif(args(1).type .eq. symb_typ_int) then
	    if(narg .ne. 2) goto 20
	    if(args(1).ival .lt. 0) goto 40	!invalid value
c
	    if(args(1).type .eq. symb_typ_char) goto 30
	    call dix_eval_copy_char_fix(args(2).strdes,work,nk_work)
	    istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	    if(.not. istat) goto 50
	    flag = -1
	    if(work(1:1) .eq. 'W') then
	      flag = lib$k_delta_weeks
	    elseif(work(1:1) .eq. 'D') then
	      flag = lib$k_delta_days
	    elseif(work(1:2) .eq. 'HO') then
	      flag = lib$k_delta_hours
	    elseif(work(1:1) .eq. 'M') then
	      flag = lib$k_delta_minutes
	    elseif(work(1:1) .eq. 'S') then
	      flag = lib$k_delta_seconds
	    elseif(work(1:2) .eq. 'HU' .or. work(1:1) .eq. 'C') then
	      call lib$emul(-10*1000*10,args(1).ival,-1,result.date)	      
	      flag = 0
	    endif
	    if(flag .ne. 0) then
	      call lib$cvt_to_internal_time(flag,args(1).ival,result.date)
	    endif
	  elseif(args(1).type .eq. symb_typ_real) then
	    if(narg .ne. 2) goto 20
	    if(args(1).rval .lt. 0) goto 40	!invalid value
c
	    if(args(1).type .eq. symb_typ_char) goto 30
	    call dix_eval_copy_char_fix(args(2).strdes,work,nk_work)
	    istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	    if(.not. istat) goto 50
	    if(work(1:1) .eq. 'W') then
	      flag = lib$k_delta_weeks_f
	    elseif(work(1:1) .eq. 'D') then
	      flag = lib$k_delta_days_f
	    elseif(work(1:2) .eq. 'HO') then
	      flag = lib$k_delta_hours_f
	    elseif(work(1:1) .eq. 'M') then
	      flag = lib$k_delta_minutes_f
	    elseif(work(1:1) .eq. 'S') then
	      flag = lib$k_delta_seconds_f
	    elseif(work(1:2) .eq. 'HU' .or. work(1:1) .eq. 'C') then
	      flag = lib$k_delta_seconds_f
	      args(1).rval = args(1).rval/100.0
	    endif
	    call lib$cvtf_to_internal_time(flag,args(1).rval,result.date)
	  else
	    goto 30
	  endif	  
	  result.type = symb_typ_date
	elseif(dix_util_match(funcnam,'F$TIME')) then
	  if(narg .gt. 2) goto 20
	  if(narg .eq. 2) then
	    if(args(2).type .eq. symb_typ_date) then
	      call lib$movc3(8,args(2).date,this_time)
	    elseif(args(2).type .eq. symb_typ_char) then
	      istat = lib$convert_date_string(args(2).strdes,this_time)
	      if(.not. istat) goto 90
	    else
	      goto 30
	    endif
	  else
	    call sys$gettim(this_time)
	  endif
	  nk_work = 0
	  call sys$asctim(nk_work,work,this_time,)
	  call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  call sys$numtim(numtim,this_time)
	  if(this_time(2) .lt. 0) then
	    call str$prefix(result.strdes,'       ')
	  endif
	  result.type = symb_typ_char
	  if(narg .gt. 0) then
	    if(args(1).type .ne. symb_typ_char) goto 30
	    call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	    if(work(1:nk_work) .ne. ' ') then
	      argvals = 'DATE|TIME|YEAR|MONTHASC|DAY|HOUR|'//
     1         'MINUTE|SECOND|HUNDREDTH'
	      istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
c
	      if(work(1:nk_work) .eq. 'DATE') then
	        if(this_time(2).lt. 0) then	!delta time
	          istat = str$pos_extr(result.strdes,result.strdes,8,11)
	          if(.not. istat) call lib$signal(%val(istat))
	        else
	          istat = str$pos_extr(result.strdes,result.strdes,1,11)
	          if(.not. istat) call lib$signal(%val(istat))
	        endif
	      elseif(work(1:1) .eq. 'T') then
	        istat = str$pos_extr(result.strdes,result.strdes,13,23)
	        if(.not. istat) call lib$signal(%val(istat))
	      elseif(work(1:1) .eq. 'Y') then
	        result.ival = numtim(1)
	        result.type = symb_typ_int
	      elseif(work(1:6) .eq. 'MONTH ') then
	        result.ival = numtim(2)
	        result.type = symb_typ_int
	      elseif(work(1:6) .eq. 'MONTHA') then
	        istat = str$pos_extr(result.strdes,result.strdes,4,6)
	        if(.not. istat) call lib$signal(%val(istat))
	      elseif(work(1:1) .eq. 'D') then
	        result.ival = numtim(3)
	        result.type = symb_typ_int
	      elseif(work(1:2) .eq. 'HO') then
	        result.ival = numtim(4)
	        result.type = symb_typ_int
	      elseif(work(1:2) .eq. 'MI') then
	        result.ival = numtim(5)
	        result.type = symb_typ_int
	      elseif(work(1:1) .eq. 'S') then
	        result.ival = numtim(6)
	        result.type = symb_typ_int
	      elseif(work(1:2) .eq. 'HU') then
	        result.ival = numtim(7)
	        result.type = symb_typ_int
	      endif
	    endif
	  endif
	elseif(dix_util_match(funcnam,'F$CHEC|KSUM')) then
c
c Syntax
c  f$checksum(begpos,endpos,[size],[method],[file])
c size   = byte/word/longword
c method = sum/xor
c file   = filetag
c
	  if(narg .gt. 5) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(2).type .ne. symb_typ_int) goto 30
c
c Parse size
c
	  wl = 1		!assume bytes
	  if(narg .ge. 3) then
	    if(args(3).type .ne. symb_typ_none) then		    
	      if(args(3).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(3).strdes,work,nk_work)
	      argvals = 'BYTE|WORD|LONGWORD'
	      istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	      wl = 0
	      if(work(1:1) .eq. 'B') wl = 1
	      if(work(1:1) .eq. 'W') wl = 2
	      if(work(1:1) .eq. 'L') wl = 4
	    endif
	  endif	  
c
c Parse method
c
	  work(1:1) = 'S'
	  if(narg .ge. 4) then
	    if(args(4).type .ne. symb_typ_none) then		    
	      if(args(4).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(4).strdes,work,nk_work)
	      argvals = 'XOR|SUM'
	      istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
c
c Parse file
c
	  iha = 5
	  call dix_eval_set_file(control,args(5),ptr_file)
	  if(ptr_file .eq. 0) goto 80
	  p_file_info = ptr_file
c
	  args(1).ival = min(file_info.data.nb_data,args(1).ival)
	  args(2).ival = min(file_info.data.nb_data,args(2).ival)
	  result.ival = dix_util_checksum(wl,file_info.data.data_rec,
     1            args(1).ival,args(2).ival,work(1:1))
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'F$ENUM|ERATE')) then
	  if(narg .gt. 2) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(narg .gt. 1) then
	    if(args(2).type .ne. symb_typ_char) goto 30
	    call dix_eval_upcase(args(2).strdes,mask,nk_mask)
	  else
	    mask = '*'
	    nk_mask = 1
	  endif	    
	  call dix_des_get_fieldname(control,args(1).ival,mask(1:nk_mask),
     1          work,nk_work)
	  call dix_eval_copy_char_dyn(work(1:nk_work),result.strdes)
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$TRIM')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  result.type = symb_typ_char
	  istat = str$trim(result.strdes,args(1).strdes)
	  if(.not. istat) call lib$signal(%val(istat))
	elseif(dix_util_match(funcnam,'F$LENG|TH')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  result.ival = zext(args(1).strdes.dsc$w_maxstrlen)
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'F$TRNL|NM')) then
	  if(narg .lt. 1 .or. narg .gt. 6) goto 20

	  if(args(1).type .ne. symb_typ_char) goto 30
c
c Arg2 must be (if there) a string (tablename)
c
	  table = 'LNM$FILE_DEV'
	  nk_tab = 12
	  if(narg .ge. 2) then
	    if(args(2).type .ne. symb_typ_none) then
	      if(args(2).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(2).strdes,table,nk_tab)
	    endif
	  endif
c
c Arg3 (if there) must be integer (index)
c
	  idx = 0
	  if(narg .ge. 3) then
	    if(args(3).type .ne. symb_typ_none) then
	      if(args(3).type .ne. symb_typ_int) goto 30
	      idx = args(3).ival
	    endif
	  endif
c
c Arg4 (if there) must be mode
c
	  mode = ' '
	  if(narg .ge. 4) then
	    if(args(4).type .ne. symb_typ_none) then
	      if(args(4).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(4).strdes,work,nk_work)
	      istat=dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	      mode = work(1:nk_work)
	    endif
	  endif
c
c Arg5 (if there) must be
c
	  option = ' '
	  if(narg .ge. 5) then
	    if(args(5).type .ne. symb_typ_none) then
	      if(args(5).type .ne. symb_typ_char) goto 30
	      k = 0
	      nk1 = 0
	      argvals = 'CASE_SENSITIVE'
	      if(vms_vers() .gt. 720) argvals = 'INTERLOCKED|'//argvals
	      do while(str$element(work,k,',',args(5).strdes))
	        nk_work = dix_util_get_len(work)
	        istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	        if(.not. istat) goto 50
	        k = k + 1
	        option = option(1:nk1)//','//work(1:nk_work)
	        nk1 = nk1 + 1 + nk_work
	      enddo
	    endif
	  endif
c
c Arg6 (if there) must be a string 
c
	  what = 'VALUE'
	  if(narg .ge. 6) then
	    if(args(6).type .ne. symb_typ_none) then
	      if(args(6).type .ne. symb_typ_char) goto 30
	      work(1:10) = ' '
	      call dix_eval_copy_char_fix(args(6).strdes,work,nk_work)
	      nk_work = 10
	      argvals = 'ACCESS_MODE|CONCEALED|CONFINE|CRELOG|'//
     1        'MAX_INDEX|NO_ALIAS|TABLE|TERMINAL|VALUE|LENGTH|EXISTS|'//
     1        'TABLE_NAME'
	      if(vms_vers() .gt. 720) argvals = 'CLUSTERWIDE|'//argvals
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	      what = work(1:nk_work)
	    endif
	  endif
c
c Now we have it all, create the service
c
	  istat = dix_eval_trnlnm(args(1).strdes,
     1         table(1:nk_tab),idx,mode,option,what,result)
	elseif(dix_util_match(funcnam,'F$DES|CRIPTION')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  k = args(1).ival
	  p_des_info = control.top_descr
	  do while(p_des_info .ne. 0)
	    k = k-1
	    if(k .eq. 0) then
	      call dix_eval_fill_char(result.strdes,
     1                 des_info.fnam(1:des_info.nk_fnam))
	      p_des_info = 0
	    else
	      p_des_info = des_info.link.forw
	    end if
	  end do
	elseif(dix_util_match(funcnam,'F$FILE')) then
c
c F$file(what,fileidx)
c f$file("DES",fileidx,"DESWHAT",desidx)
c fileidx and desidx can be either numbers or tags
c
	  if(narg .lt. 1) goto 20
	  if(narg .gt. 4) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
c
c	  
	  call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	  argvals = 'ORG|NAME|NOK|KEY|TAG|DESCRIPTION'
	  istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	  if(.not. istat) goto 50
c
	  result.type = symb_typ_char	!assume no result
c
	  iha = 2
	  call dix_eval_set_file(control,args(2),ptr_file)
	  if(ptr_file .eq. 0) goto 80
	  p_file_info = ptr_file
c
311	  if(work(1:1) .eq. 'D') then
c
c Only for descriptors the third and fourth paramater are allowed
c
	    p_des_expanded = file_info.cur_des
	    if(narg .ge. 4) then
	      if(args(4).type .ne. symb_typ_none) then 
	        if(args(4).type .eq. symb_typ_int) then
	          k = args(4).ival
	          do while(p_des_expanded .ne. 0)
	            k = k - 1
	            if(k .eq. 0) goto 312
	            p_des_expanded = des_expanded.link.forw
	          end do
	        elseif(args(4).type .eq. symb_typ_char) then
	          call dix_eval_copy_char_fix(args(4).strdes,what,nk_what)
	          call str$upcase(what(1:nk_what),what(1:nk_what))
	          p_des_expanded = file_info.top_des
	          do while(p_des_expanded .ne. 0)
	            if(des_expanded.handle .eq. what(1:nk_what)) goto 312
	            p_des_expanded = des_expanded.link.forw
	          enddo
	        else
	          goto 30		!illegal type
	        endif
	        result.type = symb_typ_char
	        work(1:1) = ' '            	!skip rest
	      endif
	    endif	        
c
312	    work1(1:1) = 'N'		!assume name wanted
	    if(narg .ge. 3) then
	      if(args(3).type .ne. symb_typ_none) then
	        if(args(3).type .ne. symb_typ_char) goto 30
	        call dix_eval_copy_char_fix(args(3).strdes,work1,nk_work1)
	        argvals = 'NAME|TAG'
	        istat = dix_eval_check_arg(work1(1:nk_work1),argvals,err_arg)
	        if(.not. istat) goto 50
	      endif
	    endif
	  else
	    if(narg .gt. 2) goto 20
	  endif
c
	  if(work(1:1) .eq. 'O') then
	    if(file_info.block_size .ne. 0) then
	      call dix_eval_fill_char(result.strdes,'BLK')
	    else
	      if(file_info.indexed) then
	        call dix_eval_fill_char(result.strdes,'IDX')
	      elseif(file_info.relative) then
	        call dix_eval_fill_char(result.strdes,'REL')
	      else
	        call dix_eval_fill_char(result.strdes,'SEQ')
	      endif
	    endif
	    result.type = symb_typ_char
	  elseif(work(1:1) .eq. 'D') then
	    if(work1(1:1) .eq. 'N') then
	      p_des_info = des_expanded.p_des_info
	      call dix_eval_fill_char(result.strdes,
     1                 des_info.fnam(1:des_info.nk_fnam))
	    elseif(work1(1:1) .eq. 'T') then
	      call dix_eval_fill_char(result.strdes,
     1                 des_expanded.handle(1:des_expanded.nk_handle))
	    endif
	    result.type = symb_typ_char
	  elseif(work(1:2) .eq. 'NA') then
	    call dix_eval_fill_char(result.strdes,
     1              file_info.fnam(1:file_info.nk_fnam))
	    result.type = symb_typ_char
	  elseif(work(1:1) .eq. 'T') then
	    call dix_eval_fill_char(result.strdes,
     1                      file_info.handle(1:file_info.nk_handle))
	    result.type = symb_typ_char
	  elseif(work(1:2) .eq. 'NO') then
	    result.ival = file_info.nkey
	    result.type = symb_typ_int
	  elseif(work(1:1) .eq. 'K') then
	    result.ival = file_info.cur_key
	    result.type = symb_typ_int
	  endif
	elseif(dix_util_match(funcnam,'F$COLL|APSE')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	  result.type = symb_typ_char
	  nk_work1 = 0
	  do k=1,nk_work
	    if(work(k:k) .ne. ' ') then
	      nk_work1 = nk_work1 + 1
	      work(nk_work1:nk_work1) = work(k:k)
	    endif
	  enddo
	  call dix_eval_copy_char_dyn(work(1:nk_work1),result.strdes)
	elseif(dix_util_match(funcnam,'F$ELEM|ENT')) then
	  if(narg .ne. 3) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(2).type .ne. symb_typ_char) goto 30
	  if(args(3).type .ne. symb_typ_char) goto 30
	  istat = str$left(kar,args(2).strdes,1)
	  if(.not. istat) call lib$signal(%val(istat))
	  if(args(1).ival .lt. 0) then
	    k = 0
	    do while(str$element(work,k,kar,args(3).strdes))
	      k = k + 1
	    end do
	    k = k + args(1).ival
	  else
	    k = args(1).ival
	  endif
	  if(.not. str$element(result.strdes,k,kar,args(3).strdes)) then
	    call dix_eval_fill_char(result.strdes,kar)
	  endif
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$EXTR|ACT')) then
	  if(narg .ne. 3) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(2).type .ne. symb_typ_int) goto 30
	  if(args(3).type .ne. symb_typ_char) goto 30
	  result.type = symb_typ_char
	  bpos = args(1).ival
	  if(bpos .ge. 0) then
	    bpos = bpos + 1
	  else
	    bpos = zext(args(3).strdes.dsc$w_maxstrlen) + bpos + 1
	  endif
	  if(args(2).ival .lt. 0) then
	    epos = zext(args(3).strdes.dsc$w_maxstrlen)
	  else
	    epos = min(args(2).ival + bpos - 1,
     1            zext(args(3).strdes.dsc$w_maxstrlen))
	  endif
c	  call dix_eval_init_char(result.strdes)
	  if(bpos .ge. 1 .and. bpos .le. 
     1          zext(args(3).strdes.dsc$w_maxstrlen)) then
	    istat = str$pos_extr(result.strdes,args(3).strdes,bpos,epos)
	  endif
	elseif(dix_util_match(funcnam,'F$MESS|AGE')) then
	  if(narg .gt. 2) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(narg .eq. 2) then
	    if(args(2).type .ne. symb_typ_int) goto 30
	    argval = args(2).ival
	    if(argval .lt. 0 .or. argval .gt. 15) goto 40
	  else
	    argval = 0
	  endif
	  result.type = symb_typ_char
	  call sys$getmsg(%val(args(1).ival),nk_work,work,%val(argval),)
	  call dix_eval_fill_char(result.strdes,work(1:nk_work))
	elseif(dix_util_match(funcnam,'F$MATC|HWILD')) then
	  if(narg .lt. 2 .or. narg .gt. 4) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  if(args(2).type .ne. symb_typ_char) goto 30
c
	  work(1:1) = 'V'	    
	  if(narg .ge. 3) then
	    if(args(3).type .ne. symb_typ_none) then
	      if(args(3).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(3).strdes,work,nk_work)
	      argvals = 'UNIX|VMS'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
	  unix = work(1:1) .eq. 'U'
c
	  work(1:1) = 'N'	    
	  if(narg .ge. 4) then
	    if(args(4).type .ne. symb_typ_char) then
	      if(args(4).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(3).strdes,work,nk_work)
	      argvals = 'CASE_SENSITIVE|NOCASE_SENSITIVE'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
	  case = work(1:1) .eq. 'C'
c

	  result.lval = dix_util_match_string_wild(args(1).strdes,
     1             args(2).strdes,unix,case)
	  result.type = symb_typ_log
	elseif(dix_util_match(funcnam,'F$UPCA|SE')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  istat = str$upcase(result.strdes,args(1).strdes)
	  if(.not. istat) call lib$signal(%val(istat))
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$LOCAS|E')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  call dix_eval_fill_char(result.strdes,args(1).strdes)
	  call dix_util_case_line(result.strdes,.false.)
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$LOCAT|E')) then
	  if(narg .lt. 2 .or. narg .gt. 4) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  if(args(2).type .ne. symb_typ_char) goto 30
	  work(1:1) = 'V'	    
	  if(narg .ge. 3) then
	    if(args(3).type .ne. symb_typ_none) then
	      if(args(3).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(3).strdes,work,nk_work)
	      argvals = 'UNIX|VMS'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
	  unix = work(1:1) .eq. 'U'
c
	  work(1:1) = 'N'	    
	  if(narg .ge. 4) then
	    if(args(4).type .ne. symb_typ_none) then
	      if(args(4).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(3).strdes,work,nk_work)
	      argvals = 'CASE_SENSITIVE|NOCASE_SENSITIVE'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
	  case = work(1:1) .eq. 'C'
c
	  result.ival = dix_util_find_string_wild(args(1).strdes,
     1                         args(2).strdes,k,unix,case)
	  if(result.ival .eq. 0) then
	    result.ival = zext(args(1).strdes.dsc$w_maxstrlen)
	  else
	    result.ival = result.ival - 1
	  endif
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'F$CHAR')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_int) goto 30
	  if(args(1).ival .lt. 0 .or. args(1).ival .gt. 255)goto 40
	  kar = char(args(1).ival)
	  call dix_eval_fill_char(result.strdes,kar)
	  result.type = symb_typ_char
	elseif(dix_util_match(funcnam,'F$EXIS|TS')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  call dix_eval_upcase(args(1).strdes,work,nk_work)
	  result.type = symb_typ_log
	  result.lval = dix_symbol_find(control,work(1:nk_work),symbval)
	elseif(dix_util_match(funcnam,'F$FIEL|D')) then
	  if(narg .ne. 2 .and. narg .ne. 3) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  if(args(2).type .ne. symb_typ_char) goto 30	
	  if(narg .eq. 3) then
	    if(args(3).type .ne. symb_typ_int) goto 30	
	  endif
c
	  call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	  argvals= 'EXISTS|TYPE|OFFSET|SIZE|BITOFFSET|'//
     1         'FIELD|NDIM|LOWDIM|HIGHDIM'
	  istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	  if(.not. istat) goto 50
c
c See if we can find the field
c
	  istat = dix_des_find_field(control,args(1).strdes,des_rec,
     1              set_dep,ptr)
c
c Now act on resut of find_field
c for exists just report the status
c
	  if(work(1:1) .eq. 'E') then
	    if(narg .ne. 2) goto 20
	    result.type = symb_typ_log
	    result.lval = istat
	    istat = 1
	  else
c
c For all other items, istat must be .true.
c
	    if(istat) then
c
c Field was found, get the info
c
	      if(work(1:1) .eq. 'T') then
	        if(narg .ne. 2) goto 20
	        call dix_util_get_type_name(des_rec.ent_type,work1,nk_work1)
	        if(des_rec.is_field) then
	          call sys$fao('*!UL.!UL',k,work1(nk_work1+1:),
     1                     %val(des_rec.size/8),
     1                     %val(mod(des_rec.size,8)))
	        else
	          call sys$fao('*!UL'    ,k, ,k,work1(nk_work1+1:),
     1                     %val(des_rec.size/8))
	        endif
	        call dix_eval_fill_char(result.strdes,work1(1:nk_work1))
	        result.type = symb_typ_char
	      elseif(work(1:1) .eq. 'B') then   !bit offset
	        if(narg .ne. 2) goto 20
	        result.type = symb_typ_int
	        result.ival = des_rec.bit_offset
	      elseif(work(1:1) .eq. 'O') then   !byte offset
	        if(narg .ne. 2) goto 20
	        result.type = symb_typ_int
	        result.ival = des_rec.bit_offset/8
	      elseif(work(1:1) .eq. 'F') then   !is bit_field
	        if(narg .ne. 2) goto 20
	        result.type = symb_typ_log
	        result.lval = des_rec.is_field
	      elseif(work(1:1) .eq. 'S') then	!size in bits
	        if(narg .ne. 2) goto 20
	        result.type = symb_typ_int
	        result.ival = des_rec.size
	      elseif(work(1:1) .eq. 'N') then	!#dimensions
	        if(narg .ne. 2) goto 20
	        p_des_rec_fil = des_rec.link_back
	        ndim = 0
	        do k=1,max_dimension
	          if(des_rec_fil.rep.dim(k).high .gt. 
     1               des_rec_fil.rep.dim(k).low) then
	            ndim = k
	          endif
	        end do
	        result.ival = ndim
	        result.type = symb_typ_int
	      elseif(work(1:1) .eq. 'L' .or. work(1:1) .eq. 'H') then	!low-highdim 
	        p_des_rec_fil = des_rec.link_back
	        do k=1,max_dimension
	          if(des_rec_fil.rep.dim(k).high .gt. 
     1               des_rec_fil.rep.dim(k).low) then
	            ndim = k
	          endif
	        end do
	        if(args(3).ival .lt. 1 .or. args(3).ival .gt. ndim) goto 40
	        if(work(1:1) .eq. 'L') then
	          result.ival = des_rec_fil.rep.dim(args(3).ival).low
	        else
	          result.ival = des_rec_fil.rep.dim(args(3).ival).high
	        endif
	        result.type = symb_typ_int	        
	      endif	    
	    else
	      call dix_eval_copy_char_fix(args(1).strdes,err_arg,nk_work)
	      istat = %loc(dix_msg_fldnotf)
	      goto 50
	    endif
	  endif
	elseif(dix_util_match(funcnam,'F$FEXI|STS')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  call dix_eval_upcase(args(1).strdes,work,nk_work)
	  result.type = symb_typ_log
	  result.lval = dix_des_find_field(control,work(1:nk_work),
     1             des_rec,set_dep,ptr)
	elseif(dix_util_match(funcnam,'F$TYPE')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  call dix_eval_upcase(args(1).strdes,work,nk_work)
	  if(dix_symbol_find(control,work(1:nk_work),symbval)) then
	    call dix_symbol_type(symbval,work,nk_work,.false.,.true.)
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	    result.type = symb_typ_char
	  else
	    call dix_eval_copy_char_fix(args(1).strdes,err_arg,nk_work)
	    istat = %loc(dix_msg_symbnotf)
	    goto 50
	  endif
	elseif(dix_util_match(funcnam,'F$FTYP|E')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  call dix_eval_upcase(args(1).strdes,work,nk_work)
	  if(dix_des_find_field(control,work(1:nk_work),des_rec,
     1                    set_dep,ptr)) then
	    call dix_util_get_type_name(des_rec.ent_type,work1,nk_work1)
	    if(des_rec.is_field) then
	      call sys$fao('*!UL.!UL',k,work1(nk_work1+1:),
     1                     %val(des_rec.size/8),
     1                     %val(mod(des_rec.size,8)))
	    else
	      call sys$fao('*!UL'    ,k,work1(nk_work1+1:),
     1                     %val(des_rec.size/8))
	    endif
	    nk_work1 = nk_work1 + 1
	    call dix_eval_fill_char(result.strdes,work1(1:nk_work1))
	    result.type = symb_typ_char
	  else
	    call dix_eval_copy_char_fix(args(1).strdes,err_arg,nk_work)
	    istat = %loc(dix_msg_fldnotf)
	    goto 50
	  endif
	elseif(dix_util_match(funcnam,'%DATA')) then
	  if(narg .gt. 2) goto 20
	  iha = 2
	  call dix_eval_set_file(control,args(2),ptr_file)
	  if(ptr_file .eq. 0) goto 80
	  p_file_info = ptr_file
c
	  work(1:1) = 'D'
	  if(narg .ge. 1) then
	    if(args(1).type .ne. symb_typ_none) then
	      if(args(1).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	      argvals = 'DATA|SAVE|VFC'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
c
	  if(    work(1:1) .eq. 'D') then
	    descr(1) = file_info.data.nb_data
	    descr(2) = %loc(file_info.data.data_rec)
	  elseif(work(1:1) .eq. 'S') then
	    descr(1) = file_info.data.nb_sav
	    descr(2) = %loc(file_info.data.data_sav)
	  elseif(work(1:1) .eq. 'V') then
	    descr(1) = file_info.data.nb_vfc
	    descr(2) = %loc(file_info.data.vfc_data)
	  endif
	  result.type = symb_typ_char	  
	  call dix_eval_copy_char_dyn(descr,result.strdes)
	elseif(dix_util_match(funcnam,'%RECORDSIZE')) then
	  if(narg .gt. 2) goto 20
	  iha = 2
	  call dix_eval_set_file(control,args(2),ptr_file)
	  if(ptr_file .eq. 0) goto 80
	  p_file_info = ptr_file
c
	  work(1:1) = 'D'
	  if(narg .ge. 1) then
	    if(args(1).type .ne. symb_typ_none) then
	      if(args(1).type .ne. symb_typ_char) goto 30
	      call dix_eval_copy_char_fix(args(1).strdes,work,nk_work)
	      argvals = 'DATA|SAVE|VFC'
	      istat = dix_eval_check_arg(work(1:nk_work),argvals,err_arg)
	      if(.not. istat) goto 50
	    endif
	  endif
	  if(    work(1:1) .eq. 'D') then
	    result.ival = file_info.data.nb_data
	  elseif(work(1:1) .eq. 'S') then
	    result.ival = file_info.data.nb_sav
	  elseif(work(1:1) .eq. 'V') then
	    result.ival = file_info.data.nb_vfc
	  endif
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'%LOC') .or.
     1         dix_util_match(funcnam,'%BLOC')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30	
	  call dix_eval_upcase(args(1).strdes,work,nk_work)
	  if(.not. dix_des_find_field(control,work(1:nk_work),
     1             des_rec,set_dep,ptr)) then
	    istat = %loc(dix_msg_fldnotf)
	    err_arg = work(1:nk_work)
	    goto 50	  
	  endif
	  result.ival = des_rec.bit_offset
	  if(funcnam(2:2) .ne. 'B') result.ival = result.ival /8
	  result.type = symb_typ_int
	elseif(dix_util_match(funcnam,'F$ICHA|R')) then
	  if(narg .ne. 1) goto 20
	  if(args(1).type .ne. symb_typ_char) goto 30
	  if(zext(args(1).strdes.dsc$w_maxstrlen) .ne. 1) goto 40
	  istat = str$left(kar,args(1).strdes,1)
	  result.ival = ichar(kar)
	  result.type = symb_typ_int
	else
	  err_arg = funcnam
	  istat = %loc(dix_msg_invfunc)
	  goto 90
	endif
	goto 90
20	err_arg = funcnam
	istat = %loc(dix_msg_wrargcnt)
  	goto 90
30	err_arg = funcnam
	istat = %loc(dix_msg_wrargtyp)
	goto 90
40	err_arg = funcnam
	istat = %loc(dix_msg_wrargval)
	goto 90
c
50	k = dix_util_get_len_fu(err_arg)
	nk1 = dix_util_get_len_fu(argvals)
	err_arg(k+1:) = ' for '//funcnam//'(valid are '//argvals(1:nk1)//')'
	goto 90
c
80	call dix_eval_copy_char_fix(args(iha).strdes,err_arg,k)
	if(k .lt. len(err_arg)) err_arg(k+1:) = ' '
	istat = %loc(dix_msg_filnotf)
	goto 90
c
90	call dix_eval_free_char(symbval.strdes)
	dix_eval_func = istat
	return
	end
	subroutine dix_eval_set_file(control,arg,ptr_file)
	implicit none
c
c  Try to set a file pointer to an argument the
c   user has given.
c   the argument may be integer: the n'th file
c                    or char   : the tag of the file
c
	include 'dix_def.inc'
	record /control/ control	!:i: control block
	record /value/ arg	!:i: the argument
	integer*4 ptr_file   	!:o: the ptr or 0
c
	record /file_info/ file_info
	pointer (p_file_info,file_info)
c
	integer*4 k,nk_name
	character*(max_handle_name_length) name
c
c Assume current
c
	p_file_info = control.cur_file
c
	if(arg.type .ne. symb_typ_none) then
	  if(arg.type .eq. symb_typ_int) then
	    p_file_info = control.top_file
	    k = arg.ival
	    do while(p_file_info .ne. 0)
	      k = k - 1
	      if(k .eq. 0) goto 90
	      p_file_info = file_info.link.forw
	    end do
c
	  elseif(arg.type .eq. symb_typ_char) then
            call dix_eval_copy_char_fix(arg.strdes,name,nk_name)
            call str$upcase(name(1:nk_name),name(1:nk_name))
            p_file_info = control.top_file
            do while(p_file_info .ne. 0)
              if(file_info.handle .eq. name(1:nk_name)) goto 90
              p_file_info = file_info.link.forw
            enddo
c
c Not found
c
	  else
	    p_file_info = 0	!invalid type, so return 0
          endif
        endif                 !type <> none
c
90	ptr_file = p_file_info
	return
	end
	function dix_eval_check_arg(arg,allowed,err_arg)
	implicit none
c
	character*(*) arg
	character*(*) allowed
	character*(*) err_arg
	integer dix_eval_check_arg
c
	logical dix_util_check_field
c
	integer*4 k,istat,nk,nk1
c
	integer*4 dix_util_get_len
c
	call str$upcase(arg,arg)
	nk1 = dix_util_get_len(arg)
	nk = dix_util_get_len(allowed)
	istat = dix_util_check_field(arg(1:nk1),allowed(1:nk),k)
	if(istat) then
	  call str$element(arg,k,'|',allowed)
	else
	  err_arg = arg
	endif
	dix_Eval_check_arg = istat
	return
	end
	function dix_eval_trnlnm(lognam,table,idx,mode,option,
     1         what,result)
	implicit none
	include 'dix_def.inc'
	character*(*) lognam
	character*(*) table
	integer*4 idx
	character*(*) mode
	character*(*) option
	character*(*) what
	record /value/ result
	integer*4 dix_eval_trnlnm
c
	character*(max_line_length) work
	integer*4 nk_work
c
	structure /item/
	  integer*2 buflen
	  integer*2 opcode
	  integer*4 bufadr
	  integer*4 retadr
	end structure
	record /item/ items(4)
c
	logical got_attr
	integer*4 attr,nit,ival,istat
	byte accmode
c
	volatile ival,work,nk_work
c
	include '($psldef)'
	include '($lnmdef)'
c
	integer*4 sys$trnlnm
	external ss$_nolognam
c
	attr = lnm$m_case_blind
	if(index(option,',C') .ne. 0) attr = 0
	if(index(option,',I') .ne. 0) attr = attr .or. lnm$m_interlocked
	nit = 0
	got_attr = .false.
	nk_work = 0
	if(what(1:4) .eq. 'VALU' .or. what(1:4) .eq. 'LENG' .or. 
     1     what(1:6) .eq. 'TABLE_') then
c
c Values
c
	  if(idx .gt. 0) then
	    nit = nit + 1
	    items(nit).opcode= lnm$_index
	    items(nit).buflen = 4
	    items(nit).bufadr = %loc(idx)
	    items(nit).retadr = 0
	  endif
	  nit = nit + 1
	  if(what(1:4) .eq. 'VALU') then
	    items(nit).opcode= lnm$_string
	    items(nit).buflen = len(work)
	    items(nit).bufadr = %loc(work)
	    items(nit).retadr = %loc(nk_work)
	    result.type = symb_typ_char
	  elseif(what(1:6) .eq. 'TABLE_') then
	    items(nit).opcode= lnm$_table
	    items(nit).buflen = len(work)
	    items(nit).bufadr = %loc(work)
	    items(nit).retadr = %loc(nk_work)
	    result.type = symb_typ_char
	  else
	    items(nit).opcode= lnm$_length
	    items(nit).buflen = 4
	    items(nit).bufadr = %loc(result.ival)
	    items(nit).retadr = 0
	    result.type = symb_typ_int
	  endif
	elseif(what(1:4) .eq. 'MAX_') then
	  nit = nit + 1
	  items(nit).opcode= lnm$_max_index
	  items(nit).buflen = 4
	  items(nit).bufadr = %loc(ival)
	  items(nit).retadr = 0
	  result.type = symb_typ_int
	elseif(what(1:4) .eq. 'ACCE') then
	  nit = nit + 1
	  items(nit).opcode= lnm$_acmode
	  items(nit).buflen = 4
	  items(nit).bufadr = %loc(ival)
	  items(nit).retadr = 0
	else
	  got_attr = .true.
	  nit = nit + 1
	  items(nit).opcode= lnm$_attributes
	  items(nit).buflen = 4
	  items(nit).bufadr = %loc(ival)
	  items(nit).retadr = 0
	  result.type = symb_typ_int
	endif		 
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
c
	if(mode .eq. ' ') then
	  istat = sys$trnlnm(attr,table,lognam,,items)
	else
	  if(mode(1:1) .eq. 'U') accmode = psl$c_user
	  if(mode(1:1) .eq. 'S') accmode = psl$c_super
	  if(mode(1:1) .eq. 'E') accmode = psl$c_exec
	  if(mode(1:1) .eq. 'K') accmode = psl$c_kernel
	  istat = sys$trnlnm(attr,table,lognam,accmode,items)
	endif
	if(istat .eq. %loc(ss$_nolognam)) then
	  istat = 1
	  call dix_eval_free_char(result.strdes)
	  result.type = symb_typ_char
	  goto 90
	endif
	if(istat) then
	  if(what(1:4) .eq. 'ACCE') then
	    result.type = symb_typ_char
	    if(ival .eq. psl$c_user)   work = 'USER'
	    if(ival .eq. psl$c_super)  work = 'SUPERVISOR'
	    if(ival .eq. psl$c_exec)   work = 'EXECUTIVE'
	    if(ival .eq. psl$c_kernel) work = 'KERNEL'
	    nk_work = index(work,' ')-1
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  elseif(what(1:4) .eq. 'VALU') then
	    if(ichar(work(1:1)) .eq. 27 .and.
     1         ichar(work(2:2)) .eq. 0) then	!luns
	      work = work(5:nk_work)
	      nk_work = nk_work - 4
	    endif	   
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  elseif(what(1:6) .eq. 'TABLE_') then
	    call dix_eval_fill_char(result.strdes,work(1:nk_work))
	  elseif(got_attr) then
	    result.type = symb_typ_log
	    if(    what(1:4) .eq. 'CONF') then
	      result.lval = (ival .and. lnm$m_confine)   .ne. 0
	    elseif(what(1:4) .eq. 'CONC') then
	      result.lval = (ival .and. lnm$m_concealed) .ne. 0
	    elseif(what(1:4) .eq. 'EXIS') then
	      result.lval = (ival .and. lnm$m_exists)    .ne. 0
	    elseif(what(1:4) .eq. 'CREL') then
	      result.lval = (ival .and. lnm$m_crelog)    .ne. 0
	    elseif(what(1:4) .eq. 'NO_A') then
	      result.lval = (ival .and. lnm$m_no_alias)  .ne. 0
	    elseif(what(1:6) .eq. 'TABLE ') then
	      result.lval = (ival .and. lnm$m_table)      .ne. 0
	    elseif(what(1:4) .eq. 'CLUS') then
	      result.lval = (ival .and. lnm$m_clusterwide).ne. 0
	    elseif(what(1:4) .eq. 'TERM') then
	      result.lval = (ival .and. lnm$m_terminal)   .ne. 0
	    endif
	  endif
	endif
90	dix_eval_trnlnm = istat
	return
	end
	function dix_eval_getdvi(devnam,what,result)
	implicit none
c
	include 'dix_def.inc'
c
	character*(*) devnam
	character*(*) what
	record /value/ result
	integer*4 dix_eval_getdvi
c
	structure /item/
	  integer*2 buflen
	  integer*2 opcode
	  integer*4 bufadr
	  integer*4 retadr
	end structure
	record /item/ items(4)
c
        include '($dvidef)'
c
	character*(max_filename_length) work
	logical*4 opened
	integer*4 istat,lun,nk_work
	integer*4 sys$getdviw
	integer*4 lib$getdvi
c
	volatile result,nk_work,work
c
	structure /homeblock/
	  union
	    map
	      byte data(512)
	    end map
	    map
              integer*4 homelbn
              integer*4 alt_homelbn
              integer*4 alt_idxlbn
              byte struclev(2)
              integer*2 cluster
              integer*2 homevbn
              integer*2 althomevbn
              integer*2 altidxvbn
              integer*2 ibmapvbn
              integer*4 ibmaplbn
              integer*4 maxfiles
	      integer*2 ibmapsize
	    end map
	  end union
	end structure
	record /homeblock/ homeblock
c
c
	if(what(1:4) .eq. 'MAXF') then
	  items(1).buflen = 4
	  items(1).opcode = dvi$_maxfiles
	  items(1).bufadr = %loc(result.ival)
	  result.type = symb_typ_int
	elseif(what(1:4) .eq. 'MAXB') then
	  items(1).buflen = 4
	  items(1).opcode = dvi$_maxblock
	  items(1).bufadr = %loc(result.ival)
	  result.type = symb_typ_int
	elseif(what(1:4) .eq. 'VOLN') then
	  items(1).buflen = len(work)
	  items(1).opcode = dvi$_volnam
	  items(1).bufadr = %loc(work)
	  items(1).retadr = %loc(nk_work)
	  result.type = symb_typ_char
	elseif(what(1:4) .eq. 'EXIS') then
	  items(1).buflen = 4
	  items(1).opcode = dvi$_devchar
	  items(1).bufadr = %loc(result.lval)
	  result.type = symb_typ_log
	elseif(what(1:4) .eq. 'BLNR') then
	  call lib$get_lun(lun)
	  nk_work = 0
	  opened = .false.
	  istat = lib$getdvi(dvi$_devnam,,devnam,,work,nk_work)
	  if(istat) then
	    call dix_append(nk_work,work,'[000000]indexf.sys;1')
	    open(lun,file=work(1:nk_work),
     1         access='direct',
     1         form='unformatted',
     1         status='old',
     1         shared,readonly,
     1         err=12)
	    opened = .true.
	    read(lun,rec=2,err=12) homeblock
	    result.ival = zext(homeblock.ibmapvbn)+zext(homeblock.ibmapsize)-1
	    result.type = symb_typ_int
	    istat = 1
	    goto 14
12	    call errsns(,istat)
14	    if(opened) close(lun)
	  endif
	  call lib$free_lun(lun)
	  goto 90
	endif
c
	istat = sys$getdviw(,,devnam,items,,,,)
	goto 90
c
c
90	if(what(1:4) .eq. 'EXIS') then
	  result.ival = istat
	  istat = 1
	endif
	if(result.type .eq. symb_typ_char) then
	  call dix_eval_fill_char(result.strdes,work(1:nk_work))
	endif
	dix_eval_getdvi = istat
	return
	end	  
	subroutine dix_eval_envi(control,what,result)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) what
	record /value/ result
c
	include '($stsdef)'
c
	character*(max_filename_length) line
	integer*4 nk
c
	if(what(1:1) .eq. 'D') then
	  result.type = symb_typ_int
	  result.ival = control.depth
	elseif(what(1:1) .eq. 'M') then
	  result.type = symb_typ_char
	  call dix_inter_conv_msg(control.msgmask,line,nk)	
	elseif(what(1:4) .eq. 'ON_S') then
	  result.type = symb_typ_char
	  call dix_inter_get_file_level_info(control,'OS',nk,line)
	elseif(what(1:4) .eq. 'ON_A') then
	  result.type = symb_typ_char
	  call dix_inter_get_file_level_info(control,'OA',nk,line)
	elseif(what(1:4) .eq. 'PROC') then
	  result.type = symb_typ_char
	  call dix_inter_get_file_level_info(control,'PR',nk,line)
	elseif(what(1:4) .eq. 'PROM') then
	  result.type = symb_typ_char
	  nk = control.nk_prompt
	  line = control.prompt
	elseif(what(1:1) .eq. 'I') then
	  result.type = symb_typ_log
	  result.lval = control.is_term
	endif
	if(result.type .eq. symb_typ_char) then
	  call dix_eval_copy_char_dyn(line(1:nk),result.strdes)
	endif
	return
	end	
