	function keydefs_init(control,case_sensitive,debug)
	implicit none
c
c Initialize key structure
c
	include 'dix_def.inc'
	include 'dix_keydefs.inc'
c
	record /control/ control
	logical case_sensitive		!:i: is table case_sensitive
	logical debug			!:i: print debug messages
	logical keydefs_init		!:f: the result
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)
c
	integer*4 istat
c
c Get some memory
c
	call get_vm(sizeof(keytable),p_keytable,control.zone_general)
	control.key_table = p_keytable
c
c Setup default mappings, this alse defines all dix_function keys
c
	keytable.case_sensitive = case_sensitive
	call keydefs_default(control,keytable,debug)
	keytable.cur_state = ' '
	istat = 1
	keydefs_init = istat
	return
	end
	options /exte
	subroutine keydefs_default(control,keytable,debug)
	implicit none
c
c Setup default mapping, and also define all dix_function keys
c
	include 'dix_keydefs.inc'
	include 'dix_def.inc'
	record /keytable/ keytable	!:io: the keytable
	integer*4 control
	logical debug
c
	include '($smgdef)'
c
c init nkey
c
	keytable.n_functions = 0
c
c First define all keys
c
	call keydefs_def(keytable,'key_up'        ,key_up,debug)
	call keydefs_def(keytable,'key_down'      ,key_down,debug)
	call keydefs_def(keytable,'key_left'      ,key_left,debug)
	call keydefs_def(keytable,'key_right'     ,key_right,debug)
	call keydefs_def(keytable,'key_prev'      ,key_prev,debug)
	call keydefs_def(keytable,'key_next'      ,key_next,debug)
	call keydefs_def(keytable,'key_top'       ,key_top,debug)
	call keydefs_def(keytable,'key_bot'       ,key_bot,debug)
	call keydefs_def(keytable,'key_find'      ,key_find,debug)
	call keydefs_def(keytable,'key_find1'     ,key_find1,debug)
	call keydefs_def(keytable,'key_binasc'    ,key_binasc,debug)
	call keydefs_def(keytable,'key_contdis'   ,key_contdis,debug)
	call keydefs_def(keytable,'key_save'      ,key_save,debug)
	call keydefs_def(keytable,'key_select'    ,key_select,debug)
c
	call keydefs_def(keytable,'key_do'        ,key_do,debug)
c	call keydefs_def(keytable,'key_show_field',key_show_field,debug)
	call keydefs_def(keytable,'key_help'      ,key_help,debug)
c
c line editting functions
c
	call keydefs_def(keytable,'key_toggle'    ,key_toggle,debug)
	call keydefs_def(keytable,'key_last'      ,key_last,debug)
	call keydefs_def(keytable,'key_first'     ,key_first,debug)
	call keydefs_def(keytable,'key_enter'     ,key_enter,debug)
	call keydefs_def(keytable,'key_erase'     ,key_erase,debug)
	call keydefs_def(keytable,'key_next_line' ,key_next_line,debug)
	call keydefs_def(keytable,'key_delete_line',key_delete_line,debug)
	call keydefs_def(keytable,'key_undelete_line',key_undelete_line,debug)
	call keydefs_def(keytable,'key_delete_word',key_delete_word,debug)
	call keydefs_def(keytable,'key_undelete_word',key_undelete_word,debug)

	call keydefs_def(keytable,'key_cancel'    ,key_cancel,debug)
	call keydefs_def(keytable,'key_set_forw'  ,key_set_forw,debug)
	call keydefs_def(keytable,'key_bot'       ,key_bot,debug)
	call keydefs_def(keytable,'key_set_backw' ,key_set_backw,debug)
	call keydefs_def(keytable,'key_dispall'   ,key_dispall,debug)
	call keydefs_def(keytable,'key_erase'     ,key_erase,debug)
	call keydefs_def(keytable,'key_remove'    ,key_remove,debug)
	call keydefs_def(keytable,'key_editdes'   ,key_editdes,debug)
	call keydefs_def(keytable,'key_fileinfo'  ,key_fileinfo,debug)
c
	call keydefs_def(keytable,'key_repaint'   ,key_repaint,debug)
	call keydefs_def(keytable,'key_getfields' ,key_getfields,debug)
	call keydefs_def(keytable,'key_print'     ,key_print,debug)
	call keydefs_def(keytable,'key_viewvfc'   ,key_viewvfc,debug)
	call keydefs_def(keytable,'key_page'      ,key_page,debug)
	call keydefs_def(keytable,'key_swap_num'  ,key_swap_num,debug)
	call keydefs_def(keytable,'key_byte'      ,key_byte,debug)
	call keydefs_def(keytable,'key_word'      ,key_word,debug)
	call keydefs_def(keytable,'key_long'      ,key_long,debug)
	call keydefs_def(keytable,'key_compres'   ,key_compres,debug)
	call keydefs_def(keytable,'key_hexdec'    ,key_hexdec,debug)
	call keydefs_def(keytable,'key_newreclen' ,key_newreclen,debug)
	call keydefs_def(keytable,'key_viewdes'   ,key_viewdes,debug)
	call keydefs_def(keytable,'key_repaint'   ,key_repaint,debug)
	call keydefs_def(keytable,'key_viewdesc'  ,key_viewdesc,debug)
c
	call keydefs_def(keytable,'key_swap_dis'  ,key_swap_dis,debug)
	call keydefs_def(keytable,'key_abort'     ,key_abort,debug)
	call keydefs_def(keytable,'key_delete'    ,key_delete,debug)
	call keydefs_def(keytable,'key_nextdes'   ,key_nextdes,debug)
	call keydefs_def(keytable,'key_prevdes'   ,key_prevdes,debug)
	call keydefs_def(keytable,'key_dirdes'    ,key_dirdes,debug)
	call keydefs_def(keytable,'key_restore'   ,key_restore,debug)
	call keydefs_def(keytable,'key_ask_key'   ,key_ask_key,debug)
	call keydefs_def(keytable,'key_next_rec'  ,key_next_rec,debug)
	call keydefs_def(keytable,'key_prev_rec'  ,key_prev_rec,debug)
	call keydefs_def(keytable,'key_put'       ,key_put,debug)
	call keydefs_def(keytable,'key_find_rec'  ,key_find_rec,debug)
	call keydefs_def(keytable,'key_find_rec1' ,key_find_rec1,debug)
	call keydefs_def(keytable,'key_next_file' ,key_next_file,debug)
	call keydefs_def(keytable,'key_prev_file' ,key_prev_file,debug)
	call keydefs_def(keytable,'key_dir_file'  ,key_dir_file,debug)
	call keydefs_def(keytable,'key_exit'      ,key_exit,debug)
	call keydefs_def(keytable,'key_modechange',key_modechange,debug)
	call keydefs_def(keytable,'key_follow_link',key_follow_link,debug)
	call keydefs_def(keytable,'key_back_link' ,key_back_link,debug)
	call keydefs_def(keytable,'key_ch_width',  key_ch_width,debug)
c
c And define all keys+mapping
c
	keytable.n_keys = 0
c
c Map two gold keys 
c
	call keydefs_map(smg$k_trm_pf1,        ' ',0,keytable,'gold',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_pf4        ,' ',0,keytable,'blue',
     1                  debug,control,' ')
c
	call keydefs_map(smg$k_trm_up,         ' ',key_up,   keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_down,       ' ',key_down, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_left,       ' ',key_left, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_right,      ' ',key_right,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_prev_screen,' ',key_prev, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_up,         'GOLD', key_prev,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_next_screen,' ',key_next, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_down,       'GOLD', key_next, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_prev_screen,'GOLD', key_top, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_next_screen,'GOLD', key_bot, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp8        ,' ', key_page,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_pf3        ,' ',key_find, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_pf3        ,'GOLD',key_find1, keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ht         ,' ',key_binasc,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f8         ,' ',key_contdis,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f9         ,' ',key_save,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_do         ,' ',key_do   ,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_help       ,' ',key_help,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp0       ,' ',key_next_line,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_minus     ,' ',key_delete_line,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_minus     ,'GOLD',key_undelete_line,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_comma     ,' ',key_delete_word,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_comma     ,'GOLD',key_undelete_word,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_pf2        ,' ',key_help,keytable,' ',
     1                  debug,control,' ')
c
c line editting functions
c
	call keydefs_map(smg$k_trm_ctrla      ,' ',key_toggle,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f14        ,' ',key_toggle,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f14        ,'GOLD',key_modechange,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrle      ,' ',key_last,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlh      ,' ',key_first,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f12        ,' ',key_first,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_cr         ,' ',key_enter,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_enter      ,' ',key_enter,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlx      ,' ',key_erase,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f13        ,' ',key_erase,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_lf         ,' ',key_erase,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlc      ,' ',key_cancel,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp4        ,' ',key_set_forw,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp4  ,'GOLD',key_set_forw,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp5   ,' ',key_set_backw,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp5   ,'GOLD',key_set_backw,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_select     ,' ',key_select,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_period     ,' ',key_select,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_s,'GOLD',key_dispall,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_delete     ,' ',key_delete,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_e,'GOLD',key_editdes,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_f,'GOLD',key_fileinfo,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_z,'GOLD',key_follow_link,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_z,'BLUE',key_back_link,keytable,' ',
     1                  debug,control,' ')
c
	call keydefs_map(smg$k_trm_ctrlr      ,' ',key_repaint,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlw      ,' ',key_repaint,keytable,' ',
     1                  debug,control,' ')
	
	call keydefs_map(smg$k_trm_uppercase_g,'GOLD', key_getfields,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_p,'GOLD',key_print,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_y,'GOLD', key_viewvfc,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_o,'GOLD', key_swap_num,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f20        ,' ',key_swap_num,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_b,'GOLD', key_byte,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_w,'GOLD', key_word,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_w,'BLUE', key_ch_width,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_l,'GOLD', key_long,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_c,'GOLD', key_compres,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_h,'GOLD', key_hexdec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_t,'GOLD', key_newreclen,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_v,'GOLD', key_viewdes,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_v,'BLUE', key_viewdesc,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlw,      'GOLD', key_repaint,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlr,      'GOLD', key_repaint,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_a,'GOLD', key_swap_dis,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f19        ,' ',key_swap_dis,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_do         ,'GOLD' ,key_abort,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_remove     ,' ',key_remove,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp6        ,' ',key_remove,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_r,'GOLD', key_remove,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_x,'GOLD', key_nextdes,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_x,'BLUE', key_prevdes,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_d,'GOLD', key_dirdes,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f9         ,'GOLD', key_restore,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f17        ,' ',key_ask_key,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_k,'GOLD',key_ask_key,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f18        ,' ',key_next_rec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f18        ,'GOLD',key_prev_rec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_n,'GOLD',key_next_rec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_n,'BLUE',key_prev_rec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_insert_here,' ',key_put,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_kp6        ,'GOLD',key_put,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_i,'GOLD', key_put,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_find       ,' ',key_find_rec,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_find       ,'GOLD', key_find_rec1,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_j,'GOLD', key_next_file,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_j,'BLUE', key_prev_file,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_uppercase_q,'GOLD', key_dir_file,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_f10        ,' ',key_exit,keytable,' ',
     1                  debug,control,' ')
	call keydefs_map(smg$k_trm_ctrlz      ,' ',key_exit,keytable,' ',
     1                  debug,control,' ')
c
	return
	end
c
	subroutine keydefs_def(keytable,function_name,function,debug)
	implicit none
	include 'dix_keydefs.inc'
c
	record /keytable/ keytable	!:io: the keytable
	character*(*) function_name 	!:i: the name of the dix_function
	integer*4 function		!:i: the funcion number
	logical debug			!:i: debug wanted
c
	integer*4 idx
	integer*4 dix_util_get_len
c
	if(keytable.n_functions .lt. keydefs_max_functions) then
	  keytable.n_functions = keytable.n_functions + 1
	  idx = keytable.n_functions 
	  if(keytable.case_sensitive) then
	    keytable.functions(idx).function_name = function_name
	  else
	    call str$upcase(keytable.functions(idx).function_name,
     1                function_name)
	  endif
	  keytable.functions(idx).nk_name  = dix_util_get_len(function_name)
	  keytable.functions(idx).function = function
	  if(debug) then
	    write(*,*) 'DBG:Defined function '//
     1        keytable.functions(idx).function_name//
     1        ' with value ',function
	  endif
        else
	  write(*,*) 'Error, too many functions '
	  stop
	endif
	return
	end
	function keydefs_map(smgkey,if_state,function,keytable,
     1                       set_state,debug,control,context)
	implicit none
c
c Map a (gold,debug)-smgkey to a dix_function
c if function = 0, this is a state-key, state_key will be the name of the state
c
	include 'dix_def.inc'
	include 'dix_keydefs.inc'
c
	integer*4 smgkey           	!:i: smg terminator
	character*(*) if_state 		!:i: gold state
	integer*4 function		!:o: function result
	record /keytable/ keytable	!:i: the keytable
	character*(*) set_state		!:i: gold state
	logical debug			!:i: debug wanted
	integer*4 control
	character*(*) context		!:i: context (screen)
	logical keydefs_map		!:f: function result
c
	integer*4 smgkeyok,nk,idx,imap
	integer*4 keydefs_chmap
	character*(max_short_line_length) idxasc
	character*(max_symbol_name_length) smgname
	character*(max_line_length) line
c
	integer*4 dix_util_get_len
	integer*4 keydefs_keycode_to_name
	external dix_msg_statdash
	external dix_msg_statempt
	external dix_msg_statfunc
	external dix_msg_smgerrnu
	external dix_msg_funcnotf
	external dix_msg_toomank
c
c Make sure all uppercase, so lowercase_u = uppercase_u
c
	smgkeyok = keydefs_chmap(smgkey,keytable)
c
	keydefs_map = .false.
c
c If state-Key (dix_function=0) specified, see if not mapped to state key
c
	if(.not. keydefs_keycode_to_name(smgkeyok,smgname)) then
	  call dix_message(control,dix_msg_smgerrnu,%val(smgkey))
	  goto 90
	endif
c
	if(index(if_state,'-') .ne. 0) then
	  call dix_message(control,dix_msg_statdash,if_state)
	  goto 90
	endif
	if(index(set_state,'-') .ne. 0) then
	  call dix_message(control,dix_msg_statdash,set_state)
	  goto 90
	endif
	if(function .eq. 0 .and. set_state .eq. ' ') then
	  call dix_message(control,dix_msg_statempt,smgname)
	  goto 90
	endif
	if(function .ne. 0 .and. set_state .ne. ' ') then
	  call dix_message(control,dix_msg_statfunc,smgname)
	  goto 90
	endif
c
c Try to locate the function, not for statedefs
c
	if(function .ne. 0) then
	  do imap=1,keytable.n_functions
	    if(keytable.functions(imap).function .eq. function) goto 20
	  end do
	  call dix_message(control,dix_msg_funcnotf,smgname)
	  goto 90
	else
	  imap = 0
	endif
c
c Try to find this key for anything else, if so override
c
20	do idx=1,keytable.n_keys
	  if(keytable.keys(idx).key .eq. smgkey .and. 
     1       keytable.keys(idx).if_state .eq. if_state) then
	    goto 30		!redefinition
	  endif
	end do
c
c Not found, so add to table
c
	if(keytable.n_keys .eq. keydefs_max_keys) then
	  call dix_message(control,dix_msg_toomank)
	  goto 90
	endif
c
	keytable.n_keys = keytable.n_keys + 1
	idx = keytable.n_keys	   
c
c Add (or redefine key)
c
30	keytable.keys(idx).key          = smgkeyok
	if(keytable.case_sensitive) then
	  keytable.keys(idx).if_state   = if_state
	else
	  call str$upcase(keytable.keys(idx).if_state,if_state)
	endif
	keytable.keys(idx).nk_if        = dix_util_get_len(if_state)
	if(keytable.case_sensitive) then
	  keytable.keys(idx).set_state  = set_state
	else
	  call str$upcase(keytable.keys(idx).set_state,set_state)
	endif
	keytable.keys(idx).nk_set       = dix_util_get_len(set_state)
	keytable.keys(idx).keyname      = smgname
	keytable.keys(idx).nk_name      = dix_util_get_len(smgname)
	keytable.keys(idx).function_idx = imap
	keytable.keys(idx).context      = context
	keytable.keys(idx).nk_context   = dix_util_get_len(context)
c
c If debug, tell user what we did
c
	if(debug) then
	  call keydefs_to_text(keytable,idx,line,nk)
	  write(idxasc,'(i3)') idx
	  if(function .eq. 0) then
	    write(*,*) 'DBG:Mapped at idx '//idxasc(1:3)//' '//
     1       line(1:nk)//' to state '//keytable.keys(idx).set_state//
     1       ' ctx '//keytable.keys(idx).context
	  else
	    write(*,*) 'DBG:Mapped at idx '//idxasc(1:3)//' '//
     1       line(1:nk)//' to function '//
     1       keytable.functions(imap).function_name//
     1       ' ctx '//keytable.keys(idx).context
	  endif
	endif	  
	keydefs_map = .true.
90	return
	end
	function keydefs_chmap(smgkey,keytable)
	implicit none
c
	include 'dix_keydefs.inc'
	integer*4 smgkey
	record /keytable/ keytable
	integer*4 keydefs_chmap
c
c Make sure all lowerkeys are mapped to upperkeys
c
	include '($smgdef)'
c
	if(keytable.case_sensitive) then
	  keydefs_chmap = smgkey
	else
	  if(smgkey .ge. smg$k_trm_lowercase_a .and. 
     1       smgkey .le. smg$k_trm_lowercase_z) then
	    keydefs_chmap = smgkey-smg$k_trm_lowercase_a+smg$k_trm_uppercase_a
	  else
	    keydefs_chmap = smgkey
	  endif
	endif
	return
	end
	function keydefs_function_name_to_code(name,function,key_ptr)
	implicit none
c 
c Translate the dix_function name to a number
c
	include 'dix_keydefs.inc'
	character*(*) name
	integer*4 function
	integer*4 key_ptr
	integer*4 keydefs_function_name_to_code
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)	
c
	integer*4 k
c
	p_keytable = key_ptr
	keydefs_function_name_to_code = .false.
	do k=1,keytable.n_functions
	  if(keytable.functions(k).function_name .eq. name) then
	    keydefs_function_name_to_code = .true.
	    function = keytable.functions(k).function
	    goto 90
	  endif
	end do
90	return
	end	
	function keydefs_function_number_to_name(function,key_ptr,nk_name,name)
	implicit none
c
c Convert the function code to a name
c
	include 'dix_keydefs.inc'
	integer*4 function
	integer*4 key_ptr
	integer*4 nk_name
	character*(*) name
	integer*4 keydefs_function_number_to_name
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)	
c
	integer*4 k
c
	p_keytable = key_ptr
c
	keydefs_function_number_to_name = .false.
	do k=1,keytable.n_functions
	  if(keytable.functions(k).function .eq. function) then
	    keydefs_function_number_to_name = .true.
	    name    = keytable.functions(k).function_name
	    nk_name = keytable.functions(k).nk_name
	    goto 90
	  endif
	end do
	name = ' '
	nk_name = 0
90	return
	end	
	function keydefs_get_map(function,key_ptr,nk_keys,keynames)
	implicit none
c
c Deliver a< comma-separated list of keys mapped to the function
c
	include 'dix_def.inc'
	include 'dix_keydefs.inc'
	integer*4 function
	integer*4 key_ptr
	integer*4 nk_keys
	character*(*) keynames
	integer*4 keydefs_get_map
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)	
c
	integer*4 k,nk,idx
	character*(max_line_length) line
c
	p_keytable = key_ptr
c
	nk_keys  = 0
	keynames = ' '
	keydefs_get_map = .false.
c
c first get the index of the function
c
	do idx=1,keytable.n_functions
	  if(keytable.functions(idx).function .eq. function) goto 10
	end do
	goto 90
c
10	do k=1,keytable.n_keys
	  if(keytable.keys(k).function_idx .eq. idx) then
	    keydefs_get_map = .true.
	    call keydefs_to_text(keytable,k,line,nk)
	    call dix_append(nk_keys,keynames,line(1:nk))
	    call dix_append(nk_keys,keynames,',')
	  end if
	end do
	if(nk_keys .gt. 0) then
	  keynames(nk_keys:nk_keys) = ' '
	  nk_keys = nk_keys - 1
	end if
90	return
	end
	function keydefs_get_key(key_table,keyb_id,function,debug)
	implicit none
c
c This function reads keys via smg-keyboard
c and maps them the DIX-Functions. State-keys are handled in this function
c
	include 'dix_keydefs.inc'
	include '($smgdef)'
c
	integer*4 key_table     	!:i: Key table address
	integer*4 keyb_id		!:i: smg-keyboard id
	integer*4 function	        !:o: wanted key, return smgkey if not found
					!    0 is illegal state-construct
	logical*4 debug
	logical*4 keydefs_get_key	!:f: function result of smg$read_keystroke
c
	integer*4 istat,k,l,smgkey,newsmgkey
	integer*4 smg$read_keystroke
	integer*4 keydefs_chmap
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)
c
	if(key_table .ne. 0) then
	  p_keytable = key_table		!set pointer
	  keytable.cur_state = ' '
	endif
c
10	call smg$set_keypad_mode(keyb_id,smg$m_keypad_application)
	istat = smg$read_keystroke(keyb_id,smgkey)
	call smg$set_keypad_mode(keyb_id,0)
	if(key_table .eq. 0) then
	  function = smgkey
	  goto 90
	endif
	if(istat) then
c
	  newsmgkey = keydefs_chmap(smgkey,keytable)
	  do k=1,keytable.n_keys
	    if(keytable.keys(k).key .eq. newsmgkey .and.
     1        (keytable.keys(k).if_state .eq. keytable.cur_state .or.
     1         (keytable.cur_state .ne. ' ' .and. 
     1         keytable.keys(k).set_state.eq. keytable.cur_state)))then
	      if(debug) then
	        write(*,*) 'DBG:Found  '//keytable.keys(k).keyname
	        write(*,*) '    state  '//keytable.keys(k).set_state
	        write(*,*) '    mapped to ',keytable.keys(k).function_idx
	      endif
c
c Got a match, now check if this key is a state-key
c
	      if(keytable.keys(k).set_state .ne. ' ') then
c
c This is a state-key, now set istate and read next char
c
	        keytable.cur_state = keytable.keys(k).set_state
	        goto 10
	      endif
	      l        = keytable.keys(k).function_idx
	      function = keytable.functions(l).function
	      if(debug) write(*,*) 'DBG : Result key '//
     1           keytable.functions(l).function_name
	      goto 90
	    endif       !got key
	  end do        !do k=1,n_key
	endif		!smg$read_keystroke
	if(keytable.cur_state .eq. ' ') then
c
c return the key
c
	  function = smgkey
	else
c
c return a 0, could not find set_key
c
	  function = 0
	endif
90	keydefs_get_key = istat
	return
	end	
	function keydefs_add_key(control,smgname,if_state,set_state,
     1                             funcname,debug)
	implicit none
c
c Define a key
c if function = "" then a state key, (state "state" will be defined)
c if function <>"" then define a key to a function (possible "stat"ed)
c
	include 'dix_keydefs.inc'
	include 'dix_def.inc'
	record /control/ control
	character*(*) smgname
	character*(*) if_state
	character*(*) set_state
	character*(*) funcname
	logical debug
	logical keydefs_add_key
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)
c
	integer*4 smgkey,function,nk
c
	integer*4 keydefs_keyname_to_code
	integer*4 keydefs_function_name_to_code
	external dix_msg_smgerrna
	external dix_msg_funcerr
c
c Define a key /state=state dix_function
c
	p_keytable = control.key_table
	keydefs_add_key = .false.
 	if(.not. keydefs_keyname_to_code(smgname,smgkey)) then
	  nk = index(smgname,' ')-1
	  call dix_message(control,dix_msg_smgerrna,smgname(1:nk))
	else
	  if(funcname .ne. ' ' .and. .not. 
     1            keydefs_function_name_to_code(funcname,
     1             function,control.key_table)) then
	    nk = index(funcname,' ')-1
	    call dix_message(control,dix_msg_funcerr,funcname(1:nk))
	  else
	    call keydefs_map(smgkey,if_state,function,keytable,
     1              set_state,debug,control)
	    keydefs_add_key = .true.
	  endif
	endif
	return
	end
	function keydefs_del_key(control,smgname,if_state,debug)
	implicit none
c
c Delete a key
c if smgname = empty, delete all keys
c
	include 'dix_keydefs.inc'
	include 'dix_def.inc'
	record /control/ control
	character*(*) smgname
	character*(*) if_state
	logical debug
	logical keydefs_del_key
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)
c
	integer*4 k,l
	external dix_msg_keyfnotf
c
c Deletion of key/function/all
c
	p_keytable = control.key_table
c
	if(smgname .eq. ' ') then
	  keytable.n_keys = 0
	else	  
	  do k=1,keytable.n_keys
	    if(keytable.keys(k).keyname .eq. smgname .and.
     1         keytable.keys(k).if_state .eq. if_state) goto 20
	  end do
	  call dix_message(control,dix_msg_keyfnotf,smgname,if_state)
	  goto 90
20	  if(debug) then
	    write(*,*) 'DBG: Deleted key '//keytable.keys(k).keyname
	  endif	
	  do l=k+1,keytable.n_keys
	    keytable.keys(l-1) = keytable.keys(l)
	  end do
	  keytable.n_keys = keytable.n_keys - 1
	endif
90	keydefs_del_key = .true.
	return
	end
	function keydefs_keycode_to_name(smgkey,smgname)
	implicit none
	include '($smgdef)'
c
	integer*4 smgkey
	character*(*) smgname
	logical*4 keydefs_keycode_to_name
c
	logical*4 smg$keycode_to_name
	integer*4 istat
c
	istat = 1
	if(smgkey .eq. smg$k_trm_delete) then
	  smgname = 'DELETE'
	  goto 90
	endif
	istat = smg$keycode_to_name(smgkey,smgname) 
	if(istat) then
c
c make some keys more readable
c
	  if(smgname .eq. 'E1') then
	    smgname = 'Find'
	  elseif(smgname .eq. 'E2') then
	    smgname = 'Insert_Here'
	  elseif(smgname .eq. 'E3') then
	    smgname = 'Remove'
	  elseif(smgname .eq. 'E4') then
	    smgname = 'Select'
	  elseif(smgname .eq. 'E5') then
	    smgname = 'Prev_Screen'
	  elseif(smgname .eq. 'E6') then
	    smgname = 'Next_Screen'
	  elseif(smgname .eq. 'CTRLM') then
	    smgname = 'Return'
	  endif
	endif
90	keydefs_keycode_to_name = istat
	return
	end
	function keydefs_keyname_to_code(smgname,smgkey)
	implicit none
	include 'dix_keydefs.inc'
	include '($smgdef)'
	character*(*) smgname
	integer*4 smgkey
	logical*4 keydefs_keyname_to_code
c
	integer*4 istat,nk
	logical*4 smg$name_to_keycode
	integer*4 dix_util_get_len
c
	character*(keydefs_name_size) name
c
	call str$upcase(name,smgname )
	if(name(1:10) .eq. 'UPPERCASE_') then
	  name = name(11:11)
	elseif(name(1:10) .eq. 'LOWERCASE_') then
	  name = char(ichar(name(11:11)) - ichar('A') + ichar('a')) 
	elseif(name .eq. 'RETURN') then
	  name = 'CTRLM'
	elseif(name .eq. 'LF') then
	  name = 'CTRLJ'
	elseif(name .eq. 'HT') then
	  name = 'CTRLH'
	elseif(name .eq. 'CR') then
	  name = 'CTRLM'
	elseif(name .eq. 'LF') then
	  name = 'CTRLJ'
	elseif(name .eq. 'DELETE') then
	  smgkey = smg$k_trm_delete
	  istat = 1
	  goto 90
	endif
	nk = dix_util_get_len(name)
	istat = smg$name_to_keycode(name(1:nk),smgkey) 
90	keydefs_keyname_to_code = istat
	return
	end
	subroutine keydefs_to_text(keytable,idx,line,nk)
	implicit none
c
c Translate the key on idx to text
c if if_state is set, prefix the key by its set_state key
c Beware , there may be more than one key containing the set-state
c
	include 'dix_keydefs.inc'
c
	record /keytable/ keytable
	integer*4 idx	
	character*(*) line
	integer*4 nk
c
	integer*4 l,nk_s,nk_k
c
	nk     = 0
	nk_k   = keytable.keys(idx).nk_name
	if(keytable.keys(idx).if_state .ne. ' ') then
c
c Go through all keys with a set_state= thiskeys if_state
c
	  do l=1,keytable.n_keys
	    if(keytable.keys(l).set_state .eq. 
     1         keytable.keys(idx).if_state) then
	      nk_s  = keytable.keys(l).nk_name
	      line(nk+1:) = 
     1               keytable.keys(l).keyname(1:nk_s)//'-'//
     1               keytable.keys(idx).keyname(1:nk_k)//','
	      nk = nk + nk_s +1 + nk_k + 1
	    endif
	  end do
c
c Do not understand?
c
	  if(nk .eq. 0) then
	    nk_s = keytable.keys(idx).nk_if
	    line = '?'//keytable.keys(idx).if_state(1:nk_s)//'-'//
     1                  keytable.keys(idx).keyname(1:nk_k)
	    nk = 1 + nk_s + nk_k + 2
	  else
	    nk = nk - 1
	  endif
	else
c
c No if state, jyst contain the keyname
c
	  line = keytable.keys(idx).keyname(1:nk_k)
	  nk   = nk_k
	end if
	return
	end
	subroutine keydefs_dump(key_ptr,fnam)
	implicit none
	integer*4 key_ptr
	character*(*) fnam
	include 'dix_def.inc'
	include 'dix_keydefs.inc'
c
	record /keytable/ keytable
	pointer (p_keytable,keytable)
c
	character*(max_line_length) line
	integer*4 nk,k,function,lun
c
	p_keytable = key_ptr
c
	call lib$get_lun(lun)
	open(lun,file=fnam,status='new',carriagecontrol='list',err=80)
c
	do k=1,keytable.n_functions
	  function = keytable.functions(k).function
	  call keydefs_get_map(function,key_ptr,nk,line)
	  write(lun,1000) keytable.functions(k).function_name(1:20),line(1:nk)
1000	  format(a,'>',a)
	end do
	close(lun)
	goto 90
80	write(*,*) 'Could not open file ',fnam
90	call lib$free_lun(lun)
	return
	end
