
  	program dix
	implicit none
c
c Dump indexed files.
C Version  Author date        comment
C  1.0     F.S.   19-jan-1991 Initial release
C  1.1     F.S.    1-mar-1991 Support for sequential files
c  2.0     F.S.    1-jan-1992 Use of smg routines
C  2.1     F.S.   26-feb-1992 Support block io
C  2.2     F.S.   27-feb-1992 Support fieldnames for bits values
C  2.3     F.S.   18-mar-1992 Support for multiple files
c  3.0     F.S.    1-jul-1998 Multiple changes
c                              support for parameters
c                              support for run-time evaluation of expressions
C  3.1     F.S.   10-mar-2003 Support for scripting in interactive mode
c  3.2     F.S.   16-Jun-2003 Added user defined keys
c  4.0     F.S.    7-may-2004 Added user defined types
c
c For further info the the Help file (DIX.HLB) and the release notes
c
c Start of coding
c
	include 'dix_def.inc'
	include '($stsdef)'
	include '($jpidef)'
	include '($syidef)'
c
C Function declaration
C 
	character*(max_line_length) line,old_line,libnam,defdir
	integer*4 nk,istat,nk_old,k,nk_lib,nk_def,dt(2)
	logical may_update
c
	external lib$get_input
	logical dcl_parse
	logical cli$present
	logical cli$dispatch
	external dix_cld
	integer*4 dix_main
	logical dix_main_check_library
c
c
	record /control/ control
c
c Process init file
c
	call lib$get_symbol('DIX_DEBUG',line,nk)	
	call str$upcase(line(1:1),line(1:1))
	control.debug = (line(1:1) .eq. 'Y')
c
c Open a channel to sys$output, for console messages
c
	call lib$get_lun(control.lun_console)
	open(control.lun_console,
     1         file='sys$output',recl=255,
     1         status='new',
     1         carriagecontrol='list')
c
	call dix_symbol_init(control)
c
	call sys$gettim(dt)
	if(2*(dt(1)/2) .eq. dt(1)) dt(1) = dt(1) + 1	!make odd
c
	control.prompt      = 'DIX#>'
	control.nk_prompt   = 5
c
	call lib$getsyi(syi$_arch_name,,line)
	if    (line(1:1) .eq. 'V') then
	  control.platform = platform_vax
	elseif(line(1:1) .eq. 'A') then
	  control.platform = platform_alpha
c	elseif(line(1:1) .eq. 'I') then
	else
	  control.platform = platform_ipf
	endif
c
	control.ran_seed    = dt(1)	!take low prec word
	control.dis_err     = 0		!no error display yet
	control.nk_symb     = 0         !no symbols yet
	control.seapos      = 0		!search pos
	control.seasiz      = 0		!search size
	control.wide        = .false.	!80 cols for now
	control.nk_fnam_out = 0         !length of output filename
	control.count       = 0         !record count to print in file mode
	control.smg_window  = 0		!output in inteactive mode to SMG
	control.one_rec     = .false.	!We have a record selected
	control.help_depth  = 0         !help depth to 0
	control.bold_set    = .false.	!not yet bolded
	control.forward     = .true.	!search in foward mode
	control.msgmask     = 0         !default all parts of message
	control.lun_out     = 0         !no output file yet
	control.nb_save     = 0		!no saved data yet
	control.input_flags = 0		!no special input flags
	control.editor      = dix_edit_internal	!use internal editor
	control.got_pasteboard = .false. !no pasteboard yet
	control.n_descr     = 0         !#desciptors
	control.top_descr   = 0         !pointer to first descriptor
	control.n_file      = 0         !#files open
	control.top_file    = 0         !pointer to first file
	control.nk_userlib  = 0         !length of user .tlb name 
	control.nk_syslib   = 0		!length of syslib .tlb anme
	control.strict_mode = 0		!no flags for strict mode
	control.paged       = 0		!no paging mode
	control.depth       = 0		!no depth
	control.top_level   = 0         !pointer to top commandfile level
	control.cur_level   = 0		!pointer to current commandifle level
	control.p_link_history = 0      !Pointer to link history
	do k=1,max_link_history
	  control.link_history(k).p_file = 0
	end do
c
	control.lun_search  = 0
	control.lun_select  = 0
c
	control.old_filep   = -1
	control.old_desp    = -1
c
	call init_vm(control.zone_file   ,0,'FILES',.false.)
	call init_vm(control.zone_cfile  ,0,'COMMAND_FILE',.false.)
	call init_vm(control.zone_general,0,'GENERAL',.false.)
	call init_vm(control.zone_descr  ,0,'DESCRIPTIONS',.false.)
	call init_vm(control.zone_links  ,0,'LINKS',.false.)
c
c Initialize keyboard mapping
c
	call smg$create_virtual_keyboard(control.keyboard_id)
	call smg$create_key_table(control.keytable_id)
c
	call keydefs_init(control,.false.,control.debug)
c
	call lib$get_foreign(line,,nk)
	if(dcl_parse(control,'DIX '//line(1:nk),dix_cld)) then
c
c Set debug flag
c
	  if(cli$present('debug')) control.debug = .true.
	  if(control.debug) call keydefs_dump(control.key_table,'keyes.txt')
c
c Fill in the name of the text librarys (if found)
c 1. system library
c 2. userlibrary
c
          call lib$getjpi(jpi$_imagname,,,,defdir,nk_def)
          call dix_util_file_parse(defdir(1:nk_def),'D',nk,nk_def)
	  call cli$get_value('SYSTEM_LIBRARY',line,nk)
	  if(dix_main_check_library(line(1:nk),libnam,nk_lib,may_update,
     1                defdir(1:nk_def))) then
	    control.may_write_to_syslib = may_update
	    control.syslib_name = libnam(1:nk_lib)
	    control.nk_syslib = nk_lib
	  endif
c
	  call cli$get_value('USER_LIBRARY',line,nk)
	  if(dix_main_check_library(line(1:nk),libnam,nk_lib,may_update,
     1                    'SYS$LOGIN:')) then
	    control.may_write_to_userlib = .true.
	    control.userlib_name = libnam(1:nk_lib)
	    control.nk_userlib = nk_lib
	  endif
c
c Check if startup file specified
c
	  call cli$get_value('startup',line,nk)
	  if(nk .gt. 0) then 
c
c Startup processing destroys the cld settings
c so after the startup processing reparse the input line.
c  The qualifiers added via lib$get_input are now included, so we do not 
c    need lib$get_input again
c
	    call cli$get_value('$LINE',old_line,nk_old)
 	    call dix_process_Startup(control,line(1:nk))
	    call dcl_parse(control,old_line(1:nk_old),dix_cld)
	  endif
c
c If debug wanted, print keyboard mapping again
c
	  if(control.debug) call keydefs_dump(control.key_table,'keyes.txt')
c
c Go parse the specific parts
c
	  istat = cli$dispatch(control)
c
c If no error seen, (and mode <> none (help)) do it
c
	  if(istat) then
	    if(control.mode .ne. mode_none) istat = dix_main(control)
	  endif
	endif
c
c Close output file again
c
	close(control.lun_console)
	call lib$free_lun(control.lun_console)
c
	istat = istat .or. sts$m_inhib_msg	!do not let DCL signal error
	call sys$exit(%val(istat))
	end		
	function dix_main(control)
	implicit none
	include 'dix_def.inc'
c
c Main work routine
c
	record /control/ control		!:io: control structure
	integer*4 dix_main 			!:f: function result
c#
	integer*4 cli$present
	logical*4 dix_main_set_initial_key
	logical dix_main_select_file
	logical dix_main_get_files
	integer*4 dix_inter_open_level
	integer*4 dix_dump
	integer*4 dix_util_get_len_fu
c
	external rms$_fnf
	external dix_msg_nofilmat
	external dix_cld
c
	include '($dcdef)'
	include '($dvidef)'
C
C Local vars
c
	record /file_info/ file
	pointer (p_file  ,file)
c
	record /dis_pars/ dis
c
	character*(max_line_length) line,old_line,err,temp_file
	integer*4 iterm,nk_old,istat,nk,k,nk_temp,lun
	logical*4 got_one,multi_file
c	
	external dix_msg_nomrkres
	external dix_msg_filnotop
	external dix_msg_general
	external dix_msg_aslelt
	external dix_msg_degegt
c
c first check if sys$input is a terminal, if not screen is not possible
c
	call lib$getdvi(dvi$_devclass,,'sys$input',k)
	control.is_term = k .eq. dc$_term
	dis.is_term = control.is_term
	if(control.is_term) then
	  call lib$getdvi(dvi$_devbufsiz,,'SYS$OUTPUT',control.ncols)
	else
	  control.ncols = 132
	endif
c
c Make a pasteboard, if not VT type terminal mode wil be set to mode_interactive
c
	if(control.mode .eq. mode_screen .or.
     1     control.mode .eq. mode_interactive) then
	  call get_pasteboard(control)
	endif
c
c Open the output file
c
	if(control.nk_fnam_out .eq. 0) then
	  control.fnam_out = 'NL:'
	  control.nk_fnam_out = 3
	endif
	call lib$get_lun(control.lun_out)
	open(control.lun_out,
     1         file=control.fnam_out(1:control.nk_fnam_out),
     1         status='new',
     1         carriagecontrol='list')
c
c Specific parts of the modes
c
	if(control.mode .eq. mode_screen) then
	  call smg$erase_pasteboard(control.paste_id)
c
c screen mode, there is a pasteboard
c
	  call dix_smg_out_of_band(control)
	  call smg$create_virtual_display(3,control.ncols,control.dis_kop)
	  call smg$paste_virtual_display(control.dis_kop,
     1          control.paste_id,1,1)
	elseif(control.mode .eq. mode_interactive) then
c
c Interative mode
c See if script is specified
c
	  nk_temp = 0
	  if(control.nk_script_file .ne. 0) then
	    line = control.script_file 
	    nk = control.nk_script_file
	    if(line(1:1) .eq. '@') then
c
c It is already a command file, just strip the @ and go
c
	      line = line(2:)
	      nk = nk - 1
	    else
c
c One line command, create a scratch file, and put line in in
c
	      call lib$get_lun(lun)
	      call sys$fao('SYS$SCRATCH:DIX_TEMP.temp_input',nk_temp,temp_file)
	      open(lun,file=temp_file(1:nk_temp),status='new')
	      write(lun,'(a)') line(1:nk)
	      inquire(lun,name=temp_file)
	      nk_temp = dix_util_get_len_fu(temp_file)
	      close(lun)
	      line = temp_file(1:nk_temp)
	      nk = nk_temp
	    endif
	  else
	    line = 'SYS$INPUT'
	    nk = 9
	  endif
c
c Since open level uses dcl_pars, we must save the cuRRent command
c
	  call cli$get_value('$LINE',old_line,nk_old)
	  istat = dix_inter_open_level(control,line(1:nk),' ')
	  if(nk_temp .ne. 0) call lib$delete_file(temp_file(1:nk_temp))
	  if(.not. istat) goto 81
c
	  call dcl_parse(control,old_line(1:nk_old),dix_cld)
	  
	  dis.is_term = control.is_term
	  call dix_smg_out_of_band(control)		!enable control-c
	elseif(control.mode .eq. mode_file) then
c
c File mode
c
	  control.ncols = 80
	  if(control.wide) control.ncols = 132
	else
c
c Info mode
c
	  control.ncols = 80
	  if(control.wide) control.ncols = 132
	end if
c
c Get the display parameters
c
	dis.unsigned = cli$present('unsigned')
c
	dis.show_des = .false.
	dis.word = 4
	if(cli$present('WORD')) dis.word = 2
	if(cli$present('BYTE')) dis.word = 1
c
	dis.raw    = cli$present('RAW')
c
	dis.number = cli$present('NUMBER')
	if(.not. dis.raw) then
c
c defaults for Interpreted mode
c
	  dis.hex = .false.
	  if(cli$present('HEX'))     dis.hex     = .true.
	else
c
c defaults for raw mode
c
	  dis.hex = .true.
	  if(cli$present('DECIMAL')) dis.hex     = .false.
	endif
c
	dis.number_hex = dis.hex
	if(cli$present('NUMBER.HEX'))     dis.number_hex  = .true.
	if(cli$present('NUMBER.DECIMAL')) dis.number_hex  = .false.
	dis.compres = cli$present('COMPRES')
c
c Get all the files specified
C  since get_files uses DCL_PARSE, we must save/restore DCL context
c
	multi_file = cli$present('multi_file')
	call cli$get_value('$LINE',old_line,nk_old)
	call dix_main_get_files(control,'p1',dis.raw,
     1                     ' ',' ',.false.)
	call dcl_parse(control,old_line(1:nk_old),dix_cld)
c
c If more then one found, and .not. multi_file, let the user
c select one.
c
	istat = 1
	if(control.n_File .gt. 1 .and. .not. multi_file) then
	  if(.not. dix_main_select_file(control)) goto 90
	endif
c
	if(control.mode .eq. mode_info) then
	  p_file = control.top_file
	  do while (p_file .ne. 0)
            call dix_rms_file_info(control,
     1              file.fnam(1:file.nk_fnam),
     1              %val(file.rabadr),%val(0))
	    p_file = file.link.forw
	  end do
	  goto 60
	endif
c                                           
c If no files found, we can continue if mode=interactive
c
	if(control.n_file .eq. 0) then
	  if(control.mode .ne. mode_interactive) then
	    istat = %loc(rms$_fnf)
	    goto 90
	  endif
	endif
c
c Else take the first file, and go
c
	control.cur_file = control.top_file
        p_file = control.cur_file
c
c Set record depending on 'record', 'ge','key' qualifiers
c
	if(%loc(file) .ne. 0) then
	  istat = dix_main_set_initial_key(control,file,got_one)
	  if(.not.istat) goto 60
c
c Returns got_one if a specific record selected, in that case set count to 1
c
	  if(got_one .and. control.count .eq. 0)  control.count = 1
	endif
c
c dump the data file
c
55	if(%loc(file) .ne. 0) then
	  if(file.cur_des .eq. 0) file.cur_des = file.top_des
	  call dix_symbol_add_str(control,'$FILE',
     1              file.fnam(1:file.nk_fnam),err)
	else
	  nk = 0
          call dix_symbol_add_str(control,'$FILE',line(1:nk),err)
	endif
c
c To work!!!!!
c
	istat = dix_dump(control,iterm,dis)
	if(.not. istat) goto 60
c
	if(iterm .eq. key_modechange) then
c
c Change mode
c
	  if(control.mode .eq. mode_screen) then
c
c We were in screen mode
c
	    call smg$delete_virtual_display(control.dis_kop)
	    control.mode = mode_interactive
	    if(control.depth .eq. 0) then
c
c Have not yet been here
c
	      call sys$fao('!AS',nk,line,'SYS$INPUT:')
	      istat = dix_inter_open_level(control,line(1:nk),' ')
	      if(.not. istat) goto 81
	      dis.is_term = control.is_term
	    endif
	  elseif(control.mode .eq. mode_interactive) then
c
c We were in interactive mode
c
	    control.mode = mode_screen
	    call smg$create_virtual_display(3,control.ncols,control.dis_kop)
	    call smg$paste_virtual_display(control.dis_kop,
     1                control.paste_id,1,1)
	  endif
	  goto 55
	endif
c
c Thats all, close input file
c
60      p_file = control.top_file
        do while(p_file .ne. 0)
	  call file_close(control,file)
	  k = file.link.forw
	  call lib$free_vm(sizeof(file),p_file)
          p_file = k
	end do
	goto 90
c
c Here if we cannot open a command level
c signal the error and return istat for main routine
c
81	call dix_message(control,dix_msg_filnotop,line(1:nk))
c
c All done , finish up
c
90	if(control.mode .eq. mode_screen) then
	  call dix_main_wait_message(control)
	  if(control.got_pasteboard) then
	    call smg$delete_pasteboard(control.paste_id)
	  endif
	  if(control.keyboard_id .ne. 0) then
	    call smg$delete_virtual_keyboard(control.keyboard_id)
	  endif
	end if
c
99	dix_main = istat
	return
	end
	function dix_main_rfa_restore(control,mark)
	implicit none
c
c Restore a file from an RFA Mark
c
	include 'dix_def.inc'
	record /control/ control        !:io: the control 
	character*(*) mark		!:i: the mark to restore to
	integer*4 dix_main_rfa_restore	!:f: function result
c#
	integer*4 k,istat
c
	integer*4 dix_rms_set_rfa
	external dix_msg_nomrkres
c
	record /file_info/ file
	pointer (p_file,file)
c
	k = control.top_file
	p_file = control.cur_file
c
	call dix_rms_save_rfa('__DIXRFA_UNDO',%val(file.rabadr),file.rec_nr)
	if(.not. dix_rms_set_rfa(control,k,mark)) then
	  istat = %loc(dix_msg_nomrkres)
c
c Was a problem, so return to previous mark
c
	  k = control.top_file
	  call dix_rms_set_rfa(control,k,'__DIXRFA_UNDO')
	else
	  istat = 1
	endif
c
c got it, k points to the correct file , now set cur_file correct
c
	control.cur_file = k
	dix_main_rfa_restore = istat
	return
	end
c
	function dix_main_follow(control,dis,auto,open_flag,link_rec,
     1           value,link_fnam)
	implicit none
c
c (try to) follow a link from a descripto entry to another file
c
	include 'dix_def.inc'
	record /control/ control	!:io: control structure
	record /dis_pars/ dis		!:i: display parameters
	logical auto                    !:i: automatic opne file
	integer*4 open_flag		!:i: open mode
	record /link_rec/ link_rec	!:i: the link info
	record /value/ value		!:i: the key/record value
	character*(*) link_fnam		!:i: link filename
	integer*4 dix_main_follow	!:f: function result
c#
	record /file_info/ file
	pointer (p_file  ,file)
c
	character*(max_filename_length) deffile
	character*(max_line_length) line,name,keyascval
	integer*4 nk,nk_def,k,istat,keyopt,length,nk1
	logical filenotf,mod_wanted,answer,string,ascending
c
	logical dix_main_question
	logical dix_main_get_files
	integer*4 dix_main_get_rec_int
	integer*4 dix_rms_get_keyed
	integer*4 dix_rms_keyinfo
	integer*4 dix_util_get_len_fu
c
	external dix_cld
	external dix_msg_nofilmat
	external dix_msg_keyisint
	external dix_msg_aslelt
	external dix_msg_degegt
	external dix_msg_keyischar
c
c Follow link to file, try to find the wanted file in open file list
c
	p_file  = control.cur_file
	nk = dix_util_get_len_fu(link_fnam)
	if(nk .eq. 0) goto 58		!current file
c
c Get the file disk,directory,name, this is used ad a default for the 
c    possible fileopens if the link file is not found
c
	deffile = file.fnam
        call dix_util_file_parse(deffile,'T',k,nk_def)
c
	filenotf = .true.
	istat = 1
	if(open_flag .eq. 0) then
	  mod_wanted = file.modify
	else
	  mod_wanted = open_flag .eq. 1
	endif
c
c Go through chain of files, and check if we found it
c First get the full file name of the file
c skip the version
c
        call dix_util_file_parse(link_fnam(1:nk),'T',k,nk1)
	inquire(file=link_fnam(1:nk1),
     1          defaultfile = deffile(1:nk_def),
     1          name=name,
     1          err=54)
c
	p_file = control.top_file
	do while(p_file .ne. 0)
	  if(file.fnam(1:file.nk_fnam) .eq. name) goto 58
          p_file = file.link.forw
	end do
c
c No filename match, ask if the user wants to add it
c
	answer = auto 			!!used to automatic
	if(.not. answer) answer = dix_main_question(control,'File '//
     1              link_fnam(1:nk)//
     1             ' not (yet) opened, open it',.true.)
	if(answer) then
c
c To make it easy, make a command line
c
	  line = 'DIX '//link_fnam(1:nk)
	  nk = nk + 4
	  if(mod_wanted) then
	    line(nk+1:) = '/MODIFY'
	    nk = nk + 7
	  endif
	
	  call dcl_parse(control,line(1:nk),dix_cld)
	  if(dix_main_get_files(control,'p1',dis.raw,
     1                          deffile(1:nk_def),' ',.false.)) then
c
c Now it must be at the end of the list
c
	    p_file = control.top_file
	    do while(file.link.forw .ne. 0)
	      p_file = file.link.forw
	    end do
	    goto 58	  
	  endif
	endif
c
c Either do not open, or file not found
c
54	istat = %loc(dix_msg_nofilmat)
	goto 90
c
c We have the file, try to find the record
c
58	if(link_rec.key_nr .lt. 0) then
c
c Record access, keyfield must be integer
c
          if(value.type .eq. symb_typ_int) then
            istat = dix_main_get_rec_int(control,file,value.ival)
          else
            istat = %loc(dix_msg_keyisint)
          endif
        else
c
c Keyed access
c
          keyopt = link_rec.match
          istat = dix_rms_keyinfo(file,link_rec.key_nr,
     1                    string,length,ascending,name)
          if(istat) then
            if(ascending .and. keyopt .lt. 0) then
              istat = %loc(dix_msg_aslelt)	
            elseif(.not. ascending .and. keyopt .gt.0) then
              istat = %loc(dix_msg_degegt)	
            endif
          endif
	
          if(istat) then
            keyopt = iabs(keyopt)
            if(string) then
              if(value.type.eq.symb_typ_char)then
c
c Make a key completely blank
c and fill with the data from the record
c
	        keyascval = ' '
	        nk = min(len(keyascval),zext(value.strdes.dsc$w_maxstrlen))
	        call lib$movc3(nk,%val(value.strdes.dsc$a_pointer),
     1                  %ref(keyascval))
c
                istat = dix_rms_get_keyed(control,file,keyopt,length,
     1               %ref(keyascval),link_rec.key_nr)
              else
                istat = %loc(dix_msg_keyischar)
	      endif
	    else
	      if(value.type.eq.symb_typ_int)then
	        istat = dix_rms_get_keyed(control,file,keyopt,length,
     1                  value.ival,link_rec.key_nr)
	      else
	        istat = %loc(dix_msg_keyisint)
	      endif	!type is integer
	    endif	!string type
	  endif		!succesfull direction
	endif		!keyded access
	if(istat) then
c
c We found the record, increment history pointer
c
	  if(control.p_link_history .eq. max_link_history) then
c
c No more room, remove oldest
c
	    do k=2,max_link_history
	       control.link_history(k-1) = control.link_history(k)
	    end do
	  else
	    control.p_link_history = control.p_link_history + 1
	  endif
c
c And save return point
c
	  control.link_history(control.p_link_history).p_file=control.cur_file
	  control.cur_file = p_file
	  p_file = control.link_history(control.p_link_history).p_file 
	  call dix_rms_compute_rfa(%val(file.rabadr),file.rec_nr,
     1       control.link_history(control.p_link_history).rfainfo,nk)
	endif
90	dix_main_follow = istat
	return
	end
	function dix_main_follow_back(control,log_it)
	implicit none
c
c Follwo the backlink from a previous link
c
	include 'dix_def.inc'
	record /control/ control	!:io: control strucuture
	logical log_it			!:i: log the switch?
	integer*4 dix_main_follow_back	!:f: function result
c#
	integer*4 save_p_file,istat
c
	record /file_info/ file
	pointer (p_file,file)
c
	integer*4 dix_rms_set_rfa_val
c
	external dix_msg_nohist
	external dix_msg_folhist
	external dix_msg_nomrkres
c
	save_p_file = 0
	if(control.p_link_history .ne. 0) then 
c
c Get history file
c
	  save_p_file = control.link_history(control.p_link_history).p_file
c
c Try to set pointer in history file (should work, unless somebody
c  else removed record).
c
	  istat = dix_rms_set_rfa_val(control,save_p_file,
     1        control.link_history(control.p_link_history).rfainfo)
c
	  control.p_link_history = control.p_link_history - 1
c
	  if(.not. istat)then
c
c Sorry could not restore record, the pointer is already removed, so the next
c time it is not used again
c
	    call dix_message(control,dix_msg_nomrkres,%descr('Link history'))
	  else
c
c Got the record, so make this file the active one 
c
	    control.cur_file = save_p_file
	    p_file = save_p_file
c
c And log it (is wanted)
c
	    if(log_it) call dix_message(control,
     1               dix_msg_folhist,file.fnam(1:file.nk_fnam))
	  endif
	else
c
c Sorry, no history present
c
	  istat = %loc(dix_msg_nohist)
	endif	  	  
	dix_main_follow_back = istat
	return
	end
	subroutine dix_main_wait_message(control)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
c#
c The user wants to exit, make sure he has read all messages
c
	integer*4 k
	external dix_msg_exiting
c
	if(control.dis_err .ne. 0) then
	  call dix_message(control,dix_msg_exiting)
	  call dix_get_key(control,k)
	end if
	return
	end
	subroutine dix_message(control,mes_code,
     1             arg1,arg2,arg3,arg4,arg5,arg6,arg7)
	implicit none
c
c Print a message (either via SMG or via write to terminal)
c
	include 'dix_def.inc'
	record /control/ control	!control block
	integer*4 mes_code		!message code
	integer*4 arg1			!arg1 up arg7
	integer*4 arg2
	integer*4 arg3
	integer*4 arg4
	integer*4 arg5
	integer*4 arg6
	integer*4 arg7			!upto 7
c#
	integer*4 args(10),narg,nk,nk1
	integer*4 did,drow,dcol
	logical use_smg,is_file
	character*(max_line_length) line,line1
c
	external dix_msg_disontop,dix_msg_clear
c
	narg = iargcount() - 2
	if(narg .gt. 0) args(1) = %loc(arg1)
	if(narg .gt. 1) args(2) = %loc(arg2)
	if(narg .gt. 2) args(3) = %loc(arg3)
	if(narg .gt. 3) args(4) = %loc(arg4)
	if(narg .gt. 4) args(5) = %loc(arg5)
	if(narg .gt. 5) args(6) = %loc(arg6)
	if(narg .gt. 6) args(7) = %loc(arg7)
c
	use_smg = control.mode .eq. mode_Screen .or. 
     1            control.smg_window .ne. 0
c
	if(%loc(mes_code) .eq. %loc(dix_msg_clear)) then
c
c In screen mode,clear error display
c
	  if(use_smg) then
	    if(control.dis_err .ne. 0) call 
     1           smg$delete_virtual_display(control.dis_err)
	    control.dis_err = 0
	  endif
	elseif(%loc(mes_code) .eq. %loc(dix_msg_disontop)) then
c
c Make sure error display is on top
c
	  if(use_smg) then
	    call smg$find_cursor_display(control.paste_id,did)
	    call smg$return_cursor_pos(did,drow,dcol)
	    call smg$repaste_virtual_display(control.dis_err,
     1                   control.paste_id,
     1                   control.nrows-control.nlin_dis_err+1,
     1                   control.ncols-control.ncol_dis_err+1)
c
c        Restore cursor
c
            call smg$set_cursor_abs(did,drow,dcol)
	  endif
	else
c
c Normal messages
c
	  call dix_main_get_message(control,mes_code,nk,line)
	  call sys$faol(line(1:nk),nk1,line1,args)
	  if(use_smg) then
	    call dix_mes(control,line1(1:nk1))
	  else
	    if(control.mode .eq. mode_interactive .and. 
     1         control.depth .gt. 0) then
c
c In interactive mode, if output to file, print there too 
c
	      call dix_inter_get_file_level_info(control,'FI',is_file,line1)
	      call dix_write_file(control,line1(1:nk1))
	    else
	      call dix_write_console(control,line1(1:nk1))
	    endif
	  endif
	endif
	return
	end
	subroutine dix_main_get_message(control,mes_code,nk,line)
	implicit none
c
c return message fro message section.
c
	include 'dix_def.inc'
	record /control/ control	!:i: control block
	integer*4 mes_code		!:i: message 
	integer*4 nk			!:o: length of message
	character*(*) line		!:o: the text of the mess
c#
	logical use_smg
	integer*4 msg_mask,nk1
c
	character*(max_line_length) line1
c
	integer*4 sys$getmsg
	external dix_msg_noname
c
	use_smg = control.mode .eq. mode_Screen .or. 
     1            control.smg_window .ne. 0
c
c In interactive mode, use the current settings of msgmask
c  else user 1 (text only)
c
	msg_mask = control.msgmask
	if(use_smg) msg_mask = 1
	if(.not. sys$getmsg(mes_code,nk,line,%val(msg_mask),)) then
c
c Shoul not happen, but if so replace by useful?? message
c
	  call sys$getmsg(dix_msg_noname,nk1,line1,%val(msg_mask),)
	  call sys$fao(line1(1:nk1),nk,line,%val(mes_code))
	endif
	return
	end
	function dix_write_console(control,line)
	implicit none
c
c Write to sys$output
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) line		!:i: the line to print
	integer*4 dix_write_console	!:f: function result
c#
	integer*4 bpos,epos,width,nkar,istat
c
c The first line it printed normally
c the second and third lines are indented by 2
c
	nkar = max(1,len(line))
	width = max(80,control.ncols)
c
	bpos = 1
	do while(bpos .le. len(line))
	  epos = min(len(line),bpos + width - 1)
	  if(bpos .eq. 1) then
	    write(control.lun_console,1000,err=80) line(bpos:epos)
1000	    format(a)
	    width = width - 2
	  else
	    write(control.lun_console,1010,err=80) line(bpos:epos)
1010	    format(2x,a)
	  endif
	  bpos = epos + 1
	end do
	istat = 1
	goto 90
80	call errsns(,istat)
90	dix_write_console = istat
	return
	end
	subroutine dix_mes(control,mes)
	implicit none
c
c Print a message to an SMG window
c
	include 'dix_def.inc'
	record /control/ control		!:i: control structure
	character*(*) mes			!:i: message text
c#
	integer*4 nkar,k,nl,nc,ipos
c
	include '($smgdef)'
	character*(*) ident
	parameter (ident='Messages')
c
c Compute #lines for the display
c
	nkar = len(mes)
c
c Compute ncols
c
	nc = max(len(ident)+1,min(nkar,control.ncols))
c
c Compute nrows
c
	nl = (nkar+nc-1)/nc
	if(control.dis_err .eq. 0) then
c
c Create new empty display with enough room for message
c
	  control.nlin_dis_err = nl
	  control.ncol_dis_err = nc
	  call smg$create_virtual_display(control.nlin_dis_err,
     1         control.ncol_dis_err,control.dis_err)
	  call smg$paste_virtual_display(control.dis_err,
     1         control.paste_id,
     1         control.nrows-control.nlin_dis_err+1,
     1         control.ncols-control.ncol_dis_err+1)
	  call smg$label_border(control.dis_err,ident)
	else	
c
c display was there, enlarge it
c
	  control.nlin_dis_err = control.nlin_dis_err + nl
	  if(nc .gt. control.ncol_dis_err) control.ncol_dis_err = nc
	  call smg$change_virtual_display(control.dis_err,
     1         control.nlin_dis_err,control.ncol_dis_err)
	  call smg$repaste_virtual_display(control.dis_err,
     1         control.paste_id,
     1         control.nrows-control.nlin_dis_err+1,
     1         control.ncols-control.ncol_dis_err+1)
	end if
c
c Now print the text to the display
c
	ipos = 1
	do k=1,nl
	  call smg$put_chars(control.dis_err,
     1        mes(ipos:min(nkar,k*control.ncols)),
     1        control.nlin_dis_err-nl+k,1,
     1        smg$m_erase_to_eol,smg$m_bold)
	  ipos = ipos+control.ncols
	end do
	return
	end

	subroutine dix_main_fill_rec(control,file)
	implicit none
c
c Fil a record to defaults (space for test, NULL for binary
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:io: file structure/record
c#
	record /des_rec/ des_rec
c
	logical dix_con_typ_is_text
c
	integer*4 k,offs,max_size,max_offs
	character nam
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)
c
	record /des_info/ des
	pointer (p_des,des)
c
c CHeck if changed data present
c
        call dix_main_check_mod_record(control,file)
c
c Fill record with all 0
c
	file.data.nb_data = file.maxrecl
	call dix_util_fill(0,file.data.nb_data,file.data.data_rec)
c
c Try to locate a fixed format description
c (no string, or lstring or something else variable)
c
	p_des_expanded = file.top_des
	do while(p_des_expanded .ne. 0) 
	  p_des = des_expanded.p_des_info
	  if(des.fixed) goto 10
	  p_des_Expanded = des_expanded.link.forw
	end do
c
c Could not find fixed one, so use the first
c
	p_des_expanded = file.top_des
	p_des = des_expanded.p_des_info
c
c Got a valid description, so gogogogogo
c
c Expand the record, since we have no data this can only work
c if nothing variable
c
c Expand descriptions
c
10	call dix_des_expand(control,des_expanded,file)
	max_size = des_expanded.max_name_size
	max_offs = 0
c
c Go through al descriptions
c
	do k=1,des_expanded.n_des
	  call dix_des_get_des(des_expanded,k,des_rec,nam)
	  offs = des_rec.bit_offset/8
	  if(dix_con_typ_is_text(des_rec.ent_type)) then
c
c Is text, so fill with spaces
c
	    call dix_util_fill(ichar(' '),des_rec.size/8,
     1                file.data.data_rec(offs+1))
	  end if
	  if(offs+des_rec.size/8 .gt. max_offs) max_offs = offs+des_rec.size/8
	end do
c
c For a fixed record length
c
	if(.not. file.fixed) file.data.nb_data = max_offs
90	return
	end


	function dix_main_set_initial_key(control,file,got_one)
	implicit none
c
c Set the record to the values given by the user
c
c /record or /key=,/lt../gt=
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:i: file information
	logical*4 got_one		!:o: true if user set /le,eq.. or /rec
	logical*4 dix_main_set_initial_key	!:f: function result
c#
c function declaration
c
	integer*4 cli$get_value,cli$present
	logical*4 dix_main_get_rec_keyed,dix_main_get_rec
	logical*4 dix_rms_set_rfa
c
c Local vars
c
	integer*4 keyopt
c
	character*(max_line_length) key_str
	character*(max_keytype_length) key_types(-2:2)
     1             /'LT','LE','EQ','GE','GT'/
 	integer*4 nkar,istat,length
	logical string,ascending
	character*(max_rms_key_name_length) keynam
c
	external dix_msg_aslelt
	external dix_msg_degegt
	external dix_msg_rewind
c
	integer*4 key
	external dix_msg_illkeyn
c
c Start of coding
c
	got_one = .false.
	istat = 1
c
c See indexed/non indexed
c
	if(cli$present('RFA')) then
	  istat = dix_rms_set_rfa(control,%loc(file),'DIXRFA')
	  if(istat) then
	    got_one = .true.
	    control.one_rec = .true.
	    goto 80
	  endif
	endif
c
	if(file.indexed .and. file.block_size .eq. 0) then
c
C Keyed file
c Get key value, and keynumber
c
c Get key number
c
	  call util_cli_get_number('key',0,key)
c
c If KEY does not exist, this returns an error
c
	  if(key .lt.0 .or. key .ge. file.nkey) then
	    call dix_message(control,dix_msg_illkeyn,
     1                    %val(key),%val(file.nkey))
	     istat = 0		!signal failure
	    goto 90
	  endif
	  file.cur_key = key
C
C See if somebody specified /**=value
c will return keyopt = 
C -2  LT search
C -1  LE search
C  0  EQ search
C  1  GE search
c  2  GT search
c  3  No search ,so rewind on specified key
c
	  do keyopt=-2,2
	    if(cli$present(key_types(keyopt))) then
	      call  cli$get_value(key_types(keyopt),key_str,nkar)
	      if(nkar .gt. 0) then
	        if(key_types(keyopt) .eq. 'EQ') control.one_rec = .true.
	        got_one = .true.
	      endif
	      goto 50
	    end if
	  end do
	  keyopt = 0
50	  call dix_rms_keyinfo(file,key,string,length,ascending,keynam)
c
c Warning 
c
	  if(ascending) then
	    if(keyopt .lt. 0) then
	      call dix_message(control,dix_msg_aslelt)
	      call dix_message(control,dix_msg_rewind)
	      nkar = 0
	    endif
	  else
	    if(keyopt .gt. 0) then
	      call dix_message(control,dix_msg_degegt)
	      call dix_message(control,dix_msg_rewind)
	      nkar = 0
	    endif
	  endif
c
c now do the settings on the file
c
	  istat = dix_main_get_rec_keyed(control,file,key,key_str,nkar,
     1             iabs(keyopt),.true.)
	else
C
C sequential file, get record number
C can be sequential (var length) or
C direct access
C
	  file.cur_key = 0
	  call cli$get_value('record',key_str,nkar)
	  if(nkar .gt. 0) then
	    control.one_rec = .true.
	    got_one = .true.
	  endif
	  istat = dix_main_get_rec(control,file,key_str(1:nkar))
	end if
c
	if(.not. istat) call dix_message(control,%val(istat))
C
80	dix_main_set_initial_key = istat
90	return
	end

	function dix_main_get_rec_keyed(control,file,key,keyval,nkar,
     1                 keyopt,translate_percent)
	implicit none
c
c Read the data according to the requested value for an indexed file
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file		!:i: fiel information
	integer*4 key			!:i: key number
	character*(*) keyval		!:i: key value to search
	integer*4 nkar			!:i: #kars in keyval (can be 0)
	integer*4 keyopt		!:i: keyoption 0=eq,1=ge,2=gt
	logical translate_percent	!:i: is %xx converted to hex char?
	logical*4 dix_main_get_rec_keyed !:F: result
c#
	logical*4 string,ascending,signal
	integer*4 length,nkar_key,istat
	character*(max_rms_key_name_length) keynam
	byte datab(32)
c
	logical*4 dix_con_int_ascint
	logical*4 dix_rms_rewind
	logical*4 dix_rms_get
	logical*4 dix_rms_get_keyed
	logical dix_con_hex_in_string
c
	external dix_msg_warnperc
c
c Get key information
c
	signal = .false.
	call dix_rms_keyinfo(file,key,string,length,ascending,keynam)
c
c For not strings, convert to binary
c
	nkar_key = nkar
	if(nkar .gt. 0) then
	  if(.not. string) then
c
c For non string convert from ascii to binary, check for keylength
c
	    nkar_key = length
	    istat=dix_con_int_ascint(keyval(1:nkar),datab,length*8,' ',
     1               0,0,control)
	    if(.not. istat) goto 90
	  else
c
c String type, justcopy
c for equal case, the whole key is used, else only the text upto nkar_data
c
	    if(keyopt .eq. 0) nkar_key = length
	    if(translate_percent) then
	      signal = dix_con_hex_in_string(keyval,nkar_key,.true.)
	    endif
	    call dix_util_copy(nkar_key,%ref(keyval),datab)
	  end if
	end if
	if(nkar_key .eq. 0) then
c
c Only /key or nothing
c
	  istat = dix_rms_rewind(control,file,key)
	  if(istat) istat = dix_rms_get(control,file)
	else
c
c keyvalue is given
c
	  istat = dix_rms_get_keyed(control,file,keyopt,nkar_key,datab,key)
	  if(.not. istat .and. signal) then
	    call dix_message(control,dix_msg_warnperc)
	  endif
	endif
90	dix_main_get_rec_keyed = istat
	return
	end

	function dix_main_get_rec(control,file,recasc)
	implicit none
c
c Read the data according to the requested value for a non-indexed file
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:i: file information
	character*(*) recasc		!:i: rec nr in ascii
	logical*4 dix_main_get_rec	!:F: result
c#
	integer*4 recnr,istat
c
	logical*4 dix_con_int_ascint
	logical*4 dix_main_get_rec_int
c
	recnr = 1
	if(recasc .ne. ' ') then
	  istat = dix_con_int_ascint(recasc,recnr,32,' ',
     1               0,0,control)
	  if(recnr .le. 0) recnr = 1
	end if
	dix_main_get_rec = dix_main_get_rec_int(control,file,recnr)
	return
	end
c
	function dix_main_get_rec_int(control,file,recnr)
	implicit none
c
c Read the data according to the requested value for a non-indexed file
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:i: file information
	integer*4 recnr			!:i: the wanted record mumber
	logical*4 dix_main_get_rec_int	!:F: result
c#
	integer*4 istat
c
	logical*4 dix_rms_get_direct
	logical*4 dix_rms_skip
	logical*4 dix_rms_get
c
	external dix_msg_firstrec
c
	if(recnr .le. 0) then
	  istat = %loc(dix_msg_firstrec)
	else
          if(file.fixed .or. file.block_size .ne. 0) then
c
c Fixed record file, so we can directly read the record
c
	    istat = dix_rms_get_direct(control,file,recnr)
	  else
c
c Variable file, skip n-1 records
c
	    call dix_rms_rewind(control,file,-1)
	    istat = dix_rms_skip(control,file,recnr-1)
	    istat = dix_rms_get(control,file)
	  end if
	endif
	dix_main_get_rec_int = istat
	return
	end

	subroutine dix_main_search_file(control,file,pf1_flag)	
	implicit none
	include 'dix_def.inc'
c
c Search the file for a specific string in a record
c
	record /control/ control		!:i: control structure
	record /file_info/ file			!:io: file structure
	logical*4 pf1_flag			!:i: force asking search str
c#
	character*(max_search_length) sear,sear1
	integer*4 dis_ch,iterm,nkar,nkar1,nrec,n
	logical*4 query,found_it
	character*(max_short_line_length) temp
	include '($smgdef)'
	character kar
c
	character*(*) help_lines
	parameter (help_lines=
     1   'search items;'//
     1   'The user can specify a search string;'//
     1   'The program will search for the string for all records;'//
     1   'following the current one (or from the start of the file);'//
     1   'The search string will be treated as a wildcard;'//
     1   ' so a search for the contents must be preceeded and;'//
     1   ' and terminated with an *')
c
	logical*4 dix_rms_get
	logical*4 dix_main_string_found
	external dix_msg_rewind
	external dix_msg_search
	external dix_msg_seanotf
	external dix_msg_ctrlcseen
c
c Check to see if interactive or screen mode
c
	if(control.mode .eq. mode_interactive) then
c
c Interactive mode, no screen mode
c
	  sear = control.sear
	  nkar = control.nk_sear
	  if(control.rewind) then
	    call dix_message(control,dix_msg_rewind)
	    call dix_rms_rewind(control,file,-1)
	  end if
	  call dix_message(control,dix_msg_search,sear(1:nkar))
	  kar = ' '
	  goto 39
	end if
c
c screen mode 
c
	if(pf1_flag) nkar = 0
	sear(nkar+1:) = ' '
	query = nkar .eq. 0
c
	call smg$create_virtual_display(4,50,dis_ch)
	call smg$paste_virtual_display(dis_ch,control.paste_id,13,15)
	call smg$put_chars(dis_ch,'Search string  :',1,1)
	call smg$put_chars(dis_ch,
     1     'Starting from current record or BOF ([C]/B):',2,1)
10	call smg$put_chars(dis_ch,' ',3,1,smg$m_erase_to_eol)
	iterm = 0
	if(query) then
	  call dix_smg_stack_help(control,help_lines)
	  call dix_smg_get_string(control,dis_ch,1,17,31,sear,0,
     1             iterm,nkar,.false.)
	  call dix_smg_unstack_help(control)
	  if(iterm .eq. key_exit) goto 90
	  if(nkar .eq. 0) goto 90
	else
	  call smg$put_chars(dis_ch,sear(1:nkar),1,17)
	  call smg$put_chars(dis_ch,'C',2,45)
	end if
c
	if(.not. file.got_record) then
	  call dix_message(control,dix_msg_rewind)
	  call dix_rms_rewind(control,file,-1)
	else
	  if(query) then
	    iterm = 0
	    call dix_smg_stack_help(control,help_lines)
	    call dix_smg_get_string(control,dis_ch,2,45,2,kar,0,
     1                    iterm,n,.false.)
	    call dix_smg_unstack_help(control)
	    if(iterm .eq. key_exit) goto 90
	    if(kar .eq. 'B' .or. kar .eq. 'b') then
	      call dix_message(control,dix_msg_rewind)
	      call dix_rms_rewind(control,file,-1)
	    end if
	  end if
	end if
	call smg$put_chars(dis_ch,'Reading record :',3,1)
c
39	nrec = 0
	control.control_c_seen = .false.
	call str$upcase(sear1,sear)
	nkar1 = nkar
	call dix_con_hex_in_string(sear1,nkar1,.true.)
c
40	if(.not. dix_rms_get(control,file)) then
	  call dix_message(control,dix_msg_seanotf)
	  if(control.mode .eq. mode_interactive) goto 90
	  goto 10
	end if
	if(control.control_c_seen) then
	  call dix_message(control,dix_msg_ctrlcseen)
	  if(control.mode .eq. mode_interactive) goto 90
	  goto 10
	end if
c
	found_it = dix_main_string_found(file.data,sear1(1:nkar1),0,0)	
c
	nrec = nrec + 1
	if(found_it .or. (mod(nrec,5) .eq. 1)) then
	  if(control.mode .eq. mode_interactive) then
	    write(*,1001) kar,nrec
1001	    format(a,'Reading record ',i6)
	    kar = '+'
	  else
	    write(temp,1000) nrec
1000	    format(i6)
	    call smg$put_chars(dis_ch,temp(1:6),3,17)
	  end if
	end if
	if(.not. found_it) goto 40
c
90	if(control.mode .ne. mode_interactive) then
	  call smg$delete_virtual_display(dis_ch)
	endif
	return
	end
	function dix_main_string_found(data,sear,seapos,seasiz)
	implicit none
c
c Try to locate a sub string in a (part of a) string
c
	include 'dix_def.inc'
	record /data_info/ data		!:i: the data record
	character*(*) sear		!:i: the search string
	integer*4 seapos		!:i: the begin position
	integer*4 seasiz		!:i: the size
	logical*4 dix_main_string_found	!:f: the result
c#
	integer*4 des(2),istat,pos,nb
c
	logical*4 dix_util_find_string_wild
c
c Sourc for upcase is the data record
c
	des(1) = data.nb_data
	des(2) = %loc(data.data_rec)
c
c Apply the substring part
c
	istat = 0
	if(seapos .gt. 0) then
	  if(seapos .gt. data.nb_data) goto 90
	  des(2) = des(2) + seapos - 1
c
	  if(seapos + seasiz .gt. data.nb_data) then
	    des(1) = data.nb_data-seapos + 1
	  else
	    des(1) = seasiz
	  endif
	endif
c
c  Let dix_util_find_string_wild find it (not unix style yet)
c
	pos = dix_util_find_string_wild(des,sear,nb,.false.,.false.)
	istat = pos .gt. 0
90	dix_main_string_found = istat

	return
	end
	subroutine dix_main_sel_files(control,batch,file_mask)
	implicit none
c
c Let the user select a file from the file list
c or display a list of file
c File mask can be
c 1: blank : display all files, and let user select one
c 2: #     : Display all files
c 3: ##    : Display all files with full file info
c 4: Other : A file mask for the filename(wildcard) or the handle(equal)
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	logical*4 batch			!:i: are we in batch mode
	character*(*) file_mask         !:i: file mask
c#
	record /file_info/ file
	pointer (p_file,file)
c
	logical*4 dix_util_get_nr
	logical str$match_wild
	integer*4 dix_util_get_len
	logical dix_write_console
c
	integer*4 k,width,nk,nk_fil,nk_h,nk_c,nk_s,nk_e
	character*(max_short_line_length) extra
	character*(max_screen_width) line,hline
	character kar
c
	external dix_msg_nofilmat
c
	if(file_mask .ne. ' ' .and. file_mask(1:1) .ne. '#') then
c
c case 4 : general file mask
c
	  p_file = control.top_file
	  nk_fil = dix_util_get_len(file_mask)
	  do k=1,control.n_file
	    if(file.handle .eq. file_mask .or. 
     1         str$match_wild(file.fnam(1:file.nk_fnam),file_mask)) then
	      control.cur_file = p_file
	      goto 90
	    endif
	    p_file = file.link.forw
	  end do
	  call dix_message(control,dix_msg_nofilmat,file_mask(1:nk_fil))
	else
c
c Either show all files (possibly full)
c or select a file
c First compute the length of vairous parts
c
	  p_file = control.top_file
	  nk_h = 3 	!max handle size
	  nk_s = 4      !max filesize size
	  do while(p_file .ne. 0)	
	    nk = file.nk_handle
	    if(nk .gt. nk_h) nk_h = nk
	    call sys$fao('!UL',k,line,%val(file.filesize))
	    if(k .gt. nk_s) nk_s = k
	    p_file = file.link.forw
	  end do
	  p_file = control.top_file
c
c Now compute the size of the count field
c
	  call sys$fao('!UL',nk_c,line,%val(control.n_file))
c
c Now print the line
c the format is
c Tcc:hh filexx ss
c T  = current         1 char
c cc = count field, nk_c char
c hh = handle       nk_h char
c xx = flags        nk_e char
c ss = size of file nk_s char
c so the size remaining for the file is
c  width - 1 - nk_c-1-nk_h-1-hk_e-1-nk_s
c
	  width = control.ncols-1 -nk_c-1 -nk_h-1 - 1- nk_s
	  kar = 'C'
	  line = 'Filename'
	  line(width-6:width) = 'Flag(s)'
	  call sys$fao('!AS!#AS:!#AS !AS !#AS',nk,hline,
     1         kar,%val(nk_c),%descr(' '),
     1         %val(nk_h),%descr('TAG'),
     1         line(1:width),
     1         %val(nk_s),%descr('Size'))
	  if(.not. dix_write_console(control,hline(1:nk))) goto 90
	  do k=1,control.n_file
	    extra = 'SEQ'
	    if(file.relative) extra = 'REL'
	    if(file.indexed ) extra = 'IDX'
	    nk_e = 3
	    if(file.fixed)  call dix_append(nk_e,extra,'/FIX')
	    if(file.modify) call dix_append(nk_e,extra,'/MOD')
	    width = control.ncols-1-nk_c-1 -nk_h-1 -nk_e-1 -nk_s
	    call lib$trim_filespec(file.fnam(1:file.nk_fnam),line,width,nk)
	    line(nk+1:) = ' '
	    kar = ' '
	    if(p_file .eq. control.cur_file) kar = '*'
	    call sys$fao('!AS!#UL:!AS !AS !#UL',nk,hline,
     1         kar,%val(nk_c),%val(k),
     1         file.handle(1:nk_h),
     1         line(1:width)//extra(1:nk_e),
     1         %val(nk_s),%val(file.filesize))
	    if(.not. dix_write_console(control,hline(1:nk))) goto 90
c
	    if(file_mask(1:2) .eq. '##') then
              call dix_rms_file_info(control,
     1              file.fnam(1:file.nk_fnam),
     1              %val(file.rabadr),%val(0))
	    endif
	    p_file = file.link.forw
	  end do
	  call sys$fao('* means the current file',nk,hline)
	  if(.not. dix_write_console(control,hline(1:nk))) goto 90
c
	  if(.not. batch .and. file_mask(1:1) .ne. '#') then
c
c Let the user select one
c
	    if(dix_util_get_nr(control.n_file,k)) then
c
c User did select file by number
c
	      p_file = control.top_file
	      do while(k .gt. 1)
	        k = k - 1
	        p_file = file.link.forw
	      end do
	      control.cur_file = p_file
	    endif
	  endif
	endif
90	return
	end
	function dix_main_get_files(control,label,raw_mode,
     1                     deffile,handle,logit)
	implicit none
c
c Open one or more files, and attach the .DES reords to it(them)
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) label	!:i: the label for cli$get_value
	logical raw_mode	!:i: raw mode?
	character*(*) deffile	!:i: the default file spec
	character*(*) handle	!:i: the tag to give to the file
	logical logit		!:i: signal file opens?
	logical dix_main_get_files	!:f: return true if a file opened
c#
	record /file_info/ file
	pointer (p_file  ,file)
c
	integer*4 nk_fnam,block_size,nk_fnam_d,context,nfnd,nk
	integer*4 temp_lun
c
	logical modify,got,got_file
	character*(max_filename_length) fnam,fnam_d
	character*(max_line_length) line
	character mod_flag,blk_flag
c
	logical cli$get_value
	logical cli$present
	logical lib$find_file
	logical dix_des_get_all
	logical memtab_read
	integer*4 dix_util_get_len
	logical dix_rms_open
	external dix_msg_filnotf
	external dix_msg_nomatch
	external dix_msg_filopen
c
c Since the processing of the descriptions takes dcl_parse
c we need to get the file/des info before we go process them
c	
	got_file = %loc(dix_msg_filnotf)
	call memtab_init(temp_lun,'filenames')
	do while(cli$get_value(label,fnam,nk_fnam))
	  mod_flag = 'N'
	  if(cli$present('modify')) mod_flag = 'Y'
	  block_size = 0
	  if(cli$present('BLOCKED')) then
	    call util_cli_get_number('BLOCKED',0,block_size)
	    block_size = min(63,max(1,block_size))
	  endif
	  blk_flag = char(block_size)
c
c  Add file filename
c
	  call memtab_add_record(temp_lun,
     1            'F'//mod_flag//blk_flag//fnam(1:nk_fnam))
	  do while(cli$get_value('DESCRIPTION',fnam,nk_fnam))
c
c Add desciption file name
c
	    call memtab_add_record(temp_lun,'D'//fnam(1:nk_fnam))	  	  
	  end do
c
c Signal end record
c
	  call memtab_add_record(temp_lun,'E')
	end do
	call memtab_rewind(temp_lun)
c
c Now process all lines from temp_lun
c
10	do while(memtab_read(temp_lun,nk,line))
	  if(line(1:1) .ne. 'F') goto 10
c
	  nfnd = control.n_file
c
c check if wildcards found, See if more than one file specified
c
	  fnam = line(4:)
	  nk_fnam = nk - 3
	  modify = line(2:2) .eq. 'Y'
	  block_size = ichar(line(3:3))
c
c Got a filename
c 
	  context = 0
	  do while(lib$find_file(fnam(1:nk_fnam),line,context,deffile))
C##
	    call get_vm(sizeof(file),p_file,control.zone_file)
c
c Init data
c
	    file.modify     = modify
	    file.block_size = block_size
	    file.fnam       = line
	    file.nk_fnam    = dix_util_get_len(line)
	    call dix_main_make_tag(control,file.handle,handle,line)
	    file.nk_handle  = dix_util_get_len(file.handle)
	    file.top_des    = 0
	    file.cur_des    = 0
	    file.cur_key    = 0
	    file.rec_nr     = 0
	    file.fabadr     = 0
	    file.rabadr     = 0
	    file.fabmod     = 0
	    file.rabmod     = 0
	    file.raw        = raw_mode
	    file.got_record = .false.
	    file.data.nb_data= 0
c
c If opening is requested, open it
c
	    if(.not. dix_rms_open(control,file)) then
	      call free_vm(sizeof(file),p_file,control.zone_file)
	    else
c
	      if(logit)  call dix_message(control,dix_msg_filopen,
     1               file.fnam(1:file.nk_fnam))
	      got_file = 1
c
c Link in
c
	      call dix_util_link_in(file.link,control.top_file)
	      control.n_file = control.n_file + 1
c
c Gather all des files for this filename
c
	      if(file.block_size .eq. 0) then
c
c Get all descriptions
c
	        got = .false.
15	        call memtab_read(temp_lun,nk,line)
	        if(line(1:1) .eq. 'D') then 
	          fnam_d = line(2:nk)
	          nk_fnam_d = nk - 1
c
c And all via the extra /description items
c
	          if(dix_des_get_all(control,file,fnam_d(1:nk_fnam_d),
     1                            .false.)) then
	            got = .true.
	          else
	            call dix_message(control,dix_msg_nomatch,
     1                       fnam_d(1:nk_fnam_d))
	          endif
	          goto 15
	        end if
	        if(.not. got) then
	          call dix_des_get_all(control,file,' ',.false.,.false.)
	        endif
	      end if		!blocksize .eq. 0
c
	      call dix_rms_rewind(control,file,-1)
	      call dix_rms_get(control,file)
	      call dix_des_check_expand_all(control,file)
	    endif		!open successful
C##
	  end do		!try the next file of the find_file
	  call lib$find_file_end(context)
	  if(nfnd .eq. control.n_file) then
	    call dix_message(control,dix_msg_filnotf,fnam(1:nk_fnam))
	  endif
	end do			!get the next filename
c
	call memtab_close(temp_lun)
	dix_main_get_files = got_file
	return
	end
	subroutine dix_main_make_tag(control,file_handle,handle,fnam)
	implicit none
c
c Make a (unique) tag from the filename
c If no tag given, take the body of the file
c
	include 'dix_def.inc'
	record /control/ control		!:i: control structure
	character*(*) file_handle		!:o: file handle result
	character*(*) handle			!:i: user given name
	character*(*) fnam			!:i: filename
c#
	character*(max_short_line_length) sernr
	integer*4 nk_w,nk1,icnt,bpos,epos
c
	record /file_info/ file
	pointer (p_file,file)
c
	integer*4 dix_util_get_len
c
c Make a unique handle
c
	if(handle .eq. ' ') then
c
c Take body of file
c
          call dix_util_file_parse(fnam,'N',bpos,epos)
	  file_handle = fnam(bpos:epos)
	else
	  file_handle = handle 		!take user defined part
	endif
	nk_w = dix_util_get_len(file_handle)
c
c See if no duplicate found
c
	icnt = 0
10	p_file = control.top_file
	do while(p_file .ne. 0) 
	  if(file.handle .eq. file_handle) then
c
c Yes we have a duplicate, append _nn and try again
c
	    icnt = icnt + 1
	    call sys$fao('_!UL',nk1,sernr,%val(icnt))	    
c
c See if it fits, if not skip last chars for WERK
c
	    if(nk_w + nk1 .gt. len(file_handle)) nk_w = len(file_handle) - nk1
c
c Append _idx and retry for uniqueness
c
	    file_handle(nk_w+1:nk_w+nk1) = sernr(1:nk1)
	    goto 10
	  endif
	  p_file = file.link.forw
	end do
c
	return
	end
	subroutine dix_main_close_files(control,file_mask,log_it)
	implicit none
c
c Close one or more files
c if mask is empty : the current file, and switch to the first
c if mask is filled: Close the file(s) that matches the mask 
c                    with the name(wildcard) or the mask (equal)
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	character*(*) file_mask		!:i: filename(handle) mask
	logical*4 log_it		!:i: log the closing?
c#
	record /file_info/ file
	pointer (p_file,file)
c
	integer*4 save_ptr,nk,nclos
c
	logical str$match_wild
	external dix_msg_fileclose
	external dix_msg_nofilmat
c
	nclos = 0
	if(file_mask .eq. ' ') then
c
c Close the current file
c
	  p_file = control.cur_file
	  if(p_file .ne. 0) then
	    if(log_it) then
	      nk = file.nk_handle
	      call dix_message(control,dix_msg_fileclose,
     1          file.fnam(1:file.nk_fnam),
     1          file.handle(1:nk))
	    endif
	    nclos = nclos + 1
	    call file_close(control,file)
	    call dix_util_link_out(file.link,control.top_file)	  
	    call free_vm(sizeof(file),p_file,control.zone_file)
	    control.n_file = control.n_file - 1
	    control.cur_file = control.top_file
	  endif
	else
c
c Close some files matching either name or tag
c
	  p_file = control.top_file
          do while(p_file .ne. 0) 
	    if(file.handle .eq. file_mask .or. 
     1         str$match_wild(file.fnam(1:file.nk_fnam),file_mask)) then
	      if(%loc(file) .eq. control.cur_file) control.cur_file = 0
	      if(log_it) then
	        nk = file.nk_handle
	        call dix_message(control,dix_msg_fileclose,
     1            file.fnam(1:file.nk_fnam),
     1            file.handle(1:nk))
	      endif
	      nclos = nclos + 1
	      call file_close(control,file)
	      save_ptr = file.link.forw
	      call dix_util_link_out(file.link,control.top_file)	  
	      call free_vm(sizeof(file),p_file,control.zone_file)
	      control.n_file = control.n_file - 1
	      p_file = save_ptr
	    else
	      p_file = file.link.forw
	    endif
	  end do
	  if(control.cur_file .eq. 0) control.cur_file = control.top_file	
	  if(nclos .eq. 0) call dix_message(control,dix_msg_nofilmat,
     1                               file_mask)
	endif
	return
	end
	subroutine file_close(control,file)
	implicit none
c
c Close a file, and return all des info to memory
c
	include 'dix_def.inc'
	record /control  / control	!:io: control structure
	record /file_info/ file		!:io: file control block
c#
	integer*4 k
	record /des_expanded/ des_expanded
	pointer (p_des_expanded, des_expanded)

	p_des_expanded = file.top_des
	do while(p_des_expanded .ne. 0)
	  k = des_expanded.link.forw
	  call dix_des_link_out(control,file,des_expanded)
	  p_des_expanded = k
	end do
	call dix_rms_close(control,file)
	return
	end
	function dix_help_rout(control)
	implicit none
c
c Easy interfase to the help function
c
	include 'dix_def.inc'
	record /control/ control	!:i: control block
	integer*4 dix_help_rout		!:f: fcuntion result
c#
	character*(max_line_length) line
	integer*4 nk
c
	call cli$get_value('p1',line,nk)
	call dix_help('DIX '//line(1:nk))
	control.mode = mode_none
	dix_help_rout = 1
	return
	end
	function dix_mode_interactive(control)
	implicit none
c
c SMG call for interactive mode
c set control fields for interactive mode
c
	include 'dix_def.inc'
	record /control/ control	!:io: control structure
	integer*4 dix_mode_interactive	!:f: function result
c#
	character*(max_line_length) line,value,err
	integer*4 nkar,ipos,ival,nk_val,istat
	logical cli$get_value
	logical dix_con_i4
	integer*4 dix_util_check_name
c
	call cli$get_value('output',control.fnam_out,control.nk_fnam_out)
	call cli$get_value('p2',line,nkar)
	if(nkar .eq. 0) then
	  call cli$get_value('script',line,nkar)
	  if(nkar .gt. 0) then
	    line = '@'//line(1:nkar)
	    nkar = nkar + 1
	  endif
	endif
	control.nk_script_file = nkar
	control.script_file = line(1:nkar)
	control.mode = mode_interactive
c
	call dix_symbol_add_int(control,'$NRARGS',0,err)
c
	call dix_main_get_strict(control.strict_mode)
	do while(cli$get_value('define',line,nkar))
	  ipos = index(line(1:nkar),'=')
	  if(ipos .ne. 0) then
c
c Ad string parameter
c
	    value = line(ipos+1:nkar)
	    nk_val = nkar-ipos
	    nkar = ipos-1
	    istat = dix_util_check_name(line(1:nkar))
	    if(.not. istat)then
	      call dix_message(control,%val(istat),line(1:nkar))
	    else
	      if(dix_con_i4(value,nk_val,ival,.false.,
     1                       control,.true.)) then
	        call dix_symbol_add_int(control,line(1:nkar),ival,err)
	      else
	        call dix_symbol_add_str(control,line(1:nkar),
     1                  value(1:nk_val),err)
	      endif
	    endif
	  else
c
c Add string parameter
c
	    istat = dix_util_check_name(line(1:nkar))
	    if(.not. istat)then
	      call dix_message(control,%val(istat),line(1:nkar))
	    else
	      call dix_symbol_add_int(control,line(1:nkar),1,err)
	    endif
	  endif
	end do
	dix_mode_interactive = 1
	return
	end
	function dix_mode_info(control)
	implicit none
c
cSMG call for INFO mode
c set control block fields for info mode
c
	include 'dix_def.inc'
	record /control/ control	!:o: control block
	integer*4 dix_mode_info		!:f: function result
c#
	integer*4 cli$present
c
	call cli$get_value('output',control.fnam_out,control.nk_fnam_out)
	control.wide = cli$present('WIDE')
	control.mode = mode_info
	dix_mode_info = 1
	return
	end
	subroutine dix_main_get_strict(strict)
	implicit none
	include 'dix_def.inc'
c
c Set the strict mode flag
c
	integer*4 strict	!:i: mode flags
c#
	logical cli$present
c
	strict = 0
	if(cli$present('STRICT.typing')) strict = strict + strict_typing
	if(cli$present('STRICT.declaration')) 
     1    strict = strict + strict_declaration
	if(cli$present('STRICT.local')) 
     1    strict = strict+strict_declaration+strict_declaration_local
	return
	end
c
	function dix_mode_file(control)
	implicit none
c
c CLD routine for dix/file
c Set control fields for file mode
c
	include 'dix_def.inc'
	record /control/ control	!:io: control structure
	integer*4 dix_mode_file
c#
	logical cli$present
	external dix_msg_illwpos
	external dix_msg_illwsiz
c
c Get qualifiers for file_mode
c
	dix_mode_file = 0		!assume problems
c
	call cli$get_value('output',control.fnam_out,control.nk_fnam_out)
	call cli$get_value('symbol',control.symbol  ,control.nk_symb)
	call dix_main_get_list('SEARCH',control.lun_search)
	call dix_main_get_list('SELECT',control.lun_select)
c
	if(control.lun_search .gt. 0) then
	  call util_cli_get_number('window.position',0,control.seapos)
	  if(control.seapos .lt. 0) then
	    call dix_message(control,dix_msg_illwpos,%val(control.seapos))
	    goto 90
	  endif
	  call util_cli_get_number('window.size',0,control.seasiz)
	  if(control.seasiz .lt. 0) then
	    call dix_message(control,dix_msg_illwsiz,%val(control.seasiz))
	    goto 90
	  endif
	  if(control.seasiz.gt.0 .and. control.seapos.eq.0) control.seapos = 1
	  if(control.seapos.gt.0 .and. control.seasiz.eq.0) control.seasiz = 1
	endif
	call util_cli_get_number('count',0,control.count)
c
	control.wide = cli$present('WIDE')
	control.mode = mode_file
c
c Check for the dsiplay portions
c
	if(cli$present('display')) then
	  control.display_data  = cli$present('display.data') .or.
     1                            cli$present('display.all')
	  control.display_vfc   = cli$present('display.vfc') .or.
     1                            cli$present('display.all')
	  control.display_recnr = cli$present('display.recnr') .or.
     1                            cli$present('display.all')
	  control.display_recsiz= cli$present('display.recsize') .or.
     1                            cli$present('display.all')
	else
	  control.display_recnr  = .true.
	  control.display_recsiz = .true.
	  control.display_data   = .true.
	  control.display_vfc    = .false.
	end if
c
	dix_mode_file = 1		!all oke
c
90	return
	end
	function dix_mode_screen(control)
	implicit none
c
c CLD entry for mode screen
c set control fields for mode SCREEN
c
	include 'dix_def.inc'
	record /control/ control	!:o: control block
	integer*4 dix_mode_screen
c#
	control.fnam_out = 'SYS$OUTPUT'
	control.nk_fnam_out = 11
	control.mode = mode_screen
	dix_mode_screen = 1
	return
	end
	subroutine get_pasteboard(control)
	implicit none
c
C Get pastboard id for SMG
c
	include 'dix_def.inc'
	record /control/ control	!:io: control block
c#
	integer*4 termtype
	include '($smgdef)'
	external dix_msg_noscreen
c
	integer*4 flags
c
c Mode was screen, this is only possible on a (vt-) terminal
c screen is default, so we must check if it is possible, if not switch
c to interactive
c
c sys$input is a terminal, so now depending on the /screen qualifier (default)
c the mode is either screen or interactive
c Try to create a paste_board, and see if terminal supports vt
c
	flags = smg$m_keep_contents
	call smg$create_pasteboard(control.paste_id,,control.nrows,
     1               control.ncols,flags,termtype)
	if(termtype .ne. smg$k_vttermtable) then
	  control.mode = mode_interactive
	  call dix_message(control,dix_msg_noscreen)
	else
	  control.got_pasteboard = .true.
        endif
	return
	end
	function dix_main_select_file(control)
	implicit none
c
c If the user entered a file mask with multiple matches and he did
c not enter /MULTI, let him select one of the files
c
	include 'dix_def.inc'
	record /control/ control	!:io: control structure
	logical dix_main_select_file
c#
	include '($smgdef)'
c
c Found n_file files, if wild than all ok, start with the first
c else ask for correct file
c
	record /file_info/ file
	pointer (p_file  ,file)
c
	character*(max_line_length) line
	integer*4 nk,temp_file_p,i_file,k,width,dis_id
	integer*4 view_rows,top_row,ikey
c
c
	record /dyn_help/ help_des
c
	width = control.ncols - 4
	dix_main_select_file = .false.
	i_file = 0
	p_file = control.top_file
	if(control.mode .eq. mode_screen) then
	  call smg$create_virtual_display(control.n_file,width,dis_id)
	  call smg$label_border(dis_id,'Select file')
	  call help_init_std(control,help_des,'File selection',20,14)
	  call help_key(control.key_table,help_des,key_exit,
     1                 'Abort selection and exit')
	  call help_key(control.key_table,help_des,key_enter,
     1                 'Select this file')
	  call dix_smg_stack_help(control,help_des)
	endif
c
	do while (p_file .ne. 0)
c
c Let user signal which file
c tell him which files found
c
	  i_file = i_file + 1
	  if(control.mode .eq. mode_screen) then
	    if(i_file .eq. 1) call smg$put_chars(dis_id,'*',1,1)
	    write(line,1001) i_file
1001	    format(i4) 
	    call smg$put_chars(dis_id,line(1:4),i_file,3)
	    call lib$trim_filespec(file.fnam(1:file.nk_fnam),line,
     1             width-7,nk)
	    call smg$put_chars(dis_id,line(1:nk),i_file,8)
	  else
	    write(*,1004) i_file,file.fnam(1:file.nk_fnam)
1004	    format(i4,':',a)
	  endif
c
	  p_file = file.link.forw
	end do
c
c Let the user select
c
	if(control.mode .eq. mode_screen) then
	  top_row = 1
	  view_rows = min(control.n_file,20)
	  call smg$create_viewport(dis_id,1,1,view_rows,width)
	  call smg$paste_virtual_display(dis_id,control.paste_id,3,3)
c
	  i_file = 1
40	  k = max(1,min(k,control.n_file))
c	  
	  if(k .ne. i_file) then
	    call smg$put_chars(dis_id,' ',i_file,1)
	    i_file = k
	    call smg$put_chars(dis_id,'*',i_file,1)
	  endif
c
c Make sure line in view
c
	  do while(i_file-top_row .ge. view_rows) 
	    top_row = top_row + 1
	    call smg$scroll_viewport(dis_id,smg$m_up,1)
	  enddo
	  do while(i_file .lt. top_row) 
	    call smg$scroll_viewport(dis_id,smg$m_down,1)
	    top_row = top_row - 1
	  enddo
c
	  call smg$set_cursor_abs(dis_id,i_file,1)
	  call dix_get_key(control,ikey)
	  k = i_file
	  if(ikey .eq. key_up) then
	    k = i_file - 1
	  elseif(ikey .eq. key_down) then
	    k = i_file + 1
	  elseif(ikey .eq. key_top)  then
	    k = 1
	  elseif(ikey .eq. key_down) then
	    k = control.n_file
	  elseif(ikey .eq. key_prev) then
	    k = i_file - 10
	  elseif(ikey .eq. key_next) then
	    k = i_file + 10
	  elseif(ikey .eq. key_help) then
	    call dix_smg_help(control)
	  elseif(ikey .eq. key_exit) then
	    goto 90
	  elseif(ikey .eq. key_enter .or.
     1           ikey .eq. key_select) then
	    goto 80
	  else
	    call dix_mes_invkey(control)
	  endif
	  goto 40
	else
	  call sys$fao('$Found !UL files, select one :',
     1             nk,line,%val(control.n_file))
	  i_file = 0
	  do while(i_file .lt. 1 .or. i_file .gt. control.n_file)
	    write(*,1005) line(1:nk)
1005	    format(a)
	    read(*,2005,err=90,end=90) i_file
2005	    format(i6)
5	  end do
	endif
c
c We got one, so now remove all others and return memory
c
80	p_file = control.top_file
	do k=1,control.n_file
	  if(k .eq. i_file) then
	    control.top_file = p_file
	  else
	    temp_file_p = file.link.forw
	    call file_close(control,file)
	    call dix_util_link_out(file.link,control.top_file)	  
	    call free_vm(sizeof(file),p_file,control.zone_file)
	    control.n_file = control.n_file - 1
	    p_file = temp_file_p
	  end if
	end do
	p_file = control.top_file
	file.link.forw = 0
	file.link.backw = 0
	control.n_file = 1
	dix_main_select_file = .true.
90	if(control.mode .eq. mode_screen) then
	  call help_exit(help_des)
	  call dix_smg_unstack_help(control)
	  call smg$delete_virtual_display(dis_id)
	endif
	return
	end
	function dix_write_file(control,line)
	implicit none
c
c Write to file mode
c
	include 'dix_interactive.inc'
	record /control/ control	!:io: control block
	character*(*) line		!:1: the line to write
	integer dix_write_file		!:f: function result
c#
	character kar
	integer*4 pagsiz,lun_out,bpos,istat
c
	external rms$_eof
	integer*4 memtab_add_record
c
	control.linenr = control.linenr + 1
c
	if(control.smg_window .ne. 0) then
	  istat = memtab_add_record(control.smg_window,line)
	else
	  if(control.mode .eq. mode_interactive) then
c
c Interactive mode. check for paged 
c
	    pagsiz = 0
	    if(control.paged .eq. 1) pagsiz = control.nrows
            if(pagsiz .gt. 0) then
              if(mod(control.linenr,pagsiz-1) .eq. 0) then
                write(*,1001,err=80)
1001            format('$Type return to continue:')
                read(*,2000,end=70,err=80) kar
2000            format(a)
              endif
            endif
	    call dix_inter_get_file_level_info(control,'LU',lun_out,kar)
	  else
c
c Non interactive, keep gooing
c
	    lun_out = control.lun_out
	  endif
          if(line(1:1) .eq. ':') then
	    bpos = 2
          else
	    bpos = 1
          end if
          if(lun_out .ne. 0) write(lun_out,1000,err=80) line(bpos:)
1000      format(a)
	  istat = 1
	endif
	goto 90
70	istat = %loc(rms$_eof)
	goto 90
80	call errsns(,istat)
	goto 90
90	dix_write_file = istat
	return
	end  
	function dix_main_check_mod_record(control,file)
	implicit none
c
c Checks if the buffer has changed, and if so 
c  if the user wants to write it out
c In batch mode always update
c
	include 'dix_def.inc'
	record /control/ control		!:i: control block
	record /file_info/ file			!:i: file structure
	integer*4 dix_main_check_mod_record	!:f: function result
c#
	logical dix_dump_record_changed
	logical dix_main_question
	external dix_msg_recchang
	integer*4 dix_rms_update
c
	character*(max_line_length) line,question
	integer*4 nk,nk_q,bpos,epos,istat
	logical*4 do_update
c

	istat = 1
	if(file.modify) then
	  if(file.got_record) then
            if(dix_dump_record_changed(file.data)) then
	      if(control.is_term) then
	        call dix_main_get_message(control,dix_msg_recchang,nk,line)
	        call dix_util_file_parse(file.fnam,'N',bpos,epos)
	        call sys$fao(line(1:nk),nk_q,question,file.fnam(bpos:epos))
	        do_update = dix_main_question(control,question(1:nk_q),.true.)
	      else
	        do_update = .true.		!batch mode
	      endif
	      if(do_update) then
                istat = dix_rms_update(control,file,.true.)
              endif       !question to Y or batch
	    endif         !changed
	  endif		!got record
        endif		!in modify
	dix_main_check_mod_record = istat
	return
	end
	function dix_main_question(control,question,def_answer)
	implicit none
c
c Ask a (yes/no) question and get an answer. Possibly with a default
c
	include 'dix_def.inc'
c
	record /control/ control        !:i: control block
	character*(*) question		!:i: the question
	logical def_answer		!:i: answer in batch mode
	logical dix_main_question	!:f: the answer
c#
	logical answer
	character kar
c
	logical dix_smg_question
	character dix_util_upcase_kar
c
	if(control.mode .eq. mode_Screen) then
c
c Screen mode
c
	  answer = dix_smg_question(control,question,def_answer)
	else
c
c Text mode
c
	  if(control.is_term) then
20	    if(def_answer) then
	      write(*,1080) question
1080          format('$',a,' ([y]/n):')
	    else
	      write(*,1081) question
1081          format('$',a,' (y/[n]):')
	    endif
            read(*,2000,end=20) kar
2000	    format(a)
	    if(kar .eq. ' ') then
	      kar = 'N'
	      if(def_answer) kar = 'Y'
	    endif	    
	    kar = dix_util_upcase_kar(kar) 
	    if(kar .ne. 'Y' .and. kar .ne. 'N') goto 20
	    answer = kar .eq. 'Y'
	  else
	    answer = def_answer
	  endif
	endif
	dix_main_question = answer
	return
	end
	function dix_main_check_library(line,libnam,nk_lib,may_update,defdir)
	implicit none
c
c Check if a library can be opened
c
	character*(*) line	!:i: the name
	character*(*) libnam 	!:o: the name
	integer*4 nk_lib	!:o: length of libnam
	logical may_update	!:o: updates allowed?
	character*(*) defdir	!:i: default directory
	logical dix_main_check_library	!:f: function result
c#
	include '($lbrdef)'
c
	integer*4 lbr_index
	integer*4 lbr$open
c
	character*(*) deftype
	parameter (deftype = '.TLB')
c
	if(line .eq. ' ') then
	  nk_lib = 0
	else
	  call lbr$ini_control(lbr_index,lbr$c_update,lbr$c_typ_txt)
	  if(lbr$open(lbr_index,line,,defdir//deftype,,libnam,nk_lib)) then
	    call lbr$close(lbr_index)
	    may_update = .true.
	  else
	    call lbr$ini_control(lbr_index,lbr$c_read,lbr$c_typ_txt)
	    if(lbr$open(lbr_index,line,,defdir//deftype,,libnam,nk_lib)) then
	      call lbr$close(lbr_index)
	    else
	      nk_lib = 0
	    endif
	  endif
	endif
	dix_main_check_library = nk_lib .gt. 0
	return
	end
	function dix_main_get_record(control,file,key,keyopt,
     1          keyval,translate_percent)
	implicit none
c
c Get a record from a file
c
	include 'dix_def.inc'
	record /control/ control	!:i: control structure
	record /file_info/ file		!:io: file structure
	integer*4 key			!:i: key number
	integer*4 keyopt		!:i: key option eq,ge,gt
	character*(*) keyval		!:i: key value
	logical translate_percent	!:i: translate %dd to hex char??
	integer*4 dix_main_get_record	!:f: function result
c#
	integer*4 istat
c
	integer*4 dix_main_get_rec
	integer*4 dix_rms_get
	integer*4 dix_main_get_rec_keyed
c
	if(keyopt .eq. 0) then
c
c sequential read, wit or without record number
c
	  if(len(keyval) .gt. 0) then
c
c We did specify a record number
c
	    istat = dix_main_get_rec(control,file,keyval)
	  else
c
c No , so just sequential read
c
	    istat = dix_rms_get(control,file)
	  endif
	else
c
c Indexed, so go to keyed routine
c
	  file.cur_key = key
	  istat = dix_main_get_rec_keyed(control,file,
     1            key,keyval,len(keyval),keyopt-1,
     1            translate_percent)
	end if
	dix_main_get_record = istat
	return
	end
	subroutine dix_main_get_list(item,lun)
	implicit none
c
	include 'dix_def.inc'
c
cBuild a list of cli items in a MEMTAB file
c
	character*(*) item	!:i: cli name
	integer*4 lun		!:o: lun for memtab (0=no list)
c
	character*(max_line_length) line
	integer*4 nk
	integer*4 cli$get_value
c
	lun = 0
	do while(cli$get_value(item,line,nk))
	  if(lun .eq. 0) call memtab_init(lun,'LIST_'//item)
	  call str$upcase(line(1:nk),line(1:nk))
	  call memtab_add_record(lun,line(1:nk))
	end do	
	return
	end
	function dcl_parse(control,string,table)
        implicit none
c
	include 'dix_def.inc'
	record /control/ control
        character*(*) string
        integer*4 table
        integer dcl_parse
c
        integer cli$dcl_parse
	external lib$get_input
c
	if(control.platform .eq. platform_ipf) then
          dcl_parse = cli$dcl_parse(string,%val(table),
     1          lib$get_input,lib$get_input,'Dix>')
	else
          dcl_parse = cli$dcl_parse(string,table,
     1          lib$get_input,lib$get_input,'Dix>')
	endif
        return
        end
