	subroutine dix_rms_close(control,file)
	implicit none
c
	include 'dix_def.inc'
	include '($fabdef)'
	include '($rabdef)'
	record /control/ control
	record /file_info/ file
c
	integer*4 istat
	integer*4 sys$close
c
	record /rabdef/ rab
	pointer (p_rab,rab)
	record /fabdef/ fab
	pointer (p_fab,fab)
c
	call dix_main_check_mod_record(control,file)
c
	if(file.fabadr .ne. 0) then
	  p_fab = file.fabadr
	  istat = sys$close(fab)
	  if(.not. istat) call dix_message(control,%val(istat))
	  call free_vm(sizeof(fab),p_fab,control.zone_file)
	  p_rab = file.rabadr          
	  call free_vm(sizeof(rab),p_rab,control.zone_file)
	endif
	if(file.fabmod .ne. 0) then
	  p_fab = file.fabmod
	  istat = sys$close(fab)
	  if(.not. istat) call dix_message(control,%val(istat))
	  call free_vm(sizeof(fab),p_fab,control.zone_file)
	  p_rab = file.rabmod
	  call free_vm(sizeof(rab),p_rab,control.zone_file)
	endif
	return
	end
	function dix_rms_rewind(control,file,key)
	implicit none
c
c
	include '($rabdef)'
	include 'dix_def.inc'
c
	integer*4 control
	record /file_info/ file
	integer*4 key
	logical*4 dix_rms_rewind
c
	record /rabdef/ rab
	pointer (p_rab,rab)
c
	integer*4 sys$rewind,istat
c
	p_rab = file.rabadr
	if(key .ge. 0) rab.rab$b_krf = key
	rab.rab$l_rop = 0
c
	istat = control		!to prevent comiler messages
	rab.rab$l_bkt = 0
	istat = sys$rewind(rab,,)
	file.rec_nr       = 0
	if(key .ge. 0) file.cur_key = key
	file.got_record   = .false.
	file.rewound      = .true.
	file.data.nb_data = 0
	file.data.nb_sav  = 0
	dix_rms_rewind    = istat
	return
	end

	subroutine dix_rms_get_reclen(rab,minrecl,maxrecl,nkey)
	implicit none
c
	include '($rabdef)'
	record /rabdef/ rab
	integer*4 minrecl
	integer*4 maxrecl
	integer*4 nkey
c
	call dix_rms_get_reclen_fab(%val(rab.rab$l_fab),minrecl,maxrecl,nkey)
	return
	end

	subroutine dix_rms_get_reclen_fab(fab,minrecl,maxrecl,nkey)
	implicit none
c
	include '($fabdef)'
	record /fabdef/ fab
	integer*4 minrecl
	integer*4 maxrecl
	integer*4 nkey
c
	include '($xabkeydef)'
	record /xabkeydef/ xab
	include '($xabsumdef)'
	record /xabsumdef/ xabsum
c
	maxrecl = fab.fab$w_mrs
	if(fab.fab$b_org .ne. fab$c_idx) then
	  minrecl = 0
	  nkey = 0
	else
c
c Make xab key
c
	  call dix_rms_fill_xab(fab,xab,xab$c_key,xab$k_keylen)
	  minrecl = xab.xab$w_mrl
c
	  call dix_rms_fill_xab(fab,xabsum,xab$c_sum,xab$k_sumlen)
	  nkey = xabsum.xab$b_nok
	end if

	return
	end
	function dix_rms_reget_rfa(control,rab,rfa)
	implicit none
c
c function; reread the record in the current record to rfa
c always to key0
c
	include '($rabdef)'
	include '($rmsdef)'
	integer*4 control
	record /rabdef/ rab
	integer*2 rfa(3)
	logical*4 dix_rms_reget_rfa
c
	integer*4 sys$get
	integer*4 istat,k
c
	byte data
c
c For non indexed file, the get is simply a read /rfa
c
	istat = control		!to prevent unused message
	rab.rab$l_ubf = %loc(data)
	rab.rab$w_usz = 1
	rab.rab$b_rac = rab$c_rfa
	rab.rab$l_kbf = 0
	rab.rab$b_ksz = 0
	rab.rab$l_rop = 0
	do k=1,3
	  rab.rab$w_rfa(k) = rfa(k)
	end do
c
	istat = sys$get(rab,,)
c
c Ignore record too big
c
	if(istat .eq. rms$_rtb) istat = 1
	dix_rms_reget_rfa = istat
	return
	end

	function dix_rms_skip(control,file,nrec)
	implicit none
c
	include '($rabdef)'
	include '($rmsdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
	integer*4 nrec
	logical*4 dix_rms_skip
c
	record /rabdef/ rab
	pointer (p_rab,rab)
c
	real*4 timstart
	logical showed_mes
	byte data(3)
	integer*4 k,istat
c
	integer*4 sys$get
	external dix_msg_skipping
c
c Set filepointer to nth record
c
	p_rab = file.rabadr
c
	showed_mes = .false.
	timstart = secnds(0.0)
c
	call dix_rms_rewind(control,file,-1)
	dix_rms_skip = .true.
	if(nrec .le. 0) goto 90
	rab.rab$l_ubf = %loc(data)
	rab.rab$w_usz = 1
	rab.rab$l_rop = 0
	istat = 1
	do k=1,nrec
	  if(.not. showed_mes) then
	    if(secnds(timstart) .gt. 1.0) then
	      call dix_message(control,dix_msg_skipping,%val(nrec))
	      showed_mes = .true.
	    endif
	  endif	
	  istat = sys$get(rab,,)
	  if(.not. istat) then
	    if(istat .ne. rms$_rtb) then
c
c Error is not record to big, if eof reached change error to record not found
c
	      if(istat .eq. rms$_eof) istat = rms$_rnf
	      goto 90
	    end if
	  end if
	  if(.not. file.indexed .or. file.relative) then
	    file.rec_nr = file.rec_nr + 1
	  endif
	end do
c
90	dix_rms_skip = istat
c
	return
	end

	function dix_rms_get(control,file)
c
	implicit none
c
	include '($rabdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
	logical*4 dix_rms_get
c
	record /rabdef/ rab
	pointer (p_rab,rab)
c
	integer*4 istat
	integer*4 sys$get
	integer*4 sys$read
	external dix_msg_nocurrec
c
	p_rab    = file.rabadr
c
c First check is unmodified data present
c
	if(.not. (file.got_record .or. file.rewound)) then
	  istat = %loc(dix_msg_nocurrec)
	  goto 90
	endif
c	  
	call dix_main_check_mod_record(control,file)
c
c Fill with 0's
c
	call dix_util_fill(0,max_buf,file.data.data_rec)
c
	rab.rab$l_rop = 0
	rab.rab$l_ubf = %loc(file.data.data_rec)
	rab.rab$l_rhb = %loc(file.data.vfc_data)
	if(file.block_size .eq. 0) then
c
c Record io
c
	  rab.rab$b_rac = rab$c_seq
	  rab.rab$w_usz = max_buf
c
c Get the data
c
	  istat = sys$get(rab,,)
	else
c
c Block io
c
	  rab.rab$w_usz = file.block_size*512
	  if(rab.rab$l_bkt .eq. 0) then
	    rab.rab$l_bkt = 1
	  else
	    rab.rab$l_bkt = rab.rab$l_bkt + file.block_size
	  end if
	  istat = sys$read(rab,,)
	end if
	if(.not. istat) then
c
c error; give smone messages, and restore rfa
c
	  file.got_record   = .false.
	  file.data.nb_data = 0
	else
	  call dix_rms_save_rfa_int(rab,file.rec_nr)
	  file.data.nb_data = zext(rab.rab$w_rsz)
	  if(.not. file.indexed .or. file.relative) then
	    file.rec_nr = file.rec_nr + 1
	  endif
	  call dix_dump_copy(file)
	end if
c
90	dix_rms_get = istat
	return
	end

	function dix_rms_get_keyed(control,file,keyopt,nb_key,key,key_nr)
c
	implicit none
c
c try to read on alternate file (to keep record contents)
c if successfull read on normal rab
c
	include '($rabdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
c
	integer*4 keyopt
	integer*4 nb_key
	byte key(*)
	integer*4 key_nr
	logical*4 dix_rms_get_keyed
c
	record /rabdef/ rab
	pointer (p_rab,rab)
	record /rabdef/ rabmod
	pointer (p_rabmod,rabmod)
c
	integer*4 istat,sys$get
c
	p_rab    = file.rabadr
	p_rabmod = file.rabmod
c
c First check is unmodified data present
c
	call dix_main_check_mod_record(control,file)
c
c First  try rabmod
c
	rabmod.rab$l_ubf = %loc(file.data.data_rec)
	rabmod.rab$l_rhb = %loc(file.data.vfc_data)
	rabmod.rab$w_usz = max_buf
	rabmod.rab$b_rac = rab$c_key
	rabmod.rab$l_kbf = %loc(key)
	rabmod.rab$b_krf = key_nr
	rabmod.rab$b_ksz = nb_key
	rabmod.rab$l_rop = 0
	if(keyopt .eq. 1) then
	  rabmod.rab$l_rop = rab$m_eqnxt
	elseif(keyopt .eq. 2) then
	  rabmod.rab$l_rop = rab$m_nxt
	end if
c
c Get the data
c
	istat = sys$get(rabmod,,)
	file.data.nb_data = zext(rabmod.rab$w_rsz)
c
	dix_rms_get_keyed = istat
	if(istat) then
	  call sys$release(rabmod,,)
	  rab.rab$l_ubf = %loc(file.data.data_rec)
	  rab.rab$l_rhb = %loc(file.data.vfc_data)
	  rab.rab$w_usz = max_buf
	  rab.rab$b_rac = rab$c_key
	  rab.rab$l_kbf = %loc(key)
	  rab.rab$b_krf = key_nr
	  rab.rab$b_ksz = nb_key
	  rab.rab$l_rop = 0
	  if(keyopt .eq. 1) then
	    rab.rab$l_rop = rab$m_eqnxt
	  elseif(keyopt .eq. 2) then
	    rab.rab$l_rop = rab$m_nxt
	  end if
c
c Fill with 0's
c
	  call dix_util_fill(0,max_buf,file.data.data_rec)
c
c Get the data
c
	  istat = sys$get(rab,,)
	  if(istat) then
	    call dix_rms_save_rfa_int(rab,0)
	    file.data.nb_data = zext(rab.rab$w_rsz)
	    file.cur_key    = key_nr
	    call dix_dump_copy(file)
	  endif
	end if
	return
	end
	function dix_rms_get_rfa(control,file,key_nr,rfa)
c
	implicit none
c
c try to read on rfa
c
	include '($rabdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
	integer*4 key_nr
	integer*2 rfa(3)
	logical*4 dix_rms_get_rfa
c
	record /rabdef/ rab
	pointer (p_rab,rab)
	record /rabdef/ rabmod
	pointer (p_rabmod,rabmod)
c
c
	integer*4 sys$get
	integer dix_rms_get_keyed
	integer dix_rms_get
c
	integer*4 istat,k,nb_key
	logical*4 string		!:o: true is string key
	integer*4 length		!:o: give length of key
	logical*4 ascending		!:o: true if ascending key
	character*(max_rms_key_name_length) keynam
c
	byte key_data(255)
c
c Make sure no unfinished data left
c
	call dix_main_check_mod_record(control,file)
	p_rab = file.rabadr
	p_rabmod = file.rabmod
c
c First  try rabmod
c
	file.cur_key = key_nr
	rabmod.rab$l_ubf = %loc(file.data.data_rec)
	rabmod.rab$l_rhb = %loc(file.data.vfc_data)
	rabmod.rab$w_usz = max_buf
	rabmod.rab$b_rac = rab$c_rfa
	rabmod.rab$b_krf = 0
	rabmod.rab$l_kbf = 0
	rabmod.rab$b_ksz = 0
	rabmod.rab$l_rop = 0
	do k=1,3
	  rabmod.rab$w_rfa(k) = rfa(k)
	end do
c
c Get the data by read rfa
c this will read the correct record , but for alternate keys
c this will not set the pointer to the next record correct.
c we fake this by recreating the key
c  reading indexed by key, and sequential until the correct rfa is read
c
	istat = sys$get(rabmod,,)
	if(.not. istat) then
	  goto 90
	endif
c
c Release record
c
	call sys$release(rabmod,,)
c
	if(file.indexed .and. key_nr .ne. 0) then
c
c Indexed file, and key<>0, Now rebuild the key from the databuffer
c
	  call dix_rms_keyinfo(file,key_nr,string,length,ascending,keynam)
	  nb_key = 0
	  do k=1,8
	    if(file.keysiz(k) .gt. 0) then
	      call lib$movc3(file.keysiz(k),
     1                       file.data.data_rec(file.keypos(k)+1),
     1                       key_data(nb_key+1))
	      nb_key = nb_key + file.keysiz(k)
	    endif
	  end do
c
c Get key via normal key (and set key_nr right)
c
	  istat = dix_rms_get_keyed(control,file,0,nb_key,key_data,key_nr)
c
c CHeck if the rfa correct
c
12	  if(istat) then
	    do k=1,3
	      if(rfa(k) .ne. rab.rab$w_rfa(k)) then
	        istat = dix_rms_get(control,file)
	        goto 12
	      endif
	    end do
	  endif
	else
c
c Either not indexed file, or rfa_read on key=0
c
	  rab.rab$l_ubf = %loc(file.data.data_rec)
	  rab.rab$l_rhb = %loc(file.data.vfc_data)
	  rab.rab$w_usz = max_buf
	  rab.rab$b_rac = rab$c_rfa
	  rab.rab$b_krf = key_nr
	  rab.rab$l_kbf = 0
	  rab.rab$b_ksz = 0
	  rab.rab$l_rop = 0
	  do k=1,3
	    rab.rab$w_rfa(k) = rfa(k)
	  end do
c
c Fill with 0's
c
	  call dix_util_fill(0,max_buf,file.data.data_rec)
c
c Get the data
c
	  istat = sys$get(rab,,)
	  if(istat) then
	    call dix_rms_save_rfa_int(rab,0)
	    file.data.nb_data = zext(rab.rab$w_rsz)
	    call dix_dump_copy(file)
	  endif
	end if
90	dix_rms_get_rfa = istat
	return
	end

	function dix_rms_get_direct(control,file,recnr)
c
	implicit none
c
	include '($rabdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
	integer*4 recnr
	logical*4 dix_rms_get_direct
c
	record /rabdef/ rab
	pointer (p_rab,rab)
	record /rabdef/ rabmod
	pointer (p_rabmod,rabmod)
c
	integer*4 istat,sys$get,sys$read
c
	p_rab    = file.rabadr
	p_rabmod = file.rabmod
c
c First check is unmodified data present
c
	call dix_main_check_mod_record(control,file)
c
	rabmod.rab$l_rop = 0
	rabmod.rab$l_ubf = %loc(file.data.data_rec)
	rabmod.rab$l_rhb = %loc(file.data.vfc_data)
c
	if(file.block_size .eq. 0) then
c
c Record io
c
	  rabmod.rab$w_usz = max_buf
	  rabmod.rab$b_rac = rab$c_key
	  rabmod.rab$l_kbf = %loc(recnr)
	  rabmod.rab$b_krf = 0
	  rabmod.rab$b_ksz = 4
c
c Get the data
c
	  istat = sys$get(rabmod,,)
	  call dix_rms_save_rfa_int(rab,file.rec_nr)
	else
c
c Blockio
c
	  rabmod.rab$w_usz = file.block_size*512
	  rabmod.rab$l_bkt = recnr
	  istat = sys$read(rabmod,,)
	end if

	file.data.nb_data = rabmod.rab$w_rsz
c
	dix_rms_get_direct = istat
	if(istat) then
c
c Fill with 0's
c
	  call dix_util_fill(0,max_buf,file.data.data_rec)
c
	  rab.rab$l_rop = 0
	  rab.rab$l_ubf = %loc(file.data.data_rec)
	  rab.rab$l_rhb = %loc(file.data.vfc_data)
	  call sys$release(rabmod,,)
	  if(file.block_size .eq. 0) then
	    rab.rab$w_usz = max_buf
	    rab.rab$b_rac = rab$c_key
	    rab.rab$l_kbf = %loc(recnr)
	    rab.rab$b_krf = 0
	    rab.rab$b_ksz = 4
c
c Get the data
c
	    istat = sys$get(rab,,)
	  else
c
c Blockio
c
	    rab.rab$w_usz = file.block_size*512
	    rab.rab$l_bkt = (recnr-1)*file.block_size+1
	    istat = sys$read(rab,,)
	  end if
	  if(istat) then
	    call dix_rms_save_rfa_int(rab,0)
	    file.data.nb_data = zext(rab.rab$w_rsz)
	    file.rec_nr = recnr
	    call dix_dump_copy(file)
	  endif
	end if
	return
	end

	function dix_rms_update(control,file,signal)
	implicit none
c
	include '($rabdef)'
	include '($rmsdef)'
	include 'dix_def.inc'
	record /control/ control	!:io: contorl structure
	record /file_info/ file
	logical signal			!:i: singla update?
	logical*4 dix_rms_update
c
	integer*4 sys$update
	logical*4 sys$write
	logical*4 sys$put
	integer*4 dix_rms_reget_rfa,dix_rms_delete
	external dix_msg_noupd
	external dix_msg_recupd
	external dix_msg_delwrok
	external dix_msg_recins
c
	integer*4 istat
c
	record /rabdef/ rab		!:io: rab of the file
	pointer (p_rab,rab)
	record /rabdef/ rabmod		!:io: rabmod
	pointer (p_rabmod,rabmod)
c
	logical*4 dix_main_question
c
	p_rab = file.rabadr
	p_rabmod = file.rabmod
cc
	if(file.data.newrec) then
c
c Just insert record
c
	  rabmod.rab$b_rac = rab$c_key
	  rabmod.rab$l_rbf = %loc(file.data.data_rec)
	  rabmod.rab$w_rsz = file.data.nb_data
	  rabmod.rab$l_rop = 0
	  istat = sys$put(rabmod,,)
	  if(istat) then
	    if(signal) call dix_message(control,dix_msg_recins)
	  endif
	  goto 90
	end if
c
	if(file.block_size .ne. 0) then
c
c Block mode transfer
c
	  rabmod.rab$l_bkt = rab.rab$l_bkt	!current record
	  rabmod.rab$w_rsz = file.block_size*512
	  rabmod.rab$l_rbf = %loc(file.data.data_rec)
	  istat = sys$write(rab,,)
	  dix_rms_update = istat
	  if(istat) then
	    if(signal) call dix_message(control,dix_msg_recupd)
	  end if
	  goto 90
	end if
	istat = dix_rms_reget_rfa(control,rabmod,rab.rab$w_rfa)
	if(istat) then
	  rabmod.rab$w_rsz = file.data.nb_data
	  rabmod.rab$l_rbf = %loc(file.data.data_rec)
	  rabmod.rab$l_rhb = %loc(file.data.vfc_data)
	  istat = sys$update(rabmod,,)
c
c if not successfull then try delete/write
c
	  if(.not. istat) then
c
c Update went wrong, maybe keychange (try delete/write)
c
	    if(istat .eq. rms$_chg) then
	      if(dix_main_question(control,
     1     '$Update cause illegal key change ;'//
     1     ' Try delete/write',.true.)) then
c 
c Because previous UPDATE went wrong
C record pointer is illegal; so reset rfa
c
	        istat = dix_rms_reget_rfa(control,rabmod,rab.rab$w_rfa)
	        if(istat) then
c
c Delete the record
c
	          istat = dix_rms_delete(control,file)
	          if(istat) then
c
c And put it now
c
	            rabmod.rab$b_rac = rab$c_key
	            rabmod.rab$l_rbf = %loc(file.data.data_rec)
	            rabmod.rab$w_rsz = file.data.nb_data
	            rabmod.rab$l_rop = 0
	            istat = sys$put(rabmod,,)
	            if(istat) then
	              call dix_message(control,dix_msg_delwrok)
	            endif
	          endif
	        endif
	      endif
	    endif
	  else
c
c Update went ok
c
	    if(signal) call dix_message(control,dix_msg_recupd)
	  endif
	endif
90	if(istat) call dix_dump_copy(file)
	dix_rms_update = istat
	return
	end

	function dix_rms_delete(control,file)
	implicit none
c
	include '($rabdef)'
	include 'dix_def.inc'
	integer*4 control
	record /file_info/ file
c
	record /rabdef/ rab
	pointer (p_rab,rab)
	record /rabdef/ rabmod
	pointer (p_rabmod,rabmod)
	logical*4 dix_rms_delete
c
	integer*4 istat
c
	integer*4 dix_rms_reget_rfa
	integer*4 sys$delete
	external dix_msg_reckill
c
c
	p_rab    = file.rabadr
	p_rabmod = file.rabmod
c
	istat = dix_rms_reget_rfa(control,rabmod,rab.rab$w_rfa)
	if(istat) then
	  rabmod.rab$l_rop = 0
	  istat = sys$delete(rabmod,,)
	  if(istat) then
	    call dix_message(control,dix_msg_reckill)
	  endif
	end if
	dix_rms_delete = istat
	return
	end

	subroutine dix_rms_file_info(control,filename,rab,des_expanded)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control        !:i: control structure
	character*(*) filename          !:i: the filename
	include '($rabdef)'
	record /rabdef/ rab             !:i: rab for the file
	record /des_expanded/ des_expanded !:i: Optional des_info record
c
	integer*4 fabadr
	logical dix_dump_print_line 
c
	if(dix_dump_print_line(control,0,
     1        'Keyinformation on file '//filename)) then
	  fabadr = rab.rab$l_fab
	  call dix_rms_file_info_scr(control,0,%val(fabadr),des_expanded)
	endif
	return
	end

	function dix_rms_fi_pr(control,dis_id,line)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	integer*4 dis_id
	character*(*) line
	integer*4 dix_rms_fi_pr
c
	integer*4 k,istat
	integer*4 dix_util_get_len_fu
	integer*4 dix_dump_print_line
	integer*4 memtab_add_record
c
	k = dix_util_get_len_fu(line)
	if(k .eq. 0) k = 1
c
	if(control.mode .eq. mode_screen) then
	  istat = memtab_add_record(dis_id,line(1:k))
	else
	  istat = dix_dump_print_line(control,0,line(1:k))
	end if
	dix_rms_fi_pr = istat
	return
	end

	function dix_rms_keyinfo(file,key,string,length,ascending,keynam)
	implicit none
c
c Return info for keynumber for RMS, and update keypos/siz in file structure
c
	include 'dix_def.inc'
	record /file_info/ file
	integer*4 key			!:i: keynumber
	logical*4 string		!:o: true is string key
	integer*4 length		!:o: give length of key
	logical*4 ascending		!:o: true if ascending key
	logical*4 dix_rms_keyinfo	!:f: status of sys$display
	character*(*) keynam
c
c Functions
c
	logical*4 dix_rms_fill_xab
c
c local vars
c
	include '($rabdef)'
	record /rabdef/ rab		!:i: rab on which file openm
	pointer (p_rab,rab)
c
	include '($xabkeydef)'
	record /xabkeydef/ xab
	integer*4 k
c
C Need keyinfo, where are the keyfields
C
c
	p_rab = file.rabadr
	call lib$movc5(0,0,0,xab$k_keylen,xab)	!clear out xab to zero's
c
c Make xab key
c
	xab.xab$b_ref = key
	xab.xab$l_knm = %loc(keynam)
	dix_rms_keyinfo = dix_rms_fill_xab(%val(rab.rab$l_fab),xab,
     1                   xab$c_key,xab$k_keylen)
c
c Check on status
c
	if(dix_rms_keyinfo) then
c
c all ok; length is sum of all siz*
c
	  length = 
     1       xab.xab$b_siz0 + 
     1       xab.xab$b_siz1 + 
     1       xab.xab$b_siz2 + 
     1       xab.xab$b_siz3 + 
     1       xab.xab$b_siz4 + 
     1       xab.xab$b_siz5 + 
     1       xab.xab$b_siz6 + 
     1       xab.xab$b_siz7
c
c String type for stg,col,pac or the descending versions
c
	  string =
     1       xab.xab$b_dtp .eq. xab$c_stg  .or.
     1       xab.xab$b_dtp .eq. xab$c_dstg .or.
     1       xab.xab$b_dtp .eq. xab$c_col  .or. 
     1       xab.xab$b_dtp .eq. xab$c_dcol .or. 
     1       xab.xab$b_dtp .eq. xab$c_pac  .or.
     1       xab.xab$b_dtp .eq. xab$c_dpac 
c
c Ascending if keytype <= max ascending keytype
c
	  ascending = xab.xab$b_dtp .le. xab$c_max_ascend
	end if
c
C Save the pos/sizes of all segments for higlighted display
C
	do k=1,8
	  file.keypos(k) = xab.xab$w_pos(k)
	  file.keysiz(k) = xab.xab$b_siz(k)
	end do
c
c Reset old xab address in FAB
c
	return
	end

	function dix_rms_update_info(file)
	implicit none
	include 'dix_def.inc'
	record /file_info/ file
	logical*4 dix_rms_update_info
c
	integer*4 k
	character*(max_rms_key_name_length) keynam
c
	logical*4 dix_rms_keyinfo
c
c
	if(file.indexed) then
	  dix_rms_update_info=dix_rms_keyinfo(file,file.cur_key,k,k,k,keynam)
	else
	  dix_rms_update_info = .true.
	  do k=1,8
	    file.keypos(k) = 0
	    file.keysiz(k) = 0
	  end do
	end if
	return
	end

	function dix_rms_offset_in_key(file,pos,plen)
	implicit none
C
C Check if position in key area
c
	include 'dix_def.inc'
	record /file_info/ file
	integer*4 pos
	integer*4 plen
	logical*4 dix_rms_offset_in_key
c
	logical*4 dix_util_overlap
C
	integer*4 k
c
c Start of coding
c
	dix_rms_offset_in_key = .false.
	do k=1,8
	  if(dix_util_overlap(   pos,                plen,
     1              zext(file.keypos(k)),zext(file.keysiz(k)))) then
	    dix_rms_offset_in_key = .true.
	    goto 90
	  end if
	end do
90	return
	end

	function dix_rms_fill_xab(fab,xab,cod,bln) 
	implicit none
	include '($fabdef)'
	record /fabdef/ fab
	include '($xabdef)'
	record /xabdef/ xab
	integer*4 dix_rms_fill_xab
	byte cod
	byte bln
c
	integer*4 sys$display
	integer*4 savxab
c
	savxab = fab.fab$l_xab
	xab.xab$b_cod = cod		!fill  in type of xab
	xab.xab$b_bln = bln		!fill in block length of xab
	fab.fab$l_xab = %loc(xab)
c
c Let rms handle it; returns with XABKEY filled in
c
	dix_rms_fill_xab = sys$display(fab,,)
	fab.fab$l_xab = savxab
	return
	end
	subroutine dix_rms_save_rfa_int(rab,recnr)
	implicit none
	include '($rabdef)'
	record /rabdef/ rab
	integer*4 recnr
c
	call dix_rms_save_rfa('DIXRFA',rab,recnr)
	return
	end
	subroutine dix_rms_save_rfa_rab(control,symbname,rab,recnr)
	implicit none
c
	include '($RABDEF)'
c
	integer*4 control
	character*(*) symbname
	record /rabdef/ rab
	integer*4 recnr
c
	external dix_msg_markset
c
	call dix_rms_save_rfa(symbname,rab,recnr)
	call dix_message(control,dix_msg_markset,symbname)
	return
	end
	function dix_rms_check_rfa(symbname)
	implicit none
c
	include 'dix_def.inc'
c
	character*(*) symbname
	logical dix_rms_check_rfa
c
	integer*4 knr,recnr,nk,k
	integer*2 rfa(3)
	integer*2 fid(3)
	character*(max_device_name_length) devnam
	byte chksum,chks
	character*(max_line_length) rfatext
c
	integer*4 dix_util_get_len
c
	dix_rms_check_rfa = .false.
	k = dix_util_get_len(symbname)
        call lib$get_symbol(symbname(1:k),rfatext,nk)
	if(nk .gt. 0) then
          read(rfatext,2010,err=90) fid,devnam,knr,rfa,recnr,chksum
2010      format(3z4.4,a16,z2.2,3z4.4,z8.8,z2.2)
	  chks = 0
	  do k=1,nk-2
	    chks = chks .xor. ichar(rfatext(k:k))
	  end do
	  dix_rms_check_rfa = chks .eq. chksum
	endif
90	return
	end
	subroutine dix_rms_save_rfa(symbname,rab,recnr)
	implicit none
c
	include 'dix_def.inc'
c
c Save a restore point to a symbol
c
	character*(*) symbname		!:i: the symbol name
	include '($rabdef)'		
	record /rabdef/ rab             !:i: the file rab
	integer*4 recnr			!:i: the record number
c
	integer*4 nk
	character*(max_line_length) rfa_asc
c
	call dix_rms_compute_rfa(rab,recnr,rfa_asc,nk)
	call lib$set_symbol(symbname,rfa_asc(1:nk))
	return
	end
	subroutine dix_rms_compute_rfa(rab,recnr,rfa_asc,nk)
	implicit none
c
c Compute a restore point
c
	include 'dix_def.inc'
	include '($rabdef)'
	record /rabdef/ rab	!:i: the file rab
	integer*4 recnr		!:i: the record number
	character*(*) rfa_asc	!:o: the text string
	integer*4 nk		!:o: the length of rfa_asc
c
	integer*2 fid(3)
	character*(max_device_name_length) devnam
c
	integer*4 k,nk1
	byte chksum
c
	call dix_rms_get_fid(rab,fid,devnam)
	nk = 0
	call sys$fao('!4XW!4XW!4XW!AS!2XB!4XW!4XW!4XW!8XL',nk,rfa_asc,
     1   %val(fid(1)),%val(fid(2)),%val(fid(3)),
     1   devnam,
     1   %val(rab.rab$b_krf),
     1   %val(rab.rab$w_rfa(1)),%val(rab.rab$w_rfa(2)),
     1   %val(rab.rab$w_rfa(3)),%val(recnr))
	chksum = 0
	do k=1,nk
	  chksum = chksum .xor. ichar(rfa_asc(k:k))
	end do
	call sys$fao('!2XB',nk1,rfa_asc(nk+1:),%val(chksum))
	nk = nk + nk1
	return
	end
	function dix_rms_set_rfa(control,ptr_file,symbname)
	implicit none
c
	include 'dix_def.inc'
	integer*4 control
	integer*4 ptr_file		!:io: pointer to file list
	character*(*) symbname          !:i: the symboalname
	logical dix_rms_set_rfa		
c
	integer*4 k,nk
	character*(max_line_length) rfatext
c
	logical dix_util_get_len
	logical dix_rms_check_rfa
	logical dix_rms_set_rfa_val
c
	dix_rms_set_rfa = .false.
c
c Make sure the symbname has valid contents
c
	k = dix_util_get_len(symbname)
	if(dix_rms_check_rfa(symbname(1:k))) then
          call lib$get_symbol(symbname(1:k),rfatext,nk)
	  dix_rms_set_rfa = dix_rms_set_rfa_val(control,ptr_file,rfatext(1:nk))
	endif
	return
	end
	function dix_rms_set_rfa_val(control,ptr_file,rfatext)
	implicit none
c
	include 'dix_def.inc'
	integer*4 control
	integer*4 ptr_file		!:io: pointer to file list
	character*(*) rfatext		!:i: the rfa value
	logical dix_rms_set_rfa_val
c
	record /file_info/ file
	pointer (p_file,file)
	integer*4 knr,recnr,nk
	integer*2 rfa(3)
c
	logical dix_rms_get_rfa
	external rms$_rnf
	logical dix_util_get_len
	external dix_msg_filnotrfa
c
	integer*2 fid(3),fid1(3)
	character*(max_device_name_length) devnam,devnam1
	character*(max_line_length) line
c
	dix_rms_set_rfa_val = .false.
c
c Translate the data to disk/fid/rfa
c
        read(rfatext,2010,err=90) fid,devnam,knr,rfa,recnr
2010    format(3z4.4,a16,z2.2,3z4,z8.8)
c
c Now we have a fid and a diskname
c get the fid and disk of the current pointed file
c if the same oke, else try the next
c
	p_file = ptr_file
10	call dix_rms_get_fid(%val(file.rabadr),fid1,devnam1)
	if(fid(1) .ne. fid1(1) .or. fid(2) .ne. fid1(2) .or.
     1     fid(3) .ne. fid1(3) .or. devnam .ne. devnam1) then
c
c No match, try the next one
c
	  p_file = file.link.forw
	  if(p_file .ne. 0) goto 10
c
c Sorry not found
c
	  nk = ichar(devnam(1:1))
	  call lib$fid_to_name(devnam(2:nk+1),fid,line)
	  nk =dix_util_get_len(line)
	  if(nk .gt. 0) then
	    call dix_message(control,dix_msg_filnotrfa,line(1:nk))
	  endif
	  dix_rms_set_rfa_val = %loc(rms$_rnf)
	else
c
c Disk and fid matched, now the rfa
c
          dix_rms_set_rfa_val = dix_rms_get_rfa(control,file,knr,rfa)
	  file.rec_nr = recnr
	  ptr_file = p_file
	endif
90	return
	end
	subroutine dix_rms_get_fid(rab,fid,devnam)
	implicit none
	include '($rabdef)'
	record /rabdef/ rab
	integer*2 fid(3)
	character*(*) devnam	
c
	include '($fabdef)'
	record /fabdef/ fab
	pointer (p_fab,fab)
c
	include '($namdef)'
	record /namdef/ nam
c
	integer sys$display
c
	p_fab = rab.rab$l_fab
	fab.fab$l_nam = %loc(nam)
c
	nam.nam$b_bln = nam$c_bln
	nam.nam$b_bid = nam$c_bid
c
	if(sys$display(fab,,)) then
	  fid(1) = nam.nam$w_fid(1)
	  fid(2) = nam.nam$w_fid(2)
	  fid(3) = nam.nam$w_fid(3)
	  devnam = nam.nam$t_dvi
	end if
	return
	end
	subroutine dix_rms_get_keyname(pos,size,des_expanded,names,nk_names)
	implicit none
c
	include 'dix_def.inc'
c
	integer*4 pos	!:i: keypos
	integer*4 size	!:i: keysize
	record /des_expanded/ des_expanded
	character*(*) names
	integer*4 nk_names
c
	integer*4 k
	record /des_rec/ des_rec
	character*(max_line_length) line
c
	logical dix_util_overlap
c
	nk_names = 0
	do k=1,des_expanded.n_des
	  call dix_des_get_des(des_Expanded,k,des_rec,line)	  
	  if(dix_util_overlap(des_rec.bit_offset,des_rec.size,
     1              pos*8,size*8)) then
	    names(nk_names+1:) = line(1:des_rec.nam_len)//','
	    nk_names = nk_names + des_rec.nam_len + 1
	  end if
	end do
	if(nk_names .gt. 0) nk_names = nk_names - 1
	return
	end
