 	function dix_rms_open(control,file)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
	integer*4 dix_rms_open
c
	include '($rabdef)'
	include '($fabdef)'
	include '($namdef)'
c
	record /fabdef/ fab
	record /fabdef/ fabmod
	record /rabdef/ rab
	record /rabdef/ rabmod
c
	record /namldef/ naml
c
	pointer (p_rab,rab)
	pointer (p_rabmod,rabmod)
	pointer (p_fab,fab)
	pointer (p_fabmod,fabmod)
c
	character*(max_filename_length) resnam
c
	integer*4 istat
	integer*4 sys$open,sys$connect
	external dix_msg_filnotop
c
	include '($xabkeydef)'
	record /xabkeydef/ xabkey
	include '($xabsumdef)'
	record /xabsumdef/ xabsum
	include '($xabfhcdef)'
	record /xabfhcdef/ xabfhc
c
	call get_vm(sizeof(fab   ),p_fab   ,control.zone_file,.true.)
	call get_vm(sizeof(fabmod),p_fabmod,control.zone_file,.true.)
	call get_vm(sizeof(rab   ),p_rab   ,control.zone_file,.true.)
	call get_vm(sizeof(rabmod),p_rabmod,control.zone_file,.true.)
c
	call dix_util_fill(0,sizeof(naml),naml)
	naml.naml$b_bid = naml$c_bid
	naml.naml$b_bln = naml$c_bln
	naml.naml$l_long_expand_alloc = len(resnam)
	naml.naml$l_long_expand       = %loc(resnam)
	naml.naml$l_long_filename_size = file.nk_fnam
	naml.naml$l_long_filename      = %loc(file.fnam)
c
	fab.fab$b_bln = fab$c_bln
	fab.fab$b_bid = fab$c_bid
	fab.fab$l_nam = %loc(naml)
c
	fabmod.fab$b_bln = fab$c_bln
	fabmod.fab$b_bid = fab$c_bid
c
	rab.rab$b_bln = rab$c_bln
	rab.rab$b_bid = rab$c_bid
c
	rabmod.rab$b_bln = rab$c_bln
	rabmod.rab$b_bid = rab$c_bid
c
	file.fabadr = p_fab
	file.fabmod = p_fabmod
	file.rabadr = p_rab
	file.rabmod = p_rabmod
c
	file.err_seen = 1		!successstatus
c
	fab.fab$l_fna = %loc(file.fnam)
	fab.fab$b_fns = file.nk_fnam
c
	fabmod.fab$l_fna = %loc(file.fnam)
	fabmod.fab$b_fns = file.nk_fnam
c
	if(file.modify) then
	  fabmod.fab$b_fac = fab$m_get .or. fab$m_put .or. fab$m_upd .or. 
     1                    fab$m_trn .or. fab$m_del
	end if
	if(file.block_size .ne. 0) then
	  fab.fab$b_fac    = fab.fab$b_fac    .or. fab$m_bio .or.
     1                           fab$m_get    .or. fab$m_put
	  fabmod.fab$b_fac = fabmod.fab$b_fac .or. fab$m_bio .or.
     1                              fab$m_get .or. fab$m_put
	  fab.fab$b_shr = fab$m_shrput .or. fab$m_shrget .or.
     1                    fab$m_shrupd .or. fab$m_shrdel .or.
     1                    fab$m_upi
	  fabmod.fab$b_shr = fab$m_shrput .or. fab$m_shrget .or.
     1                    fab$m_shrupd .or. fab$m_shrdel .or.
     1                    fab$m_upi
	  file.minrecl = 512*file.block_size
	  file.maxrecl = 512*file.block_size
	else
	  fab.fab$b_shr = fab$m_shrput .or. fab$m_shrget .or.
     1                    fab$m_shrupd .or. fab$m_shrdel
	  fabmod.fab$b_shr = fab$m_shrput .or. fab$m_shrget .or.
     1                    fab$m_shrupd .or. fab$m_shrdel
	  file.minrecl = 0
	end if
c
	istat = sys$open(fab,,)
	if(istat) then
	  file.data.nb_vfc = zext(fab.fab$b_fsz)
	  istat = sys$open(fabmod,,)
	  if(.not. istat) call dix_message(control,%val(istat))
c
c Get some extra info of this file
c
	  if(file.block_size .eq. 0) then
	    file.maxrecl = zext(fab.fab$w_mrs)
	  end if
	  file.indexed  = fab.fab$b_org .eq. fab$c_idx
 	  file.relative = fab.fab$b_org .eq. fab$c_rel
	  file.fixed    = fab.fab$b_rfm .eq. fab$c_fix
c
	  call dix_rms_fill_xab(fab,xabfhc,xab$c_fhc,xab$k_fhclen)
	  file.filesize = xabfhc.xab$l_ebk
	  if(file.filesize .gt. 0 .and. xabfhc.xab$w_ffb .eq. 0) then
	    file.filesize = file.filesize - 1
	  endif
c
	  if(file.indexed) then
	    if(file.block_size .eq. 0) then
	      call dix_rms_fill_xab(fab,xabkey,xab$c_key,xab$k_keylen)
	      file.minrecl = xabkey.xab$w_mrl
	    end if
	    call dix_rms_fill_xab(fab,xabsum,xab$c_sum,xab$k_sumlen)
	    file.nkey    = xabsum.xab$b_nok
	  else
	    file.nkey = 0
	  end if
c
c Connect rabadr
c
	  rab.rab$l_fab = p_fab
	  istat = sys$connect(rab,,)
	  if(.not. istat) call dix_message(control,%val(istat))

c
c connect rabmod
c
	  rabmod.rab$l_fab = p_fabmod
	  istat = sys$connect(rabmod,,)
	  if(.not. istat) call dix_message(control,%val(istat))
c
	else
c
c Open went wrong, tel user
c
	  call dix_message(control,dix_msg_filnotop,file.fnam(1:file.nk_fnam))
	  call dix_message(control,%val(fab.fab$l_sts))
	  call dix_message(control,%val(fab.fab$l_stv))
	  dix_rms_open = .false.
	  call free_vm(sizeof(fab),   p_fab,   control.zone_file)
	  call free_vm(sizeof(fabmod),p_fabmod,control.zone_file)
	  call free_vm(sizeof(rabmod),p_rabmod,control.zone_file)
	  call free_vm(sizeof(rab)   ,p_rab,   control.zone_file)
	  file.fabadr = 0
	  file.fabmod = 0
	  file.rabadr = 0
	  file.rabmod = 0
	  file.namadr = 0
	end if
	dix_rms_open = istat
	return
	end
	subroutine dix_rms_file_info_scr(control,dis_id,fab,des_expanded)
	implicit none
c
	include 'dix_def.inc'
	record /control /control	!:i: the control structure
	integer*4 dis_id		!:i: the display id (if screen) or 0
	include '($fabdef)'		
	record /fabdef/ fab             !:i: the fab
	record /des_expanded/ des_expanded !:i: the des record (optional)
c
	include '($namdef)'
	record /namldef/ naml
c
	logical*4 dix_rms_fill_xab
	logical dix_rms_fi_pr
c
	include '($xabdef)'
	include '($xabkeydef)'
	record /xabkeydef/ xabkey
	include '($xabrdtdef)'
	structure /help/
	  union
	    map
	      record /xabdef/ xab
	    end map
	    map
	      record /xabrdtdef/ xabrdt
	    end map
	  end union
	end structure
	record /help/ xabrdt
	include '($xabdatdef)'
	record /xabdatdef/ xabdat
	include '($xabprodef)'
	record /xabprodef1/ xabpro
	include '($xabsumdef)'
	record /xabsumdef/ xabsum
	include '($xabfhcdef)'
	record /xabfhcdef/ xabfhc
	include '($xaballdef)'
	structure /help1/
	  union
	    map
	      record /xabdef1/ xab
	    end map
	    map
	      record /xaballdef/ xaball
	    end map
	  end union
	end structure
	record /help1/ xaball
c
	logical do_des,is_seq,is_var
	integer*4 k,key,nkar,segment_nr,nk,nk_key
	integer*4 width_key,width_fld,pos_key,pos_fld
	character*(max_rms_key_name_length) keynam
	character*(max_short_line_length) ktp
	character*(max_line_length) line,flds
	integer*4 nk_fld
	character*(max_long_filename_length) fnam
c
	integer*4 dix_util_get_len_fu
c
c Make xab key
c file, get namblk filled
c
	if(iargcount() .gt. 3) then
	  do_des = %loc(des_expanded) .ne. 0
	else
	  do_des = .false.
	end if 
	naml.naml$b_bid = naml$c_bid
	naml.naml$b_bln = naml$c_bln	!make it a nam block
	naml.naml$l_long_result_alloc = min(naml$c_maxrss,len(fnam))
	naml.naml$l_long_result       = %loc(fnam)
	
	k = fab.fab$l_nam
	fab.fab$l_nam = %loc(naml)
	call sys$display(fab,,)
	fab.fab$l_nam = k
c
	if(.not. dix_rms_fi_pr(control,dis_id,':File')) goto 99
c
	if(.not. dix_rms_fi_pr(control,dis_id,'Name :'//
     1          fnam(1:naml.naml$l_long_result_size))) goto 99
c
	is_seq = .false.
	if(fab.fab$b_org .eq. fab$c_idx) then
	  Line = 'Indexed'
	elseif(fab.fab$b_org .eq. fab$c_rel) then
	  line = 'Relative'
	elseif(fab.fab$b_org .eq. fab$c_seq) then
	  line = 'Sequential'
	  is_seq = .true.
	end if
	if(.not. dix_rms_fi_pr(control,dis_id,
     1           ' Organization     : '//line(1:14))) goto 99
c
	is_var = .false.
	if(fab.fab$b_rfm .eq. fab$c_fix) then
	  line = 'Fixed'
	  nkar = 5
	elseif(fab.fab$b_rfm .eq. fab$c_stm) then
	  line = 'Stream'
	  nkar = 6
	elseif(fab.fab$b_rfm .eq. fab$c_stmcr) then
	  line = 'Stream_CR'
	  nkar = 9
	elseif(fab.fab$b_rfm .eq. fab$c_stmlf) then
	  line = 'Stream_LF'
	  nkar = 9
	elseif(fab.fab$b_rfm .eq. fab$c_udf) then
	  line = 'Undefined'
	  nkar = 9
	elseif(fab.fab$b_rfm .eq. fab$c_var) then
	  line = 'Variable'
	  nkar = 8
	  is_var = .true.
	elseif(fab.fab$b_rfm .eq. fab$c_vfc) then
	  call sys$fao('VFC, !UB byte header',nkar,line,
     1          %val(fab.fab$b_fsz))
	endif
	if(.not. dix_rms_fi_pr(control,dis_id,
     1     ' Record format    : '//line(1:nkar))) goto 99
c
	call  dix_rms_fill_xab(fab,xabdat,xab$c_dat,xab$k_datlen)
c
	call sys$asctim(,line,xabdat.xab$q_cdt)
	if(.not. dix_rms_fi_pr(control,dis_id,' Creation   date  : '//
     1           line(1:23))) goto 99
c
	if((xabdat.xab$q_edt(1) .or. xabdat.xab$q_edt(2)) .eq. 0) then
	  line = '<None specified>'
	else
	  call sys$asctim(,line,xabdat.xab$q_edt)
	endif
	if(.not. dix_rms_fi_pr(control,dis_id,' Expiration date  : '//
     1             line(1:23))) goto 99
c
	if((xabdat.xab$q_bdt(1) .or. xabdat.xab$q_bdt(2)) .eq. 0) then
	  line = '<No backup recorded>'
	else
	  call sys$asctim(,line,xabdat.xab$q_bdt)
	endif
	if(.not. dix_rms_fi_pr(control,dis_id,' Backup     date  : '//
     1            line(1:23))) goto 99
c
	call  dix_rms_fill_xab(fab,xabrdt,xab$c_rdt,xab$k_rdtlen)
	if((xabrdt.xab.xab$q_rdt(1) .or. xabrdt.xab.xab$q_rdt(2)) .eq. 0) then
	  line = '<None specified>'
	else
	  call sys$asctim(,line,xabrdt.xab.xab$q_rdt,)
	endif
	if(.not. dix_rms_fi_pr(control,dis_id,' Revision   date  : '//
     1            line(1:23))) goto 99
c
	call dix_con_type_intasc(6,naml.naml$w_fid,enttyp_fid,line,nkar)
	if(.not. dix_rms_fi_pr(control,dis_id,' File id          : '//
     1             line(1:nkar))) goto 99
c
	call  dix_rms_fill_xab(fab,xabpro,xab$c_pro,xab$k_prolen)
	call sys$fao('!%I = !%U',nkar,line,%val(xabpro.xab$l_uic),
     1                                   %val(xabpro.xab$l_uic))
	if(.not. dix_rms_fi_pr(control,dis_id,' File owner       : '//
     1            line(1:nkar)))goto 99
c
	call dix_con_type_intasc(2,xabpro.xab$w_pro,enttyp_prot,line,nkar)
	if(.not. dix_rms_fi_pr(control,dis_id,' File protection  : '//
     1            line(1:nkar))) goto 99
c
	write(line,10021) zext(fab.fab$w_gbc)
10021	format(' Globalbuffercount: ',i10)
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
c
	if(.not. dix_rms_fi_pr(control,dis_id,':Record')) goto 99
c
c Record
c
	line = ' '
	k = zext(fab.fab$b_rat)
	if(btest(k,fab$v_cr )) line = 'Carriage-return'
	if(btest(k,fab$v_FTN)) line = 'Fortran'
	if(btest(k,fab$v_PRN)) line = 'Print'
	if(is_seq) then
	  if(btest(k,fab$v_blk)) then
	  else
	    line = 'NoBlockspan,'//line
	  end if
	endif
	if(is_var) then
	  if(btest(k,fab$v_msb)) then
	    line = 'MSB,'//line
	  end if
	endif
	if(line .eq. ' ') line = 'NONE'
	if(.not. dix_rms_fi_pr(control,dis_id,' Record attribute : '//
     1           line(1:30))) goto 99
c
	call  dix_rms_fill_xab(fab,xabfhc,xab$c_fhc,xab$k_fhclen)
c
	write(line,1002) zext(xabfhc.xab$w_mrz)
1002	format(' Max record size  : ',i10)
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
	write(line,1003) xabfhc.xab$w_lrl
1003	format(' Longest record   : ',i10)
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
c
c Allocation
c
	if(.not.dix_rms_fi_pr(control,dis_id,':Allocation')) goto 99
	write(line,1004) xabfhc.xab$l_ebk,xabfhc.xab$w_FFB
1004	format(' EOF block        : ',i10,' (FFB = ',i4,')')
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
	write(line,1005) xabfhc.xab$l_hbk
1005	format(' Allocated blocks : ',i10)
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
	write(line,10041) zext(fab.fab$b_bks)
10041	format(' Bucketsize       : ',i10)
	if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
c
	if(fab.fab$b_org .ne. fab$c_idx) goto 99
c
c The rest is only defined for indexed files
c
	call  dix_rms_fill_xab(fab,xabsum,xab$c_sum,xab$k_sumlen)
c
	if(xabsum.xab$b_noa .gt. 0) then
	  if(.not.dix_rms_fi_pr(control,dis_id,':Areas')) goto 99
	  if(.not. dix_rms_fi_pr(control,dis_id,
     1      ' Area Allocation bucketsize extension')) goto 99
	end if
	do k=0,xabsum.xab$b_noa-1
	  xaball.xaball.xab$b_aid = k
	  call  dix_rms_fill_xab(fab,xaball,xab$c_all,xab$k_alllen)
	  write(line,1006) k,xaball.xaball.xab$l_alq,
     1                zext(xaball.xab.xab$b_bkz),
     1                     xaball.xaball.xab$w_deq
1006	  format(1x,i4,1x,i10,1x,i5,i10)
	  if(.not. dix_rms_fi_pr(control,dis_id,line)) goto 99
	end do
c
c Key information
c 
	if(.not. dix_rms_fi_pr(control,dis_id,':Keyinformation')) goto 99
	if(.not. dix_rms_fi_pr(control,dis_id,
     1  '                     ..INDEX. ..DATA..')) goto 99
	nk = 0
	call sys$fao('  Nr Type    Pos Siz Area Bkt Area Bkt  ',nk,line)
	pos_key = nk
	line(nk:) = 'Keyname'
c
c Compute remaining width
c
	if(do_des) then
c
c We need two columns, compute size
c
	  width_key = (control.ncols - nk - 1)/2
	  width_key = min(len(keynam),width_key)	!key_width
	  nk = nk + width_key + 1
	  pos_fld = nk
	  width_fld = control.ncols - nk
	  line(nk+1:) = 'Field'
	  nk = nk + 6
	else
	  width_key = len(keynam)	!fits in 80 cols
	  width_fld = 0
	  line(nk:) = 'Keyname'
	  nk = nk + 7
	endif
	if(.not. dix_rms_fi_pr(control,dis_id,line(1:nk))) goto 99
	if(.not.  dix_rms_fi_pr(control,dis_id,
     1  '                      Nr  siz  Nr  siz')) goto 99
c
	xabkey.xab$l_knm = %loc(keynam)
c
	do key=0,xabsum.xab$b_nok-1
	  xabkey.xab$b_ref = key
c
	  call dix_rms_fill_xab(fab,xabkey,xab$c_key,xab$k_keylen)
	  nk = index(keynam,char(0))
	  if(nk .gt. 0) keynam(nk:) = ' '
	  if(xabkey.xab$b_dtp .eq. xab$c_bn2) then
	    ktp = 'BIN2'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dbn2) then
	    ktp = 'DBIN2'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_bn4) then
	    ktp = 'BIN4'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dbn4) then
	    ktp = 'DBIN4'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_bn8) then
	    ktp = 'BIN8'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dbn8) then
	    ktp = 'DBIN8'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_in2) then
	    ktp = 'INT2'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_din2) then
	    ktp = 'DINT2'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_in4) then
	    ktp = 'INT4'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_din4) then
	    ktp = 'DINT4'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_in8) then
	    ktp = 'INT8'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_din8) then
	    ktp = 'DINT8'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_col) then
	    ktp = 'COL'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dcol) then
	    ktp = 'DCOL'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_pac) then
	    ktp = 'PAC'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dpac) then
	    ktp = 'DPAC'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_stg) then
	    ktp = 'STG'
	  elseif(xabkey.xab$b_dtp .eq. xab$c_dstg) then
	    ktp = 'DSTG'
	  else
	    ktp = '?????'
	  end if
	  write(line,1010) key,ktp(1:5),
     1                        xabkey.xab$w_pos0,
     1                        zext(xabkey.xab$b_siz0),
     1                        xabkey.xab$b_ian,
     1                        xabkey.xab$b_ibs,
     1                        xabkey.xab$b_dan,
     1                        xabkey.xab$b_dbs
1010	  format(1x,i3,1x,a,1x,i5,1x,i3,i5,i4,i5,i4)
	  nk_key = dix_util_get_len_fu(keynam) 
	  do segment_nr=1,xabkey.xab$b_nsg
c
	    if(segment_nr .gt. 1) then
	      write(line,1020) xabkey.xab$w_pos(segment_nr),
     1                         zext(xabkey.xab$b_siz(segment_nr))
1020	      format(11x,i5,1x,i3)
	    endif
c
	    if(do_des) then
	      call dix_rms_get_keyname(
     1                 zext(xabkey.xab$w_pos(segment_nr)),
     1                 zext(xabkey.xab$b_siz(segment_nr)),
     1                 des_expanded,flds,nk_fld)
	    else
	      nk_fld = 0
	    endif
	    if(nk_key .eq. 0) nk_key = 1	!force first time print
c
c Now fit in keynam and names
c
	    do while(nk_key .gt. 0 .or. nk_fld .gt. 0)
	      if(nk_key .gt. 0) then
	        nk = min(width_key,nk_key)
	        line(pos_key:pos_key+nk) = keynam(1:nk)
	        nk_key = nk_key - nk
	        keynam = keynam(nk+1:)
	        nk = pos_key + nk
	      endif
	      if(nk_fld .gt. 0) then
	        nk = min(width_fld,nk_fld)
	        line(pos_fld:pos_fld+nk) = flds(1:nk)
	        nk_fld = nk_fld - nk
	        flds = flds(nk+1:)
	        nk= pos_fld + nk
	      end if
	      if(.not. dix_rms_fi_pr(control,dis_id,line(1:nk))) goto 99
	      line = ' '
	    end do
	  end do
c
c If number of segments is >1, print total keysize
c
	  if(xabkey.xab$b_nsg .gt. 1) then
	    nk = 0
	    call sys$fao('       Total     !3UL',nk,line,
     1               %val(zext(xabkey.xab$b_tks)))
	    if(.not. dix_rms_fi_pr(control,dis_id,line(1:nk))) goto 99
	  endif
	end do
99	return
	end
