  	subroutine dix_smg_sel_files(control)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
c
	record /file_info/ file
	pointer (p_file,file)
c
	character*(max_screen_width) line
	record /dyn_help/ help_des
c
	integer*4 ipos,k,dis_id,nk,iterm,dis_id1,scr_pos,view_size
	integer*4 p_nam,p_flg,p_siz,i_file,nold,istat
c
	external dix_msg_filnotop
	external dix_msg_nofileleft
	external dix_int_cld
	external ignore_message
	integer*4 dix_main_get_files
	integer*4 dcl_parse
c
	include '($smgdef)'
c
	call smg$create_virtual_display(2,control.ncols,dis_id1)
	call sys$fao('Directory of !UL files',nk,line,%val(control.n_file))
	call smg$put_chars(dis_id1,line(1:nk),1,1)
c
c Create help page
c
	call help_init_std(control,help_des,'select files',20,15)
	call help_key(control.key_table,help_des,key_put,
     1         'inserts file(s) to list')
	call help_key(control.key_table,help_des,key_remove,
     1         'Remove this file')
	call help_key(control.key_table,help_des,key_exit,
     1         'Return to prev screen')
	call help_key(control.key_table,help_des,key_enter,
     1         'Return to prev screen and use current file')
	call help_key(control.key_table,help_des,key_select,
     1         'Set current file')
	call help_key(control.key_table,help_des,key_fileinfo,
     1         'View file')
	call dix_smg_stack_help(control,help_des)
c
c
	p_nam = len(dopointer)+1
	p_siz = control.ncols-10
	p_flg = p_siz-12
	line = ' '
	line(p_nam:) = 'Filename'
	line(p_flg:) = 'Flags'
	line(p_siz:) = '  FileSize'
c
	call smg$put_chars(dis_id1,line(1:control.ncols),2,1,,smg$m_underline)
	call smg$paste_virtual_display(dis_id1,control.paste_id,3,1)
c
c Create scroll window with data
c
	call smg$create_virtual_display(control.n_file,control.ncols,dis_id)
	view_size = min(control.n_file,control.nrows-5)
	call smg$create_viewport(dis_id,1,1,view_size,control.ncols)
c	
	p_file = control.top_file
	k = 1
	do while(p_file .ne. 0)
	  if(p_file .eq. control.cur_file) i_file = k
	  call lib$trim_filespec(file.fnam,line,p_flg-p_nam,nk)
	  call smg$put_chars(dis_id,line(1:nk),k,p_nam)
	  call sys$fao('!10UL',nk,line,%val(file.filesize))
	  call smg$put_chars(dis_id,line(1:nk),k,p_siz)
	  line = 'SEQ'
	  if(file.relative) line = 'REL'
	  if(file.indexed ) line = 'IDX'
	  nk = 3
	  if(file.fixed) then
	    line(nk+1:) = '/FIX'
	    nk = nk + 4
	  end if 
	  if(file.modify) then
	    line(nk+1:) = '/MOD'
	    nk = nk + 4
	  end if 
	  call smg$put_chars(dis_id,line(1:nk),k,p_flg)
	  k = k + 1
	  p_file = file.link.forw
	end do
c
	call smg$paste_virtual_display(dis_id,control.paste_id,5,1)
c
	call smg$put_chars(dis_id,dopointer,i_file,1)
	ipos = i_file
c
	scr_pos = 1
c
10	p_file = control.top_file
	do k=1,ipos-1
	  p_file = file.link.forw
	end do
c
c Make sure in display
c
	do while(ipos .lt. scr_pos)
	  scr_pos = scr_pos - 1
	  call smg$scroll_viewport(dis_id,smg$m_down,1)
	end do
c
	do while(ipos-scr_pos .ge. view_size)
	  scr_pos = scr_pos + 1
	  call smg$scroll_viewport(dis_id,smg$m_up,1)
	end do
c
	call smg$set_cursor_abs(dis_id,ipos,1)
	call dix_get_key(control,iterm)
15	if(iterm .eq. key_up) then
	  if(ipos .gt. 1) ipos = ipos-1
	elseif(iterm .eq. key_prev) then
	  ipos = max(ipos-10,1)
	elseif(iterm .eq. key_next) then
	  ipos = min(ipos+10,control.n_file)
	elseif(iterm .eq. key_top) then
	  ipos = 1
	elseif(iterm .eq. key_bot) then
	  ipos = control.n_file
	elseif(iterm .eq. key_right) then
	elseif(iterm .eq. key_left) then
	elseif(iterm .eq. key_down) then
	  if(ipos .lt. control.n_file) ipos = ipos+1
	elseif(iterm .eq. key_fileinfo) then
c
	  call dix_smg_file_info_scr(control,%val(file.rabadr),file.fnam,
     1                  %val(file.cur_Des))
	elseif(iterm .eq. key_remove) then
c
c Close current file
c
	  if(control.n_file .eq. 1) then
	    call dix_message(control,dix_msg_nofileleft)
	  else
	    call smg$delete_line(dis_id,ipos)
	    call file_close(control,file)
	    call dix_util_link_out(file.link,control.top_file)
	    control.n_file = control.n_file - 1
	    call smg$change_virtual_display(dis_id,control.n_file)
	    view_size = min(control.n_file,control.nrows-5)
	    call smg$change_viewport(dis_id,,,view_size)
	    if(ipos .eq. i_file) then
	      i_file = max(1,i_file-1)
	      call smg$put_chars(dis_id,dopointer,i_file,1)
	    end if
	    if(ipos .gt. control.n_file) ipos =control.n_file
	  endif
	elseif(iterm .eq. key_put) then
	  line = ' '
	  call dix_smg_get_str(control,'filename',line(1:50),iterm)
	  if(line .ne. ' ') then
	    call lib$establish(ignore_message)
	    istat = dcl_parse(control,'OPEN '//line,dix_int_cld)
	    call lib$revert
	    if(.not. istat) then
	      call dix_message(control,%val(istat))
	    else
	      nold = control.n_file
	      if(dix_main_get_files(control,'P1',.false.,
     1              ' ',' ',.false.)) then
	        call smg$change_virtual_display(dis_id,control.n_file)
	        view_size = min(control.n_file,control.nrows-5)
	        call smg$change_viewport(dis_id,,,view_size)
	        p_file = control.top_file
	        ipos = 1
	        do k=1,nold
	          p_file = file.link.forw
	          ipos = ipos + 1
	        end do
	        do k=nold+1,control.n_file
	          call lib$trim_filespec(file.fnam,line,70,nk)
	          call smg$put_chars(dis_id,line(1:nk),ipos,3)
	          call sys$fao('!10UL',nk,line,%val(file.filesize))
	          call smg$put_chars(dis_id,line(1:nk),ipos,p_siz)
	          line = 'SEQ'
	          if(file.relative) line = 'REL'
	          if(file.indexed ) line = 'IDX'
	          nk = 3
	          if(file.fixed) then
	            line(nk+1:) = '/FIX'
	            nk = nk + 4
	          end if 
	          if(file.modify) then
	            line(nk+1:) = '/MOD'
	            nk = nk + 4
	          end if 
	          call smg$put_chars(dis_id,line(1:nk),ipos,p_flg)
	          ipos = ipos + 1
	          p_file = file.link.forw
	        end do
	        call smg$put_chars(dis_id,unpointer,i_file,1)
	        i_file = nold + 1
	        call smg$put_chars(dis_id,dopointer,i_file,1)
	        ipos = i_file
	      end if    !we did open some files
	    end if      !parse want oke
	  end if	!user type a filename
	elseif(iterm .eq. key_select) then
	  call smg$put_chars(dis_id,unpointer,i_file,1)
	  i_file = ipos
	  call smg$put_chars(dis_id,dopointer,i_file,1)
	elseif(iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_enter) then
	  i_file = ipos
	  goto 90
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	else
	  call dix_mes_invkey(control)
	end if
	goto 10
90	p_file = control.top_file
	do k=2,i_file
	  p_file = file.link.forw
	end do
	control.cur_file = p_file
	call smg$delete_virtual_display(dis_id)
	call smg$delete_virtual_display(dis_id1)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end
	subroutine dix_smg_sel_dirs(control,file)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	record /file_info/ file
c
	record /dyn_help/ help_des
c
	record /des_info/ des
	pointer (p_des,des)
c
	record /des_expanded/ des_expanded
	pointer (p_des_expanded,des_expanded)
c
	character*(max_screen_width) line
	character*(max_err_arg_length) err_arg
c
	integer*4 ipos,k,dis_id,nk,iterm,n_des,i_des,dis_id1,l
	integer*4 scr_pos,view_size,p_nam,p_siz,n_old_des
	integer*4 istat
	logical old_raw
c
	logical*4 dix_des_get_all
	logical*4 dix_edit_des
	integer*4 dix_util_get_len_fu
	external dix_msg_filnotop
	external dix_msg_notchanged
c
	include '($smgdef)'
c
c Create help text
c
	call help_init_std(control,help_des,'select descriptions',20,15)
c
	call help_key(control.key_table,help_des,key_remove,
     1         'Remove description')
	call help_key(control.key_table,help_des,key_exit,
     1         'Return to previous screen')
	call help_key(control.key_table,help_des,key_editdes,
     1         'Edit description')
	call help_key(control.key_table,help_des,key_enter,
     1         'Return to prev screen and use current des;')
	call help_key(control.key_table,help_des,key_select,
     1         'Set current description')
	call help_key(control.key_table,help_des,key_put,
     1         'Add new descriptions')
	call help_key(control.key_table,help_des,key_viewdes,
     1         'View des file')
	call dix_smg_stack_help(control,help_des)
c
c
	n_des = 0
	i_des = 0
	p_des_expanded = file.top_des
	do while(p_des_expanded .ne. 0)
	  n_des = n_des + 1
	  if(p_des_expanded .eq. file.cur_des) i_des = n_des
	  p_des_expanded = des_Expanded.link.forw
	end do
c
	old_raw = file.raw .and. (n_des .eq. 0)
c
	call smg$create_virtual_display(2,control.ncols,dis_id1)
	p_nam = len(dopointer)+1
	p_siz = control.ncols-10
c
	line = ' '
	line(p_nam:) = 'Filename'
	line(p_siz:) = '  Filesize'
	call smg$put_chars(dis_id1,line(1:control.ncols),2,1,,smg$m_underline)
	call smg$paste_virtual_display(dis_id1,control.paste_id,3,1)
c
c Now the data
c
	view_size = min(control.nrows-5,n_des+1)
	call smg$create_virtual_display(n_des+1,control.ncols,dis_id)
	call smg$create_viewport(dis_id,1,1,view_size,control.ncols)
	p_des_expanded = file.top_des
	do k=1,n_des
	  p_des = des_expanded.p_des_info
	  call dix_des_display(control,des,line,nk,.false.)
	  if(nk .ge. p_siz-p_nam) then
	    call dix_des_display(control,des,line,nk,.true.)
	  endif
	  call smg$put_chars(dis_id,line(1:nk),k,p_nam)	  
c
	  call sys$fao('!10UL',nk,line,%val(des.nl_des))
	  call smg$put_chars(dis_id,line(1:nk),k,p_siz)
c
	  p_des_expanded = des_expanded.link.forw
	end do
	call smg$paste_virtual_display(dis_id,control.paste_id,5,1)
c
	if(i_des .gt. 0) call smg$put_chars(dis_id,dopointer,i_des,1)
	ipos = i_des
c
	scr_pos = 1
c
	n_old_des = n_des-1	!to force display
c
10	if(n_old_des .ne. n_des) then
	  call sys$fao('Directory of !UL descriptions',nk,line,%val(n_des))
	  call smg$put_chars(dis_id1,line(1:nk),1,1)
	  n_old_des = n_des
	endif
c
	if(n_des .gt. 0) then
	  p_des_expanded = file.top_des
	  do k=1,i_des-1
	    p_des_expanded = des_expanded.link.forw
	  end do
	  p_des = des_expanded.p_des_info
	else
	  ipos = 1	!set cursor to first line
	endif
c
c Make sure in screen
c
	do while(ipos .lt. scr_pos)
	  scr_pos = scr_pos - 1
	  call smg$scroll_viewport(dis_id,smg$m_down,1)
	end do
	do while(ipos-scr_pos .ge. view_size)
	  scr_pos = scr_pos + 1
	  call smg$scroll_viewport(dis_id,smg$m_up,1)
	end do
c##
	call smg$set_cursor_abs(dis_id,ipos,1)
	call dix_get_key(control,iterm)
c
15	if(iterm .eq. key_up) then
	  if(ipos .gt. 1) ipos = ipos-1
	elseif(iterm .eq. key_down) then
	  if(ipos .lt. n_des) ipos = ipos+1
	elseif(iterm .eq. key_prev) then
	  ipos = max(1,ipos-10)
	elseif(iterm .eq. key_next) then
	  ipos = min(n_des,ipos+10)
	elseif(iterm .eq. key_top) then
	  ipos = 1
	elseif(iterm .eq. key_bot) then
	  ipos = n_des
	elseif(iterm .eq. key_left) then
	elseif(iterm .eq. key_right) then
	elseif(iterm .eq. key_viewdes) then
	  call dix_smg_view_des_file(control,des)
	elseif(iterm .eq. key_put) then
	  line = ' '
	  call dix_smg_get_str(control,'Description file',line(1:50),iterm)
	  if(line .ne. ' ') then
	    nk = dix_util_get_len_fu(line)
c
c Remember current last description
c
	    p_des_expanded = file.top_des
	    k = 0
	    do while(p_des_expanded .ne. 0)
	      k = p_des_expanded
	      p_des_expanded = des_expanded.link.forw
	    enddo
c
	    if(.not. dix_des_get_all(control,file,line(1:nk),.false.)) then
	      call dix_message(control,dix_msg_filnotop,line(1:nk))
	      goto 10
	    endif
	    call dix_des_check_expand_all(control,file)
	    p_des_expanded = k
	    if(p_des_expanded .eq. 0) then
	      p_des_expanded = file.top_des
	    else
	      p_des_expanded = des_Expanded.link.forw
	    endif
	    do while(p_des_expanded .ne. 0) 
	      p_des = des_expanded.p_des_info
	      n_des = n_des + 1
	      call smg$change_virtual_display(dis_id,n_des+1)
	      view_size = min(control.nrows-5,n_des+1)
	      call smg$change_viewport(dis_id,1,1,view_size,control.ncols)
c
	      call sys$fao('!10UL',nk,line,%val(des.nl_des))
	      call smg$put_chars(dis_id,line(1:nk),n_des,p_siz)
c
	      call dix_des_display(control,des,line,nk,.false.)
	      if(nk .gt. p_siz-p_nam) then
	        call dix_des_display(control,des,line,nk,.true.)
	      endif
	      call smg$put_chars(dis_id,line(1:nk),n_des,p_nam)	  
	      p_des_expanded = des_expanded.link.forw
	    end do
	    call smg$put_chars(dis_id,unpointer,i_des,1)
 	    i_des = n_des
	    call smg$put_chars(dis_id,dopointer,i_des,1)
	    ipos  = n_des
	  end if
	elseif(iterm .eq. key_select) then
	  if(n_des .gt. 0) then
	    call smg$put_chars(dis_id,unpointer,i_des,1)
	    i_des = ipos
	    call smg$put_chars(dis_id,dopointer,i_des,1)
	  end if
	elseif(iterm .eq. key_remove) then
	  if(n_des .gt. 0) then
	    call smg$delete_line(dis_id,ipos,1)
c
c remove all tables from des
c
	    call dix_des_link_out(control,file,des_expanded)
	    n_des = n_des - 1
	    if(n_des .gt. 0) then
c
	      if(i_des .eq. ipos) then
	        call smg$put_chars(dis_id,unpointer,ipos,1)
	        i_des = max(1,ipos-1)
	        ipos = i_des
	        call smg$put_chars(dis_id,dopointer,ipos,1)
	      endif
	    endif
	    view_size = min(control.nrows-5,n_des+1)
	    call smg$change_virtual_display(dis_id,view_size)
	  end if
	elseif(iterm .eq. key_editdes) then
	  if(n_des .gt. 0) then
	    istat = dix_edit_des(control,file,des,' ',0,err_arg)
	    if(istat) then
	      call dix_des_display(control,des,line,nk,.false.)
	      if(nk .ge. p_siz-p_nam) then
	        call dix_des_display(control,des,line,nk,.true.)
	      endif
	      call smg$put_chars(dis_id,line(1:nk),ipos,p_nam)	  
	    else
	      l = dix_util_get_len_fu(err_arg)
	      call dix_message(control,istat,err_arg(1:l))
	    end if
	  endif
	elseif(iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_enter) then
	  if(n_des .gt. 0) i_des = ipos
	  goto 90
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	else
	  call dix_mes_invkey(control)
	end if
	goto 10
90	if(n_des .eq. 0) then
	  p_des_expanded = 0
	else
	  p_des_expanded = file.top_des
	  do k=1,i_des-1
	    p_des_expanded = des_expanded.link.forw
	  end do
	endif
	file.cur_des = p_des_expanded
c
c If we were in raw mode because there was no description
c and now we do have a description, change mode to desc
c
	if(file.cur_des .ne. 0 .and. old_raw) file.raw = .false.
c
	call smg$delete_virtual_display(dis_id)
	call smg$delete_virtual_display(dis_id1)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
c
99	return
	end
	subroutine dix_smg_view_des_file(control,des)
	implicit none
	include 'dix_def.inc'
	record /control/ control
	record /des_info/ des
c
	integer*4 lun_memtab,istat,nlin,nk
	character*(max_filename_length) fnam
c
	integer*4 memtab_open
	integer*4 dix_lbr_get_module
c                                  
	if(des.in_library .eq. des_in_file) then
	  istat = memtab_open(des.fnam(1:des.nk_fnam),lun_memtab,nlin)
	else
          istat = dix_lbr_get_module(control,des.fnam(1:des.nk_fnam),
     1            lun_memtab,nlin,des.in_library)
	endif
	call dix_des_display(control,des,fnam,nk,.true.)
	if(istat) call dix_smg_view_memtab(control,lun_memtab,
     1              fnam(1:nk),18,.false.)
	call memtab_close(lun_memtab)
	return
	end

	subroutine dix_smg_select_module(control,match,modnam,nk_mod)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) match
	character*(*) modnam
	integer*4 nk_mod
c
	integer*4 lbr_index,nk_cur,context,nk_f,nk
	logical*4 got_lib
	character*(max_filename_length) imagname
	character*(max_line_length) line
	logical*4 lbr$open
	integer*4 lib$find_file
	integer*4 dix_util_get_len
c
	include '($lbrdef)'
	include '($jpidef)'
c
	external dix_smg_get_names
	integer*4 phase,n_modules,idx,dis_id,maxl
	common /lbr_data/phase,n_modules,idx,dis_id,maxl
c
	call lib$getjpi(jpi$_imagname,,,,imagname,nk_cur)
	do while(imagname(nk_cur:nk_cur) .ne. ']') 
	  nk_cur = nk_cur-1
	end do
c
	call lbr$ini_control(lbr_index,lbr$c_read,lbr$c_typ_txt)
	got_lib = lbr$open(lbr_index,'DIX_DES',,imagname(1:nk_cur)//'.TLB')
	n_modules = 0
	idx  = 0
	do phase=1,2
	  context = 0
	  do while(lib$find_file(match,line,context,'.des'))
	    if(phase .eq. 1) then
	      n_modules = n_modules + 1
c	      nk_f = index(line,' ')-1
	      nk_f = dix_util_get_len(line)
	      if(nk_f .gt. maxl) maxl = nk_f
	    else
	      idx = idx + 1
	      call smg$put_chars(dis_id,line(1:nk_f),idx,1)	     
	    end if	    
	  end do
	  call lib$find_file_end(context)
	  if(got_lib) call lbr$get_index(lbr_index,1,dix_smg_get_names,match)
c
c Create display with size big enough
c
	  if(phase .eq. 1) then
	    call sys$fao('Directory of !UL modules',nk,line,%val(n_modules))
	    call smg$create_virtual_display(n_modules,max(nk+2,min(70,maxl)),
     1                       dis_id)
	    call smg$label_border(dis_id,line(1:nk))
	  endif
c
c Let user select item
c
	end do
	call lbr$close(lbr_index)
	call dix_smg_select_module_1(control,dis_id,n_modules,modnam,nk_mod)
	call smg$delete_virtual_display(dis_id)
	return
	end

	function dix_smg_get_names(name)  !,rfa)
	implicit none
c
	character*(*) name
c	integer*4 rfa(2)
	integer*4 dix_smg_get_names
c
	integer*4 istat
	integer*4 smg$put_chars
c
	integer*4 phase,n_modules,idx,dis_id,maxl
	common /lbr_data/phase,n_modules,idx,dis_id,maxl
c
	if(phase .eq. 1) then
	  if(len(name) .gt. maxl) maxl = len(name)
	  n_modules = n_modules + 1
	else
	  idx = idx + 1
	  istat = smg$put_chars(dis_id,name,idx,1)
	  if(.not. istat) call lib$signal(%val(istat))
	endif
	dix_smg_get_names = 1
	return
	end
	subroutine dix_smg_select_module_1(control,dis_id,nmod,modnam,nk_mod)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	integer*4 dis_id
	integer*4 nmod
	character*(*) modnam
	integer*4 nk_mod
c
c
	include '($smgdef)'

	integer*4 ipos,scr_pos,iterm,view_size
c
	integer*4 dix_util_get_len
c
	record /dyn_help/ help_des
c
c Init help-text
c
	call help_init_std(control,help_des,'select modules',20,15)
	call help_key(control.key_table,help_des,key_exit,
     1              'Return to previous screen')
	call help_key(control.key_table,help_des,key_enter,
     1    'Return to prev screen and use current module')
	call dix_smg_stack_help(control,help_des)
c
c Create scroll window with data
c
	view_size = control.nrows-5
	call smg$create_viewport(dis_id,1,1,view_size,control.ncols)
	call smg$paste_virtual_display(dis_id,control.paste_id,5,1)
c
	ipos = 1
	scr_pos = 1
c
c Make sure in display
c
10	do while(ipos .lt. scr_pos)
	  scr_pos = scr_pos - 1
	  call smg$scroll_viewport(dis_id,smg$m_down,1)
	end do
c
	do while(ipos-scr_pos .ge. view_size)
	  scr_pos = scr_pos + 1
	  call smg$scroll_viewport(dis_id,smg$m_up,1)
	end do
c
	call smg$set_cursor_abs(dis_id,ipos,1)
	call dix_get_key(control,iterm)
15	if(iterm .eq. key_up) then
	  if(ipos .gt. 1) ipos = ipos-1
	elseif(iterm .eq. key_down) then
	  if(ipos .lt. nmod) ipos = ipos+1
	elseif(iterm .eq. key_prev) then
	  ipos = max(1,ipos-10)
	elseif(iterm .eq. key_next) then
	  ipos = min(1,ipos+10)
	elseif(iterm .eq. key_top) then
	  ipos = 1
	elseif(iterm .eq. key_bot) then
	  ipos = nmod
	elseif(iterm .eq. key_left) then
	elseif(iterm .eq. key_enter) then
	  goto 80
	elseif(iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	else
	  call dix_mes_invkey(control)
	end if
	goto 10
80	call smg$read_from_display(dis_id,modnam,,ipos)
c	nk_mod = index(modnam,' ')-1
	nk_mod = dix_util_get_len(modnam)
	goto 99
90	modnam = ' '
99	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end

	subroutine dix_smg_view_file(control,lun_inp,header)
	implicit none
c
c View a file open on lun "lun_inp"
c  set header text to "header"
c
	include 'dix_def.inc'
	record /control/ control	!:io: control
	integer*4 lun_inp		!:i: lun on which file open
	character*(*) header		!:i: header text
c
	integer*4 lun_memtab,nlines,istat
	integer*4 memtab_open_lun
c
c Copy to memtab
c
	rewind(lun_inp)
	istat = memtab_open_lun(lun_inp,lun_memtab,nlines)
c
c And display it
c
	if(istat) call dix_smg_view_memtab(control,lun_memtab,
     1                header,18,.false.)
	call memtab_close(lun_memtab)
	return
	end
	subroutine dix_smg_view_memtab(control,lun_memtab,
     1              header,view_size,check_bold)
	implicit none
c
c View a file open on LUN_MEMTAB
c  with header "header"
c
	include 'dix_def.inc'
	record /control/ control	!:i: control
	integer*4 lun_memtab             !:i: lun on which memtabfile open
	character*(*) header		!:i: header text
	integer*4 view_size		!:i: length of vieuw_port
	logical check_bold		!:i: check for first char :, => bold
c
	character*(max_line_length) line,orgline
	integer*4 dis_id,nk,nlin,ipos,jpos,top_line,bpos,nk1
	integer*4 n_lines,width
	logical got_bold
c
	character*(*) bold_seq,norm_seq
        parameter (bold_seq = char(27)//'[1;7m')        !bold/reverse
        parameter (norm_seq = char(27)//'[m')
c
	logical memtab_read
c
	include '($smgdef)'
c
c Create display
c
	call memtab_get_nlines(lun_memtab,n_lines)
	call memtab_get_max_width(lun_memtab,width)
	width = max(70,min(width,len(line)))
	call smg$create_virtual_display(n_lines,width,dis_id)
	call smg$create_viewport(dis_id,1,1,view_size,
     1              min(width,control.ncols))
	nk1 = min(len(header),width-5)
	call smg$label_border(dis_id,'File:'//header(1:nk1))
c
	call memtab_rewind(lun_memtab)
	nlin = 0
	do while(memtab_read(lun_memtab,nk,line))
	  nlin = nlin + 1
	  orgline = ' '
	  bpos = 1
	  got_bold = .false.
	  if(check_bold) then
	    if(line(1:1) .eq. ':') then
	      orgline(1:1) = 'B'
	      orgline(nk-1:nk-1) = 'X'
	      bpos = 2
	      got_bold = .true.
	    endif
	  else
c
c 
c
10	    ipos = index(line,bold_seq)
	    if(ipos .ne. 0) then
	      jpos = index(line,norm_seq)
	      if(jpos .gt. ipos) then
	        line = line(1:ipos-1)//line(ipos+len(bold_seq):jpos-1)//
     1               line(jpos+len(norm_seq):nk)
	        jpos = jpos - len(bold_seq)-1
	        orgline(ipos:ipos) = 'B'
	        orgline(jpos:jpos) = 'X'
	        nk = nk - len(norm_seq) - len(bold_seq)
	        got_bold = .true.
	        goto 10
	      end if
	    endif
	  endif
	  call smg$put_chars(dis_id,line(bpos:nk),nlin,1)
	  if(got_bold) then
20	    ipos = index(orgline,'B')
	    jpos = index(orgline,'X')
	    if(ipos .ne. 0) then
	      orgline(ipos:ipos) = ' '
	      orgline(jpos:jpos) = ' '
	      call smg$change_rendition(dis_id,nlin,ipos,1,
     1               jpos-ipos+1,smg$m_bold .or. smg$m_reverse)
	      goto 20
	    end if
	  end if
	end do
c
	top_line = max(2,(control.nrows - view_size)/2)
	call smg$paste_virtual_display(dis_id,control.paste_id,top_line,1)
	call  dix_smg_show(control,dis_id,n_lines,view_size,-1,0,'View file',
     1          width,min(width,control.ncols))
	call smg$delete_virtual_display(dis_id)
	return
	end

	function dix_smg_find_string(control,dis_id,nk_se,sear_string,
     1                    row,col,nlines,forward)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
c
	integer*4 dis_id
	integer*4 nk_se
	character*(*) sear_string
	integer*4 row
	integer*4 col
	integer*4 nlines
	logical*4 forward
	logical*4 dix_smg_find_string
c
	include '($smgdef)'
c
	character*(max_short_line_length) sear_up
c
	integer*4 yp,jpos,lent,d_id,iterm
	character*(max_screen_width) regel
	external dix_msg_seanotf
c
	if(nk_se .eq. 0) then
	  sear_string = ' '
	  lent = len(sear_string)
	  call smg$create_virtual_display(3,lent+7,d_id,smg$m_border)
	  call smg$paste_virtual_display(d_id,control.paste_id,10,
     1               control.ncols-10-lent)
	  call smg$label_border(d_id,'Search string')
	  call smg$put_chars(d_id,'Search:',1,1)
	  iterm = 0
c	  call smg$set_keypad_mode(keyboard_id,smg$m_keypad_application)
	  call dix_smg_get_string(control,d_id,1,9,lent,sear_string,0,iterm,
     1                 nk_se,.false.)
	  if(iterm .eq. key_set_forw ) forward = .true.
	  if(iterm .eq. key_set_backw) forward = .false.
c	  call smg$set_keypad_mode(keyboard_id,0)
	  call smg$delete_virtual_display(d_id)
	end if
	yp = row
c
	dix_smg_find_string =.true.
	if(nk_se .eq. 0) goto 80
c
	call str$upcase(sear_up,sear_string)
	if(.not. forward) call dix_smg_rever(sear_up(1:nk_se))
c
10	call smg$read_from_display(dis_id,regel,,yp)
	call str$upcase(regel,regel)
	if(.not. forward) call dix_smg_rever(regel)
	if(yp .eq. row) then
c
c search on current line
c
	  if(forward) then
	    jpos = col
	    col = index(regel(col+1:),sear_up(1:nk_se))
	    if(col .ne. 0) col = col+jpos
	  else
	    if(col .eq. 1) then
	      col = 0
	    end if
	    if(col .eq. 0) col = len(regel)+1
	    jpos = col
	    col = index(regel(len(regel)-col+2:),sear_up(1:nk_se))
	    if(col .ne. 0) col = jpos-col-nk_se+1
	  end if
	else
c
c On non current line we can search all positions
c
	  col = index(regel,sear_up(1:nk_se))
	  if(col .ne.0 .and. .not. forward) col = len(regel)-col+1-nk_se+1
	end if	
	if(col .ne. 0) then
	  row= yp
	  goto 90
	end if
c
c Not found, so try next line
c
	if(forward) then
	  yp = yp+1
	  if(yp .gt. nlines) goto 80
	else
	  yp = yp-1
	  if(yp .eq. 0) goto 80
	end if
	goto 10
c
80	call smg$ring_bell(dis_id)
	dix_smg_find_string =.false.
	call dix_message(control,dix_msg_seanotf)
90	return
	end

	subroutine dix_smg_rever(text)
	implicit none
c
	character*(*) text
	character hulp
c
	integer*4 ipos_e,ipos_b
c
	ipos_e = len(text)
	ipos_b = 1
	do while(ipos_b .lt. ipos_e)
	  hulp = text(ipos_b:ipos_b)
	  text(ipos_b:ipos_b) = text(ipos_e:ipos_e)
	  text(ipos_e:ipos_e) = hulp
	  ipos_b = ipos_b + 1
	  ipos_e = ipos_e - 1
	end do
	return
	end

	function dix_smg_question(control,message,default)
	implicit none
c
	include 'dix_def.inc'
c
	record /control/ control
	character*(*) message
	logical*4 dix_smg_question
	logical default
	include '($smgdef)'
c
        character kar
	character dix_util_upcase_kar
c
	integer*4 iterm,dis_id,linenr
	external dix_msg_yesnomes
c
	call smg$create_virtual_display(1,max(25,len(message)+10),dis_id)
	call smg$label_border(dis_id,'Questions-answers')
	linenr = max(1,control.nrows - 2 - control.nlin_dis_err)
	call smg$paste_virtual_display(dis_id,control.paste_id,linenr,1)
9	if(default) then
	  call smg$put_chars(dis_id,message//' [y]/n:  ',1,1)
	else
	  call smg$put_chars(dis_id,message//' y/[n]:  ',1,1)
	endif
10	call dix_get_key(control,iterm)
	if(iterm .eq. key_help) then
	  call dix_message(control,dix_msg_yesnomes)
	  goto 10
	end if
c
	if(iterm .eq. key_enter) then
	  kar = 'N'
	  if(default) kar = 'Y'
	else
	  kar = dix_util_upcase_kar(char(iterm))
	endif
	if(kar .ne. 'Y' .and. kar .ne. 'N')goto 9
c
	dix_smg_question= kar .eq. 'Y'
	call smg$delete_virtual_display(dis_id)
	return
	end

	subroutine dix_smg_out_of_band(control)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	include '($smgdef)'
c
	integer*4 iterm
	external dix_smg_out_of_band_ast
c
	iterm = 2**smg$k_trm_ctrlc 
c
	call smg$set_out_of_band_asts(control.paste_id,iterm,
     1            dix_smg_out_of_band_ast,control)
	return
	end
c
	subroutine dix_smg_out_of_band_ast(param)
	implicit none
c
	include 'dix_def.inc'
c
	structure /hulp/
	  integer*4 p_id
	  integer*4 arg
	  byte kar
	  byte hulp(3)
	end structure
	record /hulp/ param
c
	record /control/ control
	pointer (p_control,control)
c
	if(param.kar .eq. 3) then
	  p_control = param.arg
	  control.control_c_seen = .true.
	end if
	return
	end

	function dix_smg_get_int(control,message,val,minval,maxval)
	implicit none
c
	include 'dix_def.inc'
c
	record /control/ control
	character*(*) message
	integer*4 val
	integer*4 minval
	integer*4 maxval
	logical*4 dix_smg_get_int
c
c
	integer*4 iterm,dis_id,col,nkar,k
	character*(max_short_line_length) line
	include '($smgdef)'
c
	external dix_msg_illval
c
	dix_smg_get_int = .false.
	call smg$create_virtual_display(1,40,dis_id)
	call smg$label_border(dis_id,'Number input')
	call smg$paste_virtual_display(dis_id,control.paste_id,
     1           control.nrows-1,1)
10	write(line,1010) message,minval,maxval,val
1010	format('Give ',a,'(',i5,'-',i5,') : ',i5)
	call smg$put_chars(dis_id,line,1,1)
	col = index(line,':')+2
	k = 0
	call sys$fao('!UL       ',nkar,line,%val(val))
	call smg$put_chars(dis_id,line(1:nkar),1,col)
c
	iterm = 0
	call dix_smg_get_string(control,dis_id,1,col,7,line,0,
     1              iterm,nkar,.false.)
	if(iterm .eq. key_exit) goto 90
	read(line(1:7),2000,err=30) k
2000	format(bn,i7)
	if(k .ge. minval .and. k .le. maxval) then
	  val = k
	  dix_smg_get_int = .true.
	  goto 90
	end if
30	call dix_message(control,dix_msg_illval)
	goto 10
90	call smg$delete_virtual_display(dis_id)
	return
	end

	subroutine dix_smg_get_str(control,message,text,iterm)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) message
	character*(*) text
	integer*4 iterm
c
cc Common for screen display
c
	integer*4 dis_id,col,nkar
	include '($smgdef)'
c
	call smg$create_virtual_display(1,60,dis_id)
	call smg$label_border(dis_id,'Enter '//message)
	call smg$paste_virtual_display(dis_id,control.paste_id,
     1                  control.nrows-1,1)
	call smg$put_chars(dis_id,message//' :',1,1)
	col = len(message)+3
	iterm = 0
	call dix_smg_get_string(control,dis_id,1,col,len(text),text,0,iterm,
     1              nkar,.false.)
	call smg$delete_virtual_display(dis_id)
	return
	end

	subroutine dix_smg_file_info_scr(control,rab,filename,des_expanded)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	include '($rabdef)'
	record /rabdef/ rab
	character*(*) filename
	record /des_expanded/ des_expanded
c
	include '($smgdef)'
c
	integer*4 fabadr,nk,mem_lun,nlines
c
	call memtab_init(mem_lun,'File View')
	control.linenr = 0
c
	fabadr = rab.rab$l_fab
	call dix_rms_file_info_scr(control,mem_lun,%val(fabadr),des_expanded)
c
	call memtab_get_nlines(mem_lun,nlines)
c
	nk = max(60,len(filename))
	call dix_smg_view_memtab(control,mem_lun,
     1              filename(1:nk),15,.true.)
	call memtab_close(mem_lun)
	return
	end

	subroutine dix_smg_show(control,dis_id,nlines,view_size,
     1             beg_lin,res_lin,Topic,ncols,view_cols)
 	implicit none
	include 'dix_def.inc'
	record /control /control
	integer*4 dis_id		!:i: display id
	integer*4 nlines		!:i: #lines in display
	integer*4 view_size		!:i: the vertical size of the viewport
	integer*4 beg_lin		!:i: the begin line to position to
	integer*4 res_lin		!:o: the line we hit the enter
	integer*4 ncols			!:i: width of the display
	integer*4 view_cols		!:i: witdh of the viewport
	character*(*) topic		!:i: topic (header line)
c
	include '($smgdef)'
c
	record /dyn_help/ help_des
 	integer*4 iterm
	integer*4 dix_smg_show_int
c         
c Create help_text
c
	call help_init_std(control,help_des,topic,20,15)
	call help_key(control.key_table,help_des,key_find,
     1              'find text in display')
	call help_key(control.key_table,help_des,key_set_forw,
     1               'Set forward')
	call help_key(control.key_table,help_des,key_set_backw,
     1                'Set backward')
c
	call dix_smg_stack_help(control,help_des)
c
c Now show the text
c
10	iterm = dix_smg_show_int(control,dis_id,nlines,view_size,beg_lin,
     1             res_lin,ncols,view_cols)
	if(iterm .eq. key_help) then
c
c Display help
c
	  call dix_smg_help(control)
	  goto 10
	endif
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end
c
	function dix_smg_show_int(control,dis_id,nlines,view_size,
     1            beg_lin,res_lin,width,view_width)
 	implicit none
	include 'dix_def.inc'
	record /control/ control
	integer*4 dis_id
	integer*4 nlines
	integer*4 view_size
	integer*4 beg_lin
	integer*4 res_lin
	integer*4 width
	integer*4 view_width
	integer*4 dix_SMG_show_int
c
	include '($smgdef)'
c
	logical*4 bold_set,forward
	integer*4 nk_se,bcol,brow,begl,iterm
	character*(max_short_line_length) sear
	common /save_12/ nk_se,forward,bold_set,sear
	data nk_se/0/,forward/.true./
	logical*4 dix_smg_find_string
c
	logical*4 pf1_flag
	integer*4 scr_pos,row,scr_col,col
c
	scr_pos = 1
	row     = 1
	col     = 1
	scr_col = 1
	begl    = 1
	if(beg_lin .gt. 0) begl = beg_lin
c
10	pf1_flag = .false.
11	if(row .lt. begl)   row = begl
	if(row .gt. nlines) row = nlines
	if(col .lt. 1)      col = 1
	if(col-1 + view_width .gt. width) col = width - view_width +1
	do while(row .lt. scr_pos)
	  scr_pos = scr_pos - 1
	  call smg$scroll_viewport(dis_id,smg$m_down,1)
	end do
c
	do while(row-scr_pos .ge. view_size)
	  scr_pos = scr_pos + 1
	  call smg$scroll_viewport(dis_id,smg$m_up,1)
	end do
c
	if(col .lt. scr_col) then
	  call smg$scroll_viewport(dis_id,smg$m_right,scr_col-col)
	elseif(col .gt. scr_col) then
	  call smg$scroll_viewport(dis_id,smg$m_left,col-scr_col)
	endif
	scr_col = col
c
	call smg$set_cursor_abs(dis_id,row,col)

	call dix_get_key(control,iterm)
	if(bold_set) then
	  call smg$change_rendition(dis_id,brow,bcol,1,nk_se,smg$m_bold)
	  bold_set = .false.
	end if
c
c
	if(iterm .eq. key_up) then
	  row = row - 1
	elseif(iterm .eq. key_prev) then
	  row = row - view_size+2
	elseif(iterm .eq. key_down) then
	  row = row + 1
	elseif(iterm .eq. key_next) then
	  row = row+view_size-2
	elseif(iterm .eq. key_top) then
	  row = 1
	elseif(iterm .eq. key_left) then
	  col = col - 1
	elseif(iterm .eq. key_right) then
	  col = col + 1
	elseif(iterm .eq. key_bot) then
	  row = nlines
	elseif(iterm .eq. key_find .or. iterm .eq. key_find1) then
	  if(iterm .eq. key_find1) nk_se = 0
	  if(dix_smg_find_string(control,dis_id,nk_se,sear,brow,bcol,
     1           nlines,forward)) then
	    bold_set = .true.
	    call smg$change_rendition(dis_id,brow,bcol,1,nk_se,,smg$m_bold)
	    row = brow - view_size/2	!make sure in screen
	  end if
	elseif(iterm .eq. key_set_forw) then
	  forward = .true.
	elseif(iterm .eq. key_set_backw) then
	  forward = .false.
	elseif(iterm .eq. key_help) then
	  goto 90		!return help key
	elseif(iterm .eq. key_exit .or. iterm .eq. key_enter) then
	  if(beg_lin .gt. 0) res_lin = row - beg_lin+1
	  goto 90
	else
	  call dix_mes_invkey(control)
	end if
	goto 10
90	dix_smg_show_int = iterm
	return
	end	

	subroutine dix_smg_help(control)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
c
	integer*4 view_size,view_width
	parameter (view_size=15,view_width=70)
c
	integer*4 idx,iterm,orig_row,orig_col,dis_id1
c
	integer*4 dix_smg_show_int
c
	include '($smgdef)'
c
	idx = control.help_depth
c 
c Save the phys cursor
c
	call dix_smg_getset_phys_cursor(control,.false.,orig_row,orig_col)
c
c Compute the #lines and width of the help text
c and fill display
c
10	call dix_smg_help_1(control,
     1               control.help_stack(idx).stack,
     1               control.help_stack(idx).nrow_h,
     1               control.help_stack(idx).ncol_h,
     1               control.help_stack(idx).dis_id)
c
c Clip the viewport to somthing reasonble
c
	control.help_stack(idx).heigth = 
     1    min(control.help_stack(idx).nrow_h,view_size,control.nrows)
	control.help_stack(idx).width  = 
     1    min(control.help_stack(idx).ncol_h,view_width,control.ncols)
c
c Create viewport
c
	call smg$create_viewport(
     1               control.help_stack(idx).dis_id,1,1,
     1               control.help_stack(idx).heigth,
     1               control.help_stack(idx).width)
c
c Past it on the screen
c
	call smg$paste_virtual_display(
     1                         control.help_stack(idx).dis_id,
     1                         control.paste_id,
     1    max(1,control.nrows- control.help_stack(idx).heigth-idx),
     1    max(1,control.ncols- control.help_stack(idx).width-idx))
c
c And look at it
c
12	iterm = dix_smg_show_int(control,
     1               control.help_stack(idx).dis_id,
     1               control.help_stack(idx).nrow_h,
     1               control.help_stack(idx).heigth,
     1               -1,0,
     1               control.help_stack(idx).ncol_h,
     1               control.help_stack(idx).width)
c
c interpret what the user wants
c
	if(iterm .eq. key_help) then
c
c Deeper help, if level=1 display the help file
c
	  if(idx .eq. 1)  then
	    call smg$create_virtual_display(control.nrows,
     1               control.ncols,dis_id1)
	    call smg$paste_virtual_display(dis_id1,control.paste_id,1,1)
	    call dix_help('DIX')
	    call smg$delete_virtual_display(dis_id1)
	    goto 12
	  else
c
c Else display the deeper level
c
	    idx = idx-1
	  end if
	  goto 10
	elseif(iterm .eq. key_enter) then
c
c Skip this help level , return to upper help
c
	  call smg$delete_virtual_display(control.help_stack(idx).dis_id)
	  idx = idx + 1
	  if(idx .le. control.help_depth) goto 12
	endif
c
c Skip all levels
c
	do while(idx .le. control.help_depth)
	  call smg$delete_virtual_display(control.help_stack(idx).dis_id)
	  idx = idx + 1
	end do
c
c And restore phys cursor
c
	call dix_smg_getset_phys_cursor(control,.true.,orig_row,orig_col)
	return
	end
	subroutine dix_smg_help_1(control,lines,nlines,nk,dis_id)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) lines
	integer*4 nlines
	integer*4 nk
	integer*4 dis_id
c
	integer*4 k,nk_helpend
	include '($smgdef)'
	character*(max_screen_width) line,helpend
c
	integer*4 ibpos,iepos,video
c
	call keydefs_get_map(key_enter,control.key_table,nk,line)
	call sys$fao('Type !AS to return to previous screen',
     1                nk_helpend,helpend,line(1:nk))
c
	ibpos  = 1
	nlines = 0
	nk     = nk_helpend		!minimal the help line
c
	do while(ibpos .lt. len(lines))
	  iepos = index(lines(ibpos:),';')
	  if(iepos .eq. 0) then
	    iepos = len(lines)
	  else
	    iepos = ibpos + iepos - 2
	  end if
	  if(iepos-ibpos+1 .gt. nk) nk = iepos-ibpos+1
	  nlines = nlines + 1
	  ibpos = iepos + 2
	end do
	nlines = nlines + 1		!for the message to return
c
c	if(nk .gt. control.ncols) nk = control.ncols
c
	call smg$create_virtual_display(nlines,nk,dis_id)
	ibpos = 1
	do k=1,nlines
	  iepos = index(lines(ibpos:),';')
	  if(iepos .eq. 0) then
	    iepos = len(lines)
	  else
	    iepos = ibpos + iepos - 2
	  end if
	  if(k .eq. 1) then
	    call smg$label_border(dis_id,'Help on '//lines(ibpos:iepos))
	  else
	    video = 0
	    if(lines(ibpos:ibpos) .eq. ':') then
	      video = smg$m_bold
	      ibpos = ibpos + 1
	    end if
	    call smg$put_line(dis_id,lines(ibpos:iepos),,video)
	  end if
	  ibpos = iepos + 2
	end do	 
c
	video = smg$m_bold
	call smg$put_line(dis_id,helpend(1:nk_helpend),,video)
c
90	return
	end
	function dix_smg_get_string_multi(control,d_id,row_inp,
     1                              col_inp,nlin,lent,
     1                              string,video_inp,iterm,nkar,col1)
c
	implicit none		
	include 'dix_def.inc'
        record /control/ control
	integer*4 d_id		!:i: display id to read from
	integer*4 row_inp	!:i: row
	integer*4 col_inp	!:i: col of string
	integer*4 nlin 		!:io: #lines on screen
	integer*4 lent		!:i: length of string to reead
	character*(*) string	!:io: result string
	integer*4 video_inp	!:i: video mode
	integer*4 iterm		!:io: teminator
	integer*4 nkar		!:io: string length
	integer*4 col1		!:i: col for separator
	logical*4 dix_smg_get_string_multi		!:i: true if changed
c
	include '($smgdef)'
c
	logical*4 dix_util_kar_in_ran
	logical*4 dix_con_kar_to_hex
	character dix_util_kar_conv
c
	external dix_msg_illhexchar
	external dix_msg_nomorel
	external dix_msg_onfirst
	external dix_msg_endfield
	external dix_msg_strfull
	external dix_msg_hexmode1
	external dix_msg_hexmode2
	external dix_msg_stafield
	external dix_msg_kardisp
	external dix_msg_clear
c
	integer*4 ipos,k,l,video,col,row,ibpos,iepos,dpos
	integer*4 nlin_needed,nk
	logical*4 insert
	character*(max_screen_width) line
c
	integer*4 max_pos
	record /dyn_help/ help_des
c
c Build help text
c
	call help_init_std(control,help_des,'get string',20,19)
	call help_key(control.key_table,help_des,key_swap_dis,
     1            'HEX info about char')
	call dix_smg_stack_help(control,help_des)
c
	video = video_inp .or. smg$m_underline
	max_pos = len(string)
c
c
c string is equal to text on screen
c nlin   is equal to #lines on screen
c nkar   is #chars in text
c
5	if(iterm .eq. key_enter .or. iterm .eq. key_right) iterm = 0
	ibpos = 1
	row = row_inp
	do while(ibpos .le. nkar) 
	  iepos = min(nkar,ibpos+lent-1)
	  call smg$change_rendition(d_id,row,col_inp,1,iepos-ibpos+1,video)
	  row = row+1
	  ibpos= iepos+1
	end do
c
	if(iterm .lt. 0) then
	  iterm = key_right
	end if
c
	ipos = 1
	insert = .false.
10	if(ipos .gt. nkar) ipos = nkar+1
	if(ipos .lt. 1) ipos = 1
c
	row = row_inp + (ipos-1)/lent
	col = col_inp + mod(ipos-1,lent)
	call smg$set_cursor_abs(d_id,row,col)
	if(iterm .eq. 0) call dix_get_key(control,iterm)
c
c
	if(iterm .eq. key_toggle) then
	  insert = .not. insert
	elseif(iterm .eq. key_last) then
	  ipos = nkar+1
	elseif(iterm .eq. key_first) then
	  ipos = 1
	elseif(iterm .eq. key_down) then
	  if(row-row_inp .le. nlin-2) then
	    ipos = ipos + lent
	  else
	    call dix_message(control,dix_msg_nomorel)
	  end if
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	elseif(iterm .eq. key_up) then
	  if(row .gt. row_inp) then
	    ipos = ipos - lent
	  else
	    call dix_message(control,dix_msg_onfirst)
	  end if
	elseif(iterm .eq. key_right) then
	  if(ipos .le. nkar) then
	    ipos = ipos + 1
	  else
	    call dix_message(control,dix_msg_endfield)
	  end if
	elseif(iterm .eq. key_left) then
	  if(ipos .gt. 1) then
	    ipos = ipos - 1
	  else
	    call dix_message(control,dix_msg_stafield)
	  end if
	elseif(iterm .eq. key_erase) then
	  string = ' '
	  nkar = 0
	  ipos = 1
	  dpos = 1
	  goto 60
	elseif(iterm .eq. key_delete) then
	  if(ipos .gt. 1) then
	    dix_smg_get_string_multi = .true.
	    string(ipos-1:nkar) = string(ipos:nkar)//' '
	    nkar = nkar - 1
	    dpos = ipos
	    ipos = ipos-1
	    goto 60
	  else
	    call dix_message(control,dix_msg_stafield)
	  end if
	elseif(iterm .eq. key_enter .or. 
     1         iterm .eq. key_set_forw   .or.
     1         iterm .eq. key_Set_backw   .or.
     1         iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_swap_dis) then
	  call dix_message(control,dix_msg_kardisp,
     1            %val(ipos),
     1            %val(ichar(string(ipos:ipos))),
     1            %val(ichar(string(ipos:ipos))),
     1            %val(ichar(string(ipos:ipos))))
	elseif(dix_util_kar_in_ran(iterm) .or. iterm .eq. key_swap_num) then
	  if(iterm .eq. key_swap_num) then
	    call dix_message(control,dix_msg_hexmode1)
	    call smg$set_cursor_abs(d_id,row,col)
	    call smg$read_keystroke(control.keyboard_id,iterm)
	    if(.not. dix_con_kar_to_hex(char(iterm),k)) goto 55
c
	    call dix_message(control,dix_msg_clear)
	    call dix_message(control,dix_msg_hexmode2)
	    call smg$set_cursor_abs(d_id,row,col)
	    call smg$read_keystroke(control.keyboard_id,iterm)
	    if(.not. dix_con_kar_to_hex(char(iterm),l)) goto 55
	    iterm = k*16+l
	    call dix_message(control,dix_msg_clear)
	  end if
	  if(ipos .le. max_pos) then
	    dix_smg_get_string_multi = .true.
	    if(insert) then
	      if(nkar .eq. max_pos) then
	        call dix_message(control,dix_msg_strfull)
	        goto 50
	      else
	        nkar = nkar + 1
	        string(1:nkar) = string(1:ipos-1)//char(iterm)//
     1                         string(ipos:max_pos-1)
	      end if
	    else
	      string(ipos:ipos) = char(iterm)
	      if(ipos .gt. nkar) nkar = ipos
	    end if
	    dpos = ipos
	    ipos = ipos + 1
	    goto 60
	  else
	    call dix_message(control,dix_msg_strfull)
	  end if
	else
	  call dix_mes_invkey(control)
	end if
50	iterm = 0
	goto 10
55	call dix_message(control,dix_msg_illhexchar)
	iterm = 0
	goto 10
c
c Redisplay data from dpos upto nkar
c
60	nlin_needed = max(1,(nkar+lent-1)/lent)
	if(nlin .gt. nlin_needed) then
	  call smg$delete_line(d_id,row_inp+nlin_needed,nlin-nlin_needed)
	  call smg$get_display_attr(d_id,k)
	  call smg$change_virtual_display(d_id,k-nlin+nlin_needed)
	elseif(nlin .lt. nlin_needed) then
	  call smg$get_display_attr(d_id,k)
	  call smg$change_virtual_display(d_id,k+nlin_needed-nlin)
c
c Make room for a lot of lines
c
	  line = ' '
	  do k=nlin+1,nlin_needed
	    call smg$insert_line(d_id,row_inp+nlin,line,smg$m_down)	!insert here
	    call smg$draw_char(d_id,smg$m_up,row_inp+k-1,col_inp-1)
	    if(col1 .ne. 0)call smg$draw_char(d_id,smg$m_up,row_inp+k-1,col1)
	  end do
c
c And blank them out
c
	end if
	nlin = nlin_needed
	do k=1,nlin
	  ibpos = (k-1)*lent+1
	  iepos = k*lent
	  if(ibpos .le. nkar .and. iepos .ge. dpos) then
	    if(iepos .gt. nkar) iepos = nkar
	    nk = iepos-ibpos+1
	    line = string(ibpos:iepos)
c	    
	    do l=1,nk
	      line(l:l) = dix_util_kar_conv(line(l:l))
	    end do
c
	    call smg$put_chars(d_id,line(1:nk),row_inp+k-1,col_inp,,video)
	  end if
	end do
c
c if nkar<lent*nlin display nkar+1 as space
c
	if(nkar .lt. nlin*lent) then
	  row = nkar/lent+row_inp
	  col = mod(nkar,lent)+col_inp
          call smg$put_chars(d_id,' ',row,col,,0)
	end if	
	goto 50
90	continue
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end		

	function dix_smg_get_string(control,d_id,row_inp,col_inp,lent,
     1                    string,video_inp,iterm,nkar,at_end)
c
	implicit none		
	include 'dix_def.inc'
	record /control/ control
	integer*4 d_id		!:i: display id to read from
	integer*4 row_inp	!:i: row
	integer*4 col_inp	!:i: col of string
	character*(*) string	!:o: result string
	integer*4 lent		!:i: max string length
	integer*4 video_inp	!:i: video mode
	integer*4 iterm		!:io: teminator
	integer*4 nkar		!:o: string length
	logical at_end		!:i: goto end of string
	logical*4 dix_smg_get_string		!:i: true if changed
c
	include '($smgdef)'
c
	logical*4 dix_util_kar_in_ran
	logical*4 dix_con_kar_to_hex
c
	integer*4 ipos,k,l,video,col,row,string_len
	integer*4 string_pos
	logical*4 insert
	character*(max_screen_width) line
c
	external dix_msg_illhexchar
	external dix_msg_endfield
	external dix_msg_strfull
	external dix_msg_hexmode1
	external dix_msg_hexmode2
	external dix_msg_stafield
	external dix_msg_kardisp
	external dix_msg_clear
c
	integer*4 max_pos
	record /dyn_help/ help_des
c
c Build help text
c
	call help_init_std(control,help_des,'get string',20,19)
	call help_key(control.key_table,help_des,key_enter,
     1               'All done')
	call help_key(control.key_table,help_des,key_swap_dis,
     1               'Display in HEX')
	call dix_smg_stack_help(control,help_des)
c
	video = video_inp .or. smg$m_underline
	string_len = min(len(line),len(string),lent)
	max_pos    = string_len+1
c
	dix_smg_get_string = .false.
	call smg$read_from_display(d_id,line,,row_inp)
	if(at_end) then
c
c Cursor is at end of string
c
	  string = line(max(1,col_inp-string_len+1):col_inp)
	  string_pos = col_inp - string_len + 1
	else
c
c Cursor is at the beginning
c
	  string = line(col_inp:min(len(line),col_inp+string_len-1))
	  string_pos = col_inp
	endif
c
c Get max length
c
	do nkar=string_len,1,-1
	  if(string(nkar:nkar) .ne. ' ') goto 5
	end do
	nkar = 0
5	if(iterm .eq. key_enter .or.iterm .eq. key_right) iterm = 0
c
	if(iterm .lt. 0) then
	  iterm = key_right
	end if
c
	if(at_end) then
	  insert = .true.
	  ipos = string_len+1
	else
	  insert = .false.
	  ipos = 1
	endif
	call smg$change_rendition(d_id,row_inp,string_pos,1,nkar,video)
10	if(ipos .gt. max_pos) ipos = max_pos
	if(ipos .lt. 1) ipos = 1
c
	row = row_inp
	col = string_pos + ipos-1
	call smg$set_cursor_abs(d_id,row,col)
	if(iterm .eq. 0) call dix_get_key(control,iterm)
c
	if(iterm .eq. key_toggle) then
	  insert = .not. insert
	elseif(iterm .eq. key_last) then
	  ipos = nkar
	elseif(iterm .eq. key_first) then
	  ipos = 1
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	elseif(iterm .eq. key_right) then
	  if(ipos .lt. max_pos) then
	    ipos = ipos + 1
	  else
	    call dix_message(control,dix_msg_endfield)
	  end if
	elseif(iterm .eq. key_left) then
	  if(ipos .gt. 1) then
	    ipos = ipos - 1
	  else
	    call dix_message(control,dix_msg_stafield)
	  end if
	elseif(iterm .eq. key_erase) then
	  string = ' '
	  call smg$put_chars(d_id,string,row_inp,string_pos,,video)
	  nkar = 0
	  ipos = 1
	elseif(iterm .eq. key_delete) then
	  if(ipos .gt. 1) then
	    dix_smg_get_string = .true.
	    if(at_end) then
	      string(1:string_len) = ' '//string(1:ipos-2)//
     1                                    string(ipos:string_len)
	    else
	      string(1:string_len) = string(1:ipos-2)//
     1                               string(ipos:string_len)
	      ipos = ipos - 1
	    endif
	    goto 52
	  else
	    call dix_message(control,dix_msg_stafield)
	  end if
	elseif(iterm .eq. key_enter .or. 
     1         iterm .eq. key_set_forw .or.
     1         iterm .eq. key_set_backw   .or.
     1         iterm .eq. key_exit) then
	  goto 90
	elseif(iterm .eq. key_swap_dis) then
	  call dix_message(control,dix_msg_kardisp,
     1            %val(ipos),
     1            %val(ichar(string(ipos:ipos))),
     1            %val(ichar(string(ipos:ipos))),
     1            %val(ichar(string(ipos:ipos))))
	elseif(dix_util_kar_in_ran(iterm) .or. iterm .eq.key_swap_num) then
	  if(iterm .eq. key_Swap_num) then
	    call dix_message(control,dix_msg_hexmode1)
	    call smg$read_keystroke(control.keyboard_id,iterm)
	    if(.not. dix_con_kar_to_hex(char(iterm),k)) goto 55
	    call dix_message(control,dix_msg_clear)
	    call dix_message(control,dix_msg_hexmode2)
	    call smg$read_keystroke(control.keyboard_id,l)
	    if(.not. dix_con_kar_to_hex(char(iterm),l)) goto 55
	    iterm = k*16+l
	    call dix_message(control,dix_msg_clear)
	  end if
	  if(ipos .le. max_pos) then
	    dix_smg_get_string = .true.
	    if(insert) then
	      if(string(1:1) .ne. ' ') then
	        call dix_message(control,dix_msg_strfull)
	        goto 50
	      else
	        string(1:string_len) = string(2:ipos-1)//char(iterm)//
     1                         string(ipos:string_len)
	      end if
	    else
	      if(ipos .gt. string_len) then
	        call dix_message(control,dix_msg_strfull)
	        goto 50
	      else
	        string(ipos:ipos) = char(iterm)
	      endif
	    end if
	    if(ipos .lt. max_pos) ipos = ipos + 1
	    goto 52
	  else
	    call dix_message(control,dix_msg_endfield)
	  end if
	else
	  call dix_mes_invkey(control)
	end if
50	iterm = 0
	goto 10
c
c Stirng changed, check for length
c
52	do k=string_len,1,-1
	  if(string(k:k) .ne. ' ') goto 341
	end do
	k = 0
341	nkar = k
	call smg$put_chars(d_id,string(1:nkar),row_inp,string_pos,,video)
	call smg$put_chars(d_id,string(nkar+1:string_len),
     1                  row_inp,string_pos+nkar)
	
	goto 50
c
55	call dix_message(control,dix_msg_illhexchar)
	goto 50
c
90	continue
        call smg$put_chars(d_id,string(1:nkar),
     1                         row_inp,string_pos,,video_inp)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end		

	function dix_smg_select_field(control,data,size,bits,fldnam,
     1                                reverse,modify)
	implicit none
c
	include 'dix_def.inc'
c
	record /control/ control
 	integer*4 data(*)		!:io: the data
	integer*4 size                  !:i: the datasize in bits
	logical*4 bits			!:i: allow multiple bits set
	character*(*) fldnam		!:i: fieldnames
	logical*4 reverse		!:i: Bits reversed?         
	logical*4 modify		!:i: modify mode?
	logical*4 dix_smg_select_field
c
	include '($smgdef)'
c
	integer*4 ncol,width,k,dis_id,iterm,nf,r,c,nrow,ipos,val
	integer*4 temp_data(2),max_w,r_old,c_old,kpos,tel,nf_tot
	character*(max_symbol_name_length) field1
c
	integer*4 max_bits
	parameter (max_bits=64)
	integer*4 indices(max_bits)
c
	logical*4 str$element
	logical dix_dump_in_modify
	integer*4 dix_util_get_len
c
	logical test_bit,bit_set
	character kar
	integer*4 all_bits(2)
	record /dyn_help/ help_des
c
c Build help text
c
	call help_init_std(control,help_des,'Select fields',20,11)
	if(bits) then
	  call help_key(control.key_table,help_des,key_remove,
     1                'Clear all bits')
	  call help_key(control.key_table,help_des,key_put,
     1                'Set all bits')
	endif
	call help_key(control.key_table,help_des,key_exit,
     1                'Disregard changes')
	call help_key(control.key_table,help_des,key_enter,
     1                'Activate this field')
	call help_key(control.key_table,help_des,key_do,
     1                'Accept this value(s)')
	call dix_smg_stack_help(control,help_des)
c
c compute #names
c
	dix_smg_select_field = .false.
	nf = 0
	max_w = 0
	nf_tot = 0
	do while(str$element(field1,nf_tot,',',fldnam)) 
	  ipos = dix_util_get_len(field1)
	  if(ipos .gt. max_w) max_w = ipos
	  if(ipos .ne. 0) nf = nf+1	!alleen niet lege velden
	  nf_tot = nf_tot + 1
	end do
c
c We have nf fields
c compute #columns to display
c
	nrow = min(nf,control.nrows-3)
	ncol = (nf+nrow-1)/nrow
	width = min(max_w+2,control.ncols/ncol)
c
	temp_data(1) = data(1)
	temp_data(2) = 0
	if(size .gt. 32) temp_data(2) = data(2)
c
c Compute width of each field
c
	call smg$create_virtual_display(nrow,width*ncol,dis_id)
	call smg$label_border(dis_id,'Selecting')
c
	call smg$paste_virtual_display(dis_id,control.paste_id,2,
     1           control.ncols-width*ncol)
c
c
5	tel = 0
	all_bits(1) = 0
	all_bits(2) = 0
	do k=0,nf_tot-1
	  call str$element(field1,k,',',fldnam)
	  r = mod((tel),nrow)+1
	  c = tel/nrow*width+1
	  if(bits) then
	    bit_set = test_bit(k,temp_data)
	    if(reverse) bit_set = .not. bit_set
	    kar = ' '
	    if(bit_set) kar = '*'
	    if(field1 .ne. ' ') then
	      call set_bit(k,all_bits)
	      tel = tel + 1
	      call  smg$put_chars(dis_id,kar//field1(1:width-2),r,c)
	      indices(tel) = k		!remember bit position
	    endif
	  else
	    ipos = index(field1,'=')
	    if(ipos .gt. 1) then
	      read(field1(1:ipos-1),'(bn,i10)') val
	    else
	      val = k
	    endif
	    kar = ' '
	    if(val .eq. temp_data(1)) then
	      kar = '*'
	      r_old = r
	      c_old = c
            endif
	    tel = tel + 1
	    call  smg$put_chars(dis_id,kar//field1(1:width-2),r,c)
	  endif
	end do
c
	ipos = 0
c
50	if(ipos .lt. 0) ipos = 0
	if(ipos .ge. nf) ipos = nf-1
	r = mod(ipos,nrow)+1
	c = ipos/nrow*width+1
c
	call str$element(field1,ipos,',',fldnam)
c
	call smg$set_cursor_abs(dis_id,r,c)
	call dix_get_key(control,iterm)
	if(iterm .eq. key_enter) then
	  if(.not. dix_dump_in_modify(control,modify)) goto 50
	  if(bits) then
	    kpos = indices(ipos+1)
	    kar = ' '
	    if(test_bit(kpos,temp_data)) then
	      call clear_bit(kpos,temp_data)
	      bit_set = .false.
	      if(reverse) kar = '*'
	    else
	      call set_bit(kpos,temp_data)
	      bit_set = .true.
	      if(.not. reverse) kar = '*'
	    endif 
	    call smg$put_chars(dis_id,kar,r,c)	      
	    ipos = ipos + 1
	  else
c
c Number case, 
c
	    k = index(field1,'=')
	    if(k .eq. 0) then
	      temp_data(1) = ipos
	    else
	      read(field1(1:k-1),'(bn,i10)') temp_data(1)
	    end if
	    call smg$put_chars(dis_id,' ',r_old,c_old)
	    call smg$put_chars(dis_id,'*',r,c)
	    r_old = r
	    c_old = c
c	    goto 90
	  endif
	elseif(iterm .eq. key_help) then
	  call dix_smg_help(control)
	elseif(iterm .eq. key_do) then
	   goto 90
	elseif(iterm .eq. key_exit) then
	   goto 95
	elseif(iterm .eq. key_down) then
	  ipos = ipos +1
	elseif(iterm .eq. key_up) then
	  ipos = ipos -1
	elseif(iterm .eq. key_put) then
	  if(.not. dix_dump_in_modify(control,modify)) goto 50
	  if(bits) then
	    temp_data(1) = all_bits(1)
	    temp_data(2) = all_bits(2)
	    if(reverse) then
	      temp_data(1) = .not. temp_data(1)
	      temp_data(2) = .not. temp_data(2)
	    endif
	    goto 5
	  else
	    call dix_mes_invkey(control)
	  endif
	elseif(iterm .eq. key_remove) then
	  if(.not. dix_dump_in_modify(control,modify)) goto 50
	  if(bits) then
	    if(reverse) then
	      temp_data(1) = -1
	      temp_data(2) = -1
	    else
	      temp_data(1) = 0
	      temp_data(2) = 0
	    endif
	    goto 5
	  else
	    call dix_mes_invkey(control)
	  endif
	elseif(iterm .eq. key_left) then
	  ipos = ipos - nrow
	  if(ipos .lt. 0) then
	    ipos = ipos + ncol*nrow - 1
	  endif
	elseif(iterm .eq. key_top) then
	  ipos = 0
	elseif(iterm .eq. key_bot) then
	  ipos = nf
	elseif(iterm .eq. key_prev) then
	  ipos = ipos - 10
	elseif(iterm .eq. key_next) then
	  ipos = ipos + 10
	elseif(iterm .eq. key_right) then
	  ipos = ipos + nrow
	  if(ipos .ge. nf) then
	    ipos = ipos - ncol*nrow + 1
	  endif
	else
	  call dix_mes_invkey(control)
	end if
	goto 50
90	call dix_util_insert_bits(temp_data,0,size,data)
 	dix_smg_select_field = .true.
95	call smg$delete_virtual_display(dis_id)
	call dix_smg_unstack_help(control)
	call help_exit(help_des)
	return
	end
	subroutine dix_smg_getset_phys_cursor(control,setit,row,col)
	implicit none
c
c Get or set physical cursor
c
	include 'dix_def.inc'
	record /control/ control
	logical*4 setit		!if true the set, else get
	integer*4 row      	!:o: row
	integer*4 col		!:o: column
c
	include '($smgdef)'
	record /smg$r_attribute_info_block/ smgrec
c
	if(setit) then
	  call smg$set_physical_cursor(control.paste_id,row,col)
	else
	  call smg$get_pasteboard_attributes(control.paste_id,
     1              smgrec,sizeof(smgrec))
	  row = smgrec.smg$w_phys_cursor_row
	  col = smgrec.smg$w_phys_cursor_col
	end if
	return
	end
	function dix_get_key(control,dix_key)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	integer*4 dix_key		!:o the key read
	logical dix_get_key		!:f: status of smg$read_key
c
	integer*4 istat
	integer*4 keydefs_get_key
	external dix_msg_disontop
	external dix_msg_clear
	external dix_msg_illstate
c
	call dix_message(control,dix_msg_disontop)	!set display on top
10	istat = keydefs_get_key(control.key_table,
     1           control.keyboard_id,dix_key,.false.)
	if(.not. istat) dix_key = key_exit
	call dix_message(control,dix_msg_clear)
	if(dix_key .eq. key_repaint) then
	  call smg$repaint_screen(control.paste_id)
	  goto 10
	end if
	if(dix_key .eq. 0) then
	  call dix_message(control,dix_msg_illstate)
	  goto 10
	endif
	dix_get_key = istat
	return
	end
	subroutine dix_mes_invkey(control)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
c
	integer*4 nk
	character*(max_line_length) line
	external dix_msg_typhelp
c
	call keydefs_get_map(key_help,control.key_table,nk,line)
c
	call dix_message(control,dix_msg_typhelp,line(1:nk))
	return
	end
