	subroutine dix_process_startup(control,filename)
	implicit none
c
	include 'dix_def.inc'
	record /control/ control
	character*(*) filename
c
	integer*4 nk,lun,istat
	character*(max_verb_length) verb
	character*(max_symbol_name_length) key,if_state,set_state
	character*(max_symbol_name_length) function,context
	character*(max_line_length) line
c
	external dix_int_cld
	logical dcl_parse
	logical cli$present
	external dix_msg_invcomm
	external ignore_message
	integer*4 smg$define_key
c
	call lib$get_lun(lun)
	open(lun,file=filename,defaultfile='sys$login:.ini',
     1          shared,readonly,status='old',err=90)
c
10	read(lun,2000,end=80) nk,line
2000	format(q,a)
	call dix_util_remove_comment(nk,line)
	if(line(1:nk) .eq.' ') goto 10
c
	call lib$establish(ignore_message)
	istat = dcl_parse(control,line(1:nk),dix_int_cld)
	call lib$revert
	if(istat) then
	  call cli$get_value('$verb',verb)
	  if(verb .eq. 'DEFI') then
	    if(cli$present('SKEY')) then
	      call cli$get_value('p1',key)
	      call cli$get_value('set_state',set_state)
	      if(set_state .eq. ' ') then
	        call cli$get_value('p2',function)
	      else
	        function = ' '
	      endif
	      call cli$get_value('if_state',if_state)
	      call cli$get_value('Context',context)
	      call keydefs_add_key(control,key,if_state,set_state,
     1                function,control.debug,context)
	    else
	      istat = smg$define_key(control.keytable_id,line(1:nk))
	      if(.not. istat) call dix_message(control,%val(istat))
	    endif
	  elseif(verb .eq. 'DELE') then
	    if(cli$present('SKEY')) then
	      if(cli$present('all')) then
	        if_state = ' '
	        key = ' '
	      else
	        call cli$get_value('p1',key)
	        call cli$get_value('state',if_state)
	      endif
	      call keydefs_del_key(control,key,if_state,control.debug)
	    else
	    endif
	  elseif(verb .eq. 'SET') then
	    call cli$get_value('p1',function)
	    if(function(1:1) .eq. 'M') then
	      call set_message(control)
	    elseif(function(1:1) .eq. 'E') then
	      call cli$get_value('p2',line)
	      if(line(1:1) .eq. 'E') then
	        control.editor = dix_edit_edt
	      elseif(line(1:1) .eq. 'I') then
	        control.editor = dix_edit_internal
	      elseif(line(1:1) .eq. 'T') then
	        control.editor = dix_edit_tpu
	      endif
	    elseif(function(1:1) .eq. 'P') then
	      call cli$get_value('p2',control.prompt,control.nk_prompt)
	    elseif(function(1:1) .eq. 'D') then
	      call cli$get_value('p2',line)
	      control.debug = line(1:2) .eq. 'ON'
	    elseif(function(1:1) .eq. 'S') then
	      call set_strict(control.strict_mode)
	    else
	      call dix_message(control,dix_msg_invcomm,line(1:nk))
	    endif
	  else
	    call dix_message(control,dix_msg_invcomm,line(1:nk))
	  endif
	else
	  call dix_message(control,dix_msg_invcomm,line(1:nk))
	endif
	goto 10
80	close(lun)
90	call lib$free_lun(lun)
	return
	end
