/* drain.c


pulled from Goggle archive by Verne Britton on  Tues  9-Oct-2001

9-Oct-2001   Add EXTERN statement for EXIT and SYS$ASSIGN (case sensitive)
		and inet_ntoa().   Added #include <string.h> and
		#pragma module.   Added (char *) to two lines to say
			(char *)inet_ntoa(sin.sin_addr)
		in some SPRINTF statements.


2-Aug-2002 v1.1  Verne Britton.  Use a temp file... read it and parse
	out extra CRs.  Break FFs into newlines.   Tested with Multinet
	v4.3 on AXP.  If parsing the extra CRs is not needed in the
	future, then this program could write directly to the final
	destination (usually a user's account).

	A stream (raw) output from any system other than Multinet may
	have a different format and not parse correctly.

4-Aug-2002  v1.2  Verne Britton.  Add check for two DCL files, SPAWNing
	them and branching around the filter code as well as the Delete.
	Added

 *    SERVER-CONFIG> SET MAX-SERVERS 1		! so only process one at a time
 *    SERVER-CONFIG> SET BACKLOG 3		! some small number

	to example Service configuration.

13-Aug-2002 v1.3   SPAWN doesn't work  :-(.  Got CrePRC working with
	termination mailbox.  Add text display when given a parameter
	or when compiled in DeBug mode.

19-Aug-2002 v1.4  Add SysMSG and OPCOM stuff.

28-Aug-2002 v1.5  Continue work on SysMSG and OPCOM stuff.
	Put SYS$ calls ($ASSIGN, $TRNLNM) in lower case to make DEC-C
	on Vax happy.   Finally compiling and working on DEC-C v6.2
	on both VAX/VMS 6.2 and AXP/VMS 7.2-1.

28-Oct-2004  v1.6  Clean up source code comments; no changes made in
	any C routines at all.   EXE file from 1-Oct-2002 still OK.

15-Nov-2004  v1.7 More typos found in comment section;  no changes made
	in any C routines at all.


-------------------------------------------------------


TO USE:  set up the Service as described below.

Logical name summary (details below):

	MULTINET_DRAIN_xxxx:   final output file
	MULTINET_DRAIN_CMD1_xxxx:  first DCL command file (optional)
	MULTINET_DRAIN_CMD2_xxxx:  second DCL command file (optional)
	MULTINET_DRAIN_OPC_CLASS_xxxx:  OpCom class name for this program
		to use for any OpCom messages (optional, default=CENTRAL)

	To debug, compile with CC/DEFINE=DEBUG/DEBUG/NOOPT  so it can be
	ran interactively, skipping all the IP socket stuff and just
	executing the file and subprocess code.

	Define "MULTINET_DRAIN_xxxx" logical where XXXX is the port
	number of the service.  This logical must be a fully qualified
	filename (Dev:[dir]file.ext) and is the final destination of
	the 'printed' text.  In MULTINET_SPOOL: the temp file we create 
	is named DRAIN_xxxx.TMP, and it is deleted after processing.

	Then define a local Stream Telnet print queue pointing to
	the DRAIN port... and send all printouts to this printer so
	the Multinet Stream Symbiont will always process the text
	data.   Note this stream queue must have a form with no
	setup ESC sequences as well as no reset sequence on the queue.

	AND THIS IS MEANT ONLY FOR TEXT DATA... NO BINARY OR GRAPHICS
	AT ALL.

	By using the port number we can have any number of these, and
	since this program, running as a detached process, needs the
	logical, it must be somewhere in its logical name tables...
	usually done with Define/System.

	OPCOM errors like:

		MultiNet Server: Service DRAIN pid 17A000CC 
			failed: no such file
	and
		MultiNet Server: Service DRAIN pid 17A000CD 
			failed: bad file version number

	mean either it could not create the temporary file in Multinet_Spool:
	or the final output file.


SubProcess return codes (completion_status):

	This program optionally uses one or two DCL command files to give
	flexibility in processing.  The first, pointed to by the system
	logical MULTINET_DRAIN_CMD1_xxxx: (again, where xxxx is the port
	number), is executed in a subprocess right after receiving the raw
	Telnet/printer text into the file MULTINET_SPOOL:DRAIN_xxxx.TMP.
	The second command file/logical, MULTINET_DRAIN_CMD2_xxxx:, is
	executed in a new subprocess after the filtering has ran
	and created the final output file; the temp MULTINET_SPOOL file
	still exists at this point.  Use EXIT xxx in DCL to pass back
	control values to this program:

	 1          create filtered file, delete temp file
	 9 (8+1)    Don't create filtered file
	17 (16+1)   Don't delete temp file
	25 (8+16+1) Don't do either one

	If the second command file exists and gets executed, its
	return code overrides the first one cmd file's return code,
	so it will determine (if it exists) if the temp file gets
	deleted or not !!

	If the return code (completion_status, Exit Status) is
	greater than 25, such as a typical VMS status code, this
	program forces it to 1, to then process things in the
	default manner.

	And in the case of the 2nd cmd file, the filtered file
	will have already been created, so a return code of 9
	will not have any affect (i.e., the filtered file will
	not be deleted).

	Just before the subprocess is created, a job table logical
	name MULTINET_DRAIN_P1_yyyyy is created, where yyyyy
	is the 8 digit hex PID of the main (parent) process.
	The subprocess can access this logical to retrieve the
	xxxx port number, in order to contruct the other logical
	names to find the MULTINET_SPOOL file as well as the
	final filtered output file;  some DCL code for the
	subprocess to do this:

		$owner = f$getjpi("","OWNER")
		$port = f$trnlnm("MULTINET_DRAIN_P1_''OWNER'")


OPCOM Messages

	This program attempts to trap and report on many different
	errors.  $SNDOPR is used to generate OpCom messages.  An
	optional item in the OpCom message is the type or class
	the message should be broadcast to.  Some of these are:
	CENTRAL, PRINTER, TAPES, DISKS, DEVICES, CARDS, NETWORK,
	CLUSTER, SECURITY, LICENSE, OPER1, OPER2, OPER3, OPER4, OPER5,
	OPER6, OPER7, OPER8, OPER9, OPER10, OPER11, OPER12.

	By having this program send out 'targeted' messages, it
	may be easier to monitor and notice these messages  :-)

	The logical name MULTINET_DRAIN_OPC_CLASS_xxxx: passes
	the class name to the program;  the CENTRAL class is
	used if this name does not exist, or contains a value (string)
	not recognized by the program... all the class names are
	hardcoded in here, Sorry  (this program upper-cases the
	class name before processing it, so the logical can contain
	either an upper case name (CENTRAL) or lowercase (network)).


NOTES on file formats:

First set (below) is what PRINT does to it (the temp output file from the 
Stream Symbiont).  The bottom part is the original text file.  We need to
process the temp file to make it as similar as possible to the original.

A<FF>B<FF>X<FF>Y<CR>
C<CR><FF>E<CR>
F<CR>
G<CR><FF>I<CR>
I2<CR><FF>H<CR>
I3<CR>
J<CR>
KLM<CR>___ NOP<CR>
Q<CR>
Q<CR><FF><FF><FF>M<CR>
N<CR><FF><FF><FF><CR>
O<CR>


A<FF>B<FF>X<FF>Y        * The embedded FF are left alone (CR inserted at        
C                       end of course)                                          
<FF>                    * FF by itself is pulled to the previous line AND       
E                       has the following line pulled up too (with a CR         
F                       inserted before the FF) (CR inserted at end of course)  
G<FF>                   * Trailing FF has next line pulled up (with a CR        
I                       inserted before the FF).  (CR inserted at end of course)
I2
<FF>H                   * Leading FF is pulled back to the previous line        
I3                      (with a CR inserted before the FF) (CR inserted at      
J                       end of course)                                          
KLM<CR>___ NOP          * imbedded CR is left alone (CR inserted at end      
                        of course)                                           

Q                       * as before, the next FF is pulled back to follow
<FF>                    the Q (with a CR just after the Q), but now the next 
<FF>                    FF is pulled back to, without any inserted CR, and 
<FF>                    again, until the M is pulled back and then the 
M                       trailing CR is put on.
N                       * as before, the next FF is pulled back to follow the
<FF><FF><FF>            N (inserting a CR), and all the following FF too, but 
O                       not the letter O, resulting in the trailing CR 
                        immediately following the last FF and the O left 
                        alone on the next line.

So, in the case of multiple FF, our general rules are OK, resulting in
the next real character being on the next 'real' line and having all the
FFs prefixing it.   In the reduced case of a single FF, that FF will
(also) be a prefix on the next 'real' line.

The multiple FFs result in blank pages, and it doesn't matter for
physical output if those blank pages (when looking at the data stream)
would have a space or a single blank line on them or not.  So taking
our 3 lines of FF and making them look just like the example of
one line containing 3 FFs I believe is A-OK.

Because of the way the FF is put together with surrounding text by the
Stream Symbiont, it is not possible to tell if the FF was the last character
on the last line of the old page, was on the last line by itself, or has a
character immediately after it... but the printed result I think is all the
same and that is ... you have the very next character on line one of a
new page. My way of having the FF as a prefix to that character will
give those results even though it will not reproduce (in all cases) the
original actual file (since we can't tell where it originally was).


Another NOTE:

The DEC C Lang Ref Manual says (Lexicon, Chap 1.8.3.3, Table 1-7,
Character Escape Sequences):

\n    NL  newline  ( LF, 10. )
\f    FF  formfeed  12.
\r    CR  carriage return  13.

see "strstr vms changing the contents file"
and  "strstr vms c file mass"  at DEJA.COM

-----------------------------------------------------


From: aaron@cisco.com (Aaron Leonard)
Subject: Re: Multinet LPD Queue to File?
Date: 1997/11/30
Message-ID: <65qp9m$vk8$1@bogon.kjsl.com>
Distribution: world
References: <347d964e.9287201@news.mindspring.com>
Organization: cisco Systems
Reply-To: Aaron@cisco.COM
Newsgroups: comp.os.vms

In article <347d964e.9287201@news.mindspring.com>, derman@mindspring.com 
(Jon Derman) writes:
|I don't know much about setting up queues, etc., so please forgive me
|if my question doesn't make sense:
|
|Would it be possible to set up a Multinet LPD queue, such that "print"
|jobs that are sent to the queue don't actually *print*, but rather,
|appear as files in some directory on the VMS machine?
|
|My reason for wanting this:  I'm hoping to set something up where an
|IBM MVS machine can send print jobs to my VMS machine (using an LPD
|queue, I figure), and I receive the output as a file, rather than
|printed hardcopy.  My understanding is that the IBM MVS machine can
|send print jobs to an LPD queue on my VMS machine, so if I can just
|set up the appropriate LPD queue on the VMS side, then I'll be all
|set.
|
|Does this make any sense?  Can anyone tell me what I need to do?
|Specifics on how to set up a Multinet LPD queue (that I could pass
|along to my VMS SysAdmin), as described above, would be greatly
|appreciated!

Yeah, I've done this.  My technique was to set up a stream queue
printing to a local TCP service which sends the incoming TCP
connection data to a file.  Works like this:

- the stream queue looks like this:

PRINTER-CONFIG>show drain_to_file
Queue Name                   IP Destination      Remote Queue Name
----------                   ---------------     -----------------
DRAIN_TO_FILE                127.0.0.1           TCP port 9393
	End of Job Form Feed will be suppressed
	Telnet Options Processing will be suppressed

- the server running on TCP port 9393 looks like this:

SERVER-CONFIG>show/ful drain
Service "DRAIN":
	TCP socket (AF_INET,SOCK_STREAM), Port 9393
	Socket Options = SO_KEEPALIVE
	INIT() = TCP_Init
	LISTEN() = TCP_Listen
	CONNECTED() = TCP_Connected
	SERVICE() = Run_Program
	Program = "SYS$COMMON:[MULTINET.EXAMPLES]DRAIN-TO-FILE.EXE"

- DRAIN-TO-FILE is given below.  (Note that the end-of-line delimiters 
  might not work quite right ...)

So the MVS box could just LPD print to the queue DRAIN_TO_FILE, which
would send the data to TCP port 9393 on localhost, which would run the
program DRAIN-TO-FILE to write the job to a file.

Aaron

---

*/


/* drain-to-file.c
 *   TCPECHOSERVER.C, slightly modified so that it writes 
 *   the data to a file (MULTINET_SPOOL:drain-to-file.tmp.)
 */

/*
 *  Example TCP server.
 *
 *  This server is an alternative ECHO server which lets the MultiNet
 *  MULTINET_SERVER process listen for it. When a connection arrives,
 *  the MULTINET_SERVER will create a process running this image which
 *  processes the connection.
 *
 *  To compile and link this server:
 *
 *    $ CC TCPECHOSERVER
 *    $ LINK TCPECHOSERVER,SYS$INPUT:/OPT
 *    MULTINET:MULTINET_SOCKET_LIBRARY/SHARE
 *    SYS$SHARE:VAXCRTL/SHARE
 *    ^Z
 *
 *  To configure the MULTINET_SERVER process to automatically create
 *  a process running this image when a connection arrives:
 *
 *    $ MULTINET CONFIGURE/SERVER
 *    MultiNet Server Configuration Utility 2.2(19)
 *    [Reading in symbols from SERVER image MULTINET:SERVER.EXE]
 *    [Reading in configuration from MULTINET:SERVICES.MASTER_SERVER]
 *    SERVER-CONFIG>ADD TEST
 *    [Adding new configuration entry for service "TEST"]
 *    Protocol: [TCP] TCP
 *    TCP Port number: 500
 *    Program to run: USERS:[ADELMAN]TCPECHOSERVER.EXE
 *    [Added service TEST to configuration]
 *    [Selected service is now TEST]
 *    SERVER-CONFIG> SELECT TEST
 *    SERVER-CONFIG> SET MAX-SERVERS 1		! so only process one at a time
 *    SERVER-CONFIG> SET BACKLOG 3		! some small number
 *    SERVER-CONFIG>RESTART
 *
 */


#pragma module drain  "Drain V1.7"

#include ctype
#include unistd		/*  have first, Multinet replaces some modules  */
#include "multinet_root:[multinet.include.sys]types.h"
#include "multinet_root:[multinet.include.sys]socket.h"
#include "multinet_root:[multinet.include.netinet]in.h"
#include <stdio.h>
#include <unixio.h>
#include "multinet_root:[multinet.include]netdb.h"
#include "multinet_root:[multinet.include]errno.h"
#include <string.h>
#include <lib$routines.h>
#include <descrip.h>
#include <rms.h>
#include <stdlib.h>
#include <starlet.h>
#include <pqldef.h>
#include accdef
#include dvidef
#include iodef
#include ssdef
#include psldef   /*  Access Modes  */
#include lnmdef
#include opcdef

//
// some global items...
//
	char my_msg[255];
	unsigned long int My_Port;

	struct item  {
	   unsigned short buflen,itemcode;
	   void *buffaddr;
	   void *retlenaddr;
	};


static int send_opcom();	/*  declare my function  */


main(int argc, char *argv[])
{
	unsigned short s;
	int completion_status;
	int n, Status, Status_save;
	int ofd;		/*  output file descriptor  */
	int ofd2;
	char *x, *y;
	char buf[32766];
	char buf2[32766];
	char outfile[255];
	char outfile2[255];

	char cmd_file1[255];
	$DESCRIPTOR(cmd_file1_dsc,cmd_file1);

	char cmd_file2[255];
	$DESCRIPTOR(cmd_file2_dsc,cmd_file2);

	char prcnam[16];
	$DESCRIPTOR(prcnam_dsc,prcnam);

	$DESCRIPTOR(cli_dsc,"DCL");
	$DESCRIPTOR(job_dsc,"LNM$JOB");

	char logi_P1_value[255];
	unsigned short crelnm_len;

	char logi_P1[255];
	$DESCRIPTOR(logi_P1_dsc,logi_P1);

	char dcl_cmd[255];
	$DESCRIPTOR(cmd_dsc,dcl_cmd);

	struct sockaddr_in sin;
	struct hostent *hp;


//	static struct {int Size; char *Ptr;} Descr={9 ,"SYS$INPUT"};
	$DESCRIPTOR(sys_input,"SYS$INPUT");

	FILE *fp;

	struct FAB fab;
	struct NAM nam;
	char rsa[255];
	char esa[255];

	unsigned long int retstat;
	$DESCRIPTOR( nla0, "_NLA0:" );
	$DESCRIPTOR( loginout, "SYS$SYSTEM:LOGINOUT.EXE" );
	unsigned long int pid;
	unsigned long int baspri = 4;
	unsigned long int uic = 0;
	unsigned long int stsflgs = 0;


/*
CrePRC stuff all from a DEJA article:

	From: Hoff Hoffman (hoffman@xdelta.zko.dec.nospam)
	Subject: Re: How to use SYS$CREPRC
	Newsgroups: comp.os.vms
	Date: 2000/04/20
*/
	struct
        {
        unsigned char pql_code;
        unsigned long int pql_value;
        } pql[] =
            {
            {   PQL$_ASTLM,        210      },
            {   PQL$_DIOLM,        200      },
            {   PQL$_BIOLM,        200      },
            {   PQL$_BYTLM,        131072   },
            {   PQL$_CPULM,        0        },
            {   PQL$_FILLM,        300      },
            {   PQL$_PGFLQUOTA,    99000    },
            {   PQL$_PRCLM,        16       },
            {   PQL$_TQELM,        100      },
            {   PQL$_WSDEFAULT,    512      },
            {   PQL$_WSQUOTA,      2048     },
            {   PQL$_WSEXTENT,     32768    },
            {   PQL$_ENQLM,        300      },
            {   PQL$_JTQUOTA,      4096     },
            {   PQL$_LISTEND,      0        }
            };

	$DESCRIPTOR( mbxname, "MY_MBX");
	int   mbx_unit_num;
	short int chan, iosb[4];

	struct accdef accstuff;

	struct item item_list[1];


	if (argc > 1) {
printf("DRAIN              (do ANALYZ/IMAGE for the version)\n");
printf("  Takes no command line arguments.\n");
printf("  Listens on a TCP/IP socket for a Telnet (raw/stream)\n");
printf("  printer connection;  captures that incoming text stream to a\n");
printf("  scratch file;  filters extra CR, LF and FF characters, creating\n");
printf("  a specified output file.\n");
printf("  See the source code or other documentation for the various\n");
printf("  logical names and subprocess functions used by this program.\n");
printf("  Cobbled together from example Multinet C programs (and other\n");
printf("  great VMS C examples from DejaNews archives, Multinet mailing\n");
printf("  archives and DSNlink) in August 2002 using OpenVMS AXP V7.2\n");
printf("  and DEC C v6.2 by\n");
printf("\n");
printf("      Verne Britton\n");
printf("      West Virginia Network\n");
printf("      837 Chestnut Ridge Road\n");
printf("      Morgantown, WV  26505\n");
printf("      verne@wvnet.edu    304-293-5192 x230\n");

#ifdef DEBUG
printf("\n");
printf("  Compiled with DeBug mode - no IP socket stuff, just file I/O\n");
printf("  and sub-process work is being done\n");
printf("\n");
#endif

printf("*** Not doing any work, just EXIT(1)\n");
	exit (1);
	}

	/*
	 *  $ASSIGN a channel to SYS$INPUT. This channel is the channel
	 *  to the network connection.
	 */


//
// Assuming if compiled with DeBug, then are running interactively,
// so display some text !!
//
#ifdef DEBUG
	printf("DRAIN\n");
	printf("     In DeBug mode - no IP socket stuff, just file I/O\n");
	printf("     and sub-process work is being done\n");
	printf("\n");
  goto label1
	;
#endif


	Status = sys$assign(&sys_input, &s, 0, 0);
	if (!(Status&1)) {
		Status_save = Status;
		sprintf(my_msg, "%s\r\n", 
			"DRAIN: SYS$ASSIGN error to the socket");
		send_opcom(Status_save);
		exit(Status_save);
	}


	/*
	 *  `sin' will be a sockaddr_in structure describing the
	 *  remote IP address (and port #) which the connection
	 *  was made from. Before we start to echo data, write a
	 *  string into the network describing this port.
	 */

	n = sizeof(sin);	   /* Pass in the length */
	Status = getsockname(s, &sin, &n);
	if (Status == -1) {
		Status_save = vaxc$errno;
		sprintf(my_msg, "%s\r\n", 
			"DRAIN: GetSockName error");
		send_opcom(Status_save);
	 	exit(Status_save);
	}


	My_Port=ntohs(sin.sin_port);

//	    sprintf(buf, "Connection received at [%s] on port  %lu\r\n",
//		inet_ntoa(sin.sin_addr),
//		My_Port);


#ifdef DEBUG
label1:
  My_Port = 4381;
  printf("Hardcoding Port to 4381 for DeBug mode.\n");
#endif


	sprintf(outfile,"multinet_spool:drain_%lu.tmp", My_Port);
	sprintf(outfile2,"multinet_drain_%lu:", My_Port);

	sprintf(cmd_file1,"multinet_drain_cmd1_%lu:", My_Port);
	cmd_file1_dsc.dsc$w_length = strlen (cmd_file1);

	sprintf(cmd_file2,"multinet_drain_cmd2_%lu:", My_Port);
	cmd_file2_dsc.dsc$w_length = strlen (cmd_file2);

	sprintf(logi_P1,"MULTINET_DRAIN_P1_%X", getpid());
	logi_P1_dsc.dsc$w_length = strlen (logi_P1);

	sprintf(logi_P1_value,"%lu", My_Port);


#ifdef DEBUG
  goto label3;
#endif

	ofd = creat(outfile, 0, "mrs=32766","rat=cr","rfm=stmlf");
	if (ofd == -1) {
		Status_save = vaxc$errno;
		sprintf(my_msg, "%s \"%s\"\r\n", 
		"DRAIN: CREAT error on temporary file",outfile);
		send_opcom(Status_save);
	    exit(Status_save);
	}
       
	/*
	 *  Now go into a loop, reading data from the network
	 */

	while ((n = socket_read(s, buf, sizeof(buf))) > 0) {
	    write(ofd, buf, n);
	}

	/*
	 *  socket_read() will return 0 on end-of-file, or -1 on error...
	 */

	if (n < 0) {
	    socket_perror("Drain: read");
	    sprintf(my_msg, "%s\r\n", 
			"DRAIN: Socket_Read error");
	    send_opcom(1);
	}

	/*
	 *  Now close down the connection...
	 */

	socket_close(s);
	close(ofd);

#ifdef DEBUG
label3:
;
#endif


//
// Execute the first DCL cmd file if it exists...
//

	fab = cc$rms_fab;	/*  Initialize structures default  */
	nam = cc$rms_nam;	/*  values  */

	fab.fab$l_fna = cmd_file1;
	fab.fab$b_fns = strlen(cmd_file1);
	fab.fab$l_nam = &nam;                 /* Assign address of NAM block */

	nam.nam$l_esa = esa;                 /* Address of the esa. */
	nam.nam$b_ess = sizeof esa;           /* length of the esa. */
	nam.nam$l_rsa = rsa;                 /* Address of the rsa. */
	nam.nam$b_rss = sizeof rsa;           /* Length of the rsa. */


//
// Do the Parse.  If OK, then try the Search.  If OK, then try the
// Spawn.
//

	completion_status = 1;   /*  give it an initial value  */

	item_list[0].buflen = strlen(logi_P1_value);
	item_list[0].itemcode = LNM$_STRING;
	item_list[0].buffaddr = &logi_P1_value;
	item_list[0].retlenaddr = &crelnm_len;
	item_list[1].buflen = 0;
	item_list[1].itemcode = 0;

	sprintf(prcnam,"DRAIN_%lu_S", My_Port);
	prcnam_dsc.dsc$w_length = strlen (prcnam);

        if ( ((Status = sys$parse(&fab,0,0)) == RMS$_NORMAL)  &&
	     ((Status = sys$search(&fab,0,0)) == RMS$_NORMAL) )
        {
//
// But first create the job level logical name consisting of our PID
// and containing the port/socket number for the subprocess to use
//
		Status = sys$crelnm (0, &job_dsc, &logi_P1_dsc,
			&PSL$C_SUPER, item_list);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
				"DRAIN: $CRELNM in job-table error (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		Status = sys$crembx( 0, &chan,   /*  PermFlg, Channel  */
			0, 0,		/*  MaxMsg, BufQuo  */
			 0, 0, &mbxname);  /*  ProtMask, AccMode, LogName */
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
				"DRAIN: $CREMBX error (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		Status = lib$getdvi( &DVI$_UNIT, &chan, 0,
			&mbx_unit_num, 0, 0);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $GETDVI error on the mailbox channel (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		retstat = sys$creprc( &pid,
			&loginout, &cmd_file1_dsc, &nla0, &nla0, 0,
			pql, &prcnam_dsc, baspri, uic, mbx_unit_num, stsflgs );

//
// If DuplNam, do again with 0 for PrcNam.  If anything else, just
// bail out.
//
		if ((retstat == SS$_DUPLNAM)) {
		    retstat = sys$creprc( &pid,
			&loginout, &cmd_file1_dsc, &nla0, &nla0, 0,
			pql, 0, baspri, uic, mbx_unit_num, stsflgs );
		    if ( !(retstat & 1)) {
			Status_save = retstat;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $CREPRC error (with no ProcessName) (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		} else
		{ if ( !(retstat & 1)) {
			Status_save = retstat;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $CREPRC error (specifying process name) (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		}

		Status = sys$qiow (0, chan, IO$_READVBLK, &iosb, 0, 0,
			&accstuff, ACC$C_TERMLEN, 0, 0, 0, 0);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
		"DRAIN: $QIOW error reading termination mailbox (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		if ( !(iosb[0] & 1)) {
			Status_save = iosb[0];
			sprintf(my_msg, "%s\r\n", 
		"DRAIN: $QIOW error in the IOSB reading termination mailbox (1st one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}

		completion_status = accstuff.acc$l_finalsts;
        }


// Must have 1 (Normal), as well as any of these 2 added to it:
//
//  9 (8+1)  Don't create filtered file
// 17 (16+1) Don't delete temp file
// 25 (8+16+1)  Don't do either one
//
// so that adds up to 25.  The DCL routines better be good since we
// don't check on them here.  SS$_Normal (1) would mean to create the
// filtered file AND to delete the temp file.  Force it to 1 if over 25
// because we don't care about any other returned status codes.
//

	if (completion_status > 25) completion_status = 1;

	if (completion_status & 8) goto L999;


// OK, now trim all those pesky CRs from every record
// by opening our temp file, reading and trimming and writing to
// the actual destination


	ofd2 = creat(outfile2, 0, "mrs=32766","rat=cr","rfm=stmlf");
	if (ofd2 == -1) {
		Status_save = vaxc$errno;
		sprintf(my_msg, "%s \"%s\"\r\n", 
			"DRAIN: CREAT error on final output file",outfile2);
		send_opcom(Status_save);
	    exit(Status_save);
	}

	fp = fopen(outfile, "r");
	if ( !fp ) {
		Status_save = vaxc$errno;
		sprintf(my_msg, "%s \"%s\"\r\n", 
		"DRAIN: Fopen error trying to open temporary file",outfile);
		send_opcom(Status_save);
	    exit(Status_save);
	}

	while (fgets(buf,32766,fp) )  {

	    n = strlen(buf);

//
// Rarely, and it seems only on the last record, we will get a line
// without a trailing LF.   Add one if it is missing.  Do this first
// so in case we end up with a CR-LF sequence, our later code will
// catch it.
//

	if ( (n > 0) && (buf[n-1] != '\n') )  {
		buf[n] = '\n';	
		n++;
		buf[n] = '\0';	
	}


//
// OK, look for CR-LF.  Naturally must have at least 2 characters
// to begin with.
//

	    while ( ( n > 1 )  &&
		(buf[n-2] == '\r')  &&
		(buf[n-1] == '\n') )   {
			buf[n-2] = buf[n-1];
			buf[n-1] = '\0';
			n--;
		}


//
// sometimes can get CR-FF imbedded in a string
// replace the CR with an LF, to create two new output records.
// Scan down the string to find multiple occurrences.
// maybe this code could be shortened somehow... or there is a
// better way...
//


//
// Special case of an imbedded CR-CR-FF.  Just remove one CR by copying
// everything 'back' one character, and let the lower code deal with 
// the remaining CR-FF.   Do it twice to handle CR-CR-CR-FF which
// I think is the worst case.... I suppose I could be proven wrong...
//
	if (NULL != (x = strchr(buf,'\f')) )   {
	  if ((n > 2) && (x[-1] == '\r')
		&& (x[-2] == '\r'))  {
		strcpy(buf2,x);
		strcpy(x-1,buf2);
		x--;
		n--;
	  }  /*  6 line IF block  */

	  if ((n > 2) && (x[-1] == '\r')
		&& (x[-2] == '\r'))  {
		strcpy(buf2,x);
		strcpy(x-1,buf2);
		x--;
		n--;
	  }  /*  6 line IF block  */

	}  /*  IF ...strchr  block  */


	if (NULL != (x = strchr(buf,'\f')) )   {
	  if ( x[-1] == '\r' )
		x[-1] = '\n';

	  y = ++x;   /*  advance start of search  */

//
// do it for the rest of the string
//
	   while (NULL != (x = strchr(y,'\f')) )  {
	      if ( x[-1] == '\r' )
		x[-1] = '\n';

		y = ++x;

	   }  /*  end of WHILE STRCHR loop (4 lines)  */

	}  /* end of STRCHR large loop (above WHILE loop and 4 
		lines before that  */


	    write(ofd2, buf, n);

        }  /*  end of big Read/Write loop  */

	fclose(fp);
	close(ofd2);


//
// Execute the second DCL cmd file if it exists...
//
	fab = cc$rms_fab;	/*  Initialize structures default  */
	nam = cc$rms_nam;	/*  values  */

	fab.fab$l_fna = cmd_file2;
	fab.fab$b_fns = strlen(cmd_file2);
	fab.fab$l_nam = &nam;                 /* Assign address of NAM block */

	nam.nam$l_esa = esa;                 /* Address of the esa. */
	nam.nam$b_ess = sizeof esa;           /* length of the esa. */
	nam.nam$l_rsa = rsa;                 /* Address of the rsa. */
	nam.nam$b_rss = sizeof rsa;           /* Length of the rsa. */


//
// Do the Parse.  If OK, then try the Search.  If OK, then try the
// Spawn.
//

	completion_status = 1;   /*  give it an initial value  */


//
// do logical again to make sure it is there, and in case we ever
// pass new info...
//
	item_list[0].buflen = strlen(logi_P1_value);
	item_list[0].itemcode = LNM$_STRING;
	item_list[0].buffaddr = &logi_P1_value;
	item_list[0].retlenaddr = &crelnm_len;
	item_list[1].buflen = 0;
	item_list[1].itemcode = 0;

	sprintf(prcnam,"DRAIN_%lu_S", My_Port);
	prcnam_dsc.dsc$w_length = strlen (prcnam);

        if ( ((Status = sys$parse(&fab,0,0)) == RMS$_NORMAL)  &&
	     ((Status = sys$search(&fab,0,0)) == RMS$_NORMAL) )
        {
		Status = sys$crelnm (0, &job_dsc, &logi_P1_dsc,
			&PSL$C_SUPER, item_list);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
				"DRAIN: $CRELNM in job-table error (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		Status = sys$crembx( 0, &chan,   /*  PermFlg, Channel  */
			0, 0,		/*  MaxMsg, BufQuo  */
			 0, 0, &mbxname);  /*  ProtMask, AccMode, LogName */
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
				"DRAIN: $CREMBX error (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		Status = lib$getdvi( &DVI$_UNIT, &chan, 0,
			&mbx_unit_num, 0, 0);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $GETDVI error on the mailbox channel (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
		}

		retstat = sys$creprc( &pid,
			&loginout, &cmd_file2_dsc, &nla0, &nla0, 0,
			pql, &prcnam_dsc, baspri, uic, mbx_unit_num, stsflgs );

//
// If DuplNam, do again with 0 for PrcNam.  If anything else, just
// bail out.
//
		if ((retstat == SS$_DUPLNAM)) {
		    retstat = sys$creprc( &pid,
			&loginout, &cmd_file2_dsc, &nla0, &nla0, 0,
			pql, 0, baspri, uic, mbx_unit_num, stsflgs );
		    if ( !(retstat & 1)) {
			Status_save = retstat;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $CREPRC error (with no ProcessName) (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		} else
		{ if ( !(retstat & 1)) {
			Status_save = retstat;
			sprintf(my_msg, "%s\r\n", 
			"DRAIN: $CREPRC error (specifying process name) (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		}

		Status = sys$qiow (0, chan, IO$_READVBLK, &iosb, 0, 0,
			&accstuff, ACC$C_TERMLEN, 0, 0, 0, 0);
		if ( !(Status & 1)) {
			Status_save = Status;
			sprintf(my_msg, "%s\r\n", 
		"DRAIN: $QIOW error reading termination mailbox (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}
		if ( !(iosb[0] & 1)) {
			Status_save = iosb[0];
			sprintf(my_msg, "%s\r\n", 
		"DRAIN: $QIOW error in the IOSB reading termination mailbox (2nd one)");
			send_opcom(Status_save);
		 	exit(Status_save);
			}

		completion_status = accstuff.acc$l_finalsts;
        }


//
// Must have 1 (Normal), as well as any of these 2 added to it:
//
//  9 (8+1)  Don't create filtered file         OF COURSE 9 DOESN'T MAKE 
// 17 (16+1) Don't delete temp file		ANY SENSE HERE...
// 25 (8+16+1)  Don't do either one
//
// so that adds up to 25.  The DCL routines better be good since we
// don't check on them here.  SS$_Normal (1) would mean to create the
// filtered file AND to delete the temp file.  Force it to 1 if over 25.
//

	if (completion_status > 25) completion_status = 1;

L999:
	if (!(completion_status & 16)) {
	  Status = delete(outfile);  /*  don't need the version or semi colon */
	  if (Status == -1) {
		Status_save = vaxc$errno;
		sprintf(my_msg, "%s \"%s\"\r\n", 
			"DRAIN: DELETE error on temporary file",outfile);
		send_opcom(Status_save);
	    exit(Status_save);
	    }
	}

	exit(1);
}


// *****************************************************************
// *****************************************************************
//
//		Function Definitions
//
// *****************************************************************
// *****************************************************************


int send_opcom(msgid)
	unsigned long msgid;
{

//
// my_msg already has text and trailing CR-LF.... use STATUS to get 
// full VMS msg... append to my_msg.   Find our OPCOM class and
// call SndOPR to tell the world what went wrong...
//

	char msgbuf[257];
	$DESCRIPTOR(msgbufdsc, msgbuf);

	short msglen;
	unsigned long int status, i;
	unsigned int opc_class;
	char tmp[257];

	struct {
	   struct {
		unsigned int type   : 8;
		unsigned int target : 24;
		} first_longword;
	int rqstid;
	char ms_text[257];
	} msgbuf_send;

	struct dsc$descriptor_s msgbuf_send_dsc;

	struct item item_list[1];
	short opcom_class_len;
	char opcom_class[257];

	$DESCRIPTOR (table_name, "LNM$FILE_DEV");

	char opcom_logical[257];
	$DESCRIPTOR(opcom_logical_dsc, opcom_logical);



//
// OK, now do the OPCOM stuff.  First translate our logical.
//

	item_list[0].buflen = sizeof(opcom_class);
	item_list[0].itemcode = LNM$_STRING;
	item_list[0].buffaddr = &opcom_class;
	item_list[0].retlenaddr = &opcom_class_len;
	item_list[1].buflen = 0;
	item_list[1].itemcode = 0;

	sprintf(opcom_logical,"MULTINET_DRAIN_OPC_CLASS_%lu", My_Port);
	opcom_logical_dsc.dsc$w_length = strlen (opcom_logical);

	status = sys$trnlnm (&LNM$M_CASE_BLIND, &table_name,
		&opcom_logical_dsc, 0, item_list);

// if anything goes wrong at all, including NoLogical, just use CENTRAL

	if ( (status == SS$_NOLOGNAM) )  {
		strcpy(opcom_class,"CENTRL");
		opcom_class_len = strlen(opcom_class);
	} else {
	if ( !(status == SS$_NORMAL) )  {

//
// to force an error on the $TRNLNM call (to test this code), just comment
// out the line above:
//      opcom_logical_dsc.dsc$w_length = strlen (opcom_logical);
// to get a 340: %SYSTEM-F-IVLOGNAM, invalid logical name error.
//

	  sprintf(tmp,
 "DRAIN: $TRNLNM error (in my function Send_OpCom) Status = %lu. Continuing...", status);
	  strcpy( msgbuf_send.ms_text, tmp );
	  msgbuf_send.first_longword.type = OPC$_RQ_RQST;
	  msgbuf_send.first_longword.target = OPC$M_NM_CENTRL;
	  msgbuf_send.rqstid = 0;

	  msgbuf_send_dsc.dsc$w_length = strlen(tmp) + 8;
	  msgbuf_send_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
	  msgbuf_send_dsc.dsc$b_class = DSC$K_CLASS_S;
	  msgbuf_send_dsc.dsc$a_pointer = (void *) &msgbuf_send;

	  status = sys$sndopr(&msgbuf_send_dsc,0);
	  if ( !(status & 1) )  exit(status);
	  strcpy(opcom_class,"CENTRL");
	  opcom_class_len = strlen(opcom_class);
	  }  /*  end of IF not SS$_NORMAL  */
	}   /*  end of ELSE clause  */


//
// Make sure its NULL terminated...
//
// had trouble with opcom_class_len being bigger than a word (SHORT)...
// the   opcom_class[opcom_class_len]   line failed (ACCVIO'ed) when
// it was a longword !!  (at least on AXP/VMS 7.2-1 and DEC-C v6.2).
// On another machine (AXP ES45, VMS 7.3, DEC-C v6.4), the longword works.
// And yet on a AXP 4100, VMS V7.1-1H1, DEC-C V5.7-004 the longword works too.
//

	opcom_class[opcom_class_len] = '\0';

	for (i=0; opcom_class[i]!=0; i++)
		opcom_class[i]=toupper(opcom_class[i]);

	opc_class = 0;

	if ( strcmp(opcom_class,"CENTRAL"  )==0 ) opc_class = OPC$M_NM_CENTRL;
	if ( strcmp(opcom_class,"CENTRL"   )==0 ) opc_class = OPC$M_NM_CENTRL;

	if ( strcmp(opcom_class,"PRINT"    )==0 ) opc_class = OPC$M_NM_PRINT;
	if ( strcmp(opcom_class,"TAPES"    )==0 ) opc_class = OPC$M_NM_TAPES;
	if ( strcmp(opcom_class,"TAPE"     )==0 ) opc_class = OPC$M_NM_TAPES;

	if ( strcmp(opcom_class,"DISKS"    )==0 ) opc_class = OPC$M_NM_DISKS;
	if ( strcmp(opcom_class,"DISK"     )==0 ) opc_class = OPC$M_NM_DISKS;

	if ( strcmp(opcom_class,"DEVICE"   )==0 ) opc_class = OPC$M_NM_DEVICE;
	if ( strcmp(opcom_class,"CARDS"    )==0 ) opc_class = OPC$M_NM_CARDS;
	if ( strcmp(opcom_class,"CARD"     )==0 ) opc_class = OPC$M_NM_CARDS;

	if ( strcmp(opcom_class,"NTWORK"   )==0 ) opc_class = OPC$M_NM_NTWORK;
	if ( strcmp(opcom_class,"NETWORK"  )==0 ) opc_class = OPC$M_NM_NTWORK;

	if ( strcmp(opcom_class,"CLUSTER"  )==0 ) opc_class = OPC$M_NM_CLUSTER;
	if ( strcmp(opcom_class,"SECURITY" )==0 ) opc_class = OPC$M_NM_SECURITY;
	if ( strcmp(opcom_class,"REPLY"    )==0 ) opc_class = OPC$M_NM_REPLY;
	if ( strcmp(opcom_class,"SOFTWARE" )==0 ) opc_class = OPC$M_NM_SOFTWARE;
	if ( strcmp(opcom_class,"LICENSE"  )==0 ) opc_class = OPC$M_NM_LICENSE;
	if ( strcmp(opcom_class,"OPER1"    )==0 ) opc_class = OPC$M_NM_OPER1;
	if ( strcmp(opcom_class,"OPER2"    )==0 ) opc_class = OPC$M_NM_OPER2;
	if ( strcmp(opcom_class,"OPER3"    )==0 ) opc_class = OPC$M_NM_OPER3;
	if ( strcmp(opcom_class,"OPER4"    )==0 ) opc_class = OPC$M_NM_OPER4;
	if ( strcmp(opcom_class,"OPER5"    )==0 ) opc_class = OPC$M_NM_OPER5;
	if ( strcmp(opcom_class,"OPER6"    )==0 ) opc_class = OPC$M_NM_OPER6;
	if ( strcmp(opcom_class,"OPER7"    )==0 ) opc_class = OPC$M_NM_OPER7;
	if ( strcmp(opcom_class,"OPER8"    )==0 ) opc_class = OPC$M_NM_OPER8;
	if ( strcmp(opcom_class,"OPER9"    )==0 ) opc_class = OPC$M_NM_OPER9;
	if ( strcmp(opcom_class,"OPER10"   )==0 ) opc_class = OPC$M_NM_OPER10;
	if ( strcmp(opcom_class,"OPER11"   )==0 ) opc_class = OPC$M_NM_OPER11;
	if ( strcmp(opcom_class,"OPER12"   )==0 ) opc_class = OPC$M_NM_OPER12;

	if (opc_class == 0)  {   /*  none of the above items matched  */
	  sprintf(tmp,
 "DRAIN: Logical MULTINET_DRAIN_OPC_CLASS_xxx of <%s> is not a valid OPCOM class; Continuing...",
 opcom_class );
	  strcpy( msgbuf_send.ms_text, tmp );
	  msgbuf_send.first_longword.type = OPC$_RQ_RQST;
	  msgbuf_send.first_longword.target = OPC$M_NM_CENTRL;
	  msgbuf_send.rqstid = 0;

	  msgbuf_send_dsc.dsc$w_length = strlen(tmp) + 8;
	  msgbuf_send_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
	  msgbuf_send_dsc.dsc$b_class = DSC$K_CLASS_S;
	  msgbuf_send_dsc.dsc$a_pointer = (void *) &msgbuf_send;

	  status = sys$sndopr(&msgbuf_send_dsc,0);
	  if ( !(status & 1) )  exit(status);
	  opc_class = OPC$M_NM_CENTRL;   /*  force it for code below  */
	}

	status = sys$getmsg(msgid, &msglen, &msgbufdsc, 0xF, 0);
	if ( !(status == SS$_NORMAL) &&
		!(status == SS$_MSGNOTFND) )  {  /*  make up my own message  */
		sprintf(msgbuf, 
	"DRAIN:$GETMSG error of %lu looking up msg number %lu", status, msgid);
		msglen = strlen(msgbuf);
	}

	msgbuf[msglen] = '\0';		/*  make sure  */

	strcat(my_msg, msgbuf);   /*  build my complete two-line message  */

	strcpy( msgbuf_send.ms_text, my_msg );
	msgbuf_send_dsc.dsc$w_length = strlen(my_msg) + 8;
	msgbuf_send.first_longword.type = OPC$_RQ_RQST;
	msgbuf_send.first_longword.target = opc_class;
	msgbuf_send.rqstid = 0;

	/*  The call to sys$sndopr requires that the message buffer argument
	be the address of a character string descriptor pointing to the
	buffer.  To accomplish this, the message buffer will be mapped into
	a string descriptor.
	*/

	msgbuf_send_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
	msgbuf_send_dsc.dsc$b_class = DSC$K_CLASS_S;
	msgbuf_send_dsc.dsc$a_pointer = (void *) &msgbuf_send;

	status = sys$sndopr(&msgbuf_send_dsc,0);

	if ( !(status & 1) )  exit(status);

	return 1;
}
