$! Copyright 1976, 2004 Hewlett-Packard Development Company, L.P.
$!
$! Put together various parts of the OpenVMS Freeware CD-ROM.
$! The Freeware V6.0 edition is a two-volume CD-ROM set
$! The Freeware V7.0 edition is a three-volume CD-ROM set
$!
$!
$! Procedure written by Stephen Hoffman for Freeware V4.0.
$! Updated by Stephen Hoffman for Freeware V5.0, V6.0 and V7.0.
$!
$!
$! Change Notice: Some of what is processed, created and used here is also
$! discussed over in the OpenVMS CD-ROM Cover Letter -- changes made here
$! to constructs such as the volume label(s) or to the number of Freeware
$! volumes will need to be reflected within the Cover Letter text used for
$! the OpenVMS release, and/or the information in the OpenVMS Release Notes.
$!
$! This procedure presently expects three Freeware volumes, and expects all
$! of the Freeware staging masters to be mounted.  (The LD tool is used for
$! the staging areas, and a native OpenVMS-based CD and DVD mastering tool
$! was used to generate the media masters.)
$!
$! The Freeware staging disks must be created with INITIALIZE /ERASE /SYSTEM,
$! and should specify the volume /STRUCTURE and cluster factor as appropriate
$! for the target OpenVMS environment (OpenVMS releases prior to V7.2, and 
$! OpenVMS VAX releases have obvious restrictions here), and should also
$! specify the appropriate volume label.
$! 
$!
$! p1 = FAST   Skips the PURGE, RENAME and the security-related steps
$!             (These steps can be slow, and are unnecessary when the
$!             re-run involves simply rebuilding the text files.)
$!
$
$ set noon
$ set control=(y,t)
$
$ fwvversdot == "V7.0"
$ fwvvers == "V70"
$ fwvers == "70"
$ fwfaq  == "70"
$
$
$ TYPE SYS$INPUT

  When creating a new version of the OpenVMS Freeware CD-ROM set, 
  remember to invoke INTOUCH with BUILD_MENU_INFO.INT as the target 
  file for the menu system.  (Or use BUILD_MENU_INFOALL.INT, to look 
  for the FREEWARE_README.TXT files anywhere on the Freeware disk.)

  The INTOUCH command used to build the menu must be separately 
  invoked on each CD-ROM in the Freeware CD-ROM set.  

  The INTOUCH command required looks like this:

    $ @DISK$FREEWARE%%_%:[tti_intouch]intouch.com

  And for each disk:

    $ set default DISK$FREEWARE%%_%:[FREEWARE]
    $ define freeware$loc DISK$FREEWARE%%_%:[FREEWARE]
    $ define freeware$cd DISK$FREEWARE%%_%
    $ intouch/source BUILD_MENU_INFO.int

  The number of CD-ROM volumes and the volume labels used here are
  documented in the CD-ROM cover letter for OpenVMS -- updates made
  here must be passed along to the writer updating the cover letter.

  Changes made to the category list here must be passed along to the
  OpenVMS webmaster for inclusion on the Freeware Submission webpage.

  Also remember to reset the various Freeware version references in
  the files of the [FREEWARE] directory to the current value.


$
$ a=f$environment("PROCEDURE")
$ dev    = f$parse(a,,,"DEVICE",)
$ devdir = f$parse(a,,,"DEVICE",) + f$parse(a,,,"DIRECTORY",)
$
$ define/process/nolog freeware$cd  'dev'
$ define/process/nolog freeware$loc 'devdir'
$
$! The list of category names we enforce...
$!
$ catlist = "|GAMES|GRAPHICS|LANGUAGES|MISCELLANEOUS|DECWINDOWS|NETWORKING|" +-
            "SOFTWARE|SYSTEM_MGMT|STORAGE_MGMT|BUILD_TOOLS|UNKNOWN|" +-
            "UTILITIES|MS_TOOLS|WEB_TOOLS|PROGRAMMING|FREEWARE|MULTIMEDIA|"
$ bel[0,7] = 7
$
$ close/nolog infile
$ close/nolog outfile
$
$ if f$locate("|''p1'|","|FAST|") .eq. f$length( "|FAST|")
$ then
$   write sys$output "Checking for the classic temporary (or non-shipped) files ..."
$   write sys$output "(Consider which, if any, of these should be manually deleted.)"
$
$   DIRECTORY DISK$FREEWARE'fwvers'_1:[*...]x.x,*.tmp,*.tjl,*.*jou*,*release*.*
$   DIRECTORY DISK$FREEWARE'fwvers'_2:[*...]x.x,*.tmp,*.tjl,*.*jou*,*release*.*
$   DIRECTORY DISK$FREEWARE'fwvers'_3:[*...]x.x,*.tmp,*.tjl,*.*jou*,*release*.*
$
$   write sys$output "Done searching for classic temporary (or non-shipped) files ..."
$
$ endif
$
$ call missing_readme_files DISK$FREEWARE'fwvers'_1:[000000]*.DIR
$ call missing_readme_files DISK$FREEWARE'fwvers'_2:[000000]*.DIR
$ call missing_readme_files DISK$FREEWARE'fwvers'_3:[000000]*.DIR
$
$ call scan_the_readme_files DISK$FREEWARE'fwvers'_1:[*]freeware_readme.txt
$ call scan_the_readme_files DISK$FREEWARE'fwvers'_2:[*]freeware_readme.txt
$ call scan_the_readme_files DISK$FREEWARE'fwvers'_3:[*]freeware_readme.txt
$
$ call build_zips DISK$FREEWARE'fwvers'_1:[000000]*.DIR
$ call build_zips DISK$FREEWARE'fwvers'_2:[000000]*.DIR
$ call build_zips DISK$FREEWARE'fwvers'_3:[000000]*.DIR
$
$ if f$search("sys$scratch:fw1rm.txt;*") .nes. "" then delete sys$scratch:fw1rm.txt;*
$ if f$search("sys$scratch:fw1ab.txt;*") .nes. "" then delete sys$scratch:fw1ab.txt;*
$ copy nla0: sys$scratch:fw1rm.txt
$ copy nla0: sys$scratch:fw1ab.txt
$ call gather_the_readme_files -
  DISK$FREEWARE'fwvers'_1:[*]freeware_readme.txt -
  sys$scratch:fw1rm.txt sys$scratch:fw1ab.txt DISK$FREEWARE'fwvers'_1
$
$ if f$search("sys$scratch:fw2rm.txt;*") .nes. "" then delete sys$scratch:fw2rm.txt;*
$ if f$search("sys$scratch:fw2ab.txt;*") .nes. "" then delete sys$scratch:fw2ab.txt;*
$ copy nla0: sys$scratch:fw2rm.txt
$ copy nla0: sys$scratch:fw2ab.txt
$ call gather_the_readme_files -
  DISK$FREEWARE'fwvers'_2:[*]freeware_readme.txt -
  sys$scratch:fw2rm.txt sys$scratch:fw2ab.txt DISK$FREEWARE'fwvers'_2
$ if f$search("sys$scratch:fw3rm.txt;*") .nes. "" then delete sys$scratch:fw3rm.txt;*
$ if f$search("sys$scratch:fw3ab.txt;*") .nes. "" then delete sys$scratch:fw3ab.txt;*
$ copy nla0: sys$scratch:fw3rm.txt
$ copy nla0: sys$scratch:fw3ab.txt
$ call gather_the_readme_files -
  DISK$FREEWARE'fwvers'_3:[*]freeware_readme.txt -
  sys$scratch:fw3rm.txt sys$scratch:fw3ab.txt DISK$FREEWARE'fwvers'_3
$
$ write sys$output "Creating the AAAREADME.''fwvvers' and 00FREEWARE_ABSTRACT.TXT files"
$
$ if f$search("DISK$FREEWARE''fwvers'_1:[000000]AAAREADME.''fwvvers';*") .nes. "" then delete DISK$FREEWARE'fwvers'_1:[000000]AAAREADME.'fwvvers';*
$ if f$search("DISK$FREEWARE''fwvers'_2:[000000]AAAREADME.''fwvvers';*") .nes. "" then delete DISK$FREEWARE'fwvers'_2:[000000]AAAREADME.'fwvvers';*
$ if f$search("DISK$FREEWARE''fwvers'_3:[000000]AAAREADME.''fwvvers';*") .nes. "" then delete DISK$FREEWARE'fwvers'_3:[000000]AAAREADME.'fwvvers';*
$ if f$search("DISK$FREEWARE''fwvers'_1:[000000]AAAREADME.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_1:[000000]AAAREADME.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_2:[000000]AAAREADME.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_2:[000000]AAAREADME.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_3:[000000]AAAREADME.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_3:[000000]AAAREADME.TXT;*
$
$ close/nolog hdrtmpfile
$ if f$search("sys$scratch:fw0rm.txt;*") .nes. "" then delete sys$scratch:fw0rm.txt;*
$ copy/write nla0: sys$scratch:fw0rm.txt    ! creates RMS seq. variable CR carriage control file format
$ open/append hdrtmpfile sys$scratch:fw0rm.txt
$ write hdrtmpfile " "
$ write hdrtmpfile "All OpenVMS Freeware ''fwvversdot' FREEWARE_README.TXT Files"
$ write hdrtmpfile " "
$ write hdrtmpfile "This file contains the contents of all FREEWARE_README.TXT files"
$ write hdrtmpfile "from all of the volumes of Freeware ''fwvversdot'.  Also please see"
$ write hdrtmpfile "[000000]AAAREADME.TXT for a full listing of the packages present."
$ write hdrtmpfile " "
$ write hdrtmpfile "The contents of this file are generated by CREATE_FREEWARE_PACKAGE.COM"
$ write hdrtmpfile " "
$ close/nolog hdrtmpfile 
$
$ append sys$scratch:fw0rm.txt,fw1rm.txt,fw2rm.txt,fw3rm.txt -
    DISK$FREEWARE'fwvers'_1:[000000]AAAREADME.'fwvvers'/NEW
$ COPY DISK$FREEWARE'fwvers'_1:[000000]AAAREADME.'fwvvers' DISK$FREEWARE'fwvers'_1:[000000]AAAREADME.TXT
$ append sys$scratch:fw0rm.txt,fw1rm.txt,fw2rm.txt,fw3rm.txt -
    DISK$FREEWARE'fwvers'_2:[000000]AAAREADME.'fwvvers'/NEW
$ COPY DISK$FREEWARE'fwvers'_2:[000000]AAAREADME.'fwvvers' DISK$FREEWARE'fwvers'_2:[000000]AAAREADME.TXT
$ append sys$scratch:fw0rm.txt,fw1rm.txt,fw2rm.txt,fw3rm.txt -
    DISK$FREEWARE'fwvers'_3:[000000]AAAREADME.'fwvvers'/NEW
$ COPY DISK$FREEWARE'fwvers'_3:[000000]AAAREADME.'fwvvers' DISK$FREEWARE'fwvers'_3:[000000]AAAREADME.TXT
$ if f$search("sys$scratch:fw0rm.txt;*") .nes. "" then delete sys$scratch:fw0rm.txt;*
$ if f$search("sys$scratch:fw1rm.txt;*") .nes. "" then delete sys$scratch:fw1rm.txt;*
$ if f$search("sys$scratch:fw2rm.txt;*") .nes. "" then delete sys$scratch:fw2rm.txt;*
$ if f$search("sys$scratch:fw3rm.txt;*") .nes. "" then delete sys$scratch:fw3rm.txt;*
$
$ close/nolog hdrtmpfile
$ if f$search("sys$scratch:fw0ab.txt;*") .nes. "" then delete sys$scratch:fw0ab.txt;*
$ copy/write nla0: sys$scratch:fw0ab.txt    ! creates RMS seq. variable CR carriage control file format
$ open/append hdrtmpfile sys$scratch:fw0ab.txt
$ write hdrtmpfile "All OpenVMS Freeware ''fwvversdot' Abstracts"
$ write hdrtmpfile " "
$ write hdrtmpfile "This file contains single-line abstracts from all FREEWARE_README.TXT files"
$ write hdrtmpfile "from all Freeware ''fwvversdot' volumes.  For additional and more detailed"
$ write hdrtmpfile "information, please see [000000]AAAREADME.TXT for an aggregate list of each"
$ write hdrtmpfile "FREEWARE_README.TXT file for each package present."
$ write hdrtmpfile " "
$ write hdrtmpfile "The package name may or may not match the actual directory name."
$ write hdrtmpfile " "
$ write hdrtmpfile "The contents of this file are generated by CREATE_FREEWARE_PACKAGE.COM"
$ write hdrtmpfile " "
$ close/nolog hdrtmpfile 
$
$ if f$search("DISK$FREEWARE''fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_2:[000000]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_2:[000000]00FREEWARE_ABSTRACT.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_3:[000000]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_3:[000000]00FREEWARE_ABSTRACT.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_1:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_1:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_2:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_2:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*
$ if f$search("DISK$FREEWARE''fwvers'_3:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*") .nes. "" then delete DISK$FREEWARE'fwvers'_3:[FREEWARE]00FREEWARE_ABSTRACT.TXT;*
$
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT/NEW
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_2:[000000]00FREEWARE_ABSTRACT.TXT/NEW
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_3:[000000]00FREEWARE_ABSTRACT.TXT/NEW
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_1:[FREEWARE]00FREEWARE_ABSTRACT.TXT/NEW
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_2:[FREEWARE]00FREEWARE_ABSTRACT.TXT/NEW
$ append sys$scratch:fw0ab.txt,fw1ab.txt,fw2ab.txt,fw3ab.txt -
    DISK$FREEWARE'fwvers'_3:[FREEWARE]00FREEWARE_ABSTRACT.TXT/NEW
$ delete sys$scratch:fw0ab.txt;*,fw1ab.txt;*,sys$scratch:fw2ab.txt;*
$
$
$ write sys$output "Removing all existing secondary 000TOOLS, VMSFAQ and FREEWARE directories, "
$ write sys$output "  and contents.  Various DELETE errors are normal within this section ..."
$
$ delete/exclude=(*.DIR) DISK$FREEWARE'fwvers'_2:[000TOOLS...]*.*.*,    DISK$FREEWARE'fwvers'_3:[000TOOLS...]*.*.*
$ delete                 DISK$FREEWARE'fwvers'_2:[000TOOLS...]*.*.*,    DISK$FREEWARE'fwvers'_3:[000TOOLS...]*.*.*
$ delete/exclude=(*.DIR) DISK$FREEWARE'fwvers'_2:[VMSFAQ...]*.*.*,      DISK$FREEWARE'fwvers'_3:[VMSFAQ...]*.*.*
$ delete                 DISK$FREEWARE'fwvers'_2:[VMSFAQ...]*.*.*,      DISK$FREEWARE'fwvers'_3:[VMSFAQ...]*.*.*
$ delete/exclude=(*.DIR) DISK$FREEWARE'fwvers'_2:[FREEWARE...]*.*.*,    DISK$FREEWARE'fwvers'_3:[FREEWARE...]*.*.*
$ delete                 DISK$FREEWARE'fwvers'_2:[FREEWARE...]*.*.*,    DISK$FREEWARE'fwvers'_3:[FREEWARE...]*.*.*
$
$ write sys$output "Replicating the 000TOOLS, VMSFAQ and FREEWARE directories ..."
$
$ backup DISK$FREEWARE'fwvers'_1:[000TOOLS...]*.*.0	DISK$FREEWARE'fwvers'_2:[000TOOLS...]
$ backup DISK$FREEWARE'fwvers'_1:[000TOOLS...]*.*.0	DISK$FREEWARE'fwvers'_3:[000TOOLS...]
$
$ backup DISK$FREEWARE'fwvers'_1:[VMSFAQ]*.*.0		DISK$FREEWARE'fwvers'_2:[VMSFAQ]
$ backup DISK$FREEWARE'fwvers'_1:[VMSFAQ]*.*.0		DISK$FREEWARE'fwvers'_3:[VMSFAQ]
$
$ backup DISK$FREEWARE'fwvers'_1:[FREEWARE]*.*.0	DISK$FREEWARE'fwvers'_2:[FREEWARE]
$ backup DISK$FREEWARE'fwvers'_1:[FREEWARE]*.*.0	DISK$FREEWARE'fwvers'_3:[FREEWARE]
$
$ write sys$output "Creating the VMSFAQ copies ..."
$
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_1:[VMSFAQ]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_1:[FREEWARE]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_1:[000000]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_2:[VMSFAQ]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_2:[FREEWARE]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_2:[000000]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_3:[VMSFAQ]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_3:[FREEWARE]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$ copy DISK$FREEWARE'fwvers'_1:[VMSFAQ]VMSFAQ.TXT DISK$FREEWARE'fwvers'_3:[000000]OPENVMS_FREQUENTLY_ASKED_QUESTIONS_FAQ.TXT
$
$
$ if f$locate("|''p1'|","|FAST|") .eq. f$length( "|FAST|")
$ then
$   write sys$output "Purging the directories ..."
$
$   PURGE DISK$FREEWARE'fwvers'_1:[*...]*.*
$   PURGE DISK$FREEWARE'fwvers'_2:[*...]*.*
$   PURGE DISK$FREEWARE'fwvers'_3:[*...]*.*
$   PURGE DISK$FREEWARE'fwvers'_1:[000000]*.*
$   PURGE DISK$FREEWARE'fwvers'_2:[000000]*.*
$   PURGE DISK$FREEWARE'fwvers'_3:[000000]*.*
$
$   write sys$output "Resetting the file versions ..."
$
$   RENAME DISK$FREEWARE'fwvers'_1:[*...]*.*.0 *.*;1
$   RENAME DISK$FREEWARE'fwvers'_2:[*...]*.*.0 *.*;1
$   RENAME DISK$FREEWARE'fwvers'_3:[*...]*.*.0 *.*;1
$   RENAME DISK$FREEWARE'fwvers'_1:[000000]*.*.0/EXCLUDE=(*.DIR,*.SYS) *.*;1
$   RENAME DISK$FREEWARE'fwvers'_2:[000000]*.*.0/EXCLUDE=(*.DIR,*.SYS) *.*;1
$   RENAME DISK$FREEWARE'fwvers'_3:[000000]*.*.0/EXCLUDE=(*.DIR,*.SYS) *.*;1
$
$ EndIf
$
$ write sys$output "Checking the abstracts for differences ..."
$
$ DIFF DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT,-
  DISK$FREEWARE'fwvers'_2:[000000]00FREEWARE_ABSTRACT.TXT
$ DIFF DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT,-
  DISK$FREEWARE'fwvers'_1:[FREEWARE]00FREEWARE_ABSTRACT.TXT
$ DIFF DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT,-
  DISK$FREEWARE'fwvers'_2:[FREEWARE]00FREEWARE_ABSTRACT.TXT
$ DIFF DISK$FREEWARE'fwvers'_1:[000000]00FREEWARE_ABSTRACT.TXT,-
  DISK$FREEWARE'fwvers'_3:[FREEWARE]00FREEWARE_ABSTRACT.TXT
$
$
$ write sys$output "Removing all existing ACL entries ..."
$
$ if f$locate("|''p1'|","|FAST|") .eq. f$length( "|FAST|")
$ then
$   set security/acl/delete=all DISK$FREEWARE'fwvers'_1:[000000]*.*;*
$   set security/acl/delete=all DISK$FREEWARE'fwvers'_2:[000000]*.*;*
$   set security/acl/delete=all DISK$FREEWARE'fwvers'_3:[000000]*.*;*
$
$   write sys$output "Setting appropriate security attributes ..."
$
$   set security/prot=(s:re,g:re,w:re,o:re)/owner=[system] DISK$FREEWARE'fwvers'_1:[*...]*.*;*
$   set security/prot=(s:re,g:re,w:re,o:re)/owner=[system] DISK$FREEWARE'fwvers'_2:[*...]*.*;*
$   set security/prot=(s:re,g:re,w:re,o:re)/owner=[system] DISK$FREEWARE'fwvers'_3:[*...]*.*;*
$ endif
$
$ write sys$output "Analyzing the disks for structural errors ..."
$
$ ANALYZE/DISK/REPAIR DISK$FREEWARE'fwvers'_1:
$ ANALYZE/DISK/REPAIR DISK$FREEWARE'fwvers'_2:
$ ANALYZE/DISK/REPAIR DISK$FREEWARE'fwvers'_3:
$
$ write sys$output "Removing all files in [SYSLOST], if any ..."
$
$ if f$search("DISK$FREEWARE''fwvers'_1:[000000]SYSLOST.DIR") .nes. ""
$ then
$   if f$search("DISK$FREEWARE''fwvers'_1:[SYSLOST]*.*.*") .nes. "" then delete DISK$FREEWARE'fwvers'_1:[SYSLOST]*.*.*
$   delete DISK$FREEWARE'fwvers'_1:[000000]SYSLOST.DIR;*
$ endif
$ if f$search("DISK$FREEWARE''fwvers'_2:[000000]SYSLOST.DIR") .nes. ""
$ then
$   if f$search("DISK$FREEWARE''fwvers'_2:[SYSLOST]*.*.*") .nes. "" then delete DISK$FREEWARE'fwvers'_2:[SYSLOST]*.*.*
$   delete DISK$FREEWARE'fwvers'_2:[000000]SYSLOST.DIR;*
$ endif
$ if f$search("DISK$FREEWARE''fwvers'_3:[000000]SYSLOST.DIR") .nes. ""
$ then
$   if f$search("DISK$FREEWARE''fwvers'_3:[SYSLOST]*.*.*") .nes. "" then delete DISK$FREEWARE'fwvers'_3:[SYSLOST]*.*.*
$   delete DISK$FREEWARE'fwvers'_3:[000000]SYSLOST.DIR;*
$ endif
$
$ write sys$output "Disk analysis completed ..."
$
$ TYPE SYS$INPUT

  Remember to reset the various Freeware version references in
  the files of the [FREEWARE] directory to the current value.

  Remember to stage current versions of all open-source contents
  found in the OpenVMS source code control libraries onto the
  Freeware.   As of this writing, this includes the [CDRECORD]
  facility, and may or may not include additional facilities.

  Remember to regenerate the INTOUCH menus.  

  The INTOUCH command used to build the menu must be separately 
  invoked on each CD-ROM in the Freeware CD-ROM set.  

  The INTOUCH command required looks like this:

    $ @DISK$FREEWARE%%_%:[tti_intouch]intouch.com

  And for each disk:

    $ set default DISK$FREEWARE%%_%:[FREEWARE]
    $ define freeware$loc DISK$FREEWARE%%_%:[FREEWARE]
    $ define freeware$cd DISK$FREEWARE%%_%
    $ intouch/source BUILD_MENU_INFO.int

$ write sys$output " "
$ write sys$output "CREATE_FREEWARE_PACKAGE is done!"
$ write sys$output " "
$
$
$Main_Exit:
$
$
$
$ EXIT
$
$
$
$gather_the_readme_files: subroutine
$ write sys$output "Creating the freeware one-line abstracts listings ..."
$ close/nolog infile
$ close/nolog outfile
$ close/nolog abfile
$ open/append outfile 'p2'
$ open/append abfile 'p3'
$ write abfile " "
$ write abfile "Abstracts for Volume ''p4'"
$ write abfile " "
$ ff[0,7] = 12
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",1)
$gtrf_loop1:
$ close/nolog infile
$ nextfile = f$search("''p1'",1)
$ nextfilelen = f$length(nextfile) 
$ if nextfilelen .eq. 0 then goto done
$ delimiter = f$fao("!#*+",nextfilelen)
$ write sys$output "Now processing ''nextfile' ..."
$ open/read infile 'nextfile'
$ write outfile ff
$ write outfile delimiter
$ write outfile nextfile
$ write outfile delimiter
$ write outfile " "
$ category = ""
$gtrf_loop2:
$ read/end=gtrf_loop1/error=oops infile textline
$ if category .eqs. ""
$ then
$   name = f$edit(f$element(0,",",textline),"COLLAPSE")
$   name2 = f$edit(f$element(0,",",textline),"TRIM")
$   category = f$edit(f$element(1,",",textline),"UPCASE,COLLAPSE")
$   category2 = f$edit(f$element(1,",",textline),"UPCASE,TRIM")
$   name = f$edit(f$element( 0,",",textline),"TRIM")
$   desc = f$edit(f$element( 2,",",textline),"TRIM,COMPRESS")
$   name = "''name'                                                                  "
$   desc = "''desc'                                                                  "
$   name = f$extract(0,24,name)
$   desc = f$extract(0,54,desc)
$   write abfile "''name'''desc'"
$ endif
$ write outfile textline
$ goto gtrf_loop2
$oops:
$ close/nolog infile
$ close/nolog outfile
$ write abfile " "
$ close/nolog abfile
$ write sys$output "The tub is filled with brightly colored hammers."
$ write sys$output "(Unexpected abstract creation results.)"
$ write sys$output "Freeware abstract creation terminating."
$ exit
$done:
$ close/nolog infile
$ close/nolog outfile
$ write abfile " "
$ close/nolog abfile
$ write sys$output "Freeware abstract completed."
$ exit
$ endsubroutine
$
$
$scan_the_readme_files: subroutine
$ write sys$output "Scanning the freeware abstracts ..."
$ close/nolog outfile
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",1)
$strf_loop1:
$ close/nolog infile
$ nextfile = f$search("''p1'",1)
$ nextfilelen = f$length(nextfile) 
$ if nextfilelen .eq. 0 then goto done
$ write sys$output "Now processing ''nextfile' ..."
$ open/read infile 'nextfile'
$ category = ""
$strf_loop2:
$ read/end=strf_loop1/error=oops infile textline
$ if category .eqs. ""
$ then
$   category = f$edit(f$element(1,",",textline),"UPCASE,COLLAPSE")
$   category2 = f$edit(f$element(1,",",textline),"UPCASE,TRIM")
$   gosub check_readme_first_line
$   name = f$edit(f$element( 0,",",textline),"TRIM")
$   desc = f$edit(f$element( 2,",",textline),"TRIM")
$   write sys$output "Product Name : ''name'"
$   write sys$output "Category     : ''category'"
$   write sys$output "Description  : ''desc'"
$   write sys$output " "
$ endif
$ goto strf_loop2
$oops:
$ close/nolog infile
$ write sys$output "The beer tastes very wrench-like today."
$ write sys$output "(Unexpected abstract creation results.)"
$ write sys$output "Scan of freeware abstracts terminating."
$ exit
$done:
$ close/nolog infile
$ write sys$output " "
$ write sys$output "Scan of freeware abstract contents completed ..."
$ write sys$output " "
$ exit
$check_readme_first_line:
$ if category2 .nes. category
$ then
$   write sys$output "DIAGNOSTICS  : **** Space in category name in ''nextfile' ****" + bel
$ endif
$ if f$locate("|''category'|",catlist) .eq. f$length(catlist)
$ then
$   write sys$output "DIAGNOSTICS  : **** Category name mismatch in ''nextfile' ****" + bel
$ endif
$ if category .eqs. "FREEWARE"
$ then
$   write sys$output "DIAGNOSTICS  : **** Submission uses reserved FREEWARE category ****" + bel
$ endif
$ if category .eqs. "UNKNOWN"
$ then
$   write sys$output "DIAGNOSTICS  : **** Submission uses reserved UNKNOWN category ****" + bel
$ endif
$ if f$length(category) .gt. 15
$ then
$   write sys$output "DIAGNOSTICS  : **** Category name too long ''nextfile' ****" + bel
$ endif
$! we should have two commas; no more, no less
$ commacheck1 = textline - "," - "," - "," 
$ commacheck2 = textline - "," - ","
$ if commacheck1 .nes. commacheck2
$ then
$   write sys$output "DIAGNOSTICS  : **** Spurious comma in ''nextfile' ****" + bel
$ endif
$ return
$ endsubroutine
$
$
$missing_readme_files: subroutine
$ write sys$output "Scanning for missing FREEWARE_README.TXT files ..."
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",1)
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",2)
$mrmf_loop1:
$ nextdir = f$search("''p1'",1)
$ nextdirlen = f$length(nextdir) 
$ if nextdirlen .eq. 0 then goto done
$ nextdirspec = f$parse(nextdir,,,"DIRECTORY") - "][" - "><" - "]" - ">" - "[" - "<"
$ nextdirnamspec = f$parse(nextdir,,,"NAME") 
$ if nextdirnamspec .eqs. "000000" then goto mrmf_loop1
$ nextdirspec = nextdirspec - "000000."
$ nextdirnamspec = nextdirnamspec - "000000."
$!$ nextabstract = f$parse(nextdir,,,"DEVICE") + "[" + nextdirspec + "." + nextdirnamspec + "]FREEWARE_README.TXT"
$ nextabstract = f$parse(nextdir,,,"DEVICE") + "[" + nextdirspec + "." + nextdirnamspec + "]FREEWARE_README.TXT"
$ nextabstract = nextabstract - "000000."
$ write sys$output "Now seeking ''nextabstract' ..."
$ if f$search("''nextabstract'",2) .eqs. ""
$ then
$   write sys$output "** Missing ''nextabstract'"
$   close/nolog fake
$   copy nla0: 'nextabstract'
$   open/write fake 'nextabstract'
$   write fake "''nextdirnamspec', UNKNOWN, ''nextdirnamspec' for OpenVMS"
$   write fake "  "
$   write fake "  No FREEWARE_README.TXT was provided with this submission."
$   write fake "  "
$   write fake "  The Collector of OpenVMS Freeware has provided this file"
$   write fake "  to satisfy the Freeware menu requirements; please see the"
$   write fake "  provided source code for details on this package."
$   write fake "  "
$   write fake "  This file generated by CREATE_FREEWARE_PACKAGE.COM"
$   close/nolog fake
$   write sys$output "** Missing ''nextabstract' automatically generated" + bel
$ endif
$ goto mrmf_loop1
$done:
$ write sys$output " "
$ write sys$output "Scan for missing FREEWARE_README.TXT files completed ..."
$ write sys$output " "
$ exit
$ endsubroutine
$
$
$build_zips: subroutine
$ write sys$output "Building FREEWARE_ZIP_*.ZIP directory zip archives ..."
$ tools = f$parse("''p1'",,,"DEVICE")
$ if f$search("''tools'[000TOOLS]DEFINE_TOOLS.COM") .nes. ""
$ then
$   @'tools'[000TOOLS]DEFINE_TOOLS.COM
$ else
$   write sys$output "Unable to locate ''tools'[000TOOLS]DEFINE_TOOLS.COM tools!"
$   stop
$ endif
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",1)
$ nextfile = f$search("SYS$LOGIN:LOGIN.COM",2)
$bz_loop1:
$ nextdir = f$search("''p1'",1)
$ nextdirlen = f$length(nextdir) 
$ if nextdirlen .eq. 0 then goto done
$ nextdirspec = f$parse(nextdir,,,"DIRECTORY") - "][" - "><" - "]" - ">" - "[" - "<"
$ nextdirnamspec = f$parse(nextdir,,,"NAME") 
$ if nextdirnamspec .eqs. "000000" then goto bz_loop1
$ nextdirspec = nextdirspec - "000000."
$ nextdirnamspec = nextdirnamspec - "000000."
$ ! this specifically skips certain directories, as they are not submissions, 
$ ! not yet completely initialized, and accordingly should not be zipped.
$ if f$locate("TTI_INTOUCH",nextdirnamspec) .ne. f$length(nextdirnamspec) then goto bz_loop1
$ if f$locate("FREEWARE",nextdirnamspec) .ne. f$length(nextdirnamspec) then goto bz_loop1
$ nextzip = f$parse(nextdir,,,"DEVICE") + "[" + nextdirspec + "." + nextdirnamspec + "]FREEWARE_ZIP_''nextdirnamspec'.ZIP"
$ nextzip = nextzip - "000000."
$ nextzippath = f$parse(nextdir,,,"DEVICE") + "[" + nextdirspec + "." + nextdirnamspec + "...]*.*"
$ nextzippath = nextzippath - "000000."
$ write sys$output "Now seeking ''nextzip' ..."
$ if f$search("''nextzip'",2) .nes. "" then delete 'nextzip';*
$!!!!!!!  $ zip "-V" 'nextzip' 'nextzippath'
$ goto bz_loop1
$done:
$ write sys$output " "
$ write sys$output "Zip (re)builds completed ..."
$ write sys$output " "
$ exit
$ endsubroutine
$
$
