$
$! This DCL procedure is an example of how to verify the integrity
$! of the check-out (master) copies of the Freeware media, media as
$! typically received from the software manufacturing organization.
$! 
$! Beware the FREEWARE$LOC setting when rebuilding the Freeware disk
$! menus, as it appears that errant combinations of the FREEWARE$CD
$! logical name and this logical name can cause a volume's menu to
$! become stale.
$!
$!
$!
$ set noon
$
$tryagain:
$ read/prompt="Mount the master disks? " sys$command mount
$ if mount
$ then
$   read/prompt="CD-ROM device? " sys$command device
$   if .not. f$getdvi(device,"EXISTS")
$   then
$     write sys$output "No such device; please try again"
$     goto tryagain
$   endif
$ endif
$ read/prompt="Current Freeware Version? " sys$command version
$ version = version - "V" - "."
$ version = f$integer(version)
$ read/prompt="Number of Freeware Volumes? " sys$command maxvolumes
$ maxvolumes = f$integer(maxvolumes)
$ currvolume = 0
$
$ zippackages = 0
$ bckpackages = 0
$
$loopdevice:
$ currvolume = currvolume + 1
$ if f$getdvi(device,"MNT") then DISMOUNT 'device'
$ lnmdev = f$fao("DISK$FREEWARE!SL_!SL", version, currvolume)
$ label = f$fao("FREEWARE!SL_!SL", version, currvolume)
$ if mount then MOUNT/ASSIST 'device' 'label'
$ fulldevnam = f$getdvi(lnmdev,"fulldevnam")
$
$loopzip:
$ nxtfile = f$search( "''fulldevnam'[*...]*.ZIP", 1 )
$ if nxtfile .eqs. "" then goto donezip
$ zippackages = zippackages + 1
$ unzip -l 'nxtfile'
$ goto loopfile
$donezip:
$loopbck:
$ nxtfile = f$search( "''fulldevnam'[*...]*.BCK", 1 )
$ if nxtfile .eqs. "" then goto donebck
$ bckpackages = bckpackages + 1
$ backup/list 'nxtfile' /save
$ goto loopbck
$donebck:
$loopsav:
$ nxtfile = f$search( "''fulldevnam'[*...]*.SAV", 1 )
$ if nxtfile .eqs. "" then goto donesav
$ bckpackages = bckpackages + 1
$ backup/list 'nxtfile' /save
$ goto loopsav
$donesav:
$loopa:
$ nxtfile = f$search( "''fulldevnam'[*...]*.A", 1 )
$ if nxtfile .eqs. "" then goto donea
$ bckpackages = bckpackages + 1
$ backup/list 'nxtfile' /save
$ goto loopa
$donea:
$
$
$ directory/size/date 'fulldevnam'[*...]*.*;0
$
$ write sys$output "Total zip archives found on volume    : " + zippackages
$ write sys$output "Total BACKUP savesets found on volume : " + bckpackages
$
$! reset for the next device loop, assuming there is another device.
$!
$ nxtfile = f$search( "SYS$LOGIN:LOGIN.COM", 1 )
$ zippackages = 0
$ bckpackages = 0
$
$ if currvolume .ge. maxvolumes then goto loopdevice
$
$!
$NoMoreDevices:
$ if mount then DISMOUNT 'device'
$ exit
