	program fshelp
	implicit none
c
c A HELP program
c Author   : F.Stubbe
c Date     : 29-jan-2003
c Revision : 2.0
c 
C This programs gives full screen access to help-libraries 
c and also to .olb. .tlb  and .mlb files
c This programs also reads .msghelp libraries
c
c The calling is just as normal help
c FSHELP [topic [topic ...]]
C FSHELP/LIBR=helplibrary [topic [topic ... ]]
c FSHELP @helplibrary [topic [topic ...]]
c FSHELP/text   [/libr=tlb_library]  [@tlb_library  [topic [topic ...]]
c FSHELP/macro  [/libr=mlb_library]  [@mlb_library  [topic [topic ...]]
c FSHELP/object [/libr=olb_library]  [@olb_library  [topic [topic ...]]
c FSHELP/image  [/libr=olb_library]  [@olb_library  [topic [topic ...]]
c FSHELP/message[/libr=msghelp_libr] [@msghelp_libr [topic [topic ...]]
c
c Start of program
c
	include 'fshelp_def'
c
c external functions
c
	external fshelp_cld
	logical*4 dcl_parse,cli$present
	integer*4 lib$get_symbol
c
c Local parameters
c
	character*255 module,defqual,facnam,line
	character*255 lbrnaam
	integer*4 nkar,nk_l,nk_m,option,options(3),nk_defqual
	integer*4 nk_f
	character*80 language
c
c get command line
c
	call lib$get_foreign(module,,nkar)
	module(nkar+1:)=' '
c
c Add default qualifiers
c
	if(lib$get_symbol('FSHELP_DEFAULT_QUALIFIERS',defqual,nk_defqual)) then
	  module = defqual(1:nk_defqual)//' '//module
	  nkar = nkar + nk_defqual+1
	end if
c
	option = 0
	options(2) = 0
	options(3) = 0
c
c Let cli$dcl_parse  check the syntax
c
	if(dcl_parse('HELP '//module(1:nkar),fshelp_cld)) then
c
c First the qualifiers for both help and help/mess
c
	  call cli$get_value('language',language,nk_l)
	  if(language .ne. ' ') then
	    option = option .or. fshelp_m_language
	    call lib$movc3(4,%ref(language),options(2))
	  endif
c
	  call cli$get_value('LIBRARY',lbrnaam,nk_l)
	  if(cli$present('HELP'))    option = option.or.fshelp_m_image
c
	  if(.not. cli$present('MOUSE')) then
	    option = option .or. fshelp_m_nomouse
	  endif
c
	  call cli$get_value('TOPICS',module,nk_m)
c
	  if(cli$present('message')) then
c
c the qualifiers for help/message
c
	    option = option.or.fshelp_m_message
	    call cli$get_value('FACILITY',facnam,nk_f)
	    if(nk_m .eq. 0 .or. cli$present('status')) then
	      call cli$get_value('status',line,nkar)
	      if(nkar .eq. 0) then
	        call lib$get_symbol('$status',line,nkar)
	        read(line(3:nkar),2000,err=11) options(3)
2000	        format(z8)
	      else
	        read(line(1:nkar),2010,err=11) options(3)
2010	        format(i10)
	      endif
	      option = option + fshelp_m_messtat
11	    endif
	  else
c
c Get Parameters for help itself
c
	    if(cli$present('OWNHELP')) then
c
c Display the help about this image
c
	      option = option.or.fshelp_m_own .or. fshelp_m_no_down
	      if(nk_m .eq. 0) then
	        if(language .ne. ' ') then
	          module = 'FSHELP '//language
	        else
	          module = 'FSHELP ENGLISH'
	        endif
	        nk_m = 12
	      endif
	    endif
	    if(cli$present('USERLIBRARY')) then
	      if(cli$present('USERLIBRARY.all')) then
	        option = option .or. fshelp_m_search_system .or.
     1                           fshelp_m_search_group .or.
     1                           fshelp_m_search_job .or.
     1                           fshelp_m_search_process 
	      else
	        if(cli$present('USERLIBRARY.SYSTEM')) 
     1            option = option .or. fshelp_m_search_system
	        if(cli$present('USERLIBRARY.GROUP')) 
     1            option = option .or. fshelp_m_search_group
	        if(cli$present('USERLIBRARY.JOB'))
     1            option = option .or. fshelp_m_search_job
	        if(cli$present('USERLIBRARY.PROCESS'))
     1            option = option .or. fshelp_m_search_process
	      end if
	    endif
c
	    if((option .and. fshelp_m_search_system) .ne. 0) then
	      option = option .or. fshelp_m_image
	    end if
c	  
	    if(cli$present('HELP'))     option  = option.or.fshelp_m_helplib
	    if(cli$present('TEXT'))     option  = option.or.fshelp_m_textlib
	    if(cli$present('MACRO'))    option  = option.or.fshelp_m_macrolib
	    if(cli$present('OBJECT'))   option  = option.or.fshelp_m_objectlib
	    if(cli$present('IMAGELIB')) option  = option.or.fshelp_m_shlib
	    if(cli$present('AUTOSIZE')) option  = option.or.fshelp_m_autosize
	    if(cli$present('SELECT.VERTICAL')) option =
     1                    option .or. fshelp_m_vertical
	    if(cli$present('SELECT.AUTOMATIC')) option =
     1                    option .or. fshelp_m_automatic
	    if(.not. cli$present('DOWN'))option = option.or.fshelp_m_no_down
	    if(.not. cli$present('TAB')) option = option.or.fshelp_m_no_tabs
	    if(cli$present('WHOLE'))     option = option.or.fshelp_m_whole
	    if(cli$present('VMS'))       option = option.or.fshelp_m_vms_help
	    if(cli$present('SEARCHWILD'))option = option.or.fshelp_m_searchwild
	    if(cli$present('COLOR'))     option = option.or.fshelp_m_colour
	    if(cli$present('BARS'))      option = option.or.fshelp_m_bars
	    if(cli$present('SKIPEMPTY')) option = option.or.fshelp_m_skipempty
	    if(cli$present('SORTED'))    option = option.or.fshelp_m_sorted
	    if(cli$present('INLINE'))    option = option.or.fshelp_m_inline
	    if(cli$present('LOAD_ALL'))  option = option.or.fshelp_m_all
	    if(cli$present('BINARY'))    option = option.or.fshelp_m_binary
c
	    nk_f = 0
	  endif
	  options(1) = option
c
c And call the main program
c
	  call fshelp_display_help(lbrnaam(1:nk_l)//'|'//facnam(1:nk_f),
     1           module(1:nk_m),options)
	end if
	end
        function dcl_parse(string,table)
        implicit none
c
        character*(*) string
        integer*4 table
        integer dcl_parse
c
	include '($syidef)'
c
        integer cli$dcl_parse
        external lib$get_input
	character*16 arch
c
	call lib$getsyi(syi$_arch_name,,arch)
        if(arch(1:1) .eq. 'I') then
          dcl_parse = cli$dcl_parse(string,%val(table),
     1          lib$get_input,lib$get_input,'Fshelp>')
        else
          dcl_parse = cli$dcl_parse(string,table,
     1          lib$get_input,lib$get_input,'Fshelp>')
        endif
        return
        end
