	integer*4 nl_dis_find		!#lines displayed in find
	parameter (nl_dis_find=5)
c
	integer*4 max_his		!remember jumps
	parameter (max_his=50)

	integer*4 key_len		!max key length
	parameter (key_len=80)

	integer*4 max_deep		!max deep level (declared by HELP)
	parameter (max_deep=10)
c
	integer*4 help_item_size	!distance between select items
	parameter (help_item_size=10)
c
	integer*4 nlines_help_def
	parameter (nlines_help_def = 5)	!default viewport size for select items
c
	integer*4 nlines_find_def
	parameter (nlines_find_def = 3)	!default viewport size for find
c
	integer*4 max_bro_lines		!max message window size
	parameter (max_bro_lines = 20)
c
	integer*4 max_line_length
	parameter (max_line_length=511)
c
	structure /lun/
	  integer*4 lun
	  integer*4 max_len
	end structure
c
	structure /search_item/
	  integer*4 nkar_key
	  character*(key_len) key
	end structure
c
	structure /header/
	  integer*4 lun_text            !lun for text
	  record /lun/ deeper		!lun for deeper topics
	  integer*4 rfa(2)		!rfa index for lbr (only toplevel)
	  integer*4 help_file		!what type of file (hlb,olb,..)
	  integer*4 n_head              !#header lines
	  logical*4 lbr_open		!is library opened
	  integer*4 lbr_index		!library index
	  record /lun/ lun_see		!lun for see-also's
	  record /lun/ lun_exe		!lun for execute scripts
	  integer*4 last_used(2)	!date last used
	  integer*4 tot_lines		!#lines
	  integer*4 tot_nbytes		!#bytes
	  integer*4 lun_see_master	!master lun for see-also's
	  integer*4 lun_exe_master	!master lun for execute scripts
	  integer*4 idx_autoalso	!index to automatic seealso
	  logical*4 has_extra		!contains / entries
	  integer*4 nkar_key		!variable part
	  character*(key_len) key       !this must be the last entry
	end structure
c
	structure /search/
	  record /header/ head
	  integer*4 nkar_file
	  integer*4 row
	  integer*4 col
	  integer*4 dis_row
	  integer*4 dis_col_beg
	  integer*4 dis_col_end
	  character*255 filename
	  integer*4 level
	  integer*4 sel_item(0:max_deep) 
	  record /search_item/ key(0:max_deep)
	end structure	  

	structure /execute/
	  record /header/ header
	  integer*4 nk_execute_line
	  character*(max_line_length) execute_line
	end structure	  

	structure /screen/
	  integer*4 paste_id
	  integer*4 keyboard_id
	  integer*4 control_c_seen
	  integer*4 display_id_kop
	  integer*4 nrows
	  integer*4 orig_ncols
	  integer*4 ncols
	  integer*4 nlines
	  integer*4 display_error
	  integer*4 nrows_error
	  integer*4 ncols_error
	  integer*4 dis_id_plus
	  integer*4 width_hdr
	end structure

	structure /pos/
	  integer*4 xpos
	  integer*4 ypos
	  integer*4 size
	end structure
c
	structure /control/
	  record /lun/ files
	  integer*4 lun_filenames
	  logical*4 pasalr
	  integer*4 lun_his
	  logical*4 his_wrap
	  integer*4 n_his
	  integer*4 level
	  record /header/ rec(0:max_deep)
	  integer*4 sel_item(0:max_deep)
	  record /lun/ mark
	  logical*4 autosize
	  logical*4 nodown
	  integer*4 vertical
	  integer*4 search_string_l
	  integer*4 search_string_fnd
	  character*20 search_string
	  integer*4 nlines_help
	  integer*4 nlines_find
	  logical*4 searchwild
	  logical*4 colour
	  logical*4 bars
	  logical*4 use_mouse
	  logical*4 skipempty
	  logical*4 sorted
	  logical*4 inline
	  integer*4 help_file
	  logical binary
	  integer*4 p_autolink
	  character*16 arch_name
	end structure
c
	integer*4 sel_hor,sel_ver,sel_aut
	parameter (sel_hor=0,sel_ver=1,sel_aut=2)

c  Key definitions

	integer*4 key_up			!up arrow
	integer*4 key_down			!down arrow
	integer*4 key_left			!left arrow
	integer*4 key_right			!right arrow
	integer*4 key_scrup			!screen up
	integer*4 key_scrdwn			!screen down
	integer*4 key_help			!pf2 or help
	integer*4 key_abort			!^z
	integer*4 key_find			!find key
	integer*4 key_search			!PF3
	integer*4 key_enter			!cr, enter
	integer*4 key_print			!f9,pf1-p
	integer*4 key_file			!F14,pf1-f
	integer*4 key_back			!pf4, f10
	integer*4 key_delete_one		!delete
	integer*4 key_delete_all		!lf
	integer*4 key_his_back			!f11 history one back

	integer*4 key_remove			!remove
	integer*4 key_his_up			!f13 one history up
	integer*4 key_seealso			!f12 seelalso
	integer*4 key_forw			!kp4, forward search
	integer*4 key_backw			!kp5, backward search
	integer*4 key_files			!TAB, other files
	integer*4 key_kp8			!next/prev screen 
c
	integer*4 key_mark1			!system mark1
	integer*4 key_mark2			!system mark2
	integer*4 key_mark3			!system mark3
	integer*4 key_marku			!user named mark

	integer*4 key_toggle			!toggle vert/horiz
	integer*4 key_ch_width			!change 132/80 cols
	integer*4 key_disp_info			!disp all info
	integer*4 key_swap_bars			!swap bar display

	integer*4 key_toggle_mouse
	integer*4 key_execute
	integer*4 key_disp_bin
c
	integer*4 key_mouse_1
	integer*4 key_mouse_2
	integer*4 key_mouse_3
	integer*4 key_mouse_4
c
	parameter (
     1            key_up              =-1,
     1            key_down            =-2,
     1            key_left            =-3,
     1            key_right           =-4,
     1            key_scrup           =-5,
     1            key_scrdwn          =-6,
     1            key_help            =-7,
     1            key_abort           =-8,
     1            key_find            =-9,
     1            key_search          =-10,
     1            key_enter           =-11,
     1            key_print           =-12,
     1            key_back            =-13,
     1            key_delete_one      =-14,
     1            key_delete_all      =-15,
     1            key_remove          =-16,
     1            key_his_up          =-17,
     1            key_seealso         =-18,
     1            key_forw            =-19,
     1            key_backw           =-20,
     1            key_files           =-21,
     1            key_mark1           =-22,
     1            key_mark2           =-23,
     1            key_mark3           =-24,
     1            key_marku           =-25,
     1            key_toggle          =-26,
     1            key_ch_width        =-27,
     1            key_disp_info       =-28,
     1            key_his_back        =-29,
     1            key_swap_bars       =-30,
     1            key_toggle_mouse    =-31,
     1            key_file            =-32,
     1            key_execute         =-33,
     1            key_kp8             =-34,
     1            key_disp_bin        =-35,
     1            key_mouse_1         =-36,
     1            key_mouse_2         =-37,
     1            key_mouse_3         =-38,
     1            key_mouse_4         =-39)

	structure /mouse/
	  union
	    map
	      integer*2 col
	      byte row
	      byte button
	    end map
	    map
	      integer*4 iterm
	    end map
	  end union
	end structure
	integer*4 lib_help,lib_text,lib_macr,lib_obj,lib_shlib
	integer*4 lib_eobj,lib_eshlib,lib_elfobj,lib_elfshlib
	parameter (
     1         lib_help=1,
     1         lib_text=2,
     1         lib_macr=3,
     1         lib_obj =4,
     1         lib_shlib=5,
     1         lib_eobj =6,
     1         lib_eshlib=7,
     1         lib_elfobj=8,
     1         lib_elfshlib=9
     5         )
c   
	structure /bar/
	  integer*4 nl1
	  integer*4 nl2
	  integer*4 nl3
	  logical need_bar
	  integer dis_id
	  logical horizontal
	  integer tot_lines
	  integer scr_lines
	end structure

c
c Return codes
c
	integer*4 ret_abort,ret_change_file,ret_last_history
	integer*4 ret_find_data,ret_to_file,ret_to_printer
	integer*4 ret_find_data_all,ret_first_mark,ret_last_mark
	integer*4 ret_first_seealso,ret_level_up,ret_sel_history
	parameter (ret_level_up      =  0)
	parameter (ret_abort         = -1)
	parameter (ret_change_file   = -2)
	parameter (ret_last_history  = -3)
	parameter (ret_find_data     = -4)
	parameter (ret_to_file       = -5)
	parameter (ret_sel_history   = -6)
	parameter (ret_to_printer    = -7)
	parameter (ret_find_data_all = -8)
	parameter (ret_first_mark    = -10)
	parameter (ret_last_mark     = -1999)
	parameter (ret_first_seealso = -2000)
c
	structure /autolink/
	  integer*4 p_next
	  integer*4 from_level
	  integer*4 from_sels(0:max_deep)
	  integer*4 to_level
	  integer*4 to_sels(0:max_deep)
	end structure	 	
