	function fshelp_disp_info(control)
	implicit none
c
c Display info about all loaded modules
c Display a page on the screen contains the name of all libraries
c  and all read subtopics.
c
	include 'fshelp.inc'
	record /control/ control		!:io: the control structure
	logical*4 fshelp_disp_info
c
	include '($smgdef)'
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	record /header/ file,rec
c
	integer*4 irec,ind,nl,nk1,dis_id,ikey,nk,k,top_line,nl_v,ncols,nk2
	integer*4 dis_id_kop,ntopic
	logical*4 pf1_flag,counting
	integer*4 width_helplib
	integer*4 width_topic
c
	character*132 line,line1
	character*6 cnt
	character*7 cnt1
c
	integer*4 ntot_lin,ntot_mod,ntot_byt
	integer*4 ntottot_lin,ntottot_mod,ntottot_lib,ntottot_byt
c
	integer*4 util_read_header
	external fshelp_display_info_help
	external fshelp_first,fshelp_contin
	external fshelp_last
	external fshelp_wrkey
c
1	ncols = screen.ncols
c
c go through the loop twice
c 1. to count the lines needed
c 2. to display the data
c
	do ind=1,2
	  ntottot_mod = 0
	  ntottot_lib = 0
	  ntottot_lin = 0	
	  ntottot_byt = 0	
c
	  counting = ind .eq. 1
	  if(counting) then
c
c Reset the counters
c
	    width_topic   = 0	!the max width of the topics
	    width_helplib = 0	!the max width of the helplib names
	    nl  = 0		!the number of lines needed
	  else
c
c Second time, create two windows
c 1. a header 
c 2. a scrollable window with the info
c
c ad 1. the header
c
	    call smg$create_virtual_display(2,ncols,dis_id_kop)
	    width_helplib = max(7,width_helplib)
	    line = 'Library'
	    nk = width_helplib + 1
	    line(nk+1:) = ' Nmods'
	    nk = nk + len(cnt) + 1 
	    line(nk+1:) = 'Modidx'
	    nk = nk + len(cnt) + 1 
	    width_topic = max(11,width_topic)
	    line(nk+1:) = 'File/Module'
	    nk = nk + width_topic + 1
	    line(nk+1:) = 'Ntopic'
	    nk = nk + len(cnt) + 1 
	    line(nk+1:) = 'Nlines'
	    nk = nk + len(cnt) + 1
	    line(nk+1:) = 'Nbytes'
	    nk = nk + len(cnt1) + 1
	    line(nk+1:) = 'Last used'
	    nk = nk + 9
	    call smg$put_line(dis_id_kop,line(1:ncols))
	    call smg$draw_line(dis_id_kop,2,1,2,ncols)
c
c Ad 2. the scrollable window
c make it at least the page size long, so all text of the normal window
c will be masked.
c
	    call smg$create_virtual_display(max(screen.nrows,nl),ncols,dis_id)
	  end if
c
	  irec = 1
	  do while(util_read_header(control.files.lun,irec,file))
c
c Start of next file
c
c
	    if(counting) then
c
c Just counting, add one line, and adjust the width of the libname
c
	      width_helplib = max(width_helplib,file.nkar_key)
	      nl = nl + 1
	    else
c
c Displaying library information
c
	      if(file.lun_text .eq. 0) then
	        cnt = 'NotYet'
	      else
	        call vm_file_info(file.deeper.lun,k)
	        write(cnt,1000,err=401) k
1000	        format(i6)
	      end if
401	      line = file.key(1:width_helplib)
	      nk = width_helplib + 1
	      line(nk+1:) = cnt
	      nk = nk + len(cnt) + 1
	      nk = nk + len(cnt) + 1		!skip index
c
	      call vm_read_rec_txt(control.lun_filenames,irec,nk1,nk2,line1)
	      line(nk+1:) = line1(1:nk1)
	      nk = min(len(line),nk + nk1)
	      call smg$put_line(dis_id,line(1:nk),,smg$m_bold)
	    endif
c
	    ntot_mod = 0		!counter for open modules
	    ntot_lin = 0	    	!counter for read-in lines
	    ntot_byt = 0	    	!counter for read-in bytes
c
	    if(file.lun_text .ne. 0) then
c
c Help file is open ;Try all modules
c
	      k = 1
	      do while(util_read_header(file.deeper.lun,k,rec))
	        if(rec.lun_text .ne. 0) then
	          ntot_mod = ntot_mod + 1		!one more modules
	          ntot_lin = ntot_lin + rec.tot_lines	!and more lines
	          ntot_byt = ntot_byt + rec.tot_nbytes	!and more lines
	          if(counting) then
c
c Just counting, one more line and adjust the topic width
c
	            nl = nl + 1
	            width_topic = max(width_topic,rec.nkar_key)
	          else
c
c Display the topic info
c
	            line = ' '
	            nk = width_helplib + 1 + len(cnt) + 1
c
	            write(cnt,1000,err=402) k
402	            line(nk+1:) = cnt
	            nk = nk + len(cnt) + 1
c
	            line(nk+1:) = rec.key
	            nk = nk + width_topic + 1
c
	            if(rec.deeper.lun .eq. 0) then
	              ntopic = 0
	            else
	              call vm_file_info(rec.deeper.lun,ntopic)
	            endif
	            write(cnt,1000,err=402) ntopic
403	            line(nk+1:) = cnt
	            nk = nk + len(cnt) + 1
c
	            write(cnt,1000,err=404) rec.tot_lines
404	            line(nk+1:) = cnt
	            nk = nk + len(cnt) + 1
c
	            call cnv_number(rec.tot_nbytes,cnt1)
	            line(nk+1:) = cnt1
	            nk = nk + len(cnt1) + 1
c
	            call sys$fao('!%D',nk1,line(nk+1:),rec.last_used) 
	            nk = nk + nk1
	            call smg$put_line(dis_id,line(1:nk))
	          end if
	        end if		!open module
	        k = k+1		!next module
	      end do		!all modules
c
	      ntottot_lib = ntottot_lib + 1
	      ntottot_mod = ntottot_mod + ntot_mod
	      ntottot_lin = ntottot_lin + ntot_lin
	      ntottot_byt = ntottot_byt + ntot_byt
c
	      if(counting) then
	        nl = nl + 1	!one more file totalisation line
	      else
	        call cnv_number(ntot_byt,cnt1)
	        call sys$fao(
     1            'Module !AS has !UL loaded modules with !UL lines'//
     1            ' and !AS bytes',
     1                   nk,line,
     1                   file.key(1:file.nkar_key),
     1                   %val(ntot_mod),%val(ntot_lin),cnt1)
	        call smg$put_line(dis_id,line(1:nk))
	      endif
	    end if		!open library
	    irec = irec + 1	!next library
	  end do		!all libraries
c
c All file processed
c
	  if(counting) then
	    nl = nl + 1	!one more total_totalisation line
	  else
	    call cnv_number(ntottot_byt,cnt1)
	    call sys$fao(
     1         'Total !UL libraries, !UL modules with !UL lines '//
     1          'and !AS bytes',
     1         nk,line,
     1         %val(ntottot_lib),
     1         %val(ntottot_mod),
     1         %val(ntottot_lin),cnt1)
	    call smg$put_line(dis_id,line(1:nk))
	  endif
	end do			!counting/display loop
c
c Got both displays, now paste and let the user look at it
c 1. paste header
	call smg$paste_virtual_display(dis_id_kop,screen.paste_id,1,1)
c
c 2. display the info window with a viewport
c
	call smg$paste_virtual_display(dis_id,screen.paste_id,3,1)
	nl_v = min(nl,screen.nrows-2)
	call smg$create_viewport(dis_id,1,1,nl_v,screen.ncols)
	top_line = 1
c
c Main loop, set cursoor to upper left position on screen
c
10	call smg$set_cursor_abs(dis_id,top_line,1)
c
c Let the user type a key
c
	call screen_getkey(ikey,pf1_flag,fshelp_display_info_help,control)
c
c Process all possible keys
c the user can move the display , change the width (80/132) or return
c
	if(ikey .eq. key_up .or. ikey .eq. key_scrup) then
c
c Up movements
c
	  if(ikey .eq. key_up) then
	    if(pf1_flag) then
	      k = max(1,top_line-10)
	    else
	      k = max(top_line -1,1)
	    end if
	  else
	    if(pf1_flag) then
	      k = 1
	    else
	      k = max(1,top_line-10)
	    endif
	  endif
	  if(k .ne. top_line) then
	    top_line = k
	    call smg$change_viewport(dis_id,top_line,1,nl_v,screen.ncols)
	  else
 	    call fshelp_mess(fshelp_first)	
	  end if
	elseif(ikey .eq. key_down .or. ikey .eq. key_scrdwn) then
c
c Down movements
c
	  if(ikey .eq. key_down) then
	    if(pf1_flag) then
	      k = top_line+10
	    else
	      k = top_line+1
	    end if
	  else
	    if(pf1_flag) then
	      k = nl
	    else
	      k = top_line+10
	    end if
	  endif
	  if((k + nl_v) .gt. nl) k = nl-nl_v+1
	  if(k .ne. top_line) then
	    top_line = k
	    call smg$change_viewport(dis_id,top_line,1,nl_v,screen.ncols)
	  else
	    call fshelp_mess(fshelp_last)
	  end if
	elseif(ikey .eq. key_ch_width) then
c
c Change width 80/132, this is done inb the getkey routine, but
c we need to recompute the width and so de delete the displays
c and redisplay them 
c
	  call smg$delete_virtual_display(dis_id)
	  call smg$delete_virtual_display(dis_id_kop)
	  goto 1
	elseif(ikey .eq. key_enter .or. ikey .eq. key_back .or. 
     1         ikey .eq. key_abort) then
c
c Return 
c
	  goto 90
	else
c
c All other keys signal error
c
	  call fshelp_mess(fshelp_wrkey)
	end if
	goto 10
c
c Exit, delete the virtual displays and return
c
90	call smg$delete_virtual_display(dis_id)
	call smg$delete_virtual_display(dis_id_kop)
c
c Return false if the user typed ^Z
c
	fshelp_disp_info = ikey .ne. key_abort
	return
	end
	subroutine fshelp_display_info_help
	implicit none
c
c The routine called when the user types help
c
	external fshelp_valid
c
	call fshelp_mess(fshelp_valid)
	return
	end
