   	subroutine file_add_extra_libraries(table,control)
	implicit none
c
c Search all HLP$LIBRARY*** lnms in the table
c
	character*(*) table		!:i: table name
	include 'fshelp.inc'
	record /control/ control
c
	include '($LNMDEF)'
c
	integer*4 sys$trnlnm
c
	structure /item/
	  integer*2 buflen
	  integer*2 opcode
	  integer*4 bufadr
	  integer*4 retadr
	end structure
	record /item/ items(2)
c
	integer*4 nkar,istat,nkar_s,log_ind
	character*20 line
	character*255 string
c
c Start of coding
c
	items(1).buflen = len(string)
	items(1).opcode = lnm$_string
	items(1).bufadr = %loc(string)
	items(1).retadr = %loc(nkar_s)
	items(2).buflen = 0
	items(2).opcode = 0
c
c Go through all libs (HLP_LIBRARY ..HLP_LIBRARY_999
c and stop if we cannot find one of them
c
	log_ind = 0
	call sys$fao('HLP$LIBRARY',nkar,line)
	do while(log_ind .le. 999)
c
c Try to locate the lnm
c
	  istat = sys$trnlnm(,table,line(1:nkar),,items)
	  if(istat) then
	    call file_add_library(control,string(1:nkar_s),lib_help)
	    log_ind = log_ind + 1
	    call sys$fao('HLP$LIBRARY_!UL',nkar,line,%val(log_ind))
	  else
	    log_ind = 1000
	  end if
	end do
	return
	end

	function file_add_library(control,libnam,textlib)
	implicit none
c
c Add library to list of found libs
c
	include 'fshelp.inc'
	record /control/ control
	character*(*) libnam		!:i: the libname to add
	integer*4 textlib		!:i: the library type (or 0)
	logical file_add_library	!:f: false if no file found
c
	include '($fscndef)'
	integer*4 ipos,context,nkar_filename,nk_def,nb
	character*20 default
c
	structure /fscn_item/
	  integer*2 buflen
	  integer*2 opcode
	  integer*4 bufadr
	end structure
	record /fscn_item/ fscn_items(2)
c
	character*255 filename
	character*300 oldline
c
	integer*4 max_types
	parameter (max_types = 5)
	character*20 types(max_types)
	data types/
     1    'SYS$HELP:.HLB',
     2    'SYS$SHARE:.TLB',        
     2    'SYS$SHARE:.MLB',
     2    'SYS$SHARE:.OLB',        
     2    'SYS$SHARE:.OLB'/        
c
	integer*4 beg_type,end_type,ind_type
c
	record /header/ file
c
	logical*4 lib$find_file
	integer*4 vm_read_txt
	integer*4 get_len
c
	file_add_library = .false.
	fscn_items(1).buflen = 0
	fscn_items(1).opcode = fscn$_name
	fscn_items(1).bufadr = 0
	fscn_items(2).buflen = 0
	fscn_items(2).opcode = 0
c
c See if the user specified a fixed library type
c
	if(textlib .eq. 0) then
	  beg_type = 1
	  end_type = max_types
	else
	  beg_type = max(1,min(textlib,max_types))
	  end_type = beg_type
	end if
c
c Got through all possible types	
c
	do ind_type=beg_type,end_type
	  default = types(ind_type)
	  nk_def = index(default,' ')-1
c
	  do while(lib$find_file(libnam,filename,context,default(1:nk_def)))
c
c Find all files that match the filename pattern (normally one, unless
c  the user specified something like /library=*.hlb)
c
	    nkar_filename = get_len(filename)
c
c Check if library not yet found
c
	    call vm_rewind(control.lun_filenames)
	    do while(vm_read_txt(control.lun_filenames,ipos,nb,oldline))
	      if(oldline(1:ipos) .eq. filename(1:nkar_filename)) then
	        call vm_set_eof(control.lun_filenames)
	        goto 56
	      endif
	    end do
c
c Not yes found, so process it
c parse the body from the filenamespec
c
	    call sys$filescan(filename(1:nkar_filename),fscn_items,)
	    ipos = fscn_items(1).bufadr - %loc(libnam)
	    file.key = libnam(ipos+1:ipos+fscn_items(1).buflen)
	    file.nkar_key = fscn_items(1).buflen
	    if(fscn_items(1).buflen .gt. control.files.max_len)
     1          control.files.max_len = fscn_items(1).buflen
	    call str$upcase(file.key,file.key)
c
c And write out a file record
c
	    file.lbr_open = .false.
	    file.lbr_index = 0
	    call util_write_header(control.files.lun,file)
c
c now write out a line containing
c  fullfilename#filenamebody
c
	    call vm_write_txt(control.lun_filenames,nkar_filename,
     1         filename(1:nkar_filename)//'#'//
     1         file.key(1:file.nkar_key))
	    file_add_library = .true.
56	  enddo
	  call lib$find_file_end(context)
	end do
	return
	end	 

	function file_open_file(control,number,file)
	implicit none
c
c Let lbr open the file and create toplevel memory files
c
	include 'fshelp.inc'
	record /control/ control		!:i: contol structure
	integer*4 number			!:i: number wanted
	record /header/ file			!:io: the file structure
	logical*4 file_open_file		!:f: function result
c
	logical*4 lbr$open
	integer*4 lbr$ini_control
	integer*4 lbr$find
	integer*4 lbr$get_header
	external lbr$_toomnylib
	external file_make_index_sub
	include '($lbrdef)'
	include '($lhidef)'
c
	integer*4 istat,l,nk,idx,nk1,sor_siz,sor_pos,n_tot,b_tot
	integer*4 desc(2)
	logical slash
	character*(max_line_length) line
	character*16 vmname
	record /header/ tfile
	record /lhidef/ libinfo
	record /search/  search		!to determine the size
	record /execute/ exeblk		!to determine the size
	real*4 this_time
c
c We are using lbr$get_index. Since this function does not have
c  a user parameter, we need a common to communicate the data
c
	integer*4     tmp_n_index,tmp_lun,tmp_maxlen,rfa_help(2),libtyp
	common /fshelp_hulp/ tmp_n_index,tmp_lun,tmp_maxlen,rfa_help,libtyp
c
	file_open_file = .false.
c
10	call util_read_header(control.files.lun,number,file)
c
	file_open_file = .true.
	if(file.lun_text .eq. 0 .and. .not. file.lbr_open) then
c
	  istat= lbr$ini_control(file.lbr_index,lbr$c_read,,)
c
c Could not open, problably too many libraries open
c
	  if(.not. istat) then
	    if(istat .eq. %loc(lbr$_toomnylib)) then
	      call file_close_oldest(control)
	      goto 10
	    endif
	    call lib$signal(%val(istat))
	  end if
c
	  file_open_file = .false.
	  call vm_read_rec_txt(control.lun_filenames,number,nk,nk1,line)
 	  istat = lbr$open(file.lbr_index,line(1:nk))
	  if(istat) then
	    file.lbr_open = .true.
c
	    istat = lbr$get_header(file.lbr_index,libinfo)
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_hlp) file.help_file=lib_help
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_txt) file.help_file=lib_text
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_mlb) file.help_file=lib_macr
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_obj) file.help_file=lib_obj
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_shstb)file.help_file=lib_shlib
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_eobj) file.help_file=lib_eobj
	    if(libinfo.lhi$l_type.eq.lbr$c_typ_eshstb)file.help_file=lib_eshlib
c	    if(libinfo.lhi$l_type.eq.lbr$c_typ_elfobj)file.help_file=lib_elfobj
	    if(libinfo.lhi$l_type.eq.9)file.help_file=lib_elfobj
c	    if(libinfo.lhi$l_type.eq.lbr$c_typ_elfshstb)
c     1                file.help_file=lib_elfshlib
	    if(libinfo.lhi$l_type.eq.10)
     1                file.help_file=lib_elfshlib
c
	    control.help_file = file.help_file
	    call util_read_header(control.files.lun,number,tfile)
c
	    sor_pos = 0
	    sor_siz = 0
	    if(control.sorted) then
	     sor_pos = %loc(tfile.key) - %loc(tfile) + 1
	     sor_siz = key_len
	    endif
c
c Make default luns
c
	    vmname = 'FS_IDX_'//tfile.key
	    nk1 = index(vmname,' ')-1
	    if(nk1 .lt. 0) nk1 = len(vmname)
c
	    call vm_open(file.deeper.lun,,,,vmname(1:nk1),sor_pos,sor_siz,2)
c
c Open master luns (zone's) for see_also's and execute scripts
c
	    vmname = 'FS_SEE_'//tfile.key
	    call vm_open(file.lun_see_master,,sizeof(search),,vmname(1:nk1))
	    vmname = 'FS_EXE_'//tfile.key
	    call vm_open(file.lun_exe_master,,sizeof(exeblk),,vmname(1:nk1))
c
	    tmp_lun     = file.deeper.lun
	    tmp_n_index = 0
	    tmp_maxlen  = 0
	    rfa_help(1) = 0
	    rfa_help(2) = 0
c
	    call lbr$get_index(file.lbr_index,1,file_make_index_sub,'*')
c
	    idx = file.lbr_index	 
	    if((file.help_file .ne. lib_help) .or. 
     1         (rfa_help(1) .eq. 0 .and. rfa_help(2) .eq. 0)) then
c
c no HELP topic, let file_get_text insert default text by setting idx to 0
c
	      if(file.help_file .eq. lib_help) idx = 0
	    else
c
c There was HELP topic, let file_get_text gather text
c
	      istat= lbr$find(file.lbr_index,rfa_help)
	      if(.not. istat)call lib$signal(%val(istat))
	      call fshelp_get_record(file.lbr_index,line,desc)	!skip 1 item line
	    end if
	    l = 1
	    slash = .false.
	    this_time = secnds(0.0)
	    n_tot = 0
	    b_tot = 0
	    call file_get_text(idx,line,nk,file,file,
     1                 l,0,-1,0,
     1                 .true.,tfile.key(1:tfile.nkar_key),
     1                 rfa_help,.true.,
     1                 slash,this_time,n_tot,b_tot,control)
	    file.deeper.max_len = tmp_maxlen
	    file_open_file = .true.
	  else
c
c Open was nog successful, signal error
c
	    call lib$signal(%val(istat))
	  end if
	end if
c
c All done
c
	call file_setmark(file)
	call util_rewrite_header(control.files.lun,file)
c
90	return
	end

	function file_make_index_sub(keyname,rfa)
	implicit none
c
c is called from lbr$get_index
c
	character*(*) keyname		!:i: the name of the key
	integer*4 rfa(2)		!:i: the rfa of the key
	integer*4 file_make_index_sub	!:f: return status (always 1)
c
	include 'fshelp.inc'
c
c Common for communication with calling routine
c since lbr$get_index does not have a user context, we need this common
c
	integer*4     tmp_n_index,tmp_lun,tmp_maxlen,rfa_help(2),libtyp
	common /fshelp_hulp/ tmp_n_index,tmp_lun,tmp_maxlen,rfa_help,libtyp
c
	integer*4 bpos,epos
	character*1 TAB
	parameter (TAB=char(9))
c
	record /header/ rec
c
	if(keyname .eq. 'HELP') then
c
c Save the HELP index in a special rfa for future reference
c
	  rfa_help(1)   = rfa(1)
	  rfa_help(2)   = rfa(2)
	end if
c		
	rec.lun_text = 0		!no text yet
	rec.rfa(1)   = rfa(1)		!save rfa for later access
	rec.rfa(2)   = rfa(2)
	rec.idx_autoalso = 0		!no autoalso
c
c Find first nonblank/notab char
c
	do bpos=1,len(keyname)
	  if(keyname(bpos:bpos) .ne. ' ' .and. keyname(bpos:bpos) .ne. TAB)
     1          goto 10
	end do
c
c Find last non blank/nontab
c
10	do epos=len(keyname),1,-1
	  if(keyname(bpos:bpos) .ne. ' ' .and. keyname(bpos:bpos) .ne. TAB)
     1          goto 20
	end do
c
c got all, now save to the name
c
20	rec.key      = keyname(bpos:epos)
	rec.nkar_key = min(epos-bpos+1,key_len)
	if(rec.nkar_key .gt. tmp_maxlen) tmp_maxlen = rec.nkar_key
c
c And write out to the list
c
	call util_write_header(tmp_lun,rec)	
	tmp_n_index = tmp_n_index + 1
	file_make_index_sub = 1
	return
	end

	subroutine file_close_oldest(control)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
c
	record /header/ file
c
	integer*4 k_old
c
	call file_get_oldest(control.files.lun,k_old)
c
	if(k_old .ne. 0) then
	  call util_read_header(control.files.lun,k_old,file)
	  call file_close_file(file)
	  call util_rewrite_header(control.files.lun,file)
	end if
	return
	end

	subroutine file_get_oldest(lun,k_old)
	implicit none
c
	integer*4 lun
	integer*4 k_old
c
	include 'fshelp.inc'
c
	record /header/ file,oldest
c
	integer*4 k,n_items
	logical*4 file_mark_older
c
	k_old = 0
c
	call vm_file_info(lun,n_items,)
	do k=1,n_items
	  call util_read_header(lun,k,file)
	  if(file.lun_text .ne. 0) then
	    if(k_old .eq. 0 .or. file_mark_older(file,oldest)) then
	      k_old  = k
	      oldest = file
	    end if
	  end if
20	end do
	return
	end

	subroutine file_close_file(file)
	implicit none

	include 'fshelp.inc'
	record /header/ file
c
	if(file.lun_text .ne. 0) then
	  call file_close(file.lun_text)
	  call file_close(file.deeper.lun)
	  call file_close(file.lun_see_master)
	  call file_close(file.lun_exe_master)
	endif
	call file_close_library(file)
	file.lbr_index = 0
	return
	end
	subroutine file_close_library(file)
	implicit none
c
c Close the lbr link, so it can be reused
c
	include 'fshelp.inc'
	record /header/ file	!:io: the file to close
c
	integer*4 istat
	integer*4 lbr$close
c
c Check if the library was open
c
	if(file.lbr_open) then
c
c Yes so now close it
c
	  istat = lbr$close(file.lbr_index)
	  if(.not. istat) call lib$signal(%val(istat))
	  file.lbr_open = .false.
	endif
	return
	end
	subroutine file_close_files(control)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
c
	integer*4 n_items,k
	record /header/ file
c
	call vm_file_info(control.files.lun,n_items,)
	do k=1,n_items
	  call util_read_header(control.files.lun,k,file)
	  call file_close_file(file)
	end do
	call file_close(control.files.lun)
	return
	end
c

	subroutine file_build_subtree(file,nr,control)
	implicit none
c
	include 'fshelp.inc'
	record /header/ file
	integer*4 nr
	record /control/ control
c
	record /header/ rec(max_deep)
	record /screen/ screen
	common /fshelp_screen/ screen
c
	character*(max_line_length) line                       
	integer*4 desc(2),nk,level,newl,size,ipos,istat,k,nk1,rfa(2)
	integer*4 nlines,nk_tmp,dis_id,lun_extra,sor_pos,sor_siz
	logical slash
c
	record /header/ extra
c
	integer*4 lbr$find
	logical*4 file_get_text
	character*20 tmp,vmname
	real*4 this_time
c
	character*1 TAB
	parameter (TAB=char(9))
c
	external fshelp_anaobj
c
	size = sizeof(rec(1))
c
	call util_read_header(file.deeper.lun,nr,rec(1))
	if(rec(1).lun_text .ne. 0) goto 90	!already done
c
	rec(1).tot_lines  = 0
	rec(1).tot_nbytes = 0
	istat= lbr$find(file.lbr_index,rec(1).rfa)
	if(.not. istat)call lib$signal(%val(istat))
c
	rfa(1) = rec(1).rfa(1)
	rfa(2) = rec(1).rfa(2)
c
	vmname = rec(1).key
	nk1 =    rec(1).nkar_key
c
	lun_extra = 0
c
	level = 1
	rec(level).deeper.lun = 0
	rec(level).deeper.max_len = 0
	if(file.help_file .eq. lib_help) then
	  call fshelp_get_record(file.lbr_index,line,desc)	!skip 1 item line
	endif
c
	nlines = 0
	nk_tmp = len(tmp)
	call smg$create_virtual_display(1,nk_tmp,dis_id)
	call smg$paste_virtual_display(dis_id,screen.paste_id,
     1           screen.nrows-1,screen.ncols-nk_tmp)
c
	slash = .false.
	this_time = secnds(0.0)
	rec(level).has_extra  = .false.
c
10	rec(level).deeper.lun = 0
c
c Go get text info
c
	istat = file_get_text(file.lbr_index,line,nk,rec(level),file,
     1             newl,dis_id,nlines,lun_extra,
     1             level .le. 1,vmname(1:nk1),
     1             rfa,.false.,
     1             slash,this_time,
     1             rec(1).tot_lines,rec(1).tot_nbytes,control)
c
	if(.not. istat) goto 50		!eof in lbr_index
c
c Now newl is level from line (or -1 for / item)
c
	if(newl .lt. 0) then
	  newl = level
c
c / qualifiers also include text in previous level
c
	  if(lun_extra .eq. 0) then
	    lun_extra = rec(level).lun_text
	    rec(level).has_extra  = .true.
	  endif
	  call vm_write_txt(lun_extra,0,line(1:nk))
	else
	  lun_extra = 0
c
c Skip leading blanks/tabs
c
	  ipos = 1
22	  ipos = ipos+1
	  if(line(ipos:ipos) .eq. ' ' .or. line(ipos:ipos) .eq. TAB) goto 22
	  line = line(ipos:)
	  nk = nk - ipos + 1
	end if
c
c Skip traling blanks
c
	do while(nk .gt. 3 .and. (line(nk:nk) .eq. ' ' .or. 
     1                            line(nk:nk) .eq. TAB))
	  nk = nk - 1
	end do
	if(nk .gt. key_len) nk = key_len
c
c Now handle all new level cases
c
	if(newl .gt. level) then
c
c Goto deeper level
c
	  sor_pos = 0
	  sor_siz = 0
	  if(control.sorted) then
	   sor_pos = %loc(file.key) - %loc(file) + 1
	   sor_siz = key_len
	  endif
	  call vm_open(rec(level).deeper.lun,,,file.deeper.lun,,
     1             sor_pos,sor_siz,2)
	  level = newl
	else
	  do k=level,newl,-1
	    call util_write_header(rec(k-1).deeper.lun,rec(k))
	  end do
	end if
	level = newl
	rec(level).nkar_key = nk
	rec(level).key = line(1:nk)
	rec(level).deeper.lun     = 0
	rec(level).deeper.max_len = 0
	rec(level).has_extra      = .false.
	if(nk .gt. rec(level-1).deeper.max_len) 
     1                   rec(level-1).deeper.max_len = nk
	goto 10
c
50	do while (level .gt. 1)
	  call util_write_header(rec(level-1).deeper.lun,rec(level))
	  level = level - 1
	end do
c
	level = 1
	call smg$delete_virtual_display(dis_id)
90	call file_setmark(rec(1))
c
c For object library we need something extra
c Make a new level , and add two topics,
c  anaobj, and binobj
c
c
	if(file.help_file .eq. lib_obj .or. 
     1     file.help_file .eq. lib_eobj .or.
     1     file.help_file .eq. lib_elfobj) then
	  call vm_open(rec(1).deeper.lun,,,file.deeper.lun)
	  call fshelp_getmsg(fshelp_anaobj,nk,line)
	  ipos = index(line,'|')
	  if(ipos .eq. 0) ipos = nk/2
	  extra.key = line(1:ipos-1)
	  extra.nkar_key = 15
	  call util_write_header(rec(1).deeper.lun,extra)	
	  extra.key = line(ipos+1:nk)
	  extra.nkar_key = max(ipos-1,nk-ipos)
	  call util_write_header(rec(1).deeper.lun,extra)	
	  file.deeper.max_len = 23
	endif
c
c And rewrite info to file
c
	call util_rewrite_header(file.deeper.lun,rec(1))
	return
	end

	function file_get_text(lbr_index,line,nk,this_level,parent_level,
     1                 level,dis_id,nlines,lun_extra,
     1                 ignore_slash,topic,
     1                 rfa,inital,
     1                 previous_is_slash,this_time,
     1                 tot_nrec,tot_nbytes,control)
	implicit none
c
	include 'fshelp.inc'
c
	integer*4 lbr_index		!:i: library index
	character*(*) line		!:o: data line
	integer*4 nk			!:o: #nkar
	integer*4 level			!:o: new level
	record /header/ this_level
	record /header/ parent_level
	integer*4 dis_id		!:i: display id for status
	integer*4 nlines		!:io: #lines read
	integer*4 lun_extra		!:i: extra lun to write to
	logical*4 ignore_slash		!:i: ignore / in first column
	character*(*) topic
	integer*4 rfa(2)		!:i: rfa of topic
	logical*4 inital
	logical*4 previous_is_slash
	real*4 this_time		!:io: the last time the reading line
					!      xxx was displayed
	integer*4 tot_nrec		!:io: Total records found
	integer*4 tot_nbytes		!:io: Total bytes found
	record /control/ control
	logical*4 file_get_text
c
c
	include '($smgdef)'
	include '($lhidef)'
c
	record /header/ work
	record /search/ search
	record /lhidef/ lhirec
c
	character*1 tab
	parameter (tab=char(9))
c
	integer*4 desc(2),istat,ipos,irec,video,iexe,version,majv,minv
	integer*4 kpos,lpos
	logical auto_also
	integer*4 lbr$set_module
	integer*4 lbr$search
c
	integer*4 fshelp_get_record
	integer*4 lbr$get_record
	character*132 tmp,vers,modnam
	character*20 ident
	integer*4 nk_t,nk_vers,nk_ident,dcxflag,nk_modnam,cdate(2)
	record /execute/ exe_blk
c
	include '($MHDEF)'
	record /mhdef/ mhdef
	include '($EMHDEF)'
	record /emhdef/ emhdef
c
	integer*4 do_disp_nk,line_count,nk_date
	integer*4 do_disp_lun,nk_m,k12,nb
	character*80 do_disp_line,line_m
c
	character*17 date
c
	integer*4 lbr$get_header
	external lbr$gl_control
c
	external fshelp_contin
c
	integer*4 file_do_disp
	external file_do_disp,fshelp_reading
	common /fshelp_do_disp/ do_disp_nk,do_disp_lun,do_disp_line
c
        include '($mhddef)'
        include '($credef)'
        structure /temp/
          record /mhddef/ mhddef
          record /credef/ credef
        end structure
        record /temp/ mhddef
c
c
	line_count                 = 0
	this_level.lun_text        = 0
	this_level.lun_see.lun     = 0
	this_level.lun_see.max_len = 0
	this_level.lun_exe.lun     = 0
	this_level.lun_exe.max_len = 0
	this_level.idx_autoalso    = 0	!no auto also yet
c
	istat = 1
	if(lbr_index .eq. 0) goto 90
c
	iexe = 0
	irec = 0
	this_level.n_head = 0
	video = smg$m_reverse
	if(control.colour) video = video .or. smg$m_user2
c
	if(parent_level.help_file .eq. lib_obj    .or. 
     1     parent_level.help_file .eq. lib_shlib  .or.
     1     parent_level.help_file .eq. lib_eobj   .or. 
     1     parent_level.help_file .eq. lib_eshlib .or.
     1     parent_level.help_file .eq. lib_elfobj .or. 
     1     parent_level.help_file .eq. lib_elfshlib) goto 20
c
	if((parent_level.help_file .ne. lib_help) .and. inital) goto 20
c
	call fshelp_getmsg(fshelp_reading,nk_m,line_m)
c
10	istat = fshelp_get_record(lbr_index,line,desc)
	irec = irec + 1
c
c Skip overflow
c
	if(istat) then
	  nk = desc(1)
	  tot_nrec   = tot_nrec   + 1
	  tot_nbytes = tot_nbytes + nk
c
	  if(control.binary) goto 14
	  if(dis_id .ne. 0) then
	    nlines = nlines + 1
	    if(secnds(this_time) .gt. 0.5 .and. mod(nlines,100) .eq. 0) then
 	      call sys$fao(line_m(1:nk_m),nk_t,tmp,%val(nlines))
	      call smg$put_chars(dis_id,tmp(1:nk_t),1,1,
     1             smg$m_erase_to_eol,video)
	      this_time = secnds(0.0)
	    end if
	  end if
c
	  if(parent_level.help_file .ne. lib_help) goto 14
c
	  if(.not. ignore_slash) then
	    if(nk .ge. 1 .and. line(1:1) .eq. '/') then
	      if(.not. previous_is_slash) then
	        previous_is_slash = .true.
	        level = -1
	        goto 90
	      endif
	    else
	      previous_is_slash = .false.	      
	    endif
	  end if
	  if(nk .ge. 2 .and. (line(2:2) .eq. ' ' .or. line(2:2) .eq. tab))then
	    if(line(1:1) .ge. '1' .and. line(1:1) .le. '9') then
	      level = ichar(line(1:1)) - ichar('0')
	      goto 90
	    endif
	  end if
c
c Check on comment lines
c line with ! in first column
c but if second char is [, than it must be a seealso
c
	  if(nk .gt. 0 .and. line(1:1) .eq. '!') then
	    if(nk .gt. 1 .and. line(2:2) .eq. '[') then
	      auto_also = .false.
	      line = line(3:nk)
	      if(line(1:1) .eq. '*') then
	        auto_also = .true.
	        line = line(2:)
	      endif
	      ipos = index(line,']')
	      if(ipos .gt. 0) then
	        search.head.key = line(1:ipos-1)
	        search.head.nkar_key = ipos-1
	        search.dis_row = 0
	        search.dis_col_beg = 0
	        search.dis_col_end = 0
	        this_level.lun_see.max_len = 
     1              max(this_level.lun_see.max_len,ipos-1)
	        call util_split_line(line(ipos+1:),search)
	        if(this_level.lun_see.lun .eq. 0) 
     1             call vm_open(this_level.lun_see.lun,10,
     1                sizeof(search),parent_level.lun_see.lun)
	        if(control.inline) then
	          search.dis_row = line_count + 1
	          search.dis_col_beg = 10
	          search.dis_col_end = search.dis_col_beg + 
     1                                 search.head.nkar_key - 1
	        endif
	        call vm_write(this_level.lun_see.lun,0,sizeof(search),search)
	        if(auto_also) then
	          call vm_file_info(this_level.lun_see,this_level.idx_autoalso)
	        endif
	        if(control.inline) then
	          line =  'See also '//search.head.key
	          nk = search.head.nkar_key + 9
	          goto 14
	        end if
	      end if
	    end if
	    if(nk .gt. 1 .and. line(2:2) .eq. '#') then
	      this_level.n_head = irec-1
	    end if
	    if(nk .gt. 1 .and. line(2:2) .eq. '@') then
	      line = line(3:)
	      nk = nk - 2
c
c New format
c
	      ipos = index(line,']')
	      if(ipos .eq. 0) then
	        exe_blk.execute_line = line
	        exe_blk.nk_execute_line = nk
	        iexe = iexe + 1
	        exe_blk.header.nkar_key = 0
	        call sys$fao('Topic !UL',exe_blk.header.nkar_key,
     1                 exe_blk.header.key,%val(iexe))
	      else
	        exe_blk.header.nkar_key = ipos-2
	        exe_blk.header.key = line(2:ipos-1)
	        exe_blk.execute_line = line(ipos+1:)
	        exe_blk.nk_execute_line = nk - ipos
	      endif
	      if(this_level.lun_exe.lun .eq. 0) 
     1            call vm_open(this_level.lun_exe.lun,10,
     1                sizeof(exe_blk),parent_level.lun_exe.lun)
	      call vm_write(this_level.lun_exe.lun,0,sizeof(exe_blk),exe_blk)
	    end if
	    goto 10
	  end if
c
c Not a new level, so write out to text
c (only if not yet seen a new level)
c
14	  if(this_level.lun_text .eq. 0) 
     1             call vm_open(this_level.lun_text,8,,
     1                          parent_level.lun_text)
	  if(control.binary) then
	    call make_binary_block(this_level.lun_text,irec,nk,%ref(line),
     1                        this_level.n_head)
	    goto 10
	  endif
	  line_count = line_count + 1
15	  if(control.inline) then
	    ipos = index(line(1:nk),'[[')
	    if(ipos .ne. 0) then
	      tmp = line(ipos+2:)
	      kpos = index(tmp,']')
	      if (kpos .ne. 0) then
	        search.head.key = tmp(1:kpos-1)
	        search.head.nkar_key = kpos-2
	        tmp = tmp(kpos+1:)
	        lpos = index(tmp,']')
	        if(lpos .ne. 0) then
	          search.dis_row = line_count
	          search.dis_col_beg = ipos
	          search.dis_col_end = ipos+kpos-1   
	          this_level.lun_see.max_len = 
     1                  max(this_level.lun_see.max_len,kpos-1)
	          call util_split_line(tmp(1:lpos-1),search)
	          if(this_level.lun_see.lun .eq. 0) 
     1               call vm_open(this_level.lun_see.lun,10,
     1                sizeof(search),parent_level.lun_see.lun)
	          call vm_write(this_level.lun_see.lun,0,sizeof(search),search)
	          line =  line(1:ipos-1)//line(ipos+2:ipos+kpos)//
     1                    line(ipos+kpos+lpos+2:)
	          nk = nk -2 -1 - lpos 
	          goto 15
	        end if  !found second ]
	      endif     !found first ]
	    endif       !found [[
	  endif		!inline
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
	  if(lun_extra .ne. 0) call vm_write_txt(lun_extra,nk,line(1:nk))
	  goto 10
	end if
18	level = -1
	goto 90
c
c Speciale versie voor OBJ en SHareable object libraries
c
20	if(this_level.lun_text .eq. 0) then
	  call vm_open(this_level.lun_text,1,,parent_level.lun_text)
	endif
	if(inital) then	
c
c Get library header
c
	  istat = lbr$get_header(lbr_index,lhirec)
c
	  tmp = 'Unknown#'
	  if(parent_level.help_file .eq. lib_text)  tmp = 'Text#'
	  if(parent_level.help_file .eq. lib_macr)  tmp = 'Macro#'
	  if(parent_level.help_file .eq. lib_obj)   tmp = 'Object#'
	  if(parent_level.help_file .eq. lib_shlib) 
     1            tmp = 'Shareable image symbol table#'
	  if(parent_level.help_file .eq. lib_eobj)   tmp = 'Alpha Object#'
	  if(parent_level.help_file .eq. lib_eshlib) 
     1            tmp = 'Alpha Shareable image symbol table#'
	  if(parent_level.help_file .eq. lib_elfobj)   tmp = 'IA64 Object#'
	  if(parent_level.help_file .eq. lib_elfshlib) 
     1            tmp = 'IA64 Shareable image symbol table#'
	  ipos = index(tmp,'#')-1
	  do_disp_line = line
	  do_disp_nk   = nk
c	  if(parent_level.help_file .eq. lib_elfobj) then
c	    call util_read_header(this_level.deeper.lun,1,work)
c	    call fshelp_files_test(lbr_index,work.key(1:work.nkar_key))
c	  endif
	  call sys$fao('Directory of !AS library !AS',nk,line,tmp(1:ipos),
     1             do_disp_line(1:do_disp_nk))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  ipos = ichar(lhirec.lhi$t_lbrver(1:1))
	  call sys$fao('Creation date:  !20%D      Creator:  !AS',nk,line,
     1         lhirec.lhi$l_credat,lhirec.lhi$t_lbrver(2:ipos+1))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  call sys$fao('Revision date:  !20%D      '//
     1                 'Library format:!4UL.!UL',nk,line,
     1                 lhirec.lhi$l_updtim,
     1                 %val(lhirec.lhi$l_majorid),
     1                 %val(lhirec.lhi$l_minorid))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  call fshelp_file_get_hdr(lbr$gl_control,ipos,dcxflag)
c
	  call sys$fao('Number of modules:!7UL                 '//
     1                 'Max. key length:!4UL',nk,line,
     1                %val(lhirec.lhi$l_modcnt),%val(ipos))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  call sys$fao('Other entries:!11UL                 '//
     1                 'Preallocated index blocks:!7UL',nk,line,
     1                 %val(lhirec.lhi$l_idxcnt-lhirec.lhi$l_modcnt),
     1                 %val(lhirec.lhi$l_hipreal-1))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  call sys$fao('Recoverable deleted blocks:!7UL        '//
     1                 'Total index blocks used:!9UL',nk,line,
     1                 %val(lhirec.lhi$l_freeblk),
     1                 %val(lhirec.lhi$l_idxblks))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	  call sys$fao('Max. Number history records:!8UL      '//
     1                 'Library history records:!9UL',nk,line,
     1                 %val(lhirec.lhi$l_maxluhrec),
     1                 %val(lhirec.lhi$l_numluhrec))
	  call vm_write_txt(this_level.lun_text,nk,line(1:nk))
	  if(dcxflag .ne. 0) call vm_write_txt(this_level.lun_text,1,
     1         'Library is in DCX data reduced format')
c
	else
c
c Make index of object names
c Get first line, contains MHD info
c Contains
c byte contents
c 0    MHD$B_RECTYP
C 1    MHD$B_HDRTYP
C 2    MHD$B_STRLVL
C 3    MHD$W_RECSIZ
C 5    MHD$B_NAMLNG
C 6    MHD$T_NAME  (variable)
C        Contains version
C      CREDAT (17 bytes long)
c      PATDAT (17 bytes long) 
c
c We skip all upto MHD$B_NAMLNG (so skip the first 5 bytes)
c The total record length is then len(name) + 2*17 so the namelength=reclen-34
c
	  if(parent_level.help_file .eq. lib_eobj .or. 
     1       parent_level.help_file .eq. lib_eshlib) then
c
c Alpha case
c
	    istat = lbr$get_record(lbr_index,line,desc)
	    nk = %loc(emhdef.emh$b_namlng) - %loc(emhdef)	!alpha
	  elseif(parent_level.help_file .eq. lib_obj .or. 
     1       parent_level.help_file .eq. lib_shlib) then
c
c Vax case
c 
	    istat = lbr$get_record(lbr_index,line,desc)
	    nk = %loc(mhdef.mhd$b_namlng) - %loc(mhdef)		!vax
	  elseif(parent_level.help_file .eq. lib_elfobj) then
c
c IA64 case
c 
	    call fshelp_files_prelf(lbr_index,rfa,
     1                this_level.key(1:this_level.nkar_key),
     1                modnam,nk_modnam,
     1                vers,nk_vers,date,nk_date,
     1                ident,nk_ident)
	    goto 45
	  elseif(parent_level.help_file .eq. lib_elfshlib) then
	    istat = lbr$get_record(lbr_index,line,desc)
	    desc(2) = 0
	    call elf_process_note_sh(%loc(line),desc(1),
     1        modnam,nk_modnam,vers,nk_vers,date,nk_date)
	    goto 45	    
	  endif
	  line = line(nk+1:)
c
c Now extract Name (ASCIC field)
c
	  nk = ichar(line(1:1))		!length
	  modnam = line(2:nk+1)
	  nk_modnam = nk
	  line = line(nk+2:)
c
c Now extract version (ASCIC field)
c
	  nk_vers = ichar(line(1:1))			!get length
	  vers = line(2:nk_vers+1)
	  date = line(nk_vers+2:)
c
45 	  call sys$fao('Module creation date     !AS',nk_t,tmp,date)
c
	  desc(1) = sizeof(mhddef)		!vax
	  desc(2) = %loc(mhddef)
	  istat = lbr$set_module(lbr_index,rfa,desc,nk)
	  if(istat) then
	    if(parent_level.help_file .eq. lib_shlib .or. 
     1         parent_level.help_file .eq. lib_eshlib .or.
     1         parent_level.help_file .eq. lib_elfshlib) then
c
c Shareable library
c
	      nb = mhddef.mhddef.MHD$B_OBJIDLNG
	      if(nb .gt. 4) nb = 4
	      k12 = %loc(mhddef.mhddef.MHD$B_OBJIDLNG) + 1
	      version = 0
	      call lib$movc3(nb,%val(k12),version)
	      majv = rshift(version,24)
	      minv = iand(version,'FFFFFF'X)
	      call sys$fao('!2XL,!6XL',nk_ident,ident,%val(majv),%val(minv))
	    elseif(parent_level.help_file .eq. lib_obj .or.
     1             parent_level.help_file .eq. lib_eobj .or.
     1             parent_level.help_file .eq. lib_elfobj) then
c
c  Vax object
c
	      call sys$fao('!AC',nk_ident,ident,mhddef.mhddef.mhd$b_objidlng)
	      call sys$fao('!AC',nk_ident,ident,mhddef.mhddef.mhd$b_objidlng)
	    endif
c
	    call sys$fao('!AS Ident !AS, Version !AS, !UL symbols',
     1                 nk,line,
     1                 topic,ident(1:nk_ident),vers(1:nk_vers),
     1                 %val(mhddef.mhddef.mhd$l_refcnt-1))
	    call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	    call vm_write_txt(this_level.lun_text,1,tmp(1:nk_t))
	    this_level.n_head = 4
c
	    if(parent_level.help_file .eq. lib_shlib .or. 
     1         parent_level.help_file .eq. lib_eshlib .or.
     1         parent_level.help_file .eq. lib_elfshlib) then
	      call fshelp_util_crea_date(modnam(1:nk_modnam),'SYS$SHARE:.EXE',
     1            cdate)
	      call sys$fao('Executable creation date !%D',nk,line,cdate)
	      call vm_write_txt(this_level.lun_text,nk,line(1:nk))
	      this_level.n_head = 5
	    endif
c
	    call sys$fao('Module insertion date    !%D',nk,line,
     1                 mhddef.mhddef.mhd$l_datim)
	    call vm_write_txt(this_level.lun_text,nk,line(1:nk))
c
	    line = 'Module'
	    line(41:) = 'Module'
	    call vm_write_txt(this_level.lun_text,nk,line(1:nk))
	    do_disp_nk  = 0
	    do_disp_lun = this_level.lun_text
c	    
	    istat = lbr$search(lbr_index,2,rfa,file_do_disp)
	    call vm_write_txt(this_level.lun_text,do_disp_nk,
     1                       do_disp_line(1:do_disp_nk))
	    call vm_file_info(this_level.lun_text,ipos,,,,nb)
	    tot_nrec   = tot_nrec   + ipos
	    tot_nbytes = tot_nbytes + nb
	  endif
	endif
	istat = 1
	istat = 0
	level = -1
	goto 99
c
90	if(this_level.lun_text .eq. 0) then
	  call vm_open(this_level.lun_text,1,,parent_level.lun_text)
	  if(.not. control.skipempty) then
	    call vm_write_txt(this_level.lun_text,1,' ')
	    call fshelp_getmsg(fshelp_contin,do_disp_nk,do_disp_line)
	    call vm_write_txt(this_level.lun_text,nk,
     1                      do_disp_line(1:do_disp_nk))
	    call vm_write_txt(this_level.lun_text,1,' ')
	  endif
	end if
99	file_get_text = istat
	return
	end

	function file_do_disp(module)
	implicit none
	character*(*) module
	integer*4 file_do_disp

c
	integer*4 do_disp_nk
	integer*4 do_disp_lun
	character*80 do_disp_line

	common /fshelp_do_disp/ do_disp_nk,do_disp_lun,do_disp_line
c
	if(do_disp_nk + len(module) .gt. 80) then
	  call vm_write_txt(do_disp_lun,do_disp_nk,do_disp_line(1:do_disp_nk))
	  do_disp_nk = 0
	endif
	do_disp_line(do_disp_nk+1:) = module
c	do_disp_nk = do_disp_nk + len(module) + 1
	do_disp_nk = do_disp_nk + max(40,len(module))
	file_do_disp = 1
	return
	end
	function file_get_record(control,nr,file)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
	integer*4 nr
	record /header/ file
	logical*4 file_get_record
c
	integer*4 nfile
	logical*4 file_open_file
c
	call vm_file_info(control.files.lun,nfile,)	
	if(nr .gt. 0 .and. nr .le. nfile) then
	  file_get_record = file_open_file(control,nr,file)
	else
	  file_get_record = .false.
	end if
	return
	end

	function file_get_next(control,max_level)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
	integer*4 max_level
	logical*4 file_get_next
c
	integer*4 lv,nr,size
	integer*4 util_read_header,file_get_record
c
	file_get_next = .false.
	size = sizeof(control.rec(0))
c
10	lv = control.level
	nr = control.sel_item(lv) 
c
	if(lv .lt. max_level .and. nr .gt. 0) then
	  if(lv .eq. 1) then
	    call file_build_subtree(control.rec(0),nr,control)
	    call util_read_header(control.rec(0).deeper.lun,nr,control.rec(1))
	  end if
	  if(control.rec(lv).deeper.lun .ne. 0) then
	    control.level = control.level + 1
	    control.sel_item(control.level) = 0
	    goto 10
	  end if
	end if
c
20	lv = control.level
	control.sel_item(lv) = control.sel_item(lv) + 1
	nr = control.sel_item(lv) 
c
	if(lv .lt. 0) then
	  goto 90
	elseif(lv .eq. 0) then
	  if(.not. file_get_record(control,nr,control.rec(0))) goto 80
	else
	  if(.not. util_read_header(control.rec(lv-1).deeper.lun,nr,
     1             control.rec(lv))) goto 80
	end if
	file_get_next = .true.
	goto 90
80	control.level = control.level -1
	goto 20
90	return
	end

	subroutine file_in_core(control)
	implicit none
c
	include 'fshelp.inc'
	record /control/control
c
	if(control.level .eq. 1) then
	  if(control.rec(1).lun_text .eq. 0) then
	    call file_build_subtree(control.rec(0),control.sel_item(1),control)
	    call util_read_header(control.rec(0).deeper.lun,
     1                      control.sel_item(1),control.rec(1))
	  end if
	end if
	if(control.level .eq. 2 .and. 
     1          (control.rec(0).help_file .eq. lib_obj .or. 
     1           control.rec(0).help_file .eq. lib_eobj .or.
     1           control.rec(0).help_file .eq. lib_elfobj)) then
	  call file_get_object(control.rec(0),control.sel_item(1),
     1              control.rec(2),control,
     1              control.sel_item(2) .eq. 1,
     1              control.rec(0).help_file .eq. lib_elfobj)
	endif
	return
	end

	subroutine file_setmark(rec)
	implicit none
c
	include 'fshelp.inc'
	record /header/ rec
c

	call sys$gettim(rec.last_used)
	return
	end

	function file_mark_older(rec1,rec2)
	implicit none
c
c Return true if rec1 older than rec2
c
	include 'fshelp.inc'
	record /header/ rec1
	record /header/ rec2
	logical*4 file_mark_older
c
	integer*4 tmp(2)
c
	call lib$sub_times(rec1.last_used,rec2.last_used,tmp)
	file_mark_older = tmp(2) .ge. 0
	return
	end
	function fshelp_get_record(lbr_index,line,nk)
	implicit none
c
	include 'fshelp.inc'
c
	integer*4 lbr_index
	character*(*) line
	integer*4 nk
	integer*4 fshelp_get_record
c
	integer*4 istat,desc(2),k,l,nk_read
	character*(max_line_length) regel
	pointer (p_regel,regel)
c
	integer*4 lbr$get_record
	external lbr$_rectrunc
c
	character tab
	parameter (tab=char(9))
c
c Use locate mode, it makes things faster
c
	call lbr$set_locate(lbr_index)
	istat = lbr$get_record(lbr_index,regel,desc)
	call lbr$set_move(lbr_index)
	p_regel = desc(2)
	if(istat .eq. %loc(lbr$_rectrunc)) then
	  istat = 1
	  nk_read = len(regel)
	else
	  nk_read = desc(1)
	end if
	nk = 0
	if(istat) then
c
c Go through it, to expand tabs
c first see if TAB is present
c
	  if(index(regel(1:nk_read),tab) .ne. 0) then
c
c Yes it is, so do it the slow way
c
	    do k=1,nk_read
	      if(regel(k:k) .eq. tab) then
	        l = nk-8*(nk/8)
	        if(l .eq. 0) l = 8
	        do while(l .gt. 0)
	          if(nk .eq. len(line)) goto 90
	          nk = nk + 1
	          line(nk:nk) = ' '
	          l = l-1
	        end do
	      else
	        if(nk .eq. len(line)) goto 90
	        nk = nk + 1
	        line(nk:nk) = regel(k:k)
	      end if
	    end do
	  else
	    nk = min(nk_read,len(line))
	    call lib$movc3(nk,%ref(regel),%ref(line))
          endif
	end if
90	fshelp_get_record = istat
	return
	end
	subroutine fshelp_file_get_hdr(pheaderi,k,dcxvbn)
	implicit none
c
	integer*4 pheaderi
	integer*4 k
	integer*4 dcxvbn
c
	include '($lbrctltbl)'
	record/lbrctltbl/ header
	pointer (pheader,header)
c
	structure /idddef/
	  integer*2 FLAGS	!,W Flags longword
	  integer*2 KEYLEN	!,W Total length of key
	  integer*4 VBN		!,L VBN of first block of index
	  integer*2 LENGTH	!,L 
	end structure
C
CDEC$ OPTIONS /NOALIGN/warn=noalign
	structure /lhddef/
	  byte TYPE		!,B Type of library
	  byte NINDEX		!,B Number of indices
	  integer*2 spare1	!,W,1 Reserved word
	  integer*4 SANITY	!,L ID for sanity check
	  integer*2 MAJORID	!,W Library format level major id
	  integer*2 MINORID	!,W Library format level minor id
	  character*32 LBRVER	!,T,32  ASCIC version of librarian that created library
	  integer*4 CREDAT(2)	!,L Creation date/time
	  integer*4 UPDTIM(2)	!,L Date/time of last update
	  byte MHDUSZ		!,B,1 Size in bytes of additional module header data
	  integer*2 IDXBLKF	!,W Number of disk blocks in index segment
	  byte spare2		!,B,1 Spares
	  integer*2 CLOSERROR	!,W Toggle during library close to trap an interupted write.
	  integer*2 SPAREWORD	!,W Spare
	  integer*4 FREEVBN	!,L VBN of 1st deleted block
	  integer*4 FREEBLK	!,L Number of deleted blocks
	  integer*2 NEXTRFA(3)	!,B,6  Next free spot for data puts
	  integer*4 NEXTVBN	!,L Next free VBN for alloc_block
	  integer*4 FREIDXBLK	!,L Number of free pre-allocated index blocks
	  integer*4 FREEIDX	!,L Listhead for pre-allocated index blocks
	  integer*4 HIPREAL	!,L VBN of highest pre-allocated index block
	  integer*4 HIPRUSD	!,L VBN of highest pre-allocated block in use
	  integer*4 IDXBLKS	!,L Number of index blocks in use
	  integer*4 IDXCNT	!,L Number of index entries (total)
	  integer*4 MODCNT	!,L Number of entries in index 1 (module names)
	  integer*2 spare3	!,W Spare
	  integer*4 MODHDRS	!,L Number of module headers in library
	  integer*4 IDXOVH	!,L Number of overhead index pointers
	  integer*2 MAXLUHREC	!,W Max number of update history records.
c				!  If zero then lib won't have history
	  integer*2 NUMLUHREC	!,W ! Count of history records.
	  integer*2 BEGLUHRFA(3)!,B,6! RFA of beginning of history
	  integer*2 ENDLUHRFA(3)!,B,6! RFA of end of library update history
	  integer*4 DCXMAPVBN	!,L  VBN of DCX map (if in reduced format)
	  integer*4 spare4(13)	!,L,13 Spares
	  record /idddef/ idddef(1)	!
	end structure
CDEC$ END OPTIONS
c
	record /lhddef/ lhddef
	pointer (plhddef,lhddef)
c!
	pheader = pheaderi
	plhddef = header.lbr$l_hdrptr
c
	k = lhddef.idddef(1).keylen-1
	dcxvbn = lhddef.dcxmapvbn
	return
	end
	subroutine file_get_object(file,nr,rec,control,raw,ia64)
	implicit none
c
	include 'fshelp.inc'
	record /header/ file
	integer*4 nr
	record /header/ rec
	record /control/ control
	logical raw
	logical ia64
c
	record /header/ hdr
c
	integer*4 istat,desc(2),irec,nlins,nbyts
	character*32768 regel
	integer*4 lbr$find
	integer*4 lbr$get_record
	integer*4 fshelp_obj_ia64
c
	integer*4 table1(32),table2(32)
c
c Get the record of the main topic, this contains the rfa for the
c olb file, and position the pointer to it
c
	call util_read_header(file.deeper.lun,nr,hdr)
	call util_read_header(hdr.deeper.lun,control.sel_item(2),rec)
	if(rec.lun_text .eq. 0) then
	  call vm_open(rec.lun_text,,,file.lun_text)
	  if(ia64) then
	    istat = fshelp_obj_ia64(file.lbr_index,hdr.rfa,
     1                rec.lun_text,.true.,raw)
	  else
	    istat= lbr$find(file.lbr_index,hdr.rfa)
c	  
	    if(istat) then
	      irec = 1
	      call fshelp_obj_init(table1,table2)
	      do while(lbr$get_record(file.lbr_index,regel,desc))
	        if(raw) then
	          call fshelp_obj_wrraw(rec.lun_text,irec,desc(1),%ref(regel),
     1                table1,table2)
	        else
	          call fshelp_obj_wrint(rec.lun_text,irec,desc(1),%ref(regel),
     1                table1,table2)
	        endif
	      end do
	      call fshelp_obj_report(rec.lun_text,table1,table2)
	    endif
	  endif
	  if(.not. istat) then
	    call vm_write_txt(rec.lun_text,0,'Error reading library')
	  endif
	  call vm_file_info(rec.lun_text,rec.tot_lines,,,,rec.tot_nbytes)
	  call util_rewrite_header(hdr.deeper.lun,rec)
	  hdr.tot_lines  = hdr.tot_lines  + rec.tot_lines
	  hdr.tot_nbytes = hdr.tot_nbytes + rec.tot_nbytes
	  call util_rewrite_header(file.deeper.lun,hdr)
	endif
	return
	end
	subroutine make_binary_block(lun,irec,nb,data,n_head)
	implicit none
c
c Make a binary dump of the datablock
c
	integer*4 lun		!:i: the lun to write to
	integer*4 irec		!:i: record number
	integer*4 nb		!:i: #bytes in block
	byte data(*)		!:i: the data
	integer*4 n_head	!:o: #header lines
c
	character*80 line
	integer*4 nk,nbpl,bpos,nbtodo,pos,posasc,posoff,k,l
c
	character*(*) set_bold,set_norm
	parameter (set_bold= char(27)//'[1m')
	parameter (set_norm= char(27)//'[m')
c
	nbpl = 16		!16 bytes/line	
c
	if(irec .eq. 1) then
	  pos = nbpl*2 + nbpl/4		!one space/word
	  posasc = pos + 2
	  posoff = posasc + nbpl + 2
	  line = ' '
	  line(pos-nbpl-6:)      = 'Binary'
	  line(posasc+nbpl/2-2:) = 'Ascii'
	  line(posoff:) = 'Offset'
	  nk = posoff + 6
	  call vm_write_txt(lun,0,line(1:nk))
	  line = ' '
	  do k=1,nbpl
	    write(line(pos:pos),1001) k-1
1001	    format(z1.1)
	    line(posasc:posasc) = line(pos:pos)
	    pos = pos - 2
	    if(mod(k-1,4) .eq. 3) pos = pos - 1
	    posasc = posasc + 1
	  end do	  
	  call vm_write_txt(lun,0,line(1:nk))
	  n_head = 2
	endif
	bpos = 0
	call sys$fao('!ASRecord !UL, recordsize !UL bytes !AS',nk,line,
     1           set_bold,%val(irec),%val(nb),set_norm)
	call vm_write_txt(lun,0,line(1:nk))
c
10	nbtodo = nbpl
	if(bpos+nbtodo .ge. nb) nbtodo = nb-bpos
	if(nbtodo .gt. 0) then
	  pos = nbpl*2 + nbpl/4		!one space/word
	  posasc = pos + 2
	  posoff = posasc + nbpl + 2
	  line = ' '
	  write(line(posoff:posoff+5),1000) bpos
1000	  format(z6.6)
	  do k=1,nbtodo
	    write(line(pos-1:pos),1010) data(bpos+k)
1010	    format(z2.2)
	    pos = pos - 2
	    if(mod(k-1,4) .eq. 3) pos = pos - 1
	    l = iand(zext(data(bpos+k)),'7F'X)
	    if(l .lt. ichar(' ') .or. l .ge. 127) l = ichar('.')
	    line(posasc:posasc) = char(l)
	    posasc = posasc + 1
	  end do
	  nk = posoff + 6
	  call vm_write_txt(lun,0,line(1:nk))
	  bpos = bpos + nbtodo
	  goto 10
	endif
	return
	end
