	subroutine fshelp_display_help(lbrnaam,module,options)
	implicit none
c
c The help routine
c
	include 'fshelp_def'
	include 'fshelp.inc'
	include '($hlpdef)'
	include '($jpidef)'
	include '($dvidef)'
	include '($syidef)'
	include '($ssdef)'
c
	character*(*) lbrnaam	!:i: libraryname or space
				!    for messagehelp the library name can
				!    be preceeded by the facility|
	character*(*) module	!:i: topics or space
	integer*4 options(3)    !:i: options field
				!    options[1] : the options 
				!    options[2] : the language
				!    options[3] : the msghelp statuscode
c
	record /search/ search
	record /control/ control
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /fshelp_vms_nlines/ nlines,pagesize,ansi
c
	integer*4 nfile,flags,flags1,istat,k,nkar_help_imag,option
	integer*4 nk_lognam,nk_fac,nk_lbr,ctx,nk_deflibs,nk_deflib,nk_hlp
	integer*4 textlib
	logical*4 no_tabs,dellog,whole,aborted
	logical*4 got_specific_library
	character*255 help_imagname,fac_naam,tmp,deflibs,deflib,hlp
	character*20 lognam,line
	character*6 lang
c
	logical*4 screen_init
	external fshelp_vms_input,fshelp_vms_output
	integer*4 lbr$output_help
	integer*4 lib$sys_trnlog
	logical*4 check_language
	integer*4 lib$find_file
	logical file_add_library
	logical screen_get_janee
c
	external fshelp_lbrnotf
	external fshelp_deflibs
	external fshelp_sure
	external fshelp_hsure
c
c In the libraryname the part after the | is the facility
c
	nk_fac = index(lbrnaam,'|')
	if(nk_fac .gt. 0) then
	  nk_lbr = nk_fac-1
	  fac_naam = lbrnaam(nk_fac+1:)
	  nk_fac = len(lbrnaam)-nk_fac
	else
	  nk_fac = 0
	  nk_lbr = len(lbrnaam)
	endif
c
c Get the architecture
c
	call lib$getsyi(syi$_arch_name,,control.arch_name)
c
c Get some option fields
c
	option = options(1)
	control.searchwild = (option .and. fshelp_m_searchwild) .ne. 0
	control.colour     = (option .and. fshelp_m_colour    ) .ne. 0
	control.use_mouse  = (option .and. fshelp_m_nomouse   ) .eq. 0
	control.skipempty  = (option .and. fshelp_m_skipempty ) .ne. 0
	control.sorted     = (option .and. fshelp_m_sorted    ) .ne. 0
	control.inline     = (option .and. fshelp_m_inline    ) .ne. 0
	control.binary     = (option .and. fshelp_m_binary    ) .ne. 0
c
	control.p_autolink = 0
c
c Get the language
c
	lang = ' '
	if((option .and. fshelp_m_language ) .ne. 0) then
	  call lib$movc3(4,options(2),%ref(lang))
	endif
	if(.not. check_language(lang)) goto 90
c
c Set the library type to 0 (unknown) or a specific type depending
c  on the user-specified qualifiers
c
	textlib = 0
	if((option .and. fshelp_m_helplib)   .ne. 0) textlib = lib_help
	if((option .and. fshelp_m_textlib)   .ne. 0) textlib = lib_text
	if((option .and. fshelp_m_macrolib)  .ne. 0) textlib = lib_macr
	if((option .and. fshelp_m_objectlib) .ne. 0) textlib = lib_obj
	if((option .and. fshelp_m_shlib)     .ne. 0) textlib = lib_shlib
c
c Get the name of the image
c
	call lib$getjpi(jpi$_imagname,,,,help_imagname,nkar_help_imag)
	call str$upcase(help_imagname,help_imagname)
c
c Skip the extension (non ods5 names)
c
	do k=nkar_help_imag,1,-1
	  if(help_imagname(k:k) .eq. '.') goto 4
	end do
c
c Check for _VAX or _ALPHA executables, if so skip that
c
4       if(    help_imagname(k-4:k-1) .eq. '_VAX') then
	  k = k - 4
	elseif(help_imagname(k-6:k-1) .eq. '_ALPHA') then
	  k = k - 6
	elseif(help_imagname(k-5:k-1) .eq. '_IA64') then
	  k = k - 5
	elseif(help_imagname(k-4:k-1) .eq. '_DEB') then
	  k = k - 4
	elseif(help_imagname(k-6:k-1) .eq. '_DEBUG') then
	  k = k - 6
	endif
c
	help_imagname(k:) = '.HLB'
	nkar_help_imag = k+3
c
c See if the file is found
c
	ctx = 0
	if(.not. lib$find_file(help_imagname(1:nkar_help_imag),tmp,ctx)) then
c
c Help file not found in the same directory as the image, 
c now try for sys$help
c
	  do k=nkar_help_imag,1,-1
	    if(help_imagname(k:k) .eq. ']') goto 5
	  end do
5	  help_imagname = 'SYS$HELP:'//help_imagname(k+1:nkar_help_imag)
	  nkar_help_imag = 9 + nkar_help_imag - k
	endif
	call lib$find_file_end(ctx)
c
c We want VMS type help
c
	if((option .and. fshelp_m_vms_help) .ne. 0) goto 80
c
c check if ansi crt, if not forget about non vms mode
c
	call lib$getdvi(dvi$_tt_ansicrt,,'sys$output',ansi)
	if(.not. ansi) then
	  if((option .and. fshelp_m_message) .ne. 0) goto 45
	  goto 80
	endif
	no_tabs = (option .and. fshelp_m_no_tabs) .ne. 0
	whole   = (option .and. fshelp_m_whole)   .ne. 0
	control.bars = (option .and. fshelp_m_bars) .ne. 0
c
c Init SMG
c
	if(.not. screen_init(control,no_tabs)) goto 80
c
	control.files.max_len = 0
	if((option .and. fshelp_m_automatic) .ne. 0) then 
	  control.vertical = sel_aut
	else
	  if((option .and. fshelp_m_vertical) .ne. 0) then 
	    control.vertical = sel_ver
	  else
	    control.vertical = sel_hor
	  end if
	end if
c
c Parse the module string to topics and optional the library (@library)
c
45	call util_split_line(module,search)
c
	if((option .and. fshelp_m_message) .ne. 0) then 
c
c Help/message wanted
c
	  if((option .and. fshelp_m_messtat) .ne. 0) then
c
c The third option word contains the statuscode wanted
c get the text part of the message text
c
	    call sys$getmsg(%val(options(3)),k,line,%val(2),)
	    search.level = 1
	    search.key(1).key = line(2:k)	!first will contain %
	    search.key(1).nkar_key = k-1
c
c Get the facility part of the message
c
	    call sys$getmsg(%val(options(3)),k,line,%val(8),)
	    fac_naam = line(2:k)
	    nk_fac = k-1
	  endif
c
c And display the info
c
	  call fshelp_msghelp(lbrnaam(1:nk_lbr),search,control,
     1                   fac_naam(1:nk_fac),ansi)
	  goto 90
	endif
c
c Normal help /.tlb/.olb/.mlb display
c
 	call vm_open(control.files.lun    ,,,,%descr('FSHELP_FILES'))
	call vm_open(control.lun_filenames,,,,%descr('FSHELP_FILENAMES'))
	call vm_open(control.mark.lun     ,,,,%descr('FSHELP_MARK'))
	control.mark.max_len = 0
	call vm_open(control.lun_his      ,,,,%descr('FSHELP_HISTORY'))
	control.his_wrap = .false.
c
c Add the specified labraries to the list of libraries
c
	got_specific_library = .false.
	if(lbrnaam(1:nk_lbr) .ne. ' ') then
c
c USer specified specific library via /libr=
c It must exist, otherwise we quit (unless image_help is specified)
c
	  if(.not. file_add_library(control,lbrnaam(1:nk_lbr),textlib)) then
	    if((option .and. fshelp_m_image) .eq. 0) then
	      call fshelp_mess_par(fshelp_lbrnotf,lbrnaam(1:nk_lbr))
	      goto 70	    
	    endif
	  endif
	  got_specific_library = .true.
	endif

	if(search.nkar_file .gt. 0) then
c
c USer specified a specific library via @library
c It must exist, otherwise we quit
c
	  if(.not. file_add_library(control,
     1        search.filename(1:search.nkar_file),textlib)) then
	    call fshelp_mess_par(fshelp_lbrnotf,
     1           search.filename(1:search.nkar_file))
	    goto 70	    
	  endif
	  got_specific_library = .true.
	end if
c
c Now for the implied logicals HLP$library...
c get the default type for each mode hlb,olb,tlb,mlb....
c textlib contains 0..5 for each mode, for 0 take 1 (HELPLIB)
c
	call fshelp_getmsg_nolang(fshelp_deflibs,nk_deflibs,deflibs)
	call str$element(deflib,max(1,textlib)-1,'|',deflibs(1:nk_deflibs))
	nk_deflib = index(deflib,' ')-1
	if(textlib .eq. 0) then
c
c add the library for the image itself
c  this is the FSHELP.HLB library for the main image, 
c  but if the user has called this routine from his own image
c  it is the image of the user's application
c
	  if((option .and. fshelp_m_own) .ne. 0) then
	    call file_add_library(control,
     1           help_imagname(1:nkar_help_imag),lib_help)
	  end if
c
c If the user specified /userlibraries=all or system
c  add sys$help:helplib and the systemwide logicals HLP$library...
c
	  if((option .and. fshelp_m_search_system) .ne. 0) then	
	    if(.not. got_specific_library) then
	      call file_add_library(control,deflib(1:nk_deflib),lib_help)
	    endif
	    call file_add_extra_libraries('LNM$SYSTEM',control)
	  end if
c
c If the user specified /userlibraries=all or group
c  add sys$help:helplib and the group logicals HLP$library...
c
	  if((option .and. fshelp_m_search_group)   .ne. 0) then	
	    call file_add_extra_libraries('LNM$GROUPS',control)
	  end if
c
c If the user specified /userlibraries=all or job
c  add sys$help:helplib and the job logicals HLP$library...
c
	  if((option .and. fshelp_m_search_job) .ne. 0) then	
	    call file_add_extra_libraries('LNM$JOB',control)
	  end if
c
c If the user specified /userlibraries=all or process
c  add sys$help:helplib and the process logicals HLP$library...
c
	  if((option .and. fshelp_m_search_process) .ne. 0) then	
	    call file_add_extra_libraries('LNM$PROCESS',control)
	  end if
c
c Add the imagename .hlb library
c
	  if((option .and. fshelp_m_image) .ne. 0) then
	    call file_add_library(control,
     1             help_imagname(1:nkar_help_imag),lib_help)
	  end if
	else
c
c for the /text, /image, /object,/macro library, 
c    the default is the textlib'th element of deflibs
c
	  if(.not. got_specific_library) then
	    if(.not.file_add_library(control,deflib(1:nk_deflib),textlib))then
	      call fshelp_mess_par(fshelp_lbrnotf,deflib(1:nk_deflib))
	      goto 70
	    endif
	  endif
	endif
c
c check if we have any files found
c
	call vm_file_info(control.files.lun,nfile,)
c
	if(nfile .gt. 0) then
c
c Yes, so go
c
	  control.nodown   = (option .and. fshelp_m_no_down ) .ne. 0
	  control.nlines_find = nlines_find_def
	  control.nlines_help = 0
	  if((option .and. fshelp_m_autosize) .eq. 0) 
     1        control.nlines_help=nlines_help_def
	  if((option .and. fshelp_m_all) .ne. 0) 
     1        call load_all_in_memory(control)
65	  call do_display(control,search,whole,aborted)
	  if((option .and. fshelp_m_all) .ne. 0) then
	    call fshelp_getmsg(fshelp_hsure,nk_hlp,hlp)
	    call fshelp_getmsg(fshelp_sure,k,tmp)
	    if(.not. screen_get_janee(tmp(1:k),1,0,hlp(1:nk_hlp),
     1             control,.true.)) goto 65
	  endif
	  call file_close_files(control)
	end if
70	call screen_exit(control,aborted)
	call file_close(control.files.lun)
	call file_close(control.lun_filenames)
	call file_close(control.mark)
	call vm_close(control.lun_his)
	goto 90
c
c smg mode is not possible , or user specified   vms_mode
c Get the directory of the image run
c
80	if((option .and. fshelp_m_image) .ne. 0) then
c
c Add image help name to process logical name table HLP$library*
c
	  k = 0
83	  if(k .eq. 0) then
	    lognam = 'HLP$LIBRARY'
	    nk_lognam = index(lognam,' ')-1
	  else
	    call sys$fao('HLP$LIBRARY_!UL',nk_lognam,lognam,%val(k))
	  end if
	  if(lib$sys_trnlog(lognam(1:nk_lognam),,line,,,3) .ne.
     1                      ss$_notran) then
	    k = k+1
	    goto 83
	  end if
	  call lib$set_logical(lognam(1:nk_lognam),
     1                    help_imagname(1:nkar_help_imag))
	  dellog = .true.
	else
	  dellog = .false.
	end if
c
c See for LBRNAAM, try if we can find it
c
	if(lbrnaam(1:nk_lbr) .ne. ' ') then
	  ctx = 0
	  istat = lib$find_file(lbrnaam(1:nk_lbr),tmp,ctx,'SYS$HELP:.HLB')
	  call lib$find_file_end(ctx)
	  if(istat) goto 85
c
c Not found, if help_imag is specified, try for imag_help
c
	  if((option .and. fshelp_m_image) .ne. 0) then
	    istat = lib$find_file(help_imagname(1:nkar_help_imag),tmp,
     1                ctx,'SYS$HELP:.HLB')
	    call lib$find_file_end(ctx)
	    if(istat) goto 85
	  endif
	  call fshelp_mess_par(fshelp_lbrnotf,lbrnaam(1:nk_lbr))
	  goto 90
	endif
c
c lbrnaam not specified, try if imagname is specified
c
	if((option .and. fshelp_m_image) .ne. 0) then
	  istat = lib$find_file(help_imagname(1:nkar_help_imag),tmp,
     1                ctx,'SYS$HELP:.HLB')
	  call lib$find_file_end(ctx)
	  if(istat) goto 85
	  call fshelp_mess_par(fshelp_lbrnotf,
     1                help_imagname(1:nkar_help_imag))
	  goto 90
	endif
c
c Neither lbrnaam nor imag_help, take sys$help:helplib.hlb
c
	tmp = 'sys$help:helplib.hlb'
c
85	flags = hlp$m_help .or. hlp$m_prompt
	flags1 = 0
	if((option .and. fshelp_m_search_system)  .ne. 0)
     1             flags1 = flags1 .or. hlp$m_system
	if((option .and. fshelp_m_search_group)   .ne. 0) 
     1             flags1 = flags1 .or. hlp$m_group
	if((option .and. fshelp_m_search_process) .ne. 0) 
     1             flags1 = flags1 .or. hlp$m_process
	if(flags1 .ne. 0) flags = flags .or. hlp$m_liblist
	flags = flags .or. flags1
	call lib$getdvi(dvi$_tt_page,,'sys$output',pagesize)
	if(ansi) then
	  write(*,1010) char(27),char(27)
1010	  format('+',a,'[H',a,'[2J',$)
	endif
	istat=lbr$output_help(fshelp_vms_output,,module,tmp,
     1                    flags,fshelp_vms_input)
	if(dellog) call lib$delete_logical(lognam(1:nk_lognam))
c
c General exit
c
90	return
	end

	function fshelp_vms_input(string,prompt,nkar)
	implicit none
c
c Routine to get input from the terminal, called from lbr$output_help
c
	character*(*) string		!:o: return string
	character*(*) prompt		!:i: prompt string
	integer*4 nkar			!:o: Length of string
	logical*4 fshelp_vms_input	!:f" function result
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /fshelp_vms_nlines/ nlines,pagesize,ansi
c
	integer*4 lib$get_input
c
	nlines = 0
c
	fshelp_vms_input = lib$get_input(string,prompt,nkar)
c
	return
	end

	function fshelp_vms_output(string)
	implicit none
c
c Output routine form lbr$output_help
c
	character*(*) string		!:i: the string
	logical*4 fshelp_vms_output	!:f: function result
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /fshelp_vms_nlines/ nlines,pagesize,ansi
c
	character*80 kar,ln1
	integer*4 nkar,nkln1,istat
c
	external fshelp_contin
	integer*4 lib$put_output,lib$get_input
c
	nlines = nlines + 1
	if(pagesize .ne. 0 .and. nlines .ge. pagesize-3) then
c
c End of page, let the user type return (or abort)
c
	  call lib$put_output(' ')
	  call lib$put_output(' ')
	  call fshelp_getmsg(fshelp_contin,nkln1,ln1)
	  istat = lib$get_input(kar,ln1(1:nkln1),nkar)
	  if(.not. istat) goto 90
c
c Clear screen again
c
	  if(ansi) write(*,1010) char(27),char(27)
1010	  format('+',a,'[H',a,'[2J',$)
	  nlines = 0
	end if
	istat = lib$put_output(string)
90	fshelp_vms_output = istat
	return
	end

	subroutine do_display(control,search,whole,aborted)
	implicit none
c
c We have one or more libraries, start displaying
c
	include 'fshelp.inc'
	record /control/ control	!:io: control structure
	record /search/ search		!:i: initial search topics
	logical*4 whole			!:i: whole-screen format
	logical*4 aborted		!:o: aborted 
c
	record /header/ file
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 l,k,row,col,ret_sta,size,nk,curlib,ipos,nb,istat
	logical*4 first,first_level,old_item,special,up
	logical*4 forward,signal_not_found
	character*255 line
	logical*4 search_names
	logical is_autolink,from_autolink
c
	integer*4 file_add_library
	logical vm_read_txt
	integer*4 lib$get_vm
c
	external fshelp_topic,fshelp_notfnd,fshelp_libnam,fshelp_nofverw
c
	include '($smgdef)'
c
	logical*4 set_search
	logical*4 find_data
c
	record /header/ rec
	record /search/ sea
	record /lun/ lun_h
	record /autolink/ autolink
	pointer (p_autolink,autolink)
c
c Start of coding, init parameters
c
	special       = .false.
	control.n_his = 0
	size          = sizeof(rec)
	forward       = .true.
	first         = .true.
	first_level   = 0
	old_item      = 0
	row           = 0
	col           = 0
	up            = .true.
	aborted       = .false.
	signal_not_found = .true.
	control.search_string_l = 0
c
	is_autolink = .false.
	from_autolink = .false.
c
c We want to search for names in the search structure
c In search we have text fields (the first time, and when processing see-alsos)
c or indices (numbers) when going to known pages
c the numbers are must faster, but we must find them first
c
9	search_names = .true.
	if(is_autolink) then
	  istat = lib$get_vm(sizeof(autolink),p_autolink)
	  if(.not. istat) call lib$signal(%val(istat))
	  autolink.from_level = control.level
	  do k=0,control.level
	    autolink.from_Sels(k) = control.sel_item(k)
	  end do
	end if
c
c Find a search items
c
10	if(.not. set_search(control,search,search_names,
     1             signal_not_found)) goto 90
c
c Search successfull
c
	if(is_autolink) then
	  do k=0,control.level
	    autolink.to_level = control.level
	    autolink.to_Sels(k) = control.sel_item(k)
	  end do
c
c Now hook in the chain
c
	  autolink.p_next = control.p_autolink
	  control.p_autolink = p_autolink
	  is_autolink = .false.
	end if
c
c  Init smome more
c
	signal_not_found = .false.
	special      = .false.
	search_names = .false.
	if(first) then
	  first = .false.	
	  if(control.nodown) first_level = control.level
	end if
c
c Filename header
c
30	call main_dis_header(control,.true.)
c
c Look user lookat data
c
	call screen_lookat(control,control.rec(control.level),row,col,ret_sta,
     1                     old_item,whole,is_autolink,from_autolink)
	from_autolink = .false.
c
c This returns 
c ret_sta >0  select a new deeper sublevel (ret_sta)
c ret_sta =0  Go one level up
c ret_sta =-1 Abort (^Z or f10 typed)
c ret_sta =-2 Choose new file (TAB key)
c ret_sta =-3 Select last history
c ret_sta =-4 find data in this (and all deeper) pages
c ret_sta =-5 print data to file
c ret_sta =-6 Let user choose a history
c ret_sta =-7 print data to printer
c ret_sta =-10 upto -2000, goto marks -10 is the first
c ret_sta <-2000 , goto see_also's, -2001 is the first
c
	row = 0
	col = 0
	old_item = 0
35	if(ret_sta .gt. 0) then
c
c ret_sta>0 goto deeper level
c
	  search.level = search.level + 1
	  search.sel_item(search.level) = ret_sta
	  up = .true.
	  goto 10
	else
c
c All other cases ret_sta <=0
c
	  if(ret_sta .eq. ret_level_up) then	!level up
c
c ret_sta=0, one level up
c
	    if(search.level .gt. first_level) then
c
c CHeck if the current is the autolink field 
c
	      if(control.p_autolink .ne. 0) then
	        p_autolink = control.p_autolink
	        if(autolink.to_level .eq. control.level) then
	          do k=0,control.level
	            if(autolink.to_sels(k) .ne. control.sel_item(k)) goto 23
	          end do
c
c Is was coming from the autolink (to part), so
c now return to the autolink from part
c
	          search.level = autolink.from_level
	          do k=0,search.level
	            search.sel_item(k) = autolink.from_Sels(k)
	          end do
c
c And free this autolink block
c
	          control.p_autolink = autolink.p_next
	          call lib$free_vm(sizeof(autolink),autolink)
	          from_autolink = .true.	!tell lookat_screen we return from autolink
	          goto 10
	        end if
	      endif
23	      old_item = search.sel_item(search.level)
	      search.level   = search.level - 1
	      if(up) call main_save_hist(control)
	      up = .false.
	      goto 10
	    end if
c
	  elseif(ret_sta .eq. ret_abort) then	!^z is abort
c
c ret_sta=ret_abort, abort : Define last help level as symbol
c
	    call vm_read_rec_txt(control.lun_filenames,control.sel_item(0),k,
     1             nk,line)
	    call util_define_symbol(control,line(1:k),line(k+2:nk))
	    aborted = .true.
c
	  elseif(ret_sta .eq. ret_change_file) then	!new file
c
c ret_sta = ret_new_file, choose new file
c
	    call screen_select(control.files,curlib,0,
     1              search.sel_item(0),
     1             'Help libraries',control,forward)
	    if(curlib .gt. 0) then
	      call main_save_hist(control)
	      call file_get_record(control,curlib,file)
	      search.level = 0
	      search.key(0).key      = file.key
	      search.key(0).nkar_key = file.nkar_key
	      search.sel_item(0)     = curlib
	      goto 10
	    elseif(curlib .lt. 0) then
	      ret_sta = k
	      goto 35
	    end if
c
	  elseif(ret_sta .eq. ret_last_history) then
c
c ret_sta = ret_last_history, Select last history
c
	    if(control.n_his .gt. 0) then
	      k = control.n_his
	      call vm_read_rec(control.lun_his,k,,sizeof(search),l,search)
	      call vm_delete(control.lun_his,control.n_his)
	      control.n_his = control.n_his - 1
	      goto 10	      
	    else
	      goto 30
	    end if
c
	  elseif(ret_sta .eq. ret_find_data .or. 
     1           ret_sta .eq. ret_find_data_all) then
c
c ret_sta=ret_find_data(_all), find_data
c
	    if(find_data(control,row,col,ret_sta,
     1             ret_sta .eq. ret_find_data_all)) then
	      if(ret_sta .ne. 0) goto 35
	    else
	      call fshelp_mess(fshelp_notfnd)
	    end if
	    search.level = control.level
	    do k=0,search.level
	      search.sel_item(k)    = control.sel_item(k)
	    end do
	    goto 10		!search for numbers
c
	  elseif(ret_sta .eq. ret_to_file) then
c
c ret_sta=ret_to_file, print data to file
c
	    call file_data(control)
	    goto 10
	  elseif(ret_sta .eq. ret_sel_history) then
c
c ret_sta = ret_sel_history, let user choose from history
c
	    k = 0
	    if(control.n_his .ne. 0) then
	      call vm_open(lun_h.lun,,,,%descr('FSHELP_TEMP_HIS'))
	      lun_h.max_len = 0	   
c
c Read his record
c
	      k = control.n_his
54	      call vm_read_rec(control.lun_his,k,,sizeof(sea),l,sea)
	        call util_make_header_search(sea,.true.,
     1                rec.key,rec.nkar_key)
	        if(rec.nkar_key .gt. lun_h.max_len)
     1                 lun_h.max_len = rec.nkar_key
	        call vm_write(lun_h,0,size,rec)
	        k = k - 1
	        if(k .eq. 0) then
	          if(control.his_wrap) then
	            k = max_his			!wrap around
	          else
	            k = control.n_his		!force end
	          endif
	        end if
	      if(k .ne. control.n_his) goto 54
c
c Got all hisses
c
	      call screen_select(lun_h,k,0,0,'History',control,forward)
	      call vm_close(lun_h.lun)
	      if(k .lt. 0) then
	        ret_sta = k
	        goto 35
	      end if
	    end if
	    if(k .gt. 0) then
	      k = control.n_his-k+1
	      if(k .le. 0) k = k + max_his
	      call vm_read_rec(control.lun_his,k,,sizeof(search),l,search)
	      goto 10	      
	    else
	      goto 30
	    endif
c
	  elseif(ret_sta .eq. ret_to_printer) then
c
c ret_sta=ret_to_printer, print data to printer
c
	    call print_data(control)
	    goto 10
c
	  elseif(ret_sta .lt. ret_first_mark .and. 
     1           ret_sta .gt. ret_last_mark) then
c
c goto marks , ret_first_mark is the first, ret_last_mark is the last 
c careful, ret_codes are negative
c
	    k = -(ret_sta-ret_first_mark)
	    call vm_read_rec(control.mark.lun,k,l,sizeof(search),l,search)
c
c Goto mark
c
	    call main_save_hist(control)
	    row = search.row
	    col = search.col
	    goto 10
c
	  elseif(ret_sta .lt. ret_first_seealso) then
c
c goto see_also's, ret_first_seealso is the first see_also
c
	    call main_save_hist(control)
	    k = -(ret_sta-ret_first_seealso)
	    call vm_read_rec(control.rec(control.level).lun_see.lun,
     1              k,l,sizeof(search),l,search)
	    if(search.key(0).nkar_key .eq. 0) then
c
c Take current library for default
c
	      search.key(0).key = control.rec(0).key
	      search.key(0).nkar_key = control.rec(0).nkar_key
	    else
c
c See if library is already loaded,, if not
c load it now
c
	      call vm_rewind(control.lun_filenames)
	      do while(vm_read_txt(control.lun_filenames,ipos,nb,line))
	        if(line(ipos+2:nb) .eq. 
     1           search.key(0).key(1:search.key(0).nkar_key)) goto 56
	      end do
c
c Did not find the library, try to load it
c
	      call vm_set_eof(control.lun_filenames)
	      call vm_set_eof(control.files.lun)
	      istat = file_add_library(control,
     1          search.key(0).key(1:search.key(0).nkar_key),
     1          lib_help)
	    end if
56	    special = .true.
	    goto 9
	  end if
	end if
c
c Here if we did not find the search_item
c This happens if the library contains incorrect see_also's
c
90	if(special) then
	  if(is_autolink) then
	    call lib$free_vm(sizeof(autolink),p_autolink)
	  endif
c
c Here if the see_also is incorrect,
c signal a message, and return to the last history
c (a see_also updates the history always)
c
	  ret_sta = ret_last_history
	  call fshelp_mess(fshelp_nofverw)
	  call fshelp_mess_par(fshelp_libnam,search.key(0).key)
	  call util_make_header_search(search,.false.,
     1                line(1:screen.ncols-11),nk)
	  call fshelp_mess_par(fshelp_topic,line(1:nk))
	  goto 35
	end if
	return
	end
	subroutine main_save_hist(control)
	implicit none
c
c Save a history to the history lun
c
	include 'fshelp.inc'
	record /control/ control	!:i: the current searchpath
c
	record /search/ rec
c
	integer*4 k
c
c One more record
c
	control.n_his = control.n_his + 1
c
c  build the rec from the current path
c
	do k=0,max_deep
	  rec.sel_item(k)     = control.sel_item(k)	!the binary search number
	  rec.key(k).key      = control.rec(k).key	!the text search items
	  rec.key(k).nkar_key = control.rec(k).nkar_key
	end do
c
c And write it to the history lun
c
	rec.level = control.level
	call vm_write(control.lun_his,0,sizeof(rec),rec)
	return
	end

	function set_search(control,search,search_names,signal_not_found)
	implicit none
c
c Search for a list of items in search.key(*) 0..search.level
c First search through all help_files files for a match of all 
c levels. If no match is found for all levels of search,
c the search.level is decremented, and the search is restarted
c The result will be a page containing the deepest level found
c
	include 'fshelp.inc'
	record /control/ control
	record /search/ search
	logical*4 search_names
	logical signal_not_found
	logical*4 set_search
c
	integer*4 deep,k,org_search_level
	logical*4 match
c
	logical*4 util_match
	logical*4 file_get_next
	external fshelp_notall
c
	set_search = .false.
	org_search_level = search.level
c
c Search for requested search_items
c
5	deep                  = 0
	control.level         = 0
	do k=0,max_deep
	  control.sel_item(k) = 0
	end do
c
10	do while(file_get_next(control,deep))
c
c Delivers a scan of all topic at level "deep" over all files
c
c level 0 means scan the files
c level 1 means scan all main entries in the file (fast)
c level 2 .. means all subtopics of this level, (read the complete data ,slow)
c Delivers in control the current context (control.level and control.key(*))
c
	  if(control.level .lt. deep) then
c
c The file_get_next delivered an item on a lower level than already matched
c if we have not specified a library, continue for the next key
c this will not match until we have reached the next file, but the data
c is in core anyway
c
	    if(search_names .and. search.key(0).key .eq. ' ') then
	      deep = deep - 1
	    else
c
c We have specified a specific library (or a binary search)
c and we did not find all levels, so now we must
c decrement the search level, and start from the beginning
c
	      search.level = search.level-1
	      goto 5
	    end if
	  end if
c
c the new found topic is at least at the same level
c
	  if(search_names) then
	    match = util_match(
     1        control.rec  (deep).key(1:control.rec  (deep).nkar_key),
     1        search.key(deep).key(1:search.key(deep).nkar_key))
	  else
	    match = control.sel_item(deep) .eq. search.sel_item(deep)
	  end if
	  if(match) then
c
c We have a match, so now continue for the next deeper level
c if we do not yet have all levels present
c
	    deep = deep + 1
	    if(deep .gt. search.level) goto 80
	  end if
	end do
c
c Not found after all files specified
c if we specified a specific library, the game is over
c else try again at a lower level
c
	if(search_names) then
	  if(search.key(0).key .eq. ' ') then	!no lib specified
	    search.level = search.level-1
	    goto 5
	  end if
	end if
c
c Could not find, so get out
c
	goto 90
80	set_search = .TRUE.
c
c It the search level is decemented, signal to the user
c (only on the initial search fro DCL level)
c
	if(org_search_level .gt. search.level) then
	  if(signal_not_found) then
	    call fshelp_mess(fshelp_notall)
	  endif
	endif
c
c Make sure search is the same as control
c
	search.level = control.level
	do deep=0,search.level
	 search.key(deep).key      = control.rec(deep).key
	 search.key(deep).nkar_key = control.rec(deep).nkar_key
	 search.sel_item(deep)     = control.sel_item(deep)
	end do
c
c Be sure data is in core
c
	call file_in_core(control)
90	return
	end

	function find_data(control,row,col,ret_sta,all_libs)
	implicit none
c
c Find a text string in this level and all deeper levels
c
	include 'fshelp.inc'
	record /control/ control	!:io: control structure
	integer*4 row			!:o: row found
	integer*4 col			!:o: col found
	logical*4 all_libs		!:i: search all libraries?
	logical*4 find_data		!:f: function result
c
	integer*4 file_get_next
	integer*4 vm_read_rec_txt
	external help_find
	logical*4 screen_getkey
c
	integer*4 nkar,nl,curlev,dis_id,ilin,k,m,ipos,indx,search_len
	integer*4 iterm,ret_sta,video,offset,offset_o,nl_text,nk_info
	integer*4 lun_past,n_past,c_past,nbyte,nkln1,nk_yes,nk_no,nk_quit
	integer*4 old_lib
	character*132 regel,search_s,ln1
	character*20 yes_string,no_string,line_info,quit_string
	logical*4 pf1_flag,forward
c
	external fshelp_seaabo,fshelp_nobig,fshelp_nosmal,fshelp_wrkey
	external fshelp_nomore
	external fshelp_seafor,fshelp_seabck,fshelp_seacon
	external fshelp_yesno,fshelp_busy
	integer find_string_wild
c
	record /screen/ screen
	common /fshelp_screen/ screen
	record /search/ search
c
	record /search/ curpos
c
	include '($smgdef)'
c
c Remember curpos in case of not found
c
	curpos.level = control.level
	do m=0,max_deep
	  curpos.sel_item(m) = control.sel_item(m)
	end do
c
c Get the yes/no fields
c
	call fshelp_getmsg(fshelp_yesno,nkar,regel)
	call str$element(yes_string ,0,'|',regel(1:nkar))
	nk_yes  = index(yes_string,' ')-1
	call str$element(no_string  ,1,'|',regel(1:nkar))
	nk_no   = index(no_string,' ')-1
	call str$element(quit_string,2,'|',regel(1:nkar))
	nk_quit = index(quit_string,' ')-1
c
c OPen a (mem)file for the found result pointers
c
	call vm_open(lun_past,100,sizeof(search),,%descr('FSHELP_SEARCH'))
	n_past = 0
	c_past = 0
	find_data = .false.
	search_len = control.search_string_l
	forward = .true.
c
	if(all_libs) control.level = 0
c
	search.level = -1
	ret_sta = 0
	call str$upcase(search_s,control.search_string)
	curlev = control.level
	if(all_libs) curlev = -1
	old_lib = 0

5	nl = control.nlines_find
	call smg$create_virtual_display(nl+2,screen.ncols,dis_id,smg$m_border)
	call smg$paste_virtual_display(dis_id,screen.paste_id,
     1                 screen.nrows-nl-1,1)
	call fshelp_getmsg(fshelp_seafor,nkln1,ln1)
	call smg$label_border(dis_id,ln1(1:nkln1)//
     1        control.search_string(1:control.search_string_l))
	video = smg$m_reverse
	if(control.colour) video = smg$m_user6
	call fshelp_getmsg(fshelp_busy,nk_info,line_info)
	call smg$put_chars(dis_id,line_info(1:nk_info),1,1,,video)
	screen.control_c_seen = .false.
c
c Get the data in core
c
10	call file_in_core(control)
	call vm_file_info(control.rec(control.level).lun_text,nl_text)
	call util_make_header(control.level,control.rec(1),
     1                        regel(1:screen.ncols-nk_info-1),nkar)
	call smg$put_chars(dis_id,regel(1:nkar),1,nk_info+1,
     1                     smg$m_erase_to_eol,video)
c
	ilin = 0
c
c Main loop to find text
c
15	ilin = ilin + 1
	if(ilin .gt. nl_text) goto 40
c
c Check for ^c typed, abort if so
c
	if(screen.control_c_seen) then
	  call fshelp_mess(fshelp_seaabo)
	  goto 90
	end if
c
c Try to locate text in string
c
 	call vm_read_rec_txt(control.rec(control.level).lun_text,ilin,
     1                           k,nkar,regel)
	ipos = find_string_wild(regel(1:nkar),search_s(1:search_len),nbyte)
	if(ipos .eq. 0) goto 15
c
c Found the string while searching
c Remember it in scratch file
c
	search.level = control.level
	do m=0,max_deep
	  search.sel_item(m) = control.sel_item(m)
	end do
	search.row = ilin
	search.col = ipos
	call vm_set_eof(lun_past)
	call vm_write_fix(lun_past,0,search)
	n_past = n_past + 1
	c_past = n_past
c
c Now display it
c
20	offset   = 0
22	offset_o = -1
c
c Check if offset changed, if so redraw
c take the lines around offset and print to the screen
c
25	if(offset .ne. offset_o) then
	  offset_o = offset	
	  indx = max(ilin+offset-control.nlines_find/2,1)
	  do m=1,control.nlines_find
	    call vm_read_rec_txt(control.rec(control.level).lun_text,indx,k,
     1                             nkar,regel)
	    call smg$put_chars(dis_id,regel(1:nkar),m+1,1,smg$m_erase_to_eol)
	    if(indx .eq. ilin) then
	     call smg$change_rendition(dis_id,m+1,ipos,1,nbyte,smg$m_reverse)
	    end if
	    indx = indx+1
	  end do
	end if
c
c Set header correctly
c
	call main_dis_header(control,old_lib .ne. control.sel_item(0))
	old_lib = control.sel_item(0)
c
c Ask the user if this is what he wants
c
30	call fshelp_getmsg(fshelp_seacon,nkln1,ln1)
	call smg$put_chars(dis_id,ln1(1:nkln1),nl+2,1,
     1                     smg$m_erase_to_eol,video)
	if(.not. screen_getkey(iterm,pf1_flag,help_find,control)) goto 90
c
c Interpret commands
c
	if(iterm .ge. ichar('a') .and. iterm .le. ichar('z'))
     1                iterm = iterm - ichar('a') + ichar('A')
c
	if(iterm .eq. key_back) then
	  goto 90
	elseif(iterm .eq. key_abort) then
	  ret_sta = ret_abort
	  goto 80
	elseif(iterm .eq. key_up) then
	  if(pf1_flag) then
c
c enlarge display window
c
	    if(control.nlines_find .eq. screen.nrows-4) then
	      call fshelp_mess(fshelp_nobig)
	    else
	      control.nlines_find = control.nlines_find + 1
	      goto 35
	    end if
	  else
c
c Screen display one down
c
	    if(ilin+offset .le. (nl+1)/2) goto 32
	    offset = offset - 1
	    goto 25
	  end if
	elseif(iterm .eq. key_down) then
	  if(pf1_flag) then
c
c Shrink display window
c
	    if(control.nlines_find .eq. 3) then
	      call fshelp_mess(fshelp_nosmal)
	    else
	      control.nlines_find = control.nlines_find - 1
	      goto 35
	    end if
	  else
c
c Move display down
c
	    if(ilin+offset .ge. nl_text-(nl-1)/2) goto 32
	    offset = offset + 1
	    goto 25
	  endif
	elseif(iterm .eq. key_scrup) then
c
c Move display up
c
	  if(ilin+offset .le. nl) goto 32
	  offset = offset - nl
	  goto 25
	elseif(iterm .eq. key_scrdwn) then
c
c Move display down
c
	  if(ilin+offset .gt. nl_text-nl) goto 32
	  offset = min(nl_text-nl,offset + nl)
	  goto 25
	elseif(index(quit_string(1:nk_quit),char(iterm)) .ne. 0) then
c
c USer said Quit
c
	  goto 90
	elseif(index(yes_string(1:nk_yes),char(iterm)) .ne. 0) then
c
c user said YES
c
	  goto 80
	elseif(index(no_string(1:nk_no),char(iterm)) .ne. 0 .or. 
     1        iterm .eq. ichar(' ') .or. iterm .eq. key_enter) then
c
c user said NO
c
	  goto 38
	elseif(iterm .ge. key_mark1 .and. iterm .le. key_marku) then
c
c the user said MARK, so do it
c
	  call main_set_mark(control,iterm,pf1_flag,
     1                           ret_sta,ilin,ipos,forward)
	  if(ret_sta .ne. 0) then
	    if(ret_sta .gt. 0) ret_sta = ret_first_mark-ret_sta
	    goto 80
	  end if
	elseif(iterm .eq. key_forw .or. iterm .eq. key_backw) then
c
c Forward/backward mode setting
c
	  forward = iterm .eq. key_forw
	  if(forward) then
	    call fshelp_getmsg(fshelp_seafor,nkln1,ln1)
	    call smg$label_border(dis_id,ln1(1:nkln1)//
     1        control.search_string(1:control.search_string_l))
	  else
	    call fshelp_getmsg(fshelp_seabck,nkln1,ln1)
	    call smg$label_border(dis_id,ln1(1:nkln1)//
     1        control.search_string(1:control.search_string_l))
	  end if
	else
c
c Display help
c
	  call fshelp_mess(fshelp_wrkey)
	end if
	goto 30
c
32	call fshelp_mess(fshelp_nomore)
	goto 30
c
c Screen modified, so now change vdis
c
35	nl = control.nlines_find
	call smg$change_virtual_display(dis_id,nl+2)
	call smg$repaste_virtual_display(dis_id,screen.paste_id,
     1            screen.nrows-nl-1,1)
	goto 22
c
c Not the one, try next/prev Clear question
c
38	call smg$put_chars(dis_id,' ',nl+2,1,smg$m_erase_to_eol)
	if(forward .and. c_past .ge. n_past) goto 15		!next search please
c
c Out of buffer
c
40	if(forward) then
	  c_past = c_past + 1
	else
	  c_past = c_past - 1
	  if(c_past .eq. 0) goto 50
	end if
c
c If the index is already in the searh history, display
c the data from this index
c
45	if(c_past .le. n_past) then
	  call vm_read_rec_fix(lun_past,c_past,m,search)
	  call set_search(control,search,.false.,.false.)
	  ilin = search.row
	  ipos = search.col
	  goto 20
	else
c
c No we need to search further in the file
c
	  if(.not. (file_get_next(control,max_deep))) goto 50
	  if(control.level .eq. curlev) goto 50
	end if
	goto 10
c
50	if(n_past .eq. 0) goto 90
	call fshelp_mess(fshelp_nomore)
	c_past = max(1,min(c_past,n_past))
	goto 45
c
c User said YES, so return true and col/row
c
80	find_data = .true.
	row = ilin
	col = ipos
	goto 99
c
c Abort wanted , return the orig position
c
90	control.level = curpos.level
	do m=0,max_deep
	  control.sel_item(m)  =  curpos.sel_item(m) 
	end do
c
c Total exit
c
99	call smg$delete_virtual_display(dis_id)
	call vm_close(lun_past)
	return
	end

	subroutine help_find(control)
	implicit none
c
c The help routine for the find command
c
	include 'fshelp.inc'
	record /control/ control	!:io: control structure

c
c Help for lookat_data routine
c
	external fshelp_hlpfin
	call general_help(fshelp_hlpfin,control)
	return
	end

	subroutine print_data(control)
	implicit none
c
c Print data from this (and optional deeper) page(s) to a printer
c
	include 'fshelp.inc'
	record /control/ control
c
	integer*4 vm_read_rec_txt
	integer*4 smg$read_string
c
	integer*4 nkar,dis_id,ilin,k,queuenaam_l,istat
	integer*4 nl_pr,nb,lun,iterm,nk_info
	character*70 queuenaam,line_info
	integer*4 fshelp_util_print_file
c
	character*512 regel
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	external fshelp_clear,fshelp_notopsc
	external fshelp_prabo,fshelp_prent,fshelp_prerr
	external fshelp_ctrlc,fshelp_busy,fshelp_outprin
c
	include '($smgdef)'
c
	character*(*) tempname
	parameter (tempname = 'sys$login:fshelp.prn')
c
c Start of coding
c
	nb = len(queuenaam)
	call smg$create_virtual_display(6,nb,dis_id,smg$m_border)
	call smg$paste_virtual_display(dis_id,screen.paste_id,17,80-nb)
	call fshelp_getmsg(fshelp_outprin,nk_info,line_info)
	call smg$label_border(dis_id,line_info(1:nk_info))
c
	screen.control_c_seen = .false.
	call lib$get_lun(lun)
c	
c
5	call smg$put_chars(dis_id,'Queue  :',1,1,smg$m_erase_to_eol)
	queuenaam = ' '
	call sys$setast(%val(0))
	istat = smg$read_string(screen.keyboard_id,queuenaam,,
     1                       nb,,,,queuenaam_l,
     1                       iterm,dis_id,'SYS$PRINT')
	call sys$setast(%val(1))
	call fshelp_mess(fshelp_clear)
	if(.not. istat) goto 90
c
	if(queuenaam_l .eq. 0) then
	  queuenaam = 'SYS$PRINT'
	  queuenaam_l = 9
	  call smg$put_chars(dis_id,queuenaam,1,9)
	end if
	open(lun,file='sys$scratch:fshelp.prn',
     1           status='new',
     1           carriagecontrol='list',
     1           err=7)
	nl_pr = 0
	if(screen.control_c_seen) goto 80
	goto 9
7	call fshelp_mess_par(fshelp_notopsc,tempname)
	goto 9
9	goto 411
c
c Gather new data
c
411	call fshelp_getmsg(fshelp_ctrlc,nk_info,line_info)
	call smg$put_chars(dis_id,line_info(1:nk_info),4,1)
	call fshelp_getmsg(fshelp_busy,nk_info,line_info)
	call smg$put_chars(dis_id,line_info(1:nk_info),5,1)
c
c
10	call file_in_core(control)
	call util_make_header(control.level,control.rec(1),
     1                    regel(1:screen.ncols-11),nkar)
	call smg$put_chars(dis_id,regel(1:nkar),5,11,smg$m_erase_to_eol)

	ilin = 1
	do while(vm_read_rec_txt(control.rec(control.level).lun_text,ilin,
     1                           k,nkar,regel)) 
	  if(control.help_file .eq. lib_help) then
	    if(regel(1:1) .eq. '/') goto 80
	  endif
c
c Print the data
c first the header
c
	  write(lun,1010) regel(1:nkar)
1010	  format(a)
	  nl_pr = nl_pr+1
	  if(screen.control_c_seen) goto 80
	  ilin = ilin + 1
	end do
c
80	if(screen.control_c_seen) then
	  close(lun,dispose='delete')
	  call fshelp_mess(fshelp_prabo)
	else
	  close(lun)
	  if(fshelp_util_print_file(queuenaam(1:queuenaam_l),
     1          tempname,.true.,.true.,k)) then
	    call sys$fao('!AS (entry !UL)',
     1          nkar,regel,queuenaam(1:queuenaam_l),%val(k))
	    call fshelp_mess_par(fshelp_prent,regel(1:nkar))
	  else
	    call fshelp_mess(fshelp_prerr)
	  endif	
	end if
90	call lib$free_lun(lun)
	call smg$delete_virtual_display(dis_id)
99	return
	end

	subroutine file_data(control)
	implicit none
c
c Output data to file
c
	include 'fshelp.inc'
	record /control/ control	!:io control structure
c
	integer*4 file_get_next
	integer*4 vm_read_rec_txt
	logical*4 screen_get_janee
	integer*4 smg$read_string
c
	integer*4 nkar,curlev,dis_id,ilin,k,outfile_l,istat
	integer*4 nl_pr,deep_level,nb,lun,iterm,nk,deep,busy_pos
	character*132 regel
	character*70 outfile
	logical*4 vmshelp
c
	integer*4 screen_get_digit
	external fshelp_clear,fshelp_notopou,fshelp_prerr
	external fshelp_prabo,fshelp_filok
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	external fshelp_hdeep,fshelp_hvmshelp
	external fshelp_deep,fshelp_vmshelp,fshelp_filnam
	external fshelp_ctrlc,fshelp_busy,fshelp_outfile
c
	include '($smgdef)'
c
	character*80 help_line,info_line,defnam
	integer*4 nk_help,nk_info,nk_d
c
c Start of coding
c
	nb = len(outfile)
	call smg$create_virtual_display(6,nb,dis_id,smg$m_border)
	call smg$paste_virtual_display(dis_id,screen.paste_id,17,80-nb)
	call fshelp_getmsg(fshelp_outfile,nkar,regel)
	call smg$label_border(dis_id,regel(1:nkar))
c
	screen.control_c_seen = .false.
	call lib$get_lun(lun)
c
5	call fshelp_getmsg(fshelp_filnam,nk_help,help_line)
	call smg$put_chars(dis_id,help_line(1:nk_help),1,1,smg$m_erase_to_eol)
	outfile = ' '
	call sys$setast(%val(0))
	defnam = control.rec(control.level).key
	nk_d   = control.rec(control.level).nkar_key
	if(control.help_file .eq. 1) then
	  defnam(nk_d+1:) = '.hlp'
	else
	  defnam(nk_d+1:) = '.txt'
	endif
	nk_d = nk_d + 4
	istat = smg$read_string(screen.keyboard_id,outfile,,
     1                       nb,,,,outfile_l,
     1                       iterm,dis_id,defnam(1:nk_d))
	call sys$setast(%val(1))
	call fshelp_mess(fshelp_clear) 	
	if(.not. istat) goto 90
c
	if(outfile_l .eq. 0) goto 90
	open(lun,file=outfile(1:outfile_l),
     1           status='new',
     1           defaultfile='fshelp.lis',
     1           carriagecontrol='list',
     1           err=7)
	nl_pr = 0
	if(screen.control_c_seen) goto 80
	goto 9
7	call fshelp_mess_par(fshelp_notopou,outfile(1:outfile_l))
	goto 5	
9	call fshelp_getmsg(fshelp_deep,nk_info,info_line)
	call fshelp_getmsg(fshelp_hdeep,nk_help,help_line)
	if(control.rec(control.level).deeper.lun .ne. 0) then
	  deep = screen_get_digit (info_line(1:nk_info),2,
     1           dis_id,help_line(1:nk_help),control)
	  if(screen.control_c_seen) goto 80
	else	
	  deep = 9
	endif
c
	call fshelp_getmsg(fshelp_vmshelp,nk_info,info_line)
	call fshelp_getmsg(fshelp_hvmshelp,nk_help,help_line)
	vmshelp=screen_get_janee(info_line(1:nk_info),3,
     1           dis_id,help_line(1:nk_help),control,.false.)
	if(screen.control_c_seen) goto 80
c
c Gather new data
c
	call fshelp_getmsg(fshelp_ctrlc,nk_info,info_line)
	call smg$put_chars(dis_id,info_line(1:nk_info))
	call fshelp_getmsg(fshelp_busy,nk_info,info_line)
	busy_pos = nk_info + 1
	call smg$put_chars(dis_id,info_line(1:nk_info),5,1)
c
	curlev = control.level
c
	deep_level = curlev+deep
c
10	call file_in_core(control)
	call util_make_header(control.level,control.rec(1),
     1                    regel(1:screen.ncols-11),nkar)
	call smg$put_chars(dis_id,regel(1:nkar),5,busy_pos,
     1                   smg$m_erase_to_eol)

	if(vmshelp) then
	  nk = control.rec(control.level).nkar_key
	  write(lun,1000) control.level,
     1     control.rec(control.level).key(1:nk)
1000	  format(i1,x,a)
	else
	  write(lun,1010) regel(1:nkar)
1010	  format(a)
	end if
	ilin = 1
	do while(vm_read_rec_txt(control.rec(control.level).lun_text,ilin,
     1                           k,nkar,regel)) 
	  if(control.help_file .eq. lib_help) then
	    if(regel(1:1) .eq. '/') goto 40
	  endif
c
c Print the data
c first the header
c
	  write(lun,1010) regel(1:nkar)
	  nl_pr = nl_pr+1
	  if(screen.control_c_seen) goto 80
	  ilin = ilin + 1
	end do
40	if(.not. (file_get_next(control,deep_level))) goto 80
	if(control.level .eq. curlev) goto 80
	goto 10
c
80	if(screen.control_c_seen) then
	  if(nl_pr .eq. 0) then
	    close(lun,dispose='delete')
	    call fshelp_mess(fshelp_prabo)
	  else
	    inquire(lun,name=outfile)
	    outfile_l = index(outfile,' ')-1
	    close(lun)
	    call fshelp_mess_par(fshelp_prabo,outfile(1:outfile_l))
	  end if
	else
	  close(lun)
	  call fshelp_mess_par(fshelp_filok,outfile(1:outfile_l))
	end if
90	call lib$free_lun(lun)
	call smg$delete_virtual_display(dis_id)
99	return
	end

	subroutine main_set_mark(control,iterm,pf1_flag,ret_sta,row,col,
     1             forward)
	implicit none
c
c Set mark 
c
	include 'fshelp.inc'
	record /control/ control	!:io: contro structure
	integer*4 iterm			!:i: terminator key
	logical*4 pf1_flag		!:i: and flag
	integer*4 ret_sta		!:o: 	
	integer*4 row			!:i: row to save
	integer*4 col			!:i: col to save
	logical forward			!:io: forward mode
c
	character*(key_len) naam
	integer*4 nkar_naam,k,l
	logical*4 found
	record /search/ search
c
	character*80 ln1,ln2
	integer nkln1,nkln2,mark_index,it1
	external fshelp_marknam,fshelp_markovr,fshelp_markhdr
c
	integer*4 vm_read
	logical*4 screen_get_janee
	external fshelp_setmrk,fshelp_nosmrk
c
	mark_index = iterm - key_mark1 + 1
	k = iterm - key_mark1 + 1
	if(pf1_flag) then
c
c Goto mark
c
	  ret_sta = 0
	  if(iterm .ne. key_marku) then
c
c Fixed markername (mark1 to mark3)
c
	    naam = 'System_'//char(k+ichar('0'))
	    nkar_naam = index(naam,' ')-1
	  else
c
c  User defined mark, ask the user for the name
c
	    call fshelp_getmsg(fshelp_marknam,nkln1,ln1)
	    naam = 'Mark_'//control.rec(control.level).key
	    nkar_naam = 5 + control.rec(control.level).nkar_key
	    call ask_String(naam,nkar_naam,ln1(1:nkln1),it1)
	  end if
c
c Check if already exists
c
	  found = .false.
	  call vm_rewind(control.mark.lun)
	  do while(vm_read(control.mark.lun,l,sizeof(search),l,search))
	    if(search.head.key(1:search.head.nkar_key) .eq.
     1                  naam(1:nkar_naam)) then
c
c GOt a match, now ask if to overwrite (not for usermarks)
c
	      found = .true.
	      if(iterm .ne. key_marku) then
	        call fshelp_getmsg(fshelp_markovr,nkln1,ln1)
	        call sys$fao(ln1(1:nkln1),nkln2,ln2,naam(1:nkar_naam))
	        nkln1 = index(ln2(1:nkln2),'|')
	        if(.not. screen_get_janee(ln2(1:nkln1-1),1,
     1               0,ln2(nkln1+1:nkln2),.false.)) goto 80
	      end if
	      goto 46
	    end if
	  end do
c
c Not found so add now
c
46	  search.head.key = naam
	  search.head.nkar_key = nkar_naam
	  search.level = control.level
	  search.row   = row
	  search.col   = col
	  do l=0,max_deep
	    search.sel_item(l) = control.sel_item(l)
	  end do
	  if(found) then
	    call vm_rewrite(control.mark.lun,mark_index,sizeof(search),search)
	  else
	    call vm_write(control.mark.lun,mark_index,sizeof(search),search)
	  end if
	  if(nkar_naam .gt. control.mark.max_len) 
     1                 control.mark.max_len = nkar_naam
	  call fshelp_mess_par(fshelp_setmrk,naam(1:nkar_naam))
	else
c
c Goto mark
c
	  if(iterm .ne. key_marku) then
c
c System mark
c
	    call vm_rewind(control.mark.lun)
	    ret_sta = 0
	    do while(vm_read(control.mark.lun,l,sizeof(search),l,search))
	      ret_sta = ret_sta + 1
	      if(l .eq. mark_index) goto 80
	    end do
	    call fshelp_mess_par(fshelp_nosmrk,char(k+ichar('0')))
	    ret_sta = 0
	  else
c
c User mark
c
	    call fshelp_getmsg(fshelp_markhdr,nkln1,ln1)
	    call screen_select(control.mark.lun,ret_sta,0,0,ln1(1:nkln1),
     1                control,forward)
	  end if
	end if
c
c Return data
c
80	return
	end
	subroutine main_dis_header(control,filetoo)
	implicit none
c
c Display headerlines 
c
	include 'fshelp.inc'
	record /control/ control	!:io: control structure
	logical filetoo
	include '($smgdef)'
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	character*132 line,regel
	integer*4 nk,video,overhead
c
c Clear to default colours
c
	regel = ' '
	if(filetoo) then
	 call smg$put_chars(screen.display_id_kop,regel,1,screen.width_hdr+1)
	endif
	call smg$put_chars(screen.display_id_kop,regel,2,screen.width_hdr+1)
c
	video = 0
	if(control.colour) video = smg$m_user2
c
	if(filetoo) then
	  call vm_read_rec_txt(control.lun_filenames,control.sel_item(0),,
     1             nk,line)
	  nk = index(line,'#')-1		!use full name only
c
c Leave room for the intro (sceen.width_hdr) and
c the line-number indication with the flags
c  approx 25 chars
c
	  overhead = 25+screen.width_hdr
	  call lib$trim_filespec(line(1:nk),regel,screen.ncols-overhead,nk)
	  call deods5name(nk,regel)
c
	  if(control.help_file .eq. lib_help) then
	  elseif(control.help_file .eq. lib_text) then
	    regel = 'TXT:'//regel
	    nk = nk + 4
	  elseif(control.help_file .eq. lib_macr) then
	    regel = 'MAC:'//regel
	    nk = nk + 4
	  elseif(control.help_file .eq. lib_obj .or. 
     1           control.help_file .eq. lib_eobj.or.
     1           control.help_file .eq. lib_elfobj) then
	    regel = 'OBJ:'//regel
	    nk = nk + 4
	  elseif(control.help_file .eq. lib_shlib .or. 
     1           control.help_file .eq. lib_eshlib .or.
     1           control.help_file .eq. lib_elfshlib) then
	    regel = 'IMG:'//regel
	    nk = nk + 4
	  end if
c
	  call smg$put_chars(screen.display_id_kop,regel(1:nk),
     1            1,screen.width_hdr+1,,video)
	endif
c
c Topic header
c Leave room for the intro (sceen.width_hdr) and
c the line-number indication with the flags
c  approx 20 chars
c
	overhead = 20+screen.width_hdr
	call util_make_header(control.level,control.rec(1),
     1                        line(1:screen.ncols-overhead),nk)
	call smg$put_chars(screen.display_id_kop,line(1:nk),
     1                   2,screen.width_hdr+1,,video)
	return
	end
	function check_language(lang)
	implicit none
c
c Check if the user selected language is valid
c
	character*(*) lang	!:i: language wanted
	logical check_language  !:f: True if language found
c
	integer*4 language,n_language
	common /fshelp_language/ language,n_language
c
	integer nk,nk_l
	character*132 line,work
c
	logical*4 str$element
	external fshelp_languages
c
	nk_l = index(lang,' ')-1
	language = 0
c
c Get the languages string
c
	call fshelp_getmsg(fshelp_languages,nk,line)
c
	n_language = 0
	language = -1
	do while(str$element(work,n_language,',',line(1:nk)))
c
c Check is this part is the right one
c
	  if(work(1:nk_l) .eq. lang) language = n_language
	  n_language = n_language + 1
	end do
c
c Take default if not found
c
	if(lang .eq. ' ') language = 0
c
c if <0 no match, so abort
c
	if(language .lt. 0) then
	  write(*,*) 'Invalid language ',lang
	  check_language = .false.
	else
	  check_language = .true.
	endif
	return
	end
	subroutine load_all_in_memory(control)
	implicit none
c
c Load all opened files in memory
c
	include 'fshelp.inc'
	record /control/ control
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	record /header/ file
	integer*4 k
c
	logical file_get_record
	external fshelp_ctrlc
c
c
	call fshelp_mess(fshelp_ctrlc)
	screen.control_c_seen = .false.
	call vm_rewind(control.files.lun)
	k = 1
	do while(file_get_record(control,k,file))
c
c We have a file here, now load all modules of that file to memory
c Set the control fields right for the load_file_in_memory
c
	  control.rec(0) = file
	  control.sel_item(0) = k
	  call load_file_in_memory(control,file)
	  if(screen.control_c_seen) goto 80
c
c If all things done, we can close the library
c  we we not be needing it any longer since all text is in memory
c This is not valid for object libraries, sinc the ana/obj
c  can happen after the complete load
c
	  if(file.help_file .ne. lib_obj .and.
     1       file.help_file .ne. lib_eobj .and.
     1       file.help_file .ne. lib_elfobj) then
	    call file_close_library(file)
	  endif
c
c Write out updated info
c
	  call util_rewrite_header(control.files.lun,file)
c
c the next file
c
	  k=k+1
	end do
	goto 90
80	screen.control_c_seen = .false.
90	return
	end
	subroutine load_file_in_memory(control,file)
	implicit none
c
c Load all data of file "file" in memory
c
	include 'fshelp.inc'
	record /control/ control
	record /header/ file
c
	integer*4 k,n_items
	logical first
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	call vm_file_info(file.deeper.lun,n_items,)
	control.level = 1
	first = .true.
	do k=1,n_items
	  call util_read_header(file.deeper.lun,k,control.rec(1))
	  control.level = 1
	  control.sel_item(1) = k
	  call main_dis_header(control,first)
	  first = .false.
	  call file_in_core(control)
	  if(screen.control_c_seen) goto 90
	end do
c
90	return
	end
