	subroutine fshelp_msghelp(lbrnaam,search,control,facnaam,ansi)
	implicit none
c
c Process the request for messagehelp
c
	include 'fshelp.inc'
	include 'fshelp_msghelp.inc'
	include '($foriosdef)'
	character*(*) lbrnaam	!:i: the name of the library or blank
	record /search/ search	!:i: search items (the keywords)
	record /control/ control!:i: control strructure
	character*(*) facnaam	!:i: facility name
	logical ansi		!ansi terminal?
c
c Local vars
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 k,l,lun,nk,ios,p_new,ilev,ipos,nk_mes,nk_res
	integer*4 nkar_key,i_table,ikey
	logical forward,highlight
	character*255 lnam,meslin,reslin
	character*132 line
	character*20 key
c
	integer*4 incr_table
	parameter (incr_table=128)	!one block of integers
	integer*4 size_table		!allocated size
	integer*4 n_table		!how many filled
	integer*4 table(128)
	pointer (p_table,table)
c
c The record in the .msghelp files
c
	record /msg_record/ record
c
c Externals
c
	integer*4 str$find_first_in_set
	external fshelp_noopou
	external fshelp_nohlpmsg
	external fshelp_notfnd
c
c Construct filename
c  either from the entry @lbr
c                or the /libr
c                default = MSGHLP$LIBRARY.MSGHLP$DATA
c
	lnam = search.key(0).key
	if(lnam .eq. ' ') lnam = lbrnaam
c
c Do not leave the .exte part empty.
c   MSGHLP$LIBRARY is also the logical name for the directory
c
	if(lnam .eq. ' ') lnam = 'MSGHLP$LIBRARY.MSGHLP$DATA;0'
c
c OPen the message library
c
	forward = .true.
	control.search_string_l = 0
	call lib$get_lun(lun)
	open(lun,
     1       file=lnam,
     1       defaultfile='MSGHLP$LIBRARY:.msghlp$data;0',
     1       organization='indexed',
     1       form='unformatted',
     1       recordtype='variable',
     1       type='old',
     1       access='keyed',
     1       shared,readonly,
     1       err=80)
c
c Display the filename 
c
	inquire(lun,name=lnam)
	nk = index(lnam,' ')-1
	if(ansi) then
          call lib$trim_filespec(lnam(1:nk),line,screen.ncols-20,nk)
          call smg$put_chars(screen.display_id_kop,line(1:nk),1,11)
	endif
c
c Make all keywords decent
c 
	do ilev=1,search.level
c
c  clear out special chars in keynames
c
	  k = str$find_first_in_set(search.key(ilev).key,',=()/')
	  if(k .ne. 0) then
	    search.key(ilev).key(k:) = ' '	!skip specials
	    search.key(ilev).nkar_key =  k-1	!and set new length
	  endif
	end do
c
c Create header for search keys
c
	if(ansi) then
	  call util_make_header_search(search,.false.,
     1                 line(1:screen.ncols-11),nk)
          call smg$put_chars(screen.display_id_kop,line(1:nk),2,11)
	endif
c
c Init table
c  this table contains the record id's of the found records
c
	size_table = 0
	n_table    = 0
c
c Go through all records 
c  Read all records that have key "key"
c  the key is char(255)//name 
c
	do ilev=1,search.level
c
c Build the keyname key
c
	  key = char(255)//search.key(ilev).key
	  nkar_key = search.key(ilev).nkar_key + 1
	  if(nkar_key .eq. 1) goto 15		!now empty
	  
c
c Find the first record
c
	  read(lun,keyge=key(1:nkar_key),keyid=0,iostat=ios) record
c
c Set all found items to negative
c  The first time this is an empty table
c
	  do k=1,n_table
	    table(k) = -iabs(table(k))
	  end do
c
c reentry from the sequential read
c
10	  if(ios .eq. for$ios_inpstareq) ios = 0
	  if(ios .eq. 0 .and. 
     1      record.facnaam(1:nkar_key) .eq. key(1:nkar_key)) then
c
c Key matches
c  if this is the first key , just add to the table
c
	    if(ilev .eq. 1) then
c
c If table not big enough, expand it
c
	      if(n_table .ge. size_table) then
	        k = 4*(size_table+incr_table)
	        call lib$get_vm(k,p_new)
	        if(p_table .ne. 0) then
	          call lib$movc3(4*size_table,table,%val(p_new))
	          call lib$free_vm(4*size_table,p_table)
	        endif
	        p_table = p_new
	        size_table = size_table+incr_table
	      endif
c
c Insert entry
c
	      n_table = n_table + 1
	      table(n_table) = record.keyval
	    else
c
c Second or following keys
c all entries in the table have been make negative
c find if this record is already in the table
c
	      do k=1,n_table
	        if(iabs(table(k)) .eq. record.keyval) then
c
c Yes, so now make the entry positive again
c
	          table(k) = iabs(table(k))
	        endif
	      end do
	    endif
c
c Read the next record
c
	    read(lun,iostat=ios) record
	    goto 10
	  endif
c
c All entries were negated
c the entries that were found using the current key are made positive again
c so all entries still negative can be excluded from the list
c CLear out unused items
c
	  do k=1,n_table
	    if(table(k) .lt. 0) table(k) = 0
	  end do
15	end do
c
c Now we have a sparsely filled table with elements
c if table(k)<>0 it contains the record number of the wanted records
c
	l = 0
c
c Read all data records (the ones pointed to by the value in table(k)
c and check if the facility matches. 
c on the fly compress table to a list of wanted ones
c 
	do k=1,n_table
	  if(table(k) .gt. 0) then
c
c Contains valid index
c
	    if(facnaam .ne. ' ') then
c
c Get the data record
c
	      read(lun,keyeq=table(k),keyid=1,iostat=ios) record
	      if(ios .eq. for$ios_inpstareq) ios = 0
	      if(ios .ne. 0) goto 54	!should not happen
c
c Check for the facility name
c
	      ipos = index(record.facnaam,',')-1
	      if(ipos .lt. 0) ipos = index(record.facnaam,' ')-1
	      if(ipos .gt. len(facnaam)) ipos = len(facnaam) 
c
c If not equal, skip this one
c
	      if(facnaam(1:ipos) .ne. record.facnaam(1:ipos)) goto 54
	    endif
c
c One more remaining entry
c
	    l = l + 1
	    table(l) = table(k)
	  end if
54	end do
c
c Now table(1:l) contain all valid entries
c
	n_table = l
c
	if(n_table .eq. 0) then
	  if(ansi) then
	    call fshelp_mess(fshelp_nohlpmsg)
	  else
	    call fshelp_getmsg(fshelp_nohlpmsg,meslin,nk_mes)
	    write(*,*) meslin(1:nk_mes)
	  endif
	else
	  if(n_table .eq. 1 .or. .not. ansi) then
c
c Either only one match, or not smg
c
	    do i_table=1,n_table
c
c Only one match, print the contents of this record 
c  either on the screen, or on the output file
c
	      read(lun,keyeq=table(i_table),keyid=1,iostat=ios) record
c	  
	      call display_msghelp(screen,record,control,ikey,
     1                search,ansi,
     1                forward,highlight,i_table,n_table,.true.)
	    enddo
	  else
c
c More than one match (and with smg), display the index
c
	    call fshelp_msg_index(control,screen,lun,n_table,
     1              table,search,forward,highlight)
	  endif
c
	endif
c
c CLose the file, and return
c
70	close(lun)
	goto 90
c
c Could notmm open then msghelp file, tell the user
c
80	nk = index(lnam,' ')-1
	if(ansi) then
	  call fshelp_mess_par(fshelp_noopou,lnam(1:nk))
	else
	  call fshelp_getmsg(fshelp_noopou,meslin,nk_mes)
	  call sys$fao(meslin(1:nk_mes),nk_res,reslin,line(1:nk))
	  write(*,*) reslin(1:nk_res)
	endif
90	call lib$free_lun(lun)
	return
	end
	subroutine display_msghelp(screen,record,control,ikey,
     1            search,ansi,forward,highlight,i_table,n_table,
     1             toplevel)
	implicit none
	include 'fshelp.inc'
	include 'fshelp_msghelp.inc'
	include '($smgdef)'
c
c Display the record data on the screen or on the terminal(file)
c
	record /screen/ screen		!:i: screen info
	record /msg_record/ record	!:i: the data record
	record /control/control		!:i: control block
	record /search/ search		!:i: the search items
	integer*4 ikey			!:o: return status
	logical*4 ansi			!:i: screen(true) or file mode
	logical*4 forward		!:io: forward search/move
	logical highlight		!:io: highlight search text in display?
	integer*4 i_table		!:i: index in table
	integer*4 n_table		!:i: total entries
	logical*4 toplevel		!:i: leave on screen
c
c Local vars
c
c
	record /mouse/ iterm
c
	integer*4 ncols,nrows,nrows_view,ncols_view,dis_id
	integer*4 col_offset,row_offset
c
	integer*4 nk,row,pos,nb,spos,k,nk1
	integer*4 col,bpos,nrows_disp
	logical moved
	character*16 topic
	character*(max_line_length) line
c
c Externals
c
	logical fshelp_msg_get_text
	external fshelp_hlpmsg
	external fshelp_firsttop
	external fshelp_lasttop
	external fshelp_first
	external fshelp_last
	external fshelp_unknown
c
c Start of coding
c
c Create display screen, initial screen size
c  this display will be expanded if needed
c
	if(ansi) then
	  nrows_view = screen.nrows - 2
	  nrows_disp = nrows_view
	  ncols = screen.ncols
	  ncols_view = ncols
	  call smg$create_virtual_display(nrows_disp,ncols,dis_id)
	  call smg$paste_virtual_display(dis_id,screen.paste_id,3,1)
	  call smg$create_viewport(dis_id,1,1,nrows_view,ncols_view)
c
c Display the index
c
	  call sys$fao('    !UL of !UL',nk,line,%val(i_table),%val(n_table))
          call smg$put_chars(screen.display_id_kop,line(1:nk),1,
     1               screen.ncols-nk+1)
c
	endif
c
	pos = 0         !pos in record
	nrows = 0	!row 0 in display
c
c Go parse anything from the data record
c  in ansi mod : print to display
c   else       : Print to sys$output
c
c Get name part
c
	do while(fshelp_msg_get_text(record,pos,record.pos_name,
     1                 record.len_name,nk,line))
	  if(ansi) then
c
c Screen mode, display the data
c
	    call fshelp_enlarge_display(dis_id,nrows,nrows_disp,1)
	    call smg$put_chars(dis_id,line(1:nk),nrows,2)
	    call str$upcase(line,line(1:nk))
c
c  locate the keywords and bold them
c
	    bpos = 1
	    do k=1,search.level
	      nk1 = search.key(k).nkar_key
	      if(nk1 .gt. 0) then
12	        spos = index(line(bpos:nk),search.key(k).key(1:nk1))
	        if(spos .ne. 0) then
c
c Underline the keyword and try again for the rest of the line
c
	          call smg$change_rendition(dis_id,nrows,spos+bpos,
     1             1,nk1,,smg$m_underline)
	          bpos = spos+bpos 
	          goto 12
	        endif
	      endif
	    end do
	  else
c
c File mode, just print
c
	    write(*,*) line(1:nk)
	  endif
	end do
c
	if(.not. ansi) write(*,*) ' '
c
c Now the facility part
c
	topic = '  Facility:'
	line = record.facnaam
	nk = min(len(record.facnaam),record.len_fac)
	if(record.len_fac .gt. nk) then
	  nb = record.len_fac - nk
	  call lib$movc3(nb,record.record(record.pos_fac),
     1                   %ref(line(nk+1:nk+1)))
	  nk = nk + nb
	endif
c
c Display (on screen or to the terminal)
c
	if(ansi) then
	  call fshelp_enlarge_display(dis_id,nrows,nrows_disp,2)
	  call smg$put_chars(dis_id,topic//line(1:nk),nrows,1)
	else
	  write(*,*) topic//line(1:nk)
	endif
c
c 2 blank lines
c
	if(.not. ansi) write(*,*) ' '
c
c Now the explanation part
c
	pos = 0
	topic = '  Explanation:'
	if(ansi) then
	  call fshelp_enlarge_display(dis_id,nrows,nrows_disp,2)
	endif
	do while(fshelp_msg_get_text(record,pos,record.pos_expla,
     1                    record.len_expla,nk,line))
c
c Display
c
	  if(ansi) then
	    call fshelp_enlarge_display(dis_id,nrows,nrows_disp,1)
	    call smg$put_chars(dis_id,topic//line(1:nk),nrows,1)
	  else
	    write(*,*) topic//line(1:nk)
	  endif
	  topic = ' '
	end do
	if(.not. ansi) write(*,*) ' '
c
c Now the user action part
c
	pos = 0
	topic = '  User action:'
	if(ansi) then
	  call fshelp_enlarge_display(dis_id,nrows,nrows_disp,1)
	endif
	do while(fshelp_msg_get_text(record,pos,record.pos_user,
     1                    record.len_user,nk,line))
c
c Display
c
	  if(ansi) then
	    call fshelp_enlarge_display(dis_id,nrows,nrows_disp,1)
	    call smg$put_chars(dis_id,topic//line(1:nk),nrows,1)
	  else
	    write(*,*) topic//line(1:nk)
	  endif
	  topic = ' '
	  row = row + 1
	end do
c
	row_offset = 1
	col_offset = 1
	col = 1
	row = 1
c
	if(.not. ansi) write(*,*) ' '
c
c get key from user (in file mode assume nextrecord)
c
10	if(ansi) then
	  call fshelp_msg_display(control,dis_id,0,
     1               nrows,ncols,
     1               nrows_view,ncols_view,
     1               row_offset,col_offset,
     1               row,col,
     1               iterm,forward,highlight,moved)
c
	else
c
c Iterm is always enter (next record)
c
	  iterm.iterm = smg$k_trm_enter
	endif
c
c Process terminator
c
	if(iterm.iterm .eq. smg$k_trm_enter) then
c
c Next record, if in screen mode : tell him : no more
c
	  if(i_table .eq. n_table) then
	    call fshelp_mess(fshelp_lasttop)
	    goto 10
 	  endif
	  ikey = + 1
	  goto 90
	elseif(iterm.iterm .eq. smg$k_trm_f10 .or.
     1         iterm.iterm .eq. smg$k_trm_ctrlz) then
c
c Exit 
c
	  ikey =   0
	  goto 90
	elseif(iterm.iterm .eq. smg$k_trm_help) then
c
c Display help
c
          call general_help(fshelp_hlpmsg,control)
	elseif(iterm.iterm .eq. smg$k_trm_find) then
	  ikey = 2
	  goto 90
	elseif(iterm.iterm .eq. smg$k_trm_period) then
c
c kp0/0 : take previous record (only if not first)
c
	  if(i_table .eq. 1) then
	    call fshelp_mess(fshelp_firsttop)
	    goto 10
	  endif
	  ikey = - 1
	  goto 90
	else
	  call fshelp_mess(fshelp_unknown)
	endif
	goto 10
c
c return iterm to caller 
c
90	if(ansi) then
c
c Leave display on screen when exit, this allows the
c  user to read the text ofter exit
c
	  if(toplevel) then
	    call smg$set_cursor_abs(dis_id,row_offset+nrows_view-1,1)
	  else
	    call smg$delete_virtual_display(dis_id)
	  endif
	endif
	return
	end		
	function fshelp_msg_get_text(data,pos,offset,length,nk,line)
	implicit none
c
c Get data from record
c
	byte data(0:*)		!:i: the data record
	integer*2 pos           !:io: offset from offset, start at 0
	integer*2 length        !:i: length of this part
	integer*2 offset	!:i: offset in record for this part
	integer*4 nk            !:o: length of text
	character*(*) line	!:o: the text
	logical fshelp_msg_get_text	!:f: if false, no more data found
c
	if(pos .lt. length) then
c
c Still in part of record, get the data
c the data is a byte counted string
c
	  nk = zext(data(pos+offset))	!get byte count
c
c And move the data, but no more than the lenght of "line"
c
	  call lib$movc3(min(nk,len(line)),
     1         data(pos+offset+1),%ref(line))
c
c Update the offset
c
	  pos = pos + 1 + nk
	  fshelp_msg_get_text =.true.
	else
c
c Sorry, n more data available
c
	  fshelp_msg_get_text =.false.
	endif
	return
	end
	subroutine fshelp_enlarge_display(dis_id,nrows,nrows_disp,incr)
	implicit none
c
c Enlarge display by 50 lines
c
	integer*4 dis_id	!:i: display id
	integer*4 nrows		!:io: #rows used
	integer*4 nrows_disp	!:io: #rows incemented by 50
	integer*4 incr		!:i: increment
c
	integer*4 istat
	integer*4 smg$change_virtual_display
c
	nrows = nrows + incr
	if(nrows .gt. nrows_disp) then
	  nrows_disp = nrows_disp + 50
	  istat = smg$change_virtual_display(dis_id,nrows_disp)
	endif
	return
	end
	subroutine fshelp_msg_index(control,screen,lun,n_table,
     1            table,search,forward,highlight)
	implicit none
c
c Display index on screen
c and let user select one from them
c
	include 'fshelp.inc'
	include 'fshelp_msghelp.inc'
	include '($foriosdef)'
	include '($smgdef)'
c
	record /control/ control!:i: control structure
	record /screen/ screen	!:i: screen structure
	integer*4 lun		!:i: the file lun
	integer*4 n_table	!:i: table size
	integer*4 table(*)	!:i: table of record numbers
	record /search/ search	!:i: search items (the keywords)
	logical forward		!:io: the forward setting
	logical highlight	!:o: result of search?
c
	record /msg_record/ record
c
	integer*4 dis_id,k,ios,nrow,row,col,nk,pos,nrows_view,kl
	integer*4 dis_hd,col_offset,row_offset,ncols_view,max_col
	integer*4 descr(2),ikey
	logical first,moved
	record /mouse/ iterm
	character*(max_line_length) line
c
	character*(*) hdr_index,hdr_fac,hdr_ident,hdr_text
	parameter (hdr_index = 'Index')
	parameter (hdr_fac   = 'Facility')
	parameter (hdr_ident = 'Ident')
	parameter (hdr_text  = 'Text')
c
	integer*4 wid_index,wid_fac,wid_ident	
c
c Externals
c
	external fshelp_hlpmsgix
	external fshelp_unknown
	external fshelp_notfnd
c
	logical fshelp_msg_get_text
	integer*4 str$find_first_not_in_set
	integer*4 str$find_first_in_set
	integer*4 find_string_wild
c
c First determine the sizes of all variable parts
c
	call sys$fao('!UL',nk,line,%val(n_table))
	wid_index = max(nk,len(hdr_index))
	wid_fac   = len(hdr_fac)
	wid_ident = len(hdr_ident)
c
	do k=1,n_table
	  read(lun,keyeq=table(k),keyid=1,iostat=ios) record
	  if(ios .eq. for$ios_inpstareq) ios = 0
	  if(ios .eq. 0) then
c
c Get the facility name
c this is in two parts
c the forst 20 (or less) chars are in record.facnaam
c the (optional) rest is in offset .pos_fac
c
	    line = record.facnaam
	    nk = min(len(record.facnaam),record.len_fac)
	    if(record.len_fac .gt. nk) then
	      kl = record.len_fac - nk
	      call lib$movc3(kl,record.record(record.pos_fac),
     1               %ref(line(nk+1:nk+1)))
	      nk = nk + kl
	    endif
c
	    kl = str$find_first_in_set(line(1:nk),' ,') - 1
	    if(kl .lt. 0) kl = nk
	    wid_fac = max(wid_fac,kl)
c 
c Now the name part
c We only take to part upto the ,
c
c
	    pos = 0         !pos in record
	    call fshelp_msg_get_text(record,pos,record.pos_name,
     1                 record.len_name,nk,line)
	    kl = str$find_first_in_set(line(1:nk),' ,') - 1
	    if(kl .lt. 0) kl = nk
	    if(kl .ge. wid_ident) wid_ident = kl
	  endif
	end do
	col = 1
c
	highlight = .false.
c
c Create header display
c
	row = 1
	call smg$create_virtual_display(1,len(line),dis_hd)
c
c Force the whole line to underline
c
	line = ' '
	call smg$put_chars(dis_hd,line,row,col,,smg$m_underline)
c
c Now display the various parts
c
	call smg$put_chars(dis_hd,hdr_index,row,col,,smg$m_underline)
	col = col + wid_index + 1
	call smg$put_chars(dis_hd,hdr_fac,row,col,,smg$m_underline)
	col = col + wid_fac + 1
	call smg$put_chars(dis_hd,hdr_ident,row,col,,smg$m_underline)
	col = col + wid_ident + 1
	call smg$put_chars(dis_hd,hdr_text,row,col,,smg$m_underline)
c
c Create data display
c
	call smg$create_virtual_display(n_table+1,len(line),dis_id)
	nrow = 0
	max_col = 0
	do k=1,n_table
	  col = 1
	  read(lun,keyeq=table(k),keyid=1,iostat=ios) record
	  if(ios .eq. for$ios_inpstareq) ios = 0
	  if(ios .ne. 0) goto 10	!should not happen
c
	  nrow = nrow + 1
	  write(line,1000) k
1000	  format(i<wid_index>)
	  call smg$put_chars(dis_id,line(1:5),nrow,col)
	  col = col + wid_index + 1
c
	  line = record.facnaam
	  nk = min(len(record.facnaam),record.len_fac)
	  if(record.len_fac .gt. nk) then
	    kl = record.len_fac - nk
	    call lib$movc3(kl,record.record(record.pos_fac),
     1               %ref(line(nk+1:nk+1)))
	    nk = nk + kl
	  endif
	  kl = str$find_first_in_set(line(1:nk),' ,') - 1
	  if(kl .lt. 0) kl = nk
	  call smg$put_chars(dis_id,line(1:kl),nrow,col)
	  col = col + wid_fac + 1
c
c Now the text part
c	  
	  pos = 0         !pos in record
c
c Get name part
c
	  first = .true.
	  do while(fshelp_msg_get_text(record,pos,record.pos_name,
     1                 record.len_name,nk,line))
	    if(first) then
c
c Skip the ident part
c
	      kl = str$find_first_in_set(line(1:nk),' ,') - 1
	      if(kl .lt. 0) kl = nk
	      call smg$put_chars(dis_id,line(1:kl),nrow,col)
	      col = col + wid_ident + 1
	      if(line(kl+1:kl+1) .eq. ',') kl = kl + 1
	      line(1:kl) = ' '
	      first = .false.
	    endif
c
c Now skip leading tabs/spaces
c	      
	    kl = str$find_first_not_in_set(line(1:nk),' '//char(9))
	    if(kl .eq. 0) kl = 1
	    call smg$put_chars(dis_id,line(kl:nk),nrow,col)
	    col = col + nk - kl + 1
	    if(col .gt. max_col) max_col = col
	  end do
10	end do
c
	nrows_view = min(nrow,screen.nrows-3)
	ncols_view = screen.ncols
	call smg$create_viewport(dis_id,1,1,nrows_view,ncols_view)
	call smg$paste_virtual_display(dis_id,screen.paste_id,4,1)
c
	call smg$create_viewport(dis_hd,1,1,1,ncols_view)
	call smg$paste_virtual_display(dis_hd,screen.paste_id,3,1)
c
	row_offset = 1
	col_offset = 1
	row = 1
	col = 1
c
20	call fshelp_msg_display(control,dis_id,dis_hd,
     1               nrow,max_col,
     1               nrows_view,ncols_view,
     1               row_offset,col_offset,
     1               row,col,
     1               iterm,forward,.false.,moved)
	if(moved) highlight = .false.
c
c Most keys are handled in msg_display, now act on the others
c
22	if(iterm.iterm .eq. smg$k_trm_enter) then
	  read(lun,keyeq=table(row),keyid=1,iostat=ios) record
c	  
	  call display_msghelp(screen,record,control,ikey,
     1                search,.true.,forward,highlight,
     1                 row,n_table,.false.)

	  if(ikey .eq. 1) then
c
c  Next rec
c
	    row = min(row + 1,n_table)
  	    goto 22
	  elseif(ikey .eq. 0) then
	    iterm.iterm = 0		!signal just return
	  elseif(ikey .eq. -1) then
c
c Prev rec
c
	    row = max(row - 1,1)
	    goto 22
	  elseif(ikey .eq. 2) then
c
c  Search all records for text
c
	    iterm.iterm = smg$k_trm_find
	  endif
	endif
	if(iterm.iterm .eq. smg$k_trm_find) then
c
c Search all records for text in control.search_string
c
	  kl = row
26	  if(forward) then
	    kl = kl+1
	  else
	    kl = kl-1
	  endif
	  if(kl .gt. 0 .and. kl .le. n_table) then
	    read(lun,keyeq=table(kl),keyid=1,iostat=ios) record
	    descr(1) = record.rec_len
	    descr(2) = %loc(record)
	    call str$upcase(descr,descr)
	    if(find_string_wild(descr,
     1           control.search_string(1:control.search_string_l),
     1             k) .ne. 0) then
	      row = kl
	      highlight = .true.
	      iterm.iterm = smg$k_trm_enter
	    else
	      goto 26
	    endif
	  else
	    call fshelp_mess(fshelp_notfnd)
	  endif
	  goto 22
	elseif(iterm.iterm .eq. smg$k_trm_help) then
c
c Display help
c
          call general_help(fshelp_hlpmsgix,control)
	elseif(iterm.iterm .eq. smg$k_trm_f10 .or.
     1         iterm.iterm .eq. smg$k_trm_ctrlz) then
	  goto 90
	elseif(iterm.iterm .eq. 0) then
c
c F10 on display_msghelp, do nothing
c
	else
	  call fshelp_mess(fshelp_unknown)
	endif
	goto 20
90	call smg$delete_virtual_display(dis_id)
	call smg$delete_virtual_display(dis_hd)
	return
	end
	subroutine fshelp_msg_display(control,dis_id,dis_hd,
     1               nrows,ncols,
     1               nrows_view,ncols_view,
     1               row_offset,col_offset,
     1               row,col,
     1               iterm,forward,highlight,moved)
	implicit none
	include '($smgdef)'
	include 'fshelp.inc'
c
c The common display window routine
c 
	record /control/ control	!:i: control block
	integer*4 dis_id		!:i: display id
	integer*4 dis_hd		!:i: display id of header (or 0)
	integer*4 nrows			!:i: #displayable rows in display
	integer*4 ncols			!:i: #displayable cols in display
	integer*4 nrows_view		!:i: nrows in view
	integer*4 ncols_view		!:i: ncol in view
	integer*4 row_offset		!:io: row offset (viewport row)
	integer*4 col_offset		!:io: col offset (viewport col)
	integer*4 row			!:io: current row
	integer*4 col			!:io: current col
	record /mouse/ iterm			!:o: key entered
	logical*4 forward		!:io: forward search/move
	logical highlight		!:io: highlight all occurs of the search string?
	logical moved			!:o: return true if movement has occurred
c
c Local vars
c
	integer*4 k,col_shift,row_fnd,col_fnd,bpos,nk,ipos,nb
	logical pf1_flag,bold_set,global
	character*(max_line_length) line
c
c Externals
c
	external fshelp_notfnd
	external fshelp_seastr1
	logical find_string
	integer find_string_wild
	integer*4 get_len

	col_shift = ncols_view/4
c
	if(highlight) then
	  do k=1,nrows
	    call smg$read_from_display(dis_id,line,,k)
	    bpos = 1
	    nk = get_len(line)
5	    ipos = find_string_wild(line(bpos:nk),
     1           control.search_string(1:control.search_string_l),nb)
	    if(ipos .ne. 0) then
	      call smg$change_rendition(dis_id,k,ipos+bpos-1,1,nb,,smg$m_bold)	       
	      bpos = bpos + ipos
	      goto 5
	    end if
	  end do
	  highlight = .false.
	end if
	moved = .false.
c
c Make sure row, col inrange
c
10	row = min(nrows,max(row,1))
	col = min(ncols,max(col,1))
c
c Make sure row is in view
c
	if(row .lt. row_offset) then
	  k = row_offset-row
	  call smg$scroll_viewport(dis_id,smg$m_down,k)
	  row_offset = row_offset - k
	endif
	if(row .ge. row_offset+nrows_view) then
	  k = row - (row_offset+nrows_view) + 1
	  call smg$scroll_viewport(dis_id,smg$m_up,k)
	  row_offset = row_offset + k
	endif
c
c Make sure col is in view
c
	if(col .lt. col_offset) then
	  k = col_offset-col
	  call smg$scroll_viewport(dis_id,smg$m_right,k)
	  if(dis_hd .ne. 0) call smg$scroll_viewport(dis_hd,smg$m_right,k)
	  col_offset = col_offset - k
	endif
c
	if(col .ge. col_offset+ncols_view) then
	  k = col - (col_offset+ncols_view) + 1
	  call smg$scroll_viewport(dis_id,smg$m_left,k)
	  if(dis_hd .ne. 0) call smg$scroll_viewport(dis_hd,smg$m_left,k)
	  col_offset = col_offset + k
	endif
c
c Set cursor and get key
c
	call smg$set_cursor_abs(dis_id,row,col)
c
c Get key
c
	pf1_flag = .false.
20	call screen_get_one_key(iterm,control)
c
c Go interpret
c
	if(iterm.iterm .eq. smg$k_trm_pf1) then
	  pf1_flag = .true.
	  goto 20
	endif
c
	if(bold_set) then
	  call smg$change_rendition(dis_id,row,col,1,
     1               control.search_string_l,,0)
	  bold_set = .false.
	endif
c
	if(iterm.iterm .eq. smg$k_trm_four .or.
     1         iterm.iterm .eq. smg$k_trm_kp4) then
	  if(pf1_flag) then
	    row = nrows
	  else
	    forward = .true.
	  endif
	elseif(iterm.iterm .eq. smg$k_trm_five .or.
     1         iterm.iterm .eq. smg$k_trm_kp5) then
	  if(pf1_flag) then
	    row = 1
	  else
	    forward = .false.
	  endif
	  goto 10
	elseif(iterm.iterm .eq. smg$k_trm_eight .or.
     1         iterm.iterm .eq. smg$k_trm_kp8) then
	  if(forward) then
	    row = row + (2*nrows_view)/3
	  else
	    row = row - (2*nrows_view)/3
	  endif
	elseif(iterm.iterm .eq. smg$k_trm_find .or.
     1         iterm.iterm .eq. smg$k_trm_pf3) then
	  if(pf1_flag) control.search_string_l = 0
	  global = iterm.iterm .eq. smg$k_trm_find
	  if(control.search_string_l .eq. 0) then
	    call ask_sear_string(control,forward,global,k)
	  endif
	  if(control.search_string_l .eq. 0) then
	    call fshelp_mess(fshelp_seastr1)
	  else
	    if(global) goto 90
	    row_fnd = row
	    col_fnd = col
	    if(find_string(control.search_string(1:control.search_string_l),
     1         dis_id,row_fnd,nrows,forward,col_fnd,
     1         control.search_string_fnd)) then
	      row = row_fnd
	      col = col_fnd
	      call smg$change_rendition(dis_id,row,col,1,
     1               control.search_string_l,,smg$m_bold)
	      bold_set = .true.
	    else
	      call fshelp_mess(fshelp_notfnd)
	    endif
	  endif
	elseif(iterm.iterm .eq. smg$k_trm_down) then
	  if(pf1_flag) then
	    row = row + (2*nrows_view)/3
	  else
	    row = row + 1
	  endif
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_next_screen) then
	  if(pf1_flag) then
	    row = nrows 
	  else
	    row = row + (2*nrows_view)/3
	  endif
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_up) then
	  if(pf1_flag) then
	    row = row - (2*nrows_view)/3
	  else
	    row = row - 1
	  endif
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_prev_screen) then
	  if(pf1_flag) then
	    row = 1
	  else
	    row = row - (2*nrows_view)/3
	  endif
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_right) then
	  if(pf1_flag) then
	    col = col + col_shift
	  else
	    col = col + 1
	  endif
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_ctrlh) then
	  col = 1
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_ctrle) then
	  call smg$read_from_display(dis_id,line,,row)
	  col = get_len(line)
	  moved = .true.
	elseif(iterm.iterm .eq. smg$k_trm_left) then
	  if(pf1_flag) then
	    col = col - col_shift
	  else
	    col = col - 1
	  endif
	  moved = .true.
	elseif(iterm.button .eq. key_mouse_1) then
	  iterm.iterm = smg$k_trm_period	!map left mouse to prev mess
	  moved = .true.
	  goto 90
	elseif(iterm.button .eq. key_mouse_3) then
	  iterm.iterm = smg$k_trm_enter 	!map left mouse to next mes
	  goto 90
	else
	  goto 90
	endif
	goto 10
90	return
	end
