	subroutine fshelp_obj_init(tablerec,tablebyt)
	implicit none
c
c Init ana/obj tables
c
	include '($objrecdef)'
	include '($eobjrecdef)'
c
	integer*4 tablerec(obj$c_hdr:eobj$c_etbt)	!:o: occur counter table
	integer*4 tablebyt(obj$c_hdr:eobj$c_etbt)	!:o: byte counter table
c
	integer*4 k
c
	do k=obj$c_hdr,eobj$c_etbt
	  tablerec(k) = 0
	  tablebyt(k) = 0
	end do
	return
	end
	subroutine fshelp_obj_wrraw(lun_text,irec,nbyte,data,
     1          tablerec,tablebyt)
	implicit none
c
c Ana/obj raw records, (binary dump)
c
	include '($objrecdef)'
	include '($eobjrecdef)'
c
	integer*4 lun_text	!:i: the (VM-) lun
	integer*4 irec		!:io: record number and updated by 1
	integer*4 nbyte		!:i: length of record
	byte data(*)		!:i: the data
	integer*4 tablerec(obj$c_hdr:eobj$c_etbt)	!:io: occur counters
	integer*4 tablebyt(obj$c_hdr:eobj$c_etbt)       !:io: byte counters
c
	external routine
c
	character*80 line,type
	integer*4 nk,k,nkt
	logical err
c
	err = .false.
	k = data(1)
c
c Set header text depending on type
c
        if(    k .eq.  obj$c_hdr) then
	  type = 'Vax header (OBJ$C_HDR)#'
        elseif(k .eq.  obj$c_gsd) then
          type = 'Vax global symbol directory (OBJ$C_GSD)#'
        elseif(k .eq.  obj$c_tir) then
          type = 'Vax text info/relocation (OBJ$C_TIR)#'
        elseif(k .eq.  obj$c_eom) then
          type = 'Vax end of object (OBJ$C_EOM)#'
        elseif(k .eq.  obj$c_dbg) then
          type = 'Vax debug (OBJ$C_DBG)#'
        elseif(k .eq.  obj$c_tbt) then
          type = 'Vax traceback (OBJ$C_TBT)#'
        elseif(k .eq.  obj$c_lnk) then
          type = 'Vax link (OBJ$C_LNK) #'
        elseif(k .eq.  obj$c_eomw) then
          type = 'Vax end of module word (OBJ$C_EMOW)#'
c
        elseif(    k .eq.  eobj$c_emh) then
          type = 'Alpha module header (EIBJ$C_EMH)#'
        elseif(k .eq.  eobj$c_eeom) then
          type = 'Alpha end of object (EOBJ$C_EEOM)#'
        elseif(k .eq.  eobj$c_egsd) then
          type = 'Alpha global symbol directory (EOBJ$C_EGSD)#'
        elseif(k .eq.  eobj$c_etir) then
          type = 'Alpha text info/relocation (EEOBJ$C_ETIR)#'
        elseif(k .eq.  eobj$c_edbg) then
          type = 'Alpha debug (EEOBJ$C_EDBG)#'
        elseif(k .eq.  eobj$c_etbt) then
          type = 'Alpha traceback (EEOBJ$C_ETBT)#'
	else
	  type = 'Unknown'
	  err = .true.
	endif
c
c Update counters
c
	if(.not. err) then
	  tablerec(k) = tablerec(k) + 1
	  tablebyt(k) = tablebyt(k) + nbyte
	end if
c
	nkt = index(type,'#')-1
c
c Write header info
c
        call sys$fao('Record !UL, !AS , nbyte = !UL',nk,line,
     1            %val(irec),type(1:nkt),%val(nbyte))
        call vm_write_txt(lun_text,0,line(1:nk))
c
        call vm_write_txt(lun_text,0,' ')
c
c Write binary dump
c
	call ana_wrblk(routine,lun_text,nbyte,data,1)
        call vm_write_txt(lun_text,0,' ')
	irec = irec + 1
	return
	end
	subroutine fshelp_obj_wrint(lun_text,irec,nk,data,
     1          tablerec,tablebyt)
	implicit none
c
c Write an analyze/object text 
c
	include '($objrecdef)'
	include '($eobjrecdef)'
c	
	integer*4 lun_text     	!:i: the (vm-) lun
	integer*4 irec		!:io: the record number (updated by 1)
	integer*4 nk		!:i: length of the record
	byte data(*)		!:i: the data
	integer*4 tablerec(obj$c_hdr:eobj$c_etbt)	!:io: occur counters
	integer*4 tablebyt(obj$c_hdr:eobj$c_etbt)	!:io: byte counters
c
	integer*4 fshelp_obj_vax_hdr
	integer*4 fshelp_obj_vax_gsd
	integer*4 fshelp_obj_vax_tir
	integer*4 fshelp_obj_vax_eom
	integer*4 fshelp_obj_vax_dbg
	integer*4 fshelp_obj_vax_tbt
	integer*4 fshelp_obj_vax_lnk
	integer*4 fshelp_obj_vax_eomw
	integer*4 fshelp_obj_alpha_hdr
	integer*4 fshelp_obj_alpha_eom
	integer*4 fshelp_obj_alpha_gsd
	integer*4 fshelp_obj_alpha_etir
	integer*4 fshelp_obj_alpha_dbg
	integer*4 fshelp_obj_alpha_tbt
c
	external routine
	integer*4 routine
c
	character*10 temp
	byte type
c
	type = data(1)
c
c Update counters
c
	if(type .ge. obj$c_hdr .and. type .le. eobj$c_etbt) then
	  tablerec(type) = tablerec(type) + 1
	  tablebyt(type) = tablebyt(type) + nk
	endif
c
c Split the parsing to the correct module (vax.. /alpha...)
c 
	if(    type .eq. obj$c_hdr) then
	  if(.not. fshelp_obj_vax_hdr(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_gsd) then
	  if(.not. fshelp_obj_vax_gsd(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_tir) then
	  if(.not. fshelp_obj_vax_tir(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_eom) then
	  if(.not. fshelp_obj_vax_eom(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_dbg) then
	  if(.not. fshelp_obj_vax_dbg(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_tbt) then
	  if(.not. fshelp_obj_vax_tbt(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_lnk) then
	  if(.not. fshelp_obj_vax_lnk(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. obj$c_eomw) then
	  if(.not. fshelp_obj_vax_eomw(nk,data,routine,lun_text,irec)) goto 90
c       
c Alpha codes
c
	elseif(    type .eq. eobj$c_emh) then
	  if(.not. fshelp_obj_alpha_hdr(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. eobj$c_eeom) then
	  if(.not. fshelp_obj_alpha_eom(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. eobj$c_egsd) then
	  if(.not. fshelp_obj_alpha_gsd(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. eobj$c_etir) then
	  if(.not. fshelp_obj_alpha_etir(nk,data,routine,lun_text,irec))goto 90
	elseif(type .eq. eobj$c_edbg) then
	  if(.not. fshelp_obj_alpha_dbg(nk,data,routine,lun_text,irec)) goto 90
	elseif(type .eq. eobj$c_etbt) then
	  if(.not. fshelp_obj_alpha_tbt(nk,data,routine,lun_text,irec)) goto 90
	else
c
c Unknown type ?? should not happen
c
	  write(temp,1000) type
1000	  format(z2.2)
	  call vm_write_txt(lun_text,0,'Unknown recordtype %X'//temp(1:2))
	endif
90	return
	end
	subroutine fshelp_obj_report(lun_text,tablerec,tablebyt)
	implicit none
c
c Report over the occur/byte counters
c
	integer*4 lun_text
	include '($objrecdef)'
	include '($eobjrecdef)'
c
	integer*4 tablerec(obj$c_hdr:eobj$c_etbt)
	integer*4 tablebyt(obj$c_hdr:eobj$c_etbt)
c
	integer*4 totnr,totnb,nk1
	character*80 lin
c
c Write header
c
	call vm_write_txt(lun_text,0,'Summary statistics')
	call vm_write_txt(lun_text,0,
     1           'Record type          Count     total bytes')
	totnb = 0
	totnr = 0
	if(tablerec(obj$c_hdr) .ne. 0) then
c
c Vax specific
c
	  totnr = totnr + tablerec(obj$c_hdr)
	  totnb = totnb + tablebyt(obj$c_hdr)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_HDR',
     1           %val(tablerec(obj$c_hdr)),%val(tablebyt(obj$c_hdr)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_gsd)
	  totnb = totnb + tablebyt(obj$c_gsd)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_GSD',
     1           %val(tablerec(obj$c_gsd)),%val(tablebyt(obj$c_gsd)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_tir)
	  totnb = totnb + tablebyt(obj$c_tir)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_TIR',
     1           %val(tablerec(obj$c_tir)),%val(tablebyt(obj$c_tir)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_eom)
	  totnb = totnb + tablebyt(obj$c_eom)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_EOM',
     1           %val(tablerec(obj$c_eom)),%val(tablebyt(obj$c_eom)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_dbg)
	  totnb = totnb + tablebyt(obj$c_dbg)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_DBG',
     1           %val(tablerec(obj$c_dbg)),%val(tablebyt(obj$c_dbg)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_tbt)
	  totnb = totnb + tablebyt(obj$c_tbt)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_TBT',
     1           %val(tablerec(obj$c_tbt)),%val(tablebyt(obj$c_tbt)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_lnk)
	  totnb = totnb + tablebyt(obj$c_lnk)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_LNK',
     1           %val(tablerec(obj$c_lnk)),%val(tablebyt(obj$c_lnk)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(obj$c_eomw)
	  totnb = totnb + tablebyt(obj$c_eomw)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'OBJ$C_EOMW',
     1           %val(tablerec(obj$c_eomw)),%val(tablebyt(obj$c_eomw)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
	endif
	if(tablerec(eobj$c_emh) .ne. 0) then
c
c Alpha specific
c
	  totnr = totnr + tablerec(eobj$c_emh)
	  totnb = totnb + tablebyt(eobj$c_emh)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_EMH',
     1           %val(tablerec(eobj$c_emh)),%val(tablebyt(eobj$c_emh)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(eobj$c_eeom)
	  totnb = totnb + tablebyt(eobj$c_eeom)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_EEOM',
     1        %val(tablerec(eobj$c_eeom)),%val(tablebyt(eobj$c_eeom)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(eobj$c_egsd)
	  totnb = totnb + tablebyt(eobj$c_egsd)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_EGSD',
     1        %val(tablerec(eobj$c_egsd)),%val(tablebyt(eobj$c_egsd)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(eobj$c_etir)
	  totnb = totnb + tablebyt(eobj$c_etir)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_ETIR',
     1        %val(tablerec(eobj$c_etir)),%val(tablebyt(eobj$c_etir)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(eobj$c_edbg)
	  totnb = totnb + tablebyt(eobj$c_edbg)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_EDBG',
     1        %val(tablerec(eobj$c_edbg)),%val(tablebyt(eobj$c_edbg)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
c
	  totnr = totnr + tablerec(eobj$c_etbt)
	  totnb = totnb + tablebyt(eobj$c_etbt)
	  call sys$fao('!15AS !10UL !10UL',nk1,lin,'EOBJ$C_ETBT',
     1        %val(tablerec(eobj$c_etbt)),%val(tablebyt(eobj$c_etbt)))
	  call vm_write_txt(lun_text,0,lin(1:nk1))
	endif
c
c Total counts
c
	call sys$fao('!15AS !10UL !10UL',nk1,lin,'Total',
     1            %val(totnr),%val(totnb))
	call vm_write_txt(lun_text,0,lin(1:nk1))
c
	return
	end
	subroutine add_str(nb,line,add)
	implicit none
c
c Add a string to an existing line
c
	integer*4 nb		!:io: the (updated) length of line
	character*(*) line	!:io: the (updated) text line
	character*(*) add       !:i: the text to append
c
	line(nb+1:) = add
	nb = nb + len(add)
	if(nb .gt. len(line)) nb = len(line)
	return
	end

	function routine(lun,text)
	implicit none
c
c The routine to be called for each output from ana.... routines
c
	integer*4 lun		!:i: the lun to write to
	character*(*) text	!:i: the text to write
	integer*4 routine	!:f: the result
c
	integer*4 vm_write_txt
c
	routine = vm_write_txt(lun,0,text)
	return
	end
c
	function ana_wrhdr(routine,argument,cnt,long,short,nbyte,level)
	implicit none
c
c Write header record
c
	external routine		!:i: the routine to use to write
	integer routine			
	integer*4 argument              !:i: the argument for routine
	integer*4 cnt			!:io: the record count (updated when >0)
	integer*4 level                 !:i: the display level(depth)
	character*(*) long		!:i: the long info
	character*(*) short		!:i: the short info
	integer*2 nbyte			!:i: record length
	integer*4 ana_wrhdr		!:f: funciton result
c
	character*32 nrasc,bytasc,shoasc
	character kar
	integer*4 nkn,  nkb   ,nks
c
	integer*4 ana_wrtxt
c
c Check for number field, if <>0 is will be inserted
c and updated
c For level 0 the separator is a .
c for deeper levers the separator is a )
c
	if(cnt .gt. 0) then
	  kar = '.'
	  if(level .ge. 1) kar = ')'
	  call sys$fao('!UL!AS ',nkn,nrasc,%val(cnt),kar)
	  cnt = cnt + 1
	else
	  nkn = 0
	endif
c
c If short is specified, it will inserted in brackets
c with space before
c
	if(short .ne. ' ') then
	  call sys$fao(' (!AS)',nks,shoasc,short)
	else
	  nks = 0
	endif
c
c If nbyte is specified, include witrh leading ,space
c
	if(nbyte .gt. 0) then
	  call sys$fao(', !UW byte!%S',nkb,bytasc,%val(nbyte))
	else
	  nkb = 0
	endif
c
c Make total line
c
	ana_wrhdr = ana_wrtxt(routine,argument,nrasc(1:nkn)//long//
     1              shoasc(1:nks)//bytasc(1:nkb),level)
	return
	end
c
	function ana_wrtxt(routine,argument,text,level)
	implicit none
c
c Write text to the (vm-)lun
c
	external routine		!:I: th routine to do the writing
	integer routine		
	integer*4 argument      	!:i: the argument for routine
	character*(*) text		!:i: the text to write
	integer*4 level			!:i: the level
	integer*4 ana_wrtxt             !:f: the function result
c
	character*32 levasc
	integer*4 nkl
c
c Get indentation (depending on level)
c
	call sys$fao('!#AS',nkl,levasc,%val(3*level),' ')
c
c And write out
c
	ana_wrtxt = routine(argument,levasc(1:nkl)//text)
	return
	end
	function ana_wri1(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*1 (unsigned)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	byte value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri1              !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt           
c
c Translate the data
c
	call sys$fao('!AS: !UB',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XB)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri1 = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wri1s(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*1 (signed)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	byte value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri1s             !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !SB',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XB)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri1s = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wri2(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*2 (unsigned)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*2 value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri2              !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !UW',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XW)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri2 = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wri2s(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*2 (signed)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*2 value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri2s             !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !SW',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XW)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri2s = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wri4(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*4 (unsigned)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*4 value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri4              !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !UL',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XL)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri4 = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wri4s(routine,argument,intro,value,level,hex)
	implicit none
c
c Write integer*4 (signed)
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*4 value			!:i: the data
	integer*4 level			!:i: the level
	logical hex			!:i: hex display too?
	integer*4 ana_wri4s             !:f: the function result
c
	character*255 totline
	integer*4 nkt,nk1
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !SL',nkt,totline,intro,%val(value))
	if(hex) then
	  call sys$fao(' (%X!XL)',nk1,totline(nkt+1:),%val(value))
	  nkt = nkt + nk1
	endif
	ana_wri4s = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wrac(routine,argument,intro,value,level)
	implicit none
c
c Write counted ascii string
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*4 value			!:i: the data
	integer*4 level			!:i: the level
	integer*4 ana_wrac              !:f: the function result
c
	character*255 totline
	integer*4 nkt
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: "!AC"',nkt,totline,intro,value)
	ana_wrac = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wras(routine,argument,intro,value,level)
	implicit none
c
c Write ascii string 
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	character*(*) value		!:i: the data
	integer*4 level			!:i: the level
	integer*4 ana_wras              !:f: the function result
c
	character*255 totline
	integer*4 nkt
c
	integer*4 ana_wrtxt
c
c Translate the data
c
	call sys$fao('!AS: !AS',nkt,totline,intro,value)
	ana_wras = ana_wrtxt(routine,argument,totline(1:nkt),level)
	return
	end
	function ana_wrblk(routine,argument,nbyte,data,level)
	implicit none
c
c Write block of binary data
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument      	!:i: the argument for routine
	integer*4 nbyte	                !:i: Number of bytes
	byte data(*)			!:i: the data
	integer*4 level			!:i: the level
	integer*4 ana_wrblk             !:f: the function result
c
	integer*4 width
	parameter (width=16)	!16 chars / line
c
	character*80 line
	integer*4 k,offs,pos,bpos,pos_Asc,tlen,pos_nr
	character kar
c
	integer*4 ana_wrtxt
c
	ana_wrblk = .false.
c
c Make header line 1 (binary part)
c
	bpos = 1
	line = ' '
	do k=width-1,0,-1
	  write(line(bpos:bpos+2),1000) k
1000	  format(z3.1)
	  bpos = bpos + 3
	end do
	pos_nr = bpos
c
c Make header line 1 (ascii part)
c
	bpos = bpos + 8
	pos_asc = bpos
	do k=0,width-1
	  write(line(bpos:bpos),1010) k
1010	  format(z1)
	  bpos = bpos + 1
	end do
	tlen = bpos-1
	if(.not. ana_wrtxt(routine,argument,line(1:tlen),level)) goto 90
c
c Make header line 2
c
	bpos = 1
	line = ' '
	do k=1,width
	  line(bpos:bpos+2) = '---'
	  bpos = bpos + 3
	end do
	line(bpos:bpos) = '+'
	bpos = bpos + 7
	line(bpos:bpos) = '+'
	bpos = bpos + 1
	do k=1,width
	  line(bpos:bpos) = '-'
	  bpos = bpos + 1
	end do
	if(.not. ana_wrtxt(routine,argument,line(1:tlen),level)) goto 90
c
c Start converting data
c
	do k=1,nbyte
c
c Compute the offset from the width
c if is is 0, we are on the beginning of the line
c
	  offs = mod(k-1,width)
	  if(offs .eq. 0) then
c
c If some data yes, print it,
c
	    if(k .gt. 1) then
	      if(.not. ana_wrtxt(routine,argument,line(1:tlen),level)) goto 90
	    endif
c
c And reinit
c
	    line = ' '
	    write(line(pos_nr:pos_nr+7),1011) k
1011	    format('| ',z4.4,' |')
	  endif
c
c Fill the binary data
c
	  pos = (width-offs-1)*3
	  call sys$fao('!2XB',,line(pos+2:pos+3),%val(data(k)))
c
c Check if binary data is printable, and put it in the line
c
	  pos = 0
	  call lib$movc3(1,data(k),pos)
	  pos = iand(pos,127)
	  if(pos .ge. ichar(' ') .and. pos .le. 126) then
	    kar = char(data(k))
	  else
	    kar = '.'
	  endif
	  line(pos_asc+offs:pos_Asc+offs) = kar
	end do
c
c Print last line
c
	if(.not. ana_wrtxt(routine,argument,line(1:tlen),level)) goto 90
c	
	ana_wrblk = .true.
90	return
	end
	function ana_wrerr(routine,argument,intro,type,level)
	implicit none
c
c Write error message about unknown code
c
	external routine		!:I: th routine to do the writing
	integer routine
	integer*4 argument	      	!:i: the argument for routine
	character*(*) intro		!:i: the intro text
	integer*4 type
	integer*4 level			!:i: the level
	integer ana_wrerr
c
	character*10 nrasc
	integer*4 nk
c
	integer*4 ana_wrtxt
c
	call sys$fao('!UL',nk,nrasc,%val(type))
	ana_wrerr = ana_wrtxt(routine,argument,'Unknown subtype for '//
     1                  intro//'('//nrasc(1:nk)//')',level)
	return
	end

