	function fshelp_obj_alpha_dbg(nk1,data,routine,argument,rcnt)
	implicit none
	include '($etirdef)'
	integer*4 nk1
	structure /werk/
	  union
	    map
	      record /etirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_dbg
c
	integer*4 fshelp_obj_alpha_etir_sub
c
	integer*4 nb,pos,cnt
c
	integer ana_wrhdr
c
	fshelp_obj_alpha_dbg = .false.
c
	if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Debugger information','EOBJ$C_EDBG',
     1       data.data.etir$w_size,0)) goto 90
c
	nb = nk1		!to prevent warnings
	nb  = data.data.etir$w_size
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_alpha_etir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_alpha_dbg = .true.
90	return
	end
	function fshelp_obj_alpha_eom(nb,data,routine,argument,rcnt)
	implicit none
	include '($eeomdef)'
	integer*4 nb
	record /eeomdef/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_eom
c
	character*80 tmp
	integer*4 nk,k
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wras
c
	fshelp_obj_alpha_eom = .false.
c
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'End of module header','EOBJ$C_EEOM',
     1       data.eeom$w_size,0)) goto 90

	k = nb	!to prevent compiler warnings
	k = data.eeom$w_comcod
	if(k .eq. eeom$c_success) then
	  call sys$fao('Successful (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eeom$c_warning) then
	  call sys$fao('Warning (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eeom$c_error) then
	  call sys$fao('Error (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eeom$c_abort) then
	  call sys$fao('Abort (!UL)',nk,tmp,%val(k))
	else
	  call sys$fao('Unknown (!UL)',nk,tmp,%val(k))
	endif
c
	if(.not. ana_wras(routine,argument,'Severity',tmp(1:nk),2)) goto 90
c
	if(.not. ana_wri4(routine,argument,
     1         'Highest conditional linkage index',
     1          2*data.eeom$l_total_lps,2,.false.)) goto 90
c
	if(data.eeom$w_size .eq. eeom$k_eommax) then
	  tmp = ' '

	  if(btest(zext(data.eeom$b_tfrflg),eeom$v_wktfr)) tmp = 'Weak'
	  if(.not. ana_wras(routine,argument,'Transfer address flags',
     1             tmp(1:4),2)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Psect',
     1             data.eeom$l_psindx,2,.false.)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Value',
     1             data.eeom$l_tfradr,2,.true.)) goto 90
	endif

	fshelp_obj_alpha_eom = .true.
90	return
	end
	function fshelp_obj_alpha_gsd(nk,data,routine,argument,rcnt)
	implicit none
c
	include '($egsdef)'
	integer*4 nk
	structure /werk/
	  union
	    map
	      record /egsdef/ data
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
c
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_gsd
c
	integer*4 nb,pos,cnt
c
	integer*4 fshelp_obj_alpha_gsd_sub
	integer*4 ana_wrhdr
c
	fshelp_obj_alpha_gsd = .false.
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Global symbol directory','EOBJ$C_EGSD',
     1       data.data.egsd$w_recsiz,0)) goto 90
c
	nb = nk		!to prevent compiler warnings
	nb  = data.data.egsd$w_recsiz
	pos = %loc(data.data.egsd$w_gsdtyp) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_alpha_gsd_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_alpha_gsd = .true.
90	return
	end
	function fshelp_obj_alpha_gsd_sub(data,pos,routine,argument,cnt)
	implicit none
c
	include '($egsdef)'
	record /egsdef/ data
	integer*4 pos
	integer*4 routine
	external routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_gsd_sub
c
	integer*4 fshelp_obj_alpha_gsd_psc
	integer*4 fshelp_obj_alpha_gsd_sym
	integer*4 fshelp_obj_alpha_gsd_idc
	integer*4 fshelp_obj_alpha_gsd_psc64
c
	integer*4 ana_wrerr
c
c
c The fortran on VAX does not have the egsd$c_psc64 def
c so we use the value instead
c
	integer*4 my_egsd$c_psc64
	parameter (my_egsd$c_psc64=9)

c
	integer*4 type,nbyte
c
	fshelp_obj_alpha_gsd_sub = .false.
	type = data.egsd$w_rectyp
	nbyte = data.egsd$w_recsiz
	if(    type .eq. egsd$c_psc) then
	  if(.not. fshelp_obj_alpha_gsd_psc(routine,argument,
     1             data,nbyte,cnt)) goto 90
	elseif(type .eq. egsd$c_sym) then
	  if(.not. fshelp_obj_alpha_gsd_sym(routine,argument,
     1             data,nbyte,cnt)) goto 90
	elseif(type .eq. egsd$c_idc) then
	  if(.not. fshelp_obj_alpha_gsd_idc(routine,argument,
     1             data,nbyte,cnt)) goto 90
c
	elseif(type .eq. my_egsd$c_psc64) then
	  if(.not. fshelp_obj_alpha_gsd_psc64(routine,argument,
     1             data,nbyte,cnt)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-GSD',type,2)) goto 90
	  goto 90
	endif
	pos = pos + nbyte
	fshelp_obj_alpha_gsd_sub = .true.
90	return
	end
c
	function fshelp_obj_alpha_gsd_psc(routine,argument,data,nbyte,cnt)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
	include '($egpsdef)'	
c
c Since vax fortran does not have the egps$v_alloc_64bit definition
c So we declare it ourselfs
c
	integer*4  my_EGPS$V_ALLOC_64BIT
	PARAMETER (my_EGPS$V_ALLOC_64BIT = 12)      ! Load in 64-bit space
	record /egpsdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_alpha_gsd_psc
c
	integer*4 nkw,k
	character*132 wrk
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wras
	integer*4 ana_wrac
c
	fshelp_obj_alpha_gsd_psc = .false.
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Program section definition','EGSD$C_PSC',
     1       nbyte,1)) goto 90
	wrk = 'Unknown'
	if(data.egps$b_align .eq.  0) wrk = 'Byte'
	if(data.egps$b_align .eq.  1) wrk = 'Word'
	if(data.egps$b_align .eq.  2) wrk = 'Longword'
	if(data.egps$b_align .eq.  3) wrk = 'Quadword'
	if(data.egps$b_align .eq.  4) wrk = 'Octaword'
	if(data.egps$b_align .eq.  9) wrk = 'Pagelet'
	if(data.egps$b_align .eq. 13) wrk = '8K Page'
	if(data.egps$b_align .eq. 16) wrk = '64K Page'
	if(.not. ana_wras(routine,argument,'Alignment',wrk(1:10),2))goto 90
c
	wrk = ' '
	nkw = 0
	k = data.egps$w_flags
	if(btest(k,egps$v_pic)) call add_str(nkw,wrk,'PIC,')
	if(btest(k,egps$v_lib)) call add_str(nkw,wrk,'LIB,')
	if(btest(k,egps$v_ovr)) call add_str(nkw,wrk,'OVR,')
	if(btest(k,egps$v_rel)) call add_str(nkw,wrk,'REL,')
	if(btest(k,egps$v_gbl)) call add_str(nkw,wrk,'GBL,')
	if(btest(k,egps$v_shr)) call add_str(nkw,wrk,'SHR,')
	if(btest(k,egps$v_exe)) call add_str(nkw,wrk,'EXE,')
	if(btest(k,egps$v_rd )) call add_str(nkw,wrk,'RD,')
	if(btest(k,egps$v_wrt)) call add_str(nkw,wrk,'WRT,')
	if(btest(k,egps$v_vec)) call add_str(nkw,wrk,'VEC,')
	if(btest(k,egps$v_nomod)) call add_str(nkw,wrk,'NOMOD,')
	if(btest(k,egps$v_com)) call add_str(nkw,wrk,'COM,')
c	if(btest(k,egps$v_alloc_64bit)) call add_str(nkw,wrk,'ALL64,')
	if(btest(k,my_egps$v_alloc_64bit)) call add_str(nkw,wrk,'ALL64,')
	if(nkw .gt. 0) nkw = nkw - 1
	if(.not. ana_wras(routine,argument,'Attribute flags',
     1               wrk(1:nkw),2)) goto 90
c
	if(.not. ana_wri4(routine,argument,'Allocation',
     1                    data.egps$l_alloc,2,.true.)) goto 90
c
	if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.egps$b_namlng,2)) goto 90
	fshelp_obj_alpha_gsd_psc = .true.
90	return
	end
	function fshelp_obj_alpha_gsd_sym(routine,argument,data,nbyte,cnt)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
	include '($egsydef)'	
	include '($esdfdef)'	
	include '($esrfdef)'	
	structure /werk/
	  union
	    map
	      record /esdfdef/ esdf
	    end map
	    map
	      record /esrfdef/ esrf
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_alpha_gsd_sym
c
	character*132 wrk
	integer*4 nkw,k
c
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wri4
	integer*4 ana_wrac
c
c The fortran compiler on VAX does not know the symbol
c egsy$v_quad_val, so we define it ourselves
c
	integer*4  my_egsy$v_quad_val
	parameter (my_egsy$v_quad_val = 7)
c
	fshelp_obj_alpha_gsd_sym = .false.

        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Global symbol specification','EGSD$C_SYM',
     1       nbyte,1)) goto 90
	k = data.esdf.esdf$w_flags
	nkw = 0
	wrk = ' '
	if(btest(k,egsy$v_weak)) call add_str(nkw,wrk,'WEAK,')
	if(btest(k,egsy$v_def)) call add_str(nkw,wrk,'DEF,')
	if(btest(k,egsy$v_rel)) call add_str(nkw,wrk,'REL,')
	if(btest(k,egsy$v_comm)) call add_str(nkw,wrk,'COMM,')
	if(btest(k,egsy$v_norm)) call add_str(nkw,wrk,'NORM,')
c	if(btest(k,egsy$v_quad_val)) call add_str(nkw,wrk,'QUADVAL,')
	if(btest(k,my_egsy$v_quad_val)) call add_str(nkw,wrk,'QUADVAL,')
	if(nkw .gt. 0) nkw = nkw - 1
	if(.not. ana_wras(routine,argument,'Symbol flags',
     1              wrk(1:nkw),2)) goto 90
c
	if(btest(k,egsy$v_def)) then
c
c Symbol definition
c
	  if(btest(k,egsy$v_norm)) then
	    if(.not. ana_wri4(routine,argument,'Psect',
     1             data.esdf.esdf$l_psindx,2,.false.)) goto 90
	    if(.not. ana_wri4(routine,argument,'Value',
     1               data.esdf.esdf$l_value,2,.true.)) goto 90
	    if(.not. ana_wri4(routine,argument,'Code address Psect',
     1             data.esdf.esdf$l_ca_psindx,2,.false.)) goto 90
	    if(.not. ana_wri4(routine,argument,'Code address',
     1             data.esdf.esdf$l_code_address,2,.true.)) goto 90
	  endif
c
	  if(.not. ana_wrac(routine,argument,'Symbol',
     1                 data.esdf.esdf$b_namlng,2)) goto 90
	else
c
c Symbol reference
c
	  if(.not. ana_wrac(routine,argument,'Symbol',
     1                 data.esrf.esrf$b_namlng,2)) goto 90
	endif
	fshelp_obj_alpha_gsd_sym = .true.
90	return
	end

	function fshelp_obj_alpha_gsd_idc(routine,argument,data,nbyte,cnt)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
	include '($eidcdef)'	
c
        structure /werk/
          union
            map
              record /eidcdef/ eidc
            end map
            map
              byte bdata(1)
            end map
          end union
        end structure
        record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_alpha_gsd_idc
c
	integer*4 nkw,k,l,pos
	character*132 wrk
	logical bindata
c
	integer*4 ana_wrhdr
	integer*4 ana_wrac
	integer*4 ana_wras
	integer*4 lib$extzv 
c
	fshelp_obj_alpha_gsd_idc = .false.

	if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Random identity check','EGSD$C_IDC',nbyte,1)) goto 90
        k = data.eidc.eidc$l_flags
        bindata = btest(k,eidc$v_binident)
        l = lib$extzv(eidc$v_idmatch,eidc$s_idmatch,k)
        wrk = 'Dunnow'
        if(l .eq. eidc$c_leq) wrk = 'Less-equal'
        if(l .eq. eidc$c_equal) wrk = 'Equal'
        if(.not. ana_wras(routine,argument,'Match',wrk(1:10),2)) goto 90
c       
        l = lib$extzv(eidc$v_errsev,eidc$s_errsev,k)
        wrk = 'Dunnow'
        if(l .eq. 0) wrk = 'Warning'
        if(l .eq. 1) wrk = 'Success'
        if(l .eq. 2) wrk = 'Error'
        if(l .eq. 3) wrk = 'Informational'
        if(l .eq. 4) wrk = 'Fatal'
        if(.not. ana_wras(routine,argument,'Error severity',
     1              wrk(1:12),2)) goto 90
c
	pos = %loc(data.eidc.eidc$b_namlng) - %loc(data) + 1
c
	if(.not. ana_wrac(routine,argument,'Entity name',
     1         data.bdata(pos),2)) goto 90
        k = zext(data.bdata(pos))
        pos = pos + k + 1
c
        if(bindata) then
          call lib$movc3(4,data.bdata(pos+1),k)
          l = lib$extzv(0,24,k)
          k = lib$extzv(23,8,k)
          call sys$fao('UL.!UL',nkw,wrk,%val(k),%val(l))
	  if(.not. ana_wras(routine,argument,'Ident',wrk(1:nkw),2)) goto 90
        else
	  if(.not. ana_wrac(routine,argument,'Ident',data.bdata(pos),2))
     1            goto 90
        endif
        k = zext(data.bdata(pos))
c
        pos = pos + k + 1
        if(.not. ana_wrac(routine,argument,'Name length',
     1        data.bdata(pos),2)) goto 90
c
	fshelp_obj_alpha_gsd_idc = .true.
90	return
	end

	function fshelp_obj_alpha_gsd_psc64(routine,argument,data,nbyte,cnt)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
c
c Since the vax fortran does not have the egps64 definitions
c We do not use the egpsdef, byut instead include the
c source directly
c	include '($egpsdef)'	
!*** MODULE $EGPSDEF ***
!DEC$ OPTIONS/NOWARN/ALIGN=(RECORDS=PACKED,COMMONS=PACKED)
 !
 !  EVAX GSD entry - 64-Bit P-section definition
 !
        PARAMETER EGPS64$M_PIC = '00000001'X
        PARAMETER EGPS64$M_LIB = '00000002'X
        PARAMETER EGPS64$M_OVR = '00000004'X
        PARAMETER EGPS64$M_REL = '00000008'X
        PARAMETER EGPS64$M_GBL = '00000010'X
        PARAMETER EGPS64$M_SHR = '00000020'X
        PARAMETER EGPS64$M_EXE = '00000040'X
        PARAMETER EGPS64$M_RD = '00000080'X
        PARAMETER EGPS64$M_WRT = '00000100'X
        PARAMETER EGPS64$M_VEC = '00000200'X
        PARAMETER EGPS64$M_NOMOD = '00000400'X
        PARAMETER EGPS64$M_COM = '00000800'X
        PARAMETER EGPS64$M_ALLOC_64BIT = '00001000'X
        PARAMETER EGPS64$K_NAME = '00000010'X
        PARAMETER EGPS64$C_NAME = '00000010'X
        STRUCTURE /EGPS64DEF/
            UNION
                MAP
                INTEGER*2 EGPS64$W_GSDTYP    ! Typ field
                END MAP
                MAP
                    ! unsupported type CHARACTER*0 EGPS64$T_START
                    INTEGER*2 %FILL
                END MAP
            END UNION
            INTEGER*2 EGPS64$W_SIZE              ! size of this EGPS
            BYTE      EGPS64$B_ALIGN             ! P-sect alignment
            BYTE      EGPS64$B_TEMP              ! pad for aligning
            UNION
                MAP
                INTEGER*2 EGPS64$W_FLAGS                 ! P-sect flags
                END MAP
                MAP
                    PARAMETER EGPS64$S_PIC = 1
                    PARAMETER EGPS64$V_PIC = 0           ! Position independent
                    PARAMETER EGPS64$S_LIB = 1
                    PARAMETER EGPS64$V_LIB = 1           ! From a shareable image
                    PARAMETER EGPS64$S_OVR = 1
                    PARAMETER EGPS64$V_OVR = 2           ! Overlaid memory allocation
                    PARAMETER EGPS64$S_REL = 1
                    PARAMETER EGPS64$V_REL = 3           ! Relocatable
                    PARAMETER EGPS64$S_GBL = 1
                    PARAMETER EGPS64$V_GBL = 4           ! Global scope
                    PARAMETER EGPS64$S_SHR = 1
                    PARAMETER EGPS64$V_SHR = 5           ! Shareable
                    PARAMETER EGPS64$S_EXE = 1
                    PARAMETER EGPS64$V_EXE = 6           ! Executable
                    PARAMETER EGPS64$S_RD = 1
                    PARAMETER EGPS64$V_RD = 7        ! Readable
                    PARAMETER EGPS64$S_WRT = 1
                    PARAMETER EGPS64$V_WRT = 8           ! Writeable
                    PARAMETER EGPS64$S_VEC = 1
                    PARAMETER EGPS64$V_VEC = 9           ! Vector psect
                    PARAMETER EGPS64$S_NOMOD = 1
                    PARAMETER EGPS64$V_NOMOD = 10    ! Not stored into
                    PARAMETER EGPS64$S_COM = 1
                    PARAMETER EGPS64$V_COM = 11              ! Associated with COMM sym
                    PARAMETER EGPS64$S_ALLOC_64BIT = 1
                    PARAMETER EGPS64$V_ALLOC_64BIT = 12        ! Load in 64-bit space
                BYTE %FILL (2)
                END MAP
            END UNION
            UNION
                MAP
                INTEGER*4 EGPS64$Q_ALLOC(2)          ! Length of this contribution
                END MAP
                MAP
                INTEGER*4 EGPS64$L_ALLOC                 !  Low Longword
                END MAP
            END UNION
            BYTE      EGPS64$B_NAMLNG        ! Length of p-sect name
            CHARACTER*31 EGPS64$T_NAME           ! Name field
        END STRUCTURE     ! EGPS64DEF
!DEC$ END OPTIONS

	record /egps64def/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_alpha_gsd_psc64
c
	integer*4 nkw,k
	character*132 wrk
c
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wrac
c
	fshelp_obj_alpha_gsd_psc64 = .false.
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      '64-bit program section definition','EGSD$C_PSC64',
     1       nbyte,1)) goto 90
	wrk = 'Unknown'
	if(data.egps64$b_align .eq.  0) wrk = 'Byte'
	if(data.egps64$b_align .eq.  1) wrk = 'Word'
	if(data.egps64$b_align .eq.  2) wrk = 'Longword'
	if(data.egps64$b_align .eq.  3) wrk = 'Quadword'
	if(data.egps64$b_align .eq.  4) wrk = 'Octaword'
	if(data.egps64$b_align .eq.  9) wrk = 'Pagelet'
	if(data.egps64$b_align .eq. 13) wrk = '8K Page'
	if(data.egps64$b_align .eq. 16) wrk = '64K Page'
	if(.not. ana_wras(routine,argument,'Alignment',wrk(1:10),2))goto 90
c
	wrk = ' '
	nkw = 0
	k = data.egps64$w_flags
	if(btest(k,egps64$v_pic)) call add_str(nkw,wrk,'PIC,')
	if(btest(k,egps64$v_lib)) call add_str(nkw,wrk,'LIB,')
	if(btest(k,egps64$v_ovr)) call add_str(nkw,wrk,'OVR,')
	if(btest(k,egps64$v_rel)) call add_str(nkw,wrk,'REL,')
	if(btest(k,egps64$v_gbl)) call add_str(nkw,wrk,'GBL,')
	if(btest(k,egps64$v_shr)) call add_str(nkw,wrk,'SHR,')
	if(btest(k,egps64$v_exe)) call add_str(nkw,wrk,'EXE,')
	if(btest(k,egps64$v_rd )) call add_str(nkw,wrk,'RD,')
	if(btest(k,egps64$v_wrt)) call add_str(nkw,wrk,'WRT,')
	if(btest(k,egps64$v_vec)) call add_str(nkw,wrk,'VEC,')
	if(btest(k,egps64$v_nomod)) call add_str(nkw,wrk,'NOMOD,')
	if(btest(k,egps64$v_com)) call add_str(nkw,wrk,'COM,')
	if(btest(k,egps64$v_alloc_64bit)) call add_str(nkw,wrk,'ALL64,')
	if(nkw .gt. 0) nkw = nkw - 1
	if(.not. ana_wras(routine,argument,'Attribute flags',
     1               wrk(1:nkw),2)) goto 90
c
	call sys$fao('!QL (%X!QX)',nkw,wrk,
     1         data.egps64$q_alloc,data.egps64$q_alloc)
	if(.not. ana_wras(routine,argument,'Allocation',wrk(1:nkw),2)) goto 90
c
	if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.egps64$b_namlng,2)) goto 90
	fshelp_obj_alpha_gsd_psc64 = .true.
90	return
	end
	function fshelp_obj_alpha_hdr(nb,data,routine,argument,rcnt)
	implicit none
	include '($emhdef)'
	integer*4 nb
	record /emhdef/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_hdr
c
	character*80 wrk
	integer*4 k,nk,pos
c
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 ana_wrerr
c
	fshelp_obj_alpha_hdr = .false.
c

	k = nb		!to prevent compiler warning
	if(    data.emh$w_hdrtyp .eq. emh$c_mhd) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Module header','EOBJ$C_EMH',
     1       data.emh$w_size,0)) goto 90
c
	  k = data.emh$b_strlvl
	  if(.not. ana_wri4(routine,argument,'Structure level',
     1             zext(data.emh$b_strlvl),1,.false.)) goto 90
c	  call sys$fao('  Structure level: !UL',nk,tmp,%val(k))
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
c
c	  k = data.emh$l_recsiz
	  if(.not. ana_wri4(routine,argument,'Maximum record size',
     1             data.emh$l_recsiz,1,.false.)) goto 90
c	  call sys$fao('  Maximum record size: !UL',nk,tmp,%val(k))
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
c
	  if(.not. ana_wrac(routine,argument,'Module name',
     1             data.emh$b_namlng,1)) goto 90
c	  call sys$fao('  Module name: "!AC"',nk,tmp,data.emh$b_namlng)
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
c
	  pos = data.emh$b_namlng+1
	  if(.not. ana_wrac(routine,argument,'Module version',
     1        %ref(data.emh$t_name(pos:pos)),1)) goto 90
	  k = ichar(data.emh$t_name(pos:pos))
c	  call sys$fao('  Module version: "!AS"',nk,tmp,
c     1        data.emh$t_name(pos+1:pos+k))
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
c
	  pos = pos + 1 + k
	  if(.not. ana_wras(routine,argument,'Creation date/time',
     1          data.emh$t_name(pos:pos+16),1)) goto 90
c	  call sys$fao('  Creation date/time: !AS',nk,tmp,
c     1        data.emh$t_name(pos:pos+16))
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
	elseif(data.emh$w_hdrtyp .eq. emh$c_lnm) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Language processor header','EOBJ$C_LNM',
     1       data.emh$w_size,0)) goto 90
	  goto 20
	elseif(data.emh$w_hdrtyp .eq. emh$c_src) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Source file header','EOBJ$C_ESRC',
     1       data.emh$w_size,0)) goto 90
	  goto 20
	elseif(data.emh$w_hdrtyp .eq. emh$c_ttl) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Title text header','EOBJ$C_TTL',
     1       data.emh$w_size,0)) goto 90
	  goto 20	  
	elseif(data.emh$w_hdrtyp .eq. emh$c_cpr) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Copyright header','EOBJ$C_CPR',
     1       data.emh$w_size,0)) goto 90
	  goto 20
	elseif(data.emh$w_hdrtyp .eq. emh$c_mtc) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Maintenance status header','EOBJ$C_MTC',
     1       data.emh$w_size,0)) goto 90
	  goto 20
	elseif(data.emh$w_hdrtyp .eq. emh$c_gtx) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'General text header','EOBJ$C_GTX',
     1       data.emh$w_size,0)) goto 90
	  goto 20
	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-HDR',
     1            zext(data.emh$w_hdrtyp),1)) goto 90
c	  write(tmp,1000) data.emh$w_hdrtyp
c1000	  format(i5)
c	  call routine(argument,'Alpha-HDR type '//tmp(1:5)//' unknown')
c	  goto 90
	endif
	goto 50
20	nk = data.emh$w_size - (%loc(data.emh$b_strlvl) - %loc(data))
	wrk = ' '
	call lib$movc3(nk,data.emh$b_strlvl,%ref(wrk))
	if(.not. ana_wras(routine,argument,'Info',wrk(1:nk),1)) goto 90
c	call sys$fao('  Info: "!AS"',nk,tmp,wrk(1:nk))	  
c	if(.not. routine(argument,tmp(1:nk))) goto 90
c
50	fshelp_obj_alpha_hdr = .true.
90	return
	end
	function fshelp_obj_alpha_tbt(nk1,data,routine,argument,rcnt)
	implicit none
	include '($etirdef)'
	integer*4 nk1
	structure /werk/
	  union
	    map
	      record /etirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_tbt
c
	integer*4 fshelp_obj_alpha_etir_sub
	integer*4 ana_wrhdr
c
	integer*4 nk,nb,pos,cnt
c
	fshelp_obj_alpha_tbt = .false.
c
	nk = nk1		!to prevent compiler warnings
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Traceback information','EOBJ$C_ETBT',
     1       data.data.etir$w_size,0)) goto 90
c
	nb  = data.data.etir$w_size
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_alpha_etir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_alpha_tbt = .true.
90	return
	end
	function fshelp_obj_alpha_etir(nk1,data,routine,argument,rcnt)
	implicit none
	include '($etirdef)'
	integer*4 nk1
	structure /werk/
	  union
	    map
	      record /etirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_alpha_etir
c
	integer*4 fshelp_obj_alpha_etir_sub
c
	integer*4 nk,nb,pos,cnt
c
	integer*4 ana_wrhdr
c
	fshelp_obj_alpha_etir = .false.
c
	nk = nk1		!to prevent compiler warnings
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Text information/relocation','EOBJ$C_ETIR',
     1       data.data.etir$w_size,0)) goto 90
c
	nb  = data.data.etir$w_size
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_alpha_etir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_alpha_etir = .true.
90	return
	end
	function fshelp_obj_alpha_etir_sub(data,pos,routine,argument,cnt)
	implicit none
c
	include '($etirdef)'
c
	structure /werk/
	  integer*2 type
	  integer*2 size
	  byte data(1)
	end structure
	record /werk/ data
	integer*4 pos
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_sub
c
	integer*4 type,nbyte
c
	logical fshelp_obj_alpha_etir_sta
	logical fshelp_obj_alpha_etir_sto
	logical fshelp_obj_alpha_etir_opr
	logical fshelp_obj_alpha_etir_ctl
	logical fshelp_obj_alpha_etir_stc
c
	fshelp_obj_alpha_etir_sub = .false.
	type  = data.type
	nbyte = data.size
c
	if(    type .ge. etir$c_minstacod .and. 
     1         type .le. etir$c_maxstacod) then
	  if(.not. fshelp_obj_alpha_etir_sta(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. etir$c_minstocod .and. 
     1         type .le. etir$c_maxstocod) then
	  if(.not. fshelp_obj_alpha_etir_sto(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. etir$c_minoprcod .and. 
     1         type .le. etir$c_maxoprcod) then
	  if(.not. fshelp_obj_alpha_etir_opr(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. etir$c_minctlcod .and. 
     1         type .le. etir$c_maxctlcod) then
	  if(.not. fshelp_obj_alpha_etir_ctl(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. etir$c_minstccod .and. 
     1         type .le. etir$c_maxstccod) then
	  if(.not. fshelp_obj_alpha_etir_stc(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	else
	  goto 90
	endif
	pos = pos + nbyte
	fshelp_obj_alpha_etir_sub = .true.
90	return
	end
	function fshelp_obj_alpha_etir_sta(type,nbyte,data,routine,
     1                    argument,cnt)
	implicit none
	include '($etirdef)'
c
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_sta
c
	character*132 tmp
	integer*4 nk
c
	integer*4 ana_wrhdr
	integer*4 ana_wrerr
	integer*4 ana_wri4
	integer*4 ana_wrtxt
	integer*4 ana_wrac
c
	fshelp_obj_alpha_etir_sta = .false.
	if(type .eq. etir$c_sta_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack global',
     1            'ETIR$C_STA_GBL',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,1))goto 90
c
	elseif(type .eq. etir$c_sta_lw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack longword',
     1            'ETIR$C_STA_LW',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Value',data,
     1                    1,.true.)) goto 90
	elseif(type .eq. etir$c_sta_qw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack Quadword',
     1            'ETIR$C_STA_QW',nbyte,1)) goto 90
	  call sys$fao('    Value: !UQ (%X!16XQ)',nk,tmp,data,data)
	  if(.not. ana_wrtxt(routine,argument,tmp(1:nk),2)) goto 90
	elseif(type .eq. etir$c_sta_pq) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + byte offset',
     1            'ETIR$C_STA_PQ',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Value',data(5),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Value',data(9),
     1                    2,.true.)) goto 90
	elseif(type .eq. etir$c_sta_li) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack literal',
     1            'ETIR$C_STA_LI',nbyte,1)) goto 90
c	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	elseif(type .eq. etir$c_sta_mod) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack module',
     1            'ETIR$C_STA_MOD',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	elseif(type .eq. etir$c_sta_ckarg) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack compare proc arg and stack for tru or false',
     1            'ETIR$C_STA_CKARG',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-ETIR-STA',
     1             type,1)) goto 90
	endif
	fshelp_obj_alpha_etir_sta = .true.
90	return
	end

	function fshelp_obj_alpha_etir_sto(type,nbyte,data,routine,
     1                 argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_sto
c
	include '($etirdef)'
c
	character*132 tmp
	integer*4 nk,tmpi4
C
	integer ana_wrblk
	integer ana_wrhdr
	integer ana_wri4
	integer ana_wrerr
	integer ana_wrtxt
	integer ana_wrac
c
	fshelp_obj_alpha_etir_sto = .false.
	if(    type .eq. etir$c_sto_b) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store byte',
     1            'ETIR$C_STO_B',nbyte,1)) goto 90
c	  tmpi4 = 0
c	  call lib$movc3(1,data,tmpi4)
c	  if(.not. ana_wri4(routine,argument,'Value',data,
c     1                    2,.true.)) goto 90
	elseif(type .eq. etir$c_sto_w) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store word',
     1            'ETIR$C_STO_W',nbyte,1)) goto 90
c	  tmpi4 = 0
c	  call lib$movc3(2,data,tmpi4)
c	  if(.not. ana_wri4(routine,argument,'Value',tmpi4,
c     1                   2,.true.)) goto 90
	elseif(type .eq. etir$c_sto_lw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store longword',
     1            'ETIR$C_STO_LW',nbyte,1)) goto 90
c	  if(.not. ana_wri4(routine,argument,'Value',data,
c     1                    2,.true.)) goto 90
	elseif(type .eq. etir$c_sto_qw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store quadword',
     1            'ETIR$C_STO_QW',nbyte,1)) goto 90
c	  call sys$fao('    Value: !UQ (%X!16XQ)',nk,tmp,data,data)
c	  if(.not. ana_wrtxt(routine,argument,tmp(1:nk),2)) goto 90
	elseif(type .eq. etir$c_sto_immr) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store immediate repeated',
     1            'ETIR$C_STO_IMMR',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1          'Store immediate repeated',data,2,.true.)) goto 90
	  if(.not. ana_wrblk(routine,argument,tmpi4,data(5),2)) goto 90
	elseif(type .eq. etir$c_sto_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store global',
     1            'ETIR$C_STO_GLB',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	elseif(type .eq. etir$c_sto_ca) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store code address',
     1            'ETIR$C_STO_CA',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	elseif(type .eq. etir$c_sto_rb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store relative branch',
     1            'ETIR$C_STO_RB',nbyte,1)) goto 90
	elseif(type .eq. etir$c_sto_ab) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store absolute branch',
     1            'ETIR$C_STO_AB',nbyte,1)) goto 90
	elseif(type .eq. etir$c_sto_off) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store offset to Psect',
     1            'ETIR$C_STO_OFF',nbyte,1)) goto 90
	elseif(type .eq. etir$c_sto_imm) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store immediate',
     1            'ETIR$C_STO_IMM',nbyte,1)) goto 90
	  call lib$movc3(4,data,tmpi4)
	  call sys$fao('Store immediate: !UL bytes',nk,tmp,%val(tmpi4))
	  if(.not. ana_wrtxt(routine,argument,tmp(1:nk),2)) goto 90
	  if(.not. ana_wrblk(routine,argument,tmpi4,data(5),2)) goto 90
c	elseif(type .eq. etir$c_sto_lp_psb) then
c	  call sys$fao('  !UL) Store LP with procedure signature '//
c     1                 ' (ETIR$C_STO_LP_PSB), '//
c     1              ' !UL bytes',nk,tmp,%val(cnt),%val(nbyte))
c	  if(.not. routine(argument,tmp(1:nk))) goto 90
c
	elseif(type .eq. etir$c_sto_br_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store branch global',
     1            'ETIR$C_STO_BR_GBL',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(5),
     1                    2,.true.)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Offset',data(9),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data(13),
     1                    2,.false.)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Offset',data(17),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(21),
     1                    2,.true.)) goto 90
	  if(.not. ana_wrac(routine,argument,'Symbol',data(25),1))goto 90
	elseif(type .eq. etir$c_sto_br_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store branch Psect+offset',
     1            'ETIR$C_STO_BR_PS',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(5),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(9),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data(13),
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(17),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(21),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Psect',data(25),
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(29),
     1                    2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,'Offset',data(33),
     1                    2,.true.)) goto 90
	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-ETIR-STO',
     1           type,1)) goto 90
	endif
	fshelp_obj_alpha_etir_sto = .true.
90	return
	end

	function fshelp_obj_alpha_etir_opr(type,nbyte,data,routine,
     1              argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_opr
c
	include '($etirdef)'
c
	integer*4 nk
c
	integer*4 ana_wrhdr
	integer*4 ana_wrerr
c
	nk = data(1)		!to prevent compiler warnings
	fshelp_obj_alpha_etir_opr = .false.
	if(    type .eq. etir$c_opr_nop) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'No-operation',
     1            'ETIR$C_OPR_NOP',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_add) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Add',
     1            'ETIR$C_OPR_ADD',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_sub) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Subtract',
     1            'ETIR$C_OPR_SUB',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_mul) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Multiply',
     1            'ETIR$C_OPR_MUL',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_div) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Divide',
     1            'ETIR$C_OPR_DIV',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_and) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'And',
     1            'ETIR$C_OPR_AND',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_ior) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Inclusive or',
     1            'ETIR$C_OPR_OR',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_eor) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Exclusive or',
     1            'ETIR$C_OPR_OR',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_neg) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Negate',
     1            'ETIR$C_OPR_NEG',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_com) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Complement',
     1            'ETIR$C_OPR_COM',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_insv) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Insert field',
     1            'ETIR$C_OPR_INSV',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_ash) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Arithmetic shift',
     1            'ETIR$C_OPR_ASH',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_ush) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Unsigned shift',
     1            'ETIR$C_OPR_USH',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_rot) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Rotate',
     1            'ETIR$C_OPR_ROT',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_sel) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Select',
     1            'ETIR$C_OPR_SEL',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_redef) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Redefine symbol top current location',
     1            'ETIR$C_OPR_REDEF',nbyte,1)) goto 90
	elseif(type .eq. etir$c_opr_dflit) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Define literal',
     1            'ETIR$C_OPR_DFLIT',nbyte,1)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-ETIR-OPR',
     1          type,1)) goto 90
	endif
	fshelp_obj_alpha_etir_opr = .true.
90	return
	end

	function fshelp_obj_alpha_etir_ctl(type,nbyte,data,routine,
     1                   argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_ctl
c
	include '($etirdef)'
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wrerr
c
	fshelp_obj_alpha_etir_ctl = .false.
c
	if(    type .eq. etir$c_ctl_setrb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Set relocation base','ETIR$C_CTL_SETRB',nbyte,1)) goto 90
	elseif(type .eq. etir$c_ctl_augrb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Augment relocation base','ETIR$C_CTL_AUGRB',
     1        nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Value',data,
     1        2,.true.)) goto 90
	elseif(type .eq. etir$c_ctl_dfloc) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Define location','ETIR$C_CTL_DFLOC',nbyte,1)) goto 90
	elseif(type .eq. etir$c_ctl_stloc) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Set location','ETIR$C_CTL_STLOC',nbyte,1)) goto 90
	elseif(type .eq. etir$c_ctl_stkdl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Stack defined location','ETIR$C_CTL_STKDL',
     1        nbyte,1)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-ETIR-CTL',
     1           type,1)) goto 90
	endif
	fshelp_obj_alpha_etir_ctl = .true.
90	return
	end

	function fshelp_obj_alpha_etir_stc(type,nbyte,data,routine,
     1                   argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_alpha_etir_stc
c
	include '($etirdef)'
c
	character*132 tmp
	integer*4 nk,k
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 ana_wras
	integer*4 ana_wrerr
c

	fshelp_obj_alpha_etir_stc = .false.
c
	if(    type .eq. etir$c_stc_lp) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond linkage pair',
     1       'ETIR$C_STC_LP',nbyte,1)) goto 90
	elseif(type .eq. etir$c_stc_lp_psb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond linkage pair + signature',
     1       'ETIR$C_STC_LP_PSB',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Conditional linkage index',data,2,.false.)) goto 90
	  if(.not. ana_wrac(routine,argument,
     1     'Symbol',data(5),2,.false.)) goto 90
	  k = data(5)
	  k = 5+k+1
	  k = data(k)
	  if(.not. ana_wri4(routine,argument,
     1     'Signature',k,2,.false.)) goto 90
	elseif(type .eq. etir$c_stc_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond global',
     1       'ETIR$C_STC_GBL',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Conditional linkage index',data,2,.false.)) goto 90
	  if(.not. ana_wrac(routine,argument,
     1     'Symbol',data(5),2,.false.)) goto 90
	elseif(type .eq. etir$c_stc_gca) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond code address',
     1       'ETIR$C_STC_GCA',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Conditional linkage index',data,2,.false.)) goto 90
	  if(.not. ana_wrac(routine,argument,
     1     'Symbol',data(5),2,.false.)) goto 90
	elseif(type .eq. etir$c_stc_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond Psect + Offset',
     1       'ETIR$C_STC_PS',nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Conditional linkage index',data,2,.false.)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Psect',data(5),2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Offset',data(9),2,.true.)) goto 90
	  if(.not. ana_wri4(routine,argument,
     1     'Offset',data(13),2,.true.)) goto 90
	elseif(type .eq. etir$c_stc_nop_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond NOP at global address',
     1       'ETIR$C_STC_NOP_GBL',nbyte,1)) goto 90
	  goto 10
	elseif(type .eq. etir$c_stc_nop_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond NOP at Psect+offset',
     1       'ETIR$C_STC_NOP_PS',nbyte,1)) goto 90
	  goto 20
	elseif(type .eq. etir$c_stc_bsr_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond BSR at global address',
     1       'ETIR$C_STC_BSR_GBL',nbyte,1)) goto 90
	  goto 10
	elseif(type .eq. etir$c_stc_bsr_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond BST at Psect+offset',
     1       'ETIR$C_STC_BSR_PS',nbyte,1)) goto 90
	  goto 20
	elseif(type .eq. etir$c_stc_lda_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond LDA at global address',
     1       'ETIR$C_STC_LDA_GBL',nbyte,1)) goto 90
	  goto 10
	elseif(type .eq. etir$c_stc_lda_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond LDA at Psect+offset',
     1       'ETIR$C_STC_LDA_PS',nbyte,1)) goto 90
	  goto 20
	elseif(type .eq. etir$c_stc_boh_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond BSR or Hint at global address',
     1       'ETIR$C_STC_BOH_GBL',nbyte,1)) goto 90
	  goto 10
	elseif(type .eq. etir$c_stc_boh_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond BSR or Hint at Psect+offset',
     1       'ETIR$C_STC_BOH_PS',nbyte,1)) goto 90
	  goto 20
	elseif(type .eq. etir$c_stc_nbh_gbl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1     'Store cond (NOP and BSR) or Hint at global address',
     1       'ETIR$C_STC_NBH_GBL',nbyte,1)) goto 90
	elseif(type .eq. etir$c_stc_nbh_ps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Store cond (NOP and BSR) or Hint at Psect+offset',
     1       'ETIR$C_STC_NMH_PS',nbyte,1)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Alpha-ETIR-STC',
     1               type,1))goto 90
	endif
	goto 90
c
c From a stc_xxx_gbl
c
10	if(.not. ana_wri4(routine,argument,
     1         'Conditional Linkage index',
     1         data,2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Psect',
     1         data(5),2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(9),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(13),2,.true.)) goto 90
	call lib$movc3(4,data(17),k)
	call sys$fao('%X!XL',nk,tmp,%val(k))
	if(.not. ana_wras(routine,argument,'Replacement instruction',
     1         tmp(1:nk),2)) goto 90
	if(.not. ana_wri4(routine,argument,'Psect',
     1         data(21),2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(25),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(29),2,.true.)) goto 90
	if(.not. ana_wrac(routine,argument,'Symbol',
     1         data(33),2)) goto 90
	goto 80
c
c from a stc_xxx_ps
c
20	if(.not. ana_wri4(routine,argument,'Linkage index',
     1         data,2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Psect',
     1         data(5),2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(9),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(13),2,.true.)) goto 90
	call lib$movc3(4,data(17),k)
	call sys$fao('%X!XL',nk,tmp,%val(k))
	if(.not. ana_wras(routine,argument,'Replacement instruction',
     1         tmp(1:nk),2)) goto 90
	if(.not. ana_wri4(routine,argument,'Psect',
     1         data(21),2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(25),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(29),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Psect',
     1         data(33),2,.false.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(37),2,.true.)) goto 90
	if(.not. ana_wri4(routine,argument,'Value',
     1         data(41),2,.true.)) goto 90
	goto 80
c
80	fshelp_obj_alpha_etir_stc = .true.
90	return
	end
