	subroutine fshelp_files_prelf(lbr_index,rfa,keyname,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
c
c Get admin data from elf library
c
	implicit none
	integer*4 lbr_index	!:i: ;library index
	character*(*) keyname	!:i: the keyname
	integer*4 rfa(2)	!:i: rfa of wanted module
	character*(*) modnam	!:o: modulename
	integer*4 nk_modnam	!:o: length of modname
	character*(*) version	!:o: version
	integer*4 nk_vers	!:o: length of version
	character*(*) date	!:o: insertion-date
	integer*4 nk_date	!:o: length of insertion date
c
	integer*4 istat
	integer*4 lbr$lookup_key
	integer*4 lbr$map_module
	integer*4 lbr$unmap_module
	integer*8 ret_adr,ret_len
c
c
c First try to map the object
c
	modnam = keyname
	nk_modnam = len(keyname)
	nk_vers = 0
	nk_date = 0
	istat = lbr$lookup_key(lbr_index,keyname,rfa)
	istat = lbr$map_module(lbr_index,ret_adr,ret_len,rfa)
	if(istat)then
	  call elf_get_note_data(%val(ret_adr),ret_len,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
	  istat = lbr$unmap_module(lbr_index,rfa)
	else
c	  call elf_signal_error(lun,istat,lib_index,rfa)
	endif
	return
c
	end
	subroutine elf_get_note_data(data,nb,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
c
	implicit none
	include 'elfdef.inc'
c
	record /elf64_ehdr/ data
	integer*4 nb
	character*(*) modnam	!:o: modulename
	integer*4 nk_modnam	!:o: length of modname
	character*(*) version	!:o: version
	integer*4 nk_vers	!:o: length of version
	character*(*) date	!:o: insertion-date
	integer*4 nk_date	!:o: length of insertion date
c
	integer*8 pos
	integer*4 k
	record /elf64_shdr/ sections(0:1)
	pointer (p_sections,sections)
c
	p_sections = %loc(data) + data.ehdr$q_e_shoff
c
c Get the pointer to the strings
c
	do k=0,data.ehdr$w_e_shnum-1
	  if(sections(k).shdr$l_sh_type .eq. shdr$k_sht_note) then
	    pos = sections(k).shdr$q_sh_offset + %loc(data)
	    call elf_process_note(pos,
     1         sections(k).shdr$q_sh_size,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
	    goto 90
	  endif
	end do
90	return
	end
	subroutine elf_process_note(p_note,nb,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
	implicit none
	integer*8 p_note
	integer*8 nb
c
	character*(*) modnam	!:o: modulename
	integer*4 nk_modnam	!:o: length of modname
	character*(*) version	!:o: version
	integer*4 nk_vers	!:o: length of version
	character*(*) date	!:o: insertion-date
	integer*4 nk_date	!:o: length of insertion date
	integer*8 bpos,size
c
	include 'elfdef.inc'
	record /elf64_nhdr/ header
	pointer (p_header, header)
c
	integer*4 k,nk
	integer*8 pos
c
	record /elf64_mhdr/ mhdr
	pointer (p_mhdr, mhdr)
c
c The note enbtry can have multiple note entries
c  we want the one with type vms_mhd
c  Set the pointer to the first
c
	p_header = p_note
10	if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_mhd) then
	  pos = p_header + sizeof(header)
c
c Skip first part
c
	  call elf_get_zero_string(%val(pos),modnam,nk_modnam,k)
	  call elf_round_up_to_8(k)
c
c The rest contains the mhd
c
	  p_mhdr = pos + k
c
c Copy the date
c
	  nk_date = min(len(date),sizeof(mhdr.mhdr$b_mh_create_date))
	  call lib$movc3(nk_date,mhdr.mhdr$b_mh_create_date,%ref(date))
c
c in the _name_version part are 2 zero terminated strings
c 1. The module name
c 2. The module version
c  Set the pointer to the start, and get the name
c
	  pos = %loc(mhdr.mhdr$b_mh_name_version)
	  call elf_get_zero_string(%val(pos),modnam,nk_modnam,k)
	  call elf_round_up_to_8(k)
c
c Now increment the pointer and get the version
c
	  pos = pos + k
	  call elf_get_zero_string(%val(pos),version,nk_vers,k)
c
c All done
c
	  goto 90
	endif
c
c Not the correct note type, try the next
c Add the sizes (rounded up to 8) and add them to the pointer
c
	nk = 0
	k = header.nhdr$q_nh_namesz	!size of first part
	call elf_round_up_to_8(k)
	nk = nk + k
	k = header.nhdr$q_nh_descsz	!szie of the second part
	call elf_round_up_to_8(k)
	nk = nk + k
	p_header = p_header + nk + sizeof(header)
	if(p_header .lt. p_note+nb) goto 10
c
90	return
	end
	subroutine elf_process_note_sh(p_note,nb,
     1         modnam,nk_modnam,
     1         version,nk_vers,
     1         date,nk_date)
	implicit none
	integer*8 p_note
	integer*8 nb
c
	character*(*) modnam	!:o: modulename
	integer*4 nk_modnam	!:o: length of modname
	character*(*) version	!:o: version
	integer*4 nk_vers	!:o: length of version
	character*(*) date	!:o: insertion-date
	integer*4 nk_date	!:o: length of insertion date
	integer*8 bpos,size
c
	include 'elfdef.inc'
	record /elf64_nhdr/ header
	pointer (p_header, header)
c
	integer*4 k,nk
	integer*8 pos,bindat
c
	record /elf64_mhdr/ mhdr
	pointer (p_mhdr, mhdr)
c
c The note enbtry can have multiple note entries
c  we want the one with type vms_mhd
c  Set the pointer to the first
c
	p_header = p_note
10	if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_imgnam) then
	  pos = p_header + sizeof(header)
c
c Skip first part, it contains the IPF/VMS header
c
	  call elf_get_zero_string(%val(pos),modnam,nk_modnam,k)
	  call elf_round_up_to_8(k)
c
c The rest contains the mhd
c
	  pos = pos + k
	  call elf_get_zero_string(%val(pos),modnam,nk_modnam,k)
	elseif(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_imgid) then
	  pos = p_header + sizeof(header)
c
c Skip first part, it contains the IPF/VMS header
c
	  call elf_get_zero_string(%val(pos),version,nk_vers,k)
	  call elf_round_up_to_8(k)
c
c The rest contains the mhd
c
	  pos = pos + k
	  call elf_get_zero_string(%val(pos),version,nk_vers,k)
	elseif(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_linktime) then
	  pos = p_header + sizeof(header)
c
c Skip first part, it contains the IPF/VMS header
c
	  call elf_get_zero_string(%val(pos),date,nk_date,k)
	  call elf_round_up_to_8(k)
c
c The rest contains the mhd
c
	  pos = pos + k
	  call lib$movc3(8,%val(pos),bindat)
	  call sys$fao('!17%D',nk_date,date,bindat)
	endif
c
c Not the correct note type, try the next
c Add the sizes (rounded up to 8) and add them to the pointer
c
	nk = 0
	k = header.nhdr$q_nh_namesz	!size of first part
	call elf_round_up_to_8(k)
	nk = nk + k
	k = header.nhdr$q_nh_descsz	!szie of the second part
	call elf_round_up_to_8(k)
	nk = nk + k
	p_header = p_header + nk + sizeof(header)
	if(p_header .lt. p_note+nb) goto 10
c
90	return
	end
 	function fshelp_obj_ia64(lbr_index,rfa,lun,full,raw)
c
c Get admin data from elf library
c
	implicit none
	integer*4 lbr_index	!:i: ;library index
	integer*4 rfa(2)	!:i: rfa of wanted module
	integer*4 lun
	logical*4 full
	logical raw
	integer*4 fshelp_obj_ia64
c
	integer*4 istat
	integer*4 lbr$map_module
	integer*4 lbr$unmap_module
	integer*8 ret_adr,ret_len
c
	character*80 line
	integer*4 nk
c
c First try to map the object
c
	istat = lbr$map_module(lbr_index,ret_adr,ret_len,rfa)
c	write(*,*) 'Result van map ',istat
	if(istat)then
	  if(raw) then
	    call sys$fao('Raw object data, length = !@UQ. (!@XQ)',
     1                   nk,line,ret_len,ret_len)
	    call elf_write_txt(lun,line(1:nk))
	    call elf_write_txt(lun,' ')
	    call elf_print_raw(lun,%val(ret_adr),0,ret_len)
	  else
	    call elf_get_data(%val(ret_adr),ret_len,lun,full)
	  endif
	  istat = lbr$unmap_module(lbr_index,rfa)
	else
	  call elf_signal_error(lun,istat,lbr_index,rfa)
	endif
	return
	fshelp_obj_ia64 = istat
	return
c
	end
	subroutine elf_signal_error(lun,istat,lbr_index,rfa)
	implicit none
c
	integer*4 lun
	integer*4 istat
	integer*4 lbr_index
	integer*4 rfa(2)
c
	character*132 line
	integer*4 nk,k
c
	integer*4 lbr$gl_substs
	external lbr$gl_substs
c
	integer*4 elf_show_substs
c
	call sys$fao('Error from lib$map_module, error = !8XL',
     1              nk,line,%val(istat))
	call vm_write_txt(lun,0,line(1:nk))
	call sys$fao('  lbr_index = !UL , rfa = !8XL !8XL',nk,line,
     1           %val(lbr_index),%val(rfa(1)),%val(rfa(2)))
	call vm_write_txt(lun,0,line(1:nk))
	k = elf_show_substs(lbr$gl_substs)
	call sys$fao('  lbr$gl_substs = !8XL',nk,line,%val(k))
	call vm_write_txt(lun,0,line(1:nk))
	return
	end
	function elf_show_substs(substs)
	implicit none
	integer*4 substs
	integer*4 elf_show_substs
c
	elf_show_substs = substs
	return
	end

	options /exte
	subroutine elf_get_data(data,nb,lun,full)
c
	implicit none
	include 'elfdef.inc'
	record /Elf64_Ehdr/ data
	integer*8 nb
	integer*4 lun
	logical full
c
	record /Elf64_Shdr/ sections(0:1)
	pointer (p_sections,sections)
c
	character*132 line
	integer*8 pos,string_location,size,pos_data,pos_1,pos_sym
	integer*8 pos_strtab
	integer*4 k,nk,k1,nk_name,nk1,l,unwind_entry
	character*40 name
	character*33 flags
	character*40 type
c
	if(data.ehdr$b_ei_mag0 .ne. EHDR$K_ELFMAG0 .or.
     1     data.ehdr$b_ei_mag1 .ne. EHDR$K_ELFMAG1 .or.
     1     data.ehdr$b_ei_mag2 .ne. EHDR$K_ELFMAG2 .or.
     1     data.ehdr$b_ei_mag3 .ne. EHDR$K_ELFMAG3) then
	  call elf_write_txt(lun,'Not OpenVMS IA64 (Elf format) object file')
	  goto 90
	endif
	call elf_write_txt(lun,'This is an OpenVMS IA64 (Elf format)'//
     1                          ' object file')
	call elf_write_txt(lun,' ')
c
	string_location = 0
	p_sections = %loc(data) + data.ehdr$q_e_shoff
	do k=0,data.ehdr$w_e_shnum-1
	  if(sections(k).shdr$l_sh_type .eq. shdr$k_sht_note) then
	    pos = %loc(data) + sections(k).shdr$q_sh_offset
	    size =  sections(k).shdr$q_sh_size
	    call elf_print_mhd(pos,size,lun,k)
	  elseif(k .eq. data.ehdr$w_e_shstrndx) then
	    string_location = %loc(data) + sections(k).shdr$q_sh_offset
	  elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_UNWIND ) then
	    unwind_entry = k
	  elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_SYMTAB) then
	    pos_sym = %loc(data)+sections(k).shdr$q_sh_offset
	    l = sections(k).shdr$l_sh_link
	    pos_strtab = %loc(data)+sections(l).shdr$q_sh_offset
	  endif
	end do
c
	call elf_write_txt(lun,'Elf Header Information, at file address 0.')
	call elf_write_txt(lun,' ')
c
	type = 'Invalid class'
	if(data.ehdr$b_ei_class .eq. ehdr$k_elfclass32) type = 'ELF-32'
	if(data.ehdr$b_ei_class .eq. ehdr$k_elfclass64) type = 'ELF-64'
	call elf_write_txt(lun,'  Class:                 '//type)
c
	name = 'Invalid encoding'
	if(data.ehdr$b_ei_data .eq. ehdr$k_elfdata2lsb) 
     1           name = 'Little-endian byte order'
	if(data.ehdr$b_ei_data .eq. ehdr$k_elfdata2msb) 
     1           name = 'Big endian byte order'
	call elf_write_txt(lun,'  Data:                  '//name)
c
	call sys$fao(           '  Elf Header Version:    !UB.',
     1      nk,line,%val(data.ehdr$b_ei_version))
	call elf_write_txt(lun,line(1:nk))
c
	type = '??inv os'
	if(data.ehdr$b_ei_osabi .eq. ehdr$k_elfosabi_openvms)
     1             type = 'OpenVMS'
	call elf_write_txt(lun,'  OS ABI:                '//type)
c
	call sys$fao(           '  OS ABI Version:        !UB.',
     1      nk,line,%val(data.ehdr$b_ei_abiversion))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'Invalid type'
	if(data.ehdr$w_e_type .eq. ehdr$k_et_rel) type ='Object'
	if(data.ehdr$w_e_type .eq. ehdr$k_et_exec) type ='Excecutable'
	call elf_write_txt(lun,'  Type:                  '//type)
c
	type = 'Invalid machine'
	if(data.ehdr$w_e_machine .eq. ehdr$k_em_ia_64) type = 'IA_64'
	call elf_write_txt(lun,'  Machine Architecture:  '//type)
c
	call sys$fao(           '  Elf File Version:      !UL.',nk,line,
     1           %val(data.ehdr$l_e_version))
	call elf_write_txt(lun,line(1:nk))
	call elf_write_txt(lun,' ')
c
	call sys$fao('SECTION SUMMARY      Table at file address !8XL, '//
     1               '!UL. sections, !UL. bytes each, '//
     1               '!UL. total bytes',
     1               nk,line,
     1               %val(data.ehdr$q_e_shoff),
     1               %val(data.ehdr$w_e_shnum),
     1               %val(data.ehdr$w_e_shentsize),
     1               %val(data.ehdr$w_e_shnum * 
     1                    data.ehdr$w_e_shentsize))
	call elf_write_txt(lun,line(1:nk))
	call elf_write_txt(lun,' ')
	call sys$fao('Number  Type                 Name                 '//
     1        '            File Address     File Size        Flags',
     1              nk,line)
	call elf_write_txt(lun,line(1:nk))
	do k=0,data.ehdr$w_e_shnum-1
	  pos = sections(k).shdr$l_sh_name + string_location
	  name = ' '
	  call elf_get_zero_string(%val(pos),name,nk,k1)
	  call elf_cvt_section_type(sections(k).shdr$l_sh_type,type,.false.)
	  call elf_cvt_section_flags(sections(k).shdr$q_sh_flags,flags)
	  call sys$fao('!5UL.  !20AS !32AS !@XQ !@XQ !AS',nk,line,
     1              %val(k),type,name,
     1               sections(k).shdr$q_sh_offset,
     1               sections(k).shdr$q_sh_size,flags)
	  call elf_write_txt(lun,line(1:nk))
	end do
	call elf_write_txt(lun,' ')
	call elf_write_txt(lun,
     1      'Key for Flags: W (Write), A (Alloc), '//
     1      'E (Execute), S (Strings), I (Info link), '//
     1      'L (Link order), O (OS-specific processing),')
	call elf_write_txt(lun,
     1      '               G (Group), Sho (Short), '//
     1      'Nrc (No recovery code), '//
     1      'Gbl (Global), Ovr (Overlaid), Shr (Shared), '//
     1      'Vec (Vector),')
	call elf_write_txt(lun,
     1      '               64b (Allocate 64bit address), '//
     1      'Pro (Protected)')
	call elf_write_txt(lun,' ')
c
c Check for full display
c
	if(full) then
	  call elf_print_header(lun,data,0)
	  do k=0,data.ehdr$w_e_shnum-1
	    call elf_write_txt(lun,' ')
c
c Init pointers
c
	    pos = sections(k).shdr$l_sh_name + string_location
	    pos_data = %loc(data) + sections(k).shdr$q_sh_offset
c
c Print out section header
c
	    name = ' '
	    call elf_get_zero_string(%val(pos),name,nk_name,k1)
c
	    call sys$fao('SECTION HEADER !UL. (!XW)',nk,line,%val(k),%val(k))
	    call elf_write_txt(lun,line(1:nk))
	    if(nk_name .gt. 0) call elf_write_txt(lun,'"'//name(1:nk_name)//'"')
c
	    call elf_print_section_header(lun,sections(k),
     1                 %loc(sections(k))-%loc(data),name(1:nk_name))
c
c Print out section data (header)
c
	    call elf_cvt_section_type(sections(k).shdr$l_sh_type,type,.true.)
	    nk = index(type,' ')-1
	    call sys$fao('SECTION DATA !UL. (!XW)   !AS  ',nk,line,
     1            %val(k),%val(k),type(1:nk))
c
c
	    if(sections(k).shdr$q_sh_size .eq. 0) then
	      call sys$fao('NO DATA IN THE FILE',nk1,line(nk+1:))
	    else
	      call sys$fao('!16@XQ (!@UQ.) bytes',nk1,line(nk+1:),
     1             sections(k).shdr$q_sh_size,sections(k).shdr$q_sh_size)
	    endif
	    call elf_write_txt(lun,line(1:nk+nk1))
	    if(nk_name .gt. 0) call elf_write_txt(lun,'"'//name(1:nk_name)//'"')
c
c Print out section data
c
	    if(sections(k).shdr$q_sh_size .eq. 0) goto 70
	    if    (sections(k).shdr$l_sh_type .eq. shdr$k_sht_null) then
	      call elf_write_txt(lun,' ')
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_PROGBITS) then
	      if(btest(sections(k).shdr$q_sh_flags,shdr$v_shf_execinstr)) then
c
c Machine code
c
	        pos = %loc(data) + sections(k).shdr$q_sh_offset
	        call elf_print_machinecode(lun,%val(pos),k,
     1             sections(k).shdr$q_sh_size,
     1             sections(k).shdr$q_sh_offset)
	      else
c	        if(name .eq. '.IA_64.unwind_info') then
c	          pos_1 = %loc(data) + sections(unwind_entry).shdr$q_sh_offset
c	          call elf_print_unwind_info(lun,pos_data,
c     1              sections(k).shdr$q_sh_size,
c     1             sections(k).shdr$q_sh_offset,%val(pos_1),
c     1             sections(unwind_entry).shdr$l_sh_link)
c	        else
	          call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	          call elf_print_raw(lun,%val(pos_data),
     1              sections(k).shdr$q_sh_offset,
     1              sections(k).shdr$q_sh_size)
c	        endif
	      endif
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_SYMTAB) then
	      l = sections(k).shdr$l_sh_link
	      call elf_print_symtab(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_size,k,
     1          sections(k).shdr$q_sh_offset,%val(pos_strtab),l,
     1          data.ehdr$w_e_shnum-1,sections,string_location)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_RELA) then
	      l = sections(k).shdr$l_sh_link
	      pos_1 = %loc(data)+sections(l).shdr$q_sh_offset
	      pos = %loc(data) + sections(k).shdr$q_sh_offset
	      call elf_print_relatab(lun,%val(pos),
     1          sections(k).shdr$q_sh_size,k,
     1          sections(k).shdr$l_sh_info,
     1          sections(k).shdr$q_sh_offset,%val(pos_1),l,
     1          data.ehdr$w_e_shnum-1,
     1          sections,string_location,data)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_HASH) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_DYNAMIC) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_NOTE) then
	      call elf_print_note(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size,k)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_NOBITS) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_REL) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_SHLIB) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_DYNSYM) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_INIT_ARRAY) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_FINI_ARRAY) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_PREINIT_ARRAY) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_GROUP) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_SYMTAB_SHNDX) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_TRACE ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_TIE_SIGNATURES) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_DEBUG ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_DEBUG_STR ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_LINKAGES ) then
	      call elf_print_linkages(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size,
     1          %val(pos_sym),%val(pos_strtab))
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_SYMBOL_VECTOR) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_VMS_FIXUP ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_LOPSREG ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_HIPSREG ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_EXT ) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_UNWIND ) then
	      call elf_print_unwind(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size,
     1          sections(k).shdr$l_sh_link,
     1          sections(k).shdr$l_sh_info,
     1          data.ehdr$w_e_shnum,
     1          sections,string_location)
	    elseif(sections(k).shdr$l_sh_type  .eq. SHDR$K_SHT_IA_64_PRIORITY_INIT) then
	      call elf_write_txt(lun,'Not yet implemented, dumping raw') 
	      call elf_print_raw(lun,%val(pos_data),
     1          sections(k).shdr$q_sh_offset,
     1          sections(k).shdr$q_sh_size)
	    endif
70	  end do
	endif
90	return
	end
	subroutine elf_print_mhd(p_note,size,lun,idx)
	implicit none
c
	include 'elfdef.inc'
	integer*8 p_note
	integer*4 size
	integer*4 lun
	integer*4 idx
c
	record /elf64_Nhdr/ header
	pointer (p_header,header)
cc
	record /elf64_mhdr/ mhd
	pointer (p_mhd,mhd)
c
	character*17 cdate,pdate
	character*80 name,version
	integer*8 pos
c
	character*80 line
	integer*4 nk,k
c
	call sys$fao('Module Identification Information,'//
     1           ' in note section !UL.',nk,line,%val(idx))
	call elf_write_txt(lun,line(1:nk))
	call elf_write_txt(lun,' ')
c
	p_header = p_note
10	if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_mhd) then
	  pos = p_header + sizeof(header)
	  call elf_get_zero_string(%val(pos),line,nk,k)
	  call elf_round_up_to_8(k)
	  p_mhd = pos + k
c
	  call lib$movc3(17,mhd.mhdr$b_mh_create_date,%ref(cdate))

	  call lib$movc3(17,mhd.mhdr$b_mh_patch_date,%ref(pdate))
	  pos = %loc(mhd.mhdr$b_mh_name_version)
	  call elf_get_zero_string(%val(pos),line,nk,k)
	  call elf_write_txt(lun,'  Module name:         "'//line(1:nk)//'"')
	  pos = pos + k
	  call elf_get_zero_string(%val(pos),line,nk,k)
	  call elf_write_txt(lun,'  Module version:      "'//line(1:nk)//'"')
c
	  call elf_write_txt(lun,'  Creation date/time:  '//cdate)
	  call elf_write_txt(lun,'  Patch date/time:     '//pdate)
c
	elseif(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_lnm) then
	  pos = p_header + sizeof(header)
	  call elf_get_zero_string(%val(pos),line,nk,k)
	  call elf_round_up_to_8(k)
	  pos = pos + k
	  call elf_get_zero_string(%val(pos),line,nk,k)
	  call elf_write_txt(lun,'  Language name:       "'//line(1:nk)//'"')
	endif
	nk = 0
	k = header.nhdr$q_nh_namesz
	call elf_round_up_to_8(k)
	nk = nk + k
c
	k = header.nhdr$q_nh_descsz
	call elf_round_up_to_8(k)
	nk = nk + k
	p_header = p_header + nk + sizeof(header)
c
	if(p_header .lt. p_note+size) goto 10
	call elf_write_txt(lun,' ')
	return
	end
	subroutine elf_get_zero_string(data,line,nk,k)
	implicit none
c
	byte data(*)
	character*(*) line
	integer*4 nk
	integer*4 k
c
	nk = 0
	k = 1
	do while(data(k) .ne. 0)
	  if(nk .lt. len(line)) then
	    nk = nk + 1
	    line(nk:nk) = char(data(k))
	  endif
	  k = k + 1
	end do
	return
	end
	subroutine elf_round_up_to_8(idx)
	implicit none

	integer*4 idx
c
	if(mod(idx,8) .ne. 0) idx = idx + 8 - mod(idx,8)
	return
	end
	options /exte
	subroutine elf_cvt_section_type(sec_type,type,full)
	implicit none
c
	integer*4 sec_type
	character*(*) type
	logical full
c
	include 'elfdef.inc'
	integer*4 nk
c
	type = ' '
	call sys$fao('typ !XL',nk,type,%val(sec_type))
c
	if(sec_type .eq. SHDR$K_SHT_NULL) type = 'NULL'
	if(sec_type .eq. SHDR$K_SHT_PROGBITS) type = 'PROGBITS'
	if(sec_type .eq. SHDR$K_SHT_SYMTAB) type = 'SYMTAB'
	if(sec_type .eq. SHDR$K_SHT_STRTAB) type = 'STRTAB'
	if(sec_type .eq. SHDR$K_SHT_RELA) type = 'RELA'
	if(sec_type .eq. SHDR$K_SHT_HASH) type = 'HASH'
	if(sec_type .eq. SHDR$K_SHT_DYNAMIC) type = 'DYNAMIC'
	if(sec_type .eq. SHDR$K_SHT_NOTE) type = 'NOTE'
	if(sec_type .eq. SHDR$K_SHT_NOBITS) type = 'NOBITS'
	if(sec_type .eq. SHDR$K_SHT_REL) type = 'REL'
	if(sec_type .eq. SHDR$K_SHT_SHLIB) type = 'SHLIB'
	if(sec_type .eq. SHDR$K_SHT_DYNSYM) type = 'DYNSYM'
	if(sec_type .eq. SHDR$K_SHT_UNUSED_12) type = 'UNUSED_12'
	if(sec_type .eq. SHDR$K_SHT_UNUSED_13) type = 'UNUSED_13'
	if(sec_type .eq. SHDR$K_SHT_INIT_ARRAY) type = 'INIT_ARRAY'
	if(sec_type .eq. SHDR$K_SHT_FINI_ARRAY) type = 'FINI_ARRAY'
	if(sec_type .eq. SHDR$K_SHT_PREINIT_ARRAY) type = 'PREINIT_ARRAY'
	if(sec_type .eq. SHDR$K_SHT_GROUP) type = 'GROUP'
	if(sec_type .eq. SHDR$K_SHT_SYMTAB_SHNDX) type = 'SYMTAB_SHNDX'
	if(sec_type .eq. SHDR$K_SHT_VMS_TRACE ) type = 'VMS_TRACE '
	if(sec_type .eq. SHDR$K_SHT_VMS_TIE_SIGNATURES) type = 'VMS_TIE_SIGNATURES'
	if(sec_type .eq. SHDR$K_SHT_VMS_DEBUG ) type = 'VMS_DEBUG '
	if(sec_type .eq. SHDR$K_SHT_VMS_DEBUG_STR ) type = 'VMS_DEBUG_STR '
	if(sec_type .eq. SHDR$K_SHT_VMS_LINKAGES ) type = 'VMS_LINKAGES '
	if(sec_type .eq. SHDR$K_SHT_VMS_SYMBOL_VECTOR) type = 'VMS_SYMBOL_VECTOR'
	if(sec_type .eq. SHDR$K_SHT_VMS_FIXUP ) type = 'VMS_FIXUP '
	if(sec_type .eq. SHDR$K_SHT_IA_64_LOPSREG ) type = 'IA_64_LOPSREG '
	if(sec_type .eq. SHDR$K_SHT_IA_64_HIPSREG ) type = 'IA_64_HIPSREG '
	if(sec_type .eq. SHDR$K_SHT_IA_64_EXT ) type = 'IA_64_EXT '
	if(sec_type .eq. SHDR$K_SHT_IA_64_UNWIND ) type = 'IA_64_UNWIND '
	if(sec_type .eq. SHDR$K_SHT_IA_64_PRIORITY_INIT) type = 'IA_64_PRIORITY_INIT'
	if(full) type = 'SHDR$K_SHT_'//type
	return
	end
	options /exte
	subroutine elf_cvt_section_flags(sec_flags,flags)
	implicit none
c
	include 'elfdef.inc'
	integer*8 sec_flags
	character*(*) flags
c
	flags = ' '
c
	call elf_check_flag(sec_flags,flags,shdr$v_shf_write,1,'W')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_alloc,2,'A')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_execinstr,3,'E')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_strings,4,'S')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_info_link,5,'I')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_link_order,6,'L')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_os_nonconforming,7,'O')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_group,8,'G')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_ia_64_short,9,'Sho')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_ia_64_norecov,12,'Nrc')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_global,15,'Gbl')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_overlaid,18,'Ovr')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_shared,21,'Shr')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_vector,24,'Vec')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_alloc_64bit,27,'64b')
	call elf_check_flag(sec_flags,flags,shdr$v_shf_vms_protected,30,'Pro')
	return
	end
	subroutine elf_check_flag(flags,text,flag,pos,insert)
	implicit none
c
	integer*8 flags
	character*(*) text
	integer*4 flag
	integer*4 pos
	character*(*) insert
c
	integer*4 nk,k
c
	nk = len(insert)
	if(btest(flags,flag)) then
	  text(pos:pos+nk-1) = insert
	else
	  do k=pos,pos+nk-1
	    text(k:k) = '-'
	  end do
	end if
	return
	end
	subroutine elf_print_section_header(lun,section,offset,name)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	record /elf64_shdr/ section
	integer*4 offset
	character*(*) name
c
	character*132 line,type
	integer*4 nk,nk1,offs
c
	character*(*) fao_str1
	parameter(fao_str1 = '!8XL !8XL  !30AS         !8XL  !6UL. !28AS !AS')
	character*(*) fao_str2
	parameter(fao_str2 = '!8XL !8XL  !30AS !16@XQ  !6@UQ. !28AS !AS') 
	character*(*) fao_str3
	parameter(fao_str3 = '!8XL !8XL  !30AS         !8XL          !28AS !AS' )
	character*(*) fao_str4
	parameter(fao_str4 = '!8XL !8XL  !30AS !16@XQ          !28AS !AS' )
c
c
	call sys$fao('Fileaddr Offset    Description                    Hex (<bitmask>)  '//
     1               'Decimal Interpretation                Field name',nk,line)
	call elf_write_txt(lun,line(1:nk))
 	call sys$fao('-------- ------    -----------                    ---------------  '//
     1               '------- --------------                ----------',nk,line)
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$l_sh_name) - %loc(section)
	call sys$fao(fao_str1,nk,line,
     1        %val(offset),%val(0),
     1        %descr('Name offset in .shstrtab:'),
     1        %val(section.shdr$l_sh_name),
     1        %val(section.shdr$l_sh_name),
     1        '"'//name//'"',
     1        %descr('shdr$l_sh_name'))
	call elf_write_txt(lun,line(1:nk))
c
	call elf_cvt_section_type(section.shdr$l_sh_type,type,.true.)
	nk1 = index(type,' ')-1
	offs = %loc(section.shdr$l_sh_name) - %loc(section)
c
	call sys$fao(fao_str3,nk,line,
     1        %val(offset+4),%val(4),
     1        %descr('Section type:'),
     1        %val(section.shdr$l_sh_type),
     1        type(1:nk1),
     1        %descr('shdr$l_sh_type'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$q_sh_flags) - %loc(section)
	call sys$fao(fao_str4,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Section flags:'),
     1        section.shdr$q_sh_flags,
     1        %descr(' '),
     1        %descr('shdr$l_sh_flags'))
	call elf_write_txt(lun,line(1:nk))
c
	call elf_cvt_section_flags_long(lun,section.shdr$q_sh_flags)
c
	offs = %loc(section.shdr$pq_sh_addr) - %loc(section)
	call sys$fao(fao_str4,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Section load address:'),
     1        section.shdr$pq_sh_addr,
     1        %descr('Not Used (Object file)'),
     1        %descr('shdr$pq_sh_addr'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$q_sh_offset) - %loc(section)
	call sys$fao(fao_str4,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Offset to section data:'),
     1        section.shdr$q_sh_offset,
     1        %descr(' '),
     1        %descr('shdr$q_sh_offset'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$q_sh_size) - %loc(section)
	call sys$fao(fao_str2,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Size of Section Data:'),
     1        section.shdr$q_sh_size,
     1        section.shdr$q_sh_size,
     1        %descr(' '),
     1        %descr('shdr$q_sh_size'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$l_sh_link) - %loc(section)
	call sys$fao(fao_str1,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Section link field:'),
     1        %val(section.shdr$l_sh_link),
     1        %val(section.shdr$l_sh_link),
     1        %descr('Associated Symbol Table'),
     1        %descr('shdr$l_sh_link'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$l_sh_info) - %loc(section)
	call sys$fao(fao_str1,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Section Info Field:'),
     1        %val(section.shdr$l_sh_info),
     1        %val(section.shdr$l_sh_info),
     1        %descr('Section being Modified'),
     1        %descr('shdr$l_sh_info'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$q_sh_addralign) - %loc(section)
	call sys$fao(fao_str2,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Alignment constraint:'),
     1        section.shdr$q_sh_addralign,
     1        section.shdr$q_sh_addralign,
     1        %descr(' '),
     1        %descr('shdr$q_sh_addralign'))
	call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(section.shdr$q_sh_entsize) - %loc(section)
	call sys$fao(fao_str2,nk,line,
     1        %val(offset+offs),%val(offs),
     1        %descr('Entry Size (if table):'),
     1        section.shdr$q_sh_entsize,
     1        section.shdr$q_sh_entsize,
     1        %descr(' '),
     1        %descr('shdr$q_sh_entsize'))
	call elf_write_txt(lun,line(1:nk))
	call elf_write_txt(lun,' ')
	return
	end
	subroutine elf_print_raw(lun,data,offset,size)
	implicit none
c
	integer*4 lun
	byte data(*)
	integer*8 offset
	integer*8 size
c
	character*132 line
	integer*8 rest
	integer*4 k,nb,bpos,idx,opos,apos
c
	rest = size
	idx = 0
	opos = 8*9 + 1 + 32 + 3
	line = ' '
c
	line(opos:opos+17) = 'FileAddr Offset  '
	call elf_write_txt(lun,line(1:opos+17))
	line(opos:opos+17) = '-------- ------  '
	call elf_write_txt(lun,line(1:opos+17))
c
5	line = ' '
	write(line(opos:opos+17),1001) offset+idx,idx
1001	format(z8.8,' ',z8.8)
	apos = opos - 34
	bpos = apos - 2
c	
	nb = min(32,rest)
	do k=1,nb
	  idx = idx + 1
	  write(line(bpos-2:bpos-1),1000) data(idx)
1000	  format(z2.2)
	  bpos = bpos - 2
	  if(mod(k,4) .eq. 0) bpos = bpos - 1
	  if(data(idx) .lt. 32 .or. data(idx) .gt. 126) then
	    line(apos:apos) = '.'
	  else
	    line(apos:apos) = char(data(idx))
	  endif
	  apos = apos + 1
	end do
	rest = rest - nb
	call elf_write_txt(lun,line(1:opos+17))
	if(rest .gt. 0) goto 5
	return
	end
	subroutine elf_print_note(lun,data,offset,size,snr)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	byte data(*)
	integer*8 offset
	integer*8 size
	integer*4 snr
c
	record /elf64_Nhdr/ header
	pointer (p_header,header)
c
	character*132 line
	integer*4 nk,iof,offs,idx,k,l
	integer*8 pos
	character*40 name
c
	record /elf64_mhdr/ mhd
	pointer (p_mhd,mhd)
c
	character*(*) fao_str
	parameter(fao_str =   '!8XL !8XL    !30AS !16@XQ  !6@UQ. !28AS !AS') 
	character*(*) fao_str1
	parameter (fao_str1 = '!8XL !8XL    !30AS !AS')
c
	call sys$fao('FileAddr Offset in Section !UL. (!XL)',
     1       nk,line,%val(snr),%val(snr))
	call elf_write_txt(lun,line(1:nk))
c
	do k=1,nk
	  line(k:k) = '-'
	end do
	call elf_write_txt(lun,line(1:nk))
c
	idx = 0
	offs = 0
	p_header = %loc(data)
10	offs = p_header - %loc(data)
	if (offs .lt. size) then
	  call sys$fao('!8XL !8XL  Note entry !UL.',
     1         nk,line,%val(offset),%val(offs),%val(idx))
	  call elf_write_txt(lun,line(1:nk))
c
	  iof = %loc(header.nhdr$q_nh_namesz) - %loc(header)
	  call sys$fao(fao_str,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('Note Name Size'),
     1         header.nhdr$q_nh_namesz,
     1         header.nhdr$q_nh_namesz,
     1         %descr(' '),
     1         %descr('nhdr$q_nh_namesz'))
	  call elf_write_txt(lun,line(1:nk))
c
	  iof = %loc(header.nhdr$q_nh_descsz) - %loc(header)
	  call sys$fao(fao_str,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('Note Descriptor Size'),
     1         header.nhdr$q_nh_descsz,
     1         header.nhdr$q_nh_descsz,
     1         %descr(' '),
     1         %descr('nhdr$q_nh_descsz'))
	  call elf_write_txt(lun,line(1:nk))
c
	  name = '??'
	  if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_mhd)
     1          name = 'NT_VMS_MHD'
	  if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_lnm)
     1          name = 'NT_VMS_LNM'
	  iof = %loc(header.nhdr$q_nh_type) -%loc(header)
	  call sys$fao(fao_str,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('Note Type'),
     1         header.nhdr$q_nh_type,
     1         header.nhdr$q_nh_type,
     1         name(1:10),
     1         %descr('nhdr$q_nh_type'))
	  call elf_write_txt(lun,line(1:nk))
c
	  iof = sizeof(header)
	  pos = %loc(header) + iof
	  call elf_get_zero_string(%val(pos),name,nk,k)
	  call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('Note Name:'),name(1:nk))
	  call elf_write_txt(lun,line(1:nk))
c
	  k = header.nhdr$q_nh_namesz
	  call elf_round_up_to_8(k)
	  iof = iof + k
	  call sys$fao('!8XL !8XL    !30AS',nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('Descriptor:'))
	  call elf_write_txt(lun,line(1:nk))

	  p_mhd = %loc(header) + iof
	  if(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_mhd) then
	    call lib$movc3(17,mhd.mhdr$b_mh_create_date,%ref(name))
	    call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('  Creation Date/Time'),
     1         name(1:17))
	    call elf_write_txt(lun,line(1:nk))
c
	    iof = iof + 17
	    call lib$movc3(17,mhd.mhdr$b_mh_patch_date,%ref(name))
	    call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('  Last Patch Date/Time'),
     1         name(1:17))
	    call elf_write_txt(lun,line(1:nk))
	    iof = iof + 17
c
	    pos = %loc(mhd.mhdr$b_mh_name_version)
	    call elf_get_zero_string(%val(pos),name,nk,k)
	    call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('  Module name:'),
     1         name(1:nk))
	    call elf_write_txt(lun,line(1:nk))
c
	    iof = iof + k
	    pos = pos + k
	    call elf_get_zero_string(%val(pos),name,nk,k)
	    call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('  Module Version:'),
     1         name(1:nk))
	    call elf_write_txt(lun,line(1:nk))
	  elseif(header.nhdr$q_nh_type .eq. nhdr$k_nt_vms_lnm) then
	    call elf_get_zero_string(mhd,name,nk,k)
	    call sys$fao(fao_str1,nk,line,
     1         %val(offset+iof),%val(offs+iof),
     1         %descr('  Language Name:'),name(1:nk))
	    call elf_write_txt(lun,line(1:nk))
	  endif
	  k = header.nhdr$q_nh_namesz
	  call elf_round_up_to_8(k)
	  l = header.nhdr$q_nh_descsz
	  call elf_round_up_to_8(l)
	  p_Header = p_Header + k + l + sizeof(header)
	  call elf_write_txt(lun,' ')
	  idx = idx + 1
	  goto 10
	end if
	return
	end
	options /exte
	subroutine elf_cvt_section_flags_long(lun,sec_flags)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	integer*8 sec_flags
c
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_write,'Data is writeable','shdr$v_shf_write')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_alloc,'Data occupies memory','shdr$v_shf_alloc')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_execinstr,'Machine instructions','shdr$v_shf_execinstr')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_strings,'String section','shdr$v_shf_strings')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_info_link,'Section index present','shdr$v_shf_info_link')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_link_order,'Link order','shdr$v_shf_link_order')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_os_nonconforming,'NonConfirming','shdr$v_shf_os_nonconforming')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_group,'Memeber of Group-section','shdr$v_shf_group')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_ia_64_short,'Short data section',
     1                                 'Short data section','shdr$v_shf_ia_64_short')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_ia_64_norecov,' ','shdr$v_shf_ia_64_norecov')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_vms_global,' ','shdr$v_shf_vms_global')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_vms_overlaid,' ','shdr$v_shf_vms_overlaid')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_vms_shared,' ','shdr$v_shf_vms_shared')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_vms_vector,' ','shdr$v_shf_vms_vector')
	call elf_check_flag_l(lun,sec_flags,shdr$v_shf_vms_alloc_64bit,' ','shdr$v_shf_vms_alloc_64bit')
	callelf_ check_flag_l(lun,sec_flags,shdr$v_shf_vms_protected,' ','shdr$v_shf_vms_protected')
	return
	end
	subroutine elf_check_flag_l(lun,mask,flag,name1,name)
	implicit none
c
	integer*4 lun
	integer*8 mask
	integer*4 flag
	character*(*) name1
	character*(*) name
c
	character*132 line
	integer*4 nk
	integer*8 mskval,idx
	character*50 name3
	character*50 nameup
c
	if(btest(mask,flag)) then
	  mskval = 1
	  mskval = ishft(mskval,flag)
	  name3 = name1
	  if(name3 .eq. ' ') name3 = name(12:)
	  call str$upcase(nameup,name)
	  call sys$fao('                     !28AS<!16@XQ>         !28AS !AS',
     1             nk,line,name3,mskval,nameup,name)
	  call elf_write_txt(lun,line(1:nk))
	endif
	return
	end
	options /exte
	subroutine elf_print_header(lun,header,offset)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	record /elf64_ehdr/ header
	integer*4 offset
c
	character*(*) fao_str1
	parameter(fao_str1 = '!8XL !8XL  !30AS         !8XL  !6UL. !28AS !AS')
	character*(*) fao_str2
	parameter(fao_str2 = '!8XL !8XL  !30AS !16@XQ  !6@UQ. !28AS !AS') 
	character*(*) fao_str3
	parameter(fao_str3 = '!8XL !8XL  !30AS         !8XL          !28AS !AS' )
	character*(*) fao_str4
	parameter(fao_str4 = '!8XL !8XL  !30AS !16@XQ          !28AS !AS' )
	character*(*) fao_str5
	parameter(fao_str5 = '!8XL !8XL  !30AS               !2XB  !6UB. !28AS !AS')
	character*(*) fao_str6
	parameter(fao_str6 = '!8XL !8XL  !30AS             !4XW  !6UW. !28AS !AS')
c
	character*132 line
	integer*4 nk,offs,temp
	character*40 name,type
c
	call elf_write_txt(lun,'ELF HEADER')
	
	call sys$fao('Fileaddr Offset    Description                    Hex (<bitmask>)  '//
     1               'Decimal Interpretation                Field name',nk,line)
	call elf_write_txt(lun,line(1:nk))
 	call sys$fao('-------- ------    -----------                    ---------------  '//
     1               '------- --------------                ----------',nk,line)
	call elf_write_txt(lun,line(1:nk))
c
	call sys$fao('!8AS !8AS  !30AS !16AS !8AS !28AS !AS',
     1               nk,line,
     1               %descr(' '),
     1               %descr(' '),
     1               %descr('Elf Identification'),
     1               %descr(' '),
     1               %descr(' '),
     1               %descr(' '),
     1               %descr('ehrd$t_e_ident'))
	call elf_write_txt(lun,line(1:nk))
c
	call lib$movc3(4,header.ehdr$b_ei_mag0,temp)
	name = '".'//char(header.ehdr$b_ei_mag1)//
     1       char(header.ehdr$b_ei_mag2)//
     1       char(header.ehdr$b_ei_mag3)//'"'
	offs = %loc(header.ehdr$b_ei_mag0) -%loc(header)
	call sys$fao(fao_str3,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  Magic Number:'),
     1         %val(temp),
     1         name(1:6),
     1         %descr('ehdr$b_ei_mag[0-3]'))
	  call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(header.ehdr$b_ei_class) -%loc(header)
	name = '??unkonwn'
	type = 'Invalid class'
	if(header.ehdr$b_ei_class .eq. ehdr$k_elfclass32) type = 'EHDR$K_ELFCLASS32'
	if(header.ehdr$b_ei_class .eq. ehdr$k_elfclass64) type = 'EHDR$K_ELFCLASS64'

	call sys$fao(fao_str5,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  File Class:'),
     1         %val(header.ehdr$b_ei_class),
     1         %val(header.ehdr$b_ei_class),
     1         type,
     1         %descr('ehdr$b_ei_class'))
	call elf_write_txt(lun,line(1:nk))
c
	name = 'Invalid encoding'
	if(header.ehdr$b_ei_data .eq. ehdr$k_elfdata2lsb) 
     1           name = 'EHDR$K_ELFDATALSB'
	if(header.ehdr$b_ei_data .eq. ehdr$k_elfdata2msb) 
     1           name = 'EHDR$K_ELFDATAMSB'
	offs = %loc(header.ehdr$b_ei_data) -%loc(header)
	call sys$fao(fao_str5,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  Data Encoding:'),
     1         %val(header.ehdr$b_ei_data),
     1         %val(header.ehdr$b_ei_data),
     1         name,
     1         %descr('ehdr$b_ei_data'))
	  call elf_write_txt(lun,line(1:nk))
c
	offs = %loc(header.ehdr$b_ei_version) -%loc(header)
	name = 'EHDR$K_EV_CURRENT'
	call sys$fao(fao_str5,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  Elf Header Version:'),
     1         %val(header.ehdr$b_ei_version),
     1         %val(header.ehdr$b_ei_version),
     1         name,
     1         %descr('ehdr$b_ei_version'))
	  call elf_write_txt(lun,line(1:nk))
c
	type = '??inv os'
	if(header.ehdr$b_ei_osabi .eq. ehdr$k_elfosabi_openvms)
     1             type = 'EHDR$K_ELFOSABI_OPENVMS'
	offs = %loc(header.ehdr$b_ei_osabi) -%loc(header)
	call sys$fao(fao_str5,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  OS Application Binary Interface:'),
     1         %val(header.ehdr$b_ei_osabi),
     1         %val(header.ehdr$b_ei_osabi),
     1         type,
     1         %descr('ehdr$b_ei_osabi'))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'EHDR$K_ELFBIVERSION_VMS_OBJ'
	offs = %loc(header.ehdr$b_ei_abiversion) -%loc(header)
	call sys$fao(fao_str5,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('  OS ABI Version:'),
     1         %val(header.ehdr$b_ei_abiversion),
     1         %val(header.ehdr$b_ei_abiversion),
     1         type,
     1         %descr('ehdr$b_ei_abiversion'))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'Invalid type'
	if(header.ehdr$w_e_type .eq. ehdr$k_et_rel) type ='EHDR$K_ET_REL'
	if(header.ehdr$w_e_type .eq. ehdr$k_et_exec) type ='EHDR$K_ET_EXEC'
	offs = %loc(header.ehdr$w_e_type) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Elf Object Type:'),
     1         %val(header.ehdr$w_e_type),
     1         %val(header.ehdr$w_e_type),
     1         type,
     1         %descr('ehdr$w_e_type'))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'EHDR$K_IA_64'
	offs = %loc(header.ehdr$w_e_machine) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Machine Architecture:'),
     1         %val(header.ehdr$w_e_machine),
     1         %val(header.ehdr$w_e_machine),
     1         type,
     1         %descr('ehdr$w_e_machine'))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'EHDR$K_EV_CURRENT'
	offs = %loc(header.ehdr$l_e_version) -%loc(header)
	call sys$fao(fao_str1,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Elf File Version:'),
     1         %val(header.ehdr$l_e_version),
     1         %val(header.ehdr$l_e_version),
     1         type,
     1         %descr('ehdr$l_e_version'))
	call elf_write_txt(lun,line(1:nk))
c
	type = 'Not Used (Object File)'
	offs = %loc(header.ehdr$pq_e_entry) -%loc(header)
	call sys$fao(fao_str4,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Entry Virtual Address:'),
     1         header.ehdr$pq_e_entry,
     1         type,
     1         %descr('ehdr$pq_e_entry'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$q_e_phoff) -%loc(header)
	call sys$fao(fao_str2,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Program Header Offset:'),
     1         header.ehdr$q_e_phoff,
     1         header.ehdr$q_e_phoff,
     1         type,
     1         %descr('ehdr$q_e_phoff'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$q_e_shoff) -%loc(header)
	call sys$fao(fao_str2,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Section Header Offset:'),
     1         header.ehdr$q_e_shoff,
     1         header.ehdr$q_e_shoff,
     1         type,
     1         %descr('ehdr$q_e_shoff'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$l_e_flags) -%loc(header)
	call sys$fao(fao_str3,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Elf Header Flags:'),
     1         %val(header.ehdr$l_e_flags),
     1         type,
     1         %descr('ehdr$l_e_flags'))
	call elf_write_txt(lun,line(1:nk))
c
	call elf_print_header_flags_full(lun,header.ehdr$l_e_flags)
c
	type = ' '
	offs = %loc(header.ehdr$w_e_ehsize) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Size of Elf Header:'),
     1         %val(header.ehdr$w_e_ehsize),
     1         %val(header.ehdr$w_e_ehsize),
     1         type,
     1         %descr('ehdr$w_e_ehsize'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$w_e_phentsize) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Size of Earch Program Header:'),
     1         %val(header.ehdr$w_e_phentsize),
     1         %val(header.ehdr$w_e_phentsize),
     1         type,
     1         %descr('ehdr$w_e_phentsize'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$w_e_phnum) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Count of Program Header Entries:'),
     1         %val(header.ehdr$w_e_phnum),
     1         %val(header.ehdr$w_e_phnum),
     1         type,
     1         %descr('ehdr$w_e_phnum'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$w_e_shentsize) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Size of Each Section Header:'),
     1         %val(header.ehdr$w_e_shentsize),
     1         %val(header.ehdr$w_e_shentsize),
     1         type,
     1         %descr('ehdr$w_e_shentsize'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$w_e_shnum) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Count of Section Header Entries:'),
     1         %val(header.ehdr$w_e_shnum),
     1         %val(header.ehdr$w_e_shnum),
     1         type,
     1         %descr('ehdr$w_e_shnum'))
	call elf_write_txt(lun,line(1:nk))
c
	type = ' '
	offs = %loc(header.ehdr$w_e_shstrndx) -%loc(header)
	call sys$fao(fao_str6,nk,line,
     1         %val(offset+offs),%val(offs),
     1         %descr('Section Name String Table Index:'),
     1         %val(header.ehdr$w_e_shstrndx),
     1         %val(header.ehdr$w_e_shstrndx),
     1         type,
     1         %descr('ehdr$w_e_shstrndx'))
	call elf_write_txt(lun,line(1:nk))
c
	return
	end
	subroutine elf_print_header_flags_full(lun,flags)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	integer*4 flags
c
	character*132 line
	integer*4 nk,k
c
	character*(*) fao_str1,fao_str2
c
	character*40 type
c
	parameter (fao_str1=
     1  '                     !28AS        <!8XL> !6UL. !28AS !AS')
	parameter (fao_str2=
     1  '                     !28AS        <!8XL>         !28AS !AS')
c
 	k = iand(flags,ehdr$m_ef_vms_comcod ) 
	if(k .eq. ehdr$k_vms_comcod_success) type = 'SUCCESS'
	if(k .eq. ehdr$k_vms_comcod_warning) type = 'WARNING'
	if(k .eq. ehdr$k_vms_comcod_error) type = 'ERROR'
	if(k .eq. ehdr$k_vms_comcod_abort) type = 'ABORT'
	type = 'EHDR$K_VMS_COMCOD_'//type
	call sys$fao(fao_str1,nk,line,
     1          %descr('Completion code:'),
     1          %val(ehdr$m_ef_vms_comcod),
     1          %val(k),
     1          type,
     1          %descr('ehdr$v_ef_vms_comcod'))
	call elf_write_txt(lun,line(1:nk))
c
	if(iand(flags,ehdr$m_ef_vms_linkages) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('VMS Linkages:'),
     1             %val(ehdr$m_ef_vms_linkages),
     1          %descr('EHDR$M_EF_VMS_LINKAGES'),
     1          %descr('ehdr$v_ef_vms_linkages'))
	  call elf_write_txt(lun,line(1:nk))
	endif
	if(iand(flags,ehdr$m_ef_ia_64_abi64 ) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('PL64 Programming Model:'),
     1             %val(ehdr$m_ef_ia_64_abi64),
     1          %descr('EHDR$M_EF_IA_64_ABI64'),
     1          %descr('ehdr$v_ef_ia_64_abi64'))
	  call elf_write_txt(lun,line(1:nk))
	endif
	if(iand(flags,ehdr$m_ef_ia_64_reducedfp) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('Reduced Floating Point Model:'),
     1             %val(ehdr$m_ef_ia_64_reducedfp),
     1          %descr('EHDR$M_EF_IA_64_REDUCEDFP'),
     1          %descr('ehdr$v_ef_ia_64_recucedfp'))
	  call elf_write_txt(lun,line(1:nk))
	endif
	if(iand(flags,ehdr$m_ef_ia_64_cons_gp ) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('Cons gp:'),
     1             %val(ehdr$m_ef_ia_64_cons_gp),
     1          %descr('EHDR$M_EF_IA_64_CONS_GP'),
     1          %descr('ehdr$v_ef_ia_64_cons_gp'))
	  call elf_write_txt(lun,line(1:nk))
	endif
	if(iand(flags,ehdr$m_ef_ia_64_nofd_cons_gp ) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('NoFD Cons GP:'),
     1             %val(ehdr$m_ef_ia_64_nofd_cons_gp),
     1          %descr('EHDR$M_EF_IA_64_NOFD_CONS_GP'),
     1          %descr('ehdr$v_ef_is_64_nofd_cons_gp'))
	  call elf_write_txt(lun,line(1:nk))
	endif
	if(iand(flags,ehdr$m_ef_ia_64_absolute ) .ne. 0) then
	  call sys$fao(fao_str2,nk,line,
     1          %descr('Absolute:'),
     1             %val(ehdr$m_ef_ia_64_absolute),
     1          %descr('EHDR$M_EF_IA_64_ABSOLUTE'),
     1          %descr('ehdr$v_ef_is_64_absolute'))
	  call elf_write_txt(lun,line(1:nk))
	endif
c
	type = '??unknown'
	k = iand(flags,ehdr$m_ef_ia_64_arch)
	k = ishft(k,-ehdr$v_ef_ia_64_arch)
	if(k .eq. ehdr$k_ef_ia_64_archversion) 
     1         type = 'EHDR$K_EF_IA_64_ARCHVERSION'
	call sys$fao(fao_str1,nk,line,
     1          %descr('Architecture Version:'),
     1          %val(ehdr$m_ef_ia_64_arch),
     1          %val(k),
     1          type,
     1          %descr('ehdr$v_ef_ia_64_arch'))
	call elf_write_txt(lun,line(1:nk))
c
	return
	end
	subroutine elf_print_symtab(lun,symtab,size,idx,offset,strtab,
     1       sec_str,n_secs,sections,string_location)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	record /elf64_sym/ symtab(0:*)
	integer*4 size
	integer*4 idx
	integer*4 offset
	integer*8 strtab
	integer*4 sec_str
	integer*4 n_secs
	record /Elf64_Shdr/ sections(0:1)
	integer*8 string_location
c
	integer*4 nsymb,k,nk
	character*132 line
c
	call sys$fao('Fileaddr Offset in Section !UW. (!8XW)',
     1     nk,line,%val(idx),%val(idx))
	call elf_write_txt(lun,line(1:nk))
	do k=1,nk
	  line(k:k) = '-'
	enddo
	call elf_write_txt(lun,line(1:nk))
c
	nsymb = size/elf64_sym$k_st_size
c	
	do k=0,nsymb-1
	  call elf_print_symbtab_ent(lun,k,symtab(k),offset,
     1          %loc(symtab(k)) - %loc(symtab),strtab,sec_str,
     1          n_secs,sections,string_location)
	end do
	return
	end
	subroutine elf_print_symbtab_ent(lun,idx,symbol,offset,offs,strtab,
     1         sec_str,n_secs,sections,string_location)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	integer*4 idx
	record /elf64_sym/ symbol
	integer*4 offset
	integer*4 offs
	integer*4 strtab
	integer*4 sec_str
	integer*2 n_secs
	record /Elf64_Shdr/ sections(0:1)
	integer*8 string_location
c
	character*132 line
	character*40 name
	integer*8 pos
c
	integer*4 k,nk,nk1,iof
c
	call elf_write_txt(lun,' ')
	call sys$fao('!8XL !8XL  Symbol !UL. (!8XL)',
     1     nk,line,
     1      %val(offset+offs),%val(offs),
     1      %val(idx),%val(idx))
c
	line(nk+1:) = ' '
	nk = 50
	line(50:) = '"'
	if(symbol.symtab$l_st_name .ne. 0) then
	  pos = %loc(strtab) + symbol.symtab$l_st_name
	  call elf_get_zero_string(%val(pos),line(nk+1:),nk1,k)
	else
	  nk1 = 0
	endif
	nk = nk + nk1
	line(nk+1:nk+1) = '"'
	nk = nk + 1
	call elf_write_txt(lun,line(1:nk))
c
	call sys$fao('Name Index in Sec. !UL.:',nk1,name,%val(sec_str))
c
	iof = %loc(symbol.symtab$l_st_name) - %loc(symbol)
	call sys$fao('!8XL !8XL    !28AS          !8XL !6UL.',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        name(1:nk1),
     1       %val(symbol.symtab$l_st_name),
     1       %val(symbol.symtab$l_st_name))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(symbol.symtab$b_st_info)  - %loc(symbol)
	call sys$fao('!8XL !8XL    !28AS                !2XB         !28AS !AS',
     1        nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Symbol Info Field:'),
     1       %val(symbol.symtab$b_st_info),
     1       %descr(' '),
     1       %descr('symtab$b_st_info'))
	call elf_write_txt(lun,line(1:nk))
c
	k = iand(symbol.symtab$b_st_info,15)
	name = '??undefined'
	if(k .eq. symtab$k_stt_notype) name = 'STT_NOTYPE'
	if(k .eq. symtab$k_stt_object) name = 'STT_OBJECT'
	if(k .eq. symtab$k_stt_func) name = 'STT_FUNC'
	if(k .eq. symtab$k_stt_section) name = 'STT_SECTION'
	if(k .eq. symtab$k_stt_file) name = 'STT_FILE'
	if(k .eq. symtab$k_stt_common) name = 'STT_COMMON'
	if(k .eq. symtab$k_stt_tls) name = 'STT_TLS'
c
	call sys$fao('                     !28AS                !2XB'//
     1                   '         !28AS',
     1        nk,line,
     1        %descr('  Symbol Type:'),
     1       %val(k),name)
	call elf_write_txt(lun,line(1:nk))
c
	k = iand(symbol.symtab$b_st_info,'F0'X)
	k = ishft(k,-4)
	name = '??undefined'
	if(k .eq. symtab$k_stb_local) name = 'STB_LOCAL'
	if(k .eq. symtab$k_stb_global) name = 'STB_GLOBAL'
	if(k .eq. symtab$k_stb_weak) name = 'STB_WEAK'
	k = ishft(k,4)
c
	call sys$fao('                     !28AS                !2XB'//
     1                   '         !28AS',
     1        nk,line,
     1        %descr('  Symbol Binding:'),
     1       %val(k),name)
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(symbol.symtab$b_st_other)  - %loc(symbol)
	call sys$fao('!8XL !8XL    !28AS                !2XB         !28AS !AS',
     1          nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Symbol ''Other'' Field:'),
     1       %val(symbol.symtab$b_st_other),
     1       %descr(' '),
     1       %descr('symtab$b_st_other'))
	call elf_write_txt(lun,line(1:nk))
c
	k = iand(symbol.symtab$b_st_other,15)
	name = '??undefined'
	if(k .eq. symtab$k_stv_default) name = 'STV_DEFAULT'
	if(k .eq. symtab$k_stv_internal) name = 'STV_INTERNAL'
	if(k .eq. symtab$k_stv_hidden) name = 'STV_HIDDEN'
	if(k .eq. symtab$k_stv_protected) name = 'STV_PROTECTED'
c
	call sys$fao('                     !28AS                !2XB'//
     1                   '         !28AS',
     1        nk,line,
     1        %descr('  Symbol Visibility:'),
     1       %val(k),name)
	call elf_write_txt(lun,line(1:nk))
c

	k = iand(symbol.symtab$b_st_other,'C0'X)
	k = ishft(k,-6)
	name = '??undefined'
	if(k .eq. symtab$k_vms_stl_ignore) name = 'VMS_STL_IGNORE'
	if(k .eq. symtab$k_vms_stl_RESERVED) name = 'VMS_STL_RESERVED'
	if(k .eq. symtab$k_vms_stl_STD) name = 'VMS_STL_STD'
	if(k .eq. symtab$k_vms_stl_lnk) name = 'VMS_STL_LNK'
	k = ishft(k,6)
c
	call sys$fao('                     !28AS                !2XB'//
     1                   '         !28AS',
     1        nk,line,
     1        %descr('  Linkage Type:'),
     1       %val(k),name)
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(symbol.symtab$w_st_shndx)  - %loc(symbol)
	call elf_get_section_name(symbol.symtab$w_st_shndx,n_secs,sections,
     1                        name,string_location)
	call sys$fao('!8XL !8XL    !28AS              !4XW !6UW. !28AS !AS',
     1         nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Bound to Section:'),
     1       %val(symbol.symtab$w_st_shndx),
     1       %val(symbol.symtab$w_st_shndx),
     1       name,
     1       %descr('symtab$w_st_shndx'))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(symbol.symtab$pq_st_value)  - %loc(symbol)
	call sys$fao('!8XL !8XL    !28AS  !16@XQ !6@UQ. !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Symbol Value:'),
     1        symbol.symtab$pq_st_value,
     1        symbol.symtab$pq_st_value,
     1       %descr(' '),
     1       %descr('symtab$pq_st_value'))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(symbol.symtab$q_st_size)  - %loc(symbol)
	call sys$fao('!8XL !8XL    !28AS  !16@XQ         !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Size associated with sym:'),
     1        symbol.symtab$q_st_size,
     1       %descr(' '),
     1       %descr('symtab$b_st_size'))
	call elf_write_txt(lun,line(1:nk))
c
	return
	end
	subroutine elf_get_section_name(idx,n_Secs,sections,name,string_location)
	implicit none
c
	include 'elfdef.inc'
c
	integer*2 idx
	integer*2 n_secs
	record /Elf64_Shdr/ sections(0:1)
	character*(*) name
	integer*8 string_location
c
	integer*8 pos
	integer*4 nk,k
c
	name = '??undefined'
	if(idx .gt. 0 .and. idx .le. n_secs) then
	  pos = sections(idx).shdr$l_sh_name + string_location
	  call elf_get_zero_string(%val(pos),name,nk,k)
	  name = '"'//name(1:nk)//'"'
	else
	  if(idx .eq. shdr$k_shn_undef) name = '(SHDR$K_SHN_UNDEF)'
	  if(idx .eq. shdr$k_shn_abs)   name = '(SHDR$K_SHN_ABS)'
	endif
	return
	end
	subroutine elf_print_machinecode(lun,data,idx,size,offset)
	implicit none
c
	integer*4 lun
	integer*4 data(0:*)
	integer*4 idx
	integer*8 size
	integer*8 offset
c
	integer*4 ntriplet,k,pos,nk,mask
	integer*8 werk,maski
	character*50 naam,instr,typ
	character*132 line
c
	character*(*) masks
	parameter (masks = 'MII     MII;;   MI;;I   MI;;I;; '//  !0-3
     1                     'MLX     MLX;;   ?????   ?????   '//  !4-7
     2                     'MMI     MMI;;   M;;MI   M;;MI;; '//  !8-b
     2                     'MFI     MFI;;   MMF     MMF;;   '//  !c-f
     3                     'MIB     MIB;;   MBB;;   MBB;;   '//  !10-13
     5                     '?????   ??????  BBB     BBB;;   '//  !14-17
     6                     'MMB     MMB;;   ?????   ?????   '//  !18-1b
     7                     'MFB     MFB;;   ?????   ?????   ')
c
	call sys$fao('FileAddr Section  Offset      Template  '//
     1               'Instruction bundle                     '//
     1               'Instruction  Format',nk,line)
	call elf_write_txt(lun,line(1:nk))
	call sys$fao('-------- -------  ------      --------  '//
     1               '------------------                      '//
     1               '-----------  ------',nk,line)
	call elf_write_txt(lun,line(1:nk))
c
	ntriplet = size/16	
	pos= 0
	do k=1,ntriplet
c
c Mask : bit 0.4
c
	  mask = iand(data(pos),'1F'X)
	  call elf_substr(masks,mask,8,naam)
	  naam = '{ .'//naam
	  call sys$fao('!8XL !8XL !8XL  !10AS  !8XL.!8XL !8XL.!8XL',
     1       nk,line,%val(offset+pos*4),%val(idx),%val(pos*4),naam,
     1       %val(data(pos+3)),
     1       %val(data(pos+2)),
     1       %val(data(pos+1)),
     1       %val(data(pos+0)))
	  call elf_write_txt(lun,line(1:nk))
c
	  naam = ' '
c
c Instr 0 bit 5:45
c
	  call lib$movc3(8,data(pos),werk)
	  werk = ishft(werk,-5)
	  maski = '1ffffffffff'x
	  werk = iand(maski,werk)
	  call elf_convert_instr(werk,instr,typ)
	  call sys$fao('                    Slot 0  !10AS  !48AS !12@XQ !AS',
     1         nk,line,naam,instr,werk,typ(1:3))
	  call elf_write_txt(lun,line(1:nk))
c
c Instr 1 bit 46:86
c
	  call lib$movc3(8,data(pos+1),werk)
	  werk =  ishft(werk,-14)
	  werk = iand(maski,werk)
	  call elf_convert_instr(werk,instr,typ)
	  call sys$fao('                    Slot 1  !10AS  !48AS !12@XQ !AS',
     1         nk,line,naam,instr,werk,typ(1:3))
	  call elf_write_txt(lun,line(1:nk))
c
c Instr 2 bit 87:127
c
	  call lib$movc3(8,data(pos+2),werk)
	  werk = ishft(werk,-23)
	  werk = iand(maski,werk)
	  call elf_convert_instr(werk,instr,typ)
	  call sys$fao('                    Slot 2  !10AS  !48AS !12@XQ !AS',
     1         nk,line,naam,instr,werk,typ(1:3))
	  call elf_write_txt(lun,line(1:nk))
c
	  call sys$fao('                            }',nk,line)
	  call elf_write_txt(lun,line(1:nk))
c
	  pos = pos + 4
	end do
	return
	end
	subroutine elf_convert_instr(werk,instr,typ)
	implicit none
	integer*8 werk
	character*(*) instr
	character*(*) typ
c
	instr = ' '
	typ = ' '
	return
	end
	subroutine elf_substr(names,index,length,name)
	implicit none
c
	character*(*) names
	integer*4 index
	integer*4 length
	character*(*) name
c
	name = names(index*length+1:(index+1)*length)
	return
	end
	subroutine elf_print_relatab(lun,relatab,size,idx,info,
     1       offset,strtab,sec_str,n_secs,sections,string_location,
     1       data)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	record /elf64_rela64/ relatab(0:*)
	integer*4 size
	integer*4 idx
	integer*4 info
	integer*4 offset
	integer*8 strtab
	integer*4 sec_str
	integer*4 n_secs
	record /Elf64_Shdr/ sections(0:1)
	integer*8 string_location
	byte data
c
	integer*4 nrela,k,nk
	character*132 line
c
	call sys$fao('Fileaddr Offset in Section !UW. (!8XW)',
     1     nk,line,%val(idx),%val(idx))
	call elf_write_txt(lun,line(1:nk))
	do k=1,nk
	  line(k:k) = '-'
	enddo
c
	nrela = size/elf64_rela64$k_r_size
	call sys$fao('RELOCATION SECTION                  !UL. Relocations',
     1    nk,line,%val(nrela))
	call elf_write_txt(lun,line(1:nk))
c
c	
	do k=0,nrela-1
	  call elf_print_relatab_ent(lun,k,relatab(k),offset,info,
     1          %loc(relatab(k)) - %loc(relatab),strtab,sec_str,
     1          n_secs,sections,string_location,data)
	end do
	return
	end
	subroutine elf_print_relatab_ent(lun,idx,rela,offset,info,
     1         offs,strtab,sec_str,n_secs,sections,string_location,
     1         data)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	integer*4 idx
	record /elf64_rela64/ rela
	integer*4 offset
	integer*4 info
	integer*4 offs
	integer*4 strtab
	integer*4 sec_str
	integer*2 n_secs
	record /Elf64_Shdr/ sections(0:1)
	integer*8 string_location
	byte data
c
	character*132 line
	character*40 name
	integer*4 nk,iof,nk1,k
	integer*8 pos
c
	call sys$fao('                   Relocation entry !UL',
     1      nk,line,%val(idx))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(rela.rela$pq_r_offset) - %loc(rela)
	call sys$fao('Sec. !UL. Offset affected:',nk1,name,%val(info))
	call sys$fao('!8XL !8XL    !28AS !16@XQ         !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        name(1:nk1),
     1        rela.rela$pq_r_offset,
     1        %descr(' '),
     1        %descr('rela$pq_r_offset'))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(rela.rela$q_r_info) - %loc(rela)
	call sys$fao('!8XL !8XL    !28AS !16@XQ         !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Relocation Entry Info:'),
     1        rela.rela$q_r_info,
     1        %descr(' '),
     1        %descr('rela$q_r_info'))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(rela.rela$l_r_type) - %loc(rela)
	call elf_rela_type(rela.rela$l_r_type,name)
	call sys$fao('!8XL !8XL    !28AS         !8XL         !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('  Relocation Type:'),
     1        %val(rela.rela$l_r_type),
     1        name,
     1        %descr('rela$l_r_type'))
	call elf_write_txt(lun,line(1:nk))
c
	call sys$fao('  Sec. !UL. Sym Index:',nk1,name,%val(sec_str))
	iof = %loc(rela.rela$l_r_sym) - %loc(rela)
	call sys$fao('!8XL !8XL    !28AS         !8XL !6UL. !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        name(1:nk1),
     1        %val(rela.rela$l_r_sym),
     1        %val(rela.rela$l_r_sym),
     1        %descr(' '),
     1        %descr('rela$l_r_sym'))
	call elf_write_txt(lun,line(1:nk))
c
	pos = %loc(data) + sections(sec_str).shdr$q_sh_offset
	call elf_get_bound(rela.rela$l_r_sym,%val(pos),k)
	call elf_get_section_name(k,n_Secs,sections,name,string_location)
c
	call sys$fao('                     !28AS         !8XL !6UL. !28AS !AS',nk,line,
     1        %descr('  Symbol Bound to Section:'),
     1        %val(k),
     1        %val(k),
     1        name,
     1        %descr('rela$l_r_type'))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(rela.rela$q_r_addend) - %loc(rela)
	call sys$fao('!8XL !8XL    !28AS !16@XQ         !28AS !AS',nk,line,
     1        %val(offset+offs+iof),%val(offs+iof),
     1        %descr('Relocation Addend:'),
     1        rela.rela$q_r_addend,
     1        %descr(' '),
     1        %descr('rela$q_r_addend'))
	call elf_write_txt(lun,line(1:nk))
	return
	end
	options /exte
	subroutine elf_rela_type(typ,nam)
	implicit none
c
	include 'elfdef.inc'
	integer*4 typ
	character*(*) nam
c
	nam = '??unknown'
	if(typ .eq. RELA$K_R_IA_64_NONE) nam = 'NONE'
	if(typ .eq. RELA$K_R_IA_64_IMM14) nam = 'IMM14'
	if(typ .eq. RELA$K_R_IA_64_IMM22) nam = 'IMM22'
	if(typ .eq. RELA$K_R_IA_64_IMM64) nam = 'IMM64'
	if(typ .eq. RELA$K_R_IA_64_DIR32MSB) nam = 'DIR32MSB'
	if(typ .eq. RELA$K_R_IA_64_DIR32LSB) nam = 'DIR32LSB'
	if(typ .eq. RELA$K_R_IA_64_DIR64MSB) nam = 'DIR64MSB'
	if(typ .eq. RELA$K_R_IA_64_DIR64LSB) nam = 'DIR64LSB'
	if(typ .eq. RELA$K_R_IA_64_GPREL22) nam = 'GPREL22'
	if(typ .eq. RELA$K_R_IA_64_GPREL64I) nam = 'GPREL64I'
	if(typ .eq. RELA$K_R_IA_64_GPREL32MSB) nam = 'GPREL32MSB'
	if(typ .eq. RELA$K_R_IA_64_GPREL32LSB) nam = 'GPREL32LSB'
	if(typ .eq. RELA$K_R_IA_64_GPREL64MSB) nam = 'GPREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_GPREL64LSB) nam = 'GPREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF22) nam = 'LTOFF22'
	if(typ .eq. RELA$K_R_IA_64_LTOFF64I) nam = 'LTOFF64I'
	if(typ .eq. RELA$K_R_IA_64_PLTOFF22) nam = 'PLTOFF22'
	if(typ .eq. RELA$K_R_IA_64_PLTOFF64I) nam = 'PLTOFF64I'
	if(typ .eq. RELA$K_R_IA_64_PLTOFF64MSB) nam = 'PLTOFF64MSB'
	if(typ .eq. RELA$K_R_IA_64_PLTOFF64LSB) nam = 'PLTOFF64LSB'
	if(typ .eq. RELA$K_R_IA_64_FPTR64I) nam = 'FPTR64I'
	if(typ .eq. RELA$K_R_IA_64_FPTR32MSB) nam = 'FPTR32MSB'
	if(typ .eq. RELA$K_R_IA_64_FPTR32LSB) nam = 'FPTR32LSB'
	if(typ .eq. RELA$K_R_IA_64_FPTR64MSB) nam = 'FPTR64MSB'
	if(typ .eq. RELA$K_R_IA_64_FPTR64LSB) nam = 'FPTR64LSB'
	if(typ .eq. RELA$K_R_IA_64_PCREL60B) nam = 'PCREL60B'
	if(typ .eq. RELA$K_R_IA_64_PCREL21B) nam = 'PCREL21B'
	if(typ .eq. RELA$K_R_IA_64_PCREL21M) nam = 'PCREL21M'
	if(typ .eq. RELA$K_R_IA_64_PCREL21F) nam = 'PCREL21F'
	if(typ .eq. RELA$K_R_IA_64_PCREL32MSB) nam = 'PCREL32MSB'
	if(typ .eq. RELA$K_R_IA_64_PCREL32LSB) nam = 'PCREL32LSB'
	if(typ .eq. RELA$K_R_IA_64_PCREL64MSB) nam = 'PCREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_PCREL64LSB) nam = 'PCREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR22) nam = 'LTOFF_FPTR22'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR64I) nam = 'LTOFF_FPTR64I'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR32MSB) nam = 'LTOFF_FPTR32MSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR32LSB) nam = 'LTOFF_FPTR32LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR64MSB) nam = 'LTOFF_FPTR64MSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_FPTR64LSB) nam = 'LTOFF_FPTR64LSB'
	if(typ .eq. RELA$K_R_IA_64_SEGREL32MSB) nam = 'SEGREL32MSB'
	if(typ .eq. RELA$K_R_IA_64_SEGREL32LSB) nam = 'SEGREL32LSB'
	if(typ .eq. RELA$K_R_IA_64_SEGREL64MSB) nam = 'SEGREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_SEGREL64LSB) nam = 'SEGREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_SECREL32MSB) nam = 'SECREL32MSB'
	if(typ .eq. RELA$K_R_IA_64_SECREL32LSB) nam = 'SECREL32LSB'
	if(typ .eq. RELA$K_R_IA_64_SECREL64MSB) nam = 'SECREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_SECREL64LSB) nam = 'SECREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_REL32MSB) nam = 'REL32MSB'
	if(typ .eq. RELA$K_R_IA_64_REL32LSB) nam = 'REL32LSB'
	if(typ .eq. RELA$K_R_IA_64_REL64MSB) nam = 'REL64MSB'
	if(typ .eq. RELA$K_R_IA_64_REL64LSB) nam = 'REL64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTV32MSB) nam = 'LTV32MSB'
	if(typ .eq. RELA$K_R_IA_64_LTV32LSB) nam = 'LTV32LSB'
	if(typ .eq. RELA$K_R_IA_64_LTV64MSB) nam = 'LTV64MSB'
	if(typ .eq. RELA$K_R_IA_64_LTV64LSB) nam = 'LTV64LSB'
	if(typ .eq. RELA$K_R_IA_64_PCREL21BI) nam = 'PCREL21BI'
	if(typ .eq. RELA$K_R_IA_64_PCREL22) nam = 'PCREL22'
	if(typ .eq. RELA$K_R_IA_64_PCREL64I) nam = 'PCREL64I'
	if(typ .eq. RELA$K_R_IA_64_IPLTMSB) nam = 'IPLTMSB'
	if(typ .eq. RELA$K_R_IA_64_IPLTLSB) nam = 'IPLTLSB'
	if(typ .eq. RELA$K_R_IA_64_COPY) nam = 'COPY'
	if(typ .eq. RELA$K_R_IA_64_SUB) nam = 'SUB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF22X) nam = 'LTOFF22X'
	if(typ .eq. RELA$K_R_IA_64_LDXMOV) nam = 'LDXMOV'
	if(typ .eq. RELA$K_R_IA_64_TPREL14) nam = 'TPREL14'
	if(typ .eq. RELA$K_R_IA_64_TPREL22) nam = 'TPREL22'
	if(typ .eq. RELA$K_R_IA_64_TPREL64I) nam = 'TPREL64I'
	if(typ .eq. RELA$K_R_IA_64_TPREL64MSB) nam = 'TPREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_TPREL64LSB) nam = 'TPREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_TP22) nam = 'LTOFF_TP22'
	if(typ .eq. RELA$K_R_IA_64_DTPMOD64MSB) nam = 'DTPMOD64MSB'
	if(typ .eq. RELA$K_R_IA_64_DTPMOD64LSB) nam = 'DTPMOD64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_DTPMOD22) nam = 'LTOFF_DTPMOD22'
	if(typ .eq. RELA$K_R_IA_64_DTPREL14) nam = 'DTPREL14'
	if(typ .eq. RELA$K_R_IA_64_DTPREL22) nam = 'DTPREL22'
	if(typ .eq. RELA$K_R_IA_64_DTPREL64I) nam = 'DTPREL64I'
	if(typ .eq. RELA$K_R_IA_64_DTPREL32MSB) nam = 'DTPREL32MSB'
	if(typ .eq. RELA$K_R_IA_64_DTPREL32LSB) nam = 'DTPREL32LSB'
	if(typ .eq. RELA$K_R_IA_64_DTPREL64MSB) nam = 'DTPREL64MSB'
	if(typ .eq. RELA$K_R_IA_64_DTPREL64LSB) nam = 'DTPREL64LSB'
	if(typ .eq. RELA$K_R_IA_64_LTOFF_DTPREL22) nam = 'LTOFF_DTPREL22'
	if(typ .eq. RELA$K_R_IA_64_LOOS) nam = 'LOOS'
	if(typ .eq. RELA$K_R_IA_64_HIOS) nam = 'HIOS'
	if(typ .eq. RELA$K_R_IA_64_DIR8) nam = 'DIR8'
	if(typ .eq. RELA$K_R_IA_64_DIR16LSB) nam = 'DIR16LSB'
	if(typ .eq. RELA$K_R_IA_64_VMS_CALL_SIG) nam = 'VMS_CALL_SIG'
	if(typ .eq. RELA$K_R_IA_64_VMS_EXECLET_FUNC) nam = 'VMS_EXECLET_FUNC'
	if(typ .eq. RELA$K_R_IA_64_VMS_EXECLET_DATA) nam = 'VMS_EXECLET_DATA'
	if(typ .eq. RELA$K_R_IA_64_VMS_FIX8) nam = 'VMS_FIX8'
	if(typ .eq. RELA$K_R_IA_64_VMS_FIX16) nam = 'VMS_FIX16'
	if(typ .eq. RELA$K_R_IA_64_VMS_FIX32) nam = 'VMS_FIX32'
	if(typ .eq. RELA$K_R_IA_64_VMS_FIX64) nam = 'VMS_FIX64'
	if(typ .eq. RELA$K_R_IA_64_VMS_FIXFD) nam = 'VMS_FIXFD'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_LOAD) nam = 'VMS_ACC_LOAD'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_ADD) nam = 'VMS_ACC_ADD'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_SUB) nam = 'VMS_ACC_SUB'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_MUL) nam = 'VMS_ACC_MUL'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_DIV) nam = 'VMS_ACC_DIV'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_AND) nam = 'VMS_ACC_AND'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_IOR) nam = 'VMS_ACC_IOR'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_EOR) nam = 'VMS_ACC_EOR'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_ASH) nam = 'VMS_ACC_ASH'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_STO8) nam = 'VMS_ACC_STO8'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_STO16LSB) nam = 'VMS_ACC_STO16LSB'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_STO32LSB) nam = 'VMS_ACC_STO32LSB'
	if(typ .eq. RELA$K_R_IA_64_VMS_ACC_STO64LSB) nam = 'VMS_ACC_STO64LSB'
	return
	end
	subroutine elf_get_bound(symidx,symtable,k)
	implicit none
c
	include 'elfdef.inc'
	integer*4 symidx
	record /elf64_sym/ symtable(0:*)
	integer*4 k
c
	k = symtable(symidx).symtab$w_st_shndx
	return
	end
	options /exten
	subroutine elf_print_unwind(lun,data,offs,nb,
     1      link_idx,info_idx,n_secs,sections,string_location)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	record /IA_64_Unwind_entry/ data(*)
	integer*8 offs
	integer*8 nb
	integer*4 link_idx
	integer*4 info_idx
	integer*4 n_secs
	record /Elf64_Shdr/ sections(0:n_secs)
	integer*8 string_location
c
	integer*4 nk,k,iof,nrec
	character*132 line
	character*40 name
c
	nrec = nb/sizeof(data(1))
	line = ' '
	call sys$fao('Unwind Section     !UL. Elements',nk,line,%val(nrec))
	line (37:) ='Value are section offsets           '//
     1              'File values replaced by relocations'//
     1              ' when module is linked.'
	call elf_write_txt(lun,line(1:131))
c
	call sys$fao('                   Start, End offsets are in section!5UL.(!8XL)    ',
     1      nk,line,%val(link_idx),%val(link_idx))
	call elf_get_section_name(link_idx,n_secs,sections,
     1                        name,string_location)
	call elf_write_txt(lun,line(1:nk)//name)
c
	call sys$fao('                   Info offset is in section        !5UL.(!8XL)    ',
     1      nk,line,%val(info_idx),%val(info_idx))
	call elf_get_section_name(info_idx,n_secs,sections,
     1                        name,string_location)
	call elf_write_txt(lun,line(1:nk)//name)
c
	iof = 0
	call sys$fao('FileAddr Offset    File Start Value File End Value   File Info Value    '//
     1                                  'Relocated Start  Relocated End    Relocated Info',nk,line)

	call elf_write_txt(lun,line(1:nk))
	call sys$fao('-------- ------    ---------------- --------------   ---------------    '//
     1                                  '---------------  -------------    --------------',nk,line)

	call elf_write_txt(lun,line(1:nk))
	do k=1,nrec
	  iof = %loc(data(k)) - %loc(data)
	  call sys$fao('!8XL !8XL  !16@XQ !16@XQ !16@XQ   !16@XQ !16@XQ !16@XQ',
     1         nk,line,
     1         %val(offs+iof),%val(iof),
     1         data(k).unwind$pq_ue_start,
     1         data(k).unwind$pq_ue_end,
     1         data(k).unwind$pq_ue_info,
     1         data(k).unwind$pq_ue_start,
     1         data(k).unwind$pq_ue_end,
     1         data(k).unwind$pq_ue_info-data(1).unwind$pq_ue_info)
	  call elf_write_txt(lun,line(1:nk))
	end do
	return
	end
	options /exte
	subroutine elf_print_unwind_info(lun,p_data,size,offs,
     1            unw_tabl,link_info)
	implicit none
c
	include 'elfdef.inc'
c
	integer*4 lun
	integer*8 p_data
	integer*8 offs
	integer*8 size
	integer*4 link_info
	record /IA_64_Unwind_entry/ unw_tabl(0:*)
c
	record /exceptn_unwind/ unw_data
	pointer (p_unw_data,unw_data)
c
	byte rest_data(1)
	pointer (p_rest_data,rest_data)
c
	integer*8 iof,extra_data
	character*(*) fao_mask
	parameter (fao_mask = '                        <!4XW> !AS !AS')
c
	character*20 name
	character*6 header
	character*8 prologue
c
	character*(132) line
	integer*4 nk,k,idx,mask,ipos,incr,n_pad,extra
c
	idx = 0
	p_unw_data = p_data
10	if(p_unw_data .lt. p_data + size) then
	  extra = 0
	  call sys$fao('                   Unwind entry !UL. modifies section !UL. (!8XL)'//
     1               ' offsets !16@XQ to !16@XQ',
     1            nk,line,%val(idx),
     1           %val(link_info),%val(link_info),
     1           unw_tabl(idx).unwind$pq_ue_start,
     1           unw_tabl(idx).unwind$pq_ue_end)
	  call elf_write_txt(lun,line(1:nk))
c
	  iof = %loc(unw_data.unwind$l_unw_length) - p_data
	  call sys$fao('!8XL !8XL  Unwind Information Block Header Version !UW. '//
     1                 '!UL. quadwords (!UL. bytes)',nk,line,
     1                 %val(offs+iof),%val(iof),
     1                 %val(unw_data.unwind$w_unw_version),
     1                 %val(unw_data.unwind$l_unw_length),
     1                 %val(unw_data.unwind$l_unw_length*8))
	  call elf_write_txt(lun,line(1:nk))
c
	  call sys$fao('                     Flags !4XW',nk,line,%val(unw_data.unwind$w_unw_flags))
	  call elf_write_txt(lun,line(1:nk))
c
	  mask = ibset(0,unwind$v_unw_flag_ehandler-32)
	  if((unw_data.unwind$w_unw_flags .and. mask) .ne. 0) then
	    call sys$fao(fao_mask,nk,line,%val(mask),'Ehandler','FLAG_EHANDLER')
	    call elf_write_txt(lun,line(1:nk))
	  endif
	  mask = ibset(0,unwind$v_unw_flag_uhandler-32)
	  if((unw_data.unwind$w_unw_flags .and. mask) .ne. 0) then
	    call sys$fao(fao_mask,nk,line,%val(mask),'Uhandler','FLAG_UHANDLER')
	    call elf_write_txt(lun,line(1:nk))
	  endif
	  mask = ibset(0,unwind$v_unw_flag_vms_osda-32)
	  if((unw_data.unwind$w_unw_flags .and. mask) .ne. 0) then
	    call sys$fao(fao_mask,nk,line,%val(mask),'OpenVMS-specific Data Area Present',
     1                'FLAG_VMS_OSDA')
	    call elf_write_txt(lun,line(1:nk))
	    extra = 8
	  endif
	  mask = ibset(0,unwind$v_unw_flag_vms_handler-32)
	  if((unw_data.unwind$w_unw_flags .and. mask) .ne. 0) then
	    call sys$fao(fao_mask,nk,line,%val(mask),'OpenVMS-specific Handler Semantics Used',
     1                     'FLAG_VMS_HANDLER')
	    call elf_write_txt(lun,line(1:nk))
	  endif
c
	  p_rest_data = p_unw_data + sizeof(unw_data)
	  iof = p_rest_data - p_data
	  ipos = 1
	  prologue = ' '
	  do while(ipos .le. unw_data.unwind$l_unw_length*8)
	    incr = 1
	    header = 'Region'
	    if((rest_data(ipos) .and. unwind$m_hdr_mask) .eq. unwind$k_hdr_pattern) then
	      header = 'header'
	      if(prologue .eq. ' ') then
	        prologue = 'Prologue'
	      else
	        prologue = 'Body'
	      endif
	    endif
	    if(rest_data(ipos) .eq. 0) then
	      n_pad = 0
14	      n_pad = n_pad + 1
	      if(ipos .lt. unw_data.unwind$l_unw_length*8) then
	        if(rest_data(ipos+1) .eq. 0) then
	          ipos = ipos + 1
	          goto 14
	        endif
	      endif
	      name = ' '
	      call sys$fao('Padding !UL',k,name,%val(n_pad))
	    elseif((rest_data(ipos) .and. unwind$m_r1_mask) .eq. unwind$k_r1_pattern) then
	      name = 'R1 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_r2_mask) .eq. unwind$k_r2_pattern) then
	      name = 'R2 patroon'
	      incr = 2
	    elseif((rest_data(ipos) .and. unwind$m_r3_mask) .eq. unwind$k_r3_pattern) then
	      name = 'R3 patroon'
	      incr = 2
	    elseif((rest_data(ipos) .and. unwind$m_p1_mask) .eq. unwind$k_p1_pattern) then
	      name = 'P1 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p2_mask) .eq. unwind$k_p2_pattern) then
	      name = 'P2 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p3_mask) .eq. unwind$k_p3_pattern) then
	      name = 'P3 patroon'
	      incr = 2
	    elseif((rest_data(ipos) .and. unwind$m_p4_mask) .eq. unwind$k_p4_pattern) then
	      name = 'P4 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p5_mask) .eq. unwind$k_p5_pattern) then
	      name = 'P5 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p6_mask) .eq. unwind$k_p6_pattern) then
	      name = 'P6 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p7_mask) .eq. unwind$k_p7_pattern) then
	      name = 'P7 patroon'
	      incr = 2
	    elseif((rest_data(ipos) .and. unwind$m_p8_mask) .eq. unwind$k_p8_pattern) then
	      name = 'P8 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p9_mask) .eq. unwind$k_p9_pattern) then
	      name = 'P9 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_p10_mask) .eq. unwind$k_p10_pattern) then
	      name = 'P10 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_b1_mask) .eq. unwind$k_b1_pattern) then
	      name = 'B1 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_b2_mask) .eq. unwind$k_b2_pattern) then
	      name = 'B2 patroon'
	      incr = 2
	    elseif((rest_data(ipos) .and. unwind$m_b3_mask) .eq. unwind$k_b3_pattern) then
	      name = 'B3 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_b4_mask) .eq. unwind$k_b4_pattern) then
	      name = 'B4 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_x1_mask) .eq. unwind$k_x1_pattern) then
	      name = 'X1 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_x2_mask) .eq. unwind$k_x2_pattern) then
	      name = 'X2 patroon'
	      incr = 4
	    elseif((rest_data(ipos) .and. unwind$m_x3_mask) .eq. unwind$k_x3_pattern) then
	      name = 'X3 patroon'
	    elseif((rest_data(ipos) .and. unwind$m_x4_mask) .eq. unwind$k_x4_pattern) then
	      name = 'X4 patroon'
	    else
	      name = 'Padding'
	    end if
	    call sys$fao('!8XL !8XL  Byte data !8XB !AS !AS !AS',nk,line,
     1           %val(offs+iof),%val(iof),%val(rest_data(ipos)),
     1           name,prologue,header)
	    call elf_write_txt(lun,line(1:nk))
	    iof  = iof + incr
	    ipos = ipos + incr
	  end do
	  idx = idx + 1
	  if(extra .ne. 0) then
	    call lib$movc3(8,rest_data(ipos),extra_data)
	    call sys$fao('!8XL !8XL    VMS-specific data - General       !16@XQ',
     1         nk,line,
     1         %val(offs+iof),%val(iof),
     1         extra_data)
	    call elf_write_txt(lun,line(1:nk))
	  endif
	  p_unw_Data = p_unw_data + unw_data.unwind$l_unw_length*8 + 
     1                 sizeof(unw_data) + extra
	  goto 10
	end if
	return
	end
	options /exte
	subroutine elf_print_linkages(lun,data,offs,size,symtab,strtab)
	implicit none
c
	include 'elfdef.inc'
	integer*4 lun
	integer*8 offs
	record /vms_linkages_header/ data
	integer*8 size
	record /elf64_sym/ symtab(0:*)
	integer*8 strtab
c
	record /vms_lnkg_entry1/ entry
	pointer (p_entry,entry)
c
	character*40 name
	integer*4 idx,nk,nk1,k,l,nk_name
	logical set
	character*132 line
	integer*8 iof
	logical is_def
c
	integer*4 lib$extzv
c
	call elf_write_txt(lun,' ')
	call elf_write_txt(lun,'Key to linkage matrix conventions')
	call elf_write_txt(lun,'    S    Register uses standard linkage convention')
	call elf_write_txt(lun,'    R    Register uses required linkage convention (implies standard)')
	call elf_write_txt(lun,'    N    Register uses non-standard linkage convention')
	call elf_write_txt(lun,'    I    Register uses invalid linkage convention')
	call elf_write_txt(lun,' ')
c
	iof = %loc(data.lnkg$l_type) - %loc(data)
	call sys$fao('!8XL !8XL Entry 0                  Type:                            !12UL.',
     1               nk,line,%val(offs+iof),%val(iof),%val(data.lnkg$l_type))
	call elf_write_txt(lun,line(1:nk))
c
	iof = %loc(data.lnkg$l_decl_count) - %loc(data)
	call sys$fao('         !8XL                          Declaration entry count:         !12UL.',
     1               nk,line,%val(iof),%val(data.lnkg$l_decl_count))
	call elf_write_txt(lun,line(1:nk))
	idx = 1
	p_entry = %loc(data) + sizeof(data) + 4	!where is the 4??
	do while(p_entry .lt. %loc(data) + size)
	  iof = %loc(entry.lnkg_entry1$l_symidx) - %loc(data)
	  line = ' '
	  name = '(Reference)'
	  is_def = .false.
	  if(symtab(entry.lnkg_entry1$l_symidx).symtab$w_st_shndx .ne. 0) then
	    name = '(Definition)'
	    is_def = .true.
	  endif
	  call sys$fao('!8XL !8XL Entry !UL. !AS',
     1               nk,line,%val(offs+iof),%val(iof),%val(idx),name(1:12))
	  nk = 43
	  call sys$fao('Explicit linkage         Symbol index !8UL.   ',nk1,line(nk+1:),
     1                %val(entry.lnkg_entry1$l_symidx))
	  nk = nk + nk1
	  call elf_get_symbol_name(entry.lnkg_entry1$l_symidx,name,nk_name,
     1                 symtab,strtab)
	  line(nk+1:) = '"'//name(1:nk_name)//'"'
	  nk = nk + 2 + nk_name
	  call elf_write_txt(lun,line(1:nk))
c
	  iof = %loc(entry.lnkg_entry1$q_vms_linkage_qw) - %loc(data)
	  call sys$fao('         !8XL                          Descr quadword :         !16@XQ',
     1               nk,line,%val(iof),entry.lnkg_entry1$q_vms_linkage_qw)
	  call elf_write_txt(lun,line(1:nk))
c
	  line = ' '
	  k = lib$extzv(0,1,entry.lnkg_entry1$q_vms_linkage_qw)
	  if(k .eq. 0) then
	    line(19:30) = 'CALL Linkage'
	  else
	    line(19:30) = 'JSB Linkage'
	  endif
c
	  name = 'Provided'
	  if(is_def) name = 'Needed'
	  nk_name = index(name,' ')-1
c
	  k = lib$extzv(1*2,2,entry.lnkg_entry1$q_vms_linkage_qw)
	  if(k .eq. 0) then
	    line(44:65) = 'GP '//name(1:nk_name)//' (R1)'
	  else
	    line(44:65) = 'GP not '//name(1:nk_name)//' (R1)'
	  endif
c
	  k = lib$extzv(25*2,2,entry.lnkg_entry1$q_vms_linkage_qw)
          if(k .eq. 0) then
	    line(69:99) = 'AI '//name(1:nk_name)//' (R25)'
	  else
	    line(69:99) = 'AI not '//name(1:nk_name)//' (R25)'
	  endif
	  nk = 99
	  call elf_write_txt(lun,line(1:nk))
	  line = ' '
	  line(19:30) = 'Registers:'
	  nk1 = 32
	  do k=31,2,-1
	    if(k .ne. 25) then
	      call sys$fao('!2UL',nk,line(nk1:nk1+1),%val(k))
	      nk1 = nk1 + 3
	    end if
	  end do
	  call elf_write_txt(lun,line(1:nk1))
c
	  do l=0,3
	    line = ' '
	    if(l .eq. 0) then
	      line(19:30) = 'Volatile:'
	    elseif(l .eq. 1) then
	      line(19:30) = 'Scratch:'
	    elseif(l .eq. 2) then
	      line(19:30) = 'Output:'
	    else
	      line(19:30) = 'Preserved:'
	    endif
	    set = .false.
	    nk1 = 33
	    do k=31,2,-1
	      if(k .ne. 25) then
                if(lib$extzv(k*2,2,entry.lnkg_entry1$q_vms_linkage_qw) .eq. l) then
	          set = .true.	
                  line(nk1:nk1) = 'X'
	        else
                  line(nk1:nk1) = '-'
	        endif
	        nk1 = nk1 + 3
	      endif
	    end do
	    if(set) call elf_write_txt(lun,line(1:nk1))
	  enddo
	  idx = idx + 1
	  p_entry = p_entry + sizeof(entry)
	end do
	return
	end
	subroutine elf_get_symbol_name(idx,name,nk_name,symtab,strtab)
	implicit none
c
	include 'elfdef.inc'
	integer*4 idx
	character*(*) name
	integer*4 nk_name
	integer*8 pos
	record /elf64_sym/ symtab(0:*)
	integer*8 strtab
c
	integer*4 k
c
	if(symtab(idx).symtab$l_st_name .ne. 0) then
	  pos = %loc(strtab) + symtab(idx).symtab$l_st_name
	  call elf_get_zero_string(%val(pos),name,nk_name,k)
	else
	  nk_name = 0
	endif
	return
	end
	subroutine elf_write_txt(lun,line)
	implicit none
c
	integer*4 lun
	character*(*) line
c
	call vm_write_txt(lun,0,line)
	return
	end
	subroutine fshelp_files_test(lbr_index,keyname)
c
c Get admin data from elf library
c because of an error in lbr$map_module
c
	implicit none
	integer*4 lbr_index	!:i: ;library index
	character*(*) keyname	!:i: the keyname
c
	integer*4 istat
	integer*4 lbr$lookup_key
	integer*4 lbr$map_module
	integer*4 lbr$unmap_module
	integer*8 ret_adr,ret_len
c
	integer*4 rfa(2)
	character kar
c
	integer*4 lbr$gl_substs
	external lbr$gl_substs
c
c try to map the object
c
	istat = lbr$lookup_key(lbr_index,keyname,rfa)
	istat = lbr$map_module(lbr_index,ret_adr,ret_len,rfa)
	if(istat)then
	  istat = lbr$unmap_module(lbr_index,rfa)
	else
d	  write(*,1000) istat
d1000	  format('Result van map %x',z8.8)
d	  call show_it(lbr$gl_substs)
d          read(*,2000) kar
c2000	  format(a)
	endif
	return
c
	end

