	function fshelp_obj_vax_dbg(nb,data,routine,argument,rcnt)
	implicit none
	include '($tirdef)'
	integer*4 nb
	structure /werk/
	  union
	    map
	      record /tirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_dbg
c
	integer*4 pos,cnt
c
	integer ana_wrhdr
	integer*4 fshelp_obj_vax_tir_sub
c
	fshelp_obj_vax_dbg = .false.
c
	if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Debugger information','OBJ$C_DBG',nb,0)) goto 90
c
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_vax_tir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_vax_dbg = .true.
90	return
	end
	function fshelp_obj_vax_eom(nb,data,routine,argument,rcnt)
	implicit none
	include '($eomdef)'
	integer*4 nb
	record /eomdef/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_eom
c
	character*80 tmp
	integer*4 nk,k
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wras
c
	fshelp_obj_vax_eom = .false.
c
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'End of module header','OBJ$C_EOM',nb,0)) goto 90

	k = data.eom$b_comcod
	if(k .eq. eom$c_success) then
	  call sys$fao('Successful (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_warning) then
	  call sys$fao('Warning (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_error) then
	  call sys$fao('Error (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_abort) then
	  call sys$fao('Abort (!UL)',nk,tmp,%val(k))
	else
	  call sys$fao('Unknown (!UL)',nk,tmp,%val(k))
	endif
c
	if(.not. ana_wras(routine,argument,'Severity',tmp(1:nk),2)) goto 90
c
	if(nb .ge. eom$k_eommax) then
	  tmp = ' '

	  if(btest(zext(data.eom$b_tfrflg),eom$v_wktfr)) tmp = 'Weak'
	  if(.not. ana_wras(routine,argument,'Transfer address flags',
     1             tmp(1:4),2)) goto 90
	endif
	if(nb .ge. eom$k_eommx1) then
c
	  if(.not. ana_wri4(routine,argument,'Psect',
     1             zext(data.eom$b_psindx),2,.false.)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Value',
     1             data.eom$l_tfradr,2,.true.)) goto 90
	endif
	fshelp_obj_vax_eom = .true.
90	return
	end
	function fshelp_obj_vax_eomw(nb,data,routine,argument,rcnt)
	implicit none
	include '($eomdef)'
	include '($eomwdef)'
	integer*4 nb
	record /eomwdef/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_eomw
c
	character*80 tmp
	integer*4 k,nk
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wras
c
	fshelp_obj_vax_eomw = .false.
c
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'End of module header','OBJ$C_EOMW',nb,0)) goto 90

	k = data.eomw$b_comcod
	if(k .eq. eom$c_success) then
	  call sys$fao('Successful (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_warning) then
	  call sys$fao('Warning (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_error) then
	  call sys$fao('Error (!UL)',nk,tmp,%val(k))
	elseif(k .eq. eom$c_abort) then
	  call sys$fao('Abort (!UL)',nk,tmp,%val(k))
	else
	  call sys$fao('Unknown (!UL)',nk,tmp,%val(k))
	endif
c
	if(.not. ana_wras(routine,argument,'Severity',tmp(1:nk),2)) goto 90
c
	if(nb .ge. eom$k_eommax) then
	  tmp = ' '

	  if(btest(zext(data.eomw$b_tfrflg),eom$v_wktfr)) tmp = 'Weak'
	  if(.not. ana_wras(routine,argument,'Transfer address flags',
     1             tmp(1:4),2)) goto 90
	endif
	if(nb .ge. eom$k_eommx1) then
c
	  if(.not. ana_wri4(routine,argument,'Psect',
     1             zext(data.eomw$w_psindx),2,.false.)) goto 90
c
	  if(.not. ana_wri4(routine,argument,'Value',
     1             data.eomw$l_tfradr,2,.true.)) goto 90
	endif
	fshelp_obj_vax_eomw = .true.
90	return
	end
	function fshelp_obj_vax_gsd(nb,data,routine,argument,rcnt)
	implicit none
	include '($gsdef)'
	integer*4 nb
	structure /werk/
	  union
	    map
	      record /gsdef/ gsd
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_gsd
c
	integer*4 pos,cnt
c
	integer*4 fshelp_obj_vax_gsd_sub
	integer*4 ana_wrhdr
c
	fshelp_obj_vax_gsd = .false.
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Global symbol directory','OBJ$C_GSD',nb,0)) goto 90
c
	pos = %loc(data.gsd.gsd$b_gsdtyp) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_vax_gsd_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_vax_gsd = .true.
90	return
	end
	function fshelp_obj_vax_gsd_sub(data,pos,routine,argument,cnt)
	implicit none
c
	include '($gsdef)'
	byte data(*)

	integer*4 pos
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_sub
c
	integer*4 type,nbyte
c
	integer*4 ana_wrerr
c
	integer*4 fshelp_obj_vax_gsd_psc
	integer*4 fshelp_obj_vax_gsd_sym
	integer*4 fshelp_obj_vax_gsd_epm
	integer*4 fshelp_obj_vax_gsd_pro
	integer*4 fshelp_obj_vax_gsd_symw
	integer*4 fshelp_obj_vax_gsd_epmw
	integer*4 fshelp_obj_vax_gsd_prow
	integer*4 fshelp_obj_vax_gsd_idc
	integer*4 fshelp_obj_vax_gsd_env
	integer*4 fshelp_obj_vax_gsd_lsy
	integer*4 fshelp_obj_vax_gsd_lepm
	integer*4 fshelp_obj_vax_gsd_lpro
c	integer*4 fshelp_obj_vax_gsd_spsc
c
	fshelp_obj_vax_gsd_sub = .false.
	type  = data(1)
c
	if    (type .eq. gsd$c_psc) then
	  if(.not. fshelp_obj_vax_gsd_psc(routine,argument,data,
     1               nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_sym) then
	  if(.not. fshelp_obj_vax_gsd_sym(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_epm) then
	  if(.not. fshelp_obj_vax_gsd_epm(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_pro) then
	  if(.not. fshelp_obj_vax_gsd_pro(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_symw) then
	  if(.not. fshelp_obj_vax_gsd_symw(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_epmw) then
	  if(.not. fshelp_obj_vax_gsd_epmw(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_prow) then
	  if(.not. fshelp_obj_vax_gsd_prow(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_idc) then
	  if(.not. fshelp_obj_vax_gsd_idc(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_env) then
	  if(.not. fshelp_obj_vax_gsd_env(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_lsy) then
	  if(.not. fshelp_obj_vax_gsd_lsy(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_lepm) then
	  if(.not. fshelp_obj_vax_gsd_lepm(routine,argument,
     1               data,nbyte,cnt)) goto 90
	elseif(type .eq. gsd$c_lpro) then
	  if(.not. fshelp_obj_vax_gsd_lpro(routine,argument,
     1               data,nbyte,cnt)) goto 90
c	elseif(type .eq. gsd$c_spsc) then
c	  if(.not. fshelp_obj_vax_gsd_spsc(routine,argument,
c     1               data,nbyte,cnt)) goto 90
	else
	  call ana_wrerr(routine,argument,'Vax-GSD-?',type,1)
	  goto 90
	endif
	pos = pos + nbyte
	fshelp_obj_vax_gsd_sub = .true.
90	return
	end
	function fshelp_obj_vax_gsd_psc(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($gpsdef)'
	record /gpsdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_psc
c
	character*80 wrk
	integer*4 nkw,k
c
	integer*4 ana_wrac
	integer*4 ana_wri4
	integer*4 ana_wras
	integer*4 ana_wrhdr
c
	nbyte = %loc(data.gps$b_namlng) - %loc(data) 
     1        + 1 + data.gps$b_namlng
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Program section definition','GSD$C_PSC',nbyte,1)) goto 90
	fshelp_obj_vax_gsd_psc = .false.
        wrk = 'Unknown'
        if(data.gps$b_align .eq.  0) wrk = 'Byte'
        if(data.gps$b_align .eq.  1) wrk = 'Word'
        if(data.gps$b_align .eq.  2) wrk = 'Longword'
        if(data.gps$b_align .eq.  3) wrk = 'Quadword'
        if(data.gps$b_align .eq.  4) wrk = 'Octaword'
        if(data.gps$b_align .eq.  9) wrk = 'Pagelet'
        if(.not. ana_wras(routine,argument,'Alignment',
     1             wrk(1:10),2))goto 90
c
        wrk = ' '
        nkw = 0
        k = data.gps$w_flags
        if(btest(k,gps$v_pic)) call add_str(nkw,wrk,'PIC,')
        if(btest(k,gps$v_lib)) call add_str(nkw,wrk,'LIB,')
        if(btest(k,gps$v_ovr)) call add_str(nkw,wrk,'OVR,')
        if(btest(k,gps$v_rel)) call add_str(nkw,wrk,'REL,')
        if(btest(k,gps$v_gbl)) call add_str(nkw,wrk,'GBL,')
        if(btest(k,gps$v_shr)) call add_str(nkw,wrk,'SHR,')
        if(btest(k,gps$v_exe)) call add_str(nkw,wrk,'EXE,')
        if(btest(k,gps$v_rd )) call add_str(nkw,wrk,'RD,')
        if(btest(k,gps$v_wrt)) call add_str(nkw,wrk,'WRT,')
        if(btest(k,gps$v_vec)) call add_str(nkw,wrk,'VEC,')
        if(nkw .gt. 0) nkw = nkw - 1
        if(.not. ana_wras(routine,argument,'Attribute flags',
     1               wrk(1:nkw),2)) goto 90
c
        if(.not. ana_wri4(routine,argument,'Allocation',
     1                      data.gps$l_alloc,2,.true.)) goto 90
c
        if(.not. ana_wrac(routine,argument,'Symbol',
     1              data.gps$b_namlng,2)) goto 90
c
	fshelp_obj_vax_gsd_psc = .true.
c
90	return
	end
	function fshelp_obj_vax_gsd_sym(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($gsydef)'
	include '($sdfdef)'
	include '($srfdef)'
	structure /werk/
	  union
	    map
	      record /sdfdef/ sdf
	    end map
	    map
	      record /srfdef/ srf
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_sym
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
c
	fshelp_obj_vax_gsd_sym = .false.
c
        if(btest(data.sdf.sdf$w_flags,gsy$v_def)) then
	  nbyte = %loc(data.sdf.sdf$b_namlng) - %loc(data) +
     1             1 + data.sdf.sdf$b_namlng
	else
	  nbyte = %loc(data.srf.srf$b_namlng) - %loc(data) +
     1             1 + data.srf.srf$b_namlng
	endif
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Symbol definition','GSD$C_SYM',nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.sdf.sdf$b_datyp,2,.false.)) goto 90

	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.sdf.sdf$w_flags)) goto 90
c
        if(btest(data.sdf.sdf$w_flags,gsy$v_def)) then
c
c Symbol definition
c
          if(.not. ana_wri1(routine,argument,'Psect',
     1             data.sdf.sdf$b_psindx,2,.false.)) goto 90
          if(.not. ana_wri4(routine,argument,'Value',
     1             data.sdf.sdf$l_value,2,.true.)) goto 90
          if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.sdf.sdf$b_namlng,2)) goto 90
        else
c
c Symbol reference
c
          if(.not. ana_wrac(routine,argument,'Symbol',
     1                 data.srf.srf$b_namlng,2)) goto 90
	endif
c
	fshelp_obj_vax_gsd_sym = .true.
90	return
	end
	function fshelp_obj_vax_gsd_epm(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($epmdef)'
	record /epmdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_epm
c
	integer*4 ana_wrhdr
	integer*4 ana_wrac
	integer*4 ana_wri4
	integer*4 ana_wri1
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
c
	fshelp_obj_vax_gsd_epm = .false.
	nbyte = %loc(data.epm$b_namlng) - %loc(data) +
     1           1 + data.epm$b_namlng
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Entry point symvol and mask definition',
     1      'GSD$C_EPM',nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.epm$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.epm$w_flags)) goto 90
c
c
        if(.not. ana_wri1(routine,argument,'Psect',
     1             data.epm$b_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.epm$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.epm$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.epm$b_namlng,2)) goto 90
	fshelp_obj_vax_gsd_epm = .true.
90	return
	end
	function fshelp_obj_vax_gsd_pro(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($prodef)'
	structure /werk/
	  union
	    map
	      record /prodef/ data
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_pro
c
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
	integer*4 fshelp_obj_vax_pro_args
c
	fshelp_obj_vax_gsd_pro = .false.
	nbyte = %loc(data.data.pro$b_namlng) - %loc(data) +
     1           1 + data.data.pro$b_namlng
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Procedure with formal argument definition',
     1       'GSD$C_PRO',nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.data.pro$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.data.pro$w_flags)) goto 90

        if(.not. ana_wri1(routine,argument,'Psect',
     1             data.data.pro$b_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.data.pro$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.data.pro$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.data.pro$b_namlng,2)) goto 90
c
c Moet nog FML afhandelen
c
	if(.not. fshelp_obj_vax_pro_args(routine,argument,
     1       data.bdata(nbyte+1),nbyte)) goto 90
	fshelp_obj_vax_gsd_pro = .true.
90	return
	end
	function fshelp_obj_vax_pro_args(routine,argument,data,nbyte)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($fmldef)'
	include '($argdef)'
	structure /werk/
	  record /fmldef/ fml
	  byte args(1)
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 fshelp_obj_vax_pro_args
c
	character*80 wrk
	integer*4 nk,narg,pos,k
c
	integer*4 ana_wras
	integer*4 ana_wrtxt
	integer*4 ana_wrblk
c
	fshelp_obj_vax_pro_args = .false.
	call sys$fao('!UB to !UB',nk,wrk,
     1          %val(data.fml.fml$b_minargs),
     1          %val(data.fml.fml$b_maxargs))
	if(.not. ana_wras(routine,argument,'Argument count',
     1               wrk(1:nk),2)) goto 90
	narg = max(zext(data.fml.fml$b_minargs),zext(data.fml.fml$b_maxargs))
	nbyte = nbyte + sizeof(data.fml)
	pos   = 1
	do k=1,narg
	  call sys$fao('Argument #!UL',nk,wrk,%val(k))
	  if(.not. ana_wrtxt(routine,argument,wrk(1:nk),2)) goto 90
	  wrk = 'Unknown'
	  if(data.args(pos) .eq. arg$c_value) wrk = 'By value'	   
	  if(data.args(pos) .eq. arg$c_ref) wrk = 'By reference'	   
	  if(data.args(pos) .eq. arg$c_desc) wrk = 'By descriptor'	   
	  if(.not. ana_wras(routine,argument,'Passing mechanism',
     1                 wrk(1:nk),3)) goto 90
	  nk = data.args(pos+1)
	  if(nk .ne. 0) then
	    if(.not. ana_wrblk(routine,argument,nk,data.args(pos+2),2)) goto 90
	  endif
	  nbyte = nbyte + 2 + nk
	  pos   = pos   + 2 + nk
	end do
	fshelp_obj_vax_pro_args = .true.
90	return
	end
	function fshelp_obj_vax_gsd_symw(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($gsydef)'
	include '($sdfwdef)'
	include '($srfdef)'
	structure /werk/
	  union
	    map
	      record /sdfwdef/ sdfw
	    end map
	    map
	      record /srfdef/ srf
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_symw
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
c
	fshelp_obj_vax_gsd_symw = .false.
c
        if(btest(data.sdfw.sdfw$w_flags,gsy$v_def)) then
	  nbyte = %loc(data.sdfw.sdfw$b_namlng) - %loc(data) + 
     1             1 + data.sdfw.sdfw$b_namlng
	else
	  nbyte = %loc(data.srf.srf$b_namlng) - %loc(data) + 
     1             1 + data.srf.srf$b_namlng
	endif
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Symbol definition with word Psect','GSD$C_SYMW',
     1       nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.sdfw.sdfw$b_datyp,2,.false.)) goto 90

	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.sdfw.sdfw$w_flags)) goto 90
c
        if(btest(data.sdfw.sdfw$w_flags,gsy$v_def)) then
c
c Symbol definition
c
          if(.not. ana_wri2(routine,argument,'Psect',
     1             data.sdfw.sdfw$w_psindx,2,.false.)) goto 90
          if(.not. ana_wri4(routine,argument,'Value',
     1             data.sdfw.sdfw$l_value,2,.true.)) goto 90
          if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.sdfw.sdfw$b_namlng,2)) goto 90
        else
c
c Symbol reference
c
          if(.not. ana_wrac(routine,argument,'Symbol',
     1                 data.srf.srf$b_namlng,2)) goto 90
	endif
c
	fshelp_obj_vax_gsd_symw = .true.
90	return
	end
	function fshelp_obj_vax_gsd_epmw(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($epmwdef)'
	record /epmwdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_epmw
c
	integer*4 ana_wrhdr
	integer*4 ana_wrac
	integer*4 ana_wri4
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
c
	fshelp_obj_vax_gsd_epmw = .false.
c
	nbyte = %loc(data.epmw$b_namlng) - %loc(data) +
     1           1 + data.epmw$b_namlng
c
	fshelp_obj_vax_gsd_epmw = .false.
          if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Entry point definition with word Psect',
     1      'GSD$C_EPMW',0,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.epmw$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.epmw$w_flags)) goto 90
c
c
        if(.not. ana_wri2(routine,argument,'Psect',
     1             data.epmw$w_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.epmw$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.epmw$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.epmw$b_namlng,2)) goto 90
	fshelp_obj_vax_gsd_epmw = .true.
90	return
	end
	function fshelp_obj_vax_gsd_prow(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($prowdef)'
	structure /werk/
	  union
	    map
	      record /prowdef/ data
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_prow
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
	integer*4 fshelp_obj_vax_pro_args
c
	fshelp_obj_vax_gsd_prow = .false.
	nbyte = %loc(data.data.prow$b_namlng) - %loc(data) +
     1           1 + data.data.prow$b_namlng
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Procedure definition with word Psect',
     1      'GSD$C_PROW',0,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.data.prow$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.data.prow$w_flags)) goto 90

        if(.not. ana_wri2(routine,argument,'Psect',
     1             data.data.prow$w_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.data.prow$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.data.prow$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.data.prow$b_namlng,2)) goto 90
c
c Moet nog FML afhandelen
c
	if(.not. fshelp_obj_vax_pro_args(routine,argument,
     1       data.bdata(nbyte+1),nbyte)) goto 90
c
	fshelp_obj_vax_gsd_prow = .true.
90	return
	end
	function fshelp_obj_vax_gsd_idc(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($idcdef)'
	structure /werk/
	  union
	    map
	      record /idcdef/ idc
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_idc
c
	integer*4 ana_wrhdr
	integer*4 ana_wrac
	integer*4 ana_wras
	integer*4 lib$extzv
	integer*4 k,l,pos
c
	logical bindata
	character*80 wrk
	integer*4 nkw
c
	fshelp_obj_vax_gsd_idc = .false.
c
	nbyte = %loc(data.idc.idc$b_namlng) - %loc(data)
	do k=1,3
	  pos = nbyte + 1
	  l = zext(data.bdata(pos))
	  nbyte = nbyte + l + 1
	  pos = pos + l + 1
	end do

        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Entity ident consintency check',
     1      'GSD$C_IDC',nbyte,1)) goto 90
c
	k = data.idc.idc$w_flags
	bindata = btest(k,idc$v_binident)
	l = lib$extzv(idc$v_idmatch,idc$s_idmatch,k)
	wrk = 'Dunnow'
	if(l .eq. idc$c_leq) wrk = 'Less-equal'
	if(l .eq. idc$c_equal) wrk = 'Equal'
	if(.not. ana_wras(routine,argument,'Match',wrk(1:10),2)) goto 90
c
	l = lib$extzv(idc$v_errsev,idc$s_errsev,k)
	wrk = 'Dunnow'
	if(l .eq. 0) wrk = 'Warning'
	if(l .eq. 1) wrk = 'Success'
	if(l .eq. 2) wrk = 'Error'
	if(l .eq. 3) wrk = 'Informational'
	if(l .eq. 4) wrk = 'Fatal'
	if(.not. ana_wras(routine,argument,'Error severity',
     1              wrk(1:12),2)) goto 90
c
	pos = %loc(data.idc.idc$b_namlng) - %loc(data) + 1
c
	if(.not. ana_wrac(routine,argument,'Entity name',data.bdata(pos),2))
     1            goto 90
	k = zext(data.bdata(pos))
	pos = pos + k + 1
c
	if(bindata) then
	  call lib$movc3(4,data.bdata(pos+1),k)
	  l = lib$extzv(0,24,k)
	  k = lib$extzv(23,8,k)
	  call sys$fao('UL.!UL',nkw,wrk,%val(k),%val(l))
	  if(.not. ana_wras(routine,argument,'Ident',wrk(1:nkw),2)) goto 90
	else
	  if(.not. ana_wrac(routine,argument,'Ident',data.bdata(pos),2))
     1            goto 90
	endif
	k = zext(data.bdata(pos))
c
	pos = pos + k + 1
	if(.not. ana_wrac(routine,argument,'Name length',data.bdata(pos),2))
     1            goto 90
c
	fshelp_obj_vax_gsd_idc = .true.
90	return
	end
	function fshelp_obj_vax_gsd_env(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($envdef)'
	record /envdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_env
cc
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wrac
	integer*4 ana_wri2
c
	character*80 wrk
	integer*4 nkw,k
c
	fshelp_obj_vax_gsd_env = .false.
	nbyte = %loc(data.env$b_namlng) - %loc(data) + 
     1           1 + data.env$b_namlng
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Environent definition/reference','GSD$C_ENV',
     1       nbyte,1)) goto 90
c
	wrk = ' '
	nkw = 0
c
	k = data.env$w_flags
	if(btest(k,env$v_def)) call add_str(nkw,wrk,'DEF')
	if(btest(k,env$v_nested)) call add_str(nkw,wrk,'NESTED')
	if(nkw .gt.0) nkw = nkw - 1
	if(.not. ana_wras(routine,argument,'Flags',wrk(1:nkw),2)) goto 90
c
	if(.not. ana_wri2(routine,argument,'Environment index',
     1          data.env$w_envindx,2,.false.)) goto 90
c
	if(.not. ana_wrac(routine,argument,'Name',
     1                data.env$b_namlng,2)) goto 90
	fshelp_obj_vax_gsd_env = .true.
90	return
	end
	function fshelp_obj_vax_gsd_lsy(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($lsydef)'
	include '($lsdfdef)'
	include '($lsrfdef)'
	structure /werk/
	  union
	    map
	      record /lsrfdef/ lsrf
	    end map
	    map
	      record /lsdfdef/ lsdf
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_lsy
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
c
	fshelp_obj_vax_gsd_lsy = .false.
        if(btest(data.lsdf.lsdf$w_flags,lsy$v_def)) then
	  nbyte = %loc(data.lsdf.lsdf$b_namlng) - %loc(data) +
     1             1 + data.lsdf.lsdf$b_namlng
	else
	  nbyte = %loc(data.lsrf.lsrf$b_namlng) - %loc(data) +
     1             1 + data.lsrf.lsrf$b_namlng
	endif
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Module local symbol def/ref','GSD$C_LSY',
     1      nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.lsdf.lsdf$b_datyp,2,.false.)) goto 90

	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.lsdf.lsdf$w_flags)) goto 90
c
	if(.not. ana_wri2(routine,argument,'Environment',
     1           data.lsdf.lsdf$w_envindx,2)) goto 90
c
        if(btest(data.lsdf.lsdf$w_flags,lsy$v_def)) then
c
c Symbol definition
c
          if(.not. ana_wri2(routine,argument,'Psect',
     1             data.lsdf.lsdf$w_psindx,2,.false.)) goto 90
          if(.not. ana_wri4(routine,argument,'Value',
     1             data.lsdf.lsdf$l_value,2,.true.)) goto 90
          if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.lsdf.lsdf$b_namlng,2)) goto 90
        else
c
c Symbol reference
c
          if(.not. ana_wrac(routine,argument,'Symbol',
     1                 data.lsrf.lsrf$b_namlng,2)) goto 90
	endif
c


	fshelp_obj_vax_gsd_lsy = .true.
90	return
	end
	function fshelp_obj_vax_gsd_lepm(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($lepmdef)'
	record /lepmdef/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_lepm
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
c
	fshelp_obj_vax_gsd_lepm = .false.
	nbyte = %loc(data.lepm$b_namlng) - %loc(data) +
     1          1 +  data.lepm$b_namlng
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Module local entry point definition',
     1      'GSD$C_LEPM',nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.lepm$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.lepm$w_flags)) goto 90
c
	if(.not. ana_wri2(routine,argument,'Environment',
     1        data.lepm$w_envindx,2)) goto 90
c
        if(.not. ana_wri2(routine,argument,'Psect',
     1             data.lepm$w_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.lepm$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.lepm$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.lepm$b_namlng,2)) goto 90
	fshelp_obj_vax_gsd_lepm = .true.
90	return
	end
	function fshelp_obj_vax_gsd_lpro(routine,argument,data,nbyte,cnt)
	implicit none
	external routine
	integer routine
	integer*4 argument
	include '($lprodef)'
	structure /werk/
	  union
	    map
	      record /lprodef/ data
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	integer*4 nbyte
	integer*4 cnt
	integer*4 fshelp_obj_vax_gsd_lpro
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri4
	integer*4 ana_wrac
	integer*4 fshelp_obj_vax_gsd_flags
	integer*4 fshelp_obj_vax_gsd_mask
	integer*4 fshelp_obj_vax_pro_args
c
	fshelp_obj_vax_gsd_lpro = .false.
c
	nbyte = %loc(data.data.lpro$b_namlng) - %loc(data) +
     1           1 + data.data.lpro$b_namlng
c
        if(.not. ana_wrhdr(routine,argument,cnt,
     1      'Module local procedure definition',
     1      'GSD$C_LPRO',nbyte,1)) goto 90
c
	if(.not. ana_wri1(routine,argument,'Datatype',
     1       data.data.lpro$b_datyp,2,.false.)) goto 90
c
	if(.not. fshelp_obj_vax_gsd_flags(routine,argument,
     1               data.data.lpro$w_flags)) goto 90

	if(.not. ana_wri2(routine,argument,'Environment',
     1       data.data.lpro$w_envindx,2)) goto 90

        if(.not. ana_wri2(routine,argument,'Psect',
     1             data.data.lpro$w_psindx,2,.false.)) goto 90
        if(.not. ana_wri4(routine,argument,'Value',
     1             data.data.lpro$l_addrs,2,.true.)) goto 90
	if(.not. fshelp_obj_vax_gsd_mask(routine,argument,
     1             data.data.lpro$w_mask)) goto 90
        if(.not. ana_wrac(routine,argument,'Symbol',
     1             data.data.lpro$b_namlng,2)) goto 90
c
c Moet nog FML afhandelen
c
	if(.not. fshelp_obj_vax_pro_args(routine,argument,
     1       data.bdata(nbyte+1),nbyte)) goto 90
c
	fshelp_obj_vax_gsd_lpro = .true.
90	return
	end
c	function fshelp_obj_vax_gsd_spsc(routine,argument,data,nbyte,cnt)
c	implicit none
c	external routine
c	integer routine
c	integer*4 argument
c	byte data(*)
c	integer*4 nbyte
c	integer*4 cnt
c	integer*4 fshelp_obj_vax_gsd_spsc
cc
c	integer*4 ana_wrhdr
cc
c	fshelp_obj_vax_gsd_spsc = .false.
c          if(.not. ana_wrhdr(routine,argument,cnt,
c     1      'Program section definition in a shareable image',
c     1      'GSD$C_SPSC',0,1)) goto 90
c	fshelp_obj_vax_gsd_spsc = .true.
c90	return
c	end
	function fshelp_obj_vax_gsd_flags(routine,argument,flags)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
	integer*2 flags
	integer*4 fshelp_obj_vax_gsd_flags
c
	include '($gsydef)'
c
	character*80 wrk
	integer*4 nkw
c
	integer*4 ana_wras
c
        nkw = 0
        wrk = ' '
        if(btest(flags,gsy$v_weak)) call add_str(nkw,wrk,'WEAK,')
        if(btest(flags,gsy$v_def))  call add_str(nkw,wrk,'DEF,')
        if(btest(flags,gsy$v_uni))  call add_str(nkw,wrk,'UNI,')
        if(btest(flags,gsy$v_rel))  call add_str(nkw,wrk,'REL,')
        if(nkw .gt. 0) nkw = nkw - 1
        fshelp_obj_vax_gsd_flags = ana_wras(routine,argument,
     1    'Symbol flags',wrk(1:nkw),2)
	return
	end
	function fshelp_obj_vax_gsd_mask(routine,argument,mask)
	implicit none
c
	external routine
	integer routine
	integer*4 argument
	integer*2 mask
	integer*4 fshelp_obj_vax_gsd_mask
c
	character*80 wrk
	integer*4 nk,nk1,k
c
	integer*4 ana_wras
c
	wrk = '<'
	nk = 1
	do k=0,15
	  if(btest(mask,k)) then
	    call sys$fao('R!UL,',nk1,wrk(nk+1:),%val(k))
            nk = nk + nk1
	  endif
	end do
	if(nk .eq. 1) nk = nk+1
	wrk(nk:nk) = '>'
	fshelp_obj_vax_gsd_mask = ana_wras(routine,argument,
     1         'Entry mask',wrk(1:nk),2)
	return
	end
	function fshelp_obj_vax_hdr(nb,data,routine,argument,rcnt)
	implicit none
	include '($mhdef)'
	integer*4 nb
	record /mhdef/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_hdr
c
	character*80 wrk
	integer*4 k,nk,pos
c
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wri4
	integer*4 ana_wri2
	integer*4 ana_wrac
	integer*4 ana_wrerr
c
	fshelp_obj_vax_hdr = .false.

	if(    data.mhd$b_hdrtyp .eq. mhd$c_mhd) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Module header','OBJ$C_MHD',nb,0)) goto 90
c
	  k = data.mhd$b_strlvl
	  if(.not. ana_wri4(routine,argument,'Structure level',
     1             zext(data.mhd$b_strlvl),1,.false.)) goto 90
	  if(.not. ana_wri2(routine,argument,'Maximum record size',
     1             data.mhd$w_recsiz,1,.false.)) goto 90
	  if(.not. ana_wrac(routine,argument,'Module name',
     1             data.mhd$b_namlng,1)) goto 90
	  pos = data.mhd$b_namlng+1
	  if(.not. ana_wrac(routine,argument,'Module version',
     1        %ref(data.mhd$t_name(pos:pos)),1)) goto 90
	  k = ichar(data.mhd$t_name(pos:pos))
	  pos = pos + 1 + k
	  if(.not. ana_wras(routine,argument,'Creation date/time',
     1          data.mhd$t_name(pos:pos+16),1)) goto 90
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_lnm) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Language processor header','OBJ$C_LNM',nb,0)) goto 90
	  goto 20
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_src) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Source file header','OBJ$C_SRC',nb,0)) goto 90
	  goto 20
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_ttl) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Title text header','OBJ$C_TTL',nb,0)) goto 90
	  goto 20	  
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_cpr) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Copyright header','OBJ$C_CPR',nb,0)) goto 90
	  goto 20
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_mtc) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Maintenance status header','OBJ$C_MTC',nb,0)) goto 90
	  goto 20
	elseif(data.mhd$b_hdrtyp .eq. mhd$c_gtx) then
          if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'General text header','OBJ$C_GTX',nb,0)) goto 90
	  goto 20
	else
	  if(.not. ana_wrerr(routine,argument,'Vax-HDR',
     1            zext(data.mhd$b_hdrtyp),1)) goto 90
	endif
	goto 50
20	nk = nb - (%loc(data.mhd$b_strlvl) - %loc(data))
	wrk = ' '
	call lib$movc3(nk,data.mhd$b_strlvl,%ref(wrk))
	if(.not. ana_wras(routine,argument,'Info',wrk(1:nk),1)) goto 90
c	call sys$fao('  Info: "!AS"',nk,tmp,wrk(1:nk))	  
c	if(.not. routine(argument,tmp(1:nk))) goto 90
c
50	fshelp_obj_vax_hdr = .true.
90	return
	end
	function fshelp_obj_vax_lnk(nb,data,routine,argument,rcnt)
	implicit none
	include '($lnkdef)'
	integer*4 nb
	structure /temp/
	  union
	    map
	      record /lnkdef/ data
	    end map
	    map
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /temp/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_lnk
c
	character*80 tmp
	integer*4 nk,pos
	integer*4 desc(2)
c
	integer*4 ana_wrhdr
	integer*4 ana_wras
	integer*4 ana_wrac
c
	fshelp_obj_vax_lnk = .false.
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Link options','OBJ$C_LNK',nb,0)) goto 90
c
	tmp = 'Dunnow#'
	if(data.data.lnk$b_lnktyp .eq. lnk$c_olb) tmp = 'Object library#'
	if(data.data.lnk$b_lnktyp .eq. lnk$c_shr) 
     1         tmp = 'Shareable image library#'
	if(data.data.lnk$b_lnktyp .eq. lnk$c_oli) 
     1         tmp = 'Object library with inclusion list#'
	if(data.data.lnk$b_lnktyp .eq. lnk$c_obj) tmp = 'Object file#'
	if(data.data.lnk$b_lnktyp .eq. lnk$c_sha) 
     1         tmp = 'Shareable image file#'
	nk = index(tmp,'#')
c
	if(.not. ana_wras(routine,argument,'Link type',tmp(1:nk),2)) goto 90
c
	tmp = ' '
	nk = 0
	if(btest(data.data.lnk$w_flags,lnk$v_selser)) 
     1        call add_str(nk,tmp,'SELSER')
	if(btest(data.data.lnk$w_flags,lnk$v_libsrch)) 
     1        call add_str(nk,tmp,'LIBSRCH')
	if(nk .gt. 0) nk = nk - 1
	if(.not. ana_wras(routine,argument,'Flags',tmp(1:nk),2)) goto 90
c
	desc(1) = data.data.lnk$w_namlng
	desc(2) = %loc(data.data.lnk$w_namlng)+2
	if(.not. ana_wras(routine,argument,'File',desc,2)) goto 90
	if(data.data.lnk$b_lnktyp .eq. lnk$c_oli) then
	  pos = %loc(data.data.lnk$w_namlng) + 2 + data.data.lnk$w_namlng
	  do while(data.bdata(pos) .ne. 0 .and. pos .le. nb) 
	    if(.not. ana_wrac(routine,argument,'Include file',
     1           data.bdata(pos),2)) goto 90
	    pos = pos + zext(data.bdata(pos)) + 1
	  enddo
	endif
c
	fshelp_obj_vax_lnk = .true.
90	return
	end
	function fshelp_obj_vax_tbt(nb,data,routine,argument,rcnt)
	implicit none
	include '($tirdef)'
	integer*4 nb
	structure /werk/
	  union
	    map
	      record /tirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_tbt
c
	integer*4 pos,cnt
c
	integer ana_wrhdr
	integer*4 fshelp_obj_vax_tir_sub
c
	fshelp_obj_vax_tbt = .false.
c
	if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Traceback information','OBJ$C_TBT',nb,0)) goto 90
c
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_vax_tir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
	fshelp_obj_vax_tbt = .true.
90	return
	end
	function fshelp_obj_vax_tir(nb,data,routine,argument,rcnt)
	implicit none
	include '($tirdef)'
	integer*4 nb
	structure /werk/
	  union
	    map
	      record /tirdef/ data
	      byte locat
	    end map
	    map	    
	      byte bdata(1)
	    end map
	  end union
	end structure
	record /werk/ data
	external routine
	integer routine
	integer*4 argument
	integer*4 rcnt
	integer*4 fshelp_obj_vax_tir
c
	integer*4 pos,cnt
c
	integer*4 ana_wrhdr
	integer*4 fshelp_obj_vax_tir_sub
c
	fshelp_obj_vax_tir = .false.
c
        if(.not. ana_wrhdr(routine,argument,rcnt,
     1      'Text information/relocation','OBJ$C_TIR',nb,0)) goto 90
c
	pos = %loc(data.locat) - %loc(data) + 1
	cnt = 1
	do while(pos .lt. nb) 
	  if(.not. fshelp_obj_vax_tir_sub(data.bdata(pos),pos,routine,
     1            argument,cnt)) goto 90
	end do
c
	fshelp_obj_vax_tir = .true.
90	return
	end
	function fshelp_obj_vax_tir_sub(data,pos,routine,argument,cnt)
	implicit none
c
	include '($tirdef)'
c
	structure /werk/
	  byte type
	  byte data(1)
	end structure
	record /werk/ data
	integer*4 pos
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_tir_sub
c
	integer*4 type,nbyte,nk
c
	logical fshelp_obj_vax_tir_sta
	logical fshelp_obj_vax_tir_sto
	logical fshelp_obj_vax_tir_opr
	logical fshelp_obj_vax_tir_ctl
c
	integer*4 ana_wrhdr
	integer*4 ana_wrblk
	integer*4 ana_wrerr
c
	fshelp_obj_vax_tir_sub = .false.
	type  = data.type
c
	if(    type .ge. 0 .and. 
     1         type .le. tir$c_maxstacod) then
	  if(.not. fshelp_obj_vax_tir_sta(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. tir$c_minstocod .and. 
     1         type .le. tir$c_maxstocod) then
	  if(.not. fshelp_obj_vax_tir_sto(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. tir$c_minoprcod .and. 
     1         type .le. tir$c_maxoprcod) then
	  if(.not. fshelp_obj_vax_tir_opr(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .ge. tir$c_minctlcod .and. 
     1         type .le. tir$c_maxctlcod) then
	  if(.not. fshelp_obj_vax_tir_ctl(type,nbyte,data.data,
     1                routine,argument,cnt)) goto 90
	elseif(type .lt. 0) then
	  nk = -type
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store immediate',
     1            'TIR$C_STO_IMM',nk,1)) goto 90
	  if(.not. ana_wrblk(routine,argument,nk,data.data,2)) goto 90
	  nbyte = 1 + nk
	else
          if(.not. ana_wrerr(routine,argument,'Vax-TIR-?',
     1           type,1)) goto 90
	endif
	pos = pos + nbyte
	fshelp_obj_vax_tir_sub = .true.
90	return
	end
	function fshelp_obj_vax_tir_sta(type,nbyte,data,routine,argument,cnt)
	implicit none
	include '($tirdef)'
c
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_tir_sta
c
	integer*4 ana_wrhdr
	integer*4 ana_wrerr
	integer*4 ana_wri1
	integer*4 ana_wri2
	integer*4 ana_wri1s
	integer*4 ana_wri2s
	integer*4 ana_wri4s
	integer*4 ana_wrac
c
	fshelp_obj_vax_tir_sta = .false.
	nbyte = 1		!for opcode only
	if(type .eq. tir$c_sta_gbl) then
	  nbyte = nbyte + 1 + zext(data(1))
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack global',
     1            'TIR$C_STA_GBL',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,1))goto 90
c
	elseif(type .eq. tir$c_sta_sb) then
	  nbyte = nbyte + 1 
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack Signed byte',
     1            'TIR$C_STA_SB',nbyte,1)) goto 90
	  if(.not. ana_wri1s(routine,argument,'Value',data,
     1                    1,.true.)) goto 90
	elseif(type .eq. tir$c_sta_sw) then
	  nbyte = nbyte + 2
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack Signed word',
     1            'TIR$C_STA_SW',nbyte,1)) goto 90
	  if(.not. ana_wri2s(routine,argument,'Value',data,
     1                    1,.true.)) goto 90
	elseif(type .eq. tir$c_sta_lw) then
	  nbyte = nbyte + 4
	  if(.not. ana_wrhdr(routine,argument,cnt,'Stack longword',
     1            'TIR$C_STA_LW',nbyte,1)) goto 90
	  if(.not. ana_wri4s(routine,argument,'Value',data,
     1                    1,.true.)) goto 90
	elseif(type .eq. tir$c_sta_pb) then
	  nbyte = nbyte + 2
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + byte offset',
     1            'TIR$C_STA_PB',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Psect',data(1),
     1                    2,.false.)) goto 90
	  if(.not. ana_wri1s(routine,argument,'Value',data(2),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_pw) then
	  nbyte = nbyte + 3
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + word offset',
     1            'TIR$C_STA_PW',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri2s(routine,argument,'Value',data(2),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_pl) then
	  nbyte = nbyte + 5
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + longword offset',
     1            'TIR$C_STA_PL',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4s(routine,argument,'Value',data(2),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_ub) then
	  nbyte = nbyte + 2
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + unsignedbyte offset',
     1            'TIR$C_STA_PQ',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri1(routine,argument,'Value',data(2),
     1                    2,.true.)) goto 90

	elseif(type .eq. tir$c_sta_uw) then
	  nbyte = nbyte + 3
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack psect + unsigned word offset',
     1            'TIR$C_STA_PQ',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri2(routine,argument,'Value',data(2),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_bfi) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack byte from image',
     1            'TIR$C_STA_BFI',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sta_wfi) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack word from image',
     1            'TIR$C_STA_WFI',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sta_lfi) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack longword from image',
     1            'TIR$C_STA_LFI',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sta_epm) then
	  nbyte = nbyte + 1 + zext(data(1))
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack entrypoint mask',
     1            'TIR$C_STA_EPM',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,1))goto 90
	elseif(type .eq. tir$c_sta_ckarg) then
	  nbyte = nbyte + 1 + zext(data(1))
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack compare proc arg and stack for tru or false',
     1            'TIR$C_STA_CKARG',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data,2))goto 90
	elseif(type .eq. tir$c_sta_wpb) then
	  nbyte = nbyte + 3
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack word psect + byte offset',
     1            'TIR$C_STA_WPB',nbyte,1)) goto 90
	  if(.not. ana_wri2(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri1s(routine,argument,'Value',data(3),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_wpw) then
	  nbyte = nbyte + 4
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack word psect + word offset',
     1            'TIR$C_STA_WPW',nbyte,1)) goto 90
	  if(.not. ana_wri2(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri2s(routine,argument,'Value',data(3),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_wpl) then
	  nbyte = nbyte + 6
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack word psect + longword offset',
     1            'TIR$C_STA_WPL',nbyte,1)) goto 90
	  if(.not. ana_wri2(routine,argument,'Psect',data,
     1                    2,.false.)) goto 90
	  if(.not. ana_wri4s(routine,argument,'Value',data(3),
     1                    2,.true.)) goto 90
	elseif(type .eq. tir$c_sta_lsy) then
	  nbyte = nbyte + 2 + zext(data(3))
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack local symbol value',
     1            'TIR$C_STA_LSY',nbyte,1)) goto 90
	  if(.not. ana_wri2(routine,argument,'Index',data,2))goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data(3),2))goto 90
	elseif(type .eq. tir$c_sta_lit) then
	  nbyte = nbyte + 1
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1             'Stack literal',
     1            'TIR$C_STA_LIT',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Value',data,2,.true.))goto 90
	elseif(type .eq. tir$c_sta_lepm) then
	  nbyte = nbyte + 2 + zext(data(3))
	  if(.not. ana_wri2(routine,argument,'Index',data,2))goto 90
	  if(.not. ana_wrac(routine,argument,'Value',data(3),2))goto 90
	else
	  if(.not. ana_wrerr(routine,argument,'VAX-TIR-STA',
     1             type,1)) goto 90
	endif
	fshelp_obj_vax_tir_sta = .true.
90	return
	end

	function fshelp_obj_vax_tir_sto(type,nbyte,data,routine,argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_tir_sto
c
	include '($tirdef)'
c
	character*132 tmp
	integer*4 nk,tmpi4
C
	integer ana_wrblk
	integer ana_wrhdr
	integer ana_wrerr
	integer ana_wrtxt
c
	nbyte = 1
c
	fshelp_obj_vax_tir_sto = .false.
	if(    type .eq. tir$c_sto_sb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store signed byte',
     1            'TIR$C_STO_SB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_sw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store signed word',
     1            'TIR$C_STO_SW',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_l) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store longword',
     1            'TIR$C_STO_LW',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_bd) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store byte displaced',
     1            'TIR$C_STO_BD',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_wd) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store word displaced',
     1            'TIR$C_STO_WD',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_ld) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store longword displaced',
     1            'TIR$C_STO_LD',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_li) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store short literal',
     1            'TIR$C_STO_LI',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_PIDR) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store position independent data reference',
     1            'TIR$C_STO_PIDR',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_PICR) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store position independent code reference',
     1            'TIR$C_STO_PICR',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rsb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store repeated signed byte',
     1            'TIR$C_STO_RSB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rsw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store repeated signed word',
     1            'TIR$C_STO_RSW',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1            'Store repeated signed longword',
     1            'TIR$C_STO_RL',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_vps) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store arbitrary field',
     1            'TIR$C_STO_VPS',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_usb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store unsigned byte',
     1            'TIR$C_STO_USB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_usw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store unsigned word',
     1            'TIR$C_STO_USW',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rub) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store repeated unsigned byte',
     1            'TIR$C_STO_RUB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_b) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store byte',
     1            'TIR$C_STO_B',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_w) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Store word',
     1            'TIR$C_STO_W',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store repeated byte',
     1            'TIR$C_STO_RB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rw) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store repeated word',
     1            'TIR$C_STO_RW',nbyte,1)) goto 90
	elseif(type .eq. tir$c_sto_rivb) then
	  tmpi4 = zext(data(1))
	  nbyte = nbyte + 1 + tmpi4
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Store repeated immediate variable bytes',
     1            'TIR$C_STO_RIVB',nbyte,1)) goto 90
	  call sys$fao('Store epeated, !UB',nk,tmp,data(1))
	  if(.not. ana_wrtxt(routine,argument,tmp(1:nk),2)) goto 90
	  if(.not. ana_wrblk(routine,argument,tmpi4,data(2),2)) goto 90
	elseif(type .eq. tir$c_sto_pirr) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1           'Store position independent reference',
     1            'TIR$C_STO_PIRR',nbyte,1)) goto 90
	else
	  if(.not. ana_wrerr(routine,argument,'Vax-TIR-STO',
     1           type,1)) goto 90
	endif
	fshelp_obj_vax_tir_sto = .true.
90	return
	end

	function fshelp_obj_vax_tir_opr(type,nbyte,data,routine,argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_tir_opr
c
	include '($tirdef)'
c
	integer*4 nk
c
	integer*4 ana_wrhdr
	integer*4 ana_wri1
	integer*4 ana_wrac
	integer*4 ana_wrerr
c
	fshelp_obj_vax_tir_opr = .false.
	nbyte = 1
	nk = data(1)		!
	if(    type .eq. tir$c_opr_nop) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'No-operation',
     1            'TIR$C_OPR_NOP',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_add) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Add',
     1            'TIR$C_OPR_ADD',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_sub) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Subtract',
     1            'TIR$C_OPR_SUB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_mul) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Multiply',
     1            'TIR$C_OPR_MUL',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_div) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Divide',
     1            'TIR$C_OPR_DIV',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_and) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'And',
     1            'TIR$C_OPR_AND',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_ior) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Inclusive or',
     1            'TIR$C_OPR_OR',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_eor) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Exclusive or',
     1            'TIR$C_OPR_OR',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_neg) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Negate',
     1            'TIR$C_OPR_NEG',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_com) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Complement',
     1            'TIR$C_OPR_COM',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_insv) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Insert field',
     1            'TIR$C_OPR_INSV',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_ash) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Arithmetic shift',
     1            'TIR$C_OPR_ASH',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_ush) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Unsigned shift',
     1            'TIR$C_OPR_USH',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_rot) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Rotate',
     1            'TIR$C_OPR_ROT',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_sel) then
	  if(.not. ana_wrhdr(routine,argument,cnt,'Select',
     1            'TIR$C_OPR_SEL',nbyte,1)) goto 90
	elseif(type .eq. tir$c_opr_redef) then
	  nbyte = nbyte + nk
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Redefine symbol top current location',
     1            'TIR$C_OPR_REDEF',nbyte,1)) goto 90
	  if(.not. ana_wrac(routine,argument,'Symbol',data,2)) goto 90
	elseif(type .eq. tir$c_opr_dflit) then
	  nbyte = nbyte + 1
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1        'Define literal',
     1            'TIR$C_OPR_DFLIT',nbyte,1)) goto 90
	  if(.not. ana_wri1(routine,argument,'Value',data,2)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Vax-TIR-OPR',
     1          type,1)) goto 90
	endif
	fshelp_obj_vax_tir_opr = .true.
90	return
	end

	function fshelp_obj_vax_tir_ctl(type,nbyte,data,routine,argument,cnt)
	implicit none
	integer*4 type
	integer*4 nbyte
	byte data(*)	
	external routine
	integer routine
	integer*4 argument
	integer*4 cnt
	integer*4 fshelp_obj_vax_tir_ctl
c
	include '($tirdef)'
c
	integer*4 ana_wrhdr
	integer*4 ana_wri4
	integer*4 ana_wrerr
c
	fshelp_obj_vax_tir_ctl = .false.
c
	nbyte = 1
	if(    type .eq. tir$c_ctl_setrb) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Set relocation base','TIR$C_CTL_SETRB',nbyte,1)) goto 90
	elseif(type .eq. tir$c_ctl_augrb) then
	  nbyte = nbyte + 4
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Augment relocation base','TIR$C_CTL_AUGRB',
     1        nbyte,1)) goto 90
	  if(.not. ana_wri4(routine,argument,'Value',data,
     1        2,.true.)) goto 90
	elseif(type .eq. tir$c_ctl_dfloc) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Define location','TIR$C_CTL_DFLOC',nbyte,1)) goto 90
	elseif(type .eq. tir$c_ctl_stloc) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Set location','TIR$C_CTL_STLOC',nbyte,1)) goto 90
	elseif(type .eq. tir$c_ctl_stkdl) then
	  if(.not. ana_wrhdr(routine,argument,cnt,
     1       'Stack defined location','TIR$C_CTL_STKDL',
     1        nbyte,1)) goto 90
 	else
	  if(.not. ana_wrerr(routine,argument,'Vax-TIR-CTL',
     1           type,1)) goto 90
	endif
	fshelp_obj_vax_tir_ctl = .true.
90	return
	end
