	program test
	implicit none
c
c This program displays the help about FSHELP. 
C if you hhave the logical FSHELP_SHR pointing to the shareable image
c (define fshelp_shr programs_top:[fshelp]fshelp_shr_alpha), this program
c will use FSHELP, otherwise it will revert to the normal VMShelp.
c
	call process_help_sub('FSHELP','programs_top:[fshelp]fshelp')
	end
c
c You can call this routine with 2 arguments
c 1. item : the requested (sub)topics
c 2. libraryname : the help library
c
c for this to work you need a logical FSHELP_SHR pointing to the sharable image 
c
c example
c
c define fshelp_shr fshelp_disk:[fshelp]fshelp_shr_alpha
c
	subroutine process_help_sub(item,libraryname)
	implicit none
c
c Try to output the help by FSHELP_SHR, but if it is not defined
c use the normal LBR$OUTPUT_HELP
c
	character*(*) item		!:i: the requested item(s)
	character*(*) libraryname	!:i: the help library
c
	integer*4 istat,flag,pagewidth,options(2)
c
	character*40 line
c
	integer*4 lib$find_image_symbol
	integer*4 lbr$output_help
	external ignore
	external my_output,my_input
c
	include '($hlpdef)'
	include '($dvidef)'
	include 'fshelp_def'
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /my_nlines/ nlines,pagesize,ansi
c
	external help_routine
	pointer (p_help_routine,help_routine)
c
c Find the imagename, and transfer to HLB name
c Try to load fshelp_shr
c 
	call lib$establish(ignore)  !to prevent message from find_image_symbol
	istat = lib$find_image_symbol('fshelp_shr',
     1             'fshelp_display_help',p_help_routine)
	call lib$revert
	if(istat) then
c
c fshelp_shr was found, so we can call it now
c with 3 arguments
c 1. The name of the library (or blank)
c 2. The topic list (or blank)
c 3. als option table of 2 words
c
c If the .HLB file is in the same directory as the image, and has the
c same name, you can also use the fshelp_m_image option here
c
c	  options(1) = fshelp_m_image
c
	  options(1) = 0
	  options(2) = 'ENGL'	!the english language
c
	  call help_routine(libraryname,item,options)
	else
c
c fshelp_shr  not found, so use lbr$output_hlp
c get some terminal data, (it could be a file)
c
	  call lib$getdvi(dvi$_tt_ansicrt,,'sys$output',ansi)
	  pagesize = 0
	  if(ansi) then
	    call lib$getdvi(dvi$_tt_page,,'sys$output',pagesize)
	    call lib$getdvi(dvi$_devbufsiz,,'sys$output',pagewidth)
	    write(*,1010) char(27),char(27)
1010	    format('+',a,'[H',a,'[2J',$)
	  endif
c
c And output help, we use our own routines to do the in and output
c so no more than a pagesize will be displayed
c
c  output through MY_OUTPUT
c  input  through MY_INPUT
c
	  flag = hlp$m_prompt .or. hlp$m_help
	  nlines = 0
	  call lbr$output_help(my_output,pagewidth,item,
     1              libraryname,flag,my_input)
	end if
c
	return
	end
c
	function my_input(string,prompt,nkar)
	implicit none
c
c This routine is called by LBR$OUTPUT_HELP, when it needs user-input
c
	character*(*) string	!:o: the typed string to return
	character*(*) prompt	!:i: the prompt for the user
	integer*4 nkar		!:o: #chars in string
	logical*4 my_input	!:f: function result
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /my_nlines/ nlines,pagesize,ansi
c
	integer*4 lib$get_input
c
c Set the nlines counter to 0, so my_output can print a whole page again
c in fact this is the only reason not to use LIB$GET_INPUT
c
	nlines = 0
c
c Ge the data fro lib$get_input
c
	my_input = lib$get_input(string,prompt,nkar)
c
	return
	end
c
	function my_output(string)
	implicit none
c
c Output data to terminal
c
	character*(*) string	!:i: the string to print
	logical*4 my_output
c
	integer*4 nlines,pagesize
	logical*4 ansi
	common /my_nlines/ nlines,pagesize,ansi
c
	character*80 kar
	integer*4 nkar
c
	integer*4 lib$put_output,lib$get_input
c
c On more line printed
c
	nlines = nlines + 1
c
c Check if #lines still fits on a page
c
	if(pagesize .ne. 0 .and. nlines .ge. pagesize-3) then
c
c No so let the user type something
c
	  call lib$put_output(' ')
	  call lib$put_output(' ')
	  my_output=lib$get_input(kar,'Press RETURN to continue ... ',
     1                      nkar)
	  if(.not. my_output) goto 90
c
c Clear screen for the next page
c
	  if(ansi) write(*,1010) char(27),char(27)
1010	  format('+',a,'[H',a,'[2J',$)
	  nlines = 0
	end if
c
c And print the data
c
	my_output = lib$put_output(string)
90	return
	end

	function ignore()
	implicit none
c
c if the fshelp_shr is not found LIB$FIND_IMAGE_SYMBOL will signal
c this status. To prevent this message to go to the screen
c we use this handler to ignore this (all) signals.
c LIB$FIND_IMAGE_SYMBOL will also return the status, and we will use 
c this return status
c
	integer*4 ignore
	include '($ssdef)'
c
	ignore = ss$_continue
	end
