 	function screen_init(control,no_tabs)
c
	implicit none
	include 'fshelp.inc'
	record /control/ control
	logical*4 screen_init
	logical*4 no_tabs
c
	include '($smgdef)'
	include '($smgmsg)'
c
	integer*4 pstat,mask,term_type,mode,video,ipos
c
	integer*4 smg$create_pasteboard
	external screen_out_of_band_routine
	external screen_broadcast_routine
	external fshelp_libnam
	external fshelp_topic
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	character*132 line_top,line_lib
	integer*4 nk_lib,nk_top
c
	screen_init = .false.
	pstat = smg$create_pasteboard(screen.paste_id,,
     1                  screen.nrows,screen.ncols,,term_type)
c
	screen.orig_ncols = screen.ncols
	control.pasalr = pstat .eq. smg$_pasalrexi
	if(control.pasalr) then
	  call smg$create_virtual_display(screen.nrows,132,screen.dis_id_plus)
	  call smg$paste_virtual_display(screen.dis_id_plus,
     1          screen.paste_id,      1,1)
	endif  
	if(.not. control.pasalr .and. term_type .ne. smg$k_vttermtable) then
	  write(*,*) 'Terminal type not supported'
	  goto 99
	end if
	if(no_tabs) then
	  call smg$control_mode(screen.paste_id,,mode)
	  mode = mode .or. smg$m_notabs
	  call smg$control_mode(screen.paste_id,mode)
	end if
c
c create virtual keyboard
c
	call smg$create_virtual_keyboard(screen.keyboard_id)
c
	screen.control_c_seen = .false.
c
	mask = (2**smg$k_trm_ctrlc) .or. (2**smg$k_trm_ctrla)
c
c Trap ^c,^a
c
	call smg$set_out_of_band_asts(screen.paste_id,mask,
     1                                screen_out_of_band_routine)
c
c Trap broadcasts
c
	call smg$set_broadcast_trapping(screen.paste_id,
     1               screen_broadcast_routine,screen.paste_id)

	video = smg$m_bold .or. smg$m_reverse
	call smg$create_virtual_display(2,132,screen.display_id_kop,,video)
c
c Get the Library name
c
	call fshelp_getmsg(fshelp_libnam,nk_lib,line_lib)
	ipos = index(line_lib,':')
	if(ipos .eq. 0) ipos = index(line_lib,'!')
	if(ipos .eq. 0) ipos = index(line_lib,' ')
	screen.width_hdr = ipos
	line_lib(ipos:) = ' '
c
	call fshelp_getmsg(fshelp_topic,nk_top,line_top)
	ipos = index(line_top,':')
	if(ipos .eq. 0) ipos = index(line_top,'!')
	if(ipos .eq. 0) ipos = index(line_top,' ')
	line_top(ipos:) = ' '
c
	screen.width_hdr = max(screen.width_hdr,ipos)
	ipos = screen.width_hdr
	line_lib(ipos:ipos) = ':'
	line_top(ipos:ipos) = ':'
c
	call smg$put_chars(screen.display_id_kop,line_lib(1:ipos),1,1,,video)
	call smg$put_chars(screen.display_id_kop,line_top(1:ipos),2,1,,video)
c
	screen.nlines = screen.nrows-2		!remember
	call smg$paste_virtual_display(screen.display_id_kop,
     1          screen.paste_id,      1,1)
c
	screen.display_error = 0		!no error messages yet
	screen_init = .true.
99	return
	end

	subroutine screen_exit(control,aborted)
c
	implicit none
	include 'fshelp.inc'
	record /control/ control
	logical*4 aborted
c
c delete virtual displays
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	if(screen.ncols .ne. screen.orig_ncols) then
	 call smg$change_pbd_characteristics(screen.paste_id,screen.orig_ncols)
	end if
c
	if(.not. aborted .or. control.pasalr) then
	  call smg$delete_virtual_display(screen.display_id_kop)
	endif
	call smg$disable_broadcast_trapping(screen.paste_id)
	call smg$delete_virtual_keyboard(screen.keyboard_id)
c
c remove pasteboard, if not already existed on create
c
	if(.not. control.pasalr) then
	  call smg$delete_pasteboard(screen.paste_id,0)
	else
	  call smg$set_cursor_abs(screen.dis_id_plus,screen.nrows,1)
	  call smg$delete_virtual_display(screen.dis_id_plus)
	end if
	return
	end

	subroutine screen_out_of_band_routine(smg)! ,reg_r0,reg_r1,reg_pc,reg_psl)
	implicit none
c
c Trap ^c,^r,^w,^a
c
	include '($smgdef)'
	record /smgdef/ smg		!:i: smg control block
c	integer*4 reg_r0		!:i: ast params (not used)
c	integer*4 reg_r1		!     ...
c	integer*4 reg_pc		!     ...
c	integer*4 reg_psl		!     ...
c
	include 'fshelp.inc'
c
	record /screen/ screen
	common /fshelp_screen/ screen
	external fshelp_clear
c
	if(smg.smg$b_character .eq. smg$k_trm_ctrla) then	
	  call fshelp_mess(fshelp_clear)
	elseif(smg.smg$b_character .eq. smg$k_trm_ctrlc) then	
	  screen.control_c_seen = .true.
	  call smg$cancel_input(screen.keyboard_id)
	end if
	return
	end

	subroutine screen_broadcast_routine !(par,par_r0,par_r1,par_pc,par_psl)
	implicit none
c
c	integer*4 par			!:i: ast params (not used)
c	integer*4 par_r0		!     ...
c	integer*4 par_r1		!     ...
c	integer*4 par_pc		!     ...
c	integer*4 par_psl		!     ...
c
c Common for screen display
c
	include 'fshelp.inc'
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 smg$get_broadcast_message
	external fshelp_general
c
	character*256 line
	integer*4 nkar,istat,ibpos,iepos,n
c
	character*2 crlf,lfcr
	parameter (crlf = char(13)//char(10))
	parameter (lfcr = char(10)//char(13))
c
	include '($ssdef)'
c
10	istat = smg$get_broadcast_message(screen.paste_id,line,nkar)
	if(istat .eq. ss$_normal) then
	  ibpos = 1
	  do while(ibpos .le. nkar)
	    n = 2
	    iepos = index(line(ibpos:nkar),crlf)
	    if(iepos .eq. 0) iepos = index(line(ibpos:nkar),lfcr)
	    if(iepos .eq. 0) then
	      iepos = nkar+1
	    else
	      iepos = iepos + ibpos-1
	    end if
	    if(iepos-ibpos .gt. screen.ncols) then
	      n = 0
	      iepos = ibpos + screen.ncols
	    end if
	    call fshelp_mess_par(fshelp_general,line(ibpos:iepos))
	    ibpos = iepos + n
	  end do
	  goto 10
	end if
c
	return
	end

	subroutine screen_message(message_text)
c
	implicit none
	character*(*) message_text		!:i: the error message
c
	include '($smgdef)'
c
c Common for screen display
c
	include 'fshelp.inc'
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 k,l,ipos,nl,nc
c
	if(message_text .eq. char(0)) then 
c
c Empty message, so clear
c
	  if(screen.display_error .ne. 0) then
	    call smg$delete_virtual_display(screen.display_error)
	    screen.display_error = 0
	  end if
	else
c
c Valid message, so display
c
	  do k=len(message_text),1,-1
	    if(message_text(k:k) .ne. ' ') goto 10
	  end do
	  k = 1
10	  nl = (k+screen.ncols-1)/screen.ncols
	  nc = k
	  if(nl .gt. 1) nc = screen.ncols
	  if(screen.display_error .eq. 0) then
	    screen.nrows_error = nl
	    screen.ncols_error = nc
	    call smg$create_virtual_display(screen.nrows_error,
     1             screen.ncols_error,screen.display_error)
  	  else
	    screen.nrows_error = screen.nrows_error + nl
	    screen.ncols_error = max(screen.ncols_error,nc)
	    call smg$change_virtual_display(screen.display_error,
     1             screen.nrows_error,screen.ncols_error)
	  end if
	  call smg$paste_virtual_display(screen.display_error,screen.paste_id,
     1               screen.nrows-screen.nrows_error+1,
     1               screen.ncols-screen.ncols_error)
	  ipos = 1
	  do l=1,nl
	    call smg$put_chars(screen.display_error,
     1              message_text(ipos:min(k,l*screen.ncols)),
     1              screen.nrows_error-nl+l,1,,smg$m_reverse)
	  end do
	end if
	return
	end
	subroutine screen_repaste_message(screen)
	implicit none
c
	include 'fshelp.inc'
	record /screen/ screen
c
	if(screen.display_error .ne. 0) then
	  call smg$unpaste_virtual_display(screen.display_error,
     1           screen.paste_id)
	  call smg$paste_virtual_display(screen.display_error,screen.paste_id,
     1               screen.nrows-screen.nrows_error+1,
     1               screen.ncols-screen.ncols_error)
	endif
	return
	end

	subroutine screen_lookat(control,head,row_wanted,col_wanted,
     1                           ret_sta,sel_item,whole,
     1                           is_autolink,from_autolink)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
	record /header/ head
	integer*4 row_wanted
	integer*4 col_wanted
	integer*4 ret_sta
	integer*4 sel_item		!:i: 0=normal,
	logical*4 whole			!:i: use whole screen for cursor
	logical is_autolink		!:o: true if autolink
	logical from_autolink		!:o: true if return from autolink
c
c Let the user look at the data
c
c The user can use the following keys
c
c Movements:
c  up arrow  mode display one line up
c  down arrow move display one line down
c  prev screen move display one page up
c  next screen move display one page down
c  PF1 prev screen move display to the first line
c  PF1 next screen move display to the last line
c  
c Search in local buffer
c  PF3 find string
c  PF1 PF3 set search string and find
c  KP4 set forward mode
c  KP5 set backward mode
c
c The user can search all deeper items, this search in forward only
c and after each occurence the text is displayed, and the user
c can specify j/n/a (yes/no/abort)
c FIND search string in all deeper items
c PF1 FIND ask search string and search all deeper items for string
c
c The user can make a print of the current topic, (and optionally 
c of all deeper items). The user can specify the filename and also
c the format (plain text of VMS help format).
c
c F14 start print session
c
c Leave options
c RETURN leave for deeper help item display(if there are)
c @ or TAB leave for help library display (if there are more than 1)
c PF4 abort this help level and return one level lower
c ^z abort this program
c
c
	include '($smgdef)'
c
c
c Common for screen display
c
	record /screen/ screen
	common /fshelp_screen/ screen
	record /search/ see_also
c	record /search/ search
	record /mouse/ mouse
	record /execute/ exe_blk
c
	record /bar/ bar_h
	record /bar/ bar_v
c
	integer*4 iterm,ypos,top_line,video,display_id_hd,intl,xpos
	integer*4 ipos,k,l,nkar,left_col,ncols !,displacement
	logical*4 pf1_flag,set_rev,forward,display_empty
	logical*4 find_string,first,is_libs,disp_binary
	integer*4 nkar_old,nb,nkar_old_col,nlines,first_line,nhd
c
	character*25 regel
	integer*4 display_id,n_text,nk_str,nk_ext,hor_disp,ver_disp
	integer*4 nk_let,lun_text,lun_bin,n_header
	character*(max_line_length) line
	character*6 str,letters
	character*40 ln1
	integer nkln1
c
	integer*4 max_vids,n_vids,curvid,kar_set !,old_nls_v,old_nls_h
	parameter (max_vids=80)
	integer*4 vids(max_vids)
	integer*4 begvids(max_vids)
	integer*4 lenvids(max_vids)
c
	integer*4 nlines_v,ncols_v
	logical*4 need_bar_v_repaste,need_bar_h_repaste,all_libs
c
	character*1 ctrl_n,ctrl_o
	parameter (ctrl_n = char(14),ctrl_o =char(15))
c
	logical*4 vm_read_txt
	logical*4 vm_read_fix
	external help_lookat
	integer*4 get_len
	logical*4 fshelp_disp_info
	integer*4 smg$set_cursor_abs
	external fshelp_wrkey,fshelp_noexe,fshelp_firstc
	external fshelp_nolibr,fshelp_noverw,fshelp_nohist,fshelp_nodeep
	external fshelp_notfnd,fshelp_seastr,fshelp_seastr1,fshelp_alltxt
	external fshelp_rowdis,fshelp_coldis,fshelp_sealso
	external fshelp_scripts,fshelp_helpi
	external fshelp_letters
c
	data nkar_old/0/,nkar_old_col/0/
c
	ipos = 0
c	
c Ga nu op de eerste plek staan.
c
	disp_binary = .false.
	is_autolink = .false.
	lun_bin = 0
c
1	if(disp_binary) then
	  if(lun_bin .eq. 0) then
	    call translate_to_bin(head.lun_text,lun_bin,n_header)
	  endif
	  lun_text = lun_bin
	  nhd = n_header
	else
	  lun_text = head.lun_text
	  nhd = head.n_head
	endif
	call vm_file_info(lun_text,n_text,,,ncols)
	if(ncols .lt. 80) ncols = 80
c	
	call smg$create_virtual_display(max(1,n_text),ncols,display_id)
c
	nhd = max(0,min(5,nhd))
c
	call fshelp_getmsg(fshelp_letters,nk_let,letters)
c
	nlines = screen.nlines-nhd
c
	call check_bars(control,screen,nhd,ncols,n_text-nhd,
     1                  nlines_v,ncols_v,bar_h,bar_v)
c
	first_line = 3+nhd
	call smg$create_viewport(display_id,1,1,nlines_v,ncols_v)
c	
	if(nhd .gt. 0) then
	  call smg$create_virtual_display(nhd,ncols_v,display_id_hd)
	  call smg$paste_virtual_display(display_id_hd,screen.paste_id,3,1)
	  call smg$create_viewport(display_id_hd,1,1,nhd,ncols_v)
	end if
	call vm_rewind(lun_text)
	n_text = 0
	curvid = 0
	kar_set = smg$c_ascii
	display_empty = .true.
	do while(vm_read_txt(lun_text,k,nb,line))
	  call screen_get_vids(line,nb,max_vids,n_vids,vids,
     1               begvids,lenvids,curvid)
	  display_empty = .false.
	  n_text = n_text+1
	  if(n_text .le. nhd) then
	    video = 0
	    if(n_text .eq. nhd) then
	      video = smg$m_underline
	      line(nb+1:) = ' '
	      nb = ncols
	    endif
	    call smg$put_chars(display_id_hd,line(1:nb),n_text,1,,video)
	  else
	    if(index(line(1:nb),ctrl_n) .ne. 0) kar_set = smg$c_spec_graphics
	    if(index(line(1:nb),ctrl_o) .ne. 0) kar_set = smg$c_ascii
	    call smg$put_chars(display_id,line(1:nb),n_text-nhd,1,,,,kar_set)
	    l = n_text-nhd
	    do k=1,n_vids
	      call smg$change_rendition(display_id,l,begvids(k),1,
     1                    lenvids(k),vids(k))
	    end do
	  end if
	end do
	if(display_empty .and. from_autolink) then
	  ret_sta = ret_level_up	!return from autolink to empty page
	  goto 90
	endif
	n_text = n_text - nhd		!remove the header lines
c
	if(control.inline) then
	  video = smg$m_user8
	  call vm_rewind(head.lun_see)
	  do while(vm_read_fix(head.lun_see,k,see_also))
	    call smg$change_rendition(display_id,
     1             see_also.dis_row,see_also.dis_col_beg,
     1             1,see_also.dis_col_end-see_also.dis_col_beg+1,video)
	  end do
	end if
c
	call vm_file_info(control.files.lun,k,)
	is_libs  = k .gt. 1
c
c Check voor verwijzingen/dieper/libraries
c
	intl = 1
	if(whole) intl = nlines_v
	str = ' '
	nk_str = 0
	if(is_libs) then
	  nk_str = nk_str + 1
	  str(nk_str:nk_str) = letters(1:1)
	end if
	if(head.deeper.lun .ne. 0) then
	  nk_str = nk_str + 1
	  str(nk_str:nk_str) = letters(2:2)
	end if
	if(head.lun_see.lun .ne. 0) then
	  nk_str = nk_str + 1
	  str(nk_str:nk_str) = letters(3:3)
	end if
	if(head.lun_exe.lun .ne. 0) then
	  nk_str = nk_str + 1
	  str(nk_str:nk_str) = letters(4:4)
	end if
	if(nk_str .ne. 0) then
	  str = '('//str(1:nk_str)//')'
	  nk_str = nk_str + 2
	end if
	nk_ext = nk_str
c
	top_line = 1
	left_col = 1
	ypos     = 1
	set_rev  = .false.
	forward  = .true.
	first    =.true.
	if(row_wanted .ne. 0) then
	  ypos = max(1,row_wanted-nlines_v/2)
	  set_rev = .true.
	end if
c
c check of nog op scherm
c see if position is allowed(or needed)
c
	need_bar_v_repaste = .true.	
	need_bar_h_repaste = .true.	
10	if(ypos .gt. n_text-nlines_v+intl) ypos = n_text-nlines_v+intl
	if(ypos .lt. 1) ypos = 1
c
	if(ypos .lt. top_line) then
	  if(bar_v.need_bar) then
	    if(.not. need_bar_v_repaste) then
	      call smg$unpaste_virtual_display(bar_v.dis_id,screen.paste_id)
	      need_bar_v_repaste = .true.
	    endif
	  endif
	  l = top_line-ypos
	  if(l .le. nlines_v) then
	    do k=1,l
	      call smg$scroll_viewport(display_id,smg$m_down,1)
	    end do
	  else
	    call smg$scroll_viewport(display_id,smg$m_down,l)
	  end if
	  top_line = top_line-l
	elseif(ypos .gt. top_line+intl-1) then
	  if(bar_v.need_bar) then
	    if(.not. need_bar_v_repaste) then
	      call smg$unpaste_virtual_display(bar_v.dis_id,screen.paste_id)
	      need_bar_v_repaste = .true.
	    endif
	  endif
	  l = ypos-top_line-intl+1
	  if(l .le. nlines_v) then
	    do k=1,l
	      call smg$scroll_viewport(display_id,smg$m_up  ,1)
	    end do
	  else
	    call smg$scroll_viewport(display_id,smg$m_up  ,l)
	  end if
	  top_line = top_line+l
	end if
c
c If row_wanted >0 we must paste the display (only once )
c
	if(first) then
	  call smg$paste_virtual_display(display_id,screen.paste_id,
     1               first_line,1)
c
c Make sure message window is on top
c
	  call screen_repaste_message(screen)
	endif
	if(bar_h.need_bar) then
	  if(need_bar_h_repaste) then
	    call smg$paste_virtual_display(bar_h.dis_id,screen.paste_id,
     1               screen.nrows,1)
	    need_bar_h_repaste = .false.
	  endif
	end if
	if(bar_v.need_bar) then
	  if(need_bar_v_repaste) then
	    call smg$paste_virtual_display(bar_v.dis_id,screen.paste_id,
     1               first_line,screen.ncols)
	    need_bar_v_repaste = .false.
	  end if
	endif
c
c Tell user on which line we are
c First : clear old data to default spaces
c
	regel = ' '
	if(nkar_old .ne. 0) then
	  call smg$put_chars(screen.display_id_kop,regel(1:nkar_old),1,
     1                 screen.ncols-nkar_old+1)
	  nkar_old = 0
	end if
	if(nkar_old_col .ne. 0) then
	  call smg$put_chars(screen.display_id_kop,regel(1:nkar_old_col),2,
     1                 screen.ncols-nkar_old_col+1)
	  nkar_old_col = 0
	end if
c
c Now fill in data again
c
	call fshelp_getmsg(fshelp_rowdis,nkln1,ln1)
	call sys$fao(ln1(1:nkln1),nkar,regel,
     1               %val(top_line),
     1               %val(min(n_text,top_line+nlines_v-1)),
     1               %val(n_text),str(1:nk_str))
	video = 0
	if(control.colour) video = smg$m_user3	!user2 does not work ????
	call smg$put_chars(screen.display_id_kop,regel(1:nkar),1,
     1                 screen.ncols-nkar+1,,video)
	nkar_old = nkar
c
c Teel user on which column we are
c
	if(ncols_v .lt. ncols) then
	  call fshelp_getmsg(fshelp_coldis,nkln1,ln1)
	  call sys$fao(ln1(1:nkln1),nkar,regel,
     1                %val(left_col),
     1                %val(left_col+ncols_v-1), 
     1                %val(ncols))
c
	  call smg$put_chars(screen.display_id_kop,regel(1:nkar),2,
     1                 screen.ncols-nkar+1,,video)
	  nkar_old_col = nkar
	end if
c
c If we found an item, display it reverse
c
	if(set_rev) then
	  call smg$change_rendition(display_id,row_wanted,col_wanted,1,
     1                    control.search_string_fnd,smg$m_reverse)
c     1                    control.search_string_l,smg$m_reverse)
	end if
c
c set cursor
c
	call display_bar(bar_v,top_line) !n_text,top_line,nlines_v,.false.)
	call display_bar(bar_h,left_col) !ncols,left_col,ncols_v,.true.)
c
	if(whole) then
	  call smg$read_from_display(display_id,line,,ypos)
	  k = get_len(line)
	  xpos = max(1,min(xpos,k))
	else
	  xpos = 1	  
	endif
	call smg$set_cursor_abs(display_id,ypos,xpos)
c
c There is data, so let the user look at it
c 
15	hor_disp = 10		!default horizontal shift
	ver_disp =  1		!default vertival shift
	if(first .and. sel_item .gt. 0 .or. display_empty) then
	  iterm = key_enter
	  pf1_flag = .false.
	else
	  call screen_getkey(iterm,pf1_flag,help_lookat,control)
	  mouse.iterm = iterm
	  if(mouse.button .eq. key_mouse_1 .or. 
     1       mouse.button .eq. key_mouse_2 .or.
     1       mouse.button .eq. key_mouse_3 .or. 
     1       mouse.button .eq. key_mouse_4) then
	    pf1_flag = .false.
	    iterm = 0
	    if(control.inline) then
	      ret_sta = ret_first_seealso
	      if(head.lun_see.lun .ne. 0) then
	        call vm_rewind(head.lun_see)
	        do while(vm_read_fix(head.lun_see,k,see_also))
	          ret_sta = ret_sta - 1
	          if(mouse.row-2 .eq. see_also.dis_row .and.
     1               (mouse.col .ge. see_also.dis_col_beg .and.
     1                mouse.col .le. see_also.dis_col_end)) then
	            goto 90
	          endif
	        end do
	      endif
	    endif
	    if(mouse.row .eq. 1 .and. mouse.col .gt. screen.ncols-nk_ext)then
	      k = nk_str - screen.ncols+mouse.col
	      if(str(k:k) .eq. letters(1:1)) iterm = key_files
	      if(str(k:k) .eq. letters(2:2)) iterm = key_enter
	      if(str(k:k) .eq. letters(3:3)) iterm = key_seealso
	      if(str(k:k) .eq. letters(4:4)) iterm = key_execute
	    endif
	    if(mouse.row .eq. 2) iterm = key_back
	    if(iterm .eq. 0) then
	      if(mouse.button .eq. key_mouse_1) then
	        if(control.bars) then
	          if(mouse.row .eq. screen.nrows) then		!on horizontal bar
	            if(bar_h.need_bar) then
	              k = mouse.col
	              hor_disp = 10
	              if(k .le. bar_h.nl1) then
	                if(k .eq. bar_h.nl1) hor_disp = 1
	                iterm = key_left
	              elseif(k .gt. bar_h.nl1+bar_h.nl2) then
	                if(k .eq. bar_h.nl1+bar_h.nl2+1) hor_disp = 1
	                iterm = key_right
	              endif
	            endif
	          elseif(mouse.col .eq. screen.ncols) then       !on vertical bar
	            if(bar_v.need_bar) then
	              k = mouse.row-first_line+1		!skip toprows
	              ver_disp = 10
	              if(k .le. bar_v.nl1) then
	                if(k .eq. bar_v.nl1) ver_disp = 1
	                iterm = key_up
	              elseif(k .gt. bar_v.nl1+bar_v.nl2) then
	                if(k .eq. bar_v.nl1+bar_v.nl2+1) ver_disp = 1
	                iterm = key_down
	              endif
	            endif
	          endif
	        else
	          if(mouse.col .lt. ncols_v/4) then	!left quarter of screen
	            hor_disp = ncols_v/4 - mouse.col
	            iterm = key_left
	          elseif(mouse.col .gt. 3*ncols_v/4) then	!right quarter of scr 
	            hor_disp = mouse.col - 3*ncols_v/4
	            iterm = key_right
	          else					!middle half of screen
	            if(mouse.row .lt.  screen.nrows /2) then
	              iterm = key_up
	              ver_disp = screen.nrows/2-mouse.row
	            else
	              iterm = key_down
	              ver_disp = mouse.row - screen.nrows/2
	            end if
	          endif
	        endif
	      elseif(mouse.button .eq. key_mouse_2) then
	        iterm = key_enter
	      elseif(mouse.button .eq. key_mouse_3) then
	        iterm = key_seealso
	      end if
	    end if
	    if(iterm .eq. 0) goto 15
	  end if
	end if
	first = .false.
	if(iterm .eq. key_remove) goto 15
c
	if(set_rev) then
	  call smg$change_rendition(display_id,row_wanted,col_wanted,1,
     1                                 control.search_string_fnd)
c     1                                control.search_string_l)
	  set_rev = .false.
	end if
c
	if(iterm .eq. key_kp8) then
c
c Map kp8 (page move) to either next_screen or prev_screen
c
	  if(forward) then
	    iterm = key_scrdwn
	  else
	    iterm = key_scrup
	  endif
	endif
	if(iterm .eq. key_file) then		!to file session
	  ret_sta = ret_to_file
	  goto 90
	elseif(iterm .eq. key_print) then	!print session
	  ret_sta = ret_to_printer
	  goto 90
	elseif(iterm .eq. key_execute) then	!print session
	  if(head.lun_exe.lun .ne. 0) then
	    call fshelp_getmsg(fshelp_scripts,nkln1,ln1)
	    call screen_select(head.lun_exe,ret_sta,0,0,ln1(1:nkln1),
     1                control,forward)
	    if(ret_sta .ne. 0) then
	      call vm_rewind(head.lun_exe.lun)
	      do k=1,ret_sta
	        call vm_read(head.lun_exe.lun,l,sizeof(exe_blk),l,exe_blk)
	      end do
c
	      call fshelp_smg_execute(control,
     1          exe_blk.execute_line(1:exe_blk.nk_execute_line))
	    endif
	  else
	    call fshelp_mess(fshelp_noexe)
	  endif
c
	elseif(iterm .eq. key_disp_info) then
	  if(pf1_flag) then
	    call smg$read_from_display(display_id,line,,ypos)
	    call display_full(control,screen,line)
	  else
	    if(.not. fshelp_disp_info(control)) then
	      ret_sta = ret_abort
	      goto 90
	    end if
	  endif
	elseif(iterm .eq. key_ch_width) then
c
c Delete virt displays 
c
	  if(bar_h.dis_id .ne. 0)
     1        call smg$delete_virtual_display(bar_h.dis_id)
	  if(bar_v.dis_id .ne. 0)
     1        call smg$delete_virtual_display(bar_v.dis_id)
	  left_col = 1
	  call check_bars(control,screen,nhd,ncols,n_text,nlines_v,ncols_v,
     1         bar_h,bar_v)
	  call smg$change_viewport(display_id,top_line,1,nlines_v,ncols_v)
	  call main_dis_header(control,.true.)
	  call smg$change_viewport(display_id_hd,1,1,nhd,ncols_v)
c
	  if(bar_v.need_bar) then
	    call smg$paste_virtual_display(bar_v.dis_id,screen.paste_id,
     1               first_line,screen.ncols)
	  end if
	  if(bar_h.need_bar) then
	    call smg$paste_virtual_display(bar_h.dis_id,screen.paste_id,
     1               screen.nrows,1)
	  endif
	elseif(iterm .eq. key_disp_bin) then
	  disp_binary = .not. disp_binary
	  call smg$delete_virtual_display(display_id)
	  if(nhd .gt. 0) call smg$delete_virtual_display(display_id_hd)
	  goto 1
	elseif(iterm .eq. key_swap_bars) then
	  if(bar_h.dis_id .ne. 0)
     1        call smg$delete_virtual_display(bar_h.dis_id)
	  if(bar_v.dis_id .ne. 0)
     1        call smg$delete_virtual_display(bar_v.dis_id)
	  control.bars = .not. control.bars
	  call check_bars(control,screen,nhd,ncols,n_text,nlines_v,ncols_v,
     1         bar_h,bar_v)
	  if(bar_v.need_bar) then
	    call smg$paste_virtual_display(bar_v.dis_id,screen.paste_id,
     1               first_line,screen.ncols)
	  end if
	  if(bar_h.need_bar) then
	    call smg$paste_virtual_display(bar_h.dis_id,screen.paste_id,
     1               screen.nrows,1)
	  endif
	elseif(iterm .eq. key_abort) then
	  ret_sta = ret_abort
	  goto 90
	elseif(iterm .eq. key_up) then
	  ypos = ypos - ver_disp
	elseif(iterm .eq. key_left) then
	  if(left_col .le. 1) then
	    call fshelp_mess(fshelp_firstc)
	  else
	    if(pf1_flag) then
	      left_col = 1
	    else
	      left_col = max(left_col-hor_disp,1)
	    end if
	    call smg$change_viewport(display_id,top_line,left_col,
     1            nlines_v,ncols_v)
	    call smg$change_viewport(display_id_hd,1,left_col,
     1            nhd,ncols_v)
	  end if
	elseif(iterm .eq. key_right) then
	  if(left_col + ncols_v .gt. ncols) then
	    call fshelp_mess(fshelp_alltxt)
	  else
	    if(pf1_flag) then
	      left_col = ncols-ncols_v+1
	    else
	      left_col = min(left_col + hor_disp,ncols-ncols_v+1)
	    end if
	    call smg$change_viewport(display_id,top_line,left_col,
     1            nlines_v,ncols_v)
	    call smg$change_viewport(display_id_hd,1,left_col,
     1            nhd,ncols_v)
	  end if
	elseif(iterm .eq. key_forw) then
	  if(pf1_flag) then
	    ypos = n_text
	  else
	    forward = .true.
	  end if
	elseif(iterm .eq. key_backw) then
	  if(pf1_flag) then
	    ypos = 1
	  else
	    forward = .false.
	  end if
	elseif(iterm .eq. key_down) then
	  ypos = ypos+ver_disp
	elseif(iterm .eq. key_scrup) then
	  if(pf1_flag) then
	    ypos = 1
	  else
	    ypos = ypos-nlines_v
	  end if
	elseif(iterm .eq. key_scrdwn) then
	  if(pf1_flag) then
	    ypos = n_text
	  else
	    ypos = ypos+nlines_v
	  end if
	elseif(iterm .eq. key_find) then
	  if(pf1_flag .or. control.search_string_l .eq. 0) then
	    control.search_string_l = 0
	    call ask_sear_string(control,forward,.true.,all_libs)
	  end if
	  ret_sta = ret_find_data
	  if(all_libs) ret_sta = ret_find_data_all
	  if(control.search_string_l .eq. 0) then
	    call fshelp_mess(fshelp_seastr)
	  else
	    goto 90
	  end if
	elseif(iterm .eq. key_search) then
	  if(pf1_flag .or. control.search_string_l .eq. 0) then
	    control.search_string_l = 0
	    call ask_sear_string(control,forward,.false.,all_libs)
	    row_wanted = 0
	  end if
	  if(row_wanted .eq. 0) row_wanted = ypos
	  if(control.search_string_l .eq. 0) then
	    call fshelp_mess(fshelp_seastr1)
	  else
	    if(find_string(control.search_string(1:control.search_string_l),
     1                  display_id,row_wanted,n_text,
     1                  forward,col_wanted,
     1                  control.search_string_fnd)) then
	      if(whole) then
	        ypos = row_wanted
	        xpos = col_wanted
	      else
 	        if(row_wanted .lt. ypos+nlines_v/4 .or.
     1             row_wanted .gt. ypos+nlines_v*3/4) then
c
c if too far outsize the middle of the display , than redisplay
c
	          ypos = row_wanted-nlines_v/2
	        end if
	      endif
	      set_rev = .true.
	    else
	      call fshelp_mess(fshelp_notfnd)
	    end if
	  end if
	elseif(iterm .eq. key_enter .or.
     1        (iterm .gt. ichar(' ') .and. iterm .le. 125)) then
	  if(head.idx_autoalso .ne. 0) then
	    is_autolink = .true.
	    ret_sta = ret_first_seealso-head.idx_autoalso
	    goto 90
	  endif
c
	  if(head.deeper.lun .ne. 0) then
	    if(iterm .lt. ichar(' ') .or. iterm .gt. 125) iterm = 0
	    call fshelp_getmsg(fshelp_helpi,nkln1,ln1)
	    call screen_select(head.deeper.lun,k,iterm,sel_item,
     1            ln1(1:nkln1),control,forward)
	    if(k .ne. 0) then
	      ret_sta = k
	      goto 90
	    end if
	    if(display_empty) then
	      ret_sta = 0
	      goto 90
	    end if
	  else
	    call fshelp_mess(fshelp_nodeep)
	  end if
	elseif(iterm .eq. key_back) then
	  ret_sta = ret_level_up
	  goto 90
	elseif(iterm .eq. key_his_up) then		!previous his
	  if(control.n_his .gt. 0) then
	    ret_sta = ret_last_history
	    if(pf1_flag) ret_sta = ret_sel_history
	    goto 90
	  else
	    call fshelp_mess(fshelp_nohist)
	  end if
	elseif(iterm .eq. key_his_back) then		!previous his
	  if(control.n_his .gt. 0) then
	    ret_sta = ret_sel_history
	    if(pf1_flag) ret_sta = ret_last_history
	    goto 90
	  else
	    call fshelp_mess(fshelp_nohist)
	  end if
	elseif(iterm .ge. key_mark1 .and. iterm .le. key_marku) then
	  call main_set_mark(control,iterm,pf1_flag,ret_sta,0,0,forward)
	  if(ret_sta .ne. 0) then
	    if(ret_sta .gt. 0) ret_sta = ret_first_mark-ret_sta
	    goto 90
	  end if
	elseif(iterm .eq. key_seealso) then		!select seealso
	  if(head.lun_see.lun .eq. 0) then
	    call fshelp_mess(fshelp_noverw)
	  else
	    call fshelp_getmsg(fshelp_sealso,nkln1,ln1)
	    call screen_select(head.lun_see,ret_sta,0,0,ln1(1:nkln1),
     1                control,forward)
	    if(ret_sta .ne. 0) then
	      if(ret_sta .gt. 0) ret_sta = ret_first_seealso-ret_sta
	      goto 90
	    endif
	  end if
	elseif(iterm .eq. key_files) then
	  if(is_libs) then
	    ret_sta = ret_change_file
	    goto 90
	  else
	    call fshelp_mess(fshelp_nolibr)
	  end if
	else
	  call fshelp_mess(fshelp_wrkey)
	end if
80	pf1_flag = .false.
	goto 10
90	row_wanted = 0
	col_wanted = 0
95	if(ret_sta .eq. ret_abort .and. .not. control.pasalr) then
c
c User want exit, so leave the screen as is
c
	  k = smg$set_cursor_abs(display_id,
     1             max(1,min(n_text,top_line+nlines_v-1)),1)	
	  if(.not. k) call lib$signal(%val(k))
	else
	  call smg$delete_virtual_display(display_id)
	  if(nhd .gt. 0) then
	    call smg$delete_virtual_display(display_id_hd)
	  end if
	end if
	if(lun_bin .ne. 0) call vm_close(lun_bin)
c
	if(bar_v.dis_id .ne. 0) then
	  call smg$delete_virtual_display(bar_v.dis_id)
	end if
	if(bar_h.dis_id .ne. 0) then
	  call smg$delete_virtual_display(bar_h.dis_id)
	end if
	return
	end

	subroutine check_bars(control,screen,nhd,ncols,n_text,
     1          nlines_v,ncols_v,bar_h,bar_v)   

	implicit none
c
	include 'fshelp.inc'
	record /control/ control
	record /screen/ screen
c
	integer*4 ncols
	integer*4 nhd
	integer*4 n_text
	integer*4 nlines_v
	integer*4 ncols_v
	record /bar/  bar_h
	record /bar/ bar_v
c
	include '($smgdef)'
c
	nlines_v = screen.nlines-nhd
	ncols_v  = screen.ncols
	bar_h.dis_id = 0
	bar_h.need_bar = .false.
	bar_v.dis_id = 0
	bar_v.need_bar = .false.
c
	if(control.bars) then
	  if(n_text .gt. nlines_v) then
c
c Too long, add bar at right side, so one less column
c
	    ncols_v = ncols_v - 1
	    bar_v.need_bar = .true.
	  end if
c
	  if(ncols .gt. ncols_v) then
c
c Too wide, add bar at bottom, so one line less
c
	    nlines_v = nlines_v - 1
 	    bar_h.need_bar = .true.
	    if(.not. bar_v.need_bar) then
c
c And check again for #lines
c
	      if(n_text .gt. nlines_v) then
c
c Becauseone line less, check if we already have a side bar, if not add one
c
	        ncols_v = ncols_v - 1
	        bar_v.need_bar = .true.
	      end if
	    end if
	  end if
	  if(bar_v.need_bar) then
	    call create_bar_disp(bar_v,.false.,nlines_v,n_text)
	  end if	  
	  if(bar_h.need_bar) then
	    call create_bar_disp(bar_h,.true.,ncols_v,ncols)
	  end if
	end if
	ncols_v  = min(ncols,ncols_v)
	return
	end
c##
	subroutine create_bar_disp(bar,horizontal,nlines_scr,nlines_tot) 
	implicit none
c
	include 'fshelp.inc'
	record /bar/ bar		!:i: bar structure
	logical*4 horizontal		!:i: hor/ver bar
	integer*4 nlines_scr		!:i: width/length viewport
	integer*4 nlines_tot		!:i: total lines in display
c
	include '($smgdef)'
c
	bar.need_bar  = .true.
	bar.tot_lines = nlines_tot
	bar.scr_lines = nlines_scr
	bar.horizontal = horizontal
	if(bar.horizontal) then
	  call smg$create_virtual_display(1,nlines_scr,bar.dis_id)
	else
	  call smg$create_virtual_display(nlines_scr,1,bar.dis_id)
	end if	  
	return
	end

	options /exten
	subroutine help_lookat(control)
	implicit none
	integer*4 control
c
c Help for lookat_data routine
c
	external fshelp_hlpmai
c
	call general_help(fshelp_hlpmai,control)
	return
	end

	options /exten
	subroutine help_select(control)
	implicit none
c
c Help for select_item routine
c
	integer*4 control
c
	external fshelp_hlpsel
	call general_help(fshelp_hlpsel,control)
	return
	end

	subroutine general_help(help_mess,control)
	implicit none
c
c Genereal help display
c
	include 'fshelp.inc'
c	integer*4 nlines			!:i: #lines help
c	character*(*) help_text(*)		!:i: the help text
	integer help_mess
	record /control/ control
c
c Common for screen display
c
	record /screen/ screen
	common /fshelp_screen/ screen
	external fshelp_contin,fshelp_addhlp
c
	integer language,n_language
	common /fshelp_language/ language,n_language
c
	integer*4 hlp_id,line_size,i,nk,nk_l,msid,nlines,nrows_displ,toprow
	integer*4 topcol,ncols_displ,k
	logical pf1_flag
	character*60 line
	character*132 hlpline
c
	include '($smgdef)'
c
	line_size = 0
	nlines = 0
	msid = %loc(help_mess)
10	call fshelp_getmsg(%val(msid),nk_l,hlpline)
	if(hlpline(1:2) .ne. '##') then
	  nlines = nlines + 1
	  msid = msid + n_language*8
	  line_size = max(line_size,nk_l)
	  goto 10
	endif
c
c Creeer display
c
	call smg$create_virtual_display(nlines,line_size,hlp_ID,smg$m_border)
	call fshelp_getmsg(fshelp_contin,nk,line)
	call smg$label_border(hlp_id,line(1:nk),smg$k_bottom)
c
	msid = %loc(help_mess)
	do i=1,nlines
	  call fshelp_getmsg(%val(msid),nk_l,hlpline)
	  msid = msid + n_language*8
	  if(hlpline(1:1) .eq. '@') then
	    call smg$put_chars(hlp_id,hlpline(2:nk_l),i,1,,smg$m_bold)
	  else
	    call smg$put_chars(hlp_id,hlpline(1:nk_l),i,1)
	  end if
	end do
	nrows_displ = screen.nrows - 4
	ncols_displ = screen.ncols - 4
	call smg$create_viewport(hlp_id,1,1,nrows_displ,ncols_displ)
c
	call smg$paste_virtual_display(hlp_id,screen.paste_id,3,3)
	toprow = 0
	topcol = 0
	pf1_flag = .false.
20	pf1_flag = .false.
21	call screen_get_one_key(i,control)
	if(i .eq. smg$k_trm_pf1) then
	  pf1_flag = .true.
	  goto 21
	endif
	if(i .eq. smg$k_trm_prev_screen) then
	  pf1_flag = .true.
	  i = smg$k_trm_up
	elseif(i .eq. smg$k_trm_next_screen) then
	  pf1_flag = .true.
	  i = smg$k_trm_down
	endif
	if(i .eq. smg$k_trm_help) then
	  call fshelp_mess(fshelp_addhlp)
	elseif(i .eq. smg$k_trm_left) then
	  if(topcol .gt. 0) then
	    k = 1
	    if(pf1_flag) k = topcol
	    topcol = topcol - k
	    call smg$scroll_viewport(hlp_id,smg$m_right,k)
	  endif
	elseif(i .eq. smg$k_trm_right) then
	  if(topcol + ncols_displ .lt. line_size) then
	    k = 1
	    if(pf1_flag) k = line_size - ncols_displ
	    topcol = topcol + k
	    call smg$scroll_viewport(hlp_id,smg$m_left,k)
	  endif
	elseif(i .eq. smg$k_trm_up) then
	  if(toprow .gt. 0) then
	    k = 1
	    if(pf1_flag) k = min(toprow,screen.nrows-5)
	    toprow = toprow - k
	    call smg$scroll_viewport(hlp_id,smg$m_down,k)
	  endif
	elseif(i .eq. smg$k_trm_down) then
	  if(toprow+nrows_displ .lt. nlines) then
	    k = 1
	    if(pf1_flag) k = min(nlines-nrows_displ,screen.nrows-5)
	    toprow = toprow + k
	    call smg$scroll_viewport(hlp_id,smg$m_up,k)
	  endif
	else
	  goto 80
	endif
	goto 20
80	call smg$delete_virtual_display(hlp_id)
	return
	end

	options /exte
c	subroutine ask_sear_string(sear_string,sear_string_l,forward,global)
	subroutine ask_sear_string(control,forward,global,all_libs)
c
c Lets user enter a search string
c via a special virtual_display
c
	implicit none
	include 'fshelp.inc'
	record /control/ control	!:io: cotnrol structure 
	logical*4 forward		!:io: forward
	logical*4 global		!:i: global search wanted
	logical all_libs		!:o: all_lib search wanted?
c
	include '($smgdef)'
c
	integer*4 iterm
c
	external fshelp_seaprom,fshelp_seaprog,fshelp_hlpsea,fshelp_seaproa
	character*50 ln1
	integer*4 nkln1
c
	all_libs = .false.
c
c Start of coding
c
10	if(.not. global) then
	  call fshelp_getmsg(fshelp_seaprom,nkln1,ln1)
	  call ask_string(control.search_string,control.search_string_l,
     1                    ln1(1:nkln1),iterm)
	else
12	  if(all_libs) then
	    call fshelp_getmsg(fshelp_seaproa,nkln1,ln1)
	  else
	    call fshelp_getmsg(fshelp_seaprog,nkln1,ln1)
	  endif
	  call ask_string(control.search_string,control.search_string_l,
     1                    ln1(1:nkln1),iterm)
	  if(iterm .eq. smg$k_trm_f20) then
	    all_libs = .not. all_libs
	    goto 12
	  endif
	end if
	if(iterm .eq. smg$k_trm_help .or. iterm .eq. smg$k_trm_pf2) then
	  call general_help(fshelp_hlpsea,control)
	  goto 10
	end if
	if(iterm .eq. smg$k_trm_kp4) forward = .true.
	if(iterm .eq. smg$k_trm_kp5) forward = .false.
c
	return
	end

	subroutine ask_string(string,string_l,header,iterm)
c
c Lets user enter a search string
c via a special virtual_display
c
	implicit none
	character*(*) string		!:io: searsch string
	integer*4 string_l		!:io: length of search string 
	character*(*) header		!:i: border label
	integer*4 iterm			!:i: terminator
c
c Common for screen display
c
c
	include 'fshelp.inc'
	record /screen/ screen
	common /fshelp_screen/ screen
c
	include '($smgdef)'
c
	integer*4 sea_id,nb
c
c Start of coding
c
	nb = max(len(string),len(header))
c
c Create a (boxed) virtual display
c
	call smg$create_virtual_display(1,nb,SEA_ID,smg$m_border)
	call smg$paste_virtual_display(sea_id,screen.paste_id,20,80-nb)
	call smg$label_border(sea_id,header)
c
c Read a string with default the old one
c
	call smg$set_keypad_mode(screen.keyboard_id,smg$m_keypad_application)
	call smg$read_string(screen.keyboard_id,string,,
     1                       nb,,,,string_l,
     1                       iterm,sea_id,
     1                       string(1:string_l))
	call smg$set_keypad_mode(screen.keyboard_id,0)
c
c Delete display
c
	call smg$delete_virtual_display(sea_id)
	return
	end

	function find_string(search_string_inp,display_id,fnd_lin,nlines,
     1                       forward,fnd_col,nbyte)
c
c Look for a string in current display (no deeper items) 
c starting on fnd_lin,fnd_col
c either forward or backward
c
	implicit none
	include 'fshelp.inc'
	character*(*) search_string_inp	!:i: search_string
	integer*4 display_id		!:i: display_id
	integer*4 fnd_lin			!:i: current position
	integer*4 nlines			!:i: #lines in display
	logical*4 forward		!:i: forwrad/backward search
	integer*4 fnd_col			!:io: position in screen
	integer nbyte
	logical*4 find_string		!:f: true if found
c
	integer*4 yp,jpos,ns,k,lenl
	character*(max_line_length) regel
	character*(max_line_length) search_string
	integer find_string_wild
	integer*4 get_len
c
	yp = fnd_lin
c
	find_string =.true.
	call str$upcase(search_string,search_string_inp)
	ns = len(search_string_inp)
c
10	call smg$read_from_display(display_id,regel,,yp)
	call str$upcase(regel,regel)
	lenl = max(1,get_len(regel))
	if(yp .eq. fnd_lin) then
c
c search on current line
c
	  if(forward) then
	    jpos = find_string_wild(regel(fnd_col+1:lenl),search_string(1:ns),
     1                      nbyte)
	    if(jpos .eq. 0) then
	      fnd_col = 0
	    else
	      fnd_col = jpos+fnd_col
	    end if
	  else
	    regel(fnd_col:) = ' '
	    fnd_col = 0
11	    k = find_string_wild(regel(fnd_col+1:lenl),
     1              search_string(1:ns),nbyte)
	    if(k .ne. 0) then
	      fnd_col = fnd_col+k
	      goto 11
	    endif
	  end if
	else
c
c On non current line we can search all positions
c
	  if(forward) then
	    fnd_col = find_string_wild(regel(1:lenl),search_string(1:ns),nbyte)
	  else
c
c We must find the last one
c
c	    fnd_col = find_string_wild(regel(1:lenl),search_string(1:ns),nbyte)
	    fnd_col = 0
12	    k = find_string_wild(regel(fnd_col+1:lenl),search_string(1:ns),
     1                           nbyte)
	    if(k .ne. 0) then
	      fnd_col = fnd_col+k
	      goto 12
	    endif
	  endif
	end if	
	if(fnd_col .ne. 0) then
	  fnd_lin = yp
	  goto 90
	end if
c
c Not found, so try next line
c
	if(forward) then
	  yp = yp+1
	  if(yp .gt. nlines) goto 80
	else
	  yp = yp-1
	  if(yp .eq. 0) goto 80
	end if
	goto 10
c
80	call smg$ring_bell(display_id)
	find_string =.false.
90	return
	end

	subroutine screen_select(lun,ind,ini_kar,sel_item,topic,
     1                           control,forward)
	implicit none
c
c Let the user slect from a list of items
c selection can be done via cursor moves, or via character search
c The items are displayed
c
	include 'fshelp.inc'
	record /lun/ lun		!:i: header record
	integer*4 ind			!:o: selected number
	integer*4 ini_kar		!:i: initial char
	integer*4 sel_item		!:i: initial choise
	character*(*) topic		!:i: Header topic
	record /control/ control	!:io: control bock
	logical*4 forward		!:io: for/backward search
c
c Common for screen display
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
c	record /pos/ pos,pos1
	integer*4 lun_pos
c
	integer*4 display_id,nl,k,l,ipos,n_items,max_l,size,max_l1
	logical*4 vertical,old_vertical  !,offs
c
	character*(max_line_length) regel
	logical*4 vm_read
c
	record /header/ rec
c
c
c Start diplaying
c do it in two passes
c first time : cpompute #lines to display
c second time: display the items
c
10	if(control.vertical .eq. sel_aut) then
	  call vm_file_info(lun.lun,k)
	  vertical = k .le. screen.nrows-6
	else
	  vertical = control.vertical .eq. sel_ver
	end if

	lun_pos = 0
c
	size = sizeof(rec)
	max_l = lun.max_len
	max_l1 = max(20,max_l)
	do l=1,2			!2 passes
	  regel = ' '
	  nl    = 0
	  ipos  = 0
	  call vm_rewind(lun.lun)
	  n_items = 0
	  do while(vm_read(lun.lun,k,size,k,rec))
	    n_items = n_items+1
	    call fill_line(regel,ipos,nl,rec.key(1:rec.nkar_key),
     1                    l.eq.1,display_id,lun_pos,max_l,vertical,
     1                    rec.has_extra)
	  end do
c  
	  if(l .eq. 1) then			!first passs
	    nl = nl + 1
	    if(vertical) then
	      call smg$create_virtual_display(n_items,screen.ncols,display_id)
	    else
	      call smg$create_virtual_display(nl,screen.ncols,display_id)
	    end if
	    call smg$label_border(display_id,' ')
	  else					!second pass only
	    call smg$put_line(display_id,regel(1:ipos))
	  end if
	end do
c
	old_vertical = vertical
	call screen_select_items_disp(display_id,lun_pos,n_items,
     1            topic,ind,ini_kar,sel_item,control.nlines_help,
     1            vertical,max_l1,control.searchwild,
     1            control,forward)
c
	if(old_vertical .ne. vertical) then
	  if(vertical) then
	    control.vertical = sel_ver
	  else
	    control.vertical = sel_hor
	  endif
	end if
	call smg$delete_virtual_display(display_id)
	call vm_close(lun_pos)
	if(ind .eq. -3) goto 10
	return
	end

	subroutine fill_line(regel,ipos,nl,item,first_pass,
     1                       display_id,lun_pos,it_len,
     1                       vertical,has_extra)
	implicit none
c
	character*(*) regel	!:io: work area
	integer*4 ipos		!:IO pos in line (init at 0)
	integer*4 nl		!:io linenr (init at 0)
	character*(*) item	!:i: The text to include
	logical*4 first_pass	!:i: first/second pass
	integer*4 display_id	!:i: display id
	integer*4 lun_pos	!:i: lun for position
	integer*4 it_len	!:i: length of items
	logical*4 vertical
	logical has_extra	!:i: this topic has slash items
c
	include 'fshelp.inc'
	record /screen/ screen
	common /fshelp_screen/ screen
	record /pos/ pos
c
	integer*4 nk,nk_it
c
	if(lun_pos .eq. 0) call vm_open(lun_pos,100,sizeof(pos),,
     1                                  %descr('FSHELP_POSITION'))
c
c Common for screen display
c
	nk_it  = help_item_size
	if(it_len .ne.0) nk_it  = min(help_item_size,it_len+1)
c
	nk = len(item)
c
	if(has_extra .or. (ipos + nk) .gt. screen.ncols-1) then
	  if(.not. first_pass) then			!second pass only
	    if(ipos .gt. 0) then
	      call smg$put_line(display_id,regel(1:ipos))
	    endif
	  end if
	  if(ipos .gt. 0) nl = nl + 1	
	  regel = ' '
	  ipos = 0
	endif
	if(.not. first_pass) then			!second pass only
	  pos.xpos = ipos+1
	  pos.ypos = nl+1
	  pos.size = nk
	  call vm_write_fix(lun_pos,0,pos)
	  regel(ipos+1:ipos+nk) = item
	end if
c
c Afronden op n*nk_it
c
	if(vertical) then
	  ipos = screen.ncols+1
	else
	  nk = (nk/nk_it +1 )*nk_it
	  if(has_extra) nk = screen.ncols+1	!so the next is new line
	  ipos = min(ipos+nk,screen.ncols)
	end if
	return
	end

	subroutine screen_select_items_disp(display_id,lun_pos,
     1          n_items,border_text,ind,ini_kar,ini_choise,
     1          nlines_help,vertical,max_l_inp,searchwild,
     1          control,forward)
	implicit none
c
c Let the user slect from a list of items
c selection can be done via cursor moves, or via character search
c The items are displayed
c
	include 'fshelp.inc'
c
	integer*4 display_id 		!:i: display_id
	integer*4 lun_pos		!:i: file for positions
	integer*4 n_items		!:i: #items
	character*(*) border_text	!:i: text above display(border)
	integer*4 ind 			!:o: select item
	integer*4 ini_kar		!:i: initial kar
	integer*4 ini_choise		!:i: initial choise
	integer*4 nlines_help		!:i: size of window
	logical*4 vertical		!:i: display topics vertical
	integer*4 max_l_inp		!:i: width of vertical display
	logical*4 searchwild		!:i: searchpath is wild
	record/control/control		!:io: control structure
	logical*4 forward		!:io: for/backward search
c
	include '($smgdef)'
c
	external help_select
c
c Common for screen display
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	record /pos/ pos,pos1,pos2,pos3
	integer*4 nb_pos
	record /bar/ bar
c
	integer*4 iterm,top_line,nl,k,l,video
	integer*4 nkar_s,nl_help,oypos,bpos,epos,incr,nk_mcount
c
	character*10 sear
	character*200 regel_tmp
	character*80 count,mcount
c
	logical*4 pf1_flag,fnd
c
	record /mouse/ mouse
c
	integer*4 max_lines,nkar_c,col,win_nc,max_l
c
	external fshelp_wrkey,fshelp_notfnd1,fshelp_seafull,fshelp_seaemp
	external fshelp_nomorl,fshelp_nolesl
	external fshelp_count
	integer*4 fshelp_disp_info
c
	max_l = max_l_inp
	nb_pos = sizeof(pos)
c
c Compute size of display
c
	call vm_read_rec_fix(lun_pos,n_items,l,pos)
	max_lines = pos.ypos
	if(vertical) then
	  col = screen.ncols-max_l
	else
	  col = 1
	end if
	if(nlines_help .eq. 0 .or. vertical) then
	  nl_help = min(max_lines,screen.nrows-4)
	else
	  nl_help = min(max_lines,nlines_help)
	end if
c
	if(vertical) then
	  call smg$create_viewport(display_id,1,1,nl_help,max_l)
	  win_nc = max_l
	else
	  call smg$create_viewport(display_id,1,1,nl_help,screen.ncols)
	  win_nc = screen.ncols
	end if
c
c
c paste virtual display on screen
c
	ind = 1
	if(ini_choise .ne. 0) ind = ini_choise
c
	top_line = 1
	nkar_s   = 0
	bar.dis_id = 0
c
c paste the display, also reentry after changing of size of display
c
8	call smg$paste_virtual_display(display_id,screen.paste_id,
     1           screen.nrows-nl_help+1,col)
c
9	if(bar.dis_id .ne. 0) call smg$delete_virtual_display(bar.dis_id)
 
	if(control.bars .and. nl_help .lt. max_lines) then
	  call create_bar_disp(bar,.false.,nl_help,max_lines)
	  call smg$paste_virtual_display(bar.dis_id,screen.paste_id,
     1           screen.nrows-nl_help+1,screen.ncols)
	end if
c
c Compute xpos/ypos
c
10	call vm_read_rec_fix(lun_pos,ind,l,pos)
	call fshelp_getmsg(fshelp_count,nk_mcount,mcount)
	call sys$fao(mcount(1:nk_mcount),nkar_c,count,%val(ind),
     1           %val(n_items),border_text)
	if(vertical) then
	  l = max_l
	else
	  l = screen.ncols
	end if
	if(nkar_s .eq. 0) then
	  if(nkar_c .gt. l) nkar_c = l
	else
	  if(nkar_c +nkar_s + 1 .gt. l) nkar_c = l - 1 - nkar_s
	  count(nkar_c+1:) = ' '//sear(1:nkar_s)
	  nkar_c = nkar_c + 1 + nkar_s
	end if
	call smg$label_border(display_id,count(1:nkar_c))
c
c check of nog op scherm
c
	if(pos.ypos .lt. top_line) then
	  nl = top_line - pos.ypos		!zovee omhoog
	  call smg$scroll_viewport(display_id,smg$m_down,nl)
	  top_line = top_line - nl
	end if
	if(pos.ypos .ge. top_line+nl_help) then
	  nl = pos.ypos - (top_line+nl_help-1)
	  call smg$scroll_viewport(display_id,smg$m_up,nl)
	  top_line = top_line + nl
	end if
c
	call display_bar(bar,top_line) !,max_lines,top_line,nl_help,.false.)
c
c Now highlight the data
c
	video = smg$m_reverse
	if(control.colour) video = smg$m_user6		!red colour
	call smg$change_rendition(display_id,pos.ypos,pos.xpos,1,pos.size,
     1                            video)
c
c set cursor
c
	call smg$set_cursor_abs(display_id,pos.ypos,pos.xpos)
c
c Get key
c
	if(ini_kar .ne. 0) then
	  iterm = ini_kar
	  ini_kar = 0
	  pf1_flag = .false.
	else
15	  call screen_getkey(iterm,pf1_flag,help_select,control)
	  if(iterm .eq. key_remove) goto 15
	  mouse.iterm = iterm
	  if(mouse.button .eq. key_mouse_1 .or. 
     1       mouse.button .eq. key_mouse_2 .or.
     1       mouse.button .eq. key_mouse_3 .or. 
     1       mouse.button .eq. key_mouse_4) then
	    pf1_flag = .false.
	    iterm = 0
c
c Mouse pressed, make row relative to this window
c
	    mouse.row = mouse.row - (screen.nrows-nl_help+1)
	    mouse.col = mouse.col - col + 1
	    if(mouse.button .eq. key_mouse_1) then
c
c If mouse outside window, than back (to text)
c
	      if(mouse.row .lt.-1 .or. mouse.col .lt. 0) then
	        iterm = key_back
c
c Check if mouse pressed in right margin, if so it is scroll up/down
c
	      elseif(mouse.col .gt. win_nc-2) then
	        if(mouse.row .lt. nl_help/2) then
	          iterm = key_scrup
	        else
	          iterm = key_scrdwn
	        end if
	      else
c
c If not it must be a selection
c
	        do k=1,n_items
	          call vm_read_rec_fix(lun_pos,k,l,pos3)
	          if(pos3.ypos .eq. mouse.row+top_line) then
	            if(pos3.xpos           .le. mouse.col .and.
     1                 pos3.xpos+pos3.size .ge. mouse.col) goto 9012
	          end if
	        end do
	        goto 15
9012	        ind   = k
	        iterm = key_enter
	      end if
	    elseif(mouse.button .eq. key_mouse_2) then
	      pf1_flag = .true.
	      if(mouse.row .lt. -1) then
	        iterm = key_up
	      else
	        iterm = key_down
	      end if
	    elseif(mouse.button .eq. key_mouse_3) then
	      pf1_flag = .true.
	      iterm = key_toggle
	    end if
	  end if
	end if
c
c
c Clear the video mode
c
	call smg$change_rendition(display_id,pos.ypos,pos.xpos,1,pos.size)
c
	if(iterm .ge. ichar(' ') .and. iterm .lt. 127) then
	  if(nkar_s .lt. len(sear)) then
	    nkar_s = nkar_s + 1
	    if(iterm .ge. ichar('a') .and. iterm .le. ichar('z'))
     1                      iterm = iterm -ichar('a') + ichar('A')
	    sear(nkar_s:nkar_s) = char(iterm)
	    oypos = 0
	    do k=1,n_items
	      call vm_read_rec_fix(lun_pos,k,l,pos2)
	      if(oypos .ne. pos2.ypos) then
	        oypos = pos2.ypos
	        call smg$read_from_display(display_id,regel_tmp,,pos2.ypos)
	      end if
	      call str$upcase(regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1),
     1                      regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1))
	      if(searchwild) then
	        fnd = index(regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1),
     1                 sear(1:nkar_s)) .ne. 0
	      else
	        fnd = regel_tmp(pos2.xpos:pos2.xpos+nkar_s-1) .eq. 
     1                 sear(1:nkar_s)
	      end if
	      if(fnd) then
	        ind = k
	        goto 18
	      end if
	    end do
	    call fshelp_mess_par(fshelp_notfnd1,sear(1:nkar_s))
	    call smg$ring_bell(display_id)
	    nkar_s = nkar_s - 1
18	    continue
	  else
	    call fshelp_mess(fshelp_seafull)
	  end if		
	elseif(iterm .eq. key_find .or. iterm .eq. key_search) then
c##
	  if(forward) then
	    bpos = ind+1
	    epos = n_items
	    incr = 1
	  else
	    bpos = ind-1
	    epos = 1
	    incr = -1
	  endif
	  if(nkar_s .eq. 0) then
	    ind = bpos
	  else
	    do k=bpos,epos,incr
	      call vm_read_rec_fix(lun_pos,k,l,pos2)
	      if(oypos .ne. pos2.ypos) then
	        oypos = pos2.ypos
	        call smg$read_from_display(display_id,regel_tmp,,pos2.ypos)
	      end if
	      call str$upcase(regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1),
     1                      regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1))
	      if(searchwild) then
	         fnd = index(regel_tmp(pos2.xpos:pos2.xpos+pos2.size-1),
     1                 sear(1:nkar_s)) .ne. 0
	      else
	        fnd = regel_tmp(pos2.xpos:pos2.xpos+nkar_s-1) .eq. 
     1                 sear(1:nkar_s)
	      end if
	      if(fnd) then
	        ind = k
	        goto 181
	      end if
	    end do
	    call fshelp_mess_par(fshelp_notfnd1,sear(1:nkar_s))
	    call smg$ring_bell(display_id)
	  endif
181	  continue
	elseif(iterm .eq. key_delete_one .or. iterm .eq. key_delete_all) then
	  if(nkar_s .gt.0) then
	    if(iterm .eq. key_delete_one) then
	      nkar_s= nkar_s-1
	    else
	      nkar_s = 0
	    end if
	  else
	    call fshelp_mess(fshelp_seaemp)
	  end if
	elseif(iterm .eq. key_swap_bars) then
	  control.bars = .not. control.bars
	  goto 9
	elseif(iterm .eq. key_forw) then
	  if(pf1_flag) then
	    ind = n_items
	  else
	    forward = .true.
	  end if
	elseif(iterm .eq. key_backw) then
	  if(pf1_flag) then
	    ind = 1
	  else
	    forward = .false.
	  end if
	elseif(iterm .eq. key_up) then
	  if(pf1_flag) then
	    if(vertical) then
	      ind = max(1,ind - nl_help)
	    else
	      if(nlines_help .gt. 0 .and. 
     1          (nl_help .lt. max_lines .and.
     1           nl_help .lt. screen.nrows-3))then
	        nlines_help = nlines_help + 1
	        nl_help = nl_help + 1
c	        call smg$change_viewport(display_id,1,1,nl_help,screen.ncols)
	        call smg$change_viewport(display_id,,,nl_help)
	        goto 8
	      else
	        call fshelp_mess(fshelp_nomorl)
	      end if
	    end if
	  else
	    pos1 = pos
	    do while (ind .gt. 1)
	      call vm_read_rec_fix(lun_pos,ind,l,pos)
	      if(pos.ypos .lt. pos1.ypos .and. pos.xpos .le. pos1.xpos)goto 121
	      ind = ind - 1
	    end do
121	  end if
	elseif(iterm .eq. key_scrup) then
	  if(pf1_flag) then
	    ind = 1
	  else
	    pos1 = pos
	    do while (ind .gt. 1) 
	      call vm_read_rec_fix(lun_pos,ind,l,pos)
	      if((pos.ypos .eq. pos1.ypos-nl_help .and.
     1            pos.xpos .le. pos1.xpos) .or.
     1            pos.ypos .lt. pos1.ypos-nl_help) goto 122
	      ind = ind - 1
	    end do
122	  end if
	elseif(iterm .eq. key_down) then
	  if(pf1_flag) then
	    if(vertical) then
	      ind = min(n_items,ind + nl_help)
	    else
	      if(nlines_help .gt. 0 .and. nl_help .gt. 1) then
	        nl_help = nl_help - 1
	        nlines_help = nlines_help - 1
	        call smg$change_viewport(display_id,,,nl_help)
	        goto 8
	      else
	        call fshelp_mess(fshelp_nolesl)
	      end if
	    end if
	  else
	    pos1 = pos
	    do while (ind .lt. n_items)
	      call vm_read_rec_fix(lun_pos,ind,l,pos)
	      if((pos.ypos .gt. pos1.ypos .and. pos.xpos .ge. pos1.xpos) .or.
     1         (pos.ypos .eq. pos1.ypos+2)) goto 123
	      ind = ind + 1
	    end do
123	    if(pos.ypos .eq. pos1.ypos+2) ind = ind-1
	  end if
	elseif(iterm .eq. key_scrdwn) then
	  if(pf1_flag) then
	    ind = n_items
	  else
	    pos1 = pos
	    do while (ind .lt. n_items)
	      call vm_read_rec_fix(lun_pos,ind,l,pos)
	      if((pos.ypos .eq. pos1.ypos+nl_help .and.
     1            pos.xpos .ge. pos1.xpos) .or.
     1           (pos.ypos .gt. pos1.ypos+nl_help)) goto 124
	      ind = ind + 1
	    end do
124	    if(pos.xpos .eq. pos1.ypos+2) ind = ind-1
	  end if
	elseif(iterm .eq. key_right) then
	  if(pf1_flag) then
	    if(vertical) then
	      if(max_l .gt. max_l_inp) then
	        max_l = max_l - 5
	        col = screen.ncols-max_l
	        call smg$change_viewport(display_id,,,,max_l)
	        goto 8
	      end if
	    else
	      pos1 = pos
	      do while (ind .lt. n_items)
	        call vm_read_rec_fix(lun_pos,ind,l,pos)
	        if(pos.ypos .gt. pos1.ypos) goto 125
	        ind = ind+1
	      end do
125	      ind = ind-1
	    end if
	  else
	    ind = min0(n_items,ind + 1)
	  end if
	elseif(iterm .eq. key_left) then
	  if(pf1_flag) then
	    if(vertical) then
	      if(max_l .lt. screen.ncols-10) then
	        max_l = max_l + 5
	        col = screen.ncols-max_l
	        call smg$change_viewport(display_id,,,,max_l)
	        goto 8
	      end if
	    else
	      pos1 = pos
	      do while (ind .ge. 1)
	        call vm_read_rec_fix(lun_pos,ind,l,pos)
	        if(pos.ypos .lt. pos1.ypos) goto 126
	        ind = ind-1
	      end do
126	      ind = ind+1
	    end if
	  else
	    ind = max0(1,ind-1)
	  end if
	elseif(iterm .eq. key_disp_info) then
	  if(.not. fshelp_disp_info(control)) then
	    ind = -1
	    goto 90
	  end if
	elseif(iterm .eq. key_abort) then
	  ind = -1
	  goto 90
	elseif(iterm .eq. key_files) then
	  ind = -2
	  goto 90
	elseif(iterm .eq. key_back) then
	  ind = 0
	  goto 90
	elseif(iterm .eq. key_toggle) then
	  vertical = .not. vertical
	  ind = -3
	  goto 90
	elseif(iterm .eq. key_ch_width) then
	  ind = -3
	  goto 90
	elseif(iterm .eq. key_enter) then
	  goto 90
	else
	  call fshelp_mess(fshelp_wrkey)
	end if
	pf1_flag = .false.
	goto 10
c
c Drop help pagina
c
90	call smg$delete_viewport(display_id)
	call smg$delete_virtual_display(display_id)
	if(bar.dis_id .ne. 0) call smg$delete_virtual_display(bar.dis_id)
	return
	end

	function screen_get_digit(text,row,dis_id,help,control)
	implicit none
c
	include 'fshelp.inc'
	character*(*) text
	integer*4 row
	integer*4 dis_id
	character*(*) help
	record /control/ control
	integer*4 screen_get_digit
c
	include '($smgdef)'
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 screen_get_one_key
	external fshelp_general
c
	integer*4 iterm,col,istat
c
	col = len(text)+1
c
 	call smg$put_chars(dis_id,text,row,1)
	call smg$set_cursor_abs(dis_id,row,col)
c
10	istat = screen_get_one_key(iterm,control)
	if(.not. istat) screen.control_c_seen = .true.
	if(.not. screen.control_c_seen) then
	  if(iterm .eq. smg$k_trm_enter) then
	    iterm = ichar('0')			!blank is zero
	  elseif(iterm .ge. ichar('0') .and. iterm .le. ichar('9')) then 
c
c ok, do nothing
c
	  else
	    call fshelp_mess_par(fshelp_general,help)
	    goto 10
	  end if
	  call smg$put_chars(dis_id,char(iterm),row,col)
	endif
90	screen_get_digit = iterm-ichar('0')
	return
	end

	function screen_get_janee(text,row,dis_id_inp,help,control,default)
	implicit none
c
	include 'fshelp.inc'
	include '($smgdef)'
c
	character*(*) text
	integer*4 row
	integer*4 dis_id_inp
	character*(*) help
	record /control/ control
	logical  default
	logical*4 screen_get_janee
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer dis_id
c
	integer*4 screen_get_one_key
	external fshelp_general,fshelp_yesno
c
	integer*4 iterm,col,istat,nk_yes,nk_no,nk
	character*20 yes_string,no_string,regel
	character*1 defchar
c
        call fshelp_getmsg(fshelp_yesno,nk,regel)
	call str$element(yes_string,0,'|',regel(1:nk))
        nk_yes = index(yes_string,' ')-1
c
	call str$element(no_string ,1,'|',regel(1:nk))
        nk_no = index(no_string,' ')-1
c
	col = len(text)+1
c
	if(dis_id_inp .ne. 0) then
	  dis_id = dis_id_inp
	else
	  call smg$create_virtual_display(1,50,dis_id)
	  call smg$label_border(dis_id,'-')
	  call smg$paste_virtual_display(dis_id,screen.paste_id,10,10)
	endif
 	call smg$put_chars(dis_id,text,row,1)
	if(default) then
	  defchar = yes_string(1:1)
	else
	  defchar = no_string(1:1)
	endif
 	call smg$put_chars(dis_id,defchar,row,col)
	screen_get_janee = .false.
c
10	call smg$set_cursor_abs(dis_id,row,col)
	istat = screen_get_one_key(iterm,control)
	if(.not. istat) screen.control_c_seen = .true.
	if(screen.control_c_seen) goto 90
	if(iterm .eq. smg$k_trm_enter) iterm = ichar(defchar)
	if(iterm .ge. ichar('a') .and. iterm .le. ichar('z'))
     1                      iterm = iterm -ichar('a') + ichar('A')
c
	if    (index(yes_string(1:nk_yes),char(iterm)) .ne. 0) then
c
c User said YES
c
	  call smg$put_chars(dis_id,char(iterm),row,col)
	  screen_get_janee = .true.
	elseif(index(no_string(1:nk_no),char(iterm)) .ne. 0) then
c
c USer said NO
c
	  call smg$put_chars(dis_id,char(iterm),row,col)
	  screen_get_janee = .false.
	else
c
c Sorry,
c
	  call fshelp_mess_par(fshelp_general,help)
	  goto 10
	end if
90	if(dis_id_inp .eq. 0) call smg$delete_virtual_display(dis_id)
	return
	end

	function screen_getkey(iterm,pf1_flag,help_rout,control)
	implicit none
	include 'fshelp.inc'
	integer*4 iterm		!:o: the key
	logical*4 pf1_flag	!:o: pf1 entered?
	integer*4 help_rout	!:i: help routine address
	record /control/ control
	logical*4 screen_getkey	!:f: false if ^c typed, else true
c
	include '($smgdef)'
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	record /mouse/ mouse
	logical*4 screen_get_one_key
	external fshelp_wrkey
	external fshelp_letters
	character*4 letters
c
	integer*4 k
c
	call fshelp_getmsg(fshelp_letters,k,letters)
c
	iterm = 0
5	pf1_flag = .false.
10	screen_getkey = screen_get_one_key(iterm,control)
	if(.not. screen_getkey) goto 90
	if(iterm .eq. smg$k_trm_pf1) then
	  pf1_flag = .true.
	  goto 10
	end if
c
c Map duplicate keys
c
	if(iterm .eq. smg$k_trm_help) then
	  call help_rout(control)
	  goto 5
	end if
	if(pf1_flag) then
	  if(iterm .ge. ichar('a') .and. iterm .le. ichar('z')) iterm=iterm-32
	  if(iterm .ge. ichar('A') .and. iterm .le. ichar('Z')) then
	    if(iterm .eq. ichar('H')) iterm = smg$k_trm_f8
	    if(iterm .eq. ichar('W')) iterm = smg$k_trm_f9
	    if(iterm .eq. ichar('D')) iterm = smg$k_trm_f11
	    if(iterm .eq. ichar('T')) iterm = smg$k_trm_f13
	    if(iterm .eq. ichar('F')) iterm = smg$k_trm_f14
	    if(iterm .eq. ichar('B')) iterm = smg$k_trm_f16
	    if(iterm .eq. ichar('P')) iterm = smg$k_trm_f6
	    if(iterm .eq. ichar(letters(3:3))) iterm = smg$k_trm_f12
	    if(iterm .eq. ichar(letters(4:4))) iterm = smg$k_trm_f5
	    if(iterm.lt.ichar('A') .or. iterm.gt.ichar('Z'))pf1_flag=.false.
	  end if
	end if
c
c Translate to known keys
c
	k = 0
	if(iterm .eq. smg$k_trm_up         ) k = key_up		!up arrow
	if(iterm .eq. smg$k_trm_down       ) k = key_down	!down arrow
	if(iterm .eq. smg$k_trm_left       ) k = key_left	!left arrow
	if(iterm .eq. smg$k_trm_right      ) k = key_right	!right arrow
	if(iterm .eq. smg$k_trm_prev_screen) k = key_scrup	!screen up
	if(iterm .eq. smg$k_trm_next_screen) k = key_scrdwn	!screen down
	if(iterm .eq. smg$k_trm_ctrlz      ) k = key_abort	!^z
	if(iterm .eq. smg$k_trm_find       ) k = key_find	!find key
	if(iterm .eq. smg$k_trm_pf3        ) k = key_search	!PF3
	if(iterm .eq. smg$k_trm_enter      ) k = key_enter	!cr, enter
	if(iterm .eq. smg$k_trm_f14        ) k = key_file	!f14,PF1-F
	if(iterm .eq. smg$k_trm_f6         ) k = key_print	!f6,PF1-P
	if(iterm .eq. smg$k_trm_f10        ) k = key_back	!pf4, f10
	if(iterm .eq. smg$k_trm_delete     ) k = key_delete_one	!delete
	if(iterm .eq. smg$k_trm_lf         ) k = key_delete_all	!lf
	if(iterm .eq. smg$k_trm_remove     ) k = key_remove	!remove
	if(iterm .eq. smg$k_trm_f8         ) k = key_his_back	!f8 All hists
	if(iterm .eq. smg$k_trm_f12        ) k = key_seealso	!f12 seelalso
	if(iterm .eq. smg$k_trm_f13        ) k = key_his_up	!f13 one hist up
	if(iterm .eq. smg$k_trm_kp8        ) k = key_kp8	!page
	if(iterm .eq. smg$k_trm_kp4        ) k = key_forw	!kp4, forward search
	if(iterm .eq. smg$k_trm_kp5        ) k = key_backw	!kp5, backward search
	if(iterm .eq. smg$k_trm_kp6        ) k = key_disp_bin	!kp6, backward search
	if(iterm .eq. smg$k_trm_f16        ) k = key_swap_bars	!Toggle bar display
	if(iterm .eq. smg$k_trm_f17        ) k = key_mark1	!system mark1
	if(iterm .eq. smg$k_trm_f18        ) k = key_mark2	!system mark2
	if(iterm .eq. smg$k_trm_f19        ) k = key_mark3	!system mark3
	if(iterm .eq. smg$k_trm_f20        ) k = key_marku	!user named mark
	if(iterm .eq. smg$k_trm_ht         ) k = key_files	!other files
	if(iterm .eq. smg$k_trm_f11        ) k = key_toggle	!togg v/h display
	if(iterm .eq. smg$k_trm_f7         ) k = key_disp_info	!display info
	if(iterm .eq. smg$k_trm_f5         ) k = key_execute	!Execute command
	if(iterm .eq. smg$k_trm_f9  ) then
	  if(screen.ncols .lt. 132) then
	    screen.ncols = 132
	  else
	    screen.ncols = 80
	  end if
	  call smg$change_pbd_characteristics(screen.paste_id,screen.ncols)
	  k = key_ch_width   !f9 132/80 cols
	end if
c
	mouse.iterm = iterm
	if(mouse.button .eq. key_mouse_1 .or. 
     1     mouse.button .eq. key_mouse_2 .or.
     1     mouse.button .eq. key_mouse_3 .or. 
     1     mouse.button .eq. key_mouse_4) k = iterm		!passthru mouse
c
	if(iterm .ge. ichar(' ') .and. iterm .le. 126) k = iterm
	if(k .eq. 0) then
	  call fshelp_mess(fshelp_wrkey)
	  goto 10
	end if	
	iterm = k
90	return
	end

	function screen_get_one_key(iterm,control)
	implicit none
	include 'fshelp.inc'
	record /mouse/ iterm
	record /control/ control
	integer*4 screen_get_one_key
c
	include '($smgdef)'
	include '($smgmsg)'
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	integer*4 smg$read_locator
	integer*4 smg$read_keystroke
	external fshelp_clear
  	integer*4 it,row,col,istat
c
5	call smg$set_keypad_mode(screen.keyboard_id,smg$m_keypad_application)
c
	iterm.iterm = 0
10	if(control.use_mouse) then
	  istat = smg$read_locator(screen.keyboard_id,
     1                             row,col,it)
	else
	  istat = smg$read_keystroke(screen.keyboard_id,it)
	endif
	if(istat .eq. smg$_eof .and. it .eq. smg$k_trm_ctrlz) then
	  screen_get_one_key = 1
	else
	  screen_get_one_key = istat
	endif
c
c ignore mouse button up clicks
c
	if(it .ge. smg$k_trm_first_up .and.
     1     it .le. smg$k_trm_fourth_up) goto 10
	if(it .ge. smg$k_trm_first_down .and. 
     1     it .le. smg$k_trm_fourth_down) then
 	  if(it .eq. smg$k_trm_first_down ) iterm.button = key_mouse_1
	  if(it .eq. smg$k_trm_second_down) iterm.button = key_mouse_2
	  if(it .eq. smg$k_trm_third_down ) iterm.button = key_mouse_3
	  if(it .eq. smg$k_trm_fourth_down) iterm.button = key_mouse_4
	  iterm.row    = row	  
	  iterm.col    = col
	else
	  iterm.iterm  = it
	end if
c
	call smg$set_keypad_mode(screen.keyboard_id,0)
	call fshelp_mess(fshelp_clear)
c
	if(iterm.iterm .eq. 2) then
	  call vm_info
	  goto 5
	end if
c
c Map duplicate keys
c
	if(iterm.iterm .eq. smg$k_trm_ctrlr) iterm.iterm = smg$k_trm_ctrlw
	if(iterm.iterm .eq. smg$k_trm_pf2  ) iterm.iterm = smg$k_trm_help
	if(iterm.iterm .eq. smg$k_trm_pf4  ) iterm.iterm = smg$k_trm_f10
	if(iterm.iterm .eq. smg$k_trm_cr   ) iterm.iterm = smg$k_trm_enter
c
	if(iterm.iterm .eq. smg$k_trm_ctrlw) then
	  call smg$repaint_screen(screen.paste_id)
	  goto 5
	end if
	if(iterm.iterm .eq. smg$k_trm_kp0) then
	  control.use_mouse = .not. control.use_mouse
	  goto 5
	end if
c
	return
	end	
	subroutine screen_get_vids(line,nb,max_vids,n_vids,vids,
     1            begvids,lenvids,video)
	implicit none
c
	character*(*) line
	integer*4 nb
	integer*4 max_vids
	integer*4 n_vids
	integer*4 vids(max_vids)
	integer*4 begvids(max_vids)
	integer*4 lenvids(max_vids)
	integer*4 video
c
	character*(*) leadin
	parameter (leadin = char(27))
	character*(*) sleadin
	parameter (sleadin = char(27+128))
c
	character*20 interm,param
	character*1 final
c
	integer*4 ipos,bpos,k,mask,ppos
c
	logical*4 wanted,found_beg,neg
c
	character*1 beg_par,end_par
	character*1 beg_int,end_int
	parameter (beg_par = char(48),end_par=char(63))
	parameter (beg_int = char(32),end_int=char(47))
c
	include '($smgdef)'
c
	found_beg = .false.
	n_vids = 0
	if(video .ne. 0) then
	  n_vids = n_vids + 1
	  begvids(n_vids) = 1
	  vids(n_vids) = video
	  found_beg = .true.
	end if
c
	ipos = 1
	do while(ipos .lt. nb)
	  if(line(ipos:ipos) .eq. leadin .or. 
     1       line(ipos:ipos) .eq. sleadin) then
c
c 3 formats
c escape sequence
c esc iiii F       where iiii : zero or more chars 32..47
c                           F : one          char  48..126
c ansi sequence
c esc[ ppp iii F   where pppp : zero or more chars 48..63
c  csi                   iiii : zero or more chars 32..47
c                           F : one          char  64..126 
c private sequence
c esc[ ? ppp iii F where pppp : zero or more chars 48..63
c  csi ?                iiii  : zero or more chars 32..47
c                           F : one          char  64..126 
c
	    wanted = .true.
	    param = ' '
	    bpos = ipos
	    if(line(ipos:ipos) .eq. sleadin) goto 10
	    wanted = .false.
c
c Not Csi sequence,
c
	    ipos = ipos + 1
	    if(ipos .gt. nb) goto 80
	    if(line(ipos:ipos) .ne. '[') goto 40  !must be escape seq
	    wanted = .true.
c
c Either ansi, or private
c
10	    ipos = ipos + 1
	    if(ipos .gt. nb) goto 80
	    if(line(ipos:ipos) .eq. '?') then
	      ipos = ipos + 1
	      if(ipos .gt. nb) goto 80
	      wanted = .false.
	    end if
c
c Get parameter field
c
	    ppos = ipos
	    do while(line(ipos:ipos) .ge. beg_par .and. 
     1               line(ipos:ipos) .le. end_par)
	      ipos = ipos + 1
	      if(ipos .gt. nb) goto 80
	    end do
	    param = line(ppos:ipos-1)
c
c Get intermediate field
c
40	    ppos = ipos
	    do while(line(ipos:ipos) .ge. beg_int .and. 
     1               line(ipos:ipos) .le. end_int)
	      ipos = ipos + 1
	      if(ipos .gt. nb) goto 80
	    end do
	    interm = line(ppos:ipos-1)
	    final = line(ipos:ipos)
c
c Skip escape seq
c
	    line(bpos:) = line(ipos+1:)
	    nb = nb - ipos+bpos-1
	    ipos = bpos-1
c
c See if video mode setting
c
	    if(wanted .and. final .eq. 'm') then
	      if(param .eq. ' ' .or. param .eq. '0') then
c
c End sequence
c
	        if(found_beg) then
	          lenvids(n_vids) = bpos-begvids(n_vids)
	          found_beg = .false.
	        end if
	        video = 0
	      else
c
c Begin sequence
c
	        if(found_beg) then
	          lenvids(n_vids) = bpos-begvids(n_vids)
	        end if
c
c Process elements of param
c number,number,...
c
30	        mask = 0
	        k = index(param,';')
	        if(k .eq. 0) k = index(param,' ')
c
c Parse one number 2n (set off ) or n (set on)
c Value will be in     mask
c  neg/pos  will be in neg
c
c
	        neg = .false.
	        if(param(1:1) .eq. '2' .and. k .gt. 2) then
	          neg = .true.
	          param = param(2:)
	          k = k-1
	        end if
	        if(param(1:k-1) .eq. '0') then
	          video = 0
	        else
	          if(param(1:k-1) .eq. '1') mask = smg$m_bold
	          if(param(1:k-1) .eq. '4') mask = smg$m_underline
	          if(param(1:k-1) .eq. '5') mask = smg$m_blink
	          if(param(1:k-1) .eq. '7') mask = smg$m_reverse
	          if(param(1:k-1) .eq. '8') mask = smg$m_invisible
	          if(neg) then
	            video = video .and. .not. mask	!clear bit
	          else
	            video = video .or. mask		!set bit
	          end if
	        end if
	        param = param(k+1:)
	        if(param .ne. ' ') goto 30
c
	        if(video .ne. 0) then
	          found_beg = .true.
	          n_vids = n_vids + 1
	          vids(n_vids) = video
	          begvids(n_vids) = bpos
	        end if
	      end if
	    end if
c	    goto 80
c70	    nb = bpos-1			!clip
80	  end if
	  ipos = ipos + 1
	end do
	if(found_beg) lenvids(n_vids) = nb-begvids(n_vids)+1
	return
	end
	subroutine display_bar(bar,ispos) !nlines,ispos,nld,horizontal)
	implicit none
c
	include 'fshelp.inc'
c
c	integer*4 did
	record /bar/ bar
	integer*4 ispos
c	integer*4 nlines
c	integer*4 nld
c	logical*4 horizontal
c
	real*4 fact
c
	include '($smgdef)'
c
	character*132 line
	character*1 kar_empt,kar_full,kar
	integer*4 nl1,nl2,nl3,video,k   !,new_nls
	integer did
c
	if(.not. bar.need_bar) goto 90
c	fact = min(1.0,float(nld)/float(nlines))
	fact = min(1.0,float(bar.scr_lines)/float(bar.tot_lines))
	nl1 = nint(fact*(ispos-1))
c	nl2 = nint(fact*min(nld,nlines))
	nl2 = nint(fact*min(bar.scr_lines,bar.tot_lines))
c	nl3 = min(nlines,nld)-nl1-nl2
	nl3 = min(bar.scr_lines,bar.tot_lines)-nl1-nl2
	if(bar.nl1.eq.nl1 .and. bar.nl2.eq.nl2 .and. bar.nl3.eq.nl3) goto 90
	bar.nl1 = nl1
	bar.nl2 = nl2
	bar.nl3 = nl3
c
	if(bar.horizontal) then
	  kar_empt = '_'
	  kar_full = ' '
	else
	  kar_empt = '|'
	  kar_full = ' '
	endif
c
	did = bar.dis_id
c
c	write(line,1000) fact,nl1,nl2,nl3
c1000	format('fact ',f4.2,' nl1 ',i3,' nl2 ',i3,' nl3 ',i3)
c	call smg$put_chars(did,line,ispos,1)
	video = smg$m_reverse
	do k=1,nl1+nl2+nl3
	  if((k .gt. nl1) .and. (k .le. nl1+nl2)) then
	    kar = kar_full
	    video = smg$m_reverse
	  else
	    kar = kar_empt
	    video = 0
	  endif
	  if(bar.horizontal) then
	    line(k:k) = kar
	  else
	    call smg$put_chars(did,kar,k,1,,video)
	  endif
	end do
	if(bar.horizontal) then
	  call smg$put_chars(did,line(        1:nl1    ),1,1)
	  video = smg$m_reverse
	  call smg$put_chars(did,line(nl1+1    :nl1+nl2),1,nl1+1,,video)
	  call smg$put_chars(did,line(nl1+nl2+1:k      ),1,nl1+nl2+1)
	endif
90	return
	end	
	subroutine fshelp_smg_execute(control,input_line)
	implicit none
c
	include 'fshelp.inc'
c
	record /control/ control
	character*(*) input_line
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	character*(max_line_length) line,temp
	character*40 header,queue
c
	character*(*) fnam
	parameter (fnam='sys$login:fshelp_execute_temp.com')
c
	integer*4 dis_id,nline,nk_head,nk,lun,bpos
	integer*4 nele,maxl,k,kpos,ipos,l
c	integer*4 it
	logical*4 on_scr
c
	integer*4 str$element
	integer*4 lib$get_symbol
	integer*4 fshelp_util_print_file
c
	external fshelp_submer,fshelp_substa
c
	line = input_line
	nele = 0
	maxl = 0
	nline = 0
	k = index(line,']')
	header = 'Execute commando]'
	if (k .ne. 0) then
	  l = 1
	  if(line(1:1) .eq. '[') l = 2
	  header = line(l:k)
	  line = line(k+1:)
	end if
	nk_head = index(header,']')-1
c
	do while(str$element(temp,nele,'|',line))
	  do k=len(temp),1,-1
	    if(temp(k:k) .ne. ' ') goto 10
	  end do
	  k = 0
10	  if(k .gt. 0) then
	    maxl = max(maxl,k)
	    nline = nline + 1
	  end if
	  nele = nele + 1
	end do
c
	call smg$create_virtual_display(nele,70,dis_id)
	call smg$label_border(dis_id,header(1:nk_head))
	on_scr = .false.
c
20	call smg$erase_display(dis_id)
	nline = 0
	do k=1,nele
	  call str$element(temp,k-1,'|',line)
	  do l=len(temp),1,-1
	    if(temp(l:l) .ne. ' ') goto 30
	  end do
	  l = 0
30	  if(l .gt. 0) then
	    nline = nline + 1
	    call smg$put_chars(dis_id,temp(1:l),nline,1)
	  endif
	end do
c
	ipos = index(line,'''')
	if(ipos .ne. 0) then
	  bpos = ipos + 1
	  if(line(bpos:bpos) .eq. '''') bpos=bpos + 1
	  kpos = index(line(bpos:),'''')
	  if(kpos .ne. 0) then
	    kpos = kpos + bpos-1
	    call fshelp_smg_replace(control,line(bpos:kpos-1),temp,l,
     1               dis_id,on_scr)
	    line = line(1:ipos-1)//temp(1:l)//line(kpos+1:)
	    goto 20
	  end if
	end if
c
	call lib$get_lun(lun)
	open(lun,file=fnam,status='new',carriagecontrol='list')
	do k=1,nele
	  call str$element(temp,k-1,'|',line)
	  do l=len(temp),1,-1
	    if(temp(l:l) .ne. ' ') goto 40
	  end do
	  l = 0
40	  if(l .gt. 0) then
	    write(lun,1000) temp(1:l)
1000	    format(a)
	  endif
	end do
	close(lun)
	if(.not. lib$get_symbol('FSHELP_QUEUE',queue,nk)) then
	  queue = 'SYS$BATCH'
	  nk = index(queue,' ')-1
	endif
	if(fshelp_util_print_file(queue(1:nk),fnam,.true.,.false.,l)) then
	  call sys$fao('!AS (entry !UL)',k,temp,queue(1:nk),%val(l))
          call fshelp_mess_par(fshelp_substa,temp(1:k))
	else
	  call fshelp_mess_par(fshelp_submer,queue(1:nk))
        endif
c	call smg$read_keystroke(screen.keyboard_id,it)
	call smg$delete_virtual_display(dis_id)
	return
	end
	subroutine fshelp_smg_replace(control,source,dest,nk,dis_mas,on_scr)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control
	character*(*) source		!:i: the source string
	character*(*) dest              !:o: the output string
	integer*4 nk                    !:o: nkar of dest
	integer*4 dis_mas		!:i: display_id
	logical*4 on_scr
c
c
	integer*4 dis_id,iterm,k
	integer*4 lib$get_symbol
c
	external fshelp_inppar,fshelp_valpar
	integer*4 nkln1
	character*80 ln1
c
	record /screen/ screen
	common /fshelp_screen/ screen
c
	call str$upcase(ln1,source)
	if(ln1 .eq. 'THIS_LIBRARY') then
	  call vm_read_rec_txt(control.lun_filenames,control.sel_item(0),,
     1            nk,dest)
	  nk = index(dest,'#')-1
	  goto 90
	elseif(ln1 .eq. 'THIS_TOPICS') then
	  call util_make_header(control.level,control.rec(1),dest,nk)
	  goto 90
	elseif(ln1(1:11) .eq. 'THIS_TOPIC_') then
	  read(ln1(12:12),2010,err=10) k
2010	  format(i1)
	  if(k .gt. control.level) goto 10
	  dest = control.rec(k).key
	  nk   = control.rec(k).nkar_key
	  goto 90
	endif
c
10	if(.not. lib$get_symbol(source,dest,nk)) then
	  if(.not. on_scr) then
	    call smg$paste_virtual_display(dis_mas,screen.paste_id,4,10)
	    on_scr = .true.
	  endif
	  call fshelp_getmsg(fshelp_inppar,nkln1,ln1)
	  call smg$create_virtual_display(1,60,dis_id)
	  k = min(len(source),60 - nkln1 - 4)
	  call smg$label_border(dis_id,ln1(1:nkln1)//':'//source(1:k))
c
	  call fshelp_getmsg(fshelp_valpar,nkln1,ln1)
	  call smg$put_chars(dis_id,ln1(1:nkln1)//' :',1,1)
	  call smg$paste_virtual_display(dis_id,screen.paste_id,
     1         screen.nrows-1,10)
c
	  call smg$read_string(screen.keyboard_id,dest,,
     1                       len(dest),,,,nk,
     1                       iterm,dis_id,
     1                       source)
	  call smg$delete_virtual_display(dis_id)
	endif
90	return
	end
	subroutine display_full(control,screen,line_in)
	implicit none
	include 'fshelp.inc'
	record /control/ control
	record /screen/ screen
	character*(*) line_in
c
	include '($smgdef)'
c
	integer k,nk,nlin,dis_id,pos,idx
c
	integer nkpl
	parameter (nkpl=16)
	character*80 line
	character*1 kar
c
	do nk=len(line_in),1,-1
	  if(line_in(nk:nk) .ne. ' ') goto 10
	end do
	nk = 1
c
10	nlin = (nk+nkpl-1)/nkpl
c
	call smg$create_virtual_display(nlin+2,78,dis_id)
	call smg$label_border(dis_id,'Raw data')
	line = ' '
	do k=0,nkpl-1
	  pos = k*3+7
	  write(line(pos:pos),1000) k
1000	  format(z1)
	  pos = k+58
	  write(line(pos:pos),1000) k
	end do
	call smg$put_line(dis_id,line,,smg$m_bold)
c
	do k=1,nk
	  idx = mod(k-1,nkpl)
	  kar = line_in(k:k)
	  if(idx .eq. 0) then
	    if(k .gt. 1) call smg$put_line(dis_id,line)
	    write(line,1010) k-1,k-1
1010	    format(z2,74x,z2)
	  endif
	  pos = idx*3+7
	  write(line(pos:pos+1),1020) ichar(kar)
1020	  format(z2.2)
	  pos = idx+58
	  if(ichar(kar) .lt. 32 .or. 
     1       ichar(kar) .gt. 253 .or.
     1      (ichar(kar) .gt. 126 .and. ichar(kar) .lt. 160)) kar = '.'
	  line(pos:pos) = kar
	end do
	call smg$put_line(dis_id,line)
	line = ' '
	do k=0,nkpl-1
	  pos = k*3+7
	  write(line(pos:pos),1000) k
	  pos = k+58
	  write(line(pos:pos),1000) k
	end do
	call smg$put_line(dis_id,line,,smg$m_bold)
c
	call smg$paste_virtual_display(dis_id,screen.paste_id,5,2)
	call screen_get_one_key(k,control)
 	call smg$delete_virtual_display(dis_id)
	return
	end
	subroutine translate_to_bin(lun_src,lun_bin,n_head)
	implicit none
c
	integer*4 lun_src	!:i: the source lun
	integer*4 lun_bin	!:o: the output lun
	integer*4 n_head	!:o: #header lines
c
	include 'fshelp.inc'
c
	integer*4 irec,k,nb
	character*(max_line_length) line
c
	integer*4 vm_read_txt
c
	irec = 1
c
	call vm_open(lun_bin)
c
	call vm_rewind(lun_src)
	do while(vm_read_txt(lun_src,k,nb,line))
	  call make_binary_block(lun_bin,irec,nb,%ref(line),n_head)
	  irec = irec + 1
	end do
	return
	end
