	subroutine util_split_line(line,search)
	implicit none
c
c Split a line in parts, separated by spaces or TAB or /
c
	include 'fshelp.inc'
c
	character*(*) line		!:i: the line
	record /search/ search          !:o: the search structure containing
					!    the line split in parts
c
	character*(*) skip_items
	parameter (skip_items  = (char(9)//' '))
c
	character*255 body
c
	integer*4 ipos,iposb,ipose,idx,k
	logical*4 done
c
	integer*4 str$find_first_in_set
	integer*4 str$find_first_not_in_set
c
c Find first non space/tab
c
	search.nkar_file = 0
	search.filename = ' '
	do k=0,max_deep
	  search.key(k).nkar_key = 0
	  search.key(k).key  = ' '
	end do	
c
	done = .false.
	idx = 0
	ipos = 1
	do while(ipos .le. len(line))
c
c Find the first non separator char
c
	  iposb = str$find_first_not_in_set(line(ipos:),skip_items)
	  if(iposb .eq. 0) goto 70
	  iposb = iposb + ipos-1
c
c now find the first separator char 
c
	  ipose = str$find_first_in_set(line(iposb+1:),skip_items//'/')
	  if(ipose .eq. 0) then
	    ipose = len(line)
	  else
	    ipose = ipose + iposb - 1
	  end if
c
c Now the part from iposb:ipose is the element
c
	  if(.not. done .and. line(iposb:iposb) .eq. '@') then
c
c We found a @ parameter, this must be the first parameter
c
	    search.nkar_file = ipose-iposb+1
	    search.filename = line(iposb+1:ipose)	!skip @
	    body = search.filename
3	    ipos =index(body,']')
	    if(ipos .gt. 0) then
	      body = body(ipos+1:)
	      goto 3
	    end if
	    ipos = index(body,'.')
	    if(ipos .eq. 0) ipos = index(body,';')
	    if(ipos .eq. 0) ipos = index(body,' ')
	    search.key(0).key    = body(1:ipos-1)
	    search.key(0).nkar_key = ipos-1
	  else
c
c A normal key item
c
	    if(idx .lt. max_deep) then
	      idx = idx + 1
	      search.key(idx).nkar_key = ipose-iposb+1
	      search.key(idx).key      = line(iposb:ipose)
	    end if
	  end if	  	  
c
c Now set done to true, so a @ is no longer accepted as a filename
c
	  done = .true.
	  ipos = ipose+1
	end do
70	search.level = idx
	return
	end

	subroutine file_close(lun)
	implicit none
c
c Close a VM file if not yet closed
c
	integer*4 lun		!:i: the lun vor the VM_LIBRARY (or 0)
c
	integer*4 istat
	integer*4 vm_close
c
	if(lun .ne. 0) then
 	  istat = vm_close(lun)
	  if(.not. istat) call lib$signal(%val(istat))
	end if
	return
	end

	function util_match(str1,str2)
	implicit none
c
c See if str2 is (case blind) found in str1
c
	character*(*) str1		!:i: the candidate string
	character*(*) str2		!:i: the pattern string
	logical*4 util_match		!:f: result 
c
	integer*4 nk
	integer*4 str$case_blind_compare
c
	nk = min(len(str1),len(str2))
	util_match = str$case_blind_compare(str2,str1(1:nk)) .eq. 0
	return
	end

	subroutine util_make_header_search(search,filetoo,line,nk)
	implicit none
c
	include 'fshelp.inc'
	record /search/ search  !:i: the search items
	logical filetoo		!:i: file name too?
	character*(*) line	!:o: the line
	integer*4 nk		!:o: length of line
c
	record /header/ rec(max_deep)
	integer*4 k,bpos
c
	bpos = 1
	if(filetoo) bpos = 0
	do k=bpos,search.level
	  rec(k).key      = search.key(k).key	
	  rec(k).nkar_key = search.key(k).nkar_key	
	end do
	call util_make_header(search.level,rec,line,nk)
	return
	end
		
	subroutine util_make_header(level,rec,line,nk)
	implicit none
c
c Make a header line from the selection rec,
c and make sure it matches in the width of the line
c
	include 'fshelp.inc'
c
	integer*4 level		!:i: level
	record /header/ rec(*)	!:i: text items
	character*(*) line	!:o: accumulated line
	integer*4 nk		!:o: line length
c
	integer*4 k,nk1
	real*4 fact
	logical*4 first
c
c in two phases
c 1.  Compute total length 
c   then compute the compression
c 2.  Fill the string with a fixed part of each key
c
	first = .true.
c
	fact = 1.0
10	nk = 0
	do k=1,level
	  if(k .gt. 1) then
	    if(rec(k).key(1:1) .ne. '/') then
	      nk = nk + 1
	      if(.not. first) line(nk:nk) = ' '
	    end if
	  end if
c
c Take length of param
c
	  nk1 = index(rec(k).key,' ')-1
	  if(nk1 .lt. 0) nk1 = rec(k).nkar_key
	  nk1 = max(4,int(fact*nk1+0.5))
	  if(.not. first) line(nk+1:) = rec(k).key
	  nk = nk + nk1
	end do
	if(first) then
	  first = .not. first
c
c Now we have the total length, if it is shorter than the line
c no problem, else compute a factor <1.0
c
	  if(nk .gt. len(line)) then
	    fact = float(len(line)-4)/float(nk)
	  else
	    fact = 1.0
	  end if
c
c And do it again, and fill the string
c
	  goto 10
	end if
c
90	return
	end

	function util_write_header(lun,rec)
	implicit none
c
c Write out just enough bytes
c
	include 'fshelp.inc'
	integer*4 lun       		!:i: the lun for the data
	record /header/ rec		!:i: the record
	integer*4 util_write_header	!:f: the result
c
	integer*4 vm_write
	integer*4 nb
c
	nb = %loc(rec.key)-%loc(rec) + rec.nkar_key
	util_write_header = vm_write(lun,0,nb,rec)
	return
	end	

	function util_rewrite_header(lun,rec)
	implicit none
c
c reWrite out just enough bytes
c
	include 'fshelp.inc'
	integer*4 lun			!:i: the lun for the data
	record /header/ rec		!:i: the (updated) record
	integer*4 util_rewrite_header	!:f: result
c
	integer*4 vm_rewrite
	integer*4 nb
c
	nb = %loc(rec.key)-%loc(rec) + rec.nkar_key
	util_rewrite_header = vm_rewrite(lun,0,nb,rec)
	return
	end	

	function util_read_header(lun,nr,rec)
	implicit none
c
c Read a header record
c
	include 'fshelp.inc'
	integer*4 lun			!:i: the lun for the data
	integer*4 nr			!:i: the record number
	record /header/ rec		!:o: the record
	integer*4 util_read_header	!:f: the result
c
	integer*4 vm_read_rec
	integer*4 nb
c
c Because write header compresses the header writes, we must
c set the fields after the rec.key(rec.nkar_key) to spaces
c
	util_read_header = vm_read_rec(lun,nr,,sizeof(rec),nb,rec)
	if(util_read_header) rec.key(rec.nkar_key+1:) = ' '
	return
	end	

	subroutine util_define_symbol(control,longname,shortname)
	implicit none
c
	include 'fshelp.inc'
	record /control/ control		!:i: control structure
	character*(*) longname			!:i: the full filename
	character*(*) shortname			!:i: the filename part
c
c Define a symbol for the last deepest page
c in a RESULT_FSHELP symbol so we can find this page again
c from DCL via 'RESULT_FSHELP'
c
	character*132 line
	integer*4 nk
c
	call util_make_header(control.level,control.rec(1),line,nk)
	if(12 + len(longname) + 1 + nk .gt. 255) then
	  call lib$set_symbol('RESULT_FSHELP',
     1     'fshelp/libr='//shortname//' '//line(1:nk))
	else
	  call lib$set_symbol('RESULT_FSHELP',
     1     'fshelp/libr='//longname//' '//line(1:nk))
	endif
	return
	end
	function fshelp_util_print_file(queue,fnam,delete,print,entry_nummer)
	implicit none
c
c Print/submit a file to a queue
c
	character*(*) fnam 		!:i: the file to print
	character*(*) queue		!:i: the queue to print to
	logical*4 delete		!:i: delete the job adter printing?
	logical*4 print			!:I: print/submit
	integer*4 entry_nummer		!:o: the entry number
	integer*4 fshelp_util_print_file!:f: the result
c
	include '($sjcdef)'
	integer*4 istat,nit,iosb(2)
	integer*4 sys$sndjbcw
c
	structure /item/
	  integer*2 buflen,opcode
	  integer*4 bufadr,retadr
	end structure
c
	record /item/ items(10)
c
c Fil the item list
c
	items(1).opcode = sjc$_queue
	items(1).buflen = len(queue)
	items(1).bufadr = %loc(queue)
	items(1).retadr = 0
c
	items(2).opcode = sjc$_file_specification
	items(2).buflen = len(fnam)
	items(2).bufadr = %loc(fnam)
	items(2).retadr = 0
c
	items(3).opcode = sjc$_entry_number_output
	items(3).buflen = 4
	items(3).bufadr = %loc(entry_nummer)
	items(3).retadr = 0
c
	nit = 3

	if(delete) then
	  nit = nit + 1
	  items(nit).opcode = sjc$_delete_file
	  items(nit).buflen = 0
	  items(nit).bufadr = 0
	  items(nit).retadr = 0
	end if
	if(.not. print) then
c
c Batch job
c
	  nit = nit + 1
	  items(nit).opcode = sjc$_no_log_specification
	  items(nit).buflen = 0
	  items(nit).bufadr = 0
	  items(nit).retadr = 0
	end if
	nit = nit + 1
	items(nit).opcode = 0
	items(nit).buflen = 0
	items(nit).bufadr = 0
	items(nit).retadr = 0
c
c Give the command to the job controller
c
	istat = sys$sndjbcw(,%val(sjc$_enter_file),,items,iosb,,)
	if(istat) istat = iosb(1)
	fshelp_util_print_file = istat
	return
	end
	subroutine fshelp_mess(mess_id)
	implicit none
c
c Display a message from a message-id (+language)
c
	integer*4 mess_id	!:i: the message id
c
	character*255 mess
	integer*4 nkar
c
	external fshelp_clear
c
	if(%loc(mess_id) .eq. %loc(fshelp_clear)) then
c
c Special case, clear the message area
c
	  call screen_message(char(0))
	else
c
c The normaal case, get the messagetext from the .msg 
c and display it
c
	  call fshelp_getmsg(mess_id,nkar,mess)
	  call screen_message(mess(1:nkar))
	endif
	return
	end
	subroutine fshelp_mess_par(mess_id,par)
	implicit none
c
c display  Message + (string) parameter 
c
	integer*4 mess_id	!:i: the message id
	character*(*) par	!:i: the (string) parameter
c
	character*255 mess,line
	integer*4 nkar,nk
c
c Get the message
c
	call fshelp_getmsg(mess_id,nkar,mess)
c
c Let FAO fill in the parameter
c
	call sys$fao(mess(1:nkar),nk,line,par)
c
c And display
c
	call screen_message(line(1:nk))
	return
	end
	subroutine fshelp_getmsg(mess_id,nkar,line)
	implicit none
c
c Get the message text from mess_id (+language)
c
	integer*4 mess_id	!:i: then messageid
	integer*4 nkar		!:o: the line length
	character*(*) line	!:o: the data
c
	include 'fshelp.inc'
	logical language
	common /fshelp_language/ language
c
	integer msid
c
c Add the language*8 to the message-id
c In this way the next message after the mess_id is located
c
	nkar = 0		!nkar=int*4, and getmsg returns *2
	msid = %loc(mess_id) + language*8
c
c Get the message, and only the message text
c
	call sys$getmsg(%val(msid),nkar,line,%val(1),)
	return
	end	
	subroutine fshelp_getmsg_nolang(mess_id,nkar,line)
	implicit none
c
c Get the message text, and ignore the language info
c
	integer*4 mess_id	!:i: the message id
	integer*4 nkar		!:o: the length of line
	character*(*) line	!:o: the text
c
	nkar = 0		!nkar=int*4 and getmsg returns *2
	call sys$getmsg(mess_id,nkar,line,%val(1),)
	return
	end	

	function fshelp_util_crea_date(fnam,defnam,date)
	implicit none
c
c Get the creation date of a file
c
	character*(*) fnam		!:i: the filename
	character*(*) defnam		!:i: the default filename
	integer*4 date(2)		!:o: the creation date of the file
	integer*4 fshelp_util_crea_date !:f: the result
c
	integer*4 lun,istat
c
	include '($rabdef)'
	include '($fabdef)'
	record /rabdef/ rab
	record /fabdef/ fab
	pointer (p_rab,rab)
	pointer (p_fab,fab)
c
	integer*4 for$rab,sys$display
c
	include '($xabdef)'
	include '($xabdatdef)'
	structure /help/
	  union
	    map
	      record /xabdef/ xab
	    end map
	    map
	      record /xabdatdef/ xabdat
	    end map
	  end union
	end structure
	record /help/ xabdat
c
c Hook in a xabdat
c
	date(1) = 0
	date(2) = 0
c
c open the file
c
	fshelp_util_crea_date = .false.
	call lib$get_lun(lun)
	open(lun,
     1       file=fnam,
     1       defaultfile=defnam,status='old',
     1       shared,
     1       readonly,
     1       err=90)
c
c Get rab addr
c
	p_rab = for$rab(lun)
c
c Get fab adr
c
	p_fab = rab.rab$l_fab
c
	fab.fab$l_xab = %loc(xabdat)
	xabdat.xab.xab$b_cod = xab$c_dat
	xabdat.xab.xab$b_bln = xab$k_datlen
c
c Let RMS fill in the XABDAT
c
	istat = sys$display(fab,,)
	if(.not. istat) goto 80
c
c And save the creation date field of the XAB
c
	date(1) = xabdat.xabdat.xab$q_cdt(1)
	date(2) = xabdat.xabdat.xab$q_cdt(2)
c
	fshelp_util_crea_date = .true.
80	close(lun)
90	call lib$free_lun(lun)
	return
	end
	function find_string_wild(data,search,nbyte)
	implicit none
c
c Find a wildcard string (Unix search string) 
c
	character*(*) data		!:i: the data
	character*(*) search            !:i: the search string
	integer nbyte			!:o: the length of the string
	integer find_string_wild	!:f: the string point (or 0)
c	
	integer endpos,begpos
	integer find_string_wild_w
c
	begpos = find_string_wild_w(data,search,endpos,.false.)
	find_string_wild = begpos
	if(begpos .ne. 0) nbyte = endpos-begpos+1
	return
	end
	options /recursive
	function find_string_wild_w(data,search,endpos,case)
	implicit none
c
c Find a wildcard string in a line
c Supported search constructs
c *     : matches all substrings (0 of meer chars)
c %     : matches exactly 1 char
c [abc] : Matches a "a" or a "b" or a "c"
c [-abc]: Matches anything except a,b,c
c [a-z] : Matches all letters (a-z)
c [-a-z]: Matches anything except letters
c 'a    : Char "a" is not longer a special char ([*%' etc)
c ~     : If in front of the searchstring , the searchstring must be in the 
c         beginning of the line, if at the end of the searchstring,
c         the searchstring must be at the end of the line
c !     : Matches one or more whitespace chars
c
	character*(*) data		!:i: the line
	character*(*) search            !:i: the search string
	integer endpos                  !:o: end pos on success
	logical case			!:i: If true, then case-sensitive
	integer find_string_wild_w      !:f: begin pos of the match(0 if not found)
c
	integer l,pos1,endpos1,spos,xpos,epos,nkd,nks,pos
	logical normal,neg,match,first_only
	character*1 kar1,kar2
c
	nkd = len(data)
	nks = len(search)
	pos = 1
	first_only = .false.
	do while(pos .le. nkd)	
	  spos = 1
	  xpos = pos
	  normal = .true.
	  do while(spos .le. nks)
	    if(normal) then
c
c Special kars are interpreted
c
	      if    (search(spos:spos) .eq. '%') then
	        goto 30
	      elseif(search(spos:spos) .eq. '~') then
	        if(spos .eq. 1) then            !~at first search pos
	          first_only = .true.
	          goto 32
	        elseif(spos .eq. nks) then	!~at last search pos
	          if(xpos .lt. nkd) goto 40	!no match
	          goto 35			!match oke
	        endif
	      elseif(search(spos:spos) .eq. '''') then
	        normal = .false.
	        goto 32
	      elseif(search(spos:spos) .eq. '[') then
c
c we found a [, see if we can find a ]
c
	        do epos=spos,nks
	          if(search(epos:epos) .eq. ']') goto 12
	        end do
c
c not found [ is regarded as a normal char
c
	        goto 20
c
c spos..epos contains [....]
c
12	        spos = spos + 1
	        neg = .false.
	        if(search(spos:spos) .eq. '-') then
	          neg = .true.
	          spos = spos + 1
	        endif
	        l = spos
	        do while (l .lt. epos)
	          if((l .lt. epos-2) .and. (search(l+1:l+1) .eq. '-')) then
	            match = (data(xpos:xpos) .ge. search(l:l)) .and.
     1                      (data(xpos:xpos) .le. search(l+2:l+2))
	            l = l + 3
	          else
	            match = data(xpos:xpos) .eq. search(l:l)
	            l = l + 1
	          endif
	          if(match) then
	            if(.not. neg) goto 14	!een match, dus oke als niet neg
	            if(neg) goto 40		!en fout als neg
	          endif
	        end do
	        if(.not. neg) goto 40			!alles matched niet, oke als neg
14	        spos = epos
	        goto 30
	      elseif(search(spos:spos) .eq. '*') then
	        do l=xpos,nkd
c
c try to match the rest of the string for all possible substrings
c recursivly
c
	          pos1 = find_string_wild_w(data(l:nkd),search(spos+1:nks),
     1                                endpos1,case)
	          if(pos1 .ne. 0) then
	            endpos = endpos1 + l -1
	            goto 90
	          endif
	        end do
	        goto 30
	      elseif(search(spos:spos) .eq. '!') then
	        do l=xpos,nkd
	          if(data(l:l) .ne. ' ' .and. data(l:l) .ne. char(9)) goto 18
	        end do
	        l = nkd + 1
18	        if(l .eq. xpos) goto 40
	        xpos = l-1
	        goto 30
	      endif
	    endif
c
c Check valid char
c
20	    if(xpos .gt. nkd) goto 40
	    if(data(xpos:xpos) .eq. search(spos:spos)) goto 30
c
c No match, if not case-sensitive then try with uppercase chars
c
	    if(.not. case) then
	      kar1 = data(xpos:xpos)
	      if(kar1 .ge. 'a' .and. kar1 .le. 'z')
     1           kar1 = char(ichar(kar1) - ichar('a') + ichar('A'))
	      kar2 = search(spos:spos)
	      if(kar2 .ge. 'a' .and. kar2 .le. 'z')
     1           kar2 = char(ichar(kar2) - ichar('a') + ichar('A'))
	      if(kar1 .eq. kar2) goto 30
	    endif
	    goto 40
30	    normal = .true.
	    xpos = xpos + 1
c
32	    spos = spos + 1
	  end do
35	  endpos = xpos - 1
c
c Found a match
c
	  goto 90
c
c No match , try the first char
c
40	  if(first_only) goto 50
	  pos = pos + 1
	end do
c
c Not found, so set pos to 0
c
50	pos = 0
90	find_string_wild_w = pos
	return
	end
	function get_len(string)
	implicit none
c
c Return the length of a string (without the trailing spaces)
c
	character*(*) string		!:i: the string
	integer*4 get_len		!:f: the string length (can be 0)
c	
	integer*4 k
c
	do k=len(string),1,-1
	  if(string(k:k) .ne. ' ') goto 10
	end do
	k = 0
10	get_len = k
	return
	end
	subroutine cnv_number(cnt,text)
	implicit none
c
c Convert a number to text
c If the number is large, K or M will be used
c
	integer*4 cnt		!:i: the number	
	character*(*) text	!:o: the ascii text
c
	character*20 line
	integer*4 nk,wid,dotpos
c
	wid = len(text)
	text = ' '
c
	call sys$fao('!UL',nk,line,%val(cnt))
	if(nk .le. 3) then
c
c Format just number
c
	  if(wid .lt. nk) goto 80
	  text(wid+1-nk:) = line(1:nk)
	elseif(nk .le. 6) then
c
c Format xxxx.yyyK
c
	  dotpos = nk - 3
	  if(nk .gt. wid-2) nk = wid-2
	  if(nk .lt. 4) goto 80
	  text(wid-1-nk:) = line(1:dotpos)//'.'//line(dotpos+1:nk)//'K'
	else
c
c Format xxxx.yyyM
c
	  dotpos = nk - 6
	  nk = nk - 3		!skip lower 3 digits
	  if(nk .gt. wid-2) nk = wid-2
	  if(nk .lt. 4) goto 80
	  text(wid-1-nk:) = line(1:dotpos)//'.'//line(dotpos+1:nk)//'M'
	end if
	goto 90
80	text = '*************'
90	return
	end
	subroutine deods5name(nk,line)
	implicit none
c
c Remove all ODS-5 ^ characters to make a nice name
c
	integer*4 nk		!:io: the filename length
	character*(*) line	!:io: the filename (updated)
c
	integer*4 k,nk_out
c
	nk_out = 0
	k = 1
	do while (k .le. len(line))
	  nk_out = nk_out + 1
	  if(line(k:k) .eq. '^') then
	    k = k + 1
	    if(line(k:k) .eq. '_') line(k:k) = ' '
	  endif
	  line(nk_out:nk_out) = line(k:k)
	  k = k + 1
	end do
	nk = nk_out
	return
	end
