C Vm package (easy interface to Virtual memory
c
c supported functions
c VM_OPEN			initilize vm
c VM_CLOSE			return all memory
c 
c vm_write			Write buffers
c vm_write_txt			write ascii text (only significant)
c vm_write_fix			write fixed records (after open with fixed)
c 				All writes after the current record
c
c vm_rewrite			ReWrite buffers
c vm_rewrite_txt		Rwrite ascii text (only significant)
c vm_rewrite_fix		REwrite fixed records (after open with fixed)
C
c vm_read			Read sequential buffers
c vm_read_txt			Read sequential text 
c vm_read_fix			Read fixed records(after open fixed)
c
c vm_read_rec			Read direct buffers on record number
c vm_read_rec_txt		Read direct text  on record number
c vm_read_rec_fix		Read direct fixed records record number
c
c vm_setrec			Set current record to requested number
c vm_rewind			reset internal position to first record
c vm_set_eof			Reset internal pointer to last record
c
c vm_sort			Sort current vm file to key (ascii)
c
c vm_delete			delete current record
c
c vm_print			Print to terminal current vm_file(ascii)
c vm_info			Print vm zone info to the file vm.info
c
	subroutine vm_print(id,full,lun)
	implicit none

	integer*4 id
	integer*4 full		!0=only header, 1=+links, 2=+links+text
	integer*4 lun		!:i: (opt) unit to print to (0=terminal)
c
	volatile full
	volatile lun
c
	integer*4 lun1,full1,n_arg
	logical*4 got_lun
c
	n_arg = iargcount()
c
	full1 = 0
	if(n_arg .gt. 1) then
	  if(%loc(full) .ne. 0) full1 = full
	end if
c
	lun1 = 0
	if(n_arg .gt. 2) then
	  if(%loc(lun) .ne. 0) lun1 = lun
	end if
	got_lun = .true.
	if(lun1 .eq. 0) then
	  got_lun = .false.
	  call lib$get_lun(lun1)
	  open(lun1,file='vm.info',status='new',carriagecontrol='list')
	end if
	if(id .ne. 0) call vm__print(%val(id),full1,lun1)
	if(.not. got_lun) then
	  close(lun1)
	  call lib$free_lun(lun1)
	end if
	return
	end
	subroutine vm__print(vm_rec,full,lun)
	implicit none
	include 'vm_record.inc'
	record /vm_record/vm_rec
	integer*4 full
	integer*4 lun
c
	record /link_record/ link_rec
	pointer (plink_rec,link_rec)
c
c
	integer*4 nkar,k
	character*1 kar
c
	write(lun,1001) vm_rec.zone_id,vm_rec.flags,vm_rec.name,
     1                vm_rec.first,vm_rec.current,vm_rec.last,
     1                vm_rec.nlines,vm_rec.current_line,
     1                vm_rec.recsiz,vm_rec.sort_pos,vm_rec.sort_size,
     1                vm_rec.nbytes
1001	format(' VM:zone id : ',z8,' flags   : ',z8,' name  : ',a/,
     1         '    first   : ',z8,' current : ',z8,' last  : ',z8,/,
     1         '    nlines  : ',i8,' curline : ',i8,' recsiz: ',i8,/,
     1         '    sor_pos : ',i8,' sor_size: ',i8,' nbytes: ',i8)
	if(full .gt. 0) then
	  write(lun,1005)
1005	  format('  address  Forward Backward Cur  Extra Vsize Bsize Text')
	  plink_rec = vm_rec.first
	  do while(plink_rec .ne. 0)
	    kar = ' '
	    if(plink_rec .eq. vm_rec.current) kar = '>'
	    if(full .eq. 1) then
	      write(lun,1000) plink_rec,link_rec.forward,
     1                      link_rec.backward,kar,link_rec.extra,
     1                      link_rec.size,link_rec.nbyte
1000	      format(3(z9),1x,a1,1x,z8,2i5,1x,100a1)
	    elseif(full .eq. 2) then
	      nkar = min(30,link_rec.nbyte)
	      write(lun,1000) plink_rec,link_rec.forward,
     1                    link_rec.backward,kar,link_rec.extra,
     1                    link_rec.size,link_rec.nbyte,
     1                    (link_rec.data(k),k=1,nkar)
	    endif
	    plink_rec = link_rec.forward
	  end do
	end if
c
	return
	end

	function vm_open(id,alloc,fixed,old_id,name,
     1                  sort_pos,sort_size,sort_flag)
	implicit none
	integer*4 id		!:o: id
	integer*4 alloc		!:i: (opt) initial alloc in blocks/bytes for fixed
	integer*4 fixed		!:i: (opt) if fixed size, recsize in bytes
	integer*4 old_id	!:i: (opt) use old VM area
	integer*4 name(2)	!:I: (OPT) VM area name
	integer*4 sort_pos	!:i: (OPT) Starting area for sorting
	integer*4 sort_size	!:i: (OPT) Size for sort field
	integer*4 sort_flag	!:i: (OPT) sort_flags
	integer*4 vm_open	!:f: status
c
	volatile alloc
	volatile fixed
	volatile old_id
	volatile name
c
	include 'vm_record.inc'
c
	record /vm_record/ vm_record
	pointer (pvm_record,vm_record)
c
	integer*4 lib$create_vm_zone,lib$get_vm
	integer*4 istat,zone_id,algorithm,nblock,recsiz,oid
	integer*4 flags,nv,descr(2)
	record /link_record/ link_rec
c
	character*(*) defname
	parameter (defname='VM_AREA')
c
c
	include '($libvmdef)'
c
c Set some defaults
c
	nv = sizeof(vm_record)
c
c Check initial allocation (default=0)
c
	nblock = 0
	if(iargcount() .gt. 1) then
	  if(%loc(alloc) .ne. 0) nblock = alloc
	end if
c
c Check if fixed records wanted
c
	flags     = 0
	algorithm = LIB$K_VM_FIRST_FIT 
	recsiz    = 0
	if(iargcount() .gt. 2) then
	  if(%loc(fixed) .ne. 0) then
	    if(fixed .gt. 0) then
c
c Make sure the header is included in fixed size
c
	      recsiz = max(nv,fixed + sizeof(link_rec)- sizeof(link_rec.data))
	      nv = recsiz
c
c In this case alloc is in records instead of blocks
c
	      nblock = (nblock * recsiz+511)/512	
	      algorithm = LIB$K_VM_FIXED
	      flags = flags .or. vm_m_fixed
	    end if
	  end if
	end if
c
c Check if user specified zone
c
	oid = 0
	if(iargcount() .gt. 3) then
	  if(%loc(old_id) .ne. 0) oid = old_id
	end if
c
c Set name correctly
c 
	descr(1) = len(defname)
	descr(2) = %loc(defname)
	if(iargcount() .gt. 4) then
	  if(%loc(name) .ne. 0) then
c      	    descr(1) = name(1)
	    descr(1) = 0
      	    call lib$movc3(2,name(1),descr(1))
	    descr(2) = name(2)
	  else
	    istat = 1
	  end if
 	end if
c
c
	if(oid .eq. 0) then
c
c We must make new vm-zone
c make new descriptor-name
c
c
c Create new VM zone
c
	  istat = lib$create_vm_zone(zone_id,algorithm,recsiz,,,nblock,
     1                               ,,,,descr)
	  if(.not. istat) goto 90
	else
c
c Use old address, oid is previous used lun
c
	  pvm_record = oid
	  zone_id = vm_record.zone_id
	  flags = flags .or. vm_m_slave
	  if(descr(2) .eq. %loc(defname)) then
	    descr(1) = len(vm_record.name)
	    descr(2) = %loc(vm_record.name)
	  endif
	end if
c
c Allocate new header record for zone-id (either new or old)
c
	istat = lib$get_vm(nv,pvm_record,zone_id)
	if(.not. istat) goto 80
	id = pvm_record			!Return memory-address to user
c
	vm_record.zone_id      = zone_id
	vm_record.first        = 0
	vm_record.last         = 0
	vm_record.current      = 0
	vm_record.nlines       = 0
	vm_record.nbytes       = 0
	vm_record.current_line = 0
	vm_record.flags        = flags
	vm_record.max_size     = 0
	vm_record.name         = ' '
	descr(1) = min(descr(1),len(vm_record.name))
	call lib$movc3(descr(1),%val(descr(2)),%ref(vm_record.name))
c	write(1,*) 'Opening'
c	call vm_print(id,.true.,1)
c
c Fill in the parameters in header record
c
	vm_record.recsiz       = 0
	if(iargcount() .gt. 2) then
	  if(%loc(fixed) .ne. 0)    vm_record.recsiz    = fixed
	end if
c
	vm_record.sort_pos     = 0
	if(iargcount() .gt. 5) then
	  if(%loc(sort_pos) .ne. 0) vm_record.sort_pos  = sort_pos
	end if
c
	vm_record.sort_size    = 0
	if(iargcount() .gt. 6) then
	  if(%loc(sort_size) .ne. 0) vm_record.sort_size = sort_size
	end if
	vm_record.sort_flag    = 0
	if(iargcount() .gt. 7) then
	  if(%loc(sort_flag) .ne. 0) vm_record.sort_flag = sort_flag
	end if
	istat = 1

	goto 90
80	if(oid .eq. 0) call lib$delete_vm_zone(zone_id)
90	vm_open = istat
	return
	end

	function vm_write_fix(id,extra,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 extra			!:o: extra field (optional)
	byte  data(*)			!:o: the data
	integer*4 vm_write_fix		!:f: result
c
	volatile extra
c
	integer*4 nbyte
	integer*4 vm_write
	integer*4 vm__get_recsiz
c
	vm_write_fix = vm__get_recsiz(%val(id),nbyte)
	if(vm_write_fix) then	
	  vm_write_fix = vm_write(id,%val(%loc(extra)),nbyte,data)
	end if
	return
	end
c
	function vm_write_txt(id,extra,line)	
	implicit none
	integer*4 id		!:i: address returned by vm_open
	integer*4 extra		!:i: extra data field (optional)
	character*(*) line	!:i: The data
	integer*4 vm_write_txt	!:f: status
c
	volatile extra
c
	integer*4 k
	integer*4 vm_write
c
c Compute actual length, skip trailing blanks
c
	do k=len(line),1,-1
	  if(line(k:k) .ne. ' ') goto 10
	end do
	k = 0
10	vm_write_txt = vm_write(id,%val(%loc(extra)),k,%ref(line))
	return
	end
	function vm_write(id,extra,nbyte,buffer)	
	implicit none
c
c Write data to VM
c
	integer*4 id		!:i: address returned by vm_open
	integer*4 extra		!:i: (OPT) extra data field 
	integer*4 nbyte		!:i: bufer length
	byte buffer(*)		!:i: the data
	integer*4 vm_write	!:f: status
c#
	include 'vm_record.inc'
	volatile extra
c
	record /vm_record/ vm_record
	pointer (pvm_record,vm_record)
c
	record /link_record/ link_rec
	integer*4 lib$get_vm
c
	integer*4 nb,ex,istat,base_address
c
c Compute # byte needed for data
c
	if(id .eq. 0) then
	  istat = 2
	  goto 90
	end if
	pvm_record = id
	nb = sizeof(link_rec) - sizeof(link_rec.data) + nbyte
	istat = lib$get_vm(nb,base_address,vm_record.zone_id)
	if(.not. istat) goto 90
c
c Get extra parameter (if specified)
c
	ex = 0
	if(%loc(extra) .ne. 0) ex = extra
c
	call vm__insert_data(vm_record,%val(base_address),ex,nbyte,buffer)
	istat = 1
90	vm_write = istat
	return
	end

	function vm_rewrite_fix(id,extra,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 extra			!:i: extra field (optional)
	byte  data(*)			!:i: the data
	integer*4 vm_rewrite_fix		!:f: result
c
	volatile extra
c
	integer*4 nbyte
	integer*4 vm_rewrite
	integer*4 vm__get_recsiz
c
	vm_rewrite_fix = vm__get_recsiz(%val(id),nbyte)
	if(vm_rewrite_fix) then	
	  vm_rewrite_fix = vm_rewrite(id,%val(%loc(extra)),nbyte,data)
	end if
	return
	end
	function vm_rewrite_txt(id,extra,line)	
	implicit none
	integer*4 id			!:i: address returned by vm_open
	integer*4 extra			!:i: extra data field (optional)
	character*(*) line		!:i: The data
	integer*4 vm_rewrite_txt	!:f: status
c
	volatile extra
c
	integer*4 k,ex
	integer*4 vm_rewrite
c
	ex = 0
	if(%loc(extra) .ne. 0) ex = extra
c
	do k=len(line),1,-1
	  if(line(k:k) .ne. ' ') goto 10
	end do
	k = 0
10	vm_rewrite_txt = vm_rewrite(id,%val(%loc(extra)),k,%ref(line))
	return
	end
	function vm_rewrite(id,extra,nbyte,buffer)	
	implicit none
c
c ReWrite data to VM
c
	include 'vm_record.inc'
	integer*4 id		!:i: address returned by vm_open
	integer*4 extra		!:i: extra data field (optional)
	integer*4 nbyte		!:i: bufer length
	byte buffer(*)		!:i: the data
	integer*4 vm_rewrite	!:f: status
c#
	volatile extra
c
	integer*4 ex
	integer*4 vm__rewrite
c
	record /vm_record/ vm_record
	pointer (pvm_record,vm_record)
c
c Compute # byte needed for data
c
	if(id .eq. 0) then
	  vm_rewrite = 2
	else
	  ex = 0
	  if(%loc(extra) .ne. 0) ex = extra
	  pvm_record = id
c##
          if(vm_record.current .eq. 0) then
	    vm_rewrite = 0
	  else
	    vm_rewrite = vm__rewrite(vm_record,
     1        %val(vm_record.current),ex,nbyte,buffer,
     1        vm_record.sort_size .ne. 0)
	  endif
	end if
	return
	end
	function vm__rewrite(vm_rec,link_rec,extra,nbyte,buffer,
     1                 is_sorted)	
	implicit none
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec	!:i: address returned by vm_open
	record /link_record/ link_rec	!:i: current record
	integer*4 extra			!:i: extra data field 
	integer*4 nbyte			!:i: bufer length
	byte buffer(*)			!:i: the data
	logical is_sorted
	integer*4 vm__rewrite		!:f: status
c
	integer*4 vm_write,vm__delete	  !,vm__get_backward
	integer*4 istat
c
	if(.not. is_sorted .and. (nbyte .le. link_rec.size)) then
	  call lib$movc3(nbyte,buffer,link_rec.data)
	  link_rec.nbyte = nbyte
	  istat = 1
	else
c
c Does not fit, or sorted , delete current record first
c
	  istat = vm__delete(vm_rec)
c
c and now reinsert new data
c 
	  if(istat) istat = vm_write(%loc(vm_rec),extra,nbyte,buffer)	
	end if
90	vm__rewrite = istat
	return
	end
	subroutine vm__insert_data(vm_rec,link_rec,extra,nb,buffer)
	implicit none
c
c Insert after current record
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	record /link_record/ link_rec
	integer*4 extra
	integer*4 nb
	byte buffer(*)
c
	record /link_record/ tlink_rec
	pointer (ptlink_rec,tlink_rec)
c
c Insert after the current record
c
	integer*4 addr,temp,k   
c
	integer vm__rec_bigger
c
	link_rec.extra = extra
	link_rec.nbyte = nb
	link_rec.size = nb
	call lib$movc3(nb,buffer,link_rec.data)
c
c Update #lines in header
c
	vm_rec.nlines = vm_rec.nlines+1
	vm_rec.nbytes = vm_rec.nbytes+nb
	vm_rec.current_line = vm_rec.current_line+1
	if(nb .gt. vm_rec.max_size) vm_rec.max_size = nb
c
	addr = %loc(link_rec)
c
c Link in
c if vm_rec.current is 0 then fill it with the last (could still be 0)
c
	if(vm_rec.sort_size .ne. 0) then
c
c Search first record with data >=new data
c
	  k    = 1
	  temp = 0
	  ptlink_rec = vm_rec.first
4	  if(ptlink_rec .ne. 0) then
	    if(.not. vm__rec_bigger(tlink_rec,link_rec,
     1             vm_rec.sort_pos,vm_rec.sort_size,
     1             vm_rec.sort_flag)) then
	      k = k + 1
	      temp = ptlink_rec
	      ptlink_rec = tlink_rec.forward
	      goto 4
	    endif
	  endif
	  if(temp .eq. 0) then
c
c Insert before first line, or in empty database
c
	    link_rec.backward = 0
	    link_rec.forward = vm_rec.first	!Can still be 0
	    vm_rec.first     = addr
	    if(vm_rec.last .eq. 0) vm_rec.last = vm_rec.first
	    vm_rec.current_line = 1
	    vm_rec.current = addr
c##
	    if(ptlink_rec .ne. 0) then
	      tlink_rec.backward = addr
	    endif
c##
	    goto 90
	  endif
	  vm_rec.current      = temp
	  vm_rec.current_line = k
	endif
c
	if(vm_rec.current .eq. 0) then
	  vm_rec.current      = vm_rec.last
	  vm_rec.current_line = vm_rec.nlines
	end if
c
c the new record's previous is always the current (might be empty)
c
	link_rec.backward = vm_rec.current
c
c Now fill all links
c
	if(vm_rec.current .eq. 0) then
c
c Empty list, easy
c
	  link_rec.forward = 0
	  vm_rec.first     = addr
	  vm_rec.last      = addr
	else
c
c Set forward link for new record, is the forward of the current record
c
	  ptlink_rec = vm_rec.current
	  link_rec.forward = tlink_rec.forward
c
c set the forward link of the current record, points to the new record
c
	  tlink_rec.forward = addr
c
c If the next record exists, set its backward link to the new record
c
	  if(link_rec.forward .eq. 0) then
	    vm_rec.last    = addr
	  else
	    ptlink_rec = link_rec.forward
	    tlink_rec.backward = addr
	  end if
	end if
c
c Now update header
c
	vm_rec.current = addr
90	return
	end
	function vm_rewind(id)
	implicit none
c
	integer*4 id			!:i: returned by vm_open
	integer*4 vm_rewind		!:f: function result
c
	include 'vm_record.inc'
	record /vm_record/ vm_record
	pointer (pvm_record,vm_record)
c
	if(id .eq. 0) then
	  vm_rewind              = 2
	else
	  pvm_record             = id
	  vm_record.current      = vm_record.first
	  vm_record.current_line = 1
	  if(vm_record.nlines .eq. 0) vm_record.current_line = 0
	  vm_rewind              = 1
	end if
	return
	end
	function vm_set_eof(id)
	implicit none
c
	integer*4 id			!:i: returned by vm_open
	integer*4 vm_set_eof		!:f: function result
c
	include 'vm_record.inc'
	record /vm_record/ vm_record
	pointer (pvm_record,vm_record)
c
	if(id .eq. 0) then
	  vm_set_eof = 2
	else
	  pvm_record             = id
	  vm_record.current      = vm_record.last
	  vm_record.current_line = vm_record.nlines
	  if(vm_record.nlines .eq. 0) vm_record.current_line = 0
	  vm_set_eof = 1
	end if
	return
	end

	function vm_read_fix(id,extra,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 extra			!:o: extra field (optional)
	byte  data(*)			!:o: the data
	integer*4 vm_read_fix		!:f: result
c
	volatile extra
c
	integer*4 ex,nbyte
	integer*4 vm_read
	integer*4 vm__get_recsiz
c
	vm_read_fix = vm__get_recsiz(%val(id),nbyte)
	if(vm_read_fix) then	
	  vm_read_fix = vm_read(id,ex,nbyte,nbyte,data)
	  if(%loc(extra) .ne. 0) extra = ex
	end if
	return
	end
	function vm_read_txt(id,extra,nbyte,line)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 extra			!:o: extra field (optional)
	integer*4 nbyte			!:o: returned buffer size
	character*(*) line		!:o: the data
	integer*4 vm_read_txt		!:f: result
c
	volatile extra
c
	integer*4 ex
	integer*4 vm_read
c
	vm_read_txt = vm_read(id,ex,len(line),nbyte,%ref(line))
	if(%loc(extra) .ne. 0) extra = ex
	if(nbyte .lt. len(line)) line(nbyte+1:) = ' '
	return
	end
	function vm_read(id,extra,bufsiz,nbyte,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 extra			!:o: extra field (optional)
	integer*4 bufsiz		!:i: buffer size
	integer*4 nbyte			!:o: returned buffer size
	byte data(*)			!:o: the data
	integer*4 vm_read		!:f: result
c
	volatile extra
c
	integer*4 ext
	integer*4 vm__read
c
	if(id .eq. 0) then
	  vm_read = 2
	else
	  vm_read = vm__read(%val(id),ext,bufsiz,nbyte,data,.true.)
	  if(%loc(extra) .ne. 0) extra = ext
	end if
	return
	end
	function vm__read(vm_rec,extra,bufsiz,nbyte,data,next)
	implicit none
	include 'vm_record.inc'
	record /vm_record/ vm_rec	!:i: header record
	integer*4 extra			!:o: extra field
	integer*4 bufsiz		!:i: buffer size
	integer*4 nbyte			!:o: returned buffer size
	byte data(*)			!:o: the data
	logical*4 next			!:i: skip to next record yes/no
	integer*4 vm__read		!:f: result
c
	record /link_record/ link_rec
	pointer (p_link_rec,link_rec)
c
	if(vm_rec.current .eq. 0) then
	  nbyte = 0
	  extra = 0
	  vm__read = 2
	else
	  call vm__copy(%val(vm_rec.current),extra,bufsiz,nbyte,data)
	  if(next) then
c
c Point to the next
c
	    p_link_rec = vm_rec.current
	    vm_rec.current = link_rec.forward
	    vm_rec.current_line = vm_rec.current_line + 1
	    if(vm_rec.current .eq. 0) vm_rec.current_line = 0
	  end if
	  vm__read = 1
	end if
	return
	end
	subroutine vm__copy(link_rec,extra,bufsiz,nbyte,data)
	implicit none
	include 'vm_record.inc'
	record /link_record/ link_rec	!:i: data_rec
	integer*4 extra			!:o: extra field
	integer*4 bufsiz		!:i: buffer size
	integer*4 nbyte			!:o: returned buffer size
	byte data(*)			!:o: the data
c
	extra = link_rec.extra
	nbyte = min(bufsiz,link_rec.nbyte)
	if(nbyte .gt. 0) call lib$movc3(nbyte,link_rec.data,data)
	return
	end
	function vm_close(id)
	implicit none
	integer*4 id			!:io: id returnd by 
	integer*4 vm_close		!:f: functionresult
c
c Zone id if first item in vm_rec, so tis easy
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	pointer (p_vm_rec,vm_rec)
c
	integer*4 lib$delete_vm_zone
c
	if(id .eq. 0) then
	  vm_close = 2
	else
	  p_vm_rec = id
	  vm_close = lib$delete_vm_zone(vm_rec.zone_id)
c	  write(1,*) 'Closing'
c	  call vm_print(id,.true.,1)
	  id = 0
	end if
	return
	end	
	function vm__get_recsiz(vm_rec,nbyte)
	implicit none
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	integer*4 nbyte
	integer*4 vm__get_recsiz
c
	vm__get_recsiz = 2		!assume error
	if(%loc(vm_rec) .eq. 0) goto 90
	if((vm_rec.flags .and. vm_m_fixed) .eq. 0) goto 90
	nbyte = vm_rec.recsiz
	vm__get_recsiz = 1		!ok
90	return
	end

	function vm_read_rec_fix(id,recnr,extra,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 recnr			!:i: requested record number
	integer*4 extra			!:o: extra field (optional)
	byte  data(*)			!:o: the data
	integer*4 vm_read_rec_fix		!:f: result
c
	volatile extra
c
	integer*4 ex,nbyte
	integer*4 vm_read_rec
	integer*4 vm__get_recsiz
c
	vm_read_rec_fix = vm__get_recsiz(%val(id),nbyte)
	if(vm_read_rec_fix) then	
	  vm_read_rec_fix = vm_read_rec(id,recnr,ex,nbyte,nbyte,data)
	  if(%loc(extra) .ne. 0) extra = ex
	end if
	return
	end
	function vm_read_rec_txt(id,recnr,extra,nbyte,line)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 recnr			!:i: requested record number
	integer*4 extra			!:o: extra field (optional)
	integer*4 nbyte			!:o: returned buffer size
	character*(*) line		!:o: the data
	integer*4 vm_read_rec_txt		!:f: result
c
	volatile extra
c
	integer*4 ex
	integer*4 vm_read_rec
c
	line = ' '
	vm_read_rec_txt = vm_read_rec(id,recnr,ex,len(line),nbyte,%ref(line))
	if(%loc(extra) .ne. 0) extra = ex
	return
	end
	function vm_read_rec(id,recnr,extra,bufsiz,nbyte,data)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 recnr			!:i: record number
	integer*4 extra			!:o: extra field (optional)
	integer*4 bufsiz		!:i: buffer size
	integer*4 nbyte			!:o: returned buffer size
	byte data(*)			!:o: the data
	integer*4 vm_read_rec		!:f: result
c
	volatile extra
c
	integer*4 ext
	integer*4 vm__read,vm_setrec
c
	vm_read_rec = vm_setrec(id,recnr)
	if(vm_read_rec) then
	  vm_read_rec = vm__read(%val(id),ext,bufsiz,nbyte,data,.false.)
	  if(%loc(extra) .ne. 0) extra = ext
	end if
	return
	end
	function vm_setrec(id,recnr)
	implicit none
	integer*4 id			!:i: id returned by vm_open
	integer*4 recnr			!:i: requested line nr
	integer*4 vm_setrec		!:f: status
c
	integer*4 vm__setrec
c
	if(id .eq. 0) then
	  vm_setrec = 2
	else
	  vm_setrec = vm__setrec(%val(id),recnr)
	end if
	return
	end		
	function vm__setrec(vm_rec,recnr)
	implicit none
	include 'vm_record.inc'
	record /vm_record/ vm_rec	!:io: vm rec
	integer*4 recnr			!:i: requested line nr
	integer*4 vm__setrec		!:f: function status
c
	record /link_record/ link_rec
	pointer (plink_rec,link_rec)
c

	integer*4 k
c
	if(recnr .le. 0 .or. recnr .gt. vm_rec.nlines) then
	  vm__setrec = 2
	else
	  if(vm_rec.current .eq. 0) then
	    if(recnr .lt. vm_rec.nlines/2) then
	      vm_rec.current      = vm_rec.first
	      vm_rec.current_line = 1
	    else
	      vm_rec.current      = vm_rec.last
	      vm_rec.current_line = vm_rec.nlines
	    end if
	  end if
	  if(recnr .lt. vm_rec.current_line) then
c
c requested record is before current record
c
	    if(recnr .lt. (vm_rec.current_line-recnr)) then
c
c distance to begin is less than distance to current
c so skip from beginning forward
c
	      plink_rec = vm_rec.first
	      do k=2,recnr
	        plink_rec = link_rec.forward
	      end do
	    else
c
c Skip back from current
c
	      plink_rec = vm_rec.current
	      do k=recnr,vm_rec.current_line-1
	        plink_rec = link_rec.backward
	      end do
	    end if
	    vm_rec.current = plink_rec
	  elseif(recnr .gt. vm_rec.current_line) then
c
c Requested record is after the current record
c
	    if(vm_rec.nlines-recnr .lt. recnr-vm_rec.current_line) then
c
c go to end first
c
	      plink_rec = vm_rec.last
	      do k=recnr,vm_rec.nlines-1
	        plink_rec = link_rec.backward
	      end do
	    else
c
c skip from current
c
	      plink_rec = vm_rec.current
	      do k=vm_rec.current_line,recnr-1
	        plink_rec = link_rec.forward
	      end do	  
	    end if
	    vm_rec.current = plink_rec
	  else
c
c Already at correct line
c
	  end if
	  vm_rec.current_line = recnr
	  vm__setrec = 1
	end if
	return
	end
	function vm_sort(id,pos,size,flag)
c
	implicit none
c
	integer*4 id
	integer*4 pos           !:i: sort pos (1=begin of record)
	integer*4 size          !:i: sort size
	integer*4 flag		!:i: (OPT) sort flags
	integer*4 vm_sort
c
	integer sor_flag
c
	if(id .eq. 0) then
	  vm_sort = 2
	else
	  sor_flag = 0
	  if(iargcount() .gt. 3) then
	    if(%loc(flag) .ne. 0) sor_flag = flag
	  endif
	  call vm__sort(%val(id),pos,size,sor_flag)
	  vm_sort = 1
	end if
	return
	end
	subroutine vm__sort(vm_rec,pos,size,flag)
c
	implicit none
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
c
	integer*4 pos
	integer*4 size
	integer*4 flag
c
	record /link_record/ link_rec
	pointer (plink_rec,link_rec)
c
	integer*4 k,l		!cur,nxt
	logical*4 vm__rec_bigger
c
c A simple bubble sort routine
c
	if(vm_rec.nlines .gt. 1) then
	  do k=1,vm_rec.nlines
	    plink_rec = vm_rec.first
	    do l=1,vm_rec.nlines-k
	      if(vm__rec_bigger(link_rec,%val(link_rec.forward),
     1              pos,size,flag)) then
c
c Exchange current end next
c
	        call vm__sort_swap(vm_rec,link_rec,%val(link_rec.forward))
	      else
	        plink_rec = link_rec.forward
	      end if
	    end do
	  end do
	end if
	vm_rec.current = vm_rec.first
	vm_rec.current_line = 1
	return
	end
	subroutine vm__sort_swap(vm_rec,cur,curnxt)
	implicit none
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	record /link_record/ cur
	record /link_record/ curnxt
c
	record /link_record/ link_rec
	pointer (p_link_rec,link_rec)
c
	integer*4 prev,next
c
c swap the current and next
c
	prev = cur.backward
	next = curnxt.forward
c
	cur.forward     = curnxt.forward
	curnxt.backward = cur.backward
	cur.backward    = %loc(curnxt)
	curnxt.forward  = %loc(cur)
c
c Now let the previous point to curnxt
c
	if(prev .eq. 0) then
c
c Cur was the top,so now curnxt is the top 
c
	  vm_rec.first = %loc(curnxt)
	else
c
c Cur was not the top, so let prev point to curnxt
c
	  p_link_rec = prev
	  link_rec.forward = %loc(curnxt)
	end if
c
c Now let the next point backward to cur
c
	if(next .eq. 0) then
c
c Curnxt was the last, so now cur is the last
c
	  vm_rec.last = %loc(cur)
	else
c
c Let next record point back to cur
c
	  p_link_rec = next
	  link_rec.backward = %loc(cur)
	end if
	return
	end
	function vm__rec_bigger(cur,nxt,pos,size,flag)
	implicit none
	include 'vm_record.inc'
	record /link_record/ cur
	record /link_record/ nxt
	integer*4 pos           !pos for compare
	integer*4 size		!size for compare
	integer*4 flag 		!flag for sort
	logical*4 vm__rec_bigger
c
	integer*4 nk,k
c
	byte byte1,byte2
c
	nk = pos+size-1
	if(cur.nbyte .lt. nk) nk = cur.nbyte
	if(nxt.nbyte .lt. nk) nk = nxt.nbyte
c
	vm__rec_bigger = .false.
	if(nk .gt. 0) then
  	  do k=pos,nk
	    byte1 = cur.data(k)
	    byte2 = nxt.data(k)
	    if((flag .and. vm_m_sort_nocase) .ne. 0) then
	      if(byte1 .gt. ichar('a') .and. byte1 .le. ichar('z')) 
     1             byte1 = byte1 - ichar('a') + ichar('A')
	      if(byte2 .gt. ichar('a') .and. byte2 .le. ichar('z')) 
     1             byte2 = byte2 - ichar('a') + ichar('A')
	    endif
	    if(byte1 .ne. byte2) goto 90
	  end do
	  k = pos
90	  if((flag .and. vm_m_sort_reverse) .eq. 0) then
	    vm__rec_bigger = byte1 .gt. byte2
	  else
	    vm__rec_bigger = byte1 .lt. byte2
	  endif
	end if
	return
	end
	function vm_delete(id,recnr)
	implicit none
c
	integer*4 id		!:i: The file to rewind
	integer*4 recnr		!:I: (opT) the recordnumber (default current) 
	integer*4 vm_delete	!:f: Function result
c
	volatile recnr
c
	integer*4 vm__delete,vm_setrec
c
	vm_delete = .true.
	if(id .eq. 0) then
	  vm_delete = 2
	else
	  if(iargcount() .gt. 1) then
	    if(%loc(recnr) .ne. 0) then
	      if(recnr .ne. 0) vm_delete = vm_setrec(id,recnr)
	    end if
	  else
	    vm_delete = 1
	  end if
	  if(vm_delete) then
	    vm_delete = vm__delete(%val(id))
	  end if
	endif
	return
	end
	function vm__delete(vm_rec)
	implicit none
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	integer*4 vm__delete
c
	record /link_record/ link_rec
	pointer (plink_rec,link_rec)
c
c	integer*4 vm__get_forward,vm__get_backward,vm___delete
	integer lib$free_vm
c
	integer*4 cur,nb,tmp
c
	if(vm_rec.current .eq. 0) then
	  vm__delete = 2
	else
	  cur = vm_rec.current
c
	  plink_rec = vm_rec.current
	  if(plink_rec .eq. vm_rec.first) then
c
c Delete first record
c
	    vm_rec.first = link_rec.forward
	    if(vm_rec.first .eq. 0) then
	      vm_rec.last = 0
	      vm_rec.current_line = 0
	    else
	      plink_rec = vm_rec.first
	      link_rec.backward  = 0
	    end if
	    vm_rec.current = vm_rec.first
	  elseif(plink_rec .eq. vm_rec.last) then
c
c Delete last record
c
	    vm_rec.last = link_rec.backward
	    plink_rec = vm_rec.last
	    link_rec.forward  = 0
	    vm_rec.current = vm_rec.last
	    vm_rec.current_line = vm_rec.current_line-1
	  else
c
c Delete middle record
c
	    tmp = link_rec.forward		!save forward link
	    plink_rec = link_rec.backward    !get prev record
	    link_rec.forward = tmp              !and let it point to next rec
c
	    tmp = plink_rec			!save adres of prev record
	    plink_rec = link_rec.forward      !point to next
	    link_rec.backward = tmp             !and set backward pointer oke
c
c	    call vm__linkout(%val(cur))
	    vm_rec.current = plink_rec
	  end if
c
c One less line,
c
	  vm_rec.nlines = vm_rec.nlines - 1
c
c really return memory to system
c
	  plink_rec = cur
	  nb = sizeof(link_rec) - sizeof(link_rec.data) + link_rec.size
	  vm__delete = lib$free_vm(nb,plink_rec,vm_rec.zone_id)
c
	end if
	return
	end
	function vm_file_info(id,nrec,currec,recsiz,maxsiz,nbytes)
	implicit none
	integer*4 id		!:i: lun
	integer*4 nrec		!:o: (opt)#records
	integer*4 currec	!:o: (opt) current record
	integer*4 recsiz	!:o: (opt) recordsize
	integer*4 maxsiz	!:o: (opt) max write record size
	integer*4 nbytes	!:o: (opt) total bytes written
	integer*4 vm_file_info	!:f: return 2 if file not open, else 1
c
	include 'vm_record.inc'
	record /vm_record/ vm_rec
	pointer (pvm_rec,vm_rec)
c
	volatile nrec
	volatile currec
	volatile recsiz
	volatile maxsiz
	volatile nbytes
c
	if(id .eq. 0) then
	  vm_file_info = 2
	else
	  pvm_rec = id
	  if(iargcount() .gt. 1) then
	    if(%loc(nrec)   .ne. 0) nrec   = vm_rec.nlines
	  end if
	  if(iargcount() .gt. 2) then
	    if(%loc(currec) .ne. 0) currec = vm_rec.current_line
	  end if
	  if(iargcount() .gt. 3) then
	    if(%loc(recsiz) .ne. 0) recsiz = vm_rec.recsiz
	  end if
	  if(iargcount() .gt. 4) then
	    if(%loc(maxsiz) .ne. 0) maxsiz = vm_rec.max_size
	  end if
	  if(iargcount() .gt. 5) then
	    if(%loc(nbytes) .ne. 0) nbytes = vm_rec.nbytes
	  end if                                           
	  vm_file_info = 1
	end if
	return
	end

	subroutine vm_info(full,lun,id)
	implicit none
	integer*4 lun		!:i: (opt)lun to write to
	integer*4 full		!:i: (opt)see lib$show_vm for detaul_level 0..3
	integer*4 id		!:i: (opt)zone id to print
c
	volatile lun
	volatile full
	volatile id
c
	logical*4 got_lun
c
	integer*4 context,zone,lun1,full1,id1
	integer*4 lib$find_vm_zone
	external vm_info_print
c
	full1 = 1
	if(iargcount() .gt. 0) then
	  if(%loc(full) .ne. 0) full1 = full
	end if
c
	lun1 = 0
	if(iargcount() .gt. 1) then
	  if(%loc(lun) .ne. 0) lun1 = lun
	end if
	got_lun = .true.
	if(lun1 .eq. 0) then
	  got_lun = .false.
	  call lib$get_lun(lun1)
	  open(lun1,file='vm.info',status='new',carriagecontrol='list')
	end if
c
	call lib$show_vm(0,vm_info_print,lun1)
	call lib$show_vm(4,vm_info_print,lun1)
c
	id1 = 0
	if(iargcount() .gt. 2) then
	  if(%loc(id) .ne. 0) id1 = id
	end if
	if(id1 .ne. 0) then
	  write(*,1008) id1
1008	  format(' ######### output for lun ',z8)
	  call lib$show_vm_zone(zone,full1,vm_info_print,lun1)
	else
	  context = 0
	  do while (lib$find_vm_zone(context,zone))
	    write(lun1,1010) zone
1010	    format(' ######## output for zone ',z8)
	    call lib$show_vm_zone(zone,full1,vm_info_print,lun1)
	  end do
	end if
	if(.not. got_lun) then
	  close(lun1)
	  call lib$free_lun(lun1)
	end if
	return
	end
	function vm_info_print(line,lun)
	implicit none
c
	character*(*) line
	integer*4 lun
	integer*4 vm_info_print
c
	write(lun,'(a)') line
	vm_info_print = 1
	return
	end
