/*
//  Copyright 2002 Compaq Information Technologies Group, L.P.
//
//  Compaq and the Compaq logo are trademarks of Compaq Information
//  Technologies Group, L.P. in the U.S. and/or other countries.
//
//  Confidential computer software. Valid license from Compaq
//  required for possession, use or copying. Consistent with
//  FAR 12.211 and 12.212, Commercial Computer Software, Computer
//  Software Documentation, and Technical Data for Commercial
//  Items are licensed to the U.S. Government under vendor's
//  standard commercial license.
*/

/*
**++
**  FACILITY:  CRTL
**
**  MODULE DESCRIPTION:
**
**      search.h -- no `t' -- public declarations for the tsearch
**	routines.  This file should be located in the system library.
**
**  AUTHORS:
**
**      Stephen Hoffman
**
**  CREATION DATE:  12-Jun-1991
**
**  DESIGN ISSUES:
**
**      Sans Issues.
**
**  MODIFICATION HISTORY:
**
**      05-Mar-2002	Hoffman
**	Updates for clean compilation using Compaq C on OpenVMS Alpha.
**--
*/

#ifndef _SEARCH
#define _SEARCH
struct tree_node 
    {
    struct tree_node *t_hi, *t_lo;
    void *t_node;
    };
enum visit
    {
    preorder,
    postorder,
    endorder,
    leaf
    };
extern void *
    tsearch( void *key, void **rootp, int (*compar)() );
extern void *
    tfind( void *key, void **rootp, int (*compar)() );
extern void *
    tdelete( void *key, void **rootp, int (*compar)() );
extern void
    twalk( void *rootp, void (*action)() );

#endif
