/*
//  Copyright 2002 Compaq Information Technologies Group, L.P.
//
//  Compaq and the Compaq logo are trademarks of Compaq Information
//  Technologies Group, L.P. in the U.S. and/or other countries.
//
//  Confidential computer software. Valid license from Compaq
//  required for possession, use or copying. Consistent with
//  FAR 12.211 and 12.212, Commercial Computer Software, Computer
//  Software Documentation, and Technical Data for Commercial
//  Items are licensed to the U.S. Government under vendor's
//  standard commercial license.
*/
#ifndef __TSEARCH_LOADED
#define __TSEARCH_LOADED 1

/*
**++
**  FACILITY:  CRTL
**
**  MODULE DESCRIPTION:
**
**      Internal declarations used by the tsearch code.  (Contains
**	mostly debugging control flags.)  Not needed by callers of
**	the tsearch routines.
**
**  AUTHORS:
**
**      Stephen Hoffman
**
**  CREATION DATE:  12-Jun-1991
**
**  DESIGN ISSUES:
**
**      {@tbs@}
**
**  [@optional module tags@]...
**
**  MODIFICATION HISTORY:
**
**      {@tbs@}...
**--
*/


/*
**  Set TSEARCH_DEBUG to 1 to enable the (verbose) tsearch debug
**  tracing.  Set it to 0 to keep the various subroutines quiet.
**  These flags affect only the tsearch routines.
*/
#define TSEARCH_DEBUG		0   /* turns on all debug logging */
#define TSEARCH_TDELETE		0   /* enables tdelete debugging */
#define TSEARCH_TWALK		0   /* ...twalk() debugging */
#define TSEARCH_TDELETE		0   /* ...tdelete() debugging */
#define TSEARCH_TSEARCH		0   /* ...tsearch() debugging */
#define TSEARCH_TFIND		0   /* ...tfind() debugging */
#define TSEARCH_TWALK_RECUR	0   /* ...twalk_recur() debugging */
#define TSEARCH_TTREE_COMMON	0   /* ... ...common() debugging */



/*
**  Set NODIFF to 1 to display addresses and node hexdumps in addition
**  to the usual dreck displayed by tsearch_test.c.  Set it to 0 to
**  allow a DIFFERENCES on the TSEARCH_TEST output.  DIFFERENCES is
**  used to verify consistency of results between runs and between
**  operating systems.  (NODIFF has no effect on tsearch.c code...)
**  This flag affects only the tsearch_test routines.
*/
#define NODIFF 0

#endif /* __TSEARCH_LOADED */
/* end tsearch.h */
