% Bliss Mode for the jed editor, essentially only syntax coloring
% tested with jed B09917
%
% Version: 0.2
% Update : Jul 2004
% Author : Hartmut Becker at hp.com
%
% hmm, can't get the multi line comments %( \nl )% to work.

create_syntax_table("bliss");
define_syntax("%(", ")%", '%', "bliss");
define_syntax ("([<", ")]>", '(', "bliss") ;
#ifdef HAS_DFA_SYNTAX
%%% DFA_CACHE_BEGIN %%%
static define setup_dfa_callback (name) {
	dfa_enable_highlight_cache("bliss.dfa", name);
	dfa_define_highlight_rule("!.*$", "comment", name);
	dfa_define_highlight_rule("%\\(.*\\)%", "Qcomment", name);
	dfa_define_highlight_rule("[A-Za-z][\\$A-Za-z_0-9]*", "Knormal", name);
	dfa_define_highlight_rule("%[A-Za-z][A-Za-z_0-9]*", "Knormal", name);
	dfa_define_highlight_rule("[0-9]+(\\.[0-9]+)?([Ee][\\+\\-]?[0-9]*)?", "number", name);
	dfa_define_highlight_rule("'[^']*'", "string", name);
% dfa_define_highlight_rule("[ \t]+", "normal", name);
% dfa_define_highlight_rule("[\\(\\[\\]\\),;\\.\\?:]", "delimiter", name);
% dfa_define_highlight_rule("[@\\-\\+/\\*=<>\\^]", "operator", name);
	dfa_build_highlight_table(name);
}
dfa_set_init_callback (&setup_dfa_callback, "bliss");
%%% DFA_CACHE_END %%%
#endif

set_color ("keyword1","blue","default");

variable reskey2_1="%b%c%d%e%g%h%o%p%x" ;
variable reskey3_1="%fi%if" ;
variable reskey4_1="%ref" ;
variable reskey5_1="%char%ctce%else%ltce%name%null%size%then%warn" ;
variable reskey6_1="%ascic%ascid%ascii%asciz%bliss%bpval%count%error%nbits%print%quote%sbttl%title%upval" ;
variable reskey7_1="%assign%bpaddr%bpunit%expand%inform%length%nbitsu%number%remove%sixbit%string" ;
variable reskey8_1="%bliss16%bliss32%bliss36%bliss64%decimal%explode%message%require%unquote%variant" ;
variable reskey9_1="%declared%isstring%rad50_10%rad50_11%switches" ;
variable reskey10_1="%charcount%exitmacro%identical%quotename%remaining" ;
variable reskey11_1="%allocation%errormacro" ;
variable reskey12_1="%exactstring%fieldexpand" ;
variable reskey14_1="%exititeration" ;

variable reskey2="bydoifoforto" ;
variable reskey3="andbitendeqleqvgeqgtrleqlssmapmodneqnotownrefrepsettesxor" ;
variable reskey4="bindbytecasedecrelseeqlaeqlufromgeqagequgtragtruincrleqalequlonglssalssuneqanequplitquadshowthenweakwithword" ;
variable reskey5="aliasalignbegindecradecrufieldincraincrulabelleavelocalmacropsectuntiluplitwhile" ;
variable reskey6="alwayseludomenableglobaliopagemodulepresetrecordreturnselectsigned" ;
variable reskey7="builtinforwardinitialinrangelibrarylinkageliteralnovaluerequireroutineselectaselectu" ;
variable reskey8="exitloopexternaloutrangeregisterswitchesunsignedvolatile" ;
variable reskey9="otherwiseselectonestructureundeclare" ;
variable reskey10="selectoneaselectoneustacklocal" ;
variable reskey11="codecommentcompiletime" ;
variable reskey12="keywordmacro" ;
variable reskey15="addressing_mode" ;

set_color ("keyword2","magenta","default");

variable predef3="absf10maxmin";
variable predef4="maxamaxuminaminusign";
variable predef5="$low$$own$blissblock";
variable predef6="$code$$high$$plit$ch$eqlch$geqch$gtrch$leqch$lssch$neqch$ptrsignalvector";
variable predef7="bliss10ch$copych$diffch$failch$fillch$movech$plusch$sizefortran";
variable predef8="$global$bliss36cch$rcharch$wchar";
variable predef9="bitvectorsetunwind";
variable predef10="ch$a_rcharch$a_wcharch$comparech$find_chch$rchar_ach$wchar_a";
variable predef11="blockvectorch$find_subfortran_subsignal_stop";
variable predef12="ch$translatefortran_func";
variable predef13="ch$allocationch$transtable";
variable predef14="ch$find_not_ch";

() = define_keywords_n ("bliss", reskey2, 2, 0);
() = define_keywords_n ("bliss", reskey3, 3, 0);
() = define_keywords_n ("bliss", reskey4, 4, 0);
() = define_keywords_n ("bliss", reskey5, 5, 0);
() = define_keywords_n ("bliss", reskey6, 6, 0);
() = define_keywords_n ("bliss", reskey7, 7, 0);
() = define_keywords_n ("bliss", reskey8, 8, 0);
() = define_keywords_n ("bliss", reskey9, 9, 0);
() = define_keywords_n ("bliss", reskey10, 10, 0);
() = define_keywords_n ("bliss", reskey11, 11, 0);
() = define_keywords_n ("bliss", reskey12, 12, 0);
() = define_keywords_n ("bliss", reskey15, 15, 0);

() = define_keywords_n ("bliss", reskey2_1, 2, 1);
() = define_keywords_n ("bliss", reskey3_1, 3, 1);
() = define_keywords_n ("bliss", reskey4_1, 4, 1);
() = define_keywords_n ("bliss", reskey5_1, 5, 1);
() = define_keywords_n ("bliss", reskey6_1, 6, 1);
() = define_keywords_n ("bliss", reskey7_1, 7, 1);
() = define_keywords_n ("bliss", reskey8_1, 8, 1);
() = define_keywords_n ("bliss", reskey9_1, 9, 1);
() = define_keywords_n ("bliss", reskey10_1, 10, 1);
() = define_keywords_n ("bliss", reskey11_1, 11, 1);
() = define_keywords_n ("bliss", reskey12_1, 12, 1);
() = define_keywords_n ("bliss", reskey14_1, 14, 1);

() = define_keywords_n ("bliss", predef3, 3, 2);
() = define_keywords_n ("bliss", predef4, 4, 2);
() = define_keywords_n ("bliss", predef5, 5, 2);
() = define_keywords_n ("bliss", predef6, 6, 2);
() = define_keywords_n ("bliss", predef7, 7, 2);
() = define_keywords_n ("bliss", predef8, 8, 2);
() = define_keywords_n ("bliss", predef9, 9, 2);
() = define_keywords_n ("bliss", predef10, 10, 2);
() = define_keywords_n ("bliss", predef11, 11, 2);
() = define_keywords_n ("bliss", predef12, 12, 2);
() = define_keywords_n ("bliss", predef13, 13, 2);
() = define_keywords_n ("bliss", predef14, 14, 2);

!if (keymap_p ("BLISS")) {
    make_keymap ("BLISS");
    definekey ("self_insert_cmd", "^I", "BLISS");
    definekey ("self_insert_cmd", "\"", "BLISS");
    definekey ("self_insert_cmd", "'", "BLISS");
}

define bliss_mode () {
    set_syntax_flags ("bliss",0x81);
    use_syntax_table("bliss");
    use_dfa_syntax(1);
   
    use_keymap ("BLISS");
    set_mode ("bliss", 4);
    run_mode_hooks("bliss_mode_hook");
}
