variable dcl_indent = 4;
variable dcl_continue = 8;

CASE_SEARCH = 0;

define dcl_bol () {
    if (bolp()) {
        newline();
        return 1;
    }
    return 0;
}

define dcl_comment() {
    push_spot();
    bol();
    if (looking_at("$!")) {
        pop_spot();
        newline();
        insert ("$! ");
        return 1;
    }
    pop_spot();
    return 0;
}

% dcl_last_indent should be recursive, but I don't know how to do this in .sl
% so the caller has to call again with greater up_lines
define dcl_last_indent(up_lines) {
    variable lcol;
    push_spot();
    if (up(up_lines)!=up_lines or bolp()) {
        pop_spot();
        return 1;
    }
    eol();
    left(1);
    if (looking_at("-")) {
        right(1);
        % lcol = dcl_last_indent ();
        % return 0 so the caller can call this again
        lcol = 0;
        pop_spot();
        return lcol;
    }
    down_1();
    if (looking_at("$!")) {
        eol();
        % lcol = dcl_last_indent ();
        % return 0 so the caller can call this again
        lcol = 0;
        pop_spot();
        return lcol;
    }
    if (looking_at("$"))
         right(1);
    skip_white();
    lcol = what_column();
    pop_spot();
    return lcol;
}

define dcl_this_indent() {
    variable lcol;
    if (bolp())
        return 1;
    push_spot();
    bol();
    if (looking_at("$!")) {
        pop_spot();
        return 1;
    }
    if (looking_at("$"))
         right(1);
    skip_white();
    lcol = what_column();
    pop_spot();
    return lcol;
}

define dcl_cont() {
    left(1);
    if (looking_at("-")) {
        variable col, ins;
        right(1);
        col = dcl_this_indent();
        if (col<=3)
            col = 1;
        ins = col-1+dcl_continue;
        push_spot();
        if (up_1() and not bolp() and 1==left(1) and looking_at("-"))
            ins = col-1;
        pop_spot();
        newline();
        insert_spaces(ins);
        return 1;
    }
    right(1);
    return 0;
}

define dcl_then() {
    push_spot();
    bol();
    if (looking_at("$")) {
        right(1);
        skip_white();
        if (looking_at("then")
            and 4==right(4)
            and (eolp() or what_char=='\t' or what_char==' ' or what_char=='!')) {
            variable col;
            col = dcl_this_indent();
            pop_spot();
            newline();
            insert ("$ ");
            insert_spaces (col-3+dcl_indent);
            return 1;
        }
    }
    pop_spot();
    return 0;
}

define dcl_else() {
    push_spot();
    bol();
    if (looking_at("$")) {
        right(1);
        skip_white();
        if (looking_at("else")
            and 4==right(4)
            and (eolp() or what_char=='\t' or what_char==' ' or what_char=='!')) {
            variable col, i, k;
            col = dcl_this_indent();
            i = 1;
            k = dcl_last_indent(i);
            while (k==0 or k>=col) {
                ++i;
                k = dcl_last_indent(i);
            }
            bol();
            right(2);
            while (col-k>0) {
                !if (what_char()==' ')
                    break;
                del();
                ++k;
            }
            pop_spot();
            newline();
            insert ("$ ");
            insert_spaces (col-3);
            return 1;
        }
    }
    pop_spot();
    return 0;
}

define dcl_endif() {
    push_spot();
    bol();
    if (looking_at("$")) {
        right(1);
        skip_white();
        if (looking_at("endif")
            and 5==right(5)
            and (eolp() or what_char=='\t' or what_char==' ' or what_char=='!')) {
            variable col, i, m;
            m = dcl_this_indent();
            i = 1;
            col = dcl_last_indent(i);
            while (col==0 or m<=col) {
                ++i;
                col = dcl_last_indent(i);
            }
            bol();
            right(2);
            while (m-col>0) {
                !if (what_char()==' ')
                    break;
                del();
                --m;
            }
            pop_spot();
            newline();
            insert ("$ ");
            insert_spaces (col-3);
            return 1;
        }
    }
    pop_spot();
    return 0;
}

define dcl_normal () {
    variable col, i;
    col = dcl_this_indent();
    push_spot();
    i = 1;
    if (up_1() and not bolp() and 1==left(1) and looking_at("-")) {
        down_1();
        col = dcl_last_indent(i);
        while (col==0) {
                ++i;
            col=dcl_last_indent(i);
        }
    }
    pop_spot();
    newline();
    insert("$ ");
    insert_spaces(col-3);
}

define dcl_newline () {
    trim();
    % at the begin of line just insert a new line
        if (dcl_bol())
        return;
    % continue a full line comment ($!...)
    if (dcl_comment())
        return;
    if (dcl_cont())
        return;
    % increase the indentation ($ then...)
    if (dcl_then())
        return;
    % keep the indentation ($ else...)
    % because there is no end for then, else will be adjusted to the left
    if (dcl_else())
        return;
    % decrease the indentation ($ endif...)
    % because there is no end for then/else endif will be adjusted to the left
    if (dcl_endif())
        return;
    dcl_normal();
}

% dcl mode--  Special mode to facilitate editing of DCL files on VMS systems.
%

create_syntax_table("dcl");

#ifdef HAS_DFA_SYNTAX
%%% DFA_CACHE_BEGIN %%%
static define setup_dfa_callback (name) {
    dfa_enable_highlight_cache("dcl.dfa", name);
    dfa_define_highlight_rule("!.*$", "comment", name);
    dfa_define_highlight_rule("\"[^\"]*\"", "string", name);
    dfa_define_highlight_rule("/[a-zA-Z][_a-zA-Z0-9\\-]*", "keyword2", name);
    dfa_define_highlight_rule("\\.([gG]|[lL]|[nN])[eE][sS]?\\.", "preprocess", name);
    dfa_define_highlight_rule("\\.([gG]|[lL])[tT][sS]?\\.", "preprocess", name);
    dfa_define_highlight_rule("\\.[eE][qQ][sS]?\\.", "preprocess", name);
    dfa_define_highlight_rule("\\.[nN][oO][tT]\\.", "preprocess", name);
    dfa_define_highlight_rule("\\.[aA][nN][tT]\\.", "preprocess", name);
    dfa_define_highlight_rule("\\.[oO][rR]\\.", "preprocess", name);
    dfa_define_highlight_rule("[a-zA-Z][\\$a-zA-Z0-9_\\-]*", "Knormal", name);
    dfa_define_highlight_rule("@", "keyword", name);
    dfa_define_highlight_rule("[0-9]+", "number", name);
    dfa_build_highlight_table(name);
}
dfa_set_init_callback (&setup_dfa_callback, "dcl");
%%% DFA_CACHE_END %%%
#endif

set_color ("keyword2","blue","default");

() = define_keywords_n ("dcl", "ifon", 2, 0);
() = define_keywords_n ("dcl", "eodmcrrunset", 3, 0);
() = define_keywords_n ("dcl", "callelseexitgotoopenreadshowthenwait", 4, 0);
() = define_keywords_n ("dcl", "closeendifgosubspawnwrite", 5, 0);
() = define_keywords_n ("dcl", "assigndefinereturn", 6, 0);
() = define_keywords_n ("dcl", "deassign", 8, 0);
() = define_keywords_n ("dcl", "subroutine", 10, 0);
() = define_keywords_n ("dcl", "endsubroutine", 13, 0);

() = define_keywords_n ("dcl", "f$faof$pid", 5, 1);
() = define_keywords_n ("dcl", "f$csidf$cvsif$cvuif$editf$filef$modef$timef$typef$user", 6, 1);
() = define_keywords_n ("dcl", "f$parse", 7, 1);
() = define_keywords_n ("dcl", "f$cvtimef$devicef$getdvif$getenvf$getjpif$getquif$getsyif$lengthf$locatef$searchf$setprvf$stringf$trnlnmf$verify", 8, 1);
() = define_keywords_n ("dcl", "f$contextf$elementf$extractf$integerf$messagef$process", 9, 1);
() = define_keywords_n ("dcl", "f$directoryf$privilege", 11, 1);
() = define_keywords_n ("dcl", "f$identifier", 12, 1);
() = define_keywords_n ("dcl", "f$environment", 13, 1);
() = define_keywords_n ("dcl", "f$file_attributes", 17, 1);

!if (keymap_p ("DCL")) {
    make_keymap ("DCL");
    definekey ("dcl_newline", "^M", "DCL");
    definekey ("self_insert_cmd", "^I", "DCL");
    definekey ("self_insert_cmd", "\"", "DCL");
    definekey ("self_insert_cmd", "'", "DCL");
}

define dcl_mode () {
    set_syntax_flags ("dcl",0x81);
    use_syntax_table("dcl");
    use_dfa_syntax(1);
   
    use_keymap ("DCL");
    set_mode ("dcl", 4);
    run_mode_hooks("dcl_mode_hook");
}
